//
// C++ Implementation: generatormap
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "generatormap.h"
#include "textgenerator.h"
#include "mainoutputbuffer.h"

using namespace std;

GeneratorMap::GeneratorMap() :
  default_generator (new TextGenerator)
{
}

GeneratorMap::~GeneratorMap()
{
  for (MapType::const_iterator it = generatormap.begin(); it != generatormap.end(); ++it)
    delete it->second;
  delete default_generator;
}

void
GeneratorMap::setDefaultGenerator(TextGenerator *gen)
{
    if (default_generator)
        delete default_generator;
    default_generator = gen;
}

void
GeneratorMap::addGenerator(const std::string &elem, TextGenerator *gen)
{
  generatormap[elem] = gen;
}

TextGenerator *
GeneratorMap::getGenerator(const string &elem)
{
  MapType::const_iterator it = generatormap.find(elem);
  if (it == generatormap.end())
    {
      // create a copy of the prototype and substitute the style.  
      TextGenerator *missing = new TextGenerator(*default_generator);
      missing->subst_style(elem);

      generatormap[elem] = missing;
      return missing;
    }

  return it->second;
}

void
GeneratorMap::generateEntire( const std::string &elem, const std::string &s )
{
  outputbuffer->output(getGenerator(elem)->generateEntire(s.c_str()));
}

void
GeneratorMap::generateNL( const std::string &s )
{
  outputbuffer->output_ln(s);
}
