/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import type { AbsoluteTime } from "@gnu-taler/taler-util";
import type { FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "../context/ui-forms.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) => ({
  design: [
    {
      title: i18n.str`Foundations`,
      fields: [
        {
          type: "textArea",
          properties: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "text",
          properties: {
            name: "knownAs",
            label:
              i18n.str`The undersigned hereby declare(s) that as board member of the foundation, or of the highest supervisory body of an underlying company of a foundation, known as`,
          },
        },
        {
          type: "text",
          properties: {
            name: "foundation.name",
            label:
              i18n.str`Name and information pertaining to the foundation`,
          },
        },
        {
          type: "choiceStacked",
          properties: {
            name: "foundation.type",
            label: i18n.str`Type of foundation`,
            choices: [
              {
                label: i18n.str`Discretionary foundation`,
                value: "discretionary",
              },
              {
                label: i18n.str`Non-discretionary foundation`,
                value: "non-discretionary",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          properties: {
            name: "foundation.revocability",
            label: i18n.str`Revocability`,
            choices: [
              {
                label: i18n.str`Revocable foundation`,
                value: "revocable",
              },
              {
                label: i18n.str`Irrevocable foundation`,
                value: "irrevocable",
              },
            ],
          },
        },
        {
          type: "array",
          properties: {
            label:
              i18n.str`Information pertaining to the (ultimate economic, not fiduciary) founder (individual(s) or entity/ies)`,
            labelField: "fullName",
            name: "founders",
            fields: [
              {
                type: "text",
                properties: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  help: i18n.str`if deceased`,
                },
              },
              {
                type: "choiceStacked",
                properties: {
                  name: "rightToRevoke",
                  required: true,
                  label:
                    i18n.str`Does the founder have the right to revoke the foundation?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          properties: {
            label:
              i18n.str`If the foundation results from the restructuring of pre-existing foundation (re-settlement) or the merger of pre-existing foundations, the following information pertaining to the (actual) founder(s) of the pre-existing foundation(s) has to be given`,
            labelField: "fullName",
            name: "preExistingFounders",
            fields: [
              {
                type: "text",
                properties: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  help: i18n.str`if deceased`,
                },
              },
            ],
          },
        },
        {
          type: "array",
          properties: {
            label:
              i18n.str`Pertaining to the beneficiary/-ies at the time of the signing of this form`,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                properties: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "choiceStacked",
                properties: {
                  name: "rightToClaim",
                  label:
                    i18n.str`Has the beneficiary an actual right to claim distribution?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                properties: {
                  label:
                    i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form`,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "array",
          properties: {
            label:
              i18n.str`Information pertaining to further persons having the right to determine or nominate representatives (e.g.) members of the foundation board), if these representatives may dispose over the assets or have the right to change the distribution of the assets or the nomination of beneficiaries`,
            labelField: "fullName",
            name: "withRightToNominate",
            fields: [
              {
                type: "text",
                properties: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "choiceStacked",
                properties: {
                  name: "rightToClaim",
                  label:
                    i18n.str`has the person the right to revoke the foundation?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                properties: {
                  label:
                    i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form`,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "text",
          properties: {
            name: "signature",
            label: i18n.str`Signature`,
          },
        },
      ],
    },
    resolutionSection(i18n),
  ],
  // behavior: function formBehavior(
  //   v: Partial<Form902_12.Form>,
  // ): FormState<Form902_12.Form> {
  //   return {
  //     founders: {
  //       elements: (v.founders ?? []).map(() => {
  //         return {
  //           rightToRevoke: {
  //             hidden: v.foundation?.revocability !== "revocable",
  //           },
  //         };
  //       }),
  //     },
  //     withRightToNominate: {
  //       elements: (v.withRightToNominate ?? []).map(() => {
  //         return {
  //           rightToRevoke: {
  //             hidden: v.foundation?.revocability !== "revocable",
  //           },
  //         };
  //       }),
  //     },
  //   };
  // },
});

namespace Form902_12 {
  interface Foundation {
    name: string;
    type: "discretionary" | "non-discretionary";
    revocability: "revocable" | "irrevocable";
  }
  interface Person {
    fullName: string;
    address: string;
    country: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }
  type WithRevoke<T> = {
    rightToRevoke: "yes" | "no";
  } & T;
  type WithClaim<T> = {
    rightToClaim: "yes" | "no";
  } & T;
  type WithDeath<T> = {
    dateOfDeath: AbsoluteTime;
  } & T;

  type Founder = WithRevoke<WithDeath<Person>>;
  type Beneficiary = WithClaim<Person>;

  export interface Form extends BaseForm {
    contractingPartner: string;
    knownAs: string;
    boardMember: string;
    foundation: Foundation;
    founders: Array<Founder>;
    preExistingFounders: Array<Founder>;
    beneficiaryWhenSigning: Array<Beneficiary>;
    beneficiaryExtra: Array<Beneficiary>;
    withRightToNominate: Array<WithRevoke<Person>>;
  }
}
