webpackJsonp([10],{

/***/ 157:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2015-2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Page shown to the user to confirm creation
 * of a reserve, usually requested by the bank.
 *
 * @author Florian Dold
 */
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
const URI = __webpack_require__(6);
const wxApi = __webpack_require__(2);
const renderHtml_1 = __webpack_require__(5);
class ErrorView extends React.Component {
    render() {
        const report = this.props.report;
        if (!report) {
            return (React.createElement("div", { id: "main" },
                React.createElement("h1", null, "Error Report Not Found"),
                React.createElement("p", null, "This page is supposed to display an error reported by the GNU Taler wallet, but the corresponding error report can't be found."),
                React.createElement("p", null, "Maybe the error occured before the browser was restarted or the wallet was reloaded.")));
        }
        try {
            switch (report.name) {
                case "pay-post-failed": {
                    const summary = report.contractTerms.summary || report.contractTerms.order_id;
                    return (React.createElement("div", { id: "main" },
                        React.createElement("h1", null, "Failed to send payment"),
                        React.createElement("p", null,
                            "Failed to send payment for ",
                            React.createElement("strong", null, summary),
                            " ",
                            "to merchant ",
                            React.createElement("strong", null, report.contractTerms.merchant.name),
                            "."),
                        React.createElement("p", null,
                            "You can ",
                            React.createElement("a", { href: report.contractTerms.fulfillment_url }, "retry"),
                            " the payment.",
                            " ",
                            "If this problem persists, please contact the mechant with the error details below."),
                        React.createElement(renderHtml_1.Collapsible, { initiallyCollapsed: true, title: "Error Details" },
                            React.createElement("pre", null, JSON.stringify(report, null, " ")))));
                }
                default:
                    return (React.createElement("div", { id: "main" },
                        React.createElement("h1", null, "Unknown Error"),
                        "The GNU Taler wallet reported an unknown error.  Here are the details:",
                        React.createElement("pre", null, JSON.stringify(report, null, " "))));
            }
        }
        catch (e) {
            return (React.createElement("div", { id: "main" },
                React.createElement("h1", null, "Error"),
                "The GNU Taler wallet reported an error.  Here are the details:",
                React.createElement("pre", null, JSON.stringify(report, null, " ")),
                "A detailed error report could not be generated:",
                React.createElement("pre", null, e.toString())));
        }
    }
}
function main() {
    return __awaiter(this, void 0, void 0, function* () {
        const url = new URI(document.location.href);
        const query = URI.parseQuery(url.query());
        const container = document.getElementById("container");
        if (!container) {
            console.error("fatal: can't mount component, countainer missing");
            return;
        }
        // report that we'll render, either looked up from the
        // logging module or synthesized here for fixed/fatal errors
        let report;
        const reportUid = query.reportUid;
        if (!reportUid) {
            report = {
                name: "missing-error",
            };
        }
        else {
            report = yield wxApi.getReport(reportUid);
        }
        ReactDOM.render(React.createElement(ErrorView, { report: report }), container);
    });
}
document.addEventListener("DOMContentLoaded", () => main());


/***/ })

},[157]);
//# sourceMappingURL=error-bundle.js.map