
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#define PERLGTKEXT_Define
#include "PerlGtkExt.h"

#include "PerlGnomeInt.h"
#include "GnomeDefs.h"

#ifndef boolSV
# define boolSV(b) ((b) ? &sv_yes : &sv_no)
#endif

extern int did_we_init_gdk, did_we_init_gtk;
int did_we_init_gnome = 0;

static void     callXS (void (*subaddr)(CV* cv), CV *cv, SV **mark) 
{
    int items;
  dSP;
   PUSHMARK (mark);
   (*subaddr)(cv);
                
    PUTBACK;  /* Forget the return values */
}

void GnomeInit_internal(char * app_id)
{
		if (!did_we_init_gdk && !did_we_init_gtk && !did_we_init_gnome) {
			struct argp parser = { };
			int argc;
			char ** argv = 0;
			AV * ARGV = perl_get_av("ARGV", FALSE);
			SV * ARGV0 = perl_get_sv("0", FALSE);
			int i;

			argc = av_len(ARGV)+2;
			if (argc) {
				argv = malloc(sizeof(char*)*argc);
				argv[0] = SvPV(ARGV0, na);
				for(i=0;i<=av_len(ARGV);i++)
					argv[i+1] = SvPV(*av_fetch(ARGV, i, 0), na);
			}

			i = argc;
			gnome_init(app_id, NULL /*&parser*/, argc, argv, 0, &i);

			did_we_init_gdk = 1;
			did_we_init_gtk = 1;
			did_we_init_gnome = 1;

			while (i--)
				av_shift(ARGV);

			if (argv)
				free(argv);
				
			GtkInit_internal();

			Gnome_InstallTypedefs();

			Gnome_InstallObjects();

			printf("Init gnome\n");
		}
}


MODULE = Gnome		PACKAGE = Gnome		PREFIX = gnome_

void
init(Class, app_id)
	SV *    Class
	char *  app_id
	CODE:
	{
		GnomeInit_internal(app_id);
	}

INCLUDE: boxed.xsh

INCLUDE: objects.xsh

INCLUDE: extension.xsh

BOOT:
{
	extern void PerlGnomeExtSetupFixups(void);
	PerlGtkExtFixup();
	PerlGnomeExtSetupFixups();
}
