#!/usr/bin/perl

use Gtk;

# Find out what tests are available, and get their names

@files = <gnome-tests/*>;

foreach $file (@files) {
	open(F, "<$file");
	next if $file =~ /~$/;
	foreach (<F>) {
            if (/\$(([\w\:\']*)\bNAME)\b.*\=/) {
            	push @tests, {file => $file, name => eval("$_;\n\$$1;")};
            }
	}
	close(F);
}


# Initialize Gtk, and construct interface

init Gtk;

my($hbox) = new Gtk::HPaned;
show $hbox;

my($scroller) = new Gtk::ScrolledWindow(undef, undef);
$scroller->set_policy(-automatic, -automatic);
$scroller->border_width(5);

show $scroller;

$list = new Gtk::List;

$list->set_selection_mode(-browse);
show $list;


$scroller->add($list);
$scroller->set_usize(100, 100);

my ($vbox) = new Gtk::VBox 0, 5;
$vbox->border_width(5);
show $vbox;

$title = new Gtk::Label "";
show $title;

my($contents_hbox) = new Gtk::HBox 0, 0;
show $contents_hbox;

$contents = new Gtk::Text undef, undef;
show $contents;

$contents_hbox->pack_start($contents, 1, 1, 0);

my($contents_vscroll) = new Gtk::VScrollbar($contents->vadj);
$contents_vscroll->show;

$contents_hbox->pack_start($contents_vscroll, 0, 0, 0);

my($bbox) = new Gtk::HButtonBox;
$bbox->border_width(5);
$bbox->set_spacing(15);
$bbox->set_layout(-end);

show $bbox;

$run = new Gtk::Button "Run";
show $run;

$stop = new Gtk::Button "Stop";
show $stop;

$bbox->add($run);
$bbox->add($stop);

$vbox->pack_start($title, 0, 0, 0);
$vbox->pack_start($contents_hbox, 1, 1, 0);
$vbox->pack_start($bbox, 0, 0, 0);

$hbox->add1($scroller);
$hbox->add2($vbox);
#$hbox->pack_start($scroller, 0, 1, 0);
#$hbox->pack_start($vbox, 1, 1, 0);

$window = new Gtk::Window -toplevel;
$window->border_width(5);
$window->set_title("Gnome/Perl tests");
$window->add($hbox);

$window->set_usize(500,300);



# Set up interaction


sub load_file {
	my($item) = @_;
	
	$title->set($item->{name} . " - " . $item->{file});
	my($text);
	
	open(F, "<$item->{file}");
	$/ = undef;
	$text = <F>;
	close(F);
	
	$contents->freeze;
	$contents->delete_text(0, $contents->get_length);
	$contents->insert_text($text, 0);
	$contents->thaw;
	
	$stop->set_sensitive(@{$item->{running}} > 0);
}

@reaped = ();
$SIG{CHLD} = sub { push @reaped, wait; };

sub start_file {
	my($item) = @_;
	
	my($pid);
	
    unless ($pid = fork) {
   		exec "perl ".join(' ', map ("-I $_", @INC))." ".$item->{file};
        print "no exec";
		kill "KILL", $$;
    }
    
    print "Launching $item->{file}, as task $pid\n";
	
	push @{$item->{running}}, $pid;
	
	$stop->set_sensitive(1);
}

sub stop_file {
	my($item) = @_;
	
	my($task) = pop @{$item->{running}};
	
	print "Stopping $item->{file}, task $task\n";
	
	kill "TERM", $task;
	
	# Let idler catch dead child
}

sub idler {

	while (@reaped > 0) {
		my($reap) = pop @reaped;
		
		foreach $test (@tests) {
			@{$test->{running}} = grep {$_ != $reap} @{$test->{running}};
			
			if ($list->selection->{file} == $test) {
				$stop->set_sensitive(@{$test->{running}} > 0);
			}
		}
	}
	
	1;
}

Gtk->idle_add(\&idler);

$list->signal_connect(button_press_event => sub {
	if ($_[1]->{type} eq "2button_press") {
		start_file($list->selection->{file});
	}
});
$list->signal_connect(select_child => sub { load_file($_[1]->{file}); });
$run->signal_connect(clicked => sub { start_file($list->selection->{file}); });
$stop->signal_connect(clicked => sub { stop_file($list->selection->{file}); });


$window->signal_connect(destroy => sub { exit } );

# Load tests into list

foreach (@tests) {
	my($item) = new Gtk::ListItem $_->{name};
	$item->{file} = $_;
	show $item;
	$list->append_items($item);
}


# On with the show...

show $window;

main Gtk;
