/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEGARG_H__
#define __GLEGARG_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- type macros --- */
#define	GLE_GARG_CLASS_TYPE(garg)	(((GleGArg*)(garg))->info->class_type)
#define	GLE_GARG_ARG_TYPE(garg)		(((GleGArg*)(garg))->info->arg->type)
#define	GLE_GARG_IS_READABLE(garg)	(((GleGArg*)(garg))->info->arg_flags & GTK_ARG_READABLE)
#define	GLE_GARG_IS_WRITABLE(garg)	(((GleGArg*)(garg))->info->arg_flags & GTK_ARG_WRITABLE)
#define	GLE_GARG_IS_READWRITE(garg)	(GLE_GARG_IS_READABLE (garg) && GLE_GARG_IS_WRITABLE (garg))
#define	GLE_GARG_IS_CONSTRUCT(garg)	(((GleGArg*)(garg))->info->arg_flags & GTK_ARG_CONSTRUCT)
#define	GLE_GARG_SETTING_FAILED(garg)	(((GleGArg*)(garg))->setting_failed)
#define	GLE_GARG_NEEDS_SET(garg)	(((GleGArg*)(garg))->needs_set)


/* --- typedefs --- */
typedef	struct _GleGArg		GleGArg;
typedef	struct _GleArgInfo	GleArgInfo;

struct _GleGArg
{
  const gchar		*arg_name;
  const GleArgInfo	*info;
  guint			 setting_failed : 1;
  guint			 needs_set : 1;
  GtkWidget		*widget;
  GtkArg		 saved_arg;
  GtkArg		 object_arg;
};
struct	_GleArgInfo
{
  GtkType	class_type;
  guint		arg_flags;
  guint 	seq_num;
  const GtkArg	*arg;
};


/* --- GleGArg prototypes --- */
GleGArg*	gle_garg_new		(const GleArgInfo	*info);
void		gle_garg_reset		(GleGArg		*garg);
void		gle_garg_save		(GleGArg		*garg);
void		gle_garg_restore	(GleGArg		*garg);
void		gle_garg_free		(GleGArg		*garg);
void		gle_garg_init		(GleGArg		*garg,
					 GtkObject		*object);
void		gle_garg_get		(GleGArg		*garg,
					 GtkObject		*object);
void		gle_garg_set		(GleGArg		*garg,
					 GtkObject		*object);


/* --- GtkArg prototypes --- */
void			gle_arg_copy_value	(const GtkArg	*src_arg,
						 GtkArg		*dest_arg);
void			gle_arg_reset		(GtkArg		*arg);
const GleArgInfo*	gle_arg_get_info	(const gchar	*arg_name);
void			gle_arg_set_from_string (GtkArg		*arg,
						 const gchar	*value_string);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEGARG_H__ */
