/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEGOBJECT_H__
#define __GLEGOBJECT_H__


#include	"glepublic.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- type macros --- */
#define	GLE_GOBJECT(go)		 ((GleGObject*)(go))
#define	GLE_IS_GOBJECT(go)	 (gtk_type_is_a(GLE_GOBJECT(go)->type,GTK_TYPE_OBJECT))


/* --- GleGObject flags --- */
enum
{
  GLE_GENERIC_GLE_NAME	= 1 <<  0
};


/* --- GLE macros --- */
#define	GLE_OBJECT_HAS_GOBJECT(object)	 (gle_object_get_gobject(GTK_OBJECT(object))!=NULL)
#define	GLE_OBJECT_HAS_GLE_NAME(object)	 (gle_object_get_glename(GTK_OBJECT(object))!=NULL)
#define	GLE_GOBJECT_IS_INSTANTIATED(go)	 (GLE_GOBJECT(go)->object!=NULL)
#define	GLE_GOBJECT_HAS_EDITOR(go)	 (GLE_GOBJECT(go)->editor!=NULL)
#define	GLE_GOBJECT_FLAGS(go)		 (GLE_GOBJECT(go)->flags)
#define	GLE_GOBJECT_SET_FLAG(go,f)	 G_STMT_START{(GLE_GOBJECT_FLAGS(go)|=(f));}G_STMT_END
#define	GLE_GOBJECT_UNSET_FLAG(go,f)	 G_STMT_START{(GLE_GOBJECT_FLAGS(go)&=~(f));}G_STMT_END
#define	GLE_GOBJECT_GENERIC_GLE_NAME(go) (GLE_GOBJECT_FLAGS(go) & GLE_GENERIC_GLE_NAME)


/* --- typedefs --- */
typedef struct	_GleGObject	GleGObject;


/* --- structures --- */
struct _GleGObject
{
  GtkType	type;

  guint32	flags;

  const gchar	*gle_name;

  GtkObject	*object;

  GList		*gargs		/* of type GleGArg* */;
  GList		*object_gargs	/* of type GleGArg* */;

  GList		*connections	/* of type GleGHandler* */;

  GtkWidget	*editor;
};


/* --- GleGObject prototypes --- */
GleGObject*	gle_gobject_new			(GtkType	 type,
						 const gchar	*gle_name,
						 gboolean	 generic_name);
GleGObject*	gle_gobject_lookup		(const gchar	*gle_name);
void		gle_gobject_associate		(GleGObject	*gobject,
						 GtkObject	*object);
GtkObject*	gle_gobject_instantiate		(GleGObject	*gobject);
void		gle_gobject_disassociate	(GleGObject	*gobject);
void		gle_gobject_connect		(GleGObject	*gobject);
void		gle_gobject_disconnect		(GleGObject	*gobject);
void		gle_gobject_apply_args		(GleGObject	*gobject);
void		gle_gobject_update_args		(GleGObject	*gobject);
void		gle_gobject_set_gle_name	(GleGObject	*gobject,
						 const gchar	*gle_name);
void		gle_gobject_register_editor	(GleGObject	*gobject,
						 GtkWidget	*editor);



/* --- GtkObject prototypes --- */
GleGObject*	gle_object_get_gobject		(GtkObject	*object);
GleGObject*	gle_object_force_gobject	(GtkObject	*object);
const gchar*	gle_object_get_gle_name		(GtkObject	*object);
gchar*		gle_object_create_gle_name	(GtkObject	*object);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEGOBJECT_H__ */
