/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glemem.h"



/* --- defines --- */
#undef	_GLE_CHUNK_DECL
#define _GLE_CHUNK_DECL(t)      GMemChunk*_GLE_CHUNK_BLOCK(t)=NULL
#define	_GLE_CHUNK_INIT(t,p,a)	_GLE_CHUNK_BLOCK(t)=g_mem_chunk_new("GLE Mem Chunks - " #t,sizeof(t),sizeof(t)*(p),(a))
#define	_GLE_CHUNK_DESTROY(t)	g_mem_chunk_destroy(_GLE_CHUNK_BLOCK(t));_GLE_CHUNK_BLOCK(t)=NULL


/* --- declarations --- */
_GLE_CHUNK_DECL (GleGArg);
_GLE_CHUNK_DECL (GleArgInfo);
_GLE_CHUNK_DECL (GleGObject);
_GLE_CHUNK_DECL (GleGWidget);


/* --- functions --- */
void
_gle_mem_chunks_init (void)
{
  _GLE_CHUNK_INIT (GleGArg,	GLE_GARGS_PREALLOC,	G_ALLOC_AND_FREE);
  _GLE_CHUNK_INIT (GleArgInfo,	64,			G_ALLOC_ONLY);
  _GLE_CHUNK_INIT (GleGObject,	GLE_GOBJECTS_PREALLOC,	G_ALLOC_AND_FREE);
  _GLE_CHUNK_INIT (GleGWidget,	GLE_GWIDGETS_PREALLOC,	G_ALLOC_AND_FREE);
}

void
_gle_mem_chunks_destroy (void)
{
  _GLE_CHUNK_DESTROY (GleGArg);
  /* _GLE_CHUNK_DESTROY (GleArgInfo); */
  _GLE_CHUNK_DESTROY (GleGObject);
  _GLE_CHUNK_DESTROY (GleGWidget);
}
