/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLEPRIVATE_H__
#define __GLEPRIVATE_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- macros --- */
/* macros that are used to tag gtkobjects as internal GLE objects.
 * this mechanism is lekly to change...
 */
#define GLE_TAG(object)			G_STMT_START{if(!GLE_HAS_TAG(object)){GLE_WEAK_TAG(object);gle_root_connect_object_life(GTK_OBJECT(object));}}G_STMT_END
#define GLE_WEAK_TAG(object)		G_STMT_START{gtk_object_set_data(GTK_OBJECT(object),gle_key_gle_tag,(gpointer)42);}G_STMT_END
#define	GLE_HAS_TAG(object)		(gtk_object_get_data(GTK_OBJECT(object),gle_key_gle_tag)==(gpointer)42)


/* --- keys --- */
extern const gchar	*gle_key_gle_tag;
extern const gchar	*gle_key_shell;


/* --- prototypes --- */
GtkObject*	gle_root_object			(void);
void		gle_root_shutdown		(void);
void		gle_root_connect_object_life	(GtkObject	*object);
GtkWidget*	gle_root_get_shell		(void);

gchar*          gle_object_create_glename       (GtkObject      *object);

     




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLEPRIVATE_H__ */
