/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"glepublic.h"
#include	"gleprivate.h"
#include	"glegobject.h"
#include	"glegwidget.h"
#include	"gleeditor.h"
#include	"gleshell.h"



/* --- functions --- */
GtkWidget*
gle_popup_gle_shell (void)
{
  GleShell *shell;

  shell = gle_shell_get ();

  if (!GTK_WIDGET_VISIBLE (shell))
    gtk_widget_show (GTK_WIDGET (shell));

  gdk_window_raise (GTK_WIDGET (shell)->window);

  return GTK_WIDGET (shell);
}

GtkWidget*
gle_popup_gle_shell_customer (GtkWidget      *customer)
{
  GleShell *shell;

  if (customer)
    g_return_val_if_fail (GTK_IS_WIDGET (customer), NULL);

  shell = gle_shell_get ();
  gle_shell_set_customer (shell, customer);

  return gle_popup_gle_shell ();
}

GtkWidget*
gle_popup_gle_shell_selector (void)
{
  GleShell *shell;

  shell = gle_shell_get ();
  gle_shell_popup_selector (GLE_SHELL (shell));

  return GTK_WIDGET (shell);
}

GtkWidget*
gle_popup_widget_editor (GtkWidget      *widget)
{
  GleGObject *gobject;

  g_return_val_if_fail (widget != NULL, NULL);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), NULL);
  g_return_val_if_fail (!GLE_HAS_TAG (widget), NULL);

  gobject = GLE_GOBJECT (gle_widget_force_gwidget (widget));

  if (GLE_GOBJECT_HAS_EDITOR (gobject))
    gdk_window_raise (gobject->editor->window);
  else
    {
      GtkWidget *editor;

      editor = gle_editor_new (gobject);
      GLE_TAG (editor);
      gtk_widget_show (editor);
    }

  return gobject->editor;
}

void
gle_build_plain_window (const gchar    *gle_name)
{
  GleGObject* gobj;

  gobj = gle_gobject_new (gtk_window_get_type (), gle_name, FALSE);
  gle_gobject_instantiate (gobj);
  gtk_widget_show (GTK_WIDGET (gobj->object));
}

