/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: windows.c,v 1.3 1997/05/03 05:52:57 tim Exp $")


#define		__windows_c__

#include	"windows.h"
#include	"widgets.h"
#include	"config.h"
#include	"defines.h"
#include	<stdio.h>
#include	<stdarg.h>



/* --- defines --- */


/* macro to create message
*/
#define	Box_add_message(Box,message_fmt,varargs)	{		\
	register GtkWidget	*label;					\
	register gchar		*char_p, *end, *del, *message;		\
	message=del=g_new(gchar, DFL_BUFFER_SIZE*16);			\
	vsprintf(message, (message_fmt), (varargs));			\
	char_p=message; end=char_p+strlen(message);			\
	while (char_p<=end) {						\
		if (*char_p=='\n' || *char_p==0) {			\
			char_p[0]=0;					\
			label=gtk_label_new(message);			\
			gtk_box_pack_start((Box), label, TRUE, FALSE, 0); \
			gtk_widget_show(label);				\
			message=char_p+1;				\
		} char_p++;						\
	} g_free(del);							\
}



/* --- structures --- */
typedef	struct	handler_disconnect_S	handler_disconnect_S;
struct	handler_disconnect_S {
	GtkObject	*object;
	gint		handler_id;
	gint		self_id;
};



/* --- prototypes --- */
static	void	SigH_handler_disconnect		(GtkObject *object,
						 gpointer func_data);
static	void	SigH_List_selection_changed	(GtkList	*list,
						 gpointer       *data_pointer);



/* --- functions --- */
void
object_connect_disc_handler	(GtkObject *object,
				 gchar *signal,
				 GtkObject *disconnect_object,
				 gint disconnect_handler)
{
	register handler_disconnect_S	*disc_rec;
	
	g_assert(object);
	g_assert(signal);
	g_assert(disconnect_object);
	
	disc_rec=g_new(handler_disconnect_S, 1);
	disc_rec->object=disconnect_object;
	disc_rec->handler_id=disconnect_handler;
	
	disc_rec->self_id=gtk_signal_connect(object,
				   signal,
				   GTK_SIGNAL_FUNC(SigH_handler_disconnect),
				   (gpointer)disc_rec);
}


void
SigH_handler_disconnect	(GtkObject	*object,
			 gpointer	func_data)
{
	register handler_disconnect_S	*disc;
	
	g_assert(func_data);
	
	disc=func_data;
	
	gtk_signal_disconnect(object, disc->self_id);
	
	gtk_signal_disconnect(disc->object, disc->handler_id);
	
	g_free(disc);
}


void
Message_create	(GtkObject	*parent_object,
		 const gchar	*message_fmt,
		 		...)
{
	static	 va_list	args;
	
	g_assert(message_fmt);
	
	
	/* clone window
	*/
	gb_widget_data_clone(GB_wCAST(base, MDiag_Window));
	
	
	/* initialize widgets
	*/
	GB_wCAST(window, MDiag_Window->clone)->title=PRGNAME_SHORT" Message";
	MDiag_Button_Action->clone->flags=0;
	MDiag_VBox_List->clone->flags=0;
	
	
	/* build window
	*/
	gb_window_build(GB_wCAST(window, MDiag_Window->clone));
	
	
	/* split message into labels
	 * and add them to window
	*/
	va_start(args, message_fmt);
	Box_add_message(GTK_BOX(MDiag_VBox_Msg->clone->widget), message_fmt, args);
	va_end(args);
	
	
	/* the window should be destroyed
	 * if it's parent gets destroyed.
	 * OTOH, this "destroy" signal handler must be
	 * removed from parent if the window gets destroyed.
	*/
	if (parent_object) {
		object_connect_disc_handler (
			GTK_OBJECT(MDiag_Button_Close->clone->widget),
			"destroy",
			parent_object,
			gtk_signal_connect_object (
				parent_object,
				"destroy",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(MDiag_Window->clone->widget)
			)
		);
	}
	
	
	/* window gets destroyed
	 * if it's close button is pressed
	*/
	gtk_signal_connect_object(GTK_OBJECT(MDiag_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(MDiag_Window->clone->widget));
	
	
	/* show window
	*/
	gtk_widget_show(MDiag_Window->clone->widget);
}


GtkWidget*
Dialog_create	(GtkObject	*parent_object,
		 gpointer	nullify_pointer,
		 const gchar	*action_name,
		 GtkSignalFunc	signal_func,
		 gpointer	func_data,
		 const gchar	*message_fmt,
		 		...)
{
	static	 va_list	args;
	
	g_assert(message_fmt);
	
	
	/* clone window
	*/
	gb_widget_data_clone(GB_wCAST(base, MDiag_Window));
	
	
	/* initialize widgets
	*/
	GB_wCAST(window, MDiag_Window->clone)->title=PRGNAME_SHORT" Dialog";
	GB_wCAST(button, MDiag_Button_Action->clone)->label=(gchar*)action_name;
	GB_wCAST(button, MDiag_Button_Close->clone)->label="Cancel";
	MDiag_VBox_List->clone->flags=0;
	
	
	/* build window
	*/
	gb_window_build(GB_wCAST(window, MDiag_Window->clone));
	
	
	/* add message
	*/
	va_start(args, message_fmt);
	Box_add_message(GTK_BOX(MDiag_VBox_Msg->clone->widget), message_fmt, args);
	va_end(args);
	
	
	/* the window should be destroyed
	 * if it's parent gets destroyed.
	 * OTOH, this "destroy" signal handler must be
	 * removed from parent if the window gets destroyed.
	*/
	if (parent_object) {
		object_connect_disc_handler (
			GTK_OBJECT(MDiag_Button_Close->clone->widget),
			"destroy",
			parent_object,
			gtk_signal_connect_object (
				parent_object,
				"destroy",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(MDiag_Window->clone->widget)
			)
		);
	}
	
	
	/* connect signal_func to action button
	*/
	gtk_signal_connect(GTK_OBJECT(MDiag_Button_Action->clone->widget),
			   "clicked",
			   signal_func,
			   func_data);
	
	
	/* window gets destroyed
	 * if it's buttons are pressed
	*/
	gtk_signal_connect_object(GTK_OBJECT(MDiag_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(MDiag_Window->clone->widget));
	gtk_signal_connect_object(GTK_OBJECT(MDiag_Button_Action->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(MDiag_Window->clone->widget));
	
	
	/* (*nullify_pointer) needs to be cleared if the window is destroyed
	*/
	if (nullify_pointer)
		GB_NULLIFY_ON_DESTROY(MDiag_Window->clone->widget, nullify_pointer);
	
	
	/* show window
	*/
	gtk_widget_show(MDiag_Window->clone->widget);
	
	return MDiag_Window->clone->widget;
}


GtkWidget*
SimpleList_create	(GtkObject		*parent_object,
			 gpointer		nullify_pointer,
			 GtkSignalFunc		signal_func,
			 gpointer		func_data,
			 gboolean		browse,
			 GList			*item_list,
			 gint			select_pos,
			 gpointer		*user_data_pointer,
			 const gchar		*message_fmt,
			 ...)
{
	static	 va_list	args;
	
	g_assert(message_fmt);
	
	
	/* clone window
	*/
	gb_widget_data_clone(GB_wCAST(base, MDiag_Window));
	
	
	/* initialize widgets
	*/
	GB_wCAST(window, MDiag_Window->clone)->title=PRGNAME_SHORT" Dialog";
	GB_wCAST(button, MDiag_Button_Action->clone)->flags=0;
	GB_wCAST(list,   MDiag_List->clone)->select_mode=
			   browse ? GTK_SELECTION_BROWSE : GTK_SELECTION_SINGLE;
	
	
	/* build window
	*/
	gb_window_build(GB_wCAST(window, MDiag_Window->clone));
	
	
	/* add message
	*/
	va_start(args, message_fmt);
	Box_add_message(GTK_BOX(MDiag_VBox_Msg->clone->widget), message_fmt, args);
	va_end(args);
	
	
	/* add items to list and connect it's signal handler
	*/
	gtk_list_append_items(GTK_LIST(MDiag_List->clone->widget), item_list);
	*user_data_pointer=NULL;
	gtk_signal_connect(GTK_OBJECT(MDiag_List->clone->widget),
			   "selection_changed",
			   GTK_SIGNAL_FUNC(SigH_List_selection_changed),
			   user_data_pointer);
	gtk_signal_connect(GTK_OBJECT(MDiag_List->clone->widget),
			   "selection_changed",
			   signal_func,
			   func_data);
	if (select_pos>=0)
		gtk_list_select_item(GTK_LIST(MDiag_List->clone->widget), select_pos);
	
	
	/* the window should be destroyed
	 * if it's parent gets destroyed.
	 * OTOH, this "destroy" signal handler must be
	 * removed from parent if the window gets destroyed.
	*/
	if (parent_object) {
		object_connect_disc_handler (
			GTK_OBJECT(MDiag_Button_Close->clone->widget),
			"destroy",
			parent_object,
			gtk_signal_connect_object (
				parent_object,
				"destroy",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(MDiag_Window->clone->widget)
			)
		);
	}
	
	
	/* window gets destroyed
	 * if close button is pressed
	*/
	gtk_signal_connect_object(GTK_OBJECT(MDiag_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(MDiag_Window->clone->widget));
	
	
	/* (*nullify_pointer) needs to be cleared if the window is destroyed
	*/
	if (nullify_pointer)
		GB_NULLIFY_ON_DESTROY(MDiag_Window->clone->widget, nullify_pointer);
	
	
	/* show window
	*/
	gtk_widget_show(MDiag_Window->clone->widget);
	
	return MDiag_Window->clone->widget;
}


void
SigH_List_selection_changed	(GtkList	*list,
				 gpointer       *user_data_pointer)
{
	g_assert(list);
	g_assert(user_data_pointer);
	
	if (list->selection) {
		register GtkItem	*item;
		
		g_assert(item=list->selection->data);
		*user_data_pointer=gtk_object_get_user_data(GTK_OBJECT(item));
	} else
		*user_data_pointer=NULL;
}
