/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* type2str.h: functions for various kinds of string conversions
 * RCS_ID("$Id: type2str.h,v 1.5 1997/08/18 03:38:12 timj Exp $")
*/


#ifndef		__type2str_h__
#define		__type2str_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"config.h"
#include	"gbuild.h"



/* --- prototypes --- */


/* the String_gb_connect_options_E() function returns a string, holding the
 * original symbol of the connect_bits, as declared in enum gb_connect_type_E.
 * a string can only be given for one bit at a time, therefore you can
 * mask out the bit you want a string for with bit_mask.
 * returns:
 * this returns a pointer to a constant and static string.
 * the string can only be used untill the next call to this function.
*/
const	char	*String_gb_connect_options_E(const guint32 connect_bits,
					     const guint32 bit_mask
					     /* the connect_bits will
					      * be anded with mask
					     */);


/* the String_GbResizePolicy() function returns a string, holding the
 * identifier counterpart for value.
 * if descriptive is TRUE, the string holds just a nice brief description of
 * the identifiers meaning.
 * returns:
 * this returns a pointer to a constant and static string.
 * the string can only be used untill the next call to this function.
*/
const	char	*String_GbResizePolicy		(const	guint32	value,
						 gboolean	descriptive);

const	char	*String_GbPageLinkage		(const	guint32	value,
						 gboolean	descriptive);

const	char	*String_GtkWidgetFlag		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkSelectionMode	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkWindowType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkArgType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkStateType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkWindowType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkDirectionType	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkShadowType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkArrowType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkPackType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkPolicyType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkUpdateType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkAttachOptions	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkSignalRunType	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkWindowPosition	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkSubmenuDirection	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkSubmenuPlacement	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkMenuFactoryType	(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkMetricType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkScrollType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkTroughType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkPositionType		(const	guint32	value,
						 gboolean	descriptive);
const	char	*String_GtkPreviewType		(const	guint32	value,
						 gboolean	descriptive);






#ifdef		__cplusplus
  }
#endif
#endif		/*__type2str_h__*/
