/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPD ------- */
	PAD_NC(GPD0, NONE), // PM_BATLOW#
	PAD_CFG_NF(GPD1, NONE, DEEP, NF1), // AC_PRESENT
	_PAD_CFG_STRUCT(GPD2, 0x880500, 0x0), // LAN_WAKEUP#
	PAD_CFG_NF(GPD3, UP_20K, DEEP, NF1), // PWR_BTN#
	PAD_CFG_NF(GPD4, NONE, DEEP, NF1), // SUSB#_PCH
	PAD_CFG_NF(GPD5, NONE, DEEP, NF1), // SUSC#_PCH
	PAD_CFG_NF(GPD6, NONE, DEEP, NF1), // SLP_A#
	PAD_NC(GPD7, NONE),
	PAD_CFG_NF(GPD8, NONE, DEEP, NF1), // SUSCLK
	PAD_CFG_NF(GPD9, NONE, DEEP, NF1), // PCH_SLP_WLAN#
	PAD_NC(GPD10, NONE), // SLP_S5#
	PAD_NC(GPD11, NONE), // PCH_GPD11

	/* ------- GPIO Group A ------- */
	PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1), // SB_KBCRST#
	PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1), // LPC_AD0
	PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1), // LPC_AD1
	PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1), // LPC_AD2
	PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1), // LPC_AD3
	PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1), // LPC_FRAME#
	PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1), // SERIRQ
	PAD_NC(GPP_A7, NONE), // G_INT1
	PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1), // PM_CLKRUN#
	PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1), // PCLK_KBC
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1), // PCLK_TPM
	PAD_CFG_NF(GPP_A11, NONE, DEEP, NF1), // LAN_WAKEUP#
	PAD_NC(GPP_A12, NONE), // PCH_GPP_A12
	PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1), // SUSWARN#
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1), // S4_STATE#
	PAD_CFG_NF(GPP_A15, NONE, DEEP, NF1), // SUSACK#
	PAD_NC(GPP_A16, NONE),
	PAD_NC(GPP_A17, NONE),
	PAD_CFG_GPO(GPP_A18, 1, DEEP), // TBTA_ACE_GPIO3
	PAD_CFG_GPO(GPP_A19, 1, DEEP), // SATA_PWR_EN
	PAD_CFG_GPO(GPP_A20, 0, DEEP), // TBTA_ACE_GPIO0
	PAD_CFG_GPO(GPP_A21, 1, PLTRST), // TBT_FRC_PWR
	PAD_CFG_GPO(GPP_A22, 0, PWROK), // PS8338B_SW
	PAD_CFG_GPO(GPP_A23, 0, PWROK), // PS8338B_PCH

	/* ------- GPIO Group B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1), // CORE_VID0
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1), // CORE_VID1
	PAD_NC(GPP_B2, NONE), // VRALERT#
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	PAD_NC(GPP_B5, NONE), // PCIECLKRQ0#
	PAD_NC(GPP_B6, NONE), // PCIECLKRQ1#
	PAD_CFG_NF(GPP_B7, NONE, DEEP, NF1), // WLAN_CLKREQ#
	PAD_CFG_NF(GPP_B8, NONE, DEEP, NF1), // LAN_CLKREQ#
	PAD_CFG_NF(GPP_B9, NONE, DEEP, NF1), // TBT_CLKREQ#
	PAD_CFG_NF(GPP_B10, NONE, DEEP, NF1), // SSD_CLKREQ#
	PAD_NC(GPP_B11, NONE),
	PAD_NC(GPP_B12, NONE), // SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1), // PLTRST#
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF1), // PCH_SPKR
	PAD_NC(GPP_B15, NONE), // PCH_GPP_B15
	PAD_NC(GPP_B16, NONE), // PCH_GPP_B16
	PAD_NC(GPP_B17, NONE), // PCH_GPP_B17
	PAD_NC(GPP_B18, NONE), // GSPI0_BBS0 - No Reboot strap
	PAD_NC(GPP_B19, NONE), // PCH_GPP_B19
	PAD_NC(GPP_B20, NONE), // PCH_GPP_B20
	PAD_NC(GPP_B21, NONE), // PCH_GPP_B21
	PAD_NC(GPP_B22, NONE), // PCH_GPP_B22 - Boot BIOS strap
	PAD_NC(GPP_B23, NONE), // PCH_GPP_B23

	/* ------- GPIO Group C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1), // SMB_CLK
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1), // SMB_DATA
	PAD_NC(GPP_C2, NONE), // PCH_GPP_C2
	PAD_NC(GPP_C3, NONE), // SML0CLK
	PAD_NC(GPP_C4, NONE), // SML0DATA
	PAD_NC(GPP_C5, NONE), // PCH_GPP_C5
	PAD_NC(GPP_C6, NONE), // SML1CLK
	PAD_NC(GPP_C7, NONE), // SML1DATA
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, NONE), // TBTA_ACE_GPIO2
	_PAD_CFG_STRUCT(GPP_C13, 0x82880100, 0x0000), // TBCIO_PLUG_EVENT
	PAD_NC(GPP_C14, NONE), // TBTA_MRESET
	PAD_NC(GPP_C15, NONE), // TBTA_ACE_GPIO7
	PAD_NC(GPP_C16, NONE), // T_SDA
	PAD_NC(GPP_C17, NONE), // T_SCL
	PAD_NC(GPP_C18, NONE),
	_PAD_CFG_STRUCT(GPP_C19, 0x40880100, 0x0000), // SWI#
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF1), // UART2_RXD
	PAD_CFG_NF(GPP_C21, NONE, DEEP, NF1), // UART2_TXD
	PAD_NC(GPP_C22, NONE), // UEART2_RTS_N
	PAD_NC(GPP_C23, NONE), // UART2_CTS_N

	/* ------- GPIO Group D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE), // PCH_GPP_D4
	PAD_NC(GPP_D5, NONE),
	PAD_NC(GPP_D6, NONE),
	PAD_NC(GPP_D7, NONE),
	PAD_CFG_GPO(GPP_D8, 1, DEEP), // SB_BLON
	PAD_NC(GPP_D9, NONE), // T_INT
	PAD_NC(GPP_D10, NONE), // EDP_DET
	PAD_NC(GPP_D11, NONE),
	PAD_NC(GPP_D12, NONE),
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	PAD_NC(GPP_D15, NONE),
	PAD_NC(GPP_D16, NONE),
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),
	PAD_NC(GPP_D20, NONE),
	PAD_CFG_GPI(GPP_D21, NONE, DEEP), // TPM_DET#
	PAD_NC(GPP_D22, NONE),
	PAD_NC(GPP_D23, NONE),

	/* ------- GPIO Group E ------- */
	PAD_NC(GPP_E0, NONE), // PCH_GPP_E0
	PAD_NC(GPP_E1, NONE), // SATA_ODD_PRSNT#
	PAD_CFG_NF(GPP_E2, NONE, DEEP, NF1), // SATAGP2
	PAD_NC(GPP_E3, NONE),
	PAD_NC(GPP_E4, NONE), // DEVSLP0
	PAD_NC(GPP_E5, NONE), // DEVSLP1
	PAD_CFG_NF(GPP_E6, NONE, DEEP, NF1), // DEVSLP2
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_NF(GPP_E8, NONE, DEEP, NF1), // PCH_SATA_LED#
	PAD_NC(GPP_E9, NONE), // USB_OC#12
	PAD_NC(GPP_E10, NONE), // USB_OC#34
	PAD_NC(GPP_E11, NONE), // USB_OC#56
	PAD_NC(GPP_E12, NONE), // USB_OC#78
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF1), // MUX_HPD
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1), // HDMI_HPD
	_PAD_CFG_STRUCT(GPP_E15, 0x42840100, 0x0), // SMI#
	PAD_CFG_GPI_SCI_LOW(GPP_E16, NONE, DEEP, LEVEL), // SCI#
	PAD_CFG_NF(GPP_E17, NONE, DEEP, NF1), // EDP_HPD
	PAD_CFG_NF(GPP_E18, NONE, DEEP, NF1), // MDP_CTRLCLK
	PAD_CFG_NF(GPP_E19, DN_20K, DEEP, NF1), // MDP_CTRLDATA
	PAD_CFG_NF(GPP_E20, NONE, DEEP, NF1), // HDMI_CTRLCLK
	PAD_CFG_NF(GPP_E21, DN_20K, DEEP, NF1), // HDMI_CTRLDATA
	PAD_NC(GPP_E22, NONE),
	PAD_NC(GPP_E23, NONE),

	/* ------- GPIO Group F ------- */
	PAD_NC(GPP_F0, NONE),
	PAD_NC(GPP_F1, NONE),
	PAD_NC(GPP_F2, NONE),
	PAD_NC(GPP_F3, NONE),
	PAD_NC(GPP_F4, NONE),
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, NONE),
	PAD_NC(GPP_F7, NONE),
	PAD_NC(GPP_F8, NONE),
	PAD_NC(GPP_F9, NONE),
	PAD_NC(GPP_F10, NONE),
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_NC(GPP_F14, NONE),
	PAD_NC(GPP_F15, NONE),
	PAD_NC(GPP_F16, NONE),
	PAD_NC(GPP_F17, NONE),
	PAD_NC(GPP_F18, NONE),
	PAD_NC(GPP_F19, NONE),
	PAD_NC(GPP_F20, NONE),
	PAD_NC(GPP_F21, NONE),
	PAD_NC(GPP_F22, NONE),
	PAD_NC(GPP_F23, NONE), // LIGHT_KB_DET#

	/* ------- GPIO Group G ------- */
	PAD_NC(GPP_G0, NONE),
	PAD_CFG_GPI(GPP_G1, NONE, DEEP), // TBT Detect
	PAD_NC(GPP_G2, NONE),
	PAD_NC(GPP_G3, NONE), // ASM1543_I_SEL0
	PAD_NC(GPP_G4, NONE), // ASM1543_I_SEL1
	PAD_NC(GPP_G5, NONE),
	PAD_NC(GPP_G6, NONE),
	PAD_NC(GPP_G7, NONE),
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
