/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _QA_ATSC_RANDOMIZER_H_
#define _QA_ATSC_RANDOMIZER_H_

#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TextTestResult.h>

#include <atsc_randomizer.h>

class qa_atsc_randomizer : public CppUnit::TestCase {
 private:
  atsc_randomizer	randomizer;
  
 public:

  void setUp (){
    // nop
  }

  void tearDown (){
    // nop
  }

  static void register_tests (CppUnit::TestSuite *suite)
  {
    suite->addTest (new CppUnit::TestCaller<qa_atsc_randomizer>
		    ("randomizer: t0_compare_output_maps", &qa_atsc_randomizer::t0_compare_output_maps));

    suite->addTest (new CppUnit::TestCaller<qa_atsc_randomizer>
		    ("randomizer: t1_initial_states", &qa_atsc_randomizer::t1_initial_states));

    suite->addTest (new CppUnit::TestCaller<qa_atsc_randomizer>
		    ("randomizer: t2_initial_values", &qa_atsc_randomizer::t2_initial_values));

    suite->addTest (new CppUnit::TestCaller<qa_atsc_randomizer>
		    ("randomizer: t3_reset", &qa_atsc_randomizer::t3_reset));

    suite->addTest (new CppUnit::TestCaller<qa_atsc_randomizer>
		    ("randomizer: t4_high_level", &qa_atsc_randomizer::t4_high_level));

  }

 private:

  void t0_compare_output_maps ();
  void t1_initial_states ();
  void t2_initial_values ();
  void t3_reset ();
  void t4_high_level ();
  
};

#endif /* _QA_ATSC_RANDOMIZER_H_ */
