/* -*- Mode: c++ -*-
*******************************************************************************
*
* File:         VrFixOffset.h
* Description:  subtract offset from ADC data
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _VRFIXOFFSET_H_
#define _VRFIXOFFSET_H_

#include <VrSigProc.h>

template<class iType, class oType>
class VrFixOffset : public VrSigProc {

public: 
  virtual const char *name() { return "VrFixOffset"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  VrFixOffset();
};

template<class iType,class oType> int
VrFixOffset<iType,oType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  iType *ip = i[0];
  oType *op = o[0];
  
  int size = output.size;

  while(size > 0) {
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    *op++ = *ip++ - 0x800;
    size -= 8;
  }
  return output.size;
}

template<class iType,class oType> 
VrFixOffset<iType,oType>::VrFixOffset()
  : VrSigProc(1, sizeof(iType), sizeof(oType))
{
  setOutputSize (1024);
}

#endif /* _VRFIXOFFSET_H_ */
