/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_gr_fir_sysconfig_generic.py.
 *
 * Any changes made to this file will be overwritten.
 */

#include <gr_fir_sysconfig_generic.h>

#include <gr_fir_CCF_generic.h>
#include <gr_fir_FCC_generic.h>
#include <gr_fir_CCC_generic.h>
#include <gr_fir_FFF_generic.h>
#include <gr_fir_SCC_generic.h>
#include <gr_fir_SIS_generic.h>
#include <gr_fir_FSF_generic.h>

/*
 * ----------------------------------------------------------------
 * static functions that serve as constructors returned by info
 * ----------------------------------------------------------------
 */

static gr_fir_CCF *
make_gr_fir_CCF (const std::vector<float> &taps)
{
  return new gr_fir_CCF_generic (taps);
}

static gr_fir_FCC *
make_gr_fir_FCC (const std::vector<VrComplex> &taps)
{
  return new gr_fir_FCC_generic (taps);
}

static gr_fir_CCC *
make_gr_fir_CCC (const std::vector<VrComplex> &taps)
{
  return new gr_fir_CCC_generic (taps);
}

static gr_fir_FFF *
make_gr_fir_FFF (const std::vector<float> &taps)
{
  return new gr_fir_FFF_generic (taps);
}

static gr_fir_SCC *
make_gr_fir_SCC (const std::vector<VrComplex> &taps)
{
  return new gr_fir_SCC_generic (taps);
}

static gr_fir_SIS *
make_gr_fir_SIS (const std::vector<short> &taps)
{
  return new gr_fir_SIS_generic (taps);
}

static gr_fir_FSF *
make_gr_fir_FSF (const std::vector<float> &taps)
{
  return new gr_fir_FSF_generic (taps);
}

/*
 * ----------------------------------------------------------------
 * return instances of the generic C++ versions of these classes.
 * ----------------------------------------------------------------
 */

gr_fir_CCF *
gr_fir_sysconfig_generic::create_gr_fir_CCF (const std::vector<float> &taps)
{
  return make_gr_fir_CCF (taps);
}

gr_fir_FCC *
gr_fir_sysconfig_generic::create_gr_fir_FCC (const std::vector<VrComplex> &taps)
{
  return make_gr_fir_FCC (taps);
}

gr_fir_CCC *
gr_fir_sysconfig_generic::create_gr_fir_CCC (const std::vector<VrComplex> &taps)
{
  return make_gr_fir_CCC (taps);
}

gr_fir_FFF *
gr_fir_sysconfig_generic::create_gr_fir_FFF (const std::vector<float> &taps)
{
  return make_gr_fir_FFF (taps);
}

gr_fir_SCC *
gr_fir_sysconfig_generic::create_gr_fir_SCC (const std::vector<VrComplex> &taps)
{
  return make_gr_fir_SCC (taps);
}

gr_fir_SIS *
gr_fir_sysconfig_generic::create_gr_fir_SIS (const std::vector<short> &taps)
{
  return make_gr_fir_SIS (taps);
}

gr_fir_FSF *
gr_fir_sysconfig_generic::create_gr_fir_FSF (const std::vector<float> &taps)
{
  return make_gr_fir_FSF (taps);
}

/*
 * Return info about available implementations.
 *
 * This is the bottom of the concrete hierarchy, so we set the
 * size of the vector to 1, and install our info.  Classes derived
 * from us invoke us first, then append their own info.
 */

void
gr_fir_sysconfig_generic::get_gr_fir_CCF_info (std::vector<gr_fir_CCF_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_CCF;
}

void
gr_fir_sysconfig_generic::get_gr_fir_FCC_info (std::vector<gr_fir_FCC_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_FCC;
}

void
gr_fir_sysconfig_generic::get_gr_fir_CCC_info (std::vector<gr_fir_CCC_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_CCC;
}

void
gr_fir_sysconfig_generic::get_gr_fir_FFF_info (std::vector<gr_fir_FFF_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_FFF;
}

void
gr_fir_sysconfig_generic::get_gr_fir_SCC_info (std::vector<gr_fir_SCC_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_SCC;
}

void
gr_fir_sysconfig_generic::get_gr_fir_SIS_info (std::vector<gr_fir_SIS_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_SIS;
}

void
gr_fir_sysconfig_generic::get_gr_fir_FSF_info (std::vector<gr_fir_FSF_info> *info)
{
  info->resize (1);
  (*info)[0].name = "generic";
  (*info)[0].create = make_gr_fir_FSF;
}
