#include <gr_iqplot.h>
#include <plotter.h>
#include <VrComplex.h>

gr_iqplot::gr_iqplot(int maxpoints, int p_or_l, float scale, char* label)
  :maxpoints(maxpoints),points_or_lines(p_or_l),points_so_far(0),
  count(0),scale(scale),label(label)
{
  plotter = new XPlotter(cin,cout,cerr);
  plotter->openpl();
  plotter->erase();
  if(label)
    {
      plotter->pencolorname("black");
      plotter->space(0,0,1,1);
      plotter->ffontsize(0.05);
      plotter->fmove(0.5,0.05);
      plotter->alabel('c','c',label);
    }
  plotter->space(-scale,-scale,scale,scale);
  plotter->pencolorname("black");
  plotter->line(-scale,0,scale,0);
  plotter->line(0,-scale,0,scale);
  plotter->pencolorname("red");
  plotter->move(0,0);
}

void 
gr_iqplot::iqplot(const VrComplex *in,int size)
{
  for(int i=0;i<size;i++)
    {
      if(points_or_lines)
	plotter->fpoint(in[i].real(),in[i].imag());
      else
	plotter->fcont(in[i].real(),in[i].imag());
      count++;
      if(count>maxpoints)
	{
	  count = 0;
	  plotter->erase();
	  if(label)
	    {
	      plotter->pencolorname("black");
	      plotter->space(0,0,1,1);
	      plotter->ffontsize(0.05);
	      plotter->fmove(0.5,0.05);
	      plotter->alabel('c','c',label);
	      plotter->space(-scale,-scale,scale,scale);
	      plotter->pencolorname("black");
	      plotter->line(-scale,0,scale,0);
	      plotter->line(0,-scale,0,scale);
	      plotter->pencolorname("red");
	      plotter->fmove(in[i].real(),in[i].imag());
	    }
	}
    }
}

gr_iqplot::~gr_iqplot ()
{
  plotter->closepl();
}
