/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include <fcntl.h>
#include <unistd.h>
#include <VrSigProc.h>
#include <VrConnect.h>
#include <GrMC4020Buffer.h>
#include <mc4020.h>

void
GrMC4020Buffer::allocateBuffer(unsigned int arg_type_size)
{
  type_size = arg_type_size;
  bufferSize = bufferSize_bytes / type_size;

  // Find a place big enough for the buffer
  char *start = NULL;
  int fdz = open ("/dev/zero",O_RDONLY);
  if ((start=(char *) mmap(0,bufferSize_bytes*2,PROT_NONE,MAP_SHARED,fdz,0)) == MAP_FAILED
      || munmap(start,bufferSize_bytes*2) == -1) {
    perror("GrMC4020Buffer: could not allocate mmap memory for buffer");
    exit(-1);
    return;
  }
  close(fdz);

  // mmap the buffer in twice
  if ((mmap(start,bufferSize_bytes,PROT_READ,MAP_FIXED|MAP_SHARED,device_fd,0)) == MAP_FAILED
      || (mmap(start+bufferSize_bytes,bufferSize_bytes,PROT_READ,MAP_FIXED|MAP_SHARED,device_fd,0)) == MAP_FAILED) {
    perror("GrMC4020Buffer: could not mmap mc4020 buffer");
    exit(-1);
    return;
  }

  bufferDupStart = ((char *)start) + bufferSize * type_size;
  //  cerr << upstream->name() <<" (mc4020)bufferDupStart = "<<(void *) bufferDupStart<<endl; 
} 
