/* -*- c++ -*- */
/*
 * Copyright 2001,2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
n * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <ppio_raw.h>
#include <stdlib.h>
#ifdef HAVE_SYS_IO_H
#include <sys/io.h>
#else
//#warn "ppio_raw is not functional on this platform"
#define inb(x) 0
#define outb(a, b)
#endif

const static int parallel_port_base[3] = {
  0x3bc,	// lp0 used to be on monochome display adapter
  0x378,	// lp1 most common
  0x278		// lp2 secondary
};

// These control port bits are active low.
// We toggle them so that this weirdness doesn't get get propagated
// through our interface.

static int CP_ACTIVE_LOW_BITS	= 0x0B;

// These status port bits are active low.
// We toggle them so that this weirdness doesn't get get propagated
// through our interface.

static int SP_ACTIVE_LOW_BITS	= 0x80;

ppio_raw::ppio_raw (int which)
{
  if (which < 0 || which > 2)
    abort ();

  d_base = parallel_port_base[which];

  // try to read ports.  If we don't have the appropriate
  // ioperm bits set, we'll segfault here.  At least it's deterministic...

  inb (d_base + 0);
  inb (d_base + 1);
  inb (d_base + 2);
}

void 
ppio_raw::write_data (unsigned char v)
{
  outb (v, d_base + 0);
}

unsigned char
ppio_raw::read_data ()
{
  return inb (d_base + 0);
}

void 
ppio_raw::write_control (unsigned char v)
{
  outb (v ^ CP_ACTIVE_LOW_BITS, d_base + 2);
}

unsigned char
ppio_raw::read_control ()
{
  return inb (d_base + 2) ^ CP_ACTIVE_LOW_BITS;
}

unsigned char
ppio_raw::read_status ()
{
  return inb (d_base + 1) ^ SP_ACTIVE_LOW_BITS;
}

void
ppio_raw::lock ()
{
  // nops for now FIXME
}

void
ppio_raw::unlock ()
{
  // nops for now FIXME
}
