#!/usr/bin/env python
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from GnuRadio import *
from slider_control import *
import eng_notation

#
# return a gr_FlowGraph
#

def build_graph3 ():

    interp_rate = 64
    sample_rate = 125e6/interp_rate
    which_board = 0
    channel_bitmask = 0
    ampl = 32e3
    center_freq = 17e6

    src = GrComplexNCOSource (sample_rate, 250e3, ampl)
    dst = GrUsrpSink (which_board, channel_bitmask, interp_rate)
    dst.set_tx_freq (0, center_freq)

    print "sample rate: %s  data rate: %s" % (eng_notation.num_to_str (sample_rate),
                                              eng_notation.num_to_str (4 * sample_rate))

    # sc1 = slider_control(None,-1,"USRP Freq",set_tx_freq0,0,60000000)
    # sc2 = slider_control(None,-1,"Source Freq",src.setFrequency,-sample_rate/2,sample_rate/2)
    # sc3 = slider_control(None,-1,"Amplitude",src.setAmplitude,0,32767)
    
    fg = gr_FlowGraph ()
    fg.connect (src, dst)

    return fg


if __name__ == '__main__':
    fg = build_graph3 ()
    fg.start ()                         # fork thread(s) and return immediately
    # your GUI mail loop goes here...
    # fg.wait ();                         # wait (forever)
    #parent,id,title,callback,min,max
    # app=wx.PySimpleApp()
    # app.MainLoop()
    raw_input ('Press Enter to quit: ')
    fg.stop ()
