/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRBUFFER_H_
#define _VRBUFFER_H_
#include "VrTypes.h"

extern int BufferSizeMultiplier;
class VrConnect;
class VrSigProc;

class VrBuffer {
protected:
  //duplicate start = end of unique + 1 = start + bufferSize
  char* bufferDupStart; 
  unsigned int bufferSize;    	 // size in items.  = bufferDupStart - buffer start
  unsigned int type_size; 	 // size of 1 unit of data 
  VrSampleIndex WPdupstart; 	 // VrSampleIndex at bufferDupStart
  MUTEX_DECLARE(dupstartlock);
  VrSampleIndex minRP;		 // hint; <= min_i(connectors[i]->minRP) -- updated rarely
  VrSigProc* upstream; 		 // who writes to this buffer 
  VrConnect ** connectors;   	 // who reads from this buffer
  unsigned int numberConnectors; // how many of above
  unsigned int setupCalled; 	 // count of how many setup requests we've received 
  virtual void allocateBuffer(unsigned int arg_type_size); 

public: 
  unsigned int buffersize() { return bufferSize; };
  unsigned int getNumberConnectors() { return numberConnectors; }
  // Add c as a reader of this buffer
  void connect_buffer(VrConnect *c);
  double buffer_getSamplingFrequency();
  VrSigProc* getUpstreamModule() {return upstream;} 
  //Called once from upstream module
  void setup(unsigned int arg_type_size);
  //recompute the hint minRP
  VrSampleIndex updateMinRP();

  //returns how much space will be left if the write pointer is updated to WP
  //  if >0, write can proceed
  int writespace(VrSampleIndex WP) {
    int s = bufferSize - (WP - minRP);
    if(s <= 0)
      updateMinRP();
    s = bufferSize - (WP - minRP);
    return s;
  }

  //called from the upstream VrSigProc (in prepareRead)
  char *getWritePointer(VrSampleRange r);
  //called from a downstream VrSigProc, via VrConnect
  virtual char *getReadPointer(VrSampleRange r);
  VrBuffer(VrSigProc *m); 
  virtual ~VrBuffer() { };
};
#define PAGE_SIZE getpagesize()
#endif
