/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VrIIRFILTER_H_
#define _VrIIRFILTER_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class VrIIRfilter : public VrSigProc {
protected:
  int order,offset;
  double *Btaps, *Ataps;
  iType *input_hist;
  oType *output_hist;
  float gain;

public: 
  virtual int work(VrSampleRange output, void *ao[],
		VrSampleRange inputs[], void *ai[]);
  virtual void initialize();
  VrIIRfilter(int,double *, double *, float);
  ~VrIIRfilter();
};

template<class iType,class oType> int
VrIIRfilter<iType,oType>::work(VrSampleRange output, void *ao[],
                VrSampleRange inputs[], void *ai[])
{
  oType result;
  for (unsigned int sample=0;sample<output.size;sample++) 
  {
	input_hist[(sample + offset)% order] = ((iType **)ai)[0][sample];
	result = Btaps[0] * ((iType **)ai)[0][sample];

	for (int tap=1; tap < order; tap++) 
		result += (Btaps[tap] * input_hist[(sample + offset + order - tap)%order]) 
			+ (Ataps[tap] * output_hist[(sample + offset + order - tap)%order]);
   	((oType **)ao)[0][sample] = gain * result;
	output_hist[(sample + offset) % order] = result;
  }
  offset = (offset + output.size) % order;
  return output.size;
}


template<class iType,class oType> 
VrIIRfilter<iType,oType>::VrIIRfilter(int ord, double *intaps, double *outtaps, float gain)
  :VrSigProc(1, sizeof(iType), sizeof(oType)), order(ord),offset(0),gain(gain)
{
  Ataps = new double[order];
  Btaps = new double[order];
  input_hist = new iType[order];
  output_hist = new oType[order];

  for(int i = 0; i<order; i++)
  {
	input_hist[i] = 0; output_hist[i] = 0;
	Btaps[i] = intaps[i];
	Ataps[i] = outtaps[i];
  }
}

template<class iType,class oType> 
void VrIIRfilter<iType,oType>::initialize()
{
  //setOutputHistory(order);
  //setHistory(order);
}

template<class iType,class oType> 
VrIIRfilter<iType,oType>::~VrIIRfilter()
{
  delete Ataps;
  delete Btaps;
  delete input_hist;
  delete output_hist;
}

#endif








