/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#include <VrSigSource.h>
#include <VrFakeGuppiSource.h>
#include <VrNop.h>
#include <VrNullSink.h>
#include <VrRealFIRfilter.h>
#include <VrComplexFIRfilter.h>
#include <VrQuadratureDemod.h>
#include <VrMultiTask.h>

/* Single FM-radio station receive chain */
/* Runs over 1-4 processors and compares the
   number of samples per second */

const float inputRate = 33000000.0;
const float inputFreq = 10700000.0;

const int CFIRdecimate = 230;
const int chanTaps = 250;
const float chanGain = 2.0;
const float chanfreq = 10000000.0;

const float FMdemodGain = 1100.0;

const int RFIRdecimate = 9;
const int ifTaps = 20;
const float ifGain = 1.0;

const float quadRate = inputRate / CFIRdecimate;
const float audioRate = quadRate / RFIRdecimate;

const float seconds = 10.0;

int main(int argc, char **argv) {

  // Create Modules
  //  VrSigSource<char>* source = new VrSigSource<char>(inputRate, VR_SIN_WAVE,10700001,100);
  VrFakeGuppiSource<char>* source = new VrFakeGuppiSource<char>(inputRate);

  VrNop<char>* nop = new VrNop<char>();
  VrComplexFIRfilter<char>* channel_filter = 
    new VrComplexFIRfilter<char>(CFIRdecimate,chanTaps, chanfreq,chanGain);

  VrQuadratureDemod<float>* demod = new  VrQuadratureDemod<float>(FMdemodGain);
  VrRealFIRfilter<float,short>* if_filter = new VrRealFIRfilter<float,short>(RFIRdecimate,4000.0,ifTaps,ifGain);
  
  VrNullSink<short>* sink = new VrNullSink<short>();
  
  // Connect Modules

  CONNECT(sink, if_filter, audioRate, 16);
  CONNECT(if_filter, demod, quadRate, 32);
  CONNECT(demod, channel_filter, quadRate, 64);
  CONNECT(channel_filter, nop, inputRate, 8);
  CONNECT(nop, source, inputRate, 8);

#ifdef THREADS

  VrMultiTask *m;

  int threads = 1;
  if (argc > 1)
    threads = atoi(argv[1]);

  //  for(int threads=1;threads<=4;threads++) {
    cerr<<threads<<" threads."<<endl;
    m=new VrMultiTask(threads);
    m->add(sink);  
    
    // Start System
    m->start();
    while(m->elapsedTime() < seconds) 
      m->process();
    m->stop();

    cerr<<"WP: "<<(sink->getWP())<<endl;
    cerr<<"time source: "<<(source->getWP()/source->getSamplingFrequency())<<endl;
    cerr<<"time sink: "<<(sink->getWP()/sink->getSamplingFrequency())<<endl<<endl;

    delete m;
    //  }
#else
  cerr<<"Compile w/ THREADS to run this performance test."<<endl;
#endif

#ifdef PERFMON
  m->print_stats();

#if 0
  VrPerfGraph *g=m->getGraph();
  g->setTitle("Single channel FM audio receive");
  g->outputGraph(seconds);
#endif
#endif
}
