/* -*- Mode: c++ -*-
 *
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */
#undef __GNUC__
#define XFD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define XFD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define XFD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define XFD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))

#include "rtpcommon.h"
#include "VrMultiTask.h"
#include "VrAWGN.h"
#include "VrSum.h"
#include "VrGUI.h"

#define SAMPLES_PER_FRAME	160
#define MEAN_FRAME	320
#define SAMPLE_RATE 8000
#define BITS_PER_SAMPLE 16
#define BYTES_PER_BLOCK 320
#define UNITS_PER_PACKET	2
#define MAXPACKETSIZE (1500-28)
#define MAX_DROPOUT	3000
#define MAX_MISORDER	100
#define MIN_SEQUENTIAL	2
#define RTP_SSRC_EXPIRE        70u
#define MAX_PACKLEN     1200
#define RAT_VERSION "RAT v4.0.4 Linux"
#define MAX_PACKET_SAMPLES	1280
#define PACKET_LENGTH		MAX_PACKET_SAMPLES + 100

void process_input(void *sp, unsigned char *packet, long arg_len);
void memdump(unsigned char *p, int len, char *title);
static void socket_error(char *msg);
#include "XVrUDPSource.h"
#include "VrUDPSink.h"
rtp_db		*masterdb;
rtcp_dbentry *active_sources;

VrUDPSource<char>* udpsource;
VrUDPSink<char>*udpsink;
VrSum<char,char>*summer;

static struct timeval last_read_time;
static int avail_bytes; /* Number of bytes available because of under read */
static struct timeval no_time_at_all = {0,0};

static rtcp_dbentry   * get_source(unsigned long ssrc)
{
	rtcp_dbentry   *dptr = active_sources;

	while (dptr) {
		if (dptr->ssrc == ssrc)
			return dptr;
		dptr = dptr->next;
	}
	return NULL;
}
static rtcp_dbentry   * find_source(unsigned long ssrc)
{
	rtcp_dbentry   *newdb;
	if ((newdb = get_source(ssrc)))
		return newdb; 
	newdb = (rtcp_dbentry *)malloc(sizeof(rtcp_dbentry));
	memset(newdb, 0, sizeof(rtcp_dbentry));
	newdb->ssrc = ssrc;
	newdb->sentry = (ssrc_entry *) malloc(sizeof(ssrc_entry));
	memset(newdb->sentry, 0, sizeof(ssrc_entry));
	newdb->sentry->ssrc = ssrc;
    newdb->age = 0;
    newdb->buffer = (unsigned char *)malloc(BUFFER_LENGTH);
    newdb->inputp = newdb->buffer; 
	newdb->next = active_sources;
	active_sources = newdb;
	return newdb;
}
static void socket_error(char *msg)
{
	perror(msg);
	abort();
}
void memdump(unsigned char *p, int len, char *title)
{
int i;

    i = 0;
    while (len > 0) {
		if ((i & 0xf) == 0) {
	    	if (i > 0)
				printf("\n");
	    	printf("%s: ",title);
		}
		printf("%02x ", *p++);
		i++;
		len--;
    }
    printf("\n");
}
static void init_session(void)
{
	masterdb = (rtp_db*)malloc(sizeof(rtp_db));
	memset(masterdb, 0, sizeof(rtp_db));
	masterdb->initial_rtcp = 1;
	masterdb->myssrc = lrand48();
	masterdb->my_dbe = find_source(masterdb->myssrc);
	masterdb->my_dbe->sentry->cname = "jca@18.31.0.163";
	masterdb->my_dbe->sentry->tool = RAT_VERSION;
	masterdb->rtp_seq = lrand48() & 0xffff;
    masterdb->last_rpt = 0; /* get_time(sp->device_clock); */
}


int out_rate = 400000; //400000;
int in_rate = 2000; //2000; 
static char test_data[] = {1,2,3,4,5,6,7,8,9,10,11};
int this_size;

int main(int argc, char *argv[])
{
VrGUI *guimain = new VrGUI(argc, argv);
int dec = out_rate / in_rate;
unsigned long	packet_time;
char *cp;
VrSampleRange outp, inp;
rtcp_dbentry *curr;
int plen;
unsigned char *ptr;
int packlen;
unsigned long thisnow;
struct sockaddr this_addr;
union {
	rtp_hdr_t h;
	char data[MAXPACKETSIZE];
} packet;

	udpsource = new VrUDPSource<char>(5004);
	udpsink = new VrUDPSink<char>("localhost", 5004);
	summer = new VrSum<char,char>();

	(void) VrGUISpace(guimain->top, 10);
	(void) VrGUILabel(guimain->top, "Channel Sim", 0, 30);

	CONNECT(udpsink, udpsource /*summer*/, out_rate, 8);
#if 0
	CONNECT(summer, udpsource, out_rate, 8); 
#endif
	VrMultiTask *m = new VrMultiTask();
	m->add(udpsink);  
	m->start(); 
	guimain->start();
	init_session();
	gettimeofday(&last_read_time, NULL);
    packet_time = 0xfffffd00; /* lrand48(); */
	while (1) {
		cp = NULL;
		udpsource->work(outp, (void **)&cp);
		packlen = 0;
		thisnow= 0; /* get_time(sp->device_clock); */
		ptr= (unsigned char *)&packet;
		if ((thisnow - masterdb->last_rpt) > masterdb->report_interval) {
			ptr = rtcp_packet_fmt_srrr(ptr);
			ptr = rtcp_packet_fmt_sdes(ptr);
			packlen = ptr - (unsigned char *)&packet;
#if 0
			if (sendto(sp->rtcp_socket->fd, (unsigned char *)&packet, packlen, 0,
				(struct sockaddr *) &this_addr, sizeof(this_addr)) < 0)
#endif
				socket_error("udp_send");
			masterdb->last_rpt = thisnow;			/* Reset per-report statistics... */
			masterdb->initial_rtcp = 0;
		}
		this_size = sizeof(test_data);
		while(1) { /* for all outputs */ 
    		packet.h.cc = 0;
    		packet.h.type = 2;
    		packet.h.seq = (unsigned short)htons(masterdb->rtp_seq++);
    		packet.h.p = packet.h.x = 0;
    		packet.h.ssrc = htonl(masterdb->myssrc);
    		packet.h.pt = 0;
    		packet.h.ts = htonl(packet_time);
    		packet.h.m = 1;
			cp = packet.data + 12 + packet.h.cc * 4;
			curr = active_sources;
			while (curr) {		/* for all inputs, compute this output */
				curr = curr->next;
			}
			plen = this_size;
			memcpy(cp, (char *) test_data, plen);
			memdump((unsigned char *)cp, plen, "Tx");
			cp += plen;
   			masterdb->byte_count += plen;
			*(long *)(&test_data[4]) += 1;
			outp.size = cp - packet.data;
			cp = (char *)&packet;
			udpsink->work(outp, &inp, (void **)&cp);
    		masterdb->pkt_count++;
			break;
		}			/* for all outputs */
		curr = active_sources;
		while (curr) {		/* increment output pointers */
			curr->outputp += this_size;
			curr = curr->next;
		}
		packet_time += SAMPLES_PER_FRAME;
		guimain->processEvents(10 /*ms*/);
#if 0
		m->process(); 
#endif
    }
    printf ("all done\n");
	return 0;
}
