/* -*- Mode: c++ -*-
 *
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *    Create May 25, 1998 Matthew L. Welborn
 */
#define FOUR  0
#define EIGHT 1
#define SYNC_VERSION        1
#define PULSE_VERSION       0

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrSum.h"
#include "VrFFTSink.h"
#include "VrFileSink.h"
#include "VrSyncFilter.h"
#include "VrComplexPlotSink.h"
#include "VrBits2Symbols.h"
#include "VrUDPSink.h"
#include "VrScopeSink.h"
#include "VrMultiTask.h"
#include "VrGUI.h"
#include "VrConstellation_defs.h"

#define DEFAULT_TPD	2600.0
int process_one = 1;
int persistent = 0;

VrScopeSink<char> *scopesink;

VrDigMod<char,char> *mod;
VrBits2Symbols* coder;

int center_freq_mult = 4, band=1; //jca 4;
int out_rate = 400000; //400000;
int in_rate = 2000; //2000; 
int offset, const_num = 5;
int num_symb = 16, output_symbol_bits= 4, K=2;
float alpha=0.6; 
int ampl=80;

void set_clear()
{
  scopesink->clear();
}
void set_my_scale(double f) {
printf ("set scale %f\n", f);
  scopesink->setScale(f);
  scopesink->clear();
}
void set_persistent()
{
	persistent = 1 - persistent;
	scopesink->set_persistent(persistent);
}

void(*last_const)();
void set_sync() { set_my_scale(2502.0); }

void set_base() { band = 0; 
                  (*last_const)();}


void set_pass() { band = 1; 
                  (*last_const)();}

void set_eye() { set_my_scale(300.0); }


void set_constellation0(){   mod -> change_constellation(alpha, ampl, 2, 8,
					symbol_phase[0], symbol_amplitude[0], band);
                             coder -> setOutputBits(1);
			     mod -> set_sync_symbols(0,1);
			     last_const = set_constellation0;
}
void set_constellation1(){   mod -> change_constellation(alpha, ampl, 4, 6,
					symbol_phase[1], symbol_amplitude[1], band);
                             coder -> setOutputBits(2);
			     mod -> set_sync_symbols(1,3);
			     last_const = set_constellation1;
}
void set_constellation2(){   mod -> change_constellation(alpha, ampl, 8, 4,
					symbol_phase[2], symbol_amplitude[2], band);
                             coder -> setOutputBits(3);
			     mod -> set_sync_symbols(3,7);
			     last_const = set_constellation2;
}
void set_constellation3(){   mod -> change_constellation(alpha, ampl, 4, 6,
					symbol_phase[3], symbol_amplitude[3], band);
			     mod -> set_sync_symbols(0,2);
                             coder -> setOutputBits(2);
			     last_const = set_constellation3;
}
void set_constellation4(){   mod -> change_constellation(alpha, ampl, 8, 4,
					symbol_phase[4], symbol_amplitude[4], band);
                             coder -> setOutputBits(3);
			     mod -> set_sync_symbols(0,4);
			     last_const = set_constellation4;
}
void set_constellation5(){   mod -> change_constellation(alpha, ampl, 16, 2,
					symbol_phase[5], symbol_amplitude[5], band);
                             coder -> setOutputBits(4);
			     mod -> set_sync_symbols(0,15);
			     last_const = set_constellation5;
}


//void set_constellation(int c) {
int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  //  int offset, const_num = 5;
  //int num_symb = 16, output_symbol_bits= 4, K=4;
  //float alpha=0.6; 
  //int ampl=80;
  last_const = set_constellation5;


  VrFileSource<char>* source = new VrFileSource<char>("../../data_files/random",1);
  coder = new VrBits2Symbols(output_symbol_bits);
  mod =  new VrDigMod<char,char>(out_rate/in_rate,65000.0,ampl,
			   num_symb, symbol_phase[const_num], symbol_amplitude[const_num],
			   K, alpha, center_freq_mult);



  (void) VrGUILabel(guimain->top, "Waveforms", 0, 30);
  VrGUILayout *scopelay_modes = guimain->top->horizontal();
  (void) VrGUISpace(scopelay_modes, 50);
  (void) new VrGUIButton(scopelay_modes, "BPSK", set_constellation0);
  (void) new VrGUIButton(scopelay_modes, "4-PAM", set_constellation1);
  (void) new VrGUIButton(scopelay_modes, "8-PAM", set_constellation2);
  (void) new VrGUIButton(scopelay_modes, "QPSK", set_constellation3);
  (void) new VrGUIButton(scopelay_modes, "8-PSK", set_constellation4);
  (void) new VrGUIButton(scopelay_modes, "16-QAM", set_constellation5);
  (void) new VrGUIButton(scopelay_modes, "8-VSB", set_constellation2);
  (void) VrGUILabel(guimain->top, "Time domain", 0, 30);
  VrGUILayout *scopelay_main = guimain->top->horizontal();
  VrGUILayout *scopelay = scopelay_main->vertical();
  scopesink = new VrScopeSink<char>(scopelay, DEFAULT_TPD/2, -128, 128, 500, 1);

  scopesink -> setSkip(1,1);
  VrGUILayout *scopelay_slider = scopelay->horizontal();
  (void) new VrGUISlider(scopelay_slider, set_my_scale, "Time", DEFAULT_TPD/100, DEFAULT_TPD);
  VrGUILayout *scopelay2 = scopelay_main->vertical();
  (void) new VrGUIButton(scopelay2, "Baseband", set_base);
  (void) new VrGUIButton(scopelay2, "Passband", set_pass);
  (void) VrGUISpace(scopelay2, 50);
  (void) new VrGUIButton(scopelay2, "Store", set_persistent);
  (void) new VrGUIButton(scopelay2, "Clear", set_clear);
  (void) VrGUISpace(scopelay2, 50);
  (void) new VrGUIButton(scopelay2, "Sync time", set_sync);
  (void) new VrGUIButton(scopelay2, "Eye time", set_eye);
  (void) VrGUISpace(scopelay2, 200);

  (void) VrGUISpace(guimain->top, 10);


  //  VrUDPSink<char>* sink      = new VrUDPSink<char>("localhost", 5001);
  VrFileSink<char>* sink      = new VrFileSink<char>("tx_out");
  VrSum<char,char>*summer = new VrSum<char,char>();

  CONNECT(scopesink, mod, out_rate, 8);
  CONNECT(sink, summer, out_rate, 8);
  CONNECT(summer, mod, out_rate, 8);
  CONNECT(mod, coder, in_rate, 8);
  CONNECT(coder, source, in_rate * output_symbol_bits / 8, 8);

  VrMultiTask *m = new VrMultiTask();
  m->add(sink);  
  m->add(scopesink);  
  m->start(); 
  guimain->start();

  offset = 3;
  while(1) {
    guimain->processEvents(10 /*ms*/);
   	m->process(); 
//printf ("sleep 10\n");
//sleep(10);
  } /* while(1) */
}
