;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:
   02/20/92 Andrew Mickish - Moved make-package call to Garnet-Loader
    2/18/92 Brad Myers - add gilt-gadget-utils
   02/22/91 Osamu Hashimoto - added "-imp" files
   12/05/90 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Loading Gilt...~%")

;; check first to see if pathname variable is set
(unless (boundp 'Garnet-Gilt-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Gilt-PathName before loading this file."))

(dolist (gadget '("text-buttons-loader"
		  "x-buttons-loader"
		  "radio-buttons-loader"
		  "labeled-box-loader"
		  "scrolling-labeled-box-loader"
		  "error-gadget-loader"
		  "v-slider-loader"
		  "prop-sheet-win-loader"
		  "multi-selection-loader"
		  #+lucid "scrolling-menu-loader"
		  #+lucid "menu-loader"
		  #+lucid "h-scroll-loader"
		  #+lucid "h-slider-loader"
		  #+lucid "v-scroll-loader"
		  #+lucid "gauge-loader"
		  #+lucid "trill-device-loader"
		  #+lucid "motif-parts"
		  ))
  (load (merge-pathnames gadget
			 #+cmu "gadgets:"
			 #+(not cmu) user::Garnet-Gadgets-PathName)))

#+allegroV3.1
(gc t)

(defvar gilt-files '("gilt-string-edit"
		     "gilt-functions-loader" ; only load if not already loaded
		     "gilt-gadget-utils"
		     "gilt-gadgets"
		     "gilt"
		     "line-imp"  "line-props"
		     "fill-imp"  "fill-props"
		     "align-imp"  "align-props" 
		     "gilt-save" "gilt-read"
		     "gilt-font-imp"  "gilt-font-props"
		     "color-imp"  "color-props"
		     ))

(dolist (file gilt-files)
  (load (merge-pathnames file
			 #+cmu "gilt:"
			 #+(not cmu) user::Garnet-Gilt-PathName)
	:verbose T))


(format T "Type (gilt:do-go) to start~%")


