/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.requests;

import org.gnunet.mq.Envelope;
import org.gnunet.mq.MessageQueue;
import org.gnunet.mq.NotifySentHandler;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.TimeoutHandler;
import org.gnunet.util.Cancelable;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Scheduler;

abstract class SimpleRequestIdentifier<T extends Request>
implements RequestIdentifier<T> {
    private final T request;
    boolean queued;
    private Cancelable sendCancel;
    private boolean sent;
    private boolean canceled;
    private Scheduler.TaskIdentifier timeoutTask;

    public SimpleRequestIdentifier(T request) {
        this.request = request;
    }

    @Override
    public void retire() {
        if (null != this.timeoutTask) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
        }
    }

    @Override
    public void setTimeout(RelativeTime timeout, final TimeoutHandler timeoutHandler) {
        if (null != this.timeoutTask) {
            throw new AssertionError((Object)"timeout already set");
        }
        this.timeoutTask = Scheduler.addDelayed(timeout, new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                if (ctx.reasons.contains((Object)Scheduler.Reason.SHUTDOWN)) {
                    return;
                }
                timeoutHandler.onTimeout();
            }
        });
    }

    @Override
    public T getRequest() {
        return this.request;
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            throw new AssertionError((Object)"canceled twice");
        }
        this.canceled = true;
        if (this.sent) {
            ((Request)this.request).cancel();
        } else if (null != this.sendCancel) {
            this.sendCancel.cancel();
            this.sendCancel = null;
        }
        this.retire();
    }

    public void send(MessageQueue mq) {
        this.queued = true;
        Envelope ev = ((Request)this.request).assembleRequest();
        ev.notifySent(new NotifySentHandler(){

            @Override
            public void onSent() {
                SimpleRequestIdentifier.this.sendCancel = null;
                SimpleRequestIdentifier.this.sent = true;
            }
        });
        mq.send(ev);
        this.sendCancel = ev;
    }
}

