########################################################################
##
## Copyright (C) 2013-2024 The Octave Project Developers
##
## See the file COPYRIGHT.md in the top-level directory of this
## distribution or <https://octave.org/copyright/>.
##
## This file is part of Octave.
##
## Octave is free software: you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, see
## <https://www.gnu.org/licenses/>.
##
########################################################################

## -*- texinfo -*-
## @deftypefn  {} {} record (@var{recorder})
## @deftypefnx {} {} record (@var{recorder}, @var{length})
## Record audio without blocking using the audiorecorder object
## @var{recorder} until paused or stopped by the @var{pause} or @var{stop}
## methods.
##
## Given the optional argument @var{length}, record for @var{length} seconds.
## @seealso{@audiorecorder/recordblocking, @audiorecorder/audiorecorder}
## @end deftypefn

function record (recorder, length)

  hrecorder = struct (recorder).recorder;

  if (nargin == 1)
    __recorder_record__ (hrecorder);
  else
    __recorder_record__ (hrecorder, length);
  endif

endfunction


## No tests possible for this function
%!assert (1)
