/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.ApplicationCommands;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.ThreadCommands;

public class GeneralCommands
extends ApplicationCommands {
    public void doFinish(Integer cmd_id, List args) {
        this.app.shutdown();
        this.app.signalCommandResult(cmd_id);
    }

    public void doTraceClasses(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        String type = args.remove(0).toString().toLowerCase();
        if (!type.equals("preparation") && !type.equals("unloading")) {
            throw new JDEException("Invalid type");
        }
        Long requestID = null;
        List classFilters = Etc.getClassFiltersFromArgs(args);
        List classExFilters = Etc.getClassExFiltersFromArgs(args);
        EventRequestManager em = this.app.getVM().eventRequestManager();
        if (type.equals("preparation")) {
            Iterator it;
            ClassPrepareRequest cpr = em.createClassPrepareRequest();
            cpr.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    cpr.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    cpr.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(cpr);
        } else if (type.equals("unloading")) {
            Iterator it;
            ClassUnloadRequest cur = em.createClassUnloadRequest();
            cur.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    cur.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    cur.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(cur);
        }
        this.app.signalCommandResult(cmd_id, requestID);
    }

    public void doCancelTraceClasses(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(args.remove(0), "request ID"));
        this.app.signalCommandResult(cmd_id);
    }

    public void doTraceMethods(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String type = args.remove(0).toString().toLowerCase();
        if (!type.equals("entry") && !type.equals("exit")) {
            throw new JDEException("Invalid type");
        }
        Object thread = Etc.getThreadFromArgs(args);
        ObjectReference tRef = null;
        if (thread == null) {
            tRef = null;
        } else if (thread instanceof Long) {
            tRef = this.store.get(thread);
            if (tRef == null) {
                throw new JDEException("No such thread exists");
            }
            if (!(tRef instanceof ThreadReference)) {
                throw new JDEException("No such thread exists (anymore?)");
            }
        } else if (thread instanceof String) {
            tRef = ThreadCommands.getThread(this.app.getVM(), thread.toString());
        }
        List classFilters = Etc.getClassFiltersFromArgs(args);
        List classExFilters = Etc.getClassExFiltersFromArgs(args);
        Long requestID = null;
        EventRequestManager em = this.app.getVM().eventRequestManager();
        if (type.equals("entry")) {
            Iterator it;
            MethodEntryRequest mer = em.createMethodEntryRequest();
            if (tRef != null) {
                mer.addThreadFilter((ThreadReference)tRef);
            }
            mer.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(mer);
        } else if (type.equals("exit")) {
            Iterator it;
            MethodExitRequest mer = em.createMethodExitRequest();
            if (tRef != null) {
                mer.addThreadFilter((ThreadReference)tRef);
            }
            mer.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(mer);
        }
        this.app.signalCommandResult(cmd_id, requestID);
    }

    public void doCancelTraceMethods(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(args.remove(0), "request ID"));
        this.app.signalCommandResult(cmd_id);
    }

    public void doGetObject(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(args.remove(0), "object ID");
        ObjectReference oRef = this.store.get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        this.app.signalCommandResult(cmd_id, Rep.getObjectRep(oRef, this.store, true));
    }

    public void doGetLoadedClasses(Integer cmd_id, List args) throws JDEException {
        String typeNames = "(list";
        Iterator<ReferenceType> it = this.app.getVM().allClasses().iterator();
        while (it.hasNext()) {
            typeNames = typeNames + " \"" + it.next().name() + "\"";
        }
        typeNames = typeNames + ")";
        this.app.signalCommandResult(cmd_id, new LispForm(typeNames));
    }

    public void doGetPathInformation(Integer cmd_id, List args) throws JDEException {
        if (!(this.app.getVM() instanceof PathSearchingVirtualMachine)) {
            throw new JDEException("VM doesn't search paths");
        }
        PathSearchingVirtualMachine vm = (PathSearchingVirtualMachine)this.app.getVM();
        String bootClassPathString = "(list";
        Iterator<String> it = vm.bootClassPath().iterator();
        while (it.hasNext()) {
            bootClassPathString = bootClassPathString + " \"" + it.next() + "\"";
        }
        bootClassPathString = bootClassPathString + ")";
        bootClassPathString = bootClassPathString.replace('\\', '/');
        String classPathString = "(list";
        it = vm.classPath().iterator();
        while (it.hasNext()) {
            classPathString = classPathString + " \"" + it.next() + "\"";
        }
        classPathString = classPathString + ")";
        classPathString = classPathString.replace('\\', '/');
        this.app.signalCommandResult(cmd_id, new LispForm("\"" + vm.baseDirectory().replace('\\', '/') + "\"" + Protocol.BR + bootClassPathString + Protocol.BR + classPathString));
    }

    public GeneralCommands(Application a, ObjectStore s) {
        super(a, s);
    }
}

