/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JdeUtilities {
    public static Vector CLASS_LIST = new Vector(500);

    public static void classExists(String fqn) {
        try {
            Class.forName(fqn);
            System.out.println("t");
        }
        catch (NoClassDefFoundError ex1) {
            System.out.println("nil");
        }
        catch (Exception ex2) {
            System.out.println("nil");
        }
    }

    public static void buildClassList() {
        JdeUtilities.buildClassList(System.getProperty("java.class.path"));
    }

    public static void buildClassList(String classPath) {
        StringTokenizer st;
        String extDirs;
        String classPathSeparator = File.pathSeparator;
        CLASS_LIST.setSize(0);
        String classPath2 = System.getProperty("sun.boot.class.path");
        if (classPath2 != null) {
            classPath = classPath + classPathSeparator + classPath2;
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            st = new StringTokenizer(extDirs, classPathSeparator);
            while (st.hasMoreTokens()) {
                File[] extFiles = new File(st.nextToken()).listFiles();
                if (extFiles == null) continue;
                int i = 0;
                while (i < extFiles.length) {
                    classPath = classPath + classPathSeparator + extFiles[i].getPath();
                    ++i;
                }
            }
        }
        st = new StringTokenizer(classPath, classPathSeparator);
        while (st.hasMoreTokens()) {
            String classPathEntry = st.nextToken();
            File classPathFile = new File(classPathEntry);
            if (!classPathFile.exists()) continue;
            if (classPathEntry.toLowerCase().endsWith(".jar")) {
                JdeUtilities.addClassesFromZip(CLASS_LIST, classPathFile);
                continue;
            }
            if (classPathEntry.toLowerCase().endsWith(".zip")) {
                JdeUtilities.addClassesFromZip(CLASS_LIST, classPathFile);
                continue;
            }
            if (!classPathFile.isDirectory()) continue;
            JdeUtilities.addClassesFromDir(CLASS_LIST, classPathFile, classPathFile);
        }
    }

    public static void addClassesFromZip(Vector classList, File classPathFile) {
        try {
            ZipFile zipFile = new ZipFile(classPathFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String current = zipEntry.getName();
                if (!current.toLowerCase().endsWith(".class")) continue;
                current = current.substring(0, current.length() - 6);
                current = current.replace('/', '.');
                current = current.replace('\\', '.');
                classList.addElement(current);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem opening " + classPathFile + " with zip.");
        }
    }

    public static void addClassesFromDir(Vector classList, File rootDir, File currentDir) {
        String[] files = currentDir.list();
        if (files == null) {
            System.err.println("Cannot read contents of " + currentDir + ".");
            return;
        }
        int i = 0;
        while (i < files.length) {
            String current = files[i];
            if (current.toLowerCase().endsWith(".class")) {
                current = current.substring(0, current.length() - 6);
                String rootPath = rootDir.getPath();
                String currentPath = currentDir.getPath();
                if (currentPath.indexOf(rootPath) != 0) {
                    System.err.println("currentPath doesn't start with rootPath!\nrootPath: " + rootPath + "\n" + "currentPath: " + currentPath + "\n");
                } else {
                    String packageName = currentPath.substring(rootPath.length());
                    if (packageName.length() > 0) {
                        packageName = packageName.replace('\\', '.');
                        packageName = packageName.replace('/', '.');
                        classList.addElement(packageName.substring(1) + '.' + current);
                    } else {
                        classList.addElement(current);
                    }
                }
            } else {
                File currentFile = new File(currentDir, current);
                if (currentFile.isDirectory()) {
                    JdeUtilities.addClassesFromDir(classList, rootDir, currentFile);
                }
            }
            ++i;
        }
    }

    public static void getQualifiedName(String className) {
        String qualifiedNameList = "(list";
        int i = 0;
        while (i < CLASS_LIST.size()) {
            String testName = (String)CLASS_LIST.elementAt(i);
            if ((testName.length() > className.length() && testName.endsWith(className) && testName.charAt(testName.length() - className.length() - 1) == '.' || testName.length() == className.length() && testName.equals(className)) && qualifiedNameList.indexOf(testName = " \"" + testName + "\"") == -1) {
                qualifiedNameList = qualifiedNameList + testName;
            }
            ++i;
        }
        qualifiedNameList = qualifiedNameList + ")";
        System.out.println(qualifiedNameList);
        System.out.flush();
    }

    static {
        JdeUtilities.buildClassList();
    }
}

