; -*- coding: iso-2022-7bit  -*-
;;; ujisx0212.el --- tables between UCS and JIS X 0212

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from JIX0212.TXT of Unicode consortium
;;; by MIYASHITA Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'japanese-jisx0212 'unicode-assoc
     'jis-x-0212-vs-unicode-assoc)

(defvar
  jis-x-0212-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
;;; ----------------------------------
      ((?$(D"/(B . "0x02D8") ;; BREVE
       (?$(D"0(B . "0x02C7") ;; CARON (Mandarin Chinese third tone)
       (?$(D"1(B . "0x00B8") ;; CEDILLA
       (?$(D"2(B . "0x02D9") ;; DOT ABOVE (Mandarin Chinese light tone)
       (?$(D"3(B . "0x02DD") ;; DOUBLE ACUTE ACCENT
       (?$(D"4(B . "0x00AF") ;; MACRON
       (?$(D"5(B . "0x02DB") ;; OGONEK
       (?$(D"6(B . "0x02DA") ;; RING ABOVE
       (?$(D"7(B . "0x007E") ;; TILDE
       (?$(D"8(B . "0x0384") ;; GREEK TONOS
       (?$(D"9(B . "0x0385") ;; GREEK DIALYTIKA TONOS
       (?$(D"B(B . "0x00A1") ;; INVERTED EXCLAMATION MARK
       (?$(D"C(B . "0x00A6") ;; BROKEN BAR
       (?$(D"D(B . "0x00BF") ;; INVERTED QUESTION MARK
       (?$(D"k(B . "0x00BA") ;; MASCULINE ORDINAL INDICATOR
       (?$(D"l(B . "0x00AA") ;; FEMININE ORDINAL INDICATOR
       (?$(D"m(B . "0x00A9") ;; COPYRIGHT SIGN
       (?$(D"n(B . "0x00AE") ;; REGISTERED SIGN
       (?$(D"o(B . "0x2122") ;; TRADE MARK SIGN
       (?$(D"p(B . "0x00A4") ;; CURRENCY SIGN
       (?$(D"q(B . "0x2116") ;; NUMERO SIGN
       (?$(D&a(B . "0x0386") ;; GREEK CAPITAL LETTER ALPHA WITH TONOS
       (?$(D&b(B . "0x0388") ;; GREEK CAPITAL LETTER EPSILON WITH TONOS
       (?$(D&c(B . "0x0389") ;; GREEK CAPITAL LETTER ETA WITH TONOS
       (?$(D&d(B . "0x038A") ;; GREEK CAPITAL LETTER IOTA WITH TONOS
       (?$(D&e(B . "0x03AA") ;; GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
       (?$(D&g(B . "0x038C") ;; GREEK CAPITAL LETTER OMICRON WITH TONOS
       (?$(D&i(B . "0x038E") ;; GREEK CAPITAL LETTER UPSILON WITH TONOS
       (?$(D&j(B . "0x03AB") ;; GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
       (?$(D&l(B . "0x038F") ;; GREEK CAPITAL LETTER OMEGA WITH TONOS
       (?$(D&q(B . "0x03AC") ;; GREEK SMALL LETTER ALPHA WITH TONOS
       (?$(D&r(B . "0x03AD") ;; GREEK SMALL LETTER EPSILON WITH TONOS
       (?$(D&s(B . "0x03AE") ;; GREEK SMALL LETTER ETA WITH TONOS
       (?$(D&t(B . "0x03AF") ;; GREEK SMALL LETTER IOTA WITH TONOS
       (?$(D&u(B . "0x03CA") ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA
       (?$(D&v(B . "0x0390") ;; GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
       (?$(D&w(B . "0x03CC") ;; GREEK SMALL LETTER OMICRON WITH TONOS
       (?$(D&x(B . "0x03C2") ;; GREEK SMALL LETTER FINAL SIGMA
       (?$(D&y(B . "0x03CD") ;; GREEK SMALL LETTER UPSILON WITH TONOS
       (?$(D&z(B . "0x03CB") ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA
       (?$(D&{(B . "0x03B0") ;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
       (?$(D&|(B . "0x03CE") ;; GREEK SMALL LETTER OMEGA WITH TONOS
       (?$(D'B(B . "0x0402") ;; CYRILLIC CAPITAL LETTER DJE
       (?$(D'C(B . "0x0403") ;; CYRILLIC CAPITAL LETTER GJE
       (?$(D'D(B . "0x0404") ;; CYRILLIC CAPITAL LETTER UKRAINIAN IE
       (?$(D'E(B . "0x0405") ;; CYRILLIC CAPITAL LETTER DZE
       (?$(D'F(B . "0x0406") ;; CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
       (?$(D'G(B . "0x0407") ;; CYRILLIC CAPITAL LETTER YI
       (?$(D'H(B . "0x0408") ;; CYRILLIC CAPITAL LETTER JE
       (?$(D'I(B . "0x0409") ;; CYRILLIC CAPITAL LETTER LJE
       (?$(D'J(B . "0x040A") ;; CYRILLIC CAPITAL LETTER NJE
       (?$(D'K(B . "0x040B") ;; CYRILLIC CAPITAL LETTER TSHE
       (?$(D'L(B . "0x040C") ;; CYRILLIC CAPITAL LETTER KJE
       (?$(D'M(B . "0x040E") ;; CYRILLIC CAPITAL LETTER SHORT U
       (?$(D'N(B . "0x040F") ;; CYRILLIC CAPITAL LETTER DZHE
       (?$(D'r(B . "0x0452") ;; CYRILLIC SMALL LETTER DJE
       (?$(D's(B . "0x0453") ;; CYRILLIC SMALL LETTER GJE
       (?$(D't(B . "0x0454") ;; CYRILLIC SMALL LETTER UKRAINIAN IE
       (?$(D'u(B . "0x0455") ;; CYRILLIC SMALL LETTER DZE
       (?$(D'v(B . "0x0456") ;; CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
       (?$(D'w(B . "0x0457") ;; CYRILLIC SMALL LETTER YI
       (?$(D'x(B . "0x0458") ;; CYRILLIC SMALL LETTER JE
       (?$(D'y(B . "0x0459") ;; CYRILLIC SMALL LETTER LJE
       (?$(D'z(B . "0x045A") ;; CYRILLIC SMALL LETTER NJE
       (?$(D'{(B . "0x045B") ;; CYRILLIC SMALL LETTER TSHE
       (?$(D'|(B . "0x045C") ;; CYRILLIC SMALL LETTER KJE
       (?$(D'}(B . "0x045E") ;; CYRILLIC SMALL LETTER SHORT U
       (?$(D'~(B . "0x045F") ;; CYRILLIC SMALL LETTER DZHE
       (?$(D)!(B . "0x00C6") ;; LATIN CAPITAL LIGATURE AE
       (?$(D)"(B . "0x0110") ;; LATIN CAPITAL LETTER D WITH STROKE
       (?$(D)$(B . "0x0126") ;; LATIN CAPITAL LETTER H WITH STROKE
       (?$(D)&(B . "0x0132") ;; LATIN CAPITAL LIGATURE IJ
       (?$(D)((B . "0x0141") ;; LATIN CAPITAL LETTER L WITH STROKE
       (?$(D))(B . "0x013F") ;; LATIN CAPITAL LETTER L WITH MIDDLE DOT
       (?$(D)+(B . "0x014A") ;; LATIN CAPITAL LETTER ENG
       (?$(D),(B . "0x00D8") ;; LATIN CAPITAL LETTER O WITH STROKE
       (?$(D)-(B . "0x0152") ;; LATIN CAPITAL LIGATURE OE
       (?$(D)/(B . "0x0166") ;; LATIN CAPITAL LETTER T WITH STROKE
       (?$(D)0(B . "0x00DE") ;; LATIN CAPITAL LETTER THORN
       (?$(D)A(B . "0x00E6") ;; LATIN SMALL LIGATURE AE
       (?$(D)B(B . "0x0111") ;; LATIN SMALL LETTER D WITH STROKE
       (?$(D)C(B . "0x00F0") ;; LATIN SMALL LETTER ETH
       (?$(D)D(B . "0x0127") ;; LATIN SMALL LETTER H WITH STROKE
       (?$(D)E(B . "0x0131") ;; LATIN SMALL LETTER DOTLESS I
       (?$(D)F(B . "0x0133") ;; LATIN SMALL LIGATURE IJ
       (?$(D)G(B . "0x0138") ;; LATIN SMALL LETTER KRA
       (?$(D)H(B . "0x0142") ;; LATIN SMALL LETTER L WITH STROKE
       (?$(D)I(B . "0x0140") ;; LATIN SMALL LETTER L WITH MIDDLE DOT
       (?$(D)J(B . "0x0149") ;; LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
       (?$(D)K(B . "0x014B") ;; LATIN SMALL LETTER ENG
       (?$(D)L(B . "0x00F8") ;; LATIN SMALL LETTER O WITH STROKE
       (?$(D)M(B . "0x0153") ;; LATIN SMALL LIGATURE OE
       (?$(D)N(B . "0x00DF") ;; LATIN SMALL LETTER SHARP S
       (?$(D)O(B . "0x0167") ;; LATIN SMALL LETTER T WITH STROKE
       (?$(D)P(B . "0x00FE") ;; LATIN SMALL LETTER THORN
       (?$(D*!(B . "0x00C1") ;; LATIN CAPITAL LETTER A WITH ACUTE
       (?$(D*"(B . "0x00C0") ;; LATIN CAPITAL LETTER A WITH GRAVE
       (?$(D*#(B . "0x00C4") ;; LATIN CAPITAL LETTER A WITH DIAERESIS
       (?$(D*$(B . "0x00C2") ;; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
       (?$(D*%(B . "0x0102") ;; LATIN CAPITAL LETTER A WITH BREVE
       (?$(D*&(B . "0x01CD") ;; LATIN CAPITAL LETTER A WITH CARON
       (?$(D*'(B . "0x0100") ;; LATIN CAPITAL LETTER A WITH MACRON
       (?$(D*((B . "0x0104") ;; LATIN CAPITAL LETTER A WITH OGONEK
       (?$(D*)(B . "0x00C5") ;; LATIN CAPITAL LETTER A WITH RING ABOVE
       (?$(D**(B . "0x00C3") ;; LATIN CAPITAL LETTER A WITH TILDE
       (?$(D*+(B . "0x0106") ;; LATIN CAPITAL LETTER C WITH ACUTE
       (?$(D*,(B . "0x0108") ;; LATIN CAPITAL LETTER C WITH CIRCUMFLEX
       (?$(D*-(B . "0x010C") ;; LATIN CAPITAL LETTER C WITH CARON
       (?$(D*.(B . "0x00C7") ;; LATIN CAPITAL LETTER C WITH CEDILLA
       (?$(D*/(B . "0x010A") ;; LATIN CAPITAL LETTER C WITH DOT ABOVE
       (?$(D*0(B . "0x010E") ;; LATIN CAPITAL LETTER D WITH CARON
       (?$(D*1(B . "0x00C9") ;; LATIN CAPITAL LETTER E WITH ACUTE
       (?$(D*2(B . "0x00C8") ;; LATIN CAPITAL LETTER E WITH GRAVE
       (?$(D*3(B . "0x00CB") ;; LATIN CAPITAL LETTER E WITH DIAERESIS
       (?$(D*4(B . "0x00CA") ;; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
       (?$(D*5(B . "0x011A") ;; LATIN CAPITAL LETTER E WITH CARON
       (?$(D*6(B . "0x0116") ;; LATIN CAPITAL LETTER E WITH DOT ABOVE
       (?$(D*7(B . "0x0112") ;; LATIN CAPITAL LETTER E WITH MACRON
       (?$(D*8(B . "0x0118") ;; LATIN CAPITAL LETTER E WITH OGONEK
       (?$(D*:(B . "0x011C") ;; LATIN CAPITAL LETTER G WITH CIRCUMFLEX
       (?$(D*;(B . "0x011E") ;; LATIN CAPITAL LETTER G WITH BREVE
       (?$(D*<(B . "0x0122") ;; LATIN CAPITAL LETTER G WITH CEDILLA
       (?$(D*=(B . "0x0120") ;; LATIN CAPITAL LETTER G WITH DOT ABOVE
       (?$(D*>(B . "0x0124") ;; LATIN CAPITAL LETTER H WITH CIRCUMFLEX
       (?$(D*?(B . "0x00CD") ;; LATIN CAPITAL LETTER I WITH ACUTE
       (?$(D*@(B . "0x00CC") ;; LATIN CAPITAL LETTER I WITH GRAVE
       (?$(D*A(B . "0x00CF") ;; LATIN CAPITAL LETTER I WITH DIAERESIS
       (?$(D*B(B . "0x00CE") ;; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
       (?$(D*C(B . "0x01CF") ;; LATIN CAPITAL LETTER I WITH CARON
       (?$(D*D(B . "0x0130") ;; LATIN CAPITAL LETTER I WITH DOT ABOVE
       (?$(D*E(B . "0x012A") ;; LATIN CAPITAL LETTER I WITH MACRON
       (?$(D*F(B . "0x012E") ;; LATIN CAPITAL LETTER I WITH OGONEK
       (?$(D*G(B . "0x0128") ;; LATIN CAPITAL LETTER I WITH TILDE
       (?$(D*H(B . "0x0134") ;; LATIN CAPITAL LETTER J WITH CIRCUMFLEX
       (?$(D*I(B . "0x0136") ;; LATIN CAPITAL LETTER K WITH CEDILLA
       (?$(D*J(B . "0x0139") ;; LATIN CAPITAL LETTER L WITH ACUTE
       (?$(D*K(B . "0x013D") ;; LATIN CAPITAL LETTER L WITH CARON
       (?$(D*L(B . "0x013B") ;; LATIN CAPITAL LETTER L WITH CEDILLA
       (?$(D*M(B . "0x0143") ;; LATIN CAPITAL LETTER N WITH ACUTE
       (?$(D*N(B . "0x0147") ;; LATIN CAPITAL LETTER N WITH CARON
       (?$(D*O(B . "0x0145") ;; LATIN CAPITAL LETTER N WITH CEDILLA
       (?$(D*P(B . "0x00D1") ;; LATIN CAPITAL LETTER N WITH TILDE
       (?$(D*Q(B . "0x00D3") ;; LATIN CAPITAL LETTER O WITH ACUTE
       (?$(D*R(B . "0x00D2") ;; LATIN CAPITAL LETTER O WITH GRAVE
       (?$(D*S(B . "0x00D6") ;; LATIN CAPITAL LETTER O WITH DIAERESIS
       (?$(D*T(B . "0x00D4") ;; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
       (?$(D*U(B . "0x01D1") ;; LATIN CAPITAL LETTER O WITH CARON
       (?$(D*V(B . "0x0150") ;; LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
       (?$(D*W(B . "0x014C") ;; LATIN CAPITAL LETTER O WITH MACRON
       (?$(D*X(B . "0x00D5") ;; LATIN CAPITAL LETTER O WITH TILDE
       (?$(D*Y(B . "0x0154") ;; LATIN CAPITAL LETTER R WITH ACUTE
       (?$(D*Z(B . "0x0158") ;; LATIN CAPITAL LETTER R WITH CARON
       (?$(D*[(B . "0x0156") ;; LATIN CAPITAL LETTER R WITH CEDILLA
       (?$(D*\(B . "0x015A") ;; LATIN CAPITAL LETTER S WITH ACUTE
       (?$(D*](B . "0x015C") ;; LATIN CAPITAL LETTER S WITH CIRCUMFLEX
       (?$(D*^(B . "0x0160") ;; LATIN CAPITAL LETTER S WITH CARON
       (?$(D*_(B . "0x015E") ;; LATIN CAPITAL LETTER S WITH CEDILLA
       (?$(D*`(B . "0x0164") ;; LATIN CAPITAL LETTER T WITH CARON
       (?$(D*a(B . "0x0162") ;; LATIN CAPITAL LETTER T WITH CEDILLA
       (?$(D*b(B . "0x00DA") ;; LATIN CAPITAL LETTER U WITH ACUTE
       (?$(D*c(B . "0x00D9") ;; LATIN CAPITAL LETTER U WITH GRAVE
       (?$(D*d(B . "0x00DC") ;; LATIN CAPITAL LETTER U WITH DIAERESIS
       (?$(D*e(B . "0x00DB") ;; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
       (?$(D*f(B . "0x016C") ;; LATIN CAPITAL LETTER U WITH BREVE
       (?$(D*g(B . "0x01D3") ;; LATIN CAPITAL LETTER U WITH CARON
       (?$(D*h(B . "0x0170") ;; LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
       (?$(D*i(B . "0x016A") ;; LATIN CAPITAL LETTER U WITH MACRON
       (?$(D*j(B . "0x0172") ;; LATIN CAPITAL LETTER U WITH OGONEK
       (?$(D*k(B . "0x016E") ;; LATIN CAPITAL LETTER U WITH RING ABOVE
       (?$(D*l(B . "0x0168") ;; LATIN CAPITAL LETTER U WITH TILDE
       (?$(D*m(B . "0x01D7") ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
       (?$(D*n(B . "0x01DB") ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
       (?$(D*o(B . "0x01D9") ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
       (?$(D*p(B . "0x01D5") ;; LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
       (?$(D*q(B . "0x0174") ;; LATIN CAPITAL LETTER W WITH CIRCUMFLEX
       (?$(D*r(B . "0x00DD") ;; LATIN CAPITAL LETTER Y WITH ACUTE
       (?$(D*s(B . "0x0178") ;; LATIN CAPITAL LETTER Y WITH DIAERESIS
       (?$(D*t(B . "0x0176") ;; LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
       (?$(D*u(B . "0x0179") ;; LATIN CAPITAL LETTER Z WITH ACUTE
       (?$(D*v(B . "0x017D") ;; LATIN CAPITAL LETTER Z WITH CARON
       (?$(D*w(B . "0x017B") ;; LATIN CAPITAL LETTER Z WITH DOT ABOVE
       (?$(D+!(B . "0x00E1") ;; LATIN SMALL LETTER A WITH ACUTE
       (?$(D+"(B . "0x00E0") ;; LATIN SMALL LETTER A WITH GRAVE
       (?$(D+#(B . "0x00E4") ;; LATIN SMALL LETTER A WITH DIAERESIS
       (?$(D+$(B . "0x00E2") ;; LATIN SMALL LETTER A WITH CIRCUMFLEX
       (?$(D+%(B . "0x0103") ;; LATIN SMALL LETTER A WITH BREVE
       (?$(D+&(B . "0x01CE") ;; LATIN SMALL LETTER A WITH CARON
       (?$(D+'(B . "0x0101") ;; LATIN SMALL LETTER A WITH MACRON
       (?$(D+((B . "0x0105") ;; LATIN SMALL LETTER A WITH OGONEK
       (?$(D+)(B . "0x00E5") ;; LATIN SMALL LETTER A WITH RING ABOVE
       (?$(D+*(B . "0x00E3") ;; LATIN SMALL LETTER A WITH TILDE
       (?$(D++(B . "0x0107") ;; LATIN SMALL LETTER C WITH ACUTE
       (?$(D+,(B . "0x0109") ;; LATIN SMALL LETTER C WITH CIRCUMFLEX
       (?$(D+-(B . "0x010D") ;; LATIN SMALL LETTER C WITH CARON
       (?$(D+.(B . "0x00E7") ;; LATIN SMALL LETTER C WITH CEDILLA
       (?$(D+/(B . "0x010B") ;; LATIN SMALL LETTER C WITH DOT ABOVE
       (?$(D+0(B . "0x010F") ;; LATIN SMALL LETTER D WITH CARON
       (?$(D+1(B . "0x00E9") ;; LATIN SMALL LETTER E WITH ACUTE
       (?$(D+2(B . "0x00E8") ;; LATIN SMALL LETTER E WITH GRAVE
       (?$(D+3(B . "0x00EB") ;; LATIN SMALL LETTER E WITH DIAERESIS
       (?$(D+4(B . "0x00EA") ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
       (?$(D+5(B . "0x011B") ;; LATIN SMALL LETTER E WITH CARON
       (?$(D+6(B . "0x0117") ;; LATIN SMALL LETTER E WITH DOT ABOVE
       (?$(D+7(B . "0x0113") ;; LATIN SMALL LETTER E WITH MACRON
       (?$(D+8(B . "0x0119") ;; LATIN SMALL LETTER E WITH OGONEK
       (?$(D+9(B . "0x01F5") ;; LATIN SMALL LETTER G WITH ACUTE
       (?$(D+:(B . "0x011D") ;; LATIN SMALL LETTER G WITH CIRCUMFLEX
       (?$(D+;(B . "0x011F") ;; LATIN SMALL LETTER G WITH BREVE
       (?$(D+=(B . "0x0121") ;; LATIN SMALL LETTER G WITH DOT ABOVE
       (?$(D+>(B . "0x0125") ;; LATIN SMALL LETTER H WITH CIRCUMFLEX
       (?$(D+?(B . "0x00ED") ;; LATIN SMALL LETTER I WITH ACUTE
       (?$(D+@(B . "0x00EC") ;; LATIN SMALL LETTER I WITH GRAVE
       (?$(D+A(B . "0x00EF") ;; LATIN SMALL LETTER I WITH DIAERESIS
       (?$(D+B(B . "0x00EE") ;; LATIN SMALL LETTER I WITH CIRCUMFLEX
       (?$(D+C(B . "0x01D0") ;; LATIN SMALL LETTER I WITH CARON
       (?$(D+E(B . "0x012B") ;; LATIN SMALL LETTER I WITH MACRON
       (?$(D+F(B . "0x012F") ;; LATIN SMALL LETTER I WITH OGONEK
       (?$(D+G(B . "0x0129") ;; LATIN SMALL LETTER I WITH TILDE
       (?$(D+H(B . "0x0135") ;; LATIN SMALL LETTER J WITH CIRCUMFLEX
       (?$(D+I(B . "0x0137") ;; LATIN SMALL LETTER K WITH CEDILLA
       (?$(D+J(B . "0x013A") ;; LATIN SMALL LETTER L WITH ACUTE
       (?$(D+K(B . "0x013E") ;; LATIN SMALL LETTER L WITH CARON
       (?$(D+L(B . "0x013C") ;; LATIN SMALL LETTER L WITH CEDILLA
       (?$(D+M(B . "0x0144") ;; LATIN SMALL LETTER N WITH ACUTE
       (?$(D+N(B . "0x0148") ;; LATIN SMALL LETTER N WITH CARON
       (?$(D+O(B . "0x0146") ;; LATIN SMALL LETTER N WITH CEDILLA
       (?$(D+P(B . "0x00F1") ;; LATIN SMALL LETTER N WITH TILDE
       (?$(D+Q(B . "0x00F3") ;; LATIN SMALL LETTER O WITH ACUTE
       (?$(D+R(B . "0x00F2") ;; LATIN SMALL LETTER O WITH GRAVE
       (?$(D+S(B . "0x00F6") ;; LATIN SMALL LETTER O WITH DIAERESIS
       (?$(D+T(B . "0x00F4") ;; LATIN SMALL LETTER O WITH CIRCUMFLEX
       (?$(D+U(B . "0x01D2") ;; LATIN SMALL LETTER O WITH CARON
       (?$(D+V(B . "0x0151") ;; LATIN SMALL LETTER O WITH DOUBLE ACUTE
       (?$(D+W(B . "0x014D") ;; LATIN SMALL LETTER O WITH MACRON
       (?$(D+X(B . "0x00F5") ;; LATIN SMALL LETTER O WITH TILDE
       (?$(D+Y(B . "0x0155") ;; LATIN SMALL LETTER R WITH ACUTE
       (?$(D+Z(B . "0x0159") ;; LATIN SMALL LETTER R WITH CARON
       (?$(D+[(B . "0x0157") ;; LATIN SMALL LETTER R WITH CEDILLA
       (?$(D+\(B . "0x015B") ;; LATIN SMALL LETTER S WITH ACUTE
       (?$(D+](B . "0x015D") ;; LATIN SMALL LETTER S WITH CIRCUMFLEX
       (?$(D+^(B . "0x0161") ;; LATIN SMALL LETTER S WITH CARON
       (?$(D+_(B . "0x015F") ;; LATIN SMALL LETTER S WITH CEDILLA
       (?$(D+`(B . "0x0165") ;; LATIN SMALL LETTER T WITH CARON
       (?$(D+a(B . "0x0163") ;; LATIN SMALL LETTER T WITH CEDILLA
       (?$(D+b(B . "0x00FA") ;; LATIN SMALL LETTER U WITH ACUTE
       (?$(D+c(B . "0x00F9") ;; LATIN SMALL LETTER U WITH GRAVE
       (?$(D+d(B . "0x00FC") ;; LATIN SMALL LETTER U WITH DIAERESIS
       (?$(D+e(B . "0x00FB") ;; LATIN SMALL LETTER U WITH CIRCUMFLEX
       (?$(D+f(B . "0x016D") ;; LATIN SMALL LETTER U WITH BREVE
       (?$(D+g(B . "0x01D4") ;; LATIN SMALL LETTER U WITH CARON
       (?$(D+h(B . "0x0171") ;; LATIN SMALL LETTER U WITH DOUBLE ACUTE
       (?$(D+i(B . "0x016B") ;; LATIN SMALL LETTER U WITH MACRON
       (?$(D+j(B . "0x0173") ;; LATIN SMALL LETTER U WITH OGONEK
       (?$(D+k(B . "0x016F") ;; LATIN SMALL LETTER U WITH RING ABOVE
       (?$(D+l(B . "0x0169") ;; LATIN SMALL LETTER U WITH TILDE
       (?$(D+m(B . "0x01D8") ;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
       (?$(D+n(B . "0x01DC") ;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
       (?$(D+o(B . "0x01DA") ;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
       (?$(D+p(B . "0x01D6") ;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
       (?$(D+q(B . "0x0175") ;; LATIN SMALL LETTER W WITH CIRCUMFLEX
       (?$(D+r(B . "0x00FD") ;; LATIN SMALL LETTER Y WITH ACUTE
       (?$(D+s(B . "0x00FF") ;; LATIN SMALL LETTER Y WITH DIAERESIS
       (?$(D+t(B . "0x0177") ;; LATIN SMALL LETTER Y WITH CIRCUMFLEX
       (?$(D+u(B . "0x017A") ;; LATIN SMALL LETTER Z WITH ACUTE
       (?$(D+v(B . "0x017E") ;; LATIN SMALL LETTER Z WITH CARON
       (?$(D+w(B . "0x017C") ;; LATIN SMALL LETTER Z WITH DOT ABOVE
;;; ----------------------------------
       (?$(D0!(B . "0x4E02") ;; <CJK>
       (?$(D0"(B . "0x4E04") ;; <CJK>
       (?$(D0#(B . "0x4E05") ;; <CJK>
       (?$(D0$(B . "0x4E0C") ;; <CJK>
       (?$(D0%(B . "0x4E12") ;; <CJK>
       (?$(D0&(B . "0x4E1F") ;; <CJK>
       (?$(D0'(B . "0x4E23") ;; <CJK>
       (?$(D0((B . "0x4E24") ;; <CJK>
       (?$(D0)(B . "0x4E28") ;; <CJK>
       (?$(D0*(B . "0x4E2B") ;; <CJK>
       (?$(D0+(B . "0x4E2E") ;; <CJK>
       (?$(D0,(B . "0x4E2F") ;; <CJK>
       (?$(D0-(B . "0x4E30") ;; <CJK>
       (?$(D0.(B . "0x4E35") ;; <CJK>
       (?$(D0/(B . "0x4E40") ;; <CJK>
       (?$(D00(B . "0x4E41") ;; <CJK>
       (?$(D01(B . "0x4E44") ;; <CJK>
       (?$(D02(B . "0x4E47") ;; <CJK>
       (?$(D03(B . "0x4E51") ;; <CJK>
       (?$(D04(B . "0x4E5A") ;; <CJK>
       (?$(D05(B . "0x4E5C") ;; <CJK>
       (?$(D06(B . "0x4E63") ;; <CJK>
       (?$(D07(B . "0x4E68") ;; <CJK>
       (?$(D08(B . "0x4E69") ;; <CJK>
       (?$(D09(B . "0x4E74") ;; <CJK>
       (?$(D0:(B . "0x4E75") ;; <CJK>
       (?$(D0;(B . "0x4E79") ;; <CJK>
       (?$(D0<(B . "0x4E7F") ;; <CJK>
       (?$(D0=(B . "0x4E8D") ;; <CJK>
       (?$(D0>(B . "0x4E96") ;; <CJK>
       (?$(D0?(B . "0x4E97") ;; <CJK>
       (?$(D0@(B . "0x4E9D") ;; <CJK>
       (?$(D0A(B . "0x4EAF") ;; <CJK>
       (?$(D0B(B . "0x4EB9") ;; <CJK>
       (?$(D0C(B . "0x4EC3") ;; <CJK>
       (?$(D0D(B . "0x4ED0") ;; <CJK>
       (?$(D0E(B . "0x4EDA") ;; <CJK>
       (?$(D0F(B . "0x4EDB") ;; <CJK>
       (?$(D0G(B . "0x4EE0") ;; <CJK>
       (?$(D0H(B . "0x4EE1") ;; <CJK>
       (?$(D0I(B . "0x4EE2") ;; <CJK>
       (?$(D0J(B . "0x4EE8") ;; <CJK>
       (?$(D0K(B . "0x4EEF") ;; <CJK>
       (?$(D0L(B . "0x4EF1") ;; <CJK>
       (?$(D0M(B . "0x4EF3") ;; <CJK>
       (?$(D0N(B . "0x4EF5") ;; <CJK>
       (?$(D0O(B . "0x4EFD") ;; <CJK>
       (?$(D0P(B . "0x4EFE") ;; <CJK>
       (?$(D0Q(B . "0x4EFF") ;; <CJK>
       (?$(D0R(B . "0x4F00") ;; <CJK>
       (?$(D0S(B . "0x4F02") ;; <CJK>
       (?$(D0T(B . "0x4F03") ;; <CJK>
       (?$(D0U(B . "0x4F08") ;; <CJK>
       (?$(D0V(B . "0x4F0B") ;; <CJK>
       (?$(D0W(B . "0x4F0C") ;; <CJK>
       (?$(D0X(B . "0x4F12") ;; <CJK>
       (?$(D0Y(B . "0x4F15") ;; <CJK>
       (?$(D0Z(B . "0x4F16") ;; <CJK>
       (?$(D0[(B . "0x4F17") ;; <CJK>
       (?$(D0\(B . "0x4F19") ;; <CJK>
       (?$(D0](B . "0x4F2E") ;; <CJK>
       (?$(D0^(B . "0x4F31") ;; <CJK>
       (?$(D0_(B . "0x4F60") ;; <CJK>
       (?$(D0`(B . "0x4F33") ;; <CJK>
       (?$(D0a(B . "0x4F35") ;; <CJK>
       (?$(D0b(B . "0x4F37") ;; <CJK>
       (?$(D0c(B . "0x4F39") ;; <CJK>
       (?$(D0d(B . "0x4F3B") ;; <CJK>
       (?$(D0e(B . "0x4F3E") ;; <CJK>
       (?$(D0f(B . "0x4F40") ;; <CJK>
       (?$(D0g(B . "0x4F42") ;; <CJK>
       (?$(D0h(B . "0x4F48") ;; <CJK>
       (?$(D0i(B . "0x4F49") ;; <CJK>
       (?$(D0j(B . "0x4F4B") ;; <CJK>
       (?$(D0k(B . "0x4F4C") ;; <CJK>
       (?$(D0l(B . "0x4F52") ;; <CJK>
       (?$(D0m(B . "0x4F54") ;; <CJK>
       (?$(D0n(B . "0x4F56") ;; <CJK>
       (?$(D0o(B . "0x4F58") ;; <CJK>
       (?$(D0p(B . "0x4F5F") ;; <CJK>
       (?$(D0q(B . "0x4F63") ;; <CJK>
       (?$(D0r(B . "0x4F6A") ;; <CJK>
       (?$(D0s(B . "0x4F6C") ;; <CJK>
       (?$(D0t(B . "0x4F6E") ;; <CJK>
       (?$(D0u(B . "0x4F71") ;; <CJK>
       (?$(D0v(B . "0x4F77") ;; <CJK>
       (?$(D0w(B . "0x4F78") ;; <CJK>
       (?$(D0x(B . "0x4F79") ;; <CJK>
       (?$(D0y(B . "0x4F7A") ;; <CJK>
       (?$(D0z(B . "0x4F7D") ;; <CJK>
       (?$(D0{(B . "0x4F7E") ;; <CJK>
       (?$(D0|(B . "0x4F81") ;; <CJK>
       (?$(D0}(B . "0x4F82") ;; <CJK>
       (?$(D0~(B . "0x4F84") ;; <CJK>
       (?$(D1!(B . "0x4F85") ;; <CJK>
       (?$(D1"(B . "0x4F89") ;; <CJK>
       (?$(D1#(B . "0x4F8A") ;; <CJK>
       (?$(D1$(B . "0x4F8C") ;; <CJK>
       (?$(D1%(B . "0x4F8E") ;; <CJK>
       (?$(D1&(B . "0x4F90") ;; <CJK>
       (?$(D1'(B . "0x4F92") ;; <CJK>
       (?$(D1((B . "0x4F93") ;; <CJK>
       (?$(D1)(B . "0x4F94") ;; <CJK>
       (?$(D1*(B . "0x4F97") ;; <CJK>
       (?$(D1+(B . "0x4F99") ;; <CJK>
       (?$(D1,(B . "0x4F9A") ;; <CJK>
       (?$(D1-(B . "0x4F9E") ;; <CJK>
       (?$(D1.(B . "0x4F9F") ;; <CJK>
       (?$(D1/(B . "0x4FB2") ;; <CJK>
       (?$(D10(B . "0x4FB7") ;; <CJK>
       (?$(D11(B . "0x4FB9") ;; <CJK>
       (?$(D12(B . "0x4FBB") ;; <CJK>
       (?$(D13(B . "0x4FBC") ;; <CJK>
       (?$(D14(B . "0x4FBD") ;; <CJK>
       (?$(D15(B . "0x4FBE") ;; <CJK>
       (?$(D16(B . "0x4FC0") ;; <CJK>
       (?$(D17(B . "0x4FC1") ;; <CJK>
       (?$(D18(B . "0x4FC5") ;; <CJK>
       (?$(D19(B . "0x4FC6") ;; <CJK>
       (?$(D1:(B . "0x4FC8") ;; <CJK>
       (?$(D1;(B . "0x4FC9") ;; <CJK>
       (?$(D1<(B . "0x4FCB") ;; <CJK>
       (?$(D1=(B . "0x4FCC") ;; <CJK>
       (?$(D1>(B . "0x4FCD") ;; <CJK>
       (?$(D1?(B . "0x4FCF") ;; <CJK>
       (?$(D1@(B . "0x4FD2") ;; <CJK>
       (?$(D1A(B . "0x4FDC") ;; <CJK>
       (?$(D1B(B . "0x4FE0") ;; <CJK>
       (?$(D1C(B . "0x4FE2") ;; <CJK>
       (?$(D1D(B . "0x4FF0") ;; <CJK>
       (?$(D1E(B . "0x4FF2") ;; <CJK>
       (?$(D1F(B . "0x4FFC") ;; <CJK>
       (?$(D1G(B . "0x4FFD") ;; <CJK>
       (?$(D1H(B . "0x4FFF") ;; <CJK>
       (?$(D1I(B . "0x5000") ;; <CJK>
       (?$(D1J(B . "0x5001") ;; <CJK>
       (?$(D1K(B . "0x5004") ;; <CJK>
       (?$(D1L(B . "0x5007") ;; <CJK>
       (?$(D1M(B . "0x500A") ;; <CJK>
       (?$(D1N(B . "0x500C") ;; <CJK>
       (?$(D1O(B . "0x500E") ;; <CJK>
       (?$(D1P(B . "0x5010") ;; <CJK>
       (?$(D1Q(B . "0x5013") ;; <CJK>
       (?$(D1R(B . "0x5017") ;; <CJK>
       (?$(D1S(B . "0x5018") ;; <CJK>
       (?$(D1T(B . "0x501B") ;; <CJK>
       (?$(D1U(B . "0x501C") ;; <CJK>
       (?$(D1V(B . "0x501D") ;; <CJK>
       (?$(D1W(B . "0x501E") ;; <CJK>
       (?$(D1X(B . "0x5022") ;; <CJK>
       (?$(D1Y(B . "0x5027") ;; <CJK>
       (?$(D1Z(B . "0x502E") ;; <CJK>
       (?$(D1[(B . "0x5030") ;; <CJK>
       (?$(D1\(B . "0x5032") ;; <CJK>
       (?$(D1](B . "0x5033") ;; <CJK>
       (?$(D1^(B . "0x5035") ;; <CJK>
       (?$(D1_(B . "0x5040") ;; <CJK>
       (?$(D1`(B . "0x5041") ;; <CJK>
       (?$(D1a(B . "0x5042") ;; <CJK>
       (?$(D1b(B . "0x5045") ;; <CJK>
       (?$(D1c(B . "0x5046") ;; <CJK>
       (?$(D1d(B . "0x504A") ;; <CJK>
       (?$(D1e(B . "0x504C") ;; <CJK>
       (?$(D1f(B . "0x504E") ;; <CJK>
       (?$(D1g(B . "0x5051") ;; <CJK>
       (?$(D1h(B . "0x5052") ;; <CJK>
       (?$(D1i(B . "0x5053") ;; <CJK>
       (?$(D1j(B . "0x5057") ;; <CJK>
       (?$(D1k(B . "0x5059") ;; <CJK>
       (?$(D1l(B . "0x505F") ;; <CJK>
       (?$(D1m(B . "0x5060") ;; <CJK>
       (?$(D1n(B . "0x5062") ;; <CJK>
       (?$(D1o(B . "0x5063") ;; <CJK>
       (?$(D1p(B . "0x5066") ;; <CJK>
       (?$(D1q(B . "0x5067") ;; <CJK>
       (?$(D1r(B . "0x506A") ;; <CJK>
       (?$(D1s(B . "0x506D") ;; <CJK>
       (?$(D1t(B . "0x5070") ;; <CJK>
       (?$(D1u(B . "0x5071") ;; <CJK>
       (?$(D1v(B . "0x503B") ;; <CJK>
       (?$(D1w(B . "0x5081") ;; <CJK>
       (?$(D1x(B . "0x5083") ;; <CJK>
       (?$(D1y(B . "0x5084") ;; <CJK>
       (?$(D1z(B . "0x5086") ;; <CJK>
       (?$(D1{(B . "0x508A") ;; <CJK>
       (?$(D1|(B . "0x508E") ;; <CJK>
       (?$(D1}(B . "0x508F") ;; <CJK>
       (?$(D1~(B . "0x5090") ;; <CJK>
       (?$(D2!(B . "0x5092") ;; <CJK>
       (?$(D2"(B . "0x5093") ;; <CJK>
       (?$(D2#(B . "0x5094") ;; <CJK>
       (?$(D2$(B . "0x5096") ;; <CJK>
       (?$(D2%(B . "0x509B") ;; <CJK>
       (?$(D2&(B . "0x509C") ;; <CJK>
       (?$(D2'(B . "0x509E") ;; <CJK>
       (?$(D2((B . "0x509F") ;; <CJK>
       (?$(D2)(B . "0x50A0") ;; <CJK>
       (?$(D2*(B . "0x50A1") ;; <CJK>
       (?$(D2+(B . "0x50A2") ;; <CJK>
       (?$(D2,(B . "0x50AA") ;; <CJK>
       (?$(D2-(B . "0x50AF") ;; <CJK>
       (?$(D2.(B . "0x50B0") ;; <CJK>
       (?$(D2/(B . "0x50B9") ;; <CJK>
       (?$(D20(B . "0x50BA") ;; <CJK>
       (?$(D21(B . "0x50BD") ;; <CJK>
       (?$(D22(B . "0x50C0") ;; <CJK>
       (?$(D23(B . "0x50C3") ;; <CJK>
       (?$(D24(B . "0x50C4") ;; <CJK>
       (?$(D25(B . "0x50C7") ;; <CJK>
       (?$(D26(B . "0x50CC") ;; <CJK>
       (?$(D27(B . "0x50CE") ;; <CJK>
       (?$(D28(B . "0x50D0") ;; <CJK>
       (?$(D29(B . "0x50D3") ;; <CJK>
       (?$(D2:(B . "0x50D4") ;; <CJK>
       (?$(D2;(B . "0x50D8") ;; <CJK>
       (?$(D2<(B . "0x50DC") ;; <CJK>
       (?$(D2=(B . "0x50DD") ;; <CJK>
       (?$(D2>(B . "0x50DF") ;; <CJK>
       (?$(D2?(B . "0x50E2") ;; <CJK>
       (?$(D2@(B . "0x50E4") ;; <CJK>
       (?$(D2A(B . "0x50E6") ;; <CJK>
       (?$(D2B(B . "0x50E8") ;; <CJK>
       (?$(D2C(B . "0x50E9") ;; <CJK>
       (?$(D2D(B . "0x50EF") ;; <CJK>
       (?$(D2E(B . "0x50F1") ;; <CJK>
       (?$(D2F(B . "0x50F6") ;; <CJK>
       (?$(D2G(B . "0x50FA") ;; <CJK>
       (?$(D2H(B . "0x50FE") ;; <CJK>
       (?$(D2I(B . "0x5103") ;; <CJK>
       (?$(D2J(B . "0x5106") ;; <CJK>
       (?$(D2K(B . "0x5107") ;; <CJK>
       (?$(D2L(B . "0x5108") ;; <CJK>
       (?$(D2M(B . "0x510B") ;; <CJK>
       (?$(D2N(B . "0x510C") ;; <CJK>
       (?$(D2O(B . "0x510D") ;; <CJK>
       (?$(D2P(B . "0x510E") ;; <CJK>
       (?$(D2Q(B . "0x50F2") ;; <CJK>
       (?$(D2R(B . "0x5110") ;; <CJK>
       (?$(D2S(B . "0x5117") ;; <CJK>
       (?$(D2T(B . "0x5119") ;; <CJK>
       (?$(D2U(B . "0x511B") ;; <CJK>
       (?$(D2V(B . "0x511C") ;; <CJK>
       (?$(D2W(B . "0x511D") ;; <CJK>
       (?$(D2X(B . "0x511E") ;; <CJK>
       (?$(D2Y(B . "0x5123") ;; <CJK>
       (?$(D2Z(B . "0x5127") ;; <CJK>
       (?$(D2[(B . "0x5128") ;; <CJK>
       (?$(D2\(B . "0x512C") ;; <CJK>
       (?$(D2](B . "0x512D") ;; <CJK>
       (?$(D2^(B . "0x512F") ;; <CJK>
       (?$(D2_(B . "0x5131") ;; <CJK>
       (?$(D2`(B . "0x5133") ;; <CJK>
       (?$(D2a(B . "0x5134") ;; <CJK>
       (?$(D2b(B . "0x5135") ;; <CJK>
       (?$(D2c(B . "0x5138") ;; <CJK>
       (?$(D2d(B . "0x5139") ;; <CJK>
       (?$(D2e(B . "0x5142") ;; <CJK>
       (?$(D2f(B . "0x514A") ;; <CJK>
       (?$(D2g(B . "0x514F") ;; <CJK>
       (?$(D2h(B . "0x5153") ;; <CJK>
       (?$(D2i(B . "0x5155") ;; <CJK>
       (?$(D2j(B . "0x5157") ;; <CJK>
       (?$(D2k(B . "0x5158") ;; <CJK>
       (?$(D2l(B . "0x515F") ;; <CJK>
       (?$(D2m(B . "0x5164") ;; <CJK>
       (?$(D2n(B . "0x5166") ;; <CJK>
       (?$(D2o(B . "0x517E") ;; <CJK>
       (?$(D2p(B . "0x5183") ;; <CJK>
       (?$(D2q(B . "0x5184") ;; <CJK>
       (?$(D2r(B . "0x518B") ;; <CJK>
       (?$(D2s(B . "0x518E") ;; <CJK>
       (?$(D2t(B . "0x5198") ;; <CJK>
       (?$(D2u(B . "0x519D") ;; <CJK>
       (?$(D2v(B . "0x51A1") ;; <CJK>
       (?$(D2w(B . "0x51A3") ;; <CJK>
       (?$(D2x(B . "0x51AD") ;; <CJK>
       (?$(D2y(B . "0x51B8") ;; <CJK>
       (?$(D2z(B . "0x51BA") ;; <CJK>
       (?$(D2{(B . "0x51BC") ;; <CJK>
       (?$(D2|(B . "0x51BE") ;; <CJK>
       (?$(D2}(B . "0x51BF") ;; <CJK>
       (?$(D2~(B . "0x51C2") ;; <CJK>
       (?$(D3!(B . "0x51C8") ;; <CJK>
       (?$(D3"(B . "0x51CF") ;; <CJK>
       (?$(D3#(B . "0x51D1") ;; <CJK>
       (?$(D3$(B . "0x51D2") ;; <CJK>
       (?$(D3%(B . "0x51D3") ;; <CJK>
       (?$(D3&(B . "0x51D5") ;; <CJK>
       (?$(D3'(B . "0x51D8") ;; <CJK>
       (?$(D3((B . "0x51DE") ;; <CJK>
       (?$(D3)(B . "0x51E2") ;; <CJK>
       (?$(D3*(B . "0x51E5") ;; <CJK>
       (?$(D3+(B . "0x51EE") ;; <CJK>
       (?$(D3,(B . "0x51F2") ;; <CJK>
       (?$(D3-(B . "0x51F3") ;; <CJK>
       (?$(D3.(B . "0x51F4") ;; <CJK>
       (?$(D3/(B . "0x51F7") ;; <CJK>
       (?$(D30(B . "0x5201") ;; <CJK>
       (?$(D31(B . "0x5202") ;; <CJK>
       (?$(D32(B . "0x5205") ;; <CJK>
       (?$(D33(B . "0x5212") ;; <CJK>
       (?$(D34(B . "0x5213") ;; <CJK>
       (?$(D35(B . "0x5215") ;; <CJK>
       (?$(D36(B . "0x5216") ;; <CJK>
       (?$(D37(B . "0x5218") ;; <CJK>
       (?$(D38(B . "0x5222") ;; <CJK>
       (?$(D39(B . "0x5228") ;; <CJK>
       (?$(D3:(B . "0x5231") ;; <CJK>
       (?$(D3;(B . "0x5232") ;; <CJK>
       (?$(D3<(B . "0x5235") ;; <CJK>
       (?$(D3=(B . "0x523C") ;; <CJK>
       (?$(D3>(B . "0x5245") ;; <CJK>
       (?$(D3?(B . "0x5249") ;; <CJK>
       (?$(D3@(B . "0x5255") ;; <CJK>
       (?$(D3A(B . "0x5257") ;; <CJK>
       (?$(D3B(B . "0x5258") ;; <CJK>
       (?$(D3C(B . "0x525A") ;; <CJK>
       (?$(D3D(B . "0x525C") ;; <CJK>
       (?$(D3E(B . "0x525F") ;; <CJK>
       (?$(D3F(B . "0x5260") ;; <CJK>
       (?$(D3G(B . "0x5261") ;; <CJK>
       (?$(D3H(B . "0x5266") ;; <CJK>
       (?$(D3I(B . "0x526E") ;; <CJK>
       (?$(D3J(B . "0x5277") ;; <CJK>
       (?$(D3K(B . "0x5278") ;; <CJK>
       (?$(D3L(B . "0x5279") ;; <CJK>
       (?$(D3M(B . "0x5280") ;; <CJK>
       (?$(D3N(B . "0x5282") ;; <CJK>
       (?$(D3O(B . "0x5285") ;; <CJK>
       (?$(D3P(B . "0x528A") ;; <CJK>
       (?$(D3Q(B . "0x528C") ;; <CJK>
       (?$(D3R(B . "0x5293") ;; <CJK>
       (?$(D3S(B . "0x5295") ;; <CJK>
       (?$(D3T(B . "0x5296") ;; <CJK>
       (?$(D3U(B . "0x5297") ;; <CJK>
       (?$(D3V(B . "0x5298") ;; <CJK>
       (?$(D3W(B . "0x529A") ;; <CJK>
       (?$(D3X(B . "0x529C") ;; <CJK>
       (?$(D3Y(B . "0x52A4") ;; <CJK>
       (?$(D3Z(B . "0x52A5") ;; <CJK>
       (?$(D3[(B . "0x52A6") ;; <CJK>
       (?$(D3\(B . "0x52A7") ;; <CJK>
       (?$(D3](B . "0x52AF") ;; <CJK>
       (?$(D3^(B . "0x52B0") ;; <CJK>
       (?$(D3_(B . "0x52B6") ;; <CJK>
       (?$(D3`(B . "0x52B7") ;; <CJK>
       (?$(D3a(B . "0x52B8") ;; <CJK>
       (?$(D3b(B . "0x52BA") ;; <CJK>
       (?$(D3c(B . "0x52BB") ;; <CJK>
       (?$(D3d(B . "0x52BD") ;; <CJK>
       (?$(D3e(B . "0x52C0") ;; <CJK>
       (?$(D3f(B . "0x52C4") ;; <CJK>
       (?$(D3g(B . "0x52C6") ;; <CJK>
       (?$(D3h(B . "0x52C8") ;; <CJK>
       (?$(D3i(B . "0x52CC") ;; <CJK>
       (?$(D3j(B . "0x52CF") ;; <CJK>
       (?$(D3k(B . "0x52D1") ;; <CJK>
       (?$(D3l(B . "0x52D4") ;; <CJK>
       (?$(D3m(B . "0x52D6") ;; <CJK>
       (?$(D3n(B . "0x52DB") ;; <CJK>
       (?$(D3o(B . "0x52DC") ;; <CJK>
       (?$(D3p(B . "0x52E1") ;; <CJK>
       (?$(D3q(B . "0x52E5") ;; <CJK>
       (?$(D3r(B . "0x52E8") ;; <CJK>
       (?$(D3s(B . "0x52E9") ;; <CJK>
       (?$(D3t(B . "0x52EA") ;; <CJK>
       (?$(D3u(B . "0x52EC") ;; <CJK>
       (?$(D3v(B . "0x52F0") ;; <CJK>
       (?$(D3w(B . "0x52F1") ;; <CJK>
       (?$(D3x(B . "0x52F4") ;; <CJK>
       (?$(D3y(B . "0x52F6") ;; <CJK>
       (?$(D3z(B . "0x52F7") ;; <CJK>
       (?$(D3{(B . "0x5300") ;; <CJK>
       (?$(D3|(B . "0x5303") ;; <CJK>
       (?$(D3}(B . "0x530A") ;; <CJK>
       (?$(D3~(B . "0x530B") ;; <CJK>
       (?$(D4!(B . "0x530C") ;; <CJK>
       (?$(D4"(B . "0x5311") ;; <CJK>
       (?$(D4#(B . "0x5313") ;; <CJK>
       (?$(D4$(B . "0x5318") ;; <CJK>
       (?$(D4%(B . "0x531B") ;; <CJK>
       (?$(D4&(B . "0x531C") ;; <CJK>
       (?$(D4'(B . "0x531E") ;; <CJK>
       (?$(D4((B . "0x531F") ;; <CJK>
       (?$(D4)(B . "0x5325") ;; <CJK>
       (?$(D4*(B . "0x5327") ;; <CJK>
       (?$(D4+(B . "0x5328") ;; <CJK>
       (?$(D4,(B . "0x5329") ;; <CJK>
       (?$(D4-(B . "0x532B") ;; <CJK>
       (?$(D4.(B . "0x532C") ;; <CJK>
       (?$(D4/(B . "0x532D") ;; <CJK>
       (?$(D40(B . "0x5330") ;; <CJK>
       (?$(D41(B . "0x5332") ;; <CJK>
       (?$(D42(B . "0x5335") ;; <CJK>
       (?$(D43(B . "0x533C") ;; <CJK>
       (?$(D44(B . "0x533D") ;; <CJK>
       (?$(D45(B . "0x533E") ;; <CJK>
       (?$(D46(B . "0x5342") ;; <CJK>
       (?$(D47(B . "0x534C") ;; <CJK>
       (?$(D48(B . "0x534B") ;; <CJK>
       (?$(D49(B . "0x5359") ;; <CJK>
       (?$(D4:(B . "0x535B") ;; <CJK>
       (?$(D4;(B . "0x5361") ;; <CJK>
       (?$(D4<(B . "0x5363") ;; <CJK>
       (?$(D4=(B . "0x5365") ;; <CJK>
       (?$(D4>(B . "0x536C") ;; <CJK>
       (?$(D4?(B . "0x536D") ;; <CJK>
       (?$(D4@(B . "0x5372") ;; <CJK>
       (?$(D4A(B . "0x5379") ;; <CJK>
       (?$(D4B(B . "0x537E") ;; <CJK>
       (?$(D4C(B . "0x5383") ;; <CJK>
       (?$(D4D(B . "0x5387") ;; <CJK>
       (?$(D4E(B . "0x5388") ;; <CJK>
       (?$(D4F(B . "0x538E") ;; <CJK>
       (?$(D4G(B . "0x5393") ;; <CJK>
       (?$(D4H(B . "0x5394") ;; <CJK>
       (?$(D4I(B . "0x5399") ;; <CJK>
       (?$(D4J(B . "0x539D") ;; <CJK>
       (?$(D4K(B . "0x53A1") ;; <CJK>
       (?$(D4L(B . "0x53A4") ;; <CJK>
       (?$(D4M(B . "0x53AA") ;; <CJK>
       (?$(D4N(B . "0x53AB") ;; <CJK>
       (?$(D4O(B . "0x53AF") ;; <CJK>
       (?$(D4P(B . "0x53B2") ;; <CJK>
       (?$(D4Q(B . "0x53B4") ;; <CJK>
       (?$(D4R(B . "0x53B5") ;; <CJK>
       (?$(D4S(B . "0x53B7") ;; <CJK>
       (?$(D4T(B . "0x53B8") ;; <CJK>
       (?$(D4U(B . "0x53BA") ;; <CJK>
       (?$(D4V(B . "0x53BD") ;; <CJK>
       (?$(D4W(B . "0x53C0") ;; <CJK>
       (?$(D4X(B . "0x53C5") ;; <CJK>
       (?$(D4Y(B . "0x53CF") ;; <CJK>
       (?$(D4Z(B . "0x53D2") ;; <CJK>
       (?$(D4[(B . "0x53D3") ;; <CJK>
       (?$(D4\(B . "0x53D5") ;; <CJK>
       (?$(D4](B . "0x53DA") ;; <CJK>
       (?$(D4^(B . "0x53DD") ;; <CJK>
       (?$(D4_(B . "0x53DE") ;; <CJK>
       (?$(D4`(B . "0x53E0") ;; <CJK>
       (?$(D4a(B . "0x53E6") ;; <CJK>
       (?$(D4b(B . "0x53E7") ;; <CJK>
       (?$(D4c(B . "0x53F5") ;; <CJK>
       (?$(D4d(B . "0x5402") ;; <CJK>
       (?$(D4e(B . "0x5413") ;; <CJK>
       (?$(D4f(B . "0x541A") ;; <CJK>
       (?$(D4g(B . "0x5421") ;; <CJK>
       (?$(D4h(B . "0x5427") ;; <CJK>
       (?$(D4i(B . "0x5428") ;; <CJK>
       (?$(D4j(B . "0x542A") ;; <CJK>
       (?$(D4k(B . "0x542F") ;; <CJK>
       (?$(D4l(B . "0x5431") ;; <CJK>
       (?$(D4m(B . "0x5434") ;; <CJK>
       (?$(D4n(B . "0x5435") ;; <CJK>
       (?$(D4o(B . "0x5443") ;; <CJK>
       (?$(D4p(B . "0x5444") ;; <CJK>
       (?$(D4q(B . "0x5447") ;; <CJK>
       (?$(D4r(B . "0x544D") ;; <CJK>
       (?$(D4s(B . "0x544F") ;; <CJK>
       (?$(D4t(B . "0x545E") ;; <CJK>
       (?$(D4u(B . "0x5462") ;; <CJK>
       (?$(D4v(B . "0x5464") ;; <CJK>
       (?$(D4w(B . "0x5466") ;; <CJK>
       (?$(D4x(B . "0x5467") ;; <CJK>
       (?$(D4y(B . "0x5469") ;; <CJK>
       (?$(D4z(B . "0x546B") ;; <CJK>
       (?$(D4{(B . "0x546D") ;; <CJK>
       (?$(D4|(B . "0x546E") ;; <CJK>
       (?$(D4}(B . "0x5474") ;; <CJK>
       (?$(D4~(B . "0x547F") ;; <CJK>
       (?$(D5!(B . "0x5481") ;; <CJK>
       (?$(D5"(B . "0x5483") ;; <CJK>
       (?$(D5#(B . "0x5485") ;; <CJK>
       (?$(D5$(B . "0x5488") ;; <CJK>
       (?$(D5%(B . "0x5489") ;; <CJK>
       (?$(D5&(B . "0x548D") ;; <CJK>
       (?$(D5'(B . "0x5491") ;; <CJK>
       (?$(D5((B . "0x5495") ;; <CJK>
       (?$(D5)(B . "0x5496") ;; <CJK>
       (?$(D5*(B . "0x549C") ;; <CJK>
       (?$(D5+(B . "0x549F") ;; <CJK>
       (?$(D5,(B . "0x54A1") ;; <CJK>
       (?$(D5-(B . "0x54A6") ;; <CJK>
       (?$(D5.(B . "0x54A7") ;; <CJK>
       (?$(D5/(B . "0x54A9") ;; <CJK>
       (?$(D50(B . "0x54AA") ;; <CJK>
       (?$(D51(B . "0x54AD") ;; <CJK>
       (?$(D52(B . "0x54AE") ;; <CJK>
       (?$(D53(B . "0x54B1") ;; <CJK>
       (?$(D54(B . "0x54B7") ;; <CJK>
       (?$(D55(B . "0x54B9") ;; <CJK>
       (?$(D56(B . "0x54BA") ;; <CJK>
       (?$(D57(B . "0x54BB") ;; <CJK>
       (?$(D58(B . "0x54BF") ;; <CJK>
       (?$(D59(B . "0x54C6") ;; <CJK>
       (?$(D5:(B . "0x54CA") ;; <CJK>
       (?$(D5;(B . "0x54CD") ;; <CJK>
       (?$(D5<(B . "0x54CE") ;; <CJK>
       (?$(D5=(B . "0x54E0") ;; <CJK>
       (?$(D5>(B . "0x54EA") ;; <CJK>
       (?$(D5?(B . "0x54EC") ;; <CJK>
       (?$(D5@(B . "0x54EF") ;; <CJK>
       (?$(D5A(B . "0x54F6") ;; <CJK>
       (?$(D5B(B . "0x54FC") ;; <CJK>
       (?$(D5C(B . "0x54FE") ;; <CJK>
       (?$(D5D(B . "0x54FF") ;; <CJK>
       (?$(D5E(B . "0x5500") ;; <CJK>
       (?$(D5F(B . "0x5501") ;; <CJK>
       (?$(D5G(B . "0x5505") ;; <CJK>
       (?$(D5H(B . "0x5508") ;; <CJK>
       (?$(D5I(B . "0x5509") ;; <CJK>
       (?$(D5J(B . "0x550C") ;; <CJK>
       (?$(D5K(B . "0x550D") ;; <CJK>
       (?$(D5L(B . "0x550E") ;; <CJK>
       (?$(D5M(B . "0x5515") ;; <CJK>
       (?$(D5N(B . "0x552A") ;; <CJK>
       (?$(D5O(B . "0x552B") ;; <CJK>
       (?$(D5P(B . "0x5532") ;; <CJK>
       (?$(D5Q(B . "0x5535") ;; <CJK>
       (?$(D5R(B . "0x5536") ;; <CJK>
       (?$(D5S(B . "0x553B") ;; <CJK>
       (?$(D5T(B . "0x553C") ;; <CJK>
       (?$(D5U(B . "0x553D") ;; <CJK>
       (?$(D5V(B . "0x5541") ;; <CJK>
       (?$(D5W(B . "0x5547") ;; <CJK>
       (?$(D5X(B . "0x5549") ;; <CJK>
       (?$(D5Y(B . "0x554A") ;; <CJK>
       (?$(D5Z(B . "0x554D") ;; <CJK>
       (?$(D5[(B . "0x5550") ;; <CJK>
       (?$(D5\(B . "0x5551") ;; <CJK>
       (?$(D5](B . "0x5558") ;; <CJK>
       (?$(D5^(B . "0x555A") ;; <CJK>
       (?$(D5_(B . "0x555B") ;; <CJK>
       (?$(D5`(B . "0x555E") ;; <CJK>
       (?$(D5a(B . "0x5560") ;; <CJK>
       (?$(D5b(B . "0x5561") ;; <CJK>
       (?$(D5c(B . "0x5564") ;; <CJK>
       (?$(D5d(B . "0x5566") ;; <CJK>
       (?$(D5e(B . "0x557F") ;; <CJK>
       (?$(D5f(B . "0x5581") ;; <CJK>
       (?$(D5g(B . "0x5582") ;; <CJK>
       (?$(D5h(B . "0x5586") ;; <CJK>
       (?$(D5i(B . "0x5588") ;; <CJK>
       (?$(D5j(B . "0x558E") ;; <CJK>
       (?$(D5k(B . "0x558F") ;; <CJK>
       (?$(D5l(B . "0x5591") ;; <CJK>
       (?$(D5m(B . "0x5592") ;; <CJK>
       (?$(D5n(B . "0x5593") ;; <CJK>
       (?$(D5o(B . "0x5594") ;; <CJK>
       (?$(D5p(B . "0x5597") ;; <CJK>
       (?$(D5q(B . "0x55A3") ;; <CJK>
       (?$(D5r(B . "0x55A4") ;; <CJK>
       (?$(D5s(B . "0x55AD") ;; <CJK>
       (?$(D5t(B . "0x55B2") ;; <CJK>
       (?$(D5u(B . "0x55BF") ;; <CJK>
       (?$(D5v(B . "0x55C1") ;; <CJK>
       (?$(D5w(B . "0x55C3") ;; <CJK>
       (?$(D5x(B . "0x55C6") ;; <CJK>
       (?$(D5y(B . "0x55C9") ;; <CJK>
       (?$(D5z(B . "0x55CB") ;; <CJK>
       (?$(D5{(B . "0x55CC") ;; <CJK>
       (?$(D5|(B . "0x55CE") ;; <CJK>
       (?$(D5}(B . "0x55D1") ;; <CJK>
       (?$(D5~(B . "0x55D2") ;; <CJK>
       (?$(D6!(B . "0x55D3") ;; <CJK>
       (?$(D6"(B . "0x55D7") ;; <CJK>
       (?$(D6#(B . "0x55D8") ;; <CJK>
       (?$(D6$(B . "0x55DB") ;; <CJK>
       (?$(D6%(B . "0x55DE") ;; <CJK>
       (?$(D6&(B . "0x55E2") ;; <CJK>
       (?$(D6'(B . "0x55E9") ;; <CJK>
       (?$(D6((B . "0x55F6") ;; <CJK>
       (?$(D6)(B . "0x55FF") ;; <CJK>
       (?$(D6*(B . "0x5605") ;; <CJK>
       (?$(D6+(B . "0x5608") ;; <CJK>
       (?$(D6,(B . "0x560A") ;; <CJK>
       (?$(D6-(B . "0x560D") ;; <CJK>
       (?$(D6.(B . "0x560E") ;; <CJK>
       (?$(D6/(B . "0x560F") ;; <CJK>
       (?$(D60(B . "0x5610") ;; <CJK>
       (?$(D61(B . "0x5611") ;; <CJK>
       (?$(D62(B . "0x5612") ;; <CJK>
       (?$(D63(B . "0x5619") ;; <CJK>
       (?$(D64(B . "0x562C") ;; <CJK>
       (?$(D65(B . "0x5630") ;; <CJK>
       (?$(D66(B . "0x5633") ;; <CJK>
       (?$(D67(B . "0x5635") ;; <CJK>
       (?$(D68(B . "0x5637") ;; <CJK>
       (?$(D69(B . "0x5639") ;; <CJK>
       (?$(D6:(B . "0x563B") ;; <CJK>
       (?$(D6;(B . "0x563C") ;; <CJK>
       (?$(D6<(B . "0x563D") ;; <CJK>
       (?$(D6=(B . "0x563F") ;; <CJK>
       (?$(D6>(B . "0x5640") ;; <CJK>
       (?$(D6?(B . "0x5641") ;; <CJK>
       (?$(D6@(B . "0x5643") ;; <CJK>
       (?$(D6A(B . "0x5644") ;; <CJK>
       (?$(D6B(B . "0x5646") ;; <CJK>
       (?$(D6C(B . "0x5649") ;; <CJK>
       (?$(D6D(B . "0x564B") ;; <CJK>
       (?$(D6E(B . "0x564D") ;; <CJK>
       (?$(D6F(B . "0x564F") ;; <CJK>
       (?$(D6G(B . "0x5654") ;; <CJK>
       (?$(D6H(B . "0x565E") ;; <CJK>
       (?$(D6I(B . "0x5660") ;; <CJK>
       (?$(D6J(B . "0x5661") ;; <CJK>
       (?$(D6K(B . "0x5662") ;; <CJK>
       (?$(D6L(B . "0x5663") ;; <CJK>
       (?$(D6M(B . "0x5666") ;; <CJK>
       (?$(D6N(B . "0x5669") ;; <CJK>
       (?$(D6O(B . "0x566D") ;; <CJK>
       (?$(D6P(B . "0x566F") ;; <CJK>
       (?$(D6Q(B . "0x5671") ;; <CJK>
       (?$(D6R(B . "0x5672") ;; <CJK>
       (?$(D6S(B . "0x5675") ;; <CJK>
       (?$(D6T(B . "0x5684") ;; <CJK>
       (?$(D6U(B . "0x5685") ;; <CJK>
       (?$(D6V(B . "0x5688") ;; <CJK>
       (?$(D6W(B . "0x568B") ;; <CJK>
       (?$(D6X(B . "0x568C") ;; <CJK>
       (?$(D6Y(B . "0x5695") ;; <CJK>
       (?$(D6Z(B . "0x5699") ;; <CJK>
       (?$(D6[(B . "0x569A") ;; <CJK>
       (?$(D6\(B . "0x569D") ;; <CJK>
       (?$(D6](B . "0x569E") ;; <CJK>
       (?$(D6^(B . "0x569F") ;; <CJK>
       (?$(D6_(B . "0x56A6") ;; <CJK>
       (?$(D6`(B . "0x56A7") ;; <CJK>
       (?$(D6a(B . "0x56A8") ;; <CJK>
       (?$(D6b(B . "0x56A9") ;; <CJK>
       (?$(D6c(B . "0x56AB") ;; <CJK>
       (?$(D6d(B . "0x56AC") ;; <CJK>
       (?$(D6e(B . "0x56AD") ;; <CJK>
       (?$(D6f(B . "0x56B1") ;; <CJK>
       (?$(D6g(B . "0x56B3") ;; <CJK>
       (?$(D6h(B . "0x56B7") ;; <CJK>
       (?$(D6i(B . "0x56BE") ;; <CJK>
       (?$(D6j(B . "0x56C5") ;; <CJK>
       (?$(D6k(B . "0x56C9") ;; <CJK>
       (?$(D6l(B . "0x56CA") ;; <CJK>
       (?$(D6m(B . "0x56CB") ;; <CJK>
       (?$(D6n(B . "0x56CF") ;; <CJK>
       (?$(D6o(B . "0x56D0") ;; <CJK>
       (?$(D6p(B . "0x56CC") ;; <CJK>
       (?$(D6q(B . "0x56CD") ;; <CJK>
       (?$(D6r(B . "0x56D9") ;; <CJK>
       (?$(D6s(B . "0x56DC") ;; <CJK>
       (?$(D6t(B . "0x56DD") ;; <CJK>
       (?$(D6u(B . "0x56DF") ;; <CJK>
       (?$(D6v(B . "0x56E1") ;; <CJK>
       (?$(D6w(B . "0x56E4") ;; <CJK>
       (?$(D6x(B . "0x56E5") ;; <CJK>
       (?$(D6y(B . "0x56E6") ;; <CJK>
       (?$(D6z(B . "0x56E7") ;; <CJK>
       (?$(D6{(B . "0x56E8") ;; <CJK>
       (?$(D6|(B . "0x56F1") ;; <CJK>
       (?$(D6}(B . "0x56EB") ;; <CJK>
       (?$(D6~(B . "0x56ED") ;; <CJK>
       (?$(D7!(B . "0x56F6") ;; <CJK>
       (?$(D7"(B . "0x56F7") ;; <CJK>
       (?$(D7#(B . "0x5701") ;; <CJK>
       (?$(D7$(B . "0x5702") ;; <CJK>
       (?$(D7%(B . "0x5707") ;; <CJK>
       (?$(D7&(B . "0x570A") ;; <CJK>
       (?$(D7'(B . "0x570C") ;; <CJK>
       (?$(D7((B . "0x5711") ;; <CJK>
       (?$(D7)(B . "0x5715") ;; <CJK>
       (?$(D7*(B . "0x571A") ;; <CJK>
       (?$(D7+(B . "0x571B") ;; <CJK>
       (?$(D7,(B . "0x571D") ;; <CJK>
       (?$(D7-(B . "0x5720") ;; <CJK>
       (?$(D7.(B . "0x5722") ;; <CJK>
       (?$(D7/(B . "0x5723") ;; <CJK>
       (?$(D70(B . "0x5724") ;; <CJK>
       (?$(D71(B . "0x5725") ;; <CJK>
       (?$(D72(B . "0x5729") ;; <CJK>
       (?$(D73(B . "0x572A") ;; <CJK>
       (?$(D74(B . "0x572C") ;; <CJK>
       (?$(D75(B . "0x572E") ;; <CJK>
       (?$(D76(B . "0x572F") ;; <CJK>
       (?$(D77(B . "0x5733") ;; <CJK>
       (?$(D78(B . "0x5734") ;; <CJK>
       (?$(D79(B . "0x573D") ;; <CJK>
       (?$(D7:(B . "0x573E") ;; <CJK>
       (?$(D7;(B . "0x573F") ;; <CJK>
       (?$(D7<(B . "0x5745") ;; <CJK>
       (?$(D7=(B . "0x5746") ;; <CJK>
       (?$(D7>(B . "0x574C") ;; <CJK>
       (?$(D7?(B . "0x574D") ;; <CJK>
       (?$(D7@(B . "0x5752") ;; <CJK>
       (?$(D7A(B . "0x5762") ;; <CJK>
       (?$(D7B(B . "0x5765") ;; <CJK>
       (?$(D7C(B . "0x5767") ;; <CJK>
       (?$(D7D(B . "0x5768") ;; <CJK>
       (?$(D7E(B . "0x576B") ;; <CJK>
       (?$(D7F(B . "0x576D") ;; <CJK>
       (?$(D7G(B . "0x576E") ;; <CJK>
       (?$(D7H(B . "0x576F") ;; <CJK>
       (?$(D7I(B . "0x5770") ;; <CJK>
       (?$(D7J(B . "0x5771") ;; <CJK>
       (?$(D7K(B . "0x5773") ;; <CJK>
       (?$(D7L(B . "0x5774") ;; <CJK>
       (?$(D7M(B . "0x5775") ;; <CJK>
       (?$(D7N(B . "0x5777") ;; <CJK>
       (?$(D7O(B . "0x5779") ;; <CJK>
       (?$(D7P(B . "0x577A") ;; <CJK>
       (?$(D7Q(B . "0x577B") ;; <CJK>
       (?$(D7R(B . "0x577C") ;; <CJK>
       (?$(D7S(B . "0x577E") ;; <CJK>
       (?$(D7T(B . "0x5781") ;; <CJK>
       (?$(D7U(B . "0x5783") ;; <CJK>
       (?$(D7V(B . "0x578C") ;; <CJK>
       (?$(D7W(B . "0x5794") ;; <CJK>
       (?$(D7X(B . "0x5797") ;; <CJK>
       (?$(D7Y(B . "0x5799") ;; <CJK>
       (?$(D7Z(B . "0x579A") ;; <CJK>
       (?$(D7[(B . "0x579C") ;; <CJK>
       (?$(D7\(B . "0x579D") ;; <CJK>
       (?$(D7](B . "0x579E") ;; <CJK>
       (?$(D7^(B . "0x579F") ;; <CJK>
       (?$(D7_(B . "0x57A1") ;; <CJK>
       (?$(D7`(B . "0x5795") ;; <CJK>
       (?$(D7a(B . "0x57A7") ;; <CJK>
       (?$(D7b(B . "0x57A8") ;; <CJK>
       (?$(D7c(B . "0x57A9") ;; <CJK>
       (?$(D7d(B . "0x57AC") ;; <CJK>
       (?$(D7e(B . "0x57B8") ;; <CJK>
       (?$(D7f(B . "0x57BD") ;; <CJK>
       (?$(D7g(B . "0x57C7") ;; <CJK>
       (?$(D7h(B . "0x57C8") ;; <CJK>
       (?$(D7i(B . "0x57CC") ;; <CJK>
       (?$(D7j(B . "0x57CF") ;; <CJK>
       (?$(D7k(B . "0x57D5") ;; <CJK>
       (?$(D7l(B . "0x57DD") ;; <CJK>
       (?$(D7m(B . "0x57DE") ;; <CJK>
       (?$(D7n(B . "0x57E4") ;; <CJK>
       (?$(D7o(B . "0x57E6") ;; <CJK>
       (?$(D7p(B . "0x57E7") ;; <CJK>
       (?$(D7q(B . "0x57E9") ;; <CJK>
       (?$(D7r(B . "0x57ED") ;; <CJK>
       (?$(D7s(B . "0x57F0") ;; <CJK>
       (?$(D7t(B . "0x57F5") ;; <CJK>
       (?$(D7u(B . "0x57F6") ;; <CJK>
       (?$(D7v(B . "0x57F8") ;; <CJK>
       (?$(D7w(B . "0x57FD") ;; <CJK>
       (?$(D7x(B . "0x57FE") ;; <CJK>
       (?$(D7y(B . "0x57FF") ;; <CJK>
       (?$(D7z(B . "0x5803") ;; <CJK>
       (?$(D7{(B . "0x5804") ;; <CJK>
       (?$(D7|(B . "0x5808") ;; <CJK>
       (?$(D7}(B . "0x5809") ;; <CJK>
       (?$(D7~(B . "0x57E1") ;; <CJK>
       (?$(D8!(B . "0x580C") ;; <CJK>
       (?$(D8"(B . "0x580D") ;; <CJK>
       (?$(D8#(B . "0x581B") ;; <CJK>
       (?$(D8$(B . "0x581E") ;; <CJK>
       (?$(D8%(B . "0x581F") ;; <CJK>
       (?$(D8&(B . "0x5820") ;; <CJK>
       (?$(D8'(B . "0x5826") ;; <CJK>
       (?$(D8((B . "0x5827") ;; <CJK>
       (?$(D8)(B . "0x582D") ;; <CJK>
       (?$(D8*(B . "0x5832") ;; <CJK>
       (?$(D8+(B . "0x5839") ;; <CJK>
       (?$(D8,(B . "0x583F") ;; <CJK>
       (?$(D8-(B . "0x5849") ;; <CJK>
       (?$(D8.(B . "0x584C") ;; <CJK>
       (?$(D8/(B . "0x584D") ;; <CJK>
       (?$(D80(B . "0x584F") ;; <CJK>
       (?$(D81(B . "0x5850") ;; <CJK>
       (?$(D82(B . "0x5855") ;; <CJK>
       (?$(D83(B . "0x585F") ;; <CJK>
       (?$(D84(B . "0x5861") ;; <CJK>
       (?$(D85(B . "0x5864") ;; <CJK>
       (?$(D86(B . "0x5867") ;; <CJK>
       (?$(D87(B . "0x5868") ;; <CJK>
       (?$(D88(B . "0x5878") ;; <CJK>
       (?$(D89(B . "0x587C") ;; <CJK>
       (?$(D8:(B . "0x587F") ;; <CJK>
       (?$(D8;(B . "0x5880") ;; <CJK>
       (?$(D8<(B . "0x5881") ;; <CJK>
       (?$(D8=(B . "0x5887") ;; <CJK>
       (?$(D8>(B . "0x5888") ;; <CJK>
       (?$(D8?(B . "0x5889") ;; <CJK>
       (?$(D8@(B . "0x588A") ;; <CJK>
       (?$(D8A(B . "0x588C") ;; <CJK>
       (?$(D8B(B . "0x588D") ;; <CJK>
       (?$(D8C(B . "0x588F") ;; <CJK>
       (?$(D8D(B . "0x5890") ;; <CJK>
       (?$(D8E(B . "0x5894") ;; <CJK>
       (?$(D8F(B . "0x5896") ;; <CJK>
       (?$(D8G(B . "0x589D") ;; <CJK>
       (?$(D8H(B . "0x58A0") ;; <CJK>
       (?$(D8I(B . "0x58A1") ;; <CJK>
       (?$(D8J(B . "0x58A2") ;; <CJK>
       (?$(D8K(B . "0x58A6") ;; <CJK>
       (?$(D8L(B . "0x58A9") ;; <CJK>
       (?$(D8M(B . "0x58B1") ;; <CJK>
       (?$(D8N(B . "0x58B2") ;; <CJK>
       (?$(D8O(B . "0x58C4") ;; <CJK>
       (?$(D8P(B . "0x58BC") ;; <CJK>
       (?$(D8Q(B . "0x58C2") ;; <CJK>
       (?$(D8R(B . "0x58C8") ;; <CJK>
       (?$(D8S(B . "0x58CD") ;; <CJK>
       (?$(D8T(B . "0x58CE") ;; <CJK>
       (?$(D8U(B . "0x58D0") ;; <CJK>
       (?$(D8V(B . "0x58D2") ;; <CJK>
       (?$(D8W(B . "0x58D4") ;; <CJK>
       (?$(D8X(B . "0x58D6") ;; <CJK>
       (?$(D8Y(B . "0x58DA") ;; <CJK>
       (?$(D8Z(B . "0x58DD") ;; <CJK>
       (?$(D8[(B . "0x58E1") ;; <CJK>
       (?$(D8\(B . "0x58E2") ;; <CJK>
       (?$(D8](B . "0x58E9") ;; <CJK>
       (?$(D8^(B . "0x58F3") ;; <CJK>
       (?$(D8_(B . "0x5905") ;; <CJK>
       (?$(D8`(B . "0x5906") ;; <CJK>
       (?$(D8a(B . "0x590B") ;; <CJK>
       (?$(D8b(B . "0x590C") ;; <CJK>
       (?$(D8c(B . "0x5912") ;; <CJK>
       (?$(D8d(B . "0x5913") ;; <CJK>
       (?$(D8e(B . "0x5914") ;; <CJK>
       (?$(D8f(B . "0x8641") ;; <CJK>
       (?$(D8g(B . "0x591D") ;; <CJK>
       (?$(D8h(B . "0x5921") ;; <CJK>
       (?$(D8i(B . "0x5923") ;; <CJK>
       (?$(D8j(B . "0x5924") ;; <CJK>
       (?$(D8k(B . "0x5928") ;; <CJK>
       (?$(D8l(B . "0x592F") ;; <CJK>
       (?$(D8m(B . "0x5930") ;; <CJK>
       (?$(D8n(B . "0x5933") ;; <CJK>
       (?$(D8o(B . "0x5935") ;; <CJK>
       (?$(D8p(B . "0x5936") ;; <CJK>
       (?$(D8q(B . "0x593F") ;; <CJK>
       (?$(D8r(B . "0x5943") ;; <CJK>
       (?$(D8s(B . "0x5946") ;; <CJK>
       (?$(D8t(B . "0x5952") ;; <CJK>
       (?$(D8u(B . "0x5953") ;; <CJK>
       (?$(D8v(B . "0x5959") ;; <CJK>
       (?$(D8w(B . "0x595B") ;; <CJK>
       (?$(D8x(B . "0x595D") ;; <CJK>
       (?$(D8y(B . "0x595E") ;; <CJK>
       (?$(D8z(B . "0x595F") ;; <CJK>
       (?$(D8{(B . "0x5961") ;; <CJK>
       (?$(D8|(B . "0x5963") ;; <CJK>
       (?$(D8}(B . "0x596B") ;; <CJK>
       (?$(D8~(B . "0x596D") ;; <CJK>
       (?$(D9!(B . "0x596F") ;; <CJK>
       (?$(D9"(B . "0x5972") ;; <CJK>
       (?$(D9#(B . "0x5975") ;; <CJK>
       (?$(D9$(B . "0x5976") ;; <CJK>
       (?$(D9%(B . "0x5979") ;; <CJK>
       (?$(D9&(B . "0x597B") ;; <CJK>
       (?$(D9'(B . "0x597C") ;; <CJK>
       (?$(D9((B . "0x598B") ;; <CJK>
       (?$(D9)(B . "0x598C") ;; <CJK>
       (?$(D9*(B . "0x598E") ;; <CJK>
       (?$(D9+(B . "0x5992") ;; <CJK>
       (?$(D9,(B . "0x5995") ;; <CJK>
       (?$(D9-(B . "0x5997") ;; <CJK>
       (?$(D9.(B . "0x599F") ;; <CJK>
       (?$(D9/(B . "0x59A4") ;; <CJK>
       (?$(D90(B . "0x59A7") ;; <CJK>
       (?$(D91(B . "0x59AD") ;; <CJK>
       (?$(D92(B . "0x59AE") ;; <CJK>
       (?$(D93(B . "0x59AF") ;; <CJK>
       (?$(D94(B . "0x59B0") ;; <CJK>
       (?$(D95(B . "0x59B3") ;; <CJK>
       (?$(D96(B . "0x59B7") ;; <CJK>
       (?$(D97(B . "0x59BA") ;; <CJK>
       (?$(D98(B . "0x59BC") ;; <CJK>
       (?$(D99(B . "0x59C1") ;; <CJK>
       (?$(D9:(B . "0x59C3") ;; <CJK>
       (?$(D9;(B . "0x59C4") ;; <CJK>
       (?$(D9<(B . "0x59C8") ;; <CJK>
       (?$(D9=(B . "0x59CA") ;; <CJK>
       (?$(D9>(B . "0x59CD") ;; <CJK>
       (?$(D9?(B . "0x59D2") ;; <CJK>
       (?$(D9@(B . "0x59DD") ;; <CJK>
       (?$(D9A(B . "0x59DE") ;; <CJK>
       (?$(D9B(B . "0x59DF") ;; <CJK>
       (?$(D9C(B . "0x59E3") ;; <CJK>
       (?$(D9D(B . "0x59E4") ;; <CJK>
       (?$(D9E(B . "0x59E7") ;; <CJK>
       (?$(D9F(B . "0x59EE") ;; <CJK>
       (?$(D9G(B . "0x59EF") ;; <CJK>
       (?$(D9H(B . "0x59F1") ;; <CJK>
       (?$(D9I(B . "0x59F2") ;; <CJK>
       (?$(D9J(B . "0x59F4") ;; <CJK>
       (?$(D9K(B . "0x59F7") ;; <CJK>
       (?$(D9L(B . "0x5A00") ;; <CJK>
       (?$(D9M(B . "0x5A04") ;; <CJK>
       (?$(D9N(B . "0x5A0C") ;; <CJK>
       (?$(D9O(B . "0x5A0D") ;; <CJK>
       (?$(D9P(B . "0x5A0E") ;; <CJK>
       (?$(D9Q(B . "0x5A12") ;; <CJK>
       (?$(D9R(B . "0x5A13") ;; <CJK>
       (?$(D9S(B . "0x5A1E") ;; <CJK>
       (?$(D9T(B . "0x5A23") ;; <CJK>
       (?$(D9U(B . "0x5A24") ;; <CJK>
       (?$(D9V(B . "0x5A27") ;; <CJK>
       (?$(D9W(B . "0x5A28") ;; <CJK>
       (?$(D9X(B . "0x5A2A") ;; <CJK>
       (?$(D9Y(B . "0x5A2D") ;; <CJK>
       (?$(D9Z(B . "0x5A30") ;; <CJK>
       (?$(D9[(B . "0x5A44") ;; <CJK>
       (?$(D9\(B . "0x5A45") ;; <CJK>
       (?$(D9](B . "0x5A47") ;; <CJK>
       (?$(D9^(B . "0x5A48") ;; <CJK>
       (?$(D9_(B . "0x5A4C") ;; <CJK>
       (?$(D9`(B . "0x5A50") ;; <CJK>
       (?$(D9a(B . "0x5A55") ;; <CJK>
       (?$(D9b(B . "0x5A5E") ;; <CJK>
       (?$(D9c(B . "0x5A63") ;; <CJK>
       (?$(D9d(B . "0x5A65") ;; <CJK>
       (?$(D9e(B . "0x5A67") ;; <CJK>
       (?$(D9f(B . "0x5A6D") ;; <CJK>
       (?$(D9g(B . "0x5A77") ;; <CJK>
       (?$(D9h(B . "0x5A7A") ;; <CJK>
       (?$(D9i(B . "0x5A7B") ;; <CJK>
       (?$(D9j(B . "0x5A7E") ;; <CJK>
       (?$(D9k(B . "0x5A8B") ;; <CJK>
       (?$(D9l(B . "0x5A90") ;; <CJK>
       (?$(D9m(B . "0x5A93") ;; <CJK>
       (?$(D9n(B . "0x5A96") ;; <CJK>
       (?$(D9o(B . "0x5A99") ;; <CJK>
       (?$(D9p(B . "0x5A9C") ;; <CJK>
       (?$(D9q(B . "0x5A9E") ;; <CJK>
       (?$(D9r(B . "0x5A9F") ;; <CJK>
       (?$(D9s(B . "0x5AA0") ;; <CJK>
       (?$(D9t(B . "0x5AA2") ;; <CJK>
       (?$(D9u(B . "0x5AA7") ;; <CJK>
       (?$(D9v(B . "0x5AAC") ;; <CJK>
       (?$(D9w(B . "0x5AB1") ;; <CJK>
       (?$(D9x(B . "0x5AB2") ;; <CJK>
       (?$(D9y(B . "0x5AB3") ;; <CJK>
       (?$(D9z(B . "0x5AB5") ;; <CJK>
       (?$(D9{(B . "0x5AB8") ;; <CJK>
       (?$(D9|(B . "0x5ABA") ;; <CJK>
       (?$(D9}(B . "0x5ABB") ;; <CJK>
       (?$(D9~(B . "0x5ABF") ;; <CJK>
       (?$(D:!(B . "0x5AC4") ;; <CJK>
       (?$(D:"(B . "0x5AC6") ;; <CJK>
       (?$(D:#(B . "0x5AC8") ;; <CJK>
       (?$(D:$(B . "0x5ACF") ;; <CJK>
       (?$(D:%(B . "0x5ADA") ;; <CJK>
       (?$(D:&(B . "0x5ADC") ;; <CJK>
       (?$(D:'(B . "0x5AE0") ;; <CJK>
       (?$(D:((B . "0x5AE5") ;; <CJK>
       (?$(D:)(B . "0x5AEA") ;; <CJK>
       (?$(D:*(B . "0x5AEE") ;; <CJK>
       (?$(D:+(B . "0x5AF5") ;; <CJK>
       (?$(D:,(B . "0x5AF6") ;; <CJK>
       (?$(D:-(B . "0x5AFD") ;; <CJK>
       (?$(D:.(B . "0x5B00") ;; <CJK>
       (?$(D:/(B . "0x5B01") ;; <CJK>
       (?$(D:0(B . "0x5B08") ;; <CJK>
       (?$(D:1(B . "0x5B17") ;; <CJK>
       (?$(D:2(B . "0x5B34") ;; <CJK>
       (?$(D:3(B . "0x5B19") ;; <CJK>
       (?$(D:4(B . "0x5B1B") ;; <CJK>
       (?$(D:5(B . "0x5B1D") ;; <CJK>
       (?$(D:6(B . "0x5B21") ;; <CJK>
       (?$(D:7(B . "0x5B25") ;; <CJK>
       (?$(D:8(B . "0x5B2D") ;; <CJK>
       (?$(D:9(B . "0x5B38") ;; <CJK>
       (?$(D::(B . "0x5B41") ;; <CJK>
       (?$(D:;(B . "0x5B4B") ;; <CJK>
       (?$(D:<(B . "0x5B4C") ;; <CJK>
       (?$(D:=(B . "0x5B52") ;; <CJK>
       (?$(D:>(B . "0x5B56") ;; <CJK>
       (?$(D:?(B . "0x5B5E") ;; <CJK>
       (?$(D:@(B . "0x5B68") ;; <CJK>
       (?$(D:A(B . "0x5B6E") ;; <CJK>
       (?$(D:B(B . "0x5B6F") ;; <CJK>
       (?$(D:C(B . "0x5B7C") ;; <CJK>
       (?$(D:D(B . "0x5B7D") ;; <CJK>
       (?$(D:E(B . "0x5B7E") ;; <CJK>
       (?$(D:F(B . "0x5B7F") ;; <CJK>
       (?$(D:G(B . "0x5B81") ;; <CJK>
       (?$(D:H(B . "0x5B84") ;; <CJK>
       (?$(D:I(B . "0x5B86") ;; <CJK>
       (?$(D:J(B . "0x5B8A") ;; <CJK>
       (?$(D:K(B . "0x5B8E") ;; <CJK>
       (?$(D:L(B . "0x5B90") ;; <CJK>
       (?$(D:M(B . "0x5B91") ;; <CJK>
       (?$(D:N(B . "0x5B93") ;; <CJK>
       (?$(D:O(B . "0x5B94") ;; <CJK>
       (?$(D:P(B . "0x5B96") ;; <CJK>
       (?$(D:Q(B . "0x5BA8") ;; <CJK>
       (?$(D:R(B . "0x5BA9") ;; <CJK>
       (?$(D:S(B . "0x5BAC") ;; <CJK>
       (?$(D:T(B . "0x5BAD") ;; <CJK>
       (?$(D:U(B . "0x5BAF") ;; <CJK>
       (?$(D:V(B . "0x5BB1") ;; <CJK>
       (?$(D:W(B . "0x5BB2") ;; <CJK>
       (?$(D:X(B . "0x5BB7") ;; <CJK>
       (?$(D:Y(B . "0x5BBA") ;; <CJK>
       (?$(D:Z(B . "0x5BBC") ;; <CJK>
       (?$(D:[(B . "0x5BC0") ;; <CJK>
       (?$(D:\(B . "0x5BC1") ;; <CJK>
       (?$(D:](B . "0x5BCD") ;; <CJK>
       (?$(D:^(B . "0x5BCF") ;; <CJK>
       (?$(D:_(B . "0x5BD6") ;; <CJK>
       (?$(D:`(B . "0x5BD7") ;; <CJK>
       (?$(D:a(B . "0x5BD8") ;; <CJK>
       (?$(D:b(B . "0x5BD9") ;; <CJK>
       (?$(D:c(B . "0x5BDA") ;; <CJK>
       (?$(D:d(B . "0x5BE0") ;; <CJK>
       (?$(D:e(B . "0x5BEF") ;; <CJK>
       (?$(D:f(B . "0x5BF1") ;; <CJK>
       (?$(D:g(B . "0x5BF4") ;; <CJK>
       (?$(D:h(B . "0x5BFD") ;; <CJK>
       (?$(D:i(B . "0x5C0C") ;; <CJK>
       (?$(D:j(B . "0x5C17") ;; <CJK>
       (?$(D:k(B . "0x5C1E") ;; <CJK>
       (?$(D:l(B . "0x5C1F") ;; <CJK>
       (?$(D:m(B . "0x5C23") ;; <CJK>
       (?$(D:n(B . "0x5C26") ;; <CJK>
       (?$(D:o(B . "0x5C29") ;; <CJK>
       (?$(D:p(B . "0x5C2B") ;; <CJK>
       (?$(D:q(B . "0x5C2C") ;; <CJK>
       (?$(D:r(B . "0x5C2E") ;; <CJK>
       (?$(D:s(B . "0x5C30") ;; <CJK>
       (?$(D:t(B . "0x5C32") ;; <CJK>
       (?$(D:u(B . "0x5C35") ;; <CJK>
       (?$(D:v(B . "0x5C36") ;; <CJK>
       (?$(D:w(B . "0x5C59") ;; <CJK>
       (?$(D:x(B . "0x5C5A") ;; <CJK>
       (?$(D:y(B . "0x5C5C") ;; <CJK>
       (?$(D:z(B . "0x5C62") ;; <CJK>
       (?$(D:{(B . "0x5C63") ;; <CJK>
       (?$(D:|(B . "0x5C67") ;; <CJK>
       (?$(D:}(B . "0x5C68") ;; <CJK>
       (?$(D:~(B . "0x5C69") ;; <CJK>
       (?$(D;!(B . "0x5C6D") ;; <CJK>
       (?$(D;"(B . "0x5C70") ;; <CJK>
       (?$(D;#(B . "0x5C74") ;; <CJK>
       (?$(D;$(B . "0x5C75") ;; <CJK>
       (?$(D;%(B . "0x5C7A") ;; <CJK>
       (?$(D;&(B . "0x5C7B") ;; <CJK>
       (?$(D;'(B . "0x5C7C") ;; <CJK>
       (?$(D;((B . "0x5C7D") ;; <CJK>
       (?$(D;)(B . "0x5C87") ;; <CJK>
       (?$(D;*(B . "0x5C88") ;; <CJK>
       (?$(D;+(B . "0x5C8A") ;; <CJK>
       (?$(D;,(B . "0x5C8F") ;; <CJK>
       (?$(D;-(B . "0x5C92") ;; <CJK>
       (?$(D;.(B . "0x5C9D") ;; <CJK>
       (?$(D;/(B . "0x5C9F") ;; <CJK>
       (?$(D;0(B . "0x5CA0") ;; <CJK>
       (?$(D;1(B . "0x5CA2") ;; <CJK>
       (?$(D;2(B . "0x5CA3") ;; <CJK>
       (?$(D;3(B . "0x5CA6") ;; <CJK>
       (?$(D;4(B . "0x5CAA") ;; <CJK>
       (?$(D;5(B . "0x5CB2") ;; <CJK>
       (?$(D;6(B . "0x5CB4") ;; <CJK>
       (?$(D;7(B . "0x5CB5") ;; <CJK>
       (?$(D;8(B . "0x5CBA") ;; <CJK>
       (?$(D;9(B . "0x5CC9") ;; <CJK>
       (?$(D;:(B . "0x5CCB") ;; <CJK>
       (?$(D;;(B . "0x5CD2") ;; <CJK>
       (?$(D;<(B . "0x5CDD") ;; <CJK>
       (?$(D;=(B . "0x5CD7") ;; <CJK>
       (?$(D;>(B . "0x5CEE") ;; <CJK>
       (?$(D;?(B . "0x5CF1") ;; <CJK>
       (?$(D;@(B . "0x5CF2") ;; <CJK>
       (?$(D;A(B . "0x5CF4") ;; <CJK>
       (?$(D;B(B . "0x5D01") ;; <CJK>
       (?$(D;C(B . "0x5D06") ;; <CJK>
       (?$(D;D(B . "0x5D0D") ;; <CJK>
       (?$(D;E(B . "0x5D12") ;; <CJK>
       (?$(D;F(B . "0x5D2B") ;; <CJK>
       (?$(D;G(B . "0x5D23") ;; <CJK>
       (?$(D;H(B . "0x5D24") ;; <CJK>
       (?$(D;I(B . "0x5D26") ;; <CJK>
       (?$(D;J(B . "0x5D27") ;; <CJK>
       (?$(D;K(B . "0x5D31") ;; <CJK>
       (?$(D;L(B . "0x5D34") ;; <CJK>
       (?$(D;M(B . "0x5D39") ;; <CJK>
       (?$(D;N(B . "0x5D3D") ;; <CJK>
       (?$(D;O(B . "0x5D3F") ;; <CJK>
       (?$(D;P(B . "0x5D42") ;; <CJK>
       (?$(D;Q(B . "0x5D43") ;; <CJK>
       (?$(D;R(B . "0x5D46") ;; <CJK>
       (?$(D;S(B . "0x5D48") ;; <CJK>
       (?$(D;T(B . "0x5D55") ;; <CJK>
       (?$(D;U(B . "0x5D51") ;; <CJK>
       (?$(D;V(B . "0x5D59") ;; <CJK>
       (?$(D;W(B . "0x5D4A") ;; <CJK>
       (?$(D;X(B . "0x5D5F") ;; <CJK>
       (?$(D;Y(B . "0x5D60") ;; <CJK>
       (?$(D;Z(B . "0x5D61") ;; <CJK>
       (?$(D;[(B . "0x5D62") ;; <CJK>
       (?$(D;\(B . "0x5D64") ;; <CJK>
       (?$(D;](B . "0x5D6A") ;; <CJK>
       (?$(D;^(B . "0x5D6D") ;; <CJK>
       (?$(D;_(B . "0x5D70") ;; <CJK>
       (?$(D;`(B . "0x5D79") ;; <CJK>
       (?$(D;a(B . "0x5D7A") ;; <CJK>
       (?$(D;b(B . "0x5D7E") ;; <CJK>
       (?$(D;c(B . "0x5D7F") ;; <CJK>
       (?$(D;d(B . "0x5D81") ;; <CJK>
       (?$(D;e(B . "0x5D83") ;; <CJK>
       (?$(D;f(B . "0x5D88") ;; <CJK>
       (?$(D;g(B . "0x5D8A") ;; <CJK>
       (?$(D;h(B . "0x5D92") ;; <CJK>
       (?$(D;i(B . "0x5D93") ;; <CJK>
       (?$(D;j(B . "0x5D94") ;; <CJK>
       (?$(D;k(B . "0x5D95") ;; <CJK>
       (?$(D;l(B . "0x5D99") ;; <CJK>
       (?$(D;m(B . "0x5D9B") ;; <CJK>
       (?$(D;n(B . "0x5D9F") ;; <CJK>
       (?$(D;o(B . "0x5DA0") ;; <CJK>
       (?$(D;p(B . "0x5DA7") ;; <CJK>
       (?$(D;q(B . "0x5DAB") ;; <CJK>
       (?$(D;r(B . "0x5DB0") ;; <CJK>
       (?$(D;s(B . "0x5DB4") ;; <CJK>
       (?$(D;t(B . "0x5DB8") ;; <CJK>
       (?$(D;u(B . "0x5DB9") ;; <CJK>
       (?$(D;v(B . "0x5DC3") ;; <CJK>
       (?$(D;w(B . "0x5DC7") ;; <CJK>
       (?$(D;x(B . "0x5DCB") ;; <CJK>
       (?$(D;y(B . "0x5DD0") ;; <CJK>
       (?$(D;z(B . "0x5DCE") ;; <CJK>
       (?$(D;{(B . "0x5DD8") ;; <CJK>
       (?$(D;|(B . "0x5DD9") ;; <CJK>
       (?$(D;}(B . "0x5DE0") ;; <CJK>
       (?$(D;~(B . "0x5DE4") ;; <CJK>
       (?$(D<!(B . "0x5DE9") ;; <CJK>
       (?$(D<"(B . "0x5DF8") ;; <CJK>
       (?$(D<#(B . "0x5DF9") ;; <CJK>
       (?$(D<$(B . "0x5E00") ;; <CJK>
       (?$(D<%(B . "0x5E07") ;; <CJK>
       (?$(D<&(B . "0x5E0D") ;; <CJK>
       (?$(D<'(B . "0x5E12") ;; <CJK>
       (?$(D<((B . "0x5E14") ;; <CJK>
       (?$(D<)(B . "0x5E15") ;; <CJK>
       (?$(D<*(B . "0x5E18") ;; <CJK>
       (?$(D<+(B . "0x5E1F") ;; <CJK>
       (?$(D<,(B . "0x5E20") ;; <CJK>
       (?$(D<-(B . "0x5E2E") ;; <CJK>
       (?$(D<.(B . "0x5E28") ;; <CJK>
       (?$(D</(B . "0x5E32") ;; <CJK>
       (?$(D<0(B . "0x5E35") ;; <CJK>
       (?$(D<1(B . "0x5E3E") ;; <CJK>
       (?$(D<2(B . "0x5E4B") ;; <CJK>
       (?$(D<3(B . "0x5E50") ;; <CJK>
       (?$(D<4(B . "0x5E49") ;; <CJK>
       (?$(D<5(B . "0x5E51") ;; <CJK>
       (?$(D<6(B . "0x5E56") ;; <CJK>
       (?$(D<7(B . "0x5E58") ;; <CJK>
       (?$(D<8(B . "0x5E5B") ;; <CJK>
       (?$(D<9(B . "0x5E5C") ;; <CJK>
       (?$(D<:(B . "0x5E5E") ;; <CJK>
       (?$(D<;(B . "0x5E68") ;; <CJK>
       (?$(D<<(B . "0x5E6A") ;; <CJK>
       (?$(D<=(B . "0x5E6B") ;; <CJK>
       (?$(D<>(B . "0x5E6C") ;; <CJK>
       (?$(D<?(B . "0x5E6D") ;; <CJK>
       (?$(D<@(B . "0x5E6E") ;; <CJK>
       (?$(D<A(B . "0x5E70") ;; <CJK>
       (?$(D<B(B . "0x5E80") ;; <CJK>
       (?$(D<C(B . "0x5E8B") ;; <CJK>
       (?$(D<D(B . "0x5E8E") ;; <CJK>
       (?$(D<E(B . "0x5EA2") ;; <CJK>
       (?$(D<F(B . "0x5EA4") ;; <CJK>
       (?$(D<G(B . "0x5EA5") ;; <CJK>
       (?$(D<H(B . "0x5EA8") ;; <CJK>
       (?$(D<I(B . "0x5EAA") ;; <CJK>
       (?$(D<J(B . "0x5EAC") ;; <CJK>
       (?$(D<K(B . "0x5EB1") ;; <CJK>
       (?$(D<L(B . "0x5EB3") ;; <CJK>
       (?$(D<M(B . "0x5EBD") ;; <CJK>
       (?$(D<N(B . "0x5EBE") ;; <CJK>
       (?$(D<O(B . "0x5EBF") ;; <CJK>
       (?$(D<P(B . "0x5EC6") ;; <CJK>
       (?$(D<Q(B . "0x5ECC") ;; <CJK>
       (?$(D<R(B . "0x5ECB") ;; <CJK>
       (?$(D<S(B . "0x5ECE") ;; <CJK>
       (?$(D<T(B . "0x5ED1") ;; <CJK>
       (?$(D<U(B . "0x5ED2") ;; <CJK>
       (?$(D<V(B . "0x5ED4") ;; <CJK>
       (?$(D<W(B . "0x5ED5") ;; <CJK>
       (?$(D<X(B . "0x5EDC") ;; <CJK>
       (?$(D<Y(B . "0x5EDE") ;; <CJK>
       (?$(D<Z(B . "0x5EE5") ;; <CJK>
       (?$(D<[(B . "0x5EEB") ;; <CJK>
       (?$(D<\(B . "0x5F02") ;; <CJK>
       (?$(D<](B . "0x5F06") ;; <CJK>
       (?$(D<^(B . "0x5F07") ;; <CJK>
       (?$(D<_(B . "0x5F08") ;; <CJK>
       (?$(D<`(B . "0x5F0E") ;; <CJK>
       (?$(D<a(B . "0x5F19") ;; <CJK>
       (?$(D<b(B . "0x5F1C") ;; <CJK>
       (?$(D<c(B . "0x5F1D") ;; <CJK>
       (?$(D<d(B . "0x5F21") ;; <CJK>
       (?$(D<e(B . "0x5F22") ;; <CJK>
       (?$(D<f(B . "0x5F23") ;; <CJK>
       (?$(D<g(B . "0x5F24") ;; <CJK>
       (?$(D<h(B . "0x5F28") ;; <CJK>
       (?$(D<i(B . "0x5F2B") ;; <CJK>
       (?$(D<j(B . "0x5F2C") ;; <CJK>
       (?$(D<k(B . "0x5F2E") ;; <CJK>
       (?$(D<l(B . "0x5F30") ;; <CJK>
       (?$(D<m(B . "0x5F34") ;; <CJK>
       (?$(D<n(B . "0x5F36") ;; <CJK>
       (?$(D<o(B . "0x5F3B") ;; <CJK>
       (?$(D<p(B . "0x5F3D") ;; <CJK>
       (?$(D<q(B . "0x5F3F") ;; <CJK>
       (?$(D<r(B . "0x5F40") ;; <CJK>
       (?$(D<s(B . "0x5F44") ;; <CJK>
       (?$(D<t(B . "0x5F45") ;; <CJK>
       (?$(D<u(B . "0x5F47") ;; <CJK>
       (?$(D<v(B . "0x5F4D") ;; <CJK>
       (?$(D<w(B . "0x5F50") ;; <CJK>
       (?$(D<x(B . "0x5F54") ;; <CJK>
       (?$(D<y(B . "0x5F58") ;; <CJK>
       (?$(D<z(B . "0x5F5B") ;; <CJK>
       (?$(D<{(B . "0x5F60") ;; <CJK>
       (?$(D<|(B . "0x5F63") ;; <CJK>
       (?$(D<}(B . "0x5F64") ;; <CJK>
       (?$(D<~(B . "0x5F67") ;; <CJK>
       (?$(D=!(B . "0x5F6F") ;; <CJK>
       (?$(D="(B . "0x5F72") ;; <CJK>
       (?$(D=#(B . "0x5F74") ;; <CJK>
       (?$(D=$(B . "0x5F75") ;; <CJK>
       (?$(D=%(B . "0x5F78") ;; <CJK>
       (?$(D=&(B . "0x5F7A") ;; <CJK>
       (?$(D='(B . "0x5F7D") ;; <CJK>
       (?$(D=((B . "0x5F7E") ;; <CJK>
       (?$(D=)(B . "0x5F89") ;; <CJK>
       (?$(D=*(B . "0x5F8D") ;; <CJK>
       (?$(D=+(B . "0x5F8F") ;; <CJK>
       (?$(D=,(B . "0x5F96") ;; <CJK>
       (?$(D=-(B . "0x5F9C") ;; <CJK>
       (?$(D=.(B . "0x5F9D") ;; <CJK>
       (?$(D=/(B . "0x5FA2") ;; <CJK>
       (?$(D=0(B . "0x5FA7") ;; <CJK>
       (?$(D=1(B . "0x5FAB") ;; <CJK>
       (?$(D=2(B . "0x5FA4") ;; <CJK>
       (?$(D=3(B . "0x5FAC") ;; <CJK>
       (?$(D=4(B . "0x5FAF") ;; <CJK>
       (?$(D=5(B . "0x5FB0") ;; <CJK>
       (?$(D=6(B . "0x5FB1") ;; <CJK>
       (?$(D=7(B . "0x5FB8") ;; <CJK>
       (?$(D=8(B . "0x5FC4") ;; <CJK>
       (?$(D=9(B . "0x5FC7") ;; <CJK>
       (?$(D=:(B . "0x5FC8") ;; <CJK>
       (?$(D=;(B . "0x5FC9") ;; <CJK>
       (?$(D=<(B . "0x5FCB") ;; <CJK>
       (?$(D==(B . "0x5FD0") ;; <CJK>
       (?$(D=>(B . "0x5FD1") ;; <CJK>
       (?$(D=?(B . "0x5FD2") ;; <CJK>
       (?$(D=@(B . "0x5FD3") ;; <CJK>
       (?$(D=A(B . "0x5FD4") ;; <CJK>
       (?$(D=B(B . "0x5FDE") ;; <CJK>
       (?$(D=C(B . "0x5FE1") ;; <CJK>
       (?$(D=D(B . "0x5FE2") ;; <CJK>
       (?$(D=E(B . "0x5FE8") ;; <CJK>
       (?$(D=F(B . "0x5FE9") ;; <CJK>
       (?$(D=G(B . "0x5FEA") ;; <CJK>
       (?$(D=H(B . "0x5FEC") ;; <CJK>
       (?$(D=I(B . "0x5FED") ;; <CJK>
       (?$(D=J(B . "0x5FEE") ;; <CJK>
       (?$(D=K(B . "0x5FEF") ;; <CJK>
       (?$(D=L(B . "0x5FF2") ;; <CJK>
       (?$(D=M(B . "0x5FF3") ;; <CJK>
       (?$(D=N(B . "0x5FF6") ;; <CJK>
       (?$(D=O(B . "0x5FFA") ;; <CJK>
       (?$(D=P(B . "0x5FFC") ;; <CJK>
       (?$(D=Q(B . "0x6007") ;; <CJK>
       (?$(D=R(B . "0x600A") ;; <CJK>
       (?$(D=S(B . "0x600D") ;; <CJK>
       (?$(D=T(B . "0x6013") ;; <CJK>
       (?$(D=U(B . "0x6014") ;; <CJK>
       (?$(D=V(B . "0x6017") ;; <CJK>
       (?$(D=W(B . "0x6018") ;; <CJK>
       (?$(D=X(B . "0x601A") ;; <CJK>
       (?$(D=Y(B . "0x601F") ;; <CJK>
       (?$(D=Z(B . "0x6024") ;; <CJK>
       (?$(D=[(B . "0x602D") ;; <CJK>
       (?$(D=\(B . "0x6033") ;; <CJK>
       (?$(D=](B . "0x6035") ;; <CJK>
       (?$(D=^(B . "0x6040") ;; <CJK>
       (?$(D=_(B . "0x6047") ;; <CJK>
       (?$(D=`(B . "0x6048") ;; <CJK>
       (?$(D=a(B . "0x6049") ;; <CJK>
       (?$(D=b(B . "0x604C") ;; <CJK>
       (?$(D=c(B . "0x6051") ;; <CJK>
       (?$(D=d(B . "0x6054") ;; <CJK>
       (?$(D=e(B . "0x6056") ;; <CJK>
       (?$(D=f(B . "0x6057") ;; <CJK>
       (?$(D=g(B . "0x605D") ;; <CJK>
       (?$(D=h(B . "0x6061") ;; <CJK>
       (?$(D=i(B . "0x6067") ;; <CJK>
       (?$(D=j(B . "0x6071") ;; <CJK>
       (?$(D=k(B . "0x607E") ;; <CJK>
       (?$(D=l(B . "0x607F") ;; <CJK>
       (?$(D=m(B . "0x6082") ;; <CJK>
       (?$(D=n(B . "0x6086") ;; <CJK>
       (?$(D=o(B . "0x6088") ;; <CJK>
       (?$(D=p(B . "0x608A") ;; <CJK>
       (?$(D=q(B . "0x608E") ;; <CJK>
       (?$(D=r(B . "0x6091") ;; <CJK>
       (?$(D=s(B . "0x6093") ;; <CJK>
       (?$(D=t(B . "0x6095") ;; <CJK>
       (?$(D=u(B . "0x6098") ;; <CJK>
       (?$(D=v(B . "0x609D") ;; <CJK>
       (?$(D=w(B . "0x609E") ;; <CJK>
       (?$(D=x(B . "0x60A2") ;; <CJK>
       (?$(D=y(B . "0x60A4") ;; <CJK>
       (?$(D=z(B . "0x60A5") ;; <CJK>
       (?$(D={(B . "0x60A8") ;; <CJK>
       (?$(D=|(B . "0x60B0") ;; <CJK>
       (?$(D=}(B . "0x60B1") ;; <CJK>
       (?$(D=~(B . "0x60B7") ;; <CJK>
       (?$(D>!(B . "0x60BB") ;; <CJK>
       (?$(D>"(B . "0x60BE") ;; <CJK>
       (?$(D>#(B . "0x60C2") ;; <CJK>
       (?$(D>$(B . "0x60C4") ;; <CJK>
       (?$(D>%(B . "0x60C8") ;; <CJK>
       (?$(D>&(B . "0x60C9") ;; <CJK>
       (?$(D>'(B . "0x60CA") ;; <CJK>
       (?$(D>((B . "0x60CB") ;; <CJK>
       (?$(D>)(B . "0x60CE") ;; <CJK>
       (?$(D>*(B . "0x60CF") ;; <CJK>
       (?$(D>+(B . "0x60D4") ;; <CJK>
       (?$(D>,(B . "0x60D5") ;; <CJK>
       (?$(D>-(B . "0x60D9") ;; <CJK>
       (?$(D>.(B . "0x60DB") ;; <CJK>
       (?$(D>/(B . "0x60DD") ;; <CJK>
       (?$(D>0(B . "0x60DE") ;; <CJK>
       (?$(D>1(B . "0x60E2") ;; <CJK>
       (?$(D>2(B . "0x60E5") ;; <CJK>
       (?$(D>3(B . "0x60F2") ;; <CJK>
       (?$(D>4(B . "0x60F5") ;; <CJK>
       (?$(D>5(B . "0x60F8") ;; <CJK>
       (?$(D>6(B . "0x60FC") ;; <CJK>
       (?$(D>7(B . "0x60FD") ;; <CJK>
       (?$(D>8(B . "0x6102") ;; <CJK>
       (?$(D>9(B . "0x6107") ;; <CJK>
       (?$(D>:(B . "0x610A") ;; <CJK>
       (?$(D>;(B . "0x610C") ;; <CJK>
       (?$(D><(B . "0x6110") ;; <CJK>
       (?$(D>=(B . "0x6111") ;; <CJK>
       (?$(D>>(B . "0x6112") ;; <CJK>
       (?$(D>?(B . "0x6113") ;; <CJK>
       (?$(D>@(B . "0x6114") ;; <CJK>
       (?$(D>A(B . "0x6116") ;; <CJK>
       (?$(D>B(B . "0x6117") ;; <CJK>
       (?$(D>C(B . "0x6119") ;; <CJK>
       (?$(D>D(B . "0x611C") ;; <CJK>
       (?$(D>E(B . "0x611E") ;; <CJK>
       (?$(D>F(B . "0x6122") ;; <CJK>
       (?$(D>G(B . "0x612A") ;; <CJK>
       (?$(D>H(B . "0x612B") ;; <CJK>
       (?$(D>I(B . "0x6130") ;; <CJK>
       (?$(D>J(B . "0x6131") ;; <CJK>
       (?$(D>K(B . "0x6135") ;; <CJK>
       (?$(D>L(B . "0x6136") ;; <CJK>
       (?$(D>M(B . "0x6137") ;; <CJK>
       (?$(D>N(B . "0x6139") ;; <CJK>
       (?$(D>O(B . "0x6141") ;; <CJK>
       (?$(D>P(B . "0x6145") ;; <CJK>
       (?$(D>Q(B . "0x6146") ;; <CJK>
       (?$(D>R(B . "0x6149") ;; <CJK>
       (?$(D>S(B . "0x615E") ;; <CJK>
       (?$(D>T(B . "0x6160") ;; <CJK>
       (?$(D>U(B . "0x616C") ;; <CJK>
       (?$(D>V(B . "0x6172") ;; <CJK>
       (?$(D>W(B . "0x6178") ;; <CJK>
       (?$(D>X(B . "0x617B") ;; <CJK>
       (?$(D>Y(B . "0x617C") ;; <CJK>
       (?$(D>Z(B . "0x617F") ;; <CJK>
       (?$(D>[(B . "0x6180") ;; <CJK>
       (?$(D>\(B . "0x6181") ;; <CJK>
       (?$(D>](B . "0x6183") ;; <CJK>
       (?$(D>^(B . "0x6184") ;; <CJK>
       (?$(D>_(B . "0x618B") ;; <CJK>
       (?$(D>`(B . "0x618D") ;; <CJK>
       (?$(D>a(B . "0x6192") ;; <CJK>
       (?$(D>b(B . "0x6193") ;; <CJK>
       (?$(D>c(B . "0x6197") ;; <CJK>
       (?$(D>d(B . "0x6198") ;; <CJK>
       (?$(D>e(B . "0x619C") ;; <CJK>
       (?$(D>f(B . "0x619D") ;; <CJK>
       (?$(D>g(B . "0x619F") ;; <CJK>
       (?$(D>h(B . "0x61A0") ;; <CJK>
       (?$(D>i(B . "0x61A5") ;; <CJK>
       (?$(D>j(B . "0x61A8") ;; <CJK>
       (?$(D>k(B . "0x61AA") ;; <CJK>
       (?$(D>l(B . "0x61AD") ;; <CJK>
       (?$(D>m(B . "0x61B8") ;; <CJK>
       (?$(D>n(B . "0x61B9") ;; <CJK>
       (?$(D>o(B . "0x61BC") ;; <CJK>
       (?$(D>p(B . "0x61C0") ;; <CJK>
       (?$(D>q(B . "0x61C1") ;; <CJK>
       (?$(D>r(B . "0x61C2") ;; <CJK>
       (?$(D>s(B . "0x61CE") ;; <CJK>
       (?$(D>t(B . "0x61CF") ;; <CJK>
       (?$(D>u(B . "0x61D5") ;; <CJK>
       (?$(D>v(B . "0x61DC") ;; <CJK>
       (?$(D>w(B . "0x61DD") ;; <CJK>
       (?$(D>x(B . "0x61DE") ;; <CJK>
       (?$(D>y(B . "0x61DF") ;; <CJK>
       (?$(D>z(B . "0x61E1") ;; <CJK>
       (?$(D>{(B . "0x61E2") ;; <CJK>
       (?$(D>|(B . "0x61E7") ;; <CJK>
       (?$(D>}(B . "0x61E9") ;; <CJK>
       (?$(D>~(B . "0x61E5") ;; <CJK>
       (?$(D?!(B . "0x61EC") ;; <CJK>
       (?$(D?"(B . "0x61ED") ;; <CJK>
       (?$(D?#(B . "0x61EF") ;; <CJK>
       (?$(D?$(B . "0x6201") ;; <CJK>
       (?$(D?%(B . "0x6203") ;; <CJK>
       (?$(D?&(B . "0x6204") ;; <CJK>
       (?$(D?'(B . "0x6207") ;; <CJK>
       (?$(D?((B . "0x6213") ;; <CJK>
       (?$(D?)(B . "0x6215") ;; <CJK>
       (?$(D?*(B . "0x621C") ;; <CJK>
       (?$(D?+(B . "0x6220") ;; <CJK>
       (?$(D?,(B . "0x6222") ;; <CJK>
       (?$(D?-(B . "0x6223") ;; <CJK>
       (?$(D?.(B . "0x6227") ;; <CJK>
       (?$(D?/(B . "0x6229") ;; <CJK>
       (?$(D?0(B . "0x622B") ;; <CJK>
       (?$(D?1(B . "0x6239") ;; <CJK>
       (?$(D?2(B . "0x623D") ;; <CJK>
       (?$(D?3(B . "0x6242") ;; <CJK>
       (?$(D?4(B . "0x6243") ;; <CJK>
       (?$(D?5(B . "0x6244") ;; <CJK>
       (?$(D?6(B . "0x6246") ;; <CJK>
       (?$(D?7(B . "0x624C") ;; <CJK>
       (?$(D?8(B . "0x6250") ;; <CJK>
       (?$(D?9(B . "0x6251") ;; <CJK>
       (?$(D?:(B . "0x6252") ;; <CJK>
       (?$(D?;(B . "0x6254") ;; <CJK>
       (?$(D?<(B . "0x6256") ;; <CJK>
       (?$(D?=(B . "0x625A") ;; <CJK>
       (?$(D?>(B . "0x625C") ;; <CJK>
       (?$(D??(B . "0x6264") ;; <CJK>
       (?$(D?@(B . "0x626D") ;; <CJK>
       (?$(D?A(B . "0x626F") ;; <CJK>
       (?$(D?B(B . "0x6273") ;; <CJK>
       (?$(D?C(B . "0x627A") ;; <CJK>
       (?$(D?D(B . "0x627D") ;; <CJK>
       (?$(D?E(B . "0x628D") ;; <CJK>
       (?$(D?F(B . "0x628E") ;; <CJK>
       (?$(D?G(B . "0x628F") ;; <CJK>
       (?$(D?H(B . "0x6290") ;; <CJK>
       (?$(D?I(B . "0x62A6") ;; <CJK>
       (?$(D?J(B . "0x62A8") ;; <CJK>
       (?$(D?K(B . "0x62B3") ;; <CJK>
       (?$(D?L(B . "0x62B6") ;; <CJK>
       (?$(D?M(B . "0x62B7") ;; <CJK>
       (?$(D?N(B . "0x62BA") ;; <CJK>
       (?$(D?O(B . "0x62BE") ;; <CJK>
       (?$(D?P(B . "0x62BF") ;; <CJK>
       (?$(D?Q(B . "0x62C4") ;; <CJK>
       (?$(D?R(B . "0x62CE") ;; <CJK>
       (?$(D?S(B . "0x62D5") ;; <CJK>
       (?$(D?T(B . "0x62D6") ;; <CJK>
       (?$(D?U(B . "0x62DA") ;; <CJK>
       (?$(D?V(B . "0x62EA") ;; <CJK>
       (?$(D?W(B . "0x62F2") ;; <CJK>
       (?$(D?X(B . "0x62F4") ;; <CJK>
       (?$(D?Y(B . "0x62FC") ;; <CJK>
       (?$(D?Z(B . "0x62FD") ;; <CJK>
       (?$(D?[(B . "0x6303") ;; <CJK>
       (?$(D?\(B . "0x6304") ;; <CJK>
       (?$(D?](B . "0x630A") ;; <CJK>
       (?$(D?^(B . "0x630B") ;; <CJK>
       (?$(D?_(B . "0x630D") ;; <CJK>
       (?$(D?`(B . "0x6310") ;; <CJK>
       (?$(D?a(B . "0x6313") ;; <CJK>
       (?$(D?b(B . "0x6316") ;; <CJK>
       (?$(D?c(B . "0x6318") ;; <CJK>
       (?$(D?d(B . "0x6329") ;; <CJK>
       (?$(D?e(B . "0x632A") ;; <CJK>
       (?$(D?f(B . "0x632D") ;; <CJK>
       (?$(D?g(B . "0x6335") ;; <CJK>
       (?$(D?h(B . "0x6336") ;; <CJK>
       (?$(D?i(B . "0x6339") ;; <CJK>
       (?$(D?j(B . "0x633C") ;; <CJK>
       (?$(D?k(B . "0x6341") ;; <CJK>
       (?$(D?l(B . "0x6342") ;; <CJK>
       (?$(D?m(B . "0x6343") ;; <CJK>
       (?$(D?n(B . "0x6344") ;; <CJK>
       (?$(D?o(B . "0x6346") ;; <CJK>
       (?$(D?p(B . "0x634A") ;; <CJK>
       (?$(D?q(B . "0x634B") ;; <CJK>
       (?$(D?r(B . "0x634E") ;; <CJK>
       (?$(D?s(B . "0x6352") ;; <CJK>
       (?$(D?t(B . "0x6353") ;; <CJK>
       (?$(D?u(B . "0x6354") ;; <CJK>
       (?$(D?v(B . "0x6358") ;; <CJK>
       (?$(D?w(B . "0x635B") ;; <CJK>
       (?$(D?x(B . "0x6365") ;; <CJK>
       (?$(D?y(B . "0x6366") ;; <CJK>
       (?$(D?z(B . "0x636C") ;; <CJK>
       (?$(D?{(B . "0x636D") ;; <CJK>
       (?$(D?|(B . "0x6371") ;; <CJK>
       (?$(D?}(B . "0x6374") ;; <CJK>
       (?$(D?~(B . "0x6375") ;; <CJK>
       (?$(D@!(B . "0x6378") ;; <CJK>
       (?$(D@"(B . "0x637C") ;; <CJK>
       (?$(D@#(B . "0x637D") ;; <CJK>
       (?$(D@$(B . "0x637F") ;; <CJK>
       (?$(D@%(B . "0x6382") ;; <CJK>
       (?$(D@&(B . "0x6384") ;; <CJK>
       (?$(D@'(B . "0x6387") ;; <CJK>
       (?$(D@((B . "0x638A") ;; <CJK>
       (?$(D@)(B . "0x6390") ;; <CJK>
       (?$(D@*(B . "0x6394") ;; <CJK>
       (?$(D@+(B . "0x6395") ;; <CJK>
       (?$(D@,(B . "0x6399") ;; <CJK>
       (?$(D@-(B . "0x639A") ;; <CJK>
       (?$(D@.(B . "0x639E") ;; <CJK>
       (?$(D@/(B . "0x63A4") ;; <CJK>
       (?$(D@0(B . "0x63A6") ;; <CJK>
       (?$(D@1(B . "0x63AD") ;; <CJK>
       (?$(D@2(B . "0x63AE") ;; <CJK>
       (?$(D@3(B . "0x63AF") ;; <CJK>
       (?$(D@4(B . "0x63BD") ;; <CJK>
       (?$(D@5(B . "0x63C1") ;; <CJK>
       (?$(D@6(B . "0x63C5") ;; <CJK>
       (?$(D@7(B . "0x63C8") ;; <CJK>
       (?$(D@8(B . "0x63CE") ;; <CJK>
       (?$(D@9(B . "0x63D1") ;; <CJK>
       (?$(D@:(B . "0x63D3") ;; <CJK>
       (?$(D@;(B . "0x63D4") ;; <CJK>
       (?$(D@<(B . "0x63D5") ;; <CJK>
       (?$(D@=(B . "0x63DC") ;; <CJK>
       (?$(D@>(B . "0x63E0") ;; <CJK>
       (?$(D@?(B . "0x63E5") ;; <CJK>
       (?$(D@@(B . "0x63EA") ;; <CJK>
       (?$(D@A(B . "0x63EC") ;; <CJK>
       (?$(D@B(B . "0x63F2") ;; <CJK>
       (?$(D@C(B . "0x63F3") ;; <CJK>
       (?$(D@D(B . "0x63F5") ;; <CJK>
       (?$(D@E(B . "0x63F8") ;; <CJK>
       (?$(D@F(B . "0x63F9") ;; <CJK>
       (?$(D@G(B . "0x6409") ;; <CJK>
       (?$(D@H(B . "0x640A") ;; <CJK>
       (?$(D@I(B . "0x6410") ;; <CJK>
       (?$(D@J(B . "0x6412") ;; <CJK>
       (?$(D@K(B . "0x6414") ;; <CJK>
       (?$(D@L(B . "0x6418") ;; <CJK>
       (?$(D@M(B . "0x641E") ;; <CJK>
       (?$(D@N(B . "0x6420") ;; <CJK>
       (?$(D@O(B . "0x6422") ;; <CJK>
       (?$(D@P(B . "0x6424") ;; <CJK>
       (?$(D@Q(B . "0x6425") ;; <CJK>
       (?$(D@R(B . "0x6429") ;; <CJK>
       (?$(D@S(B . "0x642A") ;; <CJK>
       (?$(D@T(B . "0x642F") ;; <CJK>
       (?$(D@U(B . "0x6430") ;; <CJK>
       (?$(D@V(B . "0x6435") ;; <CJK>
       (?$(D@W(B . "0x643D") ;; <CJK>
       (?$(D@X(B . "0x643F") ;; <CJK>
       (?$(D@Y(B . "0x644B") ;; <CJK>
       (?$(D@Z(B . "0x644F") ;; <CJK>
       (?$(D@[(B . "0x6451") ;; <CJK>
       (?$(D@\(B . "0x6452") ;; <CJK>
       (?$(D@](B . "0x6453") ;; <CJK>
       (?$(D@^(B . "0x6454") ;; <CJK>
       (?$(D@_(B . "0x645A") ;; <CJK>
       (?$(D@`(B . "0x645B") ;; <CJK>
       (?$(D@a(B . "0x645C") ;; <CJK>
       (?$(D@b(B . "0x645D") ;; <CJK>
       (?$(D@c(B . "0x645F") ;; <CJK>
       (?$(D@d(B . "0x6460") ;; <CJK>
       (?$(D@e(B . "0x6461") ;; <CJK>
       (?$(D@f(B . "0x6463") ;; <CJK>
       (?$(D@g(B . "0x646D") ;; <CJK>
       (?$(D@h(B . "0x6473") ;; <CJK>
       (?$(D@i(B . "0x6474") ;; <CJK>
       (?$(D@j(B . "0x647B") ;; <CJK>
       (?$(D@k(B . "0x647D") ;; <CJK>
       (?$(D@l(B . "0x6485") ;; <CJK>
       (?$(D@m(B . "0x6487") ;; <CJK>
       (?$(D@n(B . "0x648F") ;; <CJK>
       (?$(D@o(B . "0x6490") ;; <CJK>
       (?$(D@p(B . "0x6491") ;; <CJK>
       (?$(D@q(B . "0x6498") ;; <CJK>
       (?$(D@r(B . "0x6499") ;; <CJK>
       (?$(D@s(B . "0x649B") ;; <CJK>
       (?$(D@t(B . "0x649D") ;; <CJK>
       (?$(D@u(B . "0x649F") ;; <CJK>
       (?$(D@v(B . "0x64A1") ;; <CJK>
       (?$(D@w(B . "0x64A3") ;; <CJK>
       (?$(D@x(B . "0x64A6") ;; <CJK>
       (?$(D@y(B . "0x64A8") ;; <CJK>
       (?$(D@z(B . "0x64AC") ;; <CJK>
       (?$(D@{(B . "0x64B3") ;; <CJK>
       (?$(D@|(B . "0x64BD") ;; <CJK>
       (?$(D@}(B . "0x64BE") ;; <CJK>
       (?$(D@~(B . "0x64BF") ;; <CJK>
       (?$(DA!(B . "0x64C4") ;; <CJK>
       (?$(DA"(B . "0x64C9") ;; <CJK>
       (?$(DA#(B . "0x64CA") ;; <CJK>
       (?$(DA$(B . "0x64CB") ;; <CJK>
       (?$(DA%(B . "0x64CC") ;; <CJK>
       (?$(DA&(B . "0x64CE") ;; <CJK>
       (?$(DA'(B . "0x64D0") ;; <CJK>
       (?$(DA((B . "0x64D1") ;; <CJK>
       (?$(DA)(B . "0x64D5") ;; <CJK>
       (?$(DA*(B . "0x64D7") ;; <CJK>
       (?$(DA+(B . "0x64E4") ;; <CJK>
       (?$(DA,(B . "0x64E5") ;; <CJK>
       (?$(DA-(B . "0x64E9") ;; <CJK>
       (?$(DA.(B . "0x64EA") ;; <CJK>
       (?$(DA/(B . "0x64ED") ;; <CJK>
       (?$(DA0(B . "0x64F0") ;; <CJK>
       (?$(DA1(B . "0x64F5") ;; <CJK>
       (?$(DA2(B . "0x64F7") ;; <CJK>
       (?$(DA3(B . "0x64FB") ;; <CJK>
       (?$(DA4(B . "0x64FF") ;; <CJK>
       (?$(DA5(B . "0x6501") ;; <CJK>
       (?$(DA6(B . "0x6504") ;; <CJK>
       (?$(DA7(B . "0x6508") ;; <CJK>
       (?$(DA8(B . "0x6509") ;; <CJK>
       (?$(DA9(B . "0x650A") ;; <CJK>
       (?$(DA:(B . "0x650F") ;; <CJK>
       (?$(DA;(B . "0x6513") ;; <CJK>
       (?$(DA<(B . "0x6514") ;; <CJK>
       (?$(DA=(B . "0x6516") ;; <CJK>
       (?$(DA>(B . "0x6519") ;; <CJK>
       (?$(DA?(B . "0x651B") ;; <CJK>
       (?$(DA@(B . "0x651E") ;; <CJK>
       (?$(DAA(B . "0x651F") ;; <CJK>
       (?$(DAB(B . "0x6522") ;; <CJK>
       (?$(DAC(B . "0x6526") ;; <CJK>
       (?$(DAD(B . "0x6529") ;; <CJK>
       (?$(DAE(B . "0x652E") ;; <CJK>
       (?$(DAF(B . "0x6531") ;; <CJK>
       (?$(DAG(B . "0x653A") ;; <CJK>
       (?$(DAH(B . "0x653C") ;; <CJK>
       (?$(DAI(B . "0x653D") ;; <CJK>
       (?$(DAJ(B . "0x6543") ;; <CJK>
       (?$(DAK(B . "0x6547") ;; <CJK>
       (?$(DAL(B . "0x6549") ;; <CJK>
       (?$(DAM(B . "0x6550") ;; <CJK>
       (?$(DAN(B . "0x6552") ;; <CJK>
       (?$(DAO(B . "0x6554") ;; <CJK>
       (?$(DAP(B . "0x655F") ;; <CJK>
       (?$(DAQ(B . "0x6560") ;; <CJK>
       (?$(DAR(B . "0x6567") ;; <CJK>
       (?$(DAS(B . "0x656B") ;; <CJK>
       (?$(DAT(B . "0x657A") ;; <CJK>
       (?$(DAU(B . "0x657D") ;; <CJK>
       (?$(DAV(B . "0x6581") ;; <CJK>
       (?$(DAW(B . "0x6585") ;; <CJK>
       (?$(DAX(B . "0x658A") ;; <CJK>
       (?$(DAY(B . "0x6592") ;; <CJK>
       (?$(DAZ(B . "0x6595") ;; <CJK>
       (?$(DA[(B . "0x6598") ;; <CJK>
       (?$(DA\(B . "0x659D") ;; <CJK>
       (?$(DA](B . "0x65A0") ;; <CJK>
       (?$(DA^(B . "0x65A3") ;; <CJK>
       (?$(DA_(B . "0x65A6") ;; <CJK>
       (?$(DA`(B . "0x65AE") ;; <CJK>
       (?$(DAa(B . "0x65B2") ;; <CJK>
       (?$(DAb(B . "0x65B3") ;; <CJK>
       (?$(DAc(B . "0x65B4") ;; <CJK>
       (?$(DAd(B . "0x65BF") ;; <CJK>
       (?$(DAe(B . "0x65C2") ;; <CJK>
       (?$(DAf(B . "0x65C8") ;; <CJK>
       (?$(DAg(B . "0x65C9") ;; <CJK>
       (?$(DAh(B . "0x65CE") ;; <CJK>
       (?$(DAi(B . "0x65D0") ;; <CJK>
       (?$(DAj(B . "0x65D4") ;; <CJK>
       (?$(DAk(B . "0x65D6") ;; <CJK>
       (?$(DAl(B . "0x65D8") ;; <CJK>
       (?$(DAm(B . "0x65DF") ;; <CJK>
       (?$(DAn(B . "0x65F0") ;; <CJK>
       (?$(DAo(B . "0x65F2") ;; <CJK>
       (?$(DAp(B . "0x65F4") ;; <CJK>
       (?$(DAq(B . "0x65F5") ;; <CJK>
       (?$(DAr(B . "0x65F9") ;; <CJK>
       (?$(DAs(B . "0x65FE") ;; <CJK>
       (?$(DAt(B . "0x65FF") ;; <CJK>
       (?$(DAu(B . "0x6600") ;; <CJK>
       (?$(DAv(B . "0x6604") ;; <CJK>
       (?$(DAw(B . "0x6608") ;; <CJK>
       (?$(DAx(B . "0x6609") ;; <CJK>
       (?$(DAy(B . "0x660D") ;; <CJK>
       (?$(DAz(B . "0x6611") ;; <CJK>
       (?$(DA{(B . "0x6612") ;; <CJK>
       (?$(DA|(B . "0x6615") ;; <CJK>
       (?$(DA}(B . "0x6616") ;; <CJK>
       (?$(DA~(B . "0x661D") ;; <CJK>
       (?$(DB!(B . "0x661E") ;; <CJK>
       (?$(DB"(B . "0x6621") ;; <CJK>
       (?$(DB#(B . "0x6622") ;; <CJK>
       (?$(DB$(B . "0x6623") ;; <CJK>
       (?$(DB%(B . "0x6624") ;; <CJK>
       (?$(DB&(B . "0x6626") ;; <CJK>
       (?$(DB'(B . "0x6629") ;; <CJK>
       (?$(DB((B . "0x662A") ;; <CJK>
       (?$(DB)(B . "0x662B") ;; <CJK>
       (?$(DB*(B . "0x662C") ;; <CJK>
       (?$(DB+(B . "0x662E") ;; <CJK>
       (?$(DB,(B . "0x6630") ;; <CJK>
       (?$(DB-(B . "0x6631") ;; <CJK>
       (?$(DB.(B . "0x6633") ;; <CJK>
       (?$(DB/(B . "0x6639") ;; <CJK>
       (?$(DB0(B . "0x6637") ;; <CJK>
       (?$(DB1(B . "0x6640") ;; <CJK>
       (?$(DB2(B . "0x6645") ;; <CJK>
       (?$(DB3(B . "0x6646") ;; <CJK>
       (?$(DB4(B . "0x664A") ;; <CJK>
       (?$(DB5(B . "0x664C") ;; <CJK>
       (?$(DB6(B . "0x6651") ;; <CJK>
       (?$(DB7(B . "0x664E") ;; <CJK>
       (?$(DB8(B . "0x6657") ;; <CJK>
       (?$(DB9(B . "0x6658") ;; <CJK>
       (?$(DB:(B . "0x6659") ;; <CJK>
       (?$(DB;(B . "0x665B") ;; <CJK>
       (?$(DB<(B . "0x665C") ;; <CJK>
       (?$(DB=(B . "0x6660") ;; <CJK>
       (?$(DB>(B . "0x6661") ;; <CJK>
       (?$(DB?(B . "0x66FB") ;; <CJK>
       (?$(DB@(B . "0x666A") ;; <CJK>
       (?$(DBA(B . "0x666B") ;; <CJK>
       (?$(DBB(B . "0x666C") ;; <CJK>
       (?$(DBC(B . "0x667E") ;; <CJK>
       (?$(DBD(B . "0x6673") ;; <CJK>
       (?$(DBE(B . "0x6675") ;; <CJK>
       (?$(DBF(B . "0x667F") ;; <CJK>
       (?$(DBG(B . "0x6677") ;; <CJK>
       (?$(DBH(B . "0x6678") ;; <CJK>
       (?$(DBI(B . "0x6679") ;; <CJK>
       (?$(DBJ(B . "0x667B") ;; <CJK>
       (?$(DBK(B . "0x6680") ;; <CJK>
       (?$(DBL(B . "0x667C") ;; <CJK>
       (?$(DBM(B . "0x668B") ;; <CJK>
       (?$(DBN(B . "0x668C") ;; <CJK>
       (?$(DBO(B . "0x668D") ;; <CJK>
       (?$(DBP(B . "0x6690") ;; <CJK>
       (?$(DBQ(B . "0x6692") ;; <CJK>
       (?$(DBR(B . "0x6699") ;; <CJK>
       (?$(DBS(B . "0x669A") ;; <CJK>
       (?$(DBT(B . "0x669B") ;; <CJK>
       (?$(DBU(B . "0x669C") ;; <CJK>
       (?$(DBV(B . "0x669F") ;; <CJK>
       (?$(DBW(B . "0x66A0") ;; <CJK>
       (?$(DBX(B . "0x66A4") ;; <CJK>
       (?$(DBY(B . "0x66AD") ;; <CJK>
       (?$(DBZ(B . "0x66B1") ;; <CJK>
       (?$(DB[(B . "0x66B2") ;; <CJK>
       (?$(DB\(B . "0x66B5") ;; <CJK>
       (?$(DB](B . "0x66BB") ;; <CJK>
       (?$(DB^(B . "0x66BF") ;; <CJK>
       (?$(DB_(B . "0x66C0") ;; <CJK>
       (?$(DB`(B . "0x66C2") ;; <CJK>
       (?$(DBa(B . "0x66C3") ;; <CJK>
       (?$(DBb(B . "0x66C8") ;; <CJK>
       (?$(DBc(B . "0x66CC") ;; <CJK>
       (?$(DBd(B . "0x66CE") ;; <CJK>
       (?$(DBe(B . "0x66CF") ;; <CJK>
       (?$(DBf(B . "0x66D4") ;; <CJK>
       (?$(DBg(B . "0x66DB") ;; <CJK>
       (?$(DBh(B . "0x66DF") ;; <CJK>
       (?$(DBi(B . "0x66E8") ;; <CJK>
       (?$(DBj(B . "0x66EB") ;; <CJK>
       (?$(DBk(B . "0x66EC") ;; <CJK>
       (?$(DBl(B . "0x66EE") ;; <CJK>
       (?$(DBm(B . "0x66FA") ;; <CJK>
       (?$(DBn(B . "0x6705") ;; <CJK>
       (?$(DBo(B . "0x6707") ;; <CJK>
       (?$(DBp(B . "0x670E") ;; <CJK>
       (?$(DBq(B . "0x6713") ;; <CJK>
       (?$(DBr(B . "0x6719") ;; <CJK>
       (?$(DBs(B . "0x671C") ;; <CJK>
       (?$(DBt(B . "0x6720") ;; <CJK>
       (?$(DBu(B . "0x6722") ;; <CJK>
       (?$(DBv(B . "0x6733") ;; <CJK>
       (?$(DBw(B . "0x673E") ;; <CJK>
       (?$(DBx(B . "0x6745") ;; <CJK>
       (?$(DBy(B . "0x6747") ;; <CJK>
       (?$(DBz(B . "0x6748") ;; <CJK>
       (?$(DB{(B . "0x674C") ;; <CJK>
       (?$(DB|(B . "0x6754") ;; <CJK>
       (?$(DB}(B . "0x6755") ;; <CJK>
       (?$(DB~(B . "0x675D") ;; <CJK>
       (?$(DC!(B . "0x6766") ;; <CJK>
       (?$(DC"(B . "0x676C") ;; <CJK>
       (?$(DC#(B . "0x676E") ;; <CJK>
       (?$(DC$(B . "0x6774") ;; <CJK>
       (?$(DC%(B . "0x6776") ;; <CJK>
       (?$(DC&(B . "0x677B") ;; <CJK>
       (?$(DC'(B . "0x6781") ;; <CJK>
       (?$(DC((B . "0x6784") ;; <CJK>
       (?$(DC)(B . "0x678E") ;; <CJK>
       (?$(DC*(B . "0x678F") ;; <CJK>
       (?$(DC+(B . "0x6791") ;; <CJK>
       (?$(DC,(B . "0x6793") ;; <CJK>
       (?$(DC-(B . "0x6796") ;; <CJK>
       (?$(DC.(B . "0x6798") ;; <CJK>
       (?$(DC/(B . "0x6799") ;; <CJK>
       (?$(DC0(B . "0x679B") ;; <CJK>
       (?$(DC1(B . "0x67B0") ;; <CJK>
       (?$(DC2(B . "0x67B1") ;; <CJK>
       (?$(DC3(B . "0x67B2") ;; <CJK>
       (?$(DC4(B . "0x67B5") ;; <CJK>
       (?$(DC5(B . "0x67BB") ;; <CJK>
       (?$(DC6(B . "0x67BC") ;; <CJK>
       (?$(DC7(B . "0x67BD") ;; <CJK>
       (?$(DC8(B . "0x67F9") ;; <CJK>
       (?$(DC9(B . "0x67C0") ;; <CJK>
       (?$(DC:(B . "0x67C2") ;; <CJK>
       (?$(DC;(B . "0x67C3") ;; <CJK>
       (?$(DC<(B . "0x67C5") ;; <CJK>
       (?$(DC=(B . "0x67C8") ;; <CJK>
       (?$(DC>(B . "0x67C9") ;; <CJK>
       (?$(DC?(B . "0x67D2") ;; <CJK>
       (?$(DC@(B . "0x67D7") ;; <CJK>
       (?$(DCA(B . "0x67D9") ;; <CJK>
       (?$(DCB(B . "0x67DC") ;; <CJK>
       (?$(DCC(B . "0x67E1") ;; <CJK>
       (?$(DCD(B . "0x67E6") ;; <CJK>
       (?$(DCE(B . "0x67F0") ;; <CJK>
       (?$(DCF(B . "0x67F2") ;; <CJK>
       (?$(DCG(B . "0x67F6") ;; <CJK>
       (?$(DCH(B . "0x67F7") ;; <CJK>
       (?$(DCI(B . "0x6852") ;; <CJK>
       (?$(DCJ(B . "0x6814") ;; <CJK>
       (?$(DCK(B . "0x6819") ;; <CJK>
       (?$(DCL(B . "0x681D") ;; <CJK>
       (?$(DCM(B . "0x681F") ;; <CJK>
       (?$(DCN(B . "0x6828") ;; <CJK>
       (?$(DCO(B . "0x6827") ;; <CJK>
       (?$(DCP(B . "0x682C") ;; <CJK>
       (?$(DCQ(B . "0x682D") ;; <CJK>
       (?$(DCR(B . "0x682F") ;; <CJK>
       (?$(DCS(B . "0x6830") ;; <CJK>
       (?$(DCT(B . "0x6831") ;; <CJK>
       (?$(DCU(B . "0x6833") ;; <CJK>
       (?$(DCV(B . "0x683B") ;; <CJK>
       (?$(DCW(B . "0x683F") ;; <CJK>
       (?$(DCX(B . "0x6844") ;; <CJK>
       (?$(DCY(B . "0x6845") ;; <CJK>
       (?$(DCZ(B . "0x684A") ;; <CJK>
       (?$(DC[(B . "0x684C") ;; <CJK>
       (?$(DC\(B . "0x6855") ;; <CJK>
       (?$(DC](B . "0x6857") ;; <CJK>
       (?$(DC^(B . "0x6858") ;; <CJK>
       (?$(DC_(B . "0x685B") ;; <CJK>
       (?$(DC`(B . "0x686B") ;; <CJK>
       (?$(DCa(B . "0x686E") ;; <CJK>
       (?$(DCb(B . "0x686F") ;; <CJK>
       (?$(DCc(B . "0x6870") ;; <CJK>
       (?$(DCd(B . "0x6871") ;; <CJK>
       (?$(DCe(B . "0x6872") ;; <CJK>
       (?$(DCf(B . "0x6875") ;; <CJK>
       (?$(DCg(B . "0x6879") ;; <CJK>
       (?$(DCh(B . "0x687A") ;; <CJK>
       (?$(DCi(B . "0x687B") ;; <CJK>
       (?$(DCj(B . "0x687C") ;; <CJK>
       (?$(DCk(B . "0x6882") ;; <CJK>
       (?$(DCl(B . "0x6884") ;; <CJK>
       (?$(DCm(B . "0x6886") ;; <CJK>
       (?$(DCn(B . "0x6888") ;; <CJK>
       (?$(DCo(B . "0x6896") ;; <CJK>
       (?$(DCp(B . "0x6898") ;; <CJK>
       (?$(DCq(B . "0x689A") ;; <CJK>
       (?$(DCr(B . "0x689C") ;; <CJK>
       (?$(DCs(B . "0x68A1") ;; <CJK>
       (?$(DCt(B . "0x68A3") ;; <CJK>
       (?$(DCu(B . "0x68A5") ;; <CJK>
       (?$(DCv(B . "0x68A9") ;; <CJK>
       (?$(DCw(B . "0x68AA") ;; <CJK>
       (?$(DCx(B . "0x68AE") ;; <CJK>
       (?$(DCy(B . "0x68B2") ;; <CJK>
       (?$(DCz(B . "0x68BB") ;; <CJK>
       (?$(DC{(B . "0x68C5") ;; <CJK>
       (?$(DC|(B . "0x68C8") ;; <CJK>
       (?$(DC}(B . "0x68CC") ;; <CJK>
       (?$(DC~(B . "0x68CF") ;; <CJK>
       (?$(DD!(B . "0x68D0") ;; <CJK>
       (?$(DD"(B . "0x68D1") ;; <CJK>
       (?$(DD#(B . "0x68D3") ;; <CJK>
       (?$(DD$(B . "0x68D6") ;; <CJK>
       (?$(DD%(B . "0x68D9") ;; <CJK>
       (?$(DD&(B . "0x68DC") ;; <CJK>
       (?$(DD'(B . "0x68DD") ;; <CJK>
       (?$(DD((B . "0x68E5") ;; <CJK>
       (?$(DD)(B . "0x68E8") ;; <CJK>
       (?$(DD*(B . "0x68EA") ;; <CJK>
       (?$(DD+(B . "0x68EB") ;; <CJK>
       (?$(DD,(B . "0x68EC") ;; <CJK>
       (?$(DD-(B . "0x68ED") ;; <CJK>
       (?$(DD.(B . "0x68F0") ;; <CJK>
       (?$(DD/(B . "0x68F1") ;; <CJK>
       (?$(DD0(B . "0x68F5") ;; <CJK>
       (?$(DD1(B . "0x68F6") ;; <CJK>
       (?$(DD2(B . "0x68FB") ;; <CJK>
       (?$(DD3(B . "0x68FC") ;; <CJK>
       (?$(DD4(B . "0x68FD") ;; <CJK>
       (?$(DD5(B . "0x6906") ;; <CJK>
       (?$(DD6(B . "0x6909") ;; <CJK>
       (?$(DD7(B . "0x690A") ;; <CJK>
       (?$(DD8(B . "0x6910") ;; <CJK>
       (?$(DD9(B . "0x6911") ;; <CJK>
       (?$(DD:(B . "0x6913") ;; <CJK>
       (?$(DD;(B . "0x6916") ;; <CJK>
       (?$(DD<(B . "0x6917") ;; <CJK>
       (?$(DD=(B . "0x6931") ;; <CJK>
       (?$(DD>(B . "0x6933") ;; <CJK>
       (?$(DD?(B . "0x6935") ;; <CJK>
       (?$(DD@(B . "0x6938") ;; <CJK>
       (?$(DDA(B . "0x693B") ;; <CJK>
       (?$(DDB(B . "0x6942") ;; <CJK>
       (?$(DDC(B . "0x6945") ;; <CJK>
       (?$(DDD(B . "0x6949") ;; <CJK>
       (?$(DDE(B . "0x694E") ;; <CJK>
       (?$(DDF(B . "0x6957") ;; <CJK>
       (?$(DDG(B . "0x695B") ;; <CJK>
       (?$(DDH(B . "0x6963") ;; <CJK>
       (?$(DDI(B . "0x6964") ;; <CJK>
       (?$(DDJ(B . "0x6965") ;; <CJK>
       (?$(DDK(B . "0x6966") ;; <CJK>
       (?$(DDL(B . "0x6968") ;; <CJK>
       (?$(DDM(B . "0x6969") ;; <CJK>
       (?$(DDN(B . "0x696C") ;; <CJK>
       (?$(DDO(B . "0x6970") ;; <CJK>
       (?$(DDP(B . "0x6971") ;; <CJK>
       (?$(DDQ(B . "0x6972") ;; <CJK>
       (?$(DDR(B . "0x697A") ;; <CJK>
       (?$(DDS(B . "0x697B") ;; <CJK>
       (?$(DDT(B . "0x697F") ;; <CJK>
       (?$(DDU(B . "0x6980") ;; <CJK>
       (?$(DDV(B . "0x698D") ;; <CJK>
       (?$(DDW(B . "0x6992") ;; <CJK>
       (?$(DDX(B . "0x6996") ;; <CJK>
       (?$(DDY(B . "0x6998") ;; <CJK>
       (?$(DDZ(B . "0x69A1") ;; <CJK>
       (?$(DD[(B . "0x69A5") ;; <CJK>
       (?$(DD\(B . "0x69A6") ;; <CJK>
       (?$(DD](B . "0x69A8") ;; <CJK>
       (?$(DD^(B . "0x69AB") ;; <CJK>
       (?$(DD_(B . "0x69AD") ;; <CJK>
       (?$(DD`(B . "0x69AF") ;; <CJK>
       (?$(DDa(B . "0x69B7") ;; <CJK>
       (?$(DDb(B . "0x69B8") ;; <CJK>
       (?$(DDc(B . "0x69BA") ;; <CJK>
       (?$(DDd(B . "0x69BC") ;; <CJK>
       (?$(DDe(B . "0x69C5") ;; <CJK>
       (?$(DDf(B . "0x69C8") ;; <CJK>
       (?$(DDg(B . "0x69D1") ;; <CJK>
       (?$(DDh(B . "0x69D6") ;; <CJK>
       (?$(DDi(B . "0x69D7") ;; <CJK>
       (?$(DDj(B . "0x69E2") ;; <CJK>
       (?$(DDk(B . "0x69E5") ;; <CJK>
       (?$(DDl(B . "0x69EE") ;; <CJK>
       (?$(DDm(B . "0x69EF") ;; <CJK>
       (?$(DDn(B . "0x69F1") ;; <CJK>
       (?$(DDo(B . "0x69F3") ;; <CJK>
       (?$(DDp(B . "0x69F5") ;; <CJK>
       (?$(DDq(B . "0x69FE") ;; <CJK>
       (?$(DDr(B . "0x6A00") ;; <CJK>
       (?$(DDs(B . "0x6A01") ;; <CJK>
       (?$(DDt(B . "0x6A03") ;; <CJK>
       (?$(DDu(B . "0x6A0F") ;; <CJK>
       (?$(DDv(B . "0x6A11") ;; <CJK>
       (?$(DDw(B . "0x6A15") ;; <CJK>
       (?$(DDx(B . "0x6A1A") ;; <CJK>
       (?$(DDy(B . "0x6A1D") ;; <CJK>
       (?$(DDz(B . "0x6A20") ;; <CJK>
       (?$(DD{(B . "0x6A24") ;; <CJK>
       (?$(DD|(B . "0x6A28") ;; <CJK>
       (?$(DD}(B . "0x6A30") ;; <CJK>
       (?$(DD~(B . "0x6A32") ;; <CJK>
       (?$(DE!(B . "0x6A34") ;; <CJK>
       (?$(DE"(B . "0x6A37") ;; <CJK>
       (?$(DE#(B . "0x6A3B") ;; <CJK>
       (?$(DE$(B . "0x6A3E") ;; <CJK>
       (?$(DE%(B . "0x6A3F") ;; <CJK>
       (?$(DE&(B . "0x6A45") ;; <CJK>
       (?$(DE'(B . "0x6A46") ;; <CJK>
       (?$(DE((B . "0x6A49") ;; <CJK>
       (?$(DE)(B . "0x6A4A") ;; <CJK>
       (?$(DE*(B . "0x6A4E") ;; <CJK>
       (?$(DE+(B . "0x6A50") ;; <CJK>
       (?$(DE,(B . "0x6A51") ;; <CJK>
       (?$(DE-(B . "0x6A52") ;; <CJK>
       (?$(DE.(B . "0x6A55") ;; <CJK>
       (?$(DE/(B . "0x6A56") ;; <CJK>
       (?$(DE0(B . "0x6A5B") ;; <CJK>
       (?$(DE1(B . "0x6A64") ;; <CJK>
       (?$(DE2(B . "0x6A67") ;; <CJK>
       (?$(DE3(B . "0x6A6A") ;; <CJK>
       (?$(DE4(B . "0x6A71") ;; <CJK>
       (?$(DE5(B . "0x6A73") ;; <CJK>
       (?$(DE6(B . "0x6A7E") ;; <CJK>
       (?$(DE7(B . "0x6A81") ;; <CJK>
       (?$(DE8(B . "0x6A83") ;; <CJK>
       (?$(DE9(B . "0x6A86") ;; <CJK>
       (?$(DE:(B . "0x6A87") ;; <CJK>
       (?$(DE;(B . "0x6A89") ;; <CJK>
       (?$(DE<(B . "0x6A8B") ;; <CJK>
       (?$(DE=(B . "0x6A91") ;; <CJK>
       (?$(DE>(B . "0x6A9B") ;; <CJK>
       (?$(DE?(B . "0x6A9D") ;; <CJK>
       (?$(DE@(B . "0x6A9E") ;; <CJK>
       (?$(DEA(B . "0x6A9F") ;; <CJK>
       (?$(DEB(B . "0x6AA5") ;; <CJK>
       (?$(DEC(B . "0x6AAB") ;; <CJK>
       (?$(DED(B . "0x6AAF") ;; <CJK>
       (?$(DEE(B . "0x6AB0") ;; <CJK>
       (?$(DEF(B . "0x6AB1") ;; <CJK>
       (?$(DEG(B . "0x6AB4") ;; <CJK>
       (?$(DEH(B . "0x6ABD") ;; <CJK>
       (?$(DEI(B . "0x6ABE") ;; <CJK>
       (?$(DEJ(B . "0x6ABF") ;; <CJK>
       (?$(DEK(B . "0x6AC6") ;; <CJK>
       (?$(DEL(B . "0x6AC9") ;; <CJK>
       (?$(DEM(B . "0x6AC8") ;; <CJK>
       (?$(DEN(B . "0x6ACC") ;; <CJK>
       (?$(DEO(B . "0x6AD0") ;; <CJK>
       (?$(DEP(B . "0x6AD4") ;; <CJK>
       (?$(DEQ(B . "0x6AD5") ;; <CJK>
       (?$(DER(B . "0x6AD6") ;; <CJK>
       (?$(DES(B . "0x6ADC") ;; <CJK>
       (?$(DET(B . "0x6ADD") ;; <CJK>
       (?$(DEU(B . "0x6AE4") ;; <CJK>
       (?$(DEV(B . "0x6AE7") ;; <CJK>
       (?$(DEW(B . "0x6AEC") ;; <CJK>
       (?$(DEX(B . "0x6AF0") ;; <CJK>
       (?$(DEY(B . "0x6AF1") ;; <CJK>
       (?$(DEZ(B . "0x6AF2") ;; <CJK>
       (?$(DE[(B . "0x6AFC") ;; <CJK>
       (?$(DE\(B . "0x6AFD") ;; <CJK>
       (?$(DE](B . "0x6B02") ;; <CJK>
       (?$(DE^(B . "0x6B03") ;; <CJK>
       (?$(DE_(B . "0x6B06") ;; <CJK>
       (?$(DE`(B . "0x6B07") ;; <CJK>
       (?$(DEa(B . "0x6B09") ;; <CJK>
       (?$(DEb(B . "0x6B0F") ;; <CJK>
       (?$(DEc(B . "0x6B10") ;; <CJK>
       (?$(DEd(B . "0x6B11") ;; <CJK>
       (?$(DEe(B . "0x6B17") ;; <CJK>
       (?$(DEf(B . "0x6B1B") ;; <CJK>
       (?$(DEg(B . "0x6B1E") ;; <CJK>
       (?$(DEh(B . "0x6B24") ;; <CJK>
       (?$(DEi(B . "0x6B28") ;; <CJK>
       (?$(DEj(B . "0x6B2B") ;; <CJK>
       (?$(DEk(B . "0x6B2C") ;; <CJK>
       (?$(DEl(B . "0x6B2F") ;; <CJK>
       (?$(DEm(B . "0x6B35") ;; <CJK>
       (?$(DEn(B . "0x6B36") ;; <CJK>
       (?$(DEo(B . "0x6B3B") ;; <CJK>
       (?$(DEp(B . "0x6B3F") ;; <CJK>
       (?$(DEq(B . "0x6B46") ;; <CJK>
       (?$(DEr(B . "0x6B4A") ;; <CJK>
       (?$(DEs(B . "0x6B4D") ;; <CJK>
       (?$(DEt(B . "0x6B52") ;; <CJK>
       (?$(DEu(B . "0x6B56") ;; <CJK>
       (?$(DEv(B . "0x6B58") ;; <CJK>
       (?$(DEw(B . "0x6B5D") ;; <CJK>
       (?$(DEx(B . "0x6B60") ;; <CJK>
       (?$(DEy(B . "0x6B67") ;; <CJK>
       (?$(DEz(B . "0x6B6B") ;; <CJK>
       (?$(DE{(B . "0x6B6E") ;; <CJK>
       (?$(DE|(B . "0x6B70") ;; <CJK>
       (?$(DE}(B . "0x6B75") ;; <CJK>
       (?$(DE~(B . "0x6B7D") ;; <CJK>
       (?$(DF!(B . "0x6B7E") ;; <CJK>
       (?$(DF"(B . "0x6B82") ;; <CJK>
       (?$(DF#(B . "0x6B85") ;; <CJK>
       (?$(DF$(B . "0x6B97") ;; <CJK>
       (?$(DF%(B . "0x6B9B") ;; <CJK>
       (?$(DF&(B . "0x6B9F") ;; <CJK>
       (?$(DF'(B . "0x6BA0") ;; <CJK>
       (?$(DF((B . "0x6BA2") ;; <CJK>
       (?$(DF)(B . "0x6BA3") ;; <CJK>
       (?$(DF*(B . "0x6BA8") ;; <CJK>
       (?$(DF+(B . "0x6BA9") ;; <CJK>
       (?$(DF,(B . "0x6BAC") ;; <CJK>
       (?$(DF-(B . "0x6BAD") ;; <CJK>
       (?$(DF.(B . "0x6BAE") ;; <CJK>
       (?$(DF/(B . "0x6BB0") ;; <CJK>
       (?$(DF0(B . "0x6BB8") ;; <CJK>
       (?$(DF1(B . "0x6BB9") ;; <CJK>
       (?$(DF2(B . "0x6BBD") ;; <CJK>
       (?$(DF3(B . "0x6BBE") ;; <CJK>
       (?$(DF4(B . "0x6BC3") ;; <CJK>
       (?$(DF5(B . "0x6BC4") ;; <CJK>
       (?$(DF6(B . "0x6BC9") ;; <CJK>
       (?$(DF7(B . "0x6BCC") ;; <CJK>
       (?$(DF8(B . "0x6BD6") ;; <CJK>
       (?$(DF9(B . "0x6BDA") ;; <CJK>
       (?$(DF:(B . "0x6BE1") ;; <CJK>
       (?$(DF;(B . "0x6BE3") ;; <CJK>
       (?$(DF<(B . "0x6BE6") ;; <CJK>
       (?$(DF=(B . "0x6BE7") ;; <CJK>
       (?$(DF>(B . "0x6BEE") ;; <CJK>
       (?$(DF?(B . "0x6BF1") ;; <CJK>
       (?$(DF@(B . "0x6BF7") ;; <CJK>
       (?$(DFA(B . "0x6BF9") ;; <CJK>
       (?$(DFB(B . "0x6BFF") ;; <CJK>
       (?$(DFC(B . "0x6C02") ;; <CJK>
       (?$(DFD(B . "0x6C04") ;; <CJK>
       (?$(DFE(B . "0x6C05") ;; <CJK>
       (?$(DFF(B . "0x6C09") ;; <CJK>
       (?$(DFG(B . "0x6C0D") ;; <CJK>
       (?$(DFH(B . "0x6C0E") ;; <CJK>
       (?$(DFI(B . "0x6C10") ;; <CJK>
       (?$(DFJ(B . "0x6C12") ;; <CJK>
       (?$(DFK(B . "0x6C19") ;; <CJK>
       (?$(DFL(B . "0x6C1F") ;; <CJK>
       (?$(DFM(B . "0x6C26") ;; <CJK>
       (?$(DFN(B . "0x6C27") ;; <CJK>
       (?$(DFO(B . "0x6C28") ;; <CJK>
       (?$(DFP(B . "0x6C2C") ;; <CJK>
       (?$(DFQ(B . "0x6C2E") ;; <CJK>
       (?$(DFR(B . "0x6C33") ;; <CJK>
       (?$(DFS(B . "0x6C35") ;; <CJK>
       (?$(DFT(B . "0x6C36") ;; <CJK>
       (?$(DFU(B . "0x6C3A") ;; <CJK>
       (?$(DFV(B . "0x6C3B") ;; <CJK>
       (?$(DFW(B . "0x6C3F") ;; <CJK>
       (?$(DFX(B . "0x6C4A") ;; <CJK>
       (?$(DFY(B . "0x6C4B") ;; <CJK>
       (?$(DFZ(B . "0x6C4D") ;; <CJK>
       (?$(DF[(B . "0x6C4F") ;; <CJK>
       (?$(DF\(B . "0x6C52") ;; <CJK>
       (?$(DF](B . "0x6C54") ;; <CJK>
       (?$(DF^(B . "0x6C59") ;; <CJK>
       (?$(DF_(B . "0x6C5B") ;; <CJK>
       (?$(DF`(B . "0x6C5C") ;; <CJK>
       (?$(DFa(B . "0x6C6B") ;; <CJK>
       (?$(DFb(B . "0x6C6D") ;; <CJK>
       (?$(DFc(B . "0x6C6F") ;; <CJK>
       (?$(DFd(B . "0x6C74") ;; <CJK>
       (?$(DFe(B . "0x6C76") ;; <CJK>
       (?$(DFf(B . "0x6C78") ;; <CJK>
       (?$(DFg(B . "0x6C79") ;; <CJK>
       (?$(DFh(B . "0x6C7B") ;; <CJK>
       (?$(DFi(B . "0x6C85") ;; <CJK>
       (?$(DFj(B . "0x6C86") ;; <CJK>
       (?$(DFk(B . "0x6C87") ;; <CJK>
       (?$(DFl(B . "0x6C89") ;; <CJK>
       (?$(DFm(B . "0x6C94") ;; <CJK>
       (?$(DFn(B . "0x6C95") ;; <CJK>
       (?$(DFo(B . "0x6C97") ;; <CJK>
       (?$(DFp(B . "0x6C98") ;; <CJK>
       (?$(DFq(B . "0x6C9C") ;; <CJK>
       (?$(DFr(B . "0x6C9F") ;; <CJK>
       (?$(DFs(B . "0x6CB0") ;; <CJK>
       (?$(DFt(B . "0x6CB2") ;; <CJK>
       (?$(DFu(B . "0x6CB4") ;; <CJK>
       (?$(DFv(B . "0x6CC2") ;; <CJK>
       (?$(DFw(B . "0x6CC6") ;; <CJK>
       (?$(DFx(B . "0x6CCD") ;; <CJK>
       (?$(DFy(B . "0x6CCF") ;; <CJK>
       (?$(DFz(B . "0x6CD0") ;; <CJK>
       (?$(DF{(B . "0x6CD1") ;; <CJK>
       (?$(DF|(B . "0x6CD2") ;; <CJK>
       (?$(DF}(B . "0x6CD4") ;; <CJK>
       (?$(DF~(B . "0x6CD6") ;; <CJK>
       (?$(DG!(B . "0x6CDA") ;; <CJK>
       (?$(DG"(B . "0x6CDC") ;; <CJK>
       (?$(DG#(B . "0x6CE0") ;; <CJK>
       (?$(DG$(B . "0x6CE7") ;; <CJK>
       (?$(DG%(B . "0x6CE9") ;; <CJK>
       (?$(DG&(B . "0x6CEB") ;; <CJK>
       (?$(DG'(B . "0x6CEC") ;; <CJK>
       (?$(DG((B . "0x6CEE") ;; <CJK>
       (?$(DG)(B . "0x6CF2") ;; <CJK>
       (?$(DG*(B . "0x6CF4") ;; <CJK>
       (?$(DG+(B . "0x6D04") ;; <CJK>
       (?$(DG,(B . "0x6D07") ;; <CJK>
       (?$(DG-(B . "0x6D0A") ;; <CJK>
       (?$(DG.(B . "0x6D0E") ;; <CJK>
       (?$(DG/(B . "0x6D0F") ;; <CJK>
       (?$(DG0(B . "0x6D11") ;; <CJK>
       (?$(DG1(B . "0x6D13") ;; <CJK>
       (?$(DG2(B . "0x6D1A") ;; <CJK>
       (?$(DG3(B . "0x6D26") ;; <CJK>
       (?$(DG4(B . "0x6D27") ;; <CJK>
       (?$(DG5(B . "0x6D28") ;; <CJK>
       (?$(DG6(B . "0x6C67") ;; <CJK>
       (?$(DG7(B . "0x6D2E") ;; <CJK>
       (?$(DG8(B . "0x6D2F") ;; <CJK>
       (?$(DG9(B . "0x6D31") ;; <CJK>
       (?$(DG:(B . "0x6D39") ;; <CJK>
       (?$(DG;(B . "0x6D3C") ;; <CJK>
       (?$(DG<(B . "0x6D3F") ;; <CJK>
       (?$(DG=(B . "0x6D57") ;; <CJK>
       (?$(DG>(B . "0x6D5E") ;; <CJK>
       (?$(DG?(B . "0x6D5F") ;; <CJK>
       (?$(DG@(B . "0x6D61") ;; <CJK>
       (?$(DGA(B . "0x6D65") ;; <CJK>
       (?$(DGB(B . "0x6D67") ;; <CJK>
       (?$(DGC(B . "0x6D6F") ;; <CJK>
       (?$(DGD(B . "0x6D70") ;; <CJK>
       (?$(DGE(B . "0x6D7C") ;; <CJK>
       (?$(DGF(B . "0x6D82") ;; <CJK>
       (?$(DGG(B . "0x6D87") ;; <CJK>
       (?$(DGH(B . "0x6D91") ;; <CJK>
       (?$(DGI(B . "0x6D92") ;; <CJK>
       (?$(DGJ(B . "0x6D94") ;; <CJK>
       (?$(DGK(B . "0x6D96") ;; <CJK>
       (?$(DGL(B . "0x6D97") ;; <CJK>
       (?$(DGM(B . "0x6D98") ;; <CJK>
       (?$(DGN(B . "0x6DAA") ;; <CJK>
       (?$(DGO(B . "0x6DAC") ;; <CJK>
       (?$(DGP(B . "0x6DB4") ;; <CJK>
       (?$(DGQ(B . "0x6DB7") ;; <CJK>
       (?$(DGR(B . "0x6DB9") ;; <CJK>
       (?$(DGS(B . "0x6DBD") ;; <CJK>
       (?$(DGT(B . "0x6DBF") ;; <CJK>
       (?$(DGU(B . "0x6DC4") ;; <CJK>
       (?$(DGV(B . "0x6DC8") ;; <CJK>
       (?$(DGW(B . "0x6DCA") ;; <CJK>
       (?$(DGX(B . "0x6DCE") ;; <CJK>
       (?$(DGY(B . "0x6DCF") ;; <CJK>
       (?$(DGZ(B . "0x6DD6") ;; <CJK>
       (?$(DG[(B . "0x6DDB") ;; <CJK>
       (?$(DG\(B . "0x6DDD") ;; <CJK>
       (?$(DG](B . "0x6DDF") ;; <CJK>
       (?$(DG^(B . "0x6DE0") ;; <CJK>
       (?$(DG_(B . "0x6DE2") ;; <CJK>
       (?$(DG`(B . "0x6DE5") ;; <CJK>
       (?$(DGa(B . "0x6DE9") ;; <CJK>
       (?$(DGb(B . "0x6DEF") ;; <CJK>
       (?$(DGc(B . "0x6DF0") ;; <CJK>
       (?$(DGd(B . "0x6DF4") ;; <CJK>
       (?$(DGe(B . "0x6DF6") ;; <CJK>
       (?$(DGf(B . "0x6DFC") ;; <CJK>
       (?$(DGg(B . "0x6E00") ;; <CJK>
       (?$(DGh(B . "0x6E04") ;; <CJK>
       (?$(DGi(B . "0x6E1E") ;; <CJK>
       (?$(DGj(B . "0x6E22") ;; <CJK>
       (?$(DGk(B . "0x6E27") ;; <CJK>
       (?$(DGl(B . "0x6E32") ;; <CJK>
       (?$(DGm(B . "0x6E36") ;; <CJK>
       (?$(DGn(B . "0x6E39") ;; <CJK>
       (?$(DGo(B . "0x6E3B") ;; <CJK>
       (?$(DGp(B . "0x6E3C") ;; <CJK>
       (?$(DGq(B . "0x6E44") ;; <CJK>
       (?$(DGr(B . "0x6E45") ;; <CJK>
       (?$(DGs(B . "0x6E48") ;; <CJK>
       (?$(DGt(B . "0x6E49") ;; <CJK>
       (?$(DGu(B . "0x6E4B") ;; <CJK>
       (?$(DGv(B . "0x6E4F") ;; <CJK>
       (?$(DGw(B . "0x6E51") ;; <CJK>
       (?$(DGx(B . "0x6E52") ;; <CJK>
       (?$(DGy(B . "0x6E53") ;; <CJK>
       (?$(DGz(B . "0x6E54") ;; <CJK>
       (?$(DG{(B . "0x6E57") ;; <CJK>
       (?$(DG|(B . "0x6E5C") ;; <CJK>
       (?$(DG}(B . "0x6E5D") ;; <CJK>
       (?$(DG~(B . "0x6E5E") ;; <CJK>
       (?$(DH!(B . "0x6E62") ;; <CJK>
       (?$(DH"(B . "0x6E63") ;; <CJK>
       (?$(DH#(B . "0x6E68") ;; <CJK>
       (?$(DH$(B . "0x6E73") ;; <CJK>
       (?$(DH%(B . "0x6E7B") ;; <CJK>
       (?$(DH&(B . "0x6E7D") ;; <CJK>
       (?$(DH'(B . "0x6E8D") ;; <CJK>
       (?$(DH((B . "0x6E93") ;; <CJK>
       (?$(DH)(B . "0x6E99") ;; <CJK>
       (?$(DH*(B . "0x6EA0") ;; <CJK>
       (?$(DH+(B . "0x6EA7") ;; <CJK>
       (?$(DH,(B . "0x6EAD") ;; <CJK>
       (?$(DH-(B . "0x6EAE") ;; <CJK>
       (?$(DH.(B . "0x6EB1") ;; <CJK>
       (?$(DH/(B . "0x6EB3") ;; <CJK>
       (?$(DH0(B . "0x6EBB") ;; <CJK>
       (?$(DH1(B . "0x6EBF") ;; <CJK>
       (?$(DH2(B . "0x6EC0") ;; <CJK>
       (?$(DH3(B . "0x6EC1") ;; <CJK>
       (?$(DH4(B . "0x6EC3") ;; <CJK>
       (?$(DH5(B . "0x6EC7") ;; <CJK>
       (?$(DH6(B . "0x6EC8") ;; <CJK>
       (?$(DH7(B . "0x6ECA") ;; <CJK>
       (?$(DH8(B . "0x6ECD") ;; <CJK>
       (?$(DH9(B . "0x6ECE") ;; <CJK>
       (?$(DH:(B . "0x6ECF") ;; <CJK>
       (?$(DH;(B . "0x6EEB") ;; <CJK>
       (?$(DH<(B . "0x6EED") ;; <CJK>
       (?$(DH=(B . "0x6EEE") ;; <CJK>
       (?$(DH>(B . "0x6EF9") ;; <CJK>
       (?$(DH?(B . "0x6EFB") ;; <CJK>
       (?$(DH@(B . "0x6EFD") ;; <CJK>
       (?$(DHA(B . "0x6F04") ;; <CJK>
       (?$(DHB(B . "0x6F08") ;; <CJK>
       (?$(DHC(B . "0x6F0A") ;; <CJK>
       (?$(DHD(B . "0x6F0C") ;; <CJK>
       (?$(DHE(B . "0x6F0D") ;; <CJK>
       (?$(DHF(B . "0x6F16") ;; <CJK>
       (?$(DHG(B . "0x6F18") ;; <CJK>
       (?$(DHH(B . "0x6F1A") ;; <CJK>
       (?$(DHI(B . "0x6F1B") ;; <CJK>
       (?$(DHJ(B . "0x6F26") ;; <CJK>
       (?$(DHK(B . "0x6F29") ;; <CJK>
       (?$(DHL(B . "0x6F2A") ;; <CJK>
       (?$(DHM(B . "0x6F2F") ;; <CJK>
       (?$(DHN(B . "0x6F30") ;; <CJK>
       (?$(DHO(B . "0x6F33") ;; <CJK>
       (?$(DHP(B . "0x6F36") ;; <CJK>
       (?$(DHQ(B . "0x6F3B") ;; <CJK>
       (?$(DHR(B . "0x6F3C") ;; <CJK>
       (?$(DHS(B . "0x6F2D") ;; <CJK>
       (?$(DHT(B . "0x6F4F") ;; <CJK>
       (?$(DHU(B . "0x6F51") ;; <CJK>
       (?$(DHV(B . "0x6F52") ;; <CJK>
       (?$(DHW(B . "0x6F53") ;; <CJK>
       (?$(DHX(B . "0x6F57") ;; <CJK>
       (?$(DHY(B . "0x6F59") ;; <CJK>
       (?$(DHZ(B . "0x6F5A") ;; <CJK>
       (?$(DH[(B . "0x6F5D") ;; <CJK>
       (?$(DH\(B . "0x6F5E") ;; <CJK>
       (?$(DH](B . "0x6F61") ;; <CJK>
       (?$(DH^(B . "0x6F62") ;; <CJK>
       (?$(DH_(B . "0x6F68") ;; <CJK>
       (?$(DH`(B . "0x6F6C") ;; <CJK>
       (?$(DHa(B . "0x6F7D") ;; <CJK>
       (?$(DHb(B . "0x6F7E") ;; <CJK>
       (?$(DHc(B . "0x6F83") ;; <CJK>
       (?$(DHd(B . "0x6F87") ;; <CJK>
       (?$(DHe(B . "0x6F88") ;; <CJK>
       (?$(DHf(B . "0x6F8B") ;; <CJK>
       (?$(DHg(B . "0x6F8C") ;; <CJK>
       (?$(DHh(B . "0x6F8D") ;; <CJK>
       (?$(DHi(B . "0x6F90") ;; <CJK>
       (?$(DHj(B . "0x6F92") ;; <CJK>
       (?$(DHk(B . "0x6F93") ;; <CJK>
       (?$(DHl(B . "0x6F94") ;; <CJK>
       (?$(DHm(B . "0x6F96") ;; <CJK>
       (?$(DHn(B . "0x6F9A") ;; <CJK>
       (?$(DHo(B . "0x6F9F") ;; <CJK>
       (?$(DHp(B . "0x6FA0") ;; <CJK>
       (?$(DHq(B . "0x6FA5") ;; <CJK>
       (?$(DHr(B . "0x6FA6") ;; <CJK>
       (?$(DHs(B . "0x6FA7") ;; <CJK>
       (?$(DHt(B . "0x6FA8") ;; <CJK>
       (?$(DHu(B . "0x6FAE") ;; <CJK>
       (?$(DHv(B . "0x6FAF") ;; <CJK>
       (?$(DHw(B . "0x6FB0") ;; <CJK>
       (?$(DHx(B . "0x6FB5") ;; <CJK>
       (?$(DHy(B . "0x6FB6") ;; <CJK>
       (?$(DHz(B . "0x6FBC") ;; <CJK>
       (?$(DH{(B . "0x6FC5") ;; <CJK>
       (?$(DH|(B . "0x6FC7") ;; <CJK>
       (?$(DH}(B . "0x6FC8") ;; <CJK>
       (?$(DH~(B . "0x6FCA") ;; <CJK>
       (?$(DI!(B . "0x6FDA") ;; <CJK>
       (?$(DI"(B . "0x6FDE") ;; <CJK>
       (?$(DI#(B . "0x6FE8") ;; <CJK>
       (?$(DI$(B . "0x6FE9") ;; <CJK>
       (?$(DI%(B . "0x6FF0") ;; <CJK>
       (?$(DI&(B . "0x6FF5") ;; <CJK>
       (?$(DI'(B . "0x6FF9") ;; <CJK>
       (?$(DI((B . "0x6FFC") ;; <CJK>
       (?$(DI)(B . "0x6FFD") ;; <CJK>
       (?$(DI*(B . "0x7000") ;; <CJK>
       (?$(DI+(B . "0x7005") ;; <CJK>
       (?$(DI,(B . "0x7006") ;; <CJK>
       (?$(DI-(B . "0x7007") ;; <CJK>
       (?$(DI.(B . "0x700D") ;; <CJK>
       (?$(DI/(B . "0x7017") ;; <CJK>
       (?$(DI0(B . "0x7020") ;; <CJK>
       (?$(DI1(B . "0x7023") ;; <CJK>
       (?$(DI2(B . "0x702F") ;; <CJK>
       (?$(DI3(B . "0x7034") ;; <CJK>
       (?$(DI4(B . "0x7037") ;; <CJK>
       (?$(DI5(B . "0x7039") ;; <CJK>
       (?$(DI6(B . "0x703C") ;; <CJK>
       (?$(DI7(B . "0x7043") ;; <CJK>
       (?$(DI8(B . "0x7044") ;; <CJK>
       (?$(DI9(B . "0x7048") ;; <CJK>
       (?$(DI:(B . "0x7049") ;; <CJK>
       (?$(DI;(B . "0x704A") ;; <CJK>
       (?$(DI<(B . "0x704B") ;; <CJK>
       (?$(DI=(B . "0x7054") ;; <CJK>
       (?$(DI>(B . "0x7055") ;; <CJK>
       (?$(DI?(B . "0x705D") ;; <CJK>
       (?$(DI@(B . "0x705E") ;; <CJK>
       (?$(DIA(B . "0x704E") ;; <CJK>
       (?$(DIB(B . "0x7064") ;; <CJK>
       (?$(DIC(B . "0x7065") ;; <CJK>
       (?$(DID(B . "0x706C") ;; <CJK>
       (?$(DIE(B . "0x706E") ;; <CJK>
       (?$(DIF(B . "0x7075") ;; <CJK>
       (?$(DIG(B . "0x7076") ;; <CJK>
       (?$(DIH(B . "0x707E") ;; <CJK>
       (?$(DII(B . "0x7081") ;; <CJK>
       (?$(DIJ(B . "0x7085") ;; <CJK>
       (?$(DIK(B . "0x7086") ;; <CJK>
       (?$(DIL(B . "0x7094") ;; <CJK>
       (?$(DIM(B . "0x7095") ;; <CJK>
       (?$(DIN(B . "0x7096") ;; <CJK>
       (?$(DIO(B . "0x7097") ;; <CJK>
       (?$(DIP(B . "0x7098") ;; <CJK>
       (?$(DIQ(B . "0x709B") ;; <CJK>
       (?$(DIR(B . "0x70A4") ;; <CJK>
       (?$(DIS(B . "0x70AB") ;; <CJK>
       (?$(DIT(B . "0x70B0") ;; <CJK>
       (?$(DIU(B . "0x70B1") ;; <CJK>
       (?$(DIV(B . "0x70B4") ;; <CJK>
       (?$(DIW(B . "0x70B7") ;; <CJK>
       (?$(DIX(B . "0x70CA") ;; <CJK>
       (?$(DIY(B . "0x70D1") ;; <CJK>
       (?$(DIZ(B . "0x70D3") ;; <CJK>
       (?$(DI[(B . "0x70D4") ;; <CJK>
       (?$(DI\(B . "0x70D5") ;; <CJK>
       (?$(DI](B . "0x70D6") ;; <CJK>
       (?$(DI^(B . "0x70D8") ;; <CJK>
       (?$(DI_(B . "0x70DC") ;; <CJK>
       (?$(DI`(B . "0x70E4") ;; <CJK>
       (?$(DIa(B . "0x70FA") ;; <CJK>
       (?$(DIb(B . "0x7103") ;; <CJK>
       (?$(DIc(B . "0x7104") ;; <CJK>
       (?$(DId(B . "0x7105") ;; <CJK>
       (?$(DIe(B . "0x7106") ;; <CJK>
       (?$(DIf(B . "0x7107") ;; <CJK>
       (?$(DIg(B . "0x710B") ;; <CJK>
       (?$(DIh(B . "0x710C") ;; <CJK>
       (?$(DIi(B . "0x710F") ;; <CJK>
       (?$(DIj(B . "0x711E") ;; <CJK>
       (?$(DIk(B . "0x7120") ;; <CJK>
       (?$(DIl(B . "0x712B") ;; <CJK>
       (?$(DIm(B . "0x712D") ;; <CJK>
       (?$(DIn(B . "0x712F") ;; <CJK>
       (?$(DIo(B . "0x7130") ;; <CJK>
       (?$(DIp(B . "0x7131") ;; <CJK>
       (?$(DIq(B . "0x7138") ;; <CJK>
       (?$(DIr(B . "0x7141") ;; <CJK>
       (?$(DIs(B . "0x7145") ;; <CJK>
       (?$(DIt(B . "0x7146") ;; <CJK>
       (?$(DIu(B . "0x7147") ;; <CJK>
       (?$(DIv(B . "0x714A") ;; <CJK>
       (?$(DIw(B . "0x714B") ;; <CJK>
       (?$(DIx(B . "0x7150") ;; <CJK>
       (?$(DIy(B . "0x7152") ;; <CJK>
       (?$(DIz(B . "0x7157") ;; <CJK>
       (?$(DI{(B . "0x715A") ;; <CJK>
       (?$(DI|(B . "0x715C") ;; <CJK>
       (?$(DI}(B . "0x715E") ;; <CJK>
       (?$(DI~(B . "0x7160") ;; <CJK>
       (?$(DJ!(B . "0x7168") ;; <CJK>
       (?$(DJ"(B . "0x7179") ;; <CJK>
       (?$(DJ#(B . "0x7180") ;; <CJK>
       (?$(DJ$(B . "0x7185") ;; <CJK>
       (?$(DJ%(B . "0x7187") ;; <CJK>
       (?$(DJ&(B . "0x718C") ;; <CJK>
       (?$(DJ'(B . "0x7192") ;; <CJK>
       (?$(DJ((B . "0x719A") ;; <CJK>
       (?$(DJ)(B . "0x719B") ;; <CJK>
       (?$(DJ*(B . "0x71A0") ;; <CJK>
       (?$(DJ+(B . "0x71A2") ;; <CJK>
       (?$(DJ,(B . "0x71AF") ;; <CJK>
       (?$(DJ-(B . "0x71B0") ;; <CJK>
       (?$(DJ.(B . "0x71B2") ;; <CJK>
       (?$(DJ/(B . "0x71B3") ;; <CJK>
       (?$(DJ0(B . "0x71BA") ;; <CJK>
       (?$(DJ1(B . "0x71BF") ;; <CJK>
       (?$(DJ2(B . "0x71C0") ;; <CJK>
       (?$(DJ3(B . "0x71C1") ;; <CJK>
       (?$(DJ4(B . "0x71C4") ;; <CJK>
       (?$(DJ5(B . "0x71CB") ;; <CJK>
       (?$(DJ6(B . "0x71CC") ;; <CJK>
       (?$(DJ7(B . "0x71D3") ;; <CJK>
       (?$(DJ8(B . "0x71D6") ;; <CJK>
       (?$(DJ9(B . "0x71D9") ;; <CJK>
       (?$(DJ:(B . "0x71DA") ;; <CJK>
       (?$(DJ;(B . "0x71DC") ;; <CJK>
       (?$(DJ<(B . "0x71F8") ;; <CJK>
       (?$(DJ=(B . "0x71FE") ;; <CJK>
       (?$(DJ>(B . "0x7200") ;; <CJK>
       (?$(DJ?(B . "0x7207") ;; <CJK>
       (?$(DJ@(B . "0x7208") ;; <CJK>
       (?$(DJA(B . "0x7209") ;; <CJK>
       (?$(DJB(B . "0x7213") ;; <CJK>
       (?$(DJC(B . "0x7217") ;; <CJK>
       (?$(DJD(B . "0x721A") ;; <CJK>
       (?$(DJE(B . "0x721D") ;; <CJK>
       (?$(DJF(B . "0x721F") ;; <CJK>
       (?$(DJG(B . "0x7224") ;; <CJK>
       (?$(DJH(B . "0x722B") ;; <CJK>
       (?$(DJI(B . "0x722F") ;; <CJK>
       (?$(DJJ(B . "0x7234") ;; <CJK>
       (?$(DJK(B . "0x7238") ;; <CJK>
       (?$(DJL(B . "0x7239") ;; <CJK>
       (?$(DJM(B . "0x7241") ;; <CJK>
       (?$(DJN(B . "0x7242") ;; <CJK>
       (?$(DJO(B . "0x7243") ;; <CJK>
       (?$(DJP(B . "0x7245") ;; <CJK>
       (?$(DJQ(B . "0x724E") ;; <CJK>
       (?$(DJR(B . "0x724F") ;; <CJK>
       (?$(DJS(B . "0x7250") ;; <CJK>
       (?$(DJT(B . "0x7253") ;; <CJK>
       (?$(DJU(B . "0x7255") ;; <CJK>
       (?$(DJV(B . "0x7256") ;; <CJK>
       (?$(DJW(B . "0x725A") ;; <CJK>
       (?$(DJX(B . "0x725C") ;; <CJK>
       (?$(DJY(B . "0x725E") ;; <CJK>
       (?$(DJZ(B . "0x7260") ;; <CJK>
       (?$(DJ[(B . "0x7263") ;; <CJK>
       (?$(DJ\(B . "0x7268") ;; <CJK>
       (?$(DJ](B . "0x726B") ;; <CJK>
       (?$(DJ^(B . "0x726E") ;; <CJK>
       (?$(DJ_(B . "0x726F") ;; <CJK>
       (?$(DJ`(B . "0x7271") ;; <CJK>
       (?$(DJa(B . "0x7277") ;; <CJK>
       (?$(DJb(B . "0x7278") ;; <CJK>
       (?$(DJc(B . "0x727B") ;; <CJK>
       (?$(DJd(B . "0x727C") ;; <CJK>
       (?$(DJe(B . "0x727F") ;; <CJK>
       (?$(DJf(B . "0x7284") ;; <CJK>
       (?$(DJg(B . "0x7289") ;; <CJK>
       (?$(DJh(B . "0x728D") ;; <CJK>
       (?$(DJi(B . "0x728E") ;; <CJK>
       (?$(DJj(B . "0x7293") ;; <CJK>
       (?$(DJk(B . "0x729B") ;; <CJK>
       (?$(DJl(B . "0x72A8") ;; <CJK>
       (?$(DJm(B . "0x72AD") ;; <CJK>
       (?$(DJn(B . "0x72AE") ;; <CJK>
       (?$(DJo(B . "0x72B1") ;; <CJK>
       (?$(DJp(B . "0x72B4") ;; <CJK>
       (?$(DJq(B . "0x72BE") ;; <CJK>
       (?$(DJr(B . "0x72C1") ;; <CJK>
       (?$(DJs(B . "0x72C7") ;; <CJK>
       (?$(DJt(B . "0x72C9") ;; <CJK>
       (?$(DJu(B . "0x72CC") ;; <CJK>
       (?$(DJv(B . "0x72D5") ;; <CJK>
       (?$(DJw(B . "0x72D6") ;; <CJK>
       (?$(DJx(B . "0x72D8") ;; <CJK>
       (?$(DJy(B . "0x72DF") ;; <CJK>
       (?$(DJz(B . "0x72E5") ;; <CJK>
       (?$(DJ{(B . "0x72F3") ;; <CJK>
       (?$(DJ|(B . "0x72F4") ;; <CJK>
       (?$(DJ}(B . "0x72FA") ;; <CJK>
       (?$(DJ~(B . "0x72FB") ;; <CJK>
       (?$(DK!(B . "0x72FE") ;; <CJK>
       (?$(DK"(B . "0x7302") ;; <CJK>
       (?$(DK#(B . "0x7304") ;; <CJK>
       (?$(DK$(B . "0x7305") ;; <CJK>
       (?$(DK%(B . "0x7307") ;; <CJK>
       (?$(DK&(B . "0x730B") ;; <CJK>
       (?$(DK'(B . "0x730D") ;; <CJK>
       (?$(DK((B . "0x7312") ;; <CJK>
       (?$(DK)(B . "0x7313") ;; <CJK>
       (?$(DK*(B . "0x7318") ;; <CJK>
       (?$(DK+(B . "0x7319") ;; <CJK>
       (?$(DK,(B . "0x731E") ;; <CJK>
       (?$(DK-(B . "0x7322") ;; <CJK>
       (?$(DK.(B . "0x7324") ;; <CJK>
       (?$(DK/(B . "0x7327") ;; <CJK>
       (?$(DK0(B . "0x7328") ;; <CJK>
       (?$(DK1(B . "0x732C") ;; <CJK>
       (?$(DK2(B . "0x7331") ;; <CJK>
       (?$(DK3(B . "0x7332") ;; <CJK>
       (?$(DK4(B . "0x7335") ;; <CJK>
       (?$(DK5(B . "0x733A") ;; <CJK>
       (?$(DK6(B . "0x733B") ;; <CJK>
       (?$(DK7(B . "0x733D") ;; <CJK>
       (?$(DK8(B . "0x7343") ;; <CJK>
       (?$(DK9(B . "0x734D") ;; <CJK>
       (?$(DK:(B . "0x7350") ;; <CJK>
       (?$(DK;(B . "0x7352") ;; <CJK>
       (?$(DK<(B . "0x7356") ;; <CJK>
       (?$(DK=(B . "0x7358") ;; <CJK>
       (?$(DK>(B . "0x735D") ;; <CJK>
       (?$(DK?(B . "0x735E") ;; <CJK>
       (?$(DK@(B . "0x735F") ;; <CJK>
       (?$(DKA(B . "0x7360") ;; <CJK>
       (?$(DKB(B . "0x7366") ;; <CJK>
       (?$(DKC(B . "0x7367") ;; <CJK>
       (?$(DKD(B . "0x7369") ;; <CJK>
       (?$(DKE(B . "0x736B") ;; <CJK>
       (?$(DKF(B . "0x736C") ;; <CJK>
       (?$(DKG(B . "0x736E") ;; <CJK>
       (?$(DKH(B . "0x736F") ;; <CJK>
       (?$(DKI(B . "0x7371") ;; <CJK>
       (?$(DKJ(B . "0x7377") ;; <CJK>
       (?$(DKK(B . "0x7379") ;; <CJK>
       (?$(DKL(B . "0x737C") ;; <CJK>
       (?$(DKM(B . "0x7380") ;; <CJK>
       (?$(DKN(B . "0x7381") ;; <CJK>
       (?$(DKO(B . "0x7383") ;; <CJK>
       (?$(DKP(B . "0x7385") ;; <CJK>
       (?$(DKQ(B . "0x7386") ;; <CJK>
       (?$(DKR(B . "0x738E") ;; <CJK>
       (?$(DKS(B . "0x7390") ;; <CJK>
       (?$(DKT(B . "0x7393") ;; <CJK>
       (?$(DKU(B . "0x7395") ;; <CJK>
       (?$(DKV(B . "0x7397") ;; <CJK>
       (?$(DKW(B . "0x7398") ;; <CJK>
       (?$(DKX(B . "0x739C") ;; <CJK>
       (?$(DKY(B . "0x739E") ;; <CJK>
       (?$(DKZ(B . "0x739F") ;; <CJK>
       (?$(DK[(B . "0x73A0") ;; <CJK>
       (?$(DK\(B . "0x73A2") ;; <CJK>
       (?$(DK](B . "0x73A5") ;; <CJK>
       (?$(DK^(B . "0x73A6") ;; <CJK>
       (?$(DK_(B . "0x73AA") ;; <CJK>
       (?$(DK`(B . "0x73AB") ;; <CJK>
       (?$(DKa(B . "0x73AD") ;; <CJK>
       (?$(DKb(B . "0x73B5") ;; <CJK>
       (?$(DKc(B . "0x73B7") ;; <CJK>
       (?$(DKd(B . "0x73B9") ;; <CJK>
       (?$(DKe(B . "0x73BC") ;; <CJK>
       (?$(DKf(B . "0x73BD") ;; <CJK>
       (?$(DKg(B . "0x73BF") ;; <CJK>
       (?$(DKh(B . "0x73C5") ;; <CJK>
       (?$(DKi(B . "0x73C6") ;; <CJK>
       (?$(DKj(B . "0x73C9") ;; <CJK>
       (?$(DKk(B . "0x73CB") ;; <CJK>
       (?$(DKl(B . "0x73CC") ;; <CJK>
       (?$(DKm(B . "0x73CF") ;; <CJK>
       (?$(DKn(B . "0x73D2") ;; <CJK>
       (?$(DKo(B . "0x73D3") ;; <CJK>
       (?$(DKp(B . "0x73D6") ;; <CJK>
       (?$(DKq(B . "0x73D9") ;; <CJK>
       (?$(DKr(B . "0x73DD") ;; <CJK>
       (?$(DKs(B . "0x73E1") ;; <CJK>
       (?$(DKt(B . "0x73E3") ;; <CJK>
       (?$(DKu(B . "0x73E6") ;; <CJK>
       (?$(DKv(B . "0x73E7") ;; <CJK>
       (?$(DKw(B . "0x73E9") ;; <CJK>
       (?$(DKx(B . "0x73F4") ;; <CJK>
       (?$(DKy(B . "0x73F5") ;; <CJK>
       (?$(DKz(B . "0x73F7") ;; <CJK>
       (?$(DK{(B . "0x73F9") ;; <CJK>
       (?$(DK|(B . "0x73FA") ;; <CJK>
       (?$(DK}(B . "0x73FB") ;; <CJK>
       (?$(DK~(B . "0x73FD") ;; <CJK>
       (?$(DL!(B . "0x73FF") ;; <CJK>
       (?$(DL"(B . "0x7400") ;; <CJK>
       (?$(DL#(B . "0x7401") ;; <CJK>
       (?$(DL$(B . "0x7404") ;; <CJK>
       (?$(DL%(B . "0x7407") ;; <CJK>
       (?$(DL&(B . "0x740A") ;; <CJK>
       (?$(DL'(B . "0x7411") ;; <CJK>
       (?$(DL((B . "0x741A") ;; <CJK>
       (?$(DL)(B . "0x741B") ;; <CJK>
       (?$(DL*(B . "0x7424") ;; <CJK>
       (?$(DL+(B . "0x7426") ;; <CJK>
       (?$(DL,(B . "0x7428") ;; <CJK>
       (?$(DL-(B . "0x7429") ;; <CJK>
       (?$(DL.(B . "0x742A") ;; <CJK>
       (?$(DL/(B . "0x742B") ;; <CJK>
       (?$(DL0(B . "0x742C") ;; <CJK>
       (?$(DL1(B . "0x742D") ;; <CJK>
       (?$(DL2(B . "0x742E") ;; <CJK>
       (?$(DL3(B . "0x742F") ;; <CJK>
       (?$(DL4(B . "0x7430") ;; <CJK>
       (?$(DL5(B . "0x7431") ;; <CJK>
       (?$(DL6(B . "0x7439") ;; <CJK>
       (?$(DL7(B . "0x7440") ;; <CJK>
       (?$(DL8(B . "0x7443") ;; <CJK>
       (?$(DL9(B . "0x7444") ;; <CJK>
       (?$(DL:(B . "0x7446") ;; <CJK>
       (?$(DL;(B . "0x7447") ;; <CJK>
       (?$(DL<(B . "0x744B") ;; <CJK>
       (?$(DL=(B . "0x744D") ;; <CJK>
       (?$(DL>(B . "0x7451") ;; <CJK>
       (?$(DL?(B . "0x7452") ;; <CJK>
       (?$(DL@(B . "0x7457") ;; <CJK>
       (?$(DLA(B . "0x745D") ;; <CJK>
       (?$(DLB(B . "0x7462") ;; <CJK>
       (?$(DLC(B . "0x7466") ;; <CJK>
       (?$(DLD(B . "0x7467") ;; <CJK>
       (?$(DLE(B . "0x7468") ;; <CJK>
       (?$(DLF(B . "0x746B") ;; <CJK>
       (?$(DLG(B . "0x746D") ;; <CJK>
       (?$(DLH(B . "0x746E") ;; <CJK>
       (?$(DLI(B . "0x7471") ;; <CJK>
       (?$(DLJ(B . "0x7472") ;; <CJK>
       (?$(DLK(B . "0x7480") ;; <CJK>
       (?$(DLL(B . "0x7481") ;; <CJK>
       (?$(DLM(B . "0x7485") ;; <CJK>
       (?$(DLN(B . "0x7486") ;; <CJK>
       (?$(DLO(B . "0x7487") ;; <CJK>
       (?$(DLP(B . "0x7489") ;; <CJK>
       (?$(DLQ(B . "0x748F") ;; <CJK>
       (?$(DLR(B . "0x7490") ;; <CJK>
       (?$(DLS(B . "0x7491") ;; <CJK>
       (?$(DLT(B . "0x7492") ;; <CJK>
       (?$(DLU(B . "0x7498") ;; <CJK>
       (?$(DLV(B . "0x7499") ;; <CJK>
       (?$(DLW(B . "0x749A") ;; <CJK>
       (?$(DLX(B . "0x749C") ;; <CJK>
       (?$(DLY(B . "0x749F") ;; <CJK>
       (?$(DLZ(B . "0x74A0") ;; <CJK>
       (?$(DL[(B . "0x74A1") ;; <CJK>
       (?$(DL\(B . "0x74A3") ;; <CJK>
       (?$(DL](B . "0x74A6") ;; <CJK>
       (?$(DL^(B . "0x74A8") ;; <CJK>
       (?$(DL_(B . "0x74A9") ;; <CJK>
       (?$(DL`(B . "0x74AA") ;; <CJK>
       (?$(DLa(B . "0x74AB") ;; <CJK>
       (?$(DLb(B . "0x74AE") ;; <CJK>
       (?$(DLc(B . "0x74AF") ;; <CJK>
       (?$(DLd(B . "0x74B1") ;; <CJK>
       (?$(DLe(B . "0x74B2") ;; <CJK>
       (?$(DLf(B . "0x74B5") ;; <CJK>
       (?$(DLg(B . "0x74B9") ;; <CJK>
       (?$(DLh(B . "0x74BB") ;; <CJK>
       (?$(DLi(B . "0x74BF") ;; <CJK>
       (?$(DLj(B . "0x74C8") ;; <CJK>
       (?$(DLk(B . "0x74C9") ;; <CJK>
       (?$(DLl(B . "0x74CC") ;; <CJK>
       (?$(DLm(B . "0x74D0") ;; <CJK>
       (?$(DLn(B . "0x74D3") ;; <CJK>
       (?$(DLo(B . "0x74D8") ;; <CJK>
       (?$(DLp(B . "0x74DA") ;; <CJK>
       (?$(DLq(B . "0x74DB") ;; <CJK>
       (?$(DLr(B . "0x74DE") ;; <CJK>
       (?$(DLs(B . "0x74DF") ;; <CJK>
       (?$(DLt(B . "0x74E4") ;; <CJK>
       (?$(DLu(B . "0x74E8") ;; <CJK>
       (?$(DLv(B . "0x74EA") ;; <CJK>
       (?$(DLw(B . "0x74EB") ;; <CJK>
       (?$(DLx(B . "0x74EF") ;; <CJK>
       (?$(DLy(B . "0x74F4") ;; <CJK>
       (?$(DLz(B . "0x74FA") ;; <CJK>
       (?$(DL{(B . "0x74FB") ;; <CJK>
       (?$(DL|(B . "0x74FC") ;; <CJK>
       (?$(DL}(B . "0x74FF") ;; <CJK>
       (?$(DL~(B . "0x7506") ;; <CJK>
       (?$(DM!(B . "0x7512") ;; <CJK>
       (?$(DM"(B . "0x7516") ;; <CJK>
       (?$(DM#(B . "0x7517") ;; <CJK>
       (?$(DM$(B . "0x7520") ;; <CJK>
       (?$(DM%(B . "0x7521") ;; <CJK>
       (?$(DM&(B . "0x7524") ;; <CJK>
       (?$(DM'(B . "0x7527") ;; <CJK>
       (?$(DM((B . "0x7529") ;; <CJK>
       (?$(DM)(B . "0x752A") ;; <CJK>
       (?$(DM*(B . "0x752F") ;; <CJK>
       (?$(DM+(B . "0x7536") ;; <CJK>
       (?$(DM,(B . "0x7539") ;; <CJK>
       (?$(DM-(B . "0x753D") ;; <CJK>
       (?$(DM.(B . "0x753E") ;; <CJK>
       (?$(DM/(B . "0x753F") ;; <CJK>
       (?$(DM0(B . "0x7540") ;; <CJK>
       (?$(DM1(B . "0x7543") ;; <CJK>
       (?$(DM2(B . "0x7547") ;; <CJK>
       (?$(DM3(B . "0x7548") ;; <CJK>
       (?$(DM4(B . "0x754E") ;; <CJK>
       (?$(DM5(B . "0x7550") ;; <CJK>
       (?$(DM6(B . "0x7552") ;; <CJK>
       (?$(DM7(B . "0x7557") ;; <CJK>
       (?$(DM8(B . "0x755E") ;; <CJK>
       (?$(DM9(B . "0x755F") ;; <CJK>
       (?$(DM:(B . "0x7561") ;; <CJK>
       (?$(DM;(B . "0x756F") ;; <CJK>
       (?$(DM<(B . "0x7571") ;; <CJK>
       (?$(DM=(B . "0x7579") ;; <CJK>
       (?$(DM>(B . "0x757A") ;; <CJK>
       (?$(DM?(B . "0x757B") ;; <CJK>
       (?$(DM@(B . "0x757C") ;; <CJK>
       (?$(DMA(B . "0x757D") ;; <CJK>
       (?$(DMB(B . "0x757E") ;; <CJK>
       (?$(DMC(B . "0x7581") ;; <CJK>
       (?$(DMD(B . "0x7585") ;; <CJK>
       (?$(DME(B . "0x7590") ;; <CJK>
       (?$(DMF(B . "0x7592") ;; <CJK>
       (?$(DMG(B . "0x7593") ;; <CJK>
       (?$(DMH(B . "0x7595") ;; <CJK>
       (?$(DMI(B . "0x7599") ;; <CJK>
       (?$(DMJ(B . "0x759C") ;; <CJK>
       (?$(DMK(B . "0x75A2") ;; <CJK>
       (?$(DML(B . "0x75A4") ;; <CJK>
       (?$(DMM(B . "0x75B4") ;; <CJK>
       (?$(DMN(B . "0x75BA") ;; <CJK>
       (?$(DMO(B . "0x75BF") ;; <CJK>
       (?$(DMP(B . "0x75C0") ;; <CJK>
       (?$(DMQ(B . "0x75C1") ;; <CJK>
       (?$(DMR(B . "0x75C4") ;; <CJK>
       (?$(DMS(B . "0x75C6") ;; <CJK>
       (?$(DMT(B . "0x75CC") ;; <CJK>
       (?$(DMU(B . "0x75CE") ;; <CJK>
       (?$(DMV(B . "0x75CF") ;; <CJK>
       (?$(DMW(B . "0x75D7") ;; <CJK>
       (?$(DMX(B . "0x75DC") ;; <CJK>
       (?$(DMY(B . "0x75DF") ;; <CJK>
       (?$(DMZ(B . "0x75E0") ;; <CJK>
       (?$(DM[(B . "0x75E1") ;; <CJK>
       (?$(DM\(B . "0x75E4") ;; <CJK>
       (?$(DM](B . "0x75E7") ;; <CJK>
       (?$(DM^(B . "0x75EC") ;; <CJK>
       (?$(DM_(B . "0x75EE") ;; <CJK>
       (?$(DM`(B . "0x75EF") ;; <CJK>
       (?$(DMa(B . "0x75F1") ;; <CJK>
       (?$(DMb(B . "0x75F9") ;; <CJK>
       (?$(DMc(B . "0x7600") ;; <CJK>
       (?$(DMd(B . "0x7602") ;; <CJK>
       (?$(DMe(B . "0x7603") ;; <CJK>
       (?$(DMf(B . "0x7604") ;; <CJK>
       (?$(DMg(B . "0x7607") ;; <CJK>
       (?$(DMh(B . "0x7608") ;; <CJK>
       (?$(DMi(B . "0x760A") ;; <CJK>
       (?$(DMj(B . "0x760C") ;; <CJK>
       (?$(DMk(B . "0x760F") ;; <CJK>
       (?$(DMl(B . "0x7612") ;; <CJK>
       (?$(DMm(B . "0x7613") ;; <CJK>
       (?$(DMn(B . "0x7615") ;; <CJK>
       (?$(DMo(B . "0x7616") ;; <CJK>
       (?$(DMp(B . "0x7619") ;; <CJK>
       (?$(DMq(B . "0x761B") ;; <CJK>
       (?$(DMr(B . "0x761C") ;; <CJK>
       (?$(DMs(B . "0x761D") ;; <CJK>
       (?$(DMt(B . "0x761E") ;; <CJK>
       (?$(DMu(B . "0x7623") ;; <CJK>
       (?$(DMv(B . "0x7625") ;; <CJK>
       (?$(DMw(B . "0x7626") ;; <CJK>
       (?$(DMx(B . "0x7629") ;; <CJK>
       (?$(DMy(B . "0x762D") ;; <CJK>
       (?$(DMz(B . "0x7632") ;; <CJK>
       (?$(DM{(B . "0x7633") ;; <CJK>
       (?$(DM|(B . "0x7635") ;; <CJK>
       (?$(DM}(B . "0x7638") ;; <CJK>
       (?$(DM~(B . "0x7639") ;; <CJK>
       (?$(DN!(B . "0x763A") ;; <CJK>
       (?$(DN"(B . "0x763C") ;; <CJK>
       (?$(DN#(B . "0x764A") ;; <CJK>
       (?$(DN$(B . "0x7640") ;; <CJK>
       (?$(DN%(B . "0x7641") ;; <CJK>
       (?$(DN&(B . "0x7643") ;; <CJK>
       (?$(DN'(B . "0x7644") ;; <CJK>
       (?$(DN((B . "0x7645") ;; <CJK>
       (?$(DN)(B . "0x7649") ;; <CJK>
       (?$(DN*(B . "0x764B") ;; <CJK>
       (?$(DN+(B . "0x7655") ;; <CJK>
       (?$(DN,(B . "0x7659") ;; <CJK>
       (?$(DN-(B . "0x765F") ;; <CJK>
       (?$(DN.(B . "0x7664") ;; <CJK>
       (?$(DN/(B . "0x7665") ;; <CJK>
       (?$(DN0(B . "0x766D") ;; <CJK>
       (?$(DN1(B . "0x766E") ;; <CJK>
       (?$(DN2(B . "0x766F") ;; <CJK>
       (?$(DN3(B . "0x7671") ;; <CJK>
       (?$(DN4(B . "0x7674") ;; <CJK>
       (?$(DN5(B . "0x7681") ;; <CJK>
       (?$(DN6(B . "0x7685") ;; <CJK>
       (?$(DN7(B . "0x768C") ;; <CJK>
       (?$(DN8(B . "0x768D") ;; <CJK>
       (?$(DN9(B . "0x7695") ;; <CJK>
       (?$(DN:(B . "0x769B") ;; <CJK>
       (?$(DN;(B . "0x769C") ;; <CJK>
       (?$(DN<(B . "0x769D") ;; <CJK>
       (?$(DN=(B . "0x769F") ;; <CJK>
       (?$(DN>(B . "0x76A0") ;; <CJK>
       (?$(DN?(B . "0x76A2") ;; <CJK>
       (?$(DN@(B . "0x76A3") ;; <CJK>
       (?$(DNA(B . "0x76A4") ;; <CJK>
       (?$(DNB(B . "0x76A5") ;; <CJK>
       (?$(DNC(B . "0x76A6") ;; <CJK>
       (?$(DND(B . "0x76A7") ;; <CJK>
       (?$(DNE(B . "0x76A8") ;; <CJK>
       (?$(DNF(B . "0x76AA") ;; <CJK>
       (?$(DNG(B . "0x76AD") ;; <CJK>
       (?$(DNH(B . "0x76BD") ;; <CJK>
       (?$(DNI(B . "0x76C1") ;; <CJK>
       (?$(DNJ(B . "0x76C5") ;; <CJK>
       (?$(DNK(B . "0x76C9") ;; <CJK>
       (?$(DNL(B . "0x76CB") ;; <CJK>
       (?$(DNM(B . "0x76CC") ;; <CJK>
       (?$(DNN(B . "0x76CE") ;; <CJK>
       (?$(DNO(B . "0x76D4") ;; <CJK>
       (?$(DNP(B . "0x76D9") ;; <CJK>
       (?$(DNQ(B . "0x76E0") ;; <CJK>
       (?$(DNR(B . "0x76E6") ;; <CJK>
       (?$(DNS(B . "0x76E8") ;; <CJK>
       (?$(DNT(B . "0x76EC") ;; <CJK>
       (?$(DNU(B . "0x76F0") ;; <CJK>
       (?$(DNV(B . "0x76F1") ;; <CJK>
       (?$(DNW(B . "0x76F6") ;; <CJK>
       (?$(DNX(B . "0x76F9") ;; <CJK>
       (?$(DNY(B . "0x76FC") ;; <CJK>
       (?$(DNZ(B . "0x7700") ;; <CJK>
       (?$(DN[(B . "0x7706") ;; <CJK>
       (?$(DN\(B . "0x770A") ;; <CJK>
       (?$(DN](B . "0x770E") ;; <CJK>
       (?$(DN^(B . "0x7712") ;; <CJK>
       (?$(DN_(B . "0x7714") ;; <CJK>
       (?$(DN`(B . "0x7715") ;; <CJK>
       (?$(DNa(B . "0x7717") ;; <CJK>
       (?$(DNb(B . "0x7719") ;; <CJK>
       (?$(DNc(B . "0x771A") ;; <CJK>
       (?$(DNd(B . "0x771C") ;; <CJK>
       (?$(DNe(B . "0x7722") ;; <CJK>
       (?$(DNf(B . "0x7728") ;; <CJK>
       (?$(DNg(B . "0x772D") ;; <CJK>
       (?$(DNh(B . "0x772E") ;; <CJK>
       (?$(DNi(B . "0x772F") ;; <CJK>
       (?$(DNj(B . "0x7734") ;; <CJK>
       (?$(DNk(B . "0x7735") ;; <CJK>
       (?$(DNl(B . "0x7736") ;; <CJK>
       (?$(DNm(B . "0x7739") ;; <CJK>
       (?$(DNn(B . "0x773D") ;; <CJK>
       (?$(DNo(B . "0x773E") ;; <CJK>
       (?$(DNp(B . "0x7742") ;; <CJK>
       (?$(DNq(B . "0x7745") ;; <CJK>
       (?$(DNr(B . "0x7746") ;; <CJK>
       (?$(DNs(B . "0x774A") ;; <CJK>
       (?$(DNt(B . "0x774D") ;; <CJK>
       (?$(DNu(B . "0x774E") ;; <CJK>
       (?$(DNv(B . "0x774F") ;; <CJK>
       (?$(DNw(B . "0x7752") ;; <CJK>
       (?$(DNx(B . "0x7756") ;; <CJK>
       (?$(DNy(B . "0x7757") ;; <CJK>
       (?$(DNz(B . "0x775C") ;; <CJK>
       (?$(DN{(B . "0x775E") ;; <CJK>
       (?$(DN|(B . "0x775F") ;; <CJK>
       (?$(DN}(B . "0x7760") ;; <CJK>
       (?$(DN~(B . "0x7762") ;; <CJK>
       (?$(DO!(B . "0x7764") ;; <CJK>
       (?$(DO"(B . "0x7767") ;; <CJK>
       (?$(DO#(B . "0x776A") ;; <CJK>
       (?$(DO$(B . "0x776C") ;; <CJK>
       (?$(DO%(B . "0x7770") ;; <CJK>
       (?$(DO&(B . "0x7772") ;; <CJK>
       (?$(DO'(B . "0x7773") ;; <CJK>
       (?$(DO((B . "0x7774") ;; <CJK>
       (?$(DO)(B . "0x777A") ;; <CJK>
       (?$(DO*(B . "0x777D") ;; <CJK>
       (?$(DO+(B . "0x7780") ;; <CJK>
       (?$(DO,(B . "0x7784") ;; <CJK>
       (?$(DO-(B . "0x778C") ;; <CJK>
       (?$(DO.(B . "0x778D") ;; <CJK>
       (?$(DO/(B . "0x7794") ;; <CJK>
       (?$(DO0(B . "0x7795") ;; <CJK>
       (?$(DO1(B . "0x7796") ;; <CJK>
       (?$(DO2(B . "0x779A") ;; <CJK>
       (?$(DO3(B . "0x779F") ;; <CJK>
       (?$(DO4(B . "0x77A2") ;; <CJK>
       (?$(DO5(B . "0x77A7") ;; <CJK>
       (?$(DO6(B . "0x77AA") ;; <CJK>
       (?$(DO7(B . "0x77AE") ;; <CJK>
       (?$(DO8(B . "0x77AF") ;; <CJK>
       (?$(DO9(B . "0x77B1") ;; <CJK>
       (?$(DO:(B . "0x77B5") ;; <CJK>
       (?$(DO;(B . "0x77BE") ;; <CJK>
       (?$(DO<(B . "0x77C3") ;; <CJK>
       (?$(DO=(B . "0x77C9") ;; <CJK>
       (?$(DO>(B . "0x77D1") ;; <CJK>
       (?$(DO?(B . "0x77D2") ;; <CJK>
       (?$(DO@(B . "0x77D5") ;; <CJK>
       (?$(DOA(B . "0x77D9") ;; <CJK>
       (?$(DOB(B . "0x77DE") ;; <CJK>
       (?$(DOC(B . "0x77DF") ;; <CJK>
       (?$(DOD(B . "0x77E0") ;; <CJK>
       (?$(DOE(B . "0x77E4") ;; <CJK>
       (?$(DOF(B . "0x77E6") ;; <CJK>
       (?$(DOG(B . "0x77EA") ;; <CJK>
       (?$(DOH(B . "0x77EC") ;; <CJK>
       (?$(DOI(B . "0x77F0") ;; <CJK>
       (?$(DOJ(B . "0x77F1") ;; <CJK>
       (?$(DOK(B . "0x77F4") ;; <CJK>
       (?$(DOL(B . "0x77F8") ;; <CJK>
       (?$(DOM(B . "0x77FB") ;; <CJK>
       (?$(DON(B . "0x7805") ;; <CJK>
       (?$(DOO(B . "0x7806") ;; <CJK>
       (?$(DOP(B . "0x7809") ;; <CJK>
       (?$(DOQ(B . "0x780D") ;; <CJK>
       (?$(DOR(B . "0x780E") ;; <CJK>
       (?$(DOS(B . "0x7811") ;; <CJK>
       (?$(DOT(B . "0x781D") ;; <CJK>
       (?$(DOU(B . "0x7821") ;; <CJK>
       (?$(DOV(B . "0x7822") ;; <CJK>
       (?$(DOW(B . "0x7823") ;; <CJK>
       (?$(DOX(B . "0x782D") ;; <CJK>
       (?$(DOY(B . "0x782E") ;; <CJK>
       (?$(DOZ(B . "0x7830") ;; <CJK>
       (?$(DO[(B . "0x7835") ;; <CJK>
       (?$(DO\(B . "0x7837") ;; <CJK>
       (?$(DO](B . "0x7843") ;; <CJK>
       (?$(DO^(B . "0x7844") ;; <CJK>
       (?$(DO_(B . "0x7847") ;; <CJK>
       (?$(DO`(B . "0x7848") ;; <CJK>
       (?$(DOa(B . "0x784C") ;; <CJK>
       (?$(DOb(B . "0x784E") ;; <CJK>
       (?$(DOc(B . "0x7852") ;; <CJK>
       (?$(DOd(B . "0x785C") ;; <CJK>
       (?$(DOe(B . "0x785E") ;; <CJK>
       (?$(DOf(B . "0x7860") ;; <CJK>
       (?$(DOg(B . "0x7861") ;; <CJK>
       (?$(DOh(B . "0x7863") ;; <CJK>
       (?$(DOi(B . "0x7864") ;; <CJK>
       (?$(DOj(B . "0x7868") ;; <CJK>
       (?$(DOk(B . "0x786A") ;; <CJK>
       (?$(DOl(B . "0x786E") ;; <CJK>
       (?$(DOm(B . "0x787A") ;; <CJK>
       (?$(DOn(B . "0x787E") ;; <CJK>
       (?$(DOo(B . "0x788A") ;; <CJK>
       (?$(DOp(B . "0x788F") ;; <CJK>
       (?$(DOq(B . "0x7894") ;; <CJK>
       (?$(DOr(B . "0x7898") ;; <CJK>
       (?$(DOs(B . "0x78A1") ;; <CJK>
       (?$(DOt(B . "0x789D") ;; <CJK>
       (?$(DOu(B . "0x789E") ;; <CJK>
       (?$(DOv(B . "0x789F") ;; <CJK>
       (?$(DOw(B . "0x78A4") ;; <CJK>
       (?$(DOx(B . "0x78A8") ;; <CJK>
       (?$(DOy(B . "0x78AC") ;; <CJK>
       (?$(DOz(B . "0x78AD") ;; <CJK>
       (?$(DO{(B . "0x78B0") ;; <CJK>
       (?$(DO|(B . "0x78B1") ;; <CJK>
       (?$(DO}(B . "0x78B2") ;; <CJK>
       (?$(DO~(B . "0x78B3") ;; <CJK>
       (?$(DP!(B . "0x78BB") ;; <CJK>
       (?$(DP"(B . "0x78BD") ;; <CJK>
       (?$(DP#(B . "0x78BF") ;; <CJK>
       (?$(DP$(B . "0x78C7") ;; <CJK>
       (?$(DP%(B . "0x78C8") ;; <CJK>
       (?$(DP&(B . "0x78C9") ;; <CJK>
       (?$(DP'(B . "0x78CC") ;; <CJK>
       (?$(DP((B . "0x78CE") ;; <CJK>
       (?$(DP)(B . "0x78D2") ;; <CJK>
       (?$(DP*(B . "0x78D3") ;; <CJK>
       (?$(DP+(B . "0x78D5") ;; <CJK>
       (?$(DP,(B . "0x78D6") ;; <CJK>
       (?$(DP-(B . "0x78E4") ;; <CJK>
       (?$(DP.(B . "0x78DB") ;; <CJK>
       (?$(DP/(B . "0x78DF") ;; <CJK>
       (?$(DP0(B . "0x78E0") ;; <CJK>
       (?$(DP1(B . "0x78E1") ;; <CJK>
       (?$(DP2(B . "0x78E6") ;; <CJK>
       (?$(DP3(B . "0x78EA") ;; <CJK>
       (?$(DP4(B . "0x78F2") ;; <CJK>
       (?$(DP5(B . "0x78F3") ;; <CJK>
       (?$(DP6(B . "0x7900") ;; <CJK>
       (?$(DP7(B . "0x78F6") ;; <CJK>
       (?$(DP8(B . "0x78F7") ;; <CJK>
       (?$(DP9(B . "0x78FA") ;; <CJK>
       (?$(DP:(B . "0x78FB") ;; <CJK>
       (?$(DP;(B . "0x78FF") ;; <CJK>
       (?$(DP<(B . "0x7906") ;; <CJK>
       (?$(DP=(B . "0x790C") ;; <CJK>
       (?$(DP>(B . "0x7910") ;; <CJK>
       (?$(DP?(B . "0x791A") ;; <CJK>
       (?$(DP@(B . "0x791C") ;; <CJK>
       (?$(DPA(B . "0x791E") ;; <CJK>
       (?$(DPB(B . "0x791F") ;; <CJK>
       (?$(DPC(B . "0x7920") ;; <CJK>
       (?$(DPD(B . "0x7925") ;; <CJK>
       (?$(DPE(B . "0x7927") ;; <CJK>
       (?$(DPF(B . "0x7929") ;; <CJK>
       (?$(DPG(B . "0x792D") ;; <CJK>
       (?$(DPH(B . "0x7931") ;; <CJK>
       (?$(DPI(B . "0x7934") ;; <CJK>
       (?$(DPJ(B . "0x7935") ;; <CJK>
       (?$(DPK(B . "0x793B") ;; <CJK>
       (?$(DPL(B . "0x793D") ;; <CJK>
       (?$(DPM(B . "0x793F") ;; <CJK>
       (?$(DPN(B . "0x7944") ;; <CJK>
       (?$(DPO(B . "0x7945") ;; <CJK>
       (?$(DPP(B . "0x7946") ;; <CJK>
       (?$(DPQ(B . "0x794A") ;; <CJK>
       (?$(DPR(B . "0x794B") ;; <CJK>
       (?$(DPS(B . "0x794F") ;; <CJK>
       (?$(DPT(B . "0x7951") ;; <CJK>
       (?$(DPU(B . "0x7954") ;; <CJK>
       (?$(DPV(B . "0x7958") ;; <CJK>
       (?$(DPW(B . "0x795B") ;; <CJK>
       (?$(DPX(B . "0x795C") ;; <CJK>
       (?$(DPY(B . "0x7967") ;; <CJK>
       (?$(DPZ(B . "0x7969") ;; <CJK>
       (?$(DP[(B . "0x796B") ;; <CJK>
       (?$(DP\(B . "0x7972") ;; <CJK>
       (?$(DP](B . "0x7979") ;; <CJK>
       (?$(DP^(B . "0x797B") ;; <CJK>
       (?$(DP_(B . "0x797C") ;; <CJK>
       (?$(DP`(B . "0x797E") ;; <CJK>
       (?$(DPa(B . "0x798B") ;; <CJK>
       (?$(DPb(B . "0x798C") ;; <CJK>
       (?$(DPc(B . "0x7991") ;; <CJK>
       (?$(DPd(B . "0x7993") ;; <CJK>
       (?$(DPe(B . "0x7994") ;; <CJK>
       (?$(DPf(B . "0x7995") ;; <CJK>
       (?$(DPg(B . "0x7996") ;; <CJK>
       (?$(DPh(B . "0x7998") ;; <CJK>
       (?$(DPi(B . "0x799B") ;; <CJK>
       (?$(DPj(B . "0x799C") ;; <CJK>
       (?$(DPk(B . "0x79A1") ;; <CJK>
       (?$(DPl(B . "0x79A8") ;; <CJK>
       (?$(DPm(B . "0x79A9") ;; <CJK>
       (?$(DPn(B . "0x79AB") ;; <CJK>
       (?$(DPo(B . "0x79AF") ;; <CJK>
       (?$(DPp(B . "0x79B1") ;; <CJK>
       (?$(DPq(B . "0x79B4") ;; <CJK>
       (?$(DPr(B . "0x79B8") ;; <CJK>
       (?$(DPs(B . "0x79BB") ;; <CJK>
       (?$(DPt(B . "0x79C2") ;; <CJK>
       (?$(DPu(B . "0x79C4") ;; <CJK>
       (?$(DPv(B . "0x79C7") ;; <CJK>
       (?$(DPw(B . "0x79C8") ;; <CJK>
       (?$(DPx(B . "0x79CA") ;; <CJK>
       (?$(DPy(B . "0x79CF") ;; <CJK>
       (?$(DPz(B . "0x79D4") ;; <CJK>
       (?$(DP{(B . "0x79D6") ;; <CJK>
       (?$(DP|(B . "0x79DA") ;; <CJK>
       (?$(DP}(B . "0x79DD") ;; <CJK>
       (?$(DP~(B . "0x79DE") ;; <CJK>
       (?$(DQ!(B . "0x79E0") ;; <CJK>
       (?$(DQ"(B . "0x79E2") ;; <CJK>
       (?$(DQ#(B . "0x79E5") ;; <CJK>
       (?$(DQ$(B . "0x79EA") ;; <CJK>
       (?$(DQ%(B . "0x79EB") ;; <CJK>
       (?$(DQ&(B . "0x79ED") ;; <CJK>
       (?$(DQ'(B . "0x79F1") ;; <CJK>
       (?$(DQ((B . "0x79F8") ;; <CJK>
       (?$(DQ)(B . "0x79FC") ;; <CJK>
       (?$(DQ*(B . "0x7A02") ;; <CJK>
       (?$(DQ+(B . "0x7A03") ;; <CJK>
       (?$(DQ,(B . "0x7A07") ;; <CJK>
       (?$(DQ-(B . "0x7A09") ;; <CJK>
       (?$(DQ.(B . "0x7A0A") ;; <CJK>
       (?$(DQ/(B . "0x7A0C") ;; <CJK>
       (?$(DQ0(B . "0x7A11") ;; <CJK>
       (?$(DQ1(B . "0x7A15") ;; <CJK>
       (?$(DQ2(B . "0x7A1B") ;; <CJK>
       (?$(DQ3(B . "0x7A1E") ;; <CJK>
       (?$(DQ4(B . "0x7A21") ;; <CJK>
       (?$(DQ5(B . "0x7A27") ;; <CJK>
       (?$(DQ6(B . "0x7A2B") ;; <CJK>
       (?$(DQ7(B . "0x7A2D") ;; <CJK>
       (?$(DQ8(B . "0x7A2F") ;; <CJK>
       (?$(DQ9(B . "0x7A30") ;; <CJK>
       (?$(DQ:(B . "0x7A34") ;; <CJK>
       (?$(DQ;(B . "0x7A35") ;; <CJK>
       (?$(DQ<(B . "0x7A38") ;; <CJK>
       (?$(DQ=(B . "0x7A39") ;; <CJK>
       (?$(DQ>(B . "0x7A3A") ;; <CJK>
       (?$(DQ?(B . "0x7A44") ;; <CJK>
       (?$(DQ@(B . "0x7A45") ;; <CJK>
       (?$(DQA(B . "0x7A47") ;; <CJK>
       (?$(DQB(B . "0x7A48") ;; <CJK>
       (?$(DQC(B . "0x7A4C") ;; <CJK>
       (?$(DQD(B . "0x7A55") ;; <CJK>
       (?$(DQE(B . "0x7A56") ;; <CJK>
       (?$(DQF(B . "0x7A59") ;; <CJK>
       (?$(DQG(B . "0x7A5C") ;; <CJK>
       (?$(DQH(B . "0x7A5D") ;; <CJK>
       (?$(DQI(B . "0x7A5F") ;; <CJK>
       (?$(DQJ(B . "0x7A60") ;; <CJK>
       (?$(DQK(B . "0x7A65") ;; <CJK>
       (?$(DQL(B . "0x7A67") ;; <CJK>
       (?$(DQM(B . "0x7A6A") ;; <CJK>
       (?$(DQN(B . "0x7A6D") ;; <CJK>
       (?$(DQO(B . "0x7A75") ;; <CJK>
       (?$(DQP(B . "0x7A78") ;; <CJK>
       (?$(DQQ(B . "0x7A7E") ;; <CJK>
       (?$(DQR(B . "0x7A80") ;; <CJK>
       (?$(DQS(B . "0x7A82") ;; <CJK>
       (?$(DQT(B . "0x7A85") ;; <CJK>
       (?$(DQU(B . "0x7A86") ;; <CJK>
       (?$(DQV(B . "0x7A8A") ;; <CJK>
       (?$(DQW(B . "0x7A8B") ;; <CJK>
       (?$(DQX(B . "0x7A90") ;; <CJK>
       (?$(DQY(B . "0x7A91") ;; <CJK>
       (?$(DQZ(B . "0x7A94") ;; <CJK>
       (?$(DQ[(B . "0x7A9E") ;; <CJK>
       (?$(DQ\(B . "0x7AA0") ;; <CJK>
       (?$(DQ](B . "0x7AA3") ;; <CJK>
       (?$(DQ^(B . "0x7AAC") ;; <CJK>
       (?$(DQ_(B . "0x7AB3") ;; <CJK>
       (?$(DQ`(B . "0x7AB5") ;; <CJK>
       (?$(DQa(B . "0x7AB9") ;; <CJK>
       (?$(DQb(B . "0x7ABB") ;; <CJK>
       (?$(DQc(B . "0x7ABC") ;; <CJK>
       (?$(DQd(B . "0x7AC6") ;; <CJK>
       (?$(DQe(B . "0x7AC9") ;; <CJK>
       (?$(DQf(B . "0x7ACC") ;; <CJK>
       (?$(DQg(B . "0x7ACE") ;; <CJK>
       (?$(DQh(B . "0x7AD1") ;; <CJK>
       (?$(DQi(B . "0x7ADB") ;; <CJK>
       (?$(DQj(B . "0x7AE8") ;; <CJK>
       (?$(DQk(B . "0x7AE9") ;; <CJK>
       (?$(DQl(B . "0x7AEB") ;; <CJK>
       (?$(DQm(B . "0x7AEC") ;; <CJK>
       (?$(DQn(B . "0x7AF1") ;; <CJK>
       (?$(DQo(B . "0x7AF4") ;; <CJK>
       (?$(DQp(B . "0x7AFB") ;; <CJK>
       (?$(DQq(B . "0x7AFD") ;; <CJK>
       (?$(DQr(B . "0x7AFE") ;; <CJK>
       (?$(DQs(B . "0x7B07") ;; <CJK>
       (?$(DQt(B . "0x7B14") ;; <CJK>
       (?$(DQu(B . "0x7B1F") ;; <CJK>
       (?$(DQv(B . "0x7B23") ;; <CJK>
       (?$(DQw(B . "0x7B27") ;; <CJK>
       (?$(DQx(B . "0x7B29") ;; <CJK>
       (?$(DQy(B . "0x7B2A") ;; <CJK>
       (?$(DQz(B . "0x7B2B") ;; <CJK>
       (?$(DQ{(B . "0x7B2D") ;; <CJK>
       (?$(DQ|(B . "0x7B2E") ;; <CJK>
       (?$(DQ}(B . "0x7B2F") ;; <CJK>
       (?$(DQ~(B . "0x7B30") ;; <CJK>
       (?$(DR!(B . "0x7B31") ;; <CJK>
       (?$(DR"(B . "0x7B34") ;; <CJK>
       (?$(DR#(B . "0x7B3D") ;; <CJK>
       (?$(DR$(B . "0x7B3F") ;; <CJK>
       (?$(DR%(B . "0x7B40") ;; <CJK>
       (?$(DR&(B . "0x7B41") ;; <CJK>
       (?$(DR'(B . "0x7B47") ;; <CJK>
       (?$(DR((B . "0x7B4E") ;; <CJK>
       (?$(DR)(B . "0x7B55") ;; <CJK>
       (?$(DR*(B . "0x7B60") ;; <CJK>
       (?$(DR+(B . "0x7B64") ;; <CJK>
       (?$(DR,(B . "0x7B66") ;; <CJK>
       (?$(DR-(B . "0x7B69") ;; <CJK>
       (?$(DR.(B . "0x7B6A") ;; <CJK>
       (?$(DR/(B . "0x7B6D") ;; <CJK>
       (?$(DR0(B . "0x7B6F") ;; <CJK>
       (?$(DR1(B . "0x7B72") ;; <CJK>
       (?$(DR2(B . "0x7B73") ;; <CJK>
       (?$(DR3(B . "0x7B77") ;; <CJK>
       (?$(DR4(B . "0x7B84") ;; <CJK>
       (?$(DR5(B . "0x7B89") ;; <CJK>
       (?$(DR6(B . "0x7B8E") ;; <CJK>
       (?$(DR7(B . "0x7B90") ;; <CJK>
       (?$(DR8(B . "0x7B91") ;; <CJK>
       (?$(DR9(B . "0x7B96") ;; <CJK>
       (?$(DR:(B . "0x7B9B") ;; <CJK>
       (?$(DR;(B . "0x7B9E") ;; <CJK>
       (?$(DR<(B . "0x7BA0") ;; <CJK>
       (?$(DR=(B . "0x7BA5") ;; <CJK>
       (?$(DR>(B . "0x7BAC") ;; <CJK>
       (?$(DR?(B . "0x7BAF") ;; <CJK>
       (?$(DR@(B . "0x7BB0") ;; <CJK>
       (?$(DRA(B . "0x7BB2") ;; <CJK>
       (?$(DRB(B . "0x7BB5") ;; <CJK>
       (?$(DRC(B . "0x7BB6") ;; <CJK>
       (?$(DRD(B . "0x7BBA") ;; <CJK>
       (?$(DRE(B . "0x7BBB") ;; <CJK>
       (?$(DRF(B . "0x7BBC") ;; <CJK>
       (?$(DRG(B . "0x7BBD") ;; <CJK>
       (?$(DRH(B . "0x7BC2") ;; <CJK>
       (?$(DRI(B . "0x7BC5") ;; <CJK>
       (?$(DRJ(B . "0x7BC8") ;; <CJK>
       (?$(DRK(B . "0x7BCA") ;; <CJK>
       (?$(DRL(B . "0x7BD4") ;; <CJK>
       (?$(DRM(B . "0x7BD6") ;; <CJK>
       (?$(DRN(B . "0x7BD7") ;; <CJK>
       (?$(DRO(B . "0x7BD9") ;; <CJK>
       (?$(DRP(B . "0x7BDA") ;; <CJK>
       (?$(DRQ(B . "0x7BDB") ;; <CJK>
       (?$(DRR(B . "0x7BE8") ;; <CJK>
       (?$(DRS(B . "0x7BEA") ;; <CJK>
       (?$(DRT(B . "0x7BF2") ;; <CJK>
       (?$(DRU(B . "0x7BF4") ;; <CJK>
       (?$(DRV(B . "0x7BF5") ;; <CJK>
       (?$(DRW(B . "0x7BF8") ;; <CJK>
       (?$(DRX(B . "0x7BF9") ;; <CJK>
       (?$(DRY(B . "0x7BFA") ;; <CJK>
       (?$(DRZ(B . "0x7BFC") ;; <CJK>
       (?$(DR[(B . "0x7BFE") ;; <CJK>
       (?$(DR\(B . "0x7C01") ;; <CJK>
       (?$(DR](B . "0x7C02") ;; <CJK>
       (?$(DR^(B . "0x7C03") ;; <CJK>
       (?$(DR_(B . "0x7C04") ;; <CJK>
       (?$(DR`(B . "0x7C06") ;; <CJK>
       (?$(DRa(B . "0x7C09") ;; <CJK>
       (?$(DRb(B . "0x7C0B") ;; <CJK>
       (?$(DRc(B . "0x7C0C") ;; <CJK>
       (?$(DRd(B . "0x7C0E") ;; <CJK>
       (?$(DRe(B . "0x7C0F") ;; <CJK>
       (?$(DRf(B . "0x7C19") ;; <CJK>
       (?$(DRg(B . "0x7C1B") ;; <CJK>
       (?$(DRh(B . "0x7C20") ;; <CJK>
       (?$(DRi(B . "0x7C25") ;; <CJK>
       (?$(DRj(B . "0x7C26") ;; <CJK>
       (?$(DRk(B . "0x7C28") ;; <CJK>
       (?$(DRl(B . "0x7C2C") ;; <CJK>
       (?$(DRm(B . "0x7C31") ;; <CJK>
       (?$(DRn(B . "0x7C33") ;; <CJK>
       (?$(DRo(B . "0x7C34") ;; <CJK>
       (?$(DRp(B . "0x7C36") ;; <CJK>
       (?$(DRq(B . "0x7C39") ;; <CJK>
       (?$(DRr(B . "0x7C3A") ;; <CJK>
       (?$(DRs(B . "0x7C46") ;; <CJK>
       (?$(DRt(B . "0x7C4A") ;; <CJK>
       (?$(DRu(B . "0x7C55") ;; <CJK>
       (?$(DRv(B . "0x7C51") ;; <CJK>
       (?$(DRw(B . "0x7C52") ;; <CJK>
       (?$(DRx(B . "0x7C53") ;; <CJK>
       (?$(DRy(B . "0x7C59") ;; <CJK>
       (?$(DRz(B . "0x7C5A") ;; <CJK>
       (?$(DR{(B . "0x7C5B") ;; <CJK>
       (?$(DR|(B . "0x7C5C") ;; <CJK>
       (?$(DR}(B . "0x7C5D") ;; <CJK>
       (?$(DR~(B . "0x7C5E") ;; <CJK>
       (?$(DS!(B . "0x7C61") ;; <CJK>
       (?$(DS"(B . "0x7C63") ;; <CJK>
       (?$(DS#(B . "0x7C67") ;; <CJK>
       (?$(DS$(B . "0x7C69") ;; <CJK>
       (?$(DS%(B . "0x7C6D") ;; <CJK>
       (?$(DS&(B . "0x7C6E") ;; <CJK>
       (?$(DS'(B . "0x7C70") ;; <CJK>
       (?$(DS((B . "0x7C72") ;; <CJK>
       (?$(DS)(B . "0x7C79") ;; <CJK>
       (?$(DS*(B . "0x7C7C") ;; <CJK>
       (?$(DS+(B . "0x7C7D") ;; <CJK>
       (?$(DS,(B . "0x7C86") ;; <CJK>
       (?$(DS-(B . "0x7C87") ;; <CJK>
       (?$(DS.(B . "0x7C8F") ;; <CJK>
       (?$(DS/(B . "0x7C94") ;; <CJK>
       (?$(DS0(B . "0x7C9E") ;; <CJK>
       (?$(DS1(B . "0x7CA0") ;; <CJK>
       (?$(DS2(B . "0x7CA6") ;; <CJK>
       (?$(DS3(B . "0x7CB0") ;; <CJK>
       (?$(DS4(B . "0x7CB6") ;; <CJK>
       (?$(DS5(B . "0x7CB7") ;; <CJK>
       (?$(DS6(B . "0x7CBA") ;; <CJK>
       (?$(DS7(B . "0x7CBB") ;; <CJK>
       (?$(DS8(B . "0x7CBC") ;; <CJK>
       (?$(DS9(B . "0x7CBF") ;; <CJK>
       (?$(DS:(B . "0x7CC4") ;; <CJK>
       (?$(DS;(B . "0x7CC7") ;; <CJK>
       (?$(DS<(B . "0x7CC8") ;; <CJK>
       (?$(DS=(B . "0x7CC9") ;; <CJK>
       (?$(DS>(B . "0x7CCD") ;; <CJK>
       (?$(DS?(B . "0x7CCF") ;; <CJK>
       (?$(DS@(B . "0x7CD3") ;; <CJK>
       (?$(DSA(B . "0x7CD4") ;; <CJK>
       (?$(DSB(B . "0x7CD5") ;; <CJK>
       (?$(DSC(B . "0x7CD7") ;; <CJK>
       (?$(DSD(B . "0x7CD9") ;; <CJK>
       (?$(DSE(B . "0x7CDA") ;; <CJK>
       (?$(DSF(B . "0x7CDD") ;; <CJK>
       (?$(DSG(B . "0x7CE6") ;; <CJK>
       (?$(DSH(B . "0x7CE9") ;; <CJK>
       (?$(DSI(B . "0x7CEB") ;; <CJK>
       (?$(DSJ(B . "0x7CF5") ;; <CJK>
       (?$(DSK(B . "0x7D03") ;; <CJK>
       (?$(DSL(B . "0x7D07") ;; <CJK>
       (?$(DSM(B . "0x7D08") ;; <CJK>
       (?$(DSN(B . "0x7D09") ;; <CJK>
       (?$(DSO(B . "0x7D0F") ;; <CJK>
       (?$(DSP(B . "0x7D11") ;; <CJK>
       (?$(DSQ(B . "0x7D12") ;; <CJK>
       (?$(DSR(B . "0x7D13") ;; <CJK>
       (?$(DSS(B . "0x7D16") ;; <CJK>
       (?$(DST(B . "0x7D1D") ;; <CJK>
       (?$(DSU(B . "0x7D1E") ;; <CJK>
       (?$(DSV(B . "0x7D23") ;; <CJK>
       (?$(DSW(B . "0x7D26") ;; <CJK>
       (?$(DSX(B . "0x7D2A") ;; <CJK>
       (?$(DSY(B . "0x7D2D") ;; <CJK>
       (?$(DSZ(B . "0x7D31") ;; <CJK>
       (?$(DS[(B . "0x7D3C") ;; <CJK>
       (?$(DS\(B . "0x7D3D") ;; <CJK>
       (?$(DS](B . "0x7D3E") ;; <CJK>
       (?$(DS^(B . "0x7D40") ;; <CJK>
       (?$(DS_(B . "0x7D41") ;; <CJK>
       (?$(DS`(B . "0x7D47") ;; <CJK>
       (?$(DSa(B . "0x7D48") ;; <CJK>
       (?$(DSb(B . "0x7D4D") ;; <CJK>
       (?$(DSc(B . "0x7D51") ;; <CJK>
       (?$(DSd(B . "0x7D53") ;; <CJK>
       (?$(DSe(B . "0x7D57") ;; <CJK>
       (?$(DSf(B . "0x7D59") ;; <CJK>
       (?$(DSg(B . "0x7D5A") ;; <CJK>
       (?$(DSh(B . "0x7D5C") ;; <CJK>
       (?$(DSi(B . "0x7D5D") ;; <CJK>
       (?$(DSj(B . "0x7D65") ;; <CJK>
       (?$(DSk(B . "0x7D67") ;; <CJK>
       (?$(DSl(B . "0x7D6A") ;; <CJK>
       (?$(DSm(B . "0x7D70") ;; <CJK>
       (?$(DSn(B . "0x7D78") ;; <CJK>
       (?$(DSo(B . "0x7D7A") ;; <CJK>
       (?$(DSp(B . "0x7D7B") ;; <CJK>
       (?$(DSq(B . "0x7D7F") ;; <CJK>
       (?$(DSr(B . "0x7D81") ;; <CJK>
       (?$(DSs(B . "0x7D82") ;; <CJK>
       (?$(DSt(B . "0x7D83") ;; <CJK>
       (?$(DSu(B . "0x7D85") ;; <CJK>
       (?$(DSv(B . "0x7D86") ;; <CJK>
       (?$(DSw(B . "0x7D88") ;; <CJK>
       (?$(DSx(B . "0x7D8B") ;; <CJK>
       (?$(DSy(B . "0x7D8C") ;; <CJK>
       (?$(DSz(B . "0x7D8D") ;; <CJK>
       (?$(DS{(B . "0x7D91") ;; <CJK>
       (?$(DS|(B . "0x7D96") ;; <CJK>
       (?$(DS}(B . "0x7D97") ;; <CJK>
       (?$(DS~(B . "0x7D9D") ;; <CJK>
       (?$(DT!(B . "0x7D9E") ;; <CJK>
       (?$(DT"(B . "0x7DA6") ;; <CJK>
       (?$(DT#(B . "0x7DA7") ;; <CJK>
       (?$(DT$(B . "0x7DAA") ;; <CJK>
       (?$(DT%(B . "0x7DB3") ;; <CJK>
       (?$(DT&(B . "0x7DB6") ;; <CJK>
       (?$(DT'(B . "0x7DB7") ;; <CJK>
       (?$(DT((B . "0x7DB9") ;; <CJK>
       (?$(DT)(B . "0x7DC2") ;; <CJK>
       (?$(DT*(B . "0x7DC3") ;; <CJK>
       (?$(DT+(B . "0x7DC4") ;; <CJK>
       (?$(DT,(B . "0x7DC5") ;; <CJK>
       (?$(DT-(B . "0x7DC6") ;; <CJK>
       (?$(DT.(B . "0x7DCC") ;; <CJK>
       (?$(DT/(B . "0x7DCD") ;; <CJK>
       (?$(DT0(B . "0x7DCE") ;; <CJK>
       (?$(DT1(B . "0x7DD7") ;; <CJK>
       (?$(DT2(B . "0x7DD9") ;; <CJK>
       (?$(DT3(B . "0x7E00") ;; <CJK>
       (?$(DT4(B . "0x7DE2") ;; <CJK>
       (?$(DT5(B . "0x7DE5") ;; <CJK>
       (?$(DT6(B . "0x7DE6") ;; <CJK>
       (?$(DT7(B . "0x7DEA") ;; <CJK>
       (?$(DT8(B . "0x7DEB") ;; <CJK>
       (?$(DT9(B . "0x7DED") ;; <CJK>
       (?$(DT:(B . "0x7DF1") ;; <CJK>
       (?$(DT;(B . "0x7DF5") ;; <CJK>
       (?$(DT<(B . "0x7DF6") ;; <CJK>
       (?$(DT=(B . "0x7DF9") ;; <CJK>
       (?$(DT>(B . "0x7DFA") ;; <CJK>
       (?$(DT?(B . "0x7E08") ;; <CJK>
       (?$(DT@(B . "0x7E10") ;; <CJK>
       (?$(DTA(B . "0x7E11") ;; <CJK>
       (?$(DTB(B . "0x7E15") ;; <CJK>
       (?$(DTC(B . "0x7E17") ;; <CJK>
       (?$(DTD(B . "0x7E1C") ;; <CJK>
       (?$(DTE(B . "0x7E1D") ;; <CJK>
       (?$(DTF(B . "0x7E20") ;; <CJK>
       (?$(DTG(B . "0x7E27") ;; <CJK>
       (?$(DTH(B . "0x7E28") ;; <CJK>
       (?$(DTI(B . "0x7E2C") ;; <CJK>
       (?$(DTJ(B . "0x7E2D") ;; <CJK>
       (?$(DTK(B . "0x7E2F") ;; <CJK>
       (?$(DTL(B . "0x7E33") ;; <CJK>
       (?$(DTM(B . "0x7E36") ;; <CJK>
       (?$(DTN(B . "0x7E3F") ;; <CJK>
       (?$(DTO(B . "0x7E44") ;; <CJK>
       (?$(DTP(B . "0x7E45") ;; <CJK>
       (?$(DTQ(B . "0x7E47") ;; <CJK>
       (?$(DTR(B . "0x7E4E") ;; <CJK>
       (?$(DTS(B . "0x7E50") ;; <CJK>
       (?$(DTT(B . "0x7E52") ;; <CJK>
       (?$(DTU(B . "0x7E58") ;; <CJK>
       (?$(DTV(B . "0x7E5F") ;; <CJK>
       (?$(DTW(B . "0x7E61") ;; <CJK>
       (?$(DTX(B . "0x7E62") ;; <CJK>
       (?$(DTY(B . "0x7E65") ;; <CJK>
       (?$(DTZ(B . "0x7E6B") ;; <CJK>
       (?$(DT[(B . "0x7E6E") ;; <CJK>
       (?$(DT\(B . "0x7E6F") ;; <CJK>
       (?$(DT](B . "0x7E73") ;; <CJK>
       (?$(DT^(B . "0x7E78") ;; <CJK>
       (?$(DT_(B . "0x7E7E") ;; <CJK>
       (?$(DT`(B . "0x7E81") ;; <CJK>
       (?$(DTa(B . "0x7E86") ;; <CJK>
       (?$(DTb(B . "0x7E87") ;; <CJK>
       (?$(DTc(B . "0x7E8A") ;; <CJK>
       (?$(DTd(B . "0x7E8D") ;; <CJK>
       (?$(DTe(B . "0x7E91") ;; <CJK>
       (?$(DTf(B . "0x7E95") ;; <CJK>
       (?$(DTg(B . "0x7E98") ;; <CJK>
       (?$(DTh(B . "0x7E9A") ;; <CJK>
       (?$(DTi(B . "0x7E9D") ;; <CJK>
       (?$(DTj(B . "0x7E9E") ;; <CJK>
       (?$(DTk(B . "0x7F3C") ;; <CJK>
       (?$(DTl(B . "0x7F3B") ;; <CJK>
       (?$(DTm(B . "0x7F3D") ;; <CJK>
       (?$(DTn(B . "0x7F3E") ;; <CJK>
       (?$(DTo(B . "0x7F3F") ;; <CJK>
       (?$(DTp(B . "0x7F43") ;; <CJK>
       (?$(DTq(B . "0x7F44") ;; <CJK>
       (?$(DTr(B . "0x7F47") ;; <CJK>
       (?$(DTs(B . "0x7F4F") ;; <CJK>
       (?$(DTt(B . "0x7F52") ;; <CJK>
       (?$(DTu(B . "0x7F53") ;; <CJK>
       (?$(DTv(B . "0x7F5B") ;; <CJK>
       (?$(DTw(B . "0x7F5C") ;; <CJK>
       (?$(DTx(B . "0x7F5D") ;; <CJK>
       (?$(DTy(B . "0x7F61") ;; <CJK>
       (?$(DTz(B . "0x7F63") ;; <CJK>
       (?$(DT{(B . "0x7F64") ;; <CJK>
       (?$(DT|(B . "0x7F65") ;; <CJK>
       (?$(DT}(B . "0x7F66") ;; <CJK>
       (?$(DT~(B . "0x7F6D") ;; <CJK>
       (?$(DU!(B . "0x7F71") ;; <CJK>
       (?$(DU"(B . "0x7F7D") ;; <CJK>
       (?$(DU#(B . "0x7F7E") ;; <CJK>
       (?$(DU$(B . "0x7F7F") ;; <CJK>
       (?$(DU%(B . "0x7F80") ;; <CJK>
       (?$(DU&(B . "0x7F8B") ;; <CJK>
       (?$(DU'(B . "0x7F8D") ;; <CJK>
       (?$(DU((B . "0x7F8F") ;; <CJK>
       (?$(DU)(B . "0x7F90") ;; <CJK>
       (?$(DU*(B . "0x7F91") ;; <CJK>
       (?$(DU+(B . "0x7F96") ;; <CJK>
       (?$(DU,(B . "0x7F97") ;; <CJK>
       (?$(DU-(B . "0x7F9C") ;; <CJK>
       (?$(DU.(B . "0x7FA1") ;; <CJK>
       (?$(DU/(B . "0x7FA2") ;; <CJK>
       (?$(DU0(B . "0x7FA6") ;; <CJK>
       (?$(DU1(B . "0x7FAA") ;; <CJK>
       (?$(DU2(B . "0x7FAD") ;; <CJK>
       (?$(DU3(B . "0x7FB4") ;; <CJK>
       (?$(DU4(B . "0x7FBC") ;; <CJK>
       (?$(DU5(B . "0x7FBF") ;; <CJK>
       (?$(DU6(B . "0x7FC0") ;; <CJK>
       (?$(DU7(B . "0x7FC3") ;; <CJK>
       (?$(DU8(B . "0x7FC8") ;; <CJK>
       (?$(DU9(B . "0x7FCE") ;; <CJK>
       (?$(DU:(B . "0x7FCF") ;; <CJK>
       (?$(DU;(B . "0x7FDB") ;; <CJK>
       (?$(DU<(B . "0x7FDF") ;; <CJK>
       (?$(DU=(B . "0x7FE3") ;; <CJK>
       (?$(DU>(B . "0x7FE5") ;; <CJK>
       (?$(DU?(B . "0x7FE8") ;; <CJK>
       (?$(DU@(B . "0x7FEC") ;; <CJK>
       (?$(DUA(B . "0x7FEE") ;; <CJK>
       (?$(DUB(B . "0x7FEF") ;; <CJK>
       (?$(DUC(B . "0x7FF2") ;; <CJK>
       (?$(DUD(B . "0x7FFA") ;; <CJK>
       (?$(DUE(B . "0x7FFD") ;; <CJK>
       (?$(DUF(B . "0x7FFE") ;; <CJK>
       (?$(DUG(B . "0x7FFF") ;; <CJK>
       (?$(DUH(B . "0x8007") ;; <CJK>
       (?$(DUI(B . "0x8008") ;; <CJK>
       (?$(DUJ(B . "0x800A") ;; <CJK>
       (?$(DUK(B . "0x800D") ;; <CJK>
       (?$(DUL(B . "0x800E") ;; <CJK>
       (?$(DUM(B . "0x800F") ;; <CJK>
       (?$(DUN(B . "0x8011") ;; <CJK>
       (?$(DUO(B . "0x8013") ;; <CJK>
       (?$(DUP(B . "0x8014") ;; <CJK>
       (?$(DUQ(B . "0x8016") ;; <CJK>
       (?$(DUR(B . "0x801D") ;; <CJK>
       (?$(DUS(B . "0x801E") ;; <CJK>
       (?$(DUT(B . "0x801F") ;; <CJK>
       (?$(DUU(B . "0x8020") ;; <CJK>
       (?$(DUV(B . "0x8024") ;; <CJK>
       (?$(DUW(B . "0x8026") ;; <CJK>
       (?$(DUX(B . "0x802C") ;; <CJK>
       (?$(DUY(B . "0x802E") ;; <CJK>
       (?$(DUZ(B . "0x8030") ;; <CJK>
       (?$(DU[(B . "0x8034") ;; <CJK>
       (?$(DU\(B . "0x8035") ;; <CJK>
       (?$(DU](B . "0x8037") ;; <CJK>
       (?$(DU^(B . "0x8039") ;; <CJK>
       (?$(DU_(B . "0x803A") ;; <CJK>
       (?$(DU`(B . "0x803C") ;; <CJK>
       (?$(DUa(B . "0x803E") ;; <CJK>
       (?$(DUb(B . "0x8040") ;; <CJK>
       (?$(DUc(B . "0x8044") ;; <CJK>
       (?$(DUd(B . "0x8060") ;; <CJK>
       (?$(DUe(B . "0x8064") ;; <CJK>
       (?$(DUf(B . "0x8066") ;; <CJK>
       (?$(DUg(B . "0x806D") ;; <CJK>
       (?$(DUh(B . "0x8071") ;; <CJK>
       (?$(DUi(B . "0x8075") ;; <CJK>
       (?$(DUj(B . "0x8081") ;; <CJK>
       (?$(DUk(B . "0x8088") ;; <CJK>
       (?$(DUl(B . "0x808E") ;; <CJK>
       (?$(DUm(B . "0x809C") ;; <CJK>
       (?$(DUn(B . "0x809E") ;; <CJK>
       (?$(DUo(B . "0x80A6") ;; <CJK>
       (?$(DUp(B . "0x80A7") ;; <CJK>
       (?$(DUq(B . "0x80AB") ;; <CJK>
       (?$(DUr(B . "0x80B8") ;; <CJK>
       (?$(DUs(B . "0x80B9") ;; <CJK>
       (?$(DUt(B . "0x80C8") ;; <CJK>
       (?$(DUu(B . "0x80CD") ;; <CJK>
       (?$(DUv(B . "0x80CF") ;; <CJK>
       (?$(DUw(B . "0x80D2") ;; <CJK>
       (?$(DUx(B . "0x80D4") ;; <CJK>
       (?$(DUy(B . "0x80D5") ;; <CJK>
       (?$(DUz(B . "0x80D7") ;; <CJK>
       (?$(DU{(B . "0x80D8") ;; <CJK>
       (?$(DU|(B . "0x80E0") ;; <CJK>
       (?$(DU}(B . "0x80ED") ;; <CJK>
       (?$(DU~(B . "0x80EE") ;; <CJK>
       (?$(DV!(B . "0x80F0") ;; <CJK>
       (?$(DV"(B . "0x80F2") ;; <CJK>
       (?$(DV#(B . "0x80F3") ;; <CJK>
       (?$(DV$(B . "0x80F6") ;; <CJK>
       (?$(DV%(B . "0x80F9") ;; <CJK>
       (?$(DV&(B . "0x80FA") ;; <CJK>
       (?$(DV'(B . "0x80FE") ;; <CJK>
       (?$(DV((B . "0x8103") ;; <CJK>
       (?$(DV)(B . "0x810B") ;; <CJK>
       (?$(DV*(B . "0x8116") ;; <CJK>
       (?$(DV+(B . "0x8117") ;; <CJK>
       (?$(DV,(B . "0x8118") ;; <CJK>
       (?$(DV-(B . "0x811C") ;; <CJK>
       (?$(DV.(B . "0x811E") ;; <CJK>
       (?$(DV/(B . "0x8120") ;; <CJK>
       (?$(DV0(B . "0x8124") ;; <CJK>
       (?$(DV1(B . "0x8127") ;; <CJK>
       (?$(DV2(B . "0x812C") ;; <CJK>
       (?$(DV3(B . "0x8130") ;; <CJK>
       (?$(DV4(B . "0x8135") ;; <CJK>
       (?$(DV5(B . "0x813A") ;; <CJK>
       (?$(DV6(B . "0x813C") ;; <CJK>
       (?$(DV7(B . "0x8145") ;; <CJK>
       (?$(DV8(B . "0x8147") ;; <CJK>
       (?$(DV9(B . "0x814A") ;; <CJK>
       (?$(DV:(B . "0x814C") ;; <CJK>
       (?$(DV;(B . "0x8152") ;; <CJK>
       (?$(DV<(B . "0x8157") ;; <CJK>
       (?$(DV=(B . "0x8160") ;; <CJK>
       (?$(DV>(B . "0x8161") ;; <CJK>
       (?$(DV?(B . "0x8167") ;; <CJK>
       (?$(DV@(B . "0x8168") ;; <CJK>
       (?$(DVA(B . "0x8169") ;; <CJK>
       (?$(DVB(B . "0x816D") ;; <CJK>
       (?$(DVC(B . "0x816F") ;; <CJK>
       (?$(DVD(B . "0x8177") ;; <CJK>
       (?$(DVE(B . "0x8181") ;; <CJK>
       (?$(DVF(B . "0x8190") ;; <CJK>
       (?$(DVG(B . "0x8184") ;; <CJK>
       (?$(DVH(B . "0x8185") ;; <CJK>
       (?$(DVI(B . "0x8186") ;; <CJK>
       (?$(DVJ(B . "0x818B") ;; <CJK>
       (?$(DVK(B . "0x818E") ;; <CJK>
       (?$(DVL(B . "0x8196") ;; <CJK>
       (?$(DVM(B . "0x8198") ;; <CJK>
       (?$(DVN(B . "0x819B") ;; <CJK>
       (?$(DVO(B . "0x819E") ;; <CJK>
       (?$(DVP(B . "0x81A2") ;; <CJK>
       (?$(DVQ(B . "0x81AE") ;; <CJK>
       (?$(DVR(B . "0x81B2") ;; <CJK>
       (?$(DVS(B . "0x81B4") ;; <CJK>
       (?$(DVT(B . "0x81BB") ;; <CJK>
       (?$(DVU(B . "0x81CB") ;; <CJK>
       (?$(DVV(B . "0x81C3") ;; <CJK>
       (?$(DVW(B . "0x81C5") ;; <CJK>
       (?$(DVX(B . "0x81CA") ;; <CJK>
       (?$(DVY(B . "0x81CE") ;; <CJK>
       (?$(DVZ(B . "0x81CF") ;; <CJK>
       (?$(DV[(B . "0x81D5") ;; <CJK>
       (?$(DV\(B . "0x81D7") ;; <CJK>
       (?$(DV](B . "0x81DB") ;; <CJK>
       (?$(DV^(B . "0x81DD") ;; <CJK>
       (?$(DV_(B . "0x81DE") ;; <CJK>
       (?$(DV`(B . "0x81E1") ;; <CJK>
       (?$(DVa(B . "0x81E4") ;; <CJK>
       (?$(DVb(B . "0x81EB") ;; <CJK>
       (?$(DVc(B . "0x81EC") ;; <CJK>
       (?$(DVd(B . "0x81F0") ;; <CJK>
       (?$(DVe(B . "0x81F1") ;; <CJK>
       (?$(DVf(B . "0x81F2") ;; <CJK>
       (?$(DVg(B . "0x81F5") ;; <CJK>
       (?$(DVh(B . "0x81F6") ;; <CJK>
       (?$(DVi(B . "0x81F8") ;; <CJK>
       (?$(DVj(B . "0x81F9") ;; <CJK>
       (?$(DVk(B . "0x81FD") ;; <CJK>
       (?$(DVl(B . "0x81FF") ;; <CJK>
       (?$(DVm(B . "0x8200") ;; <CJK>
       (?$(DVn(B . "0x8203") ;; <CJK>
       (?$(DVo(B . "0x820F") ;; <CJK>
       (?$(DVp(B . "0x8213") ;; <CJK>
       (?$(DVq(B . "0x8214") ;; <CJK>
       (?$(DVr(B . "0x8219") ;; <CJK>
       (?$(DVs(B . "0x821A") ;; <CJK>
       (?$(DVt(B . "0x821D") ;; <CJK>
       (?$(DVu(B . "0x8221") ;; <CJK>
       (?$(DVv(B . "0x8222") ;; <CJK>
       (?$(DVw(B . "0x8228") ;; <CJK>
       (?$(DVx(B . "0x8232") ;; <CJK>
       (?$(DVy(B . "0x8234") ;; <CJK>
       (?$(DVz(B . "0x823A") ;; <CJK>
       (?$(DV{(B . "0x8243") ;; <CJK>
       (?$(DV|(B . "0x8244") ;; <CJK>
       (?$(DV}(B . "0x8245") ;; <CJK>
       (?$(DV~(B . "0x8246") ;; <CJK>
       (?$(DW!(B . "0x824B") ;; <CJK>
       (?$(DW"(B . "0x824E") ;; <CJK>
       (?$(DW#(B . "0x824F") ;; <CJK>
       (?$(DW$(B . "0x8251") ;; <CJK>
       (?$(DW%(B . "0x8256") ;; <CJK>
       (?$(DW&(B . "0x825C") ;; <CJK>
       (?$(DW'(B . "0x8260") ;; <CJK>
       (?$(DW((B . "0x8263") ;; <CJK>
       (?$(DW)(B . "0x8267") ;; <CJK>
       (?$(DW*(B . "0x826D") ;; <CJK>
       (?$(DW+(B . "0x8274") ;; <CJK>
       (?$(DW,(B . "0x827B") ;; <CJK>
       (?$(DW-(B . "0x827D") ;; <CJK>
       (?$(DW.(B . "0x827F") ;; <CJK>
       (?$(DW/(B . "0x8280") ;; <CJK>
       (?$(DW0(B . "0x8281") ;; <CJK>
       (?$(DW1(B . "0x8283") ;; <CJK>
       (?$(DW2(B . "0x8284") ;; <CJK>
       (?$(DW3(B . "0x8287") ;; <CJK>
       (?$(DW4(B . "0x8289") ;; <CJK>
       (?$(DW5(B . "0x828A") ;; <CJK>
       (?$(DW6(B . "0x828E") ;; <CJK>
       (?$(DW7(B . "0x8291") ;; <CJK>
       (?$(DW8(B . "0x8294") ;; <CJK>
       (?$(DW9(B . "0x8296") ;; <CJK>
       (?$(DW:(B . "0x8298") ;; <CJK>
       (?$(DW;(B . "0x829A") ;; <CJK>
       (?$(DW<(B . "0x829B") ;; <CJK>
       (?$(DW=(B . "0x82A0") ;; <CJK>
       (?$(DW>(B . "0x82A1") ;; <CJK>
       (?$(DW?(B . "0x82A3") ;; <CJK>
       (?$(DW@(B . "0x82A4") ;; <CJK>
       (?$(DWA(B . "0x82A7") ;; <CJK>
       (?$(DWB(B . "0x82A8") ;; <CJK>
       (?$(DWC(B . "0x82A9") ;; <CJK>
       (?$(DWD(B . "0x82AA") ;; <CJK>
       (?$(DWE(B . "0x82AE") ;; <CJK>
       (?$(DWF(B . "0x82B0") ;; <CJK>
       (?$(DWG(B . "0x82B2") ;; <CJK>
       (?$(DWH(B . "0x82B4") ;; <CJK>
       (?$(DWI(B . "0x82B7") ;; <CJK>
       (?$(DWJ(B . "0x82BA") ;; <CJK>
       (?$(DWK(B . "0x82BC") ;; <CJK>
       (?$(DWL(B . "0x82BE") ;; <CJK>
       (?$(DWM(B . "0x82BF") ;; <CJK>
       (?$(DWN(B . "0x82C6") ;; <CJK>
       (?$(DWO(B . "0x82D0") ;; <CJK>
       (?$(DWP(B . "0x82D5") ;; <CJK>
       (?$(DWQ(B . "0x82DA") ;; <CJK>
       (?$(DWR(B . "0x82E0") ;; <CJK>
       (?$(DWS(B . "0x82E2") ;; <CJK>
       (?$(DWT(B . "0x82E4") ;; <CJK>
       (?$(DWU(B . "0x82E8") ;; <CJK>
       (?$(DWV(B . "0x82EA") ;; <CJK>
       (?$(DWW(B . "0x82ED") ;; <CJK>
       (?$(DWX(B . "0x82EF") ;; <CJK>
       (?$(DWY(B . "0x82F6") ;; <CJK>
       (?$(DWZ(B . "0x82F7") ;; <CJK>
       (?$(DW[(B . "0x82FD") ;; <CJK>
       (?$(DW\(B . "0x82FE") ;; <CJK>
       (?$(DW](B . "0x8300") ;; <CJK>
       (?$(DW^(B . "0x8301") ;; <CJK>
       (?$(DW_(B . "0x8307") ;; <CJK>
       (?$(DW`(B . "0x8308") ;; <CJK>
       (?$(DWa(B . "0x830A") ;; <CJK>
       (?$(DWb(B . "0x830B") ;; <CJK>
       (?$(DWc(B . "0x8354") ;; <CJK>
       (?$(DWd(B . "0x831B") ;; <CJK>
       (?$(DWe(B . "0x831D") ;; <CJK>
       (?$(DWf(B . "0x831E") ;; <CJK>
       (?$(DWg(B . "0x831F") ;; <CJK>
       (?$(DWh(B . "0x8321") ;; <CJK>
       (?$(DWi(B . "0x8322") ;; <CJK>
       (?$(DWj(B . "0x832C") ;; <CJK>
       (?$(DWk(B . "0x832D") ;; <CJK>
       (?$(DWl(B . "0x832E") ;; <CJK>
       (?$(DWm(B . "0x8330") ;; <CJK>
       (?$(DWn(B . "0x8333") ;; <CJK>
       (?$(DWo(B . "0x8337") ;; <CJK>
       (?$(DWp(B . "0x833A") ;; <CJK>
       (?$(DWq(B . "0x833C") ;; <CJK>
       (?$(DWr(B . "0x833D") ;; <CJK>
       (?$(DWs(B . "0x8342") ;; <CJK>
       (?$(DWt(B . "0x8343") ;; <CJK>
       (?$(DWu(B . "0x8344") ;; <CJK>
       (?$(DWv(B . "0x8347") ;; <CJK>
       (?$(DWw(B . "0x834D") ;; <CJK>
       (?$(DWx(B . "0x834E") ;; <CJK>
       (?$(DWy(B . "0x8351") ;; <CJK>
       (?$(DWz(B . "0x8355") ;; <CJK>
       (?$(DW{(B . "0x8356") ;; <CJK>
       (?$(DW|(B . "0x8357") ;; <CJK>
       (?$(DW}(B . "0x8370") ;; <CJK>
       (?$(DW~(B . "0x8378") ;; <CJK>
       (?$(DX!(B . "0x837D") ;; <CJK>
       (?$(DX"(B . "0x837F") ;; <CJK>
       (?$(DX#(B . "0x8380") ;; <CJK>
       (?$(DX$(B . "0x8382") ;; <CJK>
       (?$(DX%(B . "0x8384") ;; <CJK>
       (?$(DX&(B . "0x8386") ;; <CJK>
       (?$(DX'(B . "0x838D") ;; <CJK>
       (?$(DX((B . "0x8392") ;; <CJK>
       (?$(DX)(B . "0x8394") ;; <CJK>
       (?$(DX*(B . "0x8395") ;; <CJK>
       (?$(DX+(B . "0x8398") ;; <CJK>
       (?$(DX,(B . "0x8399") ;; <CJK>
       (?$(DX-(B . "0x839B") ;; <CJK>
       (?$(DX.(B . "0x839C") ;; <CJK>
       (?$(DX/(B . "0x839D") ;; <CJK>
       (?$(DX0(B . "0x83A6") ;; <CJK>
       (?$(DX1(B . "0x83A7") ;; <CJK>
       (?$(DX2(B . "0x83A9") ;; <CJK>
       (?$(DX3(B . "0x83AC") ;; <CJK>
       (?$(DX4(B . "0x83BE") ;; <CJK>
       (?$(DX5(B . "0x83BF") ;; <CJK>
       (?$(DX6(B . "0x83C0") ;; <CJK>
       (?$(DX7(B . "0x83C7") ;; <CJK>
       (?$(DX8(B . "0x83C9") ;; <CJK>
       (?$(DX9(B . "0x83CF") ;; <CJK>
       (?$(DX:(B . "0x83D0") ;; <CJK>
       (?$(DX;(B . "0x83D1") ;; <CJK>
       (?$(DX<(B . "0x83D4") ;; <CJK>
       (?$(DX=(B . "0x83DD") ;; <CJK>
       (?$(DX>(B . "0x8353") ;; <CJK>
       (?$(DX?(B . "0x83E8") ;; <CJK>
       (?$(DX@(B . "0x83EA") ;; <CJK>
       (?$(DXA(B . "0x83F6") ;; <CJK>
       (?$(DXB(B . "0x83F8") ;; <CJK>
       (?$(DXC(B . "0x83F9") ;; <CJK>
       (?$(DXD(B . "0x83FC") ;; <CJK>
       (?$(DXE(B . "0x8401") ;; <CJK>
       (?$(DXF(B . "0x8406") ;; <CJK>
       (?$(DXG(B . "0x840A") ;; <CJK>
       (?$(DXH(B . "0x840F") ;; <CJK>
       (?$(DXI(B . "0x8411") ;; <CJK>
       (?$(DXJ(B . "0x8415") ;; <CJK>
       (?$(DXK(B . "0x8419") ;; <CJK>
       (?$(DXL(B . "0x83AD") ;; <CJK>
       (?$(DXM(B . "0x842F") ;; <CJK>
       (?$(DXN(B . "0x8439") ;; <CJK>
       (?$(DXO(B . "0x8445") ;; <CJK>
       (?$(DXP(B . "0x8447") ;; <CJK>
       (?$(DXQ(B . "0x8448") ;; <CJK>
       (?$(DXR(B . "0x844A") ;; <CJK>
       (?$(DXS(B . "0x844D") ;; <CJK>
       (?$(DXT(B . "0x844F") ;; <CJK>
       (?$(DXU(B . "0x8451") ;; <CJK>
       (?$(DXV(B . "0x8452") ;; <CJK>
       (?$(DXW(B . "0x8456") ;; <CJK>
       (?$(DXX(B . "0x8458") ;; <CJK>
       (?$(DXY(B . "0x8459") ;; <CJK>
       (?$(DXZ(B . "0x845A") ;; <CJK>
       (?$(DX[(B . "0x845C") ;; <CJK>
       (?$(DX\(B . "0x8460") ;; <CJK>
       (?$(DX](B . "0x8464") ;; <CJK>
       (?$(DX^(B . "0x8465") ;; <CJK>
       (?$(DX_(B . "0x8467") ;; <CJK>
       (?$(DX`(B . "0x846A") ;; <CJK>
       (?$(DXa(B . "0x8470") ;; <CJK>
       (?$(DXb(B . "0x8473") ;; <CJK>
       (?$(DXc(B . "0x8474") ;; <CJK>
       (?$(DXd(B . "0x8476") ;; <CJK>
       (?$(DXe(B . "0x8478") ;; <CJK>
       (?$(DXf(B . "0x847C") ;; <CJK>
       (?$(DXg(B . "0x847D") ;; <CJK>
       (?$(DXh(B . "0x8481") ;; <CJK>
       (?$(DXi(B . "0x8485") ;; <CJK>
       (?$(DXj(B . "0x8492") ;; <CJK>
       (?$(DXk(B . "0x8493") ;; <CJK>
       (?$(DXl(B . "0x8495") ;; <CJK>
       (?$(DXm(B . "0x849E") ;; <CJK>
       (?$(DXn(B . "0x84A6") ;; <CJK>
       (?$(DXo(B . "0x84A8") ;; <CJK>
       (?$(DXp(B . "0x84A9") ;; <CJK>
       (?$(DXq(B . "0x84AA") ;; <CJK>
       (?$(DXr(B . "0x84AF") ;; <CJK>
       (?$(DXs(B . "0x84B1") ;; <CJK>
       (?$(DXt(B . "0x84B4") ;; <CJK>
       (?$(DXu(B . "0x84BA") ;; <CJK>
       (?$(DXv(B . "0x84BD") ;; <CJK>
       (?$(DXw(B . "0x84BE") ;; <CJK>
       (?$(DXx(B . "0x84C0") ;; <CJK>
       (?$(DXy(B . "0x84C2") ;; <CJK>
       (?$(DXz(B . "0x84C7") ;; <CJK>
       (?$(DX{(B . "0x84C8") ;; <CJK>
       (?$(DX|(B . "0x84CC") ;; <CJK>
       (?$(DX}(B . "0x84CF") ;; <CJK>
       (?$(DX~(B . "0x84D3") ;; <CJK>
       (?$(DY!(B . "0x84DC") ;; <CJK>
       (?$(DY"(B . "0x84E7") ;; <CJK>
       (?$(DY#(B . "0x84EA") ;; <CJK>
       (?$(DY$(B . "0x84EF") ;; <CJK>
       (?$(DY%(B . "0x84F0") ;; <CJK>
       (?$(DY&(B . "0x84F1") ;; <CJK>
       (?$(DY'(B . "0x84F2") ;; <CJK>
       (?$(DY((B . "0x84F7") ;; <CJK>
       (?$(DY)(B . "0x8532") ;; <CJK>
       (?$(DY*(B . "0x84FA") ;; <CJK>
       (?$(DY+(B . "0x84FB") ;; <CJK>
       (?$(DY,(B . "0x84FD") ;; <CJK>
       (?$(DY-(B . "0x8502") ;; <CJK>
       (?$(DY.(B . "0x8503") ;; <CJK>
       (?$(DY/(B . "0x8507") ;; <CJK>
       (?$(DY0(B . "0x850C") ;; <CJK>
       (?$(DY1(B . "0x850E") ;; <CJK>
       (?$(DY2(B . "0x8510") ;; <CJK>
       (?$(DY3(B . "0x851C") ;; <CJK>
       (?$(DY4(B . "0x851E") ;; <CJK>
       (?$(DY5(B . "0x8522") ;; <CJK>
       (?$(DY6(B . "0x8523") ;; <CJK>
       (?$(DY7(B . "0x8524") ;; <CJK>
       (?$(DY8(B . "0x8525") ;; <CJK>
       (?$(DY9(B . "0x8527") ;; <CJK>
       (?$(DY:(B . "0x852A") ;; <CJK>
       (?$(DY;(B . "0x852B") ;; <CJK>
       (?$(DY<(B . "0x852F") ;; <CJK>
       (?$(DY=(B . "0x8533") ;; <CJK>
       (?$(DY>(B . "0x8534") ;; <CJK>
       (?$(DY?(B . "0x8536") ;; <CJK>
       (?$(DY@(B . "0x853F") ;; <CJK>
       (?$(DYA(B . "0x8546") ;; <CJK>
       (?$(DYB(B . "0x854F") ;; <CJK>
       (?$(DYC(B . "0x8550") ;; <CJK>
       (?$(DYD(B . "0x8551") ;; <CJK>
       (?$(DYE(B . "0x8552") ;; <CJK>
       (?$(DYF(B . "0x8553") ;; <CJK>
       (?$(DYG(B . "0x8556") ;; <CJK>
       (?$(DYH(B . "0x8559") ;; <CJK>
       (?$(DYI(B . "0x855C") ;; <CJK>
       (?$(DYJ(B . "0x855D") ;; <CJK>
       (?$(DYK(B . "0x855E") ;; <CJK>
       (?$(DYL(B . "0x855F") ;; <CJK>
       (?$(DYM(B . "0x8560") ;; <CJK>
       (?$(DYN(B . "0x8561") ;; <CJK>
       (?$(DYO(B . "0x8562") ;; <CJK>
       (?$(DYP(B . "0x8564") ;; <CJK>
       (?$(DYQ(B . "0x856B") ;; <CJK>
       (?$(DYR(B . "0x856F") ;; <CJK>
       (?$(DYS(B . "0x8579") ;; <CJK>
       (?$(DYT(B . "0x857A") ;; <CJK>
       (?$(DYU(B . "0x857B") ;; <CJK>
       (?$(DYV(B . "0x857D") ;; <CJK>
       (?$(DYW(B . "0x857F") ;; <CJK>
       (?$(DYX(B . "0x8581") ;; <CJK>
       (?$(DYY(B . "0x8585") ;; <CJK>
       (?$(DYZ(B . "0x8586") ;; <CJK>
       (?$(DY[(B . "0x8589") ;; <CJK>
       (?$(DY\(B . "0x858B") ;; <CJK>
       (?$(DY](B . "0x858C") ;; <CJK>
       (?$(DY^(B . "0x858F") ;; <CJK>
       (?$(DY_(B . "0x8593") ;; <CJK>
       (?$(DY`(B . "0x8598") ;; <CJK>
       (?$(DYa(B . "0x859D") ;; <CJK>
       (?$(DYb(B . "0x859F") ;; <CJK>
       (?$(DYc(B . "0x85A0") ;; <CJK>
       (?$(DYd(B . "0x85A2") ;; <CJK>
       (?$(DYe(B . "0x85A5") ;; <CJK>
       (?$(DYf(B . "0x85A7") ;; <CJK>
       (?$(DYg(B . "0x85B4") ;; <CJK>
       (?$(DYh(B . "0x85B6") ;; <CJK>
       (?$(DYi(B . "0x85B7") ;; <CJK>
       (?$(DYj(B . "0x85B8") ;; <CJK>
       (?$(DYk(B . "0x85BC") ;; <CJK>
       (?$(DYl(B . "0x85BD") ;; <CJK>
       (?$(DYm(B . "0x85BE") ;; <CJK>
       (?$(DYn(B . "0x85BF") ;; <CJK>
       (?$(DYo(B . "0x85C2") ;; <CJK>
       (?$(DYp(B . "0x85C7") ;; <CJK>
       (?$(DYq(B . "0x85CA") ;; <CJK>
       (?$(DYr(B . "0x85CB") ;; <CJK>
       (?$(DYs(B . "0x85CE") ;; <CJK>
       (?$(DYt(B . "0x85AD") ;; <CJK>
       (?$(DYu(B . "0x85D8") ;; <CJK>
       (?$(DYv(B . "0x85DA") ;; <CJK>
       (?$(DYw(B . "0x85DF") ;; <CJK>
       (?$(DYx(B . "0x85E0") ;; <CJK>
       (?$(DYy(B . "0x85E6") ;; <CJK>
       (?$(DYz(B . "0x85E8") ;; <CJK>
       (?$(DY{(B . "0x85ED") ;; <CJK>
       (?$(DY|(B . "0x85F3") ;; <CJK>
       (?$(DY}(B . "0x85F6") ;; <CJK>
       (?$(DY~(B . "0x85FC") ;; <CJK>
       (?$(DZ!(B . "0x85FF") ;; <CJK>
       (?$(DZ"(B . "0x8600") ;; <CJK>
       (?$(DZ#(B . "0x8604") ;; <CJK>
       (?$(DZ$(B . "0x8605") ;; <CJK>
       (?$(DZ%(B . "0x860D") ;; <CJK>
       (?$(DZ&(B . "0x860E") ;; <CJK>
       (?$(DZ'(B . "0x8610") ;; <CJK>
       (?$(DZ((B . "0x8611") ;; <CJK>
       (?$(DZ)(B . "0x8612") ;; <CJK>
       (?$(DZ*(B . "0x8618") ;; <CJK>
       (?$(DZ+(B . "0x8619") ;; <CJK>
       (?$(DZ,(B . "0x861B") ;; <CJK>
       (?$(DZ-(B . "0x861E") ;; <CJK>
       (?$(DZ.(B . "0x8621") ;; <CJK>
       (?$(DZ/(B . "0x8627") ;; <CJK>
       (?$(DZ0(B . "0x8629") ;; <CJK>
       (?$(DZ1(B . "0x8636") ;; <CJK>
       (?$(DZ2(B . "0x8638") ;; <CJK>
       (?$(DZ3(B . "0x863A") ;; <CJK>
       (?$(DZ4(B . "0x863C") ;; <CJK>
       (?$(DZ5(B . "0x863D") ;; <CJK>
       (?$(DZ6(B . "0x8640") ;; <CJK>
       (?$(DZ7(B . "0x8642") ;; <CJK>
       (?$(DZ8(B . "0x8646") ;; <CJK>
       (?$(DZ9(B . "0x8652") ;; <CJK>
       (?$(DZ:(B . "0x8653") ;; <CJK>
       (?$(DZ;(B . "0x8656") ;; <CJK>
       (?$(DZ<(B . "0x8657") ;; <CJK>
       (?$(DZ=(B . "0x8658") ;; <CJK>
       (?$(DZ>(B . "0x8659") ;; <CJK>
       (?$(DZ?(B . "0x865D") ;; <CJK>
       (?$(DZ@(B . "0x8660") ;; <CJK>
       (?$(DZA(B . "0x8661") ;; <CJK>
       (?$(DZB(B . "0x8662") ;; <CJK>
       (?$(DZC(B . "0x8663") ;; <CJK>
       (?$(DZD(B . "0x8664") ;; <CJK>
       (?$(DZE(B . "0x8669") ;; <CJK>
       (?$(DZF(B . "0x866C") ;; <CJK>
       (?$(DZG(B . "0x866F") ;; <CJK>
       (?$(DZH(B . "0x8675") ;; <CJK>
       (?$(DZI(B . "0x8676") ;; <CJK>
       (?$(DZJ(B . "0x8677") ;; <CJK>
       (?$(DZK(B . "0x867A") ;; <CJK>
       (?$(DZL(B . "0x868D") ;; <CJK>
       (?$(DZM(B . "0x8691") ;; <CJK>
       (?$(DZN(B . "0x8696") ;; <CJK>
       (?$(DZO(B . "0x8698") ;; <CJK>
       (?$(DZP(B . "0x869A") ;; <CJK>
       (?$(DZQ(B . "0x869C") ;; <CJK>
       (?$(DZR(B . "0x86A1") ;; <CJK>
       (?$(DZS(B . "0x86A6") ;; <CJK>
       (?$(DZT(B . "0x86A7") ;; <CJK>
       (?$(DZU(B . "0x86A8") ;; <CJK>
       (?$(DZV(B . "0x86AD") ;; <CJK>
       (?$(DZW(B . "0x86B1") ;; <CJK>
       (?$(DZX(B . "0x86B3") ;; <CJK>
       (?$(DZY(B . "0x86B4") ;; <CJK>
       (?$(DZZ(B . "0x86B5") ;; <CJK>
       (?$(DZ[(B . "0x86B7") ;; <CJK>
       (?$(DZ\(B . "0x86B8") ;; <CJK>
       (?$(DZ](B . "0x86B9") ;; <CJK>
       (?$(DZ^(B . "0x86BF") ;; <CJK>
       (?$(DZ_(B . "0x86C0") ;; <CJK>
       (?$(DZ`(B . "0x86C1") ;; <CJK>
       (?$(DZa(B . "0x86C3") ;; <CJK>
       (?$(DZb(B . "0x86C5") ;; <CJK>
       (?$(DZc(B . "0x86D1") ;; <CJK>
       (?$(DZd(B . "0x86D2") ;; <CJK>
       (?$(DZe(B . "0x86D5") ;; <CJK>
       (?$(DZf(B . "0x86D7") ;; <CJK>
       (?$(DZg(B . "0x86DA") ;; <CJK>
       (?$(DZh(B . "0x86DC") ;; <CJK>
       (?$(DZi(B . "0x86E0") ;; <CJK>
       (?$(DZj(B . "0x86E3") ;; <CJK>
       (?$(DZk(B . "0x86E5") ;; <CJK>
       (?$(DZl(B . "0x86E7") ;; <CJK>
       (?$(DZm(B . "0x8688") ;; <CJK>
       (?$(DZn(B . "0x86FA") ;; <CJK>
       (?$(DZo(B . "0x86FC") ;; <CJK>
       (?$(DZp(B . "0x86FD") ;; <CJK>
       (?$(DZq(B . "0x8704") ;; <CJK>
       (?$(DZr(B . "0x8705") ;; <CJK>
       (?$(DZs(B . "0x8707") ;; <CJK>
       (?$(DZt(B . "0x870B") ;; <CJK>
       (?$(DZu(B . "0x870E") ;; <CJK>
       (?$(DZv(B . "0x870F") ;; <CJK>
       (?$(DZw(B . "0x8710") ;; <CJK>
       (?$(DZx(B . "0x8713") ;; <CJK>
       (?$(DZy(B . "0x8714") ;; <CJK>
       (?$(DZz(B . "0x8719") ;; <CJK>
       (?$(DZ{(B . "0x871E") ;; <CJK>
       (?$(DZ|(B . "0x871F") ;; <CJK>
       (?$(DZ}(B . "0x8721") ;; <CJK>
       (?$(DZ~(B . "0x8723") ;; <CJK>
       (?$(D[!(B . "0x8728") ;; <CJK>
       (?$(D["(B . "0x872E") ;; <CJK>
       (?$(D[#(B . "0x872F") ;; <CJK>
       (?$(D[$(B . "0x8731") ;; <CJK>
       (?$(D[%(B . "0x8732") ;; <CJK>
       (?$(D[&(B . "0x8739") ;; <CJK>
       (?$(D['(B . "0x873A") ;; <CJK>
       (?$(D[((B . "0x873C") ;; <CJK>
       (?$(D[)(B . "0x873D") ;; <CJK>
       (?$(D[*(B . "0x873E") ;; <CJK>
       (?$(D[+(B . "0x8740") ;; <CJK>
       (?$(D[,(B . "0x8743") ;; <CJK>
       (?$(D[-(B . "0x8745") ;; <CJK>
       (?$(D[.(B . "0x874D") ;; <CJK>
       (?$(D[/(B . "0x8758") ;; <CJK>
       (?$(D[0(B . "0x875D") ;; <CJK>
       (?$(D[1(B . "0x8761") ;; <CJK>
       (?$(D[2(B . "0x8764") ;; <CJK>
       (?$(D[3(B . "0x8765") ;; <CJK>
       (?$(D[4(B . "0x876F") ;; <CJK>
       (?$(D[5(B . "0x8771") ;; <CJK>
       (?$(D[6(B . "0x8772") ;; <CJK>
       (?$(D[7(B . "0x877B") ;; <CJK>
       (?$(D[8(B . "0x8783") ;; <CJK>
       (?$(D[9(B . "0x8784") ;; <CJK>
       (?$(D[:(B . "0x8785") ;; <CJK>
       (?$(D[;(B . "0x8786") ;; <CJK>
       (?$(D[<(B . "0x8787") ;; <CJK>
       (?$(D[=(B . "0x8788") ;; <CJK>
       (?$(D[>(B . "0x8789") ;; <CJK>
       (?$(D[?(B . "0x878B") ;; <CJK>
       (?$(D[@(B . "0x878C") ;; <CJK>
       (?$(D[A(B . "0x8790") ;; <CJK>
       (?$(D[B(B . "0x8793") ;; <CJK>
       (?$(D[C(B . "0x8795") ;; <CJK>
       (?$(D[D(B . "0x8797") ;; <CJK>
       (?$(D[E(B . "0x8798") ;; <CJK>
       (?$(D[F(B . "0x8799") ;; <CJK>
       (?$(D[G(B . "0x879E") ;; <CJK>
       (?$(D[H(B . "0x87A0") ;; <CJK>
       (?$(D[I(B . "0x87A3") ;; <CJK>
       (?$(D[J(B . "0x87A7") ;; <CJK>
       (?$(D[K(B . "0x87AC") ;; <CJK>
       (?$(D[L(B . "0x87AD") ;; <CJK>
       (?$(D[M(B . "0x87AE") ;; <CJK>
       (?$(D[N(B . "0x87B1") ;; <CJK>
       (?$(D[O(B . "0x87B5") ;; <CJK>
       (?$(D[P(B . "0x87BE") ;; <CJK>
       (?$(D[Q(B . "0x87BF") ;; <CJK>
       (?$(D[R(B . "0x87C1") ;; <CJK>
       (?$(D[S(B . "0x87C8") ;; <CJK>
       (?$(D[T(B . "0x87C9") ;; <CJK>
       (?$(D[U(B . "0x87CA") ;; <CJK>
       (?$(D[V(B . "0x87CE") ;; <CJK>
       (?$(D[W(B . "0x87D5") ;; <CJK>
       (?$(D[X(B . "0x87D6") ;; <CJK>
       (?$(D[Y(B . "0x87D9") ;; <CJK>
       (?$(D[Z(B . "0x87DA") ;; <CJK>
       (?$(D[[(B . "0x87DC") ;; <CJK>
       (?$(D[\(B . "0x87DF") ;; <CJK>
       (?$(D[](B . "0x87E2") ;; <CJK>
       (?$(D[^(B . "0x87E3") ;; <CJK>
       (?$(D[_(B . "0x87E4") ;; <CJK>
       (?$(D[`(B . "0x87EA") ;; <CJK>
       (?$(D[a(B . "0x87EB") ;; <CJK>
       (?$(D[b(B . "0x87ED") ;; <CJK>
       (?$(D[c(B . "0x87F1") ;; <CJK>
       (?$(D[d(B . "0x87F3") ;; <CJK>
       (?$(D[e(B . "0x87F8") ;; <CJK>
       (?$(D[f(B . "0x87FA") ;; <CJK>
       (?$(D[g(B . "0x87FF") ;; <CJK>
       (?$(D[h(B . "0x8801") ;; <CJK>
       (?$(D[i(B . "0x8803") ;; <CJK>
       (?$(D[j(B . "0x8806") ;; <CJK>
       (?$(D[k(B . "0x8809") ;; <CJK>
       (?$(D[l(B . "0x880A") ;; <CJK>
       (?$(D[m(B . "0x880B") ;; <CJK>
       (?$(D[n(B . "0x8810") ;; <CJK>
       (?$(D[o(B . "0x8819") ;; <CJK>
       (?$(D[p(B . "0x8812") ;; <CJK>
       (?$(D[q(B . "0x8813") ;; <CJK>
       (?$(D[r(B . "0x8814") ;; <CJK>
       (?$(D[s(B . "0x8818") ;; <CJK>
       (?$(D[t(B . "0x881A") ;; <CJK>
       (?$(D[u(B . "0x881B") ;; <CJK>
       (?$(D[v(B . "0x881C") ;; <CJK>
       (?$(D[w(B . "0x881E") ;; <CJK>
       (?$(D[x(B . "0x881F") ;; <CJK>
       (?$(D[y(B . "0x8828") ;; <CJK>
       (?$(D[z(B . "0x882D") ;; <CJK>
       (?$(D[{(B . "0x882E") ;; <CJK>
       (?$(D[|(B . "0x8830") ;; <CJK>
       (?$(D[}(B . "0x8832") ;; <CJK>
       (?$(D[~(B . "0x8835") ;; <CJK>
       (?$(D\!(B . "0x883A") ;; <CJK>
       (?$(D\"(B . "0x883C") ;; <CJK>
       (?$(D\#(B . "0x8841") ;; <CJK>
       (?$(D\$(B . "0x8843") ;; <CJK>
       (?$(D\%(B . "0x8845") ;; <CJK>
       (?$(D\&(B . "0x8848") ;; <CJK>
       (?$(D\'(B . "0x8849") ;; <CJK>
       (?$(D\((B . "0x884A") ;; <CJK>
       (?$(D\)(B . "0x884B") ;; <CJK>
       (?$(D\*(B . "0x884E") ;; <CJK>
       (?$(D\+(B . "0x8851") ;; <CJK>
       (?$(D\,(B . "0x8855") ;; <CJK>
       (?$(D\-(B . "0x8856") ;; <CJK>
       (?$(D\.(B . "0x8858") ;; <CJK>
       (?$(D\/(B . "0x885A") ;; <CJK>
       (?$(D\0(B . "0x885C") ;; <CJK>
       (?$(D\1(B . "0x885F") ;; <CJK>
       (?$(D\2(B . "0x8860") ;; <CJK>
       (?$(D\3(B . "0x8864") ;; <CJK>
       (?$(D\4(B . "0x8869") ;; <CJK>
       (?$(D\5(B . "0x8871") ;; <CJK>
       (?$(D\6(B . "0x8879") ;; <CJK>
       (?$(D\7(B . "0x887B") ;; <CJK>
       (?$(D\8(B . "0x8880") ;; <CJK>
       (?$(D\9(B . "0x8898") ;; <CJK>
       (?$(D\:(B . "0x889A") ;; <CJK>
       (?$(D\;(B . "0x889B") ;; <CJK>
       (?$(D\<(B . "0x889C") ;; <CJK>
       (?$(D\=(B . "0x889F") ;; <CJK>
       (?$(D\>(B . "0x88A0") ;; <CJK>
       (?$(D\?(B . "0x88A8") ;; <CJK>
       (?$(D\@(B . "0x88AA") ;; <CJK>
       (?$(D\A(B . "0x88BA") ;; <CJK>
       (?$(D\B(B . "0x88BD") ;; <CJK>
       (?$(D\C(B . "0x88BE") ;; <CJK>
       (?$(D\D(B . "0x88C0") ;; <CJK>
       (?$(D\E(B . "0x88CA") ;; <CJK>
       (?$(D\F(B . "0x88CB") ;; <CJK>
       (?$(D\G(B . "0x88CC") ;; <CJK>
       (?$(D\H(B . "0x88CD") ;; <CJK>
       (?$(D\I(B . "0x88CE") ;; <CJK>
       (?$(D\J(B . "0x88D1") ;; <CJK>
       (?$(D\K(B . "0x88D2") ;; <CJK>
       (?$(D\L(B . "0x88D3") ;; <CJK>
       (?$(D\M(B . "0x88DB") ;; <CJK>
       (?$(D\N(B . "0x88DE") ;; <CJK>
       (?$(D\O(B . "0x88E7") ;; <CJK>
       (?$(D\P(B . "0x88EF") ;; <CJK>
       (?$(D\Q(B . "0x88F0") ;; <CJK>
       (?$(D\R(B . "0x88F1") ;; <CJK>
       (?$(D\S(B . "0x88F5") ;; <CJK>
       (?$(D\T(B . "0x88F7") ;; <CJK>
       (?$(D\U(B . "0x8901") ;; <CJK>
       (?$(D\V(B . "0x8906") ;; <CJK>
       (?$(D\W(B . "0x890D") ;; <CJK>
       (?$(D\X(B . "0x890E") ;; <CJK>
       (?$(D\Y(B . "0x890F") ;; <CJK>
       (?$(D\Z(B . "0x8915") ;; <CJK>
       (?$(D\[(B . "0x8916") ;; <CJK>
       (?$(D\\(B . "0x8918") ;; <CJK>
       (?$(D\](B . "0x8919") ;; <CJK>
       (?$(D\^(B . "0x891A") ;; <CJK>
       (?$(D\_(B . "0x891C") ;; <CJK>
       (?$(D\`(B . "0x8920") ;; <CJK>
       (?$(D\a(B . "0x8926") ;; <CJK>
       (?$(D\b(B . "0x8927") ;; <CJK>
       (?$(D\c(B . "0x8928") ;; <CJK>
       (?$(D\d(B . "0x8930") ;; <CJK>
       (?$(D\e(B . "0x8931") ;; <CJK>
       (?$(D\f(B . "0x8932") ;; <CJK>
       (?$(D\g(B . "0x8935") ;; <CJK>
       (?$(D\h(B . "0x8939") ;; <CJK>
       (?$(D\i(B . "0x893A") ;; <CJK>
       (?$(D\j(B . "0x893E") ;; <CJK>
       (?$(D\k(B . "0x8940") ;; <CJK>
       (?$(D\l(B . "0x8942") ;; <CJK>
       (?$(D\m(B . "0x8945") ;; <CJK>
       (?$(D\n(B . "0x8946") ;; <CJK>
       (?$(D\o(B . "0x8949") ;; <CJK>
       (?$(D\p(B . "0x894F") ;; <CJK>
       (?$(D\q(B . "0x8952") ;; <CJK>
       (?$(D\r(B . "0x8957") ;; <CJK>
       (?$(D\s(B . "0x895A") ;; <CJK>
       (?$(D\t(B . "0x895B") ;; <CJK>
       (?$(D\u(B . "0x895C") ;; <CJK>
       (?$(D\v(B . "0x8961") ;; <CJK>
       (?$(D\w(B . "0x8962") ;; <CJK>
       (?$(D\x(B . "0x8963") ;; <CJK>
       (?$(D\y(B . "0x896B") ;; <CJK>
       (?$(D\z(B . "0x896E") ;; <CJK>
       (?$(D\{(B . "0x8970") ;; <CJK>
       (?$(D\|(B . "0x8973") ;; <CJK>
       (?$(D\}(B . "0x8975") ;; <CJK>
       (?$(D\~(B . "0x897A") ;; <CJK>
       (?$(D]!(B . "0x897B") ;; <CJK>
       (?$(D]"(B . "0x897C") ;; <CJK>
       (?$(D]#(B . "0x897D") ;; <CJK>
       (?$(D]$(B . "0x8989") ;; <CJK>
       (?$(D]%(B . "0x898D") ;; <CJK>
       (?$(D]&(B . "0x8990") ;; <CJK>
       (?$(D]'(B . "0x8994") ;; <CJK>
       (?$(D]((B . "0x8995") ;; <CJK>
       (?$(D])(B . "0x899B") ;; <CJK>
       (?$(D]*(B . "0x899C") ;; <CJK>
       (?$(D]+(B . "0x899F") ;; <CJK>
       (?$(D],(B . "0x89A0") ;; <CJK>
       (?$(D]-(B . "0x89A5") ;; <CJK>
       (?$(D].(B . "0x89B0") ;; <CJK>
       (?$(D]/(B . "0x89B4") ;; <CJK>
       (?$(D]0(B . "0x89B5") ;; <CJK>
       (?$(D]1(B . "0x89B6") ;; <CJK>
       (?$(D]2(B . "0x89B7") ;; <CJK>
       (?$(D]3(B . "0x89BC") ;; <CJK>
       (?$(D]4(B . "0x89D4") ;; <CJK>
       (?$(D]5(B . "0x89D5") ;; <CJK>
       (?$(D]6(B . "0x89D6") ;; <CJK>
       (?$(D]7(B . "0x89D7") ;; <CJK>
       (?$(D]8(B . "0x89D8") ;; <CJK>
       (?$(D]9(B . "0x89E5") ;; <CJK>
       (?$(D]:(B . "0x89E9") ;; <CJK>
       (?$(D];(B . "0x89EB") ;; <CJK>
       (?$(D]<(B . "0x89ED") ;; <CJK>
       (?$(D]=(B . "0x89F1") ;; <CJK>
       (?$(D]>(B . "0x89F3") ;; <CJK>
       (?$(D]?(B . "0x89F6") ;; <CJK>
       (?$(D]@(B . "0x89F9") ;; <CJK>
       (?$(D]A(B . "0x89FD") ;; <CJK>
       (?$(D]B(B . "0x89FF") ;; <CJK>
       (?$(D]C(B . "0x8A04") ;; <CJK>
       (?$(D]D(B . "0x8A05") ;; <CJK>
       (?$(D]E(B . "0x8A07") ;; <CJK>
       (?$(D]F(B . "0x8A0F") ;; <CJK>
       (?$(D]G(B . "0x8A11") ;; <CJK>
       (?$(D]H(B . "0x8A12") ;; <CJK>
       (?$(D]I(B . "0x8A14") ;; <CJK>
       (?$(D]J(B . "0x8A15") ;; <CJK>
       (?$(D]K(B . "0x8A1E") ;; <CJK>
       (?$(D]L(B . "0x8A20") ;; <CJK>
       (?$(D]M(B . "0x8A22") ;; <CJK>
       (?$(D]N(B . "0x8A24") ;; <CJK>
       (?$(D]O(B . "0x8A26") ;; <CJK>
       (?$(D]P(B . "0x8A2B") ;; <CJK>
       (?$(D]Q(B . "0x8A2C") ;; <CJK>
       (?$(D]R(B . "0x8A2F") ;; <CJK>
       (?$(D]S(B . "0x8A35") ;; <CJK>
       (?$(D]T(B . "0x8A37") ;; <CJK>
       (?$(D]U(B . "0x8A3D") ;; <CJK>
       (?$(D]V(B . "0x8A3E") ;; <CJK>
       (?$(D]W(B . "0x8A40") ;; <CJK>
       (?$(D]X(B . "0x8A43") ;; <CJK>
       (?$(D]Y(B . "0x8A45") ;; <CJK>
       (?$(D]Z(B . "0x8A47") ;; <CJK>
       (?$(D][(B . "0x8A49") ;; <CJK>
       (?$(D]\(B . "0x8A4D") ;; <CJK>
       (?$(D]](B . "0x8A4E") ;; <CJK>
       (?$(D]^(B . "0x8A53") ;; <CJK>
       (?$(D]_(B . "0x8A56") ;; <CJK>
       (?$(D]`(B . "0x8A57") ;; <CJK>
       (?$(D]a(B . "0x8A58") ;; <CJK>
       (?$(D]b(B . "0x8A5C") ;; <CJK>
       (?$(D]c(B . "0x8A5D") ;; <CJK>
       (?$(D]d(B . "0x8A61") ;; <CJK>
       (?$(D]e(B . "0x8A65") ;; <CJK>
       (?$(D]f(B . "0x8A67") ;; <CJK>
       (?$(D]g(B . "0x8A75") ;; <CJK>
       (?$(D]h(B . "0x8A76") ;; <CJK>
       (?$(D]i(B . "0x8A77") ;; <CJK>
       (?$(D]j(B . "0x8A79") ;; <CJK>
       (?$(D]k(B . "0x8A7A") ;; <CJK>
       (?$(D]l(B . "0x8A7B") ;; <CJK>
       (?$(D]m(B . "0x8A7E") ;; <CJK>
       (?$(D]n(B . "0x8A7F") ;; <CJK>
       (?$(D]o(B . "0x8A80") ;; <CJK>
       (?$(D]p(B . "0x8A83") ;; <CJK>
       (?$(D]q(B . "0x8A86") ;; <CJK>
       (?$(D]r(B . "0x8A8B") ;; <CJK>
       (?$(D]s(B . "0x8A8F") ;; <CJK>
       (?$(D]t(B . "0x8A90") ;; <CJK>
       (?$(D]u(B . "0x8A92") ;; <CJK>
       (?$(D]v(B . "0x8A96") ;; <CJK>
       (?$(D]w(B . "0x8A97") ;; <CJK>
       (?$(D]x(B . "0x8A99") ;; <CJK>
       (?$(D]y(B . "0x8A9F") ;; <CJK>
       (?$(D]z(B . "0x8AA7") ;; <CJK>
       (?$(D]{(B . "0x8AA9") ;; <CJK>
       (?$(D]|(B . "0x8AAE") ;; <CJK>
       (?$(D]}(B . "0x8AAF") ;; <CJK>
       (?$(D]~(B . "0x8AB3") ;; <CJK>
       (?$(D^!(B . "0x8AB6") ;; <CJK>
       (?$(D^"(B . "0x8AB7") ;; <CJK>
       (?$(D^#(B . "0x8ABB") ;; <CJK>
       (?$(D^$(B . "0x8ABE") ;; <CJK>
       (?$(D^%(B . "0x8AC3") ;; <CJK>
       (?$(D^&(B . "0x8AC6") ;; <CJK>
       (?$(D^'(B . "0x8AC8") ;; <CJK>
       (?$(D^((B . "0x8AC9") ;; <CJK>
       (?$(D^)(B . "0x8ACA") ;; <CJK>
       (?$(D^*(B . "0x8AD1") ;; <CJK>
       (?$(D^+(B . "0x8AD3") ;; <CJK>
       (?$(D^,(B . "0x8AD4") ;; <CJK>
       (?$(D^-(B . "0x8AD5") ;; <CJK>
       (?$(D^.(B . "0x8AD7") ;; <CJK>
       (?$(D^/(B . "0x8ADD") ;; <CJK>
       (?$(D^0(B . "0x8ADF") ;; <CJK>
       (?$(D^1(B . "0x8AEC") ;; <CJK>
       (?$(D^2(B . "0x8AF0") ;; <CJK>
       (?$(D^3(B . "0x8AF4") ;; <CJK>
       (?$(D^4(B . "0x8AF5") ;; <CJK>
       (?$(D^5(B . "0x8AF6") ;; <CJK>
       (?$(D^6(B . "0x8AFC") ;; <CJK>
       (?$(D^7(B . "0x8AFF") ;; <CJK>
       (?$(D^8(B . "0x8B05") ;; <CJK>
       (?$(D^9(B . "0x8B06") ;; <CJK>
       (?$(D^:(B . "0x8B0B") ;; <CJK>
       (?$(D^;(B . "0x8B11") ;; <CJK>
       (?$(D^<(B . "0x8B1C") ;; <CJK>
       (?$(D^=(B . "0x8B1E") ;; <CJK>
       (?$(D^>(B . "0x8B1F") ;; <CJK>
       (?$(D^?(B . "0x8B0A") ;; <CJK>
       (?$(D^@(B . "0x8B2D") ;; <CJK>
       (?$(D^A(B . "0x8B30") ;; <CJK>
       (?$(D^B(B . "0x8B37") ;; <CJK>
       (?$(D^C(B . "0x8B3C") ;; <CJK>
       (?$(D^D(B . "0x8B42") ;; <CJK>
       (?$(D^E(B . "0x8B43") ;; <CJK>
       (?$(D^F(B . "0x8B44") ;; <CJK>
       (?$(D^G(B . "0x8B45") ;; <CJK>
       (?$(D^H(B . "0x8B46") ;; <CJK>
       (?$(D^I(B . "0x8B48") ;; <CJK>
       (?$(D^J(B . "0x8B52") ;; <CJK>
       (?$(D^K(B . "0x8B53") ;; <CJK>
       (?$(D^L(B . "0x8B54") ;; <CJK>
       (?$(D^M(B . "0x8B59") ;; <CJK>
       (?$(D^N(B . "0x8B4D") ;; <CJK>
       (?$(D^O(B . "0x8B5E") ;; <CJK>
       (?$(D^P(B . "0x8B63") ;; <CJK>
       (?$(D^Q(B . "0x8B6D") ;; <CJK>
       (?$(D^R(B . "0x8B76") ;; <CJK>
       (?$(D^S(B . "0x8B78") ;; <CJK>
       (?$(D^T(B . "0x8B79") ;; <CJK>
       (?$(D^U(B . "0x8B7C") ;; <CJK>
       (?$(D^V(B . "0x8B7E") ;; <CJK>
       (?$(D^W(B . "0x8B81") ;; <CJK>
       (?$(D^X(B . "0x8B84") ;; <CJK>
       (?$(D^Y(B . "0x8B85") ;; <CJK>
       (?$(D^Z(B . "0x8B8B") ;; <CJK>
       (?$(D^[(B . "0x8B8D") ;; <CJK>
       (?$(D^\(B . "0x8B8F") ;; <CJK>
       (?$(D^](B . "0x8B94") ;; <CJK>
       (?$(D^^(B . "0x8B95") ;; <CJK>
       (?$(D^_(B . "0x8B9C") ;; <CJK>
       (?$(D^`(B . "0x8B9E") ;; <CJK>
       (?$(D^a(B . "0x8B9F") ;; <CJK>
       (?$(D^b(B . "0x8C38") ;; <CJK>
       (?$(D^c(B . "0x8C39") ;; <CJK>
       (?$(D^d(B . "0x8C3D") ;; <CJK>
       (?$(D^e(B . "0x8C3E") ;; <CJK>
       (?$(D^f(B . "0x8C45") ;; <CJK>
       (?$(D^g(B . "0x8C47") ;; <CJK>
       (?$(D^h(B . "0x8C49") ;; <CJK>
       (?$(D^i(B . "0x8C4B") ;; <CJK>
       (?$(D^j(B . "0x8C4F") ;; <CJK>
       (?$(D^k(B . "0x8C51") ;; <CJK>
       (?$(D^l(B . "0x8C53") ;; <CJK>
       (?$(D^m(B . "0x8C54") ;; <CJK>
       (?$(D^n(B . "0x8C57") ;; <CJK>
       (?$(D^o(B . "0x8C58") ;; <CJK>
       (?$(D^p(B . "0x8C5B") ;; <CJK>
       (?$(D^q(B . "0x8C5D") ;; <CJK>
       (?$(D^r(B . "0x8C59") ;; <CJK>
       (?$(D^s(B . "0x8C63") ;; <CJK>
       (?$(D^t(B . "0x8C64") ;; <CJK>
       (?$(D^u(B . "0x8C66") ;; <CJK>
       (?$(D^v(B . "0x8C68") ;; <CJK>
       (?$(D^w(B . "0x8C69") ;; <CJK>
       (?$(D^x(B . "0x8C6D") ;; <CJK>
       (?$(D^y(B . "0x8C73") ;; <CJK>
       (?$(D^z(B . "0x8C75") ;; <CJK>
       (?$(D^{(B . "0x8C76") ;; <CJK>
       (?$(D^|(B . "0x8C7B") ;; <CJK>
       (?$(D^}(B . "0x8C7E") ;; <CJK>
       (?$(D^~(B . "0x8C86") ;; <CJK>
       (?$(D_!(B . "0x8C87") ;; <CJK>
       (?$(D_"(B . "0x8C8B") ;; <CJK>
       (?$(D_#(B . "0x8C90") ;; <CJK>
       (?$(D_$(B . "0x8C92") ;; <CJK>
       (?$(D_%(B . "0x8C93") ;; <CJK>
       (?$(D_&(B . "0x8C99") ;; <CJK>
       (?$(D_'(B . "0x8C9B") ;; <CJK>
       (?$(D_((B . "0x8C9C") ;; <CJK>
       (?$(D_)(B . "0x8CA4") ;; <CJK>
       (?$(D_*(B . "0x8CB9") ;; <CJK>
       (?$(D_+(B . "0x8CBA") ;; <CJK>
       (?$(D_,(B . "0x8CC5") ;; <CJK>
       (?$(D_-(B . "0x8CC6") ;; <CJK>
       (?$(D_.(B . "0x8CC9") ;; <CJK>
       (?$(D_/(B . "0x8CCB") ;; <CJK>
       (?$(D_0(B . "0x8CCF") ;; <CJK>
       (?$(D_1(B . "0x8CD6") ;; <CJK>
       (?$(D_2(B . "0x8CD5") ;; <CJK>
       (?$(D_3(B . "0x8CD9") ;; <CJK>
       (?$(D_4(B . "0x8CDD") ;; <CJK>
       (?$(D_5(B . "0x8CE1") ;; <CJK>
       (?$(D_6(B . "0x8CE8") ;; <CJK>
       (?$(D_7(B . "0x8CEC") ;; <CJK>
       (?$(D_8(B . "0x8CEF") ;; <CJK>
       (?$(D_9(B . "0x8CF0") ;; <CJK>
       (?$(D_:(B . "0x8CF2") ;; <CJK>
       (?$(D_;(B . "0x8CF5") ;; <CJK>
       (?$(D_<(B . "0x8CF7") ;; <CJK>
       (?$(D_=(B . "0x8CF8") ;; <CJK>
       (?$(D_>(B . "0x8CFE") ;; <CJK>
       (?$(D_?(B . "0x8CFF") ;; <CJK>
       (?$(D_@(B . "0x8D01") ;; <CJK>
       (?$(D_A(B . "0x8D03") ;; <CJK>
       (?$(D_B(B . "0x8D09") ;; <CJK>
       (?$(D_C(B . "0x8D12") ;; <CJK>
       (?$(D_D(B . "0x8D17") ;; <CJK>
       (?$(D_E(B . "0x8D1B") ;; <CJK>
       (?$(D_F(B . "0x8D65") ;; <CJK>
       (?$(D_G(B . "0x8D69") ;; <CJK>
       (?$(D_H(B . "0x8D6C") ;; <CJK>
       (?$(D_I(B . "0x8D6E") ;; <CJK>
       (?$(D_J(B . "0x8D7F") ;; <CJK>
       (?$(D_K(B . "0x8D82") ;; <CJK>
       (?$(D_L(B . "0x8D84") ;; <CJK>
       (?$(D_M(B . "0x8D88") ;; <CJK>
       (?$(D_N(B . "0x8D8D") ;; <CJK>
       (?$(D_O(B . "0x8D90") ;; <CJK>
       (?$(D_P(B . "0x8D91") ;; <CJK>
       (?$(D_Q(B . "0x8D95") ;; <CJK>
       (?$(D_R(B . "0x8D9E") ;; <CJK>
       (?$(D_S(B . "0x8D9F") ;; <CJK>
       (?$(D_T(B . "0x8DA0") ;; <CJK>
       (?$(D_U(B . "0x8DA6") ;; <CJK>
       (?$(D_V(B . "0x8DAB") ;; <CJK>
       (?$(D_W(B . "0x8DAC") ;; <CJK>
       (?$(D_X(B . "0x8DAF") ;; <CJK>
       (?$(D_Y(B . "0x8DB2") ;; <CJK>
       (?$(D_Z(B . "0x8DB5") ;; <CJK>
       (?$(D_[(B . "0x8DB7") ;; <CJK>
       (?$(D_\(B . "0x8DB9") ;; <CJK>
       (?$(D_](B . "0x8DBB") ;; <CJK>
       (?$(D_^(B . "0x8DC0") ;; <CJK>
       (?$(D__(B . "0x8DC5") ;; <CJK>
       (?$(D_`(B . "0x8DC6") ;; <CJK>
       (?$(D_a(B . "0x8DC7") ;; <CJK>
       (?$(D_b(B . "0x8DC8") ;; <CJK>
       (?$(D_c(B . "0x8DCA") ;; <CJK>
       (?$(D_d(B . "0x8DCE") ;; <CJK>
       (?$(D_e(B . "0x8DD1") ;; <CJK>
       (?$(D_f(B . "0x8DD4") ;; <CJK>
       (?$(D_g(B . "0x8DD5") ;; <CJK>
       (?$(D_h(B . "0x8DD7") ;; <CJK>
       (?$(D_i(B . "0x8DD9") ;; <CJK>
       (?$(D_j(B . "0x8DE4") ;; <CJK>
       (?$(D_k(B . "0x8DE5") ;; <CJK>
       (?$(D_l(B . "0x8DE7") ;; <CJK>
       (?$(D_m(B . "0x8DEC") ;; <CJK>
       (?$(D_n(B . "0x8DF0") ;; <CJK>
       (?$(D_o(B . "0x8DBC") ;; <CJK>
       (?$(D_p(B . "0x8DF1") ;; <CJK>
       (?$(D_q(B . "0x8DF2") ;; <CJK>
       (?$(D_r(B . "0x8DF4") ;; <CJK>
       (?$(D_s(B . "0x8DFD") ;; <CJK>
       (?$(D_t(B . "0x8E01") ;; <CJK>
       (?$(D_u(B . "0x8E04") ;; <CJK>
       (?$(D_v(B . "0x8E05") ;; <CJK>
       (?$(D_w(B . "0x8E06") ;; <CJK>
       (?$(D_x(B . "0x8E0B") ;; <CJK>
       (?$(D_y(B . "0x8E11") ;; <CJK>
       (?$(D_z(B . "0x8E14") ;; <CJK>
       (?$(D_{(B . "0x8E16") ;; <CJK>
       (?$(D_|(B . "0x8E20") ;; <CJK>
       (?$(D_}(B . "0x8E21") ;; <CJK>
       (?$(D_~(B . "0x8E22") ;; <CJK>
       (?$(D`!(B . "0x8E23") ;; <CJK>
       (?$(D`"(B . "0x8E26") ;; <CJK>
       (?$(D`#(B . "0x8E27") ;; <CJK>
       (?$(D`$(B . "0x8E31") ;; <CJK>
       (?$(D`%(B . "0x8E33") ;; <CJK>
       (?$(D`&(B . "0x8E36") ;; <CJK>
       (?$(D`'(B . "0x8E37") ;; <CJK>
       (?$(D`((B . "0x8E38") ;; <CJK>
       (?$(D`)(B . "0x8E39") ;; <CJK>
       (?$(D`*(B . "0x8E3D") ;; <CJK>
       (?$(D`+(B . "0x8E40") ;; <CJK>
       (?$(D`,(B . "0x8E41") ;; <CJK>
       (?$(D`-(B . "0x8E4B") ;; <CJK>
       (?$(D`.(B . "0x8E4D") ;; <CJK>
       (?$(D`/(B . "0x8E4E") ;; <CJK>
       (?$(D`0(B . "0x8E4F") ;; <CJK>
       (?$(D`1(B . "0x8E54") ;; <CJK>
       (?$(D`2(B . "0x8E5B") ;; <CJK>
       (?$(D`3(B . "0x8E5C") ;; <CJK>
       (?$(D`4(B . "0x8E5D") ;; <CJK>
       (?$(D`5(B . "0x8E5E") ;; <CJK>
       (?$(D`6(B . "0x8E61") ;; <CJK>
       (?$(D`7(B . "0x8E62") ;; <CJK>
       (?$(D`8(B . "0x8E69") ;; <CJK>
       (?$(D`9(B . "0x8E6C") ;; <CJK>
       (?$(D`:(B . "0x8E6D") ;; <CJK>
       (?$(D`;(B . "0x8E6F") ;; <CJK>
       (?$(D`<(B . "0x8E70") ;; <CJK>
       (?$(D`=(B . "0x8E71") ;; <CJK>
       (?$(D`>(B . "0x8E79") ;; <CJK>
       (?$(D`?(B . "0x8E7A") ;; <CJK>
       (?$(D`@(B . "0x8E7B") ;; <CJK>
       (?$(D`A(B . "0x8E82") ;; <CJK>
       (?$(D`B(B . "0x8E83") ;; <CJK>
       (?$(D`C(B . "0x8E89") ;; <CJK>
       (?$(D`D(B . "0x8E90") ;; <CJK>
       (?$(D`E(B . "0x8E92") ;; <CJK>
       (?$(D`F(B . "0x8E95") ;; <CJK>
       (?$(D`G(B . "0x8E9A") ;; <CJK>
       (?$(D`H(B . "0x8E9B") ;; <CJK>
       (?$(D`I(B . "0x8E9D") ;; <CJK>
       (?$(D`J(B . "0x8E9E") ;; <CJK>
       (?$(D`K(B . "0x8EA2") ;; <CJK>
       (?$(D`L(B . "0x8EA7") ;; <CJK>
       (?$(D`M(B . "0x8EA9") ;; <CJK>
       (?$(D`N(B . "0x8EAD") ;; <CJK>
       (?$(D`O(B . "0x8EAE") ;; <CJK>
       (?$(D`P(B . "0x8EB3") ;; <CJK>
       (?$(D`Q(B . "0x8EB5") ;; <CJK>
       (?$(D`R(B . "0x8EBA") ;; <CJK>
       (?$(D`S(B . "0x8EBB") ;; <CJK>
       (?$(D`T(B . "0x8EC0") ;; <CJK>
       (?$(D`U(B . "0x8EC1") ;; <CJK>
       (?$(D`V(B . "0x8EC3") ;; <CJK>
       (?$(D`W(B . "0x8EC4") ;; <CJK>
       (?$(D`X(B . "0x8EC7") ;; <CJK>
       (?$(D`Y(B . "0x8ECF") ;; <CJK>
       (?$(D`Z(B . "0x8ED1") ;; <CJK>
       (?$(D`[(B . "0x8ED4") ;; <CJK>
       (?$(D`\(B . "0x8EDC") ;; <CJK>
       (?$(D`](B . "0x8EE8") ;; <CJK>
       (?$(D`^(B . "0x8EEE") ;; <CJK>
       (?$(D`_(B . "0x8EF0") ;; <CJK>
       (?$(D``(B . "0x8EF1") ;; <CJK>
       (?$(D`a(B . "0x8EF7") ;; <CJK>
       (?$(D`b(B . "0x8EF9") ;; <CJK>
       (?$(D`c(B . "0x8EFA") ;; <CJK>
       (?$(D`d(B . "0x8EED") ;; <CJK>
       (?$(D`e(B . "0x8F00") ;; <CJK>
       (?$(D`f(B . "0x8F02") ;; <CJK>
       (?$(D`g(B . "0x8F07") ;; <CJK>
       (?$(D`h(B . "0x8F08") ;; <CJK>
       (?$(D`i(B . "0x8F0F") ;; <CJK>
       (?$(D`j(B . "0x8F10") ;; <CJK>
       (?$(D`k(B . "0x8F16") ;; <CJK>
       (?$(D`l(B . "0x8F17") ;; <CJK>
       (?$(D`m(B . "0x8F18") ;; <CJK>
       (?$(D`n(B . "0x8F1E") ;; <CJK>
       (?$(D`o(B . "0x8F20") ;; <CJK>
       (?$(D`p(B . "0x8F21") ;; <CJK>
       (?$(D`q(B . "0x8F23") ;; <CJK>
       (?$(D`r(B . "0x8F25") ;; <CJK>
       (?$(D`s(B . "0x8F27") ;; <CJK>
       (?$(D`t(B . "0x8F28") ;; <CJK>
       (?$(D`u(B . "0x8F2C") ;; <CJK>
       (?$(D`v(B . "0x8F2D") ;; <CJK>
       (?$(D`w(B . "0x8F2E") ;; <CJK>
       (?$(D`x(B . "0x8F34") ;; <CJK>
       (?$(D`y(B . "0x8F35") ;; <CJK>
       (?$(D`z(B . "0x8F36") ;; <CJK>
       (?$(D`{(B . "0x8F37") ;; <CJK>
       (?$(D`|(B . "0x8F3A") ;; <CJK>
       (?$(D`}(B . "0x8F40") ;; <CJK>
       (?$(D`~(B . "0x8F41") ;; <CJK>
       (?$(Da!(B . "0x8F43") ;; <CJK>
       (?$(Da"(B . "0x8F47") ;; <CJK>
       (?$(Da#(B . "0x8F4F") ;; <CJK>
       (?$(Da$(B . "0x8F51") ;; <CJK>
       (?$(Da%(B . "0x8F52") ;; <CJK>
       (?$(Da&(B . "0x8F53") ;; <CJK>
       (?$(Da'(B . "0x8F54") ;; <CJK>
       (?$(Da((B . "0x8F55") ;; <CJK>
       (?$(Da)(B . "0x8F58") ;; <CJK>
       (?$(Da*(B . "0x8F5D") ;; <CJK>
       (?$(Da+(B . "0x8F5E") ;; <CJK>
       (?$(Da,(B . "0x8F65") ;; <CJK>
       (?$(Da-(B . "0x8F9D") ;; <CJK>
       (?$(Da.(B . "0x8FA0") ;; <CJK>
       (?$(Da/(B . "0x8FA1") ;; <CJK>
       (?$(Da0(B . "0x8FA4") ;; <CJK>
       (?$(Da1(B . "0x8FA5") ;; <CJK>
       (?$(Da2(B . "0x8FA6") ;; <CJK>
       (?$(Da3(B . "0x8FB5") ;; <CJK>
       (?$(Da4(B . "0x8FB6") ;; <CJK>
       (?$(Da5(B . "0x8FB8") ;; <CJK>
       (?$(Da6(B . "0x8FBE") ;; <CJK>
       (?$(Da7(B . "0x8FC0") ;; <CJK>
       (?$(Da8(B . "0x8FC1") ;; <CJK>
       (?$(Da9(B . "0x8FC6") ;; <CJK>
       (?$(Da:(B . "0x8FCA") ;; <CJK>
       (?$(Da;(B . "0x8FCB") ;; <CJK>
       (?$(Da<(B . "0x8FCD") ;; <CJK>
       (?$(Da=(B . "0x8FD0") ;; <CJK>
       (?$(Da>(B . "0x8FD2") ;; <CJK>
       (?$(Da?(B . "0x8FD3") ;; <CJK>
       (?$(Da@(B . "0x8FD5") ;; <CJK>
       (?$(DaA(B . "0x8FE0") ;; <CJK>
       (?$(DaB(B . "0x8FE3") ;; <CJK>
       (?$(DaC(B . "0x8FE4") ;; <CJK>
       (?$(DaD(B . "0x8FE8") ;; <CJK>
       (?$(DaE(B . "0x8FEE") ;; <CJK>
       (?$(DaF(B . "0x8FF1") ;; <CJK>
       (?$(DaG(B . "0x8FF5") ;; <CJK>
       (?$(DaH(B . "0x8FF6") ;; <CJK>
       (?$(DaI(B . "0x8FFB") ;; <CJK>
       (?$(DaJ(B . "0x8FFE") ;; <CJK>
       (?$(DaK(B . "0x9002") ;; <CJK>
       (?$(DaL(B . "0x9004") ;; <CJK>
       (?$(DaM(B . "0x9008") ;; <CJK>
       (?$(DaN(B . "0x900C") ;; <CJK>
       (?$(DaO(B . "0x9018") ;; <CJK>
       (?$(DaP(B . "0x901B") ;; <CJK>
       (?$(DaQ(B . "0x9028") ;; <CJK>
       (?$(DaR(B . "0x9029") ;; <CJK>
       (?$(DaS(B . "0x902F") ;; <CJK>
       (?$(DaT(B . "0x902A") ;; <CJK>
       (?$(DaU(B . "0x902C") ;; <CJK>
       (?$(DaV(B . "0x902D") ;; <CJK>
       (?$(DaW(B . "0x9033") ;; <CJK>
       (?$(DaX(B . "0x9034") ;; <CJK>
       (?$(DaY(B . "0x9037") ;; <CJK>
       (?$(DaZ(B . "0x903F") ;; <CJK>
       (?$(Da[(B . "0x9043") ;; <CJK>
       (?$(Da\(B . "0x9044") ;; <CJK>
       (?$(Da](B . "0x904C") ;; <CJK>
       (?$(Da^(B . "0x905B") ;; <CJK>
       (?$(Da_(B . "0x905D") ;; <CJK>
       (?$(Da`(B . "0x9062") ;; <CJK>
       (?$(Daa(B . "0x9066") ;; <CJK>
       (?$(Dab(B . "0x9067") ;; <CJK>
       (?$(Dac(B . "0x906C") ;; <CJK>
       (?$(Dad(B . "0x9070") ;; <CJK>
       (?$(Dae(B . "0x9074") ;; <CJK>
       (?$(Daf(B . "0x9079") ;; <CJK>
       (?$(Dag(B . "0x9085") ;; <CJK>
       (?$(Dah(B . "0x9088") ;; <CJK>
       (?$(Dai(B . "0x908B") ;; <CJK>
       (?$(Daj(B . "0x908C") ;; <CJK>
       (?$(Dak(B . "0x908E") ;; <CJK>
       (?$(Dal(B . "0x9090") ;; <CJK>
       (?$(Dam(B . "0x9095") ;; <CJK>
       (?$(Dan(B . "0x9097") ;; <CJK>
       (?$(Dao(B . "0x9098") ;; <CJK>
       (?$(Dap(B . "0x9099") ;; <CJK>
       (?$(Daq(B . "0x909B") ;; <CJK>
       (?$(Dar(B . "0x90A0") ;; <CJK>
       (?$(Das(B . "0x90A1") ;; <CJK>
       (?$(Dat(B . "0x90A2") ;; <CJK>
       (?$(Dau(B . "0x90A5") ;; <CJK>
       (?$(Dav(B . "0x90B0") ;; <CJK>
       (?$(Daw(B . "0x90B2") ;; <CJK>
       (?$(Dax(B . "0x90B3") ;; <CJK>
       (?$(Day(B . "0x90B4") ;; <CJK>
       (?$(Daz(B . "0x90B6") ;; <CJK>
       (?$(Da{(B . "0x90BD") ;; <CJK>
       (?$(Da|(B . "0x90CC") ;; <CJK>
       (?$(Da}(B . "0x90BE") ;; <CJK>
       (?$(Da~(B . "0x90C3") ;; <CJK>
       (?$(Db!(B . "0x90C4") ;; <CJK>
       (?$(Db"(B . "0x90C5") ;; <CJK>
       (?$(Db#(B . "0x90C7") ;; <CJK>
       (?$(Db$(B . "0x90C8") ;; <CJK>
       (?$(Db%(B . "0x90D5") ;; <CJK>
       (?$(Db&(B . "0x90D7") ;; <CJK>
       (?$(Db'(B . "0x90D8") ;; <CJK>
       (?$(Db((B . "0x90D9") ;; <CJK>
       (?$(Db)(B . "0x90DC") ;; <CJK>
       (?$(Db*(B . "0x90DD") ;; <CJK>
       (?$(Db+(B . "0x90DF") ;; <CJK>
       (?$(Db,(B . "0x90E5") ;; <CJK>
       (?$(Db-(B . "0x90D2") ;; <CJK>
       (?$(Db.(B . "0x90F6") ;; <CJK>
       (?$(Db/(B . "0x90EB") ;; <CJK>
       (?$(Db0(B . "0x90EF") ;; <CJK>
       (?$(Db1(B . "0x90F0") ;; <CJK>
       (?$(Db2(B . "0x90F4") ;; <CJK>
       (?$(Db3(B . "0x90FE") ;; <CJK>
       (?$(Db4(B . "0x90FF") ;; <CJK>
       (?$(Db5(B . "0x9100") ;; <CJK>
       (?$(Db6(B . "0x9104") ;; <CJK>
       (?$(Db7(B . "0x9105") ;; <CJK>
       (?$(Db8(B . "0x9106") ;; <CJK>
       (?$(Db9(B . "0x9108") ;; <CJK>
       (?$(Db:(B . "0x910D") ;; <CJK>
       (?$(Db;(B . "0x9110") ;; <CJK>
       (?$(Db<(B . "0x9114") ;; <CJK>
       (?$(Db=(B . "0x9116") ;; <CJK>
       (?$(Db>(B . "0x9117") ;; <CJK>
       (?$(Db?(B . "0x9118") ;; <CJK>
       (?$(Db@(B . "0x911A") ;; <CJK>
       (?$(DbA(B . "0x911C") ;; <CJK>
       (?$(DbB(B . "0x911E") ;; <CJK>
       (?$(DbC(B . "0x9120") ;; <CJK>
       (?$(DbD(B . "0x9125") ;; <CJK>
       (?$(DbE(B . "0x9122") ;; <CJK>
       (?$(DbF(B . "0x9123") ;; <CJK>
       (?$(DbG(B . "0x9127") ;; <CJK>
       (?$(DbH(B . "0x9129") ;; <CJK>
       (?$(DbI(B . "0x912E") ;; <CJK>
       (?$(DbJ(B . "0x912F") ;; <CJK>
       (?$(DbK(B . "0x9131") ;; <CJK>
       (?$(DbL(B . "0x9134") ;; <CJK>
       (?$(DbM(B . "0x9136") ;; <CJK>
       (?$(DbN(B . "0x9137") ;; <CJK>
       (?$(DbO(B . "0x9139") ;; <CJK>
       (?$(DbP(B . "0x913A") ;; <CJK>
       (?$(DbQ(B . "0x913C") ;; <CJK>
       (?$(DbR(B . "0x913D") ;; <CJK>
       (?$(DbS(B . "0x9143") ;; <CJK>
       (?$(DbT(B . "0x9147") ;; <CJK>
       (?$(DbU(B . "0x9148") ;; <CJK>
       (?$(DbV(B . "0x914F") ;; <CJK>
       (?$(DbW(B . "0x9153") ;; <CJK>
       (?$(DbX(B . "0x9157") ;; <CJK>
       (?$(DbY(B . "0x9159") ;; <CJK>
       (?$(DbZ(B . "0x915A") ;; <CJK>
       (?$(Db[(B . "0x915B") ;; <CJK>
       (?$(Db\(B . "0x9161") ;; <CJK>
       (?$(Db](B . "0x9164") ;; <CJK>
       (?$(Db^(B . "0x9167") ;; <CJK>
       (?$(Db_(B . "0x916D") ;; <CJK>
       (?$(Db`(B . "0x9174") ;; <CJK>
       (?$(Dba(B . "0x9179") ;; <CJK>
       (?$(Dbb(B . "0x917A") ;; <CJK>
       (?$(Dbc(B . "0x917B") ;; <CJK>
       (?$(Dbd(B . "0x9181") ;; <CJK>
       (?$(Dbe(B . "0x9183") ;; <CJK>
       (?$(Dbf(B . "0x9185") ;; <CJK>
       (?$(Dbg(B . "0x9186") ;; <CJK>
       (?$(Dbh(B . "0x918A") ;; <CJK>
       (?$(Dbi(B . "0x918E") ;; <CJK>
       (?$(Dbj(B . "0x9191") ;; <CJK>
       (?$(Dbk(B . "0x9193") ;; <CJK>
       (?$(Dbl(B . "0x9194") ;; <CJK>
       (?$(Dbm(B . "0x9195") ;; <CJK>
       (?$(Dbn(B . "0x9198") ;; <CJK>
       (?$(Dbo(B . "0x919E") ;; <CJK>
       (?$(Dbp(B . "0x91A1") ;; <CJK>
       (?$(Dbq(B . "0x91A6") ;; <CJK>
       (?$(Dbr(B . "0x91A8") ;; <CJK>
       (?$(Dbs(B . "0x91AC") ;; <CJK>
       (?$(Dbt(B . "0x91AD") ;; <CJK>
       (?$(Dbu(B . "0x91AE") ;; <CJK>
       (?$(Dbv(B . "0x91B0") ;; <CJK>
       (?$(Dbw(B . "0x91B1") ;; <CJK>
       (?$(Dbx(B . "0x91B2") ;; <CJK>
       (?$(Dby(B . "0x91B3") ;; <CJK>
       (?$(Dbz(B . "0x91B6") ;; <CJK>
       (?$(Db{(B . "0x91BB") ;; <CJK>
       (?$(Db|(B . "0x91BC") ;; <CJK>
       (?$(Db}(B . "0x91BD") ;; <CJK>
       (?$(Db~(B . "0x91BF") ;; <CJK>
       (?$(Dc!(B . "0x91C2") ;; <CJK>
       (?$(Dc"(B . "0x91C3") ;; <CJK>
       (?$(Dc#(B . "0x91C5") ;; <CJK>
       (?$(Dc$(B . "0x91D3") ;; <CJK>
       (?$(Dc%(B . "0x91D4") ;; <CJK>
       (?$(Dc&(B . "0x91D7") ;; <CJK>
       (?$(Dc'(B . "0x91D9") ;; <CJK>
       (?$(Dc((B . "0x91DA") ;; <CJK>
       (?$(Dc)(B . "0x91DE") ;; <CJK>
       (?$(Dc*(B . "0x91E4") ;; <CJK>
       (?$(Dc+(B . "0x91E5") ;; <CJK>
       (?$(Dc,(B . "0x91E9") ;; <CJK>
       (?$(Dc-(B . "0x91EA") ;; <CJK>
       (?$(Dc.(B . "0x91EC") ;; <CJK>
       (?$(Dc/(B . "0x91ED") ;; <CJK>
       (?$(Dc0(B . "0x91EE") ;; <CJK>
       (?$(Dc1(B . "0x91EF") ;; <CJK>
       (?$(Dc2(B . "0x91F0") ;; <CJK>
       (?$(Dc3(B . "0x91F1") ;; <CJK>
       (?$(Dc4(B . "0x91F7") ;; <CJK>
       (?$(Dc5(B . "0x91F9") ;; <CJK>
       (?$(Dc6(B . "0x91FB") ;; <CJK>
       (?$(Dc7(B . "0x91FD") ;; <CJK>
       (?$(Dc8(B . "0x9200") ;; <CJK>
       (?$(Dc9(B . "0x9201") ;; <CJK>
       (?$(Dc:(B . "0x9204") ;; <CJK>
       (?$(Dc;(B . "0x9205") ;; <CJK>
       (?$(Dc<(B . "0x9206") ;; <CJK>
       (?$(Dc=(B . "0x9207") ;; <CJK>
       (?$(Dc>(B . "0x9209") ;; <CJK>
       (?$(Dc?(B . "0x920A") ;; <CJK>
       (?$(Dc@(B . "0x920C") ;; <CJK>
       (?$(DcA(B . "0x9210") ;; <CJK>
       (?$(DcB(B . "0x9212") ;; <CJK>
       (?$(DcC(B . "0x9213") ;; <CJK>
       (?$(DcD(B . "0x9216") ;; <CJK>
       (?$(DcE(B . "0x9218") ;; <CJK>
       (?$(DcF(B . "0x921C") ;; <CJK>
       (?$(DcG(B . "0x921D") ;; <CJK>
       (?$(DcH(B . "0x9223") ;; <CJK>
       (?$(DcI(B . "0x9224") ;; <CJK>
       (?$(DcJ(B . "0x9225") ;; <CJK>
       (?$(DcK(B . "0x9226") ;; <CJK>
       (?$(DcL(B . "0x9228") ;; <CJK>
       (?$(DcM(B . "0x922E") ;; <CJK>
       (?$(DcN(B . "0x922F") ;; <CJK>
       (?$(DcO(B . "0x9230") ;; <CJK>
       (?$(DcP(B . "0x9233") ;; <CJK>
       (?$(DcQ(B . "0x9235") ;; <CJK>
       (?$(DcR(B . "0x9236") ;; <CJK>
       (?$(DcS(B . "0x9238") ;; <CJK>
       (?$(DcT(B . "0x9239") ;; <CJK>
       (?$(DcU(B . "0x923A") ;; <CJK>
       (?$(DcV(B . "0x923C") ;; <CJK>
       (?$(DcW(B . "0x923E") ;; <CJK>
       (?$(DcX(B . "0x9240") ;; <CJK>
       (?$(DcY(B . "0x9242") ;; <CJK>
       (?$(DcZ(B . "0x9243") ;; <CJK>
       (?$(Dc[(B . "0x9246") ;; <CJK>
       (?$(Dc\(B . "0x9247") ;; <CJK>
       (?$(Dc](B . "0x924A") ;; <CJK>
       (?$(Dc^(B . "0x924D") ;; <CJK>
       (?$(Dc_(B . "0x924E") ;; <CJK>
       (?$(Dc`(B . "0x924F") ;; <CJK>
       (?$(Dca(B . "0x9251") ;; <CJK>
       (?$(Dcb(B . "0x9258") ;; <CJK>
       (?$(Dcc(B . "0x9259") ;; <CJK>
       (?$(Dcd(B . "0x925C") ;; <CJK>
       (?$(Dce(B . "0x925D") ;; <CJK>
       (?$(Dcf(B . "0x9260") ;; <CJK>
       (?$(Dcg(B . "0x9261") ;; <CJK>
       (?$(Dch(B . "0x9265") ;; <CJK>
       (?$(Dci(B . "0x9267") ;; <CJK>
       (?$(Dcj(B . "0x9268") ;; <CJK>
       (?$(Dck(B . "0x9269") ;; <CJK>
       (?$(Dcl(B . "0x926E") ;; <CJK>
       (?$(Dcm(B . "0x926F") ;; <CJK>
       (?$(Dcn(B . "0x9270") ;; <CJK>
       (?$(Dco(B . "0x9275") ;; <CJK>
       (?$(Dcp(B . "0x9276") ;; <CJK>
       (?$(Dcq(B . "0x9277") ;; <CJK>
       (?$(Dcr(B . "0x9278") ;; <CJK>
       (?$(Dcs(B . "0x9279") ;; <CJK>
       (?$(Dct(B . "0x927B") ;; <CJK>
       (?$(Dcu(B . "0x927C") ;; <CJK>
       (?$(Dcv(B . "0x927D") ;; <CJK>
       (?$(Dcw(B . "0x927F") ;; <CJK>
       (?$(Dcx(B . "0x9288") ;; <CJK>
       (?$(Dcy(B . "0x9289") ;; <CJK>
       (?$(Dcz(B . "0x928A") ;; <CJK>
       (?$(Dc{(B . "0x928D") ;; <CJK>
       (?$(Dc|(B . "0x928E") ;; <CJK>
       (?$(Dc}(B . "0x9292") ;; <CJK>
       (?$(Dc~(B . "0x9297") ;; <CJK>
       (?$(Dd!(B . "0x9299") ;; <CJK>
       (?$(Dd"(B . "0x929F") ;; <CJK>
       (?$(Dd#(B . "0x92A0") ;; <CJK>
       (?$(Dd$(B . "0x92A4") ;; <CJK>
       (?$(Dd%(B . "0x92A5") ;; <CJK>
       (?$(Dd&(B . "0x92A7") ;; <CJK>
       (?$(Dd'(B . "0x92A8") ;; <CJK>
       (?$(Dd((B . "0x92AB") ;; <CJK>
       (?$(Dd)(B . "0x92AF") ;; <CJK>
       (?$(Dd*(B . "0x92B2") ;; <CJK>
       (?$(Dd+(B . "0x92B6") ;; <CJK>
       (?$(Dd,(B . "0x92B8") ;; <CJK>
       (?$(Dd-(B . "0x92BA") ;; <CJK>
       (?$(Dd.(B . "0x92BB") ;; <CJK>
       (?$(Dd/(B . "0x92BC") ;; <CJK>
       (?$(Dd0(B . "0x92BD") ;; <CJK>
       (?$(Dd1(B . "0x92BF") ;; <CJK>
       (?$(Dd2(B . "0x92C0") ;; <CJK>
       (?$(Dd3(B . "0x92C1") ;; <CJK>
       (?$(Dd4(B . "0x92C2") ;; <CJK>
       (?$(Dd5(B . "0x92C3") ;; <CJK>
       (?$(Dd6(B . "0x92C5") ;; <CJK>
       (?$(Dd7(B . "0x92C6") ;; <CJK>
       (?$(Dd8(B . "0x92C7") ;; <CJK>
       (?$(Dd9(B . "0x92C8") ;; <CJK>
       (?$(Dd:(B . "0x92CB") ;; <CJK>
       (?$(Dd;(B . "0x92CC") ;; <CJK>
       (?$(Dd<(B . "0x92CD") ;; <CJK>
       (?$(Dd=(B . "0x92CE") ;; <CJK>
       (?$(Dd>(B . "0x92D0") ;; <CJK>
       (?$(Dd?(B . "0x92D3") ;; <CJK>
       (?$(Dd@(B . "0x92D5") ;; <CJK>
       (?$(DdA(B . "0x92D7") ;; <CJK>
       (?$(DdB(B . "0x92D8") ;; <CJK>
       (?$(DdC(B . "0x92D9") ;; <CJK>
       (?$(DdD(B . "0x92DC") ;; <CJK>
       (?$(DdE(B . "0x92DD") ;; <CJK>
       (?$(DdF(B . "0x92DF") ;; <CJK>
       (?$(DdG(B . "0x92E0") ;; <CJK>
       (?$(DdH(B . "0x92E1") ;; <CJK>
       (?$(DdI(B . "0x92E3") ;; <CJK>
       (?$(DdJ(B . "0x92E5") ;; <CJK>
       (?$(DdK(B . "0x92E7") ;; <CJK>
       (?$(DdL(B . "0x92E8") ;; <CJK>
       (?$(DdM(B . "0x92EC") ;; <CJK>
       (?$(DdN(B . "0x92EE") ;; <CJK>
       (?$(DdO(B . "0x92F0") ;; <CJK>
       (?$(DdP(B . "0x92F9") ;; <CJK>
       (?$(DdQ(B . "0x92FB") ;; <CJK>
       (?$(DdR(B . "0x92FF") ;; <CJK>
       (?$(DdS(B . "0x9300") ;; <CJK>
       (?$(DdT(B . "0x9302") ;; <CJK>
       (?$(DdU(B . "0x9308") ;; <CJK>
       (?$(DdV(B . "0x930D") ;; <CJK>
       (?$(DdW(B . "0x9311") ;; <CJK>
       (?$(DdX(B . "0x9314") ;; <CJK>
       (?$(DdY(B . "0x9315") ;; <CJK>
       (?$(DdZ(B . "0x931C") ;; <CJK>
       (?$(Dd[(B . "0x931D") ;; <CJK>
       (?$(Dd\(B . "0x931E") ;; <CJK>
       (?$(Dd](B . "0x931F") ;; <CJK>
       (?$(Dd^(B . "0x9321") ;; <CJK>
       (?$(Dd_(B . "0x9324") ;; <CJK>
       (?$(Dd`(B . "0x9325") ;; <CJK>
       (?$(Dda(B . "0x9327") ;; <CJK>
       (?$(Ddb(B . "0x9329") ;; <CJK>
       (?$(Ddc(B . "0x932A") ;; <CJK>
       (?$(Ddd(B . "0x9333") ;; <CJK>
       (?$(Dde(B . "0x9334") ;; <CJK>
       (?$(Ddf(B . "0x9336") ;; <CJK>
       (?$(Ddg(B . "0x9337") ;; <CJK>
       (?$(Ddh(B . "0x9347") ;; <CJK>
       (?$(Ddi(B . "0x9348") ;; <CJK>
       (?$(Ddj(B . "0x9349") ;; <CJK>
       (?$(Ddk(B . "0x9350") ;; <CJK>
       (?$(Ddl(B . "0x9351") ;; <CJK>
       (?$(Ddm(B . "0x9352") ;; <CJK>
       (?$(Ddn(B . "0x9355") ;; <CJK>
       (?$(Ddo(B . "0x9357") ;; <CJK>
       (?$(Ddp(B . "0x9358") ;; <CJK>
       (?$(Ddq(B . "0x935A") ;; <CJK>
       (?$(Ddr(B . "0x935E") ;; <CJK>
       (?$(Dds(B . "0x9364") ;; <CJK>
       (?$(Ddt(B . "0x9365") ;; <CJK>
       (?$(Ddu(B . "0x9367") ;; <CJK>
       (?$(Ddv(B . "0x9369") ;; <CJK>
       (?$(Ddw(B . "0x936A") ;; <CJK>
       (?$(Ddx(B . "0x936D") ;; <CJK>
       (?$(Ddy(B . "0x936F") ;; <CJK>
       (?$(Ddz(B . "0x9370") ;; <CJK>
       (?$(Dd{(B . "0x9371") ;; <CJK>
       (?$(Dd|(B . "0x9373") ;; <CJK>
       (?$(Dd}(B . "0x9374") ;; <CJK>
       (?$(Dd~(B . "0x9376") ;; <CJK>
       (?$(De!(B . "0x937A") ;; <CJK>
       (?$(De"(B . "0x937D") ;; <CJK>
       (?$(De#(B . "0x937F") ;; <CJK>
       (?$(De$(B . "0x9380") ;; <CJK>
       (?$(De%(B . "0x9381") ;; <CJK>
       (?$(De&(B . "0x9382") ;; <CJK>
       (?$(De'(B . "0x9388") ;; <CJK>
       (?$(De((B . "0x938A") ;; <CJK>
       (?$(De)(B . "0x938B") ;; <CJK>
       (?$(De*(B . "0x938D") ;; <CJK>
       (?$(De+(B . "0x938F") ;; <CJK>
       (?$(De,(B . "0x9392") ;; <CJK>
       (?$(De-(B . "0x9395") ;; <CJK>
       (?$(De.(B . "0x9398") ;; <CJK>
       (?$(De/(B . "0x939B") ;; <CJK>
       (?$(De0(B . "0x939E") ;; <CJK>
       (?$(De1(B . "0x93A1") ;; <CJK>
       (?$(De2(B . "0x93A3") ;; <CJK>
       (?$(De3(B . "0x93A4") ;; <CJK>
       (?$(De4(B . "0x93A6") ;; <CJK>
       (?$(De5(B . "0x93A8") ;; <CJK>
       (?$(De6(B . "0x93AB") ;; <CJK>
       (?$(De7(B . "0x93B4") ;; <CJK>
       (?$(De8(B . "0x93B5") ;; <CJK>
       (?$(De9(B . "0x93B6") ;; <CJK>
       (?$(De:(B . "0x93BA") ;; <CJK>
       (?$(De;(B . "0x93A9") ;; <CJK>
       (?$(De<(B . "0x93C1") ;; <CJK>
       (?$(De=(B . "0x93C4") ;; <CJK>
       (?$(De>(B . "0x93C5") ;; <CJK>
       (?$(De?(B . "0x93C6") ;; <CJK>
       (?$(De@(B . "0x93C7") ;; <CJK>
       (?$(DeA(B . "0x93C9") ;; <CJK>
       (?$(DeB(B . "0x93CA") ;; <CJK>
       (?$(DeC(B . "0x93CB") ;; <CJK>
       (?$(DeD(B . "0x93CC") ;; <CJK>
       (?$(DeE(B . "0x93CD") ;; <CJK>
       (?$(DeF(B . "0x93D3") ;; <CJK>
       (?$(DeG(B . "0x93D9") ;; <CJK>
       (?$(DeH(B . "0x93DC") ;; <CJK>
       (?$(DeI(B . "0x93DE") ;; <CJK>
       (?$(DeJ(B . "0x93DF") ;; <CJK>
       (?$(DeK(B . "0x93E2") ;; <CJK>
       (?$(DeL(B . "0x93E6") ;; <CJK>
       (?$(DeM(B . "0x93E7") ;; <CJK>
       (?$(DeN(B . "0x93F9") ;; <CJK>
       (?$(DeO(B . "0x93F7") ;; <CJK>
       (?$(DeP(B . "0x93F8") ;; <CJK>
       (?$(DeQ(B . "0x93FA") ;; <CJK>
       (?$(DeR(B . "0x93FB") ;; <CJK>
       (?$(DeS(B . "0x93FD") ;; <CJK>
       (?$(DeT(B . "0x9401") ;; <CJK>
       (?$(DeU(B . "0x9402") ;; <CJK>
       (?$(DeV(B . "0x9404") ;; <CJK>
       (?$(DeW(B . "0x9408") ;; <CJK>
       (?$(DeX(B . "0x9409") ;; <CJK>
       (?$(DeY(B . "0x940D") ;; <CJK>
       (?$(DeZ(B . "0x940E") ;; <CJK>
       (?$(De[(B . "0x940F") ;; <CJK>
       (?$(De\(B . "0x9415") ;; <CJK>
       (?$(De](B . "0x9416") ;; <CJK>
       (?$(De^(B . "0x9417") ;; <CJK>
       (?$(De_(B . "0x941F") ;; <CJK>
       (?$(De`(B . "0x942E") ;; <CJK>
       (?$(Dea(B . "0x942F") ;; <CJK>
       (?$(Deb(B . "0x9431") ;; <CJK>
       (?$(Dec(B . "0x9432") ;; <CJK>
       (?$(Ded(B . "0x9433") ;; <CJK>
       (?$(Dee(B . "0x9434") ;; <CJK>
       (?$(Def(B . "0x943B") ;; <CJK>
       (?$(Deg(B . "0x943F") ;; <CJK>
       (?$(Deh(B . "0x943D") ;; <CJK>
       (?$(Dei(B . "0x9443") ;; <CJK>
       (?$(Dej(B . "0x9445") ;; <CJK>
       (?$(Dek(B . "0x9448") ;; <CJK>
       (?$(Del(B . "0x944A") ;; <CJK>
       (?$(Dem(B . "0x944C") ;; <CJK>
       (?$(Den(B . "0x9455") ;; <CJK>
       (?$(Deo(B . "0x9459") ;; <CJK>
       (?$(Dep(B . "0x945C") ;; <CJK>
       (?$(Deq(B . "0x945F") ;; <CJK>
       (?$(Der(B . "0x9461") ;; <CJK>
       (?$(Des(B . "0x9463") ;; <CJK>
       (?$(Det(B . "0x9468") ;; <CJK>
       (?$(Deu(B . "0x946B") ;; <CJK>
       (?$(Dev(B . "0x946D") ;; <CJK>
       (?$(Dew(B . "0x946E") ;; <CJK>
       (?$(Dex(B . "0x946F") ;; <CJK>
       (?$(Dey(B . "0x9471") ;; <CJK>
       (?$(Dez(B . "0x9472") ;; <CJK>
       (?$(De{(B . "0x9484") ;; <CJK>
       (?$(De|(B . "0x9483") ;; <CJK>
       (?$(De}(B . "0x9578") ;; <CJK>
       (?$(De~(B . "0x9579") ;; <CJK>
       (?$(Df!(B . "0x957E") ;; <CJK>
       (?$(Df"(B . "0x9584") ;; <CJK>
       (?$(Df#(B . "0x9588") ;; <CJK>
       (?$(Df$(B . "0x958C") ;; <CJK>
       (?$(Df%(B . "0x958D") ;; <CJK>
       (?$(Df&(B . "0x958E") ;; <CJK>
       (?$(Df'(B . "0x959D") ;; <CJK>
       (?$(Df((B . "0x959E") ;; <CJK>
       (?$(Df)(B . "0x959F") ;; <CJK>
       (?$(Df*(B . "0x95A1") ;; <CJK>
       (?$(Df+(B . "0x95A6") ;; <CJK>
       (?$(Df,(B . "0x95A9") ;; <CJK>
       (?$(Df-(B . "0x95AB") ;; <CJK>
       (?$(Df.(B . "0x95AC") ;; <CJK>
       (?$(Df/(B . "0x95B4") ;; <CJK>
       (?$(Df0(B . "0x95B6") ;; <CJK>
       (?$(Df1(B . "0x95BA") ;; <CJK>
       (?$(Df2(B . "0x95BD") ;; <CJK>
       (?$(Df3(B . "0x95BF") ;; <CJK>
       (?$(Df4(B . "0x95C6") ;; <CJK>
       (?$(Df5(B . "0x95C8") ;; <CJK>
       (?$(Df6(B . "0x95C9") ;; <CJK>
       (?$(Df7(B . "0x95CB") ;; <CJK>
       (?$(Df8(B . "0x95D0") ;; <CJK>
       (?$(Df9(B . "0x95D1") ;; <CJK>
       (?$(Df:(B . "0x95D2") ;; <CJK>
       (?$(Df;(B . "0x95D3") ;; <CJK>
       (?$(Df<(B . "0x95D9") ;; <CJK>
       (?$(Df=(B . "0x95DA") ;; <CJK>
       (?$(Df>(B . "0x95DD") ;; <CJK>
       (?$(Df?(B . "0x95DE") ;; <CJK>
       (?$(Df@(B . "0x95DF") ;; <CJK>
       (?$(DfA(B . "0x95E0") ;; <CJK>
       (?$(DfB(B . "0x95E4") ;; <CJK>
       (?$(DfC(B . "0x95E6") ;; <CJK>
       (?$(DfD(B . "0x961D") ;; <CJK>
       (?$(DfE(B . "0x961E") ;; <CJK>
       (?$(DfF(B . "0x9622") ;; <CJK>
       (?$(DfG(B . "0x9624") ;; <CJK>
       (?$(DfH(B . "0x9625") ;; <CJK>
       (?$(DfI(B . "0x9626") ;; <CJK>
       (?$(DfJ(B . "0x962C") ;; <CJK>
       (?$(DfK(B . "0x9631") ;; <CJK>
       (?$(DfL(B . "0x9633") ;; <CJK>
       (?$(DfM(B . "0x9637") ;; <CJK>
       (?$(DfN(B . "0x9638") ;; <CJK>
       (?$(DfO(B . "0x9639") ;; <CJK>
       (?$(DfP(B . "0x963A") ;; <CJK>
       (?$(DfQ(B . "0x963C") ;; <CJK>
       (?$(DfR(B . "0x963D") ;; <CJK>
       (?$(DfS(B . "0x9641") ;; <CJK>
       (?$(DfT(B . "0x9652") ;; <CJK>
       (?$(DfU(B . "0x9654") ;; <CJK>
       (?$(DfV(B . "0x9656") ;; <CJK>
       (?$(DfW(B . "0x9657") ;; <CJK>
       (?$(DfX(B . "0x9658") ;; <CJK>
       (?$(DfY(B . "0x9661") ;; <CJK>
       (?$(DfZ(B . "0x966E") ;; <CJK>
       (?$(Df[(B . "0x9674") ;; <CJK>
       (?$(Df\(B . "0x967B") ;; <CJK>
       (?$(Df](B . "0x967C") ;; <CJK>
       (?$(Df^(B . "0x967E") ;; <CJK>
       (?$(Df_(B . "0x967F") ;; <CJK>
       (?$(Df`(B . "0x9681") ;; <CJK>
       (?$(Dfa(B . "0x9682") ;; <CJK>
       (?$(Dfb(B . "0x9683") ;; <CJK>
       (?$(Dfc(B . "0x9684") ;; <CJK>
       (?$(Dfd(B . "0x9689") ;; <CJK>
       (?$(Dfe(B . "0x9691") ;; <CJK>
       (?$(Dff(B . "0x9696") ;; <CJK>
       (?$(Dfg(B . "0x969A") ;; <CJK>
       (?$(Dfh(B . "0x969D") ;; <CJK>
       (?$(Dfi(B . "0x969F") ;; <CJK>
       (?$(Dfj(B . "0x96A4") ;; <CJK>
       (?$(Dfk(B . "0x96A5") ;; <CJK>
       (?$(Dfl(B . "0x96A6") ;; <CJK>
       (?$(Dfm(B . "0x96A9") ;; <CJK>
       (?$(Dfn(B . "0x96AE") ;; <CJK>
       (?$(Dfo(B . "0x96AF") ;; <CJK>
       (?$(Dfp(B . "0x96B3") ;; <CJK>
       (?$(Dfq(B . "0x96BA") ;; <CJK>
       (?$(Dfr(B . "0x96CA") ;; <CJK>
       (?$(Dfs(B . "0x96D2") ;; <CJK>
       (?$(Dft(B . "0x5DB2") ;; <CJK>
       (?$(Dfu(B . "0x96D8") ;; <CJK>
       (?$(Dfv(B . "0x96DA") ;; <CJK>
       (?$(Dfw(B . "0x96DD") ;; <CJK>
       (?$(Dfx(B . "0x96DE") ;; <CJK>
       (?$(Dfy(B . "0x96DF") ;; <CJK>
       (?$(Dfz(B . "0x96E9") ;; <CJK>
       (?$(Df{(B . "0x96EF") ;; <CJK>
       (?$(Df|(B . "0x96F1") ;; <CJK>
       (?$(Df}(B . "0x96FA") ;; <CJK>
       (?$(Df~(B . "0x9702") ;; <CJK>
       (?$(Dg!(B . "0x9703") ;; <CJK>
       (?$(Dg"(B . "0x9705") ;; <CJK>
       (?$(Dg#(B . "0x9709") ;; <CJK>
       (?$(Dg$(B . "0x971A") ;; <CJK>
       (?$(Dg%(B . "0x971B") ;; <CJK>
       (?$(Dg&(B . "0x971D") ;; <CJK>
       (?$(Dg'(B . "0x9721") ;; <CJK>
       (?$(Dg((B . "0x9722") ;; <CJK>
       (?$(Dg)(B . "0x9723") ;; <CJK>
       (?$(Dg*(B . "0x9728") ;; <CJK>
       (?$(Dg+(B . "0x9731") ;; <CJK>
       (?$(Dg,(B . "0x9733") ;; <CJK>
       (?$(Dg-(B . "0x9741") ;; <CJK>
       (?$(Dg.(B . "0x9743") ;; <CJK>
       (?$(Dg/(B . "0x974A") ;; <CJK>
       (?$(Dg0(B . "0x974E") ;; <CJK>
       (?$(Dg1(B . "0x974F") ;; <CJK>
       (?$(Dg2(B . "0x9755") ;; <CJK>
       (?$(Dg3(B . "0x9757") ;; <CJK>
       (?$(Dg4(B . "0x9758") ;; <CJK>
       (?$(Dg5(B . "0x975A") ;; <CJK>
       (?$(Dg6(B . "0x975B") ;; <CJK>
       (?$(Dg7(B . "0x9763") ;; <CJK>
       (?$(Dg8(B . "0x9767") ;; <CJK>
       (?$(Dg9(B . "0x976A") ;; <CJK>
       (?$(Dg:(B . "0x976E") ;; <CJK>
       (?$(Dg;(B . "0x9773") ;; <CJK>
       (?$(Dg<(B . "0x9776") ;; <CJK>
       (?$(Dg=(B . "0x9777") ;; <CJK>
       (?$(Dg>(B . "0x9778") ;; <CJK>
       (?$(Dg?(B . "0x977B") ;; <CJK>
       (?$(Dg@(B . "0x977D") ;; <CJK>
       (?$(DgA(B . "0x977F") ;; <CJK>
       (?$(DgB(B . "0x9780") ;; <CJK>
       (?$(DgC(B . "0x9789") ;; <CJK>
       (?$(DgD(B . "0x9795") ;; <CJK>
       (?$(DgE(B . "0x9796") ;; <CJK>
       (?$(DgF(B . "0x9797") ;; <CJK>
       (?$(DgG(B . "0x9799") ;; <CJK>
       (?$(DgH(B . "0x979A") ;; <CJK>
       (?$(DgI(B . "0x979E") ;; <CJK>
       (?$(DgJ(B . "0x979F") ;; <CJK>
       (?$(DgK(B . "0x97A2") ;; <CJK>
       (?$(DgL(B . "0x97AC") ;; <CJK>
       (?$(DgM(B . "0x97AE") ;; <CJK>
       (?$(DgN(B . "0x97B1") ;; <CJK>
       (?$(DgO(B . "0x97B2") ;; <CJK>
       (?$(DgP(B . "0x97B5") ;; <CJK>
       (?$(DgQ(B . "0x97B6") ;; <CJK>
       (?$(DgR(B . "0x97B8") ;; <CJK>
       (?$(DgS(B . "0x97B9") ;; <CJK>
       (?$(DgT(B . "0x97BA") ;; <CJK>
       (?$(DgU(B . "0x97BC") ;; <CJK>
       (?$(DgV(B . "0x97BE") ;; <CJK>
       (?$(DgW(B . "0x97BF") ;; <CJK>
       (?$(DgX(B . "0x97C1") ;; <CJK>
       (?$(DgY(B . "0x97C4") ;; <CJK>
       (?$(DgZ(B . "0x97C5") ;; <CJK>
       (?$(Dg[(B . "0x97C7") ;; <CJK>
       (?$(Dg\(B . "0x97C9") ;; <CJK>
       (?$(Dg](B . "0x97CA") ;; <CJK>
       (?$(Dg^(B . "0x97CC") ;; <CJK>
       (?$(Dg_(B . "0x97CD") ;; <CJK>
       (?$(Dg`(B . "0x97CE") ;; <CJK>
       (?$(Dga(B . "0x97D0") ;; <CJK>
       (?$(Dgb(B . "0x97D1") ;; <CJK>
       (?$(Dgc(B . "0x97D4") ;; <CJK>
       (?$(Dgd(B . "0x97D7") ;; <CJK>
       (?$(Dge(B . "0x97D8") ;; <CJK>
       (?$(Dgf(B . "0x97D9") ;; <CJK>
       (?$(Dgg(B . "0x97DD") ;; <CJK>
       (?$(Dgh(B . "0x97DE") ;; <CJK>
       (?$(Dgi(B . "0x97E0") ;; <CJK>
       (?$(Dgj(B . "0x97DB") ;; <CJK>
       (?$(Dgk(B . "0x97E1") ;; <CJK>
       (?$(Dgl(B . "0x97E4") ;; <CJK>
       (?$(Dgm(B . "0x97EF") ;; <CJK>
       (?$(Dgn(B . "0x97F1") ;; <CJK>
       (?$(Dgo(B . "0x97F4") ;; <CJK>
       (?$(Dgp(B . "0x97F7") ;; <CJK>
       (?$(Dgq(B . "0x97F8") ;; <CJK>
       (?$(Dgr(B . "0x97FA") ;; <CJK>
       (?$(Dgs(B . "0x9807") ;; <CJK>
       (?$(Dgt(B . "0x980A") ;; <CJK>
       (?$(Dgu(B . "0x9819") ;; <CJK>
       (?$(Dgv(B . "0x980D") ;; <CJK>
       (?$(Dgw(B . "0x980E") ;; <CJK>
       (?$(Dgx(B . "0x9814") ;; <CJK>
       (?$(Dgy(B . "0x9816") ;; <CJK>
       (?$(Dgz(B . "0x981C") ;; <CJK>
       (?$(Dg{(B . "0x981E") ;; <CJK>
       (?$(Dg|(B . "0x9820") ;; <CJK>
       (?$(Dg}(B . "0x9823") ;; <CJK>
       (?$(Dg~(B . "0x9826") ;; <CJK>
       (?$(Dh!(B . "0x982B") ;; <CJK>
       (?$(Dh"(B . "0x982E") ;; <CJK>
       (?$(Dh#(B . "0x982F") ;; <CJK>
       (?$(Dh$(B . "0x9830") ;; <CJK>
       (?$(Dh%(B . "0x9832") ;; <CJK>
       (?$(Dh&(B . "0x9833") ;; <CJK>
       (?$(Dh'(B . "0x9835") ;; <CJK>
       (?$(Dh((B . "0x9825") ;; <CJK>
       (?$(Dh)(B . "0x983E") ;; <CJK>
       (?$(Dh*(B . "0x9844") ;; <CJK>
       (?$(Dh+(B . "0x9847") ;; <CJK>
       (?$(Dh,(B . "0x984A") ;; <CJK>
       (?$(Dh-(B . "0x9851") ;; <CJK>
       (?$(Dh.(B . "0x9852") ;; <CJK>
       (?$(Dh/(B . "0x9853") ;; <CJK>
       (?$(Dh0(B . "0x9856") ;; <CJK>
       (?$(Dh1(B . "0x9857") ;; <CJK>
       (?$(Dh2(B . "0x9859") ;; <CJK>
       (?$(Dh3(B . "0x985A") ;; <CJK>
       (?$(Dh4(B . "0x9862") ;; <CJK>
       (?$(Dh5(B . "0x9863") ;; <CJK>
       (?$(Dh6(B . "0x9865") ;; <CJK>
       (?$(Dh7(B . "0x9866") ;; <CJK>
       (?$(Dh8(B . "0x986A") ;; <CJK>
       (?$(Dh9(B . "0x986C") ;; <CJK>
       (?$(Dh:(B . "0x98AB") ;; <CJK>
       (?$(Dh;(B . "0x98AD") ;; <CJK>
       (?$(Dh<(B . "0x98AE") ;; <CJK>
       (?$(Dh=(B . "0x98B0") ;; <CJK>
       (?$(Dh>(B . "0x98B4") ;; <CJK>
       (?$(Dh?(B . "0x98B7") ;; <CJK>
       (?$(Dh@(B . "0x98B8") ;; <CJK>
       (?$(DhA(B . "0x98BA") ;; <CJK>
       (?$(DhB(B . "0x98BB") ;; <CJK>
       (?$(DhC(B . "0x98BF") ;; <CJK>
       (?$(DhD(B . "0x98C2") ;; <CJK>
       (?$(DhE(B . "0x98C5") ;; <CJK>
       (?$(DhF(B . "0x98C8") ;; <CJK>
       (?$(DhG(B . "0x98CC") ;; <CJK>
       (?$(DhH(B . "0x98E1") ;; <CJK>
       (?$(DhI(B . "0x98E3") ;; <CJK>
       (?$(DhJ(B . "0x98E5") ;; <CJK>
       (?$(DhK(B . "0x98E6") ;; <CJK>
       (?$(DhL(B . "0x98E7") ;; <CJK>
       (?$(DhM(B . "0x98EA") ;; <CJK>
       (?$(DhN(B . "0x98F3") ;; <CJK>
       (?$(DhO(B . "0x98F6") ;; <CJK>
       (?$(DhP(B . "0x9902") ;; <CJK>
       (?$(DhQ(B . "0x9907") ;; <CJK>
       (?$(DhR(B . "0x9908") ;; <CJK>
       (?$(DhS(B . "0x9911") ;; <CJK>
       (?$(DhT(B . "0x9915") ;; <CJK>
       (?$(DhU(B . "0x9916") ;; <CJK>
       (?$(DhV(B . "0x9917") ;; <CJK>
       (?$(DhW(B . "0x991A") ;; <CJK>
       (?$(DhX(B . "0x991B") ;; <CJK>
       (?$(DhY(B . "0x991C") ;; <CJK>
       (?$(DhZ(B . "0x991F") ;; <CJK>
       (?$(Dh[(B . "0x9922") ;; <CJK>
       (?$(Dh\(B . "0x9926") ;; <CJK>
       (?$(Dh](B . "0x9927") ;; <CJK>
       (?$(Dh^(B . "0x992B") ;; <CJK>
       (?$(Dh_(B . "0x9931") ;; <CJK>
       (?$(Dh`(B . "0x9932") ;; <CJK>
       (?$(Dha(B . "0x9933") ;; <CJK>
       (?$(Dhb(B . "0x9934") ;; <CJK>
       (?$(Dhc(B . "0x9935") ;; <CJK>
       (?$(Dhd(B . "0x9939") ;; <CJK>
       (?$(Dhe(B . "0x993A") ;; <CJK>
       (?$(Dhf(B . "0x993B") ;; <CJK>
       (?$(Dhg(B . "0x993C") ;; <CJK>
       (?$(Dhh(B . "0x9940") ;; <CJK>
       (?$(Dhi(B . "0x9941") ;; <CJK>
       (?$(Dhj(B . "0x9946") ;; <CJK>
       (?$(Dhk(B . "0x9947") ;; <CJK>
       (?$(Dhl(B . "0x9948") ;; <CJK>
       (?$(Dhm(B . "0x994D") ;; <CJK>
       (?$(Dhn(B . "0x994E") ;; <CJK>
       (?$(Dho(B . "0x9954") ;; <CJK>
       (?$(Dhp(B . "0x9958") ;; <CJK>
       (?$(Dhq(B . "0x9959") ;; <CJK>
       (?$(Dhr(B . "0x995B") ;; <CJK>
       (?$(Dhs(B . "0x995C") ;; <CJK>
       (?$(Dht(B . "0x995E") ;; <CJK>
       (?$(Dhu(B . "0x995F") ;; <CJK>
       (?$(Dhv(B . "0x9960") ;; <CJK>
       (?$(Dhw(B . "0x999B") ;; <CJK>
       (?$(Dhx(B . "0x999D") ;; <CJK>
       (?$(Dhy(B . "0x999F") ;; <CJK>
       (?$(Dhz(B . "0x99A6") ;; <CJK>
       (?$(Dh{(B . "0x99B0") ;; <CJK>
       (?$(Dh|(B . "0x99B1") ;; <CJK>
       (?$(Dh}(B . "0x99B2") ;; <CJK>
       (?$(Dh~(B . "0x99B5") ;; <CJK>
       (?$(Di!(B . "0x99B9") ;; <CJK>
       (?$(Di"(B . "0x99BA") ;; <CJK>
       (?$(Di#(B . "0x99BD") ;; <CJK>
       (?$(Di$(B . "0x99BF") ;; <CJK>
       (?$(Di%(B . "0x99C3") ;; <CJK>
       (?$(Di&(B . "0x99C9") ;; <CJK>
       (?$(Di'(B . "0x99D3") ;; <CJK>
       (?$(Di((B . "0x99D4") ;; <CJK>
       (?$(Di)(B . "0x99D9") ;; <CJK>
       (?$(Di*(B . "0x99DA") ;; <CJK>
       (?$(Di+(B . "0x99DC") ;; <CJK>
       (?$(Di,(B . "0x99DE") ;; <CJK>
       (?$(Di-(B . "0x99E7") ;; <CJK>
       (?$(Di.(B . "0x99EA") ;; <CJK>
       (?$(Di/(B . "0x99EB") ;; <CJK>
       (?$(Di0(B . "0x99EC") ;; <CJK>
       (?$(Di1(B . "0x99F0") ;; <CJK>
       (?$(Di2(B . "0x99F4") ;; <CJK>
       (?$(Di3(B . "0x99F5") ;; <CJK>
       (?$(Di4(B . "0x99F9") ;; <CJK>
       (?$(Di5(B . "0x99FD") ;; <CJK>
       (?$(Di6(B . "0x99FE") ;; <CJK>
       (?$(Di7(B . "0x9A02") ;; <CJK>
       (?$(Di8(B . "0x9A03") ;; <CJK>
       (?$(Di9(B . "0x9A04") ;; <CJK>
       (?$(Di:(B . "0x9A0B") ;; <CJK>
       (?$(Di;(B . "0x9A0C") ;; <CJK>
       (?$(Di<(B . "0x9A10") ;; <CJK>
       (?$(Di=(B . "0x9A11") ;; <CJK>
       (?$(Di>(B . "0x9A16") ;; <CJK>
       (?$(Di?(B . "0x9A1E") ;; <CJK>
       (?$(Di@(B . "0x9A20") ;; <CJK>
       (?$(DiA(B . "0x9A22") ;; <CJK>
       (?$(DiB(B . "0x9A23") ;; <CJK>
       (?$(DiC(B . "0x9A24") ;; <CJK>
       (?$(DiD(B . "0x9A27") ;; <CJK>
       (?$(DiE(B . "0x9A2D") ;; <CJK>
       (?$(DiF(B . "0x9A2E") ;; <CJK>
       (?$(DiG(B . "0x9A33") ;; <CJK>
       (?$(DiH(B . "0x9A35") ;; <CJK>
       (?$(DiI(B . "0x9A36") ;; <CJK>
       (?$(DiJ(B . "0x9A38") ;; <CJK>
       (?$(DiK(B . "0x9A47") ;; <CJK>
       (?$(DiL(B . "0x9A41") ;; <CJK>
       (?$(DiM(B . "0x9A44") ;; <CJK>
       (?$(DiN(B . "0x9A4A") ;; <CJK>
       (?$(DiO(B . "0x9A4B") ;; <CJK>
       (?$(DiP(B . "0x9A4C") ;; <CJK>
       (?$(DiQ(B . "0x9A4E") ;; <CJK>
       (?$(DiR(B . "0x9A51") ;; <CJK>
       (?$(DiS(B . "0x9A54") ;; <CJK>
       (?$(DiT(B . "0x9A56") ;; <CJK>
       (?$(DiU(B . "0x9A5D") ;; <CJK>
       (?$(DiV(B . "0x9AAA") ;; <CJK>
       (?$(DiW(B . "0x9AAC") ;; <CJK>
       (?$(DiX(B . "0x9AAE") ;; <CJK>
       (?$(DiY(B . "0x9AAF") ;; <CJK>
       (?$(DiZ(B . "0x9AB2") ;; <CJK>
       (?$(Di[(B . "0x9AB4") ;; <CJK>
       (?$(Di\(B . "0x9AB5") ;; <CJK>
       (?$(Di](B . "0x9AB6") ;; <CJK>
       (?$(Di^(B . "0x9AB9") ;; <CJK>
       (?$(Di_(B . "0x9ABB") ;; <CJK>
       (?$(Di`(B . "0x9ABE") ;; <CJK>
       (?$(Dia(B . "0x9ABF") ;; <CJK>
       (?$(Dib(B . "0x9AC1") ;; <CJK>
       (?$(Dic(B . "0x9AC3") ;; <CJK>
       (?$(Did(B . "0x9AC6") ;; <CJK>
       (?$(Die(B . "0x9AC8") ;; <CJK>
       (?$(Dif(B . "0x9ACE") ;; <CJK>
       (?$(Dig(B . "0x9AD0") ;; <CJK>
       (?$(Dih(B . "0x9AD2") ;; <CJK>
       (?$(Dii(B . "0x9AD5") ;; <CJK>
       (?$(Dij(B . "0x9AD6") ;; <CJK>
       (?$(Dik(B . "0x9AD7") ;; <CJK>
       (?$(Dil(B . "0x9ADB") ;; <CJK>
       (?$(Dim(B . "0x9ADC") ;; <CJK>
       (?$(Din(B . "0x9AE0") ;; <CJK>
       (?$(Dio(B . "0x9AE4") ;; <CJK>
       (?$(Dip(B . "0x9AE5") ;; <CJK>
       (?$(Diq(B . "0x9AE7") ;; <CJK>
       (?$(Dir(B . "0x9AE9") ;; <CJK>
       (?$(Dis(B . "0x9AEC") ;; <CJK>
       (?$(Dit(B . "0x9AF2") ;; <CJK>
       (?$(Diu(B . "0x9AF3") ;; <CJK>
       (?$(Div(B . "0x9AF5") ;; <CJK>
       (?$(Diw(B . "0x9AF9") ;; <CJK>
       (?$(Dix(B . "0x9AFA") ;; <CJK>
       (?$(Diy(B . "0x9AFD") ;; <CJK>
       (?$(Diz(B . "0x9AFF") ;; <CJK>
       (?$(Di{(B . "0x9B00") ;; <CJK>
       (?$(Di|(B . "0x9B01") ;; <CJK>
       (?$(Di}(B . "0x9B02") ;; <CJK>
       (?$(Di~(B . "0x9B03") ;; <CJK>
       (?$(Dj!(B . "0x9B04") ;; <CJK>
       (?$(Dj"(B . "0x9B05") ;; <CJK>
       (?$(Dj#(B . "0x9B08") ;; <CJK>
       (?$(Dj$(B . "0x9B09") ;; <CJK>
       (?$(Dj%(B . "0x9B0B") ;; <CJK>
       (?$(Dj&(B . "0x9B0C") ;; <CJK>
       (?$(Dj'(B . "0x9B0D") ;; <CJK>
       (?$(Dj((B . "0x9B0E") ;; <CJK>
       (?$(Dj)(B . "0x9B10") ;; <CJK>
       (?$(Dj*(B . "0x9B12") ;; <CJK>
       (?$(Dj+(B . "0x9B16") ;; <CJK>
       (?$(Dj,(B . "0x9B19") ;; <CJK>
       (?$(Dj-(B . "0x9B1B") ;; <CJK>
       (?$(Dj.(B . "0x9B1C") ;; <CJK>
       (?$(Dj/(B . "0x9B20") ;; <CJK>
       (?$(Dj0(B . "0x9B26") ;; <CJK>
       (?$(Dj1(B . "0x9B2B") ;; <CJK>
       (?$(Dj2(B . "0x9B2D") ;; <CJK>
       (?$(Dj3(B . "0x9B33") ;; <CJK>
       (?$(Dj4(B . "0x9B34") ;; <CJK>
       (?$(Dj5(B . "0x9B35") ;; <CJK>
       (?$(Dj6(B . "0x9B37") ;; <CJK>
       (?$(Dj7(B . "0x9B39") ;; <CJK>
       (?$(Dj8(B . "0x9B3A") ;; <CJK>
       (?$(Dj9(B . "0x9B3D") ;; <CJK>
       (?$(Dj:(B . "0x9B48") ;; <CJK>
       (?$(Dj;(B . "0x9B4B") ;; <CJK>
       (?$(Dj<(B . "0x9B4C") ;; <CJK>
       (?$(Dj=(B . "0x9B55") ;; <CJK>
       (?$(Dj>(B . "0x9B56") ;; <CJK>
       (?$(Dj?(B . "0x9B57") ;; <CJK>
       (?$(Dj@(B . "0x9B5B") ;; <CJK>
       (?$(DjA(B . "0x9B5E") ;; <CJK>
       (?$(DjB(B . "0x9B61") ;; <CJK>
       (?$(DjC(B . "0x9B63") ;; <CJK>
       (?$(DjD(B . "0x9B65") ;; <CJK>
       (?$(DjE(B . "0x9B66") ;; <CJK>
       (?$(DjF(B . "0x9B68") ;; <CJK>
       (?$(DjG(B . "0x9B6A") ;; <CJK>
       (?$(DjH(B . "0x9B6B") ;; <CJK>
       (?$(DjI(B . "0x9B6C") ;; <CJK>
       (?$(DjJ(B . "0x9B6D") ;; <CJK>
       (?$(DjK(B . "0x9B6E") ;; <CJK>
       (?$(DjL(B . "0x9B73") ;; <CJK>
       (?$(DjM(B . "0x9B75") ;; <CJK>
       (?$(DjN(B . "0x9B77") ;; <CJK>
       (?$(DjO(B . "0x9B78") ;; <CJK>
       (?$(DjP(B . "0x9B79") ;; <CJK>
       (?$(DjQ(B . "0x9B7F") ;; <CJK>
       (?$(DjR(B . "0x9B80") ;; <CJK>
       (?$(DjS(B . "0x9B84") ;; <CJK>
       (?$(DjT(B . "0x9B85") ;; <CJK>
       (?$(DjU(B . "0x9B86") ;; <CJK>
       (?$(DjV(B . "0x9B87") ;; <CJK>
       (?$(DjW(B . "0x9B89") ;; <CJK>
       (?$(DjX(B . "0x9B8A") ;; <CJK>
       (?$(DjY(B . "0x9B8B") ;; <CJK>
       (?$(DjZ(B . "0x9B8D") ;; <CJK>
       (?$(Dj[(B . "0x9B8F") ;; <CJK>
       (?$(Dj\(B . "0x9B90") ;; <CJK>
       (?$(Dj](B . "0x9B94") ;; <CJK>
       (?$(Dj^(B . "0x9B9A") ;; <CJK>
       (?$(Dj_(B . "0x9B9D") ;; <CJK>
       (?$(Dj`(B . "0x9B9E") ;; <CJK>
       (?$(Dja(B . "0x9BA6") ;; <CJK>
       (?$(Djb(B . "0x9BA7") ;; <CJK>
       (?$(Djc(B . "0x9BA9") ;; <CJK>
       (?$(Djd(B . "0x9BAC") ;; <CJK>
       (?$(Dje(B . "0x9BB0") ;; <CJK>
       (?$(Djf(B . "0x9BB1") ;; <CJK>
       (?$(Djg(B . "0x9BB2") ;; <CJK>
       (?$(Djh(B . "0x9BB7") ;; <CJK>
       (?$(Dji(B . "0x9BB8") ;; <CJK>
       (?$(Djj(B . "0x9BBB") ;; <CJK>
       (?$(Djk(B . "0x9BBC") ;; <CJK>
       (?$(Djl(B . "0x9BBE") ;; <CJK>
       (?$(Djm(B . "0x9BBF") ;; <CJK>
       (?$(Djn(B . "0x9BC1") ;; <CJK>
       (?$(Djo(B . "0x9BC7") ;; <CJK>
       (?$(Djp(B . "0x9BC8") ;; <CJK>
       (?$(Djq(B . "0x9BCE") ;; <CJK>
       (?$(Djr(B . "0x9BD0") ;; <CJK>
       (?$(Djs(B . "0x9BD7") ;; <CJK>
       (?$(Djt(B . "0x9BD8") ;; <CJK>
       (?$(Dju(B . "0x9BDD") ;; <CJK>
       (?$(Djv(B . "0x9BDF") ;; <CJK>
       (?$(Djw(B . "0x9BE5") ;; <CJK>
       (?$(Djx(B . "0x9BE7") ;; <CJK>
       (?$(Djy(B . "0x9BEA") ;; <CJK>
       (?$(Djz(B . "0x9BEB") ;; <CJK>
       (?$(Dj{(B . "0x9BEF") ;; <CJK>
       (?$(Dj|(B . "0x9BF3") ;; <CJK>
       (?$(Dj}(B . "0x9BF7") ;; <CJK>
       (?$(Dj~(B . "0x9BF8") ;; <CJK>
       (?$(Dk!(B . "0x9BF9") ;; <CJK>
       (?$(Dk"(B . "0x9BFA") ;; <CJK>
       (?$(Dk#(B . "0x9BFD") ;; <CJK>
       (?$(Dk$(B . "0x9BFF") ;; <CJK>
       (?$(Dk%(B . "0x9C00") ;; <CJK>
       (?$(Dk&(B . "0x9C02") ;; <CJK>
       (?$(Dk'(B . "0x9C0B") ;; <CJK>
       (?$(Dk((B . "0x9C0F") ;; <CJK>
       (?$(Dk)(B . "0x9C11") ;; <CJK>
       (?$(Dk*(B . "0x9C16") ;; <CJK>
       (?$(Dk+(B . "0x9C18") ;; <CJK>
       (?$(Dk,(B . "0x9C19") ;; <CJK>
       (?$(Dk-(B . "0x9C1A") ;; <CJK>
       (?$(Dk.(B . "0x9C1C") ;; <CJK>
       (?$(Dk/(B . "0x9C1E") ;; <CJK>
       (?$(Dk0(B . "0x9C22") ;; <CJK>
       (?$(Dk1(B . "0x9C23") ;; <CJK>
       (?$(Dk2(B . "0x9C26") ;; <CJK>
       (?$(Dk3(B . "0x9C27") ;; <CJK>
       (?$(Dk4(B . "0x9C28") ;; <CJK>
       (?$(Dk5(B . "0x9C29") ;; <CJK>
       (?$(Dk6(B . "0x9C2A") ;; <CJK>
       (?$(Dk7(B . "0x9C31") ;; <CJK>
       (?$(Dk8(B . "0x9C35") ;; <CJK>
       (?$(Dk9(B . "0x9C36") ;; <CJK>
       (?$(Dk:(B . "0x9C37") ;; <CJK>
       (?$(Dk;(B . "0x9C3D") ;; <CJK>
       (?$(Dk<(B . "0x9C41") ;; <CJK>
       (?$(Dk=(B . "0x9C43") ;; <CJK>
       (?$(Dk>(B . "0x9C44") ;; <CJK>
       (?$(Dk?(B . "0x9C45") ;; <CJK>
       (?$(Dk@(B . "0x9C49") ;; <CJK>
       (?$(DkA(B . "0x9C4A") ;; <CJK>
       (?$(DkB(B . "0x9C4E") ;; <CJK>
       (?$(DkC(B . "0x9C4F") ;; <CJK>
       (?$(DkD(B . "0x9C50") ;; <CJK>
       (?$(DkE(B . "0x9C53") ;; <CJK>
       (?$(DkF(B . "0x9C54") ;; <CJK>
       (?$(DkG(B . "0x9C56") ;; <CJK>
       (?$(DkH(B . "0x9C58") ;; <CJK>
       (?$(DkI(B . "0x9C5B") ;; <CJK>
       (?$(DkJ(B . "0x9C5D") ;; <CJK>
       (?$(DkK(B . "0x9C5E") ;; <CJK>
       (?$(DkL(B . "0x9C5F") ;; <CJK>
       (?$(DkM(B . "0x9C63") ;; <CJK>
       (?$(DkN(B . "0x9C69") ;; <CJK>
       (?$(DkO(B . "0x9C6A") ;; <CJK>
       (?$(DkP(B . "0x9C5C") ;; <CJK>
       (?$(DkQ(B . "0x9C6B") ;; <CJK>
       (?$(DkR(B . "0x9C68") ;; <CJK>
       (?$(DkS(B . "0x9C6E") ;; <CJK>
       (?$(DkT(B . "0x9C70") ;; <CJK>
       (?$(DkU(B . "0x9C72") ;; <CJK>
       (?$(DkV(B . "0x9C75") ;; <CJK>
       (?$(DkW(B . "0x9C77") ;; <CJK>
       (?$(DkX(B . "0x9C7B") ;; <CJK>
       (?$(DkY(B . "0x9CE6") ;; <CJK>
       (?$(DkZ(B . "0x9CF2") ;; <CJK>
       (?$(Dk[(B . "0x9CF7") ;; <CJK>
       (?$(Dk\(B . "0x9CF9") ;; <CJK>
       (?$(Dk](B . "0x9D0B") ;; <CJK>
       (?$(Dk^(B . "0x9D02") ;; <CJK>
       (?$(Dk_(B . "0x9D11") ;; <CJK>
       (?$(Dk`(B . "0x9D17") ;; <CJK>
       (?$(Dka(B . "0x9D18") ;; <CJK>
       (?$(Dkb(B . "0x9D1C") ;; <CJK>
       (?$(Dkc(B . "0x9D1D") ;; <CJK>
       (?$(Dkd(B . "0x9D1E") ;; <CJK>
       (?$(Dke(B . "0x9D2F") ;; <CJK>
       (?$(Dkf(B . "0x9D30") ;; <CJK>
       (?$(Dkg(B . "0x9D32") ;; <CJK>
       (?$(Dkh(B . "0x9D33") ;; <CJK>
       (?$(Dki(B . "0x9D34") ;; <CJK>
       (?$(Dkj(B . "0x9D3A") ;; <CJK>
       (?$(Dkk(B . "0x9D3C") ;; <CJK>
       (?$(Dkl(B . "0x9D45") ;; <CJK>
       (?$(Dkm(B . "0x9D3D") ;; <CJK>
       (?$(Dkn(B . "0x9D42") ;; <CJK>
       (?$(Dko(B . "0x9D43") ;; <CJK>
       (?$(Dkp(B . "0x9D47") ;; <CJK>
       (?$(Dkq(B . "0x9D4A") ;; <CJK>
       (?$(Dkr(B . "0x9D53") ;; <CJK>
       (?$(Dks(B . "0x9D54") ;; <CJK>
       (?$(Dkt(B . "0x9D5F") ;; <CJK>
       (?$(Dku(B . "0x9D63") ;; <CJK>
       (?$(Dkv(B . "0x9D62") ;; <CJK>
       (?$(Dkw(B . "0x9D65") ;; <CJK>
       (?$(Dkx(B . "0x9D69") ;; <CJK>
       (?$(Dky(B . "0x9D6A") ;; <CJK>
       (?$(Dkz(B . "0x9D6B") ;; <CJK>
       (?$(Dk{(B . "0x9D70") ;; <CJK>
       (?$(Dk|(B . "0x9D76") ;; <CJK>
       (?$(Dk}(B . "0x9D77") ;; <CJK>
       (?$(Dk~(B . "0x9D7B") ;; <CJK>
       (?$(Dl!(B . "0x9D7C") ;; <CJK>
       (?$(Dl"(B . "0x9D7E") ;; <CJK>
       (?$(Dl#(B . "0x9D83") ;; <CJK>
       (?$(Dl$(B . "0x9D84") ;; <CJK>
       (?$(Dl%(B . "0x9D86") ;; <CJK>
       (?$(Dl&(B . "0x9D8A") ;; <CJK>
       (?$(Dl'(B . "0x9D8D") ;; <CJK>
       (?$(Dl((B . "0x9D8E") ;; <CJK>
       (?$(Dl)(B . "0x9D92") ;; <CJK>
       (?$(Dl*(B . "0x9D93") ;; <CJK>
       (?$(Dl+(B . "0x9D95") ;; <CJK>
       (?$(Dl,(B . "0x9D96") ;; <CJK>
       (?$(Dl-(B . "0x9D97") ;; <CJK>
       (?$(Dl.(B . "0x9D98") ;; <CJK>
       (?$(Dl/(B . "0x9DA1") ;; <CJK>
       (?$(Dl0(B . "0x9DAA") ;; <CJK>
       (?$(Dl1(B . "0x9DAC") ;; <CJK>
       (?$(Dl2(B . "0x9DAE") ;; <CJK>
       (?$(Dl3(B . "0x9DB1") ;; <CJK>
       (?$(Dl4(B . "0x9DB5") ;; <CJK>
       (?$(Dl5(B . "0x9DB9") ;; <CJK>
       (?$(Dl6(B . "0x9DBC") ;; <CJK>
       (?$(Dl7(B . "0x9DBF") ;; <CJK>
       (?$(Dl8(B . "0x9DC3") ;; <CJK>
       (?$(Dl9(B . "0x9DC7") ;; <CJK>
       (?$(Dl:(B . "0x9DC9") ;; <CJK>
       (?$(Dl;(B . "0x9DCA") ;; <CJK>
       (?$(Dl<(B . "0x9DD4") ;; <CJK>
       (?$(Dl=(B . "0x9DD5") ;; <CJK>
       (?$(Dl>(B . "0x9DD6") ;; <CJK>
       (?$(Dl?(B . "0x9DD7") ;; <CJK>
       (?$(Dl@(B . "0x9DDA") ;; <CJK>
       (?$(DlA(B . "0x9DDE") ;; <CJK>
       (?$(DlB(B . "0x9DDF") ;; <CJK>
       (?$(DlC(B . "0x9DE0") ;; <CJK>
       (?$(DlD(B . "0x9DE5") ;; <CJK>
       (?$(DlE(B . "0x9DE7") ;; <CJK>
       (?$(DlF(B . "0x9DE9") ;; <CJK>
       (?$(DlG(B . "0x9DEB") ;; <CJK>
       (?$(DlH(B . "0x9DEE") ;; <CJK>
       (?$(DlI(B . "0x9DF0") ;; <CJK>
       (?$(DlJ(B . "0x9DF3") ;; <CJK>
       (?$(DlK(B . "0x9DF4") ;; <CJK>
       (?$(DlL(B . "0x9DFE") ;; <CJK>
       (?$(DlM(B . "0x9E0A") ;; <CJK>
       (?$(DlN(B . "0x9E02") ;; <CJK>
       (?$(DlO(B . "0x9E07") ;; <CJK>
       (?$(DlP(B . "0x9E0E") ;; <CJK>
       (?$(DlQ(B . "0x9E10") ;; <CJK>
       (?$(DlR(B . "0x9E11") ;; <CJK>
       (?$(DlS(B . "0x9E12") ;; <CJK>
       (?$(DlT(B . "0x9E15") ;; <CJK>
       (?$(DlU(B . "0x9E16") ;; <CJK>
       (?$(DlV(B . "0x9E19") ;; <CJK>
       (?$(DlW(B . "0x9E1C") ;; <CJK>
       (?$(DlX(B . "0x9E1D") ;; <CJK>
       (?$(DlY(B . "0x9E7A") ;; <CJK>
       (?$(DlZ(B . "0x9E7B") ;; <CJK>
       (?$(Dl[(B . "0x9E7C") ;; <CJK>
       (?$(Dl\(B . "0x9E80") ;; <CJK>
       (?$(Dl](B . "0x9E82") ;; <CJK>
       (?$(Dl^(B . "0x9E83") ;; <CJK>
       (?$(Dl_(B . "0x9E84") ;; <CJK>
       (?$(Dl`(B . "0x9E85") ;; <CJK>
       (?$(Dla(B . "0x9E87") ;; <CJK>
       (?$(Dlb(B . "0x9E8E") ;; <CJK>
       (?$(Dlc(B . "0x9E8F") ;; <CJK>
       (?$(Dld(B . "0x9E96") ;; <CJK>
       (?$(Dle(B . "0x9E98") ;; <CJK>
       (?$(Dlf(B . "0x9E9B") ;; <CJK>
       (?$(Dlg(B . "0x9E9E") ;; <CJK>
       (?$(Dlh(B . "0x9EA4") ;; <CJK>
       (?$(Dli(B . "0x9EA8") ;; <CJK>
       (?$(Dlj(B . "0x9EAC") ;; <CJK>
       (?$(Dlk(B . "0x9EAE") ;; <CJK>
       (?$(Dll(B . "0x9EAF") ;; <CJK>
       (?$(Dlm(B . "0x9EB0") ;; <CJK>
       (?$(Dln(B . "0x9EB3") ;; <CJK>
       (?$(Dlo(B . "0x9EB4") ;; <CJK>
       (?$(Dlp(B . "0x9EB5") ;; <CJK>
       (?$(Dlq(B . "0x9EC6") ;; <CJK>
       (?$(Dlr(B . "0x9EC8") ;; <CJK>
       (?$(Dls(B . "0x9ECB") ;; <CJK>
       (?$(Dlt(B . "0x9ED5") ;; <CJK>
       (?$(Dlu(B . "0x9EDF") ;; <CJK>
       (?$(Dlv(B . "0x9EE4") ;; <CJK>
       (?$(Dlw(B . "0x9EE7") ;; <CJK>
       (?$(Dlx(B . "0x9EEC") ;; <CJK>
       (?$(Dly(B . "0x9EED") ;; <CJK>
       (?$(Dlz(B . "0x9EEE") ;; <CJK>
       (?$(Dl{(B . "0x9EF0") ;; <CJK>
       (?$(Dl|(B . "0x9EF1") ;; <CJK>
       (?$(Dl}(B . "0x9EF2") ;; <CJK>
       (?$(Dl~(B . "0x9EF5") ;; <CJK>
       (?$(Dm!(B . "0x9EF8") ;; <CJK>
       (?$(Dm"(B . "0x9EFF") ;; <CJK>
       (?$(Dm#(B . "0x9F02") ;; <CJK>
       (?$(Dm$(B . "0x9F03") ;; <CJK>
       (?$(Dm%(B . "0x9F09") ;; <CJK>
       (?$(Dm&(B . "0x9F0F") ;; <CJK>
       (?$(Dm'(B . "0x9F10") ;; <CJK>
       (?$(Dm((B . "0x9F11") ;; <CJK>
       (?$(Dm)(B . "0x9F12") ;; <CJK>
       (?$(Dm*(B . "0x9F14") ;; <CJK>
       (?$(Dm+(B . "0x9F16") ;; <CJK>
       (?$(Dm,(B . "0x9F17") ;; <CJK>
       (?$(Dm-(B . "0x9F19") ;; <CJK>
       (?$(Dm.(B . "0x9F1A") ;; <CJK>
       (?$(Dm/(B . "0x9F1B") ;; <CJK>
       (?$(Dm0(B . "0x9F1F") ;; <CJK>
       (?$(Dm1(B . "0x9F22") ;; <CJK>
       (?$(Dm2(B . "0x9F26") ;; <CJK>
       (?$(Dm3(B . "0x9F2A") ;; <CJK>
       (?$(Dm4(B . "0x9F2B") ;; <CJK>
       (?$(Dm5(B . "0x9F2F") ;; <CJK>
       (?$(Dm6(B . "0x9F31") ;; <CJK>
       (?$(Dm7(B . "0x9F32") ;; <CJK>
       (?$(Dm8(B . "0x9F34") ;; <CJK>
       (?$(Dm9(B . "0x9F37") ;; <CJK>
       (?$(Dm:(B . "0x9F39") ;; <CJK>
       (?$(Dm;(B . "0x9F3A") ;; <CJK>
       (?$(Dm<(B . "0x9F3C") ;; <CJK>
       (?$(Dm=(B . "0x9F3D") ;; <CJK>
       (?$(Dm>(B . "0x9F3F") ;; <CJK>
       (?$(Dm?(B . "0x9F41") ;; <CJK>
       (?$(Dm@(B . "0x9F43") ;; <CJK>
       (?$(DmA(B . "0x9F44") ;; <CJK>
       (?$(DmB(B . "0x9F45") ;; <CJK>
       (?$(DmC(B . "0x9F46") ;; <CJK>
       (?$(DmD(B . "0x9F47") ;; <CJK>
       (?$(DmE(B . "0x9F53") ;; <CJK>
       (?$(DmF(B . "0x9F55") ;; <CJK>
       (?$(DmG(B . "0x9F56") ;; <CJK>
       (?$(DmH(B . "0x9F57") ;; <CJK>
       (?$(DmI(B . "0x9F58") ;; <CJK>
       (?$(DmJ(B . "0x9F5A") ;; <CJK>
       (?$(DmK(B . "0x9F5D") ;; <CJK>
       (?$(DmL(B . "0x9F5E") ;; <CJK>
       (?$(DmM(B . "0x9F68") ;; <CJK>
       (?$(DmN(B . "0x9F69") ;; <CJK>
       (?$(DmO(B . "0x9F6D") ;; <CJK>
       (?$(DmP(B . "0x9F6E") ;; <CJK>
       (?$(DmQ(B . "0x9F6F") ;; <CJK>
       (?$(DmR(B . "0x9F70") ;; <CJK>
       (?$(DmS(B . "0x9F71") ;; <CJK>
       (?$(DmT(B . "0x9F73") ;; <CJK>
       (?$(DmU(B . "0x9F75") ;; <CJK>
       (?$(DmV(B . "0x9F7A") ;; <CJK>
       (?$(DmW(B . "0x9F7D") ;; <CJK>
       (?$(DmX(B . "0x9F8F") ;; <CJK>
       (?$(DmY(B . "0x9F90") ;; <CJK>
       (?$(DmZ(B . "0x9F91") ;; <CJK>
       (?$(Dm[(B . "0x9F92") ;; <CJK>
       (?$(Dm\(B . "0x9F94") ;; <CJK>
       (?$(Dm](B . "0x9F96") ;; <CJK>
       (?$(Dm^(B . "0x9F97") ;; <CJK>
       (?$(Dm_(B . "0x9F9E") ;; <CJK>
       (?$(Dm`(B . "0x9FA1") ;; <CJK>
       (?$(Dma(B . "0x9FA2") ;; <CJK>
       (?$(Dmb(B . "0x9FA3") ;; <CJK>
       (?$(Dmc(B . "0x9FA5") ;; <CJK>
       ))))

(provide 'ujisx0212)
     
