;;; DO NOT MODIFY THIS FILE
(if (featurep 'xwem-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "lisp/_pkg.el")

(package-provide 'xwem :version 1.12 :author-version "0.2" :type 'regular)

;;;***

;;;### (autoloads (xwem-cl-hdestroy-notify xwem-client-show xwem-client-hide xwem-fini-clients xwem-cl-get-uptime xwem-cl-get-psize xwem-cl-get-usize xwem-make-client xwem-client-change-state xwem-client-focus xwem-client-sendmsg-atom xwem-init-clients xwem-cl-correct-size-for-size xwem-cl-normal-list xwem-cl-exclude-p xwem-cl-alive-p xwem-cl-send-config xwem-remove-client xwem-find-client xwem-client-name xwem-cl-destroyed-p xwem-cl-marked-p xwem-cl-p) "xwem-clients" "lisp/xwem-clients.el")

(defcustom xwem-cl-create-hook nil "Hook to call when creating new client." :type 'hook :group 'xwem-cl)

(defcustom xwem-cl-destroy-hook nil "Hooks called with one argument - cl, when cl destroyed.\nNOT USED YET." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-manage-hook nil "*Hooks to be called with just setuped CL as argument." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-demanage-hook nil "*Hooks to be called with just desetuped CL as argument." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-refit-hook nil "Hooks called when CL just refited." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-iconify-hook nil "Hooks called when CL just iconified." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-change-hook nil "Hooks called when something changed in CL." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-state-change-hook nil "*Hooks to run when state of client changes.\nEvery hook called with three args - CL OLD-STATE NEW-STATE." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-mark-hook nil "*Hooks to run when marking client.\nHooks called with two args - CL STATE.\nWhere STATE is one of 'mark or 'unmark." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-wmnh-change-hooks nil "Hooks to be called when WM_NORMAL_HINTS changes." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-wmname-change-hooks nil "Hooks to be called when WM_NAME changes." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-wmcommand-chage-hooks nil "Hooks to be called when WM_COMMAND changes." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-wmclass-change-hooks nil "Hooks to be called when WM_CLASS changes." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-wmh-change-hooks nil "Hooks to be called when WM_HINTS changes." :type 'hook :group 'xwem-hooks)

(defvar xwem-clients nil "\
Clients Windows list")

(defvar xwem-cl-mark-ring nil "\
The list of marked clients.")

(defstruct xwem-hints wm-normal-hints wm-hints wm-class wm-command wm-name wm-transient-for wm-protocols)

(defconst xwem-client-ev-mask (Xmask-or XM-ColormapChange XM-PropertyChange XM-FocusChange XM-EnterWindow XM-LeaveWindow XM-StructureNotify XM-ResizeRedirect) "\
Event mask for xwem's client.")

(defstruct (xwem-cl (:predicate xwem-iscl-p)) xwin saved-name xgeom xattrs win hints manda transient-for (ev-mask xwem-client-ev-mask) (state 'unknown) start-time recency translist plist)

(autoload 'xwem-cl-p "xwem-clients" "\
Returns t if CL is XWEM client window." nil nil)

(autoload 'xwem-cl-marked-p "xwem-clients" "\
Return non-nil if client CL is marked, i.e. in `xwem-cl-mark-ring' list." nil nil)

(autoload 'xwem-cl-destroyed-p "xwem-clients" "\
Return non-nil if CL has already destroyed xwin." nil nil)

(defsubst xwem-cl-put-prop (cl prop val) "In CL's property list put property PROP with value VAL." (setf (xwem-cl-plist cl) (plist-put (xwem-cl-plist cl) prop val)))

(defsubst xwem-cl-get-prop (cl prop) "From CL's property list get property PROP." (plist-get (xwem-cl-plist cl) prop))

(defsubst xwem-cl-rem-prop (cl prop) "From CL's property list remove property PROP." (setf (xwem-cl-plist cl) (plist-remprop (xwem-cl-plist cl) prop)))

(autoload 'xwem-client-name "xwem-clients" "\
Returns unique name for CL.
If CLIST is ommited, `xwem-clients' will be used.
If CL is string, return it." nil nil)

(autoload 'xwem-find-client "xwem-clients" "\
Find WIN-OR-ID in client windows list.
WIN-OR-ID can be X-Win or id of window." nil nil)

(autoload 'xwem-remove-client "xwem-clients" "\
Delete WIN from clients list." nil nil)

(autoload 'xwem-cl-send-config "xwem-clients" "\
Send config info to window." nil nil)

(autoload 'xwem-cl-alive-p "xwem-clients" "\
Return non-nil if CL is alive i.e. in `xwem-clients' list." nil nil)

(autoload 'xwem-cl-exclude-p "xwem-clients" "\
Return non-nil if CL should be excluded from clients list." nil nil)

(autoload 'xwem-cl-normal-list "xwem-clients" "\
Return list of normal clients.
CLIENTS is list of xwem clients frome which we should exclude.
If PREDIC given it will be called on each client and should return nil to exclude client." nil nil)

(autoload 'xwem-cl-correct-size-for-size "xwem-clients" "\
Make CL's geometry as close to NEW-GEOM as possible.
X-TYPE is one of 'center 'left or 'right, default is 'center.
Y-TYPE is one of 'center 'top or 'bottom, default is 'center." nil nil)
(autoload 'xwem-client-iconify "xwem-clients" "" t)
(autoload 'xwem-cl-switch "xwem-clients" "" t)
(autoload 'xwem-cl-switch-other-win "xwem-clients" "" t)
(autoload 'xwem-cl-switch-other-frame "xwem-clients" "" t)
(autoload 'xwem-cl-switch-to-other "xwem-clients" "" t)
(autoload 'xwem-cl-switch-to-other-in-other-win "xwem-clients" "" t)
(autoload 'xwem-kill-cl-and-window "xwem-clients" "" t)
(autoload 'xwem-cl-transpose "xwem-clients" "" t)

(autoload 'xwem-init-clients "xwem-clients" "\
Clients part initializer" nil nil)

(autoload 'xwem-client-sendmsg-atom "xwem-clients" "\
Send Client message to client CL." nil nil)

(autoload 'xwem-client-focus "xwem-clients" "\
Focus xwem client's CL window.
By default this function does useful things only if CL is selected CL
or FORCE is non-nil.
Return non-nil, if CL supports WM_TAKE_FOCUS." nil nil)

(autoload 'xwem-client-change-state "xwem-clients" "\
Change WM_STATE for CL, STATE is one of 'managed, 'iconified, 'withdrawn, etc." nil nil)

(defsubst xwem-cl-managed-p (cl &optional win) "Return non-nil if client CL is managed, i.e. has 'managed or 'normal state." (and (or (not win) (eq (xwem-cl-win cl) win)) (or (eq (xwem-cl-state cl) 'managed) (eq (xwem-cl-state cl) 'managed-current))))

(autoload 'xwem-make-client "xwem-clients" "\
Make new client window.
WIN   - X Window.
PROPS - Properties list for new client.
XWEM-WIN - xwem window where new client should be managed(if possible)." nil nil)
(autoload 'xwem-client-turn-on-other-on-split "xwem-clients" "" t)
(autoload 'xwem-client-turn-off-other-on-split "xwem-clients" "" t)
(autoload 'xwem-client-toggle-other-on-split "xwem-clients" "" t)
(autoload 'xwem-client-kill "xwem-clients" "" t)
(autoload 'xwem-client-query-kill "xwem-clients" "" t)
(autoload 'xwem-client-demanage-others "xwem-clients" "" t)
(autoload 'xwem-client-run-copy "xwem-clients" "" t)
(autoload 'xwem-client-run-copy-other-win "xwem-clients" "" t)
(autoload 'xwem-client-run-copy-other-frame "xwem-clients" "" t)

(autoload 'xwem-cl-get-usize "xwem-clients" "\
Returns cons cell (uwi . uhe) - CL's size in steps." nil nil)

(autoload 'xwem-cl-get-psize "xwem-clients" "\
Return pixel size of CL (pwi . phe)." nil nil)

(autoload 'xwem-cl-get-uptime "xwem-clients" "\
Return CL's uptime.
FORMAT can contain %-sequences to substitute parts of the uptime.
%d is replaced by the days
%h is replaced by the hours
%m is replaced by the minutes
%s is replaced by the seconds
%A is replaced by autogenerated format." nil nil)
(autoload 'xwem-client-info "xwem-clients" "" t)
(autoload 'xwem-cl-pop-to-client "xwem-clients" "" t)
(autoload 'xwem-cl-set-title "xwem-clients" "" t)
(autoload 'xwem-client-unset-mark "xwem-clients" "" t)
(autoload 'xwem-client-set-mark "xwem-clients" "" t)

(autoload 'xwem-fini-clients "xwem-clients" "\
Fini all clients." nil nil)

(autoload 'xwem-client-hide "xwem-clients" "\
Hide CL's window. Optionally you may specify NEW-STATE." nil nil)

(autoload 'xwem-client-show "xwem-clients" "\
Show xwem client CL." nil nil)

(autoload 'xwem-cl-hdestroy-notify "xwem-clients" "\
DestroyNotify event XEV." nil nil)

;;;***

;;;### (autoloads (xwem-define-prefix-command) "xwem-compat" "lisp/xwem-compat.el")

(defvar xwem-gnuemacs-p (string-match "GNU Emacs" emacs-version) "\
Non-nil when running under GNU Emacs.")

(autoload 'xwem-define-prefix-command "xwem-compat" "\
Compat version for `define-prefix-command'." nil nil)

(unless (fboundp 'set-keymap-default-binding) (fset 'set-keymap-default-binding (lambda (keym cmd) (define-key keym [t] cmd))))

(unless (fboundp 'events-to-keys) (defalias 'events-to-keys 'identity))

;;;***

;;;### (autoloads (xwem-diag-read-data-file xwem-diag-plot-dots xwem-diag-plot-points xwem-diag-plot-coordinates xwem-diag-draw-percentage) "xwem-diagram" "lisp/xwem-diagram.el")

(autoload 'xwem-diag-draw-percentage "xwem-diagram" "\
Draw percentage sector of TYPE.
TYPE is one of 'plain or '3d.
SPEC specifies percentage to display, it is an array in form
[percents sector-label fill-color center-offset x-offset y-offset]
  perecnts - is number betwean 0 and 100.
  sector-label - either string or t, t mean show percentage.
  fill-color - nil or color to fill sector.
  center-offset - sector's offset from center using bisector vector.
  x-offset - sector's x offset.
  y-offset - sector's y offest.

EDGE-GC used to draw sector edges.
X, Y, WIDTH and HEIGHT specifies sector geometry coordinate inside
drawable D.
Optionally SECTOR-WIDTH may be specified (only for '3d TYPE).
LABEL-FACTOR is float number used, when calculating label placement.
LABEL-FONT is font used to draw label, default is font of EDGE-GC." nil nil)

(autoload 'xwem-diag-plot-coordinates "xwem-diagram" "\
Draw coordinates system." nil nil)

(autoload 'xwem-diag-plot-points "xwem-diagram" "\
Draw points of TYPE." nil nil)

(autoload 'xwem-diag-plot-dots "xwem-diagram" "\
Draw dots in cartesian coordinate system which has 0 at X Y." nil nil)

(autoload 'xwem-diag-read-data-file "xwem-diagram" "\
Read data FILE and return list of dots lists.
USING is cons cell that specifies which columns to use.
X-SCALE is x coordinates scalling.
Y-SCALE is y coordinates scalling." nil nil)

;;;***

;;;### (autoloads nil "xwem-edmacro" "lisp/xwem-edmacro.el")
(autoload 'xwem-edmacro-edit-kbd-macro "xwem-edmacro" "" t)

;;;***

;;;### (autoloads (xwem-next-event xwem-parse-message-guess xwem-fini-events xwem-init-events) "xwem-events" "lisp/xwem-events.el")

(autoload 'xwem-init-events "xwem-events" "\
Init part rot events. Installs events dispatcher on `xwem-dpy'." nil nil)

(autoload 'xwem-fini-events "xwem-events" nil nil nil)

(defvar xwem-events-queue nil)

(autoload 'xwem-parse-message-guess "xwem-events" "\
There is data waiting on XDPY, but no-one is reading it.
Try to guess what it is." nil nil)

(autoload 'xwem-next-event "xwem-events" "\
Fetch next xwem keyboard or mouse event.
If optional argument PEEK is non-nil than do not remove." nil nil)

;;;***

;;;### (autoloads (xwem-face-set-foreground xwem-face-get-gc xwem-face-tag xwem-init-faces) "xwem-faces" "lisp/xwem-faces.el")

(autoload 'xwem-init-faces "xwem-faces" "\
Initialize faces." nil nil)

(autoload 'xwem-face-tag "xwem-faces" "\
Get FACE's TAG value.
For example \\(xwem-face-tag 'xwem-face-win-selected :line-width\\)." nil nil)

(autoload 'xwem-face-get-gc "xwem-faces" "\
Return X-Gc with NAME.
Name can be symbol or string.
XDPY - X display.
D    - X drawable." nil nil)

(autoload 'xwem-face-set-foreground "xwem-faces" "\
Set FACE's foreground color to FG." nil nil)

;;;***

;;;### (autoloads (xwem-focus-mode-set xwem-focus-mode-invoke xwem-focus-excursion xwem-focus-set xwem-focus-pop-set xwem-focus-push-set xwem-focus-pop xwem-focus-push xwem-focus-xcurrent) "xwem-focus" "lisp/xwem-focus.el")

(defvar xwem-focus-stack nil "\
Last thing that has focus.
Internal variable, do not modify.")

(autoload 'xwem-focus-xcurrent "xwem-focus" "\
Return current focus." nil nil)

(autoload 'xwem-focus-push "xwem-focus" "\
Push current focus or XWIN to `xwem-focus-stack'." nil nil)

(autoload 'xwem-focus-pop "xwem-focus" "\
Pop value from `xwem-focus-stack'." nil nil)

(autoload 'xwem-focus-push-set "xwem-focus" "\
Push current focus to `xwem-focus-stack' and set focus to XWIN." nil nil)

(autoload 'xwem-focus-pop-set "xwem-focus" "\
Pop from `xwem-focus-stack' and set focus." nil nil)

(autoload 'xwem-focus-set "xwem-focus" "\
Set input focus to THING.
THING - one of X-Win, xwem-frame, or xwem-client.
PUSH  - Non-nil for pushing thing into `xwem-focus-stack'." nil nil)

(autoload 'xwem-focus-excursion "xwem-focus" "\
Under XWIN focus do FORMS." nil 'macro)

(defcustom xwem-default-focus-mode 'generic "*Default CL's focus mode." :type '(choice (const :tag "Generic mode" generic) (const :tag "Click to focus" click-focus) (const :tag "Follow mouse" follow-mouse)) :group 'xwem)

(autoload 'xwem-focus-mode-invoke "xwem-focus" "\
Invoke CL's focus mode function with ARGS." nil nil)

(autoload 'xwem-focus-mode-set "xwem-focus" "\
For CL window set focus mode to MODE." nil nil)

;;;***

;;;### (autoloads (xwem-frame-make-cl-list xwem-frame-config-restore xwem-frame-config-dump xwem-set-frame-configuration xwem-frame-configuration xwem-frame-configuration-p xwem-frame-draw xwem-frame-redraw xwem-frame-set-size xwem-frame-set-pos xwem-frame-num xwem-frame-other xwem-frame-find xwem-find-frame xwem-fini-frames xwem-init-frames xwem-make-frame-1 xwem-frame-select xwem-frame-selected-p xwem-frame-selected xwem-frame-height xwem-frame-width xwem-frame-y xwem-frame-x xwem-frame-p) "xwem-frame" "lisp/xwem-frame.el")

(defconst xwem-frame-ev-mask (Xmask-or XM-Exposure XM-StructureNotify XM-SubstructureRedirect XM-SubstructureNotify XM-KeyPress XM-ButtonPress XM-ButtonRelease XM-ResizeRedirect) "\
Events mask for xwem's frame.")

(defvar xwem-frames-list nil "\
All frames xwem owns.")

(defstruct (xwem-frame (:predicate xwem-isframe-p)) (name "default") xgeom xwin rootwin selwin link-next link-prev embedded-p state props)

(autoload 'xwem-frame-p "xwem-frame" "\
Return t if FRAME is XWEM frame." nil nil)

(autoload 'xwem-frame-x "xwem-frame" nil nil 'macro)

(autoload 'xwem-frame-y "xwem-frame" nil nil 'macro)

(autoload 'xwem-frame-width "xwem-frame" nil nil 'macro)

(autoload 'xwem-frame-height "xwem-frame" nil nil 'macro)

(autoload 'xwem-frame-selected "xwem-frame" "\
Return selected frame." nil nil)

(autoload 'xwem-frame-selected-p "xwem-frame" "\
Return non-nil if FRAME is selected." nil nil)

(autoload 'xwem-frame-select "xwem-frame" "\
Set FRAME as selected frame.
If DNR-HOOKS is non-nil, than do not run hooks." nil nil)

(autoload 'xwem-make-frame-1 "xwem-frame" "\
Create new frame with optional frame properties PROPS.
If EMBEDDED-p is non-nil than create embedded frame.
If NON-SELECT is non-nil then do not select newly created frame to be
current." nil nil)

(autoload 'xwem-init-frames "xwem-frame" "\
xwem frames initializer." nil nil)

(autoload 'xwem-fini-frames "xwem-frame" "\
Finialize frames." nil nil)
(autoload 'xwem-make-frame "xwem-frame" "" t)

(autoload 'xwem-find-frame "xwem-frame" nil nil nil)

(autoload 'xwem-frame-find "xwem-frame" "\
Find frame by ARG. HOW is search type, one of 'xwin 'win 'cl or 'name." nil nil)

(autoload 'xwem-frame-other "xwem-frame" "\
Same as `xwem-frame-other-frame', but return nil, if no good other frame found.
TYPE is ane of 'any, 'linkage" nil nil)

(autoload 'xwem-frame-num "xwem-frame" "\
Return FRAME index in `xwem-frames-list'." nil nil)

(autoload 'xwem-frame-set-pos "xwem-frame" "\
Set FRAME position at NEW-X and NEW-Y." nil nil)

(autoload 'xwem-frame-set-size "xwem-frame" "\
Resize FRAME to NEW-WIDTH and NEW-HEIGHT." nil nil)

(autoload 'xwem-frame-redraw "xwem-frame" "\
Redraw FRAMEs windows outlines." nil nil)

(autoload 'xwem-frame-draw "xwem-frame" "\
Draw FRAME. If FULL is t then fully redraw it, i.e. ClearWindow first." nil nil)

(autoload 'xwem-frame-configuration-p "xwem-frame" "\
Return non-nil if FRAME-CONFIG is looks like frame configuration." nil nil)

(autoload 'xwem-frame-configuration "xwem-frame" "\
Return current xwem frame configuration." nil nil)

(autoload 'xwem-set-frame-configuration "xwem-frame" "\
Restore the frames to the state described by FRAME-CONFIG." nil nil)

(autoload 'xwem-frame-config-dump "xwem-frame" "\
Dump frame configuration CONFIG to FILE.
If FILE ommited, than ~/.xwem/xwem-configs.el will be used." nil nil)

(autoload 'xwem-frame-config-restore "xwem-frame" "\
Restore saved frames configuration from FILE.
Default FILE is ~/.xwem/xwem-configs.el" nil nil)
(autoload 'xwem-frame-lower "xwem-frame" "" t)
(autoload 'xwem-frame-raise "xwem-frame" "" t)
(autoload 'xwem-frame-next "xwem-frame" "" t)
(autoload 'xwem-frame-previous "xwem-frame" "" t)
(autoload 'xwem-frame-switch-nth "xwem-frame" "" t)
(autoload 'xwem-frame-switch-nth-linkage "xwem-frame" "" t)
(autoload 'xwem-frame-destroy "xwem-frame" "" t)
(autoload 'xwem-frame-del-win "xwem-frame" "" t)
(autoload 'xwem-frame-del-others "xwem-frame" "" t)
(autoload 'xwem-frame-split-horiz "xwem-frame" "" t)
(autoload 'xwem-frame-split-vert "xwem-frame" "" t)
(autoload 'xwem-frame-win-enlarge-hor "xwem-frame" "" t)
(autoload 'xwem-frame-win-enlarge-ver "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next-vert "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next-hor "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev-vert "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev-hor "xwem-frame" "" t)
(autoload 'xwem-frame-split-sbs "xwem-frame" "" t)
(autoload 'xwem-frame-sbs-hor-split "xwem-frame" "" t)
(autoload 'xwem-frame-sbs-vert-split "xwem-frame" "" t)
(autoload 'xwem-frame-fit-screen "xwem-frame" "" t)
(autoload 'xwem-frame-transpose "xwem-frame" "" t)
(autoload 'xwem-frame-showroot "xwem-frame" "" t)
(autoload 'xwem-frame-hide "xwem-frame" "" t)
(autoload 'xwem-transpose-frames "xwem-frame" "" t)
(autoload 'xwem-frame-set-name "xwem-frame" "" t)
(autoload 'xwem-frame-on-delim-resize "xwem-frame" "" t)
(autoload 'xwem-frame-on-delim-menu "xwem-frame" "" t)
(autoload 'xwem-frame-imove "xwem-frame" "" t)
(autoload 'xwem-frame-iresize "xwem-frame" "" t)

(autoload 'xwem-frame-make-cl-list "xwem-frame" "\
Make list of all clients FRAME holds." nil nil)

;;;***

;;;### (autoloads (xwem-framei-start-dockapp xwem-framei-init) "xwem-framei" "lisp/xwem-framei.el")

(autoload 'xwem-framei-init "xwem-framei" "\
Initialize xwem frame indicator on display XDPY." nil nil)

(defcustom xwem-framei-dockapp-format-function 'xwem-framei-dockapp-default-format "Function passed with one arg - frame, should return string to display." :type 'funtion :group 'xwem-framei)

(autoload 'xwem-framei-start-dockapp "xwem-framei" "\
Start frameindicator as dockapp.
XDPY   - display where run dockapp (default is `xwem-dpy').
WIDTH  - Dockapp width (default is 24).
HEIGHT - Dockapp height (default is 24)." nil nil)

;;;***

;;;### (autoloads (xwem-logo-string) "xwem-help" "lisp/xwem-help.el")

(autoload 'xwem-logo-string "xwem-help" "\
Return textified XWEM's logo string." nil nil)
(autoload 'xwem-help "xwem-help" "" t)
(autoload 'xwem-help-for-help "xwem-help" "" t)
(autoload 'xwem-describe-prefix-bindings "xwem-help" "" t)
(autoload 'xwem-help-describe-bindings "xwem-help" "" t)
(autoload 'xwem-help-describe-key1 "xwem-help" "" t)
(autoload 'xwem-help-describe-key "xwem-help" "" t)
(autoload 'xwem-help-frames "xwem-help" "" t)
(autoload 'xwem-help-wins "xwem-help" "" t)
(autoload 'xwem-help-clients "xwem-help" "" t)
(autoload 'xwem-help-where-is "xwem-help" "" t)

;;;***

;;;### (autoloads nil "xwem-holer" "lisp/xwem-holer.el")

(xwem-define-prefix-command 'xwem-holer-prefix t)

;;;***

;;;### (autoloads (xwem-icons-cl-icon) "xwem-icons" "lisp/xwem-icons.el")

(defvar xwem-icons-alist '(([".*" ".term" ".Term"] . "mini-term.xpm") ([".*" "xclock" "XClock"] . "mini-clock.xpm") ([".*" "xload" "XLoad"] . "mini-measure.xpm") ([".*" "xcalc" "XCalc"] . "mini-calc.xpm") ([".*" "xkeycaps" "XKeyCaps"] . "mini-xkeycaps.xpm") ([".*" "xdvi" "XDvi"] . "mini-xdvi.xpm") ([".*" "xv" "XV.*"] . "mini-xv.xpm") ([".*" ".*" "AcroRead"] . "mini-acroread.xpm") ([".*" ".*" "Xpdf"] . "mini-acroread.xpm") ([".*" ".*" "Xman"] . "mini-info.xpm") ([".*" "Mozilla" ".*"] . "mini-mozilla.xpm") ([".*" "gv" "GV"] . "mini-gv.xpm") ([".*" "ghostview" "Ghostview"] . "mini-gv.xpm") ([".*" "xfig" "Fig"] . "mini-xfig.xpm") ([".*" "ethereal" "Ethereal"] . "mini-ethereal.xpm") ([".*" "xfd" "Xfd"] . "mini-font.xpm") ([".*" "xfontsel" "XFontSel"] . "mini-font.xpm") ([".*" "xconsole" "XConsole"] . "mini-sh1.xpm") ([".*" "xcolors" "Xcolors"] . "mini-colors.xpm") ([".*" ".*" "X-Chat"] . "mini-xchat.xpm") (["Lupe" ".*" ".*"] . "mini-zoom.xpm") (["xcmap" "" ".*"] . "mini-colors.xpm") ([".*\\.tex.*" "emacs" "Emacs"] . "mini-xemacstex.xpm") ([".*\\.c.*" "emacs" "Emacs"] . "mini-xemacsC.xpm") ([".*\\.py.*" "emacs" "Emacs"] . "mini-xemacspy.xpm") ([".*\\(Group\\|Summary\\|Article\\).*" "emacs" "Emacs"] . "mini-xemacsgnus.xpm") ([".*\\*info\\*.*" "emacs" "Emacs"] . "mini-xemacsinfo.xpm") ([".*" "emacs" "Emacs"] . "mini-xemacs.xpm") ([".*" ".*" ".*"] . "mini-x2.xpm")))

(autoload 'xwem-icons-cl-icon "xwem-icons" "\
Get X-Image of CL's icon.
Return cons cell where car is X-Pixmap of icon and cdr is X-Pixmap
where mask for icon is stored." nil nil)

;;;***

;;;### (autoloads (xwem-interactive-ilist xwem-read-frame xwem-read-client xwem-read-external-command xwem-read-shell-command xwem-read-filename xwem-read-command xwem-completing-read xwem-read-from-minibuffer xwem-interactive-p) "xwem-interactive" "lisp/xwem-interactive.el")

(defvar xwem-interactively nil "\
Non-nil when xwem in interactive mode.
Internal variabel, do not modify.")

(fset 'read-from-minibuffer-for-xwem (symbol-function 'read-from-minibuffer))

(autoload 'xwem-interactive-p "xwem-interactive" "\
Return non-nil when xwem in interactive mode." nil nil)

(autoload 'xwem-read-from-minibuffer "xwem-interactive" "\
Read data from xwem minibuffer.
Arguments PROMPT, INITIAL-CONTENTS, KEYMAP, READP, HISTORY and
ABBREV-TABLE are same as for `read-from-minibuffer'." nil nil)

(autoload 'xwem-completing-read "xwem-interactive" "\
XWEM awared varian of `completing-read'." nil nil)

(autoload 'xwem-read-command "xwem-interactive" "\
Just like `read-command', but for XWEM.
Argument PROMPT is same as for `read-command'." nil nil)

(autoload 'xwem-read-filename "xwem-interactive" "\
Just like `read-file-name', but for XWEM.
PROMPT, DIR, DEFAULT, MUST-MATCH, INITIAL-CONTENTS and HISTORY are
same as for `read-file-name'." nil nil)

(autoload 'xwem-read-shell-command "xwem-interactive" "\
Just like `read-shell-command', but for XWEM.
PROMPT, INITIAL-INPUT and HISTORY are same as for `read-shell-command'." nil nil)

(autoload 'xwem-read-external-command "xwem-interactive" "\
Read for external command using PROMPT." nil nil)

(autoload 'xwem-read-client "xwem-interactive" "\
Read for client name prompting PROMPT and return xwem client.
Additional argument PREDIC is passed right to `xwem-client-name'." nil nil)

(autoload 'xwem-read-frame "xwem-interactive" "\
Read for frame number prompting PROMPT and return xwem frame." nil nil)

(autoload 'xwem-interactive-ilist "xwem-interactive" "\
Return list valid for `interactive'.
SPEC is specification of list items." nil nil)

;;;***

;;;### (autoloads (xwem-kbd-stop-grabbing xwem-kbd-start-grabbing-sync xwem-kbd-start-grabbing xwem-kbd-uninstall-grab xwem-kbd-install-grab xwem-kbd-handle-keybutton-from-emacs xwem-kbd-handle-keybutton xwem-kbd-key-binding-evs xwem-kbd-key-binding xwem-kbd-set-current-prefix-keymap xwem-kbd-current-local-map xwem-kbd-global-map-current-p xwem-kbd-current-map xwem-kbd-force-mods-release xwem-kbd-wait-key-release xwem-key-send-ekeys xwem-kbd-ekeys->eevents xwem-kbd-xevents->emacs-events xwem-kbd-kcode-modifier-p xwem-kbd-kcode->emod xwem-kbd-emod->kcode xwem-kbd-init xwem-local-set-key xwem-local-map xwem-global-set-key xwem-define-key xwem-read-key-sequence xwem-read-key xwem-kbd) "xwem-keyboard" "lisp/xwem-keyboard.el")

(defcustom xwem-keyboard-echo-keystrokes t "*If non-nil than echo unfinished commands in echo area." :type 'boolean :group 'xwem-keyboard)

(defcustom xwem-quit-key [(hyper ?g)] "Quit command key." :type 'sexp :group 'xwem-keyboard)

(defcustom xwem-quit-command 'xwem-keyboard-quit "Default command to be called when `xwem-quit-key' pressed." :type 'function :group 'xwem-keyboard)

(defcustom xwem-prefix-help-command 'xwem-describe-prefix-bindings "Default command to be called when `xwem-help-key' pressed." :type 'function :group 'xwem-keys)

(defcustom xwem-universal-key [(hyper ?u)] "Key for universal argument commands." :type 'sexp :group 'xwem-keyboard)

(defvar xwem-override-global-map nil "\
Keymap that overrides only `xwem-global-map'.
But can't override `xwem-kbd-private-prefix-map'!
You should *bind* this, not set it.")

(defvar xwem-override-map nil "\
Keymap that overrides all other keymaps.
But can't override `xwem-kbd-private-prefix-map'!
You should *bind* this, not set it.")

(defvar xwem-kbd-now-grabbing nil "\
Non-nil indicates that we now grabbing keyboard.
Internal variable, do not modify.")

(defvar xwem-event-window nil "\
Window that receive last keypress event.")

(defvar xwem-last-event nil "\
Last keypress event.")

(defvar xwem-last-xevent nil "\
Last keypress/buttonpress X Event.")

(defvar xwem-this-command-keys [] "\
List of pressed keys to execute command.")

(defvar xwem-this-command nil "\
The command now being executed.")

(defvar xwem-last-command nil "\
The last command executed.")

(autoload 'xwem-kbd "xwem-keyboard" "\
Just like `kbd' but take into account values of `xwem-hyper-modifier' and `xwem-meta-modifier'." nil nil)

(autoload 'xwem-read-key "xwem-keyboard" "\
Read single key press, prompting PROMPT in `xwem-minibuffer'.
If NO-MINIB-FOCUS-P is non-nil, focus `xwem-minibuffer' while reading." nil nil)

(autoload 'xwem-read-key-sequence "xwem-keyboard" "\
Read key sequence that call command prompting PROMPT." nil nil)

(autoload 'xwem-define-key "xwem-keyboard" "\
Add KEY to KEYMAP to execute COMMAND and grab KEY on WIN.
When command is `nil', then undefine KEY in KEYMAP and ungrab KEY." nil nil)

(autoload 'xwem-global-set-key "xwem-keyboard" "\
Define KEY to call COMMAND, when xwem is already run.
If command is `nil' then undefine KEY in `xwem-global-map' and ungrab KEY." nil nil)

(autoload 'xwem-local-map "xwem-keyboard" "\
Return local map for CL." nil nil)

(autoload 'xwem-local-set-key "xwem-keyboard" "\
Set KEY to call COMMAND in CL's local keymap.
If COMMAND is `nil' then undefine KEY in CL's local map and ungrab KEY.
If CL is ommited `xwem-cl-selected' assumed." nil nil)
(autoload 'xwem-undefined-command "xwem-keyboard" "" t)
(autoload 'xwem-self-insert-or-undefined "xwem-keyboard" "" t)
(autoload 'xwem-keyboard-quit "xwem-keyboard" "" t)
(autoload 'xwem-kbd-quit "xwem-keyboard" "" t)

(autoload 'xwem-kbd-init "xwem-keyboard" "\
Init part for keys.
Fetches KeyboardMapping from the X server and stores it in
`xwem-xkeys-mapping'" nil nil)

(autoload 'xwem-kbd-emod->kcode "xwem-keyboard" "\
Convert Emacs modifier EMOD to X keycode.
Behaviour is undefined If ANY argument is supplied.
DO NOT RELY ON THIS FUNCTION." nil nil)

(autoload 'xwem-kbd-kcode->emod "xwem-keyboard" "\
Convert key code KCODE to Emacs modifier, if KCODE is actually a modifier.
See also `xwem-kbd-kcode-modifier-p'." nil nil)

(autoload 'xwem-kbd-kcode-modifier-p "xwem-keyboard" "\
Return non-nil if key code KCODE is modifier." nil nil)

(autoload 'xwem-kbd-xevents->emacs-events "xwem-keyboard" "\
Convert X-Events XEVS to Emacs events.

If TRUST-MODBITS is non-nil than we can trust modifier bits in
X-Event, otherwise we are trying to keep track of modifiers presses
and releases.  This is needed because core X events obtained from
RECORD extension does not have valid inforamtion about modifiers
bits." nil nil)

(autoload 'xwem-kbd-ekeys->eevents "xwem-keyboard" "\
Convert Emacs keys sequence EKEYS to Emacs events vector." nil nil)

(autoload 'xwem-key-send-ekeys "xwem-keyboard" "\
Send Emacs key sequence KEYS using XTEST extension." nil nil)

(autoload 'xwem-kbd-wait-key-release "xwem-keyboard" "\
Wait for key with KEYCODE for release." nil nil)

(autoload 'xwem-kbd-force-mods-release "xwem-keyboard" "\
Force release of some modifiers." nil nil)

(autoload 'xwem-kbd-current-map "xwem-keyboard" "\
Return current prefix map." nil nil)

(autoload 'xwem-kbd-global-map-current-p "xwem-keyboard" "\
Return non-nil if `xwem-global-map' is current prefix map." nil nil)

(autoload 'xwem-kbd-current-local-map "xwem-keyboard" "\
Return current local keymap." nil nil)

(autoload 'xwem-kbd-set-current-prefix-keymap "xwem-keyboard" "\
Set current keymap to NEWKEYMAP.

Use (xwem-kbd-set-current-prefix-keymap nil) to set current keymap
to `xwem-global-keymap' instead of
\(xwem-kbd-set-current-prefix-keymap xwem-global-map)." nil nil)

(autoload 'xwem-kbd-key-binding "xwem-keyboard" "\
Return key binding corresponding to KEYS in KEYMAP.
If KEYMAP is ommited, `xwem-global-map' will be used.
`xwem-kbd-key-binding' omits default KEYMAP binding unless
ACCEPT-DEFAULT is non-nil." nil nil)

(autoload 'xwem-kbd-key-binding-evs "xwem-keyboard" "\
Return key binding corresponding to Emacs events EVS in KEYMAP.
If KEYMAP is ommited, `xwem-global-map' will be used.
ACCEPT-DEFAULT is the same as for `xwem-kbd-key-binding'." nil nil)

(autoload 'xwem-kbd-handle-keybutton "xwem-keyboard" "\
On display XDPY and window WIN handle KeyPress or ButtonPress event XEV." nil nil)

(autoload 'xwem-kbd-handle-keybutton-from-emacs "xwem-keyboard" "\
Handle Emacs event EEV originated from XWEM.
Optional X-Event XEV, if passed to obtain X specific information." nil nil)

(autoload 'xwem-kbd-install-grab "xwem-keyboard" "\
Install KEYMAP grabs on X window WIN." nil nil)

(autoload 'xwem-kbd-uninstall-grab "xwem-keyboard" "\
Uninstall KEYMAP grabs on X window WIN." nil nil)

(autoload 'xwem-kbd-start-grabbing "xwem-keyboard" "\
Begin grabbing keyboard (some key-prefix is entered).
Optionally you can specify CURSOR to be used, while grabbing." nil nil)

(autoload 'xwem-kbd-start-grabbing-sync "xwem-keyboard" "\
Same as `xwem-kbd-start-grabbing', but initiate grabs in Sync mode.
CURSOR argument is same is for `xwem-kbd-start-grabbing'." nil nil)

(autoload 'xwem-kbd-stop-grabbing "xwem-keyboard" "\
Stop grabbing keyboard." nil nil)
(autoload 'xwem-kbd-quote-command "xwem-keyboard" "" t)

(defvar xwem-prefix-arg nil "\
The value of the prefix argument for this editing command.

It may be a number, or the symbol `-' for just a minus sign as arg, or
a list whose car is a number for just one or more
\\<xwem-global-map>\\[xwem-universal-argument] or `nil' if no argument
has been specified.  This is what `\\(xwem-interactive \"P\"\\)'
returns.")
(autoload 'xwem-universal-argument "xwem-keyboard" "" t)
(autoload 'xwem-universal-more "xwem-keyboard" "" t)
(autoload 'xwem-universal-minus "xwem-keyboard" "" t)
(autoload 'xwem-universal-digit "xwem-keyboard" "" t)
(autoload 'xwem-universal-command "xwem-keyboard" "" t)

;;;***

;;;### (autoloads nil "xwem-keydefs" "lisp/xwem-keydefs.el")

(defvar xwem-global-map (make-sparse-keymap 'XWEM-global-map) "\
XWEM's global keymap.

Bindings:
\\{xwem-global-map}.")

(defvar xwem-help-map (symbol-function (xwem-define-prefix-command 'xwem-help-prefix t)) "\
Keymap for help (\\<xwem-global-map>\\[xwem-help-prefix]) commands.

Bindings:
\\{xwem-help-map}")

(defvar xwem-user-macros-map (symbol-function (xwem-define-prefix-command 'xwem-user-macros-prefix t)) "\
Keymap of user defined keyboard macros (\\<xwem-global-map>\\[xwem-user-macros-prefix]) commands.

Bindings:
\\{xwem-user-macros-map}")

;;;***

;;;### (autoloads (xwem-keymacro-load-macros xwem-keymacro-save-macros xwem-keymacro-internal-play xwem-keymacro-execute-keys xwem-keymacro-init) "xwem-keymacro" "lisp/xwem-keymacro.el")

(defvar xwem-executing-kbd-macro nil "\
Non-nil when executing keyboard macro.
Actually Emacs keysequence(vector of keys) to be executed.
Internal variable, do not modify.")

(defvar xwem-executing-kbd-macro-index nil "\
Indexes current key in `xwem-excuting-kbd-macro' vector.
Internal variable, do not modify.")

(defvar xwem-keymacro-last-kbd-macro nil "\
Last KBD macro.")

(autoload 'xwem-keymacro-init "xwem-keymacro" "\
Initialize keyboard macrosing stuff." nil nil)

(autoload 'xwem-keymacro-execute-keys "xwem-keymacro" "\
Execute keyboard macro KEYS." nil nil)
(autoload 'xwem-keymacro-begin "xwem-keymacro")
(autoload 'xwem-keymacro-end "xwem-keymacro")

(autoload 'xwem-keymacro-internal-play "xwem-keymacro" "\
Play Emacs KEYS TIMES times." nil nil)
(autoload 'xwem-keymacro-undefined "xwem-keymacro")
(autoload 'xwem-keymacro-play-last "xwem-keymacro")
(autoload 'xwem-keymacro-recursive-edit "xwem-keymacro")
(autoload 'xwem-keymacro-exit-recursive-edit "xwem-keymacro")

(autoload 'xwem-keymacro-save-macros "xwem-keymacro" "\
Save all defined macros to FILE.
Default value for FILE is ~/.xwem/xwem-macros.el." nil nil)

(autoload 'xwem-keymacro-load-macros "xwem-keymacro" "\
Load macros saved with `xwem-key-save-macros' from FILE.
Default value for FILE is ~/.xwem/xwem-macros.el" nil nil)

;;;***

;;;### (autoloads (xwem-launch-button-start xwem-launch-generic-program xwem-execute-program xwem-launcher-query) "xwem-launcher" "lisp/xwem-launcher.el")

(defcustom xwem-launcher-function 'xwem-execute-program "Function to be used to execute external program." :type 'function :group 'xwem-launcher)

(autoload 'xwem-launcher-query "xwem-launcher" "\
Query for command to launch using PROMPT." nil nil)
(autoload 'xwem-run-program "xwem-launcher" "" t)

(autoload 'xwem-execute-program "xwem-launcher" "\
Execute COMMAND in buffer with BUFFER-NAME.
Unlike `background' do not use shell." nil nil)
(autoload 'xwem-launcher-turn-on-horizontal-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-vertical-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-toggle-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-normal-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-embedded-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-toggle-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launch-program "xwem-launcher" "" t)
(autoload 'xwem-launch-program-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-program-other-frame "xwem-launcher" "" t)

(defsubst xwem-launch (cmd) "Execute CMD using `xwem-launcher'." (funcall xwem-launcher-function cmd))

(autoload 'xwem-launch-generic-program "xwem-launcher" "\
Run generic program CMD with arguments SARG." nil nil)
(autoload 'xwem-launch-xterm "xwem-launcher" "" t)
(autoload 'xwem-launch-xterm-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-xterm-other-frame "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe-other-frame "xwem-launcher" "" t)
(autoload 'xwem-launch-xlock "xwem-launcher" "" t)

(autoload 'xwem-launch-button-start "xwem-launcher" "\
Create new dockapp button with XPM-FILE image and doing ACTION on click.
ACTION is cons cell wher car is one of 'elisp or 'cmd and cdr is string.
For 'elisp car, cdr is real elisp expression, to evaluate on click.
For 'cmd  car, cdr is cmd to run on click." nil nil)

;;;***

;;;### (autoloads (xwem-gc-function-choice xwem-cursor-shape-choice xwem-under-minib-focus define-xwem-command xwem-interactive xwem-help-display xwem-kbd-numlockmask xwem-kbd-supermask xwem-kbd-hypermask xwem-kbd-metamask xwem-kbd-controlmask xwem-kbd-lockmask xwem-kbd-shiftmask xwem-frame-linkage-map xwem-frame-link-head xwem-frame-link-remove xwem-frame-link-insert-before xwem-frame-link-insert-after xwem-frame-put-prop xwem-frame-get-prop xwem-win-expt-dec xwem-win-expt-inc xwem-win-set-expt xwem-win-get-expt xwem-win-mark-deleted xwem-win-child xwem-win-get-prop xwem-win-put-prop xwem-cl-win-geom xwem-tab-item-tabber xwem-cl-tabber xwem-cl-frame xwem-cl-selected xwem-xwin-cl xwem-xwin-frame xwem-rootgeom xwem-rootwin xwem-dpy xwem-dpy-dummy) "xwem-macros" "lisp/xwem-macros.el")

(autoload 'xwem-dpy-dummy "xwem-macros" nil nil 'macro)

(autoload 'xwem-dpy "xwem-macros" nil nil 'macro)

(autoload 'xwem-rootwin "xwem-macros" nil nil 'macro)

(autoload 'xwem-rootgeom "xwem-macros" nil nil 'macro)

(autoload 'xwem-xwin-frame "xwem-macros" "\
Return XWEM frame, which X window is XWIN." nil 'macro)

(autoload 'xwem-xwin-cl "xwem-macros" "\
Return CL, which X window is XWIN." nil 'macro)

(autoload 'xwem-cl-selected "xwem-macros" "\
Return selected client." nil 'macro)

(autoload 'xwem-cl-frame "xwem-macros" "\
Return frame where CL." nil 'macro)

(autoload 'xwem-cl-tabber "xwem-macros" "\
Return CL's tabber." nil 'macro)

(autoload 'xwem-tab-item-tabber "xwem-macros" nil nil 'macro)

(autoload 'xwem-cl-win-geom "xwem-macros" "\
Get geometry for client CL. Actually return xwem window geometry." nil 'macro)

(autoload 'xwem-win-put-prop "xwem-macros" "\
Set property PROP of WINDOW to VAL." nil 'macro)

(autoload 'xwem-win-get-prop "xwem-macros" "\
Get property PROP for WINDOW." nil 'macro)

(autoload 'xwem-win-child "xwem-macros" "\
Return child of WINDOW, hchild checked first then if not set vchild
  tested." nil 'macro)

(autoload 'xwem-win-mark-deleted "xwem-macros" "\
Mark WIN as deleted window." nil 'macro)

(autoload 'xwem-win-get-expt "xwem-macros" "\
Get value of EXPT from expectances plist of WIN.
Returns 0 if EXPT is not in plist." nil 'macro)

(autoload 'xwem-win-set-expt "xwem-macros" "\
Set EXPT with value EXPT-VALUE in expectations plist for WIN." nil 'macro)

(autoload 'xwem-win-expt-inc "xwem-macros" "\
Include by one EXPT in expectations plist for WIN.
If there no such EXPT, new one will be created with count equal to one." nil 'macro)

(autoload 'xwem-win-expt-dec "xwem-macros" "\
Decrement by one value of EXPT in expectations plist for WIN." nil 'macro)

(autoload 'xwem-frame-get-prop "xwem-macros" nil nil 'macro)

(autoload 'xwem-frame-put-prop "xwem-macros" "\
Put PROP with VAL to FRAME's properties list." nil 'macro)

(autoload 'xwem-frame-link-insert-after "xwem-macros" "\
Make FRAME2 to be after FRAME1." nil 'macro)

(autoload 'xwem-frame-link-insert-before "xwem-macros" "\
Make FRAME2 to be before FRAME1." nil 'macro)

(autoload 'xwem-frame-link-remove "xwem-macros" "\
Remove FRAME from linkage." nil 'macro)

(autoload 'xwem-frame-link-head "xwem-macros" "\
Returns head frame of FRAME's linkage." nil 'macro)

(autoload 'xwem-frame-linkage-map "xwem-macros" "\
Call FN for each frame in FRAME's linkage.
FN called with one argument - frame." nil 'macro)

(autoload 'xwem-kbd-shiftmask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-lockmask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-controlmask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-metamask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-hypermask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-supermask "xwem-macros" nil nil 'macro)

(autoload 'xwem-kbd-numlockmask "xwem-macros" nil nil 'macro)

(autoload 'xwem-help-display "xwem-macros" "\
Evaluate FORMS in special emacs frame and xwem help buffer." nil 'macro)

(autoload 'xwem-interactive "xwem-macros" "\
Just like `interactive', but accepts xwem specific arguments.
Code letters available are:
s -- String.
k -- Single key.
K -- Key sequence that executes command.
c -- Client.
f -- Existing file.
F -- Possible non-existing file.
p -- Prefix argument as number.
P -- Prefix argument in raw form.
C -- Command.
e -- External command." nil 'macro)

(autoload 'define-xwem-command "xwem-macros" "\
Same as `xwem-defun', but make FUNSYM to be interactive command.
INTER is actually a for of `xwem-interactive'." nil 'macro)

(autoload 'xwem-under-minib-focus "xwem-macros" "\
Evaluate FORM under XWEM's minibuffer focus." nil 'macro)

(autoload 'xwem-cursor-shape-choice "xwem-macros" "\
Return choice dialog to select cursor shape." nil 'macro)

(autoload 'xwem-gc-function-choice "xwem-macros" "\
Return choice dialog to select GC function." nil 'macro)

;;;***

;;;### (autoloads (xwem-fini xwem-init) "xwem-main" "lisp/xwem-main.el")

(defconst xwem-version "xwem(xemacs-package):  $Revision: 1.7 $")

(defcustom xwem-dir (file-name-as-directory (expand-file-name ".xwem" (getenv "HOME"))) "Directory to store XWEM's files." :type 'directory :group 'xwem)

(defcustom xwem-debug nil "*Non-nil mean run xlib and xwem in debugging mode." :type 'boolean :group 'xwem)

(defcustom xwem-commands-inhibit-gc t "*Non-nil mean that xwem interactive commands runs without GCing." :type 'boolean :group 'xwem)

(defcustom xwem-load-hook nil "*Hooks to call after xwem was load." :type 'hook :group 'xwem-hooks)

(defvar xwem-started nil "\
Non-nil when xwem started.
Do not modify!")

(autoload 'xwem-init "xwem-main" "\
Initialization of xwem subsystems." nil nil)

(autoload 'xwem-fini "xwem-main" "\
Fini all subsystems." nil nil)

;;;***

;;;### (autoloads (xwem-manda-init xwem-class-matcher define-xwem-manda xwem-manda-find-inst xwem-manda-refit xwem-manda-iconify xwem-manda-demanage xwem-manda-manage xwem-manda-fun-run) "xwem-manage" "lisp/xwem-manage.el")

(defstruct xwem-manda name matcher-function priority exclude-p init-fun manage-fun demanage-fun iconify-fun refit-fun)

(autoload 'xwem-manda-fun-run "xwem-manage" "\
Run function FUN for MANEL.
FUN is one of 'init, 'manage, 'demanage or 'refit
NOTE: A little bit hackish, do not do so at home." nil nil)

(autoload 'xwem-manda-manage "xwem-manage" "\
Manage CL using manage database." nil nil)

(autoload 'xwem-manda-demanage "xwem-manage" "\
Demanage CL using CL's manda entry." nil nil)

(autoload 'xwem-manda-iconify "xwem-manage" "\
Iconify CL using CL's manda entry." nil nil)

(autoload 'xwem-manda-refit "xwem-manage" "\
Refit CL using CL's manda entry." nil nil)

(autoload 'xwem-manda-find-inst "xwem-manage" "\
Find instance for CL in manage database.
NOTE: Find first match." nil nil)

(autoload 'define-xwem-manda "xwem-manage" "\
Define new entry in manage database." nil nil)

(autoload 'xwem-class-matcher "xwem-manage" "\
Define new WM_CLASS based CL matcher.

CLASS-NAME is regexp to match class-name, CLASS-INSTANCE is regexp to
match class instance, nil mean match any class instance WM-NAME is
regexp to match against WM_NAME, nil mean match any." nil 'macro)

(autoload 'xwem-manda-init "xwem-manage" "\
Initialize manage database." nil nil)

;;;***

;;;### (autoloads (xwem-minibuffer-init xwem-minib-iconify xwem-minib-demanage xwem-minib-manage xwem-minibuffer-on-deselect xwem-minibuffer-on-select xwem-minib-refit xwem-minib-create xwem-minib-xgeom) "xwem-minibuffer" "lisp/xwem-minibuffer.el")

(defstruct xwem-minib frame (evmask 0.0) cl plist)

(autoload 'xwem-minib-xgeom "xwem-minibuffer" "\
Get MINB xgeom." nil 'macro)

(defcustom xwem-minibuffer-name "xwem-minibuffer" "*Minibuffer name to be used by XWEM." :type 'string :group 'xwem-minibuffer)

(defcustom xwem-minibuffer-height 1 "Height of `xwem-minibuffer'." :type 'number :group 'xwem-minibuffer)

(defcustom xwem-minibuffer-width 80 "*Usable width of `xwem-minibuffer' frame." :type 'number :group 'xwem-minibuffer)

(defcustom xwem-minibuffer-border-width 3 "Border width for `xwem-minibuffer'." :type 'number :group 'xwem-minibuffer)

(defvar xwem-minibuffer nil "\
Internal variable, holds `xwem-minibuffer' structure.")

(autoload 'xwem-minib-create "xwem-minibuffer" "\
Create minibuffer that will be used by xwem, or use existen." nil nil)

(autoload 'xwem-minib-refit "xwem-minibuffer" "\
Refit xwem minibuffer.
CL is non-nil when `xwem-minib-refit' is called internally by xwem-minb-manage.
ARGS is additional arguments." nil nil)

(autoload 'xwem-minibuffer-on-select "xwem-minibuffer" "\
Function to be used in `select-frame-hook'." nil nil)

(autoload 'xwem-minibuffer-on-deselect "xwem-minibuffer" "\
Function to be used in `deselect-frame-hook'." nil nil)

(autoload 'xwem-minib-manage "xwem-minibuffer" "\
Manage XWEM's minibuffer client CL." nil nil)

(autoload 'xwem-minib-demanage "xwem-minibuffer" "\
Demage xwem minibuffer client CL.
ARGS is additional arguments." nil nil)

(autoload 'xwem-minib-iconify "xwem-minibuffer" "\
Iconify xwem minibuffer client CL.
ARGS is additional arguments." nil nil)

(defvar xwem-saved-menubar-visible-p nil "\
Saved value of `menubar-visible-p' specifier.")

(autoload 'xwem-minibuffer-init "xwem-minibuffer" "\
Initialize xwem minibuffer." nil nil)

;;;***

;;;### (autoloads (xwem-misc-outline xwem-misc-textsp-show xwem-misc-linesp-show xwem-misc-linesp-height xwem-misc-linesp-width xwem-misc-buffer->textsp xwem-misc-line->linesp xwem-exit-recursive-edit xwem-recursive-edit xwem-misc-profiling-results xwem-misc-start-profiling xwem-list-exchange-els xwem-list-to-string xwem-clear-message xwem-message xwem-str-with-faces xwem-init-misc xwem-misc-xerr-hook xwem-misc-xwin-valid-p xwem-misc-find-frame xwem-misc-draw-bar xwem-misc-draw-shadow xwem-init-cursors xwem-make-cursor) "xwem-misc" "lisp/xwem-misc.el")

(defvar xwem-cursor-fnt nil "\
Font for \"cursor\" series.")

(defvar xwem-cursor-default nil "\
Default cursor.")

(defvar xwem-cursor-left nil "\
Left cursor.")

(defvar xwem-cursor-right nil "\
Right cursor.")

(defvar xwem-cursor-wait nil "\
Cursor when we are wait.")

(defvar xwem-cursor-drag nil "\
Cursor when we drag.  Drug is a bad idea.")

(defvar xwem-cursor-move nil "\
Cursor when we move something.")

(defvar xwem-cursor-resize nil "\
Cursor when we resize.")

(defvar xwem-cursor-quote nil "\
Cursor when quoting key.")

(defvar xwem-cursor-help nil "\
Cursor when in help mode.")

(defsubst xwem-misc-colorspec->rgb-vector (colspec) "Conver color specification COLSPEC to internal representation.\nCOLSPEC maybe in form: #RRGGBB or name like 'green4'." (vconcat (color-instance-rgb-components (make-color-instance colspec))))

(defsubst xwem-misc-colorspec->rgb-vector-safe (colspec &optional defret) "Validate COLSPEC to be color specification in safe manner.\nReturn DEFRET or [0 0 0] if there was error." (condition-case nil (xwem-misc-colorspec->rgb-vector colspec) (t (or defret [0 0 0]))))

(defsubst xwem-misc-colorspec-valid-p (colspec) "Return non-nil if COLSPEC is valid color specification.\nValid colorspecification is spec in form: #RRGGBB or name like 'green4'." (condition-case nil (xwem-misc-colorspec->rgb-vector colspec) (t nil)))

(autoload 'xwem-make-cursor "xwem-misc" "\
Make new cursor of TYPE and store it in WHERE-STORE.
BGCOL maybe nil, that mean masking will not be done." nil nil)

(autoload 'xwem-init-cursors "xwem-misc" "\
Initialize cursors." nil nil)

(autoload 'xwem-misc-draw-shadow "xwem-misc" "\
Draw shadow." nil nil)

(autoload 'xwem-misc-draw-bar "xwem-misc" "\
Draw shadowed bar.
Bar filled with GC1.
Shadow thickness is TH and it is drawed with GC2 and GC3." nil nil)

(autoload 'xwem-misc-find-frame "xwem-misc" "\
Find Emacs frame by its NAME." nil nil)

(autoload 'xwem-misc-xwin-valid-p "xwem-misc" "\
Return non-nil if XWIN is valid X window.
Do it in safe manner." nil nil)

(autoload 'xwem-misc-xerr-hook "xwem-misc" "\
Display X errors in `xwem-minibuffer'.
Error hook must not performe any interaction with X server!
XDPY - X-Dpy.
XEV  - X-Event of error type." nil nil)

(autoload 'xwem-init-misc "xwem-misc" "\
Some misc initializetions." nil nil)

(autoload 'xwem-str-with-faces "xwem-misc" "\
Return STR with applied FACE-LIST." nil nil)

(autoload 'xwem-message "xwem-misc" "\
Display xwem message of TYPE using FMT format.
Type is:
'note -- For some xwem notes.
'warn -- For xwem warnings (beeps).
'warn-nobeep -- For xwem warnings (does not beeps).
'err  -- For xwem warnings (beeps).
'err-nobeep  -- For xwem warnings (does not beeps).
'todo -- Things that xwem should have.
'msg  -- Informatical message.
'prompt -- XWEM's input prompt.
'asis -- Such type is not passed through `format', ARGS should be nil,
         used to message colorized text.

ARGS are passed to `format' with FMT to generate final message." nil nil)

(autoload 'xwem-clear-message "xwem-misc" "\
Just as `clear-message'." nil nil)
(autoload 'xwem-show-message-log "xwem-misc")

(autoload 'xwem-list-to-string "xwem-misc" "\
Convert LIST of characterters to string with length LEN." nil nil)
(autoload 'xwem-ignore-command "xwem-misc")
(autoload 'xwem-eval-expression "xwem-misc")
(autoload 'xwem-execute-extended-command "xwem-misc")
(autoload 'xwem-shell-command "xwem-misc")
(autoload 'xwem-mini-calc "xwem-misc")
(autoload 'xwem-beginning-of-cl "xwem-misc")
(autoload 'xwem-end-of-cl "xwem-misc")
(autoload 'xwem-misc-make-screenshot "xwem-misc")
(autoload 'xwem-misc-pause "xwem-misc")

(autoload 'xwem-list-exchange-els "xwem-misc" "\
In LIST exchange places of EL1 and EL2." nil nil)

(autoload 'xwem-misc-start-profiling "xwem-misc" "\
Start profiling critical xlib/xwem functions." t nil)

(autoload 'xwem-misc-profiling-results "xwem-misc" "\
Show xlib/xwem profiling results." t nil)

(autoload 'xwem-recursive-edit "xwem-misc" "\
Enter recursive edit." nil nil)

(autoload 'xwem-exit-recursive-edit "xwem-misc" "\
Exit from recursive edit." nil nil)

(autoload 'xwem-misc-line->linesp "xwem-misc" "\
Convert current line in selected buffer to element of text spec - line spec.
DEFAULT-FACE is the default face." nil nil)

(autoload 'xwem-misc-buffer->textsp "xwem-misc" "\
Convert BUFFER to text specification.
DEFAULT-FACE is the default face.
If BUFFER is omitted, selected buffer assumed." nil nil)

(autoload 'xwem-misc-linesp-width "xwem-misc" "\
Return width of line spec LINESP." nil nil)

(autoload 'xwem-misc-linesp-height "xwem-misc" "\
Return height of line spec LINESP." nil nil)

(autoload 'xwem-misc-linesp-show "xwem-misc" "\
In x window XWIN at X and Y coordinates show line spec LINESP.
TYPE is one of XImageString or XDrawString, default is XImageString." nil nil)

(autoload 'xwem-misc-textsp-show "xwem-misc" "\
In x window XWIN at X and Y coordinates show text spec TEXTSP.
TYPE is one of XImageString or XDrawString, default is XImageString.
If TYPE is XDrawString and DEFAULT-BACKGROUND is specifed, characters
that have different than DEFAULT-BACKGROUND baground color are drawed
using XImageString." nil nil)

(autoload 'xwem-misc-outline "xwem-misc" "\
Outline XRECT using HOW method.
Valid HOW is 'normal, ..." nil nil)

;;;***

;;;### (autoloads (xwem-popup-menu xwem-gen-cl-menu xwem-mouse-ungrab xwem-mouse-grab) "xwem-mouse" "lisp/xwem-mouse.el")

(autoload 'xwem-mouse-grab "xwem-mouse" "\
Begin to grab mouse, showing CURSOR in WIN using event mask MASK.
Default WIN is root window.
Default MASK is capturing ButtonPress or ButtonRelease events." nil nil)

(autoload 'xwem-mouse-ungrab "xwem-mouse" "\
Stop grabing mouse." nil nil)
(autoload 'xwem-popup-clients-menu "xwem-mouse" nil t)

(autoload 'xwem-gen-cl-menu "xwem-mouse" "\
Generate menu for CL.
MAXNLEN - maximum menu width in characters." nil nil)

(autoload 'xwem-popup-menu "xwem-mouse" "\
Popup MENU.
MENU and EVENT is same as for `popup-menu'." nil nil)
(autoload 'xwem-popup-function-menu "xwem-mouse")
(autoload 'xwem-popup-auto-menu "xwem-mouse")

;;;***

;;;### (autoloads (xwem-osd-create-dock xwem-osd-create) "xwem-osd" "lisp/xwem-osd.el")

(autoload 'xwem-osd-create "xwem-osd" "\
On X display XDPY create new xwem osd context with +X+Y/WIDTHxHEIGHT geometry on X-PARENT." nil nil)

(autoload 'xwem-osd-create-dock "xwem-osd" "\
Create docked osd instance.
XDPY - Display.
X, Y, WIDTH, HEIGHT - OSD Geometry." nil nil)

;;;***

;;;### (autoloads (xwem-register-install-bindings) "xwem-register" "lisp/xwem-register.el")
(autoload 'xwem-register-client "xwem-register" "" t)
(autoload 'xwem-register-win-config "xwem-register" "" t)
(autoload 'xwem-register-frame-config "xwem-register" "" t)
(autoload 'xwem-register-jump "xwem-register" "" t)

(autoload 'xwem-register-install-bindings "xwem-register" "\
Install default register bindings in `xwem-global-map'." nil nil)

;;;***

;;;### (autoloads (xwem-root-events-handler xwem-root-refresh xwem-fini-root xwem-init-root) "xwem-root" "lisp/xwem-root.el")

(defconst xwem-root-ev-mask (Xmask-or XM-SubstructureNotify XM-SubstructureRedirect XM-KeyPress XM-ButtonPress XM-ButtonRelease XM-PropertyChange XM-FocusChange XM-EnterWindow XM-ResizeRedirect) "\
Event mask for X root window.")

(defvar xwem-root-screen nil "\
Description of root screen")

(autoload 'xwem-init-root "xwem-root" "\
Initialization part for root." nil nil)

(autoload 'xwem-fini-root "xwem-root" nil nil nil)

(autoload 'xwem-root-refresh "xwem-root" "\
Refresh area WIDTHxHEIGHT+X+Y." nil nil)

(autoload 'xwem-root-events-handler "xwem-root" "\
Events handler for root window." nil nil)

;;;***

;;;### (autoloads (xwem-rooter-add-client) "xwem-rooter" "lisp/xwem-rooter.el")

(autoload 'xwem-rooter-add-client "xwem-rooter" "\
Define client which class name matches CLASS-NAME regexp.
And class instance matches CLASS-INS regexp, and WM_NAME matches
WM-NAME as rooter client." nil 'macro)

;;;***

;;;### (autoloads (xwem-sound-load-default xwem-play-sound) "xwem-sound" "lisp/xwem-sound.el")

(defvar xwem-sound-alist nil "\
Sound alist for use by XWEM.
Format is identical as for `sound-alist'.
Error symbols are:
  default -- When nothing else matches.
  quit -- After \\<xwem-global-map>\\[xwem-kbd-quit]
  undefined-key -- Keybinding undefined.
  command-fail -- When execution of command failed.
  msg-warning -- Some one warnings you.
  msg-error -- Some one reports you an error.
  ready -- Time consumed task has been done.
  alarm -- Used by reminders.")

(autoload 'xwem-play-sound "xwem-sound" "\
Play a sound of provided SOUND type.
If VOLUME is specified, it overrides the value specified in
`xwem-sound-alist'." nil nil)

(autoload 'xwem-sound-load-default "xwem-sound" "\
Loads and install `xwem-sound-default-alist'.
If X-BEEP is non-nil, `xwem-sound-beeping-alist' will be loaded." nil nil)

;;;***

;;;### (autoloads (xwem-special-frame-init xwem-special-frame-iconify xwem-special-frame-demanage xwem-special-frame-manage xwem-special-popup-frame xwem-special-display-popup-frame) "xwem-special" "lisp/xwem-special.el")

(defcustom xwem-special-enabled t "*Non-nil mean make xwem to understand emacs special frames." :type 'boolean :group 'xwem-special)

(defcustom xwem-special-frame-name "xwem-special-frame" "*Name for special emacs frames" :type 'string :group 'xwem-special)

(autoload 'xwem-special-display-popup-frame "xwem-special" "\
Popup special frame with BUFFER." nil nil)

(autoload 'xwem-special-popup-frame "xwem-special" "\
As `special-display-popup-frame', but popup frame for sure.
When NONDEDICATED-P is non-nil then frame will not be dedicated." nil nil)

(autoload 'xwem-special-frame-manage "xwem-special" "\
Manage special xwem client CL." nil nil)

(autoload 'xwem-special-frame-demanage "xwem-special" "\
Demanage specal xwem client CL." nil nil)

(autoload 'xwem-special-frame-iconify "xwem-special" "\
Iconify handler for special frame." nil nil)

(autoload 'xwem-special-frame-init "xwem-special" "\
Initialize stuff to work with special emacs frames." nil nil)

;;;***

;;;### (autoloads (xwem-strokes-init) "xwem-strokes" "lisp/xwem-strokes.el")

(defcustom xwem-strokes-enabled t "*Non-nil mean xwem-stroke is enabled." :type 'boolean :group 'xwem-strokes)

(defvar xwem-strokes-keymap (let ((map (make-sparse-keymap))) (set-keymap-default-binding map 'xwem-strokes-nocmd) (define-key map xwem-quit-key 'xwem-keyboard-quit) (define-key map [button2] 'xwem-strokes-idescribe) (define-key map [button1] 'xwem-strokes-ibutton1) (define-key map [button1up] 'xwem-strokes-ibutton1up) (define-key map [(meta button1up)] 'xwem-strokes-ibutton1up) (define-key map [(control button1up)] 'xwem-strokes-ibutton1up) (define-key map [(meta control button1up)] 'xwem-strokes-ibutton1up) (define-key map [button3] 'xwem-strokes-ibutton3) map) "\
Keymap being used while in strokes event loop.")
(autoload 'xwem-strokes-define "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton1 "xwem-strokes" "" t)
(autoload 'xwem-strokes-idescribe "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton1up "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton3 "xwem-strokes" "" t)
(autoload 'xwem-strokes-nocmd "xwem-strokes" "" t)
(autoload 'xwem-strokes-begin "xwem-strokes" "" t)
(autoload 'xwem-strokes-cmplx-begin "xwem-strokes" "" t)
(autoload 'xwem-strokes-unset-last-stroke "xwem-strokes" "" t)
(autoload 'xwem-strokes-list "xwem-strokes" "" t)

(autoload 'xwem-strokes-init "xwem-strokes" "\
Initialize strokes support." nil nil)

;;;***

;;;### (autoloads (xwem-tab-item-draw-format xwem-tabber-draw xwem-tabber-regeom xwem-tabber-regeom-window xwem-tabber-create xwem-init-tabber) "xwem-tabbing" "lisp/xwem-tabbing.el")

(defcustom xwem-tab-default-format " %i %*%# %n" "*Default format for tab item." :type 'string :group 'xwem-tab)

(defstruct xwem-tab-item type state rect (delim-width 0) cl format)

(defstruct xwem-tabber frame xwin xpreparer xgeom state empty-tabi header-tabis tailer-tabis tab-items plist)

(autoload 'xwem-init-tabber "xwem-tabbing" "\
Initialize tabbing." nil nil)
(autoload 'xwem-tabber-switch-cl "xwem-tabber" "" t)
(autoload 'xwem-tabber-popup-cl-menu "xwem-tabber" "" t)

(autoload 'xwem-tabber-create "xwem-tabbing" "\
Create new tabber for FRAME with GEOM and INITIAL-STATE." nil nil)

(autoload 'xwem-tabber-regeom-window "xwem-tabbing" nil nil nil)

(autoload 'xwem-tabber-regeom "xwem-tabbing" "\
Adjust tabs geometries in TABBER." nil nil)

(defsubst xwem-tabber-safe-regeom (tabber &optional draw-p) "Saf variant of `xwem-tabber-regeom'." (and (xwem-tabber-p tabber) (xwem-tabber-regeom tabber nil draw-p)))

(autoload 'xwem-tabber-draw "xwem-tabbing" "\
Draw tabber." nil nil)

(autoload 'xwem-tab-item-draw-format "xwem-tabbing" nil nil nil)

(defsubst xwem-client-get-tab-item (cl) "Get tab item associated with CL." (xwem-cl-get-prop cl 'tab-item))

(defsubst xwem-client-set-tab-item (tabi cl) "Associate tab item TABI with client CL." (xwem-cl-put-prop cl 'tab-item tabi))

;;;***

;;;### (autoloads (xwem-time) "xwem-time" "lisp/xwem-time.el")

(autoload 'xwem-time "xwem-time" "\
Start xwem time window in system tray.
DPYNAME-OR-DPY specifies already opened X display or display name or
can be ommited." nil nil)

;;;***

;;;### (autoloads (xwem-tray-delimeter xwem-tray-fini xwem-tray-startit) "xwem-tray" "lisp/xwem-tray.el")

(defcustom xwem-tray-enabled t "*Non-nil mean that xwem's system tray will be used." :type 'boolean :group 'xwem-tray)

(autoload 'xwem-tray-startit "xwem-tray" "\
Start xwew tray on display DPY." nil nil)

(autoload 'xwem-tray-fini "xwem-tray" "\
Finialize xwem-tray." nil nil)

(autoload 'xwem-tray-delimeter "xwem-tray" "\
Add delimiter to dockapp.
W and H specifies delimiter width and height.
BGCOL - background color." nil nil)

;;;***

;;;### (autoloads (xwem-init-win xwem-win-make-cl-list-sort-by-recency xwem-win-make-cl-list xwem-window-shrink xwem-window-enlarge xwem-win-draw-delims xwem-win-split xwem-set-window-configuration xwem-window-configuration xwem-win-only-one-p xwem-win-map xwem-window-delete-others xwem-window-delete xwem-window-set-pixsize xwem-window-select-maybe-redraw xwem-window-select xwem-window-other xwem-window-prev xwem-window-next-vertical xwem-window-next xwem-win-new xwem-win-selected-p xwem-win-selected xwem-win-p xwem-win-cl-current-p) "xwem-win" "lisp/xwem-win.el")

(defcustom xwem-win-min-width 80 "*Minimal width for window" :type 'number :group 'xwem-win)

(defcustom xwem-win-min-height 80 "*Minimal height for window" :type 'number :group 'xwem-win)

(defcustom xwem-win-delim-width 3 "*Window delimeter width, including shadowness." :type 'number :group 'xwem-win)

(defcustom xwem-win-after-split-hook nil "Hook to be called after window split.\nFunctions will be called with three arguments: WIN HOW and NEW-SIZE." :type 'hook :group 'xwem-hooks)

(defstruct (xwem-win (:include X-Geom) (:predicate xwem-iswin-p)) clients props cl frame dead deleted next prev hchild vchild parent expectances)

(defstruct (xwem-win-saved (:include X-Geom) (:predicate xwem-iswinsaved-p)) clients cl props expectances currentp first-hchild first-vchild next prev)

(defstruct (xwem-win-config (:predicate xwem-iswinconfig-p)) frame frame-width frame-height current-cl min-width min-height saved-root-window)

(autoload 'xwem-win-cl-current-p "xwem-win" "\
Return non-nil if CL is current WIN's client." nil nil)

(autoload 'xwem-win-p "xwem-win" "\
Return t if WINDOW is XWEM frame's window." nil nil)

(autoload 'xwem-win-selected "xwem-win" "\
Return selected window in selected frame." nil nil)

(autoload 'xwem-win-selected-p "xwem-win" "\
Return non-nil if WIN is selected window." nil nil)

(autoload 'xwem-win-new "xwem-win" "\
Create new window with properties PROPS." nil nil)

(autoload 'xwem-window-next "xwem-win" "\
Return next window after WINDOW in canonical ordering of windows.
If omitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)

(autoload 'xwem-window-next-vertical "xwem-win" "\
Return next window which is vertically after WINDOW.
If WINDOW is not given `(xwem-win-selected)' will be used." nil nil)

(autoload 'xwem-window-prev "xwem-win" "\
Retrun previous window before WINDOW in canonical ordering of windows.
If ommitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)

(autoload 'xwem-window-other "xwem-win" "\
Return CNT's next window for WINDOW if CNT is greater then zero and
  previous if negative." nil nil)
(autoload 'xwem-winmove-up "xwem-win" "" t)
(autoload 'xwem-winmove-down "xwem-win" "" t)
(autoload 'xwem-winmove-left "xwem-win" "" t)
(autoload 'xwem-winmove-right "xwem-win" "" t)

(autoload 'xwem-window-select "xwem-win" "\
Select WINDOW as current for WINDOW's frame.
Runs `xwem-win-switch-hook'." nil nil)

(autoload 'xwem-window-select-maybe-redraw "xwem-win" "\
Select window WINDOW and if maybe redraw WINDOW's frame." nil nil)

(autoload 'xwem-window-set-pixsize "xwem-win" "\
Set pixsize for WINDOW." nil nil)

(autoload 'xwem-window-delete "xwem-win" "\
Delete WINDOW. Default is `(xwem-win-selected)'." nil nil)

(autoload 'xwem-window-delete-others "xwem-win" "\
Delete all xwem windows other then WINDOW." nil nil)

(autoload 'xwem-win-map "xwem-win" "\
Apply FN to FRAME-WIN and each subwindow.
FN will be called with a window as argument.
If ommitted, WINDOW defaults to the `(xwem-win-selected)'." nil nil)
(autoload 'xwem-balance-windows "xwem-win" "" t)

(autoload 'xwem-win-only-one-p "xwem-win" "\
Return non-nil if WINDOW is only one in chain.
If WINDOW ommitted `(xwem-win-selected)' used." nil nil)

(autoload 'xwem-window-configuration "xwem-win" "\
Return an object representing the current window configuration of xwem FRAME.
If FRAME is nil or ommited, use the sected frame." nil nil)

(autoload 'xwem-set-window-configuration "xwem-win" "\
Set window CONFIG." nil nil)
(autoload 'xwem-window-configuration-to-register "xwem-win" "" t)

(autoload 'xwem-win-split "xwem-win" "\
Split WINDOW.
When WINDOW is ommitted `(xwem-win-selected)' used.
HOW is 'vertical of 'horizontal, default is 'horizontal.
If NEW-SIZE is given make WINDOW NEW-SIZE pixels bigger after split." nil nil)

(autoload 'xwem-win-draw-delims "xwem-win" "\
Draw delimetrs in window WIN." nil nil)

(autoload 'xwem-window-enlarge "xwem-win" "\
Make WINDOW N pixels bigger.
If HEIGHT-P is non-nil then enlarge vertically.
If WINDOW is ommited then selected window will be used." nil nil)

(autoload 'xwem-window-shrink "xwem-win" "\
Make WINDON N pixels smaller.
If HEIGHT-P is non-nil then shrink vertically.
If WINDOW is ommited then selected window will be used." nil nil)

(autoload 'xwem-win-make-cl-list "xwem-win" "\
Makes list of CLs that belongs to WIN." nil nil)

(autoload 'xwem-win-make-cl-list-sort-by-recency "xwem-win" "\
Return list of clients managed in WIN, sorted by recency field." nil nil)

(autoload 'xwem-init-win "xwem-win" "\
Initialize xwem windows. Now just installs `xwem-win-switch-hook'" nil nil)

;;;***

;;;### (autoloads (xwem-worklog-start-dockapp) "xwem-worklog" "lisp/xwem-worklog.el")

(xwem-define-prefix-command 'xwem-worklog-prefix t)

(autoload 'xwem-worklog-start-dockapp "xwem-worklog" "\
Start dockapp." nil nil)

;;;***

(provide 'xwem-autoloads)
