#!/bin/ksh

PATH=${PATH}:/local/bin
export PATH

ARCHIVEDIR="/mounts/kaplan/xemacs"

generate_old_archive()
{
  mv archive archive-old
  touch archive
  chmod 660 archive
  chown xemacs archive
  chgrp xemacs archive
}

update_archive()
{
  cd ${ARCHIVEDIR}/$1
  echo $1
  ls -l
  echo "--------------------------------------------------------------------"
  
  if [ -f archive ] && [ ! -z archive ]; then
    generate_old_archive

    cd $2
    ls -l
    echo "--------------------------------------------------------------------"

    if [ -f ${3}.gz ]; then
      mv ${3}.gz ${3}-old.gz
      gunzip ${3}-old.gz
      cat ${3}-old ${ARCHIVEDIR}/${1}/archive-old > $3
      rm -f ${3}-old
    else
      cp ${ARCHIVEDIR}/${1}/archive-old $3
    fi

    gzip --best $3
    chmod $4 ${3}.gz
    chgrp $5 ${3}.gz

    ls -l
    echo "--------------------------------------------------------------------"

    cd ${ARCHIVEDIR}/$1
    rm -f archive-old
  fi

  ls -l
  echo "===================================================================="
}

#
# Handle xemacs@cs.uiuc.edu archive.
#
update_archive weekly-xemacs /csftp/mlists comp-emacs-xemacs 444 staff

#
# Handle info-bbdb@cs.uiuc.edu archive.
#
update_archive weekly-info-bbdb /usr/dcs/server/ftp/pub/bbdb info-bbdb 444 staff

#
# Handle xemacs-beta@cs.uiuc.edu archive.
#
update_archive weekly-xemacs-beta /ftp/ftp-root/pub/beta/mlists xemacs-beta 440 xemacs

#
# Handle xemacs-beta-discuss@cs.uiuc.edu archive.
#
update_archive weekly-xemacs-beta-discuss /ftp/ftp-root/pub/beta/mlists xemacs-beta-discuss 440 xemacs

#
# Handle xemacs-beta-patches@cs.uiuc.edu archive.
#

cd ${ARCHIVEDIR}/weekly-xemacs-beta-patches

echo weekly-xemacs-beta-patches
echo "--------------------------------------------------------------------"
ls -l

if [ -f archive ] && [ ! -z archive ]; then
  if [ -f archive-1.gz ]; then
    mv -f archive-1.gz archive-2.gz
  fi

  if [ -f archive-0.gz ]; then
    mv -f archive-0.gz archive-1.gz
  fi

  generate_old_archive
  mv archive-old archive-0
  gzip --best archive-0
  chmod 440 archive-0.gz
fi

ls -l
echo "===================================================================="
