/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.ApplicationCommands;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.Rep;

public class ThreadCommands
extends ApplicationCommands {
    public void doSuspend(Integer cmd_id, List args) throws JDEException {
        if (args.size() > 0) {
            Iterator it = args.iterator();
            while (it.hasNext()) {
                Long uniqueID = Etc.safeGetLong(it.next(), "thread(group)");
                ObjectReference oRef = this.store.get(uniqueID);
                if (oRef == null) {
                    throw new JDEException("Invalid ThreadID, or the thread/threadgroup is dead");
                }
                if (oRef instanceof ThreadReference) {
                    ((ThreadReference)oRef).suspend();
                    continue;
                }
                if (oRef instanceof ThreadGroupReference) {
                    ((ThreadGroupReference)oRef).suspend();
                    continue;
                }
                throw new JDEException("The object is not a thread or a threadgroup");
            }
            this.app.signalCommandResult(cmd_id);
        } else {
            try {
                this.app.getVM().suspend();
                this.app.signalCommandResult(cmd_id);
            }
            catch (Exception ex) {
                throw new JDEException("Unable to suspend the application");
            }
        }
    }

    public void doResume(Integer cmd_id, List args) throws JDEException {
        if (args.size() > 0) {
            Iterator it = args.iterator();
            while (it.hasNext()) {
                Long uniqueID = Etc.safeGetLong(it.next(), "thread(group)");
                ObjectReference oRef = this.store.get(uniqueID);
                if (oRef == null) {
                    throw new JDEException("Invalid ThreadID, or the thread/threadgroup is dead");
                }
                if (oRef instanceof ThreadReference) {
                    ((ThreadReference)oRef).resume();
                    continue;
                }
                if (oRef instanceof ThreadGroupReference) {
                    ((ThreadGroupReference)oRef).resume();
                    continue;
                }
                throw new JDEException("The object is not a thread or a threadgroup");
            }
            this.app.signalCommandResult(cmd_id);
        } else {
            try {
                this.app.getVM().resume();
                this.app.signalCommandResult(cmd_id);
            }
            catch (Exception ex) {
                throw new JDEException("Unable to resume the application");
            }
        }
    }

    public void doInterrupt(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Long uniqueID = Etc.safeGetLong(it.next(), "thread ID");
            ObjectReference oRef = this.store.get(uniqueID);
            if (oRef == null) {
                throw new JDEException("Invalid ThreadID, or the thread is dead");
            }
            if (oRef instanceof ThreadReference) {
                ((ThreadReference)oRef).interrupt();
                continue;
            }
            throw new JDEException("The object is not a thread");
        }
        this.app.signalCommandResult(cmd_id);
    }

    public void doKillThread(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(args.remove(0), "thread ID");
        ObjectReference oRef = this.store.get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(oRef instanceof ThreadReference)) {
            throw new JDEException("The ID doesn't correspond to a thread");
        }
        ThreadReference tRef = (ThreadReference)oRef;
        uniqueID = Etc.safeGetLong(args.remove(0), "thread ID");
        oRef = this.store.get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such thread exists");
        }
        try {
            tRef.stop(oRef);
        }
        catch (InvalidTypeException ex) {
            throw new JDEException("Object ID doesn't correspond to a Throwable object");
        }
        this.app.signalCommandResult(cmd_id);
    }

    public void doGetThreads(Integer cmd_id, List args) throws JDEException {
        this.app.signalCommandResult(cmd_id, ThreadCommands.getAllThreadsInformation(this.app.getVM(), this.store));
    }

    static LispForm getAllThreadsInformation(VirtualMachine vm, ObjectStore store) {
        List<ThreadGroupReference> l = vm.topLevelThreadGroups();
        String info = "(list ";
        Iterator<ThreadGroupReference> it = l.iterator();
        while (it.hasNext()) {
            info = info + Protocol.BR + Rep.getThreadGroupRep(it.next(), store);
        }
        info = info + ")";
        return new LispForm(info);
    }

    static ThreadReference getThread(VirtualMachine vm, String name) {
        List<ThreadReference> list = vm.allThreads();
        Iterator<ThreadReference> it = list.iterator();
        while (it.hasNext()) {
            ThreadReference thread = it.next();
            if (!thread.name().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public void doGetThread(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(args.remove(0), "thread ID");
        ObjectReference tRef = this.store.get(uniqueID);
        if (tRef == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(tRef instanceof ThreadReference)) {
            throw new JDEException("No such thread exists (anymore?)");
        }
        this.app.signalCommandResult(cmd_id, Rep.getThreadRep((ThreadReference)tRef, this.store, true));
    }

    public void doGetObjectMonitors(Integer cmd_id, List args) throws JDEException {
        if (args.size() != 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(args.remove(0), "object ID");
        ObjectReference oRef = this.store.get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        this.app.signalCommandResult(cmd_id, Rep.getObjectMonitorsRep(oRef, this.store));
    }

    public void doTraceThreads(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String type = args.remove(0).toString().toLowerCase();
        if (!type.equals("start") && !type.equals("death")) {
            throw new JDEException("Invalid type");
        }
        List classFilters = Etc.getClassFiltersFromArgs(args);
        List classExFilters = Etc.getClassExFiltersFromArgs(args);
        EventRequestManager em = this.app.getVM().eventRequestManager();
        Long requestID = null;
        if (type.equals("start")) {
            ThreadStartRequest ter = em.createThreadStartRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (args.size() > 0) {
                Long threadID = Etc.safeGetLong(args.remove(0), "thread ID");
                ObjectReference tRef = this.store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.addIdentifiableRequest(ter);
        } else if (type.equals("death")) {
            ThreadDeathRequest ter = em.createThreadDeathRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
            if (args.size() > 0) {
                Long threadID = Etc.safeGetLong(args.remove(0), "thread ID");
                ObjectReference tRef = this.store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.addIdentifiableRequest(ter);
        }
        this.app.signalCommandResult(cmd_id, requestID);
    }

    public void doCancelTraceThreads(Integer cmd_id, List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        this.deleteIdentifiableRequest(Etc.safeGetLong(args.remove(0), "request ID"));
        this.app.signalCommandResult(cmd_id);
    }

    public ThreadCommands(Application a, ObjectStore s) {
        super(a, s);
    }
}

