/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class MethodOverrideFactory
extends MethodFactory {
    static MethodOverrideFactory overrideFactory;
    Vector candidates = new Vector();
    String baseClassName;
    String methodName;

    public MethodOverrideFactory() {
    }

    public MethodOverrideFactory(NameFactory factory) {
        super(factory);
    }

    public Vector getMethods(Class cl, String methodName) {
        Method[] methods = cl.getDeclaredMethods();
        Vector<Method> m = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(methodName)) {
                m.addElement(methods[i]);
            }
            ++i;
        }
        return m;
    }

    public static void getCandidateSignatures(String baseClassName, String methodName) {
        if (overrideFactory == null) {
            overrideFactory = new MethodOverrideFactory();
        } else {
            overrideFactory.flush();
        }
        MethodOverrideFactory.overrideFactory.baseClassName = baseClassName;
        MethodOverrideFactory.overrideFactory.methodName = methodName;
        try {
            int i;
            Class<?> baseClass = Class.forName(baseClassName);
            while (baseClass != null) {
                Vector methods = overrideFactory.getMethods(baseClass, methodName);
                int n = methods.size();
                if (n > 0) {
                    i = 0;
                    while (i < n) {
                        Method m = (Method)methods.elementAt(i);
                        Signature s = new Signature(m, overrideFactory);
                        boolean containsSignature = false;
                        int j = 0;
                        while (j < MethodOverrideFactory.overrideFactory.candidates.size()) {
                            if (s.equals(MethodOverrideFactory.overrideFactory.candidates.elementAt(j))) {
                                containsSignature = true;
                                break;
                            }
                            ++j;
                        }
                        if (!containsSignature) {
                            MethodOverrideFactory.overrideFactory.candidates.addElement(s);
                        }
                        ++i;
                    }
                }
                baseClass = baseClass.getSuperclass();
            }
            int n = MethodOverrideFactory.overrideFactory.candidates.size();
            if (n > 0) {
                String res = "(list ";
                i = 0;
                while (i < n) {
                    Signature s = (Signature)MethodOverrideFactory.overrideFactory.candidates.elementAt(i);
                    String p = s.getParameters(s.getMethod().getParameterTypes());
                    res = res + "\"" + methodName + "(" + p + ")\" ";
                    ++i;
                }
                res = res + ")";
                MethodFactory.println(res);
            } else {
                MethodFactory.println("(error \"Could not find any method named " + methodName + " in " + baseClassName + " or any of its superclasses.\")");
            }
        }
        catch (ClassNotFoundException ee) {
            MethodFactory.println("(error \"Could not find class " + baseClassName + "\")");
        }
    }

    public static void getMethodSkeleton(int variant, boolean nl_brace) {
        Signature s = (Signature)MethodOverrideFactory.overrideFactory.candidates.elementAt(variant);
        String todo = "  //TO DO: Implement this method.\n";
        String skel = overrideFactory.getMethodSkeleton(s, true, nl_brace, todo);
        MethodFactory.println("\"" + skel + "\"");
        MethodOverrideFactory.overrideFactory.imports.clear();
        Method m = s.getMethod();
        Class<?>[] types = m.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            overrideFactory.registerImport(types[i]);
            ++i;
        }
        types = m.getExceptionTypes();
        int i2 = 0;
        while (i2 < types.length) {
            overrideFactory.registerImport(types[i2]);
            ++i2;
        }
        overrideFactory.registerImport(m.getReturnType());
    }

    public static void getImportedClasses() {
        String res = "(list ";
        Enumeration i = MethodOverrideFactory.overrideFactory.imports.keys();
        while (i.hasMoreElements()) {
            Class c = (Class)i.nextElement();
            res = res + "\"" + c.getName() + "\" ";
        }
        res = res + ")";
        MethodFactory.println(res);
    }

    public void flush() {
        super.flush();
        this.candidates.removeAllElements();
    }

    public static void main(String[] args) {
        MethodOverrideFactory.getCandidateSignatures("jde.ui.design.command.Command", "getName");
    }
}

