;;!emacs
;;
;; FILE:         hsite.el
;; SUMMARY:      Site-specific setup for Hyperbole
;; USAGE:        GNU Emacs Lisp Library
;; KEYWORDS:     hypermedia, local
;;
;; AUTHOR:       Bob Weiner
;; ORG:          BeOpen.com
;;
;; ORIG-DATE:    15-Apr-91 at 00:48:49
;; LAST-MOD:     13-Jun-99 at 01:18:45 by Bob Weiner
;;
;; Copyright (C) 1991-1997, BeOpen.com and the Free Software Foundation, Inc.
;; See the "HY-COPY" file for license information.
;;
;; This file is part of Hyperbole.
;;
;; DESCRIPTION:  
;;
;;   See the "HY-README" file for installation instructions.
;;
;;   "hsite.el" may be byte-compiled if you like but normally it is not.
;;
;;   Be sure to have users load any personal mail/news initializations
;;   before they load this file if any of Hyperbole's mail or news
;;   support features are enabled either herein or within their personal
;;   Hyperbole initializations.  Otherwise, the mail/news support may
;;   not be configured properly.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Read the comments and modify as desired.
;;; ************************************************************************

(message "Initializing Hyperbole, please wait...")

;;; ************************************************************************
;;; HYPERBOLE DIRECTORY SETTING
;;; ************************************************************************

;; The following line must not be deleted.
(require 'hyperbole)

;;; ************************************************************************
;;; TIMEZONE SETTING
;;; ************************************************************************

;; The following section applies only to MS-DOS and MS-Windows OSs.
;; For such OSs, you must configure this section or you will receive
;; an error when starting Hyperbole.  Users of other OSs may simply
;; ignore this section.


;; Microcruft OSs don't provide an automatically set timezone environment
;; variable.  Nor do they include a UNIX-style date program.  So follow
;; the commented instructions in the code below here.

;; If you happened to have installed a UNIX-style date program (when you type
;; `date' at a shell, it simply spits out the date and time and then quits),
;; you may comment out the logic.
;;
(if (and hyperb:microcruft-os-p
	 (not (or (getenv "TZ") (getenv "TIMEZONE"))))
    (progn
      ;; Comment out the following `error' line...
      (error "(hsite.el): Configure the TIMEZONE SETTING section in this file.")
      ;; ... and uncomment the following line, substituting an appropriate
      ;;     timezone from the list in the variable, `htz:world-timezones'
      ;;     in the file, "htz.el".
      ;;   (setenv "TZ" "your-3char-timezone")
      ))

;;; ************************************************************************
;;; SMART SETTINGS
;;; ************************************************************************

(defvar hkey-always-display-menu nil
  "*Non-nil means always display the Smart Menu window when the Action or Assist Key is pressed and the Smart Menu system has been loaded.
If a Smart Menu is already displayed, perform another Action or Assist Key
function.")

;(defvar smart-scroll-proportional t
;  "*Non-nil means Smart Keys should scroll relative to current line when pressed at the end of a line.
;Action Key moves current line to top of window.  Assist Key moves current
;line to bottom of window.  Repeated presses then scroll up or down a
;windowful.  Nil value instead ignores current line and always scrolls up or
;down a windowful.")

(defcustom smart-scroll-proportional t
  "*Non-nil means Smart Keys should scroll relative to current line when pressed at the end of a line.
Action Key moves current line to top of window.  Assist Key moves current
line to bottom of window.  Repeated presses then scroll up or down a
windowful.  Nil value instead ignores current line and always scrolls up or
down a windowful."
  :group 'hyperbole
  :type 'boolean
  :link '(custom-manual "(hyperbole)Glossary"))

;;; ************************************************************************
;;; INTERNET SETTINGS
;;; ************************************************************************

;; String to be used in the call: (hpath:rfc rfc-num) to create a remote
;; path to the RFC document for `rfc-num'.  Uncomment and alter this setting
;; if another site is closer for you.
;; (setq hpath:rfc "/anonymous@ftp.faqs.org:rfc/rfc%s.txt")

;; When a user creates an explicit button, Hyperbole tries to store her
;; Internet e-mail address with the button by using the formula, email-id =
;; <user-id>@<domainname>.  Not every system has its domainname set
;; up properly, however.  If you do a {M-x load-file hypb.elc RET} and then
;; hit {C-x C-e} after the closing paren of the following function,
;; (hypb:domain-name), you will see whether or not yours is configured
;; properly.  If it is not, uncomment the following line and set it to the
;; proper value.

;; (setenv "DOMAINNAME" "yourdomain.com")

;;; ************************************************************************
;;; XEMACS AND GNU EMACS 19 CONFIGURATION
;;; ************************************************************************

;; No-op unless set by one of the conditionals below.
(defun hui:but-flash ())

(if (and hyperb:emacs19-p window-system)
    (progn
      (require 'hui-em19-b)
      ;; Highlight explicit buttons whenever a file is read in.
      (var:append 'find-file-hooks '(hproperty:but-create))
      (defalias 'hui:but-flash 'hproperty:but-flash)
      ;;
      ;; Substitute for the nil argument below a valid X color name with
      ;; which to highlight buttons if the default highlighting does not
      ;; appeal to you. See "hui-em19-b.el" for how this works.
      (hproperty:cycle-but-color nil)
      ;;
      ;; Non-nil means visually emphasize that button under mouse cursor is
      ;; selectable.
      (setq hproperty:but-emphasize-p nil)
      ;;
      ;; If you find that the Hyperbole button flash time is too slow
      ;; or too fast, adjust it here.
      (setq hproperty:but-flash-time 1000)
      ))

(if (and hyperb:xemacs-p (not noninteractive))
    (progn
      (require 'hui-xe-but)
      ;;
      ;; If running XEmacs 19.8 or below, don't highlight explicit buttons
      ;; whenever a file is read in since this can cause a sporadic crash
      ;; when find-files are done.
      (if hyperb:kotl-p (var:append 'find-file-hooks '(hproperty:but-create)))
      (defalias 'hui:but-flash 'hproperty:but-flash)
      ;;
      ;; Substitute for the nil argument below a valid X color name with
      ;; which to highlight buttons if the default highlighting does not
      ;; appeal to you. See "hui-xe-but.el" for how this works.
      (hproperty:cycle-but-color nil)
      ;;
      ;; Non-nil means visually emphasize that button under mouse cursor is
      ;; selectable.
      (setq hproperty:but-emphasize-p nil)
      ;;
      ;; If you find that the Hyperbole button flash time is too slow
      ;; or too fast, adjust it here.
      (setq hproperty:but-flash-time 1000)
      ))

;;; ************************************************************************
;;; EXTERNAL SYSTEM ENCAPSULATIONS
;;; ************************************************************************

;;; Support for encapsulations of any of these external systems may be
;;; enabled here.  You should be familiar with the external system before
;;; you try to use the Hyperbole support for it.
;;; Possible system encapsulations to include within the innermost set of
;;; parentheses are:
;;;   hsys-wais
;;; See files with the same name, e.g. "hsys-wais.el" for details on each
;;; system.
;;;
;;; Note: hsys-w3 is automatically loaded by default by Hyperbole.
(setq hibtypes:begin-load-hook
      (list (function (lambda () (mapcar 'require '())))))

;;; ************************************************************************
;;; ONLINE LIBRARY CONFIGURATION
;;; ************************************************************************

;;; Support for online library document id references is loaded here but
;;; requires some additional configuration before use.  See the DESCRIPTION
;;; section in "hib-doc-id.el" for complete installation and use information.
;;;
(setq hibtypes:end-load-hook
      (list (function (lambda () (mapcar 'require '(hib-doc-id))))))

;;; ************************************************************************
;;; HYPERBOLE INITIALIZATION
;;; ************************************************************************

;;; This call loads the whole Hyperbole system.
;;; You may want to look at this file just to see what it does.
;;;
(require 'hinit)
;;;
;;; This call initializes the Hyperbole system for use.
;;;
(hyperb:init)

;;; ************************************************************************
;;; HYPERBOLE LOCAL VARIABLE SUPPORT
;;; ************************************************************************

;;; Uncomment this if you really need to be able to use Hyperbole variables
;;; (and others with colons in their names) within file local variable lists.
;;; See the source file for more details.
;;;
;;  (require 'hlvar)

;;; ************************************************************************
;;; SITE-SPECIFIC ADDITIONS - Add your Hyperbole configuration additions here.
;;; ************************************************************************

;;; ************************************************************************
;;; END OF HYPERBOLE CONFIGURATION
;;; ************************************************************************

(provide 'hsite)

(message "Hyperbole is ready for action.")
