/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* Library routines for doing command line argument parsing */
/* $Source: /import/kaplan/kaplan/carroll/cb/ws/RCS/getopt.c,v $ */

static char rcsid[] = "getopt.c $Revision: 2.1 $ $Date: 91/07/03 10:07:26 $ $State: Beta $ $Author: carroll $";

/* ------------------------------------------------------------------------- */
/* AT&T System V getopt library call. Reverse engineered by amc. */
/* This version written without any knowledge of AT&T source code.
 * For that reason, there may be incompatibilities with the standard
 * version.
 */

/*  Calling sequence -
    int getopt(int argc, char **argv, char *optlist)
	argc	: first argument passed to main()
	argv	: second argument passed to main()
	optlist	: string consisting of option characters, optionally followed
	          by colons ':', which indicate that the option has a value
		  following it.
	RETURNS : the character of the option if one was matched
		  opt_err_char if a bad option was specified
		  EOF if no more options are found.

	special case -
	  A doubled option char (default, "--") can be used by the end-user
	  to indicate "end of options", if one of the arguments starts with
	  the option char. If found, =optind= will be left at the option past
	  the double char.

	  A single option char without a non-white space character immediately
	  after it will return as a bad option. =optind= should be used to
	  find the option that the error was in, since it will have the index
	  of the option that was in error.

	extension -
	  the character ';' can be used to indicate an option that can take a
	  value, but doesn't have to. If no value is present, -optarg- will be
	  set to NULL. To deal with this, the convention is that if a possibly
	  valued option (PVO) appears, if the value is attached, it is
	  returned.  If not, then the next arg is checked, and if it does
	  *not* start with the opt char, then it is the value for the option,
	  otherwise the option has no value.
*/

/*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#include "config.h"
#include <stdio.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
/*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* nice defines */

#define	TRUE	1
#define FALSE	0

#define	loop	while
/* for do/while, to aviod confusion */

/*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
char	*optarg = NULL;		/* target of a valued option */
int    	 optind = 0;		/* index of current option */

/* various special control variables */

char	opt_char = '-';		/* character that marks an option */
char	opt_err_val = '?';	/* character returned on option error */
char	opt_err_char = '\0';	/* character that was in error */

/* internal state variables */

static char cur_op[1025];	/* working copy of current option */
static char F_cur_op = FALSE;	/* does cur_op contain a working copy? */
static int wlength=0;	/* length of working copy */
static int wi=0;	/* working index */

/*  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/* int getopt(int argc,char **argv,char *optlist) */
int getopt(argc,argv,optlist)
  int argc;
  char **argv;
  char *optlist;
    {
    int i;		/* index */
    int optlength;	/* length of optlist */
    int cop;		/* current option */
    int cc;		/* current char in option list */
    
    /* first thing, find an option */
    
    while (! F_cur_op)
	  {
	  
	  optind += 1;
	  
	  if (optind >= argc) return EOF;	/* no more options */
	  
	  /* to grab all the options, this should -continue- instead
	   * of -return- */
	  if (argv[optind][0] != opt_char) return EOF;
	  
	  /* this should probably be strncpy */
	  strcpy(cur_op,argv[optind]+1);
	  
	  /* check for double opt_char as end of options marker */
	  if (cur_op[0] == opt_char)
		{
		optind += 1;	/* skip the marker */
		return EOF;
		}
	  
	  wlength = strlen(cur_op);
	  opt_err_char = '\0';
	  if (wlength == 0) return opt_err_val;	/* check for empty option */
	  wi = 0;
	  F_cur_op = TRUE;
	  }
    
    /* we have a working copy of the current option */
    
    /* get the current option letter */
    cop = cur_op[wi++];
    /* mark if finished with working copy */
    if (wi >= wlength) F_cur_op = FALSE;
    
    /* look through optlist for the option character */
    for ( i=0,optlength=strlen(optlist)
	 ; optlist[i] != cop	
	 ; cc = optlist[++i] , i += (cc == ';' || cc == ':') /* skip : and ; */
	 )
      if (i >= optlength)	/* didn't find it */
	    {
	    opt_err_char = cop;
	    return opt_err_val;
	    }
    
    cc = optlist[i+1];		/* get next char to check for values */
    if (cc == ':' || cc == ';')
	  {
	  /* it's a valued option, find the target */
	  if (F_cur_op) optarg = argv[optind]+wi+1;	/* it's attached */
	  else	/* it's the next argument */
		{
		if (optind < argc-1)	/* there's another arg */
		      {
		      if ( cc == ':' || argv[optind+1][0] != opt_char )
			optarg = argv[++optind];
		      else optarg = NULL;
		      }
		else optarg = "";	/* there is no next argument */
		}
	  F_cur_op = FALSE;	/* in any case, this option is consumed */
	  }
    else optarg = NULL;
    
    return cop;
    }
