/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server box code */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node107.text,v $ */

static char rcsid[] = "box.c $Revision: 1.1.1.1 $ $Date: 92/05/28 09:22:04 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <X11/Composite.h>
#include <Xm/PanedW.h>
#include <Xm/Separator.h>
/* ------------------------------------------------------------------------ */
typedef struct box_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget field_widget;
  Widget base_widget;

  char *header;			/* Header address to send box to */
  char *tag;			/* Tag for sending the box */
  short wrap;			/* Wrap the bus message in parens ? */
  short editable;		/* The editable state of the box */
  short transmit;		/* Separately transmit the box? */
  t_sexp args;			/* Arguments that we want sent */

  t_generic_widget items;
  t_generic_widget fields;
} * t_box_widget;

/* ------------------------------------------------------------------------ */
extern void
  BoxRemove(), BoxUpdate(), BoxChildDestroyed(),
  BoxRealized(), BoxTransmit(), BoxEditable(), BoxReply();

extern t_generic_widget BoxHandle();

struct widget_class_struct BoxClassRecord =
{
  WS_BOX, "box",
  BoxHandle, BoxRemove, BoxChildDestroyed, BoxUpdate,
  BoxReply, BoxRealized, BoxTransmit, BoxEditable,
} ;

extern struct widget_class_struct FieldClassRecord;
/* ------------------------------------------------------------------------ */
/* This function is used to position any menu bar first in the box,
 * regardless of where in the children it appears. Mainly, this prevents
 * the field container from ending up in front of the menu bar.
 * Anything that is not a menu bar is put last.
 */

/* This gets set to hold the default paned window ordering function */
Cardinal (*pane_order)();

Cardinal
BoxOrderFunc(w) Widget w;
{
  t_generic_widget item = NULL;
  Arg argl[1];

  /* get the user data, which should be a widget structure pointer */
  XtSetArg(argl[0], XmNuserData, &item);
  XtGetValues(w, argl, XtNumber(argl));

  return (NULL != item && WS_MENU_BAR == item->type) ? 0 : pane_order(w);
}
/* ------------------------------------------------------------------------ */
void
BoxPaneFreeze(item) t_generic_widget item;
{
  short height;
  Arg argl[3];

  XtSetArg(argl[0], XmNheight, &height);
  XtGetValues(item->widget, argl, 1);
  XtSetArg(argl[0], XmNpaneMinimum, height);
  XtSetArg(argl[1], XmNpaneMaximum, height);
  XtSetArg(argl[2], XmNskipAdjust, True);
  XtSetValues(item->widget, argl, XtNumber(argl));
}
/* ------------------------------------------------------------------------ */
/* need to provide special handling for fields */

void
BoxHandleItems(box,sexp,do_it_now)
     t_box_widget box;
     t_sexp sexp;
  int do_it_now;
{
  t_sexp item, tag;
  t_generic_widget current;
  Arg argl[1];

  for ( ; MB_CONSP(sexp) ; sexp = MB_CDR(sexp) )
    {
      item = MB_CAR(sexp);
      tag = MB_CAR(item);

      if (!MBcompare_Cstring(tag, FieldClassRecord.tag))
	{
	  box->widget = box->field_widget;
	  if (NULL != (current = HandleBusItem(box, item)))
	    {
	      current->next = box->fields;
	      box->fields = current;
	      XtSetArg(argl[0], XmNallowResize, True);
	      XtSetValues(current->widget, argl, 1);
	      if (do_it_now)
	      {
		XtRealizeWidget(current->widget);
		current->class->realized(current); /* do final adjustments */
		/* Set the initial editable state */
		current->class->editable(current, box->editable);
		XtManageChild(current->widget);
	      }
	    }
	}
      else				/* not special, normal child */
	{
	  box->widget = box->base_widget;
	  if (NULL != (current = HandleBusItem(box, item)))
	    {
	      current->next = box->items;
	      box->items = current;
	      XtSetArg(argl[0], XmNallowResize, True);
	      XtSetValues(current->widget, argl, 1);
	      if (do_it_now)
	      {
		XtRealizeWidget(current->widget);
		current->class->realized(current); /* do final adjustments */
		/* Set the initial editable state */
		current->class->editable(current, box->editable);
		XtManageChild(current->widget);
	      }
	    }
	}
    }
}
/* ------------------------------------------------------------------------ */
static int
BoxCalcFieldColumns(box) t_box_widget box;
{
  int n;
  
  n = CountWidgetList(box->fields);
  return CalcColumns(n);
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct bkw[] =
{
  { ":columns", (void*)-1, KEYWORD_INT },
  { ":header", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_RAW },
  { ":wrap", (void *)KEYWORD_TRUE, KEYWORD_FLAG },
  { ":editable", (void *)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":values", NULL, KEYWORD_SEXP },
  { ":args", NULL, KEYWORD_GET_SEXP },
  { ":transmit", (void *)KEYWORD_NONE, KEYWORD_FLAG },
} ;

t_generic_widget
BoxHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_keyword_flag f_edit, f_transmit;
  t_box_widget box;
  int columns;
  int n;
  Arg argl[8];

  if (NULL == parent || NULL == sexp) return NULL;

  box = NEW_STRUCT(box_widget_struct);
  box->type = WS_BOX;
  box->class = &BoxClassRecord;
  box->fields = NULL;
  box->field_widget = NULL;
  box->items = NULL;
  box->parent = parent;
  box->top = parent->top;
  box->id = Getnth(sexp,1);

  MBparse_keywords(MBnthcdr(sexp, 3), bkw, ARRAY_SIZE(bkw));
  columns = (int)bkw[0].result;
  box->header = (char*)bkw[1].result;
  box->tag = (char *)bkw[2].result;
  box->wrap = (t_keyword_flag)bkw[3].result == KEYWORD_TRUE;
  f_edit = (t_keyword_flag)bkw[4].result;
  box->values = ContextString((t_sexp)bkw[5].result);
  box->args = (t_sexp)bkw[6].result;
  f_transmit = (t_keyword_flag)bkw[7].result;

  XtSetArg(argl[0], XmNuserData, (caddr_t)box);
  XtSetArg(argl[1], XmNallowResize, True);
  box->base_widget = XtCreateWidget("box", xmPanedWindowWidgetClass,
				    parent->widget, argl, 2);
  /* retrieve standard function and save it */
  XtSetArg(argl[0], XmNinsertPosition, &pane_order);
  XtGetValues(box->base_widget, argl, 1);
  /* replace with our function */
  XtSetArg(argl[0], XmNinsertPosition, BoxOrderFunc);
  XtSetValues(box->base_widget, argl, 1);

  n = 0;
  if (columns > 0)
    {
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
      XtSetArg(argl[n], XmNnumColumns, columns), ++n;
    }
  XtSetArg(argl[n], XmNallowResize, True), ++n;
  XtSetArg(argl[n], XmNadjustLast, False), ++n;
  XtSetArg(argl[n], XmNresizeHeight, True), ++n;
  XtSetArg(argl[n], XmNresizeWidth, True), ++n;
  box->field_widget = XtCreateWidget("fieldArea", xmRowColumnWidgetClass,
				  box->base_widget, argl, n);

  BoxHandleItems(box,MBnth(sexp,2), 0);

  ManageWidgetList(box->items);
  ManageWidgetList(box->fields);

  if (NULL != box->fields)
    {
      if (columns < 0)
	{
	  n = 0;
	  XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
	  XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
	  XtSetArg(argl[n], XmNnumColumns, BoxCalcFieldColumns(box)), ++n;
	  XtSetArg(argl[n], XmNresizeHeight, True), ++n;
	  XtSetArg(argl[n], XmNresizeWidth, True), ++n;
	  XtSetValues(box->field_widget, argl, n);
	}
      XtManageChild(box->field_widget);
    }

  if (KEYWORD_TRUE == f_edit)
  {
    /* If the keyword is true, tell our kids.  If not, nothing to do since
     * everybody defaults to non-editable when created.
     */
    box->class->editable(box, TRUE);
  }
  
  /* Set the transmit value.  If it was not specified it will default
   * to false.
   */
  box->transmit = KEYWORD_TRUE == f_transmit;
  box->widget = box->base_widget;

  return (t_generic_widget) box;
}
/* ------------------------------------------------------------------------ */
/* Called by someone else when they want us to remove all of our data
 * structures. Destruction of the widgets is the caller's job.
 */
void
BoxRemove(self) t_box_widget self;
{
  MBfree(self->id);
  RemoveWidgetList(self->items);
  RemoveWidgetList(self->fields);
  FREE(self->header);
  FREE(self->tag);
  FREE(self->values);
  MBfree(self->args);
  
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Called with an update sexp */
static struct keyword_entry_struct bukw [] =
{
  { ":editable", KEYWORD_NONE, KEYWORD_FLAG },
  { ":transmit", KEYWORD_NONE, KEYWORD_FLAG },
  { ":add", NULL, KEYWORD_SEXP },
  { ":delete", NULL, KEYWORD_SEXP },
  { ":columns", (void *)-1, KEYWORD_INT },
} ;

void
BoxUpdate(self,sexp)
     t_box_widget self;
     t_sexp sexp;
{
  t_keyword_flag f_edit, f_transmit;
  t_sexp add_items, delete_items;
  t_sexp item;
  t_generic_widget prev, check_item;
  int n, columns;
  Arg argl[10];

  if (!MBequal(MBnth(sexp,1), self->id)) /* not ours, pass on */
  {
    UpdateWidgetList(self->items, sexp);
    UpdateWidgetList(self->fields, sexp);
  }
  else
  {
    MBparse_keywords(sexp, bukw, ARRAY_SIZE(bukw));
    f_edit = (t_keyword_flag) bukw[0].result;
    f_transmit = (t_keyword_flag) bukw[1].result;
    add_items = (t_sexp) bukw[2].result;
    delete_items = (t_sexp) bukw[3].result;
    columns = (int) bukw[4].result;

    if (NULL != add_items)
	BoxHandleItems(self, add_items, 1);
    if (NULL != delete_items)
    {
      for ( item = delete_items ; MB_CONSP(item) ; item = MB_CDR(item) )
      {	    
	for (prev = NULL, check_item = self->items;
	     NULL != check_item;
	     prev = check_item, check_item = check_item->next)
	{
	  if (MBequal(check_item->id, MB_CAR(item)))
	  {
	    if (prev)
		prev->next = check_item->next;
	    else
		self->items = check_item->next;
	    XtUnmanageChild(check_item->widget);
	    XtDestroyWidget(check_item->widget);
	    check_item->class->remove(check_item);
	    break;
	  }
	}
      }
      /* Now do all the fields */
      for ( item = delete_items ; MB_CONSP(item) ; item = MB_CDR(item) )
      {	    
	for (prev = NULL, check_item = self->fields;
	     NULL != check_item;
	     prev = check_item, check_item = check_item->next)
	{
	  if (MBequal(check_item->id, MB_CAR(item)))
	  {
	    if (prev)
		prev->next = check_item->next;
	    else
		self->fields = check_item->next;
	    XtUnmanageChild(check_item->widget);
	    XtDestroyWidget(check_item->widget);
	    check_item->class->remove(check_item);
	    break;
	  }
	}
      }
    }
    if (KEYWORD_NONE != f_edit)
	self->class->editable(self, KEYWORD_TRUE == f_edit);
    if (KEYWORD_NONE != f_transmit)
	self->transmit = KEYWORD_TRUE == f_transmit;
    n = 0;
    if (columns > 0)
    {
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
      XtSetArg(argl[n], XmNnumColumns, columns), ++n;
    }
    else
    {
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNnumColumns, BoxCalcFieldColumns(self)), ++n;
      XtSetArg(argl[n], XmNresizeHeight, True), ++n;
      XtSetArg(argl[n], XmNresizeWidth, True), ++n;
    }      
    XtSetValues(self->field_widget, argl, n);
  }
}
/*----------------------------------------------------------------------*/
/* Generate the reply for the box                                       */
void
BoxReply(self, reply)
  t_box_widget self;
  t_mbus_reply reply;
{
  if (NULL == reply->header) reply->header = strdup(self->header);
  if (NULL == reply->tag) reply->tag = strdup(self->tag);
  if (NULL == reply->args) reply->args = ContextString(self->args);
  self->parent->class->reply(self->parent, reply);
}  

/*----------------------------------------------------------------------*/
/* Hook for sending the box data and all of it's children		*/
void
BoxTransmitHook(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_box_widget self;
{
  if (NULL != self->values) MBput_Cstring(message, self->values);
  TransmitWidgetList(message, orig_reply, self->items);
  TransmitWidgetList(message, orig_reply, self->fields);
}

/* ------------------------------------------------------------------------ */
/* Transmit data to MBus */
void
BoxTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_box_widget self;
{
  t_mbus_reply reply;
  if (self->transmit)
  {
    /* We want to send the message in a separate tranmission */
    reply = NewReply();
    if (orig_reply->status == TAG_PROVIDED)
    {
      /* If the tag was provided in the original reply, we want to
       * use it here, too.
       */
      reply->tag = strdup(orig_reply->tag);
    }
    else if (orig_reply->status == TAG_AND_ARGS_PROVIDED)
    {
      reply->tag = strdup(orig_reply->tag);
      reply->args = strdup(orig_reply->args);
    }
    reply->transmit = self->transmit;
    reply->status = orig_reply->status;
    reply->wrap = self->wrap;
    reply->hook = BoxTransmitHook;
    reply->hook_data = (caddr_t) self;
    
    BoxReply(self, reply);
    SendReply(reply);
    FreeReply(reply);
  }
  else
  {
    /* Otherwise, just send our children in the current message. */
    TransmitWidgetList(message, orig_reply, self->items);
    TransmitWidgetList(message, orig_reply, self->fields);
  }
}

/* ------------------------------------------------------------------------ */
/* Set the editable status */
void
BoxEditable(self,flag)
     t_box_widget self;
     int flag;
{
  self->editable = flag;
  EditableWidgetList(self->items, flag);
  EditableWidgetList(self->fields, flag);
}

/* ------------------------------------------------------------------------ */
/* Called by a child when it decides to destroy itself for whatever reason.
 * We should update our internal data to remove references to the child.
 * Assume that all of the childs internal and widgets stuff is taken care
 * of by the child.
 */
void
BoxChildDestroyed(self, child)
     t_box_widget self;
     t_generic_widget child;
{
}
/* ------------------------------------------------------------------------ */
/* Called after the widget has been realized, for final fiddling */
void
BoxRealized(self) t_box_widget self;
{
  t_generic_widget item;
  int n;
  Arg argl[1];

  for ( item = self->items ; NULL != item ; item = item->next )
    item->class->realized(item);
  for ( item = self->fields ; NULL != item ; item = item->next )
    item->class->realized(item);

  /* loop through all the items, and freeze menu bars */
  for (item = self->items ; NULL != item ; item = item->next )
    if (WS_MENU_BAR == item->type
	|| WS_BUTTON == item->type
	|| WS_LABEL == item->type
	)
      BoxPaneFreeze(item);

}
/* ------------------------------------------------------------------------ */
