/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* widget server radio support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node119.text,v $ */

static char rcsid[] = "radio.c $Revision: 1.1 $ $Date: 92/05/08 15:25:26 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
#include <Xm/CascadeBG.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/ToggleBG.h>
/* ------------------------------------------------------------------------ */
extern void
  RadioRemove(), RadioUpdate(), RadioReply(), RadioRealized(),
  RadioTransmit(), RadioEditable();

extern t_generic_widget RadioHandle();

struct widget_class_struct RadioClassRecord =
{
  WS_RADIO, "radio",
  RadioHandle, RadioRemove, NULL, RadioUpdate, RadioReply,
  RadioRealized, RadioTransmit, RadioEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct radio_item_struct
{
  Widget widget;
  t_sexp id;
  char *value;
  struct radio_item_struct *next;
} * t_radio_item;
  
typedef struct radio_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget w_title;
  Widget w_frame;
  Widget w_form;
  Widget w_radio;
  char *key;
  t_radio_item items;
  Boolean singular;
} * t_radio_widget;

/* ------------------------------------------------------------------------ */
t_radio_item
RadioNewItem()
{
  t_radio_item item;

  item = NEW_STRUCT(radio_item_struct);
  item->id = NULL;
  item->next = NULL;
  item->value = NULL;

  return item;
}
/* ------------------------------------------------------------------------ */
static struct keyword_entry_struct rikw[] =
{
  { ":select", (void *)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":sensitive", (void *)KEYWORD_NONE, KEYWORD_FLAG },
} ;

void
RadioHandleItems(radio, sexp)
     t_radio_widget radio;
     t_sexp sexp;
{
  int count = 0;
  t_radio_item item;
  t_sexp s_label, s_value, s_item, s_id;
  t_keyword_flag f_select, f_sensitive;
  char *label;
  XmString xm_str;
  int selected = 0;
  int n;
  Arg argl[4];

  /* time to wade throught the sexp and get the toggle buttons */
  /* each item is ( id label value ) */
  for ( ; NULL != sexp ; sexp = MB_CDR(sexp) )
    {
      s_item = MB_CAR(sexp);
      s_id = MBnth(s_item, 0);
      s_label = MBnth(s_item,1);
      s_value = MBnth(s_item,2);

      if (!MB_STRINGP(s_label) || NULL == s_value) continue;
      n = 0;
      MBparse_keywords(MBnthcdr(s_item, 3), rikw, ARRAY_SIZE(rikw));
      f_select = (t_keyword_flag)rikw[n++].result;
      f_sensitive = (t_keyword_flag) rikw[n++].result;

      count += 1;
      item = RadioNewItem();
      item->id = MBduplicate(s_id);
      item->next = radio->items;
      radio->items = item;
      item->value = MBprint_Cstring(s_value);
      label = MBCstring(s_label);
      xm_str = CtoXmString(label);
      n = 0;
      XtSetArg(argl[n], XmNlabelString, xm_str), ++n;
      if (KEYWORD_FALSE == f_sensitive)
	XtSetArg(argl[n], XmNsensitive, False), ++n;
      if (KEYWORD_TRUE == f_select && !(radio->singular && selected))
	{
	  XtSetArg(argl[n], XmNset, True), ++n;
	  selected = 1;
	}
      item->widget =
	XmCreateToggleButtonGadget(radio->w_radio, "toggle", argl, n);
      XtFree(xm_str); XtFree(label);
    }

  /* if it's a singular radio box, and no toggle was selected, select one */
  if (radio->singular && !selected && radio->items)
    {
      XtSetArg(argl[0], XmNset, True);
      XtSetValues(radio->items->widget, argl, 1);
    }
}
/* ------------------------------------------------------------------------ */
void
RadioManageItems(radio) t_radio_widget radio;
{
  int count;
  int i;
  t_radio_item item;
  Widget *wl;

  /* Count up how many fields we've got */
  for ( count = 0, item = radio->items ; NULL != item ; item = item->next )
    count += 1;

  if (count)
    {
      wl = (Widget *)XtMalloc(count * sizeof(Widget));
      i = count;
      for ( item = radio->items ; NULL != item ; item = item->next )
	wl[--i] = item->widget;
      XtManageChildren(wl, count);
      XtFree(wl);
    }
}
/* ------------------------------------------------------------------------ */
static int
RadioCalcColumns(radio) t_radio_widget radio;
{
  int f_spill, c_spill;
  int f_count, c_count;
  int n, i, f, c;
  t_radio_item item;

  /* Count up how many fields we've got */
  for ( n = 0, item = radio->items ; NULL != item ; item = item->next )
    n += 1;

  /* Find the ceil of the sqrt */
  for ( c = 1 ; c * c < n ; ++ c )
    ;

  c_count = c * c;			/* number of slots for ceiling */
  if (c_count == n) return c;
  f = c - 1;
  f_count = f * f;
  c_spill = c_count - n;
  f_spill = n - f_count;

  return c_spill < f_spill ? c : f;
}
/* ------------------------------------------------------------------------ */
/* Create a radio box. The sexp should be of the form
 * (radio "id" :key (<items>) &key title many)
 */
static struct keyword_entry_struct RadioKeywords[] =
{
  { ":title", NULL, KEYWORD_COOKED },
  { ":many", (void *)KEYWORD_FALSE, KEYWORD_FLAG },
  { ":columns", (void*)-1, KEYWORD_INT },
  { ":orientation", NULL, KEYWORD_SEXP },
  { ":editable", (void *)KEYWORD_NONE, KEYWORD_FLAG },
};

t_generic_widget
RadioHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_radio_widget radio;
  t_keyword_flag f_edit;
  t_sexp s_key, s_id, s_orient;
  char *title;
  int n, columns;
  Arg argl[10];

  /* check required arguments first */
  s_id = MBnth(sexp,1);
  s_key = MBnth(sexp,2);

  if (NULL == s_id || (!MB_STRINGP(s_key) && !MB_NAMEP(s_key))) return NULL;

  radio = NEW_STRUCT(radio_widget_struct);
  radio->type = WS_RADIO;
  radio->next = NULL;
  radio->parent = parent;
  radio->top = parent->top;
  radio->class = &RadioClassRecord;
  radio->id = Getnth(sexp, 1);
  radio->items = NULL;
  if (MB_STRINGP(s_key)) radio->key = MBCstring(s_key);
  else radio->key = MBprint_Cstring(s_key);
  
  /* get the keywords */
  MBparse_keywords(MBnthcdr(sexp,4), RadioKeywords, ARRAY_SIZE(RadioKeywords));
  n = 0;
  title = (char *)RadioKeywords[n++].result;
  radio->singular = (t_keyword_flag)RadioKeywords[n++].result == KEYWORD_FALSE;
  columns = (int)RadioKeywords[n++].result;
  s_orient = (t_sexp)RadioKeywords[n++].result;
  f_edit = (t_keyword_flag)RadioKeywords[n++].result;

  /* outer frame */
  radio->w_frame = XtCreateWidget("field", xmFrameWidgetClass,
				  parent->widget, NULL, 0);
  radio->widget = radio->w_frame;

  /* a form to bind the label to the RC */
  n = 0;
  radio->w_form = XtCreateWidget("form", xmFormWidgetClass,
				 radio->w_frame, argl, n);

  /* there's always a title, it's just not managed if no title set */
  radio->w_title = CreateTitle(NULL == title ? "" : title, radio->w_form);
  n = 0;
  XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNalignment, XmALIGNMENT_CENTER), ++n;
  XtSetValues(radio->w_title, argl, n);

  /* Now, the real thing - the radio box */
  n = 0;
  XtSetArg(argl[n], XmNbottomAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNleftAttachment, XmATTACH_FORM), ++n;
  XtSetArg(argl[n], XmNrightAttachment, XmATTACH_FORM), ++n;
  if (columns > 0)
    XtSetArg(argl[n], XmNnumColumns, columns), ++n;
  if (!MBcompare_Cstring(s_orient, ":horizontal"))
    {
      XtSetArg(argl[n], XmNorientation, XmHORIZONTAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
  else if (!MBcompare_Cstring(s_orient, ":vertical"))
    {
      XtSetArg(argl[n], XmNorientation, XmVERTICAL), ++n;
      XtSetArg(argl[n], XmNpacking, XmPACK_COLUMN), ++n;
    }
  else if (!MBcompare_Cstring(s_orient, ":pack"))
    XtSetArg(argl[n], XmNpacking, XmPACK_TIGHT), ++n;


  XtSetArg(argl[n], XmNsensitive, KEYWORD_TRUE == f_edit), ++n;
  XtSetArg(argl[n], XmNadjustLast, False), ++n;
  if (NULL == title)
    XtSetArg(argl[n], XmNtopAttachment, XmATTACH_FORM), ++n;
  else
    {
      XtSetArg(argl[n], XmNtopAttachment, XmATTACH_WIDGET), ++n;
      XtSetArg(argl[n], XmNtopWidget, radio->w_title), ++n;
    }
  if (!radio->singular) XtSetArg(argl[n], XmNradioBehavior, False), ++n;
  if (n > ARRAY_SIZE(argl)) fatal_error("Too many args for radio box");
  radio->w_radio = XmCreateRadioBox(radio->w_form, "radio", argl, n);

  RadioHandleItems(radio, MBnth(sexp, 3));

  if (NULL == radio->items)
    {
      RadioRemove(radio);
      XtDestroyWidget(radio->widget);
      radio = NULL;
    }
  else
    {
      if (columns == 0)
	{
	  n = 0;
	  XtSetArg(argl[n], XmNnumColumns, RadioCalcColumns(radio)), ++n;
	  XtSetValues(radio->w_radio, argl, n);
	}

      RadioManageItems(radio);

      if (NULL != title) XtManageChild(radio->w_title);
      XtManageChild(radio->w_radio);
      XtManageChild(radio->w_form);
    }

  XtFree(title);
  return (t_generic_widget)radio;
}
/* ------------------------------------------------------------------------ */
void
RadioRemove(self) t_radio_widget self;
{
  t_radio_item item, next;

  item = self->items;
  while (NULL != item)
    {
      next = item->next;
      MBfree(item->id);
      XtFree(item->value);
      XtFree(item);
      item = next;
    }
  XtFree(self->key);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the radio */
static struct keyword_entry_struct RadioUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
  { ":tag", NULL, KEYWORD_RAW },
  { ":value", NULL, KEYWORD_RAW },
};

void
RadioUpdate(self,sexp)
     t_radio_widget self;
     t_sexp sexp;
{
}
/* ------------------------------------------------------------------------ */
void
RadioReply(self, reply)
     t_radio_widget self;
     t_mbus_reply reply;
{
}
/* ------------------------------------------------------------------------ */
void
RadioRealized(self) t_radio_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
RadioTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_radio_widget self;
{
  t_radio_item item;
  char *str, *tmp;
  Widget w;

  MBput_Cstring(message, " ");
  MBput_Cstring(message, self->key);
  if (!self->singular) MBput_Cstring(message, " (");
  for ( item = self->items ; NULL != item ; item = item->next )
    {
      if (XmToggleButtonGadgetGetState(item->widget))
	{
	  MBput_Cstring(message, " ");
	  MBput_Cstring(message, item->value);
	  if (self->singular) break;
	}
    }
  if (!self->singular) MBput_Cstring(message, " )");
}
/* ------------------------------------------------------------------------ */
void
RadioEditable(self, flag)
     t_radio_widget self;
     int flag;
{
  XtSetSensitive(self->w_radio, flag ? True : False);
}
/* ------------------------------------------------------------------------ */
