;;; essd-sp5.el --- S-plus 5  customization

;; Copyright (C) 1998 A.J. Rossini
;; Copyright (C) 1999--2004 A.J. Rossini, Rich M. Heiberger, Martin
;;	Maechler, Kurt Hornik, Rodney Sparapani, and Stephen Eglen.

;; Original Author: A.J. Rossini <rossini@biostat.washington.edu>
;; Created: 9 Nov 1998
;; Maintainers: ESS-core <ESS-core@stat.math.ethz.ch>

;; Keywords: start up, configuration.

;; This file is part of ESS.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:
;;; AJR copied S4 to be S+5.
;;; DB contributed the changes from essd-sp3.el to
;;; essd-s4.el. (removed the old ugly approach).
;;; This file defines Sp5 customizations for ess-mode.  Lots of thanks
;;; to RMH and JMC for code and suggestions
;;; Thanks to MM for making this sensible.

;;; Requires and Autoloads:

(require 'essl-s)

(autoload 'inferior-ess "ess-inf" "Run an ESS process.")
(autoload 'ess-mode     "ess-mode" "Edit an ESS process.")

;;; Code:

;; You now need to make sure you've defined if you are running 5.0 or 5.1.
;; Lots of things are broken between them, GRR...

(defvar S+5-dialect-name "S+5"
  "Name of 'dialect' for S-PLUS 5.");easily changeable in a user's .emacs

(defvar S+5-customize-alist
  '((ess-local-customize-alist     . 'S+5-customize-alist)
    (ess-language                  . "S")
    (ess-dialect                   . S+5-dialect-name)
    (ess-suffix                    . "S")
    (ess-mode-editing-alist        . S-editing-alist)
    (ess-mode-syntax-table         . S-syntax-table)
    (ess-help-sec-regex            . ess-help-S+-sec-regex)
					;or just "^[A-Z. ---]+:$"
    (ess-help-sec-keys-alist       . S+-help-sec-keys-alist)

    (ess-function-template         . " <- \n#\nfunction()\n{\n\n}\n")
    (ess-loop-timeout              . ess-S-loop-timeout)
    (ess-dump-filename-template    . (replace-regexp-in-string
				      "S$" ess-suffix ; in the one from custom:
				      ess-dump-filename-template-proto))
    (ess-object-name-db-file       . "ess-sp5-namedb.el")
    (ess-dumped-missing-re
     . "\\(\\(<-\\|=\\)\nDumped\n\\'\\)\\|\\(\\(<-\\|=\\)\\(\\s \\|\n\\)*\\'\\)")
    (ess-syntax-error-re
     . "\\(Syntax error: .*\\) at line \\([0-9]*\\), file \\(.*\\)$")
    (ess-retr-lastvalue-command
     . ".Last.value <- get(\".ess.lvsave\",frame=0)\n")
    (ess-save-lastvalue-command
     . "assign(\".ess.lvsave\",.Last.value,frame=0)\n")
    (inferior-ess-program          . inferior-S+5-program-name)
    (inferior-ess-objects-command  . "objects(%d)\n")
    (inferior-ess-objects-pattern  . ".*") ; for new s4 stuff
    (inferior-ess-help-command     . "help(\"%s\",pager=\"slynx -dump\",window=F)\n")
    ;; "paths": get the "/" needed by  (ess-dir-modtime dir)  in ./ess-inf.el:
    (inferior-ess-search-list-command . "search(\"paths\")\n")
    (inferior-ess-exit-command     . "q()\n")
    (comint-use-prompt-regexp-instead-of-fields . t) ;; emacs 21 and up
    (inferior-ess-primary-prompt   . "[a-zA-Z0-9() ]*> ?")
    (inferior-ess-secondary-prompt . "+ ?")
    (ess-STERM  . "iESS")
    (ess-editor . S-editor)
    (ess-pager  . S-pager)
    (inferior-ess-language-start . (eval inferior-S-language-start))
    )
  "Variables to customize for S+5.")


;; For loading up the S code required for the above.
;;(add-hook 'ess-post-run-hook
;;	  '(lambda ()
;;	     (ess-command
;;	      (concat
;;	       "if(exists(\"Sversion\")) library(emacs) else source(\""
;;	       ess-mode-run-file
;;	       "\")\n"))
;;	     (if ess-mode-run-file2
;;		 (ess-command
;;		  (concat "source(\"" ess-mode-run-file2 "\")\n")))))


(defun S+5 (&optional proc-name)
  "Call 'Splus5', based on S version 4, from Bell Labs.
New way to do it."
  (interactive)
  (setq ess-customize-alist S+5-customize-alist)
  (ess-write-to-dribble-buffer
   (format "\n(S+5): ess-dialect=%s, buf=%s\n" ess-dialect (current-buffer)))
  (inferior-ess)
  (if inferior-ess-language-start
      (ess-eval-linewise inferior-ess-language-start)))

(defun S+5-mode (&optional proc-name)
  "Major mode for editing S+5 source.  See `ess-mode' for more help."
  (interactive)
  (setq ess-customize-alist S+5-customize-alist)
  (ess-mode S+5-customize-alist proc-name)
  (if ess-imenu-use-S (ess-imenu-S)))

(defun S+5-transcript-mode ()
  "S-PLUS 5 transcript mode."
  (interactive)
  (ess-transcript-mode S+5-customize-alist))

 ; Provide package

(provide 'essd-sp5)

 ; Local variables section

;;; This file is automatically placed in Outline minor mode.
;;; The file is structured as follows:
;;; Chapters:     ^L ;
;;; Sections:    ;;*;;
;;; Subsections: ;;;*;;;
;;; Components:  defuns, defvars, defconsts
;;;              Random code beginning with a ;;;;* comment

;;; Local variables:
;;; mode: emacs-lisp
;;; outline-minor-mode: nil
;;; mode: outline-minor
;;; outline-regexp: "\^L\\|\\`;\\|;;\\*\\|;;;\\*\\|(def[cvu]\\|(setq\\|;;;;\\*"
;;; End:

;;; essd-sp5.el ends here
