/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.HashMap;
import java.util.List;
import jde.debugger.JDEException;
import jde.debugger.command.AttachShmem;
import jde.debugger.command.AttachSocket;
import jde.debugger.command.DebugCommand;
import jde.debugger.command.EvaluateExpression;
import jde.debugger.command.GetArray;
import jde.debugger.command.GetLocals;
import jde.debugger.command.GetString;
import jde.debugger.command.GetThis;
import jde.debugger.command.LaunchApplication;
import jde.debugger.command.ListenShmem;
import jde.debugger.command.ListenSocket;
import jde.debugger.command.Quit;
import jde.debugger.command.Run;

public class DebugCommandFactory {
    private HashMap prototypes = new HashMap();
    public static DebugCommandFactory theFactory = new DebugCommandFactory();

    protected DebugCommandFactory() {
        this.prototypes.put("launch", new LaunchApplication());
        this.prototypes.put("attach_shmem", new AttachShmem());
        this.prototypes.put("attach_socket", new AttachSocket());
        this.prototypes.put("listen_shmem", new ListenShmem());
        this.prototypes.put("listen_socket", new ListenSocket());
        this.prototypes.put("quit", new Quit());
        this.prototypes.put("run", new Run());
        this.prototypes.put("get_string", new GetString());
        this.prototypes.put("get_array", new GetArray());
        this.prototypes.put("get_locals", new GetLocals());
        this.prototypes.put("get_this", new GetThis());
        this.prototypes.put("evaluate", new EvaluateExpression());
    }

    public final DebugCommand createCommand(Integer appID, Integer cmdID, String cmdName, List args) throws JDEException {
        DebugCommand prototype = (DebugCommand)this.prototypes.get(cmdName);
        if (prototype == null) {
            return null;
        }
        DebugCommand cmd = (DebugCommand)prototype.clone();
        cmd.init(appID, cmdID, cmdName, args);
        return cmd;
    }
}

