;;; DO NOT MODIFY THIS FILE
(if (featurep 'ps-print-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "ps-print/_pkg.el")

(package-provide 'ps-print :version 1.04 :type 'regular)

;;;***

;;;### (autoloads (print-region lpr-region print-buffer lpr-buffer) "lpr" "ps-print/lpr.el")

(defvar lpr-windows-system (memq system-type '(emx win32 w32 mswindows ms-dos windows-nt)))

(defvar lpr-lp-system (memq system-type '(usg-unix-v dgux hpux irix)))

(defcustom printer-name (and lpr-windows-system "PRN") "*The name of a local printer to which data is sent for printing.\n(Note that PostScript files are sent to `ps-printer-name', which see.)\n\nOn Unix-like systems, a string value should be a name understood by\nlpr's -P option; otherwise the value should be nil.\n\nOn MS-DOS and MS-Windows systems, a string value is taken as the name of\na printer device or port, provided `lpr-command' is set to \"\".\nTypical non-default settings would be \"LPT1\" to \"LPT3\" for parallel\nprinters, or \"COM1\" to \"COM4\" or \"AUX\" for serial printers, or\n\"//hostname/printer\" for a shared network printer.  You can also set\nit to the name of a file, in which case the output gets appended to that\nfile.  If you want to discard the printed output, set this to \"NUL\"." :type '(choice :menu-tag "Printer Name" :tag "Printer Name" (const :tag "Default" nil) (file :tag "Name")) :group 'lpr)

(defcustom lpr-switches nil "*List of strings to pass as extra options for the printer program.\nIt is recommended to set `printer-name' instead of including an explicit\nswitch on this list.\nSee `lpr-command'." :type '(repeat (string :tag "Argument")) :group 'lpr)

(defcustom lpr-command (cond (lpr-windows-system "") (lpr-lp-system "lp") (t "lpr")) "*Name of program for printing a file.\n\nOn MS-DOS and MS-Windows systems, if the value is an empty string then\nEmacs will write directly to the printer port named by `printer-name'.\nThe programs `print' and `nprint' (the standard print programs on\nWindows NT and Novell Netware respectively) are handled specially, using\n`printer-name' as the destination for output; any other program is\ntreated like `lpr' except that an explicit filename is given as the last\nargument." :type 'string :group 'lpr)

(autoload 'lpr-buffer "lpr" "\
Print buffer contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command." t nil)

(autoload 'print-buffer "lpr" "\
Paginate and print buffer contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.
 
See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command." t nil)

(autoload 'lpr-region "lpr" "\
Print region contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command." t nil)

(autoload 'print-region "lpr" "\
Paginate and print the region contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.
 
See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command." t nil)

;;;***

;;;### (autoloads nil "ps-bdf" "ps-print/ps-bdf.el")

(defvar bdf-directory-list (if (eq system-type 'ms-dos) (list (expand-file-name "fonts/bdf" installation-directory)) '("/usr/local/share/emacs/fonts/bdf")) "\
*List of directories to search for `BDF' font files.
The default value is '(\"/usr/local/share/emacs/fonts/bdf\").")

;;;***

;;;### (autoloads (ps-mule-begin-page ps-mule-begin-job ps-mule-header-string-charsets ps-mule-encode-header-string ps-mule-initialize ps-mule-plot-composition ps-mule-plot-string ps-mule-set-ascii-font ps-mule-prepare-ascii-font) "ps-mule" "ps-print/ps-mule.el")

(defcustom ps-multibyte-buffer nil "*Specifies the multi-byte buffer handling.\n\nValid values are:\n\n  nil                     This is the value to use the default settings which\n			  is by default for printing buffer with only ASCII\n			  and Latin characters.   The default setting can be\n			  changed by setting the variable\n			  `ps-mule-font-info-database-default' differently.\n			  The initial value of this variable is\n			  `ps-mule-font-info-database-latin' (see\n			  documentation).\n\n  `non-latin-printer'     This is the value to use when you have a Japanese\n			  or Korean PostScript printer and want to print\n			  buffer with ASCII, Latin-1, Japanese (JISX0208 and\n			  JISX0201-Kana) and Korean characters.  At present,\n			  it was not tested the Korean characters printing.\n			  If you have a korean PostScript printer, please,\n			  test it.\n\n  `bdf-font'              This is the value to use when you want to print\n			  buffer with BDF fonts.  BDF fonts include both latin\n			  and non-latin fonts.  BDF (Bitmap Distribution\n			  Format) is a format used for distributing X's font\n			  source file.  BDF fonts are included in\n			  `intlfonts-1.2' which is a collection of X11 fonts\n			  for all characters supported by Emacs.  In order to\n			  use this value, be sure to have installed\n			  `intlfonts-1.2' and set the variable\n			  `bdf-directory-list' appropriately (see ps-bdf.el for\n			  documentation of this variable).\n\n  `bdf-font-except-latin' This is like `bdf-font' except that it is used\n			  PostScript default fonts to print ASCII and Latin-1\n			  characters.  This is convenient when you want or\n			  need to use both latin and non-latin characters on\n			  the same buffer.  See `ps-font-family',\n			  `ps-header-font-family' and `ps-font-info-database'.\n\nAny other value is treated as nil." :type '(choice (const non-latin-printer) (const bdf-font) (const bdf-font-except-latin) (const :tag "nil" nil)) :group 'ps-print-font)

(autoload 'ps-mule-prepare-ascii-font "ps-mule" "\
Setup special ASCII font for STRING.
STRING should contain only ASCII characters." nil nil)

(autoload 'ps-mule-set-ascii-font "ps-mule" nil nil nil)

(autoload 'ps-mule-plot-string "ps-mule" "\
Generate PostScript code for plotting characters in the region FROM and TO.

It is assumed that all characters in this region belong to the same charset.

Optional argument BG-COLOR specifies background color.

Returns the value:

	(ENDPOS . RUN-WIDTH)

Where ENDPOS is the end position of the sequence and RUN-WIDTH is the width of
the sequence." nil nil)

(autoload 'ps-mule-plot-composition "ps-mule" "\
Generate PostScript code for plotting composition in the region FROM and TO.

It is assumed that all characters in this region belong to the same
composition.

Optional argument BG-COLOR specifies background color.

Returns the value:

	(ENDPOS . RUN-WIDTH)

Where ENDPOS is the end position of the sequence and RUN-WIDTH is the width of
the sequence." nil nil)

(autoload 'ps-mule-initialize "ps-mule" "\
Initialize global data for printing multi-byte characters." nil nil)

(autoload 'ps-mule-encode-header-string "ps-mule" "\
Generate PostScript code for ploting STRING by font FONTTAG.
FONTTAG should be a string \"/h0\" or \"/h1\"." nil nil)

(autoload 'ps-mule-header-string-charsets "ps-mule" "\
Return a list of character sets that appears in header strings." nil nil)

(autoload 'ps-mule-begin-job "ps-mule" "\
Start printing job for multi-byte chars between FROM and TO.
This checks if all multi-byte characters in the region are printable or not." nil nil)

(autoload 'ps-mule-begin-page "ps-mule" nil nil nil)

;;;***

;;;### (autoloads (ps-extend-face ps-extend-face-list ps-setup ps-nb-pages-region ps-nb-pages-buffer ps-line-lengths ps-despool ps-spool-region-with-faces ps-spool-region ps-spool-buffer-with-faces ps-spool-buffer ps-print-region-with-faces ps-print-region ps-print-buffer-with-faces ps-print-buffer ps-print-customize) "ps-print" "ps-print/ps-print.el")

(defcustom ps-page-dimensions-database (list (list 'a4 (/ (* 72 21.0) 2.54) (/ (* 72 29.7) 2.54) "A4") (list 'a3 (/ (* 72 29.7) 2.54) (/ (* 72 42.0) 2.54) "A3") (list 'letter (* 72 8.5) (* 72 11.0) "Letter") (list 'legal (* 72 8.5) (* 72 14.0) "Legal") (list 'letter-small (* 72 7.68) (* 72 10.16) "LetterSmall") (list 'tabloid (* 72 11.0) (* 72 17.0) "Tabloid") (list 'ledger (* 72 17.0) (* 72 11.0) "Ledger") (list 'statement (* 72 5.5) (* 72 8.5) "Statement") (list 'executive (* 72 7.5) (* 72 10.0) "Executive") (list 'a4small (* 72 7.47) (* 72 10.85) "A4Small") (list 'b4 (* 72 10.125) (* 72 14.33) "B4") (list 'b5 (* 72 7.16) (* 72 10.125) "B5")) "*List associating a symbolic paper type to its width, height and doc media.\nSee `ps-paper-type'." :type '(repeat (list :tag "Paper Type" (symbol :tag "Name") (number :tag "Width") (number :tag "Height") (string :tag "Media"))) :group 'ps-print-page)

(defcustom ps-paper-type 'letter "*Specify the size of paper to format for.\nShould be one of the paper types defined in `ps-page-dimensions-database', for\nexample `letter', `legal' or `a4'." :type '(symbol :validate (lambda (wid) (if (assq (widget-value wid) ps-page-dimensions-database) nil (widget-put wid :error "Unknown paper size") wid))) :group 'ps-print-page)

(autoload 'ps-print-customize "ps-print" "\
Customization of ps-print group." t nil)

(autoload 'ps-print-buffer "ps-print" "\
Generate and print a PostScript image of the buffer.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the PostScript image in that file instead of
sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name." t nil)

(autoload 'ps-print-buffer-with-faces "ps-print" "\
Generate and print a PostScript image of the buffer.
Like `ps-print-buffer', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values." t nil)

(autoload 'ps-print-region "ps-print" "\
Generate and print a PostScript image of the region.
Like `ps-print-buffer', but prints just the current region." t nil)

(autoload 'ps-print-region-with-faces "ps-print" "\
Generate and print a PostScript image of the region.
Like `ps-print-region', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values." t nil)

(autoload 'ps-spool-buffer "ps-print" "\
Generate and spool a PostScript image of the buffer.
Like `ps-print-buffer' except that the PostScript image is saved in a local
buffer to be sent to the printer later.

Use the command `ps-despool' to send the spooled images to the printer." t nil)

(autoload 'ps-spool-buffer-with-faces "ps-print" "\
Generate and spool a PostScript image of the buffer.
Like `ps-spool-buffer', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values.

Use the command `ps-despool' to send the spooled images to the printer." t nil)

(autoload 'ps-spool-region "ps-print" "\
Generate a PostScript image of the region and spool locally.
Like `ps-spool-buffer', but spools just the current region.

Use the command `ps-despool' to send the spooled images to the printer." t nil)

(autoload 'ps-spool-region-with-faces "ps-print" "\
Generate a PostScript image of the region and spool locally.
Like `ps-spool-region', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values.

Use the command `ps-despool' to send the spooled images to the printer." t nil)

(autoload 'ps-despool "ps-print" "\
Send the spooled PostScript to the printer.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name." t nil)

(autoload 'ps-line-lengths "ps-print" "\
Display the correspondence between a line length and a font size, using the
current ps-print setup.
Try: pr -t file | awk '{printf \"%3d %s
\", length($0), $0}' | sort -r | head" t nil)

(autoload 'ps-nb-pages-buffer "ps-print" "\
Display number of pages to print this buffer, for various font heights.
The table depends on the current ps-print setup." t nil)

(autoload 'ps-nb-pages-region "ps-print" "\
Display number of pages to print the region, for various font heights.
The table depends on the current ps-print setup." t nil)

(autoload 'ps-setup "ps-print" "\
Return the current PostScript-generation setup." nil nil)

(autoload 'ps-extend-face-list "ps-print" "\
Extend face in ALIST-SYM.

If optional MERGE-P is non-nil, extensions in FACE-EXTENSION-LIST are merged
with face extension in ALIST-SYM; otherwise, overrides.

If optional ALIST-SYM is nil, it's used `ps-print-face-extension-alist';
otherwise, it should be an alist symbol.

The elements in FACE-EXTENSION-LIST is like those for `ps-extend-face'.

See `ps-extend-face' for documentation." nil nil)

(autoload 'ps-extend-face "ps-print" "\
Extend face in ALIST-SYM.

If optional MERGE-P is non-nil, extensions in FACE-EXTENSION list are merged
with face extensions in ALIST-SYM; otherwise, overrides.

If optional ALIST-SYM is nil, it's used `ps-print-face-extension-alist';
otherwise, it should be an alist symbol.

The elements of FACE-EXTENSION list have the form:

   (FACE-NAME FOREGROUND BACKGROUND EXTENSION...)

FACE-NAME is a face name symbol.

FOREGROUND and BACKGROUND may be nil or a string that denotes the
foreground and background colors respectively.

EXTENSION is one of the following symbols:
   bold      - use bold font.
   italic    - use italic font.
   underline - put a line under text.
   strikeout - like underline, but the line is in middle of text.
   overline  - like underline, but the line is over the text.
   shadow    - text will have a shadow.
   box       - text will be surrounded by a box.
   outline   - print characters as hollow outlines.

If EXTENSION is any other symbol, it is ignored." nil nil)

;;;***

(provide 'ps-print-autoloads)
