/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Debug;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDEException;
import jde.debugger.command.DebugSessionCommand;

public class AttachShmem
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        String connectSpec = null;
        connectSpec = "com.sun.jdi.SharedMemoryAttach";
        AttachingConnector connector = (AttachingConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        if (this.args.size() < 1) {
            throw new JDEException("Missing name");
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            Connector.Argument nameArg = argumentMap.get("name");
            nameArg.setValue(this.args.remove(0).toString());
            VirtualMachine vm = connector.attach(argumentMap);
            DebuggeeProcess proc = new DebuggeeProcess(this.procID, vm);
            if (this.procRegistry.processExists(this.procID)) {
                proc.shutdown();
                throw new JDEException("A process with the ID" + this.procID + " already exists.");
            }
            this.procRegistry.addProcess(this.procID, proc);
            this.jde.signalCommandResult(this.procID, this.cmdID);
            this.jde.signal(this.procID, "message", "Attached VM (shmem) " + vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Error attempting to attach to process via shared memory.");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    public Object clone() {
        return new AttachShmem();
    }
}

