;;; ucs-cjk.el --- UCS table of CJK Unified Ideographs

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, CJK Unified Ideographs

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)


;;; R001 (one)

(ucs-define-ideograph #x4E00 001 00
		      ?$B0l(B ; J83-B-306C
		      ?$@0l(B ; J78-@-306C
		      ?$AR;(B ; GB0-A-523B
		      ?$(Cli(B ; KS0-C-6C69
		      ?$(GD!(B ; C01-G-4421
		      )

(ucs-define-ideograph #x4E01 001 01
		      ?$BCz(B ; J83-B-437A
		      ?$@Cz(B ; J78-@-437A
		      ?$A6!(B ; GB0-A-3621
		      ?$(CoK(B ; KS0-C-6F4B
		      ?$(GD#(B ; C01-G-4423
		      )
(ucs-define-ideograph #x4E02 001 01
		      ?$(D0!(B ; J90-D-3021
		      ?$(J!&(B ; C04-J-2126
		      )
(ucs-define-ideograph #x4E03 001 01
		      ?$B<7(B ; J83-B-3C37
		      ?$@<7(B ; J78-@-3C37
		      ?$AF_(B ; GB0-A-465F
		      ?$(CvR(B ; KS0-C-7652
		      ?$(GD$(B ; C01-G-4424
		      )
(ucs-define-ideograph #x4E04 001 01
		      ?$(D0"(B ; J90-D-3022
		      ?$(I!&(B ; C03-I-2126
		      )
(ucs-define-ideograph #x4E05 001 01
		      ?$(D0#(B ; J90-D-3023
		      ?$(I!%(B ; C03-I-2125
		      )

(ucs-define-ideograph #x4E07 001 02
		      ?$BK|(B ; J83-B-4B7C
		      ?$@K|(B ; J78-@-4B7C
		      ?$AMr(B ; GB0-A-4D72
		      ?$(CX2(B ; KS0-C-5832
		      ?$(H!&(B ; C02-H-2126
		      )
(ucs-define-ideograph #x4E08 001 02
		      ?$(Cm[(B ; KS0-C-6D5B
		      ?$@>f(B ; J78-@-3E66
		      ?$AUI(B ; GB0-A-5549
		      ?$B>f(B ; J83-B-3E66
		      ?$(GD7(B ; C01-G-4437
		      ;;?$(I!D(B ; C03-I-2144
		      )
(ucs-define-ideograph #x4E09 001 02
		      ?$B;0(B ; J83-B-3B30
		      ?$@;0(B ; J78-@-3B30
		      ?$AH}(B ; GB0-A-487D
		      ?$(C_2(B ; KS0-C-5F32
		      ?$(GD5(B ; C01-G-4435
		      )
(ucs-define-ideograph #x4E0A 001 02
		      ?$B>e(B ; J83-B-3E65
		      ?$@>e(B ; J78-@-3E65
		      ?$AIO(B ; GB0-A-494F
		      ?$(C_>(B ; KS0-C-5F3E
		      ?$(GD8(B ; C01-G-4438
		      )
(ucs-define-ideograph #x4E0B 001 02
		      ?$B2<(B ; J83-B-323C
		      ?$@2<(B ; J78-@-323C
		      ?$AOB(B ; GB0-A-4F42
		      ?$(Cy;(B ; KS0-C-793B
		      ?$(GD6(B ; C01-G-4436
		      )
(ucs-define-ideograph #x4E0C 001 02
		      ?$(D0$(B ; J90-D-3024
		      ?$(H!'(B ; C02-H-2127
		      ?$AX"(B ; GB0-A-5822
		      )

(ucs-define-ideograph #x4E0D 001 03
		      ?$BIT(B ; J83-B-4954
		      ?$@IT(B ; J78-@-4954
		      ?$A2;(B ; GB0-A-323B
		      ?$(C\t(B ; KS0-C-5C74
		      ?$(GDb(B ; C01-G-4462
		      )
(ucs-define-ideograph #x4E0E 001 03
		      ?$(H!/(B ; C02-H-212F
		      ?$ASk(B ; GB0-A-536B
		      ;; ?$@M?(B ; J78-@-4D3F
		      ;; ?$BM?(B ; J83-B-4D3F
		      )
(ucs-define-ideograph #x4E0F 001 03
		      ?$(H!-(B ; C02-H-212D
		      )
(ucs-define-ideograph #x4E10 001 03
		      ?$BP"(B ; J83-B-5022
		      ?$@P"(B ; J78-@-5022
		      ?$AX$(B ; GB0-A-5824
		      ?$(GDa(B ; C01-G-4461
		      )
(ucs-define-ideograph #x4E11 001 03
		      ?$@1/(B ; J78-@-312F
		      ?$B1/(B ; J83-B-312F
		      ?$(Cud(B ; KS0-C-7564
		      ?$(GD`(B ; C01-G-4460
		      ;;?$A3s(B ; GB0-A-3373
		      )
(ucs-define-ideograph #x4E12 001 03
		      ?$(D0%(B ; J90-D-3025
		      ?$(J!9(B ; C04-J-2139
		      )
(ucs-define-ideograph #x4E13 001 03
		      ?$AW((B ; GB0-A-5728
		      )

(ucs-define-ideograph #x4E14 001 04
		      ?$B3n(B ; J83-B-336E
		      ?$@3n(B ; J78-@-336E
		      ?$AGR(B ; GB0-A-4752
		      ?$(Cs&(B ; KS0-C-7326
		      ?$(GEb(B ; C01-G-4562
		      )
(ucs-define-ideograph #x4E15 001 04
		      ?$BP#(B ; J83-B-5023
		      ?$@P#(B ; J78-@-5023
		      ?$AX'(B ; GB0-A-5827
		      ?$(C]`(B ; KS0-C-5D60
		      ?$(GEa(B ; C01-G-4561
		      )
(ucs-define-ideograph #x4E16 001 04
		      ?$B@$(B ; J83-B-4024
		      ?$@@$(B ; J78-@-4024
		      ?$AJ@(B ; GB0-A-4A40
		      ?$(Ca&(B ; KS0-C-6126
		      ?$(GE`(B ; C01-G-4560
		      )
(ucs-define-ideograph #x4E17 001 04
		      ?$BRB(B ; J83-B-5242
		      ?$@RB(B ; J78-@-5242
		      ?$(J!U(B ; C04-J-2155
		      )
(ucs-set-char #x4E18 ?$AGp(B) ; GB0-A-4770
(ucs-set-char #x4E18 ?$(CNx(B) ; KS0-C-4E78
(ucs-set-char #x4E18 ?$(GEc(B) ; C01-G-4563
(ucs-set-char #x4E18 ?$@5V(B) ; J78-@-3556
(ucs-set-char #x4E18 ?$B5V(B) ; J83-B-3556

(ucs-set-char #x4E19 ?$A1{(B) ; GB0-A-317B
(ucs-set-char #x4E19 ?$(C\0(B) ; KS0-C-5C30
(ucs-set-char #x4E19 ?$(GE_(B) ; C01-G-455F
(ucs-set-char #x4E19 ?$@J:(B) ; J78-@-4A3A
(ucs-set-char #x4E19 ?$BJ:(B) ; J83-B-4A3A

(ucs-set-char #x4E1A ?$AR5(B) ; GB0-A-5235

(ucs-set-char #x4E1B ?$A4T(B) ; GB0-A-3454

(ucs-set-char #x4E1C ?$A6+(B) ; GB0-A-362B

(ucs-set-char #x4E1D ?$AK?(B) ; GB0-A-4B3F

(ucs-set-char #x4E1E ?$AX)(B) ; GB0-A-5829
(ucs-set-char #x4E1E ?$(Cc*(B) ; KS0-C-632A
(ucs-set-char #x4E1E ?$(GG"(B) ; C01-G-4722
(ucs-set-char #x4E1E ?$@>g(B) ; J78-@-3E67
(ucs-set-char #x4E1E ?$B>g(B) ; J83-B-3E67

(ucs-set-char #x4E1F ?$(GG#(B) ; C01-G-4723
(ucs-set-char #x4E1F ?$(D0&(B) ; J90-D-3026

(ucs-set-char #x4E20 ?$(I"b(B) ; C03-I-2262

(ucs-set-char #x4E21 ?$(I"a(B) ; C03-I-2261
(ucs-set-char #x4E21 ?$@N>(B) ; J78-@-4E3E
(ucs-set-char #x4E21 ?$BN>(B) ; J83-B-4E3E

(ucs-set-char #x4E22 ?$A6*(B) ; GB0-A-362A
(ucs-set-char #x4E22 ?$(I"c(B) ; C03-I-2263

(ucs-set-char #x4E23 ?$(J#5(B) ; C04-J-2335
(ucs-set-char #x4E23 ?$(D0'(B) ; J90-D-3027

(ucs-set-char #x4E24 ?$AA=(B) ; GB0-A-413D
(ucs-set-char #x4E24 ?$(I$?(B) ; C03-I-243F
(ucs-set-char #x4E24 ?$(D0((B) ; J90-D-3028

(ucs-set-char #x4E25 ?$AQO(B) ; GB0-A-514F

(ucs-set-char #x4E26 ?$(GKd(B) ; C01-G-4B64
(ucs-set-char #x4E26 ?$@JB(B) ; J78-@-4A42
(ucs-set-char #x4E26 ?$BJB(B) ; J83-B-4A42

(ucs-set-char #x4E27 ?$AI%(B) ; GB0-A-4925


;;; R002 (vertical)

(ucs-set-char #x4E28 ?$AX-(B) ; GB0-A-582D
(ucs-set-char #x4E28 ?$(I!!(B) ; C03-I-2121
(ucs-set-char #x4E28 ?$(D0)(B) ; J90-D-3029

(ucs-set-char #x4E29 ?$(J!'(B) ; C04-J-2127

(ucs-set-char #x4E2A ?$A8v(B) ; GB0-A-3876
(ucs-set-char #x4E2A ?$(I!,(B) ; C03-I-212C
(ucs-set-char #x4E2A ?$@P$(B) ; J78-@-5024
(ucs-set-char #x4E2A ?$BP$(B) ; J83-B-5024

(ucs-set-char #x4E2B ?$(GD9(B) ; C01-G-4439
(ucs-set-char #x4E2B ?$(D0*(B) ; J90-D-302A

(ucs-set-char #x4E2B ?$AQ>(B) ; GB0-A-513E

(ucs-set-char #x4E2C ?$Ac\(B) ; GB0-A-635C

(ucs-set-char #x4E2D ?$AVP(B) ; GB0-A-5650
(ucs-set-char #x4E2D ?$(Cqi(B) ; KS0-C-7169
(ucs-set-char #x4E2D ?$(GDc(B) ; C01-G-4463
(ucs-set-char #x4E2D ?$@Cf(B) ; J78-@-4366
(ucs-set-char #x4E2D ?$BCf(B) ; J83-B-4366

(ucs-set-char #x4E2E ?$(H!0(B) ; C02-H-2130
(ucs-set-char #x4E2E ?$(D0+(B) ; J90-D-302B

(ucs-set-char #x4E2F ?$(J!:(B) ; C04-J-213A
(ucs-set-char #x4E2F ?$(D0,(B) ; J90-D-302C

(ucs-set-char #x4E30 ?$(GDd(B) ; C01-G-4464
(ucs-set-char #x4E30 ?$A7a(B) ; GB0-A-3761
(ucs-set-char #x4E30 ?$(D0-(B) ; J90-D-302D

(ucs-set-char #x4E31 ?$(H!C(B) ; C02-H-2143
(ucs-set-char #x4E31 ?$@P%(B) ; J78-@-5025
(ucs-set-char #x4E31 ?$BP%(B) ; J83-B-5025

(ucs-set-char #x4E32 ?$A4.(B) ; GB0-A-342E
(ucs-set-char #x4E32 ?$(CMz(B) ; KS0-C-4D7A
(ucs-set-char #x4E32 ?$(GHk(B) ; C01-G-486B
(ucs-set-char #x4E32 ?$@6z(B) ; J78-@-367A
(ucs-set-char #x4E32 ?$B6z(B) ; J83-B-367A

(ucs-set-char #x4E33 ?$(H%1(B) ; C02-H-2531

(ucs-set-char #x4E34 ?$AAY(B) ; GB0-A-4159

(ucs-set-char #x4E35 ?$(D0.(B) ; J90-D-302E

(ucs-set-char #x4E35 ?$(J+^(B) ; C04-J-2B5E


;;; R003 (dot)

(ucs-set-char #x4E36 ?$AX<(B) ; GB0-A-583C
(ucs-set-char #x4E36 ?$(I!"(B) ; C03-I-2122
(ucs-set-char #x4E36 ?$@P&(B) ; J78-@-5026
(ucs-set-char #x4E36 ?$BP&(B) ; J83-B-5026

(ucs-set-char #x4E38 ?$AMh(B) ; GB0-A-4D68
(ucs-set-char #x4E38 ?$(C|/(B) ; KS0-C-7C2F
(ucs-set-char #x4E38 ?$(L!1(B) ; C06-L-2131
(ucs-set-char #x4E38 ?$@4](B) ; J78-@-345D
(ucs-set-char #x4E38 ?$B4](B) ; J83-B-345D
;;(ucs-set-char #x4E38 ?$(GD:(B) ; C01-G-443A

(ucs-set-char #x4E39 ?$A5$(B) ; GB0-A-3524
(ucs-set-char #x4E39 ?$(CS!(B) ; KS0-C-5321
(ucs-set-char #x4E39 ?$(GDe(B) ; C01-G-4465
(ucs-set-char #x4E39 ?$@C0(B) ; J78-@-4330
(ucs-set-char #x4E39 ?$BC0(B) ; J83-B-4330

(ucs-set-char #x4E3A ?$AN*(B) ; GB0-A-4E2A

(ucs-set-char #x4E3B ?$AVw(B) ; GB0-A-5677
(ucs-set-char #x4E3B ?$(Cq+(B) ; KS0-C-712B
(ucs-set-char #x4E3B ?$(GEd(B) ; C01-G-4564
(ucs-set-char #x4E3B ?$@<g(B) ; J78-@-3C67
(ucs-set-char #x4E3B ?$B<g(B) ; J83-B-3C67

(ucs-set-char #x4E3C ?$(H!D(B) ; C02-H-2144
(ucs-set-char #x4E3C ?$@P'(B) ; J78-@-5027
(ucs-set-char #x4E3C ?$BP'(B) ; J83-B-5027

(ucs-set-char #x4E3D ?$A@v(B) ; GB0-A-4076
(ucs-set-char #x4E3D ?$(I'@(B) ; C03-I-2740

(ucs-set-char #x4E3E ?$A>Y(B) ; GB0-A-3E59


;;; R004 (diagonal)

(ucs-set-char #x4E3F ?$AX/(B) ; GB0-A-582F
(ucs-set-char #x4E3F ?$(I!#(B) ; C03-I-2123
(ucs-set-char #x4E3F ?$@P((B) ; J78-@-5028
(ucs-set-char #x4E3F ?$BP((B) ; J83-B-5028

(ucs-set-char #x4E40 ?$(J!"(B) ; C04-J-2122
(ucs-set-char #x4E40 ?$(D0/(B) ; J90-D-302F

(ucs-set-char #x4E41 ?$(J!#(B) ; C04-J-2123
(ucs-set-char #x4E41 ?$(D00(B) ; J90-D-3030

(ucs-set-char #x4E42 ?$(H!!(B) ; C02-H-2121
(ucs-set-char #x4E42 ?$(CgQ(B) ; KS0-C-6751
(ucs-set-char #x4E42 ?$@P)(B) ; J78-@-5029
(ucs-set-char #x4E42 ?$BP)(B) ; J83-B-5029

(ucs-set-char #x4E43 ?$ADK(B) ; GB0-A-444B
(ucs-set-char #x4E43 ?$(CR,(B) ; KS0-C-522C
(ucs-set-char #x4E43 ?$(GD%(B) ; C01-G-4425
(ucs-set-char #x4E43 ?$@G5(B) ; J78-@-4735
(ucs-set-char #x4E43 ?$BG5(B) ; J83-B-4735

(ucs-set-char #x4E44 ?$(L!#(B) ; C06-L-2123
(ucs-set-char #x4E44 ?$(D01(B) ; J90-D-3031

(ucs-set-char #x4E45 ?$A>C(B) ; GB0-A-3E43
(ucs-set-char #x4E45 ?$(CNy(B) ; KS0-C-4E79
(ucs-set-char #x4E45 ?$(GD<(B) ; C01-G-443C
(ucs-set-char #x4E45 ?$@5W(B) ; J78-@-3557
(ucs-set-char #x4E45 ?$B5W(B) ; J83-B-3557

(ucs-set-char #x4E46 ?$(I!0(B) ; C03-I-2130

(ucs-set-char #x4E47 ?$AX1(B) ; GB0-A-5831
(ucs-set-char #x4E47 ?$(H!((B) ; C02-H-2128
(ucs-set-char #x4E47 ?$(D02(B) ; J90-D-3032

(ucs-set-char #x4E48 ?$AC4(B) ; GB0-A-4334
(ucs-set-char #x4E48 ?$(GD=(B) ; C01-G-443D

(ucs-set-char #x4E49 ?$ARe(B) ; GB0-A-5265
(ucs-set-char #x4E49 ?$(I!.(B) ; C03-I-212E

(ucs-set-char #x4E4B ?$AV.(B) ; GB0-A-562E
(ucs-set-char #x4E4B ?$(Cq}(B) ; KS0-C-717D
(ucs-set-char #x4E4B ?$(GDf(B) ; C01-G-4466
(ucs-set-char #x4E4B ?$@G7(B) ; J78-@-4737
(ucs-set-char #x4E4B ?$BG7(B) ; J83-B-4737

(ucs-set-char #x4E4C ?$ANZ(B) ; GB0-A-4E5A

(ucs-set-char #x4E4D ?$AU'(B) ; GB0-A-5527
(ucs-set-char #x4E4D ?$(C^?(B) ; KS0-C-5E3F
(ucs-set-char #x4E4D ?$(GEe(B) ; C01-G-4565
(ucs-set-char #x4E4D ?$@Fc(B) ; J78-@-4663
(ucs-set-char #x4E4D ?$BFc(B) ; J83-B-4663

(ucs-set-char #x4E4E ?$A:u(B) ; GB0-A-3A75
(ucs-set-char #x4E4E ?$(C{:(B) ; KS0-C-7B3A
(ucs-set-char #x4E4E ?$(GEg(B) ; C01-G-4567
(ucs-set-char #x4E4E ?$@8C(B) ; J78-@-3843
(ucs-set-char #x4E4E ?$B8C(B) ; J83-B-3843

(ucs-set-char #x4E4F ?$A7&(B) ; GB0-A-3726
(ucs-set-char #x4E4F ?$(GEf(B) ; C01-G-4566
(ucs-set-char #x4E4F ?$(Cy9(B) ; KS0-C-7939
(ucs-set-char #x4E4F ?$@K3(B) ; J78-@-4B33
(ucs-set-char #x4E4F ?$BK3(B) ; J83-B-4B33

(ucs-set-char #x4E50 ?$A@V(B) ; GB0-A-4056

(ucs-set-char #x4E51 ?$(J"'(B) ; C04-J-2227
(ucs-set-char #x4E51 ?$(D03(B) ; J90-D-3033

(ucs-set-char #x4E52 ?$AF9(B) ; GB0-A-4639
(ucs-set-char #x4E52 ?$(GG$(B) ; C01-G-4724

(ucs-set-char #x4E53 ?$AER(B) ; GB0-A-4552
(ucs-set-char #x4E53 ?$(GG%(B) ; C01-G-4725

(ucs-set-char #x4E54 ?$AGG(B) ; GB0-A-4747
(ucs-set-char #x4E54 ?$(I#E(B) ; C03-I-2345

(ucs-set-char #x4E55 ?$@iI(B) ; J78-@-6949
(ucs-set-char #x4E55 ?$BiI(B) ; J83-B-6949

(ucs-set-char #x4E56 ?$A9T(B) ; GB0-A-3954
(ucs-set-char #x4E56 ?$(CNR(B) ; KS0-C-4E52
(ucs-set-char #x4E56 ?$(GKe(B) ; C01-G-4B65
(ucs-set-char #x4E56 ?$@P*(B) ; J78-@-502A
(ucs-set-char #x4E56 ?$BP*(B) ; J83-B-502A

(ucs-set-char #x4E57 ?$(I+"(B) ; C03-I-2B22
(ucs-set-char #x4E57 ?$@>h(B) ; J78-@-3E68
(ucs-set-char #x4E57 ?$B>h(B) ; J83-B-3E68

(ucs-set-char #x4E58 ?$A3K(B) ; GB0-A-334B
(ucs-set-char #x4E58 ?$(Cc+(B) ; KS0-C-632B
(ucs-set-char #x4E58 ?$(GS}(B) ; C01-G-537D
(ucs-set-char #x4E58 ?$@P+(B) ; J78-@-502B
(ucs-set-char #x4E58 ?$BP+(B) ; J83-B-502B


;;; R005 (carve)

(ucs-set-char #x4E59 ?$ARR(B) ; GB0-A-5252
(ucs-set-char #x4E59 ?$(Ck`(B) ; KS0-C-6B60
(ucs-set-char #x4E59 ?$(GD"(B) ; C01-G-4422
(ucs-set-char #x4E59 ?$@25(B) ; J78-@-3235
(ucs-set-char #x4E59 ?$B25(B) ; J83-B-3235

(ucs-set-char #x4E5A ?$(J!$(B) ; C04-J-2124
(ucs-set-char #x4E5A ?$(D04(B) ; J90-D-3034

(ucs-set-char #x4E5C ?$AX?(B) ; GB0-A-583F
(ucs-set-char #x4E5C ?$(H!"(B) ; C02-H-2122
(ucs-set-char #x4E5C ?$(D05(B) ; J90-D-3035

(ucs-set-char #x4E5D ?$(CNz(B) ; KS0-C-4E7A
(ucs-set-char #x4E5D ?$(GD&(B) ; C01-G-4426
(ucs-set-char #x4E5D ?$@6e(B) ; J78-@-3665
(ucs-set-char #x4E5D ?$A>E(B) ; GB0-A-3E45
(ucs-set-char #x4E5D ?$B6e(B) ; J83-B-3665
(ucs-set-char #x4E5E ?$(CKw(B) ; KS0-C-4B77
(ucs-set-char #x4E5E ?$(GD?(B) ; C01-G-443F
(ucs-set-char #x4E5E ?$@8p(B) ; J78-@-3870
(ucs-set-char #x4E5E ?$AFr(B) ; GB0-A-4672
(ucs-set-char #x4E5E ?$B8p(B) ; J83-B-3870
(ucs-set-char #x4E5F ?$(Ce%(B) ; KS0-C-6525
(ucs-set-char #x4E5F ?$(GD>(B) ; C01-G-443E
(ucs-set-char #x4E5F ?$@Li(B) ; J78-@-4C69
(ucs-set-char #x4E5F ?$AR2(B) ; GB0-A-5232
(ucs-set-char #x4E5F ?$BLi(B) ; J83-B-4C69
(ucs-set-char #x4E60 ?$AO0(B) ; GB0-A-4F30
(ucs-set-char #x4E61 ?$AOg(B) ; GB0-A-4F67
(ucs-set-char #x4E62 ?$(I!F(B) ; C03-I-2146
(ucs-set-char #x4E62 ?$@V&(B) ; J78-@-5626
(ucs-set-char #x4E62 ?$BV&(B) ; J83-B-5626
(ucs-set-char #x4E63 ?$(D06(B) ; J90-D-3036
(ucs-set-char #x4E63 ?$(I!E(B) ; C03-I-2145
(ucs-set-char #x4E66 ?$AJi(B) ; GB0-A-4A69
(ucs-set-char #x4E68 ?$(D07(B) ; J90-D-3037
(ucs-set-char #x4E68 ?$(I"d(B) ; C03-I-2264
(ucs-set-char #x4E69 ?$(D08(B) ; J90-D-3038
(ucs-set-char #x4E69 ?$(GG&(B) ; C01-G-4726
(ucs-set-char #x4E69 ?$AX@(B) ; GB0-A-5840
(ucs-set-char #x4E6A ?$(J"((B) ; C04-J-2228
(ucs-set-char #x4E6B ?$(CJa(B) ; KS0-C-4A61
(ucs-set-char #x4E6D ?$(CTL(B) ; KS0-C-544C
(ucs-set-char #x4E70 ?$ABr(B) ; GB0-A-4272
(ucs-set-char #x4E71 ?$(I$@(B) ; C03-I-2440
(ucs-set-char #x4E71 ?$@Mp(B) ; J78-@-4D70
(ucs-set-char #x4E71 ?$ABR(B) ; GB0-A-4252
(ucs-set-char #x4E71 ?$BMp(B) ; J83-B-4D70
(ucs-set-char #x4E73 ?$(Cja(B) ; KS0-C-6A61
(ucs-set-char #x4E73 ?$(GKf(B) ; C01-G-4B66
(ucs-set-char #x4E73 ?$@F}(B) ; J78-@-467D
(ucs-set-char #x4E73 ?$AHi(B) ; GB0-A-4869
(ucs-set-char #x4E73 ?$BF}(B) ; J83-B-467D
(ucs-set-char #x4E74 ?$(D09(B) ; J90-D-3039
(ucs-set-char #x4E74 ?$(J%1(B) ; C04-J-2531
(ucs-set-char #x4E75 ?$(D0:(B) ; J90-D-303A
(ucs-set-char #x4E75 ?$(J%0(B) ; C04-J-2530
(ucs-set-char #x4E76 ?$(C\c(B) ; KS0-C-5C63
(ucs-set-char #x4E77 ?$(C_-(B) ; KS0-C-5F2D
(ucs-set-char #x4E79 ?$(D0;(B) ; J90-D-303B
(ucs-set-char #x4E79 ?$(I+#(B) ; C03-I-2B23
(ucs-set-char #x4E7E ?$(CKk(B) ; KS0-C-4B6B
(ucs-set-char #x4E7E ?$(GXq(B) ; C01-G-5871
(ucs-set-char #x4E7E ?$@4%(B) ; J78-@-3425
(ucs-set-char #x4E7E ?$AG,(B) ; GB0-A-472C
(ucs-set-char #x4E7E ?$B4%(B) ; J83-B-3425
(ucs-set-char #x4E7F ?$(D0<(B) ; J90-D-303C
(ucs-set-char #x4E7F ?$(H3N(B) ; C02-H-334E
(ucs-set-char #x4E80 ?$(I9l(B) ; C03-I-396C
(ucs-set-char #x4E80 ?$@55(B) ; J78-@-3535
(ucs-set-char #x4E80 ?$B55(B) ; J83-B-3535
(ucs-set-char #x4E81 ?$(I9n(B) ; C03-I-396E
(ucs-set-char #x4E82 ?$(CU/(B) ; KS0-C-552F
(ucs-set-char #x4E82 ?$(Gc*(B) ; C01-G-632A
(ucs-set-char #x4E82 ?$@P,(B) ; J78-@-502C
(ucs-set-char #x4E82 ?$BP,(B) ; J83-B-502C
(ucs-set-char #x4E83 ?$(HAV(B) ; C02-H-4156
(ucs-set-char #x4E84 ?$(HAW(B) ; C02-H-4157

(ucs-set-char #x4E85 ?$(I!$(B) ; C03-I-2124
(ucs-set-char #x4E85 ?$@P-(B) ; J78-@-502D
(ucs-set-char #x4E85 ?$BP-(B) ; J83-B-502D

(ucs-set-char #x4E86 ?$(CVu(B) ; KS0-C-5675
(ucs-set-char #x4E86 ?$(GD'(B) ; C01-G-4427
(ucs-set-char #x4E86 ?$@N;(B) ; J78-@-4E3B
(ucs-set-char #x4E86 ?$AAK(B) ; GB0-A-414B
(ucs-set-char #x4E86 ?$BN;(B) ; J83-B-4E3B
(ucs-set-char #x4E87 ?$(I!-(B) ; C03-I-212D
(ucs-set-char #x4E88 ?$(Cex(B) ; KS0-C-6578
(ucs-set-char #x4E88 ?$(GDh(B) ; C01-G-4468
(ucs-set-char #x4E88 ?$@M=(B) ; J78-@-4D3D
(ucs-set-char #x4E88 ?$ASh(B) ; GB0-A-5368
(ucs-set-char #x4E88 ?$BM=(B) ; J83-B-4D3D
(ucs-set-char #x4E89 ?$(I"e(B) ; C03-I-2265
(ucs-set-char #x4E89 ?$@Ah(B) ; J78-@-4168
(ucs-set-char #x4E89 ?$AUy(B) ; GB0-A-5579
(ucs-set-char #x4E89 ?$BAh(B) ; J83-B-4168
(ucs-set-char #x4E8A ?$@P/(B) ; J78-@-502F
(ucs-set-char #x4E8A ?$BP/(B) ; J83-B-502F
(ucs-set-char #x4E8B ?$(C^@(B) ; KS0-C-5E40
(ucs-set-char #x4E8B ?$(GKg(B) ; C01-G-4B67
(ucs-set-char #x4E8B ?$@;v(B) ; J78-@-3B76
(ucs-set-char #x4E8B ?$AJB(B) ; GB0-A-4A42
(ucs-set-char #x4E8B ?$B;v(B) ; J83-B-3B76

(ucs-set-char #x4E8C ?$A6~(B) ; GB0-A-367E
(ucs-set-char #x4E8C ?$(Cl#(B) ; KS0-C-6C23
(ucs-set-char #x4E8C ?$(GD((B) ; C01-G-4428
(ucs-set-char #x4E8C ?$@Fs(B) ; J78-@-4673
(ucs-set-char #x4E8C ?$BFs(B) ; J83-B-4673

(ucs-set-char #x4E8D ?$(D0=(B) ; J90-D-303D
(ucs-set-char #x4E8D ?$(H!)(B) ; C02-H-2129
(ucs-set-char #x4E8D ?$AX!(B) ; GB0-A-5821
(ucs-set-char #x4E8E ?$(CiM(B) ; KS0-C-694D
(ucs-set-char #x4E8E ?$(GD@(B) ; C01-G-4440
(ucs-set-char #x4E8E ?$@P2(B) ; J78-@-5032
(ucs-set-char #x4E8E ?$ASZ(B) ; GB0-A-535A
(ucs-set-char #x4E8E ?$BP2(B) ; J83-B-5032
(ucs-set-char #x4E8F ?$(I!1(B) ; C03-I-2131
(ucs-set-char #x4E8F ?$A?w(B) ; GB0-A-3F77
(ucs-set-char #x4E90 ?$(Cj'(B) ; KS0-C-6A27
(ucs-set-char #x4E91 ?$(Civ(B) ; KS0-C-6976
(ucs-set-char #x4E91 ?$(GDi(B) ; C01-G-4469
(ucs-set-char #x4E91 ?$@1>(B) ; J78-@-313E
(ucs-set-char #x4E91 ?$ATF(B) ; GB0-A-5446
(ucs-set-char #x4E91 ?$B1>(B) ; J83-B-313E
(ucs-set-char #x4E92 ?$(C{;(B) ; KS0-C-7B3B
(ucs-set-char #x4E92 ?$(GDk(B) ; C01-G-446B
(ucs-set-char #x4E92 ?$@8_(B) ; J78-@-385F
(ucs-set-char #x4E92 ?$A;%(B) ; GB0-A-3B25
(ucs-set-char #x4E92 ?$B8_(B) ; J83-B-385F
(ucs-set-char #x4E93 ?$(H!1(B) ; C02-H-2131
(ucs-set-char #x4E93 ?$AXA(B) ; GB0-A-5841
(ucs-set-char #x4E94 ?$(Cgi(B) ; KS0-C-6769
(ucs-set-char #x4E94 ?$(GDl(B) ; C01-G-446C
(ucs-set-char #x4E94 ?$@8^(B) ; J78-@-385E
(ucs-set-char #x4E94 ?$ANe(B) ; GB0-A-4E65
(ucs-set-char #x4E94 ?$B8^(B) ; J83-B-385E
(ucs-set-char #x4E95 ?$(CoL(B) ; KS0-C-6F4C
(ucs-set-char #x4E95 ?$(GDj(B) ; C01-G-446A
(ucs-set-char #x4E95 ?$@0f(B) ; J78-@-3066
(ucs-set-char #x4E95 ?$A>.(B) ; GB0-A-3E2E
(ucs-set-char #x4E95 ?$B0f(B) ; J83-B-3066
(ucs-set-char #x4E96 ?$(D0>(B) ; J90-D-303E
(ucs-set-char #x4E96 ?$(J!;(B) ; C04-J-213B
(ucs-set-char #x4E97 ?$(D0?(B) ; J90-D-303F
(ucs-set-char #x4E97 ?$(I!l(B) ; C03-I-216C
(ucs-set-char #x4E98 ?$(CPf(B) ; KS0-C-5066
(ucs-set-char #x4E98 ?$(I"f(B) ; C03-I-2266
(ucs-set-char #x4E98 ?$@OK(B) ; J78-@-4F4B
(ucs-set-char #x4E98 ?$AX((B) ; GB0-A-5828
(ucs-set-char #x4E98 ?$BOK(B) ; J83-B-4F4B
(ucs-set-char #x4E99 ?$(GG'(B) ; C01-G-4727
(ucs-set-char #x4E99 ?$@OJ(B) ; J78-@-4F4A
(ucs-set-char #x4E99 ?$BOJ(B) ; J83-B-4F4A
(ucs-set-char #x4E9A ?$AQG(B) ; GB0-A-5147
(ucs-set-char #x4E9B ?$(C^A(B) ; KS0-C-5E41
(ucs-set-char #x4E9B ?$(GKh(B) ; C01-G-4B68
(ucs-set-char #x4E9B ?$@:3(B) ; J78-@-3A33
(ucs-set-char #x4E9B ?$AP)(B) ; GB0-A-5029
(ucs-set-char #x4E9B ?$B:3(B) ; J83-B-3A33
(ucs-set-char #x4E9C ?$(I$B(B) ; C03-I-2442
(ucs-set-char #x4E9C ?$@0!(B) ; J78-@-3021
(ucs-set-char #x4E9C ?$B0!(B) ; J83-B-3021
(ucs-set-char #x4E9D ?$(D0@(B) ; J90-D-3040
(ucs-set-char #x4E9D ?$(I'B(B) ; C03-I-2742
(ucs-set-char #x4E9E ?$(Cd,(B) ; KS0-C-642C
(ucs-set-char #x4E9E ?$(GKi(B) ; C01-G-4B69
(ucs-set-char #x4E9E ?$@P3(B) ; J78-@-5033
(ucs-set-char #x4E9E ?$BP3(B) ; J83-B-5033
(ucs-set-char #x4E9F ?$(GOg(B) ; C01-G-4F67
(ucs-set-char #x4E9F ?$@P4(B) ; J78-@-5034
(ucs-set-char #x4E9F ?$AX=(B) ; GB0-A-583D
(ucs-set-char #x4E9F ?$BP4(B) ; J83-B-5034

(ucs-set-char #x4EA0 ?$AYo(B) ; GB0-A-596F
(ucs-set-char #x4EA0 ?$@P5(B) ; J78-@-5035
(ucs-set-char #x4EA0 ?$BP5(B) ; J83-B-5035

(ucs-set-char #x4EA1 ?$(CXL(B) ; KS0-C-584C
(ucs-set-char #x4EA1 ?$(GDA(B) ; C01-G-4441
(ucs-set-char #x4EA1 ?$@K4(B) ; J78-@-4B34
(ucs-set-char #x4EA1 ?$AMv(B) ; GB0-A-4D76
(ucs-set-char #x4EA1 ?$BK4(B) ; J83-B-4B34
(ucs-set-char #x4EA2 ?$(Cyq(B) ; KS0-C-7971
(ucs-set-char #x4EA2 ?$(GDm(B) ; C01-G-446D
(ucs-set-char #x4EA2 ?$@P6(B) ; J78-@-5036
(ucs-set-char #x4EA2 ?$A?:(B) ; GB0-A-3F3A
(ucs-set-char #x4EA2 ?$BP6(B) ; J83-B-5036
(ucs-set-char #x4EA3 ?$(I!G(B) ; C03-I-2147
(ucs-set-char #x4EA4 ?$(CN_(B) ; KS0-C-4E5F
(ucs-set-char #x4EA4 ?$(GG((B) ; C01-G-4728
(ucs-set-char #x4EA4 ?$@8r(B) ; J78-@-3872
(ucs-set-char #x4EA4 ?$A=;(B) ; GB0-A-3D3B
(ucs-set-char #x4EA4 ?$B8r(B) ; J83-B-3872
(ucs-set-char #x4EA5 ?$(Cz$(B) ; KS0-C-7A24
(ucs-set-char #x4EA5 ?$(GG*(B) ; C01-G-472A
(ucs-set-char #x4EA5 ?$@0g(B) ; J78-@-3067
(ucs-set-char #x4EA5 ?$A:%(B) ; GB0-A-3A25
(ucs-set-char #x4EA5 ?$B0g(B) ; J83-B-3067
(ucs-set-char #x4EA6 ?$(Cf2(B) ; KS0-C-6632
(ucs-set-char #x4EA6 ?$(GG)(B) ; C01-G-4729
(ucs-set-char #x4EA6 ?$@Kr(B) ; J78-@-4B72
(ucs-set-char #x4EA6 ?$AR`(B) ; GB0-A-5260
(ucs-set-char #x4EA6 ?$BKr(B) ; J83-B-4B72
(ucs-set-char #x4EA7 ?$A2z(B) ; GB0-A-327A
(ucs-set-char #x4EA8 ?$(Cz{(B) ; KS0-C-7A7B
(ucs-set-char #x4EA8 ?$(GHl(B) ; C01-G-486C
(ucs-set-char #x4EA8 ?$@5|(B) ; J78-@-357C
(ucs-set-char #x4EA8 ?$A:`(B) ; GB0-A-3A60
(ucs-set-char #x4EA8 ?$B5|(B) ; J83-B-357C
(ucs-set-char #x4EA9 ?$AD6(B) ; GB0-A-4436
(ucs-set-char #x4EAB ?$(Cz=(B) ; KS0-C-7A3D
(ucs-set-char #x4EAB ?$(GKj(B) ; C01-G-4B6A
(ucs-set-char #x4EAB ?$@5}(B) ; J78-@-357D
(ucs-set-char #x4EAB ?$AOm(B) ; GB0-A-4F6D
(ucs-set-char #x4EAB ?$B5}(B) ; J83-B-357D
(ucs-set-char #x4EAC ?$(CLH(B) ; KS0-C-4C48
(ucs-set-char #x4EAC ?$(GKk(B) ; C01-G-4B6B
(ucs-set-char #x4EAC ?$@5~(B) ; J78-@-357E
(ucs-set-char #x4EAC ?$A>)(B) ; GB0-A-3E29
(ucs-set-char #x4EAC ?$B5~(B) ; J83-B-357E
(ucs-set-char #x4EAD ?$(CoM(B) ; KS0-C-6F4D
(ucs-set-char #x4EAD ?$(GOh(B) ; C01-G-4F68
(ucs-set-char #x4EAD ?$@Db(B) ; J78-@-4462
(ucs-set-char #x4EAD ?$AM$(B) ; GB0-A-4D24
(ucs-set-char #x4EAD ?$BDb(B) ; J83-B-4462
(ucs-set-char #x4EAE ?$(CUU(B) ; KS0-C-5555
(ucs-set-char #x4EAE ?$(GOi(B) ; C01-G-4F69
(ucs-set-char #x4EAE ?$@N<(B) ; J78-@-4E3C
(ucs-set-char #x4EAE ?$AAA(B) ; GB0-A-4141
(ucs-set-char #x4EAE ?$BN<(B) ; J83-B-4E3C
(ucs-set-char #x4EAF ?$(D0A(B) ; J90-D-3041
(ucs-set-char #x4EAF ?$(I+&(B) ; C03-I-2B26
(ucs-set-char #x4EB0 ?$(I+%(B) ; C03-I-2B25
(ucs-set-char #x4EB0 ?$@P7(B) ; J78-@-5037
(ucs-set-char #x4EB0 ?$BP7(B) ; J83-B-5037
(ucs-set-char #x4EB1 ?$(I+'(B) ; C03-I-2B27
(ucs-set-char #x4EB2 ?$(I+$(B) ; C03-I-2B24
(ucs-set-char #x4EB2 ?$AGW(B) ; GB0-A-4757
(ucs-set-char #x4EB3 ?$(GS~(B) ; C01-G-537E
(ucs-set-char #x4EB3 ?$@P8(B) ; J78-@-5038
(ucs-set-char #x4EB3 ?$AYq(B) ; GB0-A-5971
(ucs-set-char #x4EB3 ?$BP8(B) ; J83-B-5038
(ucs-set-char #x4EB4 ?$(J6.(B) ; C04-J-362E
(ucs-set-char #x4EB5 ?$AYt(B) ; GB0-A-5974
(ucs-set-char #x4EB6 ?$(CS"(B) ; KS0-C-5322
(ucs-set-char #x4EB6 ?$(HAX(B) ; C02-H-4158
(ucs-set-char #x4EB6 ?$@P9(B) ; J78-@-5039
(ucs-set-char #x4EB6 ?$BP9(B) ; J83-B-5039
(ucs-set-char #x4EB7 ?$(I@3(B) ; C03-I-4033
(ucs-set-char #x4EB9 ?$(D0B(B) ; J90-D-3042
(ucs-set-char #x4EB9 ?$(HmD(B) ; C02-H-6D44

(ucs-set-char #x4EBA ?$AHK(B) ; GB0-A-484B
(ucs-set-char #x4EBA ?$(ClQ(B) ; KS0-C-6C51
(ucs-set-char #x4EBA ?$(GD)(B) ; C01-G-4429
(ucs-set-char #x4EBA ?$@?M(B) ; J78-@-3F4D
(ucs-set-char #x4EBA ?$B?M(B) ; J83-B-3F4D

(ucs-set-char #x4EBB ?$AXi(B) ; GB0-A-5869
(ucs-set-char #x4EBC ?$(I!2(B) ; C03-I-2132
(ucs-set-char #x4EBE ?$(I!3(B) ; C03-I-2133
(ucs-set-char #x4EBF ?$ARZ(B) ; GB0-A-525A
(ucs-set-char #x4EC0 ?$(Cd'(B) ; KS0-C-6427
(ucs-set-char #x4EC0 ?$(GDo(B) ; C01-G-446F
(ucs-set-char #x4EC0 ?$@=:(B) ; J78-@-3D3A
(ucs-set-char #x4EC0 ?$AJ2(B) ; GB0-A-4A32
(ucs-set-char #x4EC0 ?$B=:(B) ; J83-B-3D3A
(ucs-set-char #x4EC1 ?$(ClR(B) ; KS0-C-6C52
(ucs-set-char #x4EC1 ?$(GDn(B) ; C01-G-446E
(ucs-set-char #x4EC1 ?$@?N(B) ; J78-@-3F4E
(ucs-set-char #x4EC1 ?$AHJ(B) ; GB0-A-484A
(ucs-set-char #x4EC1 ?$B?N(B) ; J83-B-3F4E
(ucs-set-char #x4EC2 ?$(H!2(B) ; C02-H-2132
(ucs-set-char #x4EC2 ?$@P>(B) ; J78-@-503E
(ucs-set-char #x4EC2 ?$AXl(B) ; GB0-A-586C
(ucs-set-char #x4EC2 ?$BP>(B) ; J83-B-503E
(ucs-set-char #x4EC3 ?$(D0C(B) ; J90-D-3043
(ucs-set-char #x4EC3 ?$(GDp(B) ; C01-G-4470
(ucs-set-char #x4EC3 ?$AXj(B) ; GB0-A-586A
(ucs-set-char #x4EC4 ?$(Cv1(B) ; KS0-C-7631
(ucs-set-char #x4EC4 ?$(GDv(B) ; C01-G-4476
(ucs-set-char #x4EC4 ?$@P<(B) ; J78-@-503C
(ucs-set-char #x4EC4 ?$AXF(B) ; GB0-A-5846
(ucs-set-char #x4EC4 ?$BP<(B) ; J83-B-503C
(ucs-set-char #x4EC5 ?$(I!I(B) ; C03-I-2149
(ucs-set-char #x4EC5 ?$A=v(B) ; GB0-A-3D76
(ucs-set-char #x4EC6 ?$(GDq(B) ; C01-G-4471
(ucs-set-char #x4EC6 ?$@P=(B) ; J78-@-503D
(ucs-set-char #x4EC6 ?$AFM(B) ; GB0-A-464D
(ucs-set-char #x4EC6 ?$BP=(B) ; J83-B-503D
(ucs-set-char #x4EC7 ?$(CN{(B) ; KS0-C-4E7B
(ucs-set-char #x4EC7 ?$(GDr(B) ; C01-G-4472
(ucs-set-char #x4EC7 ?$@5X(B) ; J78-@-3558
(ucs-set-char #x4EC7 ?$A3p(B) ; GB0-A-3370
(ucs-set-char #x4EC7 ?$B5X(B) ; J83-B-3558
(ucs-set-char #x4EC8 ?$(H!4(B) ; C02-H-2134
(ucs-set-char #x4EC9 ?$(H!3(B) ; C02-H-2133
(ucs-set-char #x4EC9 ?$AXk(B) ; GB0-A-586B
(ucs-set-char #x4ECA ?$(CPQ(B) ; KS0-C-5051
(ucs-set-char #x4ECA ?$(GDt(B) ; C01-G-4474
(ucs-set-char #x4ECA ?$@:#(B) ; J78-@-3A23
(ucs-set-char #x4ECA ?$A=q(B) ; GB0-A-3D71
(ucs-set-char #x4ECA ?$B:#(B) ; J83-B-3A23
(ucs-set-char #x4ECB ?$(CK?(B) ; KS0-C-4B3F
(ucs-set-char #x4ECB ?$(GDu(B) ; C01-G-4475
(ucs-set-char #x4ECB ?$@2p(B) ; J78-@-3270
(ucs-set-char #x4ECB ?$A=i(B) ; GB0-A-3D69
(ucs-set-char #x4ECB ?$B2p(B) ; J83-B-3270
(ucs-set-char #x4ECC ?$(I!L(B) ; C03-I-214C
(ucs-set-char #x4ECC ?$(J!?(B) ; C04-J-213F
(ucs-set-char #x4ECD ?$(Cm$(B) ; KS0-C-6D24
(ucs-set-char #x4ECD ?$(GDs(B) ; C01-G-4473
(ucs-set-char #x4ECD ?$@P;(B) ; J78-@-503B
(ucs-set-char #x4ECD ?$AHT(B) ; GB0-A-4854
(ucs-set-char #x4ECD ?$BP;(B) ; J83-B-503B
(ucs-set-char #x4ECE ?$(I!K(B) ; C03-I-214B
(ucs-set-char #x4ECE ?$@P:(B) ; J78-@-503A
(ucs-set-char #x4ECE ?$A4S(B) ; GB0-A-3453
(ucs-set-char #x4ECE ?$BP:(B) ; J83-B-503A
(ucs-set-char #x4ECF ?$(I!J(B) ; C03-I-214A
(ucs-set-char #x4ECF ?$@J)(B) ; J78-@-4A29
(ucs-set-char #x4ECF ?$BJ)(B) ; J83-B-4A29
(ucs-set-char #x4ED0 ?$(D0D(B) ; J90-D-3044
(ucs-set-char #x4ED0 ?$(J!<(B) ; C04-J-213C
(ucs-set-char #x4ED1 ?$ABX(B) ; GB0-A-4258
(ucs-set-char #x4ED3 ?$A2V(B) ; GB0-A-3256
(ucs-set-char #x4ED4 ?$(Cm((B) ; KS0-C-6D28
(ucs-set-char #x4ED4 ?$(GEj(B) ; C01-G-456A
(ucs-set-char #x4ED4 ?$@;F(B) ; J78-@-3B46
(ucs-set-char #x4ED4 ?$AWP(B) ; GB0-A-5750
(ucs-set-char #x4ED4 ?$B;F(B) ; J83-B-3B46
(ucs-set-char #x4ED5 ?$(C^B(B) ; KS0-C-5E42
(ucs-set-char #x4ED5 ?$(GEk(B) ; C01-G-456B
(ucs-set-char #x4ED5 ?$@;E(B) ; J78-@-3B45
(ucs-set-char #x4ED5 ?$AJK(B) ; GB0-A-4A4B
(ucs-set-char #x4ED5 ?$B;E(B) ; J83-B-3B45
(ucs-set-char #x4ED6 ?$(Cvb(B) ; KS0-C-7662
(ucs-set-char #x4ED6 ?$(GEl(B) ; C01-G-456C
(ucs-set-char #x4ED6 ?$@B>(B) ; J78-@-423E
(ucs-set-char #x4ED6 ?$AK{(B) ; GB0-A-4B7B
(ucs-set-char #x4ED6 ?$BB>(B) ; J83-B-423E
(ucs-set-char #x4ED7 ?$(Cm\(B) ; KS0-C-6D5C
(ucs-set-char #x4ED7 ?$(GEm(B) ; C01-G-456D
(ucs-set-char #x4ED7 ?$@P?(B) ; J78-@-503F
(ucs-set-char #x4ED7 ?$AUL(B) ; GB0-A-554C
(ucs-set-char #x4ED7 ?$BP?(B) ; J83-B-503F
(ucs-set-char #x4ED8 ?$(C\u(B) ; KS0-C-5C75
(ucs-set-char #x4ED8 ?$(GEi(B) ; C01-G-4569
(ucs-set-char #x4ED8 ?$@IU(B) ; J78-@-4955
(ucs-set-char #x4ED8 ?$A86(B) ; GB0-A-3836
(ucs-set-char #x4ED8 ?$BIU(B) ; J83-B-4955
(ucs-set-char #x4ED9 ?$(C`9(B) ; KS0-C-6039
(ucs-set-char #x4ED9 ?$(GEp(B) ; C01-G-4570
(ucs-set-char #x4ED9 ?$@@g(B) ; J78-@-4067
(ucs-set-char #x4ED9 ?$AOI(B) ; GB0-A-4F49
(ucs-set-char #x4ED9 ?$B@g(B) ; J83-B-4067
(ucs-set-char #x4EDA ?$(D0E(B) ; J90-D-3045
(ucs-set-char #x4EDA ?$(H!J(B) ; C02-H-214A
(ucs-set-char #x4EDB ?$(D0F(B) ; J90-D-3046
(ucs-set-char #x4EDB ?$(J![(B) ; C04-J-215B
(ucs-set-char #x4EDC ?$(H!F(B) ; C02-H-2146
(ucs-set-char #x4EDD ?$(CTN(B) ; KS0-C-544E
(ucs-set-char #x4EDD ?$(H!I(B) ; C02-H-2149
(ucs-set-char #x4EDD ?$@!8(B) ; J78-@-2138
(ucs-set-char #x4EDD ?$AYZ(B) ; GB0-A-595A
(ucs-set-char #x4EDD ?$B!8(B) ; J83-B-2138
(ucs-set-char #x4EDE ?$(GEq(B) ; C01-G-4571
(ucs-set-char #x4EDE ?$@P@(B) ; J78-@-5040
(ucs-set-char #x4EDE ?$AXp(B) ; GB0-A-5870
(ucs-set-char #x4EDE ?$BP@(B) ; J83-B-5040
(ucs-set-char #x4EDF ?$(Ct5(B) ; KS0-C-7435
(ucs-set-char #x4EDF ?$(GF#(B) ; C01-G-4623
(ucs-set-char #x4EDF ?$@PB(B) ; J78-@-5042
(ucs-set-char #x4EDF ?$AG*(B) ; GB0-A-472A
(ucs-set-char #x4EDF ?$BPB(B) ; J83-B-5042
(ucs-set-char #x4EE0 ?$(D0G(B) ; J90-D-3047
(ucs-set-char #x4EE0 ?$(I!m(B) ; C03-I-216D
(ucs-set-char #x4EE1 ?$(D0H(B) ; J90-D-3048
(ucs-set-char #x4EE1 ?$(H!H(B) ; C02-H-2148
(ucs-set-char #x4EE1 ?$AXn(B) ; GB0-A-586E
(ucs-set-char #x4EE2 ?$(D0I(B) ; J90-D-3049
(ucs-set-char #x4EE2 ?$(J!Z(B) ; C04-J-215A
(ucs-set-char #x4EE3 ?$(CS[(B) ; KS0-C-535B
(ucs-set-char #x4EE3 ?$(GEn(B) ; C01-G-456E
(ucs-set-char #x4EE3 ?$@Be(B) ; J78-@-4265
(ucs-set-char #x4EE3 ?$A4z(B) ; GB0-A-347A
(ucs-set-char #x4EE3 ?$BBe(B) ; J83-B-4265
(ucs-set-char #x4EE4 ?$(CV5(B) ; KS0-C-5635
(ucs-set-char #x4EE4 ?$(GEo(B) ; C01-G-456F
(ucs-set-char #x4EE4 ?$@Na(B) ; J78-@-4E61
(ucs-set-char #x4EE4 ?$AAn(B) ; GB0-A-416E
(ucs-set-char #x4EE4 ?$BNa(B) ; J83-B-4E61
(ucs-set-char #x4EE5 ?$(Cl$(B) ; KS0-C-6C24
(ucs-set-char #x4EE5 ?$(GEh(B) ; C01-G-4568
(ucs-set-char #x4EE5 ?$@0J(B) ; J78-@-304A
(ucs-set-char #x4EE5 ?$ART(B) ; GB0-A-5254
(ucs-set-char #x4EE5 ?$B0J(B) ; J83-B-304A
(ucs-set-char #x4EE6 ?$(I!r(B) ; C03-I-2172
(ucs-set-char #x4EE7 ?$(I!p(B) ; C03-I-2170
(ucs-set-char #x4EE8 ?$(D0J(B) ; J90-D-304A
(ucs-set-char #x4EE8 ?$(H!E(B) ; C02-H-2145
(ucs-set-char #x4EE8 ?$AXm(B) ; GB0-A-586D
(ucs-set-char #x4EE9 ?$(H!G(B) ; C02-H-2147
(ucs-set-char #x4EEA ?$ARG(B) ; GB0-A-5247
(ucs-set-char #x4EEB ?$AXo(B) ; GB0-A-586F
(ucs-set-char #x4EEC ?$ACG(B) ; GB0-A-4347
(ucs-set-char #x4EED ?$@PA(B) ; J78-@-5041
(ucs-set-char #x4EED ?$BPA(B) ; J83-B-5041
(ucs-set-char #x4EEE ?$(I"o(B) ; C03-I-226F
(ucs-set-char #x4EEE ?$@2>(B) ; J78-@-323E
(ucs-set-char #x4EEE ?$B2>(B) ; J83-B-323E
(ucs-set-char #x4EEF ?$(D0K(B) ; J90-D-304B
(ucs-set-char #x4EEF ?$(I"h(B) ; C03-I-2268
(ucs-set-char #x4EF0 ?$(Cdf(B) ; KS0-C-6466
(ucs-set-char #x4EF0 ?$(GG7(B) ; C01-G-4737
(ucs-set-char #x4EF0 ?$@6D(B) ; J78-@-3644
(ucs-set-char #x4EF0 ?$AQv(B) ; GB0-A-5176
(ucs-set-char #x4EF0 ?$B6D(B) ; J83-B-3644
(ucs-set-char #x4EF1 ?$(D0L(B) ; J90-D-304C
(ucs-set-char #x4EF1 ?$(H!o(B) ; C02-H-216F
(ucs-set-char #x4EF2 ?$(Cqj(B) ; KS0-C-716A
(ucs-set-char #x4EF2 ?$(GG4(B) ; C01-G-4734
(ucs-set-char #x4EF2 ?$@Cg(B) ; J78-@-4367
(ucs-set-char #x4EF2 ?$AVY(B) ; GB0-A-5659
(ucs-set-char #x4EF2 ?$BCg(B) ; J83-B-4367
(ucs-set-char #x4EF3 ?$(D0M(B) ; J90-D-304D
(ucs-set-char #x4EF3 ?$(GG8(B) ; C01-G-4738
(ucs-set-char #x4EF3 ?$AXr(B) ; GB0-A-5872
(ucs-set-char #x4EF4 ?$(H!y(B) ; C02-H-2179
(ucs-set-char #x4EF5 ?$(D0N(B) ; J90-D-304E
(ucs-set-char #x4EF5 ?$(H!m(B) ; C02-H-216D
(ucs-set-char #x4EF5 ?$AXu(B) ; GB0-A-5875
(ucs-set-char #x4EF6 ?$(CKl(B) ; KS0-C-4B6C
(ucs-set-char #x4EF6 ?$(GG5(B) ; C01-G-4735
(ucs-set-char #x4EF6 ?$@7o(B) ; J78-@-376F
(ucs-set-char #x4EF6 ?$A<~(B) ; GB0-A-3C7E
(ucs-set-char #x4EF6 ?$B7o(B) ; J83-B-376F
(ucs-set-char #x4EF7 ?$(CK@(B) ; KS0-C-4B40
(ucs-set-char #x4EF7 ?$(H!q(B) ; C02-H-2171
(ucs-set-char #x4EF7 ?$@PC(B) ; J78-@-5043
(ucs-set-char #x4EF7 ?$A<[(B) ; GB0-A-3C5B
(ucs-set-char #x4EF7 ?$BPC(B) ; J83-B-5043
(ucs-set-char #x4EF8 ?$(I"k(B) ; C03-I-226B
(ucs-set-char #x4EF9 ?$(I"g(B) ; C03-I-2267
(ucs-set-char #x4EFA ?$(I"v(B) ; C03-I-2276
(ucs-set-char #x4EFB ?$(Clr(B) ; KS0-C-6C72
(ucs-set-char #x4EFB ?$(GG6(B) ; C01-G-4736
(ucs-set-char #x4EFB ?$@G$(B) ; J78-@-4724
(ucs-set-char #x4EFB ?$AHN(B) ; GB0-A-484E
(ucs-set-char #x4EFB ?$BG$(B) ; J83-B-4724
(ucs-set-char #x4EFC ?$(I"n(B) ; C03-I-226E
(ucs-set-char #x4EFD ?$(D0O(B) ; J90-D-304F
(ucs-set-char #x4EFD ?$(GG9(B) ; C01-G-4739
(ucs-set-char #x4EFD ?$A7](B) ; GB0-A-375D
(ucs-set-char #x4EFE ?$(D0P(B) ; J90-D-3050
(ucs-set-char #x4EFE ?$(J"-(B) ; C04-J-222D
(ucs-set-char #x4EFF ?$(D0Q(B) ; J90-D-3051
(ucs-set-char #x4EFF ?$(GG+(B) ; C01-G-472B
(ucs-set-char #x4EFF ?$A7B(B) ; GB0-A-3742
(ucs-set-char #x4F00 ?$(D0R(B) ; J90-D-3052
(ucs-set-char #x4F00 ?$(H!p(B) ; C02-H-2170
(ucs-set-char #x4F01 ?$(CPj(B) ; KS0-C-506A
(ucs-set-char #x4F01 ?$(GG:(B) ; C01-G-473A
(ucs-set-char #x4F01 ?$@4k(B) ; J78-@-346B
(ucs-set-char #x4F01 ?$AFs(B) ; GB0-A-4673
(ucs-set-char #x4F01 ?$B4k(B) ; J83-B-346B
(ucs-set-char #x4F02 ?$(D0S(B) ; J90-D-3053
(ucs-set-char #x4F02 ?$(H!t(B) ; C02-H-2174
(ucs-set-char #x4F03 ?$(D0T(B) ; J90-D-3054
(ucs-set-char #x4F03 ?$(I"m(B) ; C03-I-226D
(ucs-set-char #x4F04 ?$(H!x(B) ; C02-H-2178
(ucs-set-char #x4F05 ?$(H!u(B) ; C02-H-2175
(ucs-set-char #x4F06 ?$(I"l(B) ; C03-I-226C
(ucs-set-char #x4F07 ?$(I"t(B) ; C03-I-2274
(ucs-set-char #x4F08 ?$(D0U(B) ; J90-D-3055
(ucs-set-char #x4F08 ?$(H!r(B) ; C02-H-2172
(ucs-set-char #x4F09 ?$(Cyr(B) ; KS0-C-7972
(ucs-set-char #x4F09 ?$(GG,(B) ; C01-G-472C
(ucs-set-char #x4F09 ?$@PD(B) ; J78-@-5044
(ucs-set-char #x4F09 ?$AXx(B) ; GB0-A-5878
(ucs-set-char #x4F09 ?$BPD(B) ; J83-B-5044
(ucs-set-char #x4F0A ?$(Cl%(B) ; KS0-C-6C25
(ucs-set-char #x4F0A ?$(GG.(B) ; C01-G-472E
(ucs-set-char #x4F0A ?$@0K(B) ; J78-@-304B
(ucs-set-char #x4F0A ?$ARA(B) ; GB0-A-5241
(ucs-set-char #x4F0A ?$B0K(B) ; J83-B-304B
(ucs-set-char #x4F0B ?$(CP_(B) ; KS0-C-505F
(ucs-set-char #x4F0B ?$(D0V(B) ; J90-D-3056
(ucs-set-char #x4F0B ?$(GG;(B) ; C01-G-473B
(ucs-set-char #x4F0C ?$(D0W(B) ; J90-D-3057
(ucs-set-char #x4F0C ?$(J"*(B) ; C04-J-222A
(ucs-set-char #x4F0D ?$(Cgj(B) ; KS0-C-676A
(ucs-set-char #x4F0D ?$(GG0(B) ; C01-G-4730
(ucs-set-char #x4F0D ?$@8`(B) ; J78-@-3860
(ucs-set-char #x4F0D ?$ANi(B) ; GB0-A-4E69
(ucs-set-char #x4F0D ?$B8`(B) ; J83-B-3860
(ucs-set-char #x4F0E ?$(CPk(B) ; KS0-C-506B
(ucs-set-char #x4F0E ?$(H!j(B) ; C02-H-216A
(ucs-set-char #x4F0E ?$@4l(B) ; J78-@-346C
(ucs-set-char #x4F0E ?$A<?(B) ; GB0-A-3C3F
(ucs-set-char #x4F0E ?$B4l(B) ; J83-B-346C
(ucs-set-char #x4F0F ?$(C\Q(B) ; KS0-C-5C51
(ucs-set-char #x4F0F ?$(GG3(B) ; C01-G-4733
(ucs-set-char #x4F0F ?$@Iz(B) ; J78-@-497A
(ucs-set-char #x4F0F ?$A7|(B) ; GB0-A-377C
(ucs-set-char #x4F0F ?$BIz(B) ; J83-B-497A
(ucs-set-char #x4F10 ?$(C[i(B) ; KS0-C-5B69
(ucs-set-char #x4F10 ?$(GG1(B) ; C01-G-4731
(ucs-set-char #x4F10 ?$@H2(B) ; J78-@-4832
(ucs-set-char #x4F10 ?$A7%(B) ; GB0-A-3725
(ucs-set-char #x4F10 ?$BH2(B) ; J83-B-4832
(ucs-set-char #x4F11 ?$(C}L(B) ; KS0-C-7D4C
(ucs-set-char #x4F11 ?$(GG2(B) ; C01-G-4732
(ucs-set-char #x4F11 ?$@5Y(B) ; J78-@-3559
(ucs-set-char #x4F11 ?$AP](B) ; GB0-A-505D
(ucs-set-char #x4F11 ?$B5Y(B) ; J83-B-3559
(ucs-set-char #x4F12 ?$(D0X(B) ; J90-D-3058
(ucs-set-char #x4F12 ?$(H!z(B) ; C02-H-217A
(ucs-set-char #x4F13 ?$(H!w(B) ; C02-H-2177
(ucs-set-char #x4F14 ?$(H!n(B) ; C02-H-216E
(ucs-set-char #x4F15 ?$(D0Y(B) ; J90-D-3059
(ucs-set-char #x4F15 ?$(GG/(B) ; C01-G-472F
(ucs-set-char #x4F16 ?$(D0Z(B) ; J90-D-305A
(ucs-set-char #x4F16 ?$(I"p(B) ; C03-I-2270
(ucs-set-char #x4F17 ?$(D0[(B) ; J90-D-305B
(ucs-set-char #x4F17 ?$(I"w(B) ; C03-I-2277
(ucs-set-char #x4F17 ?$AVZ(B) ; GB0-A-565A
(ucs-set-char #x4F18 ?$(H!k(B) ; C02-H-216B
(ucs-set-char #x4F18 ?$ASE(B) ; GB0-A-5345
(ucs-set-char #x4F19 ?$(D0\(B) ; J90-D-305C
(ucs-set-char #x4F19 ?$(GG-(B) ; C01-G-472D
(ucs-set-char #x4F19 ?$A;o(B) ; GB0-A-3B6F
(ucs-set-char #x4F1A ?$(I"u(B) ; C03-I-2275
(ucs-set-char #x4F1A ?$@2q(B) ; J78-@-3271
(ucs-set-char #x4F1A ?$A;a(B) ; GB0-A-3B61
(ucs-set-char #x4F1A ?$B2q(B) ; J83-B-3271
(ucs-set-char #x4F1B ?$(J".(B) ; C04-J-222E
(ucs-set-char #x4F1B ?$AXq(B) ; GB0-A-5871
(ucs-set-char #x4F1C ?$(I"s(B) ; C03-I-2273
(ucs-set-char #x4F1C ?$@Pg(B) ; J78-@-5067
(ucs-set-char #x4F1C ?$BPg(B) ; J83-B-5067
(ucs-set-char #x4F1D ?$(H!s(B) ; C02-H-2173
(ucs-set-char #x4F1D ?$@EA(B) ; J78-@-4541
(ucs-set-char #x4F1D ?$BEA(B) ; J83-B-4541
(ucs-set-char #x4F1E ?$AI!(B) ; GB0-A-4921
(ucs-set-char #x4F1F ?$AN0(B) ; GB0-A-4E30
(ucs-set-char #x4F20 ?$A4+(B) ; GB0-A-342B
(ucs-set-char #x4F22 ?$(H!v(B) ; C02-H-2176
(ucs-set-char #x4F22 ?$AXs(B) ; GB0-A-5873
(ucs-set-char #x4F24 ?$AIK(B) ; GB0-A-494B
(ucs-set-char #x4F25 ?$AXv(B) ; GB0-A-5876
(ucs-set-char #x4F26 ?$ABW(B) ; GB0-A-4257
(ucs-set-char #x4F27 ?$AXw(B) ; GB0-A-5877
(ucs-set-char #x4F28 ?$(I"r(B) ; C03-I-2272
(ucs-set-char #x4F2A ?$AN1(B) ; GB0-A-4E31
(ucs-set-char #x4F2B ?$AXy(B) ; GB0-A-5879
(ucs-set-char #x4F2C ?$(H!l(B) ; C02-H-216C
(ucs-set-char #x4F2D ?$(H#((B) ; C02-H-2328
(ucs-set-char #x4F2E ?$(D0](B) ; J90-D-305D
(ucs-set-char #x4F2E ?$(J#9(B) ; C04-J-2339
(ucs-set-char #x4F2F ?$(C[W(B) ; KS0-C-5B57
(ucs-set-char #x4F2F ?$(GI$(B) ; C01-G-4924
(ucs-set-char #x4F2F ?$@Gl(B) ; J78-@-476C
(ucs-set-char #x4F2F ?$A2.(B) ; GB0-A-322E
(ucs-set-char #x4F2F ?$BGl(B) ; J83-B-476C
(ucs-set-char #x4F30 ?$(GHu(B) ; C01-G-4875
(ucs-set-char #x4F30 ?$@PF(B) ; J78-@-5046
(ucs-set-char #x4F30 ?$A9@(B) ; GB0-A-3940
(ucs-set-char #x4F30 ?$BPF(B) ; J83-B-5046
(ucs-set-char #x4F31 ?$(D0^(B) ; J90-D-305E
(ucs-set-char #x4F31 ?$(I$P(B) ; C03-I-2450
(ucs-set-char #x4F32 ?$(I$H(B) ; C03-I-2448
(ucs-set-char #x4F32 ?$AY#(B) ; GB0-A-5923
(ucs-set-char #x4F33 ?$(D0`(B) ; J90-D-3060
(ucs-set-char #x4F33 ?$(H#)(B) ; C02-H-2329
(ucs-set-char #x4F34 ?$(CZa(B) ; KS0-C-5A61
(ucs-set-char #x4F34 ?$(GHr(B) ; C01-G-4872
(ucs-set-char #x4F34 ?$@H<(B) ; J78-@-483C
(ucs-set-char #x4F34 ?$A0i(B) ; GB0-A-3069
(ucs-set-char #x4F34 ?$BH<(B) ; J83-B-483C
(ucs-set-char #x4F35 ?$(D0a(B) ; J90-D-3061
(ucs-set-char #x4F35 ?$(I$O(B) ; C03-I-244F
(ucs-set-char #x4F36 ?$(CV6(B) ; KS0-C-5636
(ucs-set-char #x4F36 ?$(GI&(B) ; C01-G-4926
(ucs-set-char #x4F36 ?$@Nb(B) ; J78-@-4E62
(ucs-set-char #x4F36 ?$AAf(B) ; GB0-A-4166
(ucs-set-char #x4F36 ?$BNb(B) ; J83-B-4E62
(ucs-set-char #x4F37 ?$(D0b(B) ; J90-D-3062
(ucs-set-char #x4F37 ?$(I$F(B) ; C03-I-2446
(ucs-set-char #x4F38 ?$(Cc_(B) ; KS0-C-635F
(ucs-set-char #x4F38 ?$(GHz(B) ; C01-G-487A
(ucs-set-char #x4F38 ?$@?-(B) ; J78-@-3F2D
(ucs-set-char #x4F38 ?$AIl(B) ; GB0-A-496C
(ucs-set-char #x4F38 ?$B?-(B) ; J83-B-3F2D
(ucs-set-char #x4F39 ?$(D0c(B) ; J90-D-3063
(ucs-set-char #x4F39 ?$(I$E(B) ; C03-I-2445
(ucs-set-char #x4F3A ?$(C^C(B) ; KS0-C-5E43
(ucs-set-char #x4F3A ?$(GHy(B) ; C01-G-4879
(ucs-set-char #x4F3A ?$@;G(B) ; J78-@-3B47
(ucs-set-char #x4F3A ?$AKE(B) ; GB0-A-4B45
(ucs-set-char #x4F3A ?$B;G(B) ; J83-B-3B47
(ucs-set-char #x4F3B ?$(D0d(B) ; J90-D-3064
(ucs-set-char #x4F3B ?$(H"{(B) ; C02-H-227B
(ucs-set-char #x4F3C ?$(C^D(B) ; KS0-C-5E44
(ucs-set-char #x4F3C ?$(GH}(B) ; C01-G-487D
(ucs-set-char #x4F3C ?$@;w(B) ; J78-@-3B77
(ucs-set-char #x4F3C ?$AKF(B) ; GB0-A-4B46
(ucs-set-char #x4F3C ?$B;w(B) ; J83-B-3B77
(ucs-set-char #x4F3D ?$(CJ!(B) ; KS0-C-4A21
(ucs-set-char #x4F3D ?$(GHx(B) ; C01-G-4878
(ucs-set-char #x4F3D ?$@2@(B) ; J78-@-3240
(ucs-set-char #x4F3D ?$AY$(B) ; GB0-A-5924
(ucs-set-char #x4F3D ?$B2@(B) ; J83-B-3240
(ucs-set-char #x4F3E ?$(D0e(B) ; J90-D-3065
(ucs-set-char #x4F3E ?$(H#"(B) ; C02-H-2322
(ucs-set-char #x4F3F ?$(H#*(B) ; C02-H-232A
(ucs-set-char #x4F40 ?$(D0f(B) ; J90-D-3066
(ucs-set-char #x4F40 ?$(I$N(B) ; C03-I-244E
(ucs-set-char #x4F41 ?$(H#&(B) ; C02-H-2326
(ucs-set-char #x4F42 ?$(D0g(B) ; J90-D-3067
(ucs-set-char #x4F42 ?$(I$I(B) ; C03-I-2449
(ucs-set-char #x4F43 ?$(Cnl(B) ; KS0-C-6E6C
(ucs-set-char #x4F43 ?$(GH{(B) ; C01-G-487B
(ucs-set-char #x4F43 ?$@DQ(B) ; J78-@-4451
(ucs-set-char #x4F43 ?$A5h(B) ; GB0-A-3568
(ucs-set-char #x4F43 ?$BDQ(B) ; J83-B-4451
(ucs-set-char #x4F44 ?$(I$K(B) ; C03-I-244B
(ucs-set-char #x4F45 ?$(I$C(B) ; C03-I-2443
(ucs-set-char #x4F46 ?$(CS#(B) ; KS0-C-5323
(ucs-set-char #x4F46 ?$(GH~(B) ; C01-G-487E
(ucs-set-char #x4F46 ?$@C"(B) ; J78-@-4322
(ucs-set-char #x4F46 ?$A5+(B) ; GB0-A-352B
(ucs-set-char #x4F46 ?$BC"(B) ; J83-B-4322
(ucs-set-char #x4F47 ?$(Cn7(B) ; KS0-C-6E37
(ucs-set-char #x4F47 ?$(GHo(B) ; C01-G-486F
(ucs-set-char #x4F47 ?$@PJ(B) ; J78-@-504A
(ucs-set-char #x4F47 ?$BPJ(B) ; J83-B-504A
(ucs-set-char #x4F48 ?$(CxO(B) ; KS0-C-784F
(ucs-set-char #x4F48 ?$(D0h(B) ; J90-D-3068
(ucs-set-char #x4F48 ?$(GI)(B) ; C01-G-4929
(ucs-set-char #x4F49 ?$(D0i(B) ; J90-D-3069
(ucs-set-char #x4F49 ?$(H"}(B) ; C02-H-227D
(ucs-set-char #x4F4A ?$(I$D(B) ; C03-I-2444
(ucs-set-char #x4F4B ?$(D0j(B) ; J90-D-306A
(ucs-set-char #x4F4B ?$(I$L(B) ; C03-I-244C
(ucs-set-char #x4F4C ?$(D0k(B) ; J90-D-306B
(ucs-set-char #x4F4C ?$(H%=(B) ; C02-H-253D
(ucs-set-char #x4F4D ?$(CjH(B) ; KS0-C-6A48
(ucs-set-char #x4F4D ?$(GHm(B) ; C01-G-486D
(ucs-set-char #x4F4D ?$@0L(B) ; J78-@-304C
(ucs-set-char #x4F4D ?$AN;(B) ; GB0-A-4E3B
(ucs-set-char #x4F4D ?$B0L(B) ; J83-B-304C
(ucs-set-char #x4F4E ?$(Cn8(B) ; KS0-C-6E38
(ucs-set-char #x4F4E ?$(GI%(B) ; C01-G-4925
(ucs-set-char #x4F4E ?$@Dc(B) ; J78-@-4463
(ucs-set-char #x4F4E ?$A5M(B) ; GB0-A-354D
(ucs-set-char #x4F4E ?$BDc(B) ; J83-B-4463
(ucs-set-char #x4F4F ?$(Cq,(B) ; KS0-C-712C
(ucs-set-char #x4F4F ?$(GHn(B) ; C01-G-486E
(ucs-set-char #x4F4F ?$@=;(B) ; J78-@-3D3B
(ucs-set-char #x4F4F ?$AW!(B) ; GB0-A-5721
(ucs-set-char #x4F4F ?$B=;(B) ; J83-B-3D3B
(ucs-set-char #x4F50 ?$(Cq%(B) ; KS0-C-7125
(ucs-set-char #x4F50 ?$(GHv(B) ; C01-G-4876
(ucs-set-char #x4F50 ?$@:4(B) ; J78-@-3A34
(ucs-set-char #x4F50 ?$AWt(B) ; GB0-A-5774
(ucs-set-char #x4F50 ?$B:4(B) ; J83-B-3A34
(ucs-set-char #x4F51 ?$(CiN(B) ; KS0-C-694E
(ucs-set-char #x4F51 ?$(GHw(B) ; C01-G-4877
(ucs-set-char #x4F51 ?$@M$(B) ; J78-@-4D24
(ucs-set-char #x4F51 ?$ASS(B) ; GB0-A-5353
(ucs-set-char #x4F51 ?$BM$(B) ; J83-B-4D24
(ucs-set-char #x4F52 ?$(D0l(B) ; J90-D-306C
(ucs-set-char #x4F52 ?$(H#$(B) ; C02-H-2324
(ucs-set-char #x4F53 ?$(H"~(B) ; C02-H-227E
(ucs-set-char #x4F53 ?$@BN(B) ; J78-@-424E
(ucs-set-char #x4F53 ?$ALe(B) ; GB0-A-4C65
(ucs-set-char #x4F53 ?$BBN(B) ; J83-B-424E
(ucs-set-char #x4F54 ?$(D0m(B) ; J90-D-306D
(ucs-set-char #x4F54 ?$(GH|(B) ; C01-G-487C
(ucs-set-char #x4F55 ?$(Cy<(B) ; KS0-C-793C
(ucs-set-char #x4F55 ?$(GHt(B) ; C01-G-4874
(ucs-set-char #x4F55 ?$@2?(B) ; J78-@-323F
(ucs-set-char #x4F55 ?$A:N(B) ; GB0-A-3A4E
(ucs-set-char #x4F55 ?$B2?(B) ; J83-B-323F
(ucs-set-char #x4F56 ?$(D0n(B) ; J90-D-306E
(ucs-set-char #x4F56 ?$(H"z(B) ; C02-H-227A
(ucs-set-char #x4F57 ?$(GHp(B) ; C01-G-4870
(ucs-set-char #x4F57 ?$@PI(B) ; J78-@-5049
(ucs-set-char #x4F57 ?$AY"(B) ; GB0-A-5922
(ucs-set-char #x4F57 ?$BPI(B) ; J83-B-5049
(ucs-set-char #x4F58 ?$(D0o(B) ; J90-D-306F
(ucs-set-char #x4F58 ?$(H#'(B) ; C02-H-2327
(ucs-set-char #x4F58 ?$AY\(B) ; GB0-A-595C
(ucs-set-char #x4F59 ?$(Cey(B) ; KS0-C-6579
(ucs-set-char #x4F59 ?$(GI'(B) ; C01-G-4927
(ucs-set-char #x4F59 ?$@M>(B) ; J78-@-4D3E
(ucs-set-char #x4F59 ?$AS`(B) ; GB0-A-5360
(ucs-set-char #x4F59 ?$BM>(B) ; J83-B-4D3E
(ucs-set-char #x4F5A ?$(Clj(B) ; KS0-C-6C6A
(ucs-set-char #x4F5A ?$(GI*(B) ; C01-G-492A
(ucs-set-char #x4F5A ?$@PE(B) ; J78-@-5045
(ucs-set-char #x4F5A ?$AX}(B) ; GB0-A-587D
(ucs-set-char #x4F5A ?$BPE(B) ; J83-B-5045
(ucs-set-char #x4F5B ?$(C]V(B) ; KS0-C-5D56
(ucs-set-char #x4F5B ?$(GHs(B) ; C01-G-4873
(ucs-set-char #x4F5B ?$@PG(B) ; J78-@-5047
(ucs-set-char #x4F5B ?$A7p(B) ; GB0-A-3770
(ucs-set-char #x4F5B ?$BPG(B) ; J83-B-5047
(ucs-set-char #x4F5C ?$(CmB(B) ; KS0-C-6D42
(ucs-set-char #x4F5C ?$(GI"(B) ; C01-G-4922
(ucs-set-char #x4F5C ?$@:n(B) ; J78-@-3A6E
(ucs-set-char #x4F5C ?$AWw(B) ; GB0-A-5777
(ucs-set-char #x4F5C ?$B:n(B) ; J83-B-3A6E
(ucs-set-char #x4F5D ?$(GI((B) ; C01-G-4928
(ucs-set-char #x4F5D ?$@PH(B) ; J78-@-5048
(ucs-set-char #x4F5D ?$AX~(B) ; GB0-A-587E
(ucs-set-char #x4F5D ?$BPH(B) ; J83-B-5048
(ucs-set-char #x4F5E ?$(GHq(B) ; C01-G-4871
(ucs-set-char #x4F5E ?$@U$(B) ; J78-@-5524
(ucs-set-char #x4F5E ?$AXz(B) ; GB0-A-587A
(ucs-set-char #x4F5E ?$BU$(B) ; J83-B-5524
(ucs-set-char #x4F5F ?$(D0p(B) ; J90-D-3070
(ucs-set-char #x4F5F ?$(H#%(B) ; C02-H-2325
(ucs-set-char #x4F5F ?$AY!(B) ; GB0-A-5921
(ucs-set-char #x4F60 ?$(D0_(B) ; J90-D-305F
(ucs-set-char #x4F60 ?$(GI#(B) ; C01-G-4923
(ucs-set-char #x4F60 ?$ADc(B) ; GB0-A-4463
(ucs-set-char #x4F61 ?$(H#+(B) ; C02-H-232B
(ucs-set-char #x4F62 ?$(H"|(B) ; C02-H-227C
(ucs-set-char #x4F63 ?$(D0q(B) ; J90-D-3071
(ucs-set-char #x4F63 ?$(GI!(B) ; C01-G-4921
(ucs-set-char #x4F63 ?$AS6(B) ; GB0-A-5336
(ucs-set-char #x4F64 ?$(H#!(B) ; C02-H-2321
(ucs-set-char #x4F64 ?$AXt(B) ; GB0-A-5874
(ucs-set-char #x4F65 ?$AY](B) ; GB0-A-595D
(ucs-set-char #x4F67 ?$(H##(B) ; C02-H-2323
(ucs-set-char #x4F67 ?$AX{(B) ; GB0-A-587B
(ucs-set-char #x4F69 ?$(Cx%(B) ; KS0-C-7825
(ucs-set-char #x4F69 ?$(GKy(B) ; C01-G-4B79
(ucs-set-char #x4F69 ?$@PP(B) ; J78-@-5050
(ucs-set-char #x4F69 ?$AEe(B) ; GB0-A-4565
(ucs-set-char #x4F69 ?$BPP(B) ; J83-B-5050
(ucs-set-char #x4F6A ?$(D0r(B) ; J90-D-3072
(ucs-set-char #x4F6A ?$(H%?(B) ; C02-H-253F
(ucs-set-char #x4F6B ?$(H%K(B) ; C02-H-254B
(ucs-set-char #x4F6C ?$(D0s(B) ; J90-D-3073
(ucs-set-char #x4F6C ?$(GKq(B) ; C01-G-4B71
(ucs-set-char #x4F6C ?$A@P(B) ; GB0-A-4050
(ucs-set-char #x4F6D ?$(I'G(B) ; C03-I-2747
(ucs-set-char #x4F6E ?$(D0t(B) ; J90-D-3074
(ucs-set-char #x4F6E ?$(H%L(B) ; C02-H-254C
(ucs-set-char #x4F6F ?$(Ce:(B) ; KS0-C-653A
(ucs-set-char #x4F6F ?$(GKl(B) ; C01-G-4B6C
(ucs-set-char #x4F6F ?$@PS(B) ; J78-@-5053
(ucs-set-char #x4F6F ?$AQp(B) ; GB0-A-5170
(ucs-set-char #x4F6F ?$BPS(B) ; J83-B-5053
(ucs-set-char #x4F70 ?$(C[X(B) ; KS0-C-5B58
(ucs-set-char #x4F70 ?$(GKv(B) ; C01-G-4B76
(ucs-set-char #x4F70 ?$@PQ(B) ; J78-@-5051
(ucs-set-char #x4F70 ?$A0[(B) ; GB0-A-305B
(ucs-set-char #x4F70 ?$BPQ(B) ; J83-B-5051
(ucs-set-char #x4F71 ?$(D0u(B) ; J90-D-3075
(ucs-set-char #x4F71 ?$(J%>(B) ; C04-J-253E
(ucs-set-char #x4F72 ?$(I'O(B) ; C03-I-274F
(ucs-set-char #x4F73 ?$(CJ"(B) ; KS0-C-4A22
(ucs-set-char #x4F73 ?$(GKo(B) ; C01-G-4B6F
(ucs-set-char #x4F73 ?$@2B(B) ; J78-@-3242
(ucs-set-char #x4F73 ?$A<Q(B) ; GB0-A-3C51
(ucs-set-char #x4F73 ?$B2B(B) ; J83-B-3242
(ucs-set-char #x4F74 ?$(H%9(B) ; C02-H-2539
(ucs-set-char #x4F74 ?$AY&(B) ; GB0-A-5926
(ucs-set-char #x4F75 ?$(GKw(B) ; C01-G-4B77
(ucs-set-char #x4F75 ?$@J;(B) ; J78-@-4A3B
(ucs-set-char #x4F75 ?$BJ;(B) ; J83-B-4A3B
(ucs-set-char #x4F76 ?$(CQM(B) ; KS0-C-514D
(ucs-set-char #x4F76 ?$(H%8(B) ; C02-H-2538
(ucs-set-char #x4F76 ?$@PK(B) ; J78-@-504B
(ucs-set-char #x4F76 ?$AY%(B) ; GB0-A-5925
(ucs-set-char #x4F76 ?$BPK(B) ; J83-B-504B
(ucs-set-char #x4F77 ?$(D0v(B) ; J90-D-3076
(ucs-set-char #x4F77 ?$(H%<(B) ; C02-H-253C
(ucs-set-char #x4F78 ?$(D0w(B) ; J90-D-3077
(ucs-set-char #x4F78 ?$(H%C(B) ; C02-H-2543
(ucs-set-char #x4F79 ?$(D0x(B) ; J90-D-3078
(ucs-set-char #x4F79 ?$(H%A(B) ; C02-H-2541
(ucs-set-char #x4F7A ?$(Cnm(B) ; KS0-C-6E6D
(ucs-set-char #x4F7A ?$(D0y(B) ; J90-D-3079
(ucs-set-char #x4F7A ?$(GL!(B) ; C01-G-4C21
(ucs-set-char #x4F7B ?$(GKz(B) ; C01-G-4B7A
(ucs-set-char #x4F7B ?$@PO(B) ; J78-@-504F
(ucs-set-char #x4F7B ?$AY,(B) ; GB0-A-592C
(ucs-set-char #x4F7B ?$BPO(B) ; J83-B-504F
(ucs-set-char #x4F7C ?$(H%3(B) ; C02-H-2533
(ucs-set-char #x4F7C ?$@8s(B) ; J78-@-3873
(ucs-set-char #x4F7C ?$AY.(B) ; GB0-A-592E
(ucs-set-char #x4F7C ?$B8s(B) ; J83-B-3873
(ucs-set-char #x4F7D ?$(D0z(B) ; J90-D-307A
(ucs-set-char #x4F7D ?$(H%5(B) ; C02-H-2535
(ucs-set-char #x4F7E ?$(Clk(B) ; KS0-C-6C6B
(ucs-set-char #x4F7E ?$(D0{(B) ; J90-D-307B
(ucs-set-char #x4F7E ?$(GK|(B) ; C01-G-4B7C
(ucs-set-char #x4F7E ?$AY+(B) ; GB0-A-592B
(ucs-set-char #x4F7F ?$(C^E(B) ; KS0-C-5E45
(ucs-set-char #x4F7F ?$(GKp(B) ; C01-G-4B70
(ucs-set-char #x4F7F ?$@;H(B) ; J78-@-3B48
(ucs-set-char #x4F7F ?$AJ9(B) ; GB0-A-4A39
(ucs-set-char #x4F7F ?$B;H(B) ; J83-B-3B48
(ucs-set-char #x4F80 ?$(H%6(B) ; C02-H-2536
(ucs-set-char #x4F81 ?$(Cc`(B) ; KS0-C-6360
(ucs-set-char #x4F81 ?$(D0|(B) ; J90-D-307C
(ucs-set-char #x4F81 ?$(H%B(B) ; C02-H-2542
(ucs-set-char #x4F82 ?$(D0}(B) ; J90-D-307D
(ucs-set-char #x4F82 ?$(H%I(B) ; C02-H-2549
(ucs-set-char #x4F83 ?$(CJI(B) ; KS0-C-4A49
(ucs-set-char #x4F83 ?$(GKu(B) ; C01-G-4B75
(ucs-set-char #x4F83 ?$@4&(B) ; J78-@-3426
(ucs-set-char #x4F83 ?$AY)(B) ; GB0-A-5929
(ucs-set-char #x4F83 ?$B4&(B) ; J83-B-3426
(ucs-set-char #x4F84 ?$(Cri(B) ; KS0-C-7269
(ucs-set-char #x4F84 ?$(D0~(B) ; J90-D-307E
(ucs-set-char #x4F84 ?$(H%;(B) ; C02-H-253B
(ucs-set-char #x4F84 ?$AV6(B) ; GB0-A-5636
(ucs-set-char #x4F85 ?$(D1!(B) ; J90-D-3121
(ucs-set-char #x4F85 ?$(H%4(B) ; C02-H-2534
(ucs-set-char #x4F86 ?$(CUN(B) ; KS0-C-554E
(ucs-set-char #x4F86 ?$(GKt(B) ; C01-G-4B74
(ucs-set-char #x4F86 ?$@PT(B) ; J78-@-5054
(ucs-set-char #x4F86 ?$BPT(B) ; J83-B-5054
(ucs-set-char #x4F87 ?$(H%7(B) ; C02-H-2537
(ucs-set-char #x4F88 ?$(Cv6(B) ; KS0-C-7636
(ucs-set-char #x4F88 ?$(GKx(B) ; C01-G-4B78
(ucs-set-char #x4F88 ?$@PL(B) ; J78-@-504C
(ucs-set-char #x4F88 ?$A3^(B) ; GB0-A-335E
(ucs-set-char #x4F88 ?$BPL(B) ; J83-B-504C
(ucs-set-char #x4F89 ?$(D1"(B) ; J90-D-3122
(ucs-set-char #x4F89 ?$(H%:(B) ; C02-H-253A
(ucs-set-char #x4F89 ?$AY((B) ; GB0-A-5928
(ucs-set-char #x4F8A ?$(CNB(B) ; KS0-C-4E42
(ucs-set-char #x4F8A ?$(D1#(B) ; J90-D-3123
(ucs-set-char #x4F8A ?$(I'D(B) ; C03-I-2744
(ucs-set-char #x4F8B ?$(CVG(B) ; KS0-C-5647
(ucs-set-char #x4F8B ?$(GKs(B) ; C01-G-4B73
(ucs-set-char #x4F8B ?$@Nc(B) ; J78-@-4E63
(ucs-set-char #x4F8B ?$A@}(B) ; GB0-A-407D
(ucs-set-char #x4F8B ?$BNc(B) ; J83-B-4E63
(ucs-set-char #x4F8C ?$(D1$(B) ; J90-D-3124
(ucs-set-char #x4F8C ?$(I'Q(B) ; C03-I-2751
(ucs-set-char #x4F8D ?$(Cc4(B) ; KS0-C-6334
(ucs-set-char #x4F8D ?$(GKn(B) ; C01-G-4B6E
(ucs-set-char #x4F8D ?$@;x(B) ; J78-@-3B78
(ucs-set-char #x4F8D ?$AJL(B) ; GB0-A-4A4C
(ucs-set-char #x4F8D ?$B;x(B) ; J83-B-3B78
(ucs-set-char #x4F8E ?$(D1%(B) ; J90-D-3125
(ucs-set-char #x4F8E ?$(I'H(B) ; C03-I-2748
(ucs-set-char #x4F8F ?$(Cq-(B) ; KS0-C-712D
(ucs-set-char #x4F8F ?$(GK}(B) ; C01-G-4B7D
(ucs-set-char #x4F8F ?$@PM(B) ; J78-@-504D
(ucs-set-char #x4F8F ?$AY*(B) ; GB0-A-592A
(ucs-set-char #x4F8F ?$BPM(B) ; J83-B-504D
(ucs-set-char #x4F90 ?$(D1&(B) ; J90-D-3126
(ucs-set-char #x4F90 ?$(H%D(B) ; C02-H-2544
(ucs-set-char #x4F91 ?$(Cjb(B) ; KS0-C-6A62
(ucs-set-char #x4F91 ?$(GK~(B) ; C01-G-4B7E
(ucs-set-char #x4F91 ?$@PR(B) ; J78-@-5052
(ucs-set-char #x4F91 ?$AY'(B) ; GB0-A-5927
(ucs-set-char #x4F91 ?$BPR(B) ; J83-B-5052
(ucs-set-char #x4F92 ?$(D1'(B) ; J90-D-3127
(ucs-set-char #x4F92 ?$(H%H(B) ; C02-H-2548
(ucs-set-char #x4F93 ?$(D1((B) ; J90-D-3128
(ucs-set-char #x4F93 ?$(I'C(B) ; C03-I-2743
(ucs-set-char #x4F94 ?$(D1)(B) ; J90-D-3129
(ucs-set-char #x4F94 ?$(H%F(B) ; C02-H-2546
(ucs-set-char #x4F94 ?$AY0(B) ; GB0-A-5930
(ucs-set-char #x4F95 ?$(H%J(B) ; C02-H-254A
(ucs-set-char #x4F96 ?$(CWB(B) ; KS0-C-5742
(ucs-set-char #x4F96 ?$(GK{(B) ; C01-G-4B7B
(ucs-set-char #x4F96 ?$@PU(B) ; J78-@-5055
(ucs-set-char #x4F96 ?$BPU(B) ; J83-B-5055
(ucs-set-char #x4F97 ?$(D1*(B) ; J90-D-312A
(ucs-set-char #x4F97 ?$(H%>(B) ; C02-H-253E
(ucs-set-char #x4F97 ?$A61(B) ; GB0-A-3631
(ucs-set-char #x4F98 ?$(Cs'(B) ; KS0-C-7327
(ucs-set-char #x4F98 ?$(H%2(B) ; C02-H-2532
(ucs-set-char #x4F98 ?$@PN(B) ; J78-@-504E
(ucs-set-char #x4F98 ?$BPN(B) ; J83-B-504E
(ucs-set-char #x4F99 ?$(D1+(B) ; J90-D-312B
(ucs-set-char #x4F99 ?$(J%6(B) ; C04-J-2536
(ucs-set-char #x4F9A ?$(D1,(B) ; J90-D-312C
(ucs-set-char #x4F9A ?$(H%@(B) ; C02-H-2540
(ucs-set-char #x4F9B ?$(CMj(B) ; KS0-C-4D6A
(ucs-set-char #x4F9B ?$(GKr(B) ; C01-G-4B72
(ucs-set-char #x4F9B ?$@6!(B) ; J78-@-3621
(ucs-set-char #x4F9B ?$A9)(B) ; GB0-A-3929
(ucs-set-char #x4F9B ?$B6!(B) ; J83-B-3621
(ucs-set-char #x4F9C ?$(H%E(B) ; C02-H-2545
(ucs-set-char #x4F9D ?$(Ckn(B) ; KS0-C-6B6E
(ucs-set-char #x4F9D ?$(GKm(B) ; C01-G-4B6D
(ucs-set-char #x4F9D ?$@0M(B) ; J78-@-304D
(ucs-set-char #x4F9D ?$AR@(B) ; GB0-A-5240
(ucs-set-char #x4F9D ?$B0M(B) ; J83-B-304D
(ucs-set-char #x4F9E ?$(D1-(B) ; J90-D-312D
(ucs-set-char #x4F9E ?$(H%G(B) ; C02-H-2547
(ucs-set-char #x4F9F ?$(D1.(B) ; J90-D-312E
(ucs-set-char #x4F9F ?$(I'L(B) ; C03-I-274C
(ucs-set-char #x4FA0 ?$(I'I(B) ; C03-I-2749
(ucs-set-char #x4FA0 ?$AO@(B) ; GB0-A-4F40
(ucs-set-char #x4FA0 ?$B6"(B) ; J83-B-3622
(ucs-set-char #x4FA1 ?$(I'K(B) ; C03-I-274B
(ucs-set-char #x4FA1 ?$@2A(B) ; J78-@-3241
(ucs-set-char #x4FA1 ?$B2A(B) ; J83-B-3241
(ucs-set-char #x4FA2 ?$(I'J(B) ; C03-I-274A
(ucs-set-char #x4FA3 ?$(I'M(B) ; C03-I-274D
(ucs-set-char #x4FA3 ?$ABB(B) ; GB0-A-4242
(ucs-set-char #x4FA5 ?$A=D(B) ; GB0-A-3D44
(ucs-set-char #x4FA6 ?$AUl(B) ; GB0-A-556C
(ucs-set-char #x4FA7 ?$A2`(B) ; GB0-A-3260
(ucs-set-char #x4FA8 ?$AGH(B) ; GB0-A-4748
(ucs-set-char #x4FA9 ?$A?k(B) ; GB0-A-3F6B
(ucs-set-char #x4FAA ?$AY-(B) ; GB0-A-592D
(ucs-set-char #x4FAB ?$@U%(B) ; J78-@-5525
(ucs-set-char #x4FAB ?$BU%(B) ; J83-B-5525
(ucs-set-char #x4FAC ?$AY/(B) ; GB0-A-592F
(ucs-set-char #x4FAD ?$@PV(B) ; J78-@-5056
(ucs-set-char #x4FAD ?$BKy(B) ; J83-B-4B79
(ucs-set-char #x4FAE ?$(CY2(B) ; KS0-C-5932
(ucs-set-char #x4FAE ?$(GOx(B) ; C01-G-4F78
(ucs-set-char #x4FAE ?$(J%=(B) ; C04-J-253D
(ucs-set-char #x4FAE ?$@In(B) ; J78-@-496E
(ucs-set-char #x4FAE ?$ANj(B) ; GB0-A-4E6A
(ucs-set-char #x4FAE ?$BIn(B) ; J83-B-496E
(ucs-set-char #x4FAF ?$(C}%(B) ; KS0-C-7D25
(ucs-set-char #x4FAF ?$(GOl(B) ; C01-G-4F6C
(ucs-set-char #x4FAF ?$@8t(B) ; J78-@-3874
(ucs-set-char #x4FAF ?$A:n(B) ; GB0-A-3A6E
(ucs-set-char #x4FAF ?$B8t(B) ; J83-B-3874
(ucs-set-char #x4FB0 ?$(I+-(B) ; C03-I-2B2D
(ucs-set-char #x4FB1 ?$(I+.(B) ; C03-I-2B2E
(ucs-set-char #x4FB2 ?$(D1/(B) ; J90-D-312F
(ucs-set-char #x4FB2 ?$(H)"(B) ; C02-H-2922
(ucs-set-char #x4FB3 ?$(H)*(B) ; C02-H-292A
(ucs-set-char #x4FB4 ?$(I+6(B) ; C03-I-2B36
(ucs-set-char #x4FB5 ?$(CvU(B) ; KS0-C-7655
(ucs-set-char #x4FB5 ?$(GOk(B) ; C01-G-4F6B
(ucs-set-char #x4FB5 ?$@?/(B) ; J78-@-3F2F
(ucs-set-char #x4FB5 ?$AGV(B) ; GB0-A-4756
(ucs-set-char #x4FB5 ?$B?/(B) ; J83-B-3F2F
(ucs-set-char #x4FB6 ?$(CUb(B) ; KS0-C-5562
(ucs-set-char #x4FB6 ?$(GOs(B) ; C01-G-4F73
(ucs-set-char #x4FB6 ?$@N7(B) ; J78-@-4E37
(ucs-set-char #x4FB6 ?$BN7(B) ; J83-B-4E37
(ucs-set-char #x4FB7 ?$(D10(B) ; J90-D-3130
(ucs-set-char #x4FB7 ?$(GP!(B) ; C01-G-5021
(ucs-set-char #x4FB8 ?$(I+,(B) ; C03-I-2B2C
(ucs-set-char #x4FB9 ?$(D11(B) ; J90-D-3131
(ucs-set-char #x4FB9 ?$(H)0(B) ; C02-H-2930
(ucs-set-char #x4FBA ?$(H).(B) ; C02-H-292E
(ucs-set-char #x4FBB ?$(D12(B) ; J90-D-3132
(ucs-set-char #x4FBB ?$(H))(B) ; C02-H-2929
(ucs-set-char #x4FBC ?$(D13(B) ; J90-D-3133
(ucs-set-char #x4FBC ?$(J(8(B) ; C04-J-2838
(ucs-set-char #x4FBD ?$(D14(B) ; J90-D-3134
(ucs-set-char #x4FBD ?$(J(>(B) ; C04-J-283E
(ucs-set-char #x4FBE ?$(D15(B) ; J90-D-3135
(ucs-set-char #x4FBE ?$(I++(B) ; C03-I-2B2B
(ucs-set-char #x4FBF ?$(Cx5(B) ; KS0-C-7835
(ucs-set-char #x4FBF ?$(GOm(B) ; C01-G-4F6D
(ucs-set-char #x4FBF ?$@JX(B) ; J78-@-4A58
(ucs-set-char #x4FBF ?$A1c(B) ; GB0-A-3163
(ucs-set-char #x4FBF ?$BJX(B) ; J83-B-4A58
(ucs-set-char #x4FC0 ?$(D16(B) ; J90-D-3136
(ucs-set-char #x4FC0 ?$(H)/(B) ; C02-H-292F
(ucs-set-char #x4FC1 ?$(D17(B) ; J90-D-3137
(ucs-set-char #x4FC1 ?$(H)%(B) ; C02-H-2925
(ucs-set-char #x4FC2 ?$(CLu(B) ; KS0-C-4C75
(ucs-set-char #x4FC2 ?$(GO{(B) ; C01-G-4F7B
(ucs-set-char #x4FC2 ?$@78(B) ; J78-@-3738
(ucs-set-char #x4FC2 ?$B78(B) ; J83-B-3738
(ucs-set-char #x4FC3 ?$(Cu5(B) ; KS0-C-7535
(ucs-set-char #x4FC3 ?$(GOr(B) ; C01-G-4F72
(ucs-set-char #x4FC3 ?$@B%(B) ; J78-@-4225
(ucs-set-char #x4FC3 ?$A4Y(B) ; GB0-A-3459
(ucs-set-char #x4FC3 ?$BB%(B) ; J83-B-4225
(ucs-set-char #x4FC4 ?$(Cd-(B) ; KS0-C-642D
(ucs-set-char #x4FC4 ?$(GOz(B) ; C01-G-4F7A
(ucs-set-char #x4FC4 ?$@2d(B) ; J78-@-3264
(ucs-set-char #x4FC4 ?$A6m(B) ; GB0-A-366D
(ucs-set-char #x4FC4 ?$B2d(B) ; J83-B-3264
(ucs-set-char #x4FC5 ?$(D18(B) ; J90-D-3138
(ucs-set-char #x4FC5 ?$(H(~(B) ; C02-H-287E
(ucs-set-char #x4FC5 ?$AY4(B) ; GB0-A-5934
(ucs-set-char #x4FC6 ?$(D19(B) ; J90-D-3139
(ucs-set-char #x4FC6 ?$(I+2(B) ; C03-I-2B32
(ucs-set-char #x4FC7 ?$(H),(B) ; C02-H-292C
(ucs-set-char #x4FC8 ?$(D1:(B) ; J90-D-313A
(ucs-set-char #x4FC8 ?$(I+/(B) ; C03-I-2B2F
(ucs-set-char #x4FC9 ?$(Cgk(B) ; KS0-C-676B
(ucs-set-char #x4FC9 ?$(D1;(B) ; J90-D-313B
(ucs-set-char #x4FC9 ?$(H)#(B) ; C02-H-2923
(ucs-set-char #x4FCA ?$(CqU(B) ; KS0-C-7155
(ucs-set-char #x4FCA ?$(GOv(B) ; C01-G-4F76
(ucs-set-char #x4FCA ?$@=S(B) ; J78-@-3D53
(ucs-set-char #x4FCA ?$A?!(B) ; GB0-A-3F21
(ucs-set-char #x4FCA ?$B=S(B) ; J83-B-3D53
(ucs-set-char #x4FCB ?$(D1<(B) ; J90-D-313C
(ucs-set-char #x4FCB ?$(H)$(B) ; C02-H-2924
(ucs-set-char #x4FCC ?$(D1=(B) ; J90-D-313D
(ucs-set-char #x4FCC ?$(I+3(B) ; C03-I-2B33
(ucs-set-char #x4FCD ?$(D1>(B) ; J90-D-313E
(ucs-set-char #x4FCD ?$(H(}(B) ; C02-H-287D
(ucs-set-char #x4FCE ?$(Cp;(B) ; KS0-C-703B
(ucs-set-char #x4FCE ?$(GO}(B) ; C01-G-4F7D
(ucs-set-char #x4FCE ?$@PY(B) ; J78-@-5059
(ucs-set-char #x4FCE ?$AY^(B) ; GB0-A-595E
(ucs-set-char #x4FCE ?$BPY(B) ; J83-B-5059
(ucs-set-char #x4FCF ?$(D1?(B) ; J90-D-313F
(ucs-set-char #x4FCF ?$(GOp(B) ; C01-G-4F70
(ucs-set-char #x4FCF ?$AGN(B) ; GB0-A-474E
(ucs-set-char #x4FD0 ?$(GOy(B) ; C01-G-4F79
(ucs-set-char #x4FD0 ?$@P^(B) ; J78-@-505E
(ucs-set-char #x4FD0 ?$A@~(B) ; GB0-A-407E
(ucs-set-char #x4FD0 ?$BP^(B) ; J83-B-505E
(ucs-set-char #x4FD1 ?$(Ci5(B) ; KS0-C-6935
(ucs-set-char #x4FD1 ?$(GOo(B) ; C01-G-4F6F
(ucs-set-char #x4FD1 ?$@P\(B) ; J78-@-505C
(ucs-set-char #x4FD1 ?$AY8(B) ; GB0-A-5938
(ucs-set-char #x4FD1 ?$BP\(B) ; J83-B-505C
(ucs-set-char #x4FD2 ?$(D1@(B) ; J90-D-3140
(ucs-set-char #x4FD2 ?$(I+((B) ; C03-I-2B28
(ucs-set-char #x4FD3 ?$(CLI(B) ; KS0-C-4C49
(ucs-set-char #x4FD3 ?$(H)!(B) ; C02-H-2921
(ucs-set-char #x4FD4 ?$(CzU(B) ; KS0-C-7A55
(ucs-set-char #x4FD4 ?$(H)&(B) ; C02-H-2926
(ucs-set-char #x4FD4 ?$@PW(B) ; J78-@-5057
(ucs-set-char #x4FD4 ?$BPW(B) ; J83-B-5057
(ucs-set-char #x4FD5 ?$(I+)(B) ; C03-I-2B29
(ucs-set-char #x4FD6 ?$(H)-(B) ; C02-H-292D
(ucs-set-char #x4FD7 ?$(CaT(B) ; KS0-C-6154
(ucs-set-char #x4FD7 ?$(GOw(B) ; C01-G-4F77
(ucs-set-char #x4FD7 ?$@B/(B) ; J78-@-422F
(ucs-set-char #x4FD7 ?$AKW(B) ; GB0-A-4B57
(ucs-set-char #x4FD7 ?$BB/(B) ; J83-B-422F
(ucs-set-char #x4FD8 ?$(GOt(B) ; C01-G-4F74
(ucs-set-char #x4FD8 ?$@PZ(B) ; J78-@-505A
(ucs-set-char #x4FD8 ?$A7}(B) ; GB0-A-377D
(ucs-set-char #x4FD8 ?$BPZ(B) ; J83-B-505A
(ucs-set-char #x4FD9 ?$(H)((B) ; C02-H-2928
(ucs-set-char #x4FDA ?$(CWV(B) ; KS0-C-5756
(ucs-set-char #x4FDA ?$(GO|(B) ; C01-G-4F7C
(ucs-set-char #x4FDA ?$@P](B) ; J78-@-505D
(ucs-set-char #x4FDA ?$AY5(B) ; GB0-A-5935
(ucs-set-char #x4FDA ?$BP](B) ; J83-B-505D
(ucs-set-char #x4FDB ?$(H)+(B) ; C02-H-292B
(ucs-set-char #x4FDB ?$@P[(B) ; J78-@-505B
(ucs-set-char #x4FDB ?$BP[(B) ; J83-B-505B
(ucs-set-char #x4FDC ?$(D1A(B) ; J90-D-3141
(ucs-set-char #x4FDC ?$(H)'(B) ; C02-H-2927
(ucs-set-char #x4FDC ?$AY7(B) ; GB0-A-5937
(ucs-set-char #x4FDD ?$(C\A(B) ; KS0-C-5C41
(ucs-set-char #x4FDD ?$(GOq(B) ; C01-G-4F71
(ucs-set-char #x4FDD ?$@J](B) ; J78-@-4A5D
(ucs-set-char #x4FDD ?$A1#(B) ; GB0-A-3123
(ucs-set-char #x4FDD ?$BJ](B) ; J83-B-4A5D
(ucs-set-char #x4FDE ?$(GO~(B) ; C01-G-4F7E
(ucs-set-char #x4FDE ?$ASa(B) ; GB0-A-5361
(ucs-set-char #x4FDF ?$(C^F(B) ; KS0-C-5E46
(ucs-set-char #x4FDF ?$(GOu(B) ; C01-G-4F75
(ucs-set-char #x4FDF ?$@PX(B) ; J78-@-5058
(ucs-set-char #x4FDF ?$AY9(B) ; GB0-A-5939
(ucs-set-char #x4FDF ?$BPX(B) ; J83-B-5058
(ucs-set-char #x4FE0 ?$(Czo(B) ; KS0-C-7A6F
(ucs-set-char #x4FE0 ?$(D1B(B) ; J90-D-3142
(ucs-set-char #x4FE0 ?$(GOn(B) ; C01-G-4F6E
(ucs-set-char #x4FE0 ?$@6"(B) ; J78-@-3622
(ucs-set-char #x4FE1 ?$(Cca(B) ; KS0-C-6361
(ucs-set-char #x4FE1 ?$(GOj(B) ; C01-G-4F6A
(ucs-set-char #x4FE1 ?$@?.(B) ; J78-@-3F2E
(ucs-set-char #x4FE1 ?$APE(B) ; GB0-A-5045
(ucs-set-char #x4FE1 ?$B?.(B) ; J83-B-3F2E
(ucs-set-char #x4FE2 ?$(D1C(B) ; J90-D-3143
(ucs-set-char #x4FE2 ?$(J(?(B) ; C04-J-283F
(ucs-set-char #x4FE3 ?$(I+5(B) ; C03-I-2B35
(ucs-set-char #x4FE3 ?$@Ks(B) ; J78-@-4B73
(ucs-set-char #x4FE3 ?$AY6(B) ; GB0-A-5936
(ucs-set-char #x4FE3 ?$BKs(B) ; J83-B-4B73
(ucs-set-char #x4FE4 ?$@P_(B) ; J78-@-505F
(ucs-set-char #x4FE4 ?$BP_(B) ; J83-B-505F
(ucs-set-char #x4FE5 ?$(I+4(B) ; C03-I-2B34
(ucs-set-char #x4FE5 ?$@P`(B) ; J78-@-5060
(ucs-set-char #x4FE5 ?$BP`(B) ; J83-B-5060
(ucs-set-char #x4FE6 ?$AY1(B) ; GB0-A-5931
(ucs-set-char #x4FE8 ?$AY2(B) ; GB0-A-5932
(ucs-set-char #x4FE9 ?$(J(=(B) ; C04-J-283D
(ucs-set-char #x4FE9 ?$AA)(B) ; GB0-A-4129
(ucs-set-char #x4FEA ?$AY3(B) ; GB0-A-5933
(ucs-set-char #x4FEC ?$(H)1(B) ; C02-H-2931
(ucs-set-char #x4FED ?$A<s(B) ; GB0-A-3C73
(ucs-set-char #x4FEE ?$(Cas(B) ; KS0-C-6173
(ucs-set-char #x4FEE ?$(GT:(B) ; C01-G-543A
(ucs-set-char #x4FEE ?$@=$(B) ; J78-@-3D24
(ucs-set-char #x4FEE ?$AP^(B) ; GB0-A-505E
(ucs-set-char #x4FEE ?$B=$(B) ; J83-B-3D24
(ucs-set-char #x4FEF ?$(C\v(B) ; KS0-C-5C76
(ucs-set-char #x4FEF ?$(GT$(B) ; C01-G-5424
(ucs-set-char #x4FEF ?$@Pm(B) ; J78-@-506D
(ucs-set-char #x4FEF ?$A8)(B) ; GB0-A-3829
(ucs-set-char #x4FEF ?$BPm(B) ; J83-B-506D
(ucs-set-char #x4FF0 ?$(D1D(B) ; J90-D-3144
(ucs-set-char #x4FF0 ?$(I/H(B) ; C03-I-2F48
(ucs-set-char #x4FF1 ?$(CN|(B) ; KS0-C-4E7C
(ucs-set-char #x4FF1 ?$(GT4(B) ; C01-G-5434
(ucs-set-char #x4FF1 ?$A>c(B) ; GB0-A-3E63
(ucs-set-char #x4FF2 ?$(D1E(B) ; J90-D-3145
(ucs-set-char #x4FF2 ?$(I/M(B) ; C03-I-2F4D
(ucs-set-char #x4FF3 ?$(C[D(B) ; KS0-C-5B44
(ucs-set-char #x4FF3 ?$(GT9(B) ; C01-G-5439
(ucs-set-char #x4FF3 ?$@GP(B) ; J78-@-4750
(ucs-set-char #x4FF3 ?$AY=(B) ; GB0-A-593D
(ucs-set-char #x4FF3 ?$BGP(B) ; J83-B-4750
(ucs-set-char #x4FF4 ?$(H-q(B) ; C02-H-2D71
(ucs-set-char #x4FF5 ?$(Cxq(B) ; KS0-C-7871
(ucs-set-char #x4FF5 ?$(H-p(B) ; C02-H-2D70
(ucs-set-char #x4FF5 ?$@I6(B) ; J78-@-4936
(ucs-set-char #x4FF5 ?$BI6(B) ; J83-B-4936
(ucs-set-char #x4FF6 ?$(H-u(B) ; C02-H-2D75
(ucs-set-char #x4FF6 ?$@Ph(B) ; J78-@-5068
(ucs-set-char #x4FF6 ?$BPh(B) ; J83-B-5068
(ucs-set-char #x4FF7 ?$(H-v(B) ; C02-H-2D76
(ucs-set-char #x4FF8 ?$(C\d(B) ; KS0-C-5C64
(ucs-set-char #x4FF8 ?$(GT'(B) ; C01-G-5427
(ucs-set-char #x4FF8 ?$@Jp(B) ; J78-@-4A70
(ucs-set-char #x4FF8 ?$AY:(B) ; GB0-A-593A
(ucs-set-char #x4FF8 ?$BJp(B) ; J83-B-4A70
(ucs-set-char #x4FF9 ?$(I/D(B) ; C03-I-2F44
(ucs-set-char #x4FFA ?$(Ceo(B) ; KS0-C-656F
(ucs-set-char #x4FFA ?$(GT0(B) ; C01-G-5430
(ucs-set-char #x4FFA ?$@26(B) ; J78-@-3236
(ucs-set-char #x4FFA ?$A03(B) ; GB0-A-3033
(ucs-set-char #x4FFA ?$B26(B) ; J83-B-3236
(ucs-set-char #x4FFB ?$(I/X(B) ; C03-I-2F58
(ucs-set-char #x4FFC ?$(D1F(B) ; J90-D-3146
(ucs-set-char #x4FFC ?$(I/L(B) ; C03-I-2F4C
(ucs-set-char #x4FFD ?$(D1G(B) ; J90-D-3147
(ucs-set-char #x4FFD ?$(I/V(B) ; C03-I-2F56
(ucs-set-char #x4FFE ?$(GT=(B) ; C01-G-543D
(ucs-set-char #x4FFE ?$@Pl(B) ; J78-@-506C
(ucs-set-char #x4FFE ?$AYB(B) ; GB0-A-5942
(ucs-set-char #x4FFE ?$BPl(B) ; J83-B-506C
(ucs-set-char #x4FFF ?$(D1H(B) ; J90-D-3148
(ucs-set-char #x4FFF ?$(I/F(B) ; C03-I-2F46
(ucs-set-char #x5000 ?$(D1I(B) ; J90-D-3149
(ucs-set-char #x5000 ?$(GT1(B) ; C01-G-5431
(ucs-set-char #x5001 ?$(D1J(B) ; J90-D-314A
(ucs-set-char #x5001 ?$(J+b(B) ; C04-J-2B62
(ucs-set-char #x5002 ?$(C\1(B) ; KS0-C-5C31
(ucs-set-char #x5002 ?$(I/K(B) ; C03-I-2F4B
(ucs-set-char #x5003 ?$(I/I(B) ; C03-I-2F49
(ucs-set-char #x5004 ?$(D1K(B) ; J90-D-314B
(ucs-set-char #x5004 ?$(I/G(B) ; C03-I-2F47
(ucs-set-char #x5005 ?$(H-j(B) ; C02-H-2D6A
(ucs-set-char #x5005 ?$@Pf(B) ; J78-@-5066
(ucs-set-char #x5005 ?$BPf(B) ; J83-B-5066
(ucs-set-char #x5006 ?$(CUV(B) ; KS0-C-5556
(ucs-set-char #x5006 ?$(GT*(B) ; C01-G-542A
(ucs-set-char #x5006 ?$@Po(B) ; J78-@-506F
(ucs-set-char #x5006 ?$BPo(B) ; J83-B-506F
(ucs-set-char #x5007 ?$(D1L(B) ; J90-D-314C
(ucs-set-char #x5007 ?$(H-k(B) ; C02-H-2D6B
(ucs-set-char #x5008 ?$(I/O(B) ; C03-I-2F4F
(ucs-set-char #x5009 ?$(CsZ(B) ; KS0-C-735A
(ucs-set-char #x5009 ?$(GT?(B) ; C01-G-543F
(ucs-set-char #x5009 ?$@AR(B) ; J78-@-4152
(ucs-set-char #x5009 ?$BAR(B) ; J83-B-4152
(ucs-set-char #x500A ?$(D1M(B) ; J90-D-314D
(ucs-set-char #x500A ?$(J+d(B) ; C04-J-2B64
(ucs-set-char #x500B ?$(CKA(B) ; KS0-C-4B41
(ucs-set-char #x500B ?$(GT6(B) ; C01-G-5436
(ucs-set-char #x500B ?$@8D(B) ; J78-@-3844
(ucs-set-char #x500B ?$B8D(B) ; J83-B-3844
(ucs-set-char #x500C ?$(D1N(B) ; J90-D-314E
(ucs-set-char #x500C ?$(GT!(B) ; C01-G-5421
(ucs-set-char #x500C ?$AYD(B) ; GB0-A-5944
(ucs-set-char #x500D ?$(C[C(B) ; KS0-C-5B43
(ucs-set-char #x500D ?$(GT"(B) ; C01-G-5422
(ucs-set-char #x500D ?$@G\(B) ; J78-@-475C
(ucs-set-char #x500D ?$A16(B) ; GB0-A-3136
(ucs-set-char #x500D ?$BG\(B) ; J83-B-475C
(ucs-set-char #x500E ?$(D1O(B) ; J90-D-314F
(ucs-set-char #x500E ?$(H-~(B) ; C02-H-2D7E
(ucs-set-char #x500F ?$(GY$(B) ; C01-G-5924
(ucs-set-char #x500F ?$@`G(B) ; J78-@-6047
(ucs-set-char #x500F ?$AY?(B) ; GB0-A-593F
(ucs-set-char #x500F ?$B`G(B) ; J83-B-6047
(ucs-set-char #x5010 ?$(D1P(B) ; J90-D-3150
(ucs-set-char #x5010 ?$(I/S(B) ; C03-I-2F53
(ucs-set-char #x5011 ?$(CYz(B) ; KS0-C-597A
(ucs-set-char #x5011 ?$(GT/(B) ; C01-G-542F
(ucs-set-char #x5011 ?$@Pn(B) ; J78-@-506E
(ucs-set-char #x5011 ?$BPn(B) ; J83-B-506E
(ucs-set-char #x5012 ?$(CSn(B) ; KS0-C-536E
(ucs-set-char #x5012 ?$(GT.(B) ; C01-G-542E
(ucs-set-char #x5012 ?$@E](B) ; J78-@-455D
(ucs-set-char #x5012 ?$A59(B) ; GB0-A-3539
(ucs-set-char #x5012 ?$BE](B) ; J83-B-455D
(ucs-set-char #x5013 ?$(D1Q(B) ; J90-D-3151
(ucs-set-char #x5013 ?$(H-l(B) ; C02-H-2D6C
(ucs-set-char #x5014 ?$(GT2(B) ; C01-G-5432
(ucs-set-char #x5014 ?$@Pc(B) ; J78-@-5063
(ucs-set-char #x5014 ?$A>s(B) ; GB0-A-3E73
(ucs-set-char #x5014 ?$BPc(B) ; J83-B-5063
(ucs-set-char #x5015 ?$(H3^(B) ; C02-H-335E
(ucs-set-char #x5016 ?$(Cz8(B) ; KS0-C-7A38
(ucs-set-char #x5016 ?$(GT)(B) ; C01-G-5429
(ucs-set-char #x5016 ?$@8v(B) ; J78-@-3876
(ucs-set-char #x5016 ?$B8v(B) ; J83-B-3876
(ucs-set-char #x5017 ?$(D1R(B) ; J90-D-3152
(ucs-set-char #x5017 ?$(H-w(B) ; C02-H-2D77
(ucs-set-char #x5018 ?$(D1S(B) ; J90-D-3153
(ucs-set-char #x5018 ?$(GT8(B) ; C01-G-5438
(ucs-set-char #x5018 ?$ALH(B) ; GB0-A-4C48
(ucs-set-char #x5019 ?$(C}&(B) ; KS0-C-7D26
(ucs-set-char #x5019 ?$(GT7(B) ; C01-G-5437
(ucs-set-char #x5019 ?$@8u(B) ; J78-@-3875
(ucs-set-char #x5019 ?$A:r(B) ; GB0-A-3A72
(ucs-set-char #x5019 ?$B8u(B) ; J83-B-3875
(ucs-set-char #x501A ?$(Cko(B) ; KS0-C-6B6F
(ucs-set-char #x501A ?$(GT-(B) ; C01-G-542D
(ucs-set-char #x501A ?$@Pa(B) ; J78-@-5061
(ucs-set-char #x501A ?$ARP(B) ; GB0-A-5250
(ucs-set-char #x501A ?$BPa(B) ; J83-B-5061
(ucs-set-char #x501B ?$(D1T(B) ; J90-D-3154
(ucs-set-char #x501B ?$(H-o(B) ; C02-H-2D6F
(ucs-set-char #x501C ?$(Ct&(B) ; KS0-C-7426
(ucs-set-char #x501C ?$(D1U(B) ; J90-D-3155
(ucs-set-char #x501C ?$(H-x(B) ; C02-H-2D78
(ucs-set-char #x501C ?$AYC(B) ; GB0-A-5943
(ucs-set-char #x501D ?$(D1V(B) ; J90-D-3156
(ucs-set-char #x501D ?$(I/E(B) ; C03-I-2F45
(ucs-set-char #x501E ?$(CLJ(B) ; KS0-C-4C4A
(ucs-set-char #x501E ?$(D1W(B) ; J90-D-3157
(ucs-set-char #x501E ?$(H-i(B) ; C02-H-2D69
(ucs-set-char #x501F ?$(Cs((B) ; KS0-C-7328
(ucs-set-char #x501F ?$(GT,(B) ; C01-G-542C
(ucs-set-char #x501F ?$@<Z(B) ; J78-@-3C5A
(ucs-set-char #x501F ?$A=h(B) ; GB0-A-3D68
(ucs-set-char #x501F ?$B<Z(B) ; J83-B-3C5A
(ucs-set-char #x5020 ?$(H-y(B) ; C02-H-2D79
(ucs-set-char #x5021 ?$(Cs[(B) ; KS0-C-735B
(ucs-set-char #x5021 ?$(GT5(B) ; C01-G-5435
(ucs-set-char #x5021 ?$@Pi(B) ; J78-@-5069
(ucs-set-char #x5021 ?$A3+(B) ; GB0-A-332B
(ucs-set-char #x5021 ?$BPi(B) ; J83-B-5069
(ucs-set-char #x5022 ?$(D1X(B) ; J90-D-3158
(ucs-set-char #x5022 ?$(H-m(B) ; C02-H-2D6D
(ucs-set-char #x5023 ?$(C['(B) ; KS0-C-5B27
(ucs-set-char #x5023 ?$(GT#(B) ; C01-G-5423
(ucs-set-char #x5023 ?$@Jo(B) ; J78-@-4A6F
(ucs-set-char #x5023 ?$BJo(B) ; J83-B-4A6F
(ucs-set-char #x5024 ?$(Cv7(B) ; KS0-C-7637
(ucs-set-char #x5024 ?$(I/N(B) ; C03-I-2F4E
(ucs-set-char #x5024 ?$@CM(B) ; J78-@-434D
(ucs-set-char #x5024 ?$BCM(B) ; J83-B-434D
(ucs-set-char #x5025 ?$(GT&(B) ; C01-G-5426
(ucs-set-char #x5025 ?$@Pe(B) ; J78-@-5065
(ucs-set-char #x5025 ?$AYE(B) ; GB0-A-5945
(ucs-set-char #x5025 ?$BPe(B) ; J83-B-5065
(ucs-set-char #x5026 ?$(COf(B) ; KS0-C-4F66
(ucs-set-char #x5026 ?$(GT%(B) ; C01-G-5425
(ucs-set-char #x5026 ?$@7q(B) ; J78-@-3771
(ucs-set-char #x5026 ?$A>k(B) ; GB0-A-3E6B
(ucs-set-char #x5026 ?$B7q(B) ; J83-B-3771
(ucs-set-char #x5027 ?$(Cpr(B) ; KS0-C-7072
(ucs-set-char #x5027 ?$(D1Y(B) ; J90-D-3159
(ucs-set-char #x5027 ?$(H-z(B) ; C02-H-2D7A
(ucs-set-char #x5028 ?$(CKZ(B) ; KS0-C-4B5A
(ucs-set-char #x5028 ?$(GT3(B) ; C01-G-5433
(ucs-set-char #x5028 ?$@Pb(B) ; J78-@-5062
(ucs-set-char #x5028 ?$AYF(B) ; GB0-A-5946
(ucs-set-char #x5028 ?$BPb(B) ; J83-B-5062
(ucs-set-char #x5029 ?$(GT((B) ; C01-G-5428
(ucs-set-char #x5029 ?$@Pj(B) ; J78-@-506A
(ucs-set-char #x5029 ?$AY;(B) ; GB0-A-593B
(ucs-set-char #x5029 ?$BPj(B) ; J83-B-506A
(ucs-set-char #x502A ?$(CgR(B) ; KS0-C-6752
(ucs-set-char #x502A ?$(GT<(B) ; C01-G-543C
(ucs-set-char #x502A ?$@Pd(B) ; J78-@-5064
(ucs-set-char #x502A ?$AD_(B) ; GB0-A-445F
(ucs-set-char #x502A ?$BPd(B) ; J83-B-5064
(ucs-set-char #x502B ?$(CWC(B) ; KS0-C-5743
(ucs-set-char #x502B ?$(GT>(B) ; C01-G-543E
(ucs-set-char #x502B ?$@NQ(B) ; J78-@-4E51
(ucs-set-char #x502B ?$BNQ(B) ; J83-B-4E51
(ucs-set-char #x502C ?$(Cvp(B) ; KS0-C-7670
(ucs-set-char #x502C ?$(H-t(B) ; C02-H-2D74
(ucs-set-char #x502C ?$@Pk(B) ; J78-@-506B
(ucs-set-char #x502C ?$AY>(B) ; GB0-A-593E
(ucs-set-char #x502C ?$BPk(B) ; J83-B-506B
(ucs-set-char #x502D ?$(Ch^(B) ; KS0-C-685E
(ucs-set-char #x502D ?$(GT;(B) ; C01-G-543B
(ucs-set-char #x502D ?$@OA(B) ; J78-@-4F41
(ucs-set-char #x502D ?$AYA(B) ; GB0-A-5941
(ucs-set-char #x502D ?$BOA(B) ; J83-B-4F41
(ucs-set-char #x502E ?$(D1Z(B) ; J90-D-315A
(ucs-set-char #x502E ?$(I/Q(B) ; C03-I-2F51
(ucs-set-char #x502E ?$AY@(B) ; GB0-A-5940
(ucs-set-char #x502F ?$(H-|(B) ; C02-H-2D7C
(ucs-set-char #x5030 ?$(D1[(B) ; J90-D-315B
(ucs-set-char #x5030 ?$(H-n(B) ; C02-H-2D6E
(ucs-set-char #x5031 ?$(H-}(B) ; C02-H-2D7D
(ucs-set-char #x5032 ?$(D1\(B) ; J90-D-315C
(ucs-set-char #x5032 ?$(I/C(B) ; C03-I-2F43
(ucs-set-char #x5033 ?$(D1](B) ; J90-D-315D
(ucs-set-char #x5033 ?$(H-r(B) ; C02-H-2D72
(ucs-set-char #x5034 ?$(J+a(B) ; C04-J-2B61
(ucs-set-char #x5035 ?$(D1^(B) ; J90-D-315E
(ucs-set-char #x5035 ?$(H-{(B) ; C02-H-2D7B
(ucs-set-char #x5036 ?$(I/P(B) ; C03-I-2F50
(ucs-set-char #x5036 ?$@6f(B) ; J78-@-3666
(ucs-set-char #x5036 ?$B6f(B) ; J83-B-3666
(ucs-set-char #x5037 ?$(H-s(B) ; C02-H-2D73
(ucs-set-char #x5038 ?$(I/T(B) ; C03-I-2F54
(ucs-set-char #x5039 ?$(I/U(B) ; C03-I-2F55
(ucs-set-char #x5039 ?$@7p(B) ; J78-@-3770
(ucs-set-char #x5039 ?$B7p(B) ; J83-B-3770
(ucs-set-char #x503A ?$AU.(B) ; GB0-A-552E
(ucs-set-char #x503B ?$(Ce&(B) ; KS0-C-6526
(ucs-set-char #x503B ?$(D1v(B) ; J90-D-3176
(ucs-set-char #x503C ?$(GT+(B) ; C01-G-542B
(ucs-set-char #x503C ?$AV5(B) ; GB0-A-5635
(ucs-set-char #x503E ?$AGc(B) ; GB0-A-4763
(ucs-set-char #x5040 ?$(D1_(B) ; J90-D-315F
(ucs-set-char #x5040 ?$(H3f(B) ; C02-H-3366
(ucs-set-char #x5041 ?$(D1`(B) ; J90-D-3160
(ucs-set-char #x5041 ?$(H3Z(B) ; C02-H-335A
(ucs-set-char #x5042 ?$(D1a(B) ; J90-D-3161
(ucs-set-char #x5042 ?$(I4<(B) ; C03-I-343C
(ucs-set-char #x5043 ?$(Ceg(B) ; KS0-C-6567
(ucs-set-char #x5043 ?$(GXv(B) ; C01-G-5876
(ucs-set-char #x5043 ?$@Pp(B) ; J78-@-5070
(ucs-set-char #x5043 ?$AYH(B) ; GB0-A-5948
(ucs-set-char #x5043 ?$BPp(B) ; J83-B-5070
(ucs-set-char #x5044 ?$(I4?(B) ; C03-I-343F
(ucs-set-char #x5045 ?$(D1b(B) ; J90-D-3162
(ucs-set-char #x5045 ?$(H3_(B) ; C02-H-335F
(ucs-set-char #x5046 ?$(D1c(B) ; J90-D-3163
(ucs-set-char #x5046 ?$(H3e(B) ; C02-H-3365
(ucs-set-char #x5047 ?$(CJ#(B) ; KS0-C-4A23
(ucs-set-char #x5047 ?$(GXu(B) ; C01-G-5875
(ucs-set-char #x5047 ?$@Pq(B) ; J78-@-5071
(ucs-set-char #x5047 ?$A<Y(B) ; GB0-A-3C59
(ucs-set-char #x5047 ?$BPq(B) ; J83-B-5071
(ucs-set-char #x5048 ?$(CL'(B) ; KS0-C-4C27
(ucs-set-char #x5048 ?$(H3X(B) ; C02-H-3358
(ucs-set-char #x5048 ?$@Pu(B) ; J78-@-5075
(ucs-set-char #x5048 ?$AYJ(B) ; GB0-A-594A
(ucs-set-char #x5048 ?$BPu(B) ; J83-B-5075
(ucs-set-char #x5049 ?$(CjI(B) ; KS0-C-6A49
(ucs-set-char #x5049 ?$(GXy(B) ; C01-G-5879
(ucs-set-char #x5049 ?$@0N(B) ; J78-@-304E
(ucs-set-char #x5049 ?$B0N(B) ; J83-B-304E
(ucs-set-char #x504A ?$(D1d(B) ; J90-D-3164
(ucs-set-char #x504A ?$(H3\(B) ; C02-H-335C
(ucs-set-char #x504B ?$(H3U(B) ; C02-H-3355
(ucs-set-char #x504C ?$(D1e(B) ; J90-D-3165
(ucs-set-char #x504C ?$(GXw(B) ; C01-G-5877
(ucs-set-char #x504C ?$AY<(B) ; GB0-A-593C
(ucs-set-char #x504D ?$(H3Y(B) ; C02-H-3359
(ucs-set-char #x504E ?$(D1f(B) ; J90-D-3166
(ucs-set-char #x504E ?$(GX|(B) ; C01-G-587C
(ucs-set-char #x504E ?$AYK(B) ; GB0-A-594B
(ucs-set-char #x504F ?$(Cx6(B) ; KS0-C-7836
(ucs-set-char #x504F ?$(GY#(B) ; C01-G-5923
(ucs-set-char #x504F ?$@JP(B) ; J78-@-4A50
(ucs-set-char #x504F ?$AF+(B) ; GB0-A-462B
(ucs-set-char #x504F ?$BJP(B) ; J83-B-4A50
(ucs-set-char #x5050 ?$(I4D(B) ; C03-I-3444
(ucs-set-char #x5050 ?$@Pt(B) ; J78-@-5074
(ucs-set-char #x5050 ?$BPt(B) ; J83-B-5074
(ucs-set-char #x5051 ?$(D1g(B) ; J90-D-3167
(ucs-set-char #x5051 ?$(H3j(B) ; C02-H-336A
(ucs-set-char #x5052 ?$(D1h(B) ; J90-D-3168
(ucs-set-char #x5052 ?$(I4A(B) ; C03-I-3441
(ucs-set-char #x5053 ?$(D1i(B) ; J90-D-3169
(ucs-set-char #x5053 ?$(H3T(B) ; C02-H-3354
(ucs-set-char #x5054 ?$(I4B(B) ; C03-I-3442
(ucs-set-char #x5055 ?$(Cz%(B) ; KS0-C-7A25
(ucs-set-char #x5055 ?$(GX}(B) ; C01-G-587D
(ucs-set-char #x5055 ?$@Ps(B) ; J78-@-5073
(ucs-set-char #x5055 ?$AYI(B) ; GB0-A-5949
(ucs-set-char #x5055 ?$BPs(B) ; J83-B-5073
(ucs-set-char #x5056 ?$(I/W(B) ; C03-I-2F57
(ucs-set-char #x5056 ?$@Pw(B) ; J78-@-5077
(ucs-set-char #x5056 ?$BPw(B) ; J83-B-5077
(ucs-set-char #x5057 ?$(D1j(B) ; J90-D-316A
(ucs-set-char #x5057 ?$(H3i(B) ; C02-H-3369
(ucs-set-char #x5058 ?$(I4G(B) ; C03-I-3447
(ucs-set-char #x5059 ?$(D1k(B) ; J90-D-316B
(ucs-set-char #x5059 ?$(I4=(B) ; C03-I-343D
(ucs-set-char #x505A ?$(Cq.(B) ; KS0-C-712E
(ucs-set-char #x505A ?$(GXx(B) ; C01-G-5878
(ucs-set-char #x505A ?$@Pv(B) ; J78-@-5076
(ucs-set-char #x505A ?$AWv(B) ; GB0-A-5776
(ucs-set-char #x505A ?$BPv(B) ; J83-B-5076
(ucs-set-char #x505B ?$(H3[(B) ; C02-H-335B
(ucs-set-char #x505C ?$(CoN(B) ; KS0-C-6F4E
(ucs-set-char #x505C ?$(GXt(B) ; C01-G-5874
(ucs-set-char #x505C ?$@Dd(B) ; J78-@-4464
(ucs-set-char #x505C ?$AM#(B) ; GB0-A-4D23
(ucs-set-char #x505C ?$BDd(B) ; J83-B-4464
(ucs-set-char #x505D ?$(H3V(B) ; C02-H-3356
(ucs-set-char #x505E ?$(H3R(B) ; C02-H-3352
(ucs-set-char #x505F ?$(D1l(B) ; J90-D-316C
(ucs-set-char #x505F ?$(H3`(B) ; C02-H-3360
(ucs-set-char #x5060 ?$(D1m(B) ; J90-D-316D
(ucs-set-char #x5060 ?$(H3S(B) ; C02-H-3353
(ucs-set-char #x5061 ?$(H3Q(B) ; C02-H-3351
(ucs-set-char #x5062 ?$(D1n(B) ; J90-D-316E
(ucs-set-char #x5062 ?$(H3](B) ; C02-H-335D
(ucs-set-char #x5063 ?$(D1o(B) ; J90-D-316F
(ucs-set-char #x5063 ?$(H3c(B) ; C02-H-3363
(ucs-set-char #x5064 ?$(H3d(B) ; C02-H-3364
(ucs-set-char #x5065 ?$(CKm(B) ; KS0-C-4B6D
(ucs-set-char #x5065 ?$(GXz(B) ; C01-G-587A
(ucs-set-char #x5065 ?$@7r(B) ; J78-@-3772
(ucs-set-char #x5065 ?$A=!(B) ; GB0-A-3D21
(ucs-set-char #x5065 ?$B7r(B) ; J83-B-3772
(ucs-set-char #x5066 ?$(D1p(B) ; J90-D-3170
(ucs-set-char #x5066 ?$(I4@(B) ; C03-I-3440
(ucs-set-char #x5067 ?$(D1q(B) ; J90-D-3171
(ucs-set-char #x5067 ?$(J0G(B) ; C04-J-3047
(ucs-set-char #x5068 ?$(H:?(B) ; C02-H-3A3F
(ucs-set-char #x5069 ?$(H3a(B) ; C02-H-3361
(ucs-set-char #x506A ?$(D1r(B) ; J90-D-3172
(ucs-set-char #x506A ?$(H3P(B) ; C02-H-3350
(ucs-set-char #x506B ?$(H3b(B) ; C02-H-3362
(ucs-set-char #x506C ?$(I4K(B) ; C03-I-344B
(ucs-set-char #x506C ?$@Px(B) ; J78-@-5078
(ucs-set-char #x506C ?$AYL(B) ; GB0-A-594C
(ucs-set-char #x506C ?$BPx(B) ; J83-B-5078
(ucs-set-char #x506D ?$(D1s(B) ; J90-D-3173
(ucs-set-char #x506D ?$(GY&(B) ; C01-G-5926
(ucs-set-char #x506E ?$(H3g(B) ; C02-H-3367
(ucs-set-char #x506F ?$(GY%(B) ; C01-G-5925
(ucs-set-char #x5070 ?$(D1t(B) ; J90-D-3174
(ucs-set-char #x5070 ?$(H3O(B) ; C02-H-334F
(ucs-set-char #x5071 ?$(D1u(B) ; J90-D-3175
(ucs-set-char #x5071 ?$(I4C(B) ; C03-I-3443
(ucs-set-char #x5072 ?$(H3W(B) ; C02-H-3357
(ucs-set-char #x5072 ?$@<E(B) ; J78-@-3C45
(ucs-set-char #x5072 ?$B<E(B) ; J83-B-3C45
(ucs-set-char #x5073 ?$(H3h(B) ; C02-H-3368
(ucs-set-char #x5074 ?$(Cv0(B) ; KS0-C-7630
(ucs-set-char #x5074 ?$(GY!(B) ; C01-G-5921
(ucs-set-char #x5074 ?$@B&(B) ; J78-@-4226
(ucs-set-char #x5074 ?$BB&(B) ; J83-B-4226
(ucs-set-char #x5075 ?$(CoO(B) ; KS0-C-6F4F
(ucs-set-char #x5075 ?$(GX~(B) ; C01-G-587E
(ucs-set-char #x5075 ?$@De(B) ; J78-@-4465
(ucs-set-char #x5075 ?$BDe(B) ; J83-B-4465
(ucs-set-char #x5076 ?$(CiO(B) ; KS0-C-694F
(ucs-set-char #x5076 ?$(GX{(B) ; C01-G-587B
(ucs-set-char #x5076 ?$@6v(B) ; J78-@-3676
(ucs-set-char #x5076 ?$AE<(B) ; GB0-A-453C
(ucs-set-char #x5076 ?$B6v(B) ; J83-B-3676
(ucs-set-char #x5077 ?$(GY"(B) ; C01-G-5922
(ucs-set-char #x5077 ?$AM5(B) ; GB0-A-4D35
(ucs-set-char #x5078 ?$(Cw^(B) ; KS0-C-775E
(ucs-set-char #x5078 ?$(I4L(B) ; C03-I-344C
(ucs-set-char #x5078 ?$@Py(B) ; J78-@-5079
(ucs-set-char #x5078 ?$BPy(B) ; J83-B-5079
(ucs-set-char #x5079 ?$(I4J(B) ; C03-I-344A
(ucs-set-char #x507A ?$(GXr(B) ; C01-G-5872
(ucs-set-char #x507B ?$(I4E(B) ; C03-I-3445
(ucs-set-char #x507B ?$AYM(B) ; GB0-A-594D
(ucs-set-char #x507C ?$(I4F(B) ; C03-I-3446
(ucs-set-char #x507D ?$(GXs(B) ; C01-G-5873
(ucs-set-char #x507D ?$@56(B) ; J78-@-3536
(ucs-set-char #x507D ?$B56(B) ; J83-B-3536
(ucs-set-char #x507E ?$AYG(B) ; GB0-A-5947
(ucs-set-char #x507F ?$A3%(B) ; GB0-A-3325
(ucs-set-char #x5080 ?$(CNS(B) ; KS0-C-4E53
(ucs-set-char #x5080 ?$(G^.(B) ; C01-G-5E2E
(ucs-set-char #x5080 ?$@Pz(B) ; J78-@-507A
(ucs-set-char #x5080 ?$A?~(B) ; GB0-A-3F7E
(ucs-set-char #x5080 ?$BPz(B) ; J83-B-507A
(ucs-set-char #x5081 ?$(D1w(B) ; J90-D-3177
(ucs-set-char #x5081 ?$(I9u(B) ; C03-I-3975
(ucs-set-char #x5082 ?$(H:B(B) ; C02-H-3A42
(ucs-set-char #x5083 ?$(D1x(B) ; J90-D-3178
(ucs-set-char #x5083 ?$(H:;(B) ; C02-H-3A3B
(ucs-set-char #x5084 ?$(D1y(B) ; J90-D-3179
(ucs-set-char #x5084 ?$(J64(B) ; C04-J-3634
(ucs-set-char #x5085 ?$(C\w(B) ; KS0-C-5C77
(ucs-set-char #x5085 ?$(G^+(B) ; C01-G-5E2B
(ucs-set-char #x5085 ?$@P|(B) ; J78-@-507C
(ucs-set-char #x5085 ?$A85(B) ; GB0-A-3835
(ucs-set-char #x5085 ?$BP|(B) ; J83-B-507C
(ucs-set-char #x5086 ?$(D1z(B) ; J90-D-317A
(ucs-set-char #x5086 ?$(J63(B) ; C04-J-3633
(ucs-set-char #x5087 ?$(H:C(B) ; C02-H-3A43
(ucs-set-char #x5088 ?$(I9q(B) ; C03-I-3971
(ucs-set-char #x5088 ?$A@|(B) ; GB0-A-407C
(ucs-set-char #x5089 ?$(I9r(B) ; C03-I-3972
(ucs-set-char #x508A ?$(D1{(B) ; J90-D-317B
(ucs-set-char #x508A ?$(J66(B) ; C04-J-3636
(ucs-set-char #x508B ?$(H:9(B) ; C02-H-3A39
(ucs-set-char #x508C ?$(H:<(B) ; C02-H-3A3C
(ucs-set-char #x508D ?$(C[((B) ; KS0-C-5B28
(ucs-set-char #x508D ?$(G^*(B) ; C01-G-5E2A
(ucs-set-char #x508D ?$@K5(B) ; J78-@-4B35
(ucs-set-char #x508D ?$A0x(B) ; GB0-A-3078
(ucs-set-char #x508D ?$BK5(B) ; J83-B-4B35
(ucs-set-char #x508E ?$(D1|(B) ; J90-D-317C
(ucs-set-char #x508E ?$(H:=(B) ; C02-H-3A3D
(ucs-set-char #x508F ?$(D1}(B) ; J90-D-317D
(ucs-set-char #x508F ?$(I9o(B) ; C03-I-396F
(ucs-set-char #x5090 ?$(D1~(B) ; J90-D-317E
(ucs-set-char #x5090 ?$(J61(B) ; C04-J-3631
(ucs-set-char #x5091 ?$(CKx(B) ; KS0-C-4B78
(ucs-set-char #x5091 ?$(G^-(B) ; C01-G-5E2D
(ucs-set-char #x5091 ?$@7f(B) ; J78-@-3766
(ucs-set-char #x5091 ?$B7f(B) ; J83-B-3766
(ucs-set-char #x5092 ?$(D2!(B) ; J90-D-3221
(ucs-set-char #x5092 ?$(H:A(B) ; C02-H-3A41
(ucs-set-char #x5093 ?$(D2"(B) ; J90-D-3222
(ucs-set-char #x5093 ?$(J6<(B) ; C04-J-363C
(ucs-set-char #x5094 ?$(D2#(B) ; J90-D-3223
(ucs-set-char #x5094 ?$(H:7(B) ; C02-H-3A37
(ucs-set-char #x5095 ?$(H:6(B) ; C02-H-3A36
(ucs-set-char #x5096 ?$(D2$(B) ; J90-D-3224
(ucs-set-char #x5096 ?$(G^/(B) ; C01-G-5E2F
(ucs-set-char #x5097 ?$(I9p(B) ; C03-I-3970
(ucs-set-char #x5098 ?$(C_!(B) ; KS0-C-5F21
(ucs-set-char #x5098 ?$(G^0(B) ; C01-G-5E30
(ucs-set-char #x5098 ?$@;1(B) ; J78-@-3B31
(ucs-set-char #x5098 ?$B;1(B) ; J83-B-3B31
(ucs-set-char #x5099 ?$(C]a(B) ; KS0-C-5D61
(ucs-set-char #x5099 ?$(G^,(B) ; C01-G-5E2C
(ucs-set-char #x5099 ?$@Hw(B) ; J78-@-4877
(ucs-set-char #x5099 ?$BHw(B) ; J83-B-4877
(ucs-set-char #x509A ?$(G^1(B) ; C01-G-5E31
(ucs-set-char #x509A ?$@P{(B) ; J78-@-507B
(ucs-set-char #x509A ?$BP{(B) ; J83-B-507B
(ucs-set-char #x509B ?$(D2%(B) ; J90-D-3225
(ucs-set-char #x509B ?$(H:5(B) ; C02-H-3A35
(ucs-set-char #x509C ?$(D2&(B) ; J90-D-3226
(ucs-set-char #x509C ?$(H:@(B) ; C02-H-3A40
(ucs-set-char #x509D ?$(H:>(B) ; C02-H-3A3E
(ucs-set-char #x509E ?$(D2'(B) ; J90-D-3227
(ucs-set-char #x509E ?$(H:8(B) ; C02-H-3A38
(ucs-set-char #x509F ?$(D2((B) ; J90-D-3228
(ucs-set-char #x509F ?$(J69(B) ; C04-J-3639
(ucs-set-char #x50A0 ?$(D2)(B) ; J90-D-3229
(ucs-set-char #x50A0 ?$(J60(B) ; C04-J-3630
(ucs-set-char #x50A1 ?$(D2*(B) ; J90-D-322A
(ucs-set-char #x50A1 ?$(J6:(B) ; C04-J-363A
(ucs-set-char #x50A2 ?$(D2+(B) ; J90-D-322B
(ucs-set-char #x50A2 ?$(G^)(B) ; C01-G-5E29
(ucs-set-char #x50A3 ?$(H::(B) ; C02-H-3A3A
(ucs-set-char #x50A3 ?$A4v(B) ; GB0-A-3476
(ucs-set-char #x50A5 ?$AYN(B) ; GB0-A-594E
(ucs-set-char #x50A7 ?$AYO(B) ; GB0-A-594F
(ucs-set-char #x50A8 ?$A4"(B) ; GB0-A-3422
(ucs-set-char #x50A9 ?$AYP(B) ; GB0-A-5950
(ucs-set-char #x50AA ?$(D2,(B) ; J90-D-322C
(ucs-set-char #x50AA ?$(I@9(B) ; C03-I-4039
(ucs-set-char #x50AB ?$(I@<(B) ; C03-I-403C
(ucs-set-char #x50AC ?$(CuJ(B) ; KS0-C-754A
(ucs-set-char #x50AC ?$(Gc1(B) ; C01-G-6331
(ucs-set-char #x50AC ?$@:E(B) ; J78-@-3A45
(ucs-set-char #x50AC ?$A4_(B) ; GB0-A-345F
(ucs-set-char #x50AC ?$B:E(B) ; J83-B-3A45
(ucs-set-char #x50AD ?$(Ci6(B) ; KS0-C-6936
(ucs-set-char #x50AD ?$(Gc+(B) ; C01-G-632B
(ucs-set-char #x50AD ?$@MC(B) ; J78-@-4D43
(ucs-set-char #x50AD ?$BMC(B) ; J83-B-4D43
(ucs-set-char #x50AE ?$(HA\(B) ; C02-H-415C
(ucs-set-char #x50AF ?$(D2-(B) ; J90-D-322D
(ucs-set-char #x50AF ?$(Gc4(B) ; C01-G-6334
(ucs-set-char #x50B0 ?$(D2.(B) ; J90-D-322E
(ucs-set-char #x50B0 ?$(HAb(B) ; C02-H-4162
(ucs-set-char #x50B1 ?$(HAe(B) ; C02-H-4165
(ucs-set-char #x50B2 ?$(Cgl(B) ; KS0-C-676C
(ucs-set-char #x50B2 ?$(Gc-(B) ; C01-G-632D
(ucs-set-char #x50B2 ?$@P~(B) ; J78-@-507E
(ucs-set-char #x50B2 ?$A0A(B) ; GB0-A-3041
(ucs-set-char #x50B2 ?$BP~(B) ; J83-B-507E
(ucs-set-char #x50B3 ?$(Cnn(B) ; KS0-C-6E6E
(ucs-set-char #x50B3 ?$(Gc.(B) ; C01-G-632E
(ucs-set-char #x50B3 ?$@Q#(B) ; J78-@-5123
(ucs-set-char #x50B3 ?$BQ#(B) ; J83-B-5123
(ucs-set-char #x50B4 ?$(HA_(B) ; C02-H-415F
(ucs-set-char #x50B4 ?$@P}(B) ; J78-@-507D
(ucs-set-char #x50B4 ?$BP}(B) ; J83-B-507D
(ucs-set-char #x50B5 ?$(Csp(B) ; KS0-C-7370
(ucs-set-char #x50B5 ?$(Gc,(B) ; C01-G-632C
(ucs-set-char #x50B5 ?$@:D(B) ; J78-@-3A44
(ucs-set-char #x50B5 ?$B:D(B) ; J83-B-3A44
(ucs-set-char #x50B6 ?$(HAh(B) ; C02-H-4168
(ucs-set-char #x50B7 ?$(C_?(B) ; KS0-C-5F3F
(ucs-set-char #x50B7 ?$(Gc2(B) ; C01-G-6332
(ucs-set-char #x50B7 ?$@=}(B) ; J78-@-3D7D
(ucs-set-char #x50B7 ?$B=}(B) ; J83-B-3D7D
(ucs-set-char #x50B8 ?$(HAi(B) ; C02-H-4169
(ucs-set-char #x50B9 ?$(D2/(B) ; J90-D-322F
(ucs-set-char #x50B9 ?$(I@:(B) ; C03-I-403A
(ucs-set-char #x50BA ?$(D20(B) ; J90-D-3230
(ucs-set-char #x50BA ?$(HAd(B) ; C02-H-4164
(ucs-set-char #x50BA ?$AYQ(B) ; GB0-A-5951
(ucs-set-char #x50BB ?$(Gc3(B) ; C01-G-6333
(ucs-set-char #x50BB ?$AI5(B) ; GB0-A-4935
(ucs-set-char #x50BC ?$(I@7(B) ; C03-I-4037
(ucs-set-char #x50BD ?$(D21(B) ; J90-D-3231
(ucs-set-char #x50BD ?$(HAY(B) ; C02-H-4159
(ucs-set-char #x50BE ?$(CLK(B) ; KS0-C-4C4B
(ucs-set-char #x50BE ?$(Gc0(B) ; C01-G-6330
(ucs-set-char #x50BE ?$@79(B) ; J78-@-3739
(ucs-set-char #x50BE ?$B79(B) ; J83-B-3739
(ucs-set-char #x50BF ?$(HAZ(B) ; C02-H-415A
(ucs-set-char #x50C0 ?$(D22(B) ; J90-D-3232
(ucs-set-char #x50C0 ?$(J<)(B) ; C04-J-3C29
(ucs-set-char #x50C1 ?$(HAc(B) ; C02-H-4163
(ucs-set-char #x50C2 ?$(HAa(B) ; C02-H-4161
(ucs-set-char #x50C2 ?$@Q$(B) ; J78-@-5124
(ucs-set-char #x50C2 ?$BQ$(B) ; J83-B-5124
(ucs-set-char #x50C3 ?$(D23(B) ; J90-D-3233
(ucs-set-char #x50C3 ?$(I@=(B) ; C03-I-403D
(ucs-set-char #x50C4 ?$(D24(B) ; J90-D-3234
(ucs-set-char #x50C4 ?$(HA](B) ; C02-H-415D
(ucs-set-char #x50C5 ?$(CPA(B) ; KS0-C-5041
(ucs-set-char #x50C5 ?$(Gc/(B) ; C01-G-632F
(ucs-set-char #x50C5 ?$@6O(B) ; J78-@-364F
(ucs-set-char #x50C5 ?$B6O(B) ; J83-B-364F
(ucs-set-char #x50C6 ?$(HA[(B) ; C02-H-415B
(ucs-set-char #x50C7 ?$(D25(B) ; J90-D-3235
(ucs-set-char #x50C7 ?$(Gc5(B) ; C01-G-6335
(ucs-set-char #x50C8 ?$(HA`(B) ; C02-H-4160
(ucs-set-char #x50C9 ?$(CtR(B) ; KS0-C-7452
(ucs-set-char #x50C9 ?$(HAg(B) ; C02-H-4167
(ucs-set-char #x50C9 ?$@Q!(B) ; J78-@-5121
(ucs-set-char #x50C9 ?$BQ!(B) ; J83-B-5121
(ucs-set-char #x50CA ?$(C`:(B) ; KS0-C-603A
(ucs-set-char #x50CA ?$(HA^(B) ; C02-H-415E
(ucs-set-char #x50CA ?$@Q"(B) ; J78-@-5122
(ucs-set-char #x50CA ?$BQ"(B) ; J83-B-5122
(ucs-set-char #x50CB ?$(HAf(B) ; C02-H-4166
(ucs-set-char #x50CC ?$(D26(B) ; J90-D-3236
(ucs-set-char #x50CC ?$(I@6(B) ; C03-I-4036
(ucs-set-char #x50CD ?$(I@>(B) ; C03-I-403E
(ucs-set-char #x50CD ?$@F/(B) ; J78-@-462F
(ucs-set-char #x50CD ?$BF/(B) ; J83-B-462F
(ucs-set-char #x50CE ?$(D27(B) ; J90-D-3237
(ucs-set-char #x50CE ?$(Gg|(B) ; C01-G-677C
(ucs-set-char #x50CF ?$(C_@(B) ; KS0-C-5F40
(ucs-set-char #x50CF ?$(Ggy(B) ; C01-G-6779
(ucs-set-char #x50CF ?$@A|(B) ; J78-@-417C
(ucs-set-char #x50CF ?$AOq(B) ; GB0-A-4F71
(ucs-set-char #x50CF ?$BA|(B) ; J83-B-417C
(ucs-set-char #x50D0 ?$(D28(B) ; J90-D-3238
(ucs-set-char #x50D0 ?$(IEk(B) ; C03-I-456B
(ucs-set-char #x50D1 ?$(CN`(B) ; KS0-C-4E60
(ucs-set-char #x50D1 ?$(Ggz(B) ; C01-G-677A
(ucs-set-char #x50D1 ?$@6#(B) ; J78-@-3623
(ucs-set-char #x50D1 ?$B6#(B) ; J83-B-3623
(ucs-set-char #x50D2 ?$(JB-(B) ; C04-J-422D
(ucs-set-char #x50D3 ?$(D29(B) ; J90-D-3239
(ucs-set-char #x50D3 ?$(HI!(B) ; C02-H-4921
(ucs-set-char #x50D4 ?$(D2:(B) ; J90-D-323A
(ucs-set-char #x50D4 ?$(HHw(B) ; C02-H-4877
(ucs-set-char #x50D5 ?$(C\R(B) ; KS0-C-5C52
(ucs-set-char #x50D5 ?$(Ggx(B) ; C01-G-6778
(ucs-set-char #x50D5 ?$@KM(B) ; J78-@-4B4D
(ucs-set-char #x50D5 ?$BKM(B) ; J83-B-4B4D
(ucs-set-char #x50D6 ?$(C}j(B) ; KS0-C-7D6A
(ucs-set-char #x50D6 ?$(Ggu(B) ; C01-G-6775
(ucs-set-char #x50D6 ?$@Q%(B) ; J78-@-5125
(ucs-set-char #x50D6 ?$AYR(B) ; GB0-A-5952
(ucs-set-char #x50D6 ?$BQ%(B) ; J83-B-5125
(ucs-set-char #x50D7 ?$(HHx(B) ; C02-H-4878
(ucs-set-char #x50D8 ?$(D2;(B) ; J90-D-323B
(ucs-set-char #x50D8 ?$(IEn(B) ; C03-I-456E
(ucs-set-char #x50D9 ?$(IEl(B) ; C03-I-456C
(ucs-set-char #x50DA ?$(CVv(B) ; KS0-C-5676
(ucs-set-char #x50DA ?$(Ggw(B) ; C01-G-6777
(ucs-set-char #x50DA ?$@N=(B) ; J78-@-4E3D
(ucs-set-char #x50DA ?$AAE(B) ; GB0-A-4145
(ucs-set-char #x50DA ?$BN=(B) ; J83-B-4E3D
(ucs-set-char #x50DB ?$(HH{(B) ; C02-H-487B
(ucs-set-char #x50DC ?$(D2<(B) ; J90-D-323C
(ucs-set-char #x50DC ?$(IEm(B) ; C03-I-456D
(ucs-set-char #x50DD ?$(D2=(B) ; J90-D-323D
(ucs-set-char #x50DD ?$(HH}(B) ; C02-H-487D
(ucs-set-char #x50DE ?$(CjJ(B) ; KS0-C-6A4A
(ucs-set-char #x50DE ?$(IEv(B) ; C03-I-4576
(ucs-set-char #x50DE ?$@Q&(B) ; J78-@-5126
(ucs-set-char #x50DE ?$BQ&(B) ; J83-B-5126
(ucs-set-char #x50DF ?$(D2>(B) ; J90-D-323E
(ucs-set-char #x50DF ?$(JB5(B) ; C04-J-4235
(ucs-set-char #x50E0 ?$(HI&(B) ; C02-H-4926
(ucs-set-char #x50E1 ?$(IEp(B) ; C03-I-4570
(ucs-set-char #x50E2 ?$(D2?(B) ; J90-D-323F
(ucs-set-char #x50E2 ?$(IEu(B) ; C03-I-4575
(ucs-set-char #x50E3 ?$(HI%(B) ; C02-H-4925
(ucs-set-char #x50E3 ?$@Q)(B) ; J78-@-5129
(ucs-set-char #x50E3 ?$BQ)(B) ; J83-B-5129
(ucs-set-char #x50E4 ?$(D2@(B) ; J90-D-3240
(ucs-set-char #x50E4 ?$(HH~(B) ; C02-H-487E
(ucs-set-char #x50E5 ?$(Chi(B) ; KS0-C-6869
(ucs-set-char #x50E5 ?$(Ggt(B) ; C01-G-6774
(ucs-set-char #x50E5 ?$@Q'(B) ; J78-@-5127
(ucs-set-char #x50E5 ?$BQ'(B) ; J83-B-5127
(ucs-set-char #x50E6 ?$(D2A(B) ; J90-D-3241
(ucs-set-char #x50E6 ?$(HHv(B) ; C02-H-4876
(ucs-set-char #x50E6 ?$AYV(B) ; GB0-A-5956
(ucs-set-char #x50E7 ?$(Cc,(B) ; KS0-C-632C
(ucs-set-char #x50E7 ?$(Ggr(B) ; C01-G-6772
(ucs-set-char #x50E7 ?$(J<0(B) ; C04-J-3C30
(ucs-set-char #x50E7 ?$@AN(B) ; J78-@-414E
(ucs-set-char #x50E7 ?$AI.(B) ; GB0-A-492E
(ucs-set-char #x50E7 ?$BAN(B) ; J83-B-414E
(ucs-set-char #x50E8 ?$(D2B(B) ; J90-D-3242
(ucs-set-char #x50E8 ?$(HHy(B) ; C02-H-4879
(ucs-set-char #x50E9 ?$(D2C(B) ; J90-D-3243
(ucs-set-char #x50E9 ?$(Gg}(B) ; C01-G-677D
(ucs-set-char #x50EA ?$(HH|(B) ; C02-H-487C
(ucs-set-char #x50EB ?$(IEq(B) ; C03-I-4571
(ucs-set-char #x50EC ?$(HI"(B) ; C02-H-4922
(ucs-set-char #x50EC ?$AYU(B) ; GB0-A-5955
(ucs-set-char #x50ED ?$(CsP(B) ; KS0-C-7350
(ucs-set-char #x50ED ?$(Ggv(B) ; C01-G-6776
(ucs-set-char #x50ED ?$@Q((B) ; J78-@-5128
(ucs-set-char #x50ED ?$AYT(B) ; GB0-A-5954
(ucs-set-char #x50ED ?$BQ((B) ; J83-B-5128
(ucs-set-char #x50EE ?$(Ggs(B) ; C01-G-6773
(ucs-set-char #x50EE ?$@Q*(B) ; J78-@-512A
(ucs-set-char #x50EE ?$AYW(B) ; GB0-A-5957
(ucs-set-char #x50EE ?$BQ*(B) ; J83-B-512A
(ucs-set-char #x50EF ?$(D2D(B) ; J90-D-3244
(ucs-set-char #x50EF ?$(HI$(B) ; C02-H-4924
(ucs-set-char #x50F0 ?$(HI#(B) ; C02-H-4923
(ucs-set-char #x50F1 ?$(D2E(B) ; J90-D-3245
(ucs-set-char #x50F1 ?$(Gg{(B) ; C01-G-677B
(ucs-set-char #x50F2 ?$(D2Q(B) ; J90-D-3251
(ucs-set-char #x50F3 ?$(HHz(B) ; C02-H-487A
(ucs-set-char #x50F3 ?$AK[(B) ; GB0-A-4B5B
(ucs-set-char #x50F4 ?$(IEt(B) ; C03-I-4574
(ucs-set-char #x50F5 ?$(Gl#(B) ; C01-G-6C23
(ucs-set-char #x50F5 ?$@Q,(B) ; J78-@-512C
(ucs-set-char #x50F5 ?$A=)(B) ; GB0-A-3D29
(ucs-set-char #x50F5 ?$BQ,(B) ; J83-B-512C
(ucs-set-char #x50F6 ?$(D2F(B) ; J90-D-3246
(ucs-set-char #x50F6 ?$(HOT(B) ; C02-H-4F54
(ucs-set-char #x50F7 ?$(IK)(B) ; C03-I-4B29
(ucs-set-char #x50F8 ?$(HOQ(B) ; C02-H-4F51
(ucs-set-char #x50F9 ?$(CJ$(B) ; KS0-C-4A24
(ucs-set-char #x50F9 ?$(Gl$(B) ; C01-G-6C24
(ucs-set-char #x50F9 ?$@Q+(B) ; J78-@-512B
(ucs-set-char #x50F9 ?$BQ+(B) ; J83-B-512B
(ucs-set-char #x50FA ?$(D2G(B) ; J90-D-3247
(ucs-set-char #x50FA ?$(JHy(B) ; C04-J-4879
(ucs-set-char #x50FB ?$(C[x(B) ; KS0-C-5B78
(ucs-set-char #x50FB ?$(Gl"(B) ; C01-G-6C22
(ucs-set-char #x50FB ?$@JH(B) ; J78-@-4A48
(ucs-set-char #x50FB ?$AF'(B) ; GB0-A-4627
(ucs-set-char #x50FB ?$BJH(B) ; J83-B-4A48
(ucs-set-char #x50FC ?$(IK+(B) ; C03-I-4B2B
(ucs-set-char #x50FD ?$(HOX(B) ; C02-H-4F58
(ucs-set-char #x50FE ?$(D2H(B) ; J90-D-3248
(ucs-set-char #x50FE ?$(HOU(B) ; C02-H-4F55
(ucs-set-char #x50FF ?$(C^G(B) ; KS0-C-5E47
(ucs-set-char #x50FF ?$(HON(B) ; C02-H-4F4E
(ucs-set-char #x5100 ?$(Ckp(B) ; KS0-C-6B70
(ucs-set-char #x5100 ?$(Gl!(B) ; C01-G-6C21
(ucs-set-char #x5100 ?$@57(B) ; J78-@-3537
(ucs-set-char #x5100 ?$B57(B) ; J83-B-3537
(ucs-set-char #x5101 ?$(CqV(B) ; KS0-C-7156
(ucs-set-char #x5101 ?$(IK-(B) ; C03-I-4B2D
(ucs-set-char #x5101 ?$@Q.(B) ; J78-@-512E
(ucs-set-char #x5101 ?$BQ.(B) ; J83-B-512E
(ucs-set-char #x5102 ?$(Gl%(B) ; C01-G-6C25
(ucs-set-char #x5102 ?$@Q/(B) ; J78-@-512F
(ucs-set-char #x5102 ?$BQ/(B) ; J83-B-512F
(ucs-set-char #x5103 ?$(D2I(B) ; J90-D-3249
(ucs-set-char #x5103 ?$(HOO(B) ; C02-H-4F4F
(ucs-set-char #x5104 ?$(Ceb(B) ; KS0-C-6562
(ucs-set-char #x5104 ?$(Gk~(B) ; C01-G-6B7E
(ucs-set-char #x5104 ?$@2/(B) ; J78-@-322F
(ucs-set-char #x5104 ?$B2/(B) ; J83-B-322F
(ucs-set-char #x5105 ?$(Gl((B) ; C01-G-6C28
(ucs-set-char #x5106 ?$(CLL(B) ; KS0-C-4C4C
(ucs-set-char #x5106 ?$(D2J(B) ; J90-D-324A
(ucs-set-char #x5106 ?$(HOR(B) ; C02-H-4F52
(ucs-set-char #x5106 ?$AYS(B) ; GB0-A-5953
(ucs-set-char #x5107 ?$(D2K(B) ; J90-D-324B
(ucs-set-char #x5107 ?$(HOS(B) ; C02-H-4F53
(ucs-set-char #x5107 ?$AYX(B) ; GB0-A-5958
(ucs-set-char #x5108 ?$(D2L(B) ; J90-D-324C
(ucs-set-char #x5108 ?$(Gl&(B) ; C01-G-6C26
(ucs-set-char #x5109 ?$(CK{(B) ; KS0-C-4B7B
(ucs-set-char #x5109 ?$(Gl'(B) ; C01-G-6C27
(ucs-set-char #x5109 ?$@Q-(B) ; J78-@-512D
(ucs-set-char #x5109 ?$BQ-(B) ; J83-B-512D
(ucs-set-char #x510A ?$(HOY(B) ; C02-H-4F59
(ucs-set-char #x510B ?$(D2M(B) ; J90-D-324D
(ucs-set-char #x510B ?$(HOV(B) ; C02-H-4F56
(ucs-set-char #x510B ?$AYY(B) ; GB0-A-5959
(ucs-set-char #x510C ?$(D2N(B) ; J90-D-324E
(ucs-set-char #x510C ?$(HOW(B) ; C02-H-4F57
(ucs-set-char #x510D ?$(D2O(B) ; J90-D-324F
(ucs-set-char #x510D ?$(IK,(B) ; C03-I-4B2C
(ucs-set-char #x510E ?$(D2P(B) ; J90-D-3250
(ucs-set-char #x510E ?$(IK'(B) ; C03-I-4B27
(ucs-set-char #x5110 ?$(D2R(B) ; J90-D-3252
(ucs-set-char #x5110 ?$(Gp3(B) ; C01-G-7033
(ucs-set-char #x5111 ?$(HVC(B) ; C02-H-5643
(ucs-set-char #x5112 ?$(Cjc(B) ; KS0-C-6A63
(ucs-set-char #x5112 ?$(Gp0(B) ; C01-G-7030
(ucs-set-char #x5112 ?$@<t(B) ; J78-@-3C74
(ucs-set-char #x5112 ?$AHe(B) ; GB0-A-4865
(ucs-set-char #x5112 ?$B<t(B) ; J83-B-3C74
(ucs-set-char #x5113 ?$(HV@(B) ; C02-H-5640
(ucs-set-char #x5114 ?$(Gp2(B) ; C01-G-7032
(ucs-set-char #x5114 ?$@Q2(B) ; J78-@-5132
(ucs-set-char #x5114 ?$BQ2(B) ; J83-B-5132
(ucs-set-char #x5115 ?$(Gp4(B) ; C01-G-7034
(ucs-set-char #x5115 ?$@Q1(B) ; J78-@-5131
(ucs-set-char #x5115 ?$BQ1(B) ; J83-B-5131
(ucs-set-char #x5116 ?$(IP1(B) ; C03-I-5031
(ucs-set-char #x5116 ?$@Q0(B) ; J78-@-5130
(ucs-set-char #x5116 ?$BQ0(B) ; J83-B-5130
(ucs-set-char #x5117 ?$(D2S(B) ; J90-D-3253
(ucs-set-char #x5117 ?$(HVA(B) ; C02-H-5641
(ucs-set-char #x5118 ?$(Gp1(B) ; C01-G-7031
(ucs-set-char #x5118 ?$@Ky(B) ; J78-@-4B79
(ucs-set-char #x5118 ?$BPV(B) ; J83-B-5056
(ucs-set-char #x5119 ?$(D2T(B) ; J90-D-3254
(ucs-set-char #x5119 ?$(JOZ(B) ; C04-J-4F5A
(ucs-set-char #x511A ?$(HVB(B) ; C02-H-5642
(ucs-set-char #x511A ?$@Q3(B) ; J78-@-5133
(ucs-set-char #x511A ?$BQ3(B) ; J83-B-5133
(ucs-set-char #x511B ?$(D2U(B) ; J90-D-3255
(ucs-set-char #x511B ?$(IP5(B) ; C03-I-5035
(ucs-set-char #x511C ?$(D2V(B) ; J90-D-3256
(ucs-set-char #x511C ?$(HV?(B) ; C02-H-563F
(ucs-set-char #x511D ?$(D2W(B) ; J90-D-3257
(ucs-set-char #x511D ?$(IP0(B) ; C03-I-5030
(ucs-set-char #x511E ?$(D2X(B) ; J90-D-3258
(ucs-set-char #x511E ?$(IP4(B) ; C03-I-5034
(ucs-set-char #x511F ?$(C_A(B) ; KS0-C-5F41
(ucs-set-char #x511F ?$(GsA(B) ; C01-G-7341
(ucs-set-char #x511F ?$@=~(B) ; J78-@-3D7E
(ucs-set-char #x511F ?$B=~(B) ; J83-B-3D7E
(ucs-set-char #x5120 ?$(H\I(B) ; C02-H-5C49
(ucs-set-char #x5121 ?$(CVm(B) ; KS0-C-566D
(ucs-set-char #x5121 ?$(GsB(B) ; C01-G-7342
(ucs-set-char #x5121 ?$@Q4(B) ; J78-@-5134
(ucs-set-char #x5121 ?$A@\(B) ; GB0-A-405C
(ucs-set-char #x5121 ?$BQ4(B) ; J83-B-5134
(ucs-set-char #x5122 ?$(H\G(B) ; C02-H-5C47
(ucs-set-char #x5123 ?$(D2Y(B) ; J90-D-3259
(ucs-set-char #x5123 ?$(JUe(B) ; C04-J-5565
(ucs-set-char #x5124 ?$(H\H(B) ; C02-H-5C48
(ucs-set-char #x5125 ?$(H\F(B) ; C02-H-5C46
(ucs-set-char #x5126 ?$(H\E(B) ; C02-H-5C45
(ucs-set-char #x5127 ?$(D2Z(B) ; J90-D-325A
(ucs-set-char #x5127 ?$(ITA(B) ; C03-I-5441
(ucs-set-char #x5128 ?$(D2[(B) ; J90-D-325B
(ucs-set-char #x5128 ?$(IT@(B) ; C03-I-5440
(ucs-set-char #x5129 ?$(H\J(B) ; C02-H-5C4A
(ucs-set-char #x512A ?$(CiP(B) ; KS0-C-6950
(ucs-set-char #x512A ?$(Gs@(B) ; C01-G-7340
(ucs-set-char #x512A ?$@M%(B) ; J78-@-4D25
(ucs-set-char #x512A ?$BM%(B) ; J83-B-4D25
(ucs-set-char #x512B ?$(IP3(B) ; C03-I-5033
(ucs-set-char #x512C ?$(D2\(B) ; J90-D-325C
(ucs-set-char #x512C ?$(JUi(B) ; C04-J-5569
(ucs-set-char #x512D ?$(D2](B) ; J90-D-325D
(ucs-set-char #x512D ?$(HaD(B) ; C02-H-6144
(ucs-set-char #x512E ?$(HaE(B) ; C02-H-6145
(ucs-set-char #x512F ?$(D2^(B) ; J90-D-325E
(ucs-set-char #x512F ?$(IWR(B) ; C03-I-5752
(ucs-set-char #x5130 ?$(HOP(B) ; C02-H-4F50
(ucs-set-char #x5131 ?$(D2_(B) ; J90-D-325F
(ucs-set-char #x5131 ?$(HaC(B) ; C02-H-6143
(ucs-set-char #x5132 ?$(Cn9(B) ; KS0-C-6E39
(ucs-set-char #x5132 ?$(GsC(B) ; C01-G-7343
(ucs-set-char #x5132 ?$@LY(B) ; J78-@-4C59
(ucs-set-char #x5132 ?$BLY(B) ; J83-B-4C59
(ucs-set-char #x5133 ?$(D2`(B) ; J90-D-3260
(ucs-set-char #x5133 ?$(Gx+(B) ; C01-G-782B
(ucs-set-char #x5134 ?$(D2a(B) ; J90-D-3261
(ucs-set-char #x5134 ?$(He7(B) ; C02-H-6537
(ucs-set-char #x5135 ?$(D2b(B) ; J90-D-3262
(ucs-set-char #x5135 ?$(He8(B) ; C02-H-6538
(ucs-set-char #x5136 ?$(I\2(B) ; C03-I-5C32
(ucs-set-char #x5137 ?$(CUc(B) ; KS0-C-5563
(ucs-set-char #x5137 ?$(Gzb(B) ; C01-G-7A62
(ucs-set-char #x5137 ?$@Q6(B) ; J78-@-5136
(ucs-set-char #x5137 ?$BQ6(B) ; J83-B-5136
(ucs-set-char #x5138 ?$(D2c(B) ; J90-D-3263
(ucs-set-char #x5138 ?$(Gzc(B) ; C01-G-7A63
(ucs-set-char #x5139 ?$(D2d(B) ; J90-D-3264
(ucs-set-char #x5139 ?$(HkO(B) ; C02-H-6B4F
(ucs-set-char #x513A ?$(CQS(B) ; KS0-C-5153
(ucs-set-char #x513A ?$(HkN(B) ; C02-H-6B4E
(ucs-set-char #x513A ?$@Q5(B) ; J78-@-5135
(ucs-set-char #x513A ?$BQ5(B) ; J83-B-5135
(ucs-set-char #x513B ?$(G{X(B) ; C01-G-7B58
(ucs-set-char #x513B ?$@Q8(B) ; J78-@-5138
(ucs-set-char #x513B ?$BQ8(B) ; J83-B-5138
(ucs-set-char #x513C ?$(Cep(B) ; KS0-C-6570
(ucs-set-char #x513C ?$(G{W(B) ; C01-G-7B57
(ucs-set-char #x513C ?$@Q7(B) ; J78-@-5137
(ucs-set-char #x513C ?$BQ7(B) ; J83-B-5137
(ucs-set-char #x513D ?$(Hn}(B) ; C02-H-6E7D
(ucs-set-char #x513E ?$(I`o(B) ; C03-I-606F

(ucs-set-char #x513F ?$A6y(B) ; GB0-A-3679
(ucs-set-char #x513F ?$(GD*(B) ; C01-G-442A
(ucs-set-char #x513F ?$@Q9(B) ; J78-@-5139
(ucs-set-char #x513F ?$BQ9(B) ; J83-B-5139

(ucs-set-char #x5140 ?$(Ch4(B) ; KS0-C-6834
(ucs-set-char #x5140 ?$(GDB(B) ; C01-G-4442
(ucs-set-char #x5140 ?$@Q:(B) ; J78-@-513A
(ucs-set-char #x5140 ?$AX#(B) ; GB0-A-5823
(ucs-set-char #x5140 ?$BQ:(B) ; J83-B-513A
(ucs-set-char #x5141 ?$(CkC(B) ; KS0-C-6B43
(ucs-set-char #x5141 ?$(GDx(B) ; C01-G-4478
(ucs-set-char #x5141 ?$@0t(B) ; J78-@-3074
(ucs-set-char #x5141 ?$ATJ(B) ; GB0-A-544A
(ucs-set-char #x5141 ?$B0t(B) ; J83-B-3074
(ucs-set-char #x5142 ?$(D2e(B) ; J90-D-3265
(ucs-set-char #x5142 ?$(J!=(B) ; C04-J-213D
(ucs-set-char #x5143 ?$(Cj*(B) ; KS0-C-6A2A
(ucs-set-char #x5143 ?$(GDw(B) ; C01-G-4477
(ucs-set-char #x5143 ?$@85(B) ; J78-@-3835
(ucs-set-char #x5143 ?$AT*(B) ; GB0-A-542A
(ucs-set-char #x5143 ?$B85(B) ; J83-B-3835
(ucs-set-char #x5144 ?$(Cz|(B) ; KS0-C-7A7C
(ucs-set-char #x5144 ?$(GEs(B) ; C01-G-4573
(ucs-set-char #x5144 ?$@7;(B) ; J78-@-373B
(ucs-set-char #x5144 ?$APV(B) ; GB0-A-5056
(ucs-set-char #x5144 ?$B7;(B) ; J83-B-373B
(ucs-set-char #x5145 ?$(Cuv(B) ; KS0-C-7576
(ucs-set-char #x5145 ?$(GEr(B) ; C01-G-4572
(ucs-set-char #x5145 ?$(L#R(B) ; C06-L-2352
(ucs-set-char #x5145 ?$@=<(B) ; J78-@-3D3C
(ucs-set-char #x5145 ?$A3d(B) ; GB0-A-3364
(ucs-set-char #x5145 ?$B=<(B) ; J83-B-3D3C
(ucs-set-char #x5146 ?$(Cp<(B) ; KS0-C-703C
(ucs-set-char #x5146 ?$(GG>(B) ; C01-G-473E
(ucs-set-char #x5146 ?$@C{(B) ; J78-@-437B
(ucs-set-char #x5146 ?$AUW(B) ; GB0-A-5557
(ucs-set-char #x5146 ?$BC{(B) ; J83-B-437B
(ucs-set-char #x5147 ?$(C}T(B) ; KS0-C-7D54
(ucs-set-char #x5147 ?$(GG=(B) ; C01-G-473D
(ucs-set-char #x5147 ?$@6$(B) ; J78-@-3624
(ucs-set-char #x5147 ?$B6$(B) ; J83-B-3624
(ucs-set-char #x5148 ?$(C`;(B) ; KS0-C-603B
(ucs-set-char #x5148 ?$(GG?(B) ; C01-G-473F
(ucs-set-char #x5148 ?$@@h(B) ; J78-@-4068
(ucs-set-char #x5148 ?$AOH(B) ; GB0-A-4F48
(ucs-set-char #x5148 ?$B@h(B) ; J83-B-4068
(ucs-set-char #x5149 ?$(CNC(B) ; KS0-C-4E43
(ucs-set-char #x5149 ?$(GG<(B) ; C01-G-473C
(ucs-set-char #x5149 ?$@8w(B) ; J78-@-3877
(ucs-set-char #x5149 ?$A9b(B) ; GB0-A-3962
(ucs-set-char #x5149 ?$B8w(B) ; J83-B-3877
(ucs-set-char #x514A ?$(D2f(B) ; J90-D-3266
(ucs-set-char #x514A ?$(I"x(B) ; C03-I-2278
(ucs-set-char #x514B ?$(CP:(B) ; KS0-C-503A
(ucs-set-char #x514B ?$(GI,(B) ; C01-G-492C
(ucs-set-char #x514B ?$@9n(B) ; J78-@-396E
(ucs-set-char #x514B ?$A?K(B) ; GB0-A-3F4B
(ucs-set-char #x514B ?$B9n(B) ; J83-B-396E
(ucs-set-char #x514C ?$(Cw:(B) ; KS0-C-773A
(ucs-set-char #x514C ?$(GI+(B) ; C01-G-492B
(ucs-set-char #x514C ?$@Q<(B) ; J78-@-513C
(ucs-set-char #x514C ?$BQ<(B) ; J83-B-513C
(ucs-set-char #x514D ?$(CXs(B) ; KS0-C-5873
(ucs-set-char #x514D ?$(GI-(B) ; C01-G-492D
(ucs-set-char #x514D ?$(I$R(B) ; C03-I-2452
(ucs-set-char #x514D ?$@LH(B) ; J78-@-4C48
(ucs-set-char #x514D ?$ACb(B) ; GB0-A-4362
(ucs-set-char #x514D ?$BLH(B) ; J83-B-4C48
(ucs-set-char #x514E ?$(CwM(B) ; KS0-C-774D
(ucs-set-char #x514E ?$(I$T(B) ; C03-I-2454
(ucs-set-char #x514E ?$@EF(B) ; J78-@-4546
(ucs-set-char #x514E ?$BEF(B) ; J83-B-4546
(ucs-set-char #x514F ?$(D2g(B) ; J90-D-3267
(ucs-set-char #x514F ?$(J#;(B) ; C04-J-233B
(ucs-set-char #x5150 ?$(I$S(B) ; C03-I-2453
(ucs-set-char #x5150 ?$@;y(B) ; J78-@-3B79
(ucs-set-char #x5150 ?$B;y(B) ; J83-B-3B79
(ucs-set-char #x5151 ?$(I$Q(B) ; C03-I-2451
(ucs-set-char #x5151 ?$A6R(B) ; GB0-A-3652
(ucs-set-char #x5152 ?$(Cd.(B) ; KS0-C-642E
(ucs-set-char #x5152 ?$(GL#(B) ; C01-G-4C23
(ucs-set-char #x5152 ?$@Q;(B) ; J78-@-513B
(ucs-set-char #x5152 ?$BQ;(B) ; J83-B-513B
(ucs-set-char #x5153 ?$(D2h(B) ; J90-D-3268
(ucs-set-char #x5153 ?$(J%?(B) ; C04-J-253F
(ucs-set-char #x5154 ?$(GL"(B) ; C01-G-4C22
(ucs-set-char #x5154 ?$(I'S(B) ; C03-I-2753
(ucs-set-char #x5154 ?$@Q=(B) ; J78-@-513D
(ucs-set-char #x5154 ?$AMC(B) ; GB0-A-4D43
(ucs-set-char #x5154 ?$BQ=(B) ; J83-B-513D
(ucs-set-char #x5155 ?$(D2i(B) ; J90-D-3269
(ucs-set-char #x5155 ?$(GL$(B) ; C01-G-4C24
(ucs-set-char #x5155 ?$AYn(B) ; GB0-A-596E
(ucs-set-char #x5156 ?$(I'R(B) ; C03-I-2752
(ucs-set-char #x5156 ?$AYp(B) ; GB0-A-5970
(ucs-set-char #x5157 ?$(D2j(B) ; J90-D-326A
(ucs-set-char #x5157 ?$(GP"(B) ; C01-G-5022
(ucs-set-char #x5158 ?$(D2k(B) ; J90-D-326B
(ucs-set-char #x5158 ?$(J(@(B) ; C04-J-2840
(ucs-set-char #x5159 ?$(G"y(B) ; C01-G-2279
(ucs-set-char #x515A ?$(H.!(B) ; C02-H-2E21
(ucs-set-char #x515A ?$@E^(B) ; J78-@-455E
(ucs-set-char #x515A ?$A53(B) ; GB0-A-3533
(ucs-set-char #x515A ?$BE^(B) ; J83-B-455E
(ucs-set-char #x515B ?$(G"z(B) ; C01-G-227A
(ucs-set-char #x515C ?$(CT_(B) ; KS0-C-545F
(ucs-set-char #x515C ?$(GY'(B) ; C01-G-5927
(ucs-set-char #x515C ?$@3u(B) ; J78-@-3375
(ucs-set-char #x515C ?$A65(B) ; GB0-A-3635
(ucs-set-char #x515C ?$B3u(B) ; J83-B-3375
(ucs-set-char #x515D ?$(G"|(B) ; C01-G-227C
(ucs-set-char #x515E ?$(G"{(B) ; C01-G-227B
(ucs-set-char #x515F ?$(D2l(B) ; J90-D-326C
(ucs-set-char #x515F ?$(H:D(B) ; C02-H-3A44
(ucs-set-char #x5160 ?$(I9v(B) ; C03-I-3976
(ucs-set-char #x5161 ?$(G"}(B) ; C01-G-227D
(ucs-set-char #x5162 ?$(CPg(B) ; KS0-C-5067
(ucs-set-char #x5162 ?$(Gg~(B) ; C01-G-677E
(ucs-set-char #x5162 ?$@Q>(B) ; J78-@-513E
(ucs-set-char #x5162 ?$A>$(B) ; GB0-A-3E24
(ucs-set-char #x5162 ?$BQ>(B) ; J83-B-513E
(ucs-set-char #x5163 ?$(G"~(B) ; C01-G-227E
(ucs-set-char #x5164 ?$(D2m(B) ; J90-D-326D
(ucs-set-char #x5164 ?$(I^%(B) ; C03-I-5E25

(ucs-set-char #x5165 ?$AHk(B) ; GB0-A-486B
(ucs-set-char #x5165 ?$(Cl}(B) ; KS0-C-6C7D
(ucs-set-char #x5165 ?$(GD+(B) ; C01-G-442B
(ucs-set-char #x5165 ?$@F~(B) ; J78-@-467E
(ucs-set-char #x5165 ?$BF~(B) ; J83-B-467E

(ucs-set-char #x5166 ?$(D2n(B) ; J90-D-326E
(ucs-set-char #x5166 ?$(I!4(B) ; C03-I-2134
(ucs-set-char #x5167 ?$(CR.(B) ; KS0-C-522E
(ucs-set-char #x5167 ?$(GDy(B) ; C01-G-4479
(ucs-set-char #x5168 ?$(Cno(B) ; KS0-C-6E6F
(ucs-set-char #x5168 ?$(GG@(B) ; C01-G-4740
(ucs-set-char #x5168 ?$@A4(B) ; J78-@-4134
(ucs-set-char #x5168 ?$AH+(B) ; GB0-A-482B
(ucs-set-char #x5168 ?$BA4(B) ; J83-B-4134
(ucs-set-char #x5169 ?$(CUW(B) ; KS0-C-5557
(ucs-set-char #x5169 ?$(GL%(B) ; C01-G-4C25
(ucs-set-char #x5169 ?$@Q@(B) ; J78-@-5140
(ucs-set-char #x5169 ?$BQ@(B) ; J83-B-5140
(ucs-set-char #x516A ?$(Cjd(B) ; KS0-C-6A64
(ucs-set-char #x516A ?$(I+7(B) ; C03-I-2B37
(ucs-set-char #x516A ?$@QA(B) ; J78-@-5141
(ucs-set-char #x516A ?$BQA(B) ; J83-B-5141

(ucs-set-char #x516B ?$A0K(B) ; GB0-A-304B
(ucs-set-char #x516B ?$(Cx"(B) ; KS0-C-7822
(ucs-set-char #x516B ?$(GD,(B) ; C01-G-442C
(ucs-set-char #x516B ?$@H,(B) ; J78-@-482C
(ucs-set-char #x516B ?$BH,(B) ; J83-B-482C

(ucs-set-char #x516C ?$(CMk(B) ; KS0-C-4D6B
(ucs-set-char #x516C ?$(GD|(B) ; C01-G-447C
(ucs-set-char #x516C ?$@8x(B) ; J78-@-3878
(ucs-set-char #x516C ?$A9+(B) ; GB0-A-392B
(ucs-set-char #x516C ?$B8x(B) ; J83-B-3878
(ucs-set-char #x516D ?$(CW?(B) ; KS0-C-573F
(ucs-set-char #x516D ?$(GDz(B) ; C01-G-447A
(ucs-set-char #x516D ?$@O;(B) ; J78-@-4F3B
(ucs-set-char #x516D ?$AAy(B) ; GB0-A-4179
(ucs-set-char #x516D ?$BO;(B) ; J83-B-4F3B
(ucs-set-char #x516E ?$(C{1(B) ; KS0-C-7B31
(ucs-set-char #x516E ?$(GD{(B) ; C01-G-447B
(ucs-set-char #x516E ?$@QB(B) ; J78-@-5142
(ucs-set-char #x516E ?$AYb(B) ; GB0-A-5962
(ucs-set-char #x516E ?$BQB(B) ; J83-B-5142
(ucs-set-char #x5170 ?$A@<(B) ; GB0-A-403C
(ucs-set-char #x5171 ?$(CMl(B) ; KS0-C-4D6C
(ucs-set-char #x5171 ?$(GGA(B) ; C01-G-4741
(ucs-set-char #x5171 ?$@6&(B) ; J78-@-3626
(ucs-set-char #x5171 ?$A92(B) ; GB0-A-3932
(ucs-set-char #x5171 ?$B6&(B) ; J83-B-3626
(ucs-set-char #x5172 ?$(I"z(B) ; C03-I-227A
(ucs-set-char #x5173 ?$(J"4(B) ; C04-J-2234
(ucs-set-char #x5173 ?$A9X(B) ; GB0-A-3958
(ucs-set-char #x5174 ?$APK(B) ; GB0-A-504B
(ucs-set-char #x5175 ?$(C\2(B) ; KS0-C-5C32
(ucs-set-char #x5175 ?$(GI.(B) ; C01-G-492E
(ucs-set-char #x5175 ?$@J<(B) ; J78-@-4A3C
(ucs-set-char #x5175 ?$A1x(B) ; GB0-A-3178
(ucs-set-char #x5175 ?$BJ<(B) ; J83-B-4A3C
(ucs-set-char #x5176 ?$(CPl(B) ; KS0-C-506C
(ucs-set-char #x5176 ?$(GL'(B) ; C01-G-4C27
(ucs-set-char #x5176 ?$@B6(B) ; J78-@-4236
(ucs-set-char #x5176 ?$AFd(B) ; GB0-A-4664
(ucs-set-char #x5176 ?$BB6(B) ; J83-B-4236
(ucs-set-char #x5177 ?$(CN}(B) ; KS0-C-4E7D
(ucs-set-char #x5177 ?$(GL&(B) ; C01-G-4C26
(ucs-set-char #x5177 ?$@6q(B) ; J78-@-3671
(ucs-set-char #x5177 ?$A>_(B) ; GB0-A-3E5F
(ucs-set-char #x5177 ?$B6q(B) ; J83-B-3671
(ucs-set-char #x5178 ?$(Cnp(B) ; KS0-C-6E70
(ucs-set-char #x5178 ?$(GL((B) ; C01-G-4C28
(ucs-set-char #x5178 ?$@E5(B) ; J78-@-4535
(ucs-set-char #x5178 ?$A5d(B) ; GB0-A-3564
(ucs-set-char #x5178 ?$BE5(B) ; J83-B-4535
(ucs-set-char #x5179 ?$(I.{(B) ; C03-I-2E7B
(ucs-set-char #x5179 ?$AWH(B) ; GB0-A-5748
(ucs-set-char #x517B ?$AQx(B) ; GB0-A-5178
(ucs-set-char #x517C ?$(CLB(B) ; KS0-C-4C42
(ucs-set-char #x517C ?$(GT@(B) ; C01-G-5440
(ucs-set-char #x517C ?$@7s(B) ; J78-@-3773
(ucs-set-char #x517C ?$A<f(B) ; GB0-A-3C66
(ucs-set-char #x517C ?$B7s(B) ; J83-B-3773
(ucs-set-char #x517D ?$AJ^(B) ; GB0-A-4A5E
(ucs-set-char #x517E ?$(D2o(B) ; J90-D-326F
(ucs-set-char #x517E ?$(I@?(B) ; C03-I-403F
(ucs-set-char #x5180 ?$(CPm(B) ; KS0-C-506D
(ucs-set-char #x5180 ?$(Gp5(B) ; C01-G-7035
(ucs-set-char #x5180 ?$@QC(B) ; J78-@-5143
(ucs-set-char #x5180 ?$A<=(B) ; GB0-A-3C3D
(ucs-set-char #x5180 ?$BQC(B) ; J83-B-5143
(ucs-set-char #x5181 ?$AYf(B) ; GB0-A-5966

(ucs-set-char #x5182 ?$AXg(B) ; GB0-A-5867
(ucs-set-char #x5182 ?$(I!'(B) ; C03-I-2127
(ucs-set-char #x5182 ?$@QD(B) ; J78-@-5144
(ucs-set-char #x5182 ?$BQD(B) ; J83-B-5144

(ucs-set-char #x5183 ?$(D2p(B) ; J90-D-3270
(ucs-set-char #x5183 ?$(J!>(B) ; C04-J-213E
(ucs-set-char #x5184 ?$(D2q(B) ; J90-D-3271
(ucs-set-char #x5184 ?$(I!M(B) ; C03-I-214D
(ucs-set-char #x5185 ?$(I!H(B) ; C03-I-2148
(ucs-set-char #x5185 ?$(L!P(B) ; C06-L-2150
(ucs-set-char #x5185 ?$@Fb(B) ; J78-@-4662
(ucs-set-char #x5185 ?$ADZ(B) ; GB0-A-445A
(ucs-set-char #x5185 ?$BFb(B) ; J83-B-4662
(ucs-set-char #x5186 ?$(Cew(B) ; KS0-C-6577
(ucs-set-char #x5186 ?$(I!N(B) ; C03-I-214E
(ucs-set-char #x5186 ?$@1_(B) ; J78-@-315F
(ucs-set-char #x5186 ?$B1_(B) ; J83-B-315F
(ucs-set-char #x5187 ?$(H!.(B) ; C02-H-212E
(ucs-set-char #x5188 ?$(J!R(B) ; C04-J-2152
(ucs-set-char #x5188 ?$A8T(B) ; GB0-A-3854
(ucs-set-char #x5189 ?$(GEt(B) ; C01-G-4574
(ucs-set-char #x5189 ?$@QG(B) ; J78-@-5147
(ucs-set-char #x5189 ?$AH=(B) ; GB0-A-483D
(ucs-set-char #x5189 ?$BQG(B) ; J83-B-5147
(ucs-set-char #x518A ?$(Cs|(B) ; KS0-C-737C
(ucs-set-char #x518A ?$(GEu(B) ; C01-G-4575
(ucs-set-char #x518A ?$@:}(B) ; J78-@-3A7D
(ucs-set-char #x518A ?$B:}(B) ; J83-B-3A7D
(ucs-set-char #x518B ?$(D2r(B) ; J90-D-3272
(ucs-set-char #x518B ?$(I!x(B) ; C03-I-2178
(ucs-set-char #x518C ?$(I!y(B) ; C03-I-2179
(ucs-set-char #x518C ?$@QF(B) ; J78-@-5146
(ucs-set-char #x518C ?$A2a(B) ; GB0-A-3261
(ucs-set-char #x518C ?$BQF(B) ; J83-B-5146
(ucs-set-char #x518D ?$(Cn"(B) ; KS0-C-6E22
(ucs-set-char #x518D ?$(GGB(B) ; C01-G-4742
(ucs-set-char #x518D ?$(I"{(B) ; C03-I-227B
(ucs-set-char #x518D ?$@:F(B) ; J78-@-3A46
(ucs-set-char #x518D ?$ATY(B) ; GB0-A-5459
(ucs-set-char #x518D ?$B:F(B) ; J83-B-3A46
(ucs-set-char #x518E ?$(D2s(B) ; J90-D-3273
(ucs-set-char #x518E ?$(J"6(B) ; C04-J-2236
(ucs-set-char #x518F ?$(H#,(B) ; C02-H-232C
(ucs-set-char #x518F ?$@QH(B) ; J78-@-5148
(ucs-set-char #x518F ?$BQH(B) ; J83-B-5148
(ucs-set-char #x5190 ?$(I'U(B) ; C03-I-2755
(ucs-set-char #x5190 ?$@fn(B) ; J78-@-666E
(ucs-set-char #x5190 ?$Bfn(B) ; J83-B-666E
(ucs-set-char #x5191 ?$(GP$(B) ; C01-G-5024
(ucs-set-char #x5191 ?$@QI(B) ; J78-@-5149
(ucs-set-char #x5191 ?$BQI(B) ; J83-B-5149
(ucs-set-char #x5192 ?$(CY3(B) ; KS0-C-5933
(ucs-set-char #x5192 ?$(GP#(B) ; C01-G-5023
(ucs-set-char #x5192 ?$(L1m(B) ; C06-L-316D
(ucs-set-char #x5192 ?$@KA(B) ; J78-@-4B41
(ucs-set-char #x5192 ?$AC0(B) ; GB0-A-4330
(ucs-set-char #x5192 ?$BKA(B) ; J83-B-4B41
(ucs-set-char #x5193 ?$(H.#(B) ; C02-H-2E23
(ucs-set-char #x5193 ?$@QJ(B) ; J78-@-514A
(ucs-set-char #x5193 ?$BQJ(B) ; J83-B-514A
(ucs-set-char #x5194 ?$(H."(B) ; C02-H-2E22
(ucs-set-char #x5195 ?$(CXt(B) ; KS0-C-5874
(ucs-set-char #x5195 ?$(GY((B) ; C01-G-5928
(ucs-set-char #x5195 ?$@QK(B) ; J78-@-514B
(ucs-set-char #x5195 ?$ACa(B) ; GB0-A-4361
(ucs-set-char #x5195 ?$BQK(B) ; J83-B-514B

(ucs-set-char #x5196 ?$AZ"(B) ; GB0-A-5A22
(ucs-set-char #x5196 ?$(I!((B) ; C03-I-2128
(ucs-set-char #x5196 ?$@QL(B) ; J78-@-514C
(ucs-set-char #x5196 ?$BQL(B) ; J83-B-514C

(ucs-set-char #x5197 ?$(Ci7(B) ; KS0-C-6937
(ucs-set-char #x5197 ?$(GD}(B) ; C01-G-447D
(ucs-set-char #x5197 ?$@>i(B) ; J78-@-3E69
(ucs-set-char #x5197 ?$AH_(B) ; GB0-A-485F
(ucs-set-char #x5197 ?$B>i(B) ; J83-B-3E69
(ucs-set-char #x5198 ?$(D2t(B) ; J90-D-3274
(ucs-set-char #x5198 ?$(H!5(B) ; C02-H-2135
(ucs-set-char #x5199 ?$(I!z(B) ; C03-I-217A
(ucs-set-char #x5199 ?$@<L(B) ; J78-@-3C4C
(ucs-set-char #x5199 ?$AP4(B) ; GB0-A-5034
(ucs-set-char #x5199 ?$B<L(B) ; J83-B-3C4C
(ucs-set-char #x519B ?$A>|(B) ; GB0-A-3E7C
(ucs-set-char #x519C ?$AE)(B) ; GB0-A-4529
(ucs-set-char #x519D ?$(D2u(B) ; J90-D-3275
(ucs-set-char #x519D ?$(I$W(B) ; C03-I-2457
(ucs-set-char #x519E ?$(H%M(B) ; C02-H-254D
(ucs-set-char #x519F ?$(I+9(B) ; C03-I-2B39
(ucs-set-char #x51A0 ?$(CN.(B) ; KS0-C-4E2E
(ucs-set-char #x51A0 ?$(GP%(B) ; C01-G-5025
(ucs-set-char #x51A0 ?$@4'(B) ; J78-@-3427
(ucs-set-char #x51A0 ?$A9Z(B) ; GB0-A-395A
(ucs-set-char #x51A0 ?$B4'(B) ; J83-B-3427
(ucs-set-char #x51A1 ?$(D2v(B) ; J90-D-3276
(ucs-set-char #x51A1 ?$(I/[(B) ; C03-I-2F5B
(ucs-set-char #x51A2 ?$(GTC(B) ; C01-G-5443
(ucs-set-char #x51A2 ?$@QO(B) ; J78-@-514F
(ucs-set-char #x51A2 ?$AZ#(B) ; GB0-A-5A23
(ucs-set-char #x51A2 ?$BQO(B) ; J83-B-514F
(ucs-set-char #x51A3 ?$(D2w(B) ; J90-D-3277
(ucs-set-char #x51A3 ?$(I/Y(B) ; C03-I-2F59
(ucs-set-char #x51A4 ?$(GTA(B) ; C01-G-5441
(ucs-set-char #x51A4 ?$@QM(B) ; J78-@-514D
(ucs-set-char #x51A4 ?$AT)(B) ; GB0-A-5429
(ucs-set-char #x51A4 ?$BQM(B) ; J83-B-514D
(ucs-set-char #x51A5 ?$(CY"(B) ; KS0-C-5922
(ucs-set-char #x51A5 ?$(GTB(B) ; C01-G-5442
(ucs-set-char #x51A5 ?$@L=(B) ; J78-@-4C3D
(ucs-set-char #x51A5 ?$AZ$(B) ; GB0-A-5A24
(ucs-set-char #x51A5 ?$BL=(B) ; J83-B-4C3D
(ucs-set-char #x51A6 ?$(I/Z(B) ; C03-I-2F5A
(ucs-set-char #x51A6 ?$@QN(B) ; J78-@-514E
(ucs-set-char #x51A6 ?$BQN(B) ; J83-B-514E
(ucs-set-char #x51A8 ?$(I4M(B) ; C03-I-344D
(ucs-set-char #x51A8 ?$@IZ(B) ; J78-@-495A
(ucs-set-char #x51A8 ?$BIZ(B) ; J83-B-495A
(ucs-set-char #x51A9 ?$@QP(B) ; J78-@-5150
(ucs-set-char #x51A9 ?$BQP(B) ; J83-B-5150
(ucs-set-char #x51AA ?$(CXq(B) ; KS0-C-5871
(ucs-set-char #x51AA ?$(Gp6(B) ; C01-G-7036
(ucs-set-char #x51AA ?$@QQ(B) ; J78-@-5151
(ucs-set-char #x51AA ?$BQQ(B) ; J83-B-5151

(ucs-set-char #x51AB ?$AY{(B) ; GB0-A-597B
(ucs-set-char #x51AB ?$@QR(B) ; J78-@-5152
(ucs-set-char #x51AB ?$BQR(B) ; J83-B-5152

(ucs-set-char #x51AC ?$(CTO(B) ; KS0-C-544F
(ucs-set-char #x51AC ?$(GEv(B) ; C01-G-4576
(ucs-set-char #x51AC ?$@E_(B) ; J78-@-455F
(ucs-set-char #x51AC ?$A6,(B) ; GB0-A-362C
(ucs-set-char #x51AC ?$BE_(B) ; J83-B-455F
(ucs-set-char #x51AD ?$(D2x(B) ; J90-D-3278
(ucs-set-char #x51AD ?$(J!^(B) ; C04-J-215E
(ucs-set-char #x51AF ?$A7k(B) ; GB0-A-376B
(ucs-set-char #x51B0 ?$(GGC(B) ; C01-G-4743
(ucs-set-char #x51B0 ?$@QV(B) ; J78-@-5156
(ucs-set-char #x51B0 ?$A1y(B) ; GB0-A-3179
(ucs-set-char #x51B0 ?$BQV(B) ; J83-B-5156
(ucs-set-char #x51B1 ?$(H!{(B) ; C02-H-217B
(ucs-set-char #x51B1 ?$@QT(B) ; J78-@-5154
(ucs-set-char #x51B1 ?$AY|(B) ; GB0-A-597C
(ucs-set-char #x51B1 ?$BQT(B) ; J83-B-5154
(ucs-set-char #x51B2 ?$(I"~(B) ; C03-I-227E
(ucs-set-char #x51B2 ?$@QU(B) ; J78-@-5155
(ucs-set-char #x51B2 ?$A3e(B) ; GB0-A-3365
(ucs-set-char #x51B2 ?$BQU(B) ; J83-B-5155
(ucs-set-char #x51B3 ?$(I"}(B) ; C03-I-227D
(ucs-set-char #x51B3 ?$@QS(B) ; J78-@-5153
(ucs-set-char #x51B3 ?$A>v(B) ; GB0-A-3E76
(ucs-set-char #x51B3 ?$BQS(B) ; J83-B-5153
(ucs-set-char #x51B4 ?$(I"|(B) ; C03-I-227C
(ucs-set-char #x51B4 ?$@:c(B) ; J78-@-3A63
(ucs-set-char #x51B4 ?$B:c(B) ; J83-B-3A63
(ucs-set-char #x51B5 ?$(I$A(B) ; C03-I-2441
(ucs-set-char #x51B5 ?$(I$Y(B) ; C03-I-2459
(ucs-set-char #x51B5 ?$@QW(B) ; J78-@-5157
(ucs-set-char #x51B5 ?$A?v(B) ; GB0-A-3F76
(ucs-set-char #x51B5 ?$BQW(B) ; J83-B-5157
(ucs-set-char #x51B6 ?$(Ce'(B) ; KS0-C-6527
(ucs-set-char #x51B6 ?$(GI/(B) ; C01-G-492F
(ucs-set-char #x51B6 ?$@Lj(B) ; J78-@-4C6A
(ucs-set-char #x51B6 ?$AR1(B) ; GB0-A-5231
(ucs-set-char #x51B6 ?$BLj(B) ; J83-B-4C6A
(ucs-set-char #x51B7 ?$(CUR(B) ; KS0-C-5552
(ucs-set-char #x51B7 ?$(GI0(B) ; C01-G-4930
(ucs-set-char #x51B7 ?$@Nd(B) ; J78-@-4E64
(ucs-set-char #x51B7 ?$A@d(B) ; GB0-A-4064
(ucs-set-char #x51B7 ?$BNd(B) ; J83-B-4E64
(ucs-set-char #x51B8 ?$(D2y(B) ; J90-D-3279
(ucs-set-char #x51B8 ?$(I$Z(B) ; C03-I-245A
(ucs-set-char #x51B9 ?$(H#-(B) ; C02-H-232D
(ucs-set-char #x51BA ?$(D2z(B) ; J90-D-327A
(ucs-set-char #x51BA ?$(J#=(B) ; C04-J-233D
(ucs-set-char #x51BB ?$A63(B) ; GB0-A-3633
(ucs-set-char #x51BC ?$(D2{(B) ; J90-D-327B
(ucs-set-char #x51BC ?$(H%N(B) ; C02-H-254E
(ucs-set-char #x51BC ?$AY~(B) ; GB0-A-597E
(ucs-set-char #x51BD ?$(CV)(B) ; KS0-C-5629
(ucs-set-char #x51BD ?$(GL)(B) ; C01-G-4C29
(ucs-set-char #x51BD ?$@QX(B) ; J78-@-5158
(ucs-set-char #x51BD ?$AY}(B) ; GB0-A-597D
(ucs-set-char #x51BD ?$BQX(B) ; J83-B-5158
(ucs-set-char #x51BE ?$(D2|(B) ; J90-D-327C
(ucs-set-char #x51BE ?$(H%O(B) ; C02-H-254F
(ucs-set-char #x51BF ?$(D2}(B) ; J90-D-327D
(ucs-set-char #x51BF ?$(J%@(B) ; C04-J-2540
(ucs-set-char #x51C0 ?$(J%C(B) ; C04-J-2543
(ucs-set-char #x51C0 ?$A>;(B) ; GB0-A-3E3B
(ucs-set-char #x51C1 ?$(I+;(B) ; C03-I-2B3B
(ucs-set-char #x51C2 ?$(D2~(B) ; J90-D-327E
(ucs-set-char #x51C2 ?$(I+=(B) ; C03-I-2B3D
(ucs-set-char #x51C3 ?$(I+>(B) ; C03-I-2B3E
(ucs-set-char #x51C4 ?$(Ct"(B) ; KS0-C-7422
(ucs-set-char #x51C4 ?$(H.%(B) ; C02-H-2E25
(ucs-set-char #x51C4 ?$@@((B) ; J78-@-4028
(ucs-set-char #x51C4 ?$AF`(B) ; GB0-A-4660
(ucs-set-char #x51C4 ?$B@((B) ; J83-B-4028
(ucs-set-char #x51C5 ?$(H.&(B) ; C02-H-2E26
(ucs-set-char #x51C5 ?$@QY(B) ; J78-@-5159
(ucs-set-char #x51C5 ?$BQY(B) ; J83-B-5159
(ucs-set-char #x51C6 ?$(CqW(B) ; KS0-C-7157
(ucs-set-char #x51C6 ?$(GTF(B) ; C01-G-5446
(ucs-set-char #x51C6 ?$@=Z(B) ; J78-@-3D5A
(ucs-set-char #x51C6 ?$AW<(B) ; GB0-A-573C
(ucs-set-char #x51C6 ?$B=Z(B) ; J83-B-3D5A
(ucs-set-char #x51C7 ?$(I/^(B) ; C03-I-2F5E
(ucs-set-char #x51C7 ?$AZ!(B) ; GB0-A-5A21
(ucs-set-char #x51C8 ?$(D3!(B) ; J90-D-3321
(ucs-set-char #x51C8 ?$(H.'(B) ; C02-H-2E27
(ucs-set-char #x51C9 ?$(CUX(B) ; KS0-C-5558
(ucs-set-char #x51C9 ?$(I/_(B) ; C03-I-2F5F
(ucs-set-char #x51C9 ?$@QZ(B) ; J78-@-515A
(ucs-set-char #x51C9 ?$AA9(B) ; GB0-A-4139
(ucs-set-char #x51C9 ?$BQZ(B) ; J83-B-515A
(ucs-set-char #x51CA ?$(H.$(B) ; C02-H-2E24
(ucs-set-char #x51CB ?$(Cp=(B) ; KS0-C-703D
(ucs-set-char #x51CB ?$(GTG(B) ; C01-G-5447
(ucs-set-char #x51CB ?$@C|(B) ; J78-@-437C
(ucs-set-char #x51CB ?$A5r(B) ; GB0-A-3572
(ucs-set-char #x51CB ?$BC|(B) ; J83-B-437C
(ucs-set-char #x51CC ?$(CWP(B) ; KS0-C-5750
(ucs-set-char #x51CC ?$(GTE(B) ; C01-G-5445
(ucs-set-char #x51CC ?$@N?(B) ; J78-@-4E3F
(ucs-set-char #x51CC ?$AAh(B) ; GB0-A-4168
(ucs-set-char #x51CC ?$BN?(B) ; J83-B-4E3F
(ucs-set-char #x51CD ?$(CTP(B) ; KS0-C-5450
(ucs-set-char #x51CD ?$(GTD(B) ; C01-G-5444
(ucs-set-char #x51CD ?$@E`(B) ; J78-@-4560
(ucs-set-char #x51CD ?$BE`(B) ; J83-B-4560
(ucs-set-char #x51CE ?$(H.((B) ; C02-H-2E28
(ucs-set-char #x51CF ?$(D3"(B) ; J90-D-3322
(ucs-set-char #x51CF ?$(I4O(B) ; C03-I-344F
(ucs-set-char #x51CF ?$A<u(B) ; GB0-A-3C75
(ucs-set-char #x51D0 ?$(H3k(B) ; C02-H-336B
(ucs-set-char #x51D1 ?$(D3#(B) ; J90-D-3323
(ucs-set-char #x51D1 ?$(I4N(B) ; C03-I-344E
(ucs-set-char #x51D1 ?$A4U(B) ; GB0-A-3455
(ucs-set-char #x51D2 ?$(D3$(B) ; J90-D-3324
(ucs-set-char #x51D2 ?$(I9}(B) ; C03-I-397D
(ucs-set-char #x51D3 ?$(D3%(B) ; J90-D-3325
(ucs-set-char #x51D3 ?$(I9z(B) ; C03-I-397A
(ucs-set-char #x51D4 ?$(H:E(B) ; C02-H-3A45
(ucs-set-char #x51D5 ?$(D3&(B) ; J90-D-3326
(ucs-set-char #x51D5 ?$(J6?(B) ; C04-J-363F
(ucs-set-char #x51D6 ?$(I9~(B) ; C03-I-397E
(ucs-set-char #x51D6 ?$@RE(B) ; J78-@-5245
(ucs-set-char #x51D6 ?$BRE(B) ; J83-B-5245
(ucs-set-char #x51D7 ?$(HAj(B) ; C02-H-416A
(ucs-set-char #x51D8 ?$(D3'(B) ; J90-D-3327
(ucs-set-char #x51D8 ?$(HI'(B) ; C02-H-4927
(ucs-set-char #x51D9 ?$(IK/(B) ; C03-I-4B2F
(ucs-set-char #x51DA ?$(IK.(B) ; C03-I-4B2E
(ucs-set-char #x51DB ?$(IK0(B) ; C03-I-4B30
(ucs-set-char #x51DB ?$@Q[(B) ; J78-@-515B
(ucs-set-char #x51DB ?$AA](B) ; GB0-A-415D
(ucs-set-char #x51DB ?$BQ[(B) ; J83-B-515B
(ucs-set-char #x51DC ?$(CWO(B) ; KS0-C-574F
(ucs-set-char #x51DC ?$(Gl)(B) ; C01-G-6C29
(ucs-set-char #x51DD ?$(Ckj(B) ; KS0-C-6B6A
(ucs-set-char #x51DD ?$(Gp7(B) ; C01-G-7037
(ucs-set-char #x51DD ?$@6E(B) ; J78-@-3645
(ucs-set-char #x51DD ?$AD}(B) ; GB0-A-447D
(ucs-set-char #x51DD ?$B6E(B) ; J83-B-3645
(ucs-set-char #x51DE ?$(C}k(B) ; KS0-C-7D6B
(ucs-set-char #x51DE ?$(D3((B) ; J90-D-3328
(ucs-set-char #x51DE ?$(HVD(B) ; C02-H-5644
(ucs-set-char #x51DF ?$(ITB(B) ; C03-I-5442

(ucs-set-char #x51E0 ?$A<8(B) ; GB0-A-3C38
(ucs-set-char #x51E0 ?$(GD-(B) ; C01-G-442D
(ucs-set-char #x51E0 ?$@Q\(B) ; J78-@-515C
(ucs-set-char #x51E0 ?$BQ\(B) ; J83-B-515C

(ucs-set-char #x51E1 ?$(C[m(B) ; KS0-C-5B6D
(ucs-set-char #x51E1 ?$(GD;(B) ; C01-G-443B
(ucs-set-char #x51E1 ?$@K^(B) ; J78-@-4B5E
(ucs-set-char #x51E1 ?$A72(B) ; GB0-A-3732
(ucs-set-char #x51E1 ?$BK^(B) ; J83-B-4B5E
(ucs-set-char #x51E2 ?$(D3)(B) ; J90-D-3329
(ucs-set-char #x51E2 ?$(I!/(B) ; C03-I-212F
(ucs-set-char #x51E3 ?$(I!5(B) ; C03-I-2135
(ucs-set-char #x51E4 ?$(I!Q(B) ; C03-I-2151
(ucs-set-char #x51E4 ?$A7o(B) ; GB0-A-376F
(ucs-set-char #x51E5 ?$(D3*(B) ; J90-D-332A
(ucs-set-char #x51E5 ?$(I!{(B) ; C03-I-217B
(ucs-set-char #x51E6 ?$@=h(B) ; J78-@-3D68
(ucs-set-char #x51E6 ?$B=h(B) ; J83-B-3D68
(ucs-set-char #x51E7 ?$@B|(B) ; J78-@-427C
(ucs-set-char #x51E7 ?$BB|(B) ; J83-B-427C
(ucs-set-char #x51E8 ?$(I#"(B) ; C03-I-2322
(ucs-set-char #x51E9 ?$@Q^(B) ; J78-@-515E
(ucs-set-char #x51E9 ?$BQ^(B) ; J83-B-515E
(ucs-set-char #x51EA ?$@Fd(B) ; J78-@-4664
(ucs-set-char #x51EA ?$BFd(B) ; J83-B-4664
(ucs-set-char #x51EB ?$AYl(B) ; GB0-A-596C
(ucs-set-char #x51EC ?$(I$[(B) ; C03-I-245B
(ucs-set-char #x51ED ?$(I'Y(B) ; C03-I-2759
(ucs-set-char #x51ED ?$@Q_(B) ; J78-@-515F
(ucs-set-char #x51ED ?$AF>(B) ; GB0-A-463E
(ucs-set-char #x51ED ?$BQ_(B) ; J83-B-515F
(ucs-set-char #x51EE ?$(D3+(B) ; J90-D-332B
(ucs-set-char #x51EE ?$(J%E(B) ; C04-J-2545
(ucs-set-char #x51EF ?$A?-(B) ; GB0-A-3F2D
(ucs-set-char #x51F0 ?$(C|E(B) ; KS0-C-7C45
(ucs-set-char #x51F0 ?$(GY)(B) ; C01-G-5929
(ucs-set-char #x51F0 ?$@Q`(B) ; J78-@-5160
(ucs-set-char #x51F0 ?$A;K(B) ; GB0-A-3B4B
(ucs-set-char #x51F0 ?$BQ`(B) ; J83-B-5160
(ucs-set-char #x51F1 ?$(CKB(B) ; KS0-C-4B42
(ucs-set-char #x51F1 ?$(G^3(B) ; C01-G-5E33
(ucs-set-char #x51F1 ?$@3.(B) ; J78-@-332E
(ucs-set-char #x51F1 ?$B3.(B) ; J83-B-332E
(ucs-set-char #x51F2 ?$(D3,(B) ; J90-D-332C
(ucs-set-char #x51F2 ?$(LFe(B) ; C06-L-4665
(ucs-set-char #x51F3 ?$(D3-(B) ; J90-D-332D
(ucs-set-char #x51F3 ?$(Gh!(B) ; C01-G-6821
(ucs-set-char #x51F3 ?$A5J(B) ; GB0-A-354A
(ucs-set-char #x51F4 ?$(D3.(B) ; J90-D-332E
(ucs-set-char #x51F4 ?$(IEz(B) ; C03-I-457A

(ucs-set-char #x51F5 ?$A[I(B) ; GB0-A-5B49
(ucs-set-char #x51F5 ?$(H!#(B) ; C02-H-2123
(ucs-set-char #x51F5 ?$@Qa(B) ; J78-@-5161
(ucs-set-char #x51F5 ?$BQa(B) ; J83-B-5161

(ucs-set-char #x51F6 ?$(C}U(B) ; KS0-C-7D55
(ucs-set-char #x51F6 ?$(GD~(B) ; C01-G-447E
(ucs-set-char #x51F6 ?$@6'(B) ; J78-@-3627
(ucs-set-char #x51F6 ?$APW(B) ; GB0-A-5057
(ucs-set-char #x51F6 ?$B6'(B) ; J83-B-3627
(ucs-set-char #x51F7 ?$(D3/(B) ; J90-D-332F
(ucs-set-char #x51F7 ?$(J!`(B) ; C04-J-2160
(ucs-set-char #x51F8 ?$(CtH(B) ; KS0-C-7448
(ucs-set-char #x51F8 ?$(GEy(B) ; C01-G-4579
(ucs-set-char #x51F8 ?$@FL(B) ; J78-@-464C
(ucs-set-char #x51F8 ?$AM9(B) ; GB0-A-4D39
(ucs-set-char #x51F8 ?$BFL(B) ; J83-B-464C
(ucs-set-char #x51F9 ?$(Chj(B) ; KS0-C-686A
(ucs-set-char #x51F9 ?$(GEw(B) ; C01-G-4577
(ucs-set-char #x51F9 ?$@1z(B) ; J78-@-317A
(ucs-set-char #x51F9 ?$A0<(B) ; GB0-A-303C
(ucs-set-char #x51F9 ?$B1z(B) ; J83-B-317A
(ucs-set-char #x51FA ?$(Cus(B) ; KS0-C-7573
(ucs-set-char #x51FA ?$(GEx(B) ; C01-G-4578
(ucs-set-char #x51FA ?$@=P(B) ; J78-@-3D50
(ucs-set-char #x51FA ?$A3v(B) ; GB0-A-3376
(ucs-set-char #x51FA ?$B=P(B) ; J83-B-3D50
(ucs-set-char #x51FB ?$A;w(B) ; GB0-A-3B77
(ucs-set-char #x51FC ?$A[J(B) ; GB0-A-5B4A
(ucs-set-char #x51FD ?$(Cy^(B) ; KS0-C-795E
(ucs-set-char #x51FD ?$(GL*(B) ; C01-G-4C2A
(ucs-set-char #x51FD ?$@H!(B) ; J78-@-4821
(ucs-set-char #x51FD ?$A:/(B) ; GB0-A-3A2F
(ucs-set-char #x51FD ?$BH!(B) ; J83-B-4821
(ucs-set-char #x51FE ?$(I'Z(B) ; C03-I-275A
(ucs-set-char #x51FE ?$@Qb(B) ; J78-@-5162
(ucs-set-char #x51FE ?$BQb(B) ; J83-B-5162
(ucs-set-char #x51FF ?$ATd(B) ; GB0-A-5464

(ucs-set-char #x5200 ?$A56(B) ; GB0-A-3536
(ucs-set-char #x5200 ?$(CSo(B) ; KS0-C-536F
(ucs-set-char #x5200 ?$(GD.(B) ; C01-G-442E
(ucs-set-char #x5200 ?$@Ea(B) ; J78-@-4561
(ucs-set-char #x5200 ?$BEa(B) ; J83-B-4561

(ucs-set-char #x5201 ?$(D30(B) ; J90-D-3330
(ucs-set-char #x5201 ?$(GD/(B) ; C01-G-442F
(ucs-set-char #x5201 ?$A5s(B) ; GB0-A-3573
(ucs-set-char #x5202 ?$(D31(B) ; J90-D-3331
(ucs-set-char #x5202 ?$(J!*(B) ; C04-J-212A
(ucs-set-char #x5202 ?$AXV(B) ; GB0-A-5856
(ucs-set-char #x5203 ?$(ClS(B) ; KS0-C-6C53
(ucs-set-char #x5203 ?$(GDC(B) ; C01-G-4443
(ucs-set-char #x5203 ?$(L!8(B) ; C06-L-2138
(ucs-set-char #x5203 ?$@?O(B) ; J78-@-3F4F
(ucs-set-char #x5203 ?$AHP(B) ; GB0-A-4850
(ucs-set-char #x5203 ?$B?O(B) ; J83-B-3F4F
(ucs-set-char #x5204 ?$(I!6(B) ; C03-I-2136
(ucs-set-char #x5204 ?$@Qc(B) ; J78-@-5163
(ucs-set-char #x5204 ?$BQc(B) ; J83-B-5163
(ucs-set-char #x5205 ?$(D32(B) ; J90-D-3332
(ucs-set-char #x5205 ?$(I!R(B) ; C03-I-2152
(ucs-set-char #x5206 ?$(C]B(B) ; KS0-C-5D42
(ucs-set-char #x5206 ?$(GE!(B) ; C01-G-4521
(ucs-set-char #x5206 ?$@J,(B) ; J78-@-4A2C
(ucs-set-char #x5206 ?$A7V(B) ; GB0-A-3756
(ucs-set-char #x5206 ?$BJ,(B) ; J83-B-4A2C
(ucs-set-char #x5207 ?$(Co7(B) ; KS0-C-6F37
(ucs-set-char #x5207 ?$(GE"(B) ; C01-G-4522
(ucs-set-char #x5207 ?$@@Z(B) ; J78-@-405A
(ucs-set-char #x5207 ?$AGP(B) ; GB0-A-4750
(ucs-set-char #x5207 ?$B@Z(B) ; J83-B-405A
(ucs-set-char #x5208 ?$(CgT(B) ; KS0-C-6754
(ucs-set-char #x5208 ?$(GE#(B) ; C01-G-4523
(ucs-set-char #x5208 ?$@4"(B) ; J78-@-3422
(ucs-set-char #x5208 ?$AXW(B) ; GB0-A-5857
(ucs-set-char #x5208 ?$B4"(B) ; J83-B-3422
(ucs-set-char #x5209 ?$(H!L(B) ; C02-H-214C
(ucs-set-char #x520A ?$(CJJ(B) ; KS0-C-4A4A
(ucs-set-char #x520A ?$(GEz(B) ; C01-G-457A
(ucs-set-char #x520A ?$@4)(B) ; J78-@-3429
(ucs-set-char #x520A ?$A?/(B) ; GB0-A-3F2F
(ucs-set-char #x520A ?$B4)(B) ; J83-B-3429
(ucs-set-char #x520B ?$(I!}(B) ; C03-I-217D
(ucs-set-char #x520B ?$@Qd(B) ; J78-@-5164
(ucs-set-char #x520B ?$BQd(B) ; J83-B-5164
(ucs-set-char #x520C ?$(H!K(B) ; C02-H-214B
(ucs-set-char #x520D ?$A[;(B) ; GB0-A-5B3B
(ucs-set-char #x520E ?$(CY{(B) ; KS0-C-597B
(ucs-set-char #x520E ?$(GGG(B) ; C01-G-4747
(ucs-set-char #x520E ?$@Qf(B) ; J78-@-5166
(ucs-set-char #x520E ?$AXX(B) ; GB0-A-5858
(ucs-set-char #x520E ?$BQf(B) ; J83-B-5166
(ucs-set-char #x520F ?$(I#%(B) ; C03-I-2325
(ucs-set-char #x5210 ?$(H!}(B) ; C02-H-217D
(ucs-set-char #x5211 ?$(Cz}(B) ; KS0-C-7A7D
(ucs-set-char #x5211 ?$(GGE(B) ; C01-G-4745
(ucs-set-char #x5211 ?$(I'\(B) ; C03-I-275C
(ucs-set-char #x5211 ?$@7:(B) ; J78-@-373A
(ucs-set-char #x5211 ?$APL(B) ; GB0-A-504C
(ucs-set-char #x5211 ?$B7:(B) ; J83-B-373A
(ucs-set-char #x5212 ?$(D33(B) ; J90-D-3333
(ucs-set-char #x5212 ?$(GGF(B) ; C01-G-4746
(ucs-set-char #x5212 ?$A;.(B) ; GB0-A-3B2E
(ucs-set-char #x5213 ?$(D34(B) ; J90-D-3334
(ucs-set-char #x5213 ?$(H!|(B) ; C02-H-217C
(ucs-set-char #x5214 ?$(I#$(B) ; C03-I-2324
(ucs-set-char #x5214 ?$@Qe(B) ; J78-@-5165
(ucs-set-char #x5214 ?$BQe(B) ; J83-B-5165
(ucs-set-char #x5215 ?$(D35(B) ; J90-D-3335
(ucs-set-char #x5215 ?$(I#&(B) ; C03-I-2326
(ucs-set-char #x5216 ?$(D36(B) ; J90-D-3336
(ucs-set-char #x5216 ?$(GGH(B) ; C01-G-4748
(ucs-set-char #x5216 ?$Ak>(B) ; GB0-A-6B3E
(ucs-set-char #x5217 ?$(CV*(B) ; KS0-C-562A
(ucs-set-char #x5217 ?$(GGD(B) ; C01-G-4744
(ucs-set-char #x5217 ?$@Ns(B) ; J78-@-4E73
(ucs-set-char #x5217 ?$AAP(B) ; GB0-A-4150
(ucs-set-char #x5217 ?$BNs(B) ; J83-B-4E73
(ucs-set-char #x5218 ?$(D37(B) ; J90-D-3337
(ucs-set-char #x5218 ?$(I#'(B) ; C03-I-2327
(ucs-set-char #x5218 ?$AAu(B) ; GB0-A-4175
(ucs-set-char #x5219 ?$ATr(B) ; GB0-A-5472
(ucs-set-char #x521A ?$A8U(B) ; GB0-A-3855
(ucs-set-char #x521B ?$A44(B) ; GB0-A-3434
(ucs-set-char #x521C ?$(H#.(B) ; C02-H-232E
(ucs-set-char #x521D ?$(Ctx(B) ; KS0-C-7478
(ucs-set-char #x521D ?$(GOO(B) ; C01-G-4F4F
(ucs-set-char #x521D ?$@=i(B) ; J78-@-3D69
(ucs-set-char #x521D ?$A3u(B) ; GB0-A-3375
(ucs-set-char #x521D ?$B=i(B) ; J83-B-3D69
(ucs-set-char #x521E ?$(H#/(B) ; C02-H-232F
(ucs-set-char #x521F ?$(I$_(B) ; C03-I-245F
(ucs-set-char #x5220 ?$(I$a(B) ; C03-I-2461
(ucs-set-char #x5220 ?$AI>(B) ; GB0-A-493E
(ucs-set-char #x5221 ?$(H#0(B) ; C02-H-2330
(ucs-set-char #x5222 ?$(D38(B) ; J90-D-3338
(ucs-set-char #x5222 ?$(J#@(B) ; C04-J-2340
(ucs-set-char #x5223 ?$(I$\(B) ; C03-I-245C
(ucs-set-char #x5224 ?$(Cww(B) ; KS0-C-7777
(ucs-set-char #x5224 ?$(GI2(B) ; C01-G-4932
(ucs-set-char #x5224 ?$@H=(B) ; J78-@-483D
(ucs-set-char #x5224 ?$AEP(B) ; GB0-A-4550
(ucs-set-char #x5224 ?$BH=(B) ; J83-B-483D
(ucs-set-char #x5225 ?$(C\,(B) ; KS0-C-5C2C
(ucs-set-char #x5225 ?$(GI1(B) ; C01-G-4931
(ucs-set-char #x5225 ?$@JL(B) ; J78-@-4A4C
(ucs-set-char #x5225 ?$BJL(B) ; J83-B-4A4C
(ucs-set-char #x5226 ?$(I$^(B) ; C03-I-245E
(ucs-set-char #x5227 ?$(I$](B) ; C03-I-245D
(ucs-set-char #x5227 ?$@Qg(B) ; J78-@-5167
(ucs-set-char #x5227 ?$BQg(B) ; J83-B-5167
(ucs-set-char #x5228 ?$(D39(B) ; J90-D-3339
(ucs-set-char #x5228 ?$(GI5(B) ; C01-G-4935
(ucs-set-char #x5228 ?$AEY(B) ; GB0-A-4559
(ucs-set-char #x5229 ?$(CWW(B) ; KS0-C-5757
(ucs-set-char #x5229 ?$(GI3(B) ; C01-G-4933
(ucs-set-char #x5229 ?$@Mx(B) ; J78-@-4D78
(ucs-set-char #x5229 ?$A@{(B) ; GB0-A-407B
(ucs-set-char #x5229 ?$BMx(B) ; J83-B-4D78
(ucs-set-char #x522A ?$(C_"(B) ; KS0-C-5F22
(ucs-set-char #x522A ?$(GI4(B) ; C01-G-4934
(ucs-set-char #x522A ?$@Qh(B) ; J78-@-5168
(ucs-set-char #x522A ?$BQh(B) ; J83-B-5168
(ucs-set-char #x522B ?$(I$`(B) ; C03-I-2460
(ucs-set-char #x522B ?$A1p(B) ; GB0-A-3170
(ucs-set-char #x522D ?$AXY(B) ; GB0-A-5859
(ucs-set-char #x522E ?$(CN>(B) ; KS0-C-4E3E
(ucs-set-char #x522E ?$(GL0(B) ; C01-G-4C30
(ucs-set-char #x522E ?$@Qi(B) ; J78-@-5169
(ucs-set-char #x522E ?$A9N(B) ; GB0-A-394E
(ucs-set-char #x522E ?$BQi(B) ; J83-B-5169
(ucs-set-char #x522F ?$(I'[(B) ; C03-I-275B
(ucs-set-char #x5230 ?$(CSp(B) ; KS0-C-5370
(ucs-set-char #x5230 ?$(GL/(B) ; C01-G-4C2F
(ucs-set-char #x5230 ?$@E~(B) ; J78-@-457E
(ucs-set-char #x5230 ?$A5=(B) ; GB0-A-353D
(ucs-set-char #x5230 ?$BE~(B) ; J83-B-457E
(ucs-set-char #x5231 ?$(D3:(B) ; J90-D-333A
(ucs-set-char #x5231 ?$(H%T(B) ; C02-H-2554
(ucs-set-char #x5232 ?$(D3;(B) ; J90-D-333B
(ucs-set-char #x5232 ?$(H%Q(B) ; C02-H-2551
(ucs-set-char #x5233 ?$(H%R(B) ; C02-H-2552
(ucs-set-char #x5233 ?$@Qj(B) ; J78-@-516A
(ucs-set-char #x5233 ?$AXZ(B) ; GB0-A-585A
(ucs-set-char #x5233 ?$BQj(B) ; J83-B-516A
(ucs-set-char #x5234 ?$(I'^(B) ; C03-I-275E
(ucs-set-char #x5235 ?$(D3<(B) ; J90-D-333C
(ucs-set-char #x5235 ?$(H%P(B) ; C02-H-2550
(ucs-set-char #x5236 ?$(Cp$(B) ; KS0-C-7024
(ucs-set-char #x5236 ?$(GL1(B) ; C01-G-4C31
(ucs-set-char #x5236 ?$@@)(B) ; J78-@-4029
(ucs-set-char #x5236 ?$AVF(B) ; GB0-A-5646
(ucs-set-char #x5236 ?$B@)(B) ; J83-B-4029
(ucs-set-char #x5237 ?$(Cal(B) ; KS0-C-616C
(ucs-set-char #x5237 ?$(GL-(B) ; C01-G-4C2D
(ucs-set-char #x5237 ?$@:~(B) ; J78-@-3A7E
(ucs-set-char #x5237 ?$AK"(B) ; GB0-A-4B22
(ucs-set-char #x5237 ?$B:~(B) ; J83-B-3A7E
(ucs-set-char #x5238 ?$(COg(B) ; KS0-C-4F67
(ucs-set-char #x5238 ?$(GL,(B) ; C01-G-4C2C
(ucs-set-char #x5238 ?$@7t(B) ; J78-@-3774
(ucs-set-char #x5238 ?$AH/(B) ; GB0-A-482F
(ucs-set-char #x5238 ?$B7t(B) ; J83-B-3774
(ucs-set-char #x5239 ?$(CsK(B) ; KS0-C-734B
(ucs-set-char #x5239 ?$(I'_(B) ; C03-I-275F
(ucs-set-char #x5239 ?$@Qk(B) ; J78-@-516B
(ucs-set-char #x5239 ?$AI2(B) ; GB0-A-4932
(ucs-set-char #x5239 ?$BQk(B) ; J83-B-516B
(ucs-set-char #x523A ?$(Cm)(B) ; KS0-C-6D29
(ucs-set-char #x523A ?$(GL.(B) ; C01-G-4C2E
(ucs-set-char #x523A ?$@;I(B) ; J78-@-3B49
(ucs-set-char #x523A ?$A4L(B) ; GB0-A-344C
(ucs-set-char #x523A ?$B;I(B) ; J83-B-3B49
(ucs-set-char #x523B ?$(CJ>(B) ; KS0-C-4A3E
(ucs-set-char #x523B ?$(GL+(B) ; C01-G-4C2B
(ucs-set-char #x523B ?$@9o(B) ; J78-@-396F
(ucs-set-char #x523B ?$A?L(B) ; GB0-A-3F4C
(ucs-set-char #x523B ?$B9o(B) ; J83-B-396F
(ucs-set-char #x523C ?$(D3=(B) ; J90-D-333D
(ucs-set-char #x523C ?$(I'](B) ; C03-I-275D
(ucs-set-char #x523D ?$(J%N(B) ; C04-J-254E
(ucs-set-char #x523D ?$A9t(B) ; GB0-A-3974
(ucs-set-char #x523F ?$AX[(B) ; GB0-A-585B
(ucs-set-char #x5240 ?$AX\(B) ; GB0-A-585C
(ucs-set-char #x5241 ?$(GL2(B) ; C01-G-4C32
(ucs-set-char #x5241 ?$A6g(B) ; GB0-A-3667
(ucs-set-char #x5242 ?$A<A(B) ; GB0-A-3C41
(ucs-set-char #x5243 ?$(Cto(B) ; KS0-C-746F
(ucs-set-char #x5243 ?$(GP'(B) ; C01-G-5027
(ucs-set-char #x5243 ?$@Df(B) ; J78-@-4466
(ucs-set-char #x5243 ?$ALj(B) ; GB0-A-4C6A
(ucs-set-char #x5243 ?$BDf(B) ; J83-B-4466
(ucs-set-char #x5244 ?$(H)2(B) ; C02-H-2932
(ucs-set-char #x5244 ?$@Qm(B) ; J78-@-516D
(ucs-set-char #x5244 ?$BQm(B) ; J83-B-516D
(ucs-set-char #x5245 ?$(D3>(B) ; J90-D-333E
(ucs-set-char #x5245 ?$(I+?(B) ; C03-I-2B3F
(ucs-set-char #x5246 ?$(H%S(B) ; C02-H-2553
(ucs-set-char #x5247 ?$(CvN(B) ; KS0-C-764E
(ucs-set-char #x5247 ?$(GP,(B) ; C01-G-502C
(ucs-set-char #x5247 ?$@B'(B) ; J78-@-4227
(ucs-set-char #x5247 ?$BB'(B) ; J83-B-4227
(ucs-set-char #x5248 ?$(I+@(B) ; C03-I-2B40
(ucs-set-char #x5249 ?$(D3?(B) ; J90-D-333F
(ucs-set-char #x5249 ?$(H)3(B) ; C02-H-2933
(ucs-set-char #x524A ?$(C^{(B) ; KS0-C-5E7B
(ucs-set-char #x524A ?$(GP((B) ; C01-G-5028
(ucs-set-char #x524A ?$@:o(B) ; J78-@-3A6F
(ucs-set-char #x524A ?$AOw(B) ; GB0-A-4F77
(ucs-set-char #x524A ?$B:o(B) ; J83-B-3A6F
(ucs-set-char #x524B ?$(CP;(B) ; KS0-C-503B
(ucs-set-char #x524B ?$(GP+(B) ; C01-G-502B
(ucs-set-char #x524B ?$@Qn(B) ; J78-@-516E
(ucs-set-char #x524B ?$BQn(B) ; J83-B-516E
(ucs-set-char #x524C ?$(CU7(B) ; KS0-C-5537
(ucs-set-char #x524C ?$(GP*(B) ; C01-G-502A
(ucs-set-char #x524C ?$@Qo(B) ; J78-@-516F
(ucs-set-char #x524C ?$AX](B) ; GB0-A-585D
(ucs-set-char #x524C ?$BQo(B) ; J83-B-516F
(ucs-set-char #x524D ?$(Cnq(B) ; KS0-C-6E71
(ucs-set-char #x524D ?$(GP)(B) ; C01-G-5029
(ucs-set-char #x524D ?$@A0(B) ; J78-@-4130
(ucs-set-char #x524D ?$AG0(B) ; GB0-A-4730
(ucs-set-char #x524D ?$BA0(B) ; J83-B-4130
(ucs-set-char #x524E ?$(GP&(B) ; C01-G-5026
(ucs-set-char #x524F ?$(I+C(B) ; C03-I-2B43
(ucs-set-char #x524F ?$@Ql(B) ; J78-@-516C
(ucs-set-char #x524F ?$BQl(B) ; J83-B-516C
(ucs-set-char #x5250 ?$A9P(B) ; GB0-A-3950
(ucs-set-char #x5251 ?$A=#(B) ; GB0-A-3D23
(ucs-set-char #x5252 ?$(H.+(B) ; C02-H-2E2B
(ucs-set-char #x5253 ?$(I/h(B) ; C03-I-2F68
(ucs-set-char #x5254 ?$(Ct((B) ; KS0-C-7428
(ucs-set-char #x5254 ?$(GTJ(B) ; C01-G-544A
(ucs-set-char #x5254 ?$@Qq(B) ; J78-@-5171
(ucs-set-char #x5254 ?$AL^(B) ; GB0-A-4C5E
(ucs-set-char #x5254 ?$BQq(B) ; J83-B-5171
(ucs-set-char #x5255 ?$(D3@(B) ; J90-D-3340
(ucs-set-char #x5255 ?$(H..(B) ; C02-H-2E2E
(ucs-set-char #x5256 ?$(C\x(B) ; KS0-C-5C78
(ucs-set-char #x5256 ?$(GTH(B) ; C01-G-5448
(ucs-set-char #x5256 ?$@K6(B) ; J78-@-4B36
(ucs-set-char #x5256 ?$AFJ(B) ; GB0-A-464A
(ucs-set-char #x5256 ?$BK6(B) ; J83-B-4B36
(ucs-set-char #x5257 ?$(D3A(B) ; J90-D-3341
(ucs-set-char #x5257 ?$(I/e(B) ; C03-I-2F65
(ucs-set-char #x5258 ?$(D3B(B) ; J90-D-3342
(ucs-set-char #x5258 ?$(J+n(B) ; C04-J-2B6E
(ucs-set-char #x5259 ?$(I/b(B) ; C03-I-2F62
(ucs-set-char #x525A ?$(D3C(B) ; J90-D-3343
(ucs-set-char #x525A ?$(H.*(B) ; C02-H-2E2A
(ucs-set-char #x525B ?$(CK'(B) ; KS0-C-4B27
(ucs-set-char #x525B ?$(GTK(B) ; C01-G-544B
(ucs-set-char #x525B ?$@9d(B) ; J78-@-3964
(ucs-set-char #x525B ?$B9d(B) ; J83-B-3964
(ucs-set-char #x525C ?$(D3D(B) ; J90-D-3344
(ucs-set-char #x525C ?$(GTI(B) ; C01-G-5449
(ucs-set-char #x525C ?$AX`(B) ; GB0-A-5860
(ucs-set-char #x525D ?$(CZN(B) ; KS0-C-5A4E
(ucs-set-char #x525D ?$(GTL(B) ; C01-G-544C
(ucs-set-char #x525D ?$@Gm(B) ; J78-@-476D
(ucs-set-char #x525E ?$(H.,(B) ; C02-H-2E2C
(ucs-set-char #x525E ?$@Qp(B) ; J78-@-5170
(ucs-set-char #x525E ?$AX^(B) ; GB0-A-585E
(ucs-set-char #x525E ?$BQp(B) ; J83-B-5170
(ucs-set-char #x525F ?$(D3E(B) ; J90-D-3345
(ucs-set-char #x525F ?$(H.-(B) ; C02-H-2E2D
(ucs-set-char #x5260 ?$(D3F(B) ; J90-D-3346
(ucs-set-char #x5260 ?$(I/`(B) ; C03-I-2F60
(ucs-set-char #x5261 ?$(C`f(B) ; KS0-C-6066
(ucs-set-char #x5261 ?$(D3G(B) ; J90-D-3347
(ucs-set-char #x5261 ?$(H.)(B) ; C02-H-2E29
(ucs-set-char #x5261 ?$AX_(B) ; GB0-A-585F
(ucs-set-char #x5262 ?$(H./(B) ; C02-H-2E2F
(ucs-set-char #x5263 ?$(I/f(B) ; C03-I-2F66
(ucs-set-char #x5263 ?$@7u(B) ; J78-@-3775
(ucs-set-char #x5263 ?$B7u(B) ; J83-B-3775
(ucs-set-char #x5264 ?$(I/a(B) ; C03-I-2F61
(ucs-set-char #x5264 ?$@:^(B) ; J78-@-3A5E
(ucs-set-char #x5264 ?$B:^(B) ; J83-B-3A5E
(ucs-set-char #x5265 ?$(I/c(B) ; C03-I-2F63
(ucs-set-char #x5265 ?$A0~(B) ; GB0-A-307E
(ucs-set-char #x5265 ?$BGm(B) ; J83-B-476D
(ucs-set-char #x5266 ?$(D3H(B) ; J90-D-3348
(ucs-set-char #x5267 ?$(I/d(B) ; C03-I-2F64
(ucs-set-char #x5267 ?$A>g(B) ; GB0-A-3E67
(ucs-set-char #x5268 ?$(I4P(B) ; C03-I-3450
(ucs-set-char #x5269 ?$(Cm%(B) ; KS0-C-6D25
(ucs-set-char #x5269 ?$(G^7(B) ; C01-G-5E37
(ucs-set-char #x5269 ?$@Qt(B) ; J78-@-5174
(ucs-set-char #x5269 ?$AJ#(B) ; GB0-A-4A23
(ucs-set-char #x5269 ?$BQt(B) ; J83-B-5174
(ucs-set-char #x526A ?$(Cnr(B) ; KS0-C-6E72
(ucs-set-char #x526A ?$(GY*(B) ; C01-G-592A
(ucs-set-char #x526A ?$@Qr(B) ; J78-@-5172
(ucs-set-char #x526A ?$A<t(B) ; GB0-A-3C74
(ucs-set-char #x526A ?$BQr(B) ; J83-B-5172
(ucs-set-char #x526B ?$(H3l(B) ; C02-H-336C
(ucs-set-char #x526C ?$(H3n(B) ; C02-H-336E
(ucs-set-char #x526D ?$(H3m(B) ; C02-H-336D
(ucs-set-char #x526E ?$(D3I(B) ; J90-D-3349
(ucs-set-char #x526E ?$(H3o(B) ; C02-H-336F
(ucs-set-char #x526F ?$(C\y(B) ; KS0-C-5C79
(ucs-set-char #x526F ?$(GY+(B) ; C01-G-592B
(ucs-set-char #x526F ?$@I{(B) ; J78-@-497B
(ucs-set-char #x526F ?$A81(B) ; GB0-A-3831
(ucs-set-char #x526F ?$BI{(B) ; J83-B-497B
(ucs-set-char #x5270 ?$(I:#(B) ; C03-I-3A23
(ucs-set-char #x5270 ?$@>j(B) ; J78-@-3E6A
(ucs-set-char #x5270 ?$B>j(B) ; J83-B-3E6A
(ucs-set-char #x5271 ?$@Q{(B) ; J78-@-517B
(ucs-set-char #x5271 ?$BQ{(B) ; J83-B-517B
(ucs-set-char #x5272 ?$(Cy\(B) ; KS0-C-795C
(ucs-set-char #x5272 ?$(G^4(B) ; C01-G-5E34
(ucs-set-char #x5272 ?$(LFg(B) ; C06-L-4667
(ucs-set-char #x5272 ?$@3d(B) ; J78-@-3364
(ucs-set-char #x5272 ?$A8n(B) ; GB0-A-386E
(ucs-set-char #x5272 ?$B3d(B) ; J83-B-3364
(ucs-set-char #x5273 ?$(I:!(B) ; C03-I-3A21
(ucs-set-char #x5273 ?$@Qu(B) ; J78-@-5175
(ucs-set-char #x5273 ?$BQu(B) ; J83-B-5175
(ucs-set-char #x5274 ?$(G^5(B) ; C01-G-5E35
(ucs-set-char #x5274 ?$@Qs(B) ; J78-@-5173
(ucs-set-char #x5274 ?$BQs(B) ; J83-B-5173
(ucs-set-char #x5275 ?$(Cs\(B) ; KS0-C-735C
(ucs-set-char #x5275 ?$(G^6(B) ; C01-G-5E36
(ucs-set-char #x5275 ?$@AO(B) ; J78-@-414F
(ucs-set-char #x5275 ?$BAO(B) ; J83-B-414F
(ucs-set-char #x5276 ?$(I4Q(B) ; C03-I-3451
(ucs-set-char #x5277 ?$(D3J(B) ; J90-D-334A
(ucs-set-char #x5277 ?$(Gc7(B) ; C01-G-6337
(ucs-set-char #x5277 ?$(I@C(B) ; C03-I-4043
(ucs-set-char #x5278 ?$(D3K(B) ; J90-D-334B
(ucs-set-char #x5278 ?$(HAl(B) ; C02-H-416C
(ucs-set-char #x5279 ?$(D3L(B) ; J90-D-334C
(ucs-set-char #x5279 ?$(I@A(B) ; C03-I-4041
(ucs-set-char #x527A ?$(HAk(B) ; C02-H-416B
(ucs-set-char #x527B ?$(HAm(B) ; C02-H-416D
(ucs-set-char #x527C ?$(HAn(B) ; C02-H-416E
(ucs-set-char #x527D ?$(Cxr(B) ; KS0-C-7872
(ucs-set-char #x527D ?$(Gc8(B) ; C01-G-6338
(ucs-set-char #x527D ?$@Qw(B) ; J78-@-5177
(ucs-set-char #x527D ?$AXb(B) ; GB0-A-5862
(ucs-set-char #x527D ?$BQw(B) ; J83-B-5177
(ucs-set-char #x527E ?$(I@@(B) ; C03-I-4040
(ucs-set-char #x527F ?$(Cty(B) ; KS0-C-7479
(ucs-set-char #x527F ?$(Gc6(B) ; C01-G-6336
(ucs-set-char #x527F ?$@Qv(B) ; J78-@-5176
(ucs-set-char #x527F ?$A=K(B) ; GB0-A-3D4B
(ucs-set-char #x527F ?$BQv(B) ; J83-B-5176
(ucs-set-char #x5280 ?$(D3M(B) ; J90-D-334D
(ucs-set-char #x5280 ?$(HI((B) ; C02-H-4928
(ucs-set-char #x5281 ?$(HI)(B) ; C02-H-4929
(ucs-set-char #x5281 ?$AXd(B) ; GB0-A-5864
(ucs-set-char #x5282 ?$(D3N(B) ; J90-D-334E
(ucs-set-char #x5282 ?$(Gh#(B) ; C01-G-6823
(ucs-set-char #x5282 ?$AXc(B) ; GB0-A-5863
(ucs-set-char #x5283 ?$(C|q(B) ; KS0-C-7C71
(ucs-set-char #x5283 ?$(Gh"(B) ; C01-G-6822
(ucs-set-char #x5283 ?$@3D(B) ; J78-@-3344
(ucs-set-char #x5283 ?$B3D(B) ; J83-B-3344
(ucs-set-char #x5284 ?$(HLa(B) ; C02-H-4C61
(ucs-set-char #x5285 ?$(D3O(B) ; J90-D-334F
(ucs-set-char #x5285 ?$(JI%(B) ; C04-J-4925
(ucs-set-char #x5286 ?$(IK1(B) ; C03-I-4B31
(ucs-set-char #x5287 ?$(CP<(B) ; KS0-C-503C
(ucs-set-char #x5287 ?$(Gl*(B) ; C01-G-6C2A
(ucs-set-char #x5287 ?$@7`(B) ; J78-@-3760
(ucs-set-char #x5287 ?$B7`(B) ; J83-B-3760
(ucs-set-char #x5288 ?$(C[y(B) ; KS0-C-5B79
(ucs-set-char #x5288 ?$(Gl+(B) ; C01-G-6C2B
(ucs-set-char #x5288 ?$@Q|(B) ; J78-@-517C
(ucs-set-char #x5288 ?$AE|(B) ; GB0-A-457C
(ucs-set-char #x5288 ?$BQ|(B) ; J83-B-517C
(ucs-set-char #x5289 ?$(CW1(B) ; KS0-C-5731
(ucs-set-char #x5289 ?$(Gl,(B) ; C01-G-6C2C
(ucs-set-char #x5289 ?$@N-(B) ; J78-@-4E2D
(ucs-set-char #x5289 ?$BN-(B) ; J83-B-4E2D
(ucs-set-char #x528A ?$(D3P(B) ; J90-D-3350
(ucs-set-char #x528A ?$(Gl.(B) ; C01-G-6C2E
(ucs-set-char #x528B ?$(HOZ(B) ; C02-H-4F5A
(ucs-set-char #x528C ?$(D3Q(B) ; J90-D-3351
(ucs-set-char #x528C ?$(HO[(B) ; C02-H-4F5B
(ucs-set-char #x528D ?$(CK|(B) ; KS0-C-4B7C
(ucs-set-char #x528D ?$(Gl-(B) ; C01-G-6C2D
(ucs-set-char #x528D ?$@Qx(B) ; J78-@-5178
(ucs-set-char #x528D ?$BQx(B) ; J83-B-5178
(ucs-set-char #x528E ?$(IK2(B) ; C03-I-4B32
(ucs-set-char #x5290 ?$(IP6(B) ; C03-I-5036
(ucs-set-char #x5290 ?$AXe(B) ; GB0-A-5865
(ucs-set-char #x5291 ?$(Cp%(B) ; KS0-C-7025
(ucs-set-char #x5291 ?$(Gp8(B) ; C01-G-7038
(ucs-set-char #x5291 ?$@Q}(B) ; J78-@-517D
(ucs-set-char #x5291 ?$BQ}(B) ; J83-B-517D
(ucs-set-char #x5292 ?$(CK}(B) ; KS0-C-4B7D
(ucs-set-char #x5292 ?$(JOd(B) ; C04-J-4F64
(ucs-set-char #x5292 ?$@Qz(B) ; J78-@-517A
(ucs-set-char #x5292 ?$BQz(B) ; J83-B-517A
(ucs-set-char #x5293 ?$(D3R(B) ; J90-D-3352
(ucs-set-char #x5293 ?$(Gp9(B) ; C01-G-7039
(ucs-set-char #x5293 ?$AXf(B) ; GB0-A-5866
(ucs-set-char #x5294 ?$(IP7(B) ; C03-I-5037
(ucs-set-char #x5294 ?$@Qy(B) ; J78-@-5179
(ucs-set-char #x5294 ?$BQy(B) ; J83-B-5179
(ucs-set-char #x5295 ?$(D3S(B) ; J90-D-3353
(ucs-set-char #x5295 ?$(JUm(B) ; C04-J-556D
(ucs-set-char #x5296 ?$(D3T(B) ; J90-D-3354
(ucs-set-char #x5296 ?$(He9(B) ; C02-H-6539
(ucs-set-char #x5297 ?$(D3U(B) ; J90-D-3355
(ucs-set-char #x5297 ?$(HkQ(B) ; C02-H-6B51
(ucs-set-char #x5298 ?$(D3V(B) ; J90-D-3356
(ucs-set-char #x5298 ?$(HkP(B) ; C02-H-6B50
(ucs-set-char #x5299 ?$(Hn~(B) ; C02-H-6E7E
(ucs-set-char #x529A ?$(D3W(B) ; J90-D-3357
(ucs-set-char #x529A ?$(I`,(B) ; C03-I-602C

(ucs-set-char #x529B ?$AA&(B) ; GB0-A-4126
(ucs-set-char #x529B ?$(CUt(B) ; KS0-C-5574
(ucs-set-char #x529B ?$(GD0(B) ; C01-G-4430
(ucs-set-char #x529B ?$@NO(B) ; J78-@-4E4F
(ucs-set-char #x529B ?$BNO(B) ; J83-B-4E4F

(ucs-set-char #x529C ?$(D3X(B) ; J90-D-3358
(ucs-set-char #x529C ?$(I!7(B) ; C03-I-2137
(ucs-set-char #x529D ?$(I!T(B) ; C03-I-2154
(ucs-set-char #x529D ?$AH0(B) ; GB0-A-4830
(ucs-set-char #x529E ?$(I!S(B) ; C03-I-2153
(ucs-set-char #x529E ?$A0l(B) ; GB0-A-306C
(ucs-set-char #x529F ?$(CMm(B) ; KS0-C-4D6D
(ucs-set-char #x529F ?$(GE|(B) ; C01-G-457C
(ucs-set-char #x529F ?$@8y(B) ; J78-@-3879
(ucs-set-char #x529F ?$A9&(B) ; GB0-A-3926
(ucs-set-char #x529F ?$B8y(B) ; J83-B-3879
(ucs-set-char #x52A0 ?$(CJ%(B) ; KS0-C-4A25
(ucs-set-char #x52A0 ?$(GE{(B) ; C01-G-457B
(ucs-set-char #x52A0 ?$@2C(B) ; J78-@-3243
(ucs-set-char #x52A0 ?$A<S(B) ; GB0-A-3C53
(ucs-set-char #x52A0 ?$B2C(B) ; J83-B-3243
(ucs-set-char #x52A1 ?$ANq(B) ; GB0-A-4E71
(ucs-set-char #x52A2 ?$A[=(B) ; GB0-A-5B3D
(ucs-set-char #x52A3 ?$(CV+(B) ; KS0-C-562B
(ucs-set-char #x52A3 ?$(GGI(B) ; C01-G-4749
(ucs-set-char #x52A3 ?$@Nt(B) ; J78-@-4E74
(ucs-set-char #x52A3 ?$AAS(B) ; GB0-A-4153
(ucs-set-char #x52A3 ?$BNt(B) ; J83-B-4E74
(ucs-set-char #x52A4 ?$(CPB(B) ; KS0-C-5042
(ucs-set-char #x52A4 ?$(D3Y(B) ; J90-D-3359
(ucs-set-char #x52A4 ?$(J"B(B) ; C04-J-2242
(ucs-set-char #x52A5 ?$(D3Z(B) ; J90-D-335A
(ucs-set-char #x52A5 ?$(J"?(B) ; C04-J-223F
(ucs-set-char #x52A6 ?$(D3[(B) ; J90-D-335B
(ucs-set-char #x52A6 ?$(H!~(B) ; C02-H-217E
(ucs-set-char #x52A7 ?$(D3\(B) ; J90-D-335C
(ucs-set-char #x52A7 ?$(J"A(B) ; C04-J-2241
(ucs-set-char #x52A8 ?$(I#((B) ; C03-I-2328
(ucs-set-char #x52A8 ?$A6/(B) ; GB0-A-362F
(ucs-set-char #x52A9 ?$(Cp>(B) ; KS0-C-703E
(ucs-set-char #x52A9 ?$(GI7(B) ; C01-G-4937
(ucs-set-char #x52A9 ?$@=u(B) ; J78-@-3D75
(ucs-set-char #x52A9 ?$AVz(B) ; GB0-A-567A
(ucs-set-char #x52A9 ?$B=u(B) ; J83-B-3D75
(ucs-set-char #x52AA ?$(CR=(B) ; KS0-C-523D
(ucs-set-char #x52AA ?$(GI8(B) ; C01-G-4938
(ucs-set-char #x52AA ?$@EX(B) ; J78-@-4558
(ucs-set-char #x52AA ?$AE,(B) ; GB0-A-452C
(ucs-set-char #x52AA ?$BEX(B) ; J83-B-4558
(ucs-set-char #x52AB ?$(CL$(B) ; KS0-C-4C24
(ucs-set-char #x52AB ?$(GI6(B) ; C01-G-4936
(ucs-set-char #x52AB ?$@9e(B) ; J78-@-3965
(ucs-set-char #x52AB ?$A=Y(B) ; GB0-A-3D59
(ucs-set-char #x52AB ?$B9e(B) ; J83-B-3965
(ucs-set-char #x52AC ?$(GI9(B) ; C01-G-4939
(ucs-set-char #x52AC ?$@R"(B) ; J78-@-5222
(ucs-set-char #x52AC ?$A[>(B) ; GB0-A-5B3E
(ucs-set-char #x52AC ?$BR"(B) ; J83-B-5222
(ucs-set-char #x52AD ?$(H#1(B) ; C02-H-2331
(ucs-set-char #x52AD ?$@R#(B) ; J78-@-5223
(ucs-set-char #x52AD ?$A[?(B) ; GB0-A-5B3F
(ucs-set-char #x52AD ?$BR#(B) ; J83-B-5223
(ucs-set-char #x52AE ?$(H#2(B) ; C02-H-2332
(ucs-set-char #x52AF ?$(D3](B) ; J90-D-335D
(ucs-set-char #x52AF ?$(J#F(B) ; C04-J-2346
(ucs-set-char #x52B0 ?$(D3^(B) ; J90-D-335E
(ucs-set-char #x52B0 ?$(J#G(B) ; C04-J-2347
(ucs-set-char #x52B1 ?$(J#H(B) ; C04-J-2348
(ucs-set-char #x52B1 ?$@Ne(B) ; J78-@-4E65
(ucs-set-char #x52B1 ?$A@x(B) ; GB0-A-4078
(ucs-set-char #x52B1 ?$BNe(B) ; J83-B-4E65
(ucs-set-char #x52B2 ?$(J#I(B) ; C04-J-2349
(ucs-set-char #x52B2 ?$A>"(B) ; GB0-A-3E22
(ucs-set-char #x52B3 ?$(I$c(B) ; C03-I-2463
(ucs-set-char #x52B3 ?$A@M(B) ; GB0-A-404D
(ucs-set-char #x52B4 ?$(I$b(B) ; C03-I-2462
(ucs-set-char #x52B4 ?$@O+(B) ; J78-@-4F2B
(ucs-set-char #x52B4 ?$BO+(B) ; J83-B-4F2B
(ucs-set-char #x52B5 ?$(I'a(B) ; C03-I-2761
(ucs-set-char #x52B5 ?$@R%(B) ; J78-@-5225
(ucs-set-char #x52B5 ?$BR%(B) ; J83-B-5225
(ucs-set-char #x52B6 ?$(D3_(B) ; J90-D-335F
(ucs-set-char #x52B6 ?$(K%:(B) ; C05-K-253A
(ucs-set-char #x52B7 ?$(D3`(B) ; J90-D-3360
(ucs-set-char #x52B7 ?$(K%7(B) ; C05-K-2537
(ucs-set-char #x52B8 ?$(D3a(B) ; J90-D-3361
(ucs-set-char #x52B8 ?$(K%8(B) ; C05-K-2538
(ucs-set-char #x52B9 ?$(I'`(B) ; C03-I-2760
(ucs-set-char #x52B9 ?$@8z(B) ; J78-@-387A
(ucs-set-char #x52B9 ?$B8z(B) ; J83-B-387A
(ucs-set-char #x52BA ?$(D3b(B) ; J90-D-3362
(ucs-set-char #x52BA ?$(K%;(B) ; C05-K-253B
(ucs-set-char #x52BB ?$(D3c(B) ; J90-D-3363
(ucs-set-char #x52BB ?$(GL4(B) ; C01-G-4C34
(ucs-set-char #x52BC ?$(H%U(B) ; C02-H-2555
(ucs-set-char #x52BC ?$@R$(B) ; J78-@-5224
(ucs-set-char #x52BC ?$BR$(B) ; J83-B-5224
(ucs-set-char #x52BD ?$(D3d(B) ; J90-D-3364
(ucs-set-char #x52BD ?$(J%P(B) ; C04-J-2550
(ucs-set-char #x52BE ?$(Cz6(B) ; KS0-C-7A36
(ucs-set-char #x52BE ?$(GL3(B) ; C01-G-4C33
(ucs-set-char #x52BE ?$@3/(B) ; J78-@-332F
(ucs-set-char #x52BE ?$A[@(B) ; GB0-A-5B40
(ucs-set-char #x52BE ?$B3/(B) ; J83-B-332F
(ucs-set-char #x52BF ?$(I'b(B) ; C03-I-2762
(ucs-set-char #x52BF ?$AJF(B) ; GB0-A-4A46
(ucs-set-char #x52C0 ?$(D3e(B) ; J90-D-3365
(ucs-set-char #x52C0 ?$(H)4(B) ; C02-H-2934
(ucs-set-char #x52C1 ?$(CLM(B) ; KS0-C-4C4D
(ucs-set-char #x52C1 ?$(GP0(B) ; C01-G-5030
(ucs-set-char #x52C1 ?$@R&(B) ; J78-@-5226
(ucs-set-char #x52C1 ?$BR&(B) ; J83-B-5226
(ucs-set-char #x52C2 ?$(H)5(B) ; C02-H-2935
(ucs-set-char #x52C3 ?$(CZz(B) ; KS0-C-5A7A
(ucs-set-char #x52C3 ?$(GP/(B) ; C01-G-502F
(ucs-set-char #x52C3 ?$@KV(B) ; J78-@-4B56
(ucs-set-char #x52C3 ?$A2*(B) ; GB0-A-322A
(ucs-set-char #x52C3 ?$BKV(B) ; J83-B-4B56
(ucs-set-char #x52C4 ?$(D3f(B) ; J90-D-3366
(ucs-set-char #x52C4 ?$(I+H(B) ; C03-I-2B48
(ucs-set-char #x52C5 ?$(CvO(B) ; KS0-C-764F
(ucs-set-char #x52C5 ?$(I+F(B) ; C03-I-2B46
(ucs-set-char #x52C5 ?$@D<(B) ; J78-@-443C
(ucs-set-char #x52C5 ?$BD<(B) ; J83-B-443C
(ucs-set-char #x52C6 ?$(D3g(B) ; J90-D-3367
(ucs-set-char #x52C6 ?$(J(I(B) ; C04-J-2849
(ucs-set-char #x52C7 ?$(Ci8(B) ; KS0-C-6938
(ucs-set-char #x52C7 ?$(GP-(B) ; C01-G-502D
(ucs-set-char #x52C7 ?$(L/%(B) ; C06-L-2F25
(ucs-set-char #x52C7 ?$@M&(B) ; J78-@-4D26
(ucs-set-char #x52C7 ?$ASB(B) ; GB0-A-5342
(ucs-set-char #x52C7 ?$BM&(B) ; J83-B-4D26
(ucs-set-char #x52C8 ?$(D3h(B) ; J90-D-3368
(ucs-set-char #x52C8 ?$(J(K(B) ; C04-J-284B
(ucs-set-char #x52C9 ?$(CXu(B) ; KS0-C-5875
(ucs-set-char #x52C9 ?$(GP.(B) ; C01-G-502E
(ucs-set-char #x52C9 ?$(L5X(B) ; C06-L-3558
(ucs-set-char #x52C9 ?$@JY(B) ; J78-@-4A59
(ucs-set-char #x52C9 ?$ACc(B) ; GB0-A-4363
(ucs-set-char #x52C9 ?$BJY(B) ; J83-B-4A59
(ucs-set-char #x52CA ?$(I+G(B) ; C03-I-2B47
(ucs-set-char #x52CB ?$AQ+(B) ; GB0-A-512B
(ucs-set-char #x52CC ?$(D3i(B) ; J90-D-3369
(ucs-set-char #x52CC ?$(I/o(B) ; C03-I-2F6F
(ucs-set-char #x52CD ?$(CLN(B) ; KS0-C-4C4E
(ucs-set-char #x52CD ?$(H.0(B) ; C02-H-2E30
(ucs-set-char #x52CD ?$@R'(B) ; J78-@-5227
(ucs-set-char #x52CD ?$BR'(B) ; J83-B-5227
(ucs-set-char #x52CE ?$(I/l(B) ; C03-I-2F6C
(ucs-set-char #x52CF ?$(D3j(B) ; J90-D-336A
(ucs-set-char #x52CF ?$(I/j(B) ; C03-I-2F6A
(ucs-set-char #x52D0 ?$(I/m(B) ; C03-I-2F6D
(ucs-set-char #x52D0 ?$A[B(B) ; GB0-A-5B42
(ucs-set-char #x52D1 ?$(D3k(B) ; J90-D-336B
(ucs-set-char #x52D1 ?$(I/n(B) ; C03-I-2F6E
(ucs-set-char #x52D2 ?$(CWM(B) ; KS0-C-574D
(ucs-set-char #x52D2 ?$(GY,(B) ; C01-G-592C
(ucs-set-char #x52D2 ?$@pU(B) ; J78-@-7055
(ucs-set-char #x52D2 ?$A@U(B) ; GB0-A-4055
(ucs-set-char #x52D2 ?$BpU(B) ; J83-B-7055
(ucs-set-char #x52D3 ?$(H3q(B) ; C02-H-3371
(ucs-set-char #x52D4 ?$(D3l(B) ; J90-D-336C
(ucs-set-char #x52D4 ?$(I4R(B) ; C03-I-3452
(ucs-set-char #x52D5 ?$(CTQ(B) ; KS0-C-5451
(ucs-set-char #x52D5 ?$(GY/(B) ; C01-G-592F
(ucs-set-char #x52D5 ?$@F0(B) ; J78-@-4630
(ucs-set-char #x52D5 ?$BF0(B) ; J83-B-4630
(ucs-set-char #x52D6 ?$(Cim(B) ; KS0-C-696D
(ucs-set-char #x52D6 ?$(D3m(B) ; J90-D-336D
(ucs-set-char #x52D6 ?$(H3p(B) ; C02-H-3370
(ucs-set-char #x52D6 ?$A[C(B) ; GB0-A-5B43
(ucs-set-char #x52D7 ?$(G[+(B) ; C01-G-5B2B
(ucs-set-char #x52D7 ?$@R((B) ; J78-@-5228
(ucs-set-char #x52D7 ?$BR((B) ; J83-B-5228
(ucs-set-char #x52D8 ?$(CJk(B) ; KS0-C-4A6B
(ucs-set-char #x52D8 ?$(GY.(B) ; C01-G-592E
(ucs-set-char #x52D8 ?$@4*(B) ; J78-@-342A
(ucs-set-char #x52D8 ?$A?1(B) ; GB0-A-3F31
(ucs-set-char #x52D8 ?$B4*(B) ; J83-B-342A
(ucs-set-char #x52D9 ?$(CYb(B) ; KS0-C-5962
(ucs-set-char #x52D9 ?$(GY-(B) ; C01-G-592D
(ucs-set-char #x52D9 ?$@L3(B) ; J78-@-4C33
(ucs-set-char #x52D9 ?$BL3(B) ; J83-B-4C33
(ucs-set-char #x52DB ?$(C}2(B) ; KS0-C-7D32
(ucs-set-char #x52DB ?$(D3n(B) ; J90-D-336E
(ucs-set-char #x52DB ?$(G^:(B) ; C01-G-5E3A
(ucs-set-char #x52DC ?$(D3o(B) ; J90-D-336F
(ucs-set-char #x52DC ?$(K6j(B) ; C05-K-366A
(ucs-set-char #x52DD ?$(Cc-(B) ; KS0-C-632D
(ucs-set-char #x52DD ?$(G^9(B) ; C01-G-5E39
(ucs-set-char #x52DD ?$@>!(B) ; J78-@-3E21
(ucs-set-char #x52DD ?$B>!(B) ; J83-B-3E21
(ucs-set-char #x52DE ?$(CVL(B) ; KS0-C-564C
(ucs-set-char #x52DE ?$(G^8(B) ; C01-G-5E38
(ucs-set-char #x52DE ?$@R)(B) ; J78-@-5229
(ucs-set-char #x52DE ?$BR)(B) ; J83-B-5229
(ucs-set-char #x52DF ?$(CY4(B) ; KS0-C-5934
(ucs-set-char #x52DF ?$(Gc9(B) ; C01-G-6339
(ucs-set-char #x52DF ?$@Jg(B) ; J78-@-4A67
(ucs-set-char #x52DF ?$AD<(B) ; GB0-A-443C
(ucs-set-char #x52DF ?$BJg(B) ; J83-B-4A67
(ucs-set-char #x52E0 ?$(I@E(B) ; C03-I-4045
(ucs-set-char #x52E0 ?$@R-(B) ; J78-@-522D
(ucs-set-char #x52E0 ?$BR-(B) ; J83-B-522D
(ucs-set-char #x52E1 ?$(D3p(B) ; J90-D-3370
(ucs-set-char #x52E1 ?$(I@D(B) ; C03-I-4044
(ucs-set-char #x52E2 ?$(Ca'(B) ; KS0-C-6127
(ucs-set-char #x52E2 ?$(Gc<(B) ; C01-G-633C
(ucs-set-char #x52E2 ?$@@*(B) ; J78-@-402A
(ucs-set-char #x52E2 ?$B@*(B) ; J83-B-402A
(ucs-set-char #x52E3 ?$(CnS(B) ; KS0-C-6E53
(ucs-set-char #x52E3 ?$(Gc=(B) ; C01-G-633D
(ucs-set-char #x52E3 ?$@R*(B) ; J78-@-522A
(ucs-set-char #x52E3 ?$BR*(B) ; J83-B-522A
(ucs-set-char #x52E4 ?$(CPC(B) ; KS0-C-5043
(ucs-set-char #x52E4 ?$(Gc;(B) ; C01-G-633B
(ucs-set-char #x52E4 ?$(J6L(B) ; C04-J-364C
(ucs-set-char #x52E4 ?$@6P(B) ; J78-@-3650
(ucs-set-char #x52E4 ?$AGZ(B) ; GB0-A-475A
(ucs-set-char #x52E4 ?$B6P(B) ; J83-B-3650
(ucs-set-char #x52E5 ?$(D3q(B) ; J90-D-3371
(ucs-set-char #x52E5 ?$(J<<(B) ; C04-J-3C3C
(ucs-set-char #x52E6 ?$(Gc:(B) ; C01-G-633A
(ucs-set-char #x52E6 ?$@R+(B) ; J78-@-522B
(ucs-set-char #x52E6 ?$BR+(B) ; J83-B-522B
(ucs-set-char #x52E7 ?$(I@F(B) ; C03-I-4046
(ucs-set-char #x52E7 ?$@4+(B) ; J78-@-342B
(ucs-set-char #x52E7 ?$B4+(B) ; J83-B-342B
(ucs-set-char #x52E8 ?$(D3r(B) ; J90-D-3372
(ucs-set-char #x52E8 ?$(KDg(B) ; C05-K-4467
(ucs-set-char #x52E9 ?$(D3s(B) ; J90-D-3373
(ucs-set-char #x52E9 ?$(HI*(B) ; C02-H-492A
(ucs-set-char #x52EA ?$(D3t(B) ; J90-D-3374
(ucs-set-char #x52EA ?$(IF!(B) ; C03-I-4621
(ucs-set-char #x52EB ?$(HI+(B) ; C02-H-492B
(ucs-set-char #x52EC ?$(D3u(B) ; J90-D-3375
(ucs-set-char #x52EC ?$(KDc(B) ; C05-K-4463
(ucs-set-char #x52ED ?$(IE~(B) ; C03-I-457E
(ucs-set-char #x52EE ?$(IK3(B) ; C03-I-4B33
(ucs-set-char #x52EF ?$(HO](B) ; C02-H-4F5D
(ucs-set-char #x52F0 ?$(D3v(B) ; J90-D-3376
(ucs-set-char #x52F0 ?$(Gl/(B) ; C01-G-6C2F
(ucs-set-char #x52F0 ?$A[D(B) ; GB0-A-5B44
(ucs-set-char #x52F1 ?$(D3w(B) ; J90-D-3377
(ucs-set-char #x52F1 ?$(HO\(B) ; C02-H-4F5C
(ucs-set-char #x52F2 ?$(IM,(B) ; C03-I-4D2C
(ucs-set-char #x52F2 ?$@7.(B) ; J78-@-372E
(ucs-set-char #x52F2 ?$B7.(B) ; J83-B-372E
(ucs-set-char #x52F3 ?$(C}3(B) ; KS0-C-7D33
(ucs-set-char #x52F3 ?$(Gp:(B) ; C01-G-703A
(ucs-set-char #x52F3 ?$@R.(B) ; J78-@-522E
(ucs-set-char #x52F3 ?$BR.(B) ; J83-B-522E
(ucs-set-char #x52F4 ?$(D3x(B) ; J90-D-3378
(ucs-set-char #x52F4 ?$(H\K(B) ; C02-H-5C4B
(ucs-set-char #x52F5 ?$(CUd(B) ; KS0-C-5564
(ucs-set-char #x52F5 ?$(GsD(B) ; C01-G-7344
(ucs-set-char #x52F5 ?$@R/(B) ; J78-@-522F
(ucs-set-char #x52F5 ?$BR/(B) ; J83-B-522F
(ucs-set-char #x52F6 ?$(D3y(B) ; J90-D-3379
(ucs-set-char #x52F6 ?$(KSb(B) ; C05-K-5362
(ucs-set-char #x52F7 ?$(D3z(B) ; J90-D-337A
(ucs-set-char #x52F7 ?$(He:(B) ; C02-H-653A
(ucs-set-char #x52F8 ?$(COh(B) ; KS0-C-4F68
(ucs-set-char #x52F8 ?$(Gya(B) ; C01-G-7961
(ucs-set-char #x52F8 ?$@R0(B) ; J78-@-5230
(ucs-set-char #x52F8 ?$BR0(B) ; J83-B-5230

(ucs-set-char #x52F9 ?$AYh(B) ; GB0-A-5968
(ucs-set-char #x52F9 ?$@R1(B) ; J78-@-5231
(ucs-set-char #x52F9 ?$BR1(B) ; J83-B-5231

(ucs-set-char #x52FA ?$(CmC(B) ; KS0-C-6D43
(ucs-set-char #x52FA ?$(GDD(B) ; C01-G-4444
(ucs-set-char #x52FA ?$@<[(B) ; J78-@-3C5B
(ucs-set-char #x52FA ?$AIW(B) ; GB0-A-4957
(ucs-set-char #x52FA ?$B<[(B) ; J83-B-3C5B
(ucs-set-char #x52FB ?$(CP2(B) ; KS0-C-5032
(ucs-set-char #x52FB ?$(GE$(B) ; C01-G-4524
(ucs-set-char #x52FC ?$(H!6(B) ; C02-H-2136
(ucs-set-char #x52FD ?$(I!U(B) ; C03-I-2155
(ucs-set-char #x52FE ?$(CN~(B) ; KS0-C-4E7E
(ucs-set-char #x52FE ?$(GE%(B) ; C01-G-4525
(ucs-set-char #x52FE ?$@8{(B) ; J78-@-387B
(ucs-set-char #x52FE ?$A94(B) ; GB0-A-3934
(ucs-set-char #x52FE ?$B8{(B) ; J83-B-387B
(ucs-set-char #x52FF ?$(CZ((B) ; KS0-C-5A28
(ucs-set-char #x52FF ?$(GE&(B) ; C01-G-4526
(ucs-set-char #x52FF ?$@L^(B) ; J78-@-4C5E
(ucs-set-char #x52FF ?$ANp(B) ; GB0-A-4E70
(ucs-set-char #x52FF ?$BL^(B) ; J83-B-4C5E
(ucs-set-char #x5300 ?$(D3{(B) ; J90-D-337B
(ucs-set-char #x5300 ?$(I!V(B) ; C03-I-2156
(ucs-set-char #x5300 ?$ATH(B) ; GB0-A-5448
(ucs-set-char #x5301 ?$@Lh(B) ; J78-@-4C68
(ucs-set-char #x5301 ?$BLh(B) ; J83-B-4C68
(ucs-set-char #x5302 ?$@Fw(B) ; J78-@-4677
(ucs-set-char #x5302 ?$BFw(B) ; J83-B-4677
(ucs-set-char #x5303 ?$(D3|(B) ; J90-D-337C
(ucs-set-char #x5303 ?$(I"#(B) ; C03-I-2223
(ucs-set-char #x5304 ?$(I""(B) ; C03-I-2222
(ucs-set-char #x5305 ?$(CxP(B) ; KS0-C-7850
(ucs-set-char #x5305 ?$(GE}(B) ; C01-G-457D
(ucs-set-char #x5305 ?$(L"F(B) ; C06-L-2246
(ucs-set-char #x5305 ?$@Jq(B) ; J78-@-4A71
(ucs-set-char #x5305 ?$A0|(B) ; GB0-A-307C
(ucs-set-char #x5305 ?$BJq(B) ; J83-B-4A71
(ucs-set-char #x5306 ?$(GE~(B) ; C01-G-457E
(ucs-set-char #x5306 ?$@R2(B) ; J78-@-5232
(ucs-set-char #x5306 ?$A4R(B) ; GB0-A-3452
(ucs-set-char #x5306 ?$BR2(B) ; J83-B-5232
(ucs-set-char #x5307 ?$(I"$(B) ; C03-I-2224
(ucs-set-char #x5308 ?$(C}V(B) ; KS0-C-7D56
(ucs-set-char #x5308 ?$(GGJ(B) ; C01-G-474A
(ucs-set-char #x5308 ?$@R3(B) ; J78-@-5233
(ucs-set-char #x5308 ?$APY(B) ; GB0-A-5059
(ucs-set-char #x5308 ?$BR3(B) ; J83-B-5233
(ucs-set-char #x5309 ?$(H#3(B) ; C02-H-2333
(ucs-set-char #x530A ?$(D3}(B) ; J90-D-337D
(ucs-set-char #x530A ?$(H%V(B) ; C02-H-2556
(ucs-set-char #x530B ?$(D3~(B) ; J90-D-337E
(ucs-set-char #x530B ?$(H%W(B) ; C02-H-2557
(ucs-set-char #x530C ?$(D4!(B) ; J90-D-3421
(ucs-set-char #x530C ?$(J%Q(B) ; C04-J-2551
(ucs-set-char #x530D ?$(CxQ(B) ; KS0-C-7851
(ucs-set-char #x530D ?$(GP1(B) ; C01-G-5031
(ucs-set-char #x530D ?$@R5(B) ; J78-@-5235
(ucs-set-char #x530D ?$AYi(B) ; GB0-A-5969
(ucs-set-char #x530D ?$BR5(B) ; J83-B-5235
(ucs-set-char #x530E ?$(H.1(B) ; C02-H-2E31
(ucs-set-char #x530F ?$(CxR(B) ; KS0-C-7852
(ucs-set-char #x530F ?$(GY1(B) ; C01-G-5931
(ucs-set-char #x530F ?$@R7(B) ; J78-@-5237
(ucs-set-char #x530F ?$A^K(B) ; GB0-A-5E4B
(ucs-set-char #x530F ?$BR7(B) ; J83-B-5237
(ucs-set-char #x5310 ?$(C\S(B) ; KS0-C-5C53
(ucs-set-char #x5310 ?$(GY0(B) ; C01-G-5930
(ucs-set-char #x5310 ?$@R6(B) ; J78-@-5236
(ucs-set-char #x5310 ?$AYk(B) ; GB0-A-596B
(ucs-set-char #x5310 ?$BR6(B) ; J83-B-5236
(ucs-set-char #x5311 ?$(D4"(B) ; J90-D-3422
(ucs-set-char #x5311 ?$(H:G(B) ; C02-H-3A47
(ucs-set-char #x5312 ?$(H:F(B) ; C02-H-3A46
(ucs-set-char #x5313 ?$(D4#(B) ; J90-D-3423
(ucs-set-char #x5313 ?$(LPt(B) ; C06-L-5074
(ucs-set-char #x5314 ?$(IP8(B) ; C03-I-5038

(ucs-set-char #x5315 ?$AX0(B) ; GB0-A-5830
(ucs-set-char #x5315 ?$(C]b(B) ; KS0-C-5D62
(ucs-set-char #x5315 ?$(GD1(B) ; C01-G-4431
(ucs-set-char #x5315 ?$@R8(B) ; J78-@-5238
(ucs-set-char #x5315 ?$BR8(B) ; J83-B-5238

(ucs-set-char #x5316 ?$(C{y(B) ; KS0-C-7B79
(ucs-set-char #x5316 ?$(GE'(B) ; C01-G-4527
(ucs-set-char #x5316 ?$@2=(B) ; J78-@-323D
(ucs-set-char #x5316 ?$A;/(B) ; GB0-A-3B2F
(ucs-set-char #x5316 ?$B2=(B) ; J83-B-323D
(ucs-set-char #x5317 ?$(C]A(B) ; KS0-C-5D41
(ucs-set-char #x5317 ?$(GF!(B) ; C01-G-4621
(ucs-set-char #x5317 ?$@KL(B) ; J78-@-4B4C
(ucs-set-char #x5317 ?$A11(B) ; GB0-A-3131
(ucs-set-char #x5317 ?$BKL(B) ; J83-B-4B4C
(ucs-set-char #x5318 ?$(D4$(B) ; J90-D-3424
(ucs-set-char #x5318 ?$(J0^(B) ; C04-J-305E
(ucs-set-char #x5319 ?$(Cc5(B) ; KS0-C-6335
(ucs-set-char #x5319 ?$(GY2(B) ; C01-G-5932
(ucs-set-char #x5319 ?$@:|(B) ; J78-@-3A7C
(ucs-set-char #x5319 ?$A3W(B) ; GB0-A-3357
(ucs-set-char #x5319 ?$B:|(B) ; J83-B-3A7C

(ucs-set-char #x531A ?$AXN(B) ; GB0-A-584E
(ucs-set-char #x531A ?$(H!$(B) ; C02-H-2124
(ucs-set-char #x531A ?$@R9(B) ; J78-@-5239
(ucs-set-char #x531A ?$BR9(B) ; J83-B-5239

(ucs-set-char #x531B ?$(D4%(B) ; J90-D-3425
(ucs-set-char #x531B ?$(J!e(B) ; C04-J-2165
(ucs-set-char #x531C ?$(D4&(B) ; J90-D-3426
(ucs-set-char #x531C ?$(H!M(B) ; C02-H-214D
(ucs-set-char #x531D ?$(GF"(B) ; C01-G-4622
(ucs-set-char #x531D ?$@AY(B) ; J78-@-4159
(ucs-set-char #x531D ?$ATQ(B) ; GB0-A-5451
(ucs-set-char #x531D ?$BAY(B) ; J83-B-4159
(ucs-set-char #x531E ?$(D4'(B) ; J90-D-3427
(ucs-set-char #x531E ?$(I"&(B) ; C03-I-2226
(ucs-set-char #x531F ?$(D4((B) ; J90-D-3428
(ucs-set-char #x531F ?$(H""(B) ; C02-H-2222
(ucs-set-char #x5320 ?$(Cm](B) ; KS0-C-6D5D
(ucs-set-char #x5320 ?$(GGL(B) ; C01-G-474C
(ucs-set-char #x5320 ?$@>"(B) ; J78-@-3E22
(ucs-set-char #x5320 ?$A=3(B) ; GB0-A-3D33
(ucs-set-char #x5320 ?$B>"(B) ; J83-B-3E22
(ucs-set-char #x5321 ?$(CND(B) ; KS0-C-4E44
(ucs-set-char #x5321 ?$(GGK(B) ; C01-G-474B
(ucs-set-char #x5321 ?$@6)(B) ; J78-@-3629
(ucs-set-char #x5321 ?$A?o(B) ; GB0-A-3F6F
(ucs-set-char #x5321 ?$B6)(B) ; J83-B-3629
(ucs-set-char #x5322 ?$(H"!(B) ; C02-H-2221
(ucs-set-char #x5323 ?$(CK!(B) ; KS0-C-4B21
(ucs-set-char #x5323 ?$(GI:(B) ; C01-G-493A
(ucs-set-char #x5323 ?$@R:(B) ; J78-@-523A
(ucs-set-char #x5323 ?$AO;(B) ; GB0-A-4F3B
(ucs-set-char #x5323 ?$BR:(B) ; J83-B-523A
(ucs-set-char #x5324 ?$(K#K(B) ; C05-K-234B
(ucs-set-char #x5325 ?$(D4)(B) ; J90-D-3429
(ucs-set-char #x5325 ?$(I$e(B) ; C03-I-2465
(ucs-set-char #x5326 ?$AXP(B) ; GB0-A-5850
(ucs-set-char #x5327 ?$(D4*(B) ; J90-D-342A
(ucs-set-char #x5327 ?$(I+I(B) ; C03-I-2B49
(ucs-set-char #x5328 ?$(D4+(B) ; J90-D-342B
(ucs-set-char #x5328 ?$(J(N(B) ; C04-J-284E
(ucs-set-char #x5329 ?$(D4,(B) ; J90-D-342C
(ucs-set-char #x5329 ?$(J(P(B) ; C04-J-2850
(ucs-set-char #x532A ?$(C]c(B) ; KS0-C-5D63
(ucs-set-char #x532A ?$(GTM(B) ; C01-G-544D
(ucs-set-char #x532A ?$@H[(B) ; J78-@-485B
(ucs-set-char #x532A ?$A7K(B) ; GB0-A-374B
(ucs-set-char #x532A ?$BH[(B) ; J83-B-485B
(ucs-set-char #x532B ?$(D4-(B) ; J90-D-342D
(ucs-set-char #x532B ?$(J+x(B) ; C04-J-2B78
(ucs-set-char #x532C ?$(D4.(B) ; J90-D-342E
(ucs-set-char #x532C ?$(J0_(B) ; C04-J-305F
(ucs-set-char #x532D ?$(D4/(B) ; J90-D-342F
(ucs-set-char #x532D ?$(H3r(B) ; C02-H-3372
(ucs-set-char #x532E ?$AXQ(B) ; GB0-A-5851
(ucs-set-char #x532F ?$(C|](B) ; KS0-C-7C5D
(ucs-set-char #x532F ?$(Gc>(B) ; C01-G-633E
(ucs-set-char #x532F ?$@R;(B) ; J78-@-523B
(ucs-set-char #x532F ?$BR;(B) ; J83-B-523B
(ucs-set-char #x5330 ?$(D40(B) ; J90-D-3430
(ucs-set-char #x5330 ?$(HI,(B) ; C02-H-492C
(ucs-set-char #x5331 ?$(Gh$(B) ; C01-G-6824
(ucs-set-char #x5331 ?$@R<(B) ; J78-@-523C
(ucs-set-char #x5331 ?$BR<(B) ; J83-B-523C
(ucs-set-char #x5332 ?$(D41(B) ; J90-D-3431
(ucs-set-char #x5332 ?$(IF#(B) ; C03-I-4623
(ucs-set-char #x5333 ?$(IK4(B) ; C03-I-4B34
(ucs-set-char #x5333 ?$@R=(B) ; J78-@-523D
(ucs-set-char #x5333 ?$BR=(B) ; J83-B-523D
(ucs-set-char #x5334 ?$(HVE(B) ; C02-H-5645
(ucs-set-char #x5335 ?$(D42(B) ; J90-D-3432
(ucs-set-char #x5335 ?$(ITD(B) ; C03-I-5444
(ucs-set-char #x5336 ?$(I\4(B) ; C03-I-5C34
(ucs-set-char #x5337 ?$(Hhj(B) ; C02-H-686A

(ucs-set-char #x5338 ?$(I!)(B) ; C03-I-2129
(ucs-set-char #x5338 ?$@R>(B) ; J78-@-523E
(ucs-set-char #x5338 ?$BR>(B) ; J83-B-523E

(ucs-set-char #x5339 ?$(Cy/(B) ; KS0-C-792F
(ucs-set-char #x5339 ?$(GE((B) ; C01-G-4528
(ucs-set-char #x5339 ?$@I$(B) ; J78-@-4924
(ucs-set-char #x5339 ?$AF%(B) ; GB0-A-4625
(ucs-set-char #x5339 ?$BI$(B) ; J83-B-4924
(ucs-set-char #x533A ?$(I!W(B) ; C03-I-2157
(ucs-set-char #x533A ?$@6h(B) ; J78-@-3668
(ucs-set-char #x533A ?$AGx(B) ; GB0-A-4778
(ucs-set-char #x533A ?$B6h(B) ; J83-B-3668
(ucs-set-char #x533B ?$(I$f(B) ; C03-I-2466
(ucs-set-char #x533B ?$@0e(B) ; J78-@-3065
(ucs-set-char #x533B ?$AR=(B) ; GB0-A-523D
(ucs-set-char #x533B ?$B0e(B) ; J83-B-3065
(ucs-set-char #x533C ?$(D43(B) ; J90-D-3433
(ucs-set-char #x533C ?$(H%X(B) ; C02-H-2558
(ucs-set-char #x533D ?$(D44(B) ; J90-D-3434
(ucs-set-char #x533D ?$(H)6(B) ; C02-H-2936
(ucs-set-char #x533E ?$(D45(B) ; J90-D-3435
(ucs-set-char #x533E ?$(GY5(B) ; C01-G-5935
(ucs-set-char #x533E ?$AXR(B) ; GB0-A-5852
(ucs-set-char #x533F ?$(CR{(B) ; KS0-C-527B
(ucs-set-char #x533F ?$(GY3(B) ; C01-G-5933
(ucs-set-char #x533F ?$@F?(B) ; J78-@-463F
(ucs-set-char #x533F ?$ADd(B) ; GB0-A-4464
(ucs-set-char #x533F ?$BF?(B) ; J83-B-463F
(ucs-set-char #x5340 ?$(CO!(B) ; KS0-C-4F21
(ucs-set-char #x5340 ?$(GY4(B) ; C01-G-5934
(ucs-set-char #x5340 ?$@R?(B) ; J78-@-523F
(ucs-set-char #x5340 ?$BR?(B) ; J83-B-523F

(ucs-set-char #x5341 ?$AJ.(B) ; GB0-A-4A2E
(ucs-set-char #x5341 ?$(Cd((B) ; KS0-C-6428
(ucs-set-char #x5341 ?$(GD2(B) ; C01-G-4432
(ucs-set-char #x5341 ?$@==(B) ; J78-@-3D3D
(ucs-set-char #x5341 ?$B==(B) ; J83-B-3D3D

;;(ucs-set-char #x5341 ?$(G$>(B) ; C01-G-243E

(ucs-set-char #x5342 ?$(D46(B) ; J90-D-3436
(ucs-set-char #x5342 ?$(J!0(B) ; C04-J-2130
(ucs-set-char #x5343 ?$(Ct6(B) ; KS0-C-7436
(ucs-set-char #x5343 ?$(GDE(B) ; C01-G-4445
(ucs-set-char #x5343 ?$@@i(B) ; J78-@-4069
(ucs-set-char #x5343 ?$AG'(B) ; GB0-A-4727
(ucs-set-char #x5343 ?$B@i(B) ; J83-B-4069
(ucs-set-char #x5344 ?$(Cl~(B) ; KS0-C-6C7E
(ucs-set-char #x5344 ?$(G$?(B) ; C01-G-243F
(ucs-set-char #x5344 ?$(I!8(B) ; C03-I-2138
(ucs-set-char #x5345 ?$(G$@(B) ; C01-G-2440
(ucs-set-char #x5345 ?$(GE+(B) ; C01-G-452B
(ucs-set-char #x5345 ?$@RA(B) ; J78-@-5241
(ucs-set-char #x5345 ?$AX&(B) ; GB0-A-5826
(ucs-set-char #x5345 ?$BRA(B) ; J83-B-5241
(ucs-set-char #x5346 ?$(I!Y(B) ; C03-I-2159
(ucs-set-char #x5346 ?$@R@(B) ; J78-@-5240
(ucs-set-char #x5346 ?$BR@(B) ; J83-B-5240
(ucs-set-char #x5347 ?$(Cc.(B) ; KS0-C-632E
(ucs-set-char #x5347 ?$(GE*(B) ; C01-G-452A
(ucs-set-char #x5347 ?$@>#(B) ; J78-@-3E23
(ucs-set-char #x5347 ?$AI}(B) ; GB0-A-497D
(ucs-set-char #x5347 ?$B>#(B) ; J83-B-3E23
(ucs-set-char #x5348 ?$(Cgm(B) ; KS0-C-676D
(ucs-set-char #x5348 ?$(GE)(B) ; C01-G-4529
(ucs-set-char #x5348 ?$@8a(B) ; J78-@-3861
(ucs-set-char #x5348 ?$ANg(B) ; GB0-A-4E67
(ucs-set-char #x5348 ?$B8a(B) ; J83-B-3861
(ucs-set-char #x5349 ?$(C}A(B) ; KS0-C-7D41
(ucs-set-char #x5349 ?$(GF%(B) ; C01-G-4625
(ucs-set-char #x5349 ?$@RC(B) ; J78-@-5243
(ucs-set-char #x5349 ?$A;\(B) ; GB0-A-3B5C
(ucs-set-char #x5349 ?$BRC(B) ; J83-B-5243
(ucs-set-char #x534A ?$(CZb(B) ; KS0-C-5A62
(ucs-set-char #x534A ?$(GF$(B) ; C01-G-4624
(ucs-set-char #x534A ?$@H>(B) ; J78-@-483E
(ucs-set-char #x534A ?$A0k(B) ; GB0-A-306B
(ucs-set-char #x534A ?$BH>(B) ; J83-B-483E
(ucs-set-char #x534B ?$(D48(B) ; J90-D-3438
(ucs-set-char #x534B ?$(I#*(B) ; C03-I-232A
(ucs-set-char #x534C ?$(D47(B) ; J90-D-3437
(ucs-set-char #x534C ?$(H!N(B) ; C02-H-214E
(ucs-set-char #x534D ?$(CX3(B) ; KS0-C-5833
(ucs-set-char #x534D ?$(H"#(B) ; C02-H-2223
(ucs-set-char #x534D ?$@RD(B) ; J78-@-5244
(ucs-set-char #x534D ?$BRD(B) ; J83-B-5244
(ucs-set-char #x534E ?$A;*(B) ; GB0-A-3B2A
(ucs-set-char #x534F ?$(I#+(B) ; C03-I-232B
(ucs-set-char #x534F ?$AP-(B) ; GB0-A-502D
(ucs-set-char #x5350 ?$(I#-(B) ; C03-I-232D
(ucs-set-char #x5351 ?$(C]d(B) ; KS0-C-5D64
(ucs-set-char #x5351 ?$(GL8(B) ; C01-G-4C38
(ucs-set-char #x5351 ?$(L/8(B) ; C06-L-2F38
(ucs-set-char #x5351 ?$@H\(B) ; J78-@-485C
(ucs-set-char #x5351 ?$A10(B) ; GB0-A-3130
(ucs-set-char #x5351 ?$BH\(B) ; J83-B-485C
(ucs-set-char #x5352 ?$(Cpo(B) ; KS0-C-706F
(ucs-set-char #x5352 ?$(GL5(B) ; C01-G-4C35
(ucs-set-char #x5352 ?$@B4(B) ; J78-@-4234
(ucs-set-char #x5352 ?$AWd(B) ; GB0-A-5764
(ucs-set-char #x5352 ?$BB4(B) ; J83-B-4234
(ucs-set-char #x5353 ?$(Cvq(B) ; KS0-C-7671
(ucs-set-char #x5353 ?$(GL7(B) ; C01-G-4C37
(ucs-set-char #x5353 ?$@Bn(B) ; J78-@-426E
(ucs-set-char #x5353 ?$AW?(B) ; GB0-A-573F
(ucs-set-char #x5353 ?$BBn(B) ; J83-B-426E
(ucs-set-char #x5354 ?$(Czp(B) ; KS0-C-7A70
(ucs-set-char #x5354 ?$(GL6(B) ; C01-G-4C36
(ucs-set-char #x5354 ?$@6((B) ; J78-@-3628
(ucs-set-char #x5354 ?$B6((B) ; J83-B-3628
(ucs-set-char #x5355 ?$(I'c(B) ; C03-I-2763
(ucs-set-char #x5355 ?$A5%(B) ; GB0-A-3525
(ucs-set-char #x5356 ?$ABt(B) ; GB0-A-4274
(ucs-set-char #x5357 ?$(CQu(B) ; KS0-C-5175
(ucs-set-char #x5357 ?$(GP2(B) ; C01-G-5032
(ucs-set-char #x5357 ?$@Fn(B) ; J78-@-466E
(ucs-set-char #x5357 ?$ADO(B) ; GB0-A-444F
(ucs-set-char #x5357 ?$BFn(B) ; J83-B-466E
(ucs-set-char #x5358 ?$(I+J(B) ; C03-I-2B4A
(ucs-set-char #x5358 ?$@C1(B) ; J78-@-4331
(ucs-set-char #x5358 ?$BC1(B) ; J83-B-4331
(ucs-set-char #x5359 ?$(D49(B) ; J90-D-3439
(ucs-set-char #x5359 ?$(J0`(B) ; C04-J-3060
(ucs-set-char #x535A ?$(CZO(B) ; KS0-C-5A4F
(ucs-set-char #x535A ?$(G^;(B) ; C01-G-5E3B
(ucs-set-char #x535A ?$(LFt(B) ; C06-L-4674
(ucs-set-char #x535A ?$@Gn(B) ; J78-@-476E
(ucs-set-char #x535A ?$A2)(B) ; GB0-A-3229
(ucs-set-char #x535A ?$BGn(B) ; J83-B-476E
(ucs-set-char #x535B ?$(D4:(B) ; J90-D-343A
(ucs-set-char #x535B ?$(Jf0(B) ; C04-J-6630

(ucs-set-char #x535C ?$A27(B) ; GB0-A-3237
(ucs-set-char #x535C ?$(C\T(B) ; KS0-C-5C54
(ucs-set-char #x535C ?$(GD3(B) ; C01-G-4433
(ucs-set-char #x535C ?$@KN(B) ; J78-@-4B4E
(ucs-set-char #x535C ?$BKN(B) ; J83-B-4B4E

(ucs-set-char #x535D ?$(I!Z(B) ; C03-I-215A
(ucs-set-char #x535E ?$(C\&(B) ; KS0-C-5C26
(ucs-set-char #x535E ?$(GE,(B) ; C01-G-452C
(ucs-set-char #x535E ?$@RF(B) ; J78-@-5246
(ucs-set-char #x535E ?$A1e(B) ; GB0-A-3165
(ucs-set-char #x535E ?$BRF(B) ; J83-B-5246
(ucs-set-char #x535F ?$(I"'(B) ; C03-I-2227
(ucs-set-char #x535F ?$A_2(B) ; GB0-A-5F32
(ucs-set-char #x5360 ?$(Co?(B) ; KS0-C-6F3F
(ucs-set-char #x5360 ?$(GF'(B) ; C01-G-4627
(ucs-set-char #x5360 ?$@@j(B) ; J78-@-406A
(ucs-set-char #x5360 ?$AU<(B) ; GB0-A-553C
(ucs-set-char #x5360 ?$B@j(B) ; J83-B-406A
(ucs-set-char #x5361 ?$(D4;(B) ; J90-D-343B
(ucs-set-char #x5361 ?$(GF&(B) ; C01-G-4626
(ucs-set-char #x5361 ?$A?((B) ; GB0-A-3F28
(ucs-set-char #x5362 ?$AB,(B) ; GB0-A-422C
(ucs-set-char #x5363 ?$(D4<(B) ; J90-D-343C
(ucs-set-char #x5363 ?$(H#4(B) ; C02-H-2334
(ucs-set-char #x5363 ?$AXU(B) ; GB0-A-5855
(ucs-set-char #x5364 ?$(J#M(B) ; C04-J-234D
(ucs-set-char #x5364 ?$AB1(B) ; GB0-A-4231
(ucs-set-char #x5365 ?$(D4=(B) ; J90-D-343D
(ucs-set-char #x5365 ?$(L*!(B) ; C06-L-2A21
(ucs-set-char #x5366 ?$(CNO(B) ; KS0-C-4E4F
(ucs-set-char #x5366 ?$(GL9(B) ; C01-G-4C39
(ucs-set-char #x5366 ?$@75(B) ; J78-@-3735
(ucs-set-char #x5366 ?$AXT(B) ; GB0-A-5854
(ucs-set-char #x5366 ?$B75(B) ; J83-B-3735
(ucs-set-char #x5367 ?$(I*\(B) ; C03-I-2A5C
(ucs-set-char #x5367 ?$ANT(B) ; GB0-A-4E54
(ucs-set-char #x5368 ?$(C`Y(B) ; KS0-C-6059
(ucs-set-char #x5368 ?$(J0d(B) ; C04-J-3064

(ucs-set-char #x5369 ?$AZ`(B) ; GB0-A-5A60
(ucs-set-char #x5369 ?$(I!*(B) ; C03-I-212A
(ucs-set-char #x5369 ?$@RG(B) ; J78-@-5247
(ucs-set-char #x5369 ?$BRG(B) ; J83-B-5247

(ucs-set-char #x536A ?$(J!1(B) ; C04-J-2131
(ucs-set-char #x536B ?$(L!-(B) ; C06-L-212D
(ucs-set-char #x536B ?$AN@(B) ; GB0-A-4E40
(ucs-set-char #x536C ?$(D4>(B) ; J90-D-343E
(ucs-set-char #x536C ?$(H!7(B) ; C02-H-2137
(ucs-set-char #x536D ?$(D4?(B) ; J90-D-343F
(ucs-set-char #x536D ?$(I"((B) ; C03-I-2228
(ucs-set-char #x536E ?$(GF)(B) ; C01-G-4629
(ucs-set-char #x536E ?$@RH(B) ; J78-@-5248
(ucs-set-char #x536E ?$AX4(B) ; GB0-A-5834
(ucs-set-char #x536E ?$BRH(B) ; J83-B-5248
(ucs-set-char #x536F ?$(CYV(B) ; KS0-C-5956
(ucs-set-char #x536F ?$(GF((B) ; C01-G-4628
(ucs-set-char #x536F ?$@1,(B) ; J78-@-312C
(ucs-set-char #x536F ?$AC.(B) ; GB0-A-432E
(ucs-set-char #x536F ?$B1,(B) ; J83-B-312C
(ucs-set-char #x5370 ?$(ClT(B) ; KS0-C-6C54
(ucs-set-char #x5370 ?$(GGM(B) ; C01-G-474D
(ucs-set-char #x5370 ?$@0u(B) ; J78-@-3075
(ucs-set-char #x5370 ?$AS!(B) ; GB0-A-5321
(ucs-set-char #x5370 ?$B0u(B) ; J83-B-3075
(ucs-set-char #x5371 ?$(CjK(B) ; KS0-C-6A4B
(ucs-set-char #x5371 ?$(GGN(B) ; C01-G-474E
(ucs-set-char #x5371 ?$@4m(B) ; J78-@-346D
(ucs-set-char #x5371 ?$AN#(B) ; GB0-A-4E23
(ucs-set-char #x5371 ?$B4m(B) ; J83-B-346D
(ucs-set-char #x5372 ?$(D4@(B) ; J90-D-3440
(ucs-set-char #x5372 ?$(H#5(B) ; C02-H-2335
(ucs-set-char #x5373 ?$(GI;(B) ; C01-G-493B
(ucs-set-char #x5373 ?$@B((B) ; J78-@-4228
(ucs-set-char #x5373 ?$A<4(B) ; GB0-A-3C34
(ucs-set-char #x5373 ?$BB((B) ; J83-B-4228
(ucs-set-char #x5374 ?$(CJ?(B) ; KS0-C-4A3F
(ucs-set-char #x5374 ?$(I$g(B) ; C03-I-2467
(ucs-set-char #x5374 ?$@5Q(B) ; J78-@-3551
(ucs-set-char #x5374 ?$AH4(B) ; GB0-A-4834
(ucs-set-char #x5374 ?$B5Q(B) ; J83-B-3551
(ucs-set-char #x5375 ?$(CU0(B) ; KS0-C-5530
(ucs-set-char #x5375 ?$(GI<(B) ; C01-G-493C
(ucs-set-char #x5375 ?$@Mq(B) ; J78-@-4D71
(ucs-set-char #x5375 ?$ABQ(B) ; GB0-A-4251
(ucs-set-char #x5375 ?$BMq(B) ; J83-B-4D71
(ucs-set-char #x5376 ?$(I'e(B) ; C03-I-2765
(ucs-set-char #x5377 ?$(COi(B) ; KS0-C-4F69
(ucs-set-char #x5377 ?$(GL:(B) ; C01-G-4C3A
(ucs-set-char #x5377 ?$@RK(B) ; J78-@-524B
(ucs-set-char #x5377 ?$A>m(B) ; GB0-A-3E6D
(ucs-set-char #x5377 ?$BRK(B) ; J83-B-524B
(ucs-set-char #x5378 ?$(GL;(B) ; C01-G-4C3B
(ucs-set-char #x5378 ?$@27(B) ; J78-@-3237
(ucs-set-char #x5378 ?$AP6(B) ; GB0-A-5036
(ucs-set-char #x5378 ?$B27(B) ; J83-B-3237
(ucs-set-char #x5379 ?$(D4A(B) ; J90-D-3441
(ucs-set-char #x5379 ?$(GL<(B) ; C01-G-4C3C
(ucs-set-char #x537A ?$(I'f(B) ; C03-I-2766
(ucs-set-char #x537A ?$AZa(B) ; GB0-A-5A61
(ucs-set-char #x537B ?$(GP3(B) ; C01-G-5033
(ucs-set-char #x537B ?$@RJ(B) ; J78-@-524A
(ucs-set-char #x537B ?$BRJ(B) ; J83-B-524A
(ucs-set-char #x537C ?$(H)7(B) ; C02-H-2937
(ucs-set-char #x537D ?$(Cqm(B) ; KS0-C-716D
(ucs-set-char #x537D ?$(I+K(B) ; C03-I-2B4B
(ucs-set-char #x537E ?$(D4B(B) ; J90-D-3442
(ucs-set-char #x537E ?$(J0e(B) ; C04-J-3065
(ucs-set-char #x537F ?$(CLO(B) ; KS0-C-4C4F
(ucs-set-char #x537F ?$(GTN(B) ; C01-G-544E
(ucs-set-char #x537F ?$@6*(B) ; J78-@-362A
(ucs-set-char #x537F ?$AGd(B) ; GB0-A-4764
(ucs-set-char #x537F ?$B6*(B) ; J83-B-362A
(ucs-set-char #x5380 ?$(I@G(B) ; C03-I-4047

(ucs-set-char #x5382 ?$A3'(B) ; GB0-A-3327
(ucs-set-char #x5382 ?$(H!%(B) ; C02-H-2125
(ucs-set-char #x5382 ?$@RL(B) ; J78-@-524C
(ucs-set-char #x5382 ?$BRL(B) ; J83-B-524C

(ucs-set-char #x5383 ?$(D4C(B) ; J90-D-3443
(ucs-set-char #x5383 ?$(J!D(B) ; C04-J-2144
(ucs-set-char #x5384 ?$(Cdx(B) ; KS0-C-6478
(ucs-set-char #x5384 ?$(GE-(B) ; C01-G-452D
(ucs-set-char #x5384 ?$@Lq(B) ; J78-@-4C71
(ucs-set-char #x5384 ?$A6r(B) ; GB0-A-3672
(ucs-set-char #x5384 ?$BLq(B) ; J83-B-4C71
(ucs-set-char #x5385 ?$AL|(B) ; GB0-A-4C7C
(ucs-set-char #x5386 ?$(I![(B) ; C03-I-215B
(ucs-set-char #x5386 ?$A@z(B) ; GB0-A-407A
(ucs-set-char #x5387 ?$(D4D(B) ; J90-D-3444
(ucs-set-char #x5387 ?$(J!g(B) ; C04-J-2167
(ucs-set-char #x5388 ?$(D4E(B) ; J90-D-3445
(ucs-set-char #x5388 ?$(J!f(B) ; C04-J-2166
(ucs-set-char #x5389 ?$(I")(B) ; C03-I-2229
(ucs-set-char #x5389 ?$A@w(B) ; GB0-A-4077
(ucs-set-char #x538A ?$(H"$(B) ; C02-H-2224
(ucs-set-char #x538B ?$(I#/(B) ; C03-I-232F
(ucs-set-char #x538B ?$AQ9(B) ; GB0-A-5139
(ucs-set-char #x538C ?$AQa(B) ; GB0-A-5161
(ucs-set-char #x538D ?$AXG(B) ; GB0-A-5847
(ucs-set-char #x538E ?$(D4F(B) ; J90-D-3446
(ucs-set-char #x538E ?$(H#6(B) ; C02-H-2336
(ucs-set-char #x538F ?$(H#7(B) ; C02-H-2337
(ucs-set-char #x5392 ?$(H%Y(B) ; C02-H-2559
(ucs-set-char #x5393 ?$(Cdm(B) ; KS0-C-646D
(ucs-set-char #x5393 ?$(D4G(B) ; J90-D-3447
(ucs-set-char #x5393 ?$(I'g(B) ; C03-I-2767
(ucs-set-char #x5394 ?$(D4H(B) ; J90-D-3448
(ucs-set-char #x5394 ?$(H%Z(B) ; C02-H-255A
(ucs-set-char #x5395 ?$A2^(B) ; GB0-A-325E
(ucs-set-char #x5396 ?$(H)9(B) ; C02-H-2939
(ucs-set-char #x5396 ?$@RM(B) ; J78-@-524D
(ucs-set-char #x5396 ?$BRM(B) ; J83-B-524D
(ucs-set-char #x5397 ?$(H)8(B) ; C02-H-2938
(ucs-set-char #x5398 ?$(CWX(B) ; KS0-C-5758
(ucs-set-char #x5398 ?$(H);(B) ; C02-H-293B
(ucs-set-char #x5398 ?$@NR(B) ; J78-@-4E52
(ucs-set-char #x5398 ?$A@e(B) ; GB0-A-4065
(ucs-set-char #x5398 ?$BNR(B) ; J83-B-4E52
(ucs-set-char #x5399 ?$(D4I(B) ; J90-D-3449
(ucs-set-char #x5399 ?$(H):(B) ; C02-H-293A
(ucs-set-char #x539A ?$(C}'(B) ; KS0-C-7D27
(ucs-set-char #x539A ?$(GP4(B) ; C01-G-5034
(ucs-set-char #x539A ?$@8|(B) ; J78-@-387C
(ucs-set-char #x539A ?$A:q(B) ; GB0-A-3A71
(ucs-set-char #x539A ?$B8|(B) ; J83-B-387C
(ucs-set-char #x539C ?$(H3s(B) ; C02-H-3373
(ucs-set-char #x539D ?$(D4J(B) ; J90-D-344A
(ucs-set-char #x539D ?$(GTP(B) ; C01-G-5450
(ucs-set-char #x539D ?$AXH(B) ; GB0-A-5848
(ucs-set-char #x539E ?$(H.2(B) ; C02-H-2E32
(ucs-set-char #x539F ?$(Cj+(B) ; KS0-C-6A2B
(ucs-set-char #x539F ?$(GTO(B) ; C01-G-544F
(ucs-set-char #x539F ?$@86(B) ; J78-@-3836
(ucs-set-char #x539F ?$AT-(B) ; GB0-A-542D
(ucs-set-char #x539F ?$B86(B) ; J83-B-3836
(ucs-set-char #x53A0 ?$(Cv2(B) ; KS0-C-7632
(ucs-set-char #x53A0 ?$(I4T(B) ; C03-I-3454
(ucs-set-char #x53A0 ?$@RN(B) ; J78-@-524E
(ucs-set-char #x53A0 ?$BRN(B) ; J83-B-524E
(ucs-set-char #x53A1 ?$(D4K(B) ; J90-D-344B
(ucs-set-char #x53A1 ?$(J0h(B) ; C04-J-3068
(ucs-set-char #x53A2 ?$AOa(B) ; GB0-A-4F61
(ucs-set-char #x53A3 ?$AXI(B) ; GB0-A-5849
(ucs-set-char #x53A4 ?$(D4L(B) ; J90-D-344C
(ucs-set-char #x53A4 ?$(H:H(B) ; C02-H-3A48
(ucs-set-char #x53A5 ?$(COp(B) ; KS0-C-4F70
(ucs-set-char #x53A5 ?$(G^<(B) ; C01-G-5E3C
(ucs-set-char #x53A5 ?$@RP(B) ; J78-@-5250
(ucs-set-char #x53A5 ?$AXJ(B) ; GB0-A-584A
(ucs-set-char #x53A5 ?$BRP(B) ; J83-B-5250
(ucs-set-char #x53A6 ?$(Cy=(B) ; KS0-C-793D
(ucs-set-char #x53A6 ?$(I:((B) ; C03-I-3A28
(ucs-set-char #x53A6 ?$@RO(B) ; J78-@-524F
(ucs-set-char #x53A6 ?$AOC(B) ; GB0-A-4F43
(ucs-set-char #x53A6 ?$BRO(B) ; J83-B-524F
(ucs-set-char #x53A7 ?$(H:I(B) ; C02-H-3A49
(ucs-set-char #x53A8 ?$(I:'(B) ; C03-I-3A27
(ucs-set-char #x53A8 ?$@?_(B) ; J78-@-3F5F
(ucs-set-char #x53A8 ?$A3x(B) ; GB0-A-3378
(ucs-set-char #x53A8 ?$B?_(B) ; J83-B-3F5F
(ucs-set-char #x53A9 ?$(I@J(B) ; C03-I-404A
(ucs-set-char #x53A9 ?$@19(B) ; J78-@-3139
(ucs-set-char #x53A9 ?$A>G(B) ; GB0-A-3E47
(ucs-set-char #x53A9 ?$B19(B) ; J83-B-3139
(ucs-set-char #x53AA ?$(D4M(B) ; J90-D-344D
(ucs-set-char #x53AA ?$(I@I(B) ; C03-I-4049
(ucs-set-char #x53AB ?$(D4N(B) ; J90-D-344E
(ucs-set-char #x53AB ?$(I@H(B) ; C03-I-4048
(ucs-set-char #x53AC ?$(HI-(B) ; C02-H-492D
(ucs-set-char #x53AD ?$(Cft(B) ; KS0-C-6674
(ucs-set-char #x53AD ?$(Gh%(B) ; C01-G-6825
(ucs-set-char #x53AD ?$@1^(B) ; J78-@-315E
(ucs-set-char #x53AD ?$B1^(B) ; J83-B-315E
(ucs-set-char #x53AE ?$(IF%(B) ; C03-I-4625
(ucs-set-char #x53AE ?$@RQ(B) ; J78-@-5251
(ucs-set-char #x53AE ?$AXK(B) ; GB0-A-584B
(ucs-set-char #x53AE ?$BRQ(B) ; J83-B-5251
(ucs-set-char #x53AF ?$(D4O(B) ; J90-D-344F
(ucs-set-char #x53AF ?$(J<@(B) ; C04-J-3C40
(ucs-set-char #x53B0 ?$(IF&(B) ; C03-I-4626
(ucs-set-char #x53B0 ?$@RR(B) ; J78-@-5252
(ucs-set-char #x53B0 ?$BRR(B) ; J83-B-5252
(ucs-set-char #x53B1 ?$(IK5(B) ; C03-I-4B35
(ucs-set-char #x53B2 ?$(D4P(B) ; J90-D-3450
(ucs-set-char #x53B2 ?$(Gl0(B) ; C01-G-6C30
(ucs-set-char #x53B3 ?$(ITE(B) ; C03-I-5445
(ucs-set-char #x53B3 ?$@87(B) ; J78-@-3837
(ucs-set-char #x53B3 ?$B87(B) ; J83-B-3837
(ucs-set-char #x53B4 ?$(D4Q(B) ; J90-D-3451
(ucs-set-char #x53B4 ?$(He;(B) ; C02-H-653B
(ucs-set-char #x53B5 ?$(D4R(B) ; J90-D-3452

(ucs-set-char #x53B6 ?$A[L(B) ; GB0-A-5B4C
(ucs-set-char #x53B6 ?$(I!+(B) ; C03-I-212B
(ucs-set-char #x53B6 ?$@RS(B) ; J78-@-5253
(ucs-set-char #x53B6 ?$BRS(B) ; J83-B-5253

(ucs-set-char #x53B7 ?$(D4S(B) ; J90-D-3453
(ucs-set-char #x53B7 ?$(I!\(B) ; C03-I-215C
(ucs-set-char #x53B8 ?$(D4T(B) ; J90-D-3454
(ucs-set-char #x53B8 ?$(J!E(B) ; C04-J-2145
(ucs-set-char #x53B9 ?$(H!8(B) ; C02-H-2138
(ucs-set-char #x53BA ?$(D4U(B) ; J90-D-3455
(ucs-set-char #x53BA ?$(I"*(B) ; C03-I-222A
(ucs-set-char #x53BB ?$(CK[(B) ; KS0-C-4B5B
(ucs-set-char #x53BB ?$(GF*(B) ; C01-G-462A
(ucs-set-char #x53BB ?$@5n(B) ; J78-@-356E
(ucs-set-char #x53BB ?$AH%(B) ; GB0-A-4825
(ucs-set-char #x53BB ?$B5n(B) ; J83-B-356E
(ucs-set-char #x53BD ?$(D4V(B) ; J90-D-3456
(ucs-set-char #x53BD ?$(J"H(B) ; C04-J-2248
(ucs-set-char #x53BE ?$(I#1(B) ; C03-I-2331
(ucs-set-char #x53BF ?$AOX(B) ; GB0-A-4F58
(ucs-set-char #x53C0 ?$(D4W(B) ; J90-D-3457
(ucs-set-char #x53C0 ?$(J%Y(B) ; C04-J-2559
(ucs-set-char #x53C1 ?$(I'i(B) ; C03-I-2769
(ucs-set-char #x53C1 ?$AH~(B) ; GB0-A-487E
(ucs-set-char #x53C2 ?$(I'j(B) ; C03-I-276A
(ucs-set-char #x53C2 ?$@;2(B) ; J78-@-3B32
(ucs-set-char #x53C2 ?$A2N(B) ; GB0-A-324E
(ucs-set-char #x53C2 ?$B;2(B) ; J83-B-3B32
(ucs-set-char #x53C3 ?$(CsQ(B) ; KS0-C-7351
(ucs-set-char #x53C3 ?$(GY6(B) ; C01-G-5936
(ucs-set-char #x53C3 ?$@RT(B) ; J78-@-5254
(ucs-set-char #x53C3 ?$BRT(B) ; J83-B-5254
(ucs-set-char #x53C4 ?$(I4U(B) ; C03-I-3455
(ucs-set-char #x53C5 ?$(D4X(B) ; J90-D-3458
(ucs-set-char #x53C5 ?$(I:)(B) ; C03-I-3A29

(ucs-set-char #x53C8 ?$ASV(B) ; GB0-A-5356
(ucs-set-char #x53C8 ?$(CiQ(B) ; KS0-C-6951
(ucs-set-char #x53C8 ?$(GD4(B) ; C01-G-4434
(ucs-set-char #x53C8 ?$@Kt(B) ; J78-@-4B74
(ucs-set-char #x53C8 ?$BKt(B) ; J83-B-4B74

(ucs-set-char #x53C9 ?$(Cs)(B) ; KS0-C-7329
(ucs-set-char #x53C9 ?$(GDF(B) ; C01-G-4446
(ucs-set-char #x53C9 ?$@:5(B) ; J78-@-3A35
(ucs-set-char #x53C9 ?$A2f(B) ; GB0-A-3266
(ucs-set-char #x53C9 ?$B:5(B) ; J83-B-3A35
(ucs-set-char #x53CA ?$(CP`(B) ; KS0-C-5060
(ucs-set-char #x53CA ?$(GE/(B) ; C01-G-452F
(ucs-set-char #x53CA ?$(L!a(B) ; C06-L-2161
(ucs-set-char #x53CA ?$@5Z(B) ; J78-@-355A
(ucs-set-char #x53CA ?$A<0(B) ; GB0-A-3C30
(ucs-set-char #x53CA ?$B5Z(B) ; J83-B-355A
(ucs-set-char #x53CB ?$(CiR(B) ; KS0-C-6952
(ucs-set-char #x53CB ?$(GE.(B) ; C01-G-452E
(ucs-set-char #x53CB ?$@M'(B) ; J78-@-4D27
(ucs-set-char #x53CB ?$ASQ(B) ; GB0-A-5351
(ucs-set-char #x53CB ?$BM'(B) ; J83-B-4D27
(ucs-set-char #x53CC ?$(I!^(B) ; C03-I-215E
(ucs-set-char #x53CC ?$@AP(B) ; J78-@-4150
(ucs-set-char #x53CC ?$AK+(B) ; GB0-A-4B2B
(ucs-set-char #x53CC ?$BAP(B) ; J83-B-4150
(ucs-define-ideograph #x53CD 029 02
		      ?$A74(B ; GB0-A-3734
                      ;; ?$@H?(B ; J78-@-483F
                      ;; ?$BH?(B ; J83-B-483F
                      ;; ?$(GE0(B ; C01-G-4530
                      ;; ?$(CZc(B ; KS0-C-5A63
		      )
(ucs-set-char #x53CE ?$(I!`(B) ; C03-I-2160
(ucs-set-char #x53CE ?$@<}(B) ; J78-@-3C7D
(ucs-set-char #x53CE ?$B<}(B) ; J83-B-3C7D
(ucs-set-char #x53CF ?$(D4Y(B) ; J90-D-3459
(ucs-set-char #x53CF ?$(J!i(B) ; C04-J-2169
(ucs-set-char #x53D0 ?$(I"+(B) ; C03-I-222B
(ucs-set-char #x53D1 ?$A7"(B) ; GB0-A-3722
(ucs-set-char #x53D2 ?$(D4Z(B) ; J90-D-345A
(ucs-set-char #x53D2 ?$(I#3(B) ; C03-I-2333
(ucs-set-char #x53D3 ?$(D4[(B) ; J90-D-345B
(ucs-set-char #x53D3 ?$(J#O(B) ; C04-J-234F
(ucs-set-char #x53D4 ?$(CbR(B) ; KS0-C-6252
(ucs-set-char #x53D4 ?$(GL>(B) ; C01-G-4C3E
(ucs-set-char #x53D4 ?$@=G(B) ; J78-@-3D47
(ucs-set-char #x53D4 ?$AJe(B) ; GB0-A-4A65
(ucs-set-char #x53D4 ?$B=G(B) ; J83-B-3D47
(ucs-set-char #x53D5 ?$(D4\(B) ; J90-D-345C
(ucs-set-char #x53D5 ?$(I'k(B) ; C03-I-276B
(ucs-set-char #x53D6 ?$(Cv"(B) ; KS0-C-7622
(ucs-set-char #x53D6 ?$(GL=(B) ; C01-G-4C3D
(ucs-set-char #x53D6 ?$@<h(B) ; J78-@-3C68
(ucs-set-char #x53D6 ?$AH!(B) ; GB0-A-4821
(ucs-set-char #x53D6 ?$B<h(B) ; J83-B-3C68
(ucs-set-char #x53D7 ?$(Cat(B) ; KS0-C-6174
(ucs-set-char #x53D7 ?$(GL?(B) ; C01-G-4C3F
(ucs-set-char #x53D7 ?$@<u(B) ; J78-@-3C75
(ucs-set-char #x53D7 ?$AJ\(B) ; GB0-A-4A5C
(ucs-set-char #x53D7 ?$B<u(B) ; J83-B-3C75
(ucs-set-char #x53D8 ?$A1d(B) ; GB0-A-3164
(ucs-set-char #x53D9 ?$(I+P(B) ; C03-I-2B50
(ucs-set-char #x53D9 ?$@=v(B) ; J78-@-3D76
(ucs-set-char #x53D9 ?$APp(B) ; GB0-A-5070
(ucs-set-char #x53D9 ?$B=v(B) ; J83-B-3D76
(ucs-set-char #x53DA ?$(D4](B) ; J90-D-345D
(ucs-set-char #x53DA ?$(I+O(B) ; C03-I-2B4F
(ucs-define-ideograph #x53DB 029 07
		      ?$AEQ(B ; GB0-A-4551
                      ;; ?$(GP5(B ; C01-G-5035
                      ;; ?$@H@(B ; J78-@-4840
                      ;; ?$BH@(B ; J83-B-4840
                      ;; ?$(CZd(B ; KS0-C-5A64
		      )
(ucs-set-char #x53DC ?$(I+N(B) ; C03-I-2B4E
(ucs-set-char #x53DD ?$(D4^(B) ; J90-D-345E
(ucs-set-char #x53DD ?$(I+M(B) ; C03-I-2B4D
(ucs-set-char #x53DE ?$(D4_(B) ; J90-D-345F
(ucs-set-char #x53DE ?$(L5x(B) ; C06-L-3578
(ucs-set-char #x53DF ?$(GTQ(B) ; C01-G-5451
(ucs-set-char #x53DF ?$@RW(B) ; J78-@-5257
(ucs-set-char #x53DF ?$A[E(B) ; GB0-A-5B45
(ucs-set-char #x53DF ?$BRW(B) ; J83-B-5257
(ucs-set-char #x53E0 ?$(D4`(B) ; J90-D-3460
(ucs-set-char #x53E0 ?$(I@K(B) ; C03-I-404B
(ucs-set-char #x53E0 ?$A5~(B) ; GB0-A-357E
(ucs-set-char #x53E1 ?$(CgU(B) ; KS0-C-6755
(ucs-set-char #x53E1 ?$(HVF(B) ; C02-H-5646
(ucs-set-char #x53E1 ?$@1C(B) ; J78-@-3143
(ucs-set-char #x53E1 ?$B1C(B) ; J83-B-3143
(ucs-set-char #x53E2 ?$(Cu?(B) ; KS0-C-753F
(ucs-set-char #x53E2 ?$(Gv;(B) ; C01-G-763B
(ucs-set-char #x53E2 ?$@AQ(B) ; J78-@-4151
(ucs-set-char #x53E2 ?$BAQ(B) ; J83-B-4151

(ucs-set-char #x53E3 ?$A?Z(B) ; GB0-A-3F5A
(ucs-set-char #x53E3 ?$(CO"(B) ; KS0-C-4F22
(ucs-set-char #x53E3 ?$(GDG(B) ; C01-G-4447
(ucs-set-char #x53E3 ?$@8}(B) ; J78-@-387D
(ucs-set-char #x53E3 ?$B8}(B) ; J83-B-387D

(ucs-set-char #x53E4 ?$(CM/(B) ; KS0-C-4D2F
(ucs-set-char #x53E4 ?$(GF,(B) ; C01-G-462C
(ucs-set-char #x53E4 ?$@8E(B) ; J78-@-3845
(ucs-set-char #x53E4 ?$A9E(B) ; GB0-A-3945
(ucs-set-char #x53E4 ?$B8E(B) ; J83-B-3845
(ucs-set-char #x53E5 ?$(CO#(B) ; KS0-C-4F23
(ucs-set-char #x53E5 ?$(GF;(B) ; C01-G-463B
(ucs-set-char #x53E5 ?$@6g(B) ; J78-@-3667
(ucs-set-char #x53E5 ?$A>d(B) ; GB0-A-3E64
(ucs-set-char #x53E5 ?$B6g(B) ; J83-B-3667
(ucs-set-char #x53E6 ?$(D4a(B) ; J90-D-3461
(ucs-set-char #x53E6 ?$(GF6(B) ; C01-G-4636
(ucs-set-char #x53E6 ?$AAm(B) ; GB0-A-416D
(ucs-set-char #x53E7 ?$(D4b(B) ; J90-D-3462
(ucs-set-char #x53E7 ?$(J!l(B) ; C04-J-216C
(ucs-set-char #x53E8 ?$(GF1(B) ; C01-G-4631
(ucs-set-char #x53E8 ?$@R[(B) ; J78-@-525B
(ucs-set-char #x53E8 ?$A_6(B) ; GB0-A-5F36
(ucs-set-char #x53E8 ?$BR[(B) ; J83-B-525B
(ucs-set-char #x53E9 ?$(CM0(B) ; KS0-C-4D30
(ucs-set-char #x53E9 ?$(GF0(B) ; C01-G-4630
(ucs-set-char #x53E9 ?$@C!(B) ; J78-@-4321
(ucs-set-char #x53E9 ?$A_5(B) ; GB0-A-5F35
(ucs-set-char #x53E9 ?$BC!(B) ; J83-B-4321
(ucs-set-char #x53EA ?$(Cq~(B) ; KS0-C-717E
(ucs-set-char #x53EA ?$(GF7(B) ; C01-G-4637
(ucs-set-char #x53EA ?$@B~(B) ; J78-@-427E
(ucs-set-char #x53EA ?$AV;(B) ; GB0-A-563B
(ucs-set-char #x53EA ?$BB~(B) ; J83-B-427E
(ucs-set-char #x53EB ?$(CP#(B) ; KS0-C-5023
(ucs-set-char #x53EB ?$(GF5(B) ; C01-G-4635
(ucs-set-char #x53EB ?$(L"[(B) ; C06-L-225B
(ucs-set-char #x53EB ?$@6+(B) ; J78-@-362B
(ucs-set-char #x53EB ?$A=P(B) ; GB0-A-3D50
(ucs-set-char #x53EB ?$B6+(B) ; J83-B-362B
(ucs-set-char #x53EC ?$(Ca/(B) ; KS0-C-612F
(ucs-set-char #x53EC ?$(GF.(B) ; C01-G-462E
(ucs-set-char #x53EC ?$@>$(B) ; J78-@-3E24
(ucs-set-char #x53EC ?$AUY(B) ; GB0-A-5559
(ucs-set-char #x53EC ?$B>$(B) ; J83-B-3E24
(ucs-set-char #x53ED ?$(Cx#(B) ; KS0-C-7823
(ucs-set-char #x53ED ?$(GF<(B) ; C01-G-463C
(ucs-set-char #x53ED ?$@R\(B) ; J78-@-525C
(ucs-set-char #x53ED ?$A0H(B) ; GB0-A-3048
(ucs-set-char #x53ED ?$BR\(B) ; J83-B-525C
(ucs-set-char #x53EE ?$(GF/(B) ; C01-G-462F
(ucs-set-char #x53EE ?$@RZ(B) ; J78-@-525A
(ucs-set-char #x53EE ?$A6#(B) ; GB0-A-3623
(ucs-set-char #x53EE ?$BRZ(B) ; J83-B-525A
(ucs-set-char #x53EF ?$(CJ&(B) ; KS0-C-4A26
(ucs-set-char #x53EF ?$(GF+(B) ; C01-G-462B
(ucs-set-char #x53EF ?$@2D(B) ; J78-@-3244
(ucs-set-char #x53EF ?$A?I(B) ; GB0-A-3F49
(ucs-set-char #x53EF ?$B2D(B) ; J83-B-3244
(ucs-set-char #x53F0 ?$(Cw;(B) ; KS0-C-773B
(ucs-set-char #x53F0 ?$(GF:(B) ; C01-G-463A
(ucs-set-char #x53F0 ?$@Bf(B) ; J78-@-4266
(ucs-set-char #x53F0 ?$AL((B) ; GB0-A-4C28
(ucs-set-char #x53F0 ?$BBf(B) ; J83-B-4266
(ucs-set-char #x53F1 ?$(Crj(B) ; KS0-C-726A
(ucs-set-char #x53F1 ?$(GF9(B) ; C01-G-4639
(ucs-set-char #x53F1 ?$@<8(B) ; J78-@-3C38
(ucs-set-char #x53F1 ?$A_3(B) ; GB0-A-5F33
(ucs-set-char #x53F1 ?$B<8(B) ; J83-B-3C38
(ucs-set-char #x53F2 ?$(C^H(B) ; KS0-C-5E48
(ucs-set-char #x53F2 ?$(GF8(B) ; C01-G-4638
(ucs-set-char #x53F2 ?$@;K(B) ; J78-@-3B4B
(ucs-set-char #x53F2 ?$AJ7(B) ; GB0-A-4A37
(ucs-set-char #x53F2 ?$B;K(B) ; J83-B-3B4B
(ucs-set-char #x53F3 ?$(CiS(B) ; KS0-C-6953
(ucs-set-char #x53F3 ?$(GF-(B) ; C01-G-462D
(ucs-set-char #x53F3 ?$@1&(B) ; J78-@-3126
(ucs-set-char #x53F3 ?$ASR(B) ; GB0-A-5352
(ucs-set-char #x53F3 ?$B1&(B) ; J83-B-3126
(ucs-set-char #x53F4 ?$(I"1(B) ; C03-I-2231
(ucs-set-char #x53F5 ?$(D4c(B) ; J90-D-3463
(ucs-set-char #x53F5 ?$(GF4(B) ; C01-G-4634
(ucs-set-char #x53F5 ?$AXO(B) ; GB0-A-584F
(ucs-set-char #x53F6 ?$(I"-(B) ; C03-I-222D
(ucs-set-char #x53F6 ?$@3p(B) ; J78-@-3370
(ucs-set-char #x53F6 ?$AR6(B) ; GB0-A-5236
(ucs-set-char #x53F6 ?$B3p(B) ; J83-B-3370
(ucs-set-char #x53F7 ?$(I".(B) ; C03-I-222E
(ucs-set-char #x53F7 ?$@9f(B) ; J78-@-3966
(ucs-set-char #x53F7 ?$A:E(B) ; GB0-A-3A45
(ucs-set-char #x53F7 ?$B9f(B) ; J83-B-3966
(ucs-set-char #x53F8 ?$(C^I(B) ; KS0-C-5E49
(ucs-set-char #x53F8 ?$(GF3(B) ; C01-G-4633
(ucs-set-char #x53F8 ?$@;J(B) ; J78-@-3B4A
(ucs-set-char #x53F8 ?$AK>(B) ; GB0-A-4B3E
(ucs-set-char #x53F8 ?$B;J(B) ; J83-B-3B4A
(ucs-set-char #x53F9 ?$(I"/(B) ; C03-I-222F
(ucs-set-char #x53F9 ?$AL>(B) ; GB0-A-4C3E
(ucs-set-char #x53FA ?$@R](B) ; J78-@-525D
(ucs-set-char #x53FA ?$BR](B) ; J83-B-525D
(ucs-set-char #x53FB ?$(GF=(B) ; C01-G-463D
(ucs-set-char #x53FB ?$A_7(B) ; GB0-A-5F37
(ucs-set-char #x53FC ?$(GF2(B) ; C01-G-4632
(ucs-set-char #x53FC ?$A5p(B) ; GB0-A-3570
(ucs-set-char #x53FD ?$A_4(B) ; GB0-A-5F34
(ucs-set-char #x53FF ?$(I#5(B) ; C03-I-2335
(ucs-set-char #x5400 ?$(I#7(B) ; C03-I-2337
(ucs-set-char #x5401 ?$(GGT(B) ; C01-G-4754
(ucs-set-char #x5401 ?$@R^(B) ; J78-@-525E
(ucs-set-char #x5401 ?$ASu(B) ; GB0-A-5375
(ucs-set-char #x5401 ?$BR^(B) ; J83-B-525E
(ucs-set-char #x5402 ?$(D4d(B) ; J90-D-3464
(ucs-set-char #x5402 ?$(J"L(B) ; C04-J-224C
(ucs-set-char #x5403 ?$(C}^(B) ; KS0-C-7D5E
(ucs-set-char #x5403 ?$(GGZ(B) ; C01-G-475A
(ucs-set-char #x5403 ?$@5I(B) ; J78-@-3549
(ucs-set-char #x5403 ?$A3T(B) ; GB0-A-3354
(ucs-set-char #x5403 ?$B5I(B) ; J83-B-3549
(ucs-set-char #x5404 ?$(CJ@(B) ; KS0-C-4A40
(ucs-set-char #x5404 ?$(GGV(B) ; C01-G-4756
(ucs-set-char #x5404 ?$@3F(B) ; J78-@-3346
(ucs-set-char #x5404 ?$A8w(B) ; GB0-A-3877
(ucs-set-char #x5404 ?$B3F(B) ; J83-B-3346
(ucs-set-char #x5405 ?$(I#9(B) ; C03-I-2339
(ucs-set-char #x5406 ?$(GG\(B) ; C01-G-475C
(ucs-set-char #x5406 ?$A_:(B) ; GB0-A-5F3A
(ucs-set-char #x5407 ?$(H"%(B) ; C02-H-2225
(ucs-set-char #x5408 ?$(Cyj(B) ; KS0-C-796A
(ucs-set-char #x5408 ?$(GGY(B) ; C01-G-4759
(ucs-set-char #x5408 ?$@9g(B) ; J78-@-3967
(ucs-set-char #x5408 ?$A:O(B) ; GB0-A-3A4F
(ucs-set-char #x5408 ?$B9g(B) ; J83-B-3967
(ucs-set-char #x5409 ?$(CQN(B) ; KS0-C-514E
(ucs-set-char #x5409 ?$(GGO(B) ; C01-G-474F
(ucs-set-char #x5409 ?$@5H(B) ; J78-@-3548
(ucs-set-char #x5409 ?$A<*(B) ; GB0-A-3C2A
(ucs-set-char #x5409 ?$B5H(B) ; J83-B-3548
(ucs-set-char #x540A ?$(CnT(B) ; KS0-C-6E54
(ucs-set-char #x540A ?$(GGR(B) ; C01-G-4752
(ucs-set-char #x540A ?$@D_(B) ; J78-@-445F
(ucs-set-char #x540A ?$A5u(B) ; GB0-A-3575
(ucs-set-char #x540A ?$BD_(B) ; J83-B-445F
(ucs-set-char #x540B ?$(GGU(B) ; C01-G-4755
(ucs-set-char #x540B ?$@1%(B) ; J78-@-3125
(ucs-set-char #x540B ?$B1%(B) ; J83-B-3125
(ucs-set-char #x540C ?$(CTR(B) ; KS0-C-5452
(ucs-set-char #x540C ?$(GGQ(B) ; C01-G-4751
(ucs-set-char #x540C ?$@F1(B) ; J78-@-4631
(ucs-set-char #x540C ?$AM,(B) ; GB0-A-4D2C
(ucs-set-char #x540C ?$BF1(B) ; J83-B-4631
(ucs-set-char #x540D ?$(CY#(B) ; KS0-C-5923
(ucs-set-char #x540D ?$(GGX(B) ; C01-G-4758
(ucs-set-char #x540D ?$@L>(B) ; J78-@-4C3E
(ucs-set-char #x540D ?$AC{(B) ; GB0-A-437B
(ucs-set-char #x540D ?$BL>(B) ; J83-B-4C3E
(ucs-set-char #x540E ?$(C}((B) ; KS0-C-7D28
(ucs-set-char #x540E ?$(GG[(B) ; C01-G-475B
(ucs-set-char #x540E ?$@9!(B) ; J78-@-3921
(ucs-set-char #x540E ?$A:s(B) ; GB0-A-3A73
(ucs-set-char #x540E ?$B9!(B) ; J83-B-3921
(ucs-set-char #x540F ?$(CWY(B) ; KS0-C-5759
(ucs-set-char #x540F ?$(GGP(B) ; C01-G-4750
(ucs-set-char #x540F ?$@My(B) ; J78-@-4D79
(ucs-set-char #x540F ?$A@t(B) ; GB0-A-4074
(ucs-set-char #x540F ?$BMy(B) ; J83-B-4D79
(ucs-set-char #x5410 ?$(CwN(B) ; KS0-C-774E
(ucs-set-char #x5410 ?$(GGS(B) ; C01-G-4753
(ucs-set-char #x5410 ?$@EG(B) ; J78-@-4547
(ucs-set-char #x5410 ?$AMB(B) ; GB0-A-4D42
(ucs-set-char #x5410 ?$BEG(B) ; J83-B-4547
(ucs-set-char #x5411 ?$(Cz>(B) ; KS0-C-7A3E
(ucs-set-char #x5411 ?$(GGW(B) ; C01-G-4757
(ucs-set-char #x5411 ?$@8~(B) ; J78-@-387E
(ucs-set-char #x5411 ?$AOr(B) ; GB0-A-4F72
(ucs-set-char #x5411 ?$B8~(B) ; J83-B-387E
(ucs-set-char #x5412 ?$(GG](B) ; C01-G-475D
(ucs-set-char #x5412 ?$A_8(B) ; GB0-A-5F38
(ucs-set-char #x5413 ?$(D4e(B) ; J90-D-3465
(ucs-set-char #x5413 ?$(I#:(B) ; C03-I-233A
(ucs-set-char #x5413 ?$AOE(B) ; GB0-A-4F45
(ucs-set-char #x5415 ?$(I#;(B) ; C03-I-233B
(ucs-set-char #x5415 ?$AB@(B) ; GB0-A-4240
(ucs-set-char #x5416 ?$(I#4(B) ; C03-I-2334
(ucs-set-char #x5416 ?$A_9(B) ; GB0-A-5F39
(ucs-set-char #x5417 ?$ABp(B) ; GB0-A-4270
(ucs-set-char #x5418 ?$(H#@(B) ; C02-H-2340
(ucs-set-char #x5419 ?$(H#=(B) ; C02-H-233D
(ucs-set-char #x541A ?$(D4f(B) ; J90-D-3466
(ucs-set-char #x541A ?$(I$v(B) ; C03-I-2476
(ucs-set-char #x541B ?$(COV(B) ; KS0-C-4F56
(ucs-set-char #x541B ?$(GII(B) ; C01-G-4949
(ucs-set-char #x541B ?$@7/(B) ; J78-@-372F
(ucs-set-char #x541B ?$A>}(B) ; GB0-A-3E7D
(ucs-set-char #x541B ?$B7/(B) ; J83-B-372F
(ucs-set-char #x541C ?$(H#>(B) ; C02-H-233E
(ucs-set-char #x541D ?$(CWp(B) ; KS0-C-5770
(ucs-set-char #x541D ?$(GI=(B) ; C01-G-493D
(ucs-set-char #x541D ?$@Rg(B) ; J78-@-5267
(ucs-set-char #x541D ?$AA_(B) ; GB0-A-415F
(ucs-set-char #x541D ?$BRg(B) ; J83-B-5267
(ucs-set-char #x541E ?$(GI?(B) ; C01-G-493F
(ucs-set-char #x541E ?$AML(B) ; GB0-A-4D4C
(ucs-set-char #x541F ?$(Cka(B) ; KS0-C-6B61
(ucs-set-char #x541F ?$(GIW(B) ; C01-G-4957
(ucs-set-char #x541F ?$@6c(B) ; J78-@-3663
(ucs-set-char #x541F ?$ARw(B) ; GB0-A-5277
(ucs-set-char #x541F ?$B6c(B) ; J83-B-3663
(ucs-set-char #x5420 ?$(CxE(B) ; KS0-C-7845
(ucs-set-char #x5420 ?$(GIR(B) ; C01-G-4952
(ucs-set-char #x5420 ?$@KJ(B) ; J78-@-4B4A
(ucs-set-char #x5420 ?$A7M(B) ; GB0-A-374D
(ucs-set-char #x5420 ?$BKJ(B) ; J83-B-4B4A
(ucs-set-char #x5421 ?$(D4g(B) ; J90-D-3467
(ucs-set-char #x5421 ?$(I$y(B) ; C03-I-2479
(ucs-set-char #x5421 ?$A_A(B) ; GB0-A-5F41
(ucs-set-char #x5422 ?$(I$~(B) ; C03-I-247E
(ucs-set-char #x5423 ?$(I$u(B) ; C03-I-2475
(ucs-set-char #x5423 ?$A_D(B) ; GB0-A-5F44
(ucs-set-char #x5424 ?$(H#E(B) ; C02-H-2345
(ucs-set-char #x5425 ?$(H#?(B) ; C02-H-233F
(ucs-set-char #x5426 ?$(C\z(B) ; KS0-C-5C7A
(ucs-set-char #x5426 ?$(GIA(B) ; C01-G-4941
(ucs-set-char #x5426 ?$@H](B) ; J78-@-485D
(ucs-set-char #x5426 ?$A7q(B) ; GB0-A-3771
(ucs-set-char #x5426 ?$BH](B) ; J83-B-485D
(ucs-set-char #x5427 ?$(D4h(B) ; J90-D-3468
(ucs-set-char #x5427 ?$(GIC(B) ; C01-G-4943
(ucs-set-char #x5427 ?$A0I(B) ; GB0-A-3049
(ucs-set-char #x5428 ?$(D4i(B) ; J90-D-3469
(ucs-set-char #x5428 ?$(H#D(B) ; C02-H-2344
(ucs-set-char #x5428 ?$A6V(B) ; GB0-A-3656
(ucs-set-char #x5429 ?$(C]C(B) ; KS0-C-5D43
(ucs-set-char #x5429 ?$(GIJ(B) ; C01-G-494A
(ucs-set-char #x5429 ?$@Rf(B) ; J78-@-5266
(ucs-set-char #x5429 ?$A7T(B) ; GB0-A-3754
(ucs-set-char #x5429 ?$BRf(B) ; J83-B-5266
(ucs-set-char #x542A ?$(D4j(B) ; J90-D-346A
(ucs-set-char #x542A ?$(H#:(B) ; C02-H-233A
(ucs-set-char #x542B ?$(Cy_(B) ; KS0-C-795F
(ucs-set-char #x542B ?$(GIV(B) ; C01-G-4956
(ucs-set-char #x542B ?$@4^(B) ; J78-@-345E
(ucs-set-char #x542B ?$A:,(B) ; GB0-A-3A2C
(ucs-set-char #x542B ?$B4^(B) ; J83-B-345E
(ucs-set-char #x542C ?$(GIX(B) ; C01-G-4958
(ucs-set-char #x542C ?$@Ra(B) ; J78-@-5261
(ucs-set-char #x542C ?$AL}(B) ; GB0-A-4C7D
(ucs-set-char #x542C ?$BRa(B) ; J83-B-5261
(ucs-set-char #x542D ?$(GI>(B) ; C01-G-493E
(ucs-set-char #x542D ?$@Rb(B) ; J78-@-5262
(ucs-set-char #x542D ?$A?T(B) ; GB0-A-3F54
(ucs-set-char #x542D ?$BRb(B) ; J83-B-5262
(ucs-set-char #x542E ?$(GIO(B) ; C01-G-494F
(ucs-set-char #x542E ?$@Rd(B) ; J78-@-5264
(ucs-set-char #x542E ?$AK1(B) ; GB0-A-4B31
(ucs-set-char #x542E ?$BRd(B) ; J83-B-5264
(ucs-set-char #x542F ?$(D4k(B) ; J90-D-346B
(ucs-set-char #x542F ?$(I%$(B) ; C03-I-2524
(ucs-set-char #x542F ?$AFt(B) ; GB0-A-4674
(ucs-set-char #x5430 ?$(H#8(B) ; C02-H-2338
(ucs-set-char #x5431 ?$(D4l(B) ; J90-D-346C
(ucs-set-char #x5431 ?$(GIU(B) ; C01-G-4955
(ucs-set-char #x5431 ?$AV((B) ; GB0-A-5628
(ucs-set-char #x5432 ?$(I$w(B) ; C03-I-2477
(ucs-set-char #x5432 ?$A_E(B) ; GB0-A-5F45
(ucs-set-char #x5433 ?$(Cgo(B) ; KS0-C-676F
(ucs-set-char #x5433 ?$(GIF(B) ; C01-G-4946
(ucs-set-char #x5434 ?$(D4m(B) ; J90-D-346D
(ucs-set-char #x5434 ?$(I${(B) ; C03-I-247B
(ucs-set-char #x5434 ?$ANb(B) ; GB0-A-4E62
(ucs-set-char #x5435 ?$(D4n(B) ; J90-D-346E
(ucs-set-char #x5435 ?$(GIP(B) ; C01-G-4950
(ucs-set-char #x5435 ?$A33(B) ; GB0-A-3333
(ucs-set-char #x5436 ?$(GIQ(B) ; C01-G-4951
(ucs-set-char #x5436 ?$@Re(B) ; J78-@-5265
(ucs-set-char #x5436 ?$BRe(B) ; J83-B-5265
(ucs-set-char #x5437 ?$(H#9(B) ; C02-H-2339
(ucs-set-char #x5438 ?$(C}e(B) ; KS0-C-7D65
(ucs-set-char #x5438 ?$(GIN(B) ; C01-G-494E
(ucs-set-char #x5438 ?$(L&N(B) ; C06-L-264E
(ucs-set-char #x5438 ?$@5[(B) ; J78-@-355B
(ucs-set-char #x5438 ?$AN|(B) ; GB0-A-4E7C
(ucs-set-char #x5438 ?$B5[(B) ; J83-B-355B
(ucs-set-char #x5439 ?$(Cv#(B) ; KS0-C-7623
(ucs-set-char #x5439 ?$(GIL(B) ; C01-G-494C
(ucs-set-char #x5439 ?$@?a(B) ; J78-@-3F61
(ucs-set-char #x5439 ?$A45(B) ; GB0-A-3435
(ucs-set-char #x5439 ?$B?a(B) ; J83-B-3F61
(ucs-set-char #x543A ?$(I$p(B) ; C03-I-2470
(ucs-set-char #x543B ?$(CY|(B) ; KS0-C-597C
(ucs-set-char #x543B ?$(GIM(B) ; C01-G-494D
(ucs-set-char #x543B ?$@J-(B) ; J78-@-4A2D
(ucs-set-char #x543B ?$ANG(B) ; GB0-A-4E47
(ucs-set-char #x543B ?$BJ-(B) ; J83-B-4A2D
(ucs-set-char #x543C ?$(C})(B) ; KS0-C-7D29
(ucs-set-char #x543C ?$(GIS(B) ; C01-G-4953
(ucs-set-char #x543C ?$@Rc(B) ; J78-@-5263
(ucs-set-char #x543C ?$A:p(B) ; GB0-A-3A70
(ucs-set-char #x543C ?$BRc(B) ; J83-B-5263
(ucs-set-char #x543D ?$(H#A(B) ; C02-H-2341
(ucs-set-char #x543D ?$@R_(B) ; J78-@-525F
(ucs-set-char #x543D ?$BR_(B) ; J83-B-525F
(ucs-set-char #x543E ?$(Cgn(B) ; KS0-C-676E
(ucs-set-char #x543E ?$(GI@(B) ; C01-G-4940
(ucs-set-char #x543E ?$@8c(B) ; J78-@-3863
(ucs-set-char #x543E ?$ANa(B) ; GB0-A-4E61
(ucs-set-char #x543E ?$B8c(B) ; J83-B-3863
(ucs-set-char #x543F ?$(I%!(B) ; C03-I-2521
(ucs-set-char #x5440 ?$(GIT(B) ; C01-G-4954
(ucs-set-char #x5440 ?$@R`(B) ; J78-@-5260
(ucs-set-char #x5440 ?$AQ=(B) ; GB0-A-513D
(ucs-set-char #x5440 ?$BR`(B) ; J83-B-5260
(ucs-set-char #x5441 ?$(H#C(B) ; C02-H-2343
(ucs-set-char #x5442 ?$(CUe(B) ; KS0-C-5565
(ucs-set-char #x5442 ?$(GIH(B) ; C01-G-4948
(ucs-set-char #x5442 ?$@O$(B) ; J78-@-4F24
(ucs-set-char #x5442 ?$BO$(B) ; J83-B-4F24
(ucs-set-char #x5443 ?$(D4o(B) ; J90-D-346F
(ucs-set-char #x5443 ?$(GIE(B) ; C01-G-4945
(ucs-set-char #x5443 ?$A_@(B) ; GB0-A-5F40
(ucs-set-char #x5444 ?$(D4p(B) ; J90-D-3470
(ucs-set-char #x5444 ?$(I$s(B) ; C03-I-2473
(ucs-set-char #x5445 ?$(H#<(B) ; C02-H-233C
(ucs-set-char #x5446 ?$(GID(B) ; C01-G-4944
(ucs-set-char #x5446 ?$@Jr(B) ; J78-@-4A72
(ucs-set-char #x5446 ?$A4t(B) ; GB0-A-3474
(ucs-set-char #x5446 ?$BJr(B) ; J83-B-4A72
(ucs-set-char #x5447 ?$(D4q(B) ; J90-D-3471
(ucs-set-char #x5447 ?$(H#F(B) ; C02-H-2346
(ucs-set-char #x5448 ?$(CoP(B) ; KS0-C-6F50
(ucs-set-char #x5448 ?$(GIG(B) ; C01-G-4947
(ucs-set-char #x5448 ?$(J#[(B) ; C04-J-235B
(ucs-set-char #x5448 ?$@Dh(B) ; J78-@-4468
(ucs-set-char #x5448 ?$A3J(B) ; GB0-A-334A
(ucs-set-char #x5448 ?$BDh(B) ; J83-B-4468
(ucs-set-char #x5449 ?$(I$|(B) ; C03-I-247C
(ucs-set-char #x5449 ?$@8b(B) ; J78-@-3862
(ucs-set-char #x5449 ?$B8b(B) ; J83-B-3862
(ucs-set-char #x544A ?$(CM1(B) ; KS0-C-4D31
(ucs-set-char #x544A ?$(GIK(B) ; C01-G-494B
(ucs-set-char #x544A ?$@9p(B) ; J78-@-3970
(ucs-set-char #x544A ?$A8f(B) ; GB0-A-3866
(ucs-set-char #x544A ?$B9p(B) ; J83-B-3970
(ucs-set-char #x544B ?$(I$x(B) ; C03-I-2478
(ucs-set-char #x544B ?$A_;(B) ; GB0-A-5F3B
(ucs-set-char #x544C ?$(I$t(B) ; C03-I-2474
(ucs-set-char #x544D ?$(D4r(B) ; J90-D-3472
(ucs-set-char #x544D ?$(I$m(B) ; C03-I-246D
(ucs-set-char #x544E ?$(GIB(B) ; C01-G-4942
(ucs-set-char #x544E ?$@Rh(B) ; J78-@-5268
(ucs-set-char #x544E ?$BRh(B) ; J83-B-5268
(ucs-set-char #x544F ?$(D4s(B) ; J90-D-3473
(ucs-set-char #x544F ?$(H#B(B) ; C02-H-2342
(ucs-set-char #x5450 ?$(I$}(B) ; C03-I-247D
(ucs-set-char #x5450 ?$ADE(B) ; GB0-A-4445
(ucs-set-char #x5451 ?$(Cw"(B) ; KS0-C-7722
(ucs-set-char #x5451 ?$(I%"(B) ; C03-I-2522
(ucs-set-char #x5451 ?$@F](B) ; J78-@-465D
(ucs-set-char #x5451 ?$BF](B) ; J83-B-465D
(ucs-set-char #x5452 ?$A_<(B) ; GB0-A-5F3C
(ucs-set-char #x5453 ?$A_=(B) ; GB0-A-5F3D
(ucs-set-char #x5454 ?$(H#;(B) ; C02-H-233B
(ucs-set-char #x5454 ?$A_>(B) ; GB0-A-5F3E
(ucs-set-char #x5455 ?$AE;(B) ; GB0-A-453B
(ucs-set-char #x5456 ?$A_?(B) ; GB0-A-5F3F
(ucs-set-char #x5457 ?$A_B(B) ; GB0-A-5F42
(ucs-set-char #x5458 ?$AT1(B) ; GB0-A-5431
(ucs-set-char #x5459 ?$A_C(B) ; GB0-A-5F43
(ucs-set-char #x545A ?$(I%#(B) ; C03-I-2523
(ucs-set-char #x545B ?$AG:(B) ; GB0-A-473A
(ucs-set-char #x545C ?$ANX(B) ; GB0-A-4E58
(ucs-set-char #x545D ?$(J%d(B) ; C04-J-2564
(ucs-set-char #x545E ?$(D4t(B) ; J90-D-3474
(ucs-set-char #x545E ?$(J%c(B) ; C04-J-2563
(ucs-set-char #x545F ?$(I'n(B) ; C03-I-276E
(ucs-set-char #x545F ?$@Rl(B) ; J78-@-526C
(ucs-set-char #x545F ?$BRl(B) ; J83-B-526C
(ucs-set-char #x5460 ?$(H%k(B) ; C02-H-256B
(ucs-set-char #x5461 ?$(H%j(B) ; C02-H-256A
(ucs-set-char #x5462 ?$(D4u(B) ; J90-D-3475
(ucs-set-char #x5462 ?$(GLQ(B) ; C01-G-4C51
(ucs-set-char #x5462 ?$ADX(B) ; GB0-A-4458
(ucs-set-char #x5463 ?$(H%m(B) ; C02-H-256D
(ucs-set-char #x5464 ?$(D4v(B) ; J90-D-3476
(ucs-set-char #x5464 ?$(H%o(B) ; C02-H-256F
(ucs-set-char #x5464 ?$A_J(B) ; GB0-A-5F4A
(ucs-set-char #x5465 ?$(H%d(B) ; C02-H-2564
(ucs-set-char #x5466 ?$(D4w(B) ; J90-D-3477
(ucs-set-char #x5466 ?$(H%g(B) ; C02-H-2567
(ucs-set-char #x5466 ?$A_O(B) ; GB0-A-5F4F
(ucs-set-char #x5467 ?$(D4x(B) ; J90-D-3478
(ucs-set-char #x5467 ?$(H%n(B) ; C02-H-256E
(ucs-set-char #x5468 ?$(Cq2(B) ; KS0-C-7132
(ucs-set-char #x5468 ?$(GLR(B) ; C01-G-4C52
(ucs-set-char #x5468 ?$@<~(B) ; J78-@-3C7E
(ucs-set-char #x5468 ?$AV\(B) ; GB0-A-565C
(ucs-set-char #x5468 ?$B<~(B) ; J83-B-3C7E
(ucs-set-char #x5469 ?$(D4y(B) ; J90-D-3479
(ucs-set-char #x5469 ?$(I't(B) ; C03-I-2774
(ucs-set-char #x546A ?$(Cq1(B) ; KS0-C-7131
(ucs-set-char #x546A ?$(I'x(B) ; C03-I-2778
(ucs-set-char #x546A ?$@<v(B) ; J78-@-3C76
(ucs-set-char #x546A ?$B<v(B) ; J83-B-3C76
(ucs-set-char #x546B ?$(D4z(B) ; J90-D-347A
(ucs-set-char #x546B ?$(H%a(B) ; C02-H-2561
(ucs-set-char #x546C ?$(H%e(B) ; C02-H-2565
(ucs-set-char #x546D ?$(D4{(B) ; J90-D-347B
(ucs-set-char #x546D ?$(I'u(B) ; C03-I-2775
(ucs-set-char #x546E ?$(D4|(B) ; J90-D-347C
(ucs-set-char #x546E ?$(J%_(B) ; C04-J-255F
(ucs-set-char #x546F ?$(H%i(B) ; C02-H-2569
(ucs-set-char #x5470 ?$(H)J(B) ; C02-H-294A
(ucs-set-char #x5470 ?$@Ro(B) ; J78-@-526F
(ucs-set-char #x5470 ?$BRo(B) ; J83-B-526F
(ucs-set-char #x5471 ?$(CM2(B) ; KS0-C-4D32
(ucs-set-char #x5471 ?$(GLM(B) ; C01-G-4C4D
(ucs-set-char #x5471 ?$@Rm(B) ; J78-@-526D
(ucs-set-char #x5471 ?$A_I(B) ; GB0-A-5F49
(ucs-set-char #x5471 ?$BRm(B) ; J83-B-526D
(ucs-set-char #x5472 ?$(H)N(B) ; C02-H-294E
(ucs-set-char #x5472 ?$A_Z(B) ; GB0-A-5F5A
(ucs-set-char #x5473 ?$(CZ+(B) ; KS0-C-5A2B
(ucs-set-char #x5473 ?$(GL@(B) ; C01-G-4C40
(ucs-set-char #x5473 ?$@L#(B) ; J78-@-4C23
(ucs-set-char #x5473 ?$AN6(B) ; GB0-A-4E36
(ucs-set-char #x5473 ?$BL#(B) ; J83-B-4C23
(ucs-set-char #x5474 ?$(D4}(B) ; J90-D-347D
(ucs-set-char #x5474 ?$(H%f(B) ; C02-H-2566
(ucs-set-char #x5475 ?$(CJ'(B) ; KS0-C-4A27
(ucs-set-char #x5475 ?$(GLA(B) ; C01-G-4C41
(ucs-set-char #x5475 ?$@Rj(B) ; J78-@-526A
(ucs-set-char #x5475 ?$A:G(B) ; GB0-A-3A47
(ucs-set-char #x5475 ?$BRj(B) ; J83-B-526A
(ucs-set-char #x5476 ?$(GLN(B) ; C01-G-4C4E
(ucs-set-char #x5476 ?$@Rs(B) ; J78-@-5273
(ucs-set-char #x5476 ?$A_N(B) ; GB0-A-5F4E
(ucs-set-char #x5476 ?$BRs(B) ; J83-B-5273
(ucs-set-char #x5477 ?$(GLG(B) ; C01-G-4C47
(ucs-set-char #x5477 ?$@Rn(B) ; J78-@-526E
(ucs-set-char #x5477 ?$A_H(B) ; GB0-A-5F48
(ucs-set-char #x5477 ?$BRn(B) ; J83-B-526E
(ucs-set-char #x5478 ?$(GLC(B) ; C01-G-4C43
(ucs-set-char #x5478 ?$AE^(B) ; GB0-A-455E
(ucs-set-char #x5479 ?$(I'q(B) ; C03-I-2771
(ucs-set-char #x547A ?$(H%b(B) ; C02-H-2562
(ucs-set-char #x547B ?$(Ccb(B) ; KS0-C-6362
(ucs-set-char #x547B ?$(GLF(B) ; C01-G-4C46
(ucs-set-char #x547B ?$@Rq(B) ; J78-@-5271
(ucs-set-char #x547B ?$AIk(B) ; GB0-A-496B
(ucs-set-char #x547B ?$BRq(B) ; J83-B-5271
(ucs-set-char #x547C ?$(C{<(B) ; KS0-C-7B3C
(ucs-set-char #x547C ?$(GLK(B) ; C01-G-4C4B
(ucs-set-char #x547C ?$@8F(B) ; J78-@-3846
(ucs-set-char #x547C ?$A:t(B) ; GB0-A-3A74
(ucs-set-char #x547C ?$B8F(B) ; J83-B-3846
(ucs-set-char #x547D ?$(CY$(B) ; KS0-C-5924
(ucs-set-char #x547D ?$(GLT(B) ; C01-G-4C54
(ucs-set-char #x547D ?$@L?(B) ; J78-@-4C3F
(ucs-set-char #x547D ?$AC|(B) ; GB0-A-437C
(ucs-set-char #x547D ?$BL?(B) ; J83-B-4C3F
(ucs-set-char #x547E ?$(H%c(B) ; C02-H-2563
(ucs-set-char #x547F ?$(D4~(B) ; J90-D-347E
(ucs-set-char #x547F ?$(H%\(B) ; C02-H-255C
(ucs-set-char #x5480 ?$(Cn:(B) ; KS0-C-6E3A
(ucs-set-char #x5480 ?$(GLE(B) ; C01-G-4C45
(ucs-set-char #x5480 ?$@Rr(B) ; J78-@-5272
(ucs-set-char #x5480 ?$A>W(B) ; GB0-A-3E57
(ucs-set-char #x5480 ?$BRr(B) ; J83-B-5272
(ucs-set-char #x5481 ?$(D5!(B) ; J90-D-3521
(ucs-set-char #x5481 ?$(H%](B) ; C02-H-255D
(ucs-set-char #x5482 ?$(H%_(B) ; C02-H-255F
(ucs-set-char #x5482 ?$A_F(B) ; GB0-A-5F46
(ucs-set-char #x5483 ?$(D5"(B) ; J90-D-3522
(ucs-set-char #x5483 ?$(J%`(B) ; C04-J-2560
(ucs-set-char #x5484 ?$(GLH(B) ; C01-G-4C48
(ucs-set-char #x5484 ?$@Rt(B) ; J78-@-5274
(ucs-set-char #x5484 ?$A_M(B) ; GB0-A-5F4D
(ucs-set-char #x5484 ?$BRt(B) ; J83-B-5274
(ucs-set-char #x5485 ?$(D5#(B) ; J90-D-3523
(ucs-set-char #x5485 ?$(I'l(B) ; C03-I-276C
(ucs-set-char #x5486 ?$(CxS(B) ; KS0-C-7853
(ucs-set-char #x5486 ?$(GLJ(B) ; C01-G-4C4A
(ucs-set-char #x5486 ?$@Rv(B) ; J78-@-5276
(ucs-set-char #x5486 ?$AEX(B) ; GB0-A-4558
(ucs-set-char #x5486 ?$BRv(B) ; J83-B-5276
(ucs-set-char #x5487 ?$(H%[(B) ; C02-H-255B
(ucs-set-char #x5488 ?$(D5$(B) ; J90-D-3524
(ucs-set-char #x5488 ?$(H%`(B) ; C02-H-2560
(ucs-set-char #x5489 ?$(D5%(B) ; J90-D-3525
(ucs-set-char #x5489 ?$(I'p(B) ; C03-I-2770
(ucs-set-char #x548A ?$(I'y(B) ; C03-I-2779
(ucs-set-char #x548B ?$(GLS(B) ; C01-G-4C53
(ucs-set-char #x548B ?$@:p(B) ; J78-@-3A70
(ucs-set-char #x548B ?$AU&(B) ; GB0-A-5526
(ucs-set-char #x548B ?$B:p(B) ; J83-B-3A70
(ucs-set-char #x548C ?$(C{z(B) ; KS0-C-7B7A
(ucs-set-char #x548C ?$(GLO(B) ; C01-G-4C4F
(ucs-set-char #x548C ?$@OB(B) ; J78-@-4F42
(ucs-set-char #x548C ?$A:M(B) ; GB0-A-3A4D
(ucs-set-char #x548C ?$BOB(B) ; J83-B-4F42
(ucs-set-char #x548D ?$(D5&(B) ; J90-D-3526
(ucs-set-char #x548D ?$(H%h(B) ; C02-H-2568
(ucs-set-char #x548E ?$(CO$(B) ; KS0-C-4F24
(ucs-set-char #x548E ?$(GLU(B) ; C01-G-4C55
(ucs-set-char #x548E ?$@Rk(B) ; J78-@-526B
(ucs-set-char #x548E ?$A>L(B) ; GB0-A-3E4C
(ucs-set-char #x548E ?$BRk(B) ; J83-B-526B
(ucs-set-char #x548F ?$(I's(B) ; C03-I-2773
(ucs-set-char #x548F ?$@Ri(B) ; J78-@-5269
(ucs-set-char #x548F ?$AS=(B) ; GB0-A-533D
(ucs-set-char #x548F ?$BRi(B) ; J83-B-5269
(ucs-set-char #x5490 ?$(C\{(B) ; KS0-C-5C7B
(ucs-set-char #x5490 ?$(GLL(B) ; C01-G-4C4C
(ucs-set-char #x5490 ?$@Ru(B) ; J78-@-5275
(ucs-set-char #x5490 ?$A8@(B) ; GB0-A-3840
(ucs-set-char #x5490 ?$BRu(B) ; J83-B-5275
(ucs-set-char #x5491 ?$(D5'(B) ; J90-D-3527
(ucs-set-char #x5491 ?$(H%^(B) ; C02-H-255E
(ucs-set-char #x5492 ?$(GLI(B) ; C01-G-4C49
(ucs-set-char #x5492 ?$@Rp(B) ; J78-@-5270
(ucs-set-char #x5492 ?$AVd(B) ; GB0-A-5664
(ucs-set-char #x5492 ?$BRp(B) ; J83-B-5270
(ucs-set-char #x5493 ?$(I'o(B) ; C03-I-276F
(ucs-set-char #x5494 ?$(I'w(B) ; C03-I-2777
(ucs-set-char #x5494 ?$A_G(B) ; GB0-A-5F47
(ucs-set-char #x5495 ?$(D5((B) ; J90-D-3528
(ucs-set-char #x5495 ?$(GLD(B) ; C01-G-4C44
(ucs-set-char #x5495 ?$A9>(B) ; GB0-A-393E
(ucs-set-char #x5496 ?$(D5)(B) ; J90-D-3529
(ucs-set-char #x5496 ?$(GLB(B) ; C01-G-4C42
(ucs-set-char #x5496 ?$A?'(B) ; GB0-A-3F27
(ucs-set-char #x5498 ?$(H%l(B) ; C02-H-256C
(ucs-set-char #x5499 ?$AA|(B) ; GB0-A-417C
(ucs-set-char #x549A ?$(GLP(B) ; C01-G-4C50
(ucs-set-char #x549A ?$A_K(B) ; GB0-A-5F4B
(ucs-set-char #x549B ?$A_L(B) ; GB0-A-5F4C
(ucs-set-char #x549C ?$(D5*(B) ; J90-D-352A
(ucs-set-char #x549D ?$A_P(B) ; GB0-A-5F50
(ucs-set-char #x549E ?$(I+\(B) ; C03-I-2B5C
(ucs-set-char #x549F ?$(D5+(B) ; J90-D-352B
(ucs-set-char #x549F ?$(I+](B) ; C03-I-2B5D
(ucs-set-char #x54A0 ?$(H)I(B) ; C02-H-2949
(ucs-set-char #x54A1 ?$(D5,(B) ; J90-D-352C
(ucs-set-char #x54A1 ?$(H)=(B) ; C02-H-293D
(ucs-set-char #x54A2 ?$(H)L(B) ; C02-H-294C
(ucs-set-char #x54A2 ?$@Rx(B) ; J78-@-5278
(ucs-set-char #x54A2 ?$BRx(B) ; J83-B-5278
(ucs-set-char #x54A3 ?$(I+W(B) ; C03-I-2B57
(ucs-set-char #x54A3 ?$A_[(B) ; GB0-A-5F5B
(ucs-set-char #x54A4 ?$(Cvc(B) ; KS0-C-7663
(ucs-set-char #x54A4 ?$(I+Y(B) ; C03-I-2B59
(ucs-set-char #x54A4 ?$@S#(B) ; J78-@-5323
(ucs-set-char #x54A4 ?$A_e(B) ; GB0-A-5F65
(ucs-set-char #x54A4 ?$BS#(B) ; J83-B-5323
(ucs-set-char #x54A5 ?$(H)?(B) ; C02-H-293F
(ucs-set-char #x54A5 ?$@Rz(B) ; J78-@-527A
(ucs-set-char #x54A5 ?$BRz(B) ; J83-B-527A
(ucs-set-char #x54A6 ?$(D5-(B) ; J90-D-352D
(ucs-set-char #x54A6 ?$(GP<(B) ; C01-G-503C
(ucs-set-char #x54A6 ?$A_W(B) ; GB0-A-5F57
(ucs-set-char #x54A7 ?$(D5.(B) ; J90-D-352E
(ucs-set-char #x54A7 ?$(GPJ(B) ; C01-G-504A
(ucs-set-char #x54A7 ?$A_V(B) ; GB0-A-5F56
(ucs-set-char #x54A8 ?$(Cm*(B) ; KS0-C-6D2A
(ucs-set-char #x54A8 ?$(GP8(B) ; C01-G-5038
(ucs-set-char #x54A8 ?$@R~(B) ; J78-@-527E
(ucs-set-char #x54A8 ?$AWI(B) ; GB0-A-5749
(ucs-set-char #x54A8 ?$BR~(B) ; J83-B-527E
(ucs-set-char #x54A9 ?$(D5/(B) ; J90-D-352F
(ucs-set-char #x54A9 ?$(GPI(B) ; C01-G-5049
(ucs-set-char #x54A9 ?$A_c(B) ; GB0-A-5F63
(ucs-set-char #x54AA ?$(D50(B) ; J90-D-3530
(ucs-set-char #x54AA ?$(GPA(B) ; C01-G-5041
(ucs-set-char #x54AA ?$A_d(B) ; GB0-A-5F64
(ucs-set-char #x54AB ?$(Cr!(B) ; KS0-C-7221
(ucs-set-char #x54AB ?$(GPF(B) ; C01-G-5046
(ucs-set-char #x54AB ?$@S!(B) ; J78-@-5321
(ucs-set-char #x54AB ?$Aek(B) ; GB0-A-656B
(ucs-set-char #x54AB ?$BS!(B) ; J83-B-5321
(ucs-set-char #x54AC ?$(CNa(B) ; KS0-C-4E61
(ucs-set-char #x54AC ?$(GP6(B) ; C01-G-5036
(ucs-set-char #x54AC ?$@R{(B) ; J78-@-527B
(ucs-set-char #x54AC ?$AR'(B) ; GB0-A-5227
(ucs-set-char #x54AC ?$BR{(B) ; J83-B-527B
(ucs-set-char #x54AD ?$(D51(B) ; J90-D-3531
(ucs-set-char #x54AD ?$(H)>(B) ; C02-H-293E
(ucs-set-char #x54AD ?$A_R(B) ; GB0-A-5F52
(ucs-set-char #x54AE ?$(D52(B) ; J90-D-3532
(ucs-set-char #x54AE ?$(H)D(B) ; C02-H-2944
(ucs-set-char #x54AF ?$(GPE(B) ; C01-G-5045
(ucs-set-char #x54AF ?$@S>(B) ; J78-@-533E
(ucs-set-char #x54AF ?$A?)(B) ; GB0-A-3F29
(ucs-set-char #x54AF ?$BS>(B) ; J83-B-533E
(ucs-set-char #x54B0 ?$(H)P(B) ; C02-H-2950
(ucs-set-char #x54B1 ?$(D53(B) ; J90-D-3533
(ucs-set-char #x54B1 ?$(GPG(B) ; C01-G-5047
(ucs-set-char #x54B1 ?$AT[(B) ; GB0-A-545B
(ucs-set-char #x54B2 ?$(I+[(B) ; C03-I-2B5B
(ucs-set-char #x54B2 ?$@:i(B) ; J78-@-3A69
(ucs-set-char #x54B2 ?$B:i(B) ; J83-B-3A69
(ucs-set-char #x54B3 ?$(Cz&(B) ; KS0-C-7A26
(ucs-set-char #x54B3 ?$(GP=(B) ; C01-G-503D
(ucs-set-char #x54B3 ?$@31(B) ; J78-@-3331
(ucs-set-char #x54B3 ?$A?H(B) ; GB0-A-3F48
(ucs-set-char #x54B3 ?$B31(B) ; J83-B-3331
(ucs-set-char #x54B4 ?$(I+T(B) ; C03-I-2B54
(ucs-set-char #x54B4 ?$A_T(B) ; GB0-A-5F54
(ucs-set-char #x54B5 ?$(I+^(B) ; C03-I-2B5E
(ucs-set-char #x54B6 ?$(H)F(B) ; C02-H-2946
(ucs-set-char #x54B7 ?$(D54(B) ; J90-D-3534
(ucs-set-char #x54B7 ?$(H)C(B) ; C02-H-2943
(ucs-set-char #x54B8 ?$(Cy`(B) ; KS0-C-7960
(ucs-set-char #x54B8 ?$(GP;(B) ; C01-G-503B
(ucs-set-char #x54B8 ?$@Ry(B) ; J78-@-5279
(ucs-set-char #x54B8 ?$AOL(B) ; GB0-A-4F4C
(ucs-set-char #x54B8 ?$BRy(B) ; J83-B-5279
(ucs-set-char #x54B9 ?$(D55(B) ; J90-D-3535
(ucs-set-char #x54B9 ?$(I+Q(B) ; C03-I-2B51
(ucs-set-char #x54BA ?$(D56(B) ; J90-D-3536
(ucs-set-char #x54BA ?$(H)<(B) ; C02-H-293C
(ucs-set-char #x54BB ?$(D57(B) ; J90-D-3537
(ucs-set-char #x54BB ?$(GPH(B) ; C01-G-5048
(ucs-set-char #x54BB ?$A_](B) ; GB0-A-5F5D
(ucs-set-char #x54BC ?$(H)K(B) ; C02-H-294B
(ucs-set-char #x54BC ?$@S%(B) ; J78-@-5325
(ucs-set-char #x54BC ?$BS%(B) ; J83-B-5325
(ucs-set-char #x54BD ?$(ClV(B) ; KS0-C-6C56
(ucs-set-char #x54BD ?$(GP@(B) ; C01-G-5040
(ucs-set-char #x54BD ?$@0v(B) ; J78-@-3076
(ucs-set-char #x54BD ?$AQJ(B) ; GB0-A-514A
(ucs-set-char #x54BD ?$B0v(B) ; J83-B-3076
(ucs-set-char #x54BE ?$(H)M(B) ; C02-H-294D
(ucs-set-char #x54BE ?$@S$(B) ; J78-@-5324
(ucs-set-char #x54BE ?$BS$(B) ; J83-B-5324
(ucs-set-char #x54BF ?$(D58(B) ; J90-D-3538
(ucs-set-char #x54BF ?$(GPK(B) ; C01-G-504B
(ucs-set-char #x54BF ?$A_^(B) ; GB0-A-5F5E
(ucs-set-char #x54C0 ?$(Cdn(B) ; KS0-C-646E
(ucs-set-char #x54C0 ?$(GP7(B) ; C01-G-5037
(ucs-set-char #x54C0 ?$@0%(B) ; J78-@-3025
(ucs-set-char #x54C0 ?$A0'(B) ; GB0-A-3027
(ucs-set-char #x54C0 ?$B0%(B) ; J83-B-3025
(ucs-set-char #x54C1 ?$(Cy!(B) ; KS0-C-7921
(ucs-set-char #x54C1 ?$(GPB(B) ; C01-G-5042
(ucs-set-char #x54C1 ?$@IJ(B) ; J78-@-494A
(ucs-set-char #x54C1 ?$AF7(B) ; GB0-A-4637
(ucs-set-char #x54C1 ?$BIJ(B) ; J83-B-494A
(ucs-set-char #x54C2 ?$(GP?(B) ; C01-G-503F
(ucs-set-char #x54C2 ?$@S"(B) ; J78-@-5322
(ucs-set-char #x54C2 ?$A_S(B) ; GB0-A-5F53
(ucs-set-char #x54C2 ?$BS"(B) ; J83-B-5322
(ucs-set-char #x54C3 ?$(H)A(B) ; C02-H-2941
(ucs-set-char #x54C4 ?$(C{o(B) ; KS0-C-7B6F
(ucs-set-char #x54C4 ?$(GPC(B) ; C01-G-5043
(ucs-set-char #x54C4 ?$@R|(B) ; J78-@-527C
(ucs-set-char #x54C4 ?$A:e(B) ; GB0-A-3A65
(ucs-set-char #x54C4 ?$BR|(B) ; J83-B-527C
(ucs-set-char #x54C5 ?$(H)G(B) ; C02-H-2947
(ucs-set-char #x54C6 ?$(D59(B) ; J90-D-3539
(ucs-set-char #x54C6 ?$(H)H(B) ; C02-H-2948
(ucs-set-char #x54C6 ?$A6_(B) ; GB0-A-365F
(ucs-set-char #x54C7 ?$(GP>(B) ; C01-G-503E
(ucs-set-char #x54C7 ?$@Rw(B) ; J78-@-5277
(ucs-set-char #x54C7 ?$AM[(B) ; GB0-A-4D5B
(ucs-set-char #x54C7 ?$BRw(B) ; J83-B-5277
(ucs-set-char #x54C8 ?$(Cyk(B) ; KS0-C-796B
(ucs-set-char #x54C8 ?$(GPD(B) ; C01-G-5044
(ucs-set-char #x54C8 ?$@R}(B) ; J78-@-527D
(ucs-set-char #x54C8 ?$A9~(B) ; GB0-A-397E
(ucs-set-char #x54C8 ?$BR}(B) ; J83-B-527D
(ucs-set-char #x54C9 ?$(Cn#(B) ; KS0-C-6E23
(ucs-set-char #x54C9 ?$(GP:(B) ; C01-G-503A
(ucs-set-char #x54C9 ?$@:H(B) ; J78-@-3A48
(ucs-set-char #x54C9 ?$ATU(B) ; GB0-A-5455
(ucs-set-char #x54C9 ?$B:H(B) ; J83-B-3A48
(ucs-set-char #x54CA ?$(D5:(B) ; J90-D-353A
(ucs-set-char #x54CA ?$(I+U(B) ; C03-I-2B55
(ucs-set-char #x54CC ?$(I+c(B) ; C03-I-2B63
(ucs-set-char #x54CC ?$A__(B) ; GB0-A-5F5F
(ucs-set-char #x54CD ?$(D5;(B) ; J90-D-353B
(ucs-set-char #x54CD ?$(I+a(B) ; C03-I-2B61
(ucs-set-char #x54CD ?$AOl(B) ; GB0-A-4F6C
(ucs-set-char #x54CE ?$(D5<(B) ; J90-D-353C
(ucs-set-char #x54CE ?$(GP9(B) ; C01-G-5039
(ucs-set-char #x54CE ?$A0%(B) ; GB0-A-3025
(ucs-set-char #x54CF ?$(H)@(B) ; C02-H-2940
(ucs-set-char #x54CF ?$A_g(B) ; GB0-A-5F67
(ucs-set-char #x54D0 ?$(I+S(B) ; C03-I-2B53
(ucs-set-char #x54D0 ?$A_Q(B) ; GB0-A-5F51
(ucs-set-char #x54D1 ?$AQF(B) ; GB0-A-5146
(ucs-set-char #x54D2 ?$A_U(B) ; GB0-A-5F55
(ucs-set-char #x54D3 ?$A_X(B) ; GB0-A-5F58
(ucs-set-char #x54D4 ?$A_Y(B) ; GB0-A-5F59
(ucs-set-char #x54D5 ?$A_\(B) ; GB0-A-5F5C
(ucs-set-char #x54D6 ?$(H)E(B) ; C02-H-2945
(ucs-set-char #x54D7 ?$A;)(B) ; GB0-A-3B29
(ucs-set-char #x54D8 ?$@S&(B) ; J78-@-5326
(ucs-set-char #x54D8 ?$BS&(B) ; J83-B-5326
(ucs-set-char #x54D9 ?$A_`(B) ; GB0-A-5F60
(ucs-set-char #x54DA ?$(I+X(B) ; C03-I-2B58
(ucs-set-char #x54DA ?$A_a(B) ; GB0-A-5F61
(ucs-set-char #x54DC ?$A_b(B) ; GB0-A-5F62
(ucs-set-char #x54DD ?$A_f(B) ; GB0-A-5F66
(ucs-set-char #x54DE ?$(H)O(B) ; C02-H-294F
(ucs-set-char #x54DE ?$A_h(B) ; GB0-A-5F68
(ucs-set-char #x54DF ?$AS4(B) ; GB0-A-5334
(ucs-set-char #x54E0 ?$(D5=(B) ; J90-D-353D
(ucs-set-char #x54E0 ?$(H.F(B) ; C02-H-2E46
(ucs-set-char #x54E1 ?$(Cj,(B) ; KS0-C-6A2C
(ucs-set-char #x54E1 ?$(GT^(B) ; C01-G-545E
(ucs-set-char #x54E1 ?$@0w(B) ; J78-@-3077
(ucs-set-char #x54E1 ?$B0w(B) ; J83-B-3077
(ucs-set-char #x54E2 ?$(H.4(B) ; C02-H-2E34
(ucs-set-char #x54E2 ?$@S/(B) ; J78-@-532F
(ucs-set-char #x54E2 ?$BS/(B) ; J83-B-532F
(ucs-set-char #x54E3 ?$(J,-(B) ; C04-J-2C2D
(ucs-set-char #x54E4 ?$(H.9(B) ; C02-H-2E39
(ucs-set-char #x54E5 ?$(CJ((B) ; KS0-C-4A28
(ucs-set-char #x54E5 ?$(GTW(B) ; C01-G-5457
(ucs-set-char #x54E5 ?$@S'(B) ; J78-@-5327
(ucs-set-char #x54E5 ?$A8g(B) ; GB0-A-3867
(ucs-set-char #x54E5 ?$BS'(B) ; J83-B-5327
(ucs-set-char #x54E6 ?$(GTb(B) ; C01-G-5462
(ucs-set-char #x54E6 ?$@S((B) ; J78-@-5328
(ucs-set-char #x54E6 ?$AE6(B) ; GB0-A-4536
(ucs-set-char #x54E6 ?$BS((B) ; J83-B-5328
(ucs-set-char #x54E7 ?$(H.7(B) ; C02-H-2E37
(ucs-set-char #x54E7 ?$A_j(B) ; GB0-A-5F6A
(ucs-set-char #x54E8 ?$(Ctz(B) ; KS0-C-747A
(ucs-set-char #x54E8 ?$(GTR(B) ; C01-G-5452
(ucs-set-char #x54E8 ?$@>%(B) ; J78-@-3E25
(ucs-set-char #x54E8 ?$AIZ(B) ; GB0-A-495A
(ucs-set-char #x54E8 ?$B>%(B) ; J83-B-3E25
(ucs-set-char #x54E9 ?$(GT\(B) ; C01-G-545C
(ucs-set-char #x54E9 ?$@Ki(B) ; J78-@-4B69
(ucs-set-char #x54E9 ?$AA((B) ; GB0-A-4128
(ucs-set-char #x54E9 ?$BKi(B) ; J83-B-4B69
(ucs-set-char #x54EA ?$(D5>(B) ; J90-D-353E
(ucs-set-char #x54EA ?$(GTa(B) ; C01-G-5461
(ucs-set-char #x54EA ?$ADD(B) ; GB0-A-4444
(ucs-set-char #x54EB ?$(H.>(B) ; C02-H-2E3E
(ucs-set-char #x54EC ?$(D5?(B) ; J90-D-353F
(ucs-set-char #x54EC ?$(J,&(B) ; C04-J-2C26
(ucs-set-char #x54ED ?$(CMV(B) ; KS0-C-4D56
(ucs-set-char #x54ED ?$(GT](B) ; C01-G-545D
(ucs-set-char #x54ED ?$@S-(B) ; J78-@-532D
(ucs-set-char #x54ED ?$A?^(B) ; GB0-A-3F5E
(ucs-set-char #x54ED ?$BS-(B) ; J83-B-532D
(ucs-set-char #x54EE ?$(C|v(B) ; KS0-C-7C76
(ucs-set-char #x54EE ?$(GT`(B) ; C01-G-5460
(ucs-set-char #x54EE ?$@S,(B) ; J78-@-532C
(ucs-set-char #x54EE ?$AOx(B) ; GB0-A-4F78
(ucs-set-char #x54EE ?$BS,(B) ; J83-B-532C
(ucs-set-char #x54EF ?$(D5@(B) ; J90-D-3540
(ucs-set-char #x54EF ?$(I/w(B) ; C03-I-2F77
(ucs-set-char #x54F0 ?$(I0!(B) ; C03-I-3021
(ucs-set-char #x54F1 ?$(H.A(B) ; C02-H-2E41
(ucs-set-char #x54F2 ?$(CtI(B) ; KS0-C-7449
(ucs-set-char #x54F2 ?$(GTX(B) ; C01-G-5458
(ucs-set-char #x54F2 ?$@E/(B) ; J78-@-452F
(ucs-set-char #x54F2 ?$AU\(B) ; GB0-A-555C
(ucs-set-char #x54F2 ?$BE/(B) ; J83-B-452F
(ucs-set-char #x54F3 ?$(H.8(B) ; C02-H-2E38
(ucs-set-char #x54F3 ?$A_n(B) ; GB0-A-5F6E
(ucs-set-char #x54F4 ?$(I/t(B) ; C03-I-2F74
(ucs-set-char #x54F5 ?$(I/x(B) ; C03-I-2F78
(ucs-set-char #x54F6 ?$(D5A(B) ; J90-D-3541
(ucs-set-char #x54F6 ?$(I0"(B) ; C03-I-3022
(ucs-set-char #x54F6 ?$(I0#(B) ; C03-I-3023
(ucs-set-char #x54F7 ?$(H.D(B) ; C02-H-2E44
(ucs-set-char #x54F8 ?$(H.E(B) ; C02-H-2E45
(ucs-set-char #x54F9 ?$(I/y(B) ; C03-I-2F79
(ucs-set-char #x54FA ?$(CxT(B) ; KS0-C-7854
(ucs-set-char #x54FA ?$(GTZ(B) ; C01-G-545A
(ucs-set-char #x54FA ?$@S.(B) ; J78-@-532E
(ucs-set-char #x54FA ?$A28(B) ; GB0-A-3238
(ucs-set-char #x54FA ?$BS.(B) ; J83-B-532E
(ucs-set-char #x54FB ?$(H.C(B) ; C02-H-2E43
(ucs-set-char #x54FC ?$(D5B(B) ; J90-D-3542
(ucs-set-char #x54FC ?$(GTV(B) ; C01-G-5456
(ucs-set-char #x54FC ?$A:_(B) ; GB0-A-3A5F
(ucs-set-char #x54FD ?$(GTe(B) ; C01-G-5465
(ucs-set-char #x54FD ?$@S+(B) ; J78-@-532B
(ucs-set-char #x54FD ?$A_l(B) ; GB0-A-5F6C
(ucs-set-char #x54FD ?$BS+(B) ; J83-B-532B
(ucs-set-char #x54FE ?$(D5C(B) ; J90-D-3543
(ucs-set-char #x54FE ?$(J,)(B) ; C04-J-2C29
(ucs-set-char #x54FF ?$(D5D(B) ; J90-D-3544
(ucs-set-char #x54FF ?$(H.;(B) ; C02-H-2E3B
(ucs-set-char #x54FF ?$A[A(B) ; GB0-A-5B41
(ucs-set-char #x5500 ?$(D5E(B) ; J90-D-3545
(ucs-set-char #x5500 ?$(I/{(B) ; C03-I-2F7B
(ucs-set-char #x5501 ?$(D5F(B) ; J90-D-3546
(ucs-set-char #x5501 ?$(GTT(B) ; C01-G-5454
(ucs-set-char #x5501 ?$AQd(B) ; GB0-A-5164
(ucs-set-char #x5502 ?$(I/z(B) ; C03-I-2F7A
(ucs-set-char #x5503 ?$(H.H(B) ; C02-H-2E48
(ucs-set-char #x5504 ?$(Cx&(B) ; KS0-C-7826
(ucs-set-char #x5504 ?$(H.<(B) ; C02-H-2E3C
(ucs-set-char #x5504 ?$@14(B) ; J78-@-3134
(ucs-set-char #x5504 ?$B14(B) ; J83-B-3134
(ucs-set-char #x5505 ?$(D5G(B) ; J90-D-3547
(ucs-set-char #x5505 ?$(H.@(B) ; C02-H-2E40
(ucs-set-char #x5506 ?$(C^J(B) ; KS0-C-5E4A
(ucs-set-char #x5506 ?$(GTY(B) ; C01-G-5459
(ucs-set-char #x5506 ?$@:6(B) ; J78-@-3A36
(ucs-set-char #x5506 ?$AKt(B) ; GB0-A-4B74
(ucs-set-char #x5506 ?$B:6(B) ; J83-B-3A36
(ucs-set-char #x5507 ?$(CrF(B) ; KS0-C-7246
(ucs-set-char #x5507 ?$(GTd(B) ; C01-G-5464
(ucs-set-char #x5507 ?$@?0(B) ; J78-@-3F30
(ucs-set-char #x5507 ?$A4=(B) ; GB0-A-343D
(ucs-set-char #x5507 ?$B?0(B) ; J83-B-3F30
(ucs-set-char #x5508 ?$(D5H(B) ; J90-D-3548
(ucs-set-char #x5508 ?$(H.=(B) ; C02-H-2E3D
(ucs-set-char #x5509 ?$(D5I(B) ; J90-D-3549
(ucs-set-char #x5509 ?$(GT_(B) ; C01-G-545F
(ucs-set-char #x5509 ?$A0&(B) ; GB0-A-3026
(ucs-set-char #x550A ?$(H.B(B) ; C02-H-2E42
(ucs-set-char #x550B ?$(H.I(B) ; C02-H-2E49
(ucs-set-char #x550C ?$(D5J(B) ; J90-D-354A
(ucs-set-char #x550C ?$(H4$(B) ; C02-H-3424
(ucs-set-char #x550D ?$(D5K(B) ; J90-D-354B
(ucs-set-char #x550D ?$(I/s(B) ; C03-I-2F73
(ucs-set-char #x550E ?$(CWZ(B) ; KS0-C-575A
(ucs-set-char #x550E ?$(D5L(B) ; J90-D-354C
(ucs-set-char #x550E ?$(H.G(B) ; C02-H-2E47
(ucs-set-char #x550F ?$(GTf(B) ; C01-G-5466
(ucs-set-char #x550F ?$@S)(B) ; J78-@-5329
(ucs-set-char #x550F ?$A_q(B) ; GB0-A-5F71
(ucs-set-char #x550F ?$BS)(B) ; J83-B-5329
(ucs-set-char #x5510 ?$(CSP(B) ; KS0-C-5350
(ucs-set-char #x5510 ?$(GTS(B) ; C01-G-5453
(ucs-set-char #x5510 ?$(L5~(B) ; C06-L-357E
(ucs-set-char #x5510 ?$@Eb(B) ; J78-@-4562
(ucs-set-char #x5510 ?$ALF(B) ; GB0-A-4C46
(ucs-set-char #x5510 ?$BEb(B) ; J83-B-4562
(ucs-set-char #x5511 ?$(H.?(B) ; C02-H-2E3F
(ucs-set-char #x5511 ?$A_r(B) ; GB0-A-5F72
(ucs-set-char #x5512 ?$(H.6(B) ; C02-H-2E36
(ucs-set-char #x5513 ?$(I/v(B) ; C03-I-2F76
(ucs-set-char #x5514 ?$(GT[(B) ; C01-G-545B
(ucs-set-char #x5514 ?$@S*(B) ; J78-@-532A
(ucs-set-char #x5514 ?$A_m(B) ; GB0-A-5F6D
(ucs-set-char #x5514 ?$BS*(B) ; J83-B-532A
(ucs-set-char #x5515 ?$(D5M(B) ; J90-D-354D
(ucs-set-char #x5515 ?$(J,((B) ; C04-J-2C28
(ucs-set-char #x5516 ?$(J,.(B) ; C04-J-2C2E
(ucs-set-char #x5516 ?$B0"(B) ; J83-B-3022
(ucs-set-char #x5517 ?$(H.5(B) ; C02-H-2E35
(ucs-set-char #x5518 ?$(I/~(B) ; C03-I-2F7E
(ucs-set-char #x5519 ?$(I0%(B) ; C03-I-3025
(ucs-set-char #x551A ?$(H.:(B) ; C02-H-2E3A
(ucs-set-char #x551B ?$A_i(B) ; GB0-A-5F69
(ucs-set-char #x551C ?$(CXE(B) ; KS0-C-5845
(ucs-set-char #x5520 ?$A_k(B) ; GB0-A-5F6B
(ucs-set-char #x5522 ?$A_o(B) ; GB0-A-5F6F
(ucs-set-char #x5523 ?$A_p(B) ; GB0-A-5F70
(ucs-set-char #x5524 ?$A;=(B) ; GB0-A-3B3D
(ucs-set-char #x5526 ?$(H.3(B) ; C02-H-2E33
(ucs-set-char #x5527 ?$(GTc(B) ; C01-G-5463
(ucs-set-char #x5527 ?$A_s(B) ; GB0-A-5F73
(ucs-set-char #x5529 ?$(I4_(B) ; C03-I-345F
(ucs-set-char #x552A ?$(D5N(B) ; J90-D-354E
(ucs-set-char #x552A ?$(H3z(B) ; C02-H-337A
(ucs-set-char #x552A ?$A_t(B) ; GB0-A-5F74
(ucs-set-char #x552B ?$(D5O(B) ; J90-D-354F
(ucs-set-char #x552B ?$(I4h(B) ; C03-I-3468
(ucs-set-char #x552C ?$(GYI(B) ; C01-G-5949
(ucs-set-char #x552C ?$A;#(B) ; GB0-A-3B23
(ucs-set-char #x552D ?$(H4*(B) ; C02-H-342A
(ucs-set-char #x552E ?$(GYG(B) ; C01-G-5947
(ucs-set-char #x552E ?$@S4(B) ; J78-@-5334
(ucs-set-char #x552E ?$AJ[(B) ; GB0-A-4A5B
(ucs-set-char #x552E ?$BS4(B) ; J83-B-5334
(ucs-set-char #x552F ?$(Cjf(B) ; KS0-C-6A66
(ucs-set-char #x552F ?$(GYD(B) ; C01-G-5944
(ucs-set-char #x552F ?$@M#(B) ; J78-@-4D23
(ucs-set-char #x552F ?$AN((B) ; GB0-A-4E28
(ucs-set-char #x552F ?$BM#(B) ; J83-B-4D23
(ucs-set-char #x5530 ?$(H4!(B) ; C02-H-3421
(ucs-set-char #x5530 ?$A`'(B) ; GB0-A-6027
(ucs-set-char #x5531 ?$(Cs](B) ; KS0-C-735D
(ucs-set-char #x5531 ?$(GY@(B) ; C01-G-5940
(ucs-set-char #x5531 ?$@>'(B) ; J78-@-3E27
(ucs-set-char #x5531 ?$A3*(B) ; GB0-A-332A
(ucs-set-char #x5531 ?$B>'(B) ; J83-B-3E27
(ucs-set-char #x5532 ?$(D5P(B) ; J90-D-3550
(ucs-set-char #x5532 ?$(H4%(B) ; C02-H-3425
(ucs-set-char #x5533 ?$(GYK(B) ; C01-G-594B
(ucs-set-char #x5533 ?$@S:(B) ; J78-@-533A
(ucs-set-char #x5533 ?$A`&(B) ; GB0-A-6026
(ucs-set-char #x5533 ?$BS:(B) ; J83-B-533A
(ucs-set-char #x5534 ?$(H3y(B) ; C02-H-3379
(ucs-set-char #x5535 ?$(CdZ(B) ; KS0-C-645A
(ucs-set-char #x5535 ?$(D5Q(B) ; J90-D-3551
(ucs-set-char #x5535 ?$(H3~(B) ; C02-H-337E
(ucs-set-char #x5536 ?$(D5R(B) ; J90-D-3552
(ucs-set-char #x5536 ?$(H3}(B) ; C02-H-337D
(ucs-set-char #x5537 ?$(GTU(B) ; C01-G-5455
(ucs-set-char #x5537 ?$A`!(B) ; GB0-A-6021
(ucs-set-char #x5538 ?$(GYF(B) ; C01-G-5946
(ucs-set-char #x5538 ?$@S9(B) ; J78-@-5339
(ucs-set-char #x5538 ?$BS9(B) ; J83-B-5339
(ucs-set-char #x5539 ?$(H4((B) ; C02-H-3428
(ucs-set-char #x5539 ?$@S0(B) ; J78-@-5330
(ucs-set-char #x5539 ?$BS0(B) ; J83-B-5330
(ucs-set-char #x553A ?$(I4f(B) ; C03-I-3466
(ucs-set-char #x553B ?$(D5S(B) ; J90-D-3553
(ucs-set-char #x553B ?$(H4+(B) ; C02-H-342B
(ucs-set-char #x553C ?$(D5T(B) ; J90-D-3554
(ucs-set-char #x553C ?$(H3v(B) ; C02-H-3376
(ucs-set-char #x553C ?$A_~(B) ; GB0-A-5F7E
(ucs-set-char #x553D ?$(D5U(B) ; J90-D-3555
(ucs-set-char #x553D ?$(J0w(B) ; C04-J-3077
(ucs-set-char #x553E ?$(Cvd(B) ; KS0-C-7664
(ucs-set-char #x553E ?$(G^N(B) ; C01-G-5E4E
(ucs-set-char #x553E ?$@BC(B) ; J78-@-4243
(ucs-set-char #x553E ?$AMY(B) ; GB0-A-4D59
(ucs-set-char #x553E ?$BBC(B) ; J83-B-4243
(ucs-set-char #x553F ?$(I4g(B) ; C03-I-3467
(ucs-set-char #x553F ?$A_|(B) ; GB0-A-5F7C
(ucs-set-char #x5540 ?$(H4,(B) ; C02-H-342C
(ucs-set-char #x5540 ?$@S1(B) ; J78-@-5331
(ucs-set-char #x5540 ?$BS1(B) ; J83-B-5331
(ucs-set-char #x5541 ?$(D5V(B) ; J90-D-3556
(ucs-set-char #x5541 ?$(GYL(B) ; C01-G-594C
(ucs-set-char #x5541 ?$A_z(B) ; GB0-A-5F7A
(ucs-set-char #x5542 ?$(J0r(B) ; C04-J-3072
(ucs-set-char #x5543 ?$(GY>(B) ; C01-G-593E
(ucs-set-char #x5543 ?$A?P(B) ; GB0-A-3F50
(ucs-set-char #x5544 ?$(Cvr(B) ; KS0-C-7672
(ucs-set-char #x5544 ?$(GY;(B) ; C01-G-593B
(ucs-set-char #x5544 ?$@Bo(B) ; J78-@-426F
(ucs-set-char #x5544 ?$AWD(B) ; GB0-A-5744
(ucs-set-char #x5544 ?$BBo(B) ; J83-B-426F
(ucs-set-char #x5545 ?$(H4#(B) ; C02-H-3423
(ucs-set-char #x5545 ?$@S6(B) ; J78-@-5336
(ucs-set-char #x5545 ?$BS6(B) ; J83-B-5336
(ucs-set-char #x5546 ?$(C_B(B) ; KS0-C-5F42
(ucs-set-char #x5546 ?$(GY8(B) ; C01-G-5938
(ucs-set-char #x5546 ?$@>&(B) ; J78-@-3E26
(ucs-set-char #x5546 ?$AIL(B) ; GB0-A-494C
(ucs-set-char #x5546 ?$B>&(B) ; J83-B-3E26
(ucs-set-char #x5547 ?$(D5W(B) ; J90-D-3557
(ucs-set-char #x5547 ?$(J0t(B) ; C04-J-3074
(ucs-set-char #x5548 ?$(H4)(B) ; C02-H-3429
(ucs-set-char #x5549 ?$(D5X(B) ; J90-D-3558
(ucs-set-char #x5549 ?$(I4[(B) ; C03-I-345B
(ucs-set-char #x5549 ?$A_x(B) ; GB0-A-5F78
(ucs-set-char #x554A ?$(D5Y(B) ; J90-D-3559
(ucs-set-char #x554A ?$(GY?(B) ; C01-G-593F
(ucs-set-char #x554A ?$A0!(B) ; GB0-A-3021
(ucs-set-char #x554B ?$(H4-(B) ; C02-H-342D
(ucs-set-char #x554C ?$(I4X(B) ; C03-I-3458
(ucs-set-char #x554C ?$@S3(B) ; J78-@-5333
(ucs-set-char #x554C ?$BS3(B) ; J83-B-5333
(ucs-set-char #x554D ?$(D5Z(B) ; J90-D-355A
(ucs-set-char #x554D ?$(H3w(B) ; C02-H-3377
(ucs-set-char #x554E ?$(H4'(B) ; C02-H-3427
(ucs-set-char #x554F ?$(CY}(B) ; KS0-C-597D
(ucs-set-char #x554F ?$(GYB(B) ; C01-G-5942
(ucs-set-char #x554F ?$@Ld(B) ; J78-@-4C64
(ucs-set-char #x554F ?$BLd(B) ; J83-B-4C64
(ucs-set-char #x5550 ?$(D5[(B) ; J90-D-355B
(ucs-set-char #x5550 ?$(H3x(B) ; C02-H-3378
(ucs-set-char #x5550 ?$A_}(B) ; GB0-A-5F7D
(ucs-set-char #x5551 ?$(D5\(B) ; J90-D-355C
(ucs-set-char #x5551 ?$(H3{(B) ; C02-H-337B
(ucs-set-char #x5552 ?$(H4"(B) ; C02-H-3422
(ucs-set-char #x5553 ?$(CLv(B) ; KS0-C-4C76
(ucs-set-char #x5553 ?$(I4b(B) ; C03-I-3462
(ucs-set-char #x5553 ?$@7<(B) ; J78-@-373C
(ucs-set-char #x5553 ?$B7<(B) ; J83-B-373C
(ucs-set-char #x5554 ?$(I4a(B) ; C03-I-3461
(ucs-set-char #x5555 ?$(GYC(B) ; C01-G-5943
(ucs-set-char #x5555 ?$A_{(B) ; GB0-A-5F7B
(ucs-set-char #x5556 ?$(CS:(B) ; KS0-C-533A
(ucs-set-char #x5556 ?$(GYA(B) ; C01-G-5941
(ucs-set-char #x5556 ?$@S7(B) ; J78-@-5337
(ucs-set-char #x5556 ?$A`"(B) ; GB0-A-6022
(ucs-set-char #x5556 ?$BS7(B) ; J83-B-5337
(ucs-set-char #x5557 ?$(GYM(B) ; C01-G-594D
(ucs-set-char #x5557 ?$@S8(B) ; J78-@-5338
(ucs-set-char #x5557 ?$BS8(B) ; J83-B-5338
(ucs-set-char #x5558 ?$(D5](B) ; J90-D-355D
(ucs-set-char #x5558 ?$(I4W(B) ; C03-I-3457
(ucs-set-char #x5559 ?$(I:6(B) ; C03-I-3A36
(ucs-set-char #x555A ?$(D5^(B) ; J90-D-355E
(ucs-set-char #x555A ?$(I4d(B) ; C03-I-3464
(ucs-set-char #x555B ?$(D5_(B) ; J90-D-355F
(ucs-set-char #x555B ?$(J0k(B) ; C04-J-306B
(ucs-set-char #x555C ?$(GYH(B) ; C01-G-5948
(ucs-set-char #x555C ?$@S5(B) ; J78-@-5335
(ucs-set-char #x555C ?$A`((B) ; GB0-A-6028
(ucs-set-char #x555C ?$BS5(B) ; J83-B-5335
(ucs-set-char #x555D ?$(I4^(B) ; C03-I-345E
(ucs-set-char #x555D ?$@S;(B) ; J78-@-533B
(ucs-set-char #x555D ?$BS;(B) ; J83-B-533B
(ucs-set-char #x555E ?$(Cd/(B) ; KS0-C-642F
(ucs-set-char #x555E ?$(D5`(B) ; J90-D-3560
(ucs-set-char #x555E ?$(GY<(B) ; C01-G-593C
(ucs-set-char #x555E ?$@0"(B) ; J78-@-3022
(ucs-set-char #x555F ?$(GZv(B) ; C01-G-5A76
(ucs-set-char #x5560 ?$(D5a(B) ; J90-D-3561
(ucs-set-char #x5560 ?$(J0z(B) ; C04-J-307A
(ucs-set-char #x5561 ?$(D5b(B) ; J90-D-3562
(ucs-set-char #x5561 ?$(GY=(B) ; C01-G-593D
(ucs-set-char #x5561 ?$A7H(B) ; GB0-A-3748
(ucs-set-char #x5562 ?$(H3|(B) ; C02-H-337C
(ucs-set-char #x5563 ?$(Cya(B) ; KS0-C-7961
(ucs-set-char #x5563 ?$(GYJ(B) ; C01-G-594A
(ucs-set-char #x5563 ?$@S2(B) ; J78-@-5332
(ucs-set-char #x5563 ?$BS2(B) ; J83-B-5332
(ucs-set-char #x5564 ?$(D5c(B) ; J90-D-3563
(ucs-set-char #x5564 ?$(GYE(B) ; C01-G-5945
(ucs-set-char #x5564 ?$AF!(B) ; GB0-A-4621
(ucs-set-char #x5565 ?$(H4&(B) ; C02-H-3426
(ucs-set-char #x5565 ?$AI6(B) ; GB0-A-4936
(ucs-set-char #x5566 ?$(D5d(B) ; J90-D-3564
(ucs-set-char #x5566 ?$(GY:(B) ; C01-G-593A
(ucs-set-char #x5566 ?$A@2(B) ; GB0-A-4032
(ucs-set-char #x5567 ?$A_u(B) ; GB0-A-5F75
(ucs-set-char #x5568 ?$(I4Y(B) ; C03-I-3459
(ucs-set-char #x556A ?$(GY9(B) ; C01-G-5939
(ucs-set-char #x556A ?$AE>(B) ; GB0-A-453E
(ucs-set-char #x556C ?$AXD(B) ; GB0-A-5844
(ucs-set-char #x556D ?$A_y(B) ; GB0-A-5F79
(ucs-set-char #x556E ?$ADv(B) ; GB0-A-4476
(ucs-set-char #x5575 ?$(H3t(B) ; C02-H-3374
(ucs-set-char #x5575 ?$A`#(B) ; GB0-A-6023
(ucs-set-char #x5576 ?$(H3u(B) ; C02-H-3375
(ucs-set-char #x5576 ?$A`$(B) ; GB0-A-6024
(ucs-set-char #x5577 ?$(H:N(B) ; C02-H-3A4E
(ucs-set-char #x5577 ?$A`%(B) ; GB0-A-6025
(ucs-set-char #x5578 ?$AP%(B) ; GB0-A-5025
(ucs-set-char #x557A ?$(I:<(B) ; C03-I-3A3C
(ucs-set-char #x557B ?$(G^=(B) ; C01-G-5E3D
(ucs-set-char #x557B ?$@SA(B) ; J78-@-5341
(ucs-set-char #x557B ?$A`4(B) ; GB0-A-6034
(ucs-set-char #x557B ?$BSA(B) ; J83-B-5341
(ucs-set-char #x557C ?$(Cp&(B) ; KS0-C-7026
(ucs-set-char #x557C ?$(G^@(B) ; C01-G-5E40
(ucs-set-char #x557C ?$@SF(B) ; J78-@-5346
(ucs-set-char #x557C ?$ALd(B) ; GB0-A-4C64
(ucs-set-char #x557C ?$BSF(B) ; J83-B-5346
(ucs-set-char #x557D ?$(H:Y(B) ; C02-H-3A59
(ucs-set-char #x557E ?$(G^T(B) ; C01-G-5E54
(ucs-set-char #x557E ?$@SB(B) ; J78-@-5342
(ucs-set-char #x557E ?$A`1(B) ; GB0-A-6031
(ucs-set-char #x557E ?$BSB(B) ; J83-B-5342
(ucs-set-char #x557F ?$(D5e(B) ; J90-D-3565
(ucs-set-char #x557F ?$(H:\(B) ; C02-H-3A5C
(ucs-set-char #x5580 ?$(CKS(B) ; KS0-C-4B53
(ucs-set-char #x5580 ?$(G^>(B) ; C01-G-5E3E
(ucs-set-char #x5580 ?$@S=(B) ; J78-@-533D
(ucs-set-char #x5580 ?$A?&(B) ; GB0-A-3F26
(ucs-set-char #x5580 ?$BS=(B) ; J83-B-533D
(ucs-set-char #x5581 ?$(D5f(B) ; J90-D-3566
(ucs-set-char #x5581 ?$(H:U(B) ; C02-H-3A55
(ucs-set-char #x5581 ?$A`/(B) ; GB0-A-602F
(ucs-set-char #x5582 ?$(D5g(B) ; J90-D-3567
(ucs-set-char #x5582 ?$(G^D(B) ; C01-G-5E44
(ucs-set-char #x5582 ?$AN9(B) ; GB0-A-4E39
(ucs-set-char #x5583 ?$(G^J(B) ; C01-G-5E4A
(ucs-set-char #x5583 ?$@SG(B) ; J78-@-5347
(ucs-set-char #x5583 ?$A`+(B) ; GB0-A-602B
(ucs-set-char #x5583 ?$BSG(B) ; J83-B-5347
(ucs-set-char #x5584 ?$(C`<(B) ; KS0-C-603C
(ucs-set-char #x5584 ?$(GaC(B) ; C01-G-6143
(ucs-set-char #x5584 ?$(LG*(B) ; C06-L-472A
(ucs-set-char #x5584 ?$@A1(B) ; J78-@-4131
(ucs-set-char #x5584 ?$AIF(B) ; GB0-A-4946
(ucs-set-char #x5584 ?$BA1(B) ; J83-B-4131
(ucs-set-char #x5585 ?$(I:1(B) ; C03-I-3A31
(ucs-set-char #x5586 ?$(CtJ(B) ; KS0-C-744A
(ucs-set-char #x5586 ?$(D5h(B) ; J90-D-3568
(ucs-set-char #x5586 ?$(I:8(B) ; C03-I-3A38
(ucs-set-char #x5587 ?$(CTz(B) ; KS0-C-547A
(ucs-set-char #x5587 ?$(G^H(B) ; C01-G-5E48
(ucs-set-char #x5587 ?$@SI(B) ; J78-@-5349
(ucs-set-char #x5587 ?$A@.(B) ; GB0-A-402E
(ucs-set-char #x5587 ?$BSI(B) ; J83-B-5349
(ucs-set-char #x5588 ?$(D5i(B) ; J90-D-3569
(ucs-set-char #x5588 ?$(H:R(B) ; C02-H-3A52
(ucs-set-char #x5588 ?$A`.(B) ; GB0-A-602E
(ucs-set-char #x5589 ?$(C}*(B) ; KS0-C-7D2A
(ucs-set-char #x5589 ?$(G^U(B) ; C01-G-5E55
(ucs-set-char #x5589 ?$@9"(B) ; J78-@-3922
(ucs-set-char #x5589 ?$A:m(B) ; GB0-A-3A6D
(ucs-set-char #x5589 ?$B9"(B) ; J83-B-3922
(ucs-set-char #x558A ?$(Cyb(B) ; KS0-C-7962
(ucs-set-char #x558A ?$(G^A(B) ; C01-G-5E41
(ucs-set-char #x558A ?$@S?(B) ; J78-@-533F
(ucs-set-char #x558A ?$A:0(B) ; GB0-A-3A30
(ucs-set-char #x558A ?$BS?(B) ; J83-B-533F
(ucs-set-char #x558B ?$(G^I(B) ; C01-G-5E49
(ucs-set-char #x558B ?$@C}(B) ; J78-@-437D
(ucs-set-char #x558B ?$A`)(B) ; GB0-A-6029
(ucs-set-char #x558B ?$BC}(B) ; J83-B-437D
(ucs-set-char #x558C ?$(H:Z(B) ; C02-H-3A5A
(ucs-set-char #x558D ?$(HA|(B) ; C02-H-417C
(ucs-set-char #x558E ?$(D5j(B) ; J90-D-356A
(ucs-set-char #x558E ?$(H:_(B) ; C02-H-3A5F
(ucs-set-char #x558F ?$(D5k(B) ; J90-D-356B
(ucs-set-char #x558F ?$(H:S(B) ; C02-H-3A53
(ucs-set-char #x558F ?$A_v(B) ; GB0-A-5F76
(ucs-set-char #x5590 ?$(J6\(B) ; C04-J-365C
(ucs-set-char #x5591 ?$(D5l(B) ; J90-D-356C
(ucs-set-char #x5591 ?$(H:J(B) ; C02-H-3A4A
(ucs-set-char #x5591 ?$A`3(B) ; GB0-A-6033
(ucs-set-char #x5592 ?$(D5m(B) ; J90-D-356D
(ucs-set-char #x5592 ?$(H:W(B) ; C02-H-3A57
(ucs-set-char #x5593 ?$(D5n(B) ; J90-D-356E
(ucs-set-char #x5593 ?$(H:Q(B) ; C02-H-3A51
(ucs-set-char #x5594 ?$(D5o(B) ; J90-D-356F
(ucs-set-char #x5594 ?$(G^G(B) ; C01-G-5E47
(ucs-set-char #x5594 ?$A`8(B) ; GB0-A-6038
(ucs-set-char #x5595 ?$(H:](B) ; C02-H-3A5D
(ucs-set-char #x5596 ?$(I:.(B) ; C03-I-3A2E
(ucs-set-char #x5597 ?$(D5p(B) ; J90-D-3570
(ucs-set-char #x5597 ?$(I:*(B) ; C03-I-3A2A
(ucs-set-char #x5598 ?$(Ct7(B) ; KS0-C-7437
(ucs-set-char #x5598 ?$(G^C(B) ; C01-G-5E43
(ucs-set-char #x5598 ?$@SC(B) ; J78-@-5343
(ucs-set-char #x5598 ?$A4-(B) ; GB0-A-342D
(ucs-set-char #x5598 ?$BSC(B) ; J83-B-5343
(ucs-set-char #x5599 ?$(C}B(B) ; KS0-C-7D42
(ucs-set-char #x5599 ?$(G^W(B) ; C01-G-5E57
(ucs-set-char #x5599 ?$@S<(B) ; J78-@-533C
(ucs-set-char #x5599 ?$A`9(B) ; GB0-A-6039
(ucs-set-char #x5599 ?$BS<(B) ; J83-B-533C
(ucs-set-char #x559A ?$(C|0(B) ; KS0-C-7C30
(ucs-set-char #x559A ?$(G^P(B) ; C01-G-5E50
(ucs-set-char #x559A ?$@4-(B) ; J78-@-342D
(ucs-set-char #x559A ?$B4-(B) ; J83-B-342D
(ucs-set-char #x559B ?$(I:3(B) ; C03-I-3A33
(ucs-set-char #x559C ?$(C}l(B) ; KS0-C-7D6C
(ucs-set-char #x559C ?$(G^E(B) ; C01-G-5E45
(ucs-set-char #x559C ?$@4n(B) ; J78-@-346E
(ucs-set-char #x559C ?$AO2(B) ; GB0-A-4F32
(ucs-set-char #x559C ?$B4n(B) ; J83-B-346E
(ucs-set-char #x559D ?$(CJb(B) ; KS0-C-4A62
(ucs-set-char #x559D ?$(G^B(B) ; C01-G-5E42
(ucs-set-char #x559D ?$@3e(B) ; J78-@-3365
(ucs-set-char #x559D ?$A:H(B) ; GB0-A-3A48
(ucs-set-char #x559D ?$B3e(B) ; J83-B-3365
(ucs-set-char #x559E ?$(I:@(B) ; C03-I-3A40
(ucs-set-char #x559E ?$@SD(B) ; J78-@-5344
(ucs-set-char #x559E ?$BSD(B) ; J83-B-5344
(ucs-set-char #x559F ?$(G^M(B) ; C01-G-5E4D
(ucs-set-char #x559F ?$@S@(B) ; J78-@-5340
(ucs-set-char #x559F ?$A`0(B) ; GB0-A-6030
(ucs-set-char #x559F ?$BS@(B) ; J83-B-5340
(ucs-set-char #x55A0 ?$(I:4(B) ; C03-I-3A34
(ucs-set-char #x55A1 ?$(H:^(B) ; C02-H-3A5E
(ucs-set-char #x55A2 ?$(H:P(B) ; C02-H-3A50
(ucs-set-char #x55A3 ?$(D5q(B) ; J90-D-3571
(ucs-set-char #x55A3 ?$(H:V(B) ; C02-H-3A56
(ucs-set-char #x55A4 ?$(D5r(B) ; J90-D-3572
(ucs-set-char #x55A4 ?$(H:X(B) ; C02-H-3A58
(ucs-set-char #x55A5 ?$(H:L(B) ; C02-H-3A4C
(ucs-set-char #x55A6 ?$(H:[(B) ; C02-H-3A5B
(ucs-set-char #x55A7 ?$(C}=(B) ; KS0-C-7D3D
(ucs-set-char #x55A7 ?$(G^?(B) ; C01-G-5E3F
(ucs-set-char #x55A7 ?$@7v(B) ; J78-@-3776
(ucs-set-char #x55A7 ?$APz(B) ; GB0-A-507A
(ucs-set-char #x55A7 ?$B7v(B) ; J83-B-3776
(ucs-set-char #x55A8 ?$(H:K(B) ; C02-H-3A4B
(ucs-set-char #x55A8 ?$@SJ(B) ; J78-@-534A
(ucs-set-char #x55A8 ?$BSJ(B) ; J83-B-534A
(ucs-set-char #x55A9 ?$(Cjg(B) ; KS0-C-6A67
(ucs-set-char #x55A9 ?$(I:B(B) ; C03-I-3A42
(ucs-set-char #x55A9 ?$@SH(B) ; J78-@-5348
(ucs-set-char #x55A9 ?$BSH(B) ; J83-B-5348
(ucs-set-char #x55AA ?$(C_C(B) ; KS0-C-5F43
(ucs-set-char #x55AA ?$(G^F(B) ; C01-G-5E46
(ucs-set-char #x55AA ?$@AS(B) ; J78-@-4153
(ucs-set-char #x55AA ?$BAS(B) ; J83-B-4153
(ucs-set-char #x55AB ?$(CQR(B) ; KS0-C-5152
(ucs-set-char #x55AB ?$(G^V(B) ; C01-G-5E56
(ucs-set-char #x55AB ?$(LG1(B) ; C06-L-4731
(ucs-set-char #x55AB ?$@5J(B) ; J78-@-354A
(ucs-set-char #x55AB ?$B5J(B) ; J83-B-354A
(ucs-set-char #x55AC ?$(CNb(B) ; KS0-C-4E62
(ucs-set-char #x55AC ?$(G^R(B) ; C01-G-5E52
(ucs-set-char #x55AC ?$@6,(B) ; J78-@-362C
(ucs-set-char #x55AC ?$B6,(B) ; J83-B-362C
(ucs-set-char #x55AD ?$(D5s(B) ; J90-D-3573
(ucs-set-char #x55AD ?$(H:M(B) ; C02-H-3A4D
(ucs-set-char #x55AE ?$(CS$(B) ; KS0-C-5324
(ucs-set-char #x55AE ?$(G^L(B) ; C01-G-5E4C
(ucs-set-char #x55AE ?$@SE(B) ; J78-@-5345
(ucs-set-char #x55AE ?$BSE(B) ; J83-B-5345
(ucs-set-char #x55AF ?$(I:;(B) ; C03-I-3A3B
(ucs-set-char #x55B0 ?$@6t(B) ; J78-@-3674
(ucs-set-char #x55B0 ?$B6t(B) ; J83-B-3674
(ucs-set-char #x55B1 ?$(G^S(B) ; C01-G-5E53
(ucs-set-char #x55B1 ?$A`,(B) ; GB0-A-602C
(ucs-set-char #x55B2 ?$(D5t(B) ; J90-D-3574
(ucs-set-char #x55B2 ?$(G^O(B) ; C01-G-5E4F
(ucs-set-char #x55B3 ?$(G^K(B) ; C01-G-5E4B
(ucs-set-char #x55B3 ?$AT{(B) ; GB0-A-547B
(ucs-set-char #x55B4 ?$(I:/(B) ; C03-I-3A2F
(ucs-set-char #x55B5 ?$(H:T(B) ; C02-H-3A54
(ucs-set-char #x55B5 ?$A_w(B) ; GB0-A-5F77
(ucs-set-char #x55B6 ?$(LG)(B) ; C06-L-4729
(ucs-set-char #x55B6 ?$@1D(B) ; J78-@-3144
(ucs-set-char #x55B6 ?$B1D(B) ; J83-B-3144
(ucs-set-char #x55B7 ?$AEg(B) ; GB0-A-4567
(ucs-set-char #x55B9 ?$A`-(B) ; GB0-A-602D
(ucs-set-char #x55BB ?$(G^Q(B) ; C01-G-5E51
(ucs-set-char #x55BB ?$ASw(B) ; GB0-A-5377
(ucs-set-char #x55BD ?$A`6(B) ; GB0-A-6036
(ucs-set-char #x55BE ?$A`7(B) ; GB0-A-6037
(ucs-set-char #x55BF ?$(D5u(B) ; J90-D-3575
(ucs-set-char #x55BF ?$(HAz(B) ; C02-H-417A
(ucs-set-char #x55C0 ?$(HAv(B) ; C02-H-4176
(ucs-set-char #x55C1 ?$(D5v(B) ; J90-D-3576
(ucs-set-char #x55C1 ?$(I@Q(B) ; C03-I-4051
(ucs-set-char #x55C2 ?$(HB'(B) ; C02-H-4227
(ucs-set-char #x55C3 ?$(D5w(B) ; J90-D-3577
(ucs-set-char #x55C3 ?$(HAo(B) ; C02-H-416F
(ucs-set-char #x55C4 ?$(HAx(B) ; C02-H-4178
(ucs-set-char #x55C4 ?$@SN(B) ; J78-@-534E
(ucs-set-char #x55C4 ?$A`D(B) ; GB0-A-6044
(ucs-set-char #x55C4 ?$BSN(B) ; J83-B-534E
(ucs-set-char #x55C5 ?$(C}+(B) ; KS0-C-7D2B
(ucs-set-char #x55C5 ?$(GcL(B) ; C01-G-634C
(ucs-set-char #x55C5 ?$@SL(B) ; J78-@-534C
(ucs-set-char #x55C5 ?$APa(B) ; GB0-A-5061
(ucs-set-char #x55C5 ?$BSL(B) ; J83-B-534C
(ucs-set-char #x55C6 ?$(D5x(B) ; J90-D-3578
(ucs-set-char #x55C6 ?$(GcM(B) ; C01-G-634D
(ucs-set-char #x55C7 ?$(C_`(B) ; KS0-C-5F60
(ucs-set-char #x55C7 ?$(GcE(B) ; C01-G-6345
(ucs-set-char #x55C7 ?$@T'(B) ; J78-@-5427
(ucs-set-char #x55C7 ?$BT'(B) ; J83-B-5427
(ucs-set-char #x55C8 ?$(HB#(B) ; C02-H-4223
(ucs-set-char #x55C9 ?$(D5y(B) ; J90-D-3579
(ucs-set-char #x55C9 ?$(GcO(B) ; C01-G-634F
(ucs-set-char #x55C9 ?$A`<(B) ; GB0-A-603C
(ucs-set-char #x55CA ?$(HAt(B) ; C02-H-4174
(ucs-set-char #x55CB ?$(D5z(B) ; J90-D-357A
(ucs-set-char #x55CB ?$(HAs(B) ; C02-H-4173
(ucs-set-char #x55CC ?$(D5{(B) ; J90-D-357B
(ucs-set-char #x55CC ?$(HAq(B) ; C02-H-4171
(ucs-set-char #x55CC ?$A`I(B) ; GB0-A-6049
(ucs-set-char #x55CD ?$(HB%(B) ; C02-H-4225
(ucs-set-char #x55CD ?$A`J(B) ; GB0-A-604A
(ucs-set-char #x55CE ?$(D5|(B) ; J90-D-357C
(ucs-set-char #x55CE ?$(GcC(B) ; C01-G-6343
(ucs-set-char #x55CF ?$(HA}(B) ; C02-H-417D
(ucs-set-char #x55D0 ?$(HAr(B) ; C02-H-4172
(ucs-set-char #x55D1 ?$(D5}(B) ; J90-D-357D
(ucs-set-char #x55D1 ?$(GcF(B) ; C01-G-6346
(ucs-set-char #x55D1 ?$A`>(B) ; GB0-A-603E
(ucs-set-char #x55D2 ?$(D5~(B) ; J90-D-357E
(ucs-set-char #x55D2 ?$(HA{(B) ; C02-H-417B
(ucs-set-char #x55D2 ?$A`*(B) ; GB0-A-602A
(ucs-set-char #x55D3 ?$(D6!(B) ; J90-D-3621
(ucs-set-char #x55D3 ?$(GcA(B) ; C01-G-6341
(ucs-set-char #x55D3 ?$AI$(B) ; GB0-A-4924
(ucs-set-char #x55D4 ?$(CrG(B) ; KS0-C-7247
(ucs-set-char #x55D4 ?$(HAw(B) ; C02-H-4177
(ucs-set-char #x55D4 ?$@SQ(B) ; J78-@-5351
(ucs-set-char #x55D4 ?$A`A(B) ; GB0-A-6041
(ucs-set-char #x55D4 ?$BSQ(B) ; J83-B-5351
(ucs-set-char #x55D5 ?$(HA~(B) ; C02-H-417E
(ucs-set-char #x55D6 ?$(HB"(B) ; C02-H-4222
(ucs-set-char #x55D6 ?$A`2(B) ; GB0-A-6032
(ucs-set-char #x55D7 ?$(D6"(B) ; J90-D-3622
(ucs-set-char #x55D7 ?$(I@N(B) ; C03-I-404E
(ucs-set-char #x55D8 ?$(D6#(B) ; J90-D-3623
(ucs-set-char #x55D8 ?$(J<K(B) ; C04-J-3C4B
(ucs-set-char #x55D9 ?$(HB&(B) ; C02-H-4226
(ucs-set-char #x55DA ?$(Cgp(B) ; KS0-C-6770
(ucs-set-char #x55DA ?$(GcJ(B) ; C01-G-634A
(ucs-set-char #x55DA ?$@SK(B) ; J78-@-534B
(ucs-set-char #x55DA ?$BSK(B) ; J83-B-534B
(ucs-set-char #x55DB ?$(D6$(B) ; J90-D-3624
(ucs-set-char #x55DB ?$(HAp(B) ; C02-H-4170
(ucs-set-char #x55DC ?$(CPn(B) ; KS0-C-506E
(ucs-set-char #x55DC ?$(GcD(B) ; C01-G-6344
(ucs-set-char #x55DC ?$@SO(B) ; J78-@-534F
(ucs-set-char #x55DC ?$AJH(B) ; GB0-A-4A48
(ucs-set-char #x55DC ?$BSO(B) ; J83-B-534F
(ucs-set-char #x55DD ?$(HAu(B) ; C02-H-4175
(ucs-set-char #x55DD ?$A`C(B) ; GB0-A-6043
(ucs-set-char #x55DE ?$(D6%(B) ; J90-D-3625
(ucs-set-char #x55DE ?$(I:+(B) ; C03-I-3A2B
(ucs-set-char #x55DF ?$(Cs*(B) ; KS0-C-732A
(ucs-set-char #x55DF ?$(Gc?(B) ; C01-G-633F
(ucs-set-char #x55DF ?$@SM(B) ; J78-@-534D
(ucs-set-char #x55DF ?$A`5(B) ; GB0-A-6035
(ucs-set-char #x55DF ?$BSM(B) ; J83-B-534D
(ucs-set-char #x55E0 ?$(LQC(B) ; C06-L-5143
(ucs-set-char #x55E1 ?$(GcK(B) ; C01-G-634B
(ucs-set-char #x55E1 ?$ANK(B) ; GB0-A-4E4B
(ucs-set-char #x55E2 ?$(D6&(B) ; J90-D-3626
(ucs-set-char #x55E2 ?$(HB!(B) ; C02-H-4221
(ucs-set-char #x55E3 ?$(C^K(B) ; KS0-C-5E4B
(ucs-set-char #x55E3 ?$(GcG(B) ; C01-G-6347
(ucs-set-char #x55E3 ?$@;L(B) ; J78-@-3B4C
(ucs-set-char #x55E3 ?$AKC(B) ; GB0-A-4B43
(ucs-set-char #x55E3 ?$B;L(B) ; J83-B-3B4C
(ucs-set-char #x55E4 ?$(Cv8(B) ; KS0-C-7638
(ucs-set-char #x55E4 ?$(GcH(B) ; C01-G-6348
(ucs-set-char #x55E4 ?$@SP(B) ; J78-@-5350
(ucs-set-char #x55E4 ?$A`M(B) ; GB0-A-604D
(ucs-set-char #x55E4 ?$BSP(B) ; J83-B-5350
(ucs-set-char #x55E5 ?$(GcN(B) ; C01-G-634E
(ucs-set-char #x55E5 ?$A`F(B) ; GB0-A-6046
(ucs-set-char #x55E6 ?$(GcB(B) ; C01-G-6342
(ucs-set-char #x55E6 ?$A`B(B) ; GB0-A-6042
(ucs-set-char #x55E7 ?$(G#!(B) ; C01-G-2321
(ucs-set-char #x55E8 ?$(Gc@(B) ; C01-G-6340
(ucs-set-char #x55E8 ?$A`K(B) ; GB0-A-604B
(ucs-set-char #x55E9 ?$(D6'(B) ; J90-D-3627
(ucs-set-char #x55E9 ?$(HAy(B) ; C02-H-4179
(ucs-set-char #x55EA ?$(I@L(B) ; C03-I-404C
(ucs-set-char #x55EA ?$A`:(B) ; GB0-A-603A
(ucs-set-char #x55EB ?$A`?(B) ; GB0-A-603F
(ucs-set-char #x55EC ?$A`@(B) ; GB0-A-6040
(ucs-set-char #x55EF ?$(GcI(B) ; C01-G-6349
(ucs-set-char #x55EF ?$A`E(B) ; GB0-A-6045
(ucs-set-char #x55F2 ?$(HB$(B) ; C02-H-4224
(ucs-set-char #x55F2 ?$A`G(B) ; GB0-A-6047
(ucs-set-char #x55F3 ?$A`H(B) ; GB0-A-6048
(ucs-set-char #x55F5 ?$A`L(B) ; GB0-A-604C
(ucs-set-char #x55F6 ?$(D6((B) ; J90-D-3628
(ucs-set-char #x55F6 ?$(Gh5(B) ; C01-G-6835
(ucs-set-char #x55F7 ?$(Gh0(B) ; C01-G-6830
(ucs-set-char #x55F7 ?$@SS(B) ; J78-@-5353
(ucs-set-char #x55F7 ?$A`;(B) ; GB0-A-603B
(ucs-set-char #x55F7 ?$BSS(B) ; J83-B-5353
(ucs-set-char #x55F8 ?$(IF.(B) ; C03-I-462E
(ucs-set-char #x55F9 ?$(HI<(B) ; C02-H-493C
(ucs-set-char #x55F9 ?$@SX(B) ; J78-@-5358
(ucs-set-char #x55F9 ?$BSX(B) ; J83-B-5358
(ucs-set-char #x55FA ?$(HI8(B) ; C02-H-4938
(ucs-set-char #x55FB ?$(IF((B) ; C03-I-4628
(ucs-set-char #x55FC ?$(HI2(B) ; C02-H-4932
(ucs-set-char #x55FD ?$(Cau(B) ; KS0-C-6175
(ucs-set-char #x55FD ?$(Gh*(B) ; C01-G-682A
(ucs-set-char #x55FD ?$@SV(B) ; J78-@-5356
(ucs-set-char #x55FD ?$AKT(B) ; GB0-A-4B54
(ucs-set-char #x55FD ?$BSV(B) ; J83-B-5356
(ucs-set-char #x55FE ?$(Cq3(B) ; KS0-C-7133
(ucs-set-char #x55FE ?$(Gh&(B) ; C01-G-6826
(ucs-set-char #x55FE ?$@SU(B) ; J78-@-5355
(ucs-set-char #x55FE ?$A`U(B) ; GB0-A-6055
(ucs-set-char #x55FE ?$BSU(B) ; J83-B-5355
(ucs-set-char #x55FF ?$(D6)(B) ; J90-D-3629
(ucs-set-char #x55FF ?$(HI;(B) ; C02-H-493B
(ucs-set-char #x5600 ?$(Gh'(B) ; C01-G-6827
(ucs-set-char #x5600 ?$A`V(B) ; GB0-A-6056
(ucs-set-char #x5601 ?$(HI5(B) ; C02-H-4935
(ucs-set-char #x5601 ?$A`R(B) ; GB0-A-6052
(ucs-set-char #x5602 ?$(HI7(B) ; C02-H-4937
(ucs-set-char #x5603 ?$(IF)(B) ; C03-I-4629
(ucs-set-char #x5604 ?$(HI:(B) ; C02-H-493A
(ucs-set-char #x5605 ?$(D6*(B) ; J90-D-362A
(ucs-set-char #x5605 ?$(IF6(B) ; C03-I-4636
(ucs-set-char #x5606 ?$(Cw#(B) ; KS0-C-7723
(ucs-set-char #x5606 ?$(Gh,(B) ; C01-G-682C
(ucs-set-char #x5606 ?$(LQ6(B) ; C06-L-5136
(ucs-set-char #x5606 ?$@C2(B) ; J78-@-4332
(ucs-set-char #x5606 ?$BC2(B) ; J83-B-4332
(ucs-set-char #x5607 ?$(IF,(B) ; C03-I-462C
(ucs-set-char #x5608 ?$(D6+(B) ; J90-D-362B
(ucs-set-char #x5608 ?$(Gh3(B) ; C01-G-6833
(ucs-set-char #x5608 ?$A`P(B) ; GB0-A-6050
(ucs-set-char #x5609 ?$(CJ)(B) ; KS0-C-4A29
(ucs-set-char #x5609 ?$(Gh-(B) ; C01-G-682D
(ucs-set-char #x5609 ?$@2E(B) ; J78-@-3245
(ucs-set-char #x5609 ?$A<N(B) ; GB0-A-3C4E
(ucs-set-char #x5609 ?$B2E(B) ; J83-B-3245
(ucs-set-char #x560A ?$(D6,(B) ; J90-D-362C
(ucs-set-char #x560A ?$(JBW(B) ; C04-J-4257
(ucs-set-char #x560B ?$(IF*(B) ; C03-I-462A
(ucs-set-char #x560C ?$(HI0(B) ; C02-H-4930
(ucs-set-char #x560C ?$A`Q(B) ; GB0-A-6051
(ucs-set-char #x560D ?$(D6-(B) ; J90-D-362D
(ucs-set-char #x560D ?$(Gh.(B) ; C01-G-682E
(ucs-set-char #x560E ?$(D6.(B) ; J90-D-362E
(ucs-set-char #x560E ?$(Gh/(B) ; C01-G-682F
(ucs-set-char #x560E ?$A8B(B) ; GB0-A-3842
(ucs-set-char #x560F ?$(D6/(B) ; J90-D-362F
(ucs-set-char #x560F ?$(HI3(B) ; C02-H-4933
(ucs-set-char #x560F ?$AXE(B) ; GB0-A-5845
(ucs-set-char #x5610 ?$(D60(B) ; J90-D-3630
(ucs-set-char #x5610 ?$(Gh4(B) ; C01-G-6834
(ucs-set-char #x5611 ?$(D61(B) ; J90-D-3631
(ucs-set-char #x5611 ?$(IF4(B) ; C03-I-4634
(ucs-set-char #x5612 ?$(D62(B) ; J90-D-3632
(ucs-set-char #x5612 ?$(HI1(B) ; C02-H-4931
(ucs-set-char #x5613 ?$(HI6(B) ; C02-H-4936
(ucs-set-char #x5614 ?$(CO%(B) ; KS0-C-4F25
(ucs-set-char #x5614 ?$(Gh+(B) ; C01-G-682B
(ucs-set-char #x5614 ?$@SR(B) ; J78-@-5352
(ucs-set-char #x5614 ?$BSR(B) ; J83-B-5352
(ucs-set-char #x5615 ?$(HI/(B) ; C02-H-492F
(ucs-set-char #x5616 ?$(Gh1(B) ; C01-G-6831
(ucs-set-char #x5616 ?$@ST(B) ; J78-@-5354
(ucs-set-char #x5616 ?$BST(B) ; J83-B-5354
(ucs-set-char #x5617 ?$(C_D(B) ; KS0-C-5F44
(ucs-set-char #x5617 ?$(Gh)(B) ; C01-G-6829
(ucs-set-char #x5617 ?$@>((B) ; J78-@-3E28
(ucs-set-char #x5617 ?$B>((B) ; J83-B-3E28
(ucs-set-char #x5618 ?$(IF3(B) ; C03-I-4633
(ucs-set-char #x5618 ?$@13(B) ; J78-@-3133
(ucs-set-char #x5618 ?$APj(B) ; GB0-A-506A
(ucs-set-char #x5618 ?$B13(B) ; J83-B-3133
(ucs-set-char #x5619 ?$(D63(B) ; J90-D-3633
(ucs-set-char #x5619 ?$(JBK(B) ; C04-J-424B
(ucs-set-char #x561B ?$(Gh((B) ; C01-G-6828
(ucs-set-char #x561B ?$@SW(B) ; J78-@-5357
(ucs-set-char #x561B ?$ABo(B) ; GB0-A-426F
(ucs-set-char #x561B ?$BSW(B) ; J83-B-5357
(ucs-set-char #x561C ?$(HI4(B) ; C02-H-4934
(ucs-set-char #x561D ?$(HI9(B) ; C02-H-4939
(ucs-set-char #x561E ?$(IF1(B) ; C03-I-4631
(ucs-set-char #x561E ?$A`O(B) ; GB0-A-604F
(ucs-set-char #x561F ?$(Gh2(B) ; C01-G-6832
(ucs-set-char #x561F ?$A`=(B) ; GB0-A-603D
(ucs-set-char #x5623 ?$A`T(B) ; GB0-A-6054
(ucs-set-char #x5624 ?$A`S(B) ; GB0-A-6053
(ucs-set-char #x5626 ?$(IFP(B) ; C03-I-4650
(ucs-set-char #x5627 ?$(HI.(B) ; C02-H-492E
(ucs-set-char #x5627 ?$A`W(B) ; GB0-A-6057
(ucs-set-char #x5628 ?$(IF0(B) ; C03-I-4630
(ucs-set-char #x5629 ?$(Gl7(B) ; C01-G-6C37
(ucs-set-char #x5629 ?$@2^(B) ; J78-@-325E
(ucs-set-char #x5629 ?$B2^(B) ; J83-B-325E
(ucs-set-char #x562A ?$(HOn(B) ; C02-H-4F6E
(ucs-set-char #x562B ?$(IKA(B) ; C03-I-4B41
(ucs-set-char #x562C ?$(D64(B) ; J90-D-3634
(ucs-set-char #x562C ?$(HOk(B) ; C02-H-4F6B
(ucs-set-char #x562C ?$A`\(B) ; GB0-A-605C
(ucs-set-char #x562D ?$(IK8(B) ; C03-I-4B38
(ucs-set-char #x562D ?$A`X(B) ; GB0-A-6058
(ucs-set-char #x562E ?$(Gl1(B) ; C01-G-6C31
(ucs-set-char #x562F ?$(Ca0(B) ; KS0-C-6130
(ucs-set-char #x562F ?$(Gl=(B) ; C01-G-6C3D
(ucs-set-char #x562F ?$@Sb(B) ; J78-@-5362
(ucs-set-char #x562F ?$BSb(B) ; J83-B-5362
(ucs-set-char #x5630 ?$(D65(B) ; J90-D-3635
(ucs-set-char #x5630 ?$(Gl>(B) ; C01-G-6C3E
(ucs-set-char #x5631 ?$(IK=(B) ; C03-I-4B3D
(ucs-set-char #x5631 ?$@>|(B) ; J78-@-3E7C
(ucs-set-char #x5631 ?$AVv(B) ; GB0-A-5676
(ucs-set-char #x5631 ?$B>|(B) ; J83-B-3E7C
(ucs-set-char #x5632 ?$(Cp?(B) ; KS0-C-703F
(ucs-set-char #x5632 ?$(Gl4(B) ; C01-G-6C34
(ucs-set-char #x5632 ?$@S^(B) ; J78-@-535E
(ucs-set-char #x5632 ?$A30(B) ; GB0-A-3330
(ucs-set-char #x5632 ?$BS^(B) ; J83-B-535E
(ucs-set-char #x5633 ?$(D66(B) ; J90-D-3636
(ucs-set-char #x5633 ?$(HOi(B) ; C02-H-4F69
(ucs-set-char #x5634 ?$(Cv$(B) ; KS0-C-7624
(ucs-set-char #x5634 ?$(Gl6(B) ; C01-G-6C36
(ucs-set-char #x5634 ?$@S\(B) ; J78-@-535C
(ucs-set-char #x5634 ?$AWl(B) ; GB0-A-576C
(ucs-set-char #x5634 ?$BS\(B) ; J83-B-535C
(ucs-set-char #x5635 ?$(D67(B) ; J90-D-3637
(ucs-set-char #x5635 ?$(HOa(B) ; C02-H-4F61
(ucs-set-char #x5636 ?$(Cc6(B) ; KS0-C-6336
(ucs-set-char #x5636 ?$(Gl<(B) ; C01-G-6C3C
(ucs-set-char #x5636 ?$@S](B) ; J78-@-535D
(ucs-set-char #x5636 ?$AK;(B) ; GB0-A-4B3B
(ucs-set-char #x5636 ?$BS](B) ; J83-B-535D
(ucs-set-char #x5637 ?$(D68(B) ; J90-D-3638
(ucs-set-char #x5637 ?$(IKD(B) ; C03-I-4B44
(ucs-set-char #x5638 ?$(HOm(B) ; C02-H-4F6D
(ucs-set-char #x5638 ?$@S_(B) ; J78-@-535F
(ucs-set-char #x5638 ?$BS_(B) ; J83-B-535F
(ucs-set-char #x5639 ?$(D69(B) ; J90-D-3639
(ucs-set-char #x5639 ?$(Gl3(B) ; C01-G-6C33
(ucs-set-char #x5639 ?$A`Z(B) ; GB0-A-605A
(ucs-set-char #x563A ?$(HOo(B) ; C02-H-4F6F
(ucs-set-char #x563B ?$(D6:(B) ; J90-D-363A
(ucs-set-char #x563B ?$(Gl2(B) ; C01-G-6C32
(ucs-set-char #x563B ?$AN{(B) ; GB0-A-4E7B
(ucs-set-char #x563C ?$(D6;(B) ; J90-D-363B
(ucs-set-char #x563C ?$(JI1(B) ; C04-J-4931
(ucs-set-char #x563D ?$(D6<(B) ; J90-D-363C
(ucs-set-char #x563D ?$(HOj(B) ; C02-H-4F6A
(ucs-set-char #x563E ?$(HOl(B) ; C02-H-4F6C
(ucs-set-char #x563F ?$(D6=(B) ; J90-D-363D
(ucs-set-char #x563F ?$(Gl5(B) ; C01-G-6C35
(ucs-set-char #x563F ?$A:Y(B) ; GB0-A-3A59
(ucs-set-char #x5640 ?$(D6>(B) ; J90-D-363E
(ucs-set-char #x5640 ?$(HOh(B) ; C02-H-4F68
(ucs-set-char #x5641 ?$(D6?(B) ; J90-D-363F
(ucs-set-char #x5641 ?$(HOb(B) ; C02-H-4F62
(ucs-set-char #x5642 ?$(HO_(B) ; C02-H-4F5F
(ucs-set-char #x5642 ?$@1=(B) ; J78-@-313D
(ucs-set-char #x5642 ?$B1=(B) ; J83-B-313D
(ucs-set-char #x5643 ?$(D6@(B) ; J90-D-3640
(ucs-set-char #x5643 ?$(JI.(B) ; C04-J-492E
(ucs-set-char #x5644 ?$(D6A(B) ; J90-D-3641
(ucs-set-char #x5644 ?$(IK>(B) ; C03-I-4B3E
(ucs-set-char #x5645 ?$(H:O(B) ; C02-H-3A4F
(ucs-set-char #x5646 ?$(D6B(B) ; J90-D-3642
(ucs-set-char #x5646 ?$(HOe(B) ; C02-H-4F65
(ucs-set-char #x5647 ?$(IK7(B) ; C03-I-4B37
(ucs-set-char #x5648 ?$(HO^(B) ; C02-H-4F5E
(ucs-set-char #x5649 ?$(D6C(B) ; J90-D-3643
(ucs-set-char #x5649 ?$(HOd(B) ; C02-H-4F64
(ucs-set-char #x564A ?$(HOc(B) ; C02-H-4F63
(ucs-set-char #x564B ?$(D6D(B) ; J90-D-3644
(ucs-set-char #x564B ?$(IK;(B) ; C03-I-4B3B
(ucs-set-char #x564C ?$(HO`(B) ; C02-H-4F60
(ucs-set-char #x564C ?$@A9(B) ; J78-@-4139
(ucs-set-char #x564C ?$A`a(B) ; GB0-A-6061
(ucs-set-char #x564C ?$BA9(B) ; J83-B-4139
(ucs-set-char #x564D ?$(D6E(B) ; J90-D-3645
(ucs-set-char #x564D ?$(IKC(B) ; C03-I-4B43
(ucs-set-char #x564D ?$A`](B) ; GB0-A-605D
(ucs-set-char #x564E ?$(Gl9(B) ; C01-G-6C39
(ucs-set-char #x564E ?$@SY(B) ; J78-@-5359
(ucs-set-char #x564E ?$AR-(B) ; GB0-A-522D
(ucs-set-char #x564E ?$BSY(B) ; J83-B-5359
(ucs-set-char #x564F ?$(D6F(B) ; J90-D-3646
(ucs-set-char #x564F ?$(IKE(B) ; C03-I-4B45
(ucs-set-char #x5650 ?$(IK@(B) ; C03-I-4B40
(ucs-set-char #x5650 ?$@SZ(B) ; J78-@-535A
(ucs-set-char #x5650 ?$BSZ(B) ; J83-B-535A
(ucs-set-char #x5651 ?$(IF5(B) ; C03-I-4635
(ucs-set-char #x5652 ?$(IK<(B) ; C03-I-4B3C
(ucs-set-char #x5653 ?$(CzF(B) ; KS0-C-7A46
(ucs-set-char #x5653 ?$(Gl8(B) ; C01-G-6C38
(ucs-set-char #x5654 ?$(D6G(B) ; J90-D-3647
(ucs-set-char #x5654 ?$(IK9(B) ; C03-I-4B39
(ucs-set-char #x5654 ?$A`b(B) ; GB0-A-6062
(ucs-set-char #x5655 ?$(M!c(B) ; C07-M-2163
(ucs-set-char #x5656 ?$(IK?(B) ; C03-I-4B3F
(ucs-set-char #x5657 ?$(Gl:(B) ; C01-G-6C3A
(ucs-set-char #x5657 ?$A`[(B) ; GB0-A-605B
(ucs-set-char #x5658 ?$(HOf(B) ; C02-H-4F66
(ucs-set-char #x5658 ?$A`Y(B) ; GB0-A-6059
(ucs-set-char #x5659 ?$(Gp;(B) ; C01-G-703B
(ucs-set-char #x5659 ?$A`_(B) ; GB0-A-605F
(ucs-set-char #x565A ?$(HOg(B) ; C02-H-4F67
(ucs-set-char #x565B ?$B3z(B) ; J83-B-337A
(ucs-set-char #x565C ?$A``(B) ; GB0-A-6060
(ucs-set-char #x565E ?$(D6H(B) ; J90-D-3648
(ucs-set-char #x565E ?$(HVO(B) ; C02-H-564F
(ucs-set-char #x565F ?$(IP?(B) ; C03-I-503F
(ucs-set-char #x5660 ?$(D6I(B) ; J90-D-3649
(ucs-set-char #x5660 ?$(HVH(B) ; C02-H-5648
(ucs-set-char #x5661 ?$(D6J(B) ; J90-D-364A
(ucs-set-char #x5661 ?$(IP@(B) ; C03-I-5040
(ucs-set-char #x5662 ?$(D6K(B) ; J90-D-364B
(ucs-set-char #x5662 ?$(GpG(B) ; C01-G-7047
(ucs-set-char #x5662 ?$A`^(B) ; GB0-A-605E
(ucs-set-char #x5663 ?$(D6L(B) ; J90-D-364C
(ucs-set-char #x5663 ?$(HVL(B) ; C02-H-564C
(ucs-set-char #x5664 ?$(Gp?(B) ; C01-G-703F
(ucs-set-char #x5664 ?$@Sa(B) ; J78-@-5361
(ucs-set-char #x5664 ?$A`d(B) ; GB0-A-6064
(ucs-set-char #x5664 ?$BSa(B) ; J83-B-5361
(ucs-set-char #x5665 ?$(GpC(B) ; C01-G-7043
(ucs-set-char #x5666 ?$(D6M(B) ; J90-D-364D
(ucs-set-char #x5666 ?$(HVK(B) ; C02-H-564B
(ucs-set-char #x5667 ?$(IP;(B) ; C03-I-503B
(ucs-set-char #x5668 ?$(CPo(B) ; KS0-C-506F
(ucs-set-char #x5668 ?$(GpB(B) ; C01-G-7042
(ucs-set-char #x5668 ?$(JI2(B) ; C04-J-4932
(ucs-set-char #x5668 ?$@4o(B) ; J78-@-346F
(ucs-set-char #x5668 ?$AFw(B) ; GB0-A-4677
(ucs-set-char #x5668 ?$B4o(B) ; J83-B-346F
(ucs-set-char #x5669 ?$(D6N(B) ; J90-D-364E
(ucs-set-char #x5669 ?$(Gp>(B) ; C01-G-703E
(ucs-set-char #x5669 ?$AX,(B) ; GB0-A-582C
(ucs-set-char #x566A ?$(GpA(B) ; C01-G-7041
(ucs-set-char #x566A ?$@Sd(B) ; J78-@-5364
(ucs-set-char #x566A ?$ATk(B) ; GB0-A-546B
(ucs-set-char #x566A ?$BSd(B) ; J83-B-5364
(ucs-set-char #x566B ?$(C}m(B) ; KS0-C-7D6D
(ucs-set-char #x566B ?$(Gp<(B) ; C01-G-703C
(ucs-set-char #x566B ?$@S`(B) ; J78-@-5360
(ucs-set-char #x566B ?$A`f(B) ; GB0-A-6066
(ucs-set-char #x566B ?$BS`(B) ; J83-B-5360
(ucs-set-char #x566C ?$(GpF(B) ; C01-G-7046
(ucs-set-char #x566C ?$@Sc(B) ; J78-@-5363
(ucs-set-char #x566C ?$AJI(B) ; GB0-A-4A49
(ucs-set-char #x566C ?$BSc(B) ; J83-B-5363
(ucs-set-char #x566D ?$(D6O(B) ; J90-D-364F
(ucs-set-char #x566D ?$(HVM(B) ; C02-H-564D
(ucs-set-char #x566E ?$(HVI(B) ; C02-H-5649
(ucs-set-char #x566F ?$(D6P(B) ; J90-D-3650
(ucs-set-char #x566F ?$(GpE(B) ; C01-G-7045
(ucs-set-char #x5670 ?$(HVG(B) ; C02-H-5647
(ucs-set-char #x5671 ?$(D6Q(B) ; J90-D-3651
(ucs-set-char #x5671 ?$(GpD(B) ; C01-G-7044
(ucs-set-char #x5671 ?$A`e(B) ; GB0-A-6065
(ucs-set-char #x5672 ?$(D6R(B) ; J90-D-3652
(ucs-set-char #x5672 ?$(HVN(B) ; C02-H-564E
(ucs-set-char #x5673 ?$(HVJ(B) ; C02-H-564A
(ucs-set-char #x5674 ?$(C]D(B) ; KS0-C-5D44
(ucs-set-char #x5674 ?$(Gl;(B) ; C01-G-6C3B
(ucs-set-char #x5674 ?$@J.(B) ; J78-@-4A2E
(ucs-set-char #x5674 ?$BJ.(B) ; J83-B-4A2E
(ucs-set-char #x5675 ?$(D6S(B) ; J90-D-3653
(ucs-set-char #x5675 ?$(JOq(B) ; C04-J-4F71
(ucs-set-char #x5676 ?$(GpH(B) ; C01-G-7048
(ucs-set-char #x5676 ?$A8A(B) ; GB0-A-3841
(ucs-set-char #x5677 ?$(HVP(B) ; C02-H-5650
(ucs-set-char #x5678 ?$(Gp@(B) ; C01-G-7040
(ucs-set-char #x5678 ?$@FU(B) ; J78-@-4655
(ucs-set-char #x5678 ?$BFU(B) ; J83-B-4655
(ucs-set-char #x5679 ?$(Gp=(B) ; C01-G-703D
(ucs-set-char #x567A ?$@H8(B) ; J78-@-4838
(ucs-set-char #x567A ?$BH8(B) ; J83-B-4838
(ucs-set-char #x567B ?$(IP=(B) ; C03-I-503D
(ucs-set-char #x567B ?$A`g(B) ; GB0-A-6067
(ucs-set-char #x567C ?$A`h(B) ; GB0-A-6068
(ucs-set-char #x567D ?$(ITH(B) ; C03-I-5448
(ucs-set-char #x567E ?$(H\R(B) ; C02-H-5C52
(ucs-set-char #x567F ?$(H\T(B) ; C02-H-5C54
(ucs-set-char #x5680 ?$(GsF(B) ; C01-G-7346
(ucs-set-char #x5680 ?$@Sf(B) ; J78-@-5366
(ucs-set-char #x5680 ?$BSf(B) ; J83-B-5366
(ucs-set-char #x5681 ?$(H\U(B) ; C02-H-5C55
(ucs-set-char #x5682 ?$(H\S(B) ; C02-H-5C53
(ucs-set-char #x5683 ?$(H\Q(B) ; C02-H-5C51
(ucs-set-char #x5684 ?$(D6T(B) ; J90-D-3654
(ucs-set-char #x5684 ?$(H\P(B) ; C02-H-5C50
(ucs-set-char #x5685 ?$(D6U(B) ; J90-D-3655
(ucs-set-char #x5685 ?$(GsH(B) ; C01-G-7348
(ucs-set-char #x5685 ?$A`i(B) ; GB0-A-6069
(ucs-set-char #x5686 ?$(C|w(B) ; KS0-C-7C77
(ucs-set-char #x5686 ?$(H\O(B) ; C02-H-5C4F
(ucs-set-char #x5686 ?$@Se(B) ; J78-@-5365
(ucs-set-char #x5686 ?$A`c(B) ; GB0-A-6063
(ucs-set-char #x5686 ?$BSe(B) ; J83-B-5365
(ucs-set-char #x5687 ?$(GsI(B) ; C01-G-7349
(ucs-set-char #x5687 ?$@3E(B) ; J78-@-3345
(ucs-set-char #x5687 ?$B3E(B) ; J83-B-3345
(ucs-set-char #x5688 ?$(D6V(B) ; J90-D-3656
(ucs-set-char #x5688 ?$(JUt(B) ; C04-J-5574
(ucs-set-char #x5689 ?$(ITI(B) ; C03-I-5449
(ucs-set-char #x568A ?$(ITG(B) ; C03-I-5447
(ucs-set-char #x568A ?$@Sg(B) ; J78-@-5367
(ucs-set-char #x568A ?$BSg(B) ; J83-B-5367
(ucs-set-char #x568B ?$(D6W(B) ; J90-D-3657
(ucs-set-char #x568B ?$(JUx(B) ; C04-J-5578
(ucs-set-char #x568C ?$(D6X(B) ; J90-D-3658
(ucs-set-char #x568C ?$(H\M(B) ; C02-H-5C4D
(ucs-set-char #x568D ?$(H\N(B) ; C02-H-5C4E
(ucs-set-char #x568E ?$(GsE(B) ; C01-G-7345
(ucs-set-char #x568E ?$A:?(B) ; GB0-A-3A3F
(ucs-set-char #x568F ?$(GsJ(B) ; C01-G-734A
(ucs-set-char #x568F ?$@Sj(B) ; J78-@-536A
(ucs-set-char #x568F ?$ALg(B) ; GB0-A-4C67
(ucs-set-char #x568F ?$BSj(B) ; J83-B-536A
(ucs-set-char #x5690 ?$(GsG(B) ; C01-G-7347
(ucs-set-char #x5693 ?$(H\L(B) ; C02-H-5C4C
(ucs-set-char #x5693 ?$A`j(B) ; GB0-A-606A
(ucs-set-char #x5694 ?$(IW[(B) ; C03-I-575B
(ucs-set-char #x5694 ?$@Si(B) ; J78-@-5369
(ucs-set-char #x5694 ?$BSi(B) ; J83-B-5369
(ucs-set-char #x5695 ?$(D6Y(B) ; J90-D-3659
(ucs-set-char #x5695 ?$(Gv<(B) ; C01-G-763C
(ucs-set-char #x5696 ?$(IWZ(B) ; C03-I-575A
(ucs-set-char #x5697 ?$(HaH(B) ; C02-H-6148
(ucs-set-char #x5698 ?$(HaF(B) ; C02-H-6146
(ucs-set-char #x5699 ?$(D6Z(B) ; J90-D-365A
(ucs-set-char #x5699 ?$(HaK(B) ; C02-H-614B
(ucs-set-char #x5699 ?$@3z(B) ; J78-@-337A
(ucs-set-char #x569A ?$(D6[(B) ; J90-D-365B
(ucs-set-char #x569A ?$(HaI(B) ; C02-H-6149
(ucs-set-char #x569B ?$(IWX(B) ; C03-I-5758
(ucs-set-char #x569C ?$(HaG(B) ; C02-H-6147
(ucs-set-char #x569D ?$(D6\(B) ; J90-D-365C
(ucs-set-char #x569D ?$(HaJ(B) ; C02-H-614A
(ucs-set-char #x569E ?$(D6](B) ; J90-D-365D
(ucs-set-char #x569E ?$(IWY(B) ; C03-I-5759
(ucs-set-char #x569F ?$(D6^(B) ; J90-D-365E
(ucs-set-char #x569F ?$(IWW(B) ; C03-I-5757
(ucs-set-char #x56A0 ?$(IW\(B) ; C03-I-575C
(ucs-set-char #x56A0 ?$@Sh(B) ; J78-@-5368
(ucs-set-char #x56A0 ?$BSh(B) ; J83-B-5368
(ucs-set-char #x56A2 ?$BG9(B) ; J83-B-4739
(ucs-set-char #x56A3 ?$AOy(B) ; GB0-A-4F79
(ucs-set-char #x56A5 ?$(Cf?(B) ; KS0-C-663F
(ucs-set-char #x56A5 ?$(Gx,(B) ; C01-G-782C
(ucs-set-char #x56A5 ?$@Sk(B) ; J78-@-536B
(ucs-set-char #x56A5 ?$BSk(B) ; J83-B-536B
(ucs-set-char #x56A6 ?$(D6_(B) ; J90-D-365F
(ucs-set-char #x56A6 ?$(He>(B) ; C02-H-653E
(ucs-set-char #x56A7 ?$(D6`(B) ; J90-D-3660
(ucs-set-char #x56A7 ?$(He?(B) ; C02-H-653F
(ucs-set-char #x56A8 ?$(D6a(B) ; J90-D-3661
(ucs-set-char #x56A8 ?$(Gx-(B) ; C01-G-782D
(ucs-set-char #x56A9 ?$(D6b(B) ; J90-D-3662
(ucs-set-char #x56A9 ?$(J_M(B) ; C04-J-5F4D
(ucs-set-char #x56AA ?$(He@(B) ; C02-H-6540
(ucs-set-char #x56AB ?$(D6c(B) ; J90-D-3663
(ucs-set-char #x56AB ?$(He<(B) ; C02-H-653C
(ucs-set-char #x56AC ?$(C^-(B) ; KS0-C-5E2D
(ucs-set-char #x56AC ?$(D6d(B) ; J90-D-3664
(ucs-set-char #x56AC ?$(HeA(B) ; C02-H-6541
(ucs-set-char #x56AD ?$(D6e(B) ; J90-D-3665
(ucs-set-char #x56AD ?$(He=(B) ; C02-H-653D
(ucs-set-char #x56AE ?$(Cz?(B) ; KS0-C-7A3F
(ucs-set-char #x56AE ?$(Gv=(B) ; C01-G-763D
(ucs-set-char #x56AE ?$@Sl(B) ; J78-@-536C
(ucs-set-char #x56AE ?$BSl(B) ; J83-B-536C
(ucs-set-char #x56AF ?$(IZ-(B) ; C03-I-5A2D
(ucs-set-char #x56AF ?$A`k(B) ; GB0-A-606B
(ucs-set-char #x56B1 ?$(D6f(B) ; J90-D-3666
(ucs-set-char #x56B1 ?$(Jc1(B) ; C04-J-6331
(ucs-set-char #x56B2 ?$(Hhk(B) ; C02-H-686B
(ucs-set-char #x56B3 ?$(D6g(B) ; J90-D-3667
(ucs-set-char #x56B3 ?$(Hhm(B) ; C02-H-686D
(ucs-set-char #x56B4 ?$(Ceq(B) ; KS0-C-6571
(ucs-set-char #x56B4 ?$(Gyd(B) ; C01-G-7964
(ucs-set-char #x56B4 ?$@Sn(B) ; J78-@-536E
(ucs-set-char #x56B4 ?$BSn(B) ; J83-B-536E
(ucs-set-char #x56B5 ?$(Hhl(B) ; C02-H-686C
(ucs-set-char #x56B6 ?$(Gyc(B) ; C01-G-7963
(ucs-set-char #x56B6 ?$@Sm(B) ; J78-@-536D
(ucs-set-char #x56B6 ?$BSm(B) ; J83-B-536D
(ucs-set-char #x56B7 ?$(D6h(B) ; J90-D-3668
(ucs-set-char #x56B7 ?$(Gyb(B) ; C01-G-7962
(ucs-set-char #x56B7 ?$AHB(B) ; GB0-A-4842
(ucs-set-char #x56BB ?$(I^&(B) ; C03-I-5E26
(ucs-set-char #x56BC ?$(CmD(B) ; KS0-C-6D44
(ucs-set-char #x56BC ?$(Gye(B) ; C01-G-7965
(ucs-set-char #x56BC ?$@Sp(B) ; J78-@-5370
(ucs-set-char #x56BC ?$A=@(B) ; GB0-A-3D40
(ucs-set-char #x56BC ?$BSp(B) ; J83-B-5370
(ucs-set-char #x56BD ?$(HkS(B) ; C02-H-6B53
(ucs-set-char #x56BE ?$(D6i(B) ; J90-D-3669
(ucs-set-char #x56BE ?$(HkT(B) ; C02-H-6B54
(ucs-set-char #x56BF ?$(Jf4(B) ; C04-J-6634
(ucs-set-char #x56C0 ?$(Gze(B) ; C01-G-7A65
(ucs-set-char #x56C0 ?$@Ss(B) ; J78-@-5373
(ucs-set-char #x56C0 ?$BSs(B) ; J83-B-5373
(ucs-set-char #x56C1 ?$(Gzd(B) ; C01-G-7A64
(ucs-set-char #x56C1 ?$@Sq(B) ; J78-@-5371
(ucs-set-char #x56C1 ?$BSq(B) ; J83-B-5371
(ucs-set-char #x56C2 ?$(Gzf(B) ; C01-G-7A66
(ucs-set-char #x56C2 ?$@So(B) ; J78-@-536F
(ucs-set-char #x56C2 ?$BSo(B) ; J83-B-536F
(ucs-set-char #x56C3 ?$(HkR(B) ; C02-H-6B52
(ucs-set-char #x56C3 ?$@Sr(B) ; J78-@-5372
(ucs-set-char #x56C3 ?$BSr(B) ; J83-B-5372
(ucs-set-char #x56C5 ?$(D6j(B) ; J90-D-366A
(ucs-set-char #x56C5 ?$(HmF(B) ; C02-H-6D46
(ucs-set-char #x56C6 ?$(HmE(B) ; C02-H-6D45
(ucs-set-char #x56C7 ?$(I_@(B) ; C03-I-5F40
(ucs-set-char #x56C8 ?$(G{Y(B) ; C01-G-7B59
(ucs-set-char #x56C8 ?$@St(B) ; J78-@-5374
(ucs-set-char #x56C8 ?$BSt(B) ; J83-B-5374
(ucs-set-char #x56C9 ?$(D6k(B) ; J90-D-366B
(ucs-set-char #x56C9 ?$(G{[(B) ; C01-G-7B5B
(ucs-set-char #x56CA ?$(CR%(B) ; KS0-C-5225
(ucs-set-char #x56CA ?$(D6l(B) ; J90-D-366C
(ucs-set-char #x56CA ?$(G{Z(B) ; C01-G-7B5A
(ucs-set-char #x56CA ?$@G9(B) ; J78-@-4739
(ucs-set-char #x56CA ?$ADR(B) ; GB0-A-4452
(ucs-set-char #x56CB ?$(D6m(B) ; J90-D-366D
(ucs-set-char #x56CB ?$(HmG(B) ; C02-H-6D47
(ucs-set-char #x56CC ?$(D6p(B) ; J90-D-3670
(ucs-set-char #x56CC ?$(G|4(B) ; C01-G-7C34
(ucs-set-char #x56CD ?$(C}n(B) ; KS0-C-7D6E
(ucs-set-char #x56CD ?$(D6q(B) ; J90-D-3671
(ucs-set-char #x56CD ?$(Hp4(B) ; C02-H-7034
(ucs-set-char #x56CE ?$@Su(B) ; J78-@-5375
(ucs-set-char #x56CE ?$BSu(B) ; J83-B-5375
(ucs-set-char #x56CF ?$(D6n(B) ; J90-D-366E
(ucs-set-char #x56CF ?$(JjD(B) ; C04-J-6A44
(ucs-set-char #x56D0 ?$(D6o(B) ; J90-D-366F
(ucs-set-char #x56D0 ?$(JjC(B) ; C04-J-6A43
(ucs-set-char #x56D1 ?$(Cu6(B) ; KS0-C-7536
(ucs-set-char #x56D1 ?$(G|](B) ; C01-G-7C5D
(ucs-set-char #x56D1 ?$@Sv(B) ; J78-@-5376
(ucs-set-char #x56D1 ?$BSv(B) ; J83-B-5376
(ucs-set-char #x56D2 ?$(I`q(B) ; C03-I-6071
(ucs-set-char #x56D3 ?$(Hp3(B) ; C02-H-7033
(ucs-set-char #x56D3 ?$@Sw(B) ; J78-@-5377
(ucs-set-char #x56D3 ?$BSw(B) ; J83-B-5377
(ucs-set-char #x56D4 ?$(Hp|(B) ; C02-H-707C
(ucs-set-char #x56D4 ?$A`l(B) ; GB0-A-606C

(ucs-set-char #x56D7 ?$A`m(B) ; GB0-A-606D
(ucs-set-char #x56D7 ?$(H!*(B) ; C02-H-212A
(ucs-set-char #x56D7 ?$@Sx(B) ; J78-@-5378
(ucs-set-char #x56D7 ?$BSx(B) ; J83-B-5378

(ucs-set-char #x56D8 ?$(I!w(B) ; C03-I-2177
(ucs-set-char #x56D8 ?$@QE(B) ; J78-@-5145
(ucs-set-char #x56D8 ?$BQE(B) ; J83-B-5145
(ucs-set-char #x56D9 ?$(D6r(B) ; J90-D-3672
(ucs-set-char #x56D9 ?$(J!o(B) ; C04-J-216F
(ucs-set-char #x56DA ?$(Cav(B) ; KS0-C-6176
(ucs-set-char #x56DA ?$(GF?(B) ; C01-G-463F
(ucs-set-char #x56DA ?$@<|(B) ; J78-@-3C7C
(ucs-set-char #x56DA ?$AGt(B) ; GB0-A-4774
(ucs-set-char #x56DA ?$B<|(B) ; J83-B-3C7C
(ucs-set-char #x56DB ?$(C^L(B) ; KS0-C-5E4C
(ucs-set-char #x56DB ?$(GF>(B) ; C01-G-463E
(ucs-set-char #x56DB ?$@;M(B) ; J78-@-3B4D
(ucs-set-char #x56DB ?$AKD(B) ; GB0-A-4B44
(ucs-set-char #x56DB ?$B;M(B) ; J83-B-3B4D
(ucs-set-char #x56DC ?$(D6s(B) ; J90-D-3673
(ucs-set-char #x56DC ?$(J!m(B) ; C04-J-216D
(ucs-set-char #x56DD ?$(D6t(B) ; J90-D-3674
(ucs-set-char #x56DD ?$(GG`(B) ; C01-G-4760
(ucs-set-char #x56DD ?$A`n(B) ; GB0-A-606E
(ucs-set-char #x56DE ?$(C|^(B) ; KS0-C-7C5E
(ucs-set-char #x56DE ?$(GG_(B) ; C01-G-475F
(ucs-set-char #x56DE ?$@2s(B) ; J78-@-3273
(ucs-set-char #x56DE ?$A;X(B) ; GB0-A-3B58
(ucs-set-char #x56DE ?$B2s(B) ; J83-B-3273
(ucs-set-char #x56DF ?$(D6u(B) ; J90-D-3675
(ucs-set-char #x56DF ?$(H"'(B) ; C02-H-2227
(ucs-set-char #x56DF ?$AX6(B) ; GB0-A-5836
(ucs-set-char #x56E0 ?$(ClW(B) ; KS0-C-6C57
(ucs-set-char #x56E0 ?$(GG^(B) ; C01-G-475E
(ucs-set-char #x56E0 ?$@0x(B) ; J78-@-3078
(ucs-set-char #x56E0 ?$ARr(B) ; GB0-A-5272
(ucs-set-char #x56E0 ?$B0x(B) ; J83-B-3078
(ucs-set-char #x56E1 ?$(D6v(B) ; J90-D-3676
(ucs-set-char #x56E1 ?$(H"&(B) ; C02-H-2226
(ucs-set-char #x56E1 ?$A`o(B) ; GB0-A-606F
(ucs-set-char #x56E2 ?$AME(B) ; GB0-A-4D45
(ucs-set-char #x56E3 ?$(I#>(B) ; C03-I-233E
(ucs-set-char #x56E3 ?$@CD(B) ; J78-@-4344
(ucs-set-char #x56E3 ?$BCD(B) ; J83-B-4344
(ucs-set-char #x56E4 ?$(D6w(B) ; J90-D-3677
(ucs-set-char #x56E4 ?$(GI[(B) ; C01-G-495B
(ucs-set-char #x56E4 ?$A6Z(B) ; GB0-A-365A
(ucs-set-char #x56E5 ?$(D6x(B) ; J90-D-3678
(ucs-set-char #x56E5 ?$(H#I(B) ; C02-H-2349
(ucs-set-char #x56E6 ?$(D6y(B) ; J90-D-3679
(ucs-set-char #x56E6 ?$(I%,(B) ; C03-I-252C
(ucs-set-char #x56E7 ?$(D6z(B) ; J90-D-367A
(ucs-set-char #x56E7 ?$(H#H(B) ; C02-H-2348
(ucs-set-char #x56E8 ?$(D6{(B) ; J90-D-367B
(ucs-set-char #x56E9 ?$(I%&(B) ; C03-I-2526
(ucs-set-char #x56EA ?$(GIY(B) ; C01-G-4959
(ucs-set-char #x56EB ?$(D6}(B) ; J90-D-367D
(ucs-set-char #x56EB ?$(GI\(B) ; C01-G-495C
(ucs-set-char #x56EB ?$A`q(B) ; GB0-A-6071
(ucs-set-char #x56EC ?$(I%+(B) ; C03-I-252B
(ucs-set-char #x56ED ?$(D6~(B) ; J90-D-367E
(ucs-set-char #x56ED ?$(I%*(B) ; C03-I-252A
(ucs-set-char #x56ED ?$AT0(B) ; GB0-A-5430
(ucs-set-char #x56EE ?$(H#G(B) ; C02-H-2347
(ucs-set-char #x56EE ?$@Sy(B) ; J78-@-5379
(ucs-set-char #x56EE ?$BSy(B) ; J83-B-5379
(ucs-set-char #x56EF ?$(I%)(B) ; C03-I-2529
(ucs-set-char #x56F0 ?$(CM](B) ; KS0-C-4D5D
(ucs-set-char #x56F0 ?$(GIZ(B) ; C01-G-495A
(ucs-set-char #x56F0 ?$@:$(B) ; J78-@-3A24
(ucs-set-char #x56F0 ?$A@'(B) ; GB0-A-4027
(ucs-set-char #x56F0 ?$B:$(B) ; J83-B-3A24
(ucs-set-char #x56F1 ?$(D6|(B) ; J90-D-367C
(ucs-set-char #x56F1 ?$(I%H(B) ; C03-I-2548
(ucs-set-char #x56F1 ?$A4Q(B) ; GB0-A-3451
(ucs-set-char #x56F2 ?$(I%'(B) ; C03-I-2527
(ucs-set-char #x56F2 ?$@0O(B) ; J78-@-304F
(ucs-set-char #x56F2 ?$B0O(B) ; J83-B-304F
(ucs-set-char #x56F3 ?$(I%((B) ; C03-I-2528
(ucs-set-char #x56F3 ?$@?^(B) ; J78-@-3F5E
(ucs-set-char #x56F3 ?$B?^(B) ; J83-B-3F5E
(ucs-set-char #x56F4 ?$AN'(B) ; GB0-A-4E27
(ucs-set-char #x56F5 ?$A`p(B) ; GB0-A-6070
(ucs-set-char #x56F6 ?$(D7!(B) ; J90-D-3721
(ucs-set-char #x56F6 ?$(I("(B) ; C03-I-2822
(ucs-set-char #x56F7 ?$(D7"(B) ; J90-D-3722
(ucs-set-char #x56F7 ?$(H%p(B) ; C02-H-2570
(ucs-set-char #x56F8 ?$(I'}(B) ; C03-I-277D
(ucs-set-char #x56F9 ?$(CV7(B) ; KS0-C-5637
(ucs-set-char #x56F9 ?$(H%q(B) ; C02-H-2571
(ucs-set-char #x56F9 ?$@Sz(B) ; J78-@-537A
(ucs-set-char #x56F9 ?$A`r(B) ; GB0-A-6072
(ucs-set-char #x56F9 ?$BSz(B) ; J83-B-537A
(ucs-set-char #x56FA ?$(CM3(B) ; KS0-C-4D33
(ucs-set-char #x56FA ?$(GLV(B) ; C01-G-4C56
(ucs-set-char #x56FA ?$@8G(B) ; J78-@-3847
(ucs-set-char #x56FA ?$A9L(B) ; GB0-A-394C
(ucs-set-char #x56FA ?$B8G(B) ; J83-B-3847
(ucs-set-char #x56FB ?$(I'|(B) ; C03-I-277C
(ucs-set-char #x56FC ?$(I(!(B) ; C03-I-2821
(ucs-set-char #x56FD ?$(I'{(B) ; C03-I-277B
(ucs-set-char #x56FD ?$@9q(B) ; J78-@-3971
(ucs-set-char #x56FD ?$A9z(B) ; GB0-A-397A
(ucs-set-char #x56FD ?$B9q(B) ; J83-B-3971
(ucs-set-char #x56FE ?$AM<(B) ; GB0-A-4D3C
(ucs-set-char #x56FF ?$(GPL(B) ; C01-G-504C
(ucs-set-char #x56FF ?$@S|(B) ; J78-@-537C
(ucs-set-char #x56FF ?$A`s(B) ; GB0-A-6073
(ucs-set-char #x56FF ?$BS|(B) ; J83-B-537C
(ucs-set-char #x5700 ?$(I+e(B) ; C03-I-2B65
(ucs-set-char #x5700 ?$@S{(B) ; J78-@-537B
(ucs-set-char #x5700 ?$BS{(B) ; J83-B-537B
(ucs-set-char #x5701 ?$(D7#(B) ; J90-D-3723
(ucs-set-char #x5701 ?$(H.J(B) ; C02-H-2E4A
(ucs-set-char #x5702 ?$(D7$(B) ; J90-D-3724
(ucs-set-char #x5702 ?$(H.K(B) ; C02-H-2E4B
(ucs-set-char #x5703 ?$(CxU(B) ; KS0-C-7855
(ucs-set-char #x5703 ?$(GTg(B) ; C01-G-5467
(ucs-set-char #x5703 ?$@J`(B) ; J78-@-4A60
(ucs-set-char #x5703 ?$AFT(B) ; GB0-A-4654
(ucs-set-char #x5703 ?$BJ`(B) ; J83-B-4A60
(ucs-set-char #x5704 ?$(CeX(B) ; KS0-C-6558
(ucs-set-char #x5704 ?$(GTh(B) ; C01-G-5468
(ucs-set-char #x5704 ?$@S}(B) ; J78-@-537D
(ucs-set-char #x5704 ?$A`t(B) ; GB0-A-6074
(ucs-set-char #x5704 ?$BS}(B) ; J83-B-537D
(ucs-set-char #x5705 ?$(I0'(B) ; C03-I-3027
(ucs-set-char #x5706 ?$AT2(B) ; GB0-A-5432
(ucs-set-char #x5707 ?$(D7%(B) ; J90-D-3725
(ucs-set-char #x5707 ?$(H4/(B) ; C02-H-342F
(ucs-set-char #x5708 ?$(COj(B) ; KS0-C-4F6A
(ucs-set-char #x5708 ?$(GYN(B) ; C01-G-594E
(ucs-set-char #x5708 ?$@T!(B) ; J78-@-5421
(ucs-set-char #x5708 ?$AH&(B) ; GB0-A-4826
(ucs-set-char #x5708 ?$BT!(B) ; J83-B-5421
(ucs-set-char #x5709 ?$(GYP(B) ; C01-G-5950
(ucs-set-char #x5709 ?$@S~(B) ; J78-@-537E
(ucs-set-char #x5709 ?$A`v(B) ; GB0-A-6076
(ucs-set-char #x5709 ?$BS~(B) ; J83-B-537E
(ucs-set-char #x570A ?$(D7&(B) ; J90-D-3726
(ucs-set-char #x570A ?$(H4.(B) ; C02-H-342E
(ucs-set-char #x570A ?$A`u(B) ; GB0-A-6075
(ucs-set-char #x570B ?$(COP(B) ; KS0-C-4F50
(ucs-set-char #x570B ?$(GYO(B) ; C01-G-594F
(ucs-set-char #x570B ?$@T"(B) ; J78-@-5422
(ucs-set-char #x570B ?$BT"(B) ; J83-B-5422
(ucs-set-char #x570C ?$(D7'(B) ; J90-D-3727
(ucs-set-char #x570C ?$(H:`(B) ; C02-H-3A60
(ucs-set-char #x570D ?$(CjL(B) ; KS0-C-6A4C
(ucs-set-char #x570D ?$(G^X(B) ; C01-G-5E58
(ucs-set-char #x570D ?$@T#(B) ; J78-@-5423
(ucs-set-char #x570D ?$BT#(B) ; J83-B-5423
(ucs-set-char #x570E ?$(I:D(B) ; C03-I-3A44
(ucs-set-char #x570F ?$(I:C(B) ; C03-I-3A43
(ucs-set-char #x570F ?$@7w(B) ; J78-@-3777
(ucs-set-char #x570F ?$B7w(B) ; J83-B-3777
(ucs-set-char #x5710 ?$(J6h(B) ; C04-J-3668
(ucs-set-char #x5711 ?$(D7((B) ; J90-D-3728
(ucs-set-char #x5711 ?$(J<R(B) ; C04-J-3C52
(ucs-set-char #x5712 ?$(Cj.(B) ; KS0-C-6A2E
(ucs-set-char #x5712 ?$(GcP(B) ; C01-G-6350
(ucs-set-char #x5712 ?$@1`(B) ; J78-@-3160
(ucs-set-char #x5712 ?$B1`(B) ; J83-B-3160
(ucs-set-char #x5713 ?$(Cj-(B) ; KS0-C-6A2D
(ucs-set-char #x5713 ?$(GcQ(B) ; C01-G-6351
(ucs-set-char #x5713 ?$@T$(B) ; J78-@-5424
(ucs-set-char #x5713 ?$BT$(B) ; J83-B-5424
(ucs-set-char #x5714 ?$(HB((B) ; C02-H-4228
(ucs-set-char #x5715 ?$(D7)(B) ; J90-D-3729
(ucs-set-char #x5715 ?$(I@R(B) ; C03-I-4052
(ucs-set-char #x5716 ?$(CSq(B) ; KS0-C-5371
(ucs-set-char #x5716 ?$(Gh7(B) ; C01-G-6837
(ucs-set-char #x5716 ?$(L[[(B) ; C06-L-5B5B
(ucs-set-char #x5716 ?$@T&(B) ; J78-@-5426
(ucs-set-char #x5716 ?$BT&(B) ; J83-B-5426
(ucs-set-char #x5717 ?$(IF7(B) ; C03-I-4637
(ucs-set-char #x5718 ?$(CS%(B) ; KS0-C-5325
(ucs-set-char #x5718 ?$(Gh6(B) ; C01-G-6836
(ucs-set-char #x5718 ?$@T%(B) ; J78-@-5425
(ucs-set-char #x5718 ?$BT%(B) ; J83-B-5425
(ucs-set-char #x571A ?$(D7*(B) ; J90-D-372A
(ucs-set-char #x571A ?$(HOp(B) ; C02-H-4F70
(ucs-set-char #x571B ?$(D7+(B) ; J90-D-372B
(ucs-set-char #x571B ?$(HVR(B) ; C02-H-5652
(ucs-set-char #x571C ?$(HVQ(B) ; C02-H-5651
(ucs-set-char #x571C ?$@T((B) ; J78-@-5428
(ucs-set-char #x571C ?$A`w(B) ; GB0-A-6077
(ucs-set-char #x571C ?$BT((B) ; J83-B-5428
(ucs-set-char #x571D ?$(D7,(B) ; J90-D-372C
(ucs-set-char #x571D ?$(I_A(B) ; C03-I-5F41
(ucs-set-char #x571E ?$(HqZ(B) ; C02-H-715A

(ucs-set-char #x571F ?$AMA(B) ; GB0-A-4D41
(ucs-set-char #x571F ?$(CwO(B) ; KS0-C-774F
(ucs-set-char #x571F ?$(GDH(B) ; C01-G-4448
(ucs-set-char #x571F ?$@EZ(B) ; J78-@-455A
(ucs-set-char #x571F ?$BEZ(B) ; J83-B-455A

(ucs-set-char #x5720 ?$(D7-(B) ; J90-D-372D
(ucs-set-char #x5720 ?$(H!9(B) ; C02-H-2139
(ucs-set-char #x5721 ?$(I!a(B) ; C03-I-2161
(ucs-set-char #x5722 ?$(D7.(B) ; J90-D-372E
(ucs-set-char #x5722 ?$(H!O(B) ; C02-H-214F
(ucs-set-char #x5723 ?$(D7/(B) ; J90-D-372F
(ucs-set-char #x5723 ?$(H!P(B) ; C02-H-2150
(ucs-set-char #x5723 ?$AJ%(B) ; GB0-A-4A25
(ucs-set-char #x5724 ?$(D70(B) ; J90-D-3730
(ucs-set-char #x5724 ?$(I"4(B) ; C03-I-2234
(ucs-set-char #x5725 ?$(D71(B) ; J90-D-3731
(ucs-set-char #x5725 ?$(J!p(B) ; C04-J-2170
(ucs-set-char #x5726 ?$@T)(B) ; J78-@-5429
(ucs-set-char #x5726 ?$BT)(B) ; J83-B-5429
(ucs-set-char #x5727 ?$(J!q(B) ; C04-J-2171
(ucs-set-char #x5727 ?$@05(B) ; J78-@-3035
(ucs-set-char #x5727 ?$B05(B) ; J83-B-3035
(ucs-set-char #x5728 ?$(Cn$(B) ; KS0-C-6E24
(ucs-set-char #x5728 ?$(GGc(B) ; C01-G-4763
(ucs-set-char #x5728 ?$@:_(B) ; J78-@-3A5F
(ucs-set-char #x5728 ?$ATZ(B) ; GB0-A-545A
(ucs-set-char #x5728 ?$B:_(B) ; J83-B-3A5F
(ucs-set-char #x5729 ?$(D72(B) ; J90-D-3732
(ucs-set-char #x5729 ?$(GGg(B) ; C01-G-4767
(ucs-set-char #x5729 ?$A[W(B) ; GB0-A-5B57
(ucs-set-char #x572A ?$(D73(B) ; J90-D-3733
(ucs-set-char #x572A ?$(H")(B) ; C02-H-2229
(ucs-set-char #x572A ?$A[Y(B) ; GB0-A-5B59
(ucs-set-char #x572B ?$(J"Q(B) ; C04-J-2251
(ucs-set-char #x572C ?$(D74(B) ; J90-D-3734
(ucs-set-char #x572C ?$(GGe(B) ; C01-G-4765
(ucs-set-char #x572C ?$A[X(B) ; GB0-A-5B58
(ucs-set-char #x572D ?$(CP$(B) ; KS0-C-5024
(ucs-set-char #x572D ?$(GGd(B) ; C01-G-4764
(ucs-set-char #x572D ?$@7=(B) ; J78-@-373D
(ucs-set-char #x572D ?$A9g(B) ; GB0-A-3967
(ucs-set-char #x572D ?$B7=(B) ; J83-B-373D
(ucs-set-char #x572E ?$(D75(B) ; J90-D-3735
(ucs-set-char #x572E ?$(H"((B) ; C02-H-2228
(ucs-set-char #x572E ?$A[\(B) ; GB0-A-5B5C
(ucs-set-char #x572F ?$(D76(B) ; J90-D-3736
(ucs-set-char #x572F ?$(GGf(B) ; C01-G-4766
(ucs-set-char #x572F ?$A[](B) ; GB0-A-5B5D
(ucs-set-char #x5730 ?$(Cr"(B) ; KS0-C-7222
(ucs-set-char #x5730 ?$(GGb(B) ; C01-G-4762
(ucs-set-char #x5730 ?$@CO(B) ; J78-@-434F
(ucs-set-char #x5730 ?$A5X(B) ; GB0-A-3558
(ucs-set-char #x5730 ?$BCO(B) ; J83-B-434F
(ucs-set-char #x5731 ?$(I#A(B) ; C03-I-2341
(ucs-set-char #x5732 ?$(I#B(B) ; C03-I-2342
(ucs-set-char #x5733 ?$(D77(B) ; J90-D-3737
(ucs-set-char #x5733 ?$(GGa(B) ; C01-G-4761
(ucs-set-char #x5733 ?$A[Z(B) ; GB0-A-5B5A
(ucs-set-char #x5734 ?$(D78(B) ; J90-D-3738
(ucs-set-char #x5734 ?$(H"*(B) ; C02-H-222A
(ucs-set-char #x5735 ?$(I#?(B) ; C03-I-233F
(ucs-set-char #x5736 ?$(I#@(B) ; C03-I-2340
(ucs-set-char #x5737 ?$@T*(B) ; J78-@-542A
(ucs-set-char #x5737 ?$BT*(B) ; J83-B-542A
(ucs-set-char #x5738 ?$@T+(B) ; J78-@-542B
(ucs-set-char #x5738 ?$BT+(B) ; J83-B-542B
(ucs-set-char #x5739 ?$A[[(B) ; GB0-A-5B5B
(ucs-set-char #x573A ?$A3!(B) ; GB0-A-3321
(ucs-set-char #x573B ?$(CPp(B) ; KS0-C-5070
(ucs-set-char #x573B ?$(GIf(B) ; C01-G-4966
(ucs-set-char #x573B ?$@T-(B) ; J78-@-542D
(ucs-set-char #x573B ?$A[_(B) ; GB0-A-5B5F
(ucs-set-char #x573B ?$BT-(B) ; J83-B-542D
(ucs-set-char #x573C ?$(I%1(B) ; C03-I-2531
(ucs-set-char #x573D ?$(D79(B) ; J90-D-3739
(ucs-set-char #x573D ?$(I%>(B) ; C03-I-253E
(ucs-set-char #x573E ?$(D7:(B) ; J90-D-373A
(ucs-set-char #x573E ?$(GIc(B) ; C01-G-4963
(ucs-set-char #x573E ?$A;x(B) ; GB0-A-3B78
(ucs-set-char #x573F ?$(D7;(B) ; J90-D-373B
(ucs-set-char #x573F ?$(I%0(B) ; C03-I-2530
(ucs-set-char #x5740 ?$(Cr#(B) ; KS0-C-7223
(ucs-set-char #x5740 ?$(GI_(B) ; C01-G-495F
(ucs-set-char #x5740 ?$@T.(B) ; J78-@-542E
(ucs-set-char #x5740 ?$AV7(B) ; GB0-A-5637
(ucs-set-char #x5740 ?$BT.(B) ; J83-B-542E
(ucs-set-char #x5741 ?$(H#J(B) ; C02-H-234A
(ucs-set-char #x5742 ?$(Cwx(B) ; KS0-C-7778
(ucs-set-char #x5742 ?$(I%@(B) ; C03-I-2540
(ucs-set-char #x5742 ?$@:d(B) ; J78-@-3A64
(ucs-set-char #x5742 ?$A[`(B) ; GB0-A-5B60
(ucs-set-char #x5742 ?$B:d(B) ; J83-B-3A64
(ucs-set-char #x5743 ?$(I%6(B) ; C03-I-2536
(ucs-set-char #x5744 ?$(I%/(B) ; C03-I-252F
(ucs-set-char #x5745 ?$(D7<(B) ; J90-D-373C
(ucs-set-char #x5745 ?$(H#K(B) ; C02-H-234B
(ucs-set-char #x5746 ?$(D7=(B) ; J90-D-373D
(ucs-set-char #x5746 ?$(I%<(B) ; C03-I-253C
(ucs-set-char #x5747 ?$(CP3(B) ; KS0-C-5033
(ucs-set-char #x5747 ?$(GIa(B) ; C01-G-4961
(ucs-set-char #x5747 ?$@6Q(B) ; J78-@-3651
(ucs-set-char #x5747 ?$A>y(B) ; GB0-A-3E79
(ucs-set-char #x5747 ?$B6Q(B) ; J83-B-3651
(ucs-set-char #x5748 ?$(I%-(B) ; C03-I-252D
(ucs-set-char #x5749 ?$(H#M(B) ; C02-H-234D
(ucs-set-char #x574A ?$(C[)(B) ; KS0-C-5B29
(ucs-set-char #x574A ?$(GI](B) ; C01-G-495D
(ucs-set-char #x574A ?$@K7(B) ; J78-@-4B37
(ucs-set-char #x574A ?$A7;(B) ; GB0-A-373B
(ucs-set-char #x574A ?$BK7(B) ; J83-B-4B37
(ucs-set-char #x574B ?$(H#N(B) ; C02-H-234E
(ucs-set-char #x574C ?$(D7>(B) ; J90-D-373E
(ucs-set-char #x574C ?$(H#L(B) ; C02-H-234C
(ucs-set-char #x574C ?$A[P(B) ; GB0-A-5B50
(ucs-set-char #x574D ?$(CS;(B) ; KS0-C-533B
(ucs-set-char #x574D ?$(D7?(B) ; J90-D-373F
(ucs-set-char #x574D ?$(GI`(B) ; C01-G-4960
(ucs-set-char #x574D ?$AL.(B) ; GB0-A-4C2E
(ucs-set-char #x574E ?$(CJl(B) ; KS0-C-4A6C
(ucs-set-char #x574E ?$(GIb(B) ; C01-G-4962
(ucs-set-char #x574E ?$@T,(B) ; J78-@-542C
(ucs-set-char #x574E ?$A?2(B) ; GB0-A-3F32
(ucs-set-char #x574E ?$BT,(B) ; J83-B-542C
(ucs-set-char #x574F ?$(GIe(B) ; C01-G-4965
(ucs-set-char #x574F ?$@T/(B) ; J78-@-542F
(ucs-set-char #x574F ?$A;5(B) ; GB0-A-3B35
(ucs-set-char #x574F ?$BT/(B) ; J83-B-542F
(ucs-set-char #x5750 ?$(Cq&(B) ; KS0-C-7126
(ucs-set-char #x5750 ?$(GId(B) ; C01-G-4964
(ucs-set-char #x5750 ?$@:A(B) ; J78-@-3A41
(ucs-set-char #x5750 ?$AWx(B) ; GB0-A-5778
(ucs-set-char #x5750 ?$B:A(B) ; J83-B-3A41
(ucs-set-char #x5751 ?$(CKU(B) ; KS0-C-4B55
(ucs-set-char #x5751 ?$(GI^(B) ; C01-G-495E
(ucs-set-char #x5751 ?$@9#(B) ; J78-@-3923
(ucs-set-char #x5751 ?$A?S(B) ; GB0-A-3F53
(ucs-set-char #x5751 ?$B9#(B) ; J83-B-3923
(ucs-set-char #x5752 ?$(D7@(B) ; J90-D-3740
(ucs-set-char #x5752 ?$(H#O(B) ; C02-H-234F
(ucs-set-char #x5753 ?$(I%2(B) ; C03-I-2532
(ucs-set-char #x5754 ?$(I%A(B) ; C03-I-2541
(ucs-set-char #x5755 ?$(I%B(B) ; C03-I-2542
(ucs-set-char #x5756 ?$(I%3(B) ; C03-I-2533
(ucs-set-char #x5757 ?$(I%8(B) ; C03-I-2538
(ucs-set-char #x5757 ?$A?i(B) ; GB0-A-3F69
(ucs-set-char #x5758 ?$(I%7(B) ; C03-I-2537
(ucs-set-char #x5759 ?$(J#a(B) ; C04-J-2361
(ucs-set-char #x575A ?$(L&g(B) ; C06-L-2667
(ucs-set-char #x575A ?$A<a(B) ; GB0-A-3C61
(ucs-set-char #x575B ?$AL3(B) ; GB0-A-4C33
(ucs-set-char #x575C ?$A[^(B) ; GB0-A-5B5E
(ucs-set-char #x575D ?$A0S(B) ; GB0-A-3053
(ucs-set-char #x575E ?$ANk(B) ; GB0-A-4E6B
(ucs-set-char #x575F ?$(I%5(B) ; C03-I-2535
(ucs-set-char #x575F ?$A7X(B) ; GB0-A-3758
(ucs-set-char #x5760 ?$AW9(B) ; GB0-A-5739
(ucs-set-char #x5761 ?$(Cwg(B) ; KS0-C-7767
(ucs-set-char #x5761 ?$(GL[(B) ; C01-G-4C5B
(ucs-set-char #x5761 ?$@T3(B) ; J78-@-5433
(ucs-set-char #x5761 ?$AFB(B) ; GB0-A-4642
(ucs-set-char #x5761 ?$BT3(B) ; J83-B-5433
(ucs-set-char #x5762 ?$(D7A(B) ; J90-D-3741
(ucs-set-char #x5762 ?$(H%~(B) ; C02-H-257E
(ucs-set-char #x5763 ?$(I(%(B) ; C03-I-2825
(ucs-set-char #x5764 ?$(CM^(B) ; KS0-C-4D5E
(ucs-set-char #x5764 ?$(GL](B) ; C01-G-4C5D
(ucs-set-char #x5764 ?$@:%(B) ; J78-@-3A25
(ucs-set-char #x5764 ?$A@$(B) ; GB0-A-4024
(ucs-set-char #x5764 ?$B:%(B) ; J83-B-3A25
(ucs-set-char #x5765 ?$(D7B(B) ; J90-D-3742
(ucs-set-char #x5765 ?$(I(#(B) ; C03-I-2823
(ucs-set-char #x5766 ?$(Cw$(B) ; KS0-C-7724
(ucs-set-char #x5766 ?$(GL\(B) ; C01-G-4C5C
(ucs-set-char #x5766 ?$@C3(B) ; J78-@-4333
(ucs-set-char #x5766 ?$AL9(B) ; GB0-A-4C39
(ucs-set-char #x5766 ?$BC3(B) ; J83-B-4333
(ucs-set-char #x5767 ?$(D7C(B) ; J90-D-3743
(ucs-set-char #x5767 ?$(I(&(B) ; C03-I-2826
(ucs-set-char #x5768 ?$(D7D(B) ; J90-D-3744
(ucs-set-char #x5768 ?$(H&!(B) ; C02-H-2621
(ucs-set-char #x5768 ?$A[g(B) ; GB0-A-5B67
(ucs-set-char #x5769 ?$(GLZ(B) ; C01-G-4C5A
(ucs-set-char #x5769 ?$@T0(B) ; J78-@-5430
(ucs-set-char #x5769 ?$A[a(B) ; GB0-A-5B61
(ucs-set-char #x5769 ?$BT0(B) ; J83-B-5430
(ucs-set-char #x576A ?$(Cx@(B) ; KS0-C-7840
(ucs-set-char #x576A ?$(GLY(B) ; C01-G-4C59
(ucs-set-char #x576A ?$@DZ(B) ; J78-@-445A
(ucs-set-char #x576A ?$AF:(B) ; GB0-A-463A
(ucs-set-char #x576A ?$BDZ(B) ; J83-B-445A
(ucs-set-char #x576B ?$(D7E(B) ; J90-D-3745
(ucs-set-char #x576B ?$(H%u(B) ; C02-H-2575
(ucs-set-char #x576B ?$A[c(B) ; GB0-A-5B63
(ucs-set-char #x576C ?$(J%i(B) ; C04-J-2569
(ucs-set-char #x576D ?$(D7F(B) ; J90-D-3746
(ucs-set-char #x576D ?$(H%t(B) ; C02-H-2574
(ucs-set-char #x576D ?$A[h(B) ; GB0-A-5B68
(ucs-set-char #x576E ?$(CS](B) ; KS0-C-535D
(ucs-set-char #x576E ?$(D7G(B) ; J90-D-3747
(ucs-set-char #x576E ?$(I(((B) ; C03-I-2828
(ucs-set-char #x576F ?$(D7H(B) ; J90-D-3748
(ucs-set-char #x576F ?$(H%r(B) ; C02-H-2572
(ucs-set-char #x576F ?$AEw(B) ; GB0-A-4577
(ucs-set-char #x5770 ?$(CLP(B) ; KS0-C-4C50
(ucs-set-char #x5770 ?$(D7I(B) ; J90-D-3749
(ucs-set-char #x5770 ?$(H%w(B) ; C02-H-2577
(ucs-set-char #x5771 ?$(D7J(B) ; J90-D-374A
(ucs-set-char #x5771 ?$(H%v(B) ; C02-H-2576
(ucs-set-char #x5772 ?$(H%s(B) ; C02-H-2573
(ucs-set-char #x5773 ?$(D7K(B) ; J90-D-374B
(ucs-set-char #x5773 ?$(H%|(B) ; C02-H-257C
(ucs-set-char #x5773 ?$A[j(B) ; GB0-A-5B6A
(ucs-set-char #x5774 ?$(D7L(B) ; J90-D-374C
(ucs-set-char #x5774 ?$(H%}(B) ; C02-H-257D
(ucs-set-char #x5775 ?$(CO&(B) ; KS0-C-4F26
(ucs-set-char #x5775 ?$(D7M(B) ; J90-D-374D
(ucs-set-char #x5775 ?$(H%z(B) ; C02-H-257A
(ucs-set-char #x5776 ?$(H%x(B) ; C02-H-2578
(ucs-set-char #x5776 ?$A[i(B) ; GB0-A-5B69
(ucs-set-char #x5777 ?$(D7N(B) ; J90-D-374E
(ucs-set-char #x5777 ?$(GLX(B) ; C01-G-4C58
(ucs-set-char #x5777 ?$A?@(B) ; GB0-A-3F40
(ucs-set-char #x5778 ?$(I()(B) ; C03-I-2829
(ucs-set-char #x5779 ?$(D7O(B) ; J90-D-374F
(ucs-set-char #x5779 ?$(J%f(B) ; C04-J-2566
(ucs-set-char #x577A ?$(D7P(B) ; J90-D-3750
(ucs-set-char #x577A ?$(J%h(B) ; C04-J-2568
(ucs-set-char #x577B ?$(D7Q(B) ; J90-D-3751
(ucs-set-char #x577B ?$(H%{(B) ; C02-H-257B
(ucs-set-char #x577B ?$A[f(B) ; GB0-A-5B66
(ucs-set-char #x577C ?$(Cvs(B) ; KS0-C-7673
(ucs-set-char #x577C ?$(D7R(B) ; J90-D-3752
(ucs-set-char #x577C ?$(GL^(B) ; C01-G-4C5E
(ucs-set-char #x577C ?$A[e(B) ; GB0-A-5B65
(ucs-set-char #x577D ?$(H&"(B) ; C02-H-2622
(ucs-set-char #x577E ?$(D7S(B) ; J90-D-3753
(ucs-set-char #x577E ?$(J%e(B) ; C04-J-2565
(ucs-set-char #x577F ?$(I(*(B) ; C03-I-282A
(ucs-set-char #x577F ?$@T4(B) ; J78-@-5434
(ucs-set-char #x577F ?$BT4(B) ; J83-B-5434
(ucs-set-char #x5780 ?$(H%y(B) ; C02-H-2579
(ucs-set-char #x5781 ?$(D7T(B) ; J90-D-3754
(ucs-set-char #x5781 ?$(I($(B) ; C03-I-2824
(ucs-set-char #x5782 ?$(Caw(B) ; KS0-C-6177
(ucs-set-char #x5782 ?$(GPM(B) ; C01-G-504D
(ucs-set-char #x5782 ?$@?b(B) ; J78-@-3F62
(ucs-set-char #x5782 ?$A49(B) ; GB0-A-3439
(ucs-set-char #x5782 ?$B?b(B) ; J83-B-3F62
(ucs-set-char #x5783 ?$(D7U(B) ; J90-D-3755
(ucs-set-char #x5783 ?$(GLW(B) ; C01-G-4C57
(ucs-set-char #x5783 ?$A@,(B) ; GB0-A-402C
(ucs-set-char #x5784 ?$AB"(B) ; GB0-A-4222
(ucs-set-char #x5785 ?$A[b(B) ; GB0-A-5B62
(ucs-set-char #x5786 ?$A[d(B) ; GB0-A-5B64
(ucs-set-char #x5787 ?$(J%n(B) ; C04-J-256E
(ucs-set-char #x5788 ?$(CS\(B) ; KS0-C-535C
(ucs-set-char #x5788 ?$@T2(B) ; J78-@-5432
(ucs-set-char #x5788 ?$BT2(B) ; J83-B-5432
(ucs-set-char #x5789 ?$@T5(B) ; J78-@-5435
(ucs-set-char #x5789 ?$BT5(B) ; J83-B-5435
(ucs-set-char #x578B ?$(Cz~(B) ; KS0-C-7A7E
(ucs-set-char #x578B ?$(GPN(B) ; C01-G-504E
(ucs-set-char #x578B ?$(I4p(B) ; C03-I-3470
(ucs-set-char #x578B ?$@7?(B) ; J78-@-373F
(ucs-set-char #x578B ?$APM(B) ; GB0-A-504D
(ucs-set-char #x578B ?$B7?(B) ; J83-B-373F
(ucs-set-char #x578C ?$(D7V(B) ; J90-D-3756
(ucs-set-char #x578C ?$(H)U(B) ; C02-H-2955
(ucs-set-char #x578C ?$A[m(B) ; GB0-A-5B6D
(ucs-set-char #x578D ?$(I+i(B) ; C03-I-2B69
(ucs-set-char #x578E ?$(I+h(B) ; C03-I-2B68
(ucs-set-char #x578F ?$(H)[(B) ; C02-H-295B
(ucs-set-char #x5790 ?$(I+l(B) ; C03-I-2B6C
(ucs-set-char #x5791 ?$(I+g(B) ; C03-I-2B67
(ucs-set-char #x5792 ?$(I+j(B) ; C03-I-2B6A
(ucs-set-char #x5792 ?$A@](B) ; GB0-A-405D
(ucs-set-char #x5793 ?$(Cz'(B) ; KS0-C-7A27
(ucs-set-char #x5793 ?$(GPT(B) ; C01-G-5054
(ucs-set-char #x5793 ?$@T6(B) ; J78-@-5436
(ucs-set-char #x5793 ?$A[r(B) ; GB0-A-5B72
(ucs-set-char #x5793 ?$BT6(B) ; J83-B-5436
(ucs-set-char #x5794 ?$(D7W(B) ; J90-D-3757
(ucs-set-char #x5794 ?$(H)Y(B) ; C02-H-2959
(ucs-set-char #x5795 ?$(D7`(B) ; J90-D-3760
(ucs-set-char #x5795 ?$(H)_(B) ; C02-H-295F
(ucs-set-char #x5796 ?$(I+q(B) ; C03-I-2B71
(ucs-set-char #x5797 ?$(D7X(B) ; J90-D-3758
(ucs-set-char #x5797 ?$(H)V(B) ; C02-H-2956
(ucs-set-char #x5798 ?$(H)Z(B) ; C02-H-295A
(ucs-set-char #x5799 ?$(D7Y(B) ; J90-D-3759
(ucs-set-char #x5799 ?$(H)\(B) ; C02-H-295C
(ucs-set-char #x579A ?$(D7Z(B) ; J90-D-375A
(ucs-set-char #x579A ?$(H)^(B) ; C02-H-295E
(ucs-set-char #x579B ?$(H)X(B) ; C02-H-2958
(ucs-set-char #x579B ?$A6b(B) ; GB0-A-3662
(ucs-set-char #x579C ?$(D7[(B) ; J90-D-375B
(ucs-set-char #x579C ?$(I+p(B) ; C03-I-2B70
(ucs-set-char #x579D ?$(D7\(B) ; J90-D-375C
(ucs-set-char #x579D ?$(H)W(B) ; C02-H-2957
(ucs-set-char #x579E ?$(D7](B) ; J90-D-375D
(ucs-set-char #x579E ?$(H)R(B) ; C02-H-2952
(ucs-set-char #x579F ?$(D7^(B) ; J90-D-375E
(ucs-set-char #x579F ?$(H)S(B) ; C02-H-2953
(ucs-set-char #x57A0 ?$(CkY(B) ; KS0-C-6B59
(ucs-set-char #x57A0 ?$(GPO(B) ; C01-G-504F
(ucs-set-char #x57A0 ?$@T7(B) ; J78-@-5437
(ucs-set-char #x57A0 ?$A[s(B) ; GB0-A-5B73
(ucs-set-char #x57A0 ?$BT7(B) ; J83-B-5437
(ucs-set-char #x57A1 ?$(D7_(B) ; J90-D-375F
(ucs-set-char #x57A1 ?$(I+k(B) ; C03-I-2B6B
(ucs-set-char #x57A1 ?$A[R(B) ; GB0-A-5B52
(ucs-set-char #x57A2 ?$(CO'(B) ; KS0-C-4F27
(ucs-set-char #x57A2 ?$(GPQ(B) ; C01-G-5051
(ucs-set-char #x57A2 ?$@9$(B) ; J78-@-3924
(ucs-set-char #x57A2 ?$A98(B) ; GB0-A-3938
(ucs-set-char #x57A2 ?$B9$(B) ; J83-B-3924
(ucs-set-char #x57A3 ?$(Cj/(B) ; KS0-C-6A2F
(ucs-set-char #x57A3 ?$(GPP(B) ; C01-G-5050
(ucs-set-char #x57A3 ?$@3@(B) ; J78-@-3340
(ucs-set-char #x57A3 ?$AT+(B) ; GB0-A-542B
(ucs-set-char #x57A3 ?$B3@(B) ; J83-B-3340
(ucs-set-char #x57A4 ?$(H)T(B) ; C02-H-2954
(ucs-set-char #x57A4 ?$@T9(B) ; J78-@-5439
(ucs-set-char #x57A4 ?$A[l(B) ; GB0-A-5B6C
(ucs-set-char #x57A4 ?$BT9(B) ; J83-B-5439
(ucs-set-char #x57A5 ?$(H)](B) ; C02-H-295D
(ucs-set-char #x57A6 ?$(I+m(B) ; C03-I-2B6D
(ucs-set-char #x57A6 ?$A?Q(B) ; GB0-A-3F51
(ucs-set-char #x57A7 ?$(D7a(B) ; J90-D-3761
(ucs-set-char #x57A7 ?$(I+r(B) ; C03-I-2B72
(ucs-set-char #x57A7 ?$A[p(B) ; GB0-A-5B70
(ucs-set-char #x57A8 ?$(D7b(B) ; J90-D-3762
(ucs-set-char #x57A8 ?$(I+n(B) ; C03-I-2B6E
(ucs-set-char #x57A9 ?$(D7c(B) ; J90-D-3763
(ucs-set-char #x57A9 ?$(J(`(B) ; C04-J-2860
(ucs-set-char #x57A9 ?$A[Q(B) ; GB0-A-5B51
(ucs-set-char #x57AA ?$@T:(B) ; J78-@-543A
(ucs-set-char #x57AA ?$BT:(B) ; J83-B-543A
(ucs-set-char #x57AB ?$A5f(B) ; GB0-A-3566
(ucs-set-char #x57AC ?$(D7d(B) ; J90-D-3764
(ucs-set-char #x57AC ?$(I+f(B) ; C03-I-2B66
(ucs-set-char #x57AD ?$A[k(B) ; GB0-A-5B6B
(ucs-set-char #x57AE ?$(GPS(B) ; C01-G-5053
(ucs-set-char #x57AE ?$A?e(B) ; GB0-A-3F65
(ucs-set-char #x57B0 ?$@T;(B) ; J78-@-543B
(ucs-set-char #x57B0 ?$BT;(B) ; J83-B-543B
(ucs-set-char #x57B2 ?$A[n(B) ; GB0-A-5B6E
(ucs-set-char #x57B3 ?$@T8(B) ; J78-@-5438
(ucs-set-char #x57B3 ?$BT8(B) ; J83-B-5438
(ucs-set-char #x57B4 ?$(J(^(B) ; C04-J-285E
(ucs-set-char #x57B4 ?$A[q(B) ; GB0-A-5B71
(ucs-set-char #x57B5 ?$(H)Q(B) ; C02-H-2951
(ucs-set-char #x57B6 ?$(H.U(B) ; C02-H-2E55
(ucs-set-char #x57B7 ?$(I0*(B) ; C03-I-302A
(ucs-set-char #x57B8 ?$(D7e(B) ; J90-D-3765
(ucs-set-char #x57B8 ?$(H.T(B) ; C02-H-2E54
(ucs-set-char #x57B8 ?$A[y(B) ; GB0-A-5B79
(ucs-set-char #x57B9 ?$(H.Y(B) ; C02-H-2E59
(ucs-set-char #x57BA ?$(H.P(B) ; C02-H-2E50
(ucs-set-char #x57BB ?$(I00(B) ; C03-I-3030
(ucs-set-char #x57BC ?$(H.S(B) ; C02-H-2E53
(ucs-set-char #x57BD ?$(D7f(B) ; J90-D-3766
(ucs-set-char #x57BD ?$(H.R(B) ; C02-H-2E52
(ucs-set-char #x57BE ?$(I0/(B) ; C03-I-302F
(ucs-set-char #x57BF ?$(H.V(B) ; C02-H-2E56
(ucs-set-char #x57C0 ?$(I08(B) ; C03-I-3038
(ucs-set-char #x57C0 ?$@T1(B) ; J78-@-5431
(ucs-set-char #x57C0 ?$BT1(B) ; J83-B-5431
(ucs-set-char #x57C1 ?$(H.Z(B) ; C02-H-2E5A
(ucs-set-char #x57C2 ?$(GTi(B) ; C01-G-5469
(ucs-set-char #x57C2 ?$A9!(B) ; GB0-A-3921
(ucs-set-char #x57C3 ?$(Cdo(B) ; KS0-C-646F
(ucs-set-char #x57C3 ?$(GTl(B) ; C01-G-546C
(ucs-set-char #x57C3 ?$@T<(B) ; J78-@-543C
(ucs-set-char #x57C3 ?$A0#(B) ; GB0-A-3023
(ucs-set-char #x57C3 ?$BT<(B) ; J83-B-543C
(ucs-set-char #x57C4 ?$(I04(B) ; C03-I-3034
(ucs-set-char #x57C5 ?$(I05(B) ; C03-I-3035
(ucs-set-char #x57C6 ?$(H.Q(B) ; C02-H-2E51
(ucs-set-char #x57C6 ?$@T=(B) ; J78-@-543D
(ucs-set-char #x57C6 ?$BT=(B) ; J83-B-543D
(ucs-set-char #x57C7 ?$(Ci9(B) ; KS0-C-6939
(ucs-set-char #x57C7 ?$(D7g(B) ; J90-D-3767
(ucs-set-char #x57C7 ?$(H.W(B) ; C02-H-2E57
(ucs-set-char #x57C8 ?$(CqX(B) ; KS0-C-7158
(ucs-set-char #x57C8 ?$(D7h(B) ; J90-D-3768
(ucs-set-char #x57C8 ?$(I03(B) ; C03-I-3033
(ucs-set-char #x57C9 ?$(I0((B) ; C03-I-3028
(ucs-set-char #x57CA ?$(I07(B) ; C03-I-3037
(ucs-set-char #x57CB ?$(CXX(B) ; KS0-C-5858
(ucs-set-char #x57CB ?$(GTk(B) ; C01-G-546B
(ucs-set-char #x57CB ?$@Kd(B) ; J78-@-4B64
(ucs-set-char #x57CB ?$ABq(B) ; GB0-A-4271
(ucs-set-char #x57CB ?$BKd(B) ; J83-B-4B64
(ucs-set-char #x57CC ?$(D7i(B) ; J90-D-3769
(ucs-set-char #x57CC ?$(H.L(B) ; C02-H-2E4C
(ucs-set-char #x57CD ?$(I0+(B) ; C03-I-302B
(ucs-set-char #x57CE ?$(C`r(B) ; KS0-C-6072
(ucs-set-char #x57CE ?$(GPR(B) ; C01-G-5052
(ucs-set-char #x57CE ?$(L65(B) ; C06-L-3635
(ucs-set-char #x57CE ?$@>k(B) ; J78-@-3E6B
(ucs-set-char #x57CE ?$A3G(B) ; GB0-A-3347
(ucs-set-char #x57CE ?$B>k(B) ; J83-B-3E6B
(ucs-set-char #x57CF ?$(D7j(B) ; J90-D-376A
(ucs-set-char #x57CF ?$(H4=(B) ; C02-H-343D
(ucs-set-char #x57CF ?$A[o(B) ; GB0-A-5B6F
(ucs-set-char #x57D0 ?$(H.X(B) ; C02-H-2E58
(ucs-set-char #x57D1 ?$(I06(B) ; C03-I-3036
(ucs-set-char #x57D2 ?$(H.O(B) ; C02-H-2E4F
(ucs-set-char #x57D2 ?$@T?(B) ; J78-@-543F
(ucs-set-char #x57D2 ?$A[x(B) ; GB0-A-5B78
(ucs-set-char #x57D2 ?$BT?(B) ; J83-B-543F
(ucs-set-char #x57D3 ?$(J,3(B) ; C04-J-2C33
(ucs-set-char #x57D3 ?$@T@(B) ; J78-@-5440
(ucs-set-char #x57D3 ?$BT@(B) ; J83-B-5440
(ucs-set-char #x57D4 ?$(GTj(B) ; C01-G-546A
(ucs-set-char #x57D4 ?$@T>(B) ; J78-@-543E
(ucs-set-char #x57D4 ?$AFR(B) ; GB0-A-4652
(ucs-set-char #x57D4 ?$BT>(B) ; J83-B-543E
(ucs-set-char #x57D5 ?$(D7k(B) ; J90-D-376B
(ucs-set-char #x57D5 ?$(H.N(B) ; C02-H-2E4E
(ucs-set-char #x57D5 ?$A[t(B) ; GB0-A-5B74
(ucs-set-char #x57D6 ?$@TB(B) ; J78-@-5442
(ucs-set-char #x57D6 ?$BTB(B) ; J83-B-5442
(ucs-set-char #x57D8 ?$A[u(B) ; GB0-A-5B75
(ucs-set-char #x57D9 ?$A[w(B) ; GB0-A-5B77
(ucs-set-char #x57DA ?$A[v(B) ; GB0-A-5B76
(ucs-set-char #x57DB ?$(I02(B) ; C03-I-3032
(ucs-set-char #x57DC ?$(H44(B) ; C02-H-3434
(ucs-set-char #x57DC ?$@G8(B) ; J78-@-4738
(ucs-set-char #x57DC ?$BG8(B) ; J83-B-4738
(ucs-set-char #x57DD ?$(D7l(B) ; J90-D-376C
(ucs-set-char #x57DD ?$(I4n(B) ; C03-I-346E
(ucs-set-char #x57DD ?$A[~(B) ; GB0-A-5B7E
(ucs-set-char #x57DE ?$(D7m(B) ; J90-D-376D
(ucs-set-char #x57DE ?$(I4q(B) ; C03-I-3471
(ucs-set-char #x57DF ?$(Cf4(B) ; KS0-C-6634
(ucs-set-char #x57DF ?$(GYQ(B) ; C01-G-5951
(ucs-set-char #x57DF ?$@0h(B) ; J78-@-3068
(ucs-set-char #x57DF ?$ASr(B) ; GB0-A-5372
(ucs-set-char #x57DF ?$B0h(B) ; J83-B-3068
(ucs-set-char #x57E0 ?$(C\|(B) ; KS0-C-5C7C
(ucs-set-char #x57E0 ?$(GYU(B) ; C01-G-5955
(ucs-set-char #x57E0 ?$@IV(B) ; J78-@-4956
(ucs-set-char #x57E0 ?$A2:(B) ; GB0-A-323A
(ucs-set-char #x57E0 ?$BIV(B) ; J83-B-4956
(ucs-set-char #x57E1 ?$(D7~(B) ; J90-D-377E
(ucs-set-char #x57E1 ?$(H4D(B) ; C02-H-3444
(ucs-set-char #x57E2 ?$(H42(B) ; C02-H-3432
(ucs-set-char #x57E3 ?$(H4@(B) ; C02-H-3440
(ucs-set-char #x57E3 ?$@TC(B) ; J78-@-5443
(ucs-set-char #x57E3 ?$BTC(B) ; J83-B-5443
(ucs-set-char #x57E4 ?$(D7n(B) ; J90-D-376E
(ucs-set-char #x57E4 ?$(GYV(B) ; C01-G-5956
(ucs-set-char #x57E4 ?$A[}(B) ; GB0-A-5B7D
(ucs-set-char #x57E5 ?$(H4B(B) ; C02-H-3442
(ucs-set-char #x57E6 ?$(D7o(B) ; J90-D-376F
(ucs-set-char #x57E6 ?$(I4r(B) ; C03-I-3472
(ucs-set-char #x57E7 ?$(D7p(B) ; J90-D-3770
(ucs-set-char #x57E7 ?$(H4H(B) ; C02-H-3448
(ucs-set-char #x57E8 ?$(I4t(B) ; C03-I-3474
(ucs-set-char #x57E9 ?$(D7q(B) ; J90-D-3771
(ucs-set-char #x57E9 ?$(H4L(B) ; C02-H-344C
(ucs-set-char #x57EA ?$(I4i(B) ; C03-I-3469
(ucs-set-char #x57EB ?$(J0{(B) ; C04-J-307B
(ucs-set-char #x57EC ?$(H4C(B) ; C02-H-3443
(ucs-set-char #x57ED ?$(D7r(B) ; J90-D-3772
(ucs-set-char #x57ED ?$(H47(B) ; C02-H-3437
(ucs-set-char #x57ED ?$A\$(B) ; GB0-A-5C24
(ucs-set-char #x57EE ?$(H4?(B) ; C02-H-343F
(ucs-set-char #x57EF ?$(I4k(B) ; C03-I-346B
(ucs-set-char #x57EF ?$A[{(B) ; GB0-A-5B7B
(ucs-set-char #x57F0 ?$(Csq(B) ; KS0-C-7371
(ucs-set-char #x57F0 ?$(D7s(B) ; J90-D-3773
(ucs-set-char #x57F0 ?$(H4M(B) ; C02-H-344D
(ucs-set-char #x57F1 ?$(H4K(B) ; C02-H-344B
(ucs-set-char #x57F2 ?$(H4A(B) ; C02-H-3441
(ucs-set-char #x57F3 ?$(H4<(B) ; C02-H-343C
(ucs-set-char #x57F4 ?$(CcP(B) ; KS0-C-6350
(ucs-set-char #x57F4 ?$(H45(B) ; C02-H-3435
(ucs-set-char #x57F4 ?$@>}(B) ; J78-@-3E7D
(ucs-set-char #x57F4 ?$A[z(B) ; GB0-A-5B7A
(ucs-set-char #x57F4 ?$B>}(B) ; J83-B-3E7D
(ucs-set-char #x57F5 ?$(D7t(B) ; J90-D-3774
(ucs-set-char #x57F5 ?$(H:h(B) ; C02-H-3A68
(ucs-set-char #x57F6 ?$(D7u(B) ; J90-D-3775
(ucs-set-char #x57F6 ?$(H43(B) ; C02-H-3433
(ucs-set-char #x57F7 ?$(Cr{(B) ; KS0-C-727B
(ucs-set-char #x57F7 ?$(GYZ(B) ; C01-G-595A
(ucs-set-char #x57F7 ?$@<9(B) ; J78-@-3C39
(ucs-set-char #x57F7 ?$B<9(B) ; J83-B-3C39
(ucs-set-char #x57F8 ?$(D7v(B) ; J90-D-3776
(ucs-set-char #x57F8 ?$(H4:(B) ; C02-H-343A
(ucs-set-char #x57F8 ?$A[|(B) ; GB0-A-5B7C
(ucs-set-char #x57F9 ?$(C[F(B) ; KS0-C-5B46
(ucs-set-char #x57F9 ?$(GY[(B) ; C01-G-595B
(ucs-set-char #x57F9 ?$@G](B) ; J78-@-475D
(ucs-set-char #x57F9 ?$AE`(B) ; GB0-A-4560
(ucs-set-char #x57F9 ?$BG](B) ; J83-B-475D
(ucs-set-char #x57FA ?$(CPq(B) ; KS0-C-5071
(ucs-set-char #x57FA ?$(GYW(B) ; C01-G-5957
(ucs-set-char #x57FA ?$@4p(B) ; J78-@-3470
(ucs-set-char #x57FA ?$A;y(B) ; GB0-A-3B79
(ucs-set-char #x57FA ?$B4p(B) ; J83-B-3470
(ucs-set-char #x57FB ?$(H40(B) ; C02-H-3430
(ucs-set-char #x57FC ?$(CPr(B) ; KS0-C-5072
(ucs-set-char #x57FC ?$(H4F(B) ; C02-H-3446
(ucs-set-char #x57FC ?$@:k(B) ; J78-@-3A6B
(ucs-set-char #x57FC ?$B:k(B) ; J83-B-3A6B
(ucs-set-char #x57FD ?$(D7w(B) ; J90-D-3777
(ucs-set-char #x57FD ?$(H48(B) ; C02-H-3438
(ucs-set-char #x57FD ?$A\#(B) ; GB0-A-5C23
(ucs-set-char #x57FE ?$(D7x(B) ; J90-D-3778
(ucs-set-char #x57FE ?$(I4o(B) ; C03-I-346F
(ucs-set-char #x57FF ?$(D7y(B) ; J90-D-3779
(ucs-set-char #x57FF ?$(I4u(B) ; C03-I-3475
(ucs-set-char #x5800 ?$(CO\(B) ; KS0-C-4F5C
(ucs-set-char #x5800 ?$(H46(B) ; C02-H-3436
(ucs-set-char #x5800 ?$@KY(B) ; J78-@-4B59
(ucs-set-char #x5800 ?$A\%(B) ; GB0-A-5C25
(ucs-set-char #x5800 ?$BKY(B) ; J83-B-4B59
(ucs-set-char #x5801 ?$(H4I(B) ; C02-H-3449
(ucs-set-char #x5802 ?$(CSQ(B) ; KS0-C-5351
(ucs-set-char #x5802 ?$(GYX(B) ; C01-G-5958
(ucs-set-char #x5802 ?$@F2(B) ; J78-@-4632
(ucs-set-char #x5802 ?$ALC(B) ; GB0-A-4C43
(ucs-set-char #x5802 ?$BF2(B) ; J83-B-4632
(ucs-set-char #x5803 ?$(D7z(B) ; J90-D-377A
(ucs-set-char #x5803 ?$(I4v(B) ; C03-I-3476
(ucs-set-char #x5804 ?$(D7{(B) ; J90-D-377B
(ucs-set-char #x5804 ?$(H4O(B) ; C02-H-344F
(ucs-set-char #x5805 ?$(CL1(B) ; KS0-C-4C31
(ucs-set-char #x5805 ?$(GYR(B) ; C01-G-5952
(ucs-set-char #x5805 ?$@7x(B) ; J78-@-3778
(ucs-set-char #x5805 ?$B7x(B) ; J83-B-3778
(ucs-set-char #x5806 ?$(CwX(B) ; KS0-C-7758
(ucs-set-char #x5806 ?$(GYT(B) ; C01-G-5954
(ucs-set-char #x5806 ?$@BO(B) ; J78-@-424F
(ucs-set-char #x5806 ?$A6Q(B) ; GB0-A-3651
(ucs-set-char #x5806 ?$BBO(B) ; J83-B-424F
(ucs-set-char #x5807 ?$(H4>(B) ; C02-H-343E
(ucs-set-char #x5807 ?$A]@(B) ; GB0-A-5D40
(ucs-set-char #x5808 ?$(CK((B) ; KS0-C-4B28
(ucs-set-char #x5808 ?$(D7|(B) ; J90-D-377C
(ucs-set-char #x5808 ?$(H49(B) ; C02-H-3439
(ucs-set-char #x5809 ?$(Ck<(B) ; KS0-C-6B3C
(ucs-set-char #x5809 ?$(D7}(B) ; J90-D-377D
(ucs-set-char #x5809 ?$(GTm(B) ; C01-G-546D
(ucs-set-char #x580A ?$(Cd>(B) ; KS0-C-643E
(ucs-set-char #x580A ?$(GYS(B) ; C01-G-5953
(ucs-set-char #x580A ?$@TA(B) ; J78-@-5441
(ucs-set-char #x580A ?$BTA(B) ; J83-B-5441
(ucs-set-char #x580B ?$(H4;(B) ; C02-H-343B
(ucs-set-char #x580B ?$@TD(B) ; J78-@-5444
(ucs-set-char #x580B ?$A\!(B) ; GB0-A-5C21
(ucs-set-char #x580B ?$BTD(B) ; J83-B-5444
(ucs-set-char #x580C ?$(D8!(B) ; J90-D-3821
(ucs-set-char #x580C ?$(H4J(B) ; C02-H-344A
(ucs-set-char #x580D ?$(D8"(B) ; J90-D-3822
(ucs-set-char #x580D ?$(H4N(B) ; C02-H-344E
(ucs-set-char #x580D ?$A\"(B) ; GB0-A-5C22
(ucs-set-char #x580E ?$(H4E(B) ; C02-H-3445
(ucs-set-char #x5810 ?$(H4G(B) ; C02-H-3447
(ucs-set-char #x5811 ?$AG5(B) ; GB0-A-4735
(ucs-set-char #x5814 ?$(H41(B) ; C02-H-3431
(ucs-set-char #x5815 ?$@BD(B) ; J78-@-4244
(ucs-set-char #x5815 ?$A6i(B) ; GB0-A-3669
(ucs-set-char #x5815 ?$BBD(B) ; J83-B-4244
(ucs-set-char #x5817 ?$(J6i(B) ; C04-J-3669
(ucs-set-char #x5818 ?$(I:J(B) ; C03-I-3A4A
(ucs-set-char #x5819 ?$(H:c(B) ; C02-H-3A63
(ucs-set-char #x5819 ?$@TE(B) ; J78-@-5445
(ucs-set-char #x5819 ?$A\'(B) ; GB0-A-5C27
(ucs-set-char #x5819 ?$BTE(B) ; J83-B-5445
(ucs-set-char #x581A ?$(I:E(B) ; C03-I-3A45
(ucs-set-char #x581B ?$(D8#(B) ; J90-D-3823
(ucs-set-char #x581B ?$(H:l(B) ; C02-H-3A6C
(ucs-set-char #x581C ?$(H:k(B) ; C02-H-3A6B
(ucs-set-char #x581D ?$(G^`(B) ; C01-G-5E60
(ucs-set-char #x581D ?$@TF(B) ; J78-@-5446
(ucs-set-char #x581D ?$BTF(B) ; J83-B-5446
(ucs-set-char #x581E ?$(Ct\(B) ; KS0-C-745C
(ucs-set-char #x581E ?$(D8$(B) ; J90-D-3824
(ucs-set-char #x581E ?$(H:d(B) ; C02-H-3A64
(ucs-set-char #x581E ?$A\&(B) ; GB0-A-5C26
(ucs-set-char #x581F ?$(D8%(B) ; J90-D-3825
(ucs-set-char #x581F ?$(I:G(B) ; C03-I-3A47
(ucs-set-char #x5820 ?$(D8&(B) ; J90-D-3826
(ucs-set-char #x5820 ?$(G^a(B) ; C01-G-5E61
(ucs-set-char #x5820 ?$A\)(B) ; GB0-A-5C29
(ucs-set-char #x5821 ?$(C\B(B) ; KS0-C-5C42
(ucs-set-char #x5821 ?$(G^_(B) ; C01-G-5E5F
(ucs-set-char #x5821 ?$@TH(B) ; J78-@-5448
(ucs-set-char #x5821 ?$A1$(B) ; GB0-A-3124
(ucs-set-char #x5821 ?$BTH(B) ; J83-B-5448
(ucs-set-char #x5822 ?$(I:P(B) ; C03-I-3A50
(ucs-set-char #x5823 ?$(H:f(B) ; C02-H-3A66
(ucs-set-char #x5824 ?$(Cp'(B) ; KS0-C-7027
(ucs-set-char #x5824 ?$(G^\(B) ; C01-G-5E5C
(ucs-set-char #x5824 ?$@Di(B) ; J78-@-4469
(ucs-set-char #x5824 ?$A5L(B) ; GB0-A-354C
(ucs-set-char #x5824 ?$BDi(B) ; J83-B-4469
(ucs-set-char #x5825 ?$(H:j(B) ; C02-H-3A6A
(ucs-set-char #x5826 ?$(D8'(B) ; J90-D-3827
(ucs-set-char #x5826 ?$(I:L(B) ; C03-I-3A4C
(ucs-set-char #x5827 ?$(Cf@(B) ; KS0-C-6640
(ucs-set-char #x5827 ?$(D8((B) ; J90-D-3828
(ucs-set-char #x5827 ?$(H:e(B) ; C02-H-3A65
(ucs-set-char #x5828 ?$(H:g(B) ; C02-H-3A67
(ucs-set-char #x5829 ?$(H:a(B) ; C02-H-3A61
(ucs-set-char #x582A ?$(CJm(B) ; KS0-C-4A6D
(ucs-set-char #x582A ?$(G^Z(B) ; C01-G-5E5A
(ucs-set-char #x582A ?$@4.(B) ; J78-@-342E
(ucs-set-char #x582A ?$A?0(B) ; GB0-A-3F30
(ucs-set-char #x582A ?$B4.(B) ; J83-B-342E
(ucs-set-char #x582B ?$(J6o(B) ; C04-J-366F
(ucs-set-char #x582C ?$(H:t(B) ; C02-H-3A74
(ucs-set-char #x582D ?$(D8)(B) ; J90-D-3829
(ucs-set-char #x582D ?$(H:s(B) ; C02-H-3A73
(ucs-set-char #x582E ?$(H:p(B) ; C02-H-3A70
(ucs-set-char #x582F ?$(Chk(B) ; KS0-C-686B
(ucs-set-char #x582F ?$(G^Y(B) ; C01-G-5E59
(ucs-set-char #x582F ?$@6F(B) ; J78-@-3646
(ucs-set-char #x582F ?$Bt!(B) ; J83-B-7421
(ucs-set-char #x5830 ?$(Ceh(B) ; KS0-C-6568
(ucs-set-char #x5830 ?$(G^](B) ; C01-G-5E5D
(ucs-set-char #x5830 ?$@1a(B) ; J78-@-3161
(ucs-set-char #x5830 ?$AQ_(B) ; GB0-A-515F
(ucs-set-char #x5830 ?$B1a(B) ; J83-B-3161
(ucs-set-char #x5831 ?$(C\C(B) ; KS0-C-5C43
(ucs-set-char #x5831 ?$(G^^(B) ; C01-G-5E5E
(ucs-set-char #x5831 ?$@Js(B) ; J78-@-4A73
(ucs-set-char #x5831 ?$BJs(B) ; J83-B-4A73
(ucs-set-char #x5832 ?$(D8*(B) ; J90-D-382A
(ucs-set-char #x5832 ?$(H.M(B) ; C02-H-2E4D
(ucs-set-char #x5832 ?$(J6v(B) ; C04-J-3676
(ucs-set-char #x5833 ?$(H:m(B) ; C02-H-3A6D
(ucs-set-char #x5834 ?$(Cm^(B) ; KS0-C-6D5E
(ucs-set-char #x5834 ?$(G^[(B) ; C01-G-5E5B
(ucs-set-char #x5834 ?$@>l(B) ; J78-@-3E6C
(ucs-set-char #x5834 ?$B>l(B) ; J83-B-3E6C
(ucs-set-char #x5835 ?$(CSr(B) ; KS0-C-5372
(ucs-set-char #x5835 ?$(GYY(B) ; C01-G-5959
(ucs-set-char #x5835 ?$@EH(B) ; J78-@-4548
(ucs-set-char #x5835 ?$A6B(B) ; GB0-A-3642
(ucs-set-char #x5835 ?$BEH(B) ; J83-B-4548
(ucs-set-char #x5836 ?$(H:o(B) ; C02-H-3A6F
(ucs-set-char #x5837 ?$(H:b(B) ; C02-H-3A62
(ucs-set-char #x5838 ?$(H:r(B) ; C02-H-3A72
(ucs-set-char #x5839 ?$(D8+(B) ; J90-D-382B
(ucs-set-char #x5839 ?$(H:q(B) ; C02-H-3A71
(ucs-set-char #x583A ?$(CLw(B) ; KS0-C-4C77
(ucs-set-char #x583A ?$(I:N(B) ; C03-I-3A4E
(ucs-set-char #x583A ?$@:f(B) ; J78-@-3A66
(ucs-set-char #x583A ?$B:f(B) ; J83-B-3A66
(ucs-set-char #x583B ?$(H:u(B) ; C02-H-3A75
(ucs-set-char #x583C ?$(I:I(B) ; C03-I-3A49
(ucs-set-char #x583D ?$(HB6(B) ; C02-H-4236
(ucs-set-char #x583D ?$@TN(B) ; J78-@-544E
(ucs-set-char #x583D ?$BTN(B) ; J83-B-544E
(ucs-set-char #x583E ?$(I:K(B) ; C03-I-3A4B
(ucs-set-char #x583F ?$(D8,(B) ; J90-D-382C
(ucs-set-char #x583F ?$(H:n(B) ; C02-H-3A6E
(ucs-set-char #x5840 ?$@J=(B) ; J78-@-4A3D
(ucs-set-char #x5840 ?$BJ=(B) ; J83-B-4A3D
(ucs-set-char #x5841 ?$@N](B) ; J78-@-4E5D
(ucs-set-char #x5841 ?$BN](B) ; J83-B-4E5D
(ucs-set-char #x5843 ?$(J<W(B) ; C04-J-3C57
(ucs-set-char #x5844 ?$(J6m(B) ; C04-J-366D
(ucs-set-char #x5844 ?$A\((B) ; GB0-A-5C28
(ucs-set-char #x5845 ?$(J6q(B) ; C04-J-3671
(ucs-set-char #x5848 ?$(H:i(B) ; C02-H-3A69
(ucs-set-char #x5849 ?$(D8-(B) ; J90-D-382D
(ucs-set-char #x5849 ?$(HB.(B) ; C02-H-422E
(ucs-set-char #x584A ?$(CNT(B) ; KS0-C-4E54
(ucs-set-char #x584A ?$(Gc[(B) ; C01-G-635B
(ucs-set-char #x584A ?$@2t(B) ; J78-@-3274
(ucs-set-char #x584A ?$B2t(B) ; J83-B-3274
(ucs-set-char #x584B ?$(Cg+(B) ; KS0-C-672B
(ucs-set-char #x584B ?$(Gc^(B) ; C01-G-635E
(ucs-set-char #x584B ?$@TJ(B) ; J78-@-544A
(ucs-set-char #x584B ?$BTJ(B) ; J83-B-544A
(ucs-set-char #x584C ?$(D8.(B) ; J90-D-382E
(ucs-set-char #x584C ?$(GcY(B) ; C01-G-6359
(ucs-set-char #x584C ?$AKz(B) ; GB0-A-4B7A
(ucs-set-char #x584D ?$(D8/(B) ; J90-D-382F
(ucs-set-char #x584D ?$(HB-(B) ; C02-H-422D
(ucs-set-char #x584D ?$Aks(B) ; GB0-A-6B73
(ucs-set-char #x584E ?$(HB1(B) ; C02-H-4231
(ucs-set-char #x584F ?$(CKC(B) ; KS0-C-4B43
(ucs-set-char #x584F ?$(D80(B) ; J90-D-3830
(ucs-set-char #x584F ?$(HB,(B) ; C02-H-422C
(ucs-set-char #x5850 ?$(D81(B) ; J90-D-3831
(ucs-set-char #x5850 ?$(I@W(B) ; C03-I-4057
(ucs-set-char #x5851 ?$(Ca1(B) ; KS0-C-6131
(ucs-set-char #x5851 ?$(GcS(B) ; C01-G-6353
(ucs-set-char #x5851 ?$@A:(B) ; J78-@-413A
(ucs-set-char #x5851 ?$AK\(B) ; GB0-A-4B5C
(ucs-set-char #x5851 ?$BA:(B) ; J83-B-413A
(ucs-set-char #x5852 ?$(Gc](B) ; C01-G-635D
(ucs-set-char #x5852 ?$@TM(B) ; J78-@-544D
(ucs-set-char #x5852 ?$BTM(B) ; J83-B-544D
(ucs-set-char #x5853 ?$(HB)(B) ; C02-H-4229
(ucs-set-char #x5854 ?$(Cw2(B) ; KS0-C-7732
(ucs-set-char #x5854 ?$(GcW(B) ; C01-G-6357
(ucs-set-char #x5854 ?$@Ec(B) ; J78-@-4563
(ucs-set-char #x5854 ?$AK~(B) ; GB0-A-4B7E
(ucs-set-char #x5854 ?$BEc(B) ; J83-B-4563
(ucs-set-char #x5855 ?$(D82(B) ; J90-D-3832
(ucs-set-char #x5855 ?$(HB0(B) ; C02-H-4230
(ucs-set-char #x5856 ?$(I@[(B) ; C03-I-405B
(ucs-set-char #x5857 ?$(CSs(B) ; KS0-C-5373
(ucs-set-char #x5857 ?$(GcU(B) ; C01-G-6355
(ucs-set-char #x5857 ?$@EI(B) ; J78-@-4549
(ucs-set-char #x5857 ?$BEI(B) ; J83-B-4549
(ucs-set-char #x5858 ?$(CSR(B) ; KS0-C-5352
(ucs-set-char #x5858 ?$(GcT(B) ; C01-G-6354
(ucs-set-char #x5858 ?$@Ed(B) ; J78-@-4564
(ucs-set-char #x5858 ?$ALA(B) ; GB0-A-4C41
(ucs-set-char #x5858 ?$BEd(B) ; J83-B-4564
(ucs-set-char #x5859 ?$(HB3(B) ; C02-H-4233
(ucs-set-char #x5859 ?$@H9(B) ; J78-@-4839
(ucs-set-char #x5859 ?$BH9(B) ; J83-B-4839
(ucs-set-char #x585A ?$(Cu@(B) ; KS0-C-7540
(ucs-set-char #x585A ?$(GcV(B) ; C01-G-6356
(ucs-set-char #x585A ?$@DM(B) ; J78-@-444D
(ucs-set-char #x585A ?$BDM(B) ; J83-B-444D
(ucs-set-char #x585B ?$(HB5(B) ; C02-H-4235
(ucs-set-char #x585C ?$(I@V(B) ; C03-I-4056
(ucs-set-char #x585D ?$(HB2(B) ; C02-H-4232
(ucs-set-char #x585E ?$(C_](B) ; KS0-C-5F5D
(ucs-set-char #x585E ?$(GcR(B) ; C01-G-6352
(ucs-set-char #x585E ?$@:I(B) ; J78-@-3A49
(ucs-set-char #x585E ?$AH{(B) ; GB0-A-487B
(ucs-set-char #x585E ?$B:I(B) ; J83-B-3A49
(ucs-set-char #x585F ?$(D83(B) ; J90-D-3833
(ucs-set-char #x585F ?$(I@^(B) ; C03-I-405E
(ucs-set-char #x5860 ?$(I@\(B) ; C03-I-405C
(ucs-set-char #x5861 ?$(Cns(B) ; KS0-C-6E73
(ucs-set-char #x5861 ?$(D84(B) ; J90-D-3834
(ucs-set-char #x5861 ?$(I@X(B) ; C03-I-4058
(ucs-set-char #x5861 ?$@E6(B) ; J78-@-4536
(ucs-set-char #x5862 ?$(Cgq(B) ; KS0-C-6771
(ucs-set-char #x5862 ?$(Gc\(B) ; C01-G-635C
(ucs-set-char #x5862 ?$@TI(B) ; J78-@-5449
(ucs-set-char #x5862 ?$BTI(B) ; J83-B-5449
(ucs-set-char #x5863 ?$(HB7(B) ; C02-H-4237
(ucs-set-char #x5864 ?$(C}4(B) ; KS0-C-7D34
(ucs-set-char #x5864 ?$(D85(B) ; J90-D-3835
(ucs-set-char #x5864 ?$(HB+(B) ; C02-H-422B
(ucs-set-char #x5865 ?$(HB4(B) ; C02-H-4234
(ucs-set-char #x5865 ?$A\*(B) ; GB0-A-5C2A
(ucs-set-char #x5866 ?$(I@](B) ; C03-I-405D
(ucs-set-char #x5867 ?$(D86(B) ; J90-D-3836
(ucs-set-char #x5867 ?$(J<S(B) ; C04-J-3C53
(ucs-set-char #x5868 ?$(D87(B) ; J90-D-3837
(ucs-set-char #x5868 ?$(HB*(B) ; C02-H-422A
(ucs-set-char #x5869 ?$(I@Z(B) ; C03-I-405A
(ucs-set-char #x5869 ?$@1v(B) ; J78-@-3176
(ucs-set-char #x5869 ?$B1v(B) ; J83-B-3176
(ucs-set-char #x586A ?$(I@Y(B) ; C03-I-4059
(ucs-set-char #x586B ?$(GcX(B) ; C01-G-6358
(ucs-set-char #x586B ?$ALn(B) ; GB0-A-4C6E
(ucs-set-char #x586B ?$BE6(B) ; J83-B-4536
(ucs-set-char #x586C ?$(I@T(B) ; C03-I-4054
(ucs-set-char #x586C ?$A\+(B) ; GB0-A-5C2B
(ucs-set-char #x586D ?$(GcZ(B) ; C01-G-635A
(ucs-set-char #x586F ?$(HB/(B) ; C02-H-422F
(ucs-set-char #x5870 ?$@TK(B) ; J78-@-544B
(ucs-set-char #x5870 ?$BTK(B) ; J83-B-544B
(ucs-set-char #x5871 ?$(HB8(B) ; C02-H-4238
(ucs-set-char #x5872 ?$(IFC(B) ; C03-I-4643
(ucs-set-char #x5872 ?$@TG(B) ; J78-@-5447
(ucs-set-char #x5872 ?$BTG(B) ; J83-B-5447
(ucs-set-char #x5873 ?$(IF>(B) ; C03-I-463E
(ucs-set-char #x5874 ?$(HID(B) ; C02-H-4944
(ucs-set-char #x5875 ?$(CrH(B) ; KS0-C-7248
(ucs-set-char #x5875 ?$(Gh8(B) ; C01-G-6838
(ucs-set-char #x5875 ?$@?P(B) ; J78-@-3F50
(ucs-set-char #x5875 ?$B?P(B) ; J83-B-3F50
(ucs-set-char #x5876 ?$(HIJ(B) ; C02-H-494A
(ucs-set-char #x5877 ?$(IFB(B) ; C03-I-4642
(ucs-set-char #x5878 ?$(D88(B) ; J90-D-3838
(ucs-set-char #x5878 ?$(IF<(B) ; C03-I-463C
(ucs-set-char #x5879 ?$(CsR(B) ; KS0-C-7352
(ucs-set-char #x5879 ?$(Gh=(B) ; C01-G-683D
(ucs-set-char #x5879 ?$@TO(B) ; J78-@-544F
(ucs-set-char #x5879 ?$BTO(B) ; J83-B-544F
(ucs-set-char #x587A ?$(HIF(B) ; C02-H-4946
(ucs-set-char #x587B ?$(HIM(B) ; C02-H-494D
(ucs-set-char #x587C ?$(Cnt(B) ; KS0-C-6E74
(ucs-set-char #x587C ?$(D89(B) ; J90-D-3839
(ucs-set-char #x587C ?$(HI>(B) ; C02-H-493E
(ucs-set-char #x587D ?$(Gh?(B) ; C01-G-683F
(ucs-set-char #x587E ?$(CbS(B) ; KS0-C-6253
(ucs-set-char #x587E ?$(Gh9(B) ; C01-G-6839
(ucs-set-char #x587E ?$@=N(B) ; J78-@-3D4E
(ucs-set-char #x587E ?$A[S(B) ; GB0-A-5B53
(ucs-set-char #x587E ?$B=N(B) ; J83-B-3D4E
(ucs-set-char #x587F ?$(D8:(B) ; J90-D-383A
(ucs-set-char #x587F ?$(HIC(B) ; C02-H-4943
(ucs-set-char #x5880 ?$(D8;(B) ; J90-D-383B
(ucs-set-char #x5880 ?$(Gl?(B) ; C01-G-6C3F
(ucs-set-char #x5880 ?$A\/(B) ; GB0-A-5C2F
(ucs-set-char #x5881 ?$(D8<(B) ; J90-D-383C
(ucs-set-char #x5881 ?$(HIB(B) ; C02-H-4942
(ucs-set-char #x5881 ?$A\,(B) ; GB0-A-5C2C
(ucs-set-char #x5882 ?$(HIK(B) ; C02-H-494B
(ucs-set-char #x5883 ?$(CLQ(B) ; KS0-C-4C51
(ucs-set-char #x5883 ?$(Gh:(B) ; C01-G-683A
(ucs-set-char #x5883 ?$@6-(B) ; J78-@-362D
(ucs-set-char #x5883 ?$A>3(B) ; GB0-A-3E33
(ucs-set-char #x5883 ?$B6-(B) ; J83-B-362D
(ucs-set-char #x5884 ?$(IF=(B) ; C03-I-463D
(ucs-set-char #x5885 ?$(C_j(B) ; KS0-C-5F6A
(ucs-set-char #x5885 ?$(Gh>(B) ; C01-G-683E
(ucs-set-char #x5885 ?$@TP(B) ; J78-@-5450
(ucs-set-char #x5885 ?$AJ{(B) ; GB0-A-4A7B
(ucs-set-char #x5885 ?$BTP(B) ; J83-B-5450
(ucs-set-char #x5886 ?$(HIA(B) ; C02-H-4941
(ucs-set-char #x5887 ?$(D8=(B) ; J90-D-383D
(ucs-set-char #x5887 ?$(HIG(B) ; C02-H-4947
(ucs-set-char #x5888 ?$(D8>(B) ; J90-D-383E
(ucs-set-char #x5888 ?$(HIL(B) ; C02-H-494C
(ucs-set-char #x5889 ?$(Ci:(B) ; KS0-C-693A
(ucs-set-char #x5889 ?$(D8?(B) ; J90-D-383F
(ucs-set-char #x5889 ?$(HI=(B) ; C02-H-493D
(ucs-set-char #x5889 ?$A\-(B) ; GB0-A-5C2D
(ucs-set-char #x588A ?$(D8@(B) ; J90-D-3840
(ucs-set-char #x588A ?$(Gh<(B) ; C01-G-683C
(ucs-set-char #x588B ?$(HIE(B) ; C02-H-4945
(ucs-set-char #x588C ?$(D8A(B) ; J90-D-3841
(ucs-set-char #x588C ?$(IF:(B) ; C03-I-463A
(ucs-set-char #x588D ?$(D8B(B) ; J90-D-3842
(ucs-set-char #x588D ?$(IFE(B) ; C03-I-4645
(ucs-set-char #x588E ?$(HII(B) ; C02-H-4949
(ucs-set-char #x588F ?$(D8C(B) ; J90-D-3843
(ucs-set-char #x588F ?$(HIO(B) ; C02-H-494F
(ucs-set-char #x5890 ?$(D8D(B) ; J90-D-3844
(ucs-set-char #x5890 ?$(HI?(B) ; C02-H-493F
(ucs-set-char #x5891 ?$(HIH(B) ; C02-H-4948
(ucs-set-char #x5892 ?$(IF8(B) ; C03-I-4638
(ucs-set-char #x5892 ?$AIJ(B) ; GB0-A-494A
(ucs-set-char #x5893 ?$(CYW(B) ; KS0-C-5957
(ucs-set-char #x5893 ?$(Gh;(B) ; C01-G-683B
(ucs-set-char #x5893 ?$@Jh(B) ; J78-@-4A68
(ucs-set-char #x5893 ?$AD9(B) ; GB0-A-4439
(ucs-set-char #x5893 ?$BJh(B) ; J83-B-4A68
(ucs-set-char #x5894 ?$(D8E(B) ; J90-D-3845
(ucs-set-char #x5894 ?$(HIN(B) ; C02-H-494E
(ucs-set-char #x5895 ?$(IFA(B) ; C03-I-4641
(ucs-set-char #x5896 ?$(D8F(B) ; J90-D-3846
(ucs-set-char #x5896 ?$(IFD(B) ; C03-I-4644
(ucs-set-char #x5897 ?$(IF@(B) ; C03-I-4640
(ucs-set-char #x5897 ?$@A}(B) ; J78-@-417D
(ucs-set-char #x5897 ?$BA}(B) ; J83-B-417D
(ucs-set-char #x5898 ?$(HI@(B) ; C02-H-4940
(ucs-set-char #x5899 ?$AG=(B) ; GB0-A-473D
(ucs-set-char #x589A ?$(JBY(B) ; C04-J-4259
(ucs-set-char #x589A ?$A\.(B) ; GB0-A-5C2E
(ucs-set-char #x589C ?$(CuM(B) ; KS0-C-754D
(ucs-set-char #x589C ?$(GlC(B) ; C01-G-6C43
(ucs-set-char #x589C ?$@DF(B) ; J78-@-4446
(ucs-set-char #x589C ?$BDF(B) ; J83-B-4446
(ucs-set-char #x589D ?$(D8G(B) ; J90-D-3847
(ucs-set-char #x589D ?$(HOr(B) ; C02-H-4F72
(ucs-set-char #x589E ?$(Cqr(B) ; KS0-C-7172
(ucs-set-char #x589E ?$(GlA(B) ; C01-G-6C41
(ucs-set-char #x589E ?$ATv(B) ; GB0-A-5476
(ucs-set-char #x589F ?$(CzG(B) ; KS0-C-7A47
(ucs-set-char #x589F ?$(Gl@(B) ; C01-G-6C40
(ucs-set-char #x589F ?$@TR(B) ; J78-@-5452
(ucs-set-char #x589F ?$APf(B) ; GB0-A-5066
(ucs-set-char #x589F ?$BTR(B) ; J83-B-5452
(ucs-set-char #x58A0 ?$(D8H(B) ; J90-D-3848
(ucs-set-char #x58A0 ?$(HOt(B) ; C02-H-4F74
(ucs-set-char #x58A1 ?$(D8I(B) ; J90-D-3849
(ucs-set-char #x58A1 ?$(HOy(B) ; C02-H-4F79
(ucs-set-char #x58A2 ?$(D8J(B) ; J90-D-384A
(ucs-set-char #x58A2 ?$(IKF(B) ; C03-I-4B46
(ucs-set-char #x58A3 ?$(HOu(B) ; C02-H-4F75
(ucs-set-char #x58A4 ?$(IKP(B) ; C03-I-4B50
(ucs-set-char #x58A5 ?$(HOx(B) ; C02-H-4F78
(ucs-set-char #x58A6 ?$(D8K(B) ; J90-D-384B
(ucs-set-char #x58A6 ?$(GlF(B) ; C01-G-6C46
(ucs-set-char #x58A7 ?$(IKQ(B) ; C03-I-4B51
(ucs-set-char #x58A8 ?$(CYx(B) ; KS0-C-5978
(ucs-set-char #x58A8 ?$(Gp.(B) ; C01-G-702E
(ucs-set-char #x58A8 ?$@KO(B) ; J78-@-4B4F
(ucs-set-char #x58A8 ?$AD+(B) ; GB0-A-442B
(ucs-set-char #x58A8 ?$BKO(B) ; J83-B-4B4F
(ucs-set-char #x58A9 ?$(CTB(B) ; KS0-C-5442
(ucs-set-char #x58A9 ?$(D8L(B) ; J90-D-384C
(ucs-set-char #x58A9 ?$(GlE(B) ; C01-G-6C45
(ucs-set-char #x58A9 ?$A6U(B) ; GB0-A-3655
(ucs-set-char #x58AA ?$(IKK(B) ; C03-I-4B4B
(ucs-set-char #x58AB ?$(HOq(B) ; C02-H-4F71
(ucs-set-char #x58AB ?$@TS(B) ; J78-@-5453
(ucs-set-char #x58AB ?$BTS(B) ; J83-B-5453
(ucs-set-char #x58AC ?$(HOw(B) ; C02-H-4F77
(ucs-set-char #x58AD ?$(IF?(B) ; C03-I-463F
(ucs-set-char #x58AE ?$(Cve(B) ; KS0-C-7665
(ucs-set-char #x58AE ?$(GlD(B) ; C01-G-6C44
(ucs-set-char #x58AE ?$@TX(B) ; J78-@-5458
(ucs-set-char #x58AE ?$BTX(B) ; J83-B-5458
(ucs-set-char #x58AF ?$(HOv(B) ; C02-H-4F76
(ucs-set-char #x58B0 ?$(IKM(B) ; C03-I-4B4D
(ucs-set-char #x58B1 ?$(D8M(B) ; J90-D-384D
(ucs-set-char #x58B1 ?$(HOs(B) ; C02-H-4F73
(ucs-set-char #x58B2 ?$(D8N(B) ; J90-D-384E
(ucs-set-char #x58B2 ?$(IKI(B) ; C03-I-4B49
(ucs-set-char #x58B3 ?$(C]E(B) ; KS0-C-5D45
(ucs-set-char #x58B3 ?$(GlB(B) ; C01-G-6C42
(ucs-set-char #x58B3 ?$@J/(B) ; J78-@-4A2F
(ucs-set-char #x58B3 ?$BJ/(B) ; J83-B-4A2F
(ucs-set-char #x58B4 ?$(IKO(B) ; C03-I-4B4F
(ucs-set-char #x58B5 ?$(IKL(B) ; C03-I-4B4C
(ucs-set-char #x58B7 ?$(IKG(B) ; C03-I-4B47
(ucs-set-char #x58B8 ?$@TW(B) ; J78-@-5457
(ucs-set-char #x58B8 ?$BTW(B) ; J83-B-5457
(ucs-set-char #x58B9 ?$@TQ(B) ; J78-@-5451
(ucs-set-char #x58B9 ?$BTQ(B) ; J83-B-5451
(ucs-set-char #x58BA ?$(Cgr(B) ; KS0-C-6772
(ucs-set-char #x58BA ?$(HVW(B) ; C02-H-5657
(ucs-set-char #x58BA ?$@TT(B) ; J78-@-5454
(ucs-set-char #x58BA ?$BTT(B) ; J83-B-5454
(ucs-set-char #x58BB ?$(Cm_(B) ; KS0-C-6D5F
(ucs-set-char #x58BB ?$(IPJ(B) ; C03-I-504A
(ucs-set-char #x58BB ?$@TV(B) ; J78-@-5456
(ucs-set-char #x58BB ?$BTV(B) ; J83-B-5456
(ucs-set-char #x58BC ?$(D8P(B) ; J90-D-3850
(ucs-set-char #x58BC ?$(HVY(B) ; C02-H-5659
(ucs-set-char #x58BC ?$A[T(B) ; GB0-A-5B54
(ucs-set-char #x58BD ?$(HVT(B) ; C02-H-5654
(ucs-set-char #x58BE ?$(CJK(B) ; KS0-C-4A4B
(ucs-set-char #x58BE ?$(GpJ(B) ; C01-G-704A
(ucs-set-char #x58BE ?$@:&(B) ; J78-@-3A26
(ucs-set-char #x58BE ?$B:&(B) ; J83-B-3A26
(ucs-set-char #x58BF ?$(HVV(B) ; C02-H-5656
(ucs-set-char #x58C0 ?$(IPK(B) ; C03-I-504B
(ucs-set-char #x58C1 ?$(C[z(B) ; KS0-C-5B7A
(ucs-set-char #x58C1 ?$(GpI(B) ; C01-G-7049
(ucs-set-char #x58C1 ?$@JI(B) ; J78-@-4A49
(ucs-set-char #x58C1 ?$A1Z(B) ; GB0-A-315A
(ucs-set-char #x58C1 ?$BJI(B) ; J83-B-4A49
(ucs-set-char #x58C2 ?$(D8Q(B) ; J90-D-3851
(ucs-set-char #x58C2 ?$(HVX(B) ; C02-H-5658
(ucs-set-char #x58C3 ?$(IPH(B) ; C03-I-5048
(ucs-set-char #x58C4 ?$(D8O(B) ; J90-D-384F
(ucs-set-char #x58C4 ?$(IPL(B) ; C03-I-504C
(ucs-set-char #x58C4 ?$(M!x(B) ; C07-M-2178
(ucs-set-char #x58C5 ?$(Ch5(B) ; KS0-C-6835
(ucs-set-char #x58C5 ?$(GpL(B) ; C01-G-704C
(ucs-set-char #x58C5 ?$@TY(B) ; J78-@-5459
(ucs-set-char #x58C5 ?$A[U(B) ; GB0-A-5B55
(ucs-set-char #x58C5 ?$BTY(B) ; J83-B-5459
(ucs-set-char #x58C6 ?$(HVZ(B) ; C02-H-565A
(ucs-set-char #x58C7 ?$(CS&(B) ; KS0-C-5326
(ucs-set-char #x58C7 ?$(GpK(B) ; C01-G-704B
(ucs-set-char #x58C7 ?$@CE(B) ; J78-@-4345
(ucs-set-char #x58C7 ?$BCE(B) ; J83-B-4345
(ucs-set-char #x58C8 ?$(D8R(B) ; J90-D-3852
(ucs-set-char #x58C8 ?$(HVS(B) ; C02-H-5653
(ucs-set-char #x58C9 ?$(HVU(B) ; C02-H-5655
(ucs-set-char #x58CA ?$(IPI(B) ; C03-I-5049
(ucs-set-char #x58CA ?$@2u(B) ; J78-@-3275
(ucs-set-char #x58CA ?$B2u(B) ; J83-B-3275
(ucs-set-char #x58CC ?$@>m(B) ; J78-@-3E6D
(ucs-set-char #x58CC ?$B>m(B) ; J83-B-3E6D
(ucs-set-char #x58CD ?$(D8S(B) ; J90-D-3853
(ucs-set-char #x58CD ?$(ITK(B) ; C03-I-544B
(ucs-set-char #x58CE ?$(C}5(B) ; KS0-C-7D35
(ucs-set-char #x58CE ?$(D8T(B) ; J90-D-3854
(ucs-set-char #x58CE ?$(GsN(B) ; C01-G-734E
(ucs-set-char #x58CF ?$(H\X(B) ; C02-H-5C58
(ucs-set-char #x58D0 ?$(D8U(B) ; J90-D-3855
(ucs-set-char #x58D0 ?$(ITL(B) ; C03-I-544C
(ucs-set-char #x58D1 ?$(CyI(B) ; KS0-C-7949
(ucs-set-char #x58D1 ?$(GsM(B) ; C01-G-734D
(ucs-set-char #x58D1 ?$@T[(B) ; J78-@-545B
(ucs-set-char #x58D1 ?$A[V(B) ; GB0-A-5B56
(ucs-set-char #x58D1 ?$BT[(B) ; J83-B-545B
(ucs-set-char #x58D2 ?$(D8V(B) ; J90-D-3856
(ucs-set-char #x58D2 ?$(H\Y(B) ; C02-H-5C59
(ucs-set-char #x58D3 ?$(Cdb(B) ; KS0-C-6462
(ucs-set-char #x58D3 ?$(GsL(B) ; C01-G-734C
(ucs-set-char #x58D3 ?$@TZ(B) ; J78-@-545A
(ucs-set-char #x58D3 ?$BTZ(B) ; J83-B-545A
(ucs-set-char #x58D4 ?$(D8W(B) ; J90-D-3857
(ucs-set-char #x58D4 ?$(H\W(B) ; C02-H-5C57
(ucs-set-char #x58D5 ?$(C{=(B) ; KS0-C-7B3D
(ucs-set-char #x58D5 ?$(GsK(B) ; C01-G-734B
(ucs-set-char #x58D5 ?$@9h(B) ; J78-@-3968
(ucs-set-char #x58D5 ?$A:>(B) ; GB0-A-3A3E
(ucs-set-char #x58D5 ?$B9h(B) ; J83-B-3968
(ucs-set-char #x58D6 ?$(D8X(B) ; J90-D-3858
(ucs-set-char #x58D6 ?$(H\V(B) ; C02-H-5C56
(ucs-set-char #x58D7 ?$@T\(B) ; J78-@-545C
(ucs-set-char #x58D7 ?$BT\(B) ; J83-B-545C
(ucs-set-char #x58D8 ?$(CW$(B) ; KS0-C-5724
(ucs-set-char #x58D8 ?$(Gv?(B) ; C01-G-763F
(ucs-set-char #x58D8 ?$@T^(B) ; J78-@-545E
(ucs-set-char #x58D8 ?$BT^(B) ; J83-B-545E
(ucs-set-char #x58D9 ?$(CNE(B) ; KS0-C-4E45
(ucs-set-char #x58D9 ?$(Gv>(B) ; C01-G-763E
(ucs-set-char #x58D9 ?$@T](B) ; J78-@-545D
(ucs-set-char #x58D9 ?$BT](B) ; J83-B-545D
(ucs-set-char #x58DA ?$(D8Y(B) ; J90-D-3859
(ucs-set-char #x58DA ?$(HeB(B) ; C02-H-6542
(ucs-set-char #x58DB ?$(HeD(B) ; C02-H-6544
(ucs-set-char #x58DC ?$(IZ/(B) ; C03-I-5A2F
(ucs-set-char #x58DC ?$@T`(B) ; J78-@-5460
(ucs-set-char #x58DC ?$BT`(B) ; J83-B-5460
(ucs-set-char #x58DD ?$(D8Z(B) ; J90-D-385A
(ucs-set-char #x58DD ?$(HeC(B) ; C02-H-6543
(ucs-set-char #x58DE ?$(CNU(B) ; KS0-C-4E55
(ucs-set-char #x58DE ?$(Gx.(B) ; C01-G-782E
(ucs-set-char #x58DE ?$@TU(B) ; J78-@-5455
(ucs-set-char #x58DE ?$BTU(B) ; J83-B-5455
(ucs-set-char #x58DF ?$(CVf(B) ; KS0-C-5666
(ucs-set-char #x58DF ?$(Gx/(B) ; C01-G-782F
(ucs-set-char #x58DF ?$@Tb(B) ; J78-@-5462
(ucs-set-char #x58DF ?$BTb(B) ; J83-B-5462
(ucs-set-char #x58E0 ?$(IZ.(B) ; C03-I-5A2E
(ucs-set-char #x58E1 ?$(D8[(B) ; J90-D-385B
(ucs-set-char #x58E1 ?$(MFE(B) ; C07-M-4645
(ucs-set-char #x58E2 ?$(D8\(B) ; J90-D-385C
(ucs-set-char #x58E2 ?$(Gx0(B) ; C01-G-7830
(ucs-set-char #x58E3 ?$(Hhn(B) ; C02-H-686E
(ucs-set-char #x58E4 ?$(Ce=(B) ; KS0-C-653D
(ucs-set-char #x58E4 ?$(Gyf(B) ; C01-G-7966
(ucs-set-char #x58E4 ?$@Ta(B) ; J78-@-5461
(ucs-set-char #x58E4 ?$AH@(B) ; GB0-A-4840
(ucs-set-char #x58E4 ?$BTa(B) ; J83-B-5461
(ucs-set-char #x58E5 ?$@T_(B) ; J78-@-545F
(ucs-set-char #x58E5 ?$BT_(B) ; J83-B-545F
(ucs-set-char #x58E6 ?$(I^((B) ; C03-I-5E28
(ucs-set-char #x58E7 ?$(Ho"(B) ; C02-H-6F22
(ucs-set-char #x58E8 ?$(Ho!(B) ; C02-H-6F21
(ucs-set-char #x58E9 ?$(D8](B) ; J90-D-385D
(ucs-set-char #x58E9 ?$(G|^(B) ; C01-G-7C5E

(ucs-set-char #x58EB ?$AJ?(B) ; GB0-A-4A3F
(ucs-set-char #x58EB ?$(C^M(B) ; KS0-C-5E4D
(ucs-set-char #x58EB ?$(GDI(B) ; C01-G-4449
(ucs-set-char #x58EB ?$@;N(B) ; J78-@-3B4E
(ucs-set-char #x58EB ?$B;N(B) ; J83-B-3B4E

(ucs-set-char #x58EC ?$(Cls(B) ; KS0-C-6C73
(ucs-set-char #x58EC ?$(GE1(B) ; C01-G-4531
(ucs-set-char #x58EC ?$@?Q(B) ; J78-@-3F51
(ucs-set-char #x58EC ?$AHI(B) ; GB0-A-4849
(ucs-set-char #x58EC ?$B?Q(B) ; J83-B-3F51
(ucs-set-char #x58EE ?$(I#C(B) ; C03-I-2343
(ucs-set-char #x58EE ?$@AT(B) ; J78-@-4154
(ucs-set-char #x58EE ?$AW3(B) ; GB0-A-5733
(ucs-set-char #x58EE ?$BAT(B) ; J83-B-4154
(ucs-set-char #x58EF ?$(Cm`(B) ; KS0-C-6D60
(ucs-set-char #x58EF ?$(GIg(B) ; C01-G-4967
(ucs-set-char #x58EF ?$@Tc(B) ; J78-@-5463
(ucs-set-char #x58EF ?$BTc(B) ; J83-B-5463
(ucs-set-char #x58F0 ?$(I%E(B) ; C03-I-2545
(ucs-set-char #x58F0 ?$@@<(B) ; J78-@-403C
(ucs-set-char #x58F0 ?$AIy(B) ; GB0-A-4979
(ucs-set-char #x58F0 ?$B@<(B) ; J83-B-403C
(ucs-set-char #x58F1 ?$(I%C(B) ; C03-I-2543
(ucs-set-char #x58F1 ?$@0m(B) ; J78-@-306D
(ucs-set-char #x58F1 ?$B0m(B) ; J83-B-306D
(ucs-set-char #x58F2 ?$(I%D(B) ; C03-I-2544
(ucs-set-char #x58F2 ?$@Gd(B) ; J78-@-4764
(ucs-set-char #x58F2 ?$BGd(B) ; J83-B-4764
(ucs-set-char #x58F3 ?$(D8^(B) ; J90-D-385E
(ucs-set-char #x58F3 ?$(I(-(B) ; C03-I-282D
(ucs-set-char #x58F3 ?$A?G(B) ; GB0-A-3F47
(ucs-set-char #x58F4 ?$(H)`(B) ; C02-H-2960
(ucs-set-char #x58F5 ?$(I+w(B) ; C03-I-2B77
(ucs-set-char #x58F6 ?$A:x(B) ; GB0-A-3A78
(ucs-set-char #x58F7 ?$(I4w(B) ; C03-I-3477
(ucs-set-char #x58F7 ?$@Td(B) ; J78-@-5464
(ucs-set-char #x58F7 ?$BD[(B) ; J83-B-445B
(ucs-set-char #x58F9 ?$(Cll(B) ; KS0-C-6C6C
(ucs-set-char #x58F9 ?$(G^b(B) ; C01-G-5E62
(ucs-set-char #x58F9 ?$@Te(B) ; J78-@-5465
(ucs-set-char #x58F9 ?$AR<(B) ; GB0-A-523C
(ucs-set-char #x58F9 ?$BTe(B) ; J83-B-5465
(ucs-set-char #x58FA ?$(C{>(B) ; KS0-C-7B3E
(ucs-set-char #x58FA ?$(G^c(B) ; C01-G-5E63
(ucs-set-char #x58FA ?$@D[(B) ; J78-@-445B
(ucs-set-char #x58FA ?$BTd(B) ; J83-B-5464
(ucs-set-char #x58FB ?$(C_k(B) ; KS0-C-5F6B
(ucs-set-char #x58FB ?$(I:R(B) ; C03-I-3A52
(ucs-set-char #x58FB ?$@Tf(B) ; J78-@-5466
(ucs-set-char #x58FB ?$BTf(B) ; J83-B-5466
(ucs-set-char #x58FC ?$(HB9(B) ; C02-H-4239
(ucs-set-char #x58FC ?$@Tg(B) ; J78-@-5467
(ucs-set-char #x58FC ?$BTg(B) ; J83-B-5467
(ucs-set-char #x58FD ?$(Cax(B) ; KS0-C-6178
(ucs-set-char #x58FD ?$(Gh@(B) ; C01-G-6840
(ucs-set-char #x58FD ?$@Th(B) ; J78-@-5468
(ucs-set-char #x58FD ?$BTh(B) ; J83-B-5468
(ucs-set-char #x58FE ?$(HIP(B) ; C02-H-4950
(ucs-set-char #x58FF ?$(HOz(B) ; C02-H-4F7A
(ucs-set-char #x5900 ?$(L\/(B) ; C06-L-5C2F
(ucs-set-char #x5901 ?$(IPM(B) ; C03-I-504D
(ucs-set-char #x5902 ?$(I!9(B) ; C03-I-2139
(ucs-set-char #x5902 ?$@Ti(B) ; J78-@-5469
(ucs-set-char #x5902 ?$Ab:(B) ; GB0-A-623A
(ucs-set-char #x5902 ?$BTi(B) ; J83-B-5469
(ucs-set-char #x5903 ?$(H!:(B) ; C02-H-213A
(ucs-set-char #x5904 ?$(I"5(B) ; C03-I-2235
(ucs-set-char #x5904 ?$A4&(B) ; GB0-A-3426
(ucs-set-char #x5905 ?$(D8_(B) ; J90-D-385F
(ucs-set-char #x5905 ?$(I#D(B) ; C03-I-2344
(ucs-set-char #x5906 ?$(D8`(B) ; J90-D-3860
(ucs-set-char #x5906 ?$(H#P(B) ; C02-H-2350
(ucs-set-char #x5907 ?$A18(B) ; GB0-A-3138
(ucs-set-char #x5908 ?$(I+z(B) ; C03-I-2B7A
(ucs-set-char #x5909 ?$(I+y(B) ; C03-I-2B79
(ucs-set-char #x5909 ?$@JQ(B) ; J78-@-4A51
(ucs-set-char #x5909 ?$BJQ(B) ; J83-B-4A51

(ucs-set-char #x590A ?$(I!:(B) ; C03-I-213A
(ucs-set-char #x590A ?$@Tj(B) ; J78-@-546A
(ucs-set-char #x590A ?$BTj(B) ; J83-B-546A

(ucs-set-char #x590B ?$(D8a(B) ; J90-D-3861
(ucs-set-char #x590B ?$(I%F(B) ; C03-I-2546
(ucs-set-char #x590C ?$(D8b(B) ; J90-D-3862
(ucs-set-char #x590C ?$(H&#(B) ; C02-H-2623
(ucs-set-char #x590D ?$(H)a(B) ; C02-H-2961
(ucs-set-char #x590D ?$A84(B) ; GB0-A-3834
(ucs-set-char #x590E ?$(H.[(B) ; C02-H-2E5B
(ucs-set-char #x590F ?$(Cy>(B) ; KS0-C-793E
(ucs-set-char #x590F ?$(GTn(B) ; C01-G-546E
(ucs-set-char #x590F ?$@2F(B) ; J78-@-3246
(ucs-set-char #x590F ?$AOD(B) ; GB0-A-4F44
(ucs-set-char #x590F ?$B2F(B) ; J83-B-3246
(ucs-set-char #x5910 ?$(IFF(B) ; C03-I-4646
(ucs-set-char #x5910 ?$@Tk(B) ; J78-@-546B
(ucs-set-char #x5910 ?$BTk(B) ; J83-B-546B
(ucs-set-char #x5912 ?$(D8c(B) ; J90-D-3863
(ucs-set-char #x5912 ?$(HeE(B) ; C02-H-6545
(ucs-set-char #x5913 ?$(D8d(B) ; J90-D-3864
(ucs-set-char #x5913 ?$(J_R(B) ; C04-J-5F52
(ucs-set-char #x5914 ?$(CPs(B) ; KS0-C-5073
(ucs-set-char #x5914 ?$(D8e(B) ; J90-D-3865
(ucs-set-char #x5914 ?$(Gzg(B) ; C01-G-7A67
(ucs-set-char #x5914 ?$AYg(B) ; GB0-A-5967

(ucs-set-char #x5915 ?$AO&(B) ; GB0-A-4F26
(ucs-set-char #x5915 ?$(C`*(B) ; KS0-C-602A
(ucs-set-char #x5915 ?$(GDJ(B) ; C01-G-444A
(ucs-set-char #x5915 ?$@M<(B) ; J78-@-4D3C
(ucs-set-char #x5915 ?$BM<(B) ; J83-B-4D3C

(ucs-set-char #x5916 ?$(Chb(B) ; KS0-C-6862
(ucs-set-char #x5916 ?$(GF@(B) ; C01-G-4640
(ucs-set-char #x5916 ?$@30(B) ; J78-@-3330
(ucs-set-char #x5916 ?$AMb(B) ; GB0-A-4D62
(ucs-set-char #x5916 ?$B30(B) ; J83-B-3330
(ucs-set-char #x5917 ?$(H!Q(B) ; C02-H-2151
(ucs-set-char #x5918 ?$(I"6(B) ; C03-I-2236
(ucs-set-char #x5918 ?$@RI(B) ; J78-@-5249
(ucs-set-char #x5918 ?$BRI(B) ; J83-B-5249
(ucs-set-char #x5919 ?$(CbT(B) ; KS0-C-6254
(ucs-set-char #x5919 ?$(GGh(B) ; C01-G-4768
(ucs-set-char #x5919 ?$@=H(B) ; J78-@-3D48
(ucs-set-char #x5919 ?$AYm(B) ; GB0-A-596D
(ucs-set-char #x5919 ?$B=H(B) ; J83-B-3D48
(ucs-set-char #x591A ?$(CR}(B) ; KS0-C-527D
(ucs-set-char #x591A ?$(GGi(B) ; C01-G-4769
(ucs-set-char #x591A ?$@B?(B) ; J78-@-423F
(ucs-set-char #x591A ?$A6`(B) ; GB0-A-3660
(ucs-set-char #x591A ?$BB?(B) ; J83-B-423F
(ucs-set-char #x591B ?$(J"R(B) ; C04-J-2252
(ucs-set-char #x591B ?$@Tl(B) ; J78-@-546C
(ucs-set-char #x591B ?$BTl(B) ; J83-B-546C
(ucs-set-char #x591C ?$(Ce((B) ; KS0-C-6528
(ucs-set-char #x591C ?$(GL_(B) ; C01-G-4C5F
(ucs-set-char #x591C ?$@Lk(B) ; J78-@-4C6B
(ucs-set-char #x591C ?$AR9(B) ; GB0-A-5239
(ucs-set-char #x591C ?$BLk(B) ; J83-B-4C6B
(ucs-set-char #x591D ?$(D8g(B) ; J90-D-3867
(ucs-set-char #x591D ?$(J%p(B) ; C04-J-2570
(ucs-set-char #x591F ?$(I4y(B) ; C03-I-3479
(ucs-set-char #x591F ?$A9;(B) ; GB0-A-393B
(ucs-set-char #x5920 ?$(GY\(B) ; C01-G-595C
(ucs-set-char #x5921 ?$(D8h(B) ; J90-D-3868
(ucs-set-char #x5921 ?$(K7=(B) ; C05-K-373D
(ucs-set-char #x5922 ?$(CYS(B) ; KS0-C-5953
(ucs-set-char #x5922 ?$(GhB(B) ; C01-G-6842
(ucs-set-char #x5922 ?$(LQ^(B) ; C06-L-515E
(ucs-set-char #x5922 ?$@L4(B) ; J78-@-4C34
(ucs-set-char #x5922 ?$BL4(B) ; J83-B-4C34
(ucs-set-char #x5923 ?$(D8i(B) ; J90-D-3869
(ucs-set-char #x5923 ?$(I@_(B) ; C03-I-405F
(ucs-set-char #x5924 ?$(D8j(B) ; J90-D-386A
(ucs-set-char #x5924 ?$(GhC(B) ; C01-G-6843
(ucs-set-char #x5924 ?$Ab9(B) ; GB0-A-6239
(ucs-set-char #x5925 ?$(GhA(B) ; C01-G-6841
(ucs-set-char #x5925 ?$@Tn(B) ; J78-@-546E
(ucs-set-char #x5925 ?$Ab7(B) ; GB0-A-6237
(ucs-set-char #x5925 ?$BTn(B) ; J83-B-546E
(ucs-set-char #x5926 ?$(IKS(B) ; C03-I-4B53

(ucs-set-char #x5927 ?$A4s(B) ; GB0-A-3473
(ucs-set-char #x5927 ?$(CS^(B) ; KS0-C-535E
(ucs-set-char #x5927 ?$(GDK(B) ; C01-G-444B
(ucs-set-char #x5927 ?$@Bg(B) ; J78-@-4267
(ucs-set-char #x5927 ?$BBg(B) ; J83-B-4267

(ucs-set-char #x5928 ?$(D8k(B) ; J90-D-386B
(ucs-set-char #x5928 ?$(J!I(B) ; C04-J-2149
(ucs-set-char #x5929 ?$(Ct8(B) ; KS0-C-7438
(ucs-set-char #x5929 ?$(GE2(B) ; C01-G-4532
(ucs-set-char #x5929 ?$@E7(B) ; J78-@-4537
(ucs-set-char #x5929 ?$ALl(B) ; GB0-A-4C6C
(ucs-set-char #x5929 ?$BE7(B) ; J83-B-4537
(ucs-set-char #x592A ?$(Cw<(B) ; KS0-C-773C
(ucs-set-char #x592A ?$(GE4(B) ; C01-G-4534
(ucs-set-char #x592A ?$@B@(B) ; J78-@-4240
(ucs-set-char #x592A ?$AL+(B) ; GB0-A-4C2B
(ucs-set-char #x592A ?$BB@(B) ; J83-B-4240
(ucs-set-char #x592B ?$(C\}(B) ; KS0-C-5C7D
(ucs-set-char #x592B ?$(GE3(B) ; C01-G-4533
(ucs-set-char #x592B ?$@IW(B) ; J78-@-4957
(ucs-set-char #x592B ?$A7r(B) ; GB0-A-3772
(ucs-set-char #x592B ?$BIW(B) ; J83-B-4957
(ucs-set-char #x592C ?$(H!;(B) ; C02-H-213B
(ucs-set-char #x592C ?$@To(B) ; J78-@-546F
(ucs-set-char #x592C ?$BTo(B) ; J83-B-546F
(ucs-set-char #x592D ?$(Chl(B) ; KS0-C-686C
(ucs-set-char #x592D ?$(GE5(B) ; C01-G-4535
(ucs-set-char #x592D ?$@Tp(B) ; J78-@-5470
(ucs-set-char #x592D ?$AX2(B) ; GB0-A-5832
(ucs-set-char #x592D ?$BTp(B) ; J83-B-5470
(ucs-set-char #x592E ?$(Cdg(B) ; KS0-C-6467
(ucs-set-char #x592E ?$(GFA(B) ; C01-G-4641
(ucs-set-char #x592E ?$@1{(B) ; J78-@-317B
(ucs-set-char #x592E ?$AQk(B) ; GB0-A-516B
(ucs-set-char #x592E ?$B1{(B) ; J83-B-317B
(ucs-set-char #x592F ?$(D8l(B) ; J90-D-386C
(ucs-set-char #x592F ?$(H!R(B) ; C02-H-2152
(ucs-set-char #x592F ?$A:;(B) ; GB0-A-3A3B
(ucs-set-char #x5930 ?$(D8m(B) ; J90-D-386D
(ucs-set-char #x5930 ?$(I"8(B) ; C03-I-2238
(ucs-set-char #x5931 ?$(Ccw(B) ; KS0-C-6377
(ucs-set-char #x5931 ?$(GFB(B) ; C01-G-4642
(ucs-set-char #x5931 ?$@<:(B) ; J78-@-3C3A
(ucs-set-char #x5931 ?$AJ'(B) ; GB0-A-4A27
(ucs-set-char #x5931 ?$B<:(B) ; J83-B-3C3A
(ucs-set-char #x5932 ?$(I"7(B) ; C03-I-2237
(ucs-set-char #x5932 ?$@Tq(B) ; J78-@-5471
(ucs-set-char #x5932 ?$BTq(B) ; J83-B-5471
(ucs-set-char #x5933 ?$(D8n(B) ; J90-D-386E
(ucs-set-char #x5933 ?$(J!r(B) ; C04-J-2172
(ucs-set-char #x5934 ?$(I"9(B) ; C03-I-2239
(ucs-set-char #x5934 ?$AM7(B) ; GB0-A-4D37
(ucs-set-char #x5935 ?$(D8o(B) ; J90-D-386F
(ucs-set-char #x5935 ?$(J"S(B) ; C04-J-2253
(ucs-set-char #x5936 ?$(D8p(B) ; J90-D-3870
(ucs-set-char #x5936 ?$(I#G(B) ; C03-I-2347
(ucs-set-char #x5937 ?$(Cl((B) ; KS0-C-6C28
(ucs-set-char #x5937 ?$(GGj(B) ; C01-G-476A
(ucs-set-char #x5937 ?$@0P(B) ; J78-@-3050
(ucs-set-char #x5937 ?$ARD(B) ; GB0-A-5244
(ucs-set-char #x5937 ?$B0P(B) ; J83-B-3050
(ucs-set-char #x5938 ?$(GGk(B) ; C01-G-476B
(ucs-set-char #x5938 ?$@Tr(B) ; J78-@-5472
(ucs-set-char #x5938 ?$A?d(B) ; GB0-A-3F64
(ucs-set-char #x5938 ?$BTr(B) ; J83-B-5472
(ucs-set-char #x5939 ?$A<P(B) ; GB0-A-3C50
(ucs-set-char #x593A ?$A6a(B) ; GB0-A-3661
(ucs-set-char #x593C ?$(H"+(B) ; C02-H-222B
(ucs-set-char #x593C ?$A^E(B) ; GB0-A-5E45
(ucs-set-char #x593D ?$(I%I(B) ; C03-I-2549
(ucs-set-char #x593E ?$(Czq(B) ; KS0-C-7A71
(ucs-set-char #x593E ?$(GIh(B) ; C01-G-4968
(ucs-set-char #x593E ?$@Ts(B) ; J78-@-5473
(ucs-set-char #x593E ?$BTs(B) ; J83-B-5473
(ucs-set-char #x593F ?$(D8q(B) ; J90-D-3871
(ucs-set-char #x593F ?$(J#b(B) ; C04-J-2362
(ucs-set-char #x5940 ?$(H#Q(B) ; C02-H-2351
(ucs-set-char #x5941 ?$A^F(B) ; GB0-A-5E46
(ucs-set-char #x5942 ?$A[<(B) ; GB0-A-5B3C
(ucs-set-char #x5943 ?$(D8r(B) ; J90-D-3872
(ucs-set-char #x5943 ?$(J%u(B) ; C04-J-2575
(ucs-set-char #x5944 ?$(Cer(B) ; KS0-C-6572
(ucs-set-char #x5944 ?$(GLc(B) ; C01-G-4C63
(ucs-set-char #x5944 ?$@1b(B) ; J78-@-3162
(ucs-set-char #x5944 ?$AQY(B) ; GB0-A-5159
(ucs-set-char #x5944 ?$B1b(B) ; J83-B-3162
(ucs-set-char #x5945 ?$(H&$(B) ; C02-H-2624
(ucs-set-char #x5946 ?$(D8s(B) ; J90-D-3873
(ucs-set-char #x5946 ?$(J%r(B) ; C04-J-2572
(ucs-set-char #x5947 ?$(CPt(B) ; KS0-C-5074
(ucs-set-char #x5947 ?$(GLa(B) ; C01-G-4C61
(ucs-set-char #x5947 ?$@4q(B) ; J78-@-3471
(ucs-set-char #x5947 ?$AFf(B) ; GB0-A-4666
(ucs-set-char #x5947 ?$B4q(B) ; J83-B-3471
(ucs-set-char #x5948 ?$(CR/(B) ; KS0-C-522F
(ucs-set-char #x5948 ?$(GLb(B) ; C01-G-4C62
(ucs-set-char #x5948 ?$@F`(B) ; J78-@-4660
(ucs-set-char #x5948 ?$ADN(B) ; GB0-A-444E
(ucs-set-char #x5948 ?$BF`(B) ; J83-B-4660
(ucs-set-char #x5949 ?$(C\e(B) ; KS0-C-5C65
(ucs-set-char #x5949 ?$(GL`(B) ; C01-G-4C60
(ucs-set-char #x5949 ?$@Jt(B) ; J78-@-4A74
(ucs-set-char #x5949 ?$A7n(B) ; GB0-A-376E
(ucs-set-char #x5949 ?$BJt(B) ; J83-B-4A74
(ucs-set-char #x594A ?$(H.\(B) ; C02-H-2E5C
(ucs-set-char #x594B ?$(I(.(B) ; C03-I-282E
(ucs-set-char #x594B ?$A7\(B) ; GB0-A-375C
(ucs-set-char #x594C ?$(I(/(B) ; C03-I-282F
(ucs-set-char #x594E ?$(CP%(B) ; KS0-C-5025
(ucs-set-char #x594E ?$(GPX(B) ; C01-G-5058
(ucs-set-char #x594E ?$@Tw(B) ; J78-@-5477
(ucs-set-char #x594E ?$A?|(B) ; GB0-A-3F7C
(ucs-set-char #x594E ?$BTw(B) ; J83-B-5477
(ucs-set-char #x594F ?$(Cq4(B) ; KS0-C-7134
(ucs-set-char #x594F ?$(GPW(B) ; C01-G-5057
(ucs-set-char #x594F ?$@AU(B) ; J78-@-4155
(ucs-set-char #x594F ?$AW`(B) ; GB0-A-5760
(ucs-set-char #x594F ?$BAU(B) ; J83-B-4155
(ucs-set-char #x5950 ?$(C|1(B) ; KS0-C-7C31
(ucs-set-char #x5950 ?$(GPY(B) ; C01-G-5059
(ucs-set-char #x5950 ?$@Tv(B) ; J78-@-5476
(ucs-set-char #x5950 ?$BTv(B) ; J83-B-5476
(ucs-set-char #x5951 ?$(CLx(B) ; KS0-C-4C78
(ucs-set-char #x5951 ?$(GPV(B) ; C01-G-5056
(ucs-set-char #x5951 ?$@7@(B) ; J78-@-3740
(ucs-set-char #x5951 ?$AFu(B) ; GB0-A-4675
(ucs-set-char #x5951 ?$B7@(B) ; J83-B-3740
(ucs-set-char #x5952 ?$(D8t(B) ; J90-D-3874
(ucs-set-char #x5952 ?$(I+|(B) ; C03-I-2B7C
(ucs-set-char #x5953 ?$(D8u(B) ; J90-D-3875
(ucs-set-char #x5953 ?$(H)b(B) ; C02-H-2962
(ucs-set-char #x5954 ?$(C]F(B) ; KS0-C-5D46
(ucs-set-char #x5954 ?$(GLd(B) ; C01-G-4C64
(ucs-set-char #x5954 ?$@K[(B) ; J78-@-4B5B
(ucs-set-char #x5954 ?$A1<(B) ; GB0-A-313C
(ucs-set-char #x5954 ?$BK[(B) ; J83-B-4B5B
(ucs-set-char #x5955 ?$(CzQ(B) ; KS0-C-7A51
(ucs-set-char #x5955 ?$(GPU(B) ; C01-G-5055
(ucs-set-char #x5955 ?$@Tu(B) ; J78-@-5475
(ucs-set-char #x5955 ?$A^H(B) ; GB0-A-5E48
(ucs-set-char #x5955 ?$BTu(B) ; J83-B-5475
(ucs-set-char #x5956 ?$A=1(B) ; GB0-A-3D31
(ucs-set-char #x5957 ?$(Cw_(B) ; KS0-C-775F
(ucs-set-char #x5957 ?$(GTo(B) ; C01-G-546F
(ucs-set-char #x5957 ?$@Ee(B) ; J78-@-4565
(ucs-set-char #x5957 ?$ALW(B) ; GB0-A-4C57
(ucs-set-char #x5957 ?$BEe(B) ; J83-B-4565
(ucs-set-char #x5958 ?$(GTp(B) ; C01-G-5470
(ucs-set-char #x5958 ?$@Ty(B) ; J78-@-5479
(ucs-set-char #x5958 ?$A^J(B) ; GB0-A-5E4A
(ucs-set-char #x5958 ?$BTy(B) ; J83-B-5479
(ucs-set-char #x5959 ?$(D8v(B) ; J90-D-3876
(ucs-set-char #x5959 ?$(J,8(B) ; C04-J-2C38
(ucs-set-char #x595A ?$(Cz((B) ; KS0-C-7A28
(ucs-set-char #x595A ?$(GTq(B) ; C01-G-5471
(ucs-set-char #x595A ?$@Tx(B) ; J78-@-5478
(ucs-set-char #x595A ?$A^I(B) ; GB0-A-5E49
(ucs-set-char #x595A ?$BTx(B) ; J83-B-5478
(ucs-set-char #x595B ?$(D8w(B) ; J90-D-3877
(ucs-set-char #x595B ?$(I4{(B) ; C03-I-347B
(ucs-set-char #x595C ?$(H4P(B) ; C02-H-3450
(ucs-set-char #x595D ?$(D8x(B) ; J90-D-3878
(ucs-set-char #x595D ?$(I4|(B) ; C03-I-347C
(ucs-set-char #x595E ?$(D8y(B) ; J90-D-3879
(ucs-set-char #x595E ?$(I4}(B) ; C03-I-347D
(ucs-set-char #x595F ?$(D8z(B) ; J90-D-387A
(ucs-set-char #x595F ?$(J1&(B) ; C04-J-3126
(ucs-set-char #x5960 ?$(Cnu(B) ; KS0-C-6E75
(ucs-set-char #x5960 ?$(G^d(B) ; C01-G-5E64
(ucs-set-char #x5960 ?$@T{(B) ; J78-@-547B
(ucs-set-char #x5960 ?$A5l(B) ; GB0-A-356C
(ucs-set-char #x5960 ?$BT{(B) ; J83-B-547B
(ucs-set-char #x5961 ?$(D8{(B) ; J90-D-387B
(ucs-set-char #x5961 ?$(H:v(B) ; C02-H-3A76
(ucs-set-char #x5962 ?$(C^N(B) ; KS0-C-5E4E
(ucs-set-char #x5962 ?$(GY](B) ; C01-G-595D
(ucs-set-char #x5962 ?$(LGV(B) ; C06-L-4756
(ucs-set-char #x5962 ?$@Tz(B) ; J78-@-547A
(ucs-set-char #x5962 ?$AI](B) ; GB0-A-495D
(ucs-set-char #x5962 ?$BTz(B) ; J83-B-547A
(ucs-set-char #x5963 ?$(D8|(B) ; J90-D-387C
(ucs-set-char #x5963 ?$(I:S(B) ; C03-I-3A53
(ucs-set-char #x5964 ?$(I:T(B) ; C03-I-3A54
(ucs-set-char #x5965 ?$(J6y(B) ; C04-J-3679
(ucs-set-char #x5965 ?$@1|(B) ; J78-@-317C
(ucs-set-char #x5965 ?$A0B(B) ; GB0-A-3042
(ucs-set-char #x5965 ?$B1|(B) ; J83-B-317C
(ucs-set-char #x5966 ?$(I@`(B) ; C03-I-4060
(ucs-set-char #x5967 ?$(Cgs(B) ; KS0-C-6773
(ucs-set-char #x5967 ?$(Gc_(B) ; C01-G-635F
(ucs-set-char #x5967 ?$@T|(B) ; J78-@-547C
(ucs-set-char #x5967 ?$BT|(B) ; J83-B-547C
(ucs-set-char #x5968 ?$(I@a(B) ; C03-I-4061
(ucs-set-char #x5968 ?$@>)(B) ; J78-@-3E29
(ucs-set-char #x5968 ?$B>)(B) ; J83-B-3E29
(ucs-set-char #x5969 ?$(GhE(B) ; C01-G-6845
(ucs-set-char #x5969 ?$@T~(B) ; J78-@-547E
(ucs-set-char #x5969 ?$BT~(B) ; J83-B-547E
(ucs-set-char #x596A ?$(Cw,(B) ; KS0-C-772C
(ucs-set-char #x596A ?$(GhD(B) ; C01-G-6844
(ucs-set-char #x596A ?$@C%(B) ; J78-@-4325
(ucs-set-char #x596A ?$BC%(B) ; J83-B-4325
(ucs-set-char #x596B ?$(CkD(B) ; KS0-C-6B44
(ucs-set-char #x596B ?$(D8}(B) ; J90-D-387D
(ucs-set-char #x596B ?$(HIQ(B) ; C02-H-4951
(ucs-set-char #x596C ?$(Cma(B) ; KS0-C-6D61
(ucs-set-char #x596C ?$(IFH(B) ; C03-I-4648
(ucs-set-char #x596C ?$@T}(B) ; J78-@-547D
(ucs-set-char #x596C ?$BT}(B) ; J83-B-547D
(ucs-set-char #x596D ?$(C`+(B) ; KS0-C-602B
(ucs-set-char #x596D ?$(D8~(B) ; J90-D-387E
(ucs-set-char #x596D ?$(GlG(B) ; C01-G-6C47
(ucs-set-char #x596E ?$(C]G(B) ; KS0-C-5D47
(ucs-set-char #x596E ?$(GpM(B) ; C01-G-704D
(ucs-set-char #x596E ?$@J3(B) ; J78-@-4A33
(ucs-set-char #x596E ?$BJ3(B) ; J83-B-4A33
(ucs-set-char #x596F ?$(D9!(B) ; J90-D-3921
(ucs-set-char #x596F ?$(JO{(B) ; C04-J-4F7B
(ucs-set-char #x5970 ?$(HaL(B) ; C02-H-614C
(ucs-set-char #x5971 ?$(HmH(B) ; C02-H-6D48
(ucs-set-char #x5972 ?$(D9"(B) ; J90-D-3922
(ucs-set-char #x5972 ?$(Ho#(B) ; C02-H-6F23

(ucs-set-char #x5973 ?$AE.(B) ; GB0-A-452E
(ucs-set-char #x5973 ?$(CR3(B) ; KS0-C-5233
(ucs-set-char #x5973 ?$(GDL(B) ; C01-G-444C
(ucs-set-char #x5973 ?$@=w(B) ; J78-@-3D77
(ucs-set-char #x5973 ?$B=w(B) ; J83-B-3D77

(ucs-set-char #x5974 ?$(CR?(B) ; KS0-C-523F
(ucs-set-char #x5974 ?$(GFC(B) ; C01-G-4643
(ucs-set-char #x5974 ?$@E[(B) ; J78-@-455B
(ucs-set-char #x5974 ?$AE+(B) ; GB0-A-452B
(ucs-set-char #x5974 ?$BE[(B) ; J83-B-455B
(ucs-set-char #x5975 ?$(D9#(B) ; J90-D-3923
(ucs-set-char #x5975 ?$(I";(B) ; C03-I-223B
(ucs-set-char #x5976 ?$(D9$(B) ; J90-D-3924
(ucs-set-char #x5976 ?$(GFD(B) ; C01-G-4644
(ucs-set-char #x5976 ?$ADL(B) ; GB0-A-444C
(ucs-set-char #x5977 ?$(H"1(B) ; C02-H-2231
(ucs-set-char #x5978 ?$(CJL(B) ; KS0-C-4A4C
(ucs-set-char #x5978 ?$(GGm(B) ; C01-G-476D
(ucs-set-char #x5978 ?$@U!(B) ; J78-@-5521
(ucs-set-char #x5978 ?$A<i(B) ; GB0-A-3C69
(ucs-set-char #x5978 ?$BU!(B) ; J83-B-5521
(ucs-set-char #x5979 ?$(D9%(B) ; J90-D-3925
(ucs-set-char #x5979 ?$(GGp(B) ; C01-G-4770
(ucs-set-char #x5979 ?$AK}(B) ; GB0-A-4B7D
(ucs-set-char #x597A ?$(I#K(B) ; C03-I-234B
(ucs-set-char #x597B ?$(D9&(B) ; J90-D-3926
(ucs-set-char #x597B ?$(H"/(B) ; C02-H-222F
(ucs-set-char #x597C ?$(D9'(B) ; J90-D-3927
(ucs-set-char #x597C ?$(H"-(B) ; C02-H-222D
(ucs-set-char #x597D ?$(C{?(B) ; KS0-C-7B3F
(ucs-set-char #x597D ?$(GGo(B) ; C01-G-476F
(ucs-set-char #x597D ?$@9%(B) ; J78-@-3925
(ucs-set-char #x597D ?$A:C(B) ; GB0-A-3A43
(ucs-set-char #x597D ?$B9%(B) ; J83-B-3925
(ucs-set-char #x597E ?$(H"0(B) ; C02-H-2230
(ucs-set-char #x597F ?$(H"2(B) ; C02-H-2232
(ucs-set-char #x5980 ?$(H",(B) ; C02-H-222C
(ucs-set-char #x5981 ?$(GGr(B) ; C01-G-4772
(ucs-set-char #x5981 ?$@U"(B) ; J78-@-5522
(ucs-set-char #x5981 ?$Aey(B) ; GB0-A-6579
(ucs-set-char #x5981 ?$BU"(B) ; J83-B-5522
(ucs-set-char #x5982 ?$(Ce}(B) ; KS0-C-657D
(ucs-set-char #x5982 ?$(GGq(B) ; C01-G-4771
(ucs-set-char #x5982 ?$@G!(B) ; J78-@-4721
(ucs-set-char #x5982 ?$AHg(B) ; GB0-A-4867
(ucs-set-char #x5982 ?$BG!(B) ; J83-B-4721
(ucs-set-char #x5983 ?$(C]e(B) ; KS0-C-5D65
(ucs-set-char #x5983 ?$(GGn(B) ; C01-G-476E
(ucs-set-char #x5983 ?$@H^(B) ; J78-@-485E
(ucs-set-char #x5983 ?$Aez(B) ; GB0-A-657A
(ucs-set-char #x5983 ?$BH^(B) ; J83-B-485E
(ucs-set-char #x5984 ?$(CXM(B) ; KS0-C-584D
(ucs-set-char #x5984 ?$(GGl(B) ; C01-G-476C
(ucs-set-char #x5984 ?$@LQ(B) ; J78-@-4C51
(ucs-set-char #x5984 ?$AM}(B) ; GB0-A-4D7D
(ucs-set-char #x5984 ?$BLQ(B) ; J83-B-4C51
(ucs-set-char #x5985 ?$(H".(B) ; C02-H-222E
(ucs-set-char #x5986 ?$(I#M(B) ; C03-I-234D
(ucs-set-char #x5986 ?$AW1(B) ; GB0-A-5731
(ucs-set-char #x5987 ?$A8>(B) ; GB0-A-383E
(ucs-set-char #x5988 ?$ABh(B) ; GB0-A-4268
(ucs-set-char #x5989 ?$(I%U(B) ; C03-I-2555
(ucs-set-char #x598A ?$(Clt(B) ; KS0-C-6C74
(ucs-set-char #x598A ?$(GIs(B) ; C01-G-4973
(ucs-set-char #x598A ?$@G%(B) ; J78-@-4725
(ucs-set-char #x598A ?$AHQ(B) ; GB0-A-4851
(ucs-set-char #x598A ?$BG%(B) ; J83-B-4725
(ucs-set-char #x598B ?$(D9((B) ; J90-D-3928
(ucs-set-char #x598B ?$(J#g(B) ; C04-J-2367
(ucs-set-char #x598C ?$(D9)(B) ; J90-D-3929
(ucs-set-char #x598C ?$(I%L(B) ; C03-I-254C
(ucs-set-char #x598D ?$(GIp(B) ; C01-G-4970
(ucs-set-char #x598D ?$@U+(B) ; J78-@-552B
(ucs-set-char #x598D ?$Ae{(B) ; GB0-A-657B
(ucs-set-char #x598D ?$BU+(B) ; J83-B-552B
(ucs-set-char #x598E ?$(D9*(B) ; J90-D-392A
(ucs-set-char #x598E ?$(H#V(B) ; C02-H-2356
(ucs-set-char #x598F ?$(H#Y(B) ; C02-H-2359
(ucs-set-char #x5990 ?$(H#X(B) ; C02-H-2358
(ucs-set-char #x5991 ?$(J#i(B) ; C04-J-2369
(ucs-set-char #x5992 ?$(D9+(B) ; J90-D-392B
(ucs-set-char #x5992 ?$(GIj(B) ; C01-G-496A
(ucs-set-char #x5992 ?$A6J(B) ; GB0-A-364A
(ucs-set-char #x5993 ?$(CPu(B) ; KS0-C-5075
(ucs-set-char #x5993 ?$(GIr(B) ; C01-G-4972
(ucs-set-char #x5993 ?$@58(B) ; J78-@-3538
(ucs-set-char #x5993 ?$A<K(B) ; GB0-A-3C4B
(ucs-set-char #x5993 ?$B58(B) ; J83-B-3538
(ucs-set-char #x5994 ?$(I%K(B) ; C03-I-254B
(ucs-set-char #x5995 ?$(D9,(B) ; J90-D-392C
(ucs-set-char #x5995 ?$(J#j(B) ; C04-J-236A
(ucs-set-char #x5996 ?$(Chm(B) ; KS0-C-686D
(ucs-set-char #x5996 ?$(GIo(B) ; C01-G-496F
(ucs-set-char #x5996 ?$@ME(B) ; J78-@-4D45
(ucs-set-char #x5996 ?$AQ}(B) ; GB0-A-517D
(ucs-set-char #x5996 ?$BME(B) ; J83-B-4D45
(ucs-set-char #x5997 ?$(CPR(B) ; KS0-C-5052
(ucs-set-char #x5997 ?$(D9-(B) ; J90-D-392D
(ucs-set-char #x5997 ?$(H#U(B) ; C02-H-2355
(ucs-set-char #x5997 ?$Af!(B) ; GB0-A-6621
(ucs-set-char #x5998 ?$(H#S(B) ; C02-H-2353
(ucs-set-char #x5999 ?$(CYX(B) ; KS0-C-5958
(ucs-set-char #x5999 ?$(GIn(B) ; C01-G-496E
(ucs-set-char #x5999 ?$@L/(B) ; J78-@-4C2F
(ucs-set-char #x5999 ?$ACn(B) ; GB0-A-436E
(ucs-set-char #x5999 ?$BL/(B) ; J83-B-4C2F
(ucs-set-char #x599A ?$(I%V(B) ; C03-I-2556
(ucs-set-char #x599B ?$(I%S(B) ; C03-I-2553
(ucs-set-char #x599B ?$@V,(B) ; J78-@-562C
(ucs-set-char #x599B ?$BV,(B) ; J83-B-562C
(ucs-set-char #x599C ?$(I%N(B) ; C03-I-254E
(ucs-set-char #x599D ?$(GIi(B) ; C01-G-4969
(ucs-set-char #x599D ?$@U#(B) ; J78-@-5523
(ucs-set-char #x599D ?$BU#(B) ; J83-B-5523
(ucs-set-char #x599E ?$(GIl(B) ; C01-G-496C
(ucs-set-char #x599E ?$Af$(B) ; GB0-A-6624
(ucs-set-char #x599F ?$(D9.(B) ; J90-D-392E
(ucs-set-char #x599F ?$(I%Q(B) ; C03-I-2551
(ucs-set-char #x59A0 ?$(H#T(B) ; C02-H-2354
(ucs-set-char #x59A1 ?$(H#[(B) ; C02-H-235B
(ucs-set-char #x59A2 ?$(H#W(B) ; C02-H-2357
(ucs-set-char #x59A3 ?$(GIm(B) ; C01-G-496D
(ucs-set-char #x59A3 ?$@U&(B) ; J78-@-5526
(ucs-set-char #x59A3 ?$Ae~(B) ; GB0-A-657E
(ucs-set-char #x59A3 ?$BU&(B) ; J83-B-5526
(ucs-set-char #x59A4 ?$(D9/(B) ; J90-D-392F
(ucs-set-char #x59A4 ?$(GIq(B) ; C01-G-4971
(ucs-set-char #x59A4 ?$Af%(B) ; GB0-A-6625
(ucs-set-char #x59A5 ?$(Cvf(B) ; KS0-C-7666
(ucs-set-char #x59A5 ?$(GIt(B) ; C01-G-4974
(ucs-set-char #x59A5 ?$@BE(B) ; J78-@-4245
(ucs-set-char #x59A5 ?$AMW(B) ; GB0-A-4D57
(ucs-set-char #x59A5 ?$BBE(B) ; J83-B-4245
(ucs-set-char #x59A6 ?$(H#R(B) ; C02-H-2352
(ucs-set-char #x59A7 ?$(D90(B) ; J90-D-3930
(ucs-set-char #x59A7 ?$(H#Z(B) ; C02-H-235A
(ucs-set-char #x59A8 ?$(C[*(B) ; KS0-C-5B2A
(ucs-set-char #x59A8 ?$(GIk(B) ; C01-G-496B
(ucs-set-char #x59A8 ?$@K8(B) ; J78-@-4B38
(ucs-set-char #x59A8 ?$A7A(B) ; GB0-A-3741
(ucs-set-char #x59A8 ?$BK8(B) ; J83-B-4B38
(ucs-set-char #x59A9 ?$Ae|(B) ; GB0-A-657C
(ucs-set-char #x59AA ?$Ae}(B) ; GB0-A-657D
(ucs-set-char #x59AB ?$Af#(B) ; GB0-A-6623
(ucs-set-char #x59AC ?$(Cw`(B) ; KS0-C-7760
(ucs-set-char #x59AC ?$(I(A(B) ; C03-I-2841
(ucs-set-char #x59AC ?$@EJ(B) ; J78-@-454A
(ucs-set-char #x59AC ?$BEJ(B) ; J83-B-454A
(ucs-set-char #x59AD ?$(D91(B) ; J90-D-3931
(ucs-set-char #x59AD ?$(I(3(B) ; C03-I-2833
(ucs-set-char #x59AE ?$(D92(B) ; J90-D-3932
(ucs-set-char #x59AE ?$(GLi(B) ; C01-G-4C69
(ucs-set-char #x59AE ?$AD](B) ; GB0-A-445D
(ucs-set-char #x59AF ?$(D93(B) ; J90-D-3933
(ucs-set-char #x59AF ?$(GLq(B) ; C01-G-4C71
(ucs-set-char #x59AF ?$Af((B) ; GB0-A-6628
(ucs-set-char #x59B0 ?$(D94(B) ; J90-D-3934
(ucs-set-char #x59B0 ?$(I(8(B) ; C03-I-2838
(ucs-set-char #x59B1 ?$(H&0(B) ; C02-H-2630
(ucs-set-char #x59B2 ?$(H&)(B) ; C02-H-2629
(ucs-set-char #x59B2 ?$@U'(B) ; J78-@-5527
(ucs-set-char #x59B2 ?$Af'(B) ; GB0-A-6627
(ucs-set-char #x59B2 ?$BU'(B) ; J83-B-5527
(ucs-set-char #x59B3 ?$(D95(B) ; J90-D-3935
(ucs-set-char #x59B3 ?$(GLr(B) ; C01-G-4C72
(ucs-set-char #x59B4 ?$(H&4(B) ; C02-H-2634
(ucs-set-char #x59B5 ?$(H&%(B) ; C02-H-2625
(ucs-set-char #x59B6 ?$(H&,(B) ; C02-H-262C
(ucs-set-char #x59B7 ?$(D96(B) ; J90-D-3936
(ucs-set-char #x59B7 ?$(I(E(B) ; C03-I-2845
(ucs-set-char #x59B8 ?$(I(@(B) ; C03-I-2840
(ucs-set-char #x59B9 ?$(CXY(B) ; KS0-C-5859
(ucs-set-char #x59B9 ?$(GLh(B) ; C01-G-4C68
(ucs-set-char #x59B9 ?$@Ke(B) ; J78-@-4B65
(ucs-set-char #x59B9 ?$ACC(B) ; GB0-A-4343
(ucs-set-char #x59B9 ?$BKe(B) ; J83-B-4B65
(ucs-set-char #x59BA ?$(D97(B) ; J90-D-3937
(ucs-set-char #x59BA ?$(H&&(B) ; C02-H-2626
(ucs-set-char #x59BB ?$(Ct#(B) ; KS0-C-7423
(ucs-set-char #x59BB ?$(GLf(B) ; C01-G-4C66
(ucs-set-char #x59BB ?$@:J(B) ; J78-@-3A4A
(ucs-set-char #x59BB ?$AF^(B) ; GB0-A-465E
(ucs-set-char #x59BB ?$B:J(B) ; J83-B-3A4A
(ucs-set-char #x59BC ?$(D98(B) ; J90-D-3938
(ucs-set-char #x59BC ?$(H&-(B) ; C02-H-262D
(ucs-set-char #x59BD ?$(H&1(B) ; C02-H-2631
(ucs-set-char #x59BE ?$(Ct](B) ; KS0-C-745D
(ucs-set-char #x59BE ?$(GLe(B) ; C01-G-4C65
(ucs-set-char #x59BE ?$@>*(B) ; J78-@-3E2A
(ucs-set-char #x59BE ?$Af*(B) ; GB0-A-662A
(ucs-set-char #x59BE ?$B>*(B) ; J83-B-3E2A
(ucs-set-char #x59BF ?$(I(=(B) ; C03-I-283D
(ucs-set-char #x59C0 ?$(H&2(B) ; C02-H-2632
(ucs-set-char #x59C1 ?$(D99(B) ; J90-D-3939
(ucs-set-char #x59C1 ?$(H&+(B) ; C02-H-262B
(ucs-set-char #x59C2 ?$(I(7(B) ; C03-I-2837
(ucs-set-char #x59C3 ?$(CoQ(B) ; KS0-C-6F51
(ucs-set-char #x59C3 ?$(D9:(B) ; J90-D-393A
(ucs-set-char #x59C3 ?$(H&.(B) ; C02-H-262E
(ucs-set-char #x59C4 ?$(D9;(B) ; J90-D-393B
(ucs-set-char #x59C4 ?$(I(5(B) ; C03-I-2835
(ucs-set-char #x59C5 ?$(GLt(B) ; C01-G-4C74
(ucs-set-char #x59C6 ?$(CY5(B) ; KS0-C-5935
(ucs-set-char #x59C6 ?$(GLk(B) ; C01-G-4C6B
(ucs-set-char #x59C6 ?$@U((B) ; J78-@-5528
(ucs-set-char #x59C6 ?$AD7(B) ; GB0-A-4437
(ucs-set-char #x59C6 ?$BU((B) ; J83-B-5528
(ucs-set-char #x59C7 ?$(H&5(B) ; C02-H-2635
(ucs-set-char #x59C8 ?$(D9<(B) ; J90-D-393C
(ucs-set-char #x59C8 ?$(H&3(B) ; C02-H-2633
(ucs-set-char #x59C9 ?$(Cm+(B) ; KS0-C-6D2B
(ucs-set-char #x59C9 ?$(I(?(B) ; C03-I-283F
(ucs-set-char #x59C9 ?$@;P(B) ; J78-@-3B50
(ucs-set-char #x59C9 ?$B;P(B) ; J83-B-3B50
(ucs-set-char #x59CA ?$(D9=(B) ; J90-D-393D
(ucs-set-char #x59CA ?$(GLp(B) ; C01-G-4C70
(ucs-set-char #x59CA ?$Af"(B) ; GB0-A-6622
(ucs-set-char #x59CB ?$(Cc7(B) ; KS0-C-6337
(ucs-set-char #x59CB ?$(GLn(B) ; C01-G-4C6E
(ucs-set-char #x59CB ?$@;O(B) ; J78-@-3B4F
(ucs-set-char #x59CB ?$AJ<(B) ; GB0-A-4A3C
(ucs-set-char #x59CB ?$B;O(B) ; J83-B-3B4F
(ucs-set-char #x59CC ?$(H&*(B) ; C02-H-262A
(ucs-set-char #x59CD ?$(D9>(B) ; J90-D-393E
(ucs-set-char #x59CD ?$(GLm(B) ; C01-G-4C6D
(ucs-set-char #x59CE ?$(H&((B) ; C02-H-2628
(ucs-set-char #x59CF ?$(H&'(B) ; C02-H-2627
(ucs-set-char #x59D0 ?$(Cn;(B) ; KS0-C-6E3B
(ucs-set-char #x59D0 ?$(GLl(B) ; C01-G-4C6C
(ucs-set-char #x59D0 ?$@09(B) ; J78-@-3039
(ucs-set-char #x59D0 ?$A=c(B) ; GB0-A-3D63
(ucs-set-char #x59D0 ?$B09(B) ; J83-B-3039
(ucs-set-char #x59D1 ?$(CM4(B) ; KS0-C-4D34
(ucs-set-char #x59D1 ?$(GLj(B) ; C01-G-4C6A
(ucs-set-char #x59D1 ?$@8H(B) ; J78-@-3848
(ucs-set-char #x59D1 ?$A9C(B) ; GB0-A-3943
(ucs-set-char #x59D1 ?$B8H(B) ; J83-B-3848
(ucs-set-char #x59D2 ?$(D9?(B) ; J90-D-393F
(ucs-set-char #x59D2 ?$(GLs(B) ; C01-G-4C73
(ucs-set-char #x59D2 ?$Af&(B) ; GB0-A-6626
(ucs-set-char #x59D3 ?$(C`s(B) ; KS0-C-6073
(ucs-set-char #x59D3 ?$(GLo(B) ; C01-G-4C6F
(ucs-set-char #x59D3 ?$@@+(B) ; J78-@-402B
(ucs-set-char #x59D3 ?$APU(B) ; GB0-A-5055
(ucs-set-char #x59D3 ?$B@+(B) ; J83-B-402B
(ucs-set-char #x59D4 ?$(CjM(B) ; KS0-C-6A4D
(ucs-set-char #x59D4 ?$(GLg(B) ; C01-G-4C67
(ucs-set-char #x59D4 ?$@0Q(B) ; J78-@-3051
(ucs-set-char #x59D4 ?$AN/(B) ; GB0-A-4E2F
(ucs-set-char #x59D4 ?$B0Q(B) ; J83-B-3051
(ucs-set-char #x59D5 ?$(I,&(B) ; C03-I-2C26
(ucs-set-char #x59D6 ?$(H&/(B) ; C02-H-262F
(ucs-set-char #x59D7 ?$(I(F(B) ; C03-I-2846
(ucs-set-char #x59D7 ?$Af)(B) ; GB0-A-6629
(ucs-set-char #x59D8 ?$(GP[(B) ; C01-G-505B
(ucs-set-char #x59D8 ?$Af0(B) ; GB0-A-6630
(ucs-set-char #x59D9 ?$(Clu(B) ; KS0-C-6C75
(ucs-set-char #x59D9 ?$(I,-(B) ; C03-I-2C2D
(ucs-set-char #x59D9 ?$@U,(B) ; J78-@-552C
(ucs-set-char #x59D9 ?$BU,(B) ; J83-B-552C
(ucs-set-char #x59DA ?$(Chn(B) ; KS0-C-686E
(ucs-set-char #x59DA ?$(GPb(B) ; C01-G-5062
(ucs-set-char #x59DA ?$@U-(B) ; J78-@-552D
(ucs-set-char #x59DA ?$AR&(B) ; GB0-A-5226
(ucs-set-char #x59DA ?$BU-(B) ; J83-B-552D
(ucs-set-char #x59DB ?$(H)p(B) ; C02-H-2970
(ucs-set-char #x59DC ?$(CK)(B) ; KS0-C-4B29
(ucs-set-char #x59DC ?$(GPZ(B) ; C01-G-505A
(ucs-set-char #x59DC ?$@U*(B) ; J78-@-552A
(ucs-set-char #x59DC ?$A=*(B) ; GB0-A-3D2A
(ucs-set-char #x59DC ?$BU*(B) ; J83-B-552A
(ucs-set-char #x59DD ?$(Cq/(B) ; KS0-C-712F
(ucs-set-char #x59DD ?$(D9@(B) ; J90-D-3940
(ucs-set-char #x59DD ?$(H)h(B) ; C02-H-2968
(ucs-set-char #x59DD ?$Af-(B) ; GB0-A-662D
(ucs-set-char #x59DE ?$(D9A(B) ; J90-D-3941
(ucs-set-char #x59DE ?$(H)d(B) ; C02-H-2964
(ucs-set-char #x59DF ?$(D9B(B) ; J90-D-3942
(ucs-set-char #x59DF ?$(I,!(B) ; C03-I-2C21
(ucs-set-char #x59E0 ?$(H)t(B) ; C02-H-2974
(ucs-set-char #x59E1 ?$(H)c(B) ; C02-H-2963
(ucs-set-char #x59E2 ?$(I,,(B) ; C03-I-2C2C
(ucs-set-char #x59E3 ?$(D9C(B) ; J90-D-3943
(ucs-set-char #x59E3 ?$(GP](B) ; C01-G-505D
(ucs-set-char #x59E3 ?$Af/(B) ; GB0-A-662F
(ucs-set-char #x59E4 ?$(D9D(B) ; J90-D-3944
(ucs-set-char #x59E4 ?$(H)m(B) ; C02-H-296D
(ucs-set-char #x59E5 ?$(GP`(B) ; C01-G-5060
(ucs-set-char #x59E5 ?$@18(B) ; J78-@-3138
(ucs-set-char #x59E5 ?$A@Q(B) ; GB0-A-4051
(ucs-set-char #x59E5 ?$B18(B) ; J83-B-3138
(ucs-set-char #x59E6 ?$(CJM(B) ; KS0-C-4A4D
(ucs-set-char #x59E6 ?$(GPc(B) ; C01-G-5063
(ucs-set-char #x59E6 ?$@4/(B) ; J78-@-342F
(ucs-set-char #x59E6 ?$B4/(B) ; J83-B-342F
(ucs-set-char #x59E7 ?$(D9E(B) ; J90-D-3945
(ucs-set-char #x59E7 ?$(I,.(B) ; C03-I-2C2E
(ucs-set-char #x59E8 ?$(Cl)(B) ; KS0-C-6C29
(ucs-set-char #x59E8 ?$(GP^(B) ; C01-G-505E
(ucs-set-char #x59E8 ?$@U)(B) ; J78-@-5529
(ucs-set-char #x59E8 ?$ARL(B) ; GB0-A-524C
(ucs-set-char #x59E8 ?$BU)(B) ; J83-B-5529
(ucs-set-char #x59E9 ?$(H)q(B) ; C02-H-2971
(ucs-set-char #x59EA ?$(Crk(B) ; KS0-C-726B
(ucs-set-char #x59EA ?$(GPa(B) ; C01-G-5061
(ucs-set-char #x59EA ?$@LE(B) ; J78-@-4C45
(ucs-set-char #x59EA ?$BLE(B) ; J83-B-4C45
(ucs-set-char #x59EB ?$(I,#(B) ; C03-I-2C23
(ucs-set-char #x59EB ?$@I1(B) ; J78-@-4931
(ucs-set-char #x59EB ?$BI1(B) ; J83-B-4931
(ucs-set-char #x59EC ?$(C}o(B) ; KS0-C-7D6F
(ucs-set-char #x59EC ?$(GTx(B) ; C01-G-5478
(ucs-set-char #x59EC ?$A<'(B) ; GB0-A-3C27
(ucs-set-char #x59ED ?$(H)w(B) ; C02-H-2977
(ucs-set-char #x59EE ?$(Cys(B) ; KS0-C-7973
(ucs-set-char #x59EE ?$(D9F(B) ; J90-D-3946
(ucs-set-char #x59EE ?$(H)e(B) ; C02-H-2965
(ucs-set-char #x59EF ?$(D9G(B) ; J90-D-3947
(ucs-set-char #x59EF ?$(I,$(B) ; C03-I-2C24
(ucs-set-char #x59F0 ?$(I,%(B) ; C03-I-2C25
(ucs-set-char #x59F1 ?$(D9H(B) ; J90-D-3948
(ucs-set-char #x59F1 ?$(H)g(B) ; C02-H-2967
(ucs-set-char #x59F2 ?$(D9I(B) ; J90-D-3949
(ucs-set-char #x59F2 ?$(H)n(B) ; C02-H-296E
(ucs-set-char #x59F3 ?$(H)r(B) ; C02-H-2972
(ucs-set-char #x59F4 ?$(D9J(B) ; J90-D-394A
(ucs-set-char #x59F4 ?$(H)v(B) ; C02-H-2976
(ucs-set-char #x59F5 ?$(H)s(B) ; C02-H-2973
(ucs-set-char #x59F6 ?$(H)l(B) ; C02-H-296C
(ucs-set-char #x59F6 ?$@0((B) ; J78-@-3028
(ucs-set-char #x59F6 ?$B0((B) ; J83-B-3028
(ucs-set-char #x59F7 ?$(D9K(B) ; J90-D-394B
(ucs-set-char #x59F7 ?$(H)o(B) ; C02-H-296F
(ucs-set-char #x59F8 ?$(CfA(B) ; KS0-C-6641
(ucs-set-char #x59F8 ?$(I,+(B) ; C03-I-2C2B
(ucs-set-char #x59F9 ?$(I,)(B) ; C03-I-2C29
(ucs-set-char #x59F9 ?$Af1(B) ; GB0-A-6631
(ucs-set-char #x59FA ?$(H)i(B) ; C02-H-2969
(ucs-set-char #x59FB ?$(ClX(B) ; KS0-C-6C58
(ucs-set-char #x59FB ?$(GPe(B) ; C01-G-5065
(ucs-set-char #x59FB ?$@0y(B) ; J78-@-3079
(ucs-set-char #x59FB ?$ARv(B) ; GB0-A-5276
(ucs-set-char #x59FB ?$B0y(B) ; J83-B-3079
(ucs-set-char #x59FC ?$(H)k(B) ; C02-H-296B
(ucs-set-char #x59FD ?$(H)j(B) ; C02-H-296A
(ucs-set-char #x59FE ?$(H)u(B) ; C02-H-2975
(ucs-set-char #x59FF ?$(Cm,(B) ; KS0-C-6D2C
(ucs-set-char #x59FF ?$(GP\(B) ; C01-G-505C
(ucs-set-char #x59FF ?$@;Q(B) ; J78-@-3B51
(ucs-set-char #x59FF ?$AWK(B) ; GB0-A-574B
(ucs-set-char #x59FF ?$B;Q(B) ; J83-B-3B51
(ucs-set-char #x5A00 ?$(D9L(B) ; J90-D-394C
(ucs-set-char #x5A00 ?$(H)f(B) ; C02-H-2966
(ucs-set-char #x5A01 ?$(CjN(B) ; KS0-C-6A4E
(ucs-set-char #x5A01 ?$(GPd(B) ; C01-G-5064
(ucs-set-char #x5A01 ?$@0R(B) ; J78-@-3052
(ucs-set-char #x5A01 ?$AM~(B) ; GB0-A-4D7E
(ucs-set-char #x5A01 ?$B0R(B) ; J83-B-3052
(ucs-set-char #x5A02 ?$(I,*(B) ; C03-I-2C2A
(ucs-set-char #x5A03 ?$(Ch_(B) ; KS0-C-685F
(ucs-set-char #x5A03 ?$(GP_(B) ; C01-G-505F
(ucs-set-char #x5A03 ?$@0#(B) ; J78-@-3023
(ucs-set-char #x5A03 ?$AM^(B) ; GB0-A-4D5E
(ucs-set-char #x5A03 ?$B0#(B) ; J83-B-3023
(ucs-set-char #x5A04 ?$(D9M(B) ; J90-D-394D
(ucs-set-char #x5A04 ?$(I,((B) ; C03-I-2C28
(ucs-set-char #x5A04 ?$AB&(B) ; GB0-A-4226
(ucs-set-char #x5A05 ?$Af+(B) ; GB0-A-662B
(ucs-set-char #x5A06 ?$Af,(B) ; GB0-A-662C
(ucs-set-char #x5A07 ?$A=?(B) ; GB0-A-3D3F
(ucs-set-char #x5A08 ?$Af.(B) ; GB0-A-662E
(ucs-set-char #x5A09 ?$(GT~(B) ; C01-G-547E
(ucs-set-char #x5A09 ?$@U2(B) ; J78-@-5532
(ucs-set-char #x5A09 ?$Af3(B) ; GB0-A-6633
(ucs-set-char #x5A09 ?$BU2(B) ; J83-B-5532
(ucs-set-char #x5A0A ?$(H.d(B) ; C02-H-2E64
(ucs-set-char #x5A0B ?$(I0@(B) ; C03-I-3040
(ucs-set-char #x5A0C ?$(D9N(B) ; J90-D-394E
(ucs-set-char #x5A0C ?$(GT}(B) ; C01-G-547D
(ucs-set-char #x5A0C ?$Af2(B) ; GB0-A-6632
(ucs-set-char #x5A0D ?$(D9O(B) ; J90-D-394F
(ucs-set-char #x5A0D ?$(I,'(B) ; C03-I-2C27
(ucs-set-char #x5A0E ?$(D9P(B) ; J90-D-3950
(ucs-set-char #x5A0E ?$(J,@(B) ; C04-J-2C40
(ucs-set-char #x5A0F ?$(H.b(B) ; C02-H-2E62
(ucs-set-char #x5A10 ?$(J,>(B) ; C04-J-2C3E
(ucs-set-char #x5A11 ?$(C^O(B) ; KS0-C-5E4F
(ucs-set-char #x5A11 ?$(GTr(B) ; C01-G-5472
(ucs-set-char #x5A11 ?$@U0(B) ; J78-@-5530
(ucs-set-char #x5A11 ?$Af6(B) ; GB0-A-6636
(ucs-set-char #x5A11 ?$BU0(B) ; J83-B-5530
(ucs-set-char #x5A12 ?$(D9Q(B) ; J90-D-3951
(ucs-set-char #x5A12 ?$(I0O(B) ; C03-I-304F
(ucs-set-char #x5A13 ?$(D9R(B) ; J90-D-3952
(ucs-set-char #x5A13 ?$(GTw(B) ; C01-G-5477
(ucs-set-char #x5A13 ?$Af8(B) ; GB0-A-6638
(ucs-set-char #x5A14 ?$(I0J(B) ; C03-I-304A
(ucs-set-char #x5A15 ?$(H.a(B) ; C02-H-2E61
(ucs-set-char #x5A16 ?$(H.^(B) ; C02-H-2E5E
(ucs-set-char #x5A17 ?$(H.c(B) ; C02-H-2E63
(ucs-set-char #x5A18 ?$(CR&(B) ; KS0-C-5226
(ucs-set-char #x5A18 ?$(GTs(B) ; C01-G-5473
(ucs-set-char #x5A18 ?$@L<(B) ; J78-@-4C3C
(ucs-set-char #x5A18 ?$ADo(B) ; GB0-A-446F
(ucs-set-char #x5A18 ?$BL<(B) ; J83-B-4C3C
(ucs-set-char #x5A19 ?$(H.](B) ; C02-H-2E5D
(ucs-set-char #x5A1A ?$(I0N(B) ; C03-I-304E
(ucs-set-char #x5A1A ?$@U3(B) ; J78-@-5533
(ucs-set-char #x5A1A ?$BU3(B) ; J83-B-5533
(ucs-set-char #x5A1B ?$(Cgt(B) ; KS0-C-6774
(ucs-set-char #x5A1B ?$(GTv(B) ; C01-G-5476
(ucs-set-char #x5A1C ?$(CQV(B) ; KS0-C-5156
(ucs-set-char #x5A1C ?$(GTt(B) ; C01-G-5474
(ucs-set-char #x5A1C ?$@U1(B) ; J78-@-5531
(ucs-set-char #x5A1C ?$ADH(B) ; GB0-A-4448
(ucs-set-char #x5A1C ?$BU1(B) ; J83-B-5531
(ucs-set-char #x5A1D ?$(I0>(B) ; C03-I-303E
(ucs-set-char #x5A1E ?$(D9S(B) ; J90-D-3953
(ucs-set-char #x5A1E ?$(H.e(B) ; C02-H-2E65
(ucs-set-char #x5A1F ?$(CfB(B) ; KS0-C-6642
(ucs-set-char #x5A1F ?$(GTu(B) ; C01-G-5475
(ucs-set-char #x5A1F ?$@U/(B) ; J78-@-552F
(ucs-set-char #x5A1F ?$A>j(B) ; GB0-A-3E6A
(ucs-set-char #x5A1F ?$BU/(B) ; J83-B-552F
(ucs-set-char #x5A20 ?$(Ccc(B) ; KS0-C-6363
(ucs-set-char #x5A20 ?$(GTy(B) ; C01-G-5479
(ucs-set-char #x5A20 ?$@?1(B) ; J78-@-3F31
(ucs-set-char #x5A20 ?$AIo(B) ; GB0-A-496F
(ucs-set-char #x5A20 ?$B?1(B) ; J83-B-3F31
(ucs-set-char #x5A21 ?$(I0;(B) ; C03-I-303B
(ucs-set-char #x5A22 ?$(I0E(B) ; C03-I-3045
(ucs-set-char #x5A23 ?$(D9T(B) ; J90-D-3954
(ucs-set-char #x5A23 ?$(GTz(B) ; C01-G-547A
(ucs-set-char #x5A23 ?$Af7(B) ; GB0-A-6637
(ucs-set-char #x5A24 ?$(D9U(B) ; J90-D-3955
(ucs-set-char #x5A24 ?$(I0H(B) ; C03-I-3048
(ucs-set-char #x5A25 ?$(Cd0(B) ; KS0-C-6430
(ucs-set-char #x5A25 ?$(GT|(B) ; C01-G-547C
(ucs-set-char #x5A25 ?$@U.(B) ; J78-@-552E
(ucs-set-char #x5A25 ?$A6p(B) ; GB0-A-3670
(ucs-set-char #x5A25 ?$BU.(B) ; J83-B-552E
(ucs-set-char #x5A26 ?$(I0R(B) ; C03-I-3052
(ucs-set-char #x5A27 ?$(D9V(B) ; J90-D-3956
(ucs-set-char #x5A27 ?$(J,9(B) ; C04-J-2C39
(ucs-set-char #x5A28 ?$(D9W(B) ; J90-D-3957
(ucs-set-char #x5A28 ?$(J,=(B) ; C04-J-2C3D
(ucs-set-char #x5A29 ?$(CX4(B) ; KS0-C-5834
(ucs-set-char #x5A29 ?$(GT{(B) ; C01-G-547B
(ucs-set-char #x5A29 ?$@JZ(B) ; J78-@-4A5A
(ucs-set-char #x5A29 ?$ACd(B) ; GB0-A-4364
(ucs-set-char #x5A29 ?$BJZ(B) ; J83-B-4A5A
(ucs-set-char #x5A2A ?$(D9X(B) ; J90-D-3958
(ucs-set-char #x5A2A ?$(I0<(B) ; C03-I-303C
(ucs-set-char #x5A2B ?$(I5"(B) ; C03-I-3522
(ucs-set-char #x5A2C ?$(I58(B) ; C03-I-3538
(ucs-set-char #x5A2D ?$(D9Y(B) ; J90-D-3959
(ucs-set-char #x5A2D ?$(H._(B) ; C02-H-2E5F
(ucs-set-char #x5A2E ?$(H.`(B) ; C02-H-2E60
(ucs-set-char #x5A2F ?$(I0M(B) ; C03-I-304D
(ucs-set-char #x5A2F ?$@8d(B) ; J78-@-3864
(ucs-set-char #x5A2F ?$B8d(B) ; J83-B-3864
(ucs-set-char #x5A30 ?$(D9Z(B) ; J90-D-395A
(ucs-set-char #x5A30 ?$(L6W(B) ; C06-L-3657
(ucs-set-char #x5A31 ?$(I0K(B) ; C03-I-304B
(ucs-set-char #x5A31 ?$ASi(B) ; GB0-A-5369
(ucs-set-char #x5A32 ?$Af4(B) ; GB0-A-6634
(ucs-set-char #x5A33 ?$(H.f(B) ; C02-H-2E66
(ucs-set-char #x5A34 ?$Af5(B) ; GB0-A-6635
(ucs-set-char #x5A35 ?$(H4W(B) ; C02-H-3457
(ucs-set-char #x5A35 ?$@U7(B) ; J78-@-5537
(ucs-set-char #x5A35 ?$BU7(B) ; J83-B-5537
(ucs-set-char #x5A36 ?$(Cv%(B) ; KS0-C-7625
(ucs-set-char #x5A36 ?$(GY^(B) ; C01-G-595E
(ucs-set-char #x5A36 ?$@U8(B) ; J78-@-5538
(ucs-set-char #x5A36 ?$AH"(B) ; GB0-A-4822
(ucs-set-char #x5A36 ?$BU8(B) ; J83-B-5538
(ucs-set-char #x5A37 ?$(H;&(B) ; C02-H-3B26
(ucs-set-char #x5A38 ?$(H4V(B) ; C02-H-3456
(ucs-set-char #x5A39 ?$(H4i(B) ; C02-H-3469
(ucs-set-char #x5A3A ?$(I5((B) ; C03-I-3528
(ucs-set-char #x5A3B ?$(I5$(B) ; C03-I-3524
(ucs-set-char #x5A3C ?$(Cs^(B) ; KS0-C-735E
(ucs-set-char #x5A3C ?$(GYd(B) ; C01-G-5964
(ucs-set-char #x5A3C ?$@>+(B) ; J78-@-3E2B
(ucs-set-char #x5A3C ?$Af=(B) ; GB0-A-663D
(ucs-set-char #x5A3C ?$B>+(B) ; J83-B-3E2B
(ucs-set-char #x5A3D ?$(I51(B) ; C03-I-3531
(ucs-set-char #x5A3E ?$(H4g(B) ; C02-H-3467
(ucs-set-char #x5A3F ?$(I53(B) ; C03-I-3533
(ucs-set-char #x5A40 ?$(GYc(B) ; C01-G-5963
(ucs-set-char #x5A40 ?$@U4(B) ; J78-@-5534
(ucs-set-char #x5A40 ?$Af9(B) ; GB0-A-6639
(ucs-set-char #x5A40 ?$BU4(B) ; J83-B-5534
(ucs-set-char #x5A41 ?$(CW%(B) ; KS0-C-5725
(ucs-set-char #x5A41 ?$(GY_(B) ; C01-G-595F
(ucs-set-char #x5A41 ?$@O,(B) ; J78-@-4F2C
(ucs-set-char #x5A41 ?$BO,(B) ; J83-B-4F2C
(ucs-set-char #x5A42 ?$(H4p(B) ; C02-H-3470
(ucs-set-char #x5A43 ?$(H4`(B) ; C02-H-3460
(ucs-set-char #x5A44 ?$(D9[(B) ; J90-D-395B
(ucs-set-char #x5A44 ?$(H4c(B) ; C02-H-3463
(ucs-set-char #x5A45 ?$(D9\(B) ; J90-D-395C
(ucs-set-char #x5A45 ?$(I5.(B) ; C03-I-352E
(ucs-set-char #x5A46 ?$(Cwh(B) ; KS0-C-7768
(ucs-set-char #x5A46 ?$(GYg(B) ; C01-G-5967
(ucs-set-char #x5A46 ?$@GL(B) ; J78-@-474C
(ucs-set-char #x5A46 ?$AFE(B) ; GB0-A-4645
(ucs-set-char #x5A46 ?$BGL(B) ; J83-B-474C
(ucs-set-char #x5A47 ?$(D9](B) ; J90-D-395D
(ucs-set-char #x5A47 ?$(H4m(B) ; C02-H-346D
(ucs-set-char #x5A48 ?$(D9^(B) ; J90-D-395E
(ucs-set-char #x5A48 ?$(H4e(B) ; C02-H-3465
(ucs-set-char #x5A49 ?$(ChF(B) ; KS0-C-6846
(ucs-set-char #x5A49 ?$(GY`(B) ; C01-G-5960
(ucs-set-char #x5A49 ?$@U6(B) ; J78-@-5536
(ucs-set-char #x5A49 ?$AMq(B) ; GB0-A-4D71
(ucs-set-char #x5A49 ?$BU6(B) ; J83-B-5536
(ucs-set-char #x5A4A ?$(GYh(B) ; C01-G-5968
(ucs-set-char #x5A4A ?$Af;(B) ; GB0-A-663B
(ucs-set-char #x5A4B ?$(I5*(B) ; C03-I-352A
(ucs-set-char #x5A4C ?$(D9_(B) ; J90-D-395F
(ucs-set-char #x5A4C ?$(H4j(B) ; C02-H-346A
(ucs-set-char #x5A4D ?$(H4h(B) ; C02-H-3468
(ucs-set-char #x5A4E ?$(I5/(B) ; C03-I-352F
(ucs-set-char #x5A4F ?$(I5;(B) ; C03-I-353B
(ucs-set-char #x5A50 ?$(D9`(B) ; J90-D-3960
(ucs-set-char #x5A50 ?$(H4Y(B) ; C02-H-3459
(ucs-set-char #x5A51 ?$(H4n(B) ; C02-H-346E
(ucs-set-char #x5A52 ?$(H4b(B) ; C02-H-3462
(ucs-set-char #x5A53 ?$(H4](B) ; C02-H-345D
(ucs-set-char #x5A54 ?$(I5:(B) ; C03-I-353A
(ucs-set-char #x5A55 ?$(D9a(B) ; J90-D-3961
(ucs-set-char #x5A55 ?$(H4S(B) ; C02-H-3453
(ucs-set-char #x5A55 ?$Af<(B) ; GB0-A-663C
(ucs-set-char #x5A56 ?$(H4o(B) ; C02-H-346F
(ucs-set-char #x5A57 ?$(H4_(B) ; C02-H-345F
(ucs-set-char #x5A58 ?$(H4R(B) ; C02-H-3452
(ucs-set-char #x5A59 ?$(I59(B) ; C03-I-3539
(ucs-set-char #x5A5A ?$(C{f(B) ; KS0-C-7B66
(ucs-set-char #x5A5A ?$(GYf(B) ; C01-G-5966
(ucs-set-char #x5A5A ?$@:'(B) ; J78-@-3A27
(ucs-set-char #x5A5A ?$A;i(B) ; GB0-A-3B69
(ucs-set-char #x5A5A ?$B:'(B) ; J83-B-3A27
(ucs-set-char #x5A5B ?$(H4d(B) ; C02-H-3464
(ucs-set-char #x5A5C ?$(H4q(B) ; C02-H-3471
(ucs-set-char #x5A5D ?$(H4a(B) ; C02-H-3461
(ucs-set-char #x5A5E ?$(D9b(B) ; J90-D-3962
(ucs-set-char #x5A5E ?$(H4U(B) ; C02-H-3455
(ucs-set-char #x5A5F ?$(H4Z(B) ; C02-H-345A
(ucs-set-char #x5A60 ?$(H4Q(B) ; C02-H-3451
(ucs-set-char #x5A61 ?$(I5'(B) ; C03-I-3527
(ucs-set-char #x5A62 ?$(C]f(B) ; KS0-C-5D66
(ucs-set-char #x5A62 ?$(GYe(B) ; C01-G-5965
(ucs-set-char #x5A62 ?$@U9(B) ; J78-@-5539
(ucs-set-char #x5A62 ?$Af>(B) ; GB0-A-663E
(ucs-set-char #x5A62 ?$BU9(B) ; J83-B-5539
(ucs-set-char #x5A63 ?$(D9c(B) ; J90-D-3963
(ucs-set-char #x5A63 ?$(I5<(B) ; C03-I-353C
(ucs-set-char #x5A64 ?$(H4^(B) ; C02-H-345E
(ucs-set-char #x5A65 ?$(D9d(B) ; J90-D-3964
(ucs-set-char #x5A65 ?$(H4[(B) ; C02-H-345B
(ucs-set-char #x5A66 ?$(C\~(B) ; KS0-C-5C7E
(ucs-set-char #x5A66 ?$(GYa(B) ; C01-G-5961
(ucs-set-char #x5A66 ?$(L>P(B) ; C06-L-3E50
(ucs-set-char #x5A66 ?$@IX(B) ; J78-@-4958
(ucs-set-char #x5A66 ?$BIX(B) ; J83-B-4958
(ucs-set-char #x5A67 ?$(D9e(B) ; J90-D-3965
(ucs-set-char #x5A67 ?$(H4T(B) ; C02-H-3454
(ucs-set-char #x5A67 ?$Af:(B) ; GB0-A-663A
(ucs-set-char #x5A68 ?$(I50(B) ; C03-I-3530
(ucs-set-char #x5A69 ?$(H4l(B) ; C02-H-346C
(ucs-set-char #x5A6A ?$(GYb(B) ; C01-G-5962
(ucs-set-char #x5A6A ?$@U:(B) ; J78-@-553A
(ucs-set-char #x5A6A ?$A@7(B) ; GB0-A-4037
(ucs-set-char #x5A6A ?$BU:(B) ; J83-B-553A
(ucs-set-char #x5A6B ?$(I5+(B) ; C03-I-352B
(ucs-set-char #x5A6C ?$(H4\(B) ; C02-H-345C
(ucs-set-char #x5A6C ?$@U5(B) ; J78-@-5535
(ucs-set-char #x5A6C ?$BU5(B) ; J83-B-5535
(ucs-set-char #x5A6D ?$(D9f(B) ; J90-D-3966
(ucs-set-char #x5A6D ?$(H4X(B) ; C02-H-3458
(ucs-set-char #x5A6E ?$(I5)(B) ; C03-I-3529
(ucs-set-char #x5A6F ?$(I54(B) ; C03-I-3534
(ucs-set-char #x5A70 ?$(H4k(B) ; C02-H-346B
(ucs-set-char #x5A71 ?$(I52(B) ; C03-I-3532
(ucs-set-char #x5A73 ?$(I57(B) ; C03-I-3537
(ucs-set-char #x5A74 ?$AS$(B) ; GB0-A-5324
(ucs-set-char #x5A75 ?$(I55(B) ; C03-I-3535
(ucs-set-char #x5A75 ?$Af?(B) ; GB0-A-663F
(ucs-set-char #x5A76 ?$AIt(B) ; GB0-A-4974
(ucs-set-char #x5A77 ?$(D9g(B) ; J90-D-3967
(ucs-set-char #x5A77 ?$(G^e(B) ; C01-G-5E65
(ucs-set-char #x5A77 ?$AfC(B) ; GB0-A-6643
(ucs-set-char #x5A78 ?$(H:}(B) ; C02-H-3A7D
(ucs-set-char #x5A79 ?$(I:u(B) ; C03-I-3A75
(ucs-set-char #x5A7A ?$(D9h(B) ; J90-D-3968
(ucs-set-char #x5A7A ?$(H:z(B) ; C02-H-3A7A
(ucs-set-char #x5A7A ?$AfD(B) ; GB0-A-6644
(ucs-set-char #x5A7B ?$(D9i(B) ; J90-D-3969
(ucs-set-char #x5A7B ?$(H;-(B) ; C02-H-3B2D
(ucs-set-char #x5A7C ?$(H;!(B) ; C02-H-3B21
(ucs-set-char #x5A7D ?$(H;.(B) ; C02-H-3B2E
(ucs-set-char #x5A7E ?$(D9j(B) ; J90-D-396A
(ucs-set-char #x5A7E ?$(I:|(B) ; C03-I-3A7C
(ucs-set-char #x5A7F ?$(G^g(B) ; C01-G-5E67
(ucs-set-char #x5A7F ?$@L;(B) ; J78-@-4C3B
(ucs-set-char #x5A7F ?$APv(B) ; GB0-A-5076
(ucs-set-char #x5A7F ?$BL;(B) ; J83-B-4C3B
(ucs-set-char #x5A80 ?$(I:c(B) ; C03-I-3A63
(ucs-set-char #x5A81 ?$(I:a(B) ; C03-I-3A61
(ucs-set-char #x5A82 ?$(I:X(B) ; C03-I-3A58
(ucs-set-char #x5A83 ?$(H;*(B) ; C02-H-3B2A
(ucs-set-char #x5A84 ?$(H;'(B) ; C02-H-3B27
(ucs-set-char #x5A85 ?$(I:[(B) ; C03-I-3A5B
(ucs-set-char #x5A86 ?$(I:w(B) ; C03-I-3A77
(ucs-set-char #x5A87 ?$(I:r(B) ; C03-I-3A72
(ucs-set-char #x5A88 ?$(I:Y(B) ; C03-I-3A59
(ucs-set-char #x5A89 ?$(I:`(B) ; C03-I-3A60
(ucs-set-char #x5A8A ?$(H;((B) ; C02-H-3B28
(ucs-set-char #x5A8B ?$(D9k(B) ; J90-D-396B
(ucs-set-char #x5A8B ?$(H;+(B) ; C02-H-3B2B
(ucs-set-char #x5A8C ?$(H;/(B) ; C02-H-3B2F
(ucs-set-char #x5A8D ?$(I:{(B) ; C03-I-3A7B
(ucs-set-char #x5A8E ?$(H4f(B) ; C02-H-3466
(ucs-set-char #x5A8F ?$(H;1(B) ; C02-H-3B31
(ucs-set-char #x5A90 ?$(D9l(B) ; J90-D-396C
(ucs-set-char #x5A90 ?$(HBM(B) ; C02-H-424D
(ucs-set-char #x5A91 ?$(I:f(B) ; C03-I-3A66
(ucs-set-char #x5A92 ?$(CXZ(B) ; KS0-C-585A
(ucs-set-char #x5A92 ?$(G^h(B) ; C01-G-5E68
(ucs-set-char #x5A92 ?$@G^(B) ; J78-@-475E
(ucs-set-char #x5A92 ?$AC=(B) ; GB0-A-433D
(ucs-set-char #x5A92 ?$BG^(B) ; J83-B-475E
(ucs-set-char #x5A93 ?$(D9m(B) ; J90-D-396D
(ucs-set-char #x5A93 ?$(H;2(B) ; C02-H-3B32
(ucs-set-char #x5A94 ?$(H:x(B) ; C02-H-3A78
(ucs-set-char #x5A95 ?$(H;$(B) ; C02-H-3B24
(ucs-set-char #x5A96 ?$(D9n(B) ; J90-D-396E
(ucs-set-char #x5A96 ?$(I:b(B) ; C03-I-3A62
(ucs-set-char #x5A97 ?$(H;)(B) ; C02-H-3B29
(ucs-set-char #x5A98 ?$(I:\(B) ; C03-I-3A5C
(ucs-set-char #x5A99 ?$(D9o(B) ; J90-D-396F
(ucs-set-char #x5A99 ?$(I:^(B) ; C03-I-3A5E
(ucs-set-char #x5A9A ?$(CZ,(B) ; KS0-C-5A2C
(ucs-set-char #x5A9A ?$(G^f(B) ; C01-G-5E66
(ucs-set-char #x5A9A ?$@U;(B) ; J78-@-553B
(ucs-set-char #x5A9A ?$ACD(B) ; GB0-A-4344
(ucs-set-char #x5A9A ?$BU;(B) ; J83-B-553B
(ucs-set-char #x5A9B ?$(Cj0(B) ; KS0-C-6A30
(ucs-set-char #x5A9B ?$(G^i(B) ; C01-G-5E69
(ucs-set-char #x5A9B ?$@I2(B) ; J78-@-4932
(ucs-set-char #x5A9B ?$AfB(B) ; GB0-A-6642
(ucs-set-char #x5A9B ?$BI2(B) ; J83-B-4932
(ucs-set-char #x5A9C ?$(D9p(B) ; J90-D-3970
(ucs-set-char #x5A9C ?$(H;0(B) ; C02-H-3B30
(ucs-set-char #x5A9D ?$(H;3(B) ; C02-H-3B33
(ucs-set-char #x5A9E ?$(D9q(B) ; J90-D-3971
(ucs-set-char #x5A9E ?$(H:|(B) ; C02-H-3A7C
(ucs-set-char #x5A9F ?$(D9r(B) ; J90-D-3972
(ucs-set-char #x5A9F ?$(H:y(B) ; C02-H-3A79
(ucs-set-char #x5AA0 ?$(D9s(B) ; J90-D-3973
(ucs-set-char #x5AA0 ?$(I:s(B) ; C03-I-3A73
(ucs-set-char #x5AA1 ?$(I:Z(B) ; C03-I-3A5A
(ucs-set-char #x5AA2 ?$(D9t(B) ; J90-D-3974
(ucs-set-char #x5AA2 ?$(H:{(B) ; C02-H-3A7B
(ucs-set-char #x5AA3 ?$(I:W(B) ; C03-I-3A57
(ucs-set-char #x5AA4 ?$(Cc8(B) ; KS0-C-6338
(ucs-set-char #x5AA4 ?$(I:z(B) ; C03-I-3A7A
(ucs-set-char #x5AA5 ?$(H;"(B) ; C02-H-3B22
(ucs-set-char #x5AA6 ?$(H:~(B) ; C02-H-3A7E
(ucs-set-char #x5AA7 ?$(D9u(B) ; J90-D-3975
(ucs-set-char #x5AA7 ?$(G^j(B) ; C01-G-5E6A
(ucs-set-char #x5AA8 ?$(I:V(B) ; C03-I-3A56
(ucs-set-char #x5AA9 ?$(H;,(B) ; C02-H-3B2C
(ucs-set-char #x5AAA ?$(I:y(B) ; C03-I-3A79
(ucs-set-char #x5AAA ?$AfA(B) ; GB0-A-6641
(ucs-set-char #x5AAB ?$(I:x(B) ; C03-I-3A78
(ucs-set-char #x5AAC ?$(D9v(B) ; J90-D-3976
(ucs-set-char #x5AAC ?$(H;#(B) ; C02-H-3B23
(ucs-set-char #x5AAE ?$(H;%(B) ; C02-H-3B25
(ucs-set-char #x5AAF ?$(H:w(B) ; C02-H-3A77
(ucs-set-char #x5AB0 ?$(HBA(B) ; C02-H-4241
(ucs-set-char #x5AB1 ?$(D9w(B) ; J90-D-3977
(ucs-set-char #x5AB1 ?$(HB?(B) ; C02-H-423F
(ucs-set-char #x5AB2 ?$(D9x(B) ; J90-D-3978
(ucs-set-char #x5AB2 ?$(Gch(B) ; C01-G-6368
(ucs-set-char #x5AB2 ?$AfG(B) ; GB0-A-6647
(ucs-set-char #x5AB3 ?$(D9y(B) ; J90-D-3979
(ucs-set-char #x5AB3 ?$(Gcf(B) ; C01-G-6366
(ucs-set-char #x5AB3 ?$AO1(B) ; GB0-A-4F31
(ucs-set-char #x5AB4 ?$(HBI(B) ; C02-H-4249
(ucs-set-char #x5AB5 ?$(D9z(B) ; J90-D-397A
(ucs-set-char #x5AB5 ?$(HB@(B) ; C02-H-4240
(ucs-set-char #x5AB5 ?$Akt(B) ; GB0-A-6B74
(ucs-set-char #x5AB6 ?$(HBJ(B) ; C02-H-424A
(ucs-set-char #x5AB7 ?$(HBF(B) ; C02-H-4246
(ucs-set-char #x5AB8 ?$(D9{(B) ; J90-D-397B
(ucs-set-char #x5AB8 ?$(HB>(B) ; C02-H-423E
(ucs-set-char #x5AB8 ?$AfJ(B) ; GB0-A-664A
(ucs-set-char #x5AB9 ?$(HBL(B) ; C02-H-424C
(ucs-set-char #x5ABA ?$(D9|(B) ; J90-D-397C
(ucs-set-char #x5ABA ?$(HB=(B) ; C02-H-423D
(ucs-set-char #x5ABB ?$(D9}(B) ; J90-D-397D
(ucs-set-char #x5ABB ?$(HBD(B) ; C02-H-4244
(ucs-set-char #x5ABC ?$(Gce(B) ; C01-G-6365
(ucs-set-char #x5ABC ?$@U<(B) ; J78-@-553C
(ucs-set-char #x5ABC ?$BU<(B) ; J83-B-553C
(ucs-set-char #x5ABD ?$(Gcd(B) ; C01-G-6364
(ucs-set-char #x5ABD ?$@U@(B) ; J78-@-5540
(ucs-set-char #x5ABD ?$BU@(B) ; J83-B-5540
(ucs-set-char #x5ABE ?$(Gcc(B) ; C01-G-6363
(ucs-set-char #x5ABE ?$@U=(B) ; J78-@-553D
(ucs-set-char #x5ABE ?$AfE(B) ; GB0-A-6645
(ucs-set-char #x5ABE ?$BU=(B) ; J83-B-553D
(ucs-set-char #x5ABF ?$(D9~(B) ; J90-D-397E
(ucs-set-char #x5ABF ?$(HBB(B) ; C02-H-4242
(ucs-set-char #x5AC0 ?$(HBG(B) ; C02-H-4247
(ucs-set-char #x5AC1 ?$(CJ*(B) ; KS0-C-4A2A
(ucs-set-char #x5AC1 ?$(Gc`(B) ; C01-G-6360
(ucs-set-char #x5AC1 ?$@2G(B) ; J78-@-3247
(ucs-set-char #x5AC1 ?$A<^(B) ; GB0-A-3C5E
(ucs-set-char #x5AC1 ?$B2G(B) ; J83-B-3247
(ucs-set-char #x5AC2 ?$(Cay(B) ; KS0-C-6179
(ucs-set-char #x5AC2 ?$(Gcg(B) ; C01-G-6367
(ucs-set-char #x5AC2 ?$@U?(B) ; J78-@-553F
(ucs-set-char #x5AC2 ?$AI)(B) ; GB0-A-4929
(ucs-set-char #x5AC2 ?$BU?(B) ; J83-B-553F
(ucs-set-char #x5AC3 ?$(I@g(B) ; C03-I-4067
(ucs-set-char #x5AC4 ?$(Cj1(B) ; KS0-C-6A31
(ucs-set-char #x5AC4 ?$(D:!(B) ; J90-D-3A21
(ucs-set-char #x5AC4 ?$(HB;(B) ; C02-H-423B
(ucs-set-char #x5AC5 ?$(I@f(B) ; C03-I-4066
(ucs-set-char #x5AC6 ?$(D:"(B) ; J90-D-3A22
(ucs-set-char #x5AC6 ?$(HBE(B) ; C02-H-4245
(ucs-set-char #x5AC7 ?$(HB:(B) ; C02-H-423A
(ucs-set-char #x5AC8 ?$(D:#(B) ; J90-D-3A23
(ucs-set-char #x5AC8 ?$(HBC(B) ; C02-H-4243
(ucs-set-char #x5AC9 ?$(Crl(B) ; KS0-C-726C
(ucs-set-char #x5AC9 ?$(Gca(B) ; C01-G-6361
(ucs-set-char #x5AC9 ?$@<;(B) ; J78-@-3C3B
(ucs-set-char #x5AC9 ?$A<5(B) ; GB0-A-3C35
(ucs-set-char #x5AC9 ?$B<;(B) ; J83-B-3C3B
(ucs-set-char #x5ACA ?$(HBH(B) ; C02-H-4248
(ucs-set-char #x5ACB ?$(HB<(B) ; C02-H-423C
(ucs-set-char #x5ACB ?$@U>(B) ; J78-@-553E
(ucs-set-char #x5ACB ?$BU>(B) ; J83-B-553E
(ucs-set-char #x5ACC ?$(Czn(B) ; KS0-C-7A6E
(ucs-set-char #x5ACC ?$(Gcb(B) ; C01-G-6362
(ucs-set-char #x5ACC ?$@7y(B) ; J78-@-3779
(ucs-set-char #x5ACC ?$AOS(B) ; GB0-A-4F53
(ucs-set-char #x5ACC ?$B7y(B) ; J83-B-3779
(ucs-set-char #x5ACD ?$(HBK(B) ; C02-H-424B
(ucs-set-char #x5ACE ?$(I@d(B) ; C03-I-4064
(ucs-set-char #x5ACF ?$(D:$(B) ; J90-D-3A24
(ucs-set-char #x5ACF ?$(I:k(B) ; C03-I-3A6B
(ucs-set-char #x5AD0 ?$(I@j(B) ; C03-I-406A
(ucs-set-char #x5AD0 ?$@UL(B) ; J78-@-554C
(ucs-set-char #x5AD0 ?$BUL(B) ; J83-B-554C
(ucs-set-char #x5AD2 ?$AfH(B) ; GB0-A-6648
(ucs-set-char #x5AD4 ?$AfI(B) ; GB0-A-6649
(ucs-set-char #x5AD5 ?$(HIU(B) ; C02-H-4955
(ucs-set-char #x5AD6 ?$(GhJ(B) ; C01-G-684A
(ucs-set-char #x5AD6 ?$@UE(B) ; J78-@-5545
(ucs-set-char #x5AD6 ?$AfN(B) ; GB0-A-664E
(ucs-set-char #x5AD6 ?$BUE(B) ; J83-B-5545
(ucs-set-char #x5AD7 ?$(GhI(B) ; C01-G-6849
(ucs-set-char #x5AD7 ?$@UB(B) ; J78-@-5542
(ucs-set-char #x5AD7 ?$BUB(B) ; J83-B-5542
(ucs-set-char #x5AD8 ?$(GhK(B) ; C01-G-684B
(ucs-set-char #x5AD8 ?$AfP(B) ; GB0-A-6650
(ucs-set-char #x5AD9 ?$(HIa(B) ; C02-H-4961
(ucs-set-char #x5ADA ?$(D:%(B) ; J90-D-3A25
(ucs-set-char #x5ADA ?$(HIW(B) ; C02-H-4957
(ucs-set-char #x5ADB ?$(HI](B) ; C02-H-495D
(ucs-set-char #x5ADC ?$(D:&(B) ; J90-D-3A26
(ucs-set-char #x5ADC ?$(HIR(B) ; C02-H-4952
(ucs-set-char #x5ADC ?$AfQ(B) ; GB0-A-6651
(ucs-set-char #x5ADD ?$(HI`(B) ; C02-H-4960
(ucs-set-char #x5ADE ?$(HI_(B) ; C02-H-495F
(ucs-set-char #x5ADF ?$(HIc(B) ; C02-H-4963
(ucs-set-char #x5AE0 ?$(D:'(B) ; J90-D-3A27
(ucs-set-char #x5AE0 ?$(HI\(B) ; C02-H-495C
(ucs-set-char #x5AE0 ?$AfK(B) ; GB0-A-664B
(ucs-set-char #x5AE1 ?$(CnU(B) ; KS0-C-6E55
(ucs-set-char #x5AE1 ?$(GhF(B) ; C01-G-6846
(ucs-set-char #x5AE1 ?$@Cd(B) ; J78-@-4364
(ucs-set-char #x5AE1 ?$A5U(B) ; GB0-A-3555
(ucs-set-char #x5AE1 ?$BCd(B) ; J83-B-4364
(ucs-set-char #x5AE2 ?$(HI[(B) ; C02-H-495B
(ucs-set-char #x5AE3 ?$(GhL(B) ; C01-G-684C
(ucs-set-char #x5AE3 ?$@UA(B) ; J78-@-5541
(ucs-set-char #x5AE3 ?$AfL(B) ; GB0-A-664C
(ucs-set-char #x5AE3 ?$BUA(B) ; J83-B-5541
(ucs-set-char #x5AE4 ?$(IFL(B) ; C03-I-464C
(ucs-set-char #x5AE5 ?$(D:((B) ; J90-D-3A28
(ucs-set-char #x5AE5 ?$(HIT(B) ; C02-H-4954
(ucs-set-char #x5AE6 ?$(Cyt(B) ; KS0-C-7974
(ucs-set-char #x5AE6 ?$(GhG(B) ; C01-G-6847
(ucs-set-char #x5AE6 ?$@UC(B) ; J78-@-5543
(ucs-set-char #x5AE6 ?$AfO(B) ; GB0-A-664F
(ucs-set-char #x5AE6 ?$BUC(B) ; J83-B-5543
(ucs-set-char #x5AE7 ?$(IFJ(B) ; C03-I-464A
(ucs-set-char #x5AE8 ?$(HIb(B) ; C02-H-4962
(ucs-set-char #x5AE9 ?$(CRl(B) ; KS0-C-526C
(ucs-set-char #x5AE9 ?$(GhH(B) ; C01-G-6848
(ucs-set-char #x5AE9 ?$@UD(B) ; J78-@-5544
(ucs-set-char #x5AE9 ?$AD[(B) ; GB0-A-445B
(ucs-set-char #x5AE9 ?$BUD(B) ; J83-B-5544
(ucs-set-char #x5AEA ?$(D:)(B) ; J90-D-3A29
(ucs-set-char #x5AEA ?$(HIV(B) ; C02-H-4956
(ucs-set-char #x5AEB ?$(HIY(B) ; C02-H-4959
(ucs-set-char #x5AEB ?$AfF(B) ; GB0-A-6646
(ucs-set-char #x5AEC ?$(HI^(B) ; C02-H-495E
(ucs-set-char #x5AED ?$(HIX(B) ; C02-H-4958
(ucs-set-char #x5AEE ?$(D:*(B) ; J90-D-3A2A
(ucs-set-char #x5AEE ?$(HIS(B) ; C02-H-4953
(ucs-set-char #x5AEF ?$(IFO(B) ; C03-I-464F
(ucs-set-char #x5AF0 ?$(IFS(B) ; C03-I-4653
(ucs-set-char #x5AF1 ?$AfM(B) ; GB0-A-664D
(ucs-set-char #x5AF3 ?$(HIZ(B) ; C02-H-495A
(ucs-set-char #x5AF4 ?$(HO|(B) ; C02-H-4F7C
(ucs-set-char #x5AF5 ?$(D:+(B) ; J90-D-3A2B
(ucs-set-char #x5AF5 ?$(GlK(B) ; C01-G-6C4B
(ucs-set-char #x5AF6 ?$(D:,(B) ; J90-D-3A2C
(ucs-set-char #x5AF6 ?$(HP!(B) ; C02-H-5021
(ucs-set-char #x5AF7 ?$(HO~(B) ; C02-H-4F7E
(ucs-set-char #x5AF8 ?$(HP#(B) ; C02-H-5023
(ucs-set-char #x5AF9 ?$(HP%(B) ; C02-H-5025
(ucs-set-char #x5AFA ?$(IK\(B) ; C03-I-4B5C
(ucs-set-char #x5AFA ?$@UF(B) ; J78-@-5546
(ucs-set-char #x5AFA ?$BUF(B) ; J83-B-5546
(ucs-set-char #x5AFB ?$(GlI(B) ; C01-G-6C49
(ucs-set-char #x5AFB ?$@UG(B) ; J78-@-5547
(ucs-set-char #x5AFB ?$BUG(B) ; J83-B-5547
(ucs-set-char #x5AFC ?$(IKX(B) ; C03-I-4B58
(ucs-set-char #x5AFD ?$(D:-(B) ; J90-D-3A2D
(ucs-set-char #x5AFD ?$(HO}(B) ; C02-H-4F7D
(ucs-set-char #x5AFE ?$(IKT(B) ; C03-I-4B54
(ucs-set-char #x5AFF ?$(HO{(B) ; C02-H-4F7B
(ucs-set-char #x5B00 ?$(D:.(B) ; J90-D-3A2E
(ucs-set-char #x5B00 ?$(IK^(B) ; C03-I-4B5E
(ucs-set-char #x5B01 ?$(D:/(B) ; J90-D-3A2F
(ucs-set-char #x5B01 ?$(HP&(B) ; C02-H-5026
(ucs-set-char #x5B02 ?$(HP$(B) ; C02-H-5024
(ucs-set-char #x5B03 ?$(HP"(B) ; C02-H-5022
(ucs-set-char #x5B04 ?$(IKV(B) ; C03-I-4B56
(ucs-set-char #x5B05 ?$(C{{(B) ; KS0-C-7B7B
(ucs-set-char #x5B05 ?$(HP((B) ; C02-H-5028
(ucs-set-char #x5B06 ?$(IKZ(B) ; C03-I-4B5A
(ucs-set-char #x5B07 ?$(HP'(B) ; C02-H-5027
(ucs-set-char #x5B08 ?$(D:0(B) ; J90-D-3A30
(ucs-set-char #x5B08 ?$(GlM(B) ; C01-G-6C4D
(ucs-set-char #x5B09 ?$(C}p(B) ; KS0-C-7D70
(ucs-set-char #x5B09 ?$(GlH(B) ; C01-G-6C48
(ucs-set-char #x5B09 ?$@4r(B) ; J78-@-3472
(ucs-set-char #x5B09 ?$AfR(B) ; GB0-A-6652
(ucs-set-char #x5B09 ?$B4r(B) ; J83-B-3472
(ucs-set-char #x5B0A ?$(IK[(B) ; C03-I-4B5B
(ucs-set-char #x5B0B ?$(C`=(B) ; KS0-C-603D
(ucs-set-char #x5B0B ?$(GlJ(B) ; C01-G-6C4A
(ucs-set-char #x5B0B ?$@UI(B) ; J78-@-5549
(ucs-set-char #x5B0B ?$BUI(B) ; J83-B-5549
(ucs-set-char #x5B0C ?$(CNc(B) ; KS0-C-4E63
(ucs-set-char #x5B0C ?$(GlL(B) ; C01-G-6C4C
(ucs-set-char #x5B0C ?$@UH(B) ; J78-@-5548
(ucs-set-char #x5B0C ?$BUH(B) ; J83-B-5548
(ucs-set-char #x5B0D ?$(IK](B) ; C03-I-4B5D
(ucs-set-char #x5B0E ?$(IK_(B) ; C03-I-4B5F
(ucs-set-char #x5B0F ?$(HP)(B) ; C02-H-5029
(ucs-set-char #x5B10 ?$(HVa(B) ; C02-H-5661
(ucs-set-char #x5B11 ?$(IPP(B) ; C03-I-5050
(ucs-set-char #x5B12 ?$(IPS(B) ; C03-I-5053
(ucs-set-char #x5B13 ?$(HV`(B) ; C02-H-5660
(ucs-set-char #x5B14 ?$(HV_(B) ; C02-H-565F
(ucs-set-char #x5B15 ?$(IPQ(B) ; C03-I-5051
(ucs-set-char #x5B16 ?$(CxF(B) ; KS0-C-7846
(ucs-set-char #x5B16 ?$(HVb(B) ; C02-H-5662
(ucs-set-char #x5B16 ?$@UJ(B) ; J78-@-554A
(ucs-set-char #x5B16 ?$AfT(B) ; GB0-A-6654
(ucs-set-char #x5B16 ?$BUJ(B) ; J83-B-554A
(ucs-set-char #x5B17 ?$(D:1(B) ; J90-D-3A31
(ucs-set-char #x5B17 ?$(HV[(B) ; C02-H-565B
(ucs-set-char #x5B17 ?$AfS(B) ; GB0-A-6653
(ucs-set-char #x5B18 ?$(IPO(B) ; C03-I-504F
(ucs-set-char #x5B19 ?$(D:3(B) ; J90-D-3A33
(ucs-set-char #x5B19 ?$(HV\(B) ; C02-H-565C
(ucs-set-char #x5B1A ?$(HVd(B) ; C02-H-5664
(ucs-set-char #x5B1B ?$(D:4(B) ; J90-D-3A34
(ucs-set-char #x5B1B ?$(HV](B) ; C02-H-565D
(ucs-set-char #x5B1C ?$(IPT(B) ; C03-I-5054
(ucs-set-char #x5B1D ?$(D:5(B) ; J90-D-3A35
(ucs-set-char #x5B1D ?$(GpN(B) ; C01-G-704E
(ucs-set-char #x5B1E ?$(HVf(B) ; C02-H-5666
(ucs-set-char #x5B1F ?$(IPN(B) ; C03-I-504E
(ucs-set-char #x5B20 ?$(HVe(B) ; C02-H-5665
(ucs-set-char #x5B21 ?$(D:6(B) ; J90-D-3A36
(ucs-set-char #x5B21 ?$(HV^(B) ; C02-H-565E
(ucs-set-char #x5B22 ?$(IPV(B) ; C03-I-5056
(ucs-set-char #x5B22 ?$@>n(B) ; J78-@-3E6E
(ucs-set-char #x5B22 ?$B>n(B) ; J83-B-3E6E
(ucs-set-char #x5B23 ?$(H\](B) ; C02-H-5C5D
(ucs-set-char #x5B24 ?$(GsQ(B) ; C01-G-7351
(ucs-set-char #x5B25 ?$(D:7(B) ; J90-D-3A37
(ucs-set-char #x5B25 ?$(H\[(B) ; C02-H-5C5B
(ucs-set-char #x5B26 ?$(H\`(B) ; C02-H-5C60
(ucs-set-char #x5B27 ?$(H\_(B) ; C02-H-5C5F
(ucs-set-char #x5B28 ?$(HVc(B) ; C02-H-5663
(ucs-set-char #x5B29 ?$(ITP(B) ; C03-I-5450
(ucs-set-char #x5B2A ?$(C^.(B) ; KS0-C-5E2E
(ucs-set-char #x5B2A ?$(GsP(B) ; C01-G-7350
(ucs-set-char #x5B2A ?$@UM(B) ; J78-@-554D
(ucs-set-char #x5B2A ?$BUM(B) ; J83-B-554D
(ucs-set-char #x5B2B ?$(ITN(B) ; C03-I-544E
(ucs-set-char #x5B2C ?$(H\^(B) ; C02-H-5C5E
(ucs-set-char #x5B2C ?$@D\(B) ; J78-@-445C
(ucs-set-char #x5B2C ?$BD\(B) ; J83-B-445C
(ucs-set-char #x5B2D ?$(D:8(B) ; J90-D-3A38
(ucs-set-char #x5B2D ?$(H\Z(B) ; C02-H-5C5A
(ucs-set-char #x5B2E ?$(H\b(B) ; C02-H-5C62
(ucs-set-char #x5B2F ?$(H\a(B) ; C02-H-5C61
(ucs-set-char #x5B30 ?$(GsO(B) ; C01-G-734F
(ucs-set-char #x5B30 ?$@1E(B) ; J78-@-3145
(ucs-set-char #x5B30 ?$B1E(B) ; J83-B-3145
(ucs-set-char #x5B31 ?$(ITR(B) ; C03-I-5452
(ucs-set-char #x5B32 ?$(H\\(B) ; C02-H-5C5C
(ucs-set-char #x5B32 ?$@UK(B) ; J78-@-554B
(ucs-set-char #x5B32 ?$AfU(B) ; GB0-A-6655
(ucs-set-char #x5B32 ?$BUK(B) ; J83-B-554B
(ucs-set-char #x5B33 ?$(ITO(B) ; C03-I-544F
(ucs-set-char #x5B34 ?$(D:2(B) ; J90-D-3A32
(ucs-set-char #x5B34 ?$(GpO(B) ; C01-G-704F
(ucs-set-char #x5B34 ?$AYx(B) ; GB0-A-5978
(ucs-set-char #x5B35 ?$(ITQ(B) ; C03-I-5451
(ucs-set-char #x5B36 ?$@UN(B) ; J78-@-554E
(ucs-set-char #x5B36 ?$BUN(B) ; J83-B-554E
(ucs-set-char #x5B37 ?$(ITS(B) ; C03-I-5453
(ucs-set-char #x5B37 ?$AfV(B) ; GB0-A-6656
(ucs-set-char #x5B38 ?$(D:9(B) ; J90-D-3A39
(ucs-set-char #x5B38 ?$(Gv@(B) ; C01-G-7640
(ucs-set-char #x5B39 ?$(IZ1(B) ; C03-I-5A31
(ucs-set-char #x5B3A ?$(IWa(B) ; C03-I-5761
(ucs-set-char #x5B3B ?$(IW^(B) ; C03-I-575E
(ucs-set-char #x5B3C ?$(HaM(B) ; C02-H-614D
(ucs-set-char #x5B3D ?$(HeF(B) ; C02-H-6546
(ucs-set-char #x5B3E ?$(HeG(B) ; C02-H-6547
(ucs-set-char #x5B3E ?$(IZ3(B) ; C03-I-5A33
(ucs-set-char #x5B3E ?$@UO(B) ; J78-@-554F
(ucs-set-char #x5B3E ?$BUO(B) ; J83-B-554F
(ucs-set-char #x5B3F ?$(HeH(B) ; C02-H-6548
(ucs-set-char #x5B40 ?$(C_E(B) ; KS0-C-5F45
(ucs-set-char #x5B40 ?$(Gyg(B) ; C01-G-7967
(ucs-set-char #x5B40 ?$@UR(B) ; J78-@-5552
(ucs-set-char #x5B40 ?$AfW(B) ; GB0-A-6657
(ucs-set-char #x5B40 ?$BUR(B) ; J83-B-5552
(ucs-set-char #x5B41 ?$(D::(B) ; J90-D-3A3A
(ucs-set-char #x5B41 ?$(Jc4(B) ; C04-J-6334
(ucs-set-char #x5B42 ?$(I\6(B) ; C03-I-5C36
(ucs-set-char #x5B43 ?$(Ce>(B) ; KS0-C-653E
(ucs-set-char #x5B43 ?$(Gyh(B) ; C01-G-7968
(ucs-set-char #x5B43 ?$@UP(B) ; J78-@-5550
(ucs-set-char #x5B43 ?$BUP(B) ; J83-B-5550
(ucs-set-char #x5B44 ?$(I\9(B) ; C03-I-5C39
(ucs-set-char #x5B45 ?$(Hho(B) ; C02-H-686F
(ucs-set-char #x5B45 ?$@UQ(B) ; J78-@-5551
(ucs-set-char #x5B45 ?$BUQ(B) ; J83-B-5551
(ucs-set-char #x5B46 ?$(I\:(B) ; C03-I-5C3A
(ucs-set-char #x5B47 ?$(HkV(B) ; C02-H-6B56
(ucs-set-char #x5B48 ?$(HkU(B) ; C02-H-6B55
(ucs-set-char #x5B49 ?$(I^)(B) ; C03-I-5E29
(ucs-set-char #x5B4A ?$(I_B(B) ; C03-I-5F42
(ucs-set-char #x5B4B ?$(D:;(B) ; J90-D-3A3B
(ucs-set-char #x5B4B ?$(HmI(B) ; C02-H-6D49
(ucs-set-char #x5B4C ?$(D:<(B) ; J90-D-3A3C
(ucs-set-char #x5B4C ?$(HmJ(B) ; C02-H-6D4A
(ucs-set-char #x5B4D ?$(Ho$(B) ; C02-H-6F24
(ucs-set-char #x5B4E ?$(Hp5(B) ; C02-H-7035
(ucs-set-char #x5B4F ?$(I`s(B) ; C03-I-6073

(ucs-set-char #x5B50 ?$AWS(B) ; GB0-A-5753
(ucs-set-char #x5B50 ?$(Cm-(B) ; KS0-C-6D2D
(ucs-set-char #x5B50 ?$(GDM(B) ; C01-G-444D
(ucs-set-char #x5B50 ?$@;R(B) ; J78-@-3B52
(ucs-set-char #x5B50 ?$B;R(B) ; J83-B-3B52

(ucs-set-char #x5B51 ?$(Czj(B) ; KS0-C-7A6A
(ucs-set-char #x5B51 ?$(GDN(B) ; C01-G-444E
(ucs-set-char #x5B51 ?$@US(B) ; J78-@-5553
(ucs-set-char #x5B51 ?$Af](B) ; GB0-A-665D
(ucs-set-char #x5B51 ?$BUS(B) ; J83-B-5553
(ucs-set-char #x5B52 ?$(D:=(B) ; J90-D-3A3D
(ucs-set-char #x5B52 ?$(J!2(B) ; C04-J-2132
(ucs-set-char #x5B53 ?$(GDO(B) ; C01-G-444F
(ucs-set-char #x5B53 ?$Af^(B) ; GB0-A-665E
(ucs-set-char #x5B54 ?$(CMn(B) ; KS0-C-4D6E
(ucs-set-char #x5B54 ?$(GE6(B) ; C01-G-4536
(ucs-set-char #x5B54 ?$@9&(B) ; J78-@-3926
(ucs-set-char #x5B54 ?$A?W(B) ; GB0-A-3F57
(ucs-set-char #x5B54 ?$B9&(B) ; J83-B-3926
(ucs-set-char #x5B55 ?$(Cm&(B) ; KS0-C-6D26
(ucs-set-char #x5B55 ?$(GFE(B) ; C01-G-4645
(ucs-set-char #x5B55 ?$@UT(B) ; J78-@-5554
(ucs-set-char #x5B55 ?$ATP(B) ; GB0-A-5450
(ucs-set-char #x5B55 ?$BUT(B) ; J83-B-5554
(ucs-set-char #x5B56 ?$(D:>(B) ; J90-D-3A3E
(ucs-set-char #x5B56 ?$(H"3(B) ; C02-H-2233
(ucs-set-char #x5B57 ?$(Cm.(B) ; KS0-C-6D2E
(ucs-set-char #x5B57 ?$(GGs(B) ; C01-G-4773
(ucs-set-char #x5B57 ?$@;z(B) ; J78-@-3B7A
(ucs-set-char #x5B57 ?$AWV(B) ; GB0-A-5756
(ucs-set-char #x5B57 ?$B;z(B) ; J83-B-3B7A
(ucs-set-char #x5B58 ?$(Cpm(B) ; KS0-C-706D
(ucs-set-char #x5B58 ?$(GGt(B) ; C01-G-4774
(ucs-set-char #x5B58 ?$@B8(B) ; J78-@-4238
(ucs-set-char #x5B58 ?$A4f(B) ; GB0-A-3466
(ucs-set-char #x5B58 ?$BB8(B) ; J83-B-4238
(ucs-set-char #x5B59 ?$AKo(B) ; GB0-A-4B6F
(ucs-set-char #x5B5A ?$(C]!(B) ; KS0-C-5D21
(ucs-set-char #x5B5A ?$(GIw(B) ; C01-G-4977
(ucs-set-char #x5B5A ?$@UU(B) ; J78-@-5555
(ucs-set-char #x5B5A ?$AfZ(B) ; GB0-A-665A
(ucs-set-char #x5B5A ?$BUU(B) ; J83-B-5555
(ucs-set-char #x5B5B ?$(GIx(B) ; C01-G-4978
(ucs-set-char #x5B5B ?$@UV(B) ; J78-@-5556
(ucs-set-char #x5B5B ?$AXC(B) ; GB0-A-5843
(ucs-set-char #x5B5B ?$BUV(B) ; J83-B-5556
(ucs-set-char #x5B5C ?$(Cm/(B) ; KS0-C-6D2F
(ucs-set-char #x5B5C ?$(GIv(B) ; C01-G-4976
(ucs-set-char #x5B5C ?$@;Z(B) ; J78-@-3B5A
(ucs-set-char #x5B5C ?$AWN(B) ; GB0-A-574E
(ucs-set-char #x5B5C ?$B;Z(B) ; J83-B-3B5A
(ucs-set-char #x5B5D ?$(C|x(B) ; KS0-C-7C78
(ucs-set-char #x5B5D ?$(GIu(B) ; C01-G-4975
(ucs-set-char #x5B5D ?$@9'(B) ; J78-@-3927
(ucs-set-char #x5B5D ?$AP"(B) ; GB0-A-5022
(ucs-set-char #x5B5D ?$B9'(B) ; J83-B-3927
(ucs-set-char #x5B5E ?$(D:?(B) ; J90-D-3A3F
(ucs-set-char #x5B5F ?$(CXk(B) ; KS0-C-586B
(ucs-set-char #x5B5F ?$(GLu(B) ; C01-G-4C75
(ucs-set-char #x5B5F ?$@LR(B) ; J78-@-4C52
(ucs-set-char #x5B5F ?$ACO(B) ; GB0-A-434F
(ucs-set-char #x5B5F ?$BLR(B) ; J83-B-4C52
(ucs-set-char #x5B60 ?$(I(H(B) ; C03-I-2848
(ucs-set-char #x5B61 ?$(J&"(B) ; C04-J-2622
(ucs-set-char #x5B62 ?$(H&6(B) ; C02-H-2636
(ucs-set-char #x5B62 ?$Af_(B) ; GB0-A-665F
(ucs-set-char #x5B63 ?$(CLy(B) ; KS0-C-4C79
(ucs-set-char #x5B63 ?$(GLw(B) ; C01-G-4C77
(ucs-set-char #x5B63 ?$@5((B) ; J78-@-3528
(ucs-set-char #x5B63 ?$A<>(B) ; GB0-A-3C3E
(ucs-set-char #x5B63 ?$B5((B) ; J83-B-3528
(ucs-set-char #x5B64 ?$(CM5(B) ; KS0-C-4D35
(ucs-set-char #x5B64 ?$(GLv(B) ; C01-G-4C76
(ucs-set-char #x5B64 ?$@8I(B) ; J78-@-3849
(ucs-set-char #x5B64 ?$A9B(B) ; GB0-A-3942
(ucs-set-char #x5B64 ?$B8I(B) ; J83-B-3849
(ucs-set-char #x5B65 ?$(H&7(B) ; C02-H-2637
(ucs-set-char #x5B65 ?$@UW(B) ; J78-@-5557
(ucs-set-char #x5B65 ?$Af[(B) ; GB0-A-665B
(ucs-set-char #x5B65 ?$BUW(B) ; J83-B-5557
(ucs-set-char #x5B66 ?$(J&#(B) ; C04-J-2623
(ucs-set-char #x5B66 ?$@3X(B) ; J78-@-3358
(ucs-set-char #x5B66 ?$AQ'(B) ; GB0-A-5127
(ucs-set-char #x5B66 ?$B3X(B) ; J83-B-3358
(ucs-set-char #x5B68 ?$(D:@(B) ; J90-D-3A40
(ucs-set-char #x5B68 ?$(J(n(B) ; C04-J-286E
(ucs-set-char #x5B69 ?$(Cz)(B) ; KS0-C-7A29
(ucs-set-char #x5B69 ?$(GPf(B) ; C01-G-5066
(ucs-set-char #x5B69 ?$@UX(B) ; J78-@-5558
(ucs-set-char #x5B69 ?$A:"(B) ; GB0-A-3A22
(ucs-set-char #x5B69 ?$BUX(B) ; J83-B-5558
(ucs-set-char #x5B6A ?$(I,/(B) ; C03-I-2C2F
(ucs-set-char #x5B6A ?$ABO(B) ; GB0-A-424F
(ucs-set-char #x5B6B ?$(Ca](B) ; KS0-C-615D
(ucs-set-char #x5B6B ?$(GU!(B) ; C01-G-5521
(ucs-set-char #x5B6B ?$@B9(B) ; J78-@-4239
(ucs-set-char #x5B6B ?$BB9(B) ; J83-B-4239
(ucs-set-char #x5B6C ?$(H.g(B) ; C02-H-2E67
(ucs-set-char #x5B6C ?$AX+(B) ; GB0-A-582B
(ucs-set-char #x5B6E ?$(D:A(B) ; J90-D-3A41
(ucs-set-char #x5B6E ?$(H4s(B) ; C02-H-3473
(ucs-set-char #x5B6F ?$(D:B(B) ; J90-D-3A42
(ucs-set-char #x5B6F ?$(J1,(B) ; C04-J-312C
(ucs-set-char #x5B70 ?$(CbU(B) ; KS0-C-6255
(ucs-set-char #x5B70 ?$(GYi(B) ; C01-G-5969
(ucs-set-char #x5B70 ?$@UY(B) ; J78-@-5559
(ucs-set-char #x5B70 ?$AJk(B) ; GB0-A-4A6B
(ucs-set-char #x5B70 ?$BUY(B) ; J83-B-5559
(ucs-set-char #x5B71 ?$(CmO(B) ; KS0-C-6D4F
(ucs-set-char #x5B71 ?$(G^l(B) ; C01-G-5E6C
(ucs-set-char #x5B71 ?$@V#(B) ; J78-@-5623
(ucs-set-char #x5B71 ?$Aen(B) ; GB0-A-656E
(ucs-set-char #x5B71 ?$BV#(B) ; J83-B-5623
(ucs-set-char #x5B72 ?$(H4r(B) ; C02-H-3472
(ucs-set-char #x5B73 ?$(G^k(B) ; C01-G-5E6B
(ucs-set-char #x5B73 ?$@UZ(B) ; J78-@-555A
(ucs-set-char #x5B73 ?$Af\(B) ; GB0-A-665C
(ucs-set-char #x5B73 ?$BUZ(B) ; J83-B-555A
(ucs-set-char #x5B74 ?$(I@q(B) ; C03-I-4071
(ucs-set-char #x5B75 ?$(C]"(B) ; KS0-C-5D22
(ucs-set-char #x5B75 ?$(GhM(B) ; C01-G-684D
(ucs-set-char #x5B75 ?$@U[(B) ; J78-@-555B
(ucs-set-char #x5B75 ?$A7u(B) ; GB0-A-3775
(ucs-set-char #x5B75 ?$BU[(B) ; J83-B-555B
(ucs-set-char #x5B76 ?$(I@r(B) ; C03-I-4072
(ucs-set-char #x5B77 ?$(HId(B) ; C02-H-4964
(ucs-set-char #x5B78 ?$(CyJ(B) ; KS0-C-794A
(ucs-set-char #x5B78 ?$(GpP(B) ; C01-G-7050
(ucs-set-char #x5B78 ?$@U\(B) ; J78-@-555C
(ucs-set-char #x5B78 ?$BU\(B) ; J83-B-555C
(ucs-set-char #x5B79 ?$(IPW(B) ; C03-I-5057
(ucs-set-char #x5B7A ?$(Cjh(B) ; KS0-C-6A68
(ucs-set-char #x5B7A ?$(GsR(B) ; C01-G-7352
(ucs-set-char #x5B7A ?$@U^(B) ; J78-@-555E
(ucs-set-char #x5B7A ?$AHf(B) ; GB0-A-4866
(ucs-set-char #x5B7A ?$BU^(B) ; J83-B-555E
(ucs-set-char #x5B7B ?$(H\c(B) ; C02-H-5C63
(ucs-set-char #x5B7C ?$(Cem(B) ; KS0-C-656D
(ucs-set-char #x5B7C ?$(D:C(B) ; J90-D-3A43
(ucs-set-char #x5B7C ?$(IZ4(B) ; C03-I-5A34
(ucs-set-char #x5B7D ?$(D:D(B) ; J90-D-3A44
(ucs-set-char #x5B7D ?$(Gyi(B) ; C01-G-7969
(ucs-set-char #x5B7D ?$ADu(B) ; GB0-A-4475
(ucs-set-char #x5B7E ?$(D:E(B) ; J90-D-3A45
(ucs-set-char #x5B7E ?$(I\;(B) ; C03-I-5C3B
(ucs-set-char #x5B7F ?$(D:F(B) ; J90-D-3A46
(ucs-set-char #x5B7F ?$(G{\(B) ; C01-G-7B5C

(ucs-set-char #x5B80 ?$Ae2(B) ; GB0-A-6532
(ucs-set-char #x5B80 ?$(I!;(B) ; C03-I-213B
(ucs-set-char #x5B80 ?$@U_(B) ; J78-@-555F
(ucs-set-char #x5B80 ?$BU_(B) ; J83-B-555F

(ucs-set-char #x5B81 ?$(D:G(B) ; J90-D-3A47
(ucs-set-char #x5B81 ?$(H!S(B) ; C02-H-2153
(ucs-set-char #x5B81 ?$AD~(B) ; GB0-A-447E
(ucs-set-char #x5B82 ?$(I"=(B) ; C03-I-223D
(ucs-set-char #x5B83 ?$(GFF(B) ; C01-G-4646
(ucs-set-char #x5B83 ?$@U`(B) ; J78-@-5560
(ucs-set-char #x5B83 ?$AK|(B) ; GB0-A-4B7C
(ucs-set-char #x5B83 ?$BU`(B) ; J83-B-5560
(ucs-set-char #x5B84 ?$(D:H(B) ; J90-D-3A48
(ucs-set-char #x5B84 ?$(H!T(B) ; C02-H-2154
(ucs-set-char #x5B84 ?$Ae3(B) ; GB0-A-6533
(ucs-set-char #x5B85 ?$(CSk(B) ; KS0-C-536B
(ucs-set-char #x5B85 ?$(GGw(B) ; C01-G-4777
(ucs-set-char #x5B85 ?$@Bp(B) ; J78-@-4270
(ucs-set-char #x5B85 ?$AU,(B) ; GB0-A-552C
(ucs-set-char #x5B85 ?$BBp(B) ; J83-B-4270
(ucs-set-char #x5B86 ?$(D:I(B) ; J90-D-3A49
(ucs-set-char #x5B86 ?$(I#P(B) ; C03-I-2350
(ucs-set-char #x5B87 ?$(CiT(B) ; KS0-C-6954
(ucs-set-char #x5B87 ?$(GGu(B) ; C01-G-4775
(ucs-set-char #x5B87 ?$@1'(B) ; J78-@-3127
(ucs-set-char #x5B87 ?$ASn(B) ; GB0-A-536E
(ucs-set-char #x5B87 ?$B1'(B) ; J83-B-3127
(ucs-set-char #x5B88 ?$(Caz(B) ; KS0-C-617A
(ucs-set-char #x5B88 ?$(GGv(B) ; C01-G-4776
(ucs-set-char #x5B88 ?$@<i(B) ; J78-@-3C69
(ucs-set-char #x5B88 ?$AJX(B) ; GB0-A-4A58
(ucs-set-char #x5B88 ?$B<i(B) ; J83-B-3C69
(ucs-set-char #x5B89 ?$(CdL(B) ; KS0-C-644C
(ucs-set-char #x5B89 ?$(GGx(B) ; C01-G-4778
(ucs-set-char #x5B89 ?$@0B(B) ; J78-@-3042
(ucs-set-char #x5B89 ?$A02(B) ; GB0-A-3032
(ucs-set-char #x5B89 ?$B0B(B) ; J83-B-3042
(ucs-set-char #x5B8A ?$(D:J(B) ; J90-D-3A4A
(ucs-set-char #x5B8A ?$(J#o(B) ; C04-J-236F
(ucs-set-char #x5B8B ?$(Cad(B) ; KS0-C-6164
(ucs-set-char #x5B8B ?$(GIz(B) ; C01-G-497A
(ucs-set-char #x5B8B ?$@AW(B) ; J78-@-4157
(ucs-set-char #x5B8B ?$AKN(B) ; GB0-A-4B4E
(ucs-set-char #x5B8B ?$BAW(B) ; J83-B-4157
(ucs-set-char #x5B8C ?$(ChG(B) ; KS0-C-6847
(ucs-set-char #x5B8C ?$(GIy(B) ; C01-G-4979
(ucs-set-char #x5B8C ?$@40(B) ; J78-@-3430
(ucs-set-char #x5B8C ?$AMj(B) ; GB0-A-4D6A
(ucs-set-char #x5B8C ?$B40(B) ; J83-B-3430
(ucs-set-char #x5B8D ?$(I%Z(B) ; C03-I-255A
(ucs-set-char #x5B8D ?$@<5(B) ; J78-@-3C35
(ucs-set-char #x5B8D ?$B<5(B) ; J83-B-3C35
(ucs-set-char #x5B8E ?$(D:K(B) ; J90-D-3A4B
(ucs-set-char #x5B8E ?$(H#\(B) ; C02-H-235C
(ucs-set-char #x5B8F ?$(CN[(B) ; KS0-C-4E5B
(ucs-set-char #x5B8F ?$(GI{(B) ; C01-G-497B
(ucs-set-char #x5B8F ?$@9((B) ; J78-@-3928
(ucs-set-char #x5B8F ?$A:j(B) ; GB0-A-3A6A
(ucs-set-char #x5B8F ?$B9((B) ; J83-B-3928
(ucs-set-char #x5B90 ?$(D:L(B) ; J90-D-3A4C
(ucs-set-char #x5B90 ?$(J"[(B) ; C04-J-225B
(ucs-set-char #x5B91 ?$(D:M(B) ; J90-D-3A4D
(ucs-set-char #x5B92 ?$(H#](B) ; C02-H-235D
(ucs-set-char #x5B93 ?$(C\U(B) ; KS0-C-5C55
(ucs-set-char #x5B93 ?$(D:N(B) ; J90-D-3A4E
(ucs-set-char #x5B93 ?$(H&8(B) ; C02-H-2638
(ucs-set-char #x5B93 ?$Ae5(B) ; GB0-A-6535
(ucs-set-char #x5B94 ?$(D:O(B) ; J90-D-3A4F
(ucs-set-char #x5B94 ?$(I(L(B) ; C03-I-284C
(ucs-set-char #x5B95 ?$(Cw5(B) ; KS0-C-7735
(ucs-set-char #x5B95 ?$(H&9(B) ; C02-H-2639
(ucs-set-char #x5B95 ?$@Ef(B) ; J78-@-4566
(ucs-set-char #x5B95 ?$Ae4(B) ; GB0-A-6534
(ucs-set-char #x5B95 ?$BEf(B) ; J83-B-4566
(ucs-set-char #x5B96 ?$(C|s(B) ; KS0-C-7C73
(ucs-set-char #x5B96 ?$(D:P(B) ; J90-D-3A50
(ucs-set-char #x5B96 ?$(I(J(B) ; C03-I-284A
(ucs-set-char #x5B97 ?$(Cps(B) ; KS0-C-7073
(ucs-set-char #x5B97 ?$(GLx(B) ; C01-G-4C78
(ucs-set-char #x5B97 ?$@=!(B) ; J78-@-3D21
(ucs-set-char #x5B97 ?$AWZ(B) ; GB0-A-575A
(ucs-set-char #x5B97 ?$B=!(B) ; J83-B-3D21
(ucs-set-char #x5B98 ?$(CN/(B) ; KS0-C-4E2F
(ucs-set-char #x5B98 ?$(GLz(B) ; C01-G-4C7A
(ucs-set-char #x5B98 ?$@41(B) ; J78-@-3431
(ucs-set-char #x5B98 ?$A9Y(B) ; GB0-A-3959
(ucs-set-char #x5B98 ?$B41(B) ; J83-B-3431
(ucs-set-char #x5B99 ?$(Cq5(B) ; KS0-C-7135
(ucs-set-char #x5B99 ?$(GL|(B) ; C01-G-4C7C
(ucs-set-char #x5B99 ?$@Ch(B) ; J78-@-4368
(ucs-set-char #x5B99 ?$AVf(B) ; GB0-A-5666
(ucs-set-char #x5B99 ?$BCh(B) ; J83-B-4368
(ucs-set-char #x5B9A ?$(CoR(B) ; KS0-C-6F52
(ucs-set-char #x5B9A ?$(GLy(B) ; C01-G-4C79
(ucs-set-char #x5B9A ?$@Dj(B) ; J78-@-446A
(ucs-set-char #x5B9A ?$A6((B) ; GB0-A-3628
(ucs-set-char #x5B9A ?$BDj(B) ; J83-B-446A
(ucs-set-char #x5B9B ?$(ChH(B) ; KS0-C-6848
(ucs-set-char #x5B9B ?$(GL}(B) ; C01-G-4C7D
(ucs-set-char #x5B9B ?$@08(B) ; J78-@-3038
(ucs-set-char #x5B9B ?$AMp(B) ; GB0-A-4D70
(ucs-set-char #x5B9B ?$B08(B) ; J83-B-3038
(ucs-set-char #x5B9C ?$(Ckq(B) ; KS0-C-6B71
(ucs-set-char #x5B9C ?$(GL{(B) ; C01-G-4C7B
(ucs-set-char #x5B9C ?$@59(B) ; J78-@-3539
(ucs-set-char #x5B9C ?$ARK(B) ; GB0-A-524B
(ucs-set-char #x5B9C ?$B59(B) ; J83-B-3539
(ucs-set-char #x5B9D ?$(I(N(B) ; C03-I-284E
(ucs-set-char #x5B9D ?$@Ju(B) ; J78-@-4A75
(ucs-set-char #x5B9D ?$A1&(B) ; GB0-A-3126
(ucs-set-char #x5B9D ?$BJu(B) ; J83-B-4A75
(ucs-set-char #x5B9E ?$(I(K(B) ; C03-I-284B
(ucs-set-char #x5B9E ?$AJ5(B) ; GB0-A-4A35
(ucs-set-char #x5B9F ?$(I(M(B) ; C03-I-284D
(ucs-set-char #x5B9F ?$@<B(B) ; J78-@-3C42
(ucs-set-char #x5B9F ?$B<B(B) ; J83-B-3C42
(ucs-set-char #x5BA0 ?$A3h(B) ; GB0-A-3368
(ucs-set-char #x5BA1 ?$AIs(B) ; GB0-A-4973
(ucs-set-char #x5BA2 ?$(CKT(B) ; KS0-C-4B54
(ucs-set-char #x5BA2 ?$(GPj(B) ; C01-G-506A
(ucs-set-char #x5BA2 ?$@5R(B) ; J78-@-3552
(ucs-set-char #x5BA2 ?$A?M(B) ; GB0-A-3F4D
(ucs-set-char #x5BA2 ?$B5R(B) ; J83-B-3552
(ucs-set-char #x5BA3 ?$(C`>(B) ; KS0-C-603E
(ucs-set-char #x5BA3 ?$(GPg(B) ; C01-G-5067
(ucs-set-char #x5BA3 ?$@@k(B) ; J78-@-406B
(ucs-set-char #x5BA3 ?$AP{(B) ; GB0-A-507B
(ucs-set-char #x5BA3 ?$B@k(B) ; J83-B-406B
(ucs-set-char #x5BA4 ?$(Ccx(B) ; KS0-C-6378
(ucs-set-char #x5BA4 ?$(GPi(B) ; C01-G-5069
(ucs-set-char #x5BA4 ?$@<<(B) ; J78-@-3C3C
(ucs-set-char #x5BA4 ?$AJR(B) ; GB0-A-4A52
(ucs-set-char #x5BA4 ?$B<<(B) ; J83-B-3C3C
(ucs-set-char #x5BA5 ?$(Cji(B) ; KS0-C-6A69
(ucs-set-char #x5BA5 ?$(GPk(B) ; C01-G-506B
(ucs-set-char #x5BA5 ?$@M((B) ; J78-@-4D28
(ucs-set-char #x5BA5 ?$Ae6(B) ; GB0-A-6536
(ucs-set-char #x5BA5 ?$BM((B) ; J83-B-4D28
(ucs-set-char #x5BA6 ?$(C|2(B) ; KS0-C-7C32
(ucs-set-char #x5BA6 ?$(GPh(B) ; C01-G-5068
(ucs-set-char #x5BA6 ?$@Ua(B) ; J78-@-5561
(ucs-set-char #x5BA6 ?$A;B(B) ; GB0-A-3B42
(ucs-set-char #x5BA6 ?$BUa(B) ; J83-B-5561
(ucs-set-char #x5BA7 ?$(H.h(B) ; C02-H-2E68
(ucs-set-char #x5BA8 ?$(D:Q(B) ; J90-D-3A51
(ucs-set-char #x5BA8 ?$(H)x(B) ; C02-H-2978
(ucs-set-char #x5BA9 ?$(D:R(B) ; J90-D-3A52
(ucs-set-char #x5BAA ?$AO\(B) ; GB0-A-4F5C
(ucs-set-char #x5BAB ?$(I,2(B) ; C03-I-2C32
(ucs-set-char #x5BAB ?$A9,(B) ; GB0-A-392C
(ucs-set-char #x5BAC ?$(C`t(B) ; KS0-C-6074
(ucs-set-char #x5BAC ?$(D:S(B) ; J90-D-3A53
(ucs-set-char #x5BAC ?$(H.j(B) ; C02-H-2E6A
(ucs-set-char #x5BAD ?$(D:T(B) ; J90-D-3A54
(ucs-set-char #x5BAD ?$(H.i(B) ; C02-H-2E69
(ucs-set-char #x5BAE ?$(CO`(B) ; KS0-C-4F60
(ucs-set-char #x5BAE ?$(GU'(B) ; C01-G-5527
(ucs-set-char #x5BAE ?$@5\(B) ; J78-@-355C
(ucs-set-char #x5BAE ?$B5\(B) ; J83-B-355C
(ucs-set-char #x5BAF ?$(D:U(B) ; J90-D-3A55
(ucs-set-char #x5BAF ?$(J,F(B) ; C04-J-2C46
(ucs-set-char #x5BB0 ?$(Cn%(B) ; KS0-C-6E25
(ucs-set-char #x5BB0 ?$(GU#(B) ; C01-G-5523
(ucs-set-char #x5BB0 ?$@:K(B) ; J78-@-3A4B
(ucs-set-char #x5BB0 ?$ATW(B) ; GB0-A-5457
(ucs-set-char #x5BB0 ?$B:K(B) ; J83-B-3A4B
(ucs-set-char #x5BB1 ?$(D:V(B) ; J90-D-3A56
(ucs-set-char #x5BB1 ?$(J,I(B) ; C04-J-2C49
(ucs-set-char #x5BB2 ?$(D:W(B) ; J90-D-3A57
(ucs-set-char #x5BB2 ?$(L6f(B) ; C06-L-3666
(ucs-set-char #x5BB3 ?$(Cz*(B) ; KS0-C-7A2A
(ucs-set-char #x5BB3 ?$(GU$(B) ; C01-G-5524
(ucs-set-char #x5BB3 ?$@32(B) ; J78-@-3332
(ucs-set-char #x5BB3 ?$A:&(B) ; GB0-A-3A26
(ucs-set-char #x5BB3 ?$B32(B) ; J83-B-3332
(ucs-set-char #x5BB4 ?$(CfC(B) ; KS0-C-6643
(ucs-set-char #x5BB4 ?$(GU&(B) ; C01-G-5526
(ucs-set-char #x5BB4 ?$@1c(B) ; J78-@-3163
(ucs-set-char #x5BB4 ?$AQg(B) ; GB0-A-5167
(ucs-set-char #x5BB4 ?$B1c(B) ; J83-B-3163
(ucs-set-char #x5BB5 ?$(Ca2(B) ; KS0-C-6132
(ucs-set-char #x5BB5 ?$(GU((B) ; C01-G-5528
(ucs-set-char #x5BB5 ?$@>,(B) ; J78-@-3E2C
(ucs-set-char #x5BB5 ?$AO|(B) ; GB0-A-4F7C
(ucs-set-char #x5BB5 ?$B>,(B) ; J83-B-3E2C
(ucs-set-char #x5BB6 ?$(CJ+(B) ; KS0-C-4A2B
(ucs-set-char #x5BB6 ?$(GU%(B) ; C01-G-5525
(ucs-set-char #x5BB6 ?$@2H(B) ; J78-@-3248
(ucs-set-char #x5BB6 ?$A<R(B) ; GB0-A-3C52
(ucs-set-char #x5BB6 ?$B2H(B) ; J83-B-3248
(ucs-set-char #x5BB7 ?$(D:X(B) ; J90-D-3A58
(ucs-set-char #x5BB7 ?$(I0W(B) ; C03-I-3057
(ucs-set-char #x5BB8 ?$(Ccd(B) ; KS0-C-6364
(ucs-set-char #x5BB8 ?$(GU*(B) ; C01-G-552A
(ucs-set-char #x5BB8 ?$@Ub(B) ; J78-@-5562
(ucs-set-char #x5BB8 ?$Ae7(B) ; GB0-A-6537
(ucs-set-char #x5BB8 ?$BUb(B) ; J83-B-5562
(ucs-set-char #x5BB9 ?$(Ci;(B) ; KS0-C-693B
(ucs-set-char #x5BB9 ?$(GU)(B) ; C01-G-5529
(ucs-set-char #x5BB9 ?$@MF(B) ; J78-@-4D46
(ucs-set-char #x5BB9 ?$AH](B) ; GB0-A-485D
(ucs-set-char #x5BB9 ?$BMF(B) ; J83-B-4D46
(ucs-set-char #x5BBA ?$(D:Y(B) ; J90-D-3A59
(ucs-set-char #x5BBA ?$(J,H(B) ; C04-J-2C48
(ucs-set-char #x5BBB ?$(I0V(B) ; C03-I-3056
(ucs-set-char #x5BBC ?$(D:Z(B) ; J90-D-3A5A
(ucs-set-char #x5BBC ?$(I0U(B) ; C03-I-3055
(ucs-set-char #x5BBD ?$A?m(B) ; GB0-A-3F6D
(ucs-set-char #x5BBE ?$A1v(B) ; GB0-A-3176
(ucs-set-char #x5BBF ?$(CbV(B) ; KS0-C-6256
(ucs-set-char #x5BBF ?$(GYn(B) ; C01-G-596E
(ucs-set-char #x5BBF ?$@=I(B) ; J78-@-3D49
(ucs-set-char #x5BBF ?$AK^(B) ; GB0-A-4B5E
(ucs-set-char #x5BBF ?$B=I(B) ; J83-B-3D49
(ucs-set-char #x5BC0 ?$(Csr(B) ; KS0-C-7372
(ucs-set-char #x5BC0 ?$(D:[(B) ; J90-D-3A5B
(ucs-set-char #x5BC0 ?$(H4u(B) ; C02-H-3475
(ucs-set-char #x5BC1 ?$(D:\(B) ; J90-D-3A5C
(ucs-set-char #x5BC1 ?$(H4t(B) ; C02-H-3474
(ucs-set-char #x5BC2 ?$(CnV(B) ; KS0-C-6E56
(ucs-set-char #x5BC2 ?$(GYm(B) ; C01-G-596D
(ucs-set-char #x5BC2 ?$@<d(B) ; J78-@-3C64
(ucs-set-char #x5BC2 ?$A<E(B) ; GB0-A-3C45
(ucs-set-char #x5BC2 ?$B<d(B) ; J83-B-3C64
(ucs-set-char #x5BC3 ?$(Cj2(B) ; KS0-C-6A32
(ucs-set-char #x5BC3 ?$(I5A(B) ; C03-I-3541
(ucs-set-char #x5BC3 ?$@Uc(B) ; J78-@-5563
(ucs-set-char #x5BC3 ?$BUc(B) ; J83-B-5563
(ucs-set-char #x5BC4 ?$(CPv(B) ; KS0-C-5076
(ucs-set-char #x5BC4 ?$(GYl(B) ; C01-G-596C
(ucs-set-char #x5BC4 ?$@4s(B) ; J78-@-3473
(ucs-set-char #x5BC4 ?$A<D(B) ; GB0-A-3C44
(ucs-set-char #x5BC4 ?$B4s(B) ; J83-B-3473
(ucs-set-char #x5BC5 ?$(ClY(B) ; KS0-C-6C59
(ucs-set-char #x5BC5 ?$(GYk(B) ; C01-G-596B
(ucs-set-char #x5BC5 ?$@FR(B) ; J78-@-4652
(ucs-set-char #x5BC5 ?$ARz(B) ; GB0-A-527A
(ucs-set-char #x5BC5 ?$BFR(B) ; J83-B-4652
(ucs-set-char #x5BC6 ?$(CZK(B) ; KS0-C-5A4B
(ucs-set-char #x5BC6 ?$(GYo(B) ; C01-G-596F
(ucs-set-char #x5BC6 ?$@L)(B) ; J78-@-4C29
(ucs-set-char #x5BC6 ?$AC\(B) ; GB0-A-435C
(ucs-set-char #x5BC6 ?$BL)(B) ; J83-B-4C29
(ucs-set-char #x5BC7 ?$(CO((B) ; KS0-C-4F28
(ucs-set-char #x5BC7 ?$(GYj(B) ; C01-G-596A
(ucs-set-char #x5BC7 ?$@Ud(B) ; J78-@-5564
(ucs-set-char #x5BC7 ?$A?\(B) ; GB0-A-3F5C
(ucs-set-char #x5BC7 ?$BUd(B) ; J83-B-5564
(ucs-set-char #x5BC8 ?$(I5?(B) ; C03-I-353F
(ucs-set-char #x5BC9 ?$@Ue(B) ; J78-@-5565
(ucs-set-char #x5BC9 ?$BUe(B) ; J83-B-5565
(ucs-set-char #x5BCA ?$(H;9(B) ; C02-H-3B39
(ucs-set-char #x5BCB ?$(H;6(B) ; C02-H-3B36
(ucs-set-char #x5BCC ?$(C]#(B) ; KS0-C-5D23
(ucs-set-char #x5BCC ?$(G^n(B) ; C01-G-5E6E
(ucs-set-char #x5BCC ?$@IY(B) ; J78-@-4959
(ucs-set-char #x5BCC ?$A8;(B) ; GB0-A-383B
(ucs-set-char #x5BCC ?$BIY(B) ; J83-B-4959
(ucs-set-char #x5BCD ?$(D:](B) ; J90-D-3A5D
(ucs-set-char #x5BCD ?$(H;5(B) ; C02-H-3B35
(ucs-set-char #x5BCE ?$(H;:(B) ; C02-H-3B3A
(ucs-set-char #x5BCF ?$(D:^(B) ; J90-D-3A5E
(ucs-set-char #x5BCF ?$(J7$(B) ; C04-J-3724
(ucs-set-char #x5BD0 ?$(CX[(B) ; KS0-C-585B
(ucs-set-char #x5BD0 ?$(G^p(B) ; C01-G-5E70
(ucs-set-char #x5BD0 ?$@Ug(B) ; J78-@-5567
(ucs-set-char #x5BD0 ?$ACB(B) ; GB0-A-4342
(ucs-set-char #x5BD0 ?$BUg(B) ; J83-B-5567
(ucs-set-char #x5BD1 ?$(H;8(B) ; C02-H-3B38
(ucs-set-char #x5BD2 ?$(CyN(B) ; KS0-C-794E
(ucs-set-char #x5BD2 ?$(G^m(B) ; C01-G-5E6D
(ucs-set-char #x5BD2 ?$@4((B) ; J78-@-3428
(ucs-set-char #x5BD2 ?$A:.(B) ; GB0-A-3A2E
(ucs-set-char #x5BD2 ?$B4((B) ; J83-B-3428
(ucs-set-char #x5BD3 ?$(CiU(B) ; KS0-C-6955
(ucs-set-char #x5BD3 ?$(G^o(B) ; C01-G-5E6F
(ucs-set-char #x5BD3 ?$@6w(B) ; J78-@-3677
(ucs-set-char #x5BD3 ?$AT"(B) ; GB0-A-5422
(ucs-set-char #x5BD3 ?$B6w(B) ; J83-B-3677
(ucs-set-char #x5BD4 ?$(CcQ(B) ; KS0-C-6351
(ucs-set-char #x5BD4 ?$(H;7(B) ; C02-H-3B37
(ucs-set-char #x5BD4 ?$@Uf(B) ; J78-@-5566
(ucs-set-char #x5BD4 ?$BUf(B) ; J83-B-5566
(ucs-set-char #x5BD5 ?$(I:~(B) ; C03-I-3A7E
(ucs-set-char #x5BD6 ?$(D:_(B) ; J90-D-3A5F
(ucs-set-char #x5BD6 ?$(HBN(B) ; C02-H-424E
(ucs-set-char #x5BD7 ?$(CR<(B) ; KS0-C-523C
(ucs-set-char #x5BD7 ?$(D:`(B) ; J90-D-3A60
(ucs-set-char #x5BD7 ?$(I@t(B) ; C03-I-4074
(ucs-set-char #x5BD8 ?$(D:a(B) ; J90-D-3A61
(ucs-set-char #x5BD8 ?$(HBO(B) ; C02-H-424F
(ucs-set-char #x5BD9 ?$(D:b(B) ; J90-D-3A62
(ucs-set-char #x5BD9 ?$(HBP(B) ; C02-H-4250
(ucs-set-char #x5BDA ?$(D:c(B) ; J90-D-3A63
(ucs-set-char #x5BDA ?$(I@u(B) ; C03-I-4075
(ucs-set-char #x5BDB ?$(I@v(B) ; C03-I-4076
(ucs-set-char #x5BDB ?$@42(B) ; J78-@-3432
(ucs-set-char #x5BDB ?$B42(B) ; J83-B-3432
(ucs-set-char #x5BDC ?$(I@s(B) ; C03-I-4073
(ucs-set-char #x5BDD ?$(J<n(B) ; C04-J-3C6E
(ucs-set-char #x5BDD ?$@?2(B) ; J78-@-3F32
(ucs-set-char #x5BDD ?$AG^(B) ; GB0-A-475E
(ucs-set-char #x5BDD ?$B?2(B) ; J83-B-3F32
(ucs-set-char #x5BDE ?$(CX,(B) ; KS0-C-582C
(ucs-set-char #x5BDE ?$(GhN(B) ; C01-G-684E
(ucs-set-char #x5BDE ?$@Uk(B) ; J78-@-556B
(ucs-set-char #x5BDE ?$AD/(B) ; GB0-A-442F
(ucs-set-char #x5BDE ?$BUk(B) ; J83-B-556B
(ucs-set-char #x5BDF ?$(CsL(B) ; KS0-C-734C
(ucs-set-char #x5BDF ?$(GhV(B) ; C01-G-6856
(ucs-set-char #x5BDF ?$@;!(B) ; J78-@-3B21
(ucs-set-char #x5BDF ?$A2l(B) ; GB0-A-326C
(ucs-set-char #x5BDF ?$B;!(B) ; J83-B-3B21
(ucs-set-char #x5BE0 ?$(D:d(B) ; J90-D-3A64
(ucs-set-char #x5BE0 ?$(HIe(B) ; C02-H-4965
(ucs-set-char #x5BE1 ?$(CM{(B) ; KS0-C-4D7B
(ucs-set-char #x5BE1 ?$(GhP(B) ; C01-G-6850
(ucs-set-char #x5BE1 ?$@2I(B) ; J78-@-3249
(ucs-set-char #x5BE1 ?$A9Q(B) ; GB0-A-3951
(ucs-set-char #x5BE1 ?$B2I(B) ; J83-B-3249
(ucs-set-char #x5BE2 ?$(CvV(B) ; KS0-C-7656
(ucs-set-char #x5BE2 ?$(GhT(B) ; C01-G-6854
(ucs-set-char #x5BE2 ?$@Uj(B) ; J78-@-556A
(ucs-set-char #x5BE2 ?$BUj(B) ; J83-B-556A
(ucs-set-char #x5BE3 ?$(HIf(B) ; C02-H-4966
(ucs-set-char #x5BE4 ?$(Cgu(B) ; KS0-C-6775
(ucs-set-char #x5BE4 ?$(GhU(B) ; C01-G-6855
(ucs-set-char #x5BE4 ?$@Uh(B) ; J78-@-5568
(ucs-set-char #x5BE4 ?$Ae;(B) ; GB0-A-653B
(ucs-set-char #x5BE4 ?$BUh(B) ; J83-B-5568
(ucs-set-char #x5BE5 ?$(Cho(B) ; KS0-C-686F
(ucs-set-char #x5BE5 ?$(GhQ(B) ; C01-G-6851
(ucs-set-char #x5BE5 ?$@Ul(B) ; J78-@-556C
(ucs-set-char #x5BE5 ?$AAH(B) ; GB0-A-4148
(ucs-set-char #x5BE5 ?$BUl(B) ; J83-B-556C
(ucs-set-char #x5BE6 ?$(Ccy(B) ; KS0-C-6379
(ucs-set-char #x5BE6 ?$(GhR(B) ; C01-G-6852
(ucs-set-char #x5BE6 ?$@Ui(B) ; J78-@-5569
(ucs-set-char #x5BE6 ?$BUi(B) ; J83-B-5569
(ucs-set-char #x5BE7 ?$(CR;(B) ; KS0-C-523B
(ucs-set-char #x5BE7 ?$(GhO(B) ; C01-G-684F
(ucs-set-char #x5BE7 ?$@G+(B) ; J78-@-472B
(ucs-set-char #x5BE7 ?$BG+(B) ; J83-B-472B
(ucs-set-char #x5BE8 ?$(Css(B) ; KS0-C-7373
(ucs-set-char #x5BE8 ?$(GhS(B) ; C01-G-6853
(ucs-set-char #x5BE8 ?$@\M(B) ; J78-@-5C4D
(ucs-set-char #x5BE8 ?$AU/(B) ; GB0-A-552F
(ucs-set-char #x5BE8 ?$B\M(B) ; J83-B-5C4D
(ucs-set-char #x5BE9 ?$(Cc{(B) ; KS0-C-637B
(ucs-set-char #x5BE9 ?$(GlP(B) ; C01-G-6C50
(ucs-set-char #x5BE9 ?$@?3(B) ; J78-@-3F33
(ucs-set-char #x5BE9 ?$B?3(B) ; J83-B-3F33
(ucs-set-char #x5BEA ?$(H;4(B) ; C02-H-3B34
(ucs-set-char #x5BEB ?$(C^P(B) ; KS0-C-5E50
(ucs-set-char #x5BEB ?$(GlQ(B) ; C01-G-6C51
(ucs-set-char #x5BEB ?$@Um(B) ; J78-@-556D
(ucs-set-char #x5BEB ?$BUm(B) ; J83-B-556D
(ucs-set-char #x5BEC ?$(CN0(B) ; KS0-C-4E30
(ucs-set-char #x5BEC ?$(GlO(B) ; C01-G-6C4F
(ucs-set-char #x5BED ?$(JID(B) ; C04-J-4944
(ucs-set-char #x5BEE ?$(CVw(B) ; KS0-C-5677
(ucs-set-char #x5BEE ?$(GlN(B) ; C01-G-6C4E
(ucs-set-char #x5BEE ?$@N@(B) ; J78-@-4E40
(ucs-set-char #x5BEE ?$Ae<(B) ; GB0-A-653C
(ucs-set-char #x5BEE ?$BN@(B) ; J83-B-4E40
(ucs-set-char #x5BEF ?$(CqY(B) ; KS0-C-7159
(ucs-set-char #x5BEF ?$(D:e(B) ; J90-D-3A65
(ucs-set-char #x5BEF ?$(HVg(B) ; C02-H-5667
(ucs-set-char #x5BF0 ?$(GpQ(B) ; C01-G-7051
(ucs-set-char #x5BF0 ?$@Un(B) ; J78-@-556E
(ucs-set-char #x5BF0 ?$Ae>(B) ; GB0-A-653E
(ucs-set-char #x5BF0 ?$BUn(B) ; J83-B-556E
(ucs-set-char #x5BF1 ?$(D:f(B) ; J90-D-3A66
(ucs-set-char #x5BF1 ?$(H\d(B) ; C02-H-5C64
(ucs-set-char #x5BF2 ?$(H\e(B) ; C02-H-5C65
(ucs-set-char #x5BF3 ?$(IZ5(B) ; C03-I-5A35
(ucs-set-char #x5BF3 ?$(IZ6(B) ; C03-I-5A36
(ucs-set-char #x5BF3 ?$@Up(B) ; J78-@-5570
(ucs-set-char #x5BF3 ?$BUp(B) ; J83-B-5570
(ucs-set-char #x5BF4 ?$(D:g(B) ; J90-D-3A67
(ucs-set-char #x5BF4 ?$(J_U(B) ; C04-J-5F55
(ucs-set-char #x5BF5 ?$(CuA(B) ; KS0-C-7541
(ucs-set-char #x5BF5 ?$(Gx1(B) ; C01-G-7831
(ucs-set-char #x5BF5 ?$@C~(B) ; J78-@-437E
(ucs-set-char #x5BF5 ?$BC~(B) ; J83-B-437E
(ucs-set-char #x5BF6 ?$(C\D(B) ; KS0-C-5C44
(ucs-set-char #x5BF6 ?$(Gyj(B) ; C01-G-796A
(ucs-set-char #x5BF6 ?$@Uo(B) ; J78-@-556F
(ucs-set-char #x5BF6 ?$BUo(B) ; J83-B-556F
(ucs-set-char #x5BF7 ?$(I^*(B) ; C03-I-5E2A

(ucs-set-char #x5BF8 ?$A4g(B) ; GB0-A-3467
(ucs-set-char #x5BF8 ?$(Cu;(B) ; KS0-C-753B
(ucs-set-char #x5BF8 ?$(GDP(B) ; C01-G-4450
(ucs-set-char #x5BF8 ?$@@#(B) ; J78-@-4023
(ucs-set-char #x5BF8 ?$B@#(B) ; J83-B-4023

(ucs-set-char #x5BF9 ?$(I">(B) ; C03-I-223E
(ucs-set-char #x5BF9 ?$A6T(B) ; GB0-A-3654
(ucs-set-char #x5BFA ?$(C^Q(B) ; KS0-C-5E51
(ucs-set-char #x5BFA ?$(GGy(B) ; C01-G-4779
(ucs-set-char #x5BFA ?$@;{(B) ; J78-@-3B7B
(ucs-set-char #x5BFA ?$AKB(B) ; GB0-A-4B42
(ucs-set-char #x5BFA ?$B;{(B) ; J83-B-3B7B
(ucs-set-char #x5BFB ?$AQ0(B) ; GB0-A-5130
(ucs-set-char #x5BFC ?$A5<(B) ; GB0-A-353C
(ucs-set-char #x5BFD ?$(D:h(B) ; J90-D-3A68
(ucs-set-char #x5BFD ?$(I%^(B) ; C03-I-255E
(ucs-set-char #x5BFE ?$(I%\(B) ; C03-I-255C
(ucs-set-char #x5BFE ?$@BP(B) ; J78-@-4250
(ucs-set-char #x5BFE ?$BBP(B) ; J83-B-4250
(ucs-set-char #x5BFF ?$(I%](B) ; C03-I-255D
(ucs-set-char #x5BFF ?$(L'!(B) ; C06-L-2721
(ucs-set-char #x5BFF ?$@<w(B) ; J78-@-3C77
(ucs-set-char #x5BFF ?$AJY(B) ; GB0-A-4A59
(ucs-set-char #x5BFF ?$B<w(B) ; J83-B-3C77
(ucs-set-char #x5C00 ?$(I(P(B) ; C03-I-2850
(ucs-set-char #x5C01 ?$(C\f(B) ; KS0-C-5C66
(ucs-set-char #x5C01 ?$(GPl(B) ; C01-G-506C
(ucs-set-char #x5C01 ?$@Iu(B) ; J78-@-4975
(ucs-set-char #x5C01 ?$A7b(B) ; GB0-A-3762
(ucs-set-char #x5C01 ?$BIu(B) ; J83-B-4975
(ucs-set-char #x5C02 ?$@@l(B) ; J78-@-406C
(ucs-set-char #x5C02 ?$B@l(B) ; J83-B-406C
(ucs-set-char #x5C03 ?$(H.k(B) ; C02-H-2E6B
(ucs-set-char #x5C04 ?$(C^R(B) ; KS0-C-5E52
(ucs-set-char #x5C04 ?$(GU+(B) ; C01-G-552B
(ucs-set-char #x5C04 ?$@<M(B) ; J78-@-3C4D
(ucs-set-char #x5C04 ?$AId(B) ; GB0-A-4964
(ucs-set-char #x5C04 ?$B<M(B) ; J83-B-3C4D
(ucs-set-char #x5C05 ?$(I0X(B) ; C03-I-3058
(ucs-set-char #x5C05 ?$@Uq(B) ; J78-@-5571
(ucs-set-char #x5C05 ?$BUq(B) ; J83-B-5571
(ucs-set-char #x5C06 ?$(I0Y(B) ; C03-I-3059
(ucs-set-char #x5C06 ?$@>-(B) ; J78-@-3E2D
(ucs-set-char #x5C06 ?$A=+(B) ; GB0-A-3D2B
(ucs-set-char #x5C06 ?$B>-(B) ; J83-B-3E2D
(ucs-set-char #x5C07 ?$(Cmb(B) ; KS0-C-6D62
(ucs-set-char #x5C07 ?$(GYr(B) ; C01-G-5972
(ucs-set-char #x5C07 ?$@Ur(B) ; J78-@-5572
(ucs-set-char #x5C07 ?$BUr(B) ; J83-B-5572
(ucs-set-char #x5C08 ?$(Cnv(B) ; KS0-C-6E76
(ucs-set-char #x5C08 ?$(GYq(B) ; C01-G-5971
(ucs-set-char #x5C08 ?$@Us(B) ; J78-@-5573
(ucs-set-char #x5C08 ?$BUs(B) ; J83-B-5573
(ucs-set-char #x5C09 ?$(CjO(B) ; KS0-C-6A4F
(ucs-set-char #x5C09 ?$(GYp(B) ; C01-G-5970
(ucs-set-char #x5C09 ?$@0S(B) ; J78-@-3053
(ucs-set-char #x5C09 ?$AN>(B) ; GB0-A-4E3E
(ucs-set-char #x5C09 ?$B0S(B) ; J83-B-3053
(ucs-set-char #x5C0A ?$(Cpn(B) ; KS0-C-706E
(ucs-set-char #x5C0A ?$(G^q(B) ; C01-G-5E71
(ucs-set-char #x5C0A ?$@B:(B) ; J78-@-423A
(ucs-set-char #x5C0A ?$AWp(B) ; GB0-A-5770
(ucs-set-char #x5C0A ?$BB:(B) ; J83-B-423A
(ucs-set-char #x5C0B ?$(Cc|(B) ; KS0-C-637C
(ucs-set-char #x5C0B ?$(G^r(B) ; C01-G-5E72
(ucs-set-char #x5C0B ?$@?R(B) ; J78-@-3F52
(ucs-set-char #x5C0B ?$B?R(B) ; J83-B-3F52
(ucs-set-char #x5C0C ?$(D:i(B) ; J90-D-3A69
(ucs-set-char #x5C0C ?$(H;;(B) ; C02-H-3B3B
(ucs-set-char #x5C0D ?$(CS_(B) ; KS0-C-535F
(ucs-set-char #x5C0D ?$(GhW(B) ; C01-G-6857
(ucs-set-char #x5C0D ?$@Ut(B) ; J78-@-5574
(ucs-set-char #x5C0D ?$BUt(B) ; J83-B-5574
(ucs-set-char #x5C0E ?$(CSt(B) ; KS0-C-5374
(ucs-set-char #x5C0E ?$(GpR(B) ; C01-G-7052
(ucs-set-char #x5C0E ?$@F3(B) ; J78-@-4633
(ucs-set-char #x5C0E ?$BF3(B) ; J83-B-4633

(ucs-set-char #x5C0F ?$AP!(B) ; GB0-A-5021
(ucs-set-char #x5C0F ?$(Ca3(B) ; KS0-C-6133
(ucs-set-char #x5C0F ?$(GDQ(B) ; C01-G-4451
(ucs-set-char #x5C0F ?$@>.(B) ; J78-@-3E2E
(ucs-set-char #x5C0F ?$B>.(B) ; J83-B-3E2E

(ucs-set-char #x5C10 ?$(H!<(B) ; C02-H-213C
(ucs-set-char #x5C11 ?$(Ca4(B) ; KS0-C-6134
(ucs-set-char #x5C11 ?$(GE7(B) ; C01-G-4537
(ucs-set-char #x5C11 ?$@>/(B) ; J78-@-3E2F
(ucs-set-char #x5C11 ?$AIY(B) ; GB0-A-4959
(ucs-set-char #x5C11 ?$B>/(B) ; J83-B-3E2F
(ucs-set-char #x5C12 ?$(H!U(B) ; C02-H-2155
(ucs-set-char #x5C13 ?$(J!s(B) ; C04-J-2173
(ucs-set-char #x5C13 ?$@Uu(B) ; J78-@-5575
(ucs-set-char #x5C13 ?$BUu(B) ; J83-B-5575
(ucs-set-char #x5C14 ?$(I"?(B) ; C03-I-223F
(ucs-set-char #x5C14 ?$A6{(B) ; GB0-A-367B
(ucs-set-char #x5C15 ?$(H"4(B) ; C02-H-2234
(ucs-set-char #x5C15 ?$AfX(B) ; GB0-A-6658
(ucs-set-char #x5C16 ?$(CtS(B) ; KS0-C-7453
(ucs-set-char #x5C16 ?$(GGz(B) ; C01-G-477A
(ucs-set-char #x5C16 ?$@@m(B) ; J78-@-406D
(ucs-set-char #x5C16 ?$A<b(B) ; GB0-A-3C62
(ucs-set-char #x5C16 ?$B@m(B) ; J83-B-406D
(ucs-set-char #x5C17 ?$(D:j(B) ; J90-D-3A6A
(ucs-set-char #x5C17 ?$(J"\(B) ; C04-J-225C
(ucs-set-char #x5C18 ?$(I#R(B) ; C03-I-2352
(ucs-set-char #x5C18 ?$A3>(B) ; GB0-A-333E
(ucs-set-char #x5C19 ?$(C_F(B) ; KS0-C-5F46
(ucs-set-char #x5C19 ?$(I(Q(B) ; C03-I-2851
(ucs-set-char #x5C1A ?$(GL~(B) ; C01-G-4C7E
(ucs-set-char #x5C1A ?$@>0(B) ; J78-@-3E30
(ucs-set-char #x5C1A ?$AIP(B) ; GB0-A-4950
(ucs-set-char #x5C1A ?$B>0(B) ; J83-B-3E30
(ucs-set-char #x5C1B ?$(I,4(B) ; C03-I-2C34
(ucs-set-char #x5C1C ?$AfY(B) ; GB0-A-6659
(ucs-set-char #x5C1D ?$A3"(B) ; GB0-A-3322
(ucs-set-char #x5C1E ?$(D:k(B) ; J90-D-3A6B
(ucs-set-char #x5C1E ?$(I;$(B) ; C03-I-3B24
(ucs-set-char #x5C1F ?$(D:l(B) ; J90-D-3A6C
(ucs-set-char #x5C1F ?$(HBQ(B) ; C02-H-4251
(ucs-set-char #x5C20 ?$(I@x(B) ; C03-I-4078
(ucs-set-char #x5C20 ?$@Uv(B) ; J78-@-5576
(ucs-set-char #x5C20 ?$BUv(B) ; J83-B-5576

(ucs-set-char #x5C22 ?$A^L(B) ; GB0-A-5E4C
(ucs-set-char #x5C22 ?$(J!4(B) ; C04-J-2134
(ucs-set-char #x5C22 ?$(GDR(B) ; C01-G-4452
(ucs-set-char #x5C22 ?$@Uw(B) ; J78-@-5577
(ucs-set-char #x5C22 ?$BUw(B) ; J83-B-5577

(ucs-set-char #x5C23 ?$(D:m(B) ; J90-D-3A6D
(ucs-set-char #x5C23 ?$(J!K(B) ; C04-J-214B
(ucs-set-char #x5C24 ?$(CiV(B) ; KS0-C-6956
(ucs-set-char #x5C24 ?$(GE8(B) ; C01-G-4538
(ucs-set-char #x5C24 ?$@L`(B) ; J78-@-4C60
(ucs-set-char #x5C24 ?$ASH(B) ; GB0-A-5348
(ucs-set-char #x5C24 ?$BL`(B) ; J83-B-4C60
(ucs-set-char #x5C25 ?$(H"5(B) ; C02-H-2235
(ucs-set-char #x5C25 ?$A^M(B) ; GB0-A-5E4D
(ucs-set-char #x5C26 ?$(D:n(B) ; J90-D-3A6E
(ucs-set-char #x5C27 ?$AR"(B) ; GB0-A-5222
(ucs-set-char #x5C28 ?$(C[+(B) ; KS0-C-5B2B
(ucs-set-char #x5C28 ?$(H#^(B) ; C02-H-235E
(ucs-set-char #x5C28 ?$@Ux(B) ; J78-@-5578
(ucs-set-char #x5C28 ?$BUx(B) ; J83-B-5578
(ucs-set-char #x5C29 ?$(D:o(B) ; J90-D-3A6F
(ucs-set-char #x5C29 ?$(J&)(B) ; C04-J-2629
(ucs-set-char #x5C2A ?$(H#_(B) ; C02-H-235F
(ucs-set-char #x5C2B ?$(D:p(B) ; J90-D-3A70
(ucs-set-char #x5C2B ?$(I%_(B) ; C03-I-255F
(ucs-set-char #x5C2C ?$(D:q(B) ; J90-D-3A71
(ucs-set-char #x5C2C ?$(GI|(B) ; C01-G-497C
(ucs-set-char #x5C2C ?$A^N(B) ; GB0-A-5E4E
(ucs-set-char #x5C2D ?$B6F(B) ; J83-B-3646
(ucs-set-char #x5C2E ?$(D:r(B) ; J90-D-3A72
(ucs-set-char #x5C2E ?$(K(r(B) ; C05-K-2872
(ucs-set-char #x5C2F ?$(I,5(B) ; C03-I-2C35
(ucs-set-char #x5C30 ?$(D:s(B) ; J90-D-3A73
(ucs-set-char #x5C30 ?$(H;<(B) ; C02-H-3B3C
(ucs-set-char #x5C31 ?$(Cv&(B) ; KS0-C-7626
(ucs-set-char #x5C31 ?$(G^s(B) ; C01-G-5E73
(ucs-set-char #x5C31 ?$@="(B) ; J78-@-3D22
(ucs-set-char #x5C31 ?$A>M(B) ; GB0-A-3E4D
(ucs-set-char #x5C31 ?$B="(B) ; J83-B-3D22
(ucs-set-char #x5C32 ?$(D:t(B) ; J90-D-3A74
(ucs-set-char #x5C32 ?$(JBz(B) ; C04-J-427A
(ucs-set-char #x5C33 ?$(HBR(B) ; C02-H-4252
(ucs-set-char #x5C34 ?$A^O(B) ; GB0-A-5E4F
(ucs-set-char #x5C35 ?$(D:u(B) ; J90-D-3A75
(ucs-set-char #x5C35 ?$(JII(B) ; C04-J-4949
(ucs-set-char #x5C36 ?$(D:v(B) ; J90-D-3A76
(ucs-set-char #x5C36 ?$(ITT(B) ; C03-I-5454
(ucs-set-char #x5C37 ?$(GsS(B) ; C01-G-7353

(ucs-set-char #x5C38 ?$AJ,(B) ; GB0-A-4A2C
(ucs-set-char #x5C38 ?$(Cc9(B) ; KS0-C-6339
(ucs-set-char #x5C38 ?$(GDS(B) ; C01-G-4453
(ucs-set-char #x5C38 ?$@Uy(B) ; J78-@-5579
(ucs-set-char #x5C38 ?$BUy(B) ; J83-B-5579

(ucs-set-char #x5C39 ?$(CkE(B) ; KS0-C-6B45
(ucs-set-char #x5C39 ?$(GDg(B) ; C01-G-4467
(ucs-set-char #x5C39 ?$@Uz(B) ; J78-@-557A
(ucs-set-char #x5C39 ?$AR|(B) ; GB0-A-527C
(ucs-set-char #x5C39 ?$BUz(B) ; J83-B-557A
(ucs-set-char #x5C3A ?$(Ct)(B) ; KS0-C-7429
(ucs-set-char #x5C3A ?$(GE9(B) ; C01-G-4539
(ucs-set-char #x5C3A ?$@<\(B) ; J78-@-3C5C
(ucs-set-char #x5C3A ?$A3_(B) ; GB0-A-335F
(ucs-set-char #x5C3A ?$B<\(B) ; J83-B-3C5C
(ucs-set-char #x5C3B ?$(CM6(B) ; KS0-C-4D36
(ucs-set-char #x5C3B ?$(H!V(B) ; C02-H-2156
(ucs-set-char #x5C3B ?$@?,(B) ; J78-@-3F2C
(ucs-set-char #x5C3B ?$Aej(B) ; GB0-A-656A
(ucs-set-char #x5C3B ?$B?,(B) ; J83-B-3F2C
(ucs-set-char #x5C3C ?$(CRy(B) ; KS0-C-5279
(ucs-set-char #x5C3C ?$(GFG(B) ; C01-G-4647
(ucs-set-char #x5C3C ?$@Ft(B) ; J78-@-4674
(ucs-set-char #x5C3C ?$ADa(B) ; GB0-A-4461
(ucs-set-char #x5C3C ?$BFt(B) ; J83-B-4674
(ucs-set-char #x5C3D ?$(I#T(B) ; C03-I-2354
(ucs-set-char #x5C3D ?$@?T(B) ; J78-@-3F54
(ucs-set-char #x5C3D ?$A>!(B) ; GB0-A-3E21
(ucs-set-char #x5C3D ?$B?T(B) ; J83-B-3F54
(ucs-set-char #x5C3E ?$(CZ-(B) ; KS0-C-5A2D
(ucs-set-char #x5C3E ?$(GJ"(B) ; C01-G-4A22
(ucs-set-char #x5C3E ?$@Hx(B) ; J78-@-4878
(ucs-set-char #x5C3E ?$AN2(B) ; GB0-A-4E32
(ucs-set-char #x5C3E ?$BHx(B) ; J83-B-4878
(ucs-set-char #x5C3F ?$(CRc(B) ; KS0-C-5263
(ucs-set-char #x5C3F ?$(GJ!(B) ; C01-G-4A21
(ucs-set-char #x5C3F ?$@G"(B) ; J78-@-4722
(ucs-set-char #x5C3F ?$ADr(B) ; GB0-A-4472
(ucs-set-char #x5C3F ?$BG"(B) ; J83-B-4722
(ucs-set-char #x5C40 ?$(COQ(B) ; KS0-C-4F51
(ucs-set-char #x5C40 ?$(GI}(B) ; C01-G-497D
(ucs-set-char #x5C40 ?$@6I(B) ; J78-@-3649
(ucs-set-char #x5C40 ?$A>V(B) ; GB0-A-3E56
(ucs-set-char #x5C40 ?$B6I(B) ; J83-B-3649
(ucs-set-char #x5C41 ?$(GI~(B) ; C01-G-497E
(ucs-set-char #x5C41 ?$@U{(B) ; J78-@-557B
(ucs-set-char #x5C41 ?$AF((B) ; GB0-A-4628
(ucs-set-char #x5C41 ?$BU{(B) ; J83-B-557B
(ucs-set-char #x5C42 ?$A2c(B) ; GB0-A-3263
(ucs-set-char #x5C44 ?$(H&:(B) ; C02-H-263A
(ucs-set-char #x5C45 ?$(CK\(B) ; KS0-C-4B5C
(ucs-set-char #x5C45 ?$(GM"(B) ; C01-G-4D22
(ucs-set-char #x5C45 ?$@5o(B) ; J78-@-356F
(ucs-set-char #x5C45 ?$A>S(B) ; GB0-A-3E53
(ucs-set-char #x5C45 ?$B5o(B) ; J83-B-356F
(ucs-set-char #x5C46 ?$(CLz(B) ; KS0-C-4C7A
(ucs-set-char #x5C46 ?$(GM#(B) ; C01-G-4D23
(ucs-set-char #x5C46 ?$@U|(B) ; J78-@-557C
(ucs-set-char #x5C46 ?$BU|(B) ; J83-B-557C
(ucs-set-char #x5C47 ?$(H&;(B) ; C02-H-263B
(ucs-set-char #x5C48 ?$(CO](B) ; KS0-C-4F5D
(ucs-set-char #x5C48 ?$(GM!(B) ; C01-G-4D21
(ucs-set-char #x5C48 ?$@6~(B) ; J78-@-367E
(ucs-set-char #x5C48 ?$AG|(B) ; GB0-A-477C
(ucs-set-char #x5C48 ?$B6~(B) ; J83-B-367E
(ucs-set-char #x5C49 ?$(I(T(B) ; C03-I-2854
(ucs-set-char #x5C49 ?$ALk(B) ; GB0-A-4C6B
(ucs-set-char #x5C4A ?$(I(U(B) ; C03-I-2855
(ucs-set-char #x5C4A ?$@FO(B) ; J78-@-464F
(ucs-set-char #x5C4A ?$A=l(B) ; GB0-A-3D6C
(ucs-set-char #x5C4A ?$BFO(B) ; J83-B-464F
(ucs-set-char #x5C4B ?$(Ch)(B) ; KS0-C-6829
(ucs-set-char #x5C4B ?$(GPp(B) ; C01-G-5070
(ucs-set-char #x5C4B ?$@20(B) ; J78-@-3230
(ucs-set-char #x5C4B ?$AN](B) ; GB0-A-4E5D
(ucs-set-char #x5C4B ?$B20(B) ; J83-B-3230
(ucs-set-char #x5C4C ?$(H)y(B) ; C02-H-2979
(ucs-set-char #x5C4D ?$(Cc;(B) ; KS0-C-633B
(ucs-set-char #x5C4D ?$(GPo(B) ; C01-G-506F
(ucs-set-char #x5C4D ?$@;S(B) ; J78-@-3B53
(ucs-set-char #x5C4D ?$B;S(B) ; J83-B-3B53
(ucs-set-char #x5C4E ?$(Cc:(B) ; KS0-C-633A
(ucs-set-char #x5C4E ?$(GPm(B) ; C01-G-506D
(ucs-set-char #x5C4E ?$@U}(B) ; J78-@-557D
(ucs-set-char #x5C4E ?$AJ:(B) ; GB0-A-4A3A
(ucs-set-char #x5C4E ?$BU}(B) ; J83-B-557D
(ucs-set-char #x5C4F ?$(GPn(B) ; C01-G-506E
(ucs-set-char #x5C4F ?$AFA(B) ; GB0-A-4641
(ucs-set-char #x5C4F ?$BV"(B) ; J83-B-5622
(ucs-set-char #x5C50 ?$(GU.(B) ; C01-G-552E
(ucs-set-char #x5C50 ?$@V!(B) ; J78-@-5621
(ucs-set-char #x5C50 ?$Ael(B) ; GB0-A-656C
(ucs-set-char #x5C50 ?$BV!(B) ; J83-B-5621
(ucs-set-char #x5C51 ?$(C`Z(B) ; KS0-C-605A
(ucs-set-char #x5C51 ?$(GU,(B) ; C01-G-552C
(ucs-set-char #x5C51 ?$@6}(B) ; J78-@-367D
(ucs-set-char #x5C51 ?$AP<(B) ; GB0-A-503C
(ucs-set-char #x5C51 ?$B6}(B) ; J83-B-367D
(ucs-set-char #x5C52 ?$(I0Z(B) ; C03-I-305A
(ucs-set-char #x5C53 ?$(I0[(B) ; C03-I-305B
(ucs-set-char #x5C53 ?$@U~(B) ; J78-@-557E
(ucs-set-char #x5C53 ?$BU~(B) ; J83-B-557E
(ucs-set-char #x5C54 ?$(H.m(B) ; C02-H-2E6D
(ucs-set-char #x5C55 ?$(Cnw(B) ; KS0-C-6E77
(ucs-set-char #x5C55 ?$(GU-(B) ; C01-G-552D
(ucs-set-char #x5C55 ?$@E8(B) ; J78-@-4538
(ucs-set-char #x5C55 ?$AU9(B) ; GB0-A-5539
(ucs-set-char #x5C55 ?$BE8(B) ; J83-B-4538
(ucs-set-char #x5C56 ?$(H.l(B) ; C02-H-2E6C
(ucs-set-char #x5C58 ?$(GU"(B) ; C01-G-5522
(ucs-set-char #x5C59 ?$(D:w(B) ; J90-D-3A77
(ucs-set-char #x5C59 ?$(H4v(B) ; C02-H-3476
(ucs-set-char #x5C59 ?$Aem(B) ; GB0-A-656D
(ucs-set-char #x5C5A ?$(D:x(B) ; J90-D-3A78
(ucs-set-char #x5C5A ?$(J15(B) ; C04-J-3135
(ucs-set-char #x5C5B ?$(C\3(B) ; KS0-C-5C33
(ucs-set-char #x5C5B ?$(I5C(B) ; C03-I-3543
(ucs-set-char #x5C5B ?$@V"(B) ; J78-@-5622
(ucs-set-char #x5C5C ?$(D:y(B) ; J90-D-3A79
(ucs-set-char #x5C5C ?$(GYt(B) ; C01-G-5974
(ucs-set-char #x5C5D ?$(GYu(B) ; C01-G-5975
(ucs-set-char #x5C5E ?$(I;&(B) ; C03-I-3B26
(ucs-set-char #x5C5E ?$@B0(B) ; J78-@-4230
(ucs-set-char #x5C5E ?$AJt(B) ; GB0-A-4A74
(ucs-set-char #x5C5E ?$BB0(B) ; J83-B-4230
(ucs-set-char #x5C5F ?$(I;%(B) ; C03-I-3B25
(ucs-set-char #x5C60 ?$(CSu(B) ; KS0-C-5375
(ucs-set-char #x5C60 ?$(GYs(B) ; C01-G-5973
(ucs-set-char #x5C60 ?$(LG{(B) ; C06-L-477B
(ucs-set-char #x5C60 ?$@EK(B) ; J78-@-454B
(ucs-set-char #x5C60 ?$AM@(B) ; GB0-A-4D40
(ucs-set-char #x5C60 ?$BEK(B) ; J83-B-454B
(ucs-set-char #x5C61 ?$(I5D(B) ; C03-I-3544
(ucs-set-char #x5C61 ?$ABE(B) ; GB0-A-4245
(ucs-set-char #x5C61 ?$B<H(B) ; J83-B-3C48
(ucs-set-char #x5C62 ?$(CW&(B) ; KS0-C-5726
(ucs-set-char #x5C62 ?$(D:z(B) ; J90-D-3A7A
(ucs-set-char #x5C62 ?$(GhX(B) ; C01-G-6858
(ucs-set-char #x5C62 ?$@<H(B) ; J78-@-3C48
(ucs-set-char #x5C63 ?$(D:{(B) ; J90-D-3A7B
(ucs-set-char #x5C63 ?$(HIg(B) ; C02-H-4967
(ucs-set-char #x5C63 ?$Aeo(B) ; GB0-A-656F
(ucs-set-char #x5C64 ?$(Cv5(B) ; KS0-C-7635
(ucs-set-char #x5C64 ?$(GlR(B) ; C01-G-6C52
(ucs-set-char #x5C64 ?$@AX(B) ; J78-@-4158
(ucs-set-char #x5C64 ?$BAX(B) ; J83-B-4158
(ucs-set-char #x5C65 ?$(CW[(B) ; KS0-C-575B
(ucs-set-char #x5C65 ?$(GlS(B) ; C01-G-6C53
(ucs-set-char #x5C65 ?$@Mz(B) ; J78-@-4D7A
(ucs-set-char #x5C65 ?$ABD(B) ; GB0-A-4244
(ucs-set-char #x5C65 ?$BMz(B) ; J83-B-4D7A
(ucs-set-char #x5C66 ?$Aep(B) ; GB0-A-6570
(ucs-set-char #x5C67 ?$(D:|(B) ; J90-D-3A7C
(ucs-set-char #x5C67 ?$(HP*(B) ; C02-H-502A
(ucs-set-char #x5C68 ?$(D:}(B) ; J90-D-3A7D
(ucs-set-char #x5C68 ?$(GsT(B) ; C01-G-7354
(ucs-set-char #x5C69 ?$(D:~(B) ; J90-D-3A7E
(ucs-set-char #x5C69 ?$(HaN(B) ; C02-H-614E
(ucs-set-char #x5C6A ?$(HaO(B) ; C02-H-614F
(ucs-set-char #x5C6B ?$(IZ8(B) ; C03-I-5A38
(ucs-set-char #x5C6C ?$(CaU(B) ; KS0-C-6155
(ucs-set-char #x5C6C ?$(Gzh(B) ; C01-G-7A68
(ucs-set-char #x5C6C ?$@V$(B) ; J78-@-5624
(ucs-set-char #x5C6C ?$BV$(B) ; J83-B-5624
(ucs-set-char #x5C6D ?$(D;!(B) ; J90-D-3B21
(ucs-set-char #x5C6D ?$(Hp6(B) ; C02-H-7036

(ucs-set-char #x5C6E ?$Aex(B) ; GB0-A-6578
(ucs-set-char #x5C6E ?$(H!+(B) ; C02-H-212B
(ucs-set-char #x5C6E ?$(J!5(B) ; C04-J-2135
(ucs-set-char #x5C6E ?$@V%(B) ; J78-@-5625
(ucs-set-char #x5C6E ?$BV%(B) ; J83-B-5625

(ucs-set-char #x5C6F ?$(CTj(B) ; KS0-C-546A
(ucs-set-char #x5C6F ?$(GE:(B) ; C01-G-453A
(ucs-set-char #x5C6F ?$@FV(B) ; J78-@-4656
(ucs-set-char #x5C6F ?$AMM(B) ; GB0-A-4D4D
(ucs-set-char #x5C6F ?$BFV(B) ; J83-B-4656
(ucs-set-char #x5C70 ?$(D;"(B) ; J90-D-3B22
(ucs-set-char #x5C70 ?$(J"_(B) ; C04-J-225F

(ucs-set-char #x5C71 ?$AI=(B) ; GB0-A-493D
(ucs-set-char #x5C71 ?$(C_#(B) ; KS0-C-5F23
(ucs-set-char #x5C71 ?$(GDT(B) ; C01-G-4454
(ucs-set-char #x5C71 ?$@;3(B) ; J78-@-3B33
(ucs-set-char #x5C71 ?$B;3(B) ; J83-B-3B33

(ucs-set-char #x5C73 ?$(H!X(B) ; C02-H-2158
(ucs-set-char #x5C74 ?$(D;#(B) ; J90-D-3B23
(ucs-set-char #x5C74 ?$(H!W(B) ; C02-H-2157
(ucs-set-char #x5C75 ?$(D;$(B) ; J90-D-3B24
(ucs-set-char #x5C75 ?$(J!v(B) ; C04-J-2176
(ucs-set-char #x5C76 ?$@V'(B) ; J78-@-5627
(ucs-set-char #x5C76 ?$BV'(B) ; J83-B-5627
(ucs-set-char #x5C78 ?$(I#U(B) ; C03-I-2355
(ucs-set-char #x5C79 ?$(C}_(B) ; KS0-C-7D5F
(ucs-set-char #x5C79 ?$(GG{(B) ; C01-G-477B
(ucs-set-char #x5C79 ?$@V((B) ; J78-@-5628
(ucs-set-char #x5C79 ?$ARY(B) ; GB0-A-5259
(ucs-set-char #x5C79 ?$BV((B) ; J83-B-5628
(ucs-set-char #x5C7A ?$(D;%(B) ; J90-D-3B25
(ucs-set-char #x5C7A ?$(H"7(B) ; C02-H-2237
(ucs-set-char #x5C7A ?$Aa((B) ; GB0-A-6128
(ucs-set-char #x5C7B ?$(D;&(B) ; J90-D-3B26
(ucs-set-char #x5C7B ?$(H"8(B) ; C02-H-2238
(ucs-set-char #x5C7C ?$(D;'(B) ; J90-D-3B27
(ucs-set-char #x5C7C ?$(H"6(B) ; C02-H-2236
(ucs-set-char #x5C7D ?$(D;((B) ; J90-D-3B28
(ucs-set-char #x5C7D ?$(J"`(B) ; C04-J-2260
(ucs-set-char #x5C7E ?$(H"9(B) ; C02-H-2239
(ucs-set-char #x5C7F ?$ASl(B) ; GB0-A-536C
(ucs-set-char #x5C80 ?$(I#Z(B) ; C03-I-235A
(ucs-set-char #x5C81 ?$AKj(B) ; GB0-A-4B6A
(ucs-set-char #x5C82 ?$AFq(B) ; GB0-A-4671
(ucs-set-char #x5C84 ?$(I%a(B) ; C03-I-2561
(ucs-set-char #x5C85 ?$(I%f(B) ; C03-I-2566
(ucs-set-char #x5C86 ?$(H#g(B) ; C02-H-2367
(ucs-set-char #x5C87 ?$(D;)(B) ; J90-D-3B29
(ucs-set-char #x5C87 ?$(J#z(B) ; C04-J-237A
(ucs-set-char #x5C88 ?$(D;*(B) ; J90-D-3B2A
(ucs-set-char #x5C88 ?$(H#b(B) ; C02-H-2362
(ucs-set-char #x5C88 ?$Aa,(B) ; GB0-A-612C
(ucs-set-char #x5C89 ?$(H#d(B) ; C02-H-2364
(ucs-set-char #x5C8A ?$(D;+(B) ; J90-D-3B2B
(ucs-set-char #x5C8A ?$(H#f(B) ; C02-H-2366
(ucs-set-char #x5C8B ?$(H#c(B) ; C02-H-2363
(ucs-set-char #x5C8C ?$(GJ&(B) ; C01-G-4A26
(ucs-set-char #x5C8C ?$@V)(B) ; J78-@-5629
(ucs-set-char #x5C8C ?$Aa'(B) ; GB0-A-6127
(ucs-set-char #x5C8C ?$BV)(B) ; J83-B-5629
(ucs-set-char #x5C8D ?$(H#`(B) ; C02-H-2360
(ucs-set-char #x5C8D ?$(I,@(B) ; C03-I-2C40
(ucs-set-char #x5C8D ?$Aa)(B) ; GB0-A-6129
(ucs-set-char #x5C8E ?$(I%b(B) ; C03-I-2562
(ucs-set-char #x5C8F ?$(D;,(B) ; J90-D-3B2C
(ucs-set-char #x5C8F ?$(H#a(B) ; C02-H-2361
(ucs-set-char #x5C90 ?$(CPw(B) ; KS0-C-5077
(ucs-set-char #x5C90 ?$(GJ#(B) ; C01-G-4A23
(ucs-set-char #x5C90 ?$@4t(B) ; J78-@-3474
(ucs-set-char #x5C90 ?$Aa*(B) ; GB0-A-612A
(ucs-set-char #x5C90 ?$B4t(B) ; J83-B-3474
(ucs-set-char #x5C91 ?$(CmT(B) ; KS0-C-6D54
(ucs-set-char #x5C91 ?$(GJ$(B) ; C01-G-4A24
(ucs-set-char #x5C91 ?$@V*(B) ; J78-@-562A
(ucs-set-char #x5C91 ?$Aa/(B) ; GB0-A-612F
(ucs-set-char #x5C91 ?$BV*(B) ; J83-B-562A
(ucs-set-char #x5C92 ?$(D;-(B) ; J90-D-3B2D
(ucs-set-char #x5C92 ?$(H#e(B) ; C02-H-2365
(ucs-set-char #x5C93 ?$(H#h(B) ; C02-H-2368
(ucs-set-char #x5C94 ?$(GJ%(B) ; C01-G-4A25
(ucs-set-char #x5C94 ?$@V+(B) ; J78-@-562B
(ucs-set-char #x5C94 ?$A2m(B) ; GB0-A-326D
(ucs-set-char #x5C94 ?$BV+(B) ; J83-B-562B
(ucs-set-char #x5C95 ?$(H#i(B) ; C02-H-2369
(ucs-set-char #x5C96 ?$Aa+(B) ; GB0-A-612B
(ucs-set-char #x5C97 ?$A8Z(B) ; GB0-A-385A
(ucs-set-char #x5C98 ?$Aa-(B) ; GB0-A-612D
(ucs-set-char #x5C99 ?$Aa.(B) ; GB0-A-612E
(ucs-set-char #x5C9A ?$Aa0(B) ; GB0-A-6130
(ucs-set-char #x5C9B ?$A5:(B) ; GB0-A-353A
(ucs-set-char #x5C9C ?$(I%c(B) ; C03-I-2563
(ucs-set-char #x5C9C ?$Aa1(B) ; GB0-A-6131
(ucs-set-char #x5C9D ?$(D;.(B) ; J90-D-3B2E
(ucs-set-char #x5C9D ?$(H&I(B) ; C02-H-2649
(ucs-set-char #x5C9E ?$(I(](B) ; C03-I-285D
(ucs-set-char #x5C9F ?$(D;/(B) ; J90-D-3B2F
(ucs-set-char #x5C9F ?$(H&C(B) ; C02-H-2643
(ucs-set-char #x5CA0 ?$(D;0(B) ; J90-D-3B30
(ucs-set-char #x5CA0 ?$(H&>(B) ; C02-H-263E
(ucs-set-char #x5CA1 ?$(CK*(B) ; KS0-C-4B2A
(ucs-set-char #x5CA1 ?$(GM%(B) ; C01-G-4D25
(ucs-set-char #x5CA1 ?$@2,(B) ; J78-@-322C
(ucs-set-char #x5CA1 ?$B2,(B) ; J83-B-322C
(ucs-set-char #x5CA2 ?$(D;1(B) ; J90-D-3B31
(ucs-set-char #x5CA2 ?$(H&F(B) ; C02-H-2646
(ucs-set-char #x5CA2 ?$Aa3(B) ; GB0-A-6133
(ucs-set-char #x5CA3 ?$(D;2(B) ; J90-D-3B32
(ucs-set-char #x5CA3 ?$(H&D(B) ; C02-H-2644
(ucs-set-char #x5CA3 ?$Aa8(B) ; GB0-A-6138
(ucs-set-char #x5CA4 ?$(H&=(B) ; C02-H-263D
(ucs-set-char #x5CA5 ?$(H&J(B) ; C02-H-264A
(ucs-set-char #x5CA6 ?$(D;3(B) ; J90-D-3B33
(ucs-set-char #x5CA6 ?$(H&M(B) ; C02-H-264D
(ucs-set-char #x5CA7 ?$(H&H(B) ; C02-H-2648
(ucs-set-char #x5CA8 ?$(H&A(B) ; C02-H-2641
(ucs-set-char #x5CA8 ?$@A;(B) ; J78-@-413B
(ucs-set-char #x5CA8 ?$BA;(B) ; J83-B-413B
(ucs-set-char #x5CA9 ?$(Cd[(B) ; KS0-C-645B
(ucs-set-char #x5CA9 ?$(GM'(B) ; C01-G-4D27
(ucs-set-char #x5CA9 ?$@4d(B) ; J78-@-3464
(ucs-set-char #x5CA9 ?$AQR(B) ; GB0-A-5152
(ucs-set-char #x5CA9 ?$B4d(B) ; J83-B-3464
(ucs-set-char #x5CAA ?$(D;4(B) ; J90-D-3B34
(ucs-set-char #x5CAA ?$(H&G(B) ; C02-H-2647
(ucs-set-char #x5CAB ?$(Ca{(B) ; KS0-C-617B
(ucs-set-char #x5CAB ?$(GM((B) ; C01-G-4D28
(ucs-set-char #x5CAB ?$@V-(B) ; J78-@-562D
(ucs-set-char #x5CAB ?$Aa6(B) ; GB0-A-6136
(ucs-set-char #x5CAB ?$BV-(B) ; J83-B-562D
(ucs-set-char #x5CAC ?$(CK"(B) ; KS0-C-4B22
(ucs-set-char #x5CAC ?$(H&B(B) ; C02-H-2642
(ucs-set-char #x5CAC ?$@L((B) ; J78-@-4C28
(ucs-set-char #x5CAC ?$Aa5(B) ; GB0-A-6135
(ucs-set-char #x5CAC ?$BL((B) ; J83-B-4C28
(ucs-set-char #x5CAD ?$(H&E(B) ; C02-H-2645
(ucs-set-char #x5CAD ?$AAk(B) ; GB0-A-416B
(ucs-set-char #x5CAE ?$(H&<(B) ; C02-H-263C
(ucs-set-char #x5CAF ?$(H&@(B) ; C02-H-2640
(ucs-set-char #x5CB0 ?$(H&L(B) ; C02-H-264C
(ucs-set-char #x5CB1 ?$(CS`(B) ; KS0-C-5360
(ucs-set-char #x5CB1 ?$(GM)(B) ; C01-G-4D29
(ucs-set-char #x5CB1 ?$@BR(B) ; J78-@-4252
(ucs-set-char #x5CB1 ?$Aa7(B) ; GB0-A-6137
(ucs-set-char #x5CB1 ?$BBR(B) ; J83-B-4252
(ucs-set-char #x5CB2 ?$(D;5(B) ; J90-D-3B35
(ucs-set-char #x5CB2 ?$(J&/(B) ; C04-J-262F
(ucs-set-char #x5CB3 ?$(Cd?(B) ; KS0-C-643F
(ucs-set-char #x5CB3 ?$(GM*(B) ; C01-G-4D2A
(ucs-set-char #x5CB3 ?$@3Y(B) ; J78-@-3359
(ucs-set-char #x5CB3 ?$AT@(B) ; GB0-A-5440
(ucs-set-char #x5CB3 ?$B3Y(B) ; J83-B-3359
(ucs-set-char #x5CB4 ?$(D;6(B) ; J90-D-3B36
(ucs-set-char #x5CB4 ?$(I(^(B) ; C03-I-285E
(ucs-set-char #x5CB5 ?$(C{@(B) ; KS0-C-7B40
(ucs-set-char #x5CB5 ?$(D;7(B) ; J90-D-3B37
(ucs-set-char #x5CB5 ?$(H&?(B) ; C02-H-263F
(ucs-set-char #x5CB5 ?$Aa2(B) ; GB0-A-6132
(ucs-set-char #x5CB6 ?$(H&K(B) ; C02-H-264B
(ucs-set-char #x5CB6 ?$@V/(B) ; J78-@-562F
(ucs-set-char #x5CB6 ?$BV/(B) ; J83-B-562F
(ucs-set-char #x5CB7 ?$(CZ>(B) ; KS0-C-5A3E
(ucs-set-char #x5CB7 ?$(GM$(B) ; C01-G-4D24
(ucs-set-char #x5CB7 ?$@V1(B) ; J78-@-5631
(ucs-set-char #x5CB7 ?$Aa:(B) ; GB0-A-613A
(ucs-set-char #x5CB7 ?$BV1(B) ; J83-B-5631
(ucs-set-char #x5CB8 ?$(CdM(B) ; KS0-C-644D
(ucs-set-char #x5CB8 ?$(GM&(B) ; C01-G-4D26
(ucs-set-char #x5CB8 ?$@4_(B) ; J78-@-345F
(ucs-set-char #x5CB8 ?$A06(B) ; GB0-A-3036
(ucs-set-char #x5CB8 ?$B4_(B) ; J83-B-345F
(ucs-set-char #x5CB9 ?$(I(\(B) ; C03-I-285C
(ucs-set-char #x5CBA ?$(CV9(B) ; KS0-C-5639
(ucs-set-char #x5CBA ?$(D;8(B) ; J90-D-3B38
(ucs-set-char #x5CBA ?$(I(_(B) ; C03-I-285F
(ucs-set-char #x5CBB ?$(I(W(B) ; C03-I-2857
(ucs-set-char #x5CBB ?$@V.(B) ; J78-@-562E
(ucs-set-char #x5CBB ?$BV.(B) ; J83-B-562E
(ucs-set-char #x5CBC ?$@V0(B) ; J78-@-5630
(ucs-set-char #x5CBC ?$BV0(B) ; J83-B-5630
(ucs-set-char #x5CBD ?$Aa4(B) ; GB0-A-6134
(ucs-set-char #x5CBE ?$(Co@(B) ; KS0-C-6F40
(ucs-set-char #x5CBE ?$@V3(B) ; J78-@-5633
(ucs-set-char #x5CBE ?$BV3(B) ; J83-B-5633
(ucs-set-char #x5CBF ?$A?y(B) ; GB0-A-3F79
(ucs-set-char #x5CC0 ?$(Ca|(B) ; KS0-C-617C
(ucs-set-char #x5CC0 ?$(J&4(B) ; C04-J-2634
(ucs-set-char #x5CC1 ?$(I(X(B) ; C03-I-2858
(ucs-set-char #x5CC1 ?$Aa9(B) ; GB0-A-6139
(ucs-set-char #x5CC4 ?$Aa;(B) ; GB0-A-613B
(ucs-set-char #x5CC5 ?$@V2(B) ; J78-@-5632
(ucs-set-char #x5CC5 ?$BV2(B) ; J83-B-5632
(ucs-set-char #x5CC6 ?$(H*,(B) ; C02-H-2A2C
(ucs-set-char #x5CC7 ?$(H*%(B) ; C02-H-2A25
(ucs-set-char #x5CC7 ?$@V4(B) ; J78-@-5634
(ucs-set-char #x5CC7 ?$BV4(B) ; J83-B-5634
(ucs-set-char #x5CC8 ?$(H*+(B) ; C02-H-2A2B
(ucs-set-char #x5CC9 ?$(D;9(B) ; J90-D-3B39
(ucs-set-char #x5CC9 ?$(H*$(B) ; C02-H-2A24
(ucs-set-char #x5CCA ?$(H*&(B) ; C02-H-2A26
(ucs-set-char #x5CCB ?$(D;:(B) ; J90-D-3B3A
(ucs-set-char #x5CCB ?$(H)~(B) ; C02-H-297E
(ucs-set-char #x5CCB ?$Aa>(B) ; GB0-A-613E
(ucs-set-char #x5CCC ?$(H)|(B) ; C02-H-297C
(ucs-set-char #x5CCD ?$(I,?(B) ; C03-I-2C3F
(ucs-set-char #x5CCE ?$(H*-(B) ; C02-H-2A2D
(ucs-set-char #x5CCF ?$(H**(B) ; C02-H-2A2A
(ucs-set-char #x5CD0 ?$(H)z(B) ; C02-H-297A
(ucs-set-char #x5CD1 ?$(I,;(B) ; C03-I-2C3B
(ucs-set-char #x5CD2 ?$(D;;(B) ; J90-D-3B3B
(ucs-set-char #x5CD2 ?$(GPr(B) ; C01-G-5072
(ucs-set-char #x5CD2 ?$Aa<(B) ; GB0-A-613C
(ucs-set-char #x5CD3 ?$(H*((B) ; C02-H-2A28
(ucs-set-char #x5CD4 ?$(H*)(B) ; C02-H-2A29
(ucs-set-char #x5CD5 ?$(J(}(B) ; C04-J-287D
(ucs-set-char #x5CD6 ?$(H*'(B) ; C02-H-2A27
(ucs-set-char #x5CD7 ?$(D;=(B) ; J90-D-3B3D
(ucs-set-char #x5CD7 ?$(H)}(B) ; C02-H-297D
(ucs-set-char #x5CD8 ?$(H){(B) ; C02-H-297B
(ucs-set-char #x5CD9 ?$(Cv9(B) ; KS0-C-7639
(ucs-set-char #x5CD9 ?$(GPq(B) ; C01-G-5071
(ucs-set-char #x5CD9 ?$@V5(B) ; J78-@-5635
(ucs-set-char #x5CD9 ?$AVE(B) ; GB0-A-5645
(ucs-set-char #x5CD9 ?$BV5(B) ; J83-B-5635
(ucs-set-char #x5CDA ?$(H*#(B) ; C02-H-2A23
(ucs-set-char #x5CDB ?$(H*!(B) ; C02-H-2A21
(ucs-set-char #x5CDC ?$(I,<(B) ; C03-I-2C3C
(ucs-set-char #x5CDD ?$(D;<(B) ; J90-D-3B3C
(ucs-set-char #x5CDD ?$(I,B(B) ; C03-I-2C42
(ucs-set-char #x5CDE ?$(H*"(B) ; C02-H-2A22
(ucs-set-char #x5CDF ?$(H*.(B) ; C02-H-2A2E
(ucs-set-char #x5CE0 ?$(C_G(B) ; KS0-C-5F47
(ucs-set-char #x5CE0 ?$@F=(B) ; J78-@-463D
(ucs-set-char #x5CE0 ?$BF=(B) ; J83-B-463D
(ucs-set-char #x5CE1 ?$(I,>(B) ; C03-I-2C3E
(ucs-set-char #x5CE1 ?$@6.(B) ; J78-@-362E
(ucs-set-char #x5CE1 ?$AO?(B) ; GB0-A-4F3F
(ucs-set-char #x5CE1 ?$B6.(B) ; J83-B-362E
(ucs-set-char #x5CE2 ?$(I,A(B) ; C03-I-2C41
(ucs-set-char #x5CE4 ?$Aa=(B) ; GB0-A-613D
(ucs-set-char #x5CE5 ?$(I,C(B) ; C03-I-2C43
(ucs-set-char #x5CE5 ?$Aa?(B) ; GB0-A-613F
(ucs-set-char #x5CE6 ?$(I,=(B) ; C03-I-2C3D
(ucs-set-char #x5CE6 ?$ABM(B) ; GB0-A-424D
(ucs-set-char #x5CE8 ?$(Cd1(B) ; KS0-C-6431
(ucs-set-char #x5CE8 ?$(GU3(B) ; C01-G-5533
(ucs-set-char #x5CE8 ?$@2e(B) ; J78-@-3265
(ucs-set-char #x5CE8 ?$A6k(B) ; GB0-A-366B
(ucs-set-char #x5CE8 ?$B2e(B) ; J83-B-3265
(ucs-set-char #x5CE9 ?$(I0c(B) ; C03-I-3063
(ucs-set-char #x5CE9 ?$@V6(B) ; J78-@-5636
(ucs-set-char #x5CE9 ?$BV6(B) ; J83-B-5636
(ucs-set-char #x5CEA ?$(GU2(B) ; C01-G-5532
(ucs-set-char #x5CEA ?$@V;(B) ; J78-@-563B
(ucs-set-char #x5CEA ?$ASx(B) ; GB0-A-5378
(ucs-set-char #x5CEA ?$BV;(B) ; J83-B-563B
(ucs-set-char #x5CEB ?$(I0_(B) ; C03-I-305F
(ucs-set-char #x5CEC ?$(H.n(B) ; C02-H-2E6E
(ucs-set-char #x5CED ?$(GU/(B) ; C01-G-552F
(ucs-set-char #x5CED ?$@V9(B) ; J78-@-5639
(ucs-set-char #x5CED ?$AGM(B) ; GB0-A-474D
(ucs-set-char #x5CED ?$BV9(B) ; J83-B-5639
(ucs-set-char #x5CEE ?$(D;>(B) ; J90-D-3B3E
(ucs-set-char #x5CEE ?$(H.p(B) ; C02-H-2E70
(ucs-set-char #x5CEF ?$(C\g(B) ; KS0-C-5C67
(ucs-set-char #x5CEF ?$(I0d(B) ; C03-I-3064
(ucs-set-char #x5CEF ?$@Jw(B) ; J78-@-4A77
(ucs-set-char #x5CEF ?$BJw(B) ; J83-B-4A77
(ucs-set-char #x5CF0 ?$(C\h(B) ; KS0-C-5C68
(ucs-set-char #x5CF0 ?$(GU4(B) ; C01-G-5534
(ucs-set-char #x5CF0 ?$@Jv(B) ; J78-@-4A76
(ucs-set-char #x5CF0 ?$A7e(B) ; GB0-A-3765
(ucs-set-char #x5CF0 ?$BJv(B) ; J83-B-4A76
(ucs-set-char #x5CF1 ?$(D;?(B) ; J90-D-3B3F
(ucs-set-char #x5CF1 ?$(H.q(B) ; C02-H-2E71
(ucs-set-char #x5CF2 ?$(D;@(B) ; J90-D-3B40
(ucs-set-char #x5CF2 ?$(J,`(B) ; C04-J-2C60
(ucs-set-char #x5CF3 ?$(I0a(B) ; C03-I-3061
(ucs-set-char #x5CF4 ?$(CzV(B) ; KS0-C-7A56
(ucs-set-char #x5CF4 ?$(D;A(B) ; J90-D-3B41
(ucs-set-char #x5CF4 ?$(GU7(B) ; C01-G-5537
(ucs-set-char #x5CF5 ?$(I0b(B) ; C03-I-3062
(ucs-set-char #x5CF6 ?$(CSv(B) ; KS0-C-5376
(ucs-set-char #x5CF6 ?$(GU5(B) ; C01-G-5535
(ucs-set-char #x5CF6 ?$@Eg(B) ; J78-@-4567
(ucs-set-char #x5CF6 ?$BEg(B) ; J83-B-4567
(ucs-set-char #x5CF7 ?$(H.r(B) ; C02-H-2E72
(ucs-set-char #x5CF8 ?$(H*/(B) ; C02-H-2A2F
(ucs-set-char #x5CF9 ?$(H.t(B) ; C02-H-2E74
(ucs-set-char #x5CFA ?$(I0^(B) ; C03-I-305E
(ucs-set-char #x5CFA ?$@V8(B) ; J78-@-5638
(ucs-set-char #x5CFA ?$BV8(B) ; J83-B-5638
(ucs-set-char #x5CFB ?$(CqZ(B) ; KS0-C-715A
(ucs-set-char #x5CFB ?$(GU1(B) ; C01-G-5531
(ucs-set-char #x5CFB ?$@=T(B) ; J78-@-3D54
(ucs-set-char #x5CFB ?$A>~(B) ; GB0-A-3E7E
(ucs-set-char #x5CFB ?$B=T(B) ; J83-B-3D54
(ucs-set-char #x5CFC ?$(J,\(B) ; C04-J-2C5C
(ucs-set-char #x5CFD ?$(Czr(B) ; KS0-C-7A72
(ucs-set-char #x5CFD ?$(GU0(B) ; C01-G-5530
(ucs-set-char #x5CFD ?$@V7(B) ; J78-@-5637
(ucs-set-char #x5CFD ?$BV7(B) ; J83-B-5637
(ucs-set-char #x5CFE ?$(J,a(B) ; C04-J-2C61
(ucs-set-char #x5CFF ?$(H.o(B) ; C02-H-2E6F
(ucs-set-char #x5D00 ?$(H.s(B) ; C02-H-2E73
(ucs-set-char #x5D01 ?$(D;B(B) ; J90-D-3B42
(ucs-set-char #x5D01 ?$(GU6(B) ; C01-G-5536
(ucs-set-char #x5D02 ?$Aa@(B) ; GB0-A-6140
(ucs-set-char #x5D03 ?$AaA(B) ; GB0-A-6141
(ucs-set-char #x5D06 ?$(D;C(B) ; J90-D-3B43
(ucs-set-char #x5D06 ?$(GYw(B) ; C01-G-5977
(ucs-set-char #x5D06 ?$AaG(B) ; GB0-A-6147
(ucs-set-char #x5D07 ?$(Cb}(B) ; KS0-C-627D
(ucs-set-char #x5D07 ?$(GYv(B) ; C01-G-5976
(ucs-set-char #x5D07 ?$@?r(B) ; J78-@-3F72
(ucs-set-char #x5D07 ?$A3g(B) ; GB0-A-3367
(ucs-set-char #x5D07 ?$B?r(B) ; J83-B-3F72
(ucs-set-char #x5D08 ?$(I5K(B) ; C03-I-354B
(ucs-set-char #x5D09 ?$(I5H(B) ; C03-I-3548
(ucs-set-char #x5D0A ?$(I5G(B) ; C03-I-3547
(ucs-set-char #x5D0B ?$(H4x(B) ; C02-H-3478
(ucs-set-char #x5D0B ?$@V<(B) ; J78-@-563C
(ucs-set-char #x5D0B ?$BV<(B) ; J83-B-563C
(ucs-set-char #x5D0C ?$(H4|(B) ; C02-H-347C
(ucs-set-char #x5D0D ?$(CUO(B) ; KS0-C-554F
(ucs-set-char #x5D0D ?$(D;D(B) ; J90-D-3B44
(ucs-set-char #x5D0D ?$(H4~(B) ; C02-H-347E
(ucs-set-char #x5D0E ?$(CPx(B) ; KS0-C-5078
(ucs-set-char #x5D0E ?$(GYx(B) ; C01-G-5978
(ucs-set-char #x5D0E ?$@:j(B) ; J78-@-3A6A
(ucs-set-char #x5D0E ?$AFi(B) ; GB0-A-4669
(ucs-set-char #x5D0E ?$B:j(B) ; J83-B-3A6A
(ucs-set-char #x5D0F ?$(H5#(B) ; C02-H-3523
(ucs-set-char #x5D10 ?$(I5Q(B) ; C03-I-3551
(ucs-set-char #x5D11 ?$(CM_(B) ; KS0-C-4D5F
(ucs-set-char #x5D11 ?$(GY|(B) ; C01-G-597C
(ucs-set-char #x5D11 ?$@VB(B) ; J78-@-5642
(ucs-set-char #x5D11 ?$BVB(B) ; J83-B-5642
(ucs-set-char #x5D12 ?$(D;E(B) ; J90-D-3B45
(ucs-set-char #x5D12 ?$(H5%(B) ; C02-H-3525
(ucs-set-char #x5D13 ?$(I5R(B) ; C03-I-3552
(ucs-set-char #x5D14 ?$(CuK(B) ; KS0-C-754B
(ucs-set-char #x5D14 ?$(GY~(B) ; C01-G-597E
(ucs-set-char #x5D14 ?$@VC(B) ; J78-@-5643
(ucs-set-char #x5D14 ?$A4^(B) ; GB0-A-345E
(ucs-set-char #x5D14 ?$BVC(B) ; J83-B-5643
(ucs-set-char #x5D15 ?$(I5O(B) ; C03-I-354F
(ucs-set-char #x5D15 ?$@V=(B) ; J78-@-563D
(ucs-set-char #x5D15 ?$BV=(B) ; J83-B-563D
(ucs-set-char #x5D16 ?$(Cdp(B) ; KS0-C-6470
(ucs-set-char #x5D16 ?$(GYz(B) ; C01-G-597A
(ucs-set-char #x5D16 ?$@33(B) ; J78-@-3333
(ucs-set-char #x5D16 ?$AQB(B) ; GB0-A-5142
(ucs-set-char #x5D16 ?$B33(B) ; J83-B-3333
(ucs-set-char #x5D17 ?$(CK+(B) ; KS0-C-4B2B
(ucs-set-char #x5D17 ?$(GZ$(B) ; C01-G-5A24
(ucs-set-char #x5D17 ?$@V>(B) ; J78-@-563E
(ucs-set-char #x5D17 ?$BV>(B) ; J83-B-563E
(ucs-set-char #x5D18 ?$(I5U(B) ; C03-I-3555
(ucs-set-char #x5D18 ?$@VG(B) ; J78-@-5647
(ucs-set-char #x5D18 ?$BVG(B) ; J83-B-5647
(ucs-set-char #x5D19 ?$(CWD(B) ; KS0-C-5744
(ucs-set-char #x5D19 ?$(GZ!(B) ; C01-G-5A21
(ucs-set-char #x5D19 ?$@VF(B) ; J78-@-5646
(ucs-set-char #x5D19 ?$BVF(B) ; J83-B-5646
(ucs-set-char #x5D1A ?$(H4z(B) ; C02-H-347A
(ucs-set-char #x5D1A ?$@VE(B) ; J78-@-5645
(ucs-set-char #x5D1A ?$BVE(B) ; J83-B-5645
(ucs-set-char #x5D1B ?$(GYy(B) ; C01-G-5979
(ucs-set-char #x5D1B ?$@VA(B) ; J78-@-5641
(ucs-set-char #x5D1B ?$AaH(B) ; GB0-A-6148
(ucs-set-char #x5D1B ?$BVA(B) ; J83-B-5641
(ucs-set-char #x5D1C ?$(I;+(B) ; C03-I-3B2B
(ucs-set-char #x5D1D ?$(H4y(B) ; C02-H-3479
(ucs-set-char #x5D1E ?$(H4w(B) ; C02-H-3477
(ucs-set-char #x5D1E ?$AaF(B) ; GB0-A-6146
(ucs-set-char #x5D1F ?$(H5'(B) ; C02-H-3527
(ucs-set-char #x5D1F ?$@V@(B) ; J78-@-5640
(ucs-set-char #x5D1F ?$BV@(B) ; J83-B-5640
(ucs-set-char #x5D20 ?$(H4{(B) ; C02-H-347B
(ucs-set-char #x5D21 ?$(I5F(B) ; C03-I-3546
(ucs-set-char #x5D22 ?$(GY{(B) ; C01-G-597B
(ucs-set-char #x5D22 ?$@VD(B) ; J78-@-5644
(ucs-set-char #x5D22 ?$BVD(B) ; J83-B-5644
(ucs-set-char #x5D23 ?$(D;G(B) ; J90-D-3B47
(ucs-set-char #x5D23 ?$(H5&(B) ; C02-H-3526
(ucs-set-char #x5D24 ?$(D;H(B) ; J90-D-3B48
(ucs-set-char #x5D24 ?$(GZ"(B) ; C01-G-5A22
(ucs-set-char #x5D24 ?$AaE(B) ; GB0-A-6145
(ucs-set-char #x5D25 ?$(H5"(B) ; C02-H-3522
(ucs-set-char #x5D26 ?$(D;I(B) ; J90-D-3B49
(ucs-set-char #x5D26 ?$(H5!(B) ; C02-H-3521
(ucs-set-char #x5D26 ?$AaC(B) ; GB0-A-6143
(ucs-set-char #x5D27 ?$(Cb~(B) ; KS0-C-627E
(ucs-set-char #x5D27 ?$(D;J(B) ; J90-D-3B4A
(ucs-set-char #x5D27 ?$(GZ#(B) ; C01-G-5A23
(ucs-set-char #x5D27 ?$AaB(B) ; GB0-A-6142
(ucs-set-char #x5D28 ?$(H4}(B) ; C02-H-347D
(ucs-set-char #x5D29 ?$(C]Z(B) ; KS0-C-5D5A
(ucs-set-char #x5D29 ?$(GY}(B) ; C01-G-597D
(ucs-set-char #x5D29 ?$@Jx(B) ; J78-@-4A78
(ucs-set-char #x5D29 ?$A1@(B) ; GB0-A-3140
(ucs-set-char #x5D29 ?$BJx(B) ; J83-B-4A78
(ucs-set-char #x5D2A ?$(I5N(B) ; C03-I-354E
(ucs-set-char #x5D2B ?$(D;F(B) ; J90-D-3B46
(ucs-set-char #x5D2B ?$(L>v(B) ; C06-L-3E76
(ucs-set-char #x5D2C ?$(I5J(B) ; C03-I-354A
(ucs-set-char #x5D2D ?$AU8(B) ; GB0-A-5538
(ucs-set-char #x5D2E ?$(H5((B) ; C02-H-3528
(ucs-set-char #x5D2E ?$AaD(B) ; GB0-A-6144
(ucs-set-char #x5D2F ?$(I5T(B) ; C03-I-3554
(ucs-set-char #x5D30 ?$(H5$(B) ; C02-H-3524
(ucs-set-char #x5D31 ?$(D;K(B) ; J90-D-3B4B
(ucs-set-char #x5D31 ?$(H;K(B) ; C02-H-3B4B
(ucs-set-char #x5D32 ?$(H;R(B) ; C02-H-3B52
(ucs-set-char #x5D33 ?$(H;G(B) ; C02-H-3B47
(ucs-set-char #x5D34 ?$(D;L(B) ; J90-D-3B4C
(ucs-set-char #x5D34 ?$(G^v(B) ; C01-G-5E76
(ucs-set-char #x5D34 ?$AaK(B) ; GB0-A-614B
(ucs-set-char #x5D35 ?$(H;C(B) ; C02-H-3B43
(ucs-set-char #x5D36 ?$(H;S(B) ; C02-H-3B53
(ucs-set-char #x5D37 ?$(H;=(B) ; C02-H-3B3D
(ucs-set-char #x5D38 ?$(H;P(B) ; C02-H-3B50
(ucs-set-char #x5D39 ?$(D;M(B) ; J90-D-3B4D
(ucs-set-char #x5D39 ?$(H;N(B) ; C02-H-3B4E
(ucs-set-char #x5D3A ?$(H;H(B) ; C02-H-3B48
(ucs-set-char #x5D3B ?$(I;6(B) ; C03-I-3B36
(ucs-set-char #x5D3C ?$(H;Q(B) ; C02-H-3B51
(ucs-set-char #x5D3D ?$(D;N(B) ; J90-D-3B4E
(ucs-set-char #x5D3D ?$(H;J(B) ; C02-H-3B4A
(ucs-set-char #x5D3D ?$AaL(B) ; GB0-A-614C
(ucs-set-char #x5D3E ?$(I;((B) ; C03-I-3B28
(ucs-set-char #x5D3E ?$AaJ(B) ; GB0-A-614A
(ucs-set-char #x5D3F ?$(D;O(B) ; J90-D-3B4F
(ucs-set-char #x5D3F ?$(H;B(B) ; C02-H-3B42
(ucs-set-char #x5D40 ?$(H;T(B) ; C02-H-3B54
(ucs-set-char #x5D41 ?$(H;@(B) ; C02-H-3B40
(ucs-set-char #x5D42 ?$(D;P(B) ; J90-D-3B50
(ucs-set-char #x5D42 ?$(H;M(B) ; C02-H-3B4D
(ucs-set-char #x5D43 ?$(D;Q(B) ; J90-D-3B51
(ucs-set-char #x5D43 ?$(H;>(B) ; C02-H-3B3E
(ucs-set-char #x5D43 ?$(LH+(B) ; C06-L-482B
(ucs-set-char #x5D44 ?$(I;'(B) ; C03-I-3B27
(ucs-set-char #x5D45 ?$(H;U(B) ; C02-H-3B55
(ucs-set-char #x5D46 ?$(D;R(B) ; J90-D-3B52
(ucs-set-char #x5D46 ?$(I;7(B) ; C03-I-3B37
(ucs-set-char #x5D47 ?$(G^w(B) ; C01-G-5E77
(ucs-set-char #x5D47 ?$Aoz(B) ; GB0-A-6F7A
(ucs-set-char #x5D48 ?$(D;S(B) ; J90-D-3B53
(ucs-set-char #x5D48 ?$(I;*(B) ; C03-I-3B2A
(ucs-set-char #x5D49 ?$(H;O(B) ; C02-H-3B4F
(ucs-set-char #x5D4A ?$(D;W(B) ; J90-D-3B57
(ucs-set-char #x5D4A ?$(HBU(B) ; C02-H-4255
(ucs-set-char #x5D4A ?$AaS(B) ; GB0-A-6153
(ucs-set-char #x5D4B ?$(CZ.(B) ; KS0-C-5A2E
(ucs-set-char #x5D4B ?$(H;A(B) ; C02-H-3B41
(ucs-set-char #x5D4B ?$@VK(B) ; J78-@-564B
(ucs-set-char #x5D4B ?$AaR(B) ; GB0-A-6152
(ucs-set-char #x5D4B ?$BVK(B) ; J83-B-564B
(ucs-set-char #x5D4C ?$(CJn(B) ; KS0-C-4A6E
(ucs-set-char #x5D4C ?$(G^t(B) ; C01-G-5E74
(ucs-set-char #x5D4C ?$@VH(B) ; J78-@-5648
(ucs-set-char #x5D4C ?$AG6(B) ; GB0-A-4736
(ucs-set-char #x5D4C ?$BVH(B) ; J83-B-5648
(ucs-set-char #x5D4D ?$(I;.(B) ; C03-I-3B2E
(ucs-set-char #x5D4E ?$(H;E(B) ; C02-H-3B45
(ucs-set-char #x5D4E ?$@VJ(B) ; J78-@-564A
(ucs-set-char #x5D4E ?$BVJ(B) ; J83-B-564A
(ucs-set-char #x5D4F ?$(I;4(B) ; C03-I-3B34
(ucs-set-char #x5D50 ?$(CU9(B) ; KS0-C-5539
(ucs-set-char #x5D50 ?$(G^u(B) ; C01-G-5E75
(ucs-set-char #x5D50 ?$@Mr(B) ; J78-@-4D72
(ucs-set-char #x5D50 ?$BMr(B) ; J83-B-4D72
(ucs-set-char #x5D51 ?$(D;U(B) ; J90-D-3B55
(ucs-set-char #x5D51 ?$(H;D(B) ; C02-H-3B44
(ucs-set-char #x5D52 ?$(H;I(B) ; C02-H-3B49
(ucs-set-char #x5D52 ?$@VI(B) ; J78-@-5649
(ucs-set-char #x5D52 ?$BVI(B) ; J83-B-5649
(ucs-set-char #x5D53 ?$(I;3(B) ; C03-I-3B33
(ucs-set-char #x5D54 ?$(J75(B) ; C04-J-3735
(ucs-set-char #x5D55 ?$(D;T(B) ; J90-D-3B54
(ucs-set-char #x5D55 ?$(H;F(B) ; C02-H-3B46
(ucs-set-char #x5D56 ?$(J7/(B) ; C04-J-372F
(ucs-set-char #x5D57 ?$(I;1(B) ; C03-I-3B31
(ucs-set-char #x5D58 ?$AaI(B) ; GB0-A-6149
(ucs-set-char #x5D59 ?$(D;V(B) ; J90-D-3B56
(ucs-set-char #x5D59 ?$(H;L(B) ; C02-H-3B4C
(ucs-set-char #x5D5B ?$(I;-(B) ; C03-I-3B2D
(ucs-set-char #x5D5B ?$AaN(B) ; GB0-A-614E
(ucs-set-char #x5D5C ?$@V?(B) ; J78-@-563F
(ucs-set-char #x5D5C ?$BV?(B) ; J83-B-563F
(ucs-set-char #x5D5D ?$AaP(B) ; GB0-A-6150
(ucs-set-char #x5D5E ?$(HBY(B) ; C02-H-4259
(ucs-set-char #x5D5F ?$(D;X(B) ; J90-D-3B58
(ucs-set-char #x5D5F ?$(J<y(B) ; C04-J-3C79
(ucs-set-char #x5D60 ?$(D;Y(B) ; J90-D-3B59
(ucs-set-char #x5D60 ?$(IA!(B) ; C03-I-4121
(ucs-set-char #x5D61 ?$(D;Z(B) ; J90-D-3B5A
(ucs-set-char #x5D61 ?$(J<{(B) ; C04-J-3C7B
(ucs-set-char #x5D62 ?$(D;[(B) ; J90-D-3B5B
(ucs-set-char #x5D62 ?$(HB\(B) ; C02-H-425C
(ucs-set-char #x5D63 ?$(HBT(B) ; C02-H-4254
(ucs-set-char #x5D64 ?$(D;\(B) ; J90-D-3B5C
(ucs-set-char #x5D64 ?$(I@|(B) ; C03-I-407C
(ucs-set-char #x5D65 ?$(HBV(B) ; C02-H-4256
(ucs-set-char #x5D66 ?$(I@z(B) ; C03-I-407A
(ucs-set-char #x5D67 ?$(HB[(B) ; C02-H-425B
(ucs-set-char #x5D68 ?$(HBZ(B) ; C02-H-425A
(ucs-set-char #x5D69 ?$(Cc!(B) ; KS0-C-6321
(ucs-set-char #x5D69 ?$(Gci(B) ; C01-G-6369
(ucs-set-char #x5D69 ?$@?s(B) ; J78-@-3F73
(ucs-set-char #x5D69 ?$AaT(B) ; GB0-A-6154
(ucs-set-char #x5D69 ?$B?s(B) ; J83-B-3F73
(ucs-set-char #x5D6A ?$(D;](B) ; J90-D-3B5D
(ucs-set-char #x5D6A ?$(J<u(B) ; C04-J-3C75
(ucs-set-char #x5D6B ?$(H;?(B) ; C02-H-3B3F
(ucs-set-char #x5D6B ?$AaQ(B) ; GB0-A-6151
(ucs-set-char #x5D6C ?$(Chc(B) ; KS0-C-6863
(ucs-set-char #x5D6C ?$(HBX(B) ; C02-H-4258
(ucs-set-char #x5D6C ?$@VL(B) ; J78-@-564C
(ucs-set-char #x5D6C ?$AaM(B) ; GB0-A-614D
(ucs-set-char #x5D6C ?$BVL(B) ; J83-B-564C
(ucs-set-char #x5D6D ?$(D;^(B) ; J90-D-3B5E
(ucs-set-char #x5D6D ?$(I@y(B) ; C03-I-4079
(ucs-set-char #x5D6E ?$(I@}(B) ; C03-I-407D
(ucs-set-char #x5D6F ?$(Cs+(B) ; KS0-C-732B
(ucs-set-char #x5D6F ?$(Gcj(B) ; C01-G-636A
(ucs-set-char #x5D6F ?$@:7(B) ; J78-@-3A37
(ucs-set-char #x5D6F ?$AaO(B) ; GB0-A-614F
(ucs-set-char #x5D6F ?$B:7(B) ; J83-B-3A37
(ucs-set-char #x5D70 ?$(D;_(B) ; J90-D-3B5F
(ucs-set-char #x5D70 ?$(J<t(B) ; C04-J-3C74
(ucs-set-char #x5D71 ?$(HBS(B) ; C02-H-4253
(ucs-set-char #x5D72 ?$(HBW(B) ; C02-H-4257
(ucs-set-char #x5D73 ?$(J<|(B) ; C04-J-3C7C
(ucs-set-char #x5D73 ?$@VM(B) ; J78-@-564D
(ucs-set-char #x5D73 ?$BVM(B) ; J83-B-564D
(ucs-set-char #x5D74 ?$(J<x(B) ; C04-J-3C78
(ucs-set-char #x5D74 ?$AaU(B) ; GB0-A-6155
(ucs-set-char #x5D76 ?$@VN(B) ; J78-@-564E
(ucs-set-char #x5D76 ?$BVN(B) ; J83-B-564E
(ucs-set-char #x5D77 ?$(HIn(B) ; C02-H-496E
(ucs-set-char #x5D78 ?$(IF\(B) ; C03-I-465C
(ucs-set-char #x5D79 ?$(D;`(B) ; J90-D-3B60
(ucs-set-char #x5D79 ?$(HIu(B) ; C02-H-4975
(ucs-set-char #x5D7A ?$(D;a(B) ; J90-D-3B61
(ucs-set-char #x5D7A ?$(HIl(B) ; C02-H-496C
(ucs-set-char #x5D7B ?$(IFT(B) ; C03-I-4654
(ucs-set-char #x5D7C ?$(HIs(B) ; C02-H-4973
(ucs-set-char #x5D7D ?$(HIj(B) ; C02-H-496A
(ucs-set-char #x5D7E ?$(D;b(B) ; J90-D-3B62
(ucs-set-char #x5D7E ?$(HIr(B) ; C02-H-4972
(ucs-set-char #x5D7F ?$(D;c(B) ; J90-D-3B63
(ucs-set-char #x5D7F ?$(HIv(B) ; C02-H-4976
(ucs-set-char #x5D80 ?$(HIi(B) ; C02-H-4969
(ucs-set-char #x5D81 ?$(D;d(B) ; J90-D-3B64
(ucs-set-char #x5D81 ?$(HIm(B) ; C02-H-496D
(ucs-set-char #x5D82 ?$(HIh(B) ; C02-H-4968
(ucs-set-char #x5D82 ?$@VQ(B) ; J78-@-5651
(ucs-set-char #x5D82 ?$AaV(B) ; GB0-A-6156
(ucs-set-char #x5D82 ?$BVQ(B) ; J83-B-5651
(ucs-set-char #x5D83 ?$(D;e(B) ; J90-D-3B65
(ucs-set-char #x5D83 ?$(IFV(B) ; C03-I-4656
(ucs-set-char #x5D84 ?$(GhY(B) ; C01-G-6859
(ucs-set-char #x5D84 ?$@VP(B) ; J78-@-5650
(ucs-set-char #x5D84 ?$BVP(B) ; J83-B-5650
(ucs-set-char #x5D85 ?$(JC,(B) ; C04-J-432C
(ucs-set-char #x5D86 ?$(HIk(B) ; C02-H-496B
(ucs-set-char #x5D87 ?$(CO)(B) ; KS0-C-4F29
(ucs-set-char #x5D87 ?$(GhZ(B) ; C01-G-685A
(ucs-set-char #x5D87 ?$@VO(B) ; J78-@-564F
(ucs-set-char #x5D87 ?$BVO(B) ; J83-B-564F
(ucs-set-char #x5D88 ?$(D;f(B) ; J90-D-3B66
(ucs-set-char #x5D88 ?$(HIq(B) ; C02-H-4971
(ucs-set-char #x5D89 ?$(HIp(B) ; C02-H-4970
(ucs-set-char #x5D8A ?$(D;g(B) ; J90-D-3B67
(ucs-set-char #x5D8A ?$(HIo(B) ; C02-H-496F
(ucs-set-char #x5D8B ?$(CSw(B) ; KS0-C-5377
(ucs-set-char #x5D8B ?$(IFY(B) ; C03-I-4659
(ucs-set-char #x5D8B ?$@Eh(B) ; J78-@-4568
(ucs-set-char #x5D8B ?$BEh(B) ; J83-B-4568
(ucs-set-char #x5D8C ?$(IFZ(B) ; C03-I-465A
(ucs-set-char #x5D8C ?$@V:(B) ; J78-@-563A
(ucs-set-char #x5D8C ?$BV:(B) ; J83-B-563A
(ucs-set-char #x5D8D ?$(HIt(B) ; C02-H-4974
(ucs-set-char #x5D8F ?$(IKe(B) ; C03-I-4B65
(ucs-set-char #x5D90 ?$(IKf(B) ; C03-I-4B66
(ucs-set-char #x5D90 ?$@VW(B) ; J78-@-5657
(ucs-set-char #x5D90 ?$BVW(B) ; J83-B-5657
(ucs-set-char #x5D91 ?$(IKc(B) ; C03-I-4B63
(ucs-set-char #x5D92 ?$(D;h(B) ; J90-D-3B68
(ucs-set-char #x5D92 ?$(HP.(B) ; C02-H-502E
(ucs-set-char #x5D93 ?$(D;i(B) ; J90-D-3B69
(ucs-set-char #x5D93 ?$(HP0(B) ; C02-H-5030
(ucs-set-char #x5D94 ?$(D;j(B) ; J90-D-3B6A
(ucs-set-char #x5D94 ?$(GlU(B) ; C01-G-6C55
(ucs-set-char #x5D95 ?$(D;k(B) ; J90-D-3B6B
(ucs-set-char #x5D95 ?$(HP1(B) ; C02-H-5031
(ucs-set-char #x5D96 ?$(IKk(B) ; C03-I-4B6B
(ucs-set-char #x5D97 ?$(HP,(B) ; C02-H-502C
(ucs-set-char #x5D98 ?$(IKg(B) ; C03-I-4B67
(ucs-set-char #x5D99 ?$(D;l(B) ; J90-D-3B6C
(ucs-set-char #x5D99 ?$(HP+(B) ; C02-H-502B
(ucs-set-char #x5D99 ?$AaW(B) ; GB0-A-6157
(ucs-set-char #x5D9A ?$(HP5(B) ; C02-H-5035
(ucs-set-char #x5D9B ?$(D;m(B) ; J90-D-3B6D
(ucs-set-char #x5D9B ?$(IKi(B) ; C03-I-4B69
(ucs-set-char #x5D9C ?$(HP3(B) ; C02-H-5033
(ucs-set-char #x5D9D ?$(CTq(B) ; KS0-C-5471
(ucs-set-char #x5D9D ?$(GlT(B) ; C01-G-6C54
(ucs-set-char #x5D9D ?$@VS(B) ; J78-@-5653
(ucs-set-char #x5D9D ?$AaX(B) ; GB0-A-6158
(ucs-set-char #x5D9D ?$BVS(B) ; J83-B-5653
(ucs-set-char #x5D9E ?$(HP6(B) ; C02-H-5036
(ucs-set-char #x5D9F ?$(D;n(B) ; J90-D-3B6E
(ucs-set-char #x5D9F ?$(HP-(B) ; C02-H-502D
(ucs-set-char #x5DA0 ?$(CNd(B) ; KS0-C-4E64
(ucs-set-char #x5DA0 ?$(D;o(B) ; J90-D-3B6F
(ucs-set-char #x5DA0 ?$(HP2(B) ; C02-H-5032
(ucs-set-char #x5DA1 ?$(HP4(B) ; C02-H-5034
(ucs-set-char #x5DA2 ?$(Chr(B) ; KS0-C-6872
(ucs-set-char #x5DA2 ?$(HP/(B) ; C02-H-502F
(ucs-set-char #x5DA2 ?$@VR(B) ; J78-@-5652
(ucs-set-char #x5DA2 ?$BVR(B) ; J83-B-5652
(ucs-set-char #x5DA3 ?$(IKj(B) ; C03-I-4B6A
(ucs-set-char #x5DA4 ?$(IKh(B) ; C03-I-4B68
(ucs-set-char #x5DA6 ?$(IPX(B) ; C03-I-5058
(ucs-set-char #x5DA7 ?$(D;p(B) ; J90-D-3B70
(ucs-set-char #x5DA7 ?$(HVk(B) ; C02-H-566B
(ucs-set-char #x5DA8 ?$(HVp(B) ; C02-H-5670
(ucs-set-char #x5DA9 ?$(HVj(B) ; C02-H-566A
(ucs-set-char #x5DAA ?$(Ceu(B) ; KS0-C-6575
(ucs-set-char #x5DAA ?$(HVo(B) ; C02-H-566F
(ucs-set-char #x5DAB ?$(D;q(B) ; J90-D-3B71
(ucs-set-char #x5DAB ?$(IP[(B) ; C03-I-505B
(ucs-set-char #x5DAC ?$(HVh(B) ; C02-H-5668
(ucs-set-char #x5DAC ?$@VT(B) ; J78-@-5654
(ucs-set-char #x5DAC ?$BVT(B) ; J83-B-5654
(ucs-set-char #x5DAD ?$(HVr(B) ; C02-H-5672
(ucs-set-char #x5DAE ?$(HVn(B) ; C02-H-566E
(ucs-set-char #x5DAE ?$@VU(B) ; J78-@-5655
(ucs-set-char #x5DAE ?$BVU(B) ; J83-B-5655
(ucs-set-char #x5DAF ?$(HVs(B) ; C02-H-5673
(ucs-set-char #x5DB0 ?$(D;r(B) ; J90-D-3B72
(ucs-set-char #x5DB0 ?$(HVm(B) ; C02-H-566D
(ucs-set-char #x5DB1 ?$(HVi(B) ; C02-H-5669
(ucs-set-char #x5DB2 ?$(Dft(B) ; J90-D-6674
(ucs-set-char #x5DB2 ?$(HVq(B) ; C02-H-5671
(ucs-set-char #x5DB3 ?$(IPZ(B) ; C03-I-505A
(ucs-set-char #x5DB4 ?$(D;s(B) ; J90-D-3B73
(ucs-set-char #x5DB4 ?$(HVt(B) ; C02-H-5674
(ucs-set-char #x5DB5 ?$(HVl(B) ; C02-H-566C
(ucs-set-char #x5DB7 ?$(H\f(B) ; C02-H-5C66
(ucs-set-char #x5DB7 ?$@VX(B) ; J78-@-5658
(ucs-set-char #x5DB7 ?$AaZ(B) ; GB0-A-615A
(ucs-set-char #x5DB7 ?$BVX(B) ; J83-B-5658
(ucs-set-char #x5DB8 ?$(Cg.(B) ; KS0-C-672E
(ucs-set-char #x5DB8 ?$(D;t(B) ; J90-D-3B74
(ucs-set-char #x5DB8 ?$(GsX(B) ; C01-G-7358
(ucs-set-char #x5DB9 ?$(D;u(B) ; J90-D-3B75
(ucs-set-char #x5DB9 ?$(ITW(B) ; C03-I-5457
(ucs-set-char #x5DBA ?$(CV:(B) ; KS0-C-563A
(ucs-set-char #x5DBA ?$(GsV(B) ; C01-G-7356
(ucs-set-char #x5DBA ?$@Nf(B) ; J78-@-4E66
(ucs-set-char #x5DBA ?$BNf(B) ; J83-B-4E66
(ucs-set-char #x5DBB ?$(ITY(B) ; C03-I-5459
(ucs-set-char #x5DBC ?$(C_l(B) ; KS0-C-5F6C
(ucs-set-char #x5DBC ?$(GsU(B) ; C01-G-7355
(ucs-set-char #x5DBC ?$@VY(B) ; J78-@-5659
(ucs-set-char #x5DBC ?$BVY(B) ; J83-B-5659
(ucs-set-char #x5DBD ?$(Cd@(B) ; KS0-C-6440
(ucs-set-char #x5DBD ?$(GsW(B) ; C01-G-7357
(ucs-set-char #x5DBD ?$@VV(B) ; J78-@-5656
(ucs-set-char #x5DBD ?$BVV(B) ; J83-B-5656
(ucs-set-char #x5DBE ?$(ITU(B) ; C03-I-5455
(ucs-set-char #x5DC0 ?$(HaP(B) ; C02-H-6150
(ucs-set-char #x5DC1 ?$(IWb(B) ; C03-I-5762
(ucs-set-char #x5DC2 ?$(Hd>(B) ; C02-H-643E
(ucs-set-char #x5DC3 ?$(D;v(B) ; J90-D-3B76
(ucs-set-char #x5DC3 ?$(HeI(B) ; C02-H-6549
(ucs-set-char #x5DC4 ?$(IZ9(B) ; C03-I-5A39
(ucs-set-char #x5DC5 ?$Aa[(B) ; GB0-A-615B
(ucs-set-char #x5DC6 ?$(Hhp(B) ; C02-H-6870
(ucs-set-char #x5DC7 ?$(D;w(B) ; J90-D-3B77
(ucs-set-char #x5DC7 ?$(Hhq(B) ; C02-H-6871
(ucs-set-char #x5DC8 ?$(I\=(B) ; C03-I-5C3D
(ucs-set-char #x5DC9 ?$(Gyk(B) ; C01-G-796B
(ucs-set-char #x5DC9 ?$@VZ(B) ; J78-@-565A
(ucs-set-char #x5DC9 ?$BVZ(B) ; J83-B-565A
(ucs-set-char #x5DCA ?$(I\<(B) ; C03-I-5C3C
(ucs-set-char #x5DCB ?$(D;x(B) ; J90-D-3B78
(ucs-set-char #x5DCB ?$(HkW(B) ; C02-H-6B57
(ucs-set-char #x5DCC ?$(I\>(B) ; C03-I-5C3E
(ucs-set-char #x5DCC ?$@4`(B) ; J78-@-3460
(ucs-set-char #x5DCC ?$B4`(B) ; J83-B-3460
(ucs-set-char #x5DCD ?$(Chd(B) ; KS0-C-6864
(ucs-set-char #x5DCD ?$(Gzi(B) ; C01-G-7A69
(ucs-set-char #x5DCD ?$@V[(B) ; J78-@-565B
(ucs-set-char #x5DCD ?$AN!(B) ; GB0-A-4E21
(ucs-set-char #x5DCD ?$BV[(B) ; J83-B-565B
(ucs-set-char #x5DCE ?$(D;z(B) ; J90-D-3B7A
(ucs-set-char #x5DCE ?$(Jf;(B) ; C04-J-663B
(ucs-set-char #x5DCF ?$(HkX(B) ; C02-H-6B58
(ucs-set-char #x5DD0 ?$(D;y(B) ; J90-D-3B79
(ucs-set-char #x5DD0 ?$(I^-(B) ; C03-I-5E2D
(ucs-set-char #x5DD1 ?$(HmL(B) ; C02-H-6D4C
(ucs-set-char #x5DD2 ?$(CX5(B) ; KS0-C-5835
(ucs-set-char #x5DD2 ?$(G{^(B) ; C01-G-7B5E
(ucs-set-char #x5DD2 ?$@V](B) ; J78-@-565D
(ucs-set-char #x5DD2 ?$BV](B) ; J83-B-565D
(ucs-set-char #x5DD3 ?$(I_C(B) ; C03-I-5F43
(ucs-set-char #x5DD3 ?$@V\(B) ; J78-@-565C
(ucs-set-char #x5DD3 ?$BV\(B) ; J83-B-565C
(ucs-set-char #x5DD4 ?$(G{](B) ; C01-G-7B5D
(ucs-set-char #x5DD5 ?$(HmK(B) ; C02-H-6D4B
(ucs-set-char #x5DD6 ?$(Cd\(B) ; KS0-C-645C
(ucs-set-char #x5DD6 ?$(G|5(B) ; C01-G-7C35
(ucs-set-char #x5DD6 ?$@V^(B) ; J78-@-565E
(ucs-set-char #x5DD6 ?$BV^(B) ; J83-B-565E
(ucs-set-char #x5DD7 ?$(I`0(B) ; C03-I-6030
(ucs-set-char #x5DD8 ?$(D;{(B) ; J90-D-3B7B
(ucs-set-char #x5DD8 ?$(Ho%(B) ; C02-H-6F25
(ucs-set-char #x5DD9 ?$(D;|(B) ; J90-D-3B7C
(ucs-set-char #x5DD9 ?$(Jkh(B) ; C04-J-6B68
(ucs-set-char #x5DDA ?$(JjF(B) ; C04-J-6A46

(ucs-set-char #x5DDB ?$Ag](B) ; GB0-A-675D
(ucs-set-char #x5DDB ?$(I!<(B) ; C03-I-213C
(ucs-set-char #x5DDB ?$@V_(B) ; J78-@-565F
(ucs-set-char #x5DDB ?$BV_(B) ; J83-B-565F

(ucs-set-char #x5DDC ?$(J!,(B) ; C04-J-212C

(ucs-set-char #x5DDD ?$(Ct9(B) ; KS0-C-7439
(ucs-set-char #x5DDD ?$(GDU(B) ; C01-G-4455
(ucs-set-char #x5DDD ?$@@n(B) ; J78-@-406E
(ucs-set-char #x5DDD ?$A4((B) ; GB0-A-3428
(ucs-set-char #x5DDD ?$B@n(B) ; J83-B-406E
(ucs-set-char #x5DDE ?$(Cq6(B) ; KS0-C-7136
(ucs-set-char #x5DDE ?$(GG|(B) ; C01-G-477C
(ucs-set-char #x5DDE ?$@=#(B) ; J78-@-3D23
(ucs-set-char #x5DDE ?$AV](B) ; GB0-A-565D
(ucs-set-char #x5DDE ?$B=#(B) ; J83-B-3D23
(ucs-set-char #x5DDF ?$(H":(B) ; C02-H-223A
(ucs-set-char #x5DE0 ?$(D;}(B) ; J90-D-3B7D
(ucs-set-char #x5DE0 ?$(H#j(B) ; C02-H-236A
(ucs-set-char #x5DE1 ?$(Cb^(B) ; KS0-C-625E
(ucs-set-char #x5DE1 ?$(GKV(B) ; C01-G-4B56
(ucs-set-char #x5DE1 ?$(L'6(B) ; C06-L-2736
(ucs-set-char #x5DE1 ?$@=d(B) ; J78-@-3D64
(ucs-set-char #x5DE1 ?$AQ2(B) ; GB0-A-5132
(ucs-set-char #x5DE1 ?$B=d(B) ; J83-B-3D64
(ucs-set-char #x5DE2 ?$(Ca5(B) ; KS0-C-6135
(ucs-set-char #x5DE2 ?$(GZ%(B) ; C01-G-5A25
(ucs-set-char #x5DE2 ?$A32(B) ; GB0-A-3332
(ucs-set-char #x5DE3 ?$(I5W(B) ; C03-I-3557
(ucs-set-char #x5DE3 ?$@Ac(B) ; J78-@-4163
(ucs-set-char #x5DE3 ?$BAc(B) ; J83-B-4163
(ucs-set-char #x5DE4 ?$(D;~(B) ; J90-D-3B7E
(ucs-set-char #x5DE4 ?$(IKl(B) ; C03-I-4B6C

(ucs-set-char #x5DE5 ?$A9$(B) ; GB0-A-3924
(ucs-set-char #x5DE5 ?$(CMo(B) ; KS0-C-4D6F
(ucs-set-char #x5DE5 ?$(GDV(B) ; C01-G-4456
(ucs-set-char #x5DE5 ?$@9)(B) ; J78-@-3929
(ucs-set-char #x5DE5 ?$B9)(B) ; J83-B-3929

(ucs-set-char #x5DE6 ?$(Cq'(B) ; KS0-C-7127
(ucs-set-char #x5DE6 ?$(GFJ(B) ; C01-G-464A
(ucs-set-char #x5DE6 ?$@:8(B) ; J78-@-3A38
(ucs-set-char #x5DE6 ?$AWs(B) ; GB0-A-5773
(ucs-set-char #x5DE6 ?$B:8(B) ; J83-B-3A38
(ucs-set-char #x5DE7 ?$(CNe(B) ; KS0-C-4E65
(ucs-set-char #x5DE7 ?$(GFI(B) ; C01-G-4649
(ucs-set-char #x5DE7 ?$@9*(B) ; J78-@-392A
(ucs-set-char #x5DE7 ?$AGI(B) ; GB0-A-4749
(ucs-set-char #x5DE7 ?$B9*(B) ; J83-B-392A
(ucs-set-char #x5DE8 ?$(CK](B) ; KS0-C-4B5D
(ucs-set-char #x5DE8 ?$(GFH(B) ; C01-G-4648
(ucs-set-char #x5DE8 ?$@5p(B) ; J78-@-3570
(ucs-set-char #x5DE8 ?$A>^(B) ; GB0-A-3E5E
(ucs-set-char #x5DE8 ?$B5p(B) ; J83-B-3570
(ucs-set-char #x5DE9 ?$(D<!(B) ; J90-D-3C21
(ucs-set-char #x5DE9 ?$(J"c(B) ; C04-J-2263
(ucs-set-char #x5DE9 ?$A9.(B) ; GB0-A-392E
(ucs-set-char #x5DEB ?$(CYc(B) ; KS0-C-5963
(ucs-set-char #x5DEB ?$(GJ'(B) ; C01-G-4A27
(ucs-set-char #x5DEB ?$@V`(B) ; J78-@-5660
(ucs-set-char #x5DEB ?$ANW(B) ; GB0-A-4E57
(ucs-set-char #x5DEB ?$BV`(B) ; J83-B-5660
(ucs-set-char #x5DEE ?$(Cs,(B) ; KS0-C-732C
(ucs-set-char #x5DEE ?$(GU8(B) ; C01-G-5538
(ucs-set-char #x5DEE ?$@:9(B) ; J78-@-3A39
(ucs-set-char #x5DEE ?$A2n(B) ; GB0-A-326E
(ucs-set-char #x5DEE ?$B:9(B) ; J83-B-3A39
(ucs-set-char #x5DEF ?$A[O(B) ; GB0-A-5B4F
(ucs-set-char #x5DF0 ?$(HB](B) ; C02-H-425D

(ucs-set-char #x5DF1 ?$A<:(B) ; GB0-A-3C3A
(ucs-set-char #x5DF1 ?$(CPy(B) ; KS0-C-5079
(ucs-set-char #x5DF1 ?$(GDW(B) ; C01-G-4457
(ucs-set-char #x5DF1 ?$@8J(B) ; J78-@-384A
(ucs-set-char #x5DF1 ?$B8J(B) ; J83-B-384A

(ucs-set-char #x5DF2 ?$(Cl+(B) ; KS0-C-6C2B
(ucs-set-char #x5DF2 ?$(GDX(B) ; C01-G-4458
(ucs-set-char #x5DF2 ?$@Va(B) ; J78-@-5661
(ucs-set-char #x5DF2 ?$ARQ(B) ; GB0-A-5251
(ucs-set-char #x5DF2 ?$BVa(B) ; J83-B-5661
(ucs-set-char #x5DF3 ?$(C^S(B) ; KS0-C-5E53
(ucs-set-char #x5DF3 ?$(GDY(B) ; C01-G-4459
(ucs-set-char #x5DF3 ?$@L&(B) ; J78-@-4C26
(ucs-set-char #x5DF3 ?$AKH(B) ; GB0-A-4B48
(ucs-set-char #x5DF3 ?$BL&(B) ; J83-B-4C26
(ucs-set-char #x5DF4 ?$(Cwi(B) ; KS0-C-7769
(ucs-set-char #x5DF4 ?$(GE;(B) ; C01-G-453B
(ucs-set-char #x5DF4 ?$@GC(B) ; J78-@-4743
(ucs-set-char #x5DF4 ?$A0M(B) ; GB0-A-304D
(ucs-set-char #x5DF4 ?$BGC(B) ; J83-B-4743
(ucs-set-char #x5DF5 ?$(I%g(B) ; C03-I-2567
(ucs-set-char #x5DF5 ?$@Vb(B) ; J78-@-5662
(ucs-set-char #x5DF5 ?$BVb(B) ; J83-B-5662
(ucs-set-char #x5DF6 ?$(I(`(B) ; C03-I-2860
(ucs-set-char #x5DF7 ?$(Cyu(B) ; KS0-C-7975
(ucs-set-char #x5DF7 ?$(GPs(B) ; C01-G-5073
(ucs-set-char #x5DF7 ?$@9+(B) ; J78-@-392B
(ucs-set-char #x5DF7 ?$AOo(B) ; GB0-A-4F6F
(ucs-set-char #x5DF7 ?$B9+(B) ; J83-B-392B
(ucs-set-char #x5DF8 ?$(D<"(B) ; J90-D-3C22
(ucs-set-char #x5DF8 ?$(J,d(B) ; C04-J-2C64
(ucs-set-char #x5DF9 ?$(D<#(B) ; J90-D-3C23
(ucs-set-char #x5DF9 ?$(H*0(B) ; C02-H-2A30
(ucs-set-char #x5DFA ?$(I,E(B) ; C03-I-2C45
(ucs-set-char #x5DFB ?$(I,D(B) ; C03-I-2C44
(ucs-set-char #x5DFB ?$@4,(B) ; J78-@-342C
(ucs-set-char #x5DFB ?$B4,(B) ; J83-B-342C
(ucs-set-char #x5DFD ?$(Ca^(B) ; KS0-C-615E
(ucs-set-char #x5DFD ?$(G^x(B) ; C01-G-5E78
(ucs-set-char #x5DFD ?$(LH7(B) ; C06-L-4837
(ucs-set-char #x5DFD ?$@C'(B) ; J78-@-4327
(ucs-set-char #x5DFD ?$AYc(B) ; GB0-A-5963
(ucs-set-char #x5DFD ?$BC'(B) ; J83-B-4327
(ucs-set-char #x5DFE ?$(CKn(B) ; KS0-C-4B6E
(ucs-set-char #x5DFE ?$(GDZ(B) ; C01-G-445A
(ucs-set-char #x5DFE ?$@6R(B) ; J78-@-3652
(ucs-set-char #x5DFE ?$A=m(B) ; GB0-A-3D6D
(ucs-set-char #x5DFE ?$B6R(B) ; J83-B-3652
(ucs-set-char #x5DFF ?$(H!=(B) ; C02-H-213D
(ucs-set-char #x5E00 ?$(D<$(B) ; J90-D-3C24
(ucs-set-char #x5E00 ?$(I!c(B) ; C03-I-2163
(ucs-set-char #x5E01 ?$(J!L(B) ; C04-J-214C
(ucs-set-char #x5E01 ?$A1R(B) ; GB0-A-3152
(ucs-set-char #x5E02 ?$(Cc<(B) ; KS0-C-633C
(ucs-set-char #x5E02 ?$(GFK(B) ; C01-G-464B
(ucs-set-char #x5E02 ?$@;T(B) ; J78-@-3B54
(ucs-set-char #x5E02 ?$AJP(B) ; GB0-A-4A50
(ucs-set-char #x5E02 ?$B;T(B) ; J83-B-3B54
(ucs-set-char #x5E03 ?$(CxV(B) ; KS0-C-7856
(ucs-set-char #x5E03 ?$(GFL(B) ; C01-G-464C
(ucs-set-char #x5E03 ?$@I[(B) ; J78-@-495B
(ucs-set-char #x5E03 ?$A2<(B) ; GB0-A-323C
(ucs-set-char #x5E03 ?$BI[(B) ; J83-B-495B
(ucs-set-char #x5E04 ?$(H!Y(B) ; C02-H-2159
(ucs-set-char #x5E05 ?$AK'(B) ; GB0-A-4B27
(ucs-set-char #x5E06 ?$(C[n(B) ; KS0-C-5B6E
(ucs-set-char #x5E06 ?$(GG}(B) ; C01-G-477D
(ucs-set-char #x5E06 ?$@HA(B) ; J78-@-4841
(ucs-set-char #x5E06 ?$A7+(B) ; GB0-A-372B
(ucs-set-char #x5E06 ?$BHA(B) ; J83-B-4841
(ucs-set-char #x5E07 ?$(D<%(B) ; J90-D-3C25
(ucs-set-char #x5E07 ?$(K"\(B) ; C05-K-225C
(ucs-set-char #x5E08 ?$(I#\(B) ; C03-I-235C
(ucs-set-char #x5E08 ?$AJ&(B) ; GB0-A-4A26
(ucs-set-char #x5E09 ?$(I%h(B) ; C03-I-2568
(ucs-set-char #x5E0A ?$(H#k(B) ; C02-H-236B
(ucs-set-char #x5E0B ?$(I%k(B) ; C03-I-256B
(ucs-set-char #x5E0B ?$@Vc(B) ; J78-@-5663
(ucs-set-char #x5E0B ?$BVc(B) ; J83-B-5663
(ucs-set-char #x5E0C ?$(C}q(B) ; KS0-C-7D71
(ucs-set-char #x5E0C ?$(GJ((B) ; C01-G-4A28
(ucs-set-char #x5E0C ?$@4u(B) ; J78-@-3475
(ucs-set-char #x5E0C ?$AO#(B) ; GB0-A-4F23
(ucs-set-char #x5E0C ?$B4u(B) ; J83-B-3475
(ucs-set-char #x5E0D ?$(D<&(B) ; J90-D-3C26
(ucs-set-char #x5E0D ?$(J$#(B) ; C04-J-2423
(ucs-set-char #x5E0E ?$(H#l(B) ; C02-H-236C
(ucs-set-char #x5E0F ?$A`x(B) ; GB0-A-6078
(ucs-set-char #x5E10 ?$AUJ(B) ; GB0-A-554A
(ucs-set-char #x5E11 ?$(Cw6(B) ; KS0-C-7736
(ucs-set-char #x5E11 ?$(GM0(B) ; C01-G-4D30
(ucs-set-char #x5E11 ?$@Vf(B) ; J78-@-5666
(ucs-set-char #x5E11 ?$A`{(B) ; GB0-A-607B
(ucs-set-char #x5E11 ?$BVf(B) ; J83-B-5666
(ucs-set-char #x5E12 ?$(D<'(B) ; J90-D-3C27
(ucs-set-char #x5E12 ?$(I(b(B) ; C03-I-2862
(ucs-set-char #x5E13 ?$(I(a(B) ; C03-I-2861
(ucs-set-char #x5E14 ?$(D<((B) ; J90-D-3C28
(ucs-set-char #x5E14 ?$(H&O(B) ; C02-H-264F
(ucs-set-char #x5E14 ?$A`z(B) ; GB0-A-607A
(ucs-set-char #x5E15 ?$(D<)(B) ; J90-D-3C29
(ucs-set-char #x5E15 ?$(GM.(B) ; C01-G-4D2E
(ucs-set-char #x5E15 ?$AEA(B) ; GB0-A-4541
(ucs-set-char #x5E16 ?$(Ct^(B) ; KS0-C-745E
(ucs-set-char #x5E16 ?$(GM-(B) ; C01-G-4D2D
(ucs-set-char #x5E16 ?$@D!(B) ; J78-@-4421
(ucs-set-char #x5E16 ?$AL{(B) ; GB0-A-4C7B
(ucs-set-char #x5E16 ?$BD!(B) ; J83-B-4421
(ucs-set-char #x5E17 ?$(H&N(B) ; C02-H-264E
(ucs-set-char #x5E18 ?$(D<*(B) ; J90-D-3C2A
(ucs-set-char #x5E18 ?$(GM+(B) ; C01-G-4D2B
(ucs-set-char #x5E18 ?$AA1(B) ; GB0-A-4131
(ucs-set-char #x5E19 ?$(Crm(B) ; KS0-C-726D
(ucs-set-char #x5E19 ?$(H&P(B) ; C02-H-2650
(ucs-set-char #x5E19 ?$@Ve(B) ; J78-@-5665
(ucs-set-char #x5E19 ?$A`y(B) ; GB0-A-6079
(ucs-set-char #x5E19 ?$BVe(B) ; J83-B-5665
(ucs-set-char #x5E1A ?$(GM,(B) ; C01-G-4D2C
(ucs-set-char #x5E1A ?$@Vd(B) ; J78-@-5664
(ucs-set-char #x5E1A ?$AVc(B) ; GB0-A-5663
(ucs-set-char #x5E1A ?$BVd(B) ; J83-B-5664
(ucs-set-char #x5E1B ?$(C[Y(B) ; KS0-C-5B59
(ucs-set-char #x5E1B ?$(GM/(B) ; C01-G-4D2F
(ucs-set-char #x5E1B ?$@Vg(B) ; J78-@-5667
(ucs-set-char #x5E1B ?$A2/(B) ; GB0-A-322F
(ucs-set-char #x5E1B ?$BVg(B) ; J83-B-5667
(ucs-set-char #x5E1C ?$AVD(B) ; GB0-A-5644
(ucs-set-char #x5E1D ?$(Cp((B) ; KS0-C-7028
(ucs-set-char #x5E1D ?$(GPt(B) ; C01-G-5074
(ucs-set-char #x5E1D ?$@Dk(B) ; J78-@-446B
(ucs-set-char #x5E1D ?$A5[(B) ; GB0-A-355B
(ucs-set-char #x5E1D ?$BDk(B) ; J83-B-446B
(ucs-set-char #x5E1E ?$(I,F(B) ; C03-I-2C46
(ucs-set-char #x5E1F ?$(D<+(B) ; J90-D-3C2B
(ucs-set-char #x5E1F ?$(GPv(B) ; C01-G-5076
(ucs-set-char #x5E20 ?$(D<,(B) ; J90-D-3C2C
(ucs-set-char #x5E20 ?$(H*4(B) ; C02-H-2A34
(ucs-set-char #x5E21 ?$(H*1(B) ; C02-H-2A31
(ucs-set-char #x5E22 ?$(H*2(B) ; C02-H-2A32
(ucs-set-char #x5E23 ?$(H*3(B) ; C02-H-2A33
(ucs-set-char #x5E24 ?$(H*5(B) ; C02-H-2A35
(ucs-set-char #x5E25 ?$(Ca}(B) ; KS0-C-617D
(ucs-set-char #x5E25 ?$(GPu(B) ; C01-G-5075
(ucs-set-char #x5E25 ?$@?c(B) ; J78-@-3F63
(ucs-set-char #x5E25 ?$B?c(B) ; J83-B-3F63
(ucs-set-char #x5E26 ?$A4x(B) ; GB0-A-3478
(ucs-set-char #x5E27 ?$AV!(B) ; GB0-A-5621
(ucs-set-char #x5E28 ?$(D<.(B) ; J90-D-3C2E
(ucs-set-char #x5E28 ?$(H.v(B) ; C02-H-2E76
(ucs-set-char #x5E29 ?$(H.u(B) ; C02-H-2E75
(ucs-set-char #x5E2A ?$(I0f(B) ; C03-I-3066
(ucs-set-char #x5E2B ?$(C^T(B) ; KS0-C-5E54
(ucs-set-char #x5E2B ?$(GU:(B) ; C01-G-553A
(ucs-set-char #x5E2B ?$@;U(B) ; J78-@-3B55
(ucs-set-char #x5E2B ?$B;U(B) ; J83-B-3B55
(ucs-set-char #x5E2C ?$(I0i(B) ; C03-I-3069
(ucs-set-char #x5E2D ?$(C`,(B) ; KS0-C-602C
(ucs-set-char #x5E2D ?$(GU9(B) ; C01-G-5539
(ucs-set-char #x5E2D ?$@@J(B) ; J78-@-404A
(ucs-set-char #x5E2D ?$AO/(B) ; GB0-A-4F2F
(ucs-set-char #x5E2D ?$B@J(B) ; J83-B-404A
(ucs-set-char #x5E2E ?$(D<-(B) ; J90-D-3C2D
(ucs-set-char #x5E2E ?$(I0h(B) ; C03-I-3068
(ucs-set-char #x5E2E ?$A0o(B) ; GB0-A-306F
(ucs-set-char #x5E2F ?$(I0j(B) ; C03-I-306A
(ucs-set-char #x5E2F ?$@BS(B) ; J78-@-4253
(ucs-set-char #x5E2F ?$BBS(B) ; J83-B-4253
(ucs-set-char #x5E30 ?$(I0g(B) ; C03-I-3067
(ucs-set-char #x5E30 ?$@5"(B) ; J78-@-3522
(ucs-set-char #x5E30 ?$B5"(B) ; J83-B-3522
(ucs-set-char #x5E31 ?$A`|(B) ; GB0-A-607C
(ucs-set-char #x5E32 ?$(D</(B) ; J90-D-3C2F
(ucs-set-char #x5E32 ?$(I5[(B) ; C03-I-355B
(ucs-set-char #x5E33 ?$(Cmc(B) ; KS0-C-6D63
(ucs-set-char #x5E33 ?$(GZ((B) ; C01-G-5A28
(ucs-set-char #x5E33 ?$@D"(B) ; J78-@-4422
(ucs-set-char #x5E33 ?$BD"(B) ; J83-B-4422
(ucs-set-char #x5E34 ?$(H5*(B) ; C02-H-352A
(ucs-set-char #x5E35 ?$(D<0(B) ; J90-D-3C30
(ucs-set-char #x5E35 ?$(I5Y(B) ; C03-I-3559
(ucs-set-char #x5E36 ?$(CSa(B) ; KS0-C-5361
(ucs-set-char #x5E36 ?$(GZ'(B) ; C01-G-5A27
(ucs-set-char #x5E36 ?$@Vh(B) ; J78-@-5668
(ucs-set-char #x5E36 ?$BVh(B) ; J83-B-5668
(ucs-set-char #x5E37 ?$(GZ)(B) ; C01-G-5A29
(ucs-set-char #x5E37 ?$@Vi(B) ; J78-@-5669
(ucs-set-char #x5E37 ?$Aa!(B) ; GB0-A-6121
(ucs-set-char #x5E37 ?$BVi(B) ; J83-B-5669
(ucs-set-char #x5E38 ?$(C_H(B) ; KS0-C-5F48
(ucs-set-char #x5E38 ?$(GZ&(B) ; C01-G-5A26
(ucs-set-char #x5E38 ?$@>o(B) ; J78-@-3E6F
(ucs-set-char #x5E38 ?$A3#(B) ; GB0-A-3323
(ucs-set-char #x5E38 ?$B>o(B) ; J83-B-3E6F
(ucs-set-char #x5E39 ?$(I5X(B) ; C03-I-3558
(ucs-set-char #x5E3A ?$(I5Z(B) ; C03-I-355A
(ucs-set-char #x5E3B ?$A`}(B) ; GB0-A-607D
(ucs-set-char #x5E3C ?$A`~(B) ; GB0-A-607E
(ucs-set-char #x5E3D ?$(CY6(B) ; KS0-C-5936
(ucs-set-char #x5E3D ?$(G^z(B) ; C01-G-5E7A
(ucs-set-char #x5E3D ?$(LH<(B) ; C06-L-483C
(ucs-set-char #x5E3D ?$@K9(B) ; J78-@-4B39
(ucs-set-char #x5E3D ?$AC1(B) ; GB0-A-4331
(ucs-set-char #x5E3D ?$BK9(B) ; J83-B-4B39
(ucs-set-char #x5E3E ?$(D<1(B) ; J90-D-3C31
(ucs-set-char #x5E3E ?$(H5)(B) ; C02-H-3529
(ucs-set-char #x5E3F ?$(C},(B) ; KS0-C-7D2C
(ucs-set-char #x5E3F ?$(K7|(B) ; C05-K-377C
(ucs-set-char #x5E40 ?$(CoS(B) ; KS0-C-6F53
(ucs-set-char #x5E40 ?$(G^{(B) ; C01-G-5E7B
(ucs-set-char #x5E40 ?$@Vl(B) ; J78-@-566C
(ucs-set-char #x5E40 ?$BVl(B) ; J83-B-566C
(ucs-set-char #x5E41 ?$(H;W(B) ; C02-H-3B57
(ucs-set-char #x5E42 ?$(I9y(B) ; C03-I-3979
(ucs-set-char #x5E42 ?$AC](B) ; GB0-A-435D
(ucs-set-char #x5E43 ?$(G^|(B) ; C01-G-5E7C
(ucs-set-char #x5E43 ?$@Vk(B) ; J78-@-566B
(ucs-set-char #x5E43 ?$BVk(B) ; J83-B-566B
(ucs-set-char #x5E44 ?$(CdA(B) ; KS0-C-6441
(ucs-set-char #x5E44 ?$(H;V(B) ; C02-H-3B56
(ucs-set-char #x5E44 ?$@Vj(B) ; J78-@-566A
(ucs-set-char #x5E44 ?$Aa"(B) ; GB0-A-6122
(ucs-set-char #x5E44 ?$BVj(B) ; J83-B-566A
(ucs-set-char #x5E45 ?$(Cxk(B) ; KS0-C-786B
(ucs-set-char #x5E45 ?$(G^y(B) ; C01-G-5E79
(ucs-set-char #x5E45 ?$@I}(B) ; J78-@-497D
(ucs-set-char #x5E45 ?$A7y(B) ; GB0-A-3779
(ucs-set-char #x5E45 ?$BI}(B) ; J83-B-497D
(ucs-set-char #x5E46 ?$(I;:(B) ; C03-I-3B3A
(ucs-set-char #x5E47 ?$(C[,(B) ; KS0-C-5B2C
(ucs-set-char #x5E47 ?$(I;;(B) ; C03-I-3B3B
(ucs-set-char #x5E47 ?$@Vs(B) ; J78-@-5673
(ucs-set-char #x5E47 ?$BVs(B) ; J83-B-5673
(ucs-set-char #x5E48 ?$(I;=(B) ; C03-I-3B3D
(ucs-set-char #x5E49 ?$(D<4(B) ; J90-D-3C34
(ucs-set-char #x5E4A ?$(HB`(B) ; C02-H-4260
(ucs-set-char #x5E4B ?$(D<2(B) ; J90-D-3C32
(ucs-set-char #x5E4B ?$(HBb(B) ; C02-H-4262
(ucs-set-char #x5E4C ?$(C|F(B) ; KS0-C-7C46
(ucs-set-char #x5E4C ?$(Gck(B) ; C01-G-636B
(ucs-set-char #x5E4C ?$@KZ(B) ; J78-@-4B5A
(ucs-set-char #x5E4C ?$A;O(B) ; GB0-A-3B4F
(ucs-set-char #x5E4C ?$BKZ(B) ; J83-B-4B5A
(ucs-set-char #x5E4D ?$(HBa(B) ; C02-H-4261
(ucs-set-char #x5E4E ?$(HB_(B) ; C02-H-425F
(ucs-set-char #x5E4E ?$@Vm(B) ; J78-@-566D
(ucs-set-char #x5E4E ?$BVm(B) ; J83-B-566D
(ucs-set-char #x5E4F ?$(HB^(B) ; C02-H-425E
(ucs-set-char #x5E50 ?$(D<3(B) ; J90-D-3C33
(ucs-set-char #x5E50 ?$(J=*(B) ; C04-J-3D2A
(ucs-set-char #x5E51 ?$(D<5(B) ; J90-D-3C35
(ucs-set-char #x5E51 ?$(JC5(B) ; C04-J-4335
(ucs-set-char #x5E52 ?$(IF](B) ; C03-I-465D
(ucs-set-char #x5E53 ?$(HIy(B) ; C02-H-4979
(ucs-set-char #x5E54 ?$(Gh_(B) ; C01-G-685F
(ucs-set-char #x5E54 ?$@Vo(B) ; J78-@-566F
(ucs-set-char #x5E54 ?$Aa#(B) ; GB0-A-6123
(ucs-set-char #x5E54 ?$BVo(B) ; J83-B-566F
(ucs-set-char #x5E55 ?$(CX-(B) ; KS0-C-582D
(ucs-set-char #x5E55 ?$(Gh](B) ; C01-G-685D
(ucs-set-char #x5E55 ?$@Kk(B) ; J78-@-4B6B
(ucs-set-char #x5E55 ?$AD;(B) ; GB0-A-443B
(ucs-set-char #x5E55 ?$BKk(B) ; J83-B-4B6B
(ucs-set-char #x5E56 ?$(D<6(B) ; J90-D-3C36
(ucs-set-char #x5E56 ?$(JC0(B) ; C04-J-4330
(ucs-set-char #x5E57 ?$(Gh^(B) ; C01-G-685E
(ucs-set-char #x5E57 ?$@Vn(B) ; J78-@-566E
(ucs-set-char #x5E57 ?$BVn(B) ; J83-B-566E
(ucs-set-char #x5E58 ?$(D<7(B) ; J90-D-3C37
(ucs-set-char #x5E58 ?$(HIw(B) ; C02-H-4977
(ucs-set-char #x5E59 ?$(HIx(B) ; C02-H-4978
(ucs-set-char #x5E5A ?$(IKm(B) ; C03-I-4B6D
(ucs-set-char #x5E5B ?$(D<8(B) ; J90-D-3C38
(ucs-set-char #x5E5B ?$(Gh[(B) ; C01-G-685B
(ucs-set-char #x5E5B ?$Aa$(B) ; GB0-A-6124
(ucs-set-char #x5E5C ?$(D<9(B) ; J90-D-3C39
(ucs-set-char #x5E5C ?$(HP:(B) ; C02-H-503A
(ucs-set-char #x5E5D ?$(HP8(B) ; C02-H-5038
(ucs-set-char #x5E5E ?$(D<:(B) ; J90-D-3C3A
(ucs-set-char #x5E5E ?$(IKp(B) ; C03-I-4B70
(ucs-set-char #x5E5E ?$Aa%(B) ; GB0-A-6125
(ucs-set-char #x5E5F ?$(Cv:(B) ; KS0-C-763A
(ucs-set-char #x5E5F ?$(GlW(B) ; C01-G-6C57
(ucs-set-char #x5E5F ?$@Vp(B) ; J78-@-5670
(ucs-set-char #x5E5F ?$BVp(B) ; J83-B-5670
(ucs-set-char #x5E60 ?$(HP9(B) ; C02-H-5039
(ucs-set-char #x5E61 ?$(C[_(B) ; KS0-C-5B5F
(ucs-set-char #x5E61 ?$(GlX(B) ; C01-G-6C58
(ucs-set-char #x5E61 ?$@H((B) ; J78-@-4828
(ucs-set-char #x5E61 ?$Aa&(B) ; GB0-A-6126
(ucs-set-char #x5E61 ?$BH((B) ; J83-B-4828
(ucs-set-char #x5E62 ?$(CSS(B) ; KS0-C-5353
(ucs-set-char #x5E62 ?$(GlV(B) ; C01-G-6C56
(ucs-set-char #x5E62 ?$@Vq(B) ; J78-@-5671
(ucs-set-char #x5E62 ?$A41(B) ; GB0-A-3431
(ucs-set-char #x5E62 ?$BVq(B) ; J83-B-5671
(ucs-set-char #x5E63 ?$(CxG(B) ; KS0-C-7847
(ucs-set-char #x5E63 ?$(Gh\(B) ; C01-G-685C
(ucs-set-char #x5E63 ?$@J>(B) ; J78-@-4A3E
(ucs-set-char #x5E63 ?$BJ>(B) ; J83-B-4A3E
(ucs-set-char #x5E64 ?$@Vr(B) ; J78-@-5672
(ucs-set-char #x5E64 ?$BVr(B) ; J83-B-5672
(ucs-set-char #x5E66 ?$(HVw(B) ; C02-H-5677
(ucs-set-char #x5E67 ?$(HVu(B) ; C02-H-5675
(ucs-set-char #x5E68 ?$(D<;(B) ; J90-D-3C3B
(ucs-set-char #x5E68 ?$(HVv(B) ; C02-H-5676
(ucs-set-char #x5E69 ?$(HP7(B) ; C02-H-5037
(ucs-set-char #x5E6A ?$(D<<(B) ; J90-D-3C3C
(ucs-set-char #x5E6A ?$(H\h(B) ; C02-H-5C68
(ucs-set-char #x5E6B ?$(D<=(B) ; J90-D-3C3D
(ucs-set-char #x5E6B ?$(GsY(B) ; C01-G-7359
(ucs-set-char #x5E6C ?$(D<>(B) ; J90-D-3C3E
(ucs-set-char #x5E6C ?$(H\g(B) ; C02-H-5C67
(ucs-set-char #x5E6D ?$(D<?(B) ; J90-D-3C3F
(ucs-set-char #x5E6D ?$(HaQ(B) ; C02-H-6151
(ucs-set-char #x5E6E ?$(D<@(B) ; J90-D-3C40
(ucs-set-char #x5E6E ?$(HaR(B) ; C02-H-6152
(ucs-set-char #x5E6F ?$(HVx(B) ; C02-H-5678
(ucs-set-char #x5E70 ?$(D<A(B) ; J90-D-3C41
(ucs-set-char #x5E70 ?$(HeJ(B) ; C02-H-654A
(ucs-set-char #x5E71 ?$(Jc9(B) ; C04-J-6339
(ucs-set-char #x5E72 ?$(CJN(B) ; KS0-C-4A4E
(ucs-set-char #x5E72 ?$(GD[(B) ; C01-G-445B
(ucs-set-char #x5E72 ?$@43(B) ; J78-@-3433
(ucs-set-char #x5E72 ?$A8I(B) ; GB0-A-3849
(ucs-set-char #x5E72 ?$B43(B) ; J83-B-3433
(ucs-set-char #x5E73 ?$(CxA(B) ; KS0-C-7841
(ucs-set-char #x5E73 ?$(GFM(B) ; C01-G-464D
(ucs-set-char #x5E73 ?$@J?(B) ; J78-@-4A3F
(ucs-set-char #x5E73 ?$AF=(B) ; GB0-A-463D
(ucs-set-char #x5E73 ?$BJ?(B) ; J83-B-4A3F
(ucs-set-char #x5E74 ?$(CR4(B) ; KS0-C-5234
(ucs-set-char #x5E74 ?$(GH!(B) ; C01-G-4821
(ucs-set-char #x5E74 ?$@G/(B) ; J78-@-472F
(ucs-set-char #x5E74 ?$ADj(B) ; GB0-A-446A
(ucs-set-char #x5E74 ?$BG/(B) ; J83-B-472F
(ucs-set-char #x5E75 ?$(H";(B) ; C02-H-223B
(ucs-set-char #x5E75 ?$@Vt(B) ; J78-@-5674
(ucs-set-char #x5E75 ?$BVt(B) ; J83-B-5674
(ucs-set-char #x5E76 ?$(GG~(B) ; C01-G-477E
(ucs-set-char #x5E76 ?$@Vu(B) ; J78-@-5675
(ucs-set-char #x5E76 ?$A2"(B) ; GB0-A-3222
(ucs-set-char #x5E76 ?$BVu(B) ; J83-B-5675
(ucs-set-char #x5E77 ?$(C\4(B) ; KS0-C-5C34
(ucs-set-char #x5E77 ?$(I(c(B) ; C03-I-2863
(ucs-set-char #x5E78 ?$(Cz9(B) ; KS0-C-7A39
(ucs-set-char #x5E78 ?$(GM1(B) ; C01-G-4D31
(ucs-set-char #x5E78 ?$@9,(B) ; J78-@-392C
(ucs-set-char #x5E78 ?$APR(B) ; GB0-A-5052
(ucs-set-char #x5E78 ?$B9,(B) ; J83-B-392C
(ucs-set-char #x5E79 ?$(CJO(B) ; KS0-C-4A4F
(ucs-set-char #x5E79 ?$(Gcl(B) ; C01-G-636C
(ucs-set-char #x5E79 ?$@44(B) ; J78-@-3434
(ucs-set-char #x5E79 ?$B44(B) ; J83-B-3434
(ucs-set-char #x5E7A ?$(I!=(B) ; C03-I-213D
(ucs-set-char #x5E7A ?$@Vv(B) ; J78-@-5676
(ucs-set-char #x5E7A ?$Ag[(B) ; GB0-A-675B
(ucs-set-char #x5E7A ?$BVv(B) ; J83-B-5676
(ucs-set-char #x5E7B ?$(C|3(B) ; KS0-C-7C33
(ucs-set-char #x5E7B ?$(GE<(B) ; C01-G-453C
(ucs-set-char #x5E7B ?$@88(B) ; J78-@-3838
(ucs-set-char #x5E7B ?$A;C(B) ; GB0-A-3B43
(ucs-set-char #x5E7B ?$B88(B) ; J83-B-3838
(ucs-set-char #x5E7C ?$(Cjj(B) ; KS0-C-6A6A
(ucs-set-char #x5E7C ?$(GFN(B) ; C01-G-464E
(ucs-set-char #x5E7C ?$@MD(B) ; J78-@-4D44
(ucs-set-char #x5E7C ?$ASW(B) ; GB0-A-5357
(ucs-set-char #x5E7C ?$BMD(B) ; J83-B-4D44
(ucs-set-char #x5E7D ?$(Cjk(B) ; KS0-C-6A6B
(ucs-set-char #x5E7D ?$(GPw(B) ; C01-G-5077
(ucs-set-char #x5E7D ?$@M)(B) ; J78-@-4D29
(ucs-set-char #x5E7D ?$ASD(B) ; GB0-A-5344
(ucs-set-char #x5E7D ?$BM)(B) ; J83-B-4D29
(ucs-set-char #x5E7E ?$(CPz(B) ; KS0-C-507A
(ucs-set-char #x5E7E ?$(G^}(B) ; C01-G-5E7D
(ucs-set-char #x5E7E ?$@4v(B) ; J78-@-3476
(ucs-set-char #x5E7E ?$B4v(B) ; J83-B-3476
(ucs-set-char #x5E7F ?$(I!>(B) ; C03-I-213E
(ucs-set-char #x5E7F ?$@Vx(B) ; J78-@-5678
(ucs-set-char #x5E7F ?$A9c(B) ; GB0-A-3963
(ucs-set-char #x5E7F ?$BVx(B) ; J83-B-5678
(ucs-set-char #x5E80 ?$(D<B(B) ; J90-D-3C42
(ucs-set-char #x5E80 ?$(H!Z(B) ; C02-H-215A
(ucs-set-char #x5E80 ?$AbO(B) ; GB0-A-624F
(ucs-set-char #x5E81 ?$(I"G(B) ; C03-I-2247
(ucs-set-char #x5E81 ?$@D#(B) ; J78-@-4423
(ucs-set-char #x5E81 ?$BD#(B) ; J83-B-4423
(ucs-set-char #x5E82 ?$(H![(B) ; C02-H-215B
(ucs-set-char #x5E83 ?$(I"H(B) ; C03-I-2248
(ucs-set-char #x5E83 ?$@9-(B) ; J78-@-392D
(ucs-set-char #x5E83 ?$B9-(B) ; J83-B-392D
(ucs-set-char #x5E84 ?$(Cmd(B) ; KS0-C-6D64
(ucs-set-char #x5E84 ?$(H"<(B) ; C02-H-223C
(ucs-set-char #x5E84 ?$@>1(B) ; J78-@-3E31
(ucs-set-char #x5E84 ?$AW/(B) ; GB0-A-572F
(ucs-set-char #x5E84 ?$B>1(B) ; J83-B-3E31
(ucs-set-char #x5E86 ?$AGl(B) ; GB0-A-476C
(ucs-set-char #x5E87 ?$(C]g(B) ; KS0-C-5D67
(ucs-set-char #x5E87 ?$(GJ*(B) ; C01-G-4A2A
(ucs-set-char #x5E87 ?$@H_(B) ; J78-@-485F
(ucs-set-char #x5E87 ?$A1S(B) ; GB0-A-3153
(ucs-set-char #x5E87 ?$BH_(B) ; J83-B-485F
(ucs-set-char #x5E88 ?$(H#p(B) ; C02-H-2370
(ucs-set-char #x5E89 ?$(H#n(B) ; C02-H-236E
(ucs-set-char #x5E8A ?$(C_I(B) ; KS0-C-5F49
(ucs-set-char #x5E8A ?$(GJ+(B) ; C01-G-4A2B
(ucs-set-char #x5E8A ?$@>2(B) ; J78-@-3E32
(ucs-set-char #x5E8A ?$A42(B) ; GB0-A-3432
(ucs-set-char #x5E8A ?$B>2(B) ; J83-B-3E32
(ucs-set-char #x5E8B ?$(D<C(B) ; J90-D-3C43
(ucs-set-char #x5E8B ?$(H#m(B) ; C02-H-236D
(ucs-set-char #x5E8B ?$AbQ(B) ; GB0-A-6251
(ucs-set-char #x5E8C ?$(H#o(B) ; C02-H-236F
(ucs-set-char #x5E8D ?$(H#q(B) ; C02-H-2371
(ucs-set-char #x5E8E ?$(D<D(B) ; J90-D-3C44
(ucs-set-char #x5E8E ?$(J$((B) ; C04-J-2428
(ucs-set-char #x5E8F ?$(C_m(B) ; KS0-C-5F6D
(ucs-set-char #x5E8F ?$(GJ)(B) ; C01-G-4A29
(ucs-set-char #x5E8F ?$@=x(B) ; J78-@-3D78
(ucs-set-char #x5E8F ?$APr(B) ; GB0-A-5072
(ucs-set-char #x5E8F ?$B=x(B) ; J83-B-3D78
(ucs-set-char #x5E90 ?$(I%n(B) ; C03-I-256E
(ucs-set-char #x5E90 ?$AB.(B) ; GB0-A-422E
(ucs-set-char #x5E91 ?$AbP(B) ; GB0-A-6250
(ucs-set-char #x5E92 ?$(I%m(B) ; C03-I-256D
(ucs-set-char #x5E93 ?$A?b(B) ; GB0-A-3F62
(ucs-set-char #x5E94 ?$(L'C(B) ; C06-L-2743
(ucs-set-char #x5E94 ?$AS&(B) ; GB0-A-5326
(ucs-set-char #x5E95 ?$(Cn<(B) ; KS0-C-6E3C
(ucs-set-char #x5E95 ?$(GM5(B) ; C01-G-4D35
(ucs-set-char #x5E95 ?$@Dl(B) ; J78-@-446C
(ucs-set-char #x5E95 ?$A5W(B) ; GB0-A-3557
(ucs-set-char #x5E95 ?$BDl(B) ; J83-B-446C
(ucs-set-char #x5E96 ?$(GM6(B) ; C01-G-4D36
(ucs-set-char #x5E96 ?$@Jy(B) ; J78-@-4A79
(ucs-set-char #x5E96 ?$AbR(B) ; GB0-A-6252
(ucs-set-char #x5E96 ?$BJy(B) ; J83-B-4A79
(ucs-set-char #x5E97 ?$(CoA(B) ; KS0-C-6F41
(ucs-set-char #x5E97 ?$(GM3(B) ; C01-G-4D33
(ucs-set-char #x5E97 ?$@E9(B) ; J78-@-4539
(ucs-set-char #x5E97 ?$A5j(B) ; GB0-A-356A
(ucs-set-char #x5E97 ?$BE9(B) ; J83-B-4539
(ucs-set-char #x5E98 ?$(I(e(B) ; C03-I-2865
(ucs-set-char #x5E99 ?$(I(g(B) ; C03-I-2867
(ucs-set-char #x5E99 ?$ACm(B) ; GB0-A-436D
(ucs-set-char #x5E9A ?$(CLR(B) ; KS0-C-4C52
(ucs-set-char #x5E9A ?$(GM2(B) ; C01-G-4D32
(ucs-set-char #x5E9A ?$@9.(B) ; J78-@-392E
(ucs-set-char #x5E9A ?$A8}(B) ; GB0-A-387D
(ucs-set-char #x5E9A ?$B9.(B) ; J83-B-392E
(ucs-set-char #x5E9B ?$(H*9(B) ; C02-H-2A39
(ucs-set-char #x5E9C ?$(C]$(B) ; KS0-C-5D24
(ucs-set-char #x5E9C ?$(GM4(B) ; C01-G-4D34
(ucs-set-char #x5E9C ?$@I\(B) ; J78-@-495C
(ucs-set-char #x5E9C ?$A8.(B) ; GB0-A-382E
(ucs-set-char #x5E9C ?$BI\(B) ; J83-B-495C
(ucs-set-char #x5E9D ?$(I(h(B) ; C03-I-2868
(ucs-set-char #x5E9E ?$AES(B) ; GB0-A-4553
(ucs-set-char #x5E9F ?$(J&9(B) ; C04-J-2639
(ucs-set-char #x5E9F ?$A7O(B) ; GB0-A-374F
(ucs-set-char #x5EA0 ?$(C_J(B) ; KS0-C-5F4A
(ucs-set-char #x5EA0 ?$(GPx(B) ; C01-G-5078
(ucs-set-char #x5EA0 ?$@Vy(B) ; J78-@-5679
(ucs-set-char #x5EA0 ?$AbT(B) ; GB0-A-6254
(ucs-set-char #x5EA0 ?$BVy(B) ; J83-B-5679
(ucs-set-char #x5EA1 ?$(I,H(B) ; C03-I-2C48
(ucs-set-char #x5EA2 ?$(D<E(B) ; J90-D-3C45
(ucs-set-char #x5EA2 ?$(H*8(B) ; C02-H-2A38
(ucs-set-char #x5EA3 ?$(H*:(B) ; C02-H-2A3A
(ucs-set-char #x5EA4 ?$(D<F(B) ; J90-D-3C46
(ucs-set-char #x5EA4 ?$(H*7(B) ; C02-H-2A37
(ucs-set-char #x5EA5 ?$(D<G(B) ; J90-D-3C47
(ucs-set-char #x5EA5 ?$(H*;(B) ; C02-H-2A3B
(ucs-set-char #x5EA5 ?$AbS(B) ; GB0-A-6253
(ucs-set-char #x5EA6 ?$(CSx(B) ; KS0-C-5378
(ucs-set-char #x5EA6 ?$(GPy(B) ; C01-G-5079
(ucs-set-char #x5EA6 ?$@EY(B) ; J78-@-4559
(ucs-set-char #x5EA6 ?$A6H(B) ; GB0-A-3648
(ucs-set-char #x5EA6 ?$BEY(B) ; J83-B-4559
(ucs-set-char #x5EA7 ?$(Cq((B) ; KS0-C-7128
(ucs-set-char #x5EA7 ?$(GU=(B) ; C01-G-553D
(ucs-set-char #x5EA7 ?$@:B(B) ; J78-@-3A42
(ucs-set-char #x5EA7 ?$AWy(B) ; GB0-A-5779
(ucs-set-char #x5EA7 ?$B:B(B) ; J83-B-3A42
(ucs-set-char #x5EA8 ?$(D<H(B) ; J90-D-3C48
(ucs-set-char #x5EA8 ?$(H.w(B) ; C02-H-2E77
(ucs-set-char #x5EA9 ?$(I0l(B) ; C03-I-306C
(ucs-set-char #x5EAA ?$(D<I(B) ; J90-D-3C49
(ucs-set-char #x5EAA ?$(H.y(B) ; C02-H-2E79
(ucs-set-char #x5EAB ?$(CM7(B) ; KS0-C-4D37
(ucs-set-char #x5EAB ?$(GU;(B) ; C01-G-553B
(ucs-set-char #x5EAB ?$@8K(B) ; J78-@-384B
(ucs-set-char #x5EAB ?$B8K(B) ; J83-B-384B
(ucs-set-char #x5EAC ?$(D<J(B) ; J90-D-3C4A
(ucs-set-char #x5EAC ?$(H.z(B) ; C02-H-2E7A
(ucs-set-char #x5EAD ?$(CoT(B) ; KS0-C-6F54
(ucs-set-char #x5EAD ?$(GU<(B) ; C01-G-553C
(ucs-set-char #x5EAD ?$@Dm(B) ; J78-@-446D
(ucs-set-char #x5EAD ?$AM%(B) ; GB0-A-4D25
(ucs-set-char #x5EAD ?$BDm(B) ; J83-B-446D
(ucs-set-char #x5EAE ?$(H.x(B) ; C02-H-2E78
(ucs-set-char #x5EAF ?$(I0k(B) ; C03-I-306B
(ucs-set-char #x5EB0 ?$(H*6(B) ; C02-H-2A36
(ucs-set-char #x5EB1 ?$(D<K(B) ; J90-D-3C4B
(ucs-set-char #x5EB1 ?$(H5+(B) ; C02-H-352B
(ucs-set-char #x5EB2 ?$(H5.(B) ; C02-H-352E
(ucs-set-char #x5EB3 ?$(D<L(B) ; J90-D-3C4C
(ucs-set-char #x5EB3 ?$(H5/(B) ; C02-H-352F
(ucs-set-char #x5EB3 ?$AbX(B) ; GB0-A-6258
(ucs-set-char #x5EB4 ?$(H5,(B) ; C02-H-352C
(ucs-set-char #x5EB5 ?$(Cd](B) ; KS0-C-645D
(ucs-set-char #x5EB5 ?$(GZ-(B) ; C01-G-5A2D
(ucs-set-char #x5EB5 ?$@0C(B) ; J78-@-3043
(ucs-set-char #x5EB5 ?$AbV(B) ; GB0-A-6256
(ucs-set-char #x5EB5 ?$B0C(B) ; J83-B-3043
(ucs-set-char #x5EB6 ?$(C_n(B) ; KS0-C-5F6E
(ucs-set-char #x5EB6 ?$(GZ,(B) ; C01-G-5A2C
(ucs-set-char #x5EB6 ?$@=n(B) ; J78-@-3D6E
(ucs-set-char #x5EB6 ?$AJ|(B) ; GB0-A-4A7C
(ucs-set-char #x5EB6 ?$B=n(B) ; J83-B-3D6E
(ucs-set-char #x5EB7 ?$(CK,(B) ; KS0-C-4B2C
(ucs-set-char #x5EB7 ?$(GZ*(B) ; C01-G-5A2A
(ucs-set-char #x5EB7 ?$@9/(B) ; J78-@-392F
(ucs-set-char #x5EB7 ?$A?5(B) ; GB0-A-3F35
(ucs-set-char #x5EB7 ?$B9/(B) ; J83-B-392F
(ucs-set-char #x5EB8 ?$(Ci<(B) ; KS0-C-693C
(ucs-set-char #x5EB8 ?$(GZ+(B) ; C01-G-5A2B
(ucs-set-char #x5EB8 ?$@MG(B) ; J78-@-4D47
(ucs-set-char #x5EB8 ?$AS9(B) ; GB0-A-5339
(ucs-set-char #x5EB8 ?$BMG(B) ; J83-B-4D47
(ucs-set-char #x5EB9 ?$(H5-(B) ; C02-H-352D
(ucs-set-char #x5EB9 ?$AbU(B) ; GB0-A-6255
(ucs-set-char #x5EBA ?$(I5a(B) ; C03-I-3561
(ucs-set-char #x5EBB ?$(I5`(B) ; C03-I-3560
(ucs-set-char #x5EBD ?$(D<M(B) ; J90-D-3C4D
(ucs-set-char #x5EBD ?$(I;?(B) ; C03-I-3B3F
(ucs-set-char #x5EBE ?$(Cjl(B) ; KS0-C-6A6C
(ucs-set-char #x5EBE ?$(D<N(B) ; J90-D-3C4E
(ucs-set-char #x5EBE ?$(GZ.(B) ; C01-G-5A2E
(ucs-set-char #x5EBE ?$AbW(B) ; GB0-A-6257
(ucs-set-char #x5EBF ?$(D<O(B) ; J90-D-3C4F
(ucs-set-char #x5EBF ?$(I;@(B) ; C03-I-3B40
(ucs-set-char #x5EC0 ?$(I;>(B) ; C03-I-3B3E
(ucs-set-char #x5EC1 ?$(G_!(B) ; C01-G-5F21
(ucs-set-char #x5EC1 ?$@Vz(B) ; J78-@-567A
(ucs-set-char #x5EC1 ?$BVz(B) ; J83-B-567A
(ucs-set-char #x5EC2 ?$(C_K(B) ; KS0-C-5F4B
(ucs-set-char #x5EC2 ?$(G_"(B) ; C01-G-5F22
(ucs-set-char #x5EC2 ?$@V{(B) ; J78-@-567B
(ucs-set-char #x5EC2 ?$BV{(B) ; J83-B-567B
(ucs-set-char #x5EC3 ?$(LHE(B) ; C06-L-4845
(ucs-set-char #x5EC3 ?$@GQ(B) ; J78-@-4751
(ucs-set-char #x5EC3 ?$BGQ(B) ; J83-B-4751
(ucs-set-char #x5EC4 ?$(G_#(B) ; C01-G-5F23
(ucs-set-char #x5EC5 ?$(HBc(B) ; C02-H-4263
(ucs-set-char #x5EC6 ?$(D<P(B) ; J90-D-3C50
(ucs-set-char #x5EC6 ?$(HBe(B) ; C02-H-4265
(ucs-set-char #x5EC7 ?$(HBg(B) ; C02-H-4267
(ucs-set-char #x5EC8 ?$(Cy?(B) ; KS0-C-793F
(ucs-set-char #x5EC8 ?$(Gcn(B) ; C01-G-636E
(ucs-set-char #x5EC8 ?$@V|(B) ; J78-@-567C
(ucs-set-char #x5EC8 ?$BV|(B) ; J83-B-567C
(ucs-set-char #x5EC9 ?$(CV/(B) ; KS0-C-562F
(ucs-set-char #x5EC9 ?$(Gcm(B) ; C01-G-636D
(ucs-set-char #x5EC9 ?$@Nw(B) ; J78-@-4E77
(ucs-set-char #x5EC9 ?$AA.(B) ; GB0-A-412E
(ucs-set-char #x5EC9 ?$BNw(B) ; J83-B-4E77
(ucs-set-char #x5ECA ?$(CUF(B) ; KS0-C-5546
(ucs-set-char #x5ECA ?$(G^~(B) ; C01-G-5E7E
(ucs-set-char #x5ECA ?$(LR@(B) ; C06-L-5240
(ucs-set-char #x5ECA ?$@O-(B) ; J78-@-4F2D
(ucs-set-char #x5ECA ?$A@H(B) ; GB0-A-4048
(ucs-set-char #x5ECA ?$BO-(B) ; J83-B-4F2D
(ucs-set-char #x5ECB ?$(D<R(B) ; J90-D-3C52
(ucs-set-char #x5ECB ?$(HBf(B) ; C02-H-4266
(ucs-set-char #x5ECC ?$(D<Q(B) ; J90-D-3C51
(ucs-set-char #x5ECC ?$(HBd(B) ; C02-H-4264
(ucs-set-char #x5ECE ?$(D<S(B) ; J90-D-3C53
(ucs-set-char #x5ECE ?$(HI}(B) ; C02-H-497D
(ucs-set-char #x5ECF ?$(IFa(B) ; C03-I-4661
(ucs-set-char #x5ECF ?$@V~(B) ; J78-@-567E
(ucs-set-char #x5ECF ?$BV~(B) ; J83-B-567E
(ucs-set-char #x5ED0 ?$(CO*(B) ; KS0-C-4F2A
(ucs-set-char #x5ED0 ?$(IF`(B) ; C03-I-4660
(ucs-set-char #x5ED0 ?$@V}(B) ; J78-@-567D
(ucs-set-char #x5ED0 ?$BV}(B) ; J83-B-567D
(ucs-set-char #x5ED1 ?$(D<T(B) ; J90-D-3C54
(ucs-set-char #x5ED1 ?$(HI{(B) ; C02-H-497B
(ucs-set-char #x5ED1 ?$Ab[(B) ; GB0-A-625B
(ucs-set-char #x5ED2 ?$(D<U(B) ; J90-D-3C55
(ucs-set-char #x5ED2 ?$(HJ#(B) ; C02-H-4A23
(ucs-set-char #x5ED2 ?$AbZ(B) ; GB0-A-625A
(ucs-set-char #x5ED3 ?$(CN)(B) ; KS0-C-4E29
(ucs-set-char #x5ED3 ?$(Gh`(B) ; C01-G-6860
(ucs-set-char #x5ED3 ?$@3G(B) ; J78-@-3347
(ucs-set-char #x5ED3 ?$A@*(B) ; GB0-A-402A
(ucs-set-char #x5ED3 ?$B3G(B) ; J83-B-3347
(ucs-set-char #x5ED4 ?$(D<V(B) ; J90-D-3C56
(ucs-set-char #x5ED4 ?$(HJ$(B) ; C02-H-4A24
(ucs-set-char #x5ED5 ?$(D<W(B) ; J90-D-3C57
(ucs-set-char #x5ED5 ?$(HJ!(B) ; C02-H-4A21
(ucs-set-char #x5ED6 ?$(CVx(B) ; KS0-C-5678
(ucs-set-char #x5ED6 ?$(Gha(B) ; C01-G-6861
(ucs-set-char #x5ED6 ?$@W!(B) ; J78-@-5721
(ucs-set-char #x5ED6 ?$AAN(B) ; GB0-A-414E
(ucs-set-char #x5ED6 ?$BW!(B) ; J83-B-5721
(ucs-set-char #x5ED7 ?$(HI|(B) ; C02-H-497C
(ucs-set-char #x5ED8 ?$(HIz(B) ; C02-H-497A
(ucs-set-char #x5ED9 ?$(HJ"(B) ; C02-H-4A22
(ucs-set-char #x5EDA ?$(Cq7(B) ; KS0-C-7137
(ucs-set-char #x5EDA ?$(GlZ(B) ; C01-G-6C5A
(ucs-set-char #x5EDA ?$@W$(B) ; J78-@-5724
(ucs-set-char #x5EDA ?$BW$(B) ; J83-B-5724
(ucs-set-char #x5EDB ?$(Cnx(B) ; KS0-C-6E78
(ucs-set-char #x5EDB ?$(HP<(B) ; C02-H-503C
(ucs-set-char #x5EDB ?$@W%(B) ; J78-@-5725
(ucs-set-char #x5EDB ?$Ab\(B) ; GB0-A-625C
(ucs-set-char #x5EDB ?$BW%(B) ; J83-B-5725
(ucs-set-char #x5EDC ?$(D<X(B) ; J90-D-3C58
(ucs-set-char #x5EDC ?$(HI~(B) ; C02-H-497E
(ucs-set-char #x5EDD ?$(Gl\(B) ; C01-G-6C5C
(ucs-set-char #x5EDD ?$@W#(B) ; J78-@-5723
(ucs-set-char #x5EDD ?$BW#(B) ; J83-B-5723
(ucs-set-char #x5EDE ?$(D<Y(B) ; J90-D-3C59
(ucs-set-char #x5EDE ?$(HP=(B) ; C02-H-503D
(ucs-set-char #x5EDF ?$(CYY(B) ; KS0-C-5959
(ucs-set-char #x5EDF ?$(Gl[(B) ; C01-G-6C5B
(ucs-set-char #x5EDF ?$@I@(B) ; J78-@-4940
(ucs-set-char #x5EDF ?$BI@(B) ; J83-B-4940
(ucs-set-char #x5EE0 ?$(Cs_(B) ; KS0-C-735F
(ucs-set-char #x5EE0 ?$(Gl^(B) ; C01-G-6C5E
(ucs-set-char #x5EE0 ?$@>3(B) ; J78-@-3E33
(ucs-set-char #x5EE0 ?$B>3(B) ; J83-B-3E33
(ucs-set-char #x5EE1 ?$(HP>(B) ; C02-H-503E
(ucs-set-char #x5EE1 ?$@W'(B) ; J78-@-5727
(ucs-set-char #x5EE1 ?$BW'(B) ; J83-B-5727
(ucs-set-char #x5EE2 ?$(CxH(B) ; KS0-C-7848
(ucs-set-char #x5EE2 ?$(GlY(B) ; C01-G-6C59
(ucs-set-char #x5EE2 ?$@W&(B) ; J78-@-5726
(ucs-set-char #x5EE2 ?$BW&(B) ; J83-B-5726
(ucs-set-char #x5EE3 ?$(CNF(B) ; KS0-C-4E46
(ucs-set-char #x5EE3 ?$(Gl](B) ; C01-G-6C5D
(ucs-set-char #x5EE3 ?$@W"(B) ; J78-@-5722
(ucs-set-char #x5EE3 ?$BW"(B) ; J83-B-5722
(ucs-set-char #x5EE5 ?$(D<Z(B) ; J90-D-3C5A
(ucs-set-char #x5EE5 ?$(HV}(B) ; C02-H-567D
(ucs-set-char #x5EE6 ?$(HV{(B) ; C02-H-567B
(ucs-set-char #x5EE7 ?$(HVz(B) ; C02-H-567A
(ucs-set-char #x5EE8 ?$(HV|(B) ; C02-H-567C
(ucs-set-char #x5EE8 ?$@W((B) ; J78-@-5728
(ucs-set-char #x5EE8 ?$Ab](B) ; GB0-A-625D
(ucs-set-char #x5EE8 ?$BW((B) ; J83-B-5728
(ucs-set-char #x5EE9 ?$(HVy(B) ; C02-H-5679
(ucs-set-char #x5EE9 ?$@W)(B) ; J78-@-5729
(ucs-set-char #x5EE9 ?$BW)(B) ; J83-B-5729
(ucs-set-char #x5EEA ?$(IP\(B) ; C03-I-505C
(ucs-set-char #x5EEA ?$Ab^(B) ; GB0-A-625E
(ucs-set-char #x5EEB ?$(D<[(B) ; J90-D-3C5B
(ucs-set-char #x5EEB ?$(J[!(B) ; C04-J-5B21
(ucs-set-char #x5EEC ?$(CUf(B) ; KS0-C-5566
(ucs-set-char #x5EEC ?$(Gx3(B) ; C01-G-7833
(ucs-set-char #x5EEC ?$@W*(B) ; J78-@-572A
(ucs-set-char #x5EEC ?$BW*(B) ; J83-B-572A
(ucs-set-char #x5EEE ?$(Hhr(B) ; C02-H-6872
(ucs-set-char #x5EEF ?$(Hhs(B) ; C02-H-6873
(ucs-set-char #x5EF0 ?$(I\?(B) ; C03-I-5C3F
(ucs-set-char #x5EF0 ?$@W-(B) ; J78-@-572D
(ucs-set-char #x5EF0 ?$BW-(B) ; J83-B-572D
(ucs-set-char #x5EF1 ?$(HkY(B) ; C02-H-6B59
(ucs-set-char #x5EF1 ?$@W+(B) ; J78-@-572B
(ucs-set-char #x5EF1 ?$BW+(B) ; J83-B-572B
(ucs-set-char #x5EF2 ?$(HmM(B) ; C02-H-6D4D
(ucs-set-char #x5EF3 ?$(Ctf(B) ; KS0-C-7466
(ucs-set-char #x5EF3 ?$(G}"(B) ; C01-G-7D22
(ucs-set-char #x5EF3 ?$@W,(B) ; J78-@-572C
(ucs-set-char #x5EF3 ?$BW,(B) ; J83-B-572C
(ucs-set-char #x5EF4 ?$(I!?(B) ; C03-I-213F
(ucs-set-char #x5EF4 ?$@W.(B) ; J78-@-572E
(ucs-set-char #x5EF4 ?$A[H(B) ; GB0-A-5B48
(ucs-set-char #x5EF4 ?$BW.(B) ; J83-B-572E
(ucs-set-char #x5EF5 ?$(I#a(B) ; C03-I-2361
(ucs-set-char #x5EF6 ?$(CfE(B) ; KS0-C-6645
(ucs-set-char #x5EF6 ?$(GM7(B) ; C01-G-4D37
(ucs-set-char #x5EF6 ?$@1d(B) ; J78-@-3164
(ucs-set-char #x5EF6 ?$AQS(B) ; GB0-A-5153
(ucs-set-char #x5EF6 ?$B1d(B) ; J83-B-3164
(ucs-set-char #x5EF7 ?$(CoU(B) ; KS0-C-6F55
(ucs-set-char #x5EF7 ?$(GJ,(B) ; C01-G-4A2C
(ucs-set-char #x5EF7 ?$@Dn(B) ; J78-@-446E
(ucs-set-char #x5EF7 ?$AM"(B) ; GB0-A-4D22
(ucs-set-char #x5EF7 ?$BDn(B) ; J83-B-446E
(ucs-set-char #x5EF8 ?$(I(i(B) ; C03-I-2869
(ucs-set-char #x5EF8 ?$@W/(B) ; J78-@-572F
(ucs-set-char #x5EF8 ?$BW/(B) ; J83-B-572F
(ucs-set-char #x5EF9 ?$(I(k(B) ; C03-I-286B
(ucs-set-char #x5EFA ?$(CKo(B) ; KS0-C-4B6F
(ucs-set-char #x5EFA ?$(GPz(B) ; C01-G-507A
(ucs-set-char #x5EFA ?$@7z(B) ; J78-@-377A
(ucs-set-char #x5EFA ?$A=((B) ; GB0-A-3D28
(ucs-set-char #x5EFA ?$B7z(B) ; J83-B-377A
(ucs-set-char #x5EFB ?$(C|_(B) ; KS0-C-7C5F
(ucs-set-char #x5EFB ?$(I,L(B) ; C03-I-2C4C
(ucs-set-char #x5EFB ?$@2v(B) ; J78-@-3276
(ucs-set-char #x5EFB ?$B2v(B) ; J83-B-3276
(ucs-set-char #x5EFC ?$(I,K(B) ; C03-I-2C4B
(ucs-set-char #x5EFC ?$@G6(B) ; J78-@-4736
(ucs-set-char #x5EFC ?$BG6(B) ; J83-B-4736
(ucs-set-char #x5EFD ?$(I0n(B) ; C03-I-306E
(ucs-set-char #x5EFE ?$(GD\(B) ; C01-G-445C
(ucs-set-char #x5EFE ?$@W0(B) ; J78-@-5730
(ucs-set-char #x5EFE ?$A^C(B) ; GB0-A-5E43
(ucs-set-char #x5EFE ?$BW0(B) ; J83-B-5730
(ucs-set-char #x5EFF ?$(GE=(B) ; C01-G-453D
(ucs-set-char #x5EFF ?$@F{(B) ; J78-@-467B
(ucs-set-char #x5EFF ?$AX%(B) ; GB0-A-5825
(ucs-set-char #x5EFF ?$BF{(B) ; J83-B-467B
(ucs-set-char #x5F00 ?$(J!M(B) ; C04-J-214D
(ucs-set-char #x5F00 ?$A?*(B) ; GB0-A-3F2A
(ucs-set-char #x5F01 ?$(C\'(B) ; KS0-C-5C27
(ucs-set-char #x5F01 ?$(GFO(B) ; C01-G-464F
(ucs-set-char #x5F01 ?$@J[(B) ; J78-@-4A5B
(ucs-set-char #x5F01 ?$A[M(B) ; GB0-A-5B4D
(ucs-set-char #x5F01 ?$BJ[(B) ; J83-B-4A5B
(ucs-set-char #x5F02 ?$(D<\(B) ; J90-D-3C5C
(ucs-set-char #x5F02 ?$(H"=(B) ; C02-H-223D
(ucs-set-char #x5F02 ?$ARl(B) ; GB0-A-526C
(ucs-set-char #x5F03 ?$(I%o(B) ; C03-I-256F
(ucs-set-char #x5F03 ?$@W1(B) ; J78-@-5731
(ucs-set-char #x5F03 ?$AFz(B) ; GB0-A-467A
(ucs-set-char #x5F03 ?$BW1(B) ; J83-B-5731
(ucs-set-char #x5F04 ?$(CVg(B) ; KS0-C-5667
(ucs-set-char #x5F04 ?$(GJ-(B) ; C01-G-4A2D
(ucs-set-char #x5F04 ?$@O.(B) ; J78-@-4F2E
(ucs-set-char #x5F04 ?$AE*(B) ; GB0-A-452A
(ucs-set-char #x5F04 ?$BO.(B) ; J83-B-4F2E
(ucs-set-char #x5F05 ?$(H#r(B) ; C02-H-2372
(ucs-set-char #x5F06 ?$(D<](B) ; J90-D-3C5D
(ucs-set-char #x5F06 ?$(I(m(B) ; C03-I-286D
(ucs-set-char #x5F07 ?$(D<^(B) ; J90-D-3C5E
(ucs-set-char #x5F07 ?$(H*<(B) ; C02-H-2A3C
(ucs-set-char #x5F08 ?$(D<_(B) ; J90-D-3C5F
(ucs-set-char #x5F08 ?$(GP{(B) ; C01-G-507B
(ucs-set-char #x5F08 ?$A^D(B) ; GB0-A-5E44
(ucs-set-char #x5F09 ?$@W2(B) ; J78-@-5732
(ucs-set-char #x5F09 ?$BW2(B) ; J83-B-5732
(ucs-set-char #x5F0A ?$(CxI(B) ; KS0-C-7849
(ucs-set-char #x5F0A ?$(Ghb(B) ; C01-G-6862
(ucs-set-char #x5F0A ?$@J@(B) ; J78-@-4A40
(ucs-set-char #x5F0A ?$A1W(B) ; GB0-A-3157
(ucs-set-char #x5F0A ?$BJ@(B) ; J83-B-4A40
(ucs-set-char #x5F0B ?$(GD](B) ; C01-G-445D
(ucs-set-char #x5F0B ?$@W5(B) ; J78-@-5735
(ucs-set-char #x5F0B ?$A_.(B) ; GB0-A-5F2E
(ucs-set-char #x5F0B ?$BW5(B) ; J83-B-5735
(ucs-set-char #x5F0C ?$(I!d(B) ; C03-I-2164
(ucs-set-char #x5F0C ?$@P!(B) ; J78-@-5021
(ucs-set-char #x5F0C ?$BP!(B) ; J83-B-5021
(ucs-set-char #x5F0D ?$(I"I(B) ; C03-I-2249
(ucs-set-char #x5F0D ?$@P1(B) ; J78-@-5031
(ucs-set-char #x5F0D ?$BP1(B) ; J83-B-5031
(ucs-set-char #x5F0E ?$(D<`(B) ; J90-D-3C60
(ucs-set-char #x5F0E ?$(I#b(B) ; C03-I-2362
(ucs-set-char #x5F0F ?$(CcR(B) ; KS0-C-6352
(ucs-set-char #x5F0F ?$(GH"(B) ; C01-G-4822
(ucs-set-char #x5F0F ?$@<0(B) ; J78-@-3C30
(ucs-set-char #x5F0F ?$AJ=(B) ; GB0-A-4A3D
(ucs-set-char #x5F0F ?$B<0(B) ; J83-B-3C30
(ucs-set-char #x5F10 ?$@Fu(B) ; J78-@-4675
(ucs-set-char #x5F10 ?$BFu(B) ; J83-B-4675
(ucs-set-char #x5F11 ?$(Cc=(B) ; KS0-C-633D
(ucs-set-char #x5F11 ?$(I;B(B) ; C03-I-3B42
(ucs-set-char #x5F11 ?$@W6(B) ; J78-@-5736
(ucs-set-char #x5F11 ?$A_1(B) ; GB0-A-5F31
(ucs-set-char #x5F11 ?$BW6(B) ; J83-B-5736
(ucs-set-char #x5F12 ?$(Gco(B) ; C01-G-636F
(ucs-set-char #x5F13 ?$(COa(B) ; KS0-C-4F61
(ucs-set-char #x5F13 ?$(GD^(B) ; C01-G-445E
(ucs-set-char #x5F13 ?$@5](B) ; J78-@-355D
(ucs-set-char #x5F13 ?$A9-(B) ; GB0-A-392D
(ucs-set-char #x5F13 ?$B5](B) ; J83-B-355D
(ucs-set-char #x5F14 ?$(Cp@(B) ; KS0-C-7040
(ucs-set-char #x5F14 ?$(GE>(B) ; C01-G-453E
(ucs-set-char #x5F14 ?$@D$(B) ; J78-@-4424
(ucs-set-char #x5F14 ?$BD$(B) ; J83-B-4424
(ucs-set-char #x5F15 ?$(ClZ(B) ; KS0-C-6C5A
(ucs-set-char #x5F15 ?$(GE?(B) ; C01-G-453F
(ucs-set-char #x5F15 ?$@0z(B) ; J78-@-307A
(ucs-set-char #x5F15 ?$AR}(B) ; GB0-A-527D
(ucs-set-char #x5F15 ?$B0z(B) ; J83-B-307A
(ucs-set-char #x5F16 ?$@W7(B) ; J78-@-5737
(ucs-set-char #x5F16 ?$BW7(B) ; J83-B-5737
(ucs-set-char #x5F17 ?$(C]W(B) ; KS0-C-5D57
(ucs-set-char #x5F17 ?$(GFQ(B) ; C01-G-4651
(ucs-set-char #x5F17 ?$@J&(B) ; J78-@-4A26
(ucs-set-char #x5F17 ?$A8%(B) ; GB0-A-3825
(ucs-set-char #x5F17 ?$BJ&(B) ; J83-B-4A26
(ucs-set-char #x5F18 ?$(C{p(B) ; KS0-C-7B70
(ucs-set-char #x5F18 ?$(GFP(B) ; C01-G-4650
(ucs-set-char #x5F18 ?$@90(B) ; J78-@-3930
(ucs-set-char #x5F18 ?$A:k(B) ; GB0-A-3A6B
(ucs-set-char #x5F18 ?$B90(B) ; J83-B-3930
(ucs-set-char #x5F19 ?$(D<a(B) ; J90-D-3C61
(ucs-set-char #x5F19 ?$(J"k(B) ; C04-J-226B
(ucs-set-char #x5F1A ?$(H">(B) ; C02-H-223E
(ucs-set-char #x5F1B ?$(Cl,(B) ; KS0-C-6C2C
(ucs-set-char #x5F1B ?$(GH#(B) ; C01-G-4823
(ucs-set-char #x5F1B ?$@CP(B) ; J78-@-4350
(ucs-set-char #x5F1B ?$A3Z(B) ; GB0-A-335A
(ucs-set-char #x5F1B ?$BCP(B) ; J83-B-4350
(ucs-set-char #x5F1C ?$(D<b(B) ; J90-D-3C62
(ucs-set-char #x5F1C ?$(J"l(B) ; C04-J-226C
(ucs-set-char #x5F1D ?$(D<c(B) ; J90-D-3C63
(ucs-set-char #x5F1D ?$(H#s(B) ; C02-H-2373
(ucs-set-char #x5F1E ?$(I%q(B) ; C03-I-2571
(ucs-set-char #x5F1F ?$(Cp)(B) ; KS0-C-7029
(ucs-set-char #x5F1F ?$(GJ.(B) ; C01-G-4A2E
(ucs-set-char #x5F1F ?$@Do(B) ; J78-@-446F
(ucs-set-char #x5F1F ?$A5\(B) ; GB0-A-355C
(ucs-set-char #x5F1F ?$BDo(B) ; J83-B-446F
(ucs-set-char #x5F20 ?$AUE(B) ; GB0-A-5545
(ucs-set-char #x5F21 ?$(D<d(B) ; J90-D-3C64
(ucs-set-char #x5F21 ?$(I(n(B) ; C03-I-286E
(ucs-set-char #x5F22 ?$(D<e(B) ; J90-D-3C65
(ucs-set-char #x5F22 ?$(H&R(B) ; C02-H-2652
(ucs-set-char #x5F23 ?$(D<f(B) ; J90-D-3C66
(ucs-set-char #x5F23 ?$(H&S(B) ; C02-H-2653
(ucs-set-char #x5F24 ?$(D<g(B) ; J90-D-3C67
(ucs-set-char #x5F24 ?$(H&T(B) ; C02-H-2654
(ucs-set-char #x5F25 ?$(I(p(B) ; C03-I-2870
(ucs-set-char #x5F25 ?$@Lo(B) ; J78-@-4C6F
(ucs-set-char #x5F25 ?$ACV(B) ; GB0-A-4356
(ucs-set-char #x5F25 ?$BLo(B) ; J83-B-4C6F
(ucs-set-char #x5F26 ?$(CzW(B) ; KS0-C-7A57
(ucs-set-char #x5F26 ?$(GM8(B) ; C01-G-4D38
(ucs-set-char #x5F26 ?$@89(B) ; J78-@-3839
(ucs-set-char #x5F26 ?$AOR(B) ; GB0-A-4F52
(ucs-set-char #x5F26 ?$B89(B) ; J83-B-3839
(ucs-set-char #x5F27 ?$(C{A(B) ; KS0-C-7B41
(ucs-set-char #x5F27 ?$(GM9(B) ; C01-G-4D39
(ucs-set-char #x5F27 ?$@8L(B) ; J78-@-384C
(ucs-set-char #x5F27 ?$A;!(B) ; GB0-A-3B21
(ucs-set-char #x5F27 ?$B8L(B) ; J83-B-384C
(ucs-set-char #x5F28 ?$(D<h(B) ; J90-D-3C68
(ucs-set-char #x5F28 ?$(H&Q(B) ; C02-H-2651
(ucs-set-char #x5F29 ?$(CR@(B) ; KS0-C-5240
(ucs-set-char #x5F29 ?$(GM:(B) ; C01-G-4D3A
(ucs-set-char #x5F29 ?$@W8(B) ; J78-@-5738
(ucs-set-char #x5F29 ?$Aes(B) ; GB0-A-6573
(ucs-set-char #x5F29 ?$BW8(B) ; J83-B-5738
(ucs-set-char #x5F2A ?$Aer(B) ; GB0-A-6572
(ucs-set-char #x5F2B ?$(D<i(B) ; J90-D-3C69
(ucs-set-char #x5F2B ?$(J),(B) ; C04-J-292C
(ucs-set-char #x5F2C ?$(D<j(B) ; J90-D-3C6A
(ucs-set-char #x5F2C ?$(J,p(B) ; C04-J-2C70
(ucs-set-char #x5F2D ?$(GP|(B) ; C01-G-507C
(ucs-set-char #x5F2D ?$@W9(B) ; J78-@-5739
(ucs-set-char #x5F2D ?$Aet(B) ; GB0-A-6574
(ucs-set-char #x5F2D ?$BW9(B) ; J83-B-5739
(ucs-set-char #x5F2E ?$(D<k(B) ; J90-D-3C6B
(ucs-set-char #x5F2E ?$(H*=(B) ; C02-H-2A3D
(ucs-set-char #x5F2F ?$(I,M(B) ; C03-I-2C4D
(ucs-set-char #x5F2F ?$@W?(B) ; J78-@-573F
(ucs-set-char #x5F2F ?$AMd(B) ; GB0-A-4D64
(ucs-set-char #x5F2F ?$BW?(B) ; J83-B-573F
(ucs-set-char #x5F30 ?$(D<l(B) ; J90-D-3C6C
(ucs-set-char #x5F30 ?$(H.|(B) ; C02-H-2E7C
(ucs-set-char #x5F31 ?$(Ce0(B) ; KS0-C-6530
(ucs-set-char #x5F31 ?$(GU>(B) ; C01-G-553E
(ucs-set-char #x5F31 ?$@<e(B) ; J78-@-3C65
(ucs-set-char #x5F31 ?$AHu(B) ; GB0-A-4875
(ucs-set-char #x5F31 ?$B<e(B) ; J83-B-3C65
(ucs-set-char #x5F32 ?$(I0o(B) ; C03-I-306F
(ucs-set-char #x5F33 ?$(H.{(B) ; C02-H-2E7B
(ucs-set-char #x5F34 ?$(D<m(B) ; J90-D-3C6D
(ucs-set-char #x5F34 ?$(I5b(B) ; C03-I-3562
(ucs-set-char #x5F35 ?$(Cme(B) ; KS0-C-6D65
(ucs-set-char #x5F35 ?$(GZ/(B) ; C01-G-5A2F
(ucs-set-char #x5F35 ?$@D%(B) ; J78-@-4425
(ucs-set-char #x5F35 ?$BD%(B) ; J83-B-4425
(ucs-set-char #x5F36 ?$(D<n(B) ; J90-D-3C6E
(ucs-set-char #x5F36 ?$(H50(B) ; C02-H-3530
(ucs-set-char #x5F37 ?$(GZ0(B) ; C01-G-5A30
(ucs-set-char #x5F37 ?$@6/(B) ; J78-@-362F
(ucs-set-char #x5F37 ?$B6/(B) ; J83-B-362F
(ucs-set-char #x5F38 ?$(H51(B) ; C02-H-3531
(ucs-set-char #x5F38 ?$@W:(B) ; J78-@-573A
(ucs-set-char #x5F38 ?$BW:(B) ; J83-B-573A
(ucs-set-char #x5F39 ?$(I5c(B) ; C03-I-3563
(ucs-set-char #x5F39 ?$A5/(B) ; GB0-A-352F
(ucs-set-char #x5F3A ?$(CK-(B) ; KS0-C-4B2D
(ucs-set-char #x5F3A ?$(I;G(B) ; C03-I-3B47
(ucs-set-char #x5F3A ?$AG?(B) ; GB0-A-473F
(ucs-set-char #x5F3B ?$(D<o(B) ; J90-D-3C6F
(ucs-set-char #x5F3B ?$(I;E(B) ; C03-I-3B45
(ucs-set-char #x5F3C ?$(Cy0(B) ; KS0-C-7930
(ucs-set-char #x5F3C ?$(G_$(B) ; C01-G-5F24
(ucs-set-char #x5F3C ?$@I+(B) ; J78-@-492B
(ucs-set-char #x5F3C ?$Aev(B) ; GB0-A-6576
(ucs-set-char #x5F3C ?$BI+(B) ; J83-B-492B
(ucs-set-char #x5F3D ?$(D<p(B) ; J90-D-3C70
(ucs-set-char #x5F3D ?$(J7E(B) ; C04-J-3745
(ucs-set-char #x5F3E ?$(I;D(B) ; C03-I-3B44
(ucs-set-char #x5F3E ?$@CF(B) ; J78-@-4346
(ucs-set-char #x5F3E ?$BCF(B) ; J83-B-4346
(ucs-set-char #x5F3F ?$(D<q(B) ; J90-D-3C71
(ucs-set-char #x5F3F ?$(J=0(B) ; C04-J-3D30
(ucs-set-char #x5F40 ?$(D<r(B) ; J90-D-3C72
(ucs-set-char #x5F40 ?$(HBh(B) ; C02-H-4268
(ucs-set-char #x5F40 ?$Al0(B) ; GB0-A-6C30
(ucs-set-char #x5F41 ?$@W;(B) ; J78-@-573B
(ucs-set-char #x5F41 ?$BW;(B) ; J83-B-573B
(ucs-set-char #x5F42 ?$(IA"(B) ; C03-I-4122
(ucs-set-char #x5F43 ?$(HJ&(B) ; C02-H-4A26
(ucs-set-char #x5F44 ?$(D<s(B) ; J90-D-3C73
(ucs-set-char #x5F44 ?$(HJ%(B) ; C02-H-4A25
(ucs-set-char #x5F45 ?$(D<t(B) ; J90-D-3C74
(ucs-set-char #x5F46 ?$(Ghc(B) ; C01-G-6863
(ucs-set-char #x5F47 ?$(D<u(B) ; J90-D-3C75
(ucs-set-char #x5F47 ?$(JI^(B) ; C04-J-495E
(ucs-set-char #x5F48 ?$(Cw%(B) ; KS0-C-7725
(ucs-set-char #x5F48 ?$(Gl_(B) ; C01-G-6C5F
(ucs-set-char #x5F48 ?$@W<(B) ; J78-@-573C
(ucs-set-char #x5F48 ?$BW<(B) ; J83-B-573C
(ucs-set-char #x5F49 ?$(HP?(B) ; C02-H-503F
(ucs-set-char #x5F4A ?$(CK.(B) ; KS0-C-4B2E
(ucs-set-char #x5F4A ?$(GpS(B) ; C01-G-7053
(ucs-set-char #x5F4A ?$@60(B) ; J78-@-3630
(ucs-set-char #x5F4A ?$B60(B) ; J83-B-3630
(ucs-set-char #x5F4B ?$(HV~(B) ; C02-H-567E
(ucs-set-char #x5F4C ?$(CZ/(B) ; KS0-C-5A2F
(ucs-set-char #x5F4C ?$(GsZ(B) ; C01-G-735A
(ucs-set-char #x5F4C ?$@W=(B) ; J78-@-573D
(ucs-set-char #x5F4C ?$BW=(B) ; J83-B-573D
(ucs-set-char #x5F4D ?$(D<v(B) ; J90-D-3C76
(ucs-set-char #x5F4D ?$(IWc(B) ; C03-I-5763
(ucs-set-char #x5F4E ?$(CX6(B) ; KS0-C-5836
(ucs-set-char #x5F4E ?$(G{_(B) ; C01-G-7B5F
(ucs-set-char #x5F4E ?$@W>(B) ; J78-@-573E
(ucs-set-char #x5F4E ?$BW>(B) ; J83-B-573E
(ucs-set-char #x5F4F ?$(Ho'(B) ; C02-H-6F27
(ucs-set-char #x5F50 ?$(D<w(B) ; J90-D-3C77
(ucs-set-char #x5F50 ?$(I!@(B) ; C03-I-2140
(ucs-set-char #x5F50 ?$Aef(B) ; GB0-A-6566
(ucs-set-char #x5F51 ?$(I!A(B) ; C03-I-2141
(ucs-set-char #x5F51 ?$@W@(B) ; J78-@-5740
(ucs-set-char #x5F51 ?$BW@(B) ; J83-B-5740
(ucs-set-char #x5F52 ?$(I"J(B) ; C03-I-224A
(ucs-set-char #x5F52 ?$A9i(B) ; GB0-A-3969
(ucs-set-char #x5F53 ?$(I#Q(B) ; C03-I-2351
(ucs-set-char #x5F53 ?$@Ev(B) ; J78-@-4576
(ucs-set-char #x5F53 ?$A51(B) ; GB0-A-3531
(ucs-set-char #x5F53 ?$BEv(B) ; J83-B-4576
(ucs-set-char #x5F54 ?$(D<x(B) ; J90-D-3C78
(ucs-set-char #x5F54 ?$(H&U(B) ; C02-H-2655
(ucs-set-char #x5F55 ?$(I(q(B) ; C03-I-2871
(ucs-set-char #x5F55 ?$AB<(B) ; GB0-A-423C
(ucs-set-char #x5F56 ?$(CS'(B) ; KS0-C-5327
(ucs-set-char #x5F56 ?$(H*>(B) ; C02-H-2A3E
(ucs-set-char #x5F56 ?$@WA(B) ; J78-@-5741
(ucs-set-char #x5F56 ?$Aeh(B) ; GB0-A-6568
(ucs-set-char #x5F56 ?$BWA(B) ; J83-B-5741
(ucs-set-char #x5F57 ?$(C{2(B) ; KS0-C-7B32
(ucs-set-char #x5F57 ?$(GZ1(B) ; C01-G-5A31
(ucs-set-char #x5F57 ?$@WB(B) ; J78-@-5742
(ucs-set-char #x5F57 ?$Aeg(B) ; GB0-A-6567
(ucs-set-char #x5F57 ?$BWB(B) ; J83-B-5742
(ucs-set-char #x5F58 ?$(D<y(B) ; J90-D-3C79
(ucs-set-char #x5F58 ?$(H;X(B) ; C02-H-3B58
(ucs-set-char #x5F58 ?$Aei(B) ; GB0-A-6569
(ucs-set-char #x5F59 ?$(C}D(B) ; KS0-C-7D44
(ucs-set-char #x5F59 ?$(Gcp(B) ; C01-G-6370
(ucs-set-char #x5F59 ?$@WC(B) ; J78-@-5743
(ucs-set-char #x5F59 ?$BWC(B) ; J83-B-5743
(ucs-set-char #x5F5A ?$(IA#(B) ; C03-I-4123
(ucs-set-char #x5F5B ?$(Cl-(B) ; KS0-C-6C2D
(ucs-set-char #x5F5B ?$(D<z(B) ; J90-D-3C7A
(ucs-set-char #x5F5B ?$(IP^(B) ; C03-I-505E
(ucs-set-char #x5F5C ?$@W4(B) ; J78-@-5734
(ucs-set-char #x5F5C ?$BW4(B) ; J83-B-5734
(ucs-set-char #x5F5D ?$(IWd(B) ; C03-I-5764
(ucs-set-char #x5F5D ?$@W3(B) ; J78-@-5733
(ucs-set-char #x5F5D ?$ARM(B) ; GB0-A-524D
(ucs-set-char #x5F5D ?$BW3(B) ; J83-B-5733
(ucs-set-char #x5F5E ?$(GvA(B) ; C01-G-7641
(ucs-set-char #x5F60 ?$(D<{(B) ; J90-D-3C7B
(ucs-set-char #x5F60 ?$(Iad(B) ; C03-I-6164
(ucs-set-char #x5F61 ?$(I!B(B) ; C03-I-2142
(ucs-set-char #x5F61 ?$@WD(B) ; J78-@-5744
(ucs-set-char #x5F61 ?$Aaj(B) ; GB0-A-616A
(ucs-set-char #x5F61 ?$BWD(B) ; J83-B-5744
(ucs-set-char #x5F62 ?$(C{!(B) ; KS0-C-7B21
(ucs-set-char #x5F62 ?$(GJ0(B) ; C01-G-4A30
(ucs-set-char #x5F62 ?$@7A(B) ; J78-@-3741
(ucs-set-char #x5F62 ?$APN(B) ; GB0-A-504E
(ucs-set-char #x5F62 ?$B7A(B) ; J83-B-3741
(ucs-set-char #x5F63 ?$(D<|(B) ; J90-D-3C7C
(ucs-set-char #x5F63 ?$(I%r(B) ; C03-I-2572
(ucs-set-char #x5F64 ?$(D<}(B) ; J90-D-3C7D
(ucs-set-char #x5F64 ?$(GJ/(B) ; C01-G-4A2F
(ucs-set-char #x5F64 ?$AM.(B) ; GB0-A-4D2E
(ucs-set-char #x5F65 ?$(GP}(B) ; C01-G-507D
(ucs-set-char #x5F66 ?$(Cei(B) ; KS0-C-6569
(ucs-set-char #x5F66 ?$(I,P(B) ; C03-I-2C50
(ucs-set-char #x5F66 ?$@I'(B) ; J78-@-4927
(ucs-set-char #x5F66 ?$AQe(B) ; GB0-A-5165
(ucs-set-char #x5F66 ?$BI'(B) ; J83-B-4927
(ucs-set-char #x5F67 ?$(Cin(B) ; KS0-C-696E
(ucs-set-char #x5F67 ?$(D<~(B) ; J90-D-3C7E
(ucs-set-char #x5F67 ?$(H.}(B) ; C02-H-2E7D
(ucs-set-char #x5F69 ?$(Cst(B) ; KS0-C-7374
(ucs-set-char #x5F69 ?$(GZ3(B) ; C01-G-5A33
(ucs-set-char #x5F69 ?$@:L(B) ; J78-@-3A4C
(ucs-set-char #x5F69 ?$A2J(B) ; GB0-A-324A
(ucs-set-char #x5F69 ?$B:L(B) ; J83-B-3A4C
(ucs-set-char #x5F6A ?$(Cxs(B) ; KS0-C-7873
(ucs-set-char #x5F6A ?$(G])(B) ; C01-G-5D29
(ucs-set-char #x5F6A ?$@I7(B) ; J78-@-4937
(ucs-set-char #x5F6A ?$A1k(B) ; GB0-A-316B
(ucs-set-char #x5F6A ?$BI7(B) ; J83-B-4937
(ucs-set-char #x5F6B ?$(CpA(B) ; KS0-C-7041
(ucs-set-char #x5F6B ?$(GZ4(B) ; C01-G-5A34
(ucs-set-char #x5F6B ?$@D&(B) ; J78-@-4426
(ucs-set-char #x5F6B ?$BD&(B) ; J83-B-4426
(ucs-set-char #x5F6C ?$(C^/(B) ; KS0-C-5E2F
(ucs-set-char #x5F6C ?$(GZ2(B) ; C01-G-5A32
(ucs-set-char #x5F6C ?$@IK(B) ; J78-@-494B
(ucs-set-char #x5F6C ?$A1r(B) ; GB0-A-3172
(ucs-set-char #x5F6C ?$BIK(B) ; J83-B-494B
(ucs-set-char #x5F6D ?$(Cx0(B) ; KS0-C-7830
(ucs-set-char #x5F6D ?$(G_%(B) ; C01-G-5F25
(ucs-set-char #x5F6D ?$@WE(B) ; J78-@-5745
(ucs-set-char #x5F6D ?$AEm(B) ; GB0-A-456D
(ucs-set-char #x5F6D ?$BWE(B) ; J83-B-5745
(ucs-set-char #x5F6E ?$(IA$(B) ; C03-I-4124
(ucs-set-char #x5F6F ?$(D=!(B) ; J90-D-3D21
(ucs-set-char #x5F6F ?$(HJ'(B) ; C02-H-4A27
(ucs-set-char #x5F70 ?$(Cs`(B) ; KS0-C-7360
(ucs-set-char #x5F70 ?$(Ghd(B) ; C01-G-6864
(ucs-set-char #x5F70 ?$@>4(B) ; J78-@-3E34
(ucs-set-char #x5F70 ?$AUC(B) ; GB0-A-5543
(ucs-set-char #x5F70 ?$B>4(B) ; J83-B-3E34
(ucs-set-char #x5F71 ?$(Cg/(B) ; KS0-C-672F
(ucs-set-char #x5F71 ?$(Gl`(B) ; C01-G-6C60
(ucs-set-char #x5F71 ?$@1F(B) ; J78-@-3146
(ucs-set-char #x5F71 ?$AS0(B) ; GB0-A-5330
(ucs-set-char #x5F71 ?$B1F(B) ; J83-B-3146
(ucs-set-char #x5F72 ?$(D="(B) ; J90-D-3D22
(ucs-set-char #x5F72 ?$(I_E(B) ; C03-I-5F45
(ucs-set-char #x5F73 ?$(H!,(B) ; C02-H-212C
(ucs-set-char #x5F73 ?$@WF(B) ; J78-@-5746
(ucs-set-char #x5F73 ?$Aa\(B) ; GB0-A-615C
(ucs-set-char #x5F73 ?$BWF(B) ; J83-B-5746
(ucs-set-char #x5F74 ?$(D=#(B) ; J90-D-3D23
(ucs-set-char #x5F74 ?$(H"?(B) ; C02-H-223F
(ucs-set-char #x5F75 ?$(D=$(B) ; J90-D-3D24
(ucs-set-char #x5F75 ?$(J"m(B) ; C04-J-226D
(ucs-set-char #x5F76 ?$(H#u(B) ; C02-H-2375
(ucs-set-char #x5F77 ?$(C[-(B) ; KS0-C-5B2D
(ucs-set-char #x5F77 ?$(GJ1(B) ; C01-G-4A31
(ucs-set-char #x5F77 ?$@WG(B) ; J78-@-5747
(ucs-set-char #x5F77 ?$Aa](B) ; GB0-A-615D
(ucs-set-char #x5F77 ?$BWG(B) ; J83-B-5747
(ucs-set-char #x5F78 ?$(D=%(B) ; J90-D-3D25
(ucs-set-char #x5F78 ?$(H#t(B) ; C02-H-2374
(ucs-set-char #x5F79 ?$(Cf5(B) ; KS0-C-6635
(ucs-set-char #x5F79 ?$(GJ2(B) ; C01-G-4A32
(ucs-set-char #x5F79 ?$@Lr(B) ; J78-@-4C72
(ucs-set-char #x5F79 ?$AR[(B) ; GB0-A-525B
(ucs-set-char #x5F79 ?$BLr(B) ; J83-B-4C72
(ucs-set-char #x5F7A ?$(D=&(B) ; J90-D-3D26
(ucs-set-char #x5F7A ?$(J$,(B) ; C04-J-242C
(ucs-set-char #x5F7B ?$A39(B) ; GB0-A-3339
(ucs-set-char #x5F7C ?$(Cy((B) ; KS0-C-7928
(ucs-set-char #x5F7C ?$(GM>(B) ; C01-G-4D3E
(ucs-set-char #x5F7C ?$@H`(B) ; J78-@-4860
(ucs-set-char #x5F7C ?$A1K(B) ; GB0-A-314B
(ucs-set-char #x5F7C ?$BH`(B) ; J83-B-4860
(ucs-set-char #x5F7D ?$(D='(B) ; J90-D-3D27
(ucs-set-char #x5F7D ?$(H&X(B) ; C02-H-2658
(ucs-set-char #x5F7E ?$(D=((B) ; J90-D-3D28
(ucs-set-char #x5F7E ?$(H&W(B) ; C02-H-2657
(ucs-set-char #x5F7F ?$(C]X(B) ; KS0-C-5D58
(ucs-set-char #x5F7F ?$(GM=(B) ; C01-G-4D3D
(ucs-set-char #x5F7F ?$@WJ(B) ; J78-@-574A
(ucs-set-char #x5F7F ?$BWJ(B) ; J83-B-574A
(ucs-set-char #x5F80 ?$(ChY(B) ; KS0-C-6859
(ucs-set-char #x5F80 ?$(GM;(B) ; C01-G-4D3B
(ucs-set-char #x5F80 ?$@1}(B) ; J78-@-317D
(ucs-set-char #x5F80 ?$AMy(B) ; GB0-A-4D79
(ucs-set-char #x5F80 ?$B1}(B) ; J83-B-317D
(ucs-set-char #x5F81 ?$(CoV(B) ; KS0-C-6F56
(ucs-set-char #x5F81 ?$(GM<(B) ; C01-G-4D3C
(ucs-set-char #x5F81 ?$@@,(B) ; J78-@-402C
(ucs-set-char #x5F81 ?$AUw(B) ; GB0-A-5577
(ucs-set-char #x5F81 ?$B@,(B) ; J83-B-402C
(ucs-set-char #x5F82 ?$(H&V(B) ; C02-H-2656
(ucs-set-char #x5F82 ?$@WI(B) ; J78-@-5749
(ucs-set-char #x5F82 ?$Aa^(B) ; GB0-A-615E
(ucs-set-char #x5F82 ?$BWI(B) ; J83-B-5749
(ucs-set-char #x5F83 ?$(I(v(B) ; C03-I-2876
(ucs-set-char #x5F83 ?$@WH(B) ; J78-@-5748
(ucs-set-char #x5F83 ?$BWH(B) ; J83-B-5748
(ucs-set-char #x5F84 ?$(I(u(B) ; C03-I-2875
(ucs-set-char #x5F84 ?$@7B(B) ; J78-@-3742
(ucs-set-char #x5F84 ?$A>6(B) ; GB0-A-3E36
(ucs-set-char #x5F84 ?$B7B(B) ; J83-B-3742
(ucs-set-char #x5F85 ?$(CSb(B) ; KS0-C-5362
(ucs-set-char #x5F85 ?$(GQ!(B) ; C01-G-5121
(ucs-set-char #x5F85 ?$@BT(B) ; J78-@-4254
(ucs-set-char #x5F85 ?$A4}(B) ; GB0-A-347D
(ucs-set-char #x5F85 ?$BBT(B) ; J83-B-4254
(ucs-set-char #x5F86 ?$(H*?(B) ; C02-H-2A3F
(ucs-set-char #x5F87 ?$(Cb_(B) ; KS0-C-625F
(ucs-set-char #x5F87 ?$(GQ$(B) ; C01-G-5124
(ucs-set-char #x5F87 ?$@WN(B) ; J78-@-574E
(ucs-set-char #x5F87 ?$Aa_(B) ; GB0-A-615F
(ucs-set-char #x5F87 ?$BWN(B) ; J83-B-574E
(ucs-set-char #x5F88 ?$(GP~(B) ; C01-G-507E
(ucs-set-char #x5F88 ?$@WL(B) ; J78-@-574C
(ucs-set-char #x5F88 ?$A:\(B) ; GB0-A-3A5C
(ucs-set-char #x5F88 ?$BWL(B) ; J83-B-574C
(ucs-set-char #x5F89 ?$(D=)(B) ; J90-D-3D29
(ucs-set-char #x5F89 ?$(GQ&(B) ; C01-G-5126
(ucs-set-char #x5F89 ?$Aa`(B) ; GB0-A-6160
(ucs-set-char #x5F8A ?$(C|`(B) ; KS0-C-7C60
(ucs-set-char #x5F8A ?$(GQ"(B) ; C01-G-5122
(ucs-set-char #x5F8A ?$@WK(B) ; J78-@-574B
(ucs-set-char #x5F8A ?$A;2(B) ; GB0-A-3B32
(ucs-set-char #x5F8A ?$BWK(B) ; J83-B-574B
(ucs-set-char #x5F8B ?$(CWH(B) ; KS0-C-5748
(ucs-set-char #x5F8B ?$(GQ#(B) ; C01-G-5123
(ucs-set-char #x5F8B ?$@N'(B) ; J78-@-4E27
(ucs-set-char #x5F8B ?$ABI(B) ; GB0-A-4249
(ucs-set-char #x5F8B ?$BN'(B) ; J83-B-4E27
(ucs-set-char #x5F8C ?$(C}-(B) ; KS0-C-7D2D
(ucs-set-char #x5F8C ?$(GQ%(B) ; C01-G-5125
(ucs-set-char #x5F8C ?$@8e(B) ; J78-@-3865
(ucs-set-char #x5F8C ?$Aaa(B) ; GB0-A-6161
(ucs-set-char #x5F8C ?$B8e(B) ; J83-B-3865
(ucs-set-char #x5F8D ?$(D=*(B) ; J90-D-3D2A
(ucs-set-char #x5F8D ?$(J)1(B) ; C04-J-2931
(ucs-set-char #x5F8E ?$(I0p(B) ; C03-I-3070
(ucs-set-char #x5F8F ?$(D=+(B) ; J90-D-3D2B
(ucs-set-char #x5F8F ?$(I0r(B) ; C03-I-3072
(ucs-set-char #x5F90 ?$(C_o(B) ; KS0-C-5F6F
(ucs-set-char #x5F90 ?$(GUA(B) ; C01-G-5541
(ucs-set-char #x5F90 ?$@=y(B) ; J78-@-3D79
(ucs-set-char #x5F90 ?$APl(B) ; GB0-A-506C
(ucs-set-char #x5F90 ?$B=y(B) ; J83-B-3D79
(ucs-set-char #x5F91 ?$(CLS(B) ; KS0-C-4C53
(ucs-set-char #x5F91 ?$(GU@(B) ; C01-G-5540
(ucs-set-char #x5F91 ?$@WM(B) ; J78-@-574D
(ucs-set-char #x5F91 ?$BWM(B) ; J83-B-574D
(ucs-set-char #x5F92 ?$(CSy(B) ; KS0-C-5379
(ucs-set-char #x5F92 ?$(GU?(B) ; C01-G-553F
(ucs-set-char #x5F92 ?$@EL(B) ; J78-@-454C
(ucs-set-char #x5F92 ?$AM=(B) ; GB0-A-4D3D
(ucs-set-char #x5F92 ?$BEL(B) ; J83-B-454C
(ucs-set-char #x5F93 ?$(I0q(B) ; C03-I-3071
(ucs-set-char #x5F93 ?$@=>(B) ; J78-@-3D3E
(ucs-set-char #x5F93 ?$B=>(B) ; J83-B-3D3E
(ucs-set-char #x5F95 ?$Aab(B) ; GB0-A-6162
(ucs-set-char #x5F96 ?$(D=,(B) ; J90-D-3D2C
(ucs-set-char #x5F96 ?$(H53(B) ; C02-H-3533
(ucs-set-char #x5F97 ?$(CTp(B) ; KS0-C-5470
(ucs-set-char #x5F97 ?$(GZ5(B) ; C01-G-5A35
(ucs-set-char #x5F97 ?$@F@(B) ; J78-@-4640
(ucs-set-char #x5F97 ?$A5C(B) ; GB0-A-3543
(ucs-set-char #x5F97 ?$BF@(B) ; J83-B-4640
(ucs-set-char #x5F98 ?$(C[G(B) ; KS0-C-5B47
(ucs-set-char #x5F98 ?$(GZ8(B) ; C01-G-5A38
(ucs-set-char #x5F98 ?$@WQ(B) ; J78-@-5751
(ucs-set-char #x5F98 ?$AEG(B) ; GB0-A-4547
(ucs-set-char #x5F98 ?$BWQ(B) ; J83-B-5751
(ucs-set-char #x5F99 ?$(C^U(B) ; KS0-C-5E55
(ucs-set-char #x5F99 ?$(GZ6(B) ; C01-G-5A36
(ucs-set-char #x5F99 ?$@WP(B) ; J78-@-5750
(ucs-set-char #x5F99 ?$Aac(B) ; GB0-A-6163
(ucs-set-char #x5F99 ?$BWP(B) ; J83-B-5750
(ucs-set-char #x5F9B ?$(H52(B) ; C02-H-3532
(ucs-set-char #x5F9C ?$(D=-(B) ; J90-D-3D2D
(ucs-set-char #x5F9C ?$(GZ;(B) ; C01-G-5A3B
(ucs-set-char #x5F9C ?$Aad(B) ; GB0-A-6164
(ucs-set-char #x5F9D ?$(D=.(B) ; J90-D-3D2E
(ucs-set-char #x5F9D ?$(J1S(B) ; C04-J-3153
(ucs-set-char #x5F9E ?$(Cpt(B) ; KS0-C-7074
(ucs-set-char #x5F9E ?$(GZ7(B) ; C01-G-5A37
(ucs-set-char #x5F9E ?$@WO(B) ; J78-@-574F
(ucs-set-char #x5F9E ?$BWO(B) ; J83-B-574F
(ucs-set-char #x5F9F ?$(H54(B) ; C02-H-3534
(ucs-set-char #x5FA0 ?$(CUP(B) ; KS0-C-5550
(ucs-set-char #x5FA0 ?$(GZ:(B) ; C01-G-5A3A
(ucs-set-char #x5FA0 ?$@WR(B) ; J78-@-5752
(ucs-set-char #x5FA0 ?$BWR(B) ; J83-B-5752
(ucs-set-char #x5FA1 ?$(CeY(B) ; KS0-C-6559
(ucs-set-char #x5FA1 ?$(GZ9(B) ; C01-G-5A39
(ucs-set-char #x5FA1 ?$@8f(B) ; J78-@-3866
(ucs-set-char #x5FA1 ?$ASy(B) ; GB0-A-5379
(ucs-set-char #x5FA1 ?$B8f(B) ; J83-B-3866
(ucs-set-char #x5FA2 ?$(D=/(B) ; J90-D-3D2F
(ucs-set-char #x5FA2 ?$(J1R(B) ; C04-J-3152
(ucs-set-char #x5FA3 ?$(J1W(B) ; C04-J-3157
(ucs-set-char #x5FA4 ?$(D=2(B) ; J90-D-3D32
(ucs-set-char #x5FA4 ?$(J7J(B) ; C04-J-374A
(ucs-set-char #x5FA5 ?$(H;Z(B) ; C02-H-3B5A
(ucs-set-char #x5FA6 ?$(H;Y(B) ; C02-H-3B59
(ucs-set-char #x5FA7 ?$(D=0(B) ; J90-D-3D30
(ucs-set-char #x5FA7 ?$(I;K(B) ; C03-I-3B4B
(ucs-set-char #x5FA8 ?$(C|G(B) ; KS0-C-7C47
(ucs-set-char #x5FA8 ?$(G_((B) ; C01-G-5F28
(ucs-set-char #x5FA8 ?$@WS(B) ; J78-@-5753
(ucs-set-char #x5FA8 ?$Aae(B) ; GB0-A-6165
(ucs-set-char #x5FA8 ?$BWS(B) ; J83-B-5753
(ucs-set-char #x5FA9 ?$(C\V(B) ; KS0-C-5C56
(ucs-set-char #x5FA9 ?$(G_&(B) ; C01-G-5F26
(ucs-set-char #x5FA9 ?$@I|(B) ; J78-@-497C
(ucs-set-char #x5FA9 ?$BI|(B) ; J83-B-497C
(ucs-set-char #x5FAA ?$(Cb`(B) ; KS0-C-6260
(ucs-set-char #x5FAA ?$(G_'(B) ; C01-G-5F27
(ucs-set-char #x5FAA ?$@=[(B) ; J78-@-3D5B
(ucs-set-char #x5FAA ?$AQ-(B) ; GB0-A-512D
(ucs-set-char #x5FAA ?$B=[(B) ; J83-B-3D5B
(ucs-set-char #x5FAB ?$(D=1(B) ; J90-D-3D31
(ucs-set-char #x5FAB ?$(H;[(B) ; C02-H-3B5B
(ucs-set-char #x5FAC ?$(D=3(B) ; J90-D-3D33
(ucs-set-char #x5FAC ?$(Gcq(B) ; C01-G-6371
(ucs-set-char #x5FAD ?$(HBj(B) ; C02-H-426A
(ucs-set-char #x5FAD ?$@WT(B) ; J78-@-5754
(ucs-set-char #x5FAD ?$Aaf(B) ; GB0-A-6166
(ucs-set-char #x5FAD ?$BWT(B) ; J83-B-5754
(ucs-set-char #x5FAE ?$(CZ0(B) ; KS0-C-5A30
(ucs-set-char #x5FAE ?$(Gcr(B) ; C01-G-6372
(ucs-set-char #x5FAE ?$@Hy(B) ; J78-@-4879
(ucs-set-char #x5FAE ?$AN"(B) ; GB0-A-4E22
(ucs-set-char #x5FAE ?$BHy(B) ; J83-B-4879
(ucs-set-char #x5FAF ?$(D=4(B) ; J90-D-3D34
(ucs-set-char #x5FAF ?$(HBi(B) ; C02-H-4269
(ucs-set-char #x5FB0 ?$(D=5(B) ; J90-D-3D35
(ucs-set-char #x5FB0 ?$(J=4(B) ; C04-J-3D34
(ucs-set-char #x5FB1 ?$(D=6(B) ; J90-D-3D36
(ucs-set-char #x5FB1 ?$(JC?(B) ; C04-J-433F
(ucs-set-char #x5FB2 ?$(HP@(B) ; C02-H-5040
(ucs-set-char #x5FB3 ?$(IFc(B) ; C03-I-4663
(ucs-set-char #x5FB3 ?$@FA(B) ; J78-@-4641
(ucs-set-char #x5FB3 ?$BFA(B) ; J83-B-4641
(ucs-set-char #x5FB4 ?$(IFd(B) ; C03-I-4664
(ucs-set-char #x5FB4 ?$@D'(B) ; J78-@-4427
(ucs-set-char #x5FB4 ?$BD'(B) ; J83-B-4427
(ucs-set-char #x5FB5 ?$(Cs#(B) ; KS0-C-7323
(ucs-set-char #x5FB5 ?$(Glb(B) ; C01-G-6C62
(ucs-set-char #x5FB5 ?$Aag(B) ; GB0-A-6167
(ucs-set-char #x5FB6 ?$(HJ((B) ; C02-H-4A28
(ucs-set-char #x5FB7 ?$(CSl(B) ; KS0-C-536C
(ucs-set-char #x5FB7 ?$(Gla(B) ; C01-G-6C61
(ucs-set-char #x5FB7 ?$A5B(B) ; GB0-A-3542
(ucs-set-char #x5FB8 ?$(D=7(B) ; J90-D-3D37
(ucs-set-char #x5FB8 ?$(IKr(B) ; C03-I-4B72
(ucs-set-char #x5FB9 ?$(CtK(B) ; KS0-C-744B
(ucs-set-char #x5FB9 ?$(Ghe(B) ; C01-G-6865
(ucs-set-char #x5FB9 ?$@E0(B) ; J78-@-4530
(ucs-set-char #x5FB9 ?$BE0(B) ; J83-B-4530
(ucs-set-char #x5FBB ?$(HW"(B) ; C02-H-5722
(ucs-set-char #x5FBC ?$(HW!(B) ; C02-H-5721
(ucs-set-char #x5FBC ?$@WU(B) ; J78-@-5755
(ucs-set-char #x5FBC ?$Aah(B) ; GB0-A-6168
(ucs-set-char #x5FBC ?$BWU(B) ; J83-B-5755
(ucs-set-char #x5FBD ?$(C}E(B) ; KS0-C-7D45
(ucs-set-char #x5FBD ?$(Gs[(B) ; C01-G-735B
(ucs-set-char #x5FBD ?$@5+(B) ; J78-@-352B
(ucs-set-char #x5FBD ?$A;U(B) ; GB0-A-3B55
(ucs-set-char #x5FBD ?$B5+(B) ; J83-B-352B
(ucs-set-char #x5FBE ?$(H\i(B) ; C02-H-5C69
(ucs-set-char #x5FBF ?$(HeK(B) ; C02-H-654B
(ucs-set-char #x5FC0 ?$(Hht(B) ; C02-H-6874
(ucs-set-char #x5FC1 ?$(Hhu(B) ; C02-H-6875
(ucs-set-char #x5FC2 ?$(I^/(B) ; C03-I-5E2F
(ucs-set-char #x5FC3 ?$(Cc}(B) ; KS0-C-637D
(ucs-set-char #x5FC3 ?$(GE@(B) ; C01-G-4540
(ucs-set-char #x5FC3 ?$@?4(B) ; J78-@-3F34
(ucs-set-char #x5FC3 ?$APD(B) ; GB0-A-5044
(ucs-set-char #x5FC3 ?$B?4(B) ; J83-B-3F34
(ucs-set-char #x5FC4 ?$(D=8(B) ; J90-D-3D38
(ucs-set-char #x5FC4 ?$(J!6(B) ; C04-J-2136
(ucs-set-char #x5FC4 ?$Ab`(B) ; GB0-A-6260
(ucs-set-char #x5FC5 ?$(Cy1(B) ; KS0-C-7931
(ucs-set-char #x5FC5 ?$(GFR(B) ; C01-G-4652
(ucs-set-char #x5FC5 ?$@I,(B) ; J78-@-492C
(ucs-set-char #x5FC5 ?$A1X(B) ; GB0-A-3158
(ucs-set-char #x5FC5 ?$BI,(B) ; J83-B-492C
(ucs-set-char #x5FC6 ?$ARd(B) ; GB0-A-5264
(ucs-set-char #x5FC7 ?$(D=9(B) ; J90-D-3D39
(ucs-set-char #x5FC7 ?$(I"M(B) ; C03-I-224D
(ucs-set-char #x5FC8 ?$(D=:(B) ; J90-D-3D3A
(ucs-set-char #x5FC8 ?$(J"q(B) ; C04-J-2271
(ucs-set-char #x5FC9 ?$(D=;(B) ; J90-D-3D3B
(ucs-set-char #x5FC9 ?$(H!\(B) ; C02-H-215C
(ucs-set-char #x5FC9 ?$Aba(B) ; GB0-A-6261
(ucs-set-char #x5FCA ?$(I"L(B) ; C03-I-224C
(ucs-set-char #x5FCB ?$(D=<(B) ; J90-D-3D3C
(ucs-set-char #x5FCB ?$(K"f(B) ; C05-K-2266
(ucs-set-char #x5FCC ?$(CP{(B) ; KS0-C-507B
(ucs-set-char #x5FCC ?$(GJ4(B) ; C01-G-4A34
(ucs-set-char #x5FCC ?$@4w(B) ; J78-@-3477
(ucs-set-char #x5FCC ?$A<I(B) ; GB0-A-3C49
(ucs-set-char #x5FCC ?$B4w(B) ; J83-B-3477
(ucs-set-char #x5FCD ?$(Cl[(B) ; KS0-C-6C5B
(ucs-set-char #x5FCD ?$(GJ6(B) ; C01-G-4A36
(ucs-set-char #x5FCD ?$(L'_(B) ; C06-L-275F
(ucs-set-char #x5FCD ?$@G&(B) ; J78-@-4726
(ucs-set-char #x5FCD ?$AHL(B) ; GB0-A-484C
(ucs-set-char #x5FCD ?$BG&(B) ; J83-B-4726
(ucs-set-char #x5FCE ?$(I%x(B) ; C03-I-2578
(ucs-set-char #x5FCF ?$(H"B(B) ; C02-H-2242
(ucs-set-char #x5FCF ?$Abc(B) ; GB0-A-6263
(ucs-set-char #x5FD0 ?$(D==(B) ; J90-D-3D3D
(ucs-set-char #x5FD0 ?$(H#x(B) ; C02-H-2378
(ucs-set-char #x5FD0 ?$Al~(B) ; GB0-A-6C7E
(ucs-set-char #x5FD1 ?$(D=>(B) ; J90-D-3D3E
(ucs-set-char #x5FD1 ?$(H#w(B) ; C02-H-2377
(ucs-set-char #x5FD1 ?$Al}(B) ; GB0-A-6C7D
(ucs-set-char #x5FD2 ?$(D=?(B) ; J90-D-3D3F
(ucs-set-char #x5FD2 ?$(H#v(B) ; C02-H-2376
(ucs-set-char #x5FD2 ?$A_/(B) ; GB0-A-5F2F
(ucs-set-char #x5FD3 ?$(D=@(B) ; J90-D-3D40
(ucs-set-char #x5FD3 ?$(I#f(B) ; C03-I-2366
(ucs-set-char #x5FD4 ?$(D=A(B) ; J90-D-3D41
(ucs-set-char #x5FD4 ?$(H"A(B) ; C02-H-2241
(ucs-set-char #x5FD5 ?$(H"@(B) ; C02-H-2240
(ucs-set-char #x5FD6 ?$(Cu<(B) ; KS0-C-753C
(ucs-set-char #x5FD6 ?$(GH%(B) ; C01-G-4825
(ucs-set-char #x5FD6 ?$@WV(B) ; J78-@-5756
(ucs-set-char #x5FD6 ?$Abb(B) ; GB0-A-6262
(ucs-set-char #x5FD6 ?$BWV(B) ; J83-B-5756
(ucs-set-char #x5FD7 ?$(Cr$(B) ; KS0-C-7224
(ucs-set-char #x5FD7 ?$(GJ5(B) ; C01-G-4A35
(ucs-set-char #x5FD7 ?$@;V(B) ; J78-@-3B56
(ucs-set-char #x5FD7 ?$AV>(B) ; GB0-A-563E
(ucs-set-char #x5FD7 ?$B;V(B) ; J83-B-3B56
(ucs-set-char #x5FD8 ?$(CXN(B) ; KS0-C-584E
(ucs-set-char #x5FD8 ?$(GJ3(B) ; C01-G-4A33
(ucs-set-char #x5FD8 ?$@K:(B) ; J78-@-4B3A
(ucs-set-char #x5FD8 ?$AM|(B) ; GB0-A-4D7C
(ucs-set-char #x5FD8 ?$BK:(B) ; J83-B-4B3A
(ucs-set-char #x5FD9 ?$(CXO(B) ; KS0-C-584F
(ucs-set-char #x5FD9 ?$(GH$(B) ; C01-G-4824
(ucs-set-char #x5FD9 ?$@K;(B) ; J78-@-4B3B
(ucs-set-char #x5FD9 ?$AC&(B) ; GB0-A-4326
(ucs-set-char #x5FD9 ?$BK;(B) ; J83-B-4B3B
(ucs-set-char #x5FDA ?$(I#g(B) ; C03-I-2367
(ucs-set-char #x5FDB ?$(I#i(B) ; C03-I-2369
(ucs-set-char #x5FDC ?$(I%w(B) ; C03-I-2577
(ucs-set-char #x5FDC ?$@1~(B) ; J78-@-317E
(ucs-set-char #x5FDC ?$B1~(B) ; J83-B-317E
(ucs-set-char #x5FDD ?$(GM?(B) ; C01-G-4D3F
(ucs-set-char #x5FDD ?$@W[(B) ; J78-@-575B
(ucs-set-char #x5FDD ?$AcC(B) ; GB0-A-6343
(ucs-set-char #x5FDD ?$BW[(B) ; J83-B-575B
(ucs-set-char #x5FDE ?$(D=B(B) ; J90-D-3D42
(ucs-set-char #x5FDE ?$(H&Y(B) ; C02-H-2659
(ucs-set-char #x5FDF ?$(I%{(B) ; C03-I-257B
(ucs-set-char #x5FE0 ?$(Cuw(B) ; KS0-C-7577
(ucs-set-char #x5FE0 ?$(GM@(B) ; C01-G-4D40
(ucs-set-char #x5FE0 ?$@Ci(B) ; J78-@-4369
(ucs-set-char #x5FE0 ?$AVR(B) ; GB0-A-5652
(ucs-set-char #x5FE0 ?$BCi(B) ; J83-B-4369
(ucs-set-char #x5FE1 ?$(D=C(B) ; J90-D-3D43
(ucs-set-char #x5FE1 ?$(H#}(B) ; C02-H-237D
(ucs-set-char #x5FE1 ?$Abg(B) ; GB0-A-6267
(ucs-set-char #x5FE2 ?$(D=D(B) ; J90-D-3D44
(ucs-set-char #x5FE2 ?$(J&P(B) ; C04-J-2650
(ucs-set-char #x5FE3 ?$(H$!(B) ; C02-H-2421
(ucs-set-char #x5FE4 ?$(H#~(B) ; C02-H-237E
(ucs-set-char #x5FE4 ?$@WX(B) ; J78-@-5758
(ucs-set-char #x5FE4 ?$Abh(B) ; GB0-A-6268
(ucs-set-char #x5FE4 ?$BWX(B) ; J83-B-5758
(ucs-set-char #x5FE5 ?$(H&Z(B) ; C02-H-265A
(ucs-set-char #x5FE6 ?$(I%v(B) ; C03-I-2576
(ucs-set-char #x5FE7 ?$(I%t(B) ; C03-I-2574
(ucs-set-char #x5FE7 ?$ASG(B) ; GB0-A-5347
(ucs-set-char #x5FE8 ?$(D=E(B) ; J90-D-3D45
(ucs-set-char #x5FE8 ?$(H#z(B) ; C02-H-237A
(ucs-set-char #x5FE9 ?$(D=F(B) ; J90-D-3D46
(ucs-set-char #x5FE9 ?$(I(~(B) ; C03-I-287E
(ucs-set-char #x5FEA ?$(D=G(B) ; J90-D-3D47
(ucs-set-char #x5FEA ?$(GJ:(B) ; C01-G-4A3A
(ucs-set-char #x5FEA ?$Abl(B) ; GB0-A-626C
(ucs-set-char #x5FEB ?$(Cva(B) ; KS0-C-7661
(ucs-set-char #x5FEB ?$(GJ8(B) ; C01-G-4A38
(ucs-set-char #x5FEB ?$@2w(B) ; J78-@-3277
(ucs-set-char #x5FEB ?$A?l(B) ; GB0-A-3F6C
(ucs-set-char #x5FEB ?$B2w(B) ; J83-B-3277
(ucs-set-char #x5FEC ?$(D=H(B) ; J90-D-3D48
(ucs-set-char #x5FEC ?$(I%|(B) ; C03-I-257C
(ucs-set-char #x5FED ?$(D=I(B) ; J90-D-3D49
(ucs-set-char #x5FED ?$(H#y(B) ; C02-H-2379
(ucs-set-char #x5FED ?$Abm(B) ; GB0-A-626D
(ucs-set-char #x5FEE ?$(D=J(B) ; J90-D-3D4A
(ucs-set-char #x5FEE ?$(H#{(B) ; C02-H-237B
(ucs-set-char #x5FEE ?$Abe(B) ; GB0-A-6265
(ucs-set-char #x5FEF ?$(D=K(B) ; J90-D-3D4B
(ucs-set-char #x5FEF ?$(H$#(B) ; C02-H-2423
(ucs-set-char #x5FF0 ?$(I&"(B) ; C03-I-2622
(ucs-set-char #x5FF0 ?$@X-(B) ; J78-@-582D
(ucs-set-char #x5FF0 ?$BX-(B) ; J83-B-582D
(ucs-set-char #x5FF1 ?$(GJ7(B) ; C01-G-4A37
(ucs-set-char #x5FF1 ?$@WZ(B) ; J78-@-575A
(ucs-set-char #x5FF1 ?$A3@(B) ; GB0-A-3340
(ucs-set-char #x5FF1 ?$BWZ(B) ; J83-B-575A
(ucs-set-char #x5FF2 ?$(D=L(B) ; J90-D-3D4C
(ucs-set-char #x5FF2 ?$(I&!(B) ; C03-I-2621
(ucs-set-char #x5FF3 ?$(D=M(B) ; J90-D-3D4D
(ucs-set-char #x5FF3 ?$(H#|(B) ; C02-H-237C
(ucs-set-char #x5FF4 ?$(H$'(B) ; C02-H-2427
(ucs-set-char #x5FF5 ?$(CR7(B) ; KS0-C-5237
(ucs-set-char #x5FF5 ?$(GMB(B) ; C01-G-4D42
(ucs-set-char #x5FF5 ?$@G0(B) ; J78-@-4730
(ucs-set-char #x5FF5 ?$ADn(B) ; GB0-A-446E
(ucs-set-char #x5FF5 ?$BG0(B) ; J83-B-4730
(ucs-set-char #x5FF6 ?$(D=N(B) ; J90-D-3D4E
(ucs-set-char #x5FF6 ?$(I%}(B) ; C03-I-257D
(ucs-set-char #x5FF7 ?$(H$$(B) ; C02-H-2424
(ucs-set-char #x5FF8 ?$(GJ9(B) ; C01-G-4A39
(ucs-set-char #x5FF8 ?$@WY(B) ; J78-@-5759
(ucs-set-char #x5FF8 ?$Abn(B) ; GB0-A-626E
(ucs-set-char #x5FF8 ?$BWY(B) ; J83-B-5759
(ucs-set-char #x5FF9 ?$(I&#(B) ; C03-I-2623
(ucs-set-char #x5FFA ?$(D=O(B) ; J90-D-3D4F
(ucs-set-char #x5FFA ?$(H$"(B) ; C02-H-2422
(ucs-set-char #x5FFB ?$(H$%(B) ; C02-H-2425
(ucs-set-char #x5FFB ?$@WW(B) ; J78-@-5757
(ucs-set-char #x5FFB ?$APC(B) ; GB0-A-5043
(ucs-set-char #x5FFB ?$BWW(B) ; J83-B-5757
(ucs-set-char #x5FFC ?$(D=P(B) ; J90-D-3D50
(ucs-set-char #x5FFC ?$(I%z(B) ; C03-I-257A
(ucs-set-char #x5FFD ?$(C{l(B) ; KS0-C-7B6C
(ucs-set-char #x5FFD ?$(GMA(B) ; C01-G-4D41
(ucs-set-char #x5FFD ?$@9z(B) ; J78-@-397A
(ucs-set-char #x5FFD ?$A:v(B) ; GB0-A-3A76
(ucs-set-char #x5FFD ?$B9z(B) ; J83-B-397A
(ucs-set-char #x5FFE ?$(I%u(B) ; C03-I-2575
(ucs-set-char #x5FFE ?$Abi(B) ; GB0-A-6269
(ucs-set-char #x5FFF ?$(C]H(B) ; KS0-C-5D48
(ucs-set-char #x5FFF ?$(GMC(B) ; C01-G-4D43
(ucs-set-char #x5FFF ?$@W](B) ; J78-@-575D
(ucs-set-char #x5FFF ?$A7^(B) ; GB0-A-375E
(ucs-set-char #x5FFF ?$BW](B) ; J83-B-575D
(ucs-set-char #x6000 ?$(H$&(B) ; C02-H-2426
(ucs-set-char #x6000 ?$A;3(B) ; GB0-A-3B33
(ucs-set-char #x6001 ?$AL,(B) ; GB0-A-4C2C
(ucs-set-char #x6002 ?$AKK(B) ; GB0-A-4B4B
(ucs-set-char #x6003 ?$Abd(B) ; GB0-A-6264
(ucs-set-char #x6004 ?$Abf(B) ; GB0-A-6266
(ucs-set-char #x6005 ?$Abj(B) ; GB0-A-626A
(ucs-set-char #x6006 ?$Abk(B) ; GB0-A-626B
(ucs-set-char #x6007 ?$(D=Q(B) ; J90-D-3D51
(ucs-set-char #x6007 ?$(I(x(B) ; C03-I-2878
(ucs-set-char #x6008 ?$(I)"(B) ; C03-I-2922
(ucs-set-char #x6009 ?$(H&n(B) ; C02-H-266E
(ucs-set-char #x600A ?$(D=R(B) ; J90-D-3D52
(ucs-set-char #x600A ?$(H&a(B) ; C02-H-2661
(ucs-set-char #x600A ?$Abw(B) ; GB0-A-6277
(ucs-set-char #x600B ?$(H&_(B) ; C02-H-265F
(ucs-set-char #x600C ?$(H&m(B) ; C02-H-266D
(ucs-set-char #x600D ?$(D=S(B) ; J90-D-3D53
(ucs-set-char #x600D ?$(H&h(B) ; C02-H-2668
(ucs-set-char #x600D ?$Abt(B) ; GB0-A-6274
(ucs-set-char #x600E ?$(GQ+(B) ; C01-G-512B
(ucs-set-char #x600E ?$@Wc(B) ; J78-@-5763
(ucs-set-char #x600E ?$ATu(B) ; GB0-A-5475
(ucs-set-char #x600E ?$BWc(B) ; J83-B-5763
(ucs-set-char #x600F ?$(Cdh(B) ; KS0-C-6468
(ucs-set-char #x600F ?$(GMD(B) ; C01-G-4D44
(ucs-set-char #x600F ?$@Wi(B) ; J78-@-5769
(ucs-set-char #x600F ?$Abs(B) ; GB0-A-6273
(ucs-set-char #x600F ?$BWi(B) ; J83-B-5769
(ucs-set-char #x6010 ?$(H&i(B) ; C02-H-2669
(ucs-set-char #x6010 ?$@Wa(B) ; J78-@-5761
(ucs-set-char #x6010 ?$BWa(B) ; J83-B-5761
(ucs-set-char #x6011 ?$(H&l(B) ; C02-H-266C
(ucs-set-char #x6012 ?$(CRA(B) ; KS0-C-5241
(ucs-set-char #x6012 ?$(GQ'(B) ; C01-G-5127
(ucs-set-char #x6012 ?$@E\(B) ; J78-@-455C
(ucs-set-char #x6012 ?$AE-(B) ; GB0-A-452D
(ucs-set-char #x6012 ?$BE\(B) ; J83-B-455C
(ucs-set-char #x6013 ?$(D=T(B) ; J90-D-3D54
(ucs-set-char #x6013 ?$(H&k(B) ; C02-H-266B
(ucs-set-char #x6014 ?$(D=U(B) ; J90-D-3D55
(ucs-set-char #x6014 ?$(GME(B) ; C01-G-4D45
(ucs-set-char #x6014 ?$AUz(B) ; GB0-A-557A
(ucs-set-char #x6015 ?$(GMJ(B) ; C01-G-4D4A
(ucs-set-char #x6015 ?$@Wf(B) ; J78-@-5766
(ucs-set-char #x6015 ?$AEB(B) ; GB0-A-4542
(ucs-set-char #x6015 ?$BWf(B) ; J83-B-5766
(ucs-set-char #x6016 ?$(CxW(B) ; KS0-C-7857
(ucs-set-char #x6016 ?$(GMH(B) ; C01-G-4D48
(ucs-set-char #x6016 ?$@I](B) ; J78-@-495D
(ucs-set-char #x6016 ?$A2@(B) ; GB0-A-3240
(ucs-set-char #x6016 ?$BI](B) ; J83-B-495D
(ucs-set-char #x6017 ?$(D=V(B) ; J90-D-3D56
(ucs-set-char #x6017 ?$(H&b(B) ; C02-H-2662
(ucs-set-char #x6018 ?$(D=W(B) ; J90-D-3D57
(ucs-set-char #x6018 ?$(J)6(B) ; C04-J-2936
(ucs-set-char #x6019 ?$(H&](B) ; C02-H-265D
(ucs-set-char #x6019 ?$@W`(B) ; J78-@-5760
(ucs-set-char #x6019 ?$Abo(B) ; GB0-A-626F
(ucs-set-char #x6019 ?$BW`(B) ; J83-B-5760
(ucs-set-char #x601A ?$(D=X(B) ; J90-D-3D58
(ucs-set-char #x601A ?$(H&d(B) ; C02-H-2664
(ucs-set-char #x601B ?$(GMO(B) ; C01-G-4D4F
(ucs-set-char #x601B ?$@We(B) ; J78-@-5765
(ucs-set-char #x601B ?$Abr(B) ; GB0-A-6272
(ucs-set-char #x601B ?$BWe(B) ; J83-B-5765
(ucs-set-char #x601C ?$(CV;(B) ; KS0-C-563B
(ucs-set-char #x601C ?$(H&o(B) ; C02-H-266F
(ucs-set-char #x601C ?$@Ng(B) ; J78-@-4E67
(ucs-set-char #x601C ?$AA/(B) ; GB0-A-412F
(ucs-set-char #x601C ?$BNg(B) ; J83-B-4E67
(ucs-set-char #x601D ?$(C^V(B) ; KS0-C-5E56
(ucs-set-char #x601D ?$(GQ((B) ; C01-G-5128
(ucs-set-char #x601D ?$@;W(B) ; J78-@-3B57
(ucs-set-char #x601D ?$AK<(B) ; GB0-A-4B3C
(ucs-set-char #x601D ?$B;W(B) ; J83-B-3B57
(ucs-set-char #x601E ?$(H&e(B) ; C02-H-2665
(ucs-set-char #x601F ?$(D=Y(B) ; J90-D-3D59
(ucs-set-char #x601F ?$(J&O(B) ; C04-J-264F
(ucs-set-char #x6020 ?$(Cw=(B) ; KS0-C-773D
(ucs-set-char #x6020 ?$(GQ)(B) ; C01-G-5129
(ucs-set-char #x6020 ?$@BU(B) ; J78-@-4255
(ucs-set-char #x6020 ?$A5!(B) ; GB0-A-3521
(ucs-set-char #x6020 ?$BBU(B) ; J83-B-4255
(ucs-set-char #x6021 ?$(Cl.(B) ; KS0-C-6C2E
(ucs-set-char #x6021 ?$(GMK(B) ; C01-G-4D4B
(ucs-set-char #x6021 ?$@W^(B) ; J78-@-575E
(ucs-set-char #x6021 ?$Aby(B) ; GB0-A-6279
(ucs-set-char #x6021 ?$BW^(B) ; J83-B-575E
(ucs-set-char #x6022 ?$(H&g(B) ; C02-H-2667
(ucs-set-char #x6023 ?$(I,Z(B) ; C03-I-2C5A
(ucs-set-char #x6024 ?$(D=Z(B) ; J90-D-3D5A
(ucs-set-char #x6024 ?$(H*N(B) ; C02-H-2A4E
(ucs-set-char #x6025 ?$(CPa(B) ; KS0-C-5061
(ucs-set-char #x6025 ?$(GQ*(B) ; C01-G-512A
(ucs-set-char #x6025 ?$@5^(B) ; J78-@-355E
(ucs-set-char #x6025 ?$A<1(B) ; GB0-A-3C31
(ucs-set-char #x6025 ?$B5^(B) ; J83-B-355E
(ucs-set-char #x6026 ?$(H&\(B) ; C02-H-265C
(ucs-set-char #x6026 ?$@Wh(B) ; J78-@-5768
(ucs-set-char #x6026 ?$Abq(B) ; GB0-A-6271
(ucs-set-char #x6026 ?$BWh(B) ; J83-B-5768
(ucs-set-char #x6027 ?$(C`u(B) ; KS0-C-6075
(ucs-set-char #x6027 ?$(GML(B) ; C01-G-4D4C
(ucs-set-char #x6027 ?$@@-(B) ; J78-@-402D
(ucs-set-char #x6027 ?$APT(B) ; GB0-A-5054
(ucs-set-char #x6027 ?$B@-(B) ; J83-B-402D
(ucs-set-char #x6028 ?$(Cj3(B) ; KS0-C-6A33
(ucs-set-char #x6028 ?$(GQ,(B) ; C01-G-512C
(ucs-set-char #x6028 ?$@1e(B) ; J78-@-3165
(ucs-set-char #x6028 ?$AT9(B) ; GB0-A-5439
(ucs-set-char #x6028 ?$B1e(B) ; J83-B-3165
(ucs-set-char #x6029 ?$(GMM(B) ; C01-G-4D4D
(ucs-set-char #x6029 ?$@Wb(B) ; J78-@-5762
(ucs-set-char #x6029 ?$Abu(B) ; GB0-A-6275
(ucs-set-char #x6029 ?$BWb(B) ; J83-B-5762
(ucs-set-char #x602A ?$(CNV(B) ; KS0-C-4E56
(ucs-set-char #x602A ?$(GMI(B) ; C01-G-4D49
(ucs-set-char #x602A ?$@2x(B) ; J78-@-3278
(ucs-set-char #x602A ?$A9V(B) ; GB0-A-3956
(ucs-set-char #x602A ?$B2x(B) ; J83-B-3278
(ucs-set-char #x602B ?$(GMN(B) ; C01-G-4D4E
(ucs-set-char #x602B ?$@Wg(B) ; J78-@-5767
(ucs-set-char #x602B ?$Abv(B) ; GB0-A-6276
(ucs-set-char #x602B ?$BWg(B) ; J83-B-5767
(ucs-set-char #x602C ?$(H&f(B) ; C02-H-2666
(ucs-set-char #x602D ?$(D=[(B) ; J90-D-3D5B
(ucs-set-char #x602D ?$(H&[(B) ; C02-H-265B
(ucs-set-char #x602E ?$(H&j(B) ; C02-H-266A
(ucs-set-char #x602F ?$(CL%(B) ; KS0-C-4C25
(ucs-set-char #x602F ?$(GMF(B) ; C01-G-4D46
(ucs-set-char #x602F ?$@61(B) ; J78-@-3631
(ucs-set-char #x602F ?$AGS(B) ; GB0-A-4753
(ucs-set-char #x602F ?$B61(B) ; J83-B-3631
(ucs-set-char #x6030 ?$(I(w(B) ; C03-I-2877
(ucs-set-char #x6031 ?$(I,[(B) ; C03-I-2C5B
(ucs-set-char #x6031 ?$@Wd(B) ; J78-@-5764
(ucs-set-char #x6031 ?$BWd(B) ; J83-B-5764
(ucs-set-char #x6032 ?$(H&^(B) ; C02-H-265E
(ucs-set-char #x6033 ?$(D=\(B) ; J90-D-3D5C
(ucs-set-char #x6033 ?$(H&c(B) ; C02-H-2663
(ucs-set-char #x6034 ?$(H&`(B) ; C02-H-2660
(ucs-set-char #x6035 ?$(D=](B) ; J90-D-3D5D
(ucs-set-char #x6035 ?$(GMG(B) ; C01-G-4D47
(ucs-set-char #x6035 ?$Abp(B) ; GB0-A-6270
(ucs-set-char #x6036 ?$(I(z(B) ; C03-I-287A
(ucs-set-char #x6037 ?$(H*@(B) ; C02-H-2A40
(ucs-set-char #x6039 ?$(H*A(B) ; C02-H-2A41
(ucs-set-char #x603A ?$@Wj(B) ; J78-@-576A
(ucs-set-char #x603A ?$BWj(B) ; J83-B-576A
(ucs-set-char #x603B ?$AW\(B) ; GB0-A-575C
(ucs-set-char #x603C ?$Am!(B) ; GB0-A-6D21
(ucs-set-char #x603D ?$(I)!(B) ; C03-I-2921
(ucs-set-char #x603F ?$Abx(B) ; GB0-A-6278
(ucs-set-char #x6040 ?$(D=^(B) ; J90-D-3D5E
(ucs-set-char #x6040 ?$(H*K(B) ; C02-H-2A4B
(ucs-set-char #x6041 ?$(Clv(B) ; KS0-C-6C76
(ucs-set-char #x6041 ?$(H/#(B) ; C02-H-2F23
(ucs-set-char #x6041 ?$@Wl(B) ; J78-@-576C
(ucs-set-char #x6041 ?$Am%(B) ; GB0-A-6D25
(ucs-set-char #x6041 ?$BWl(B) ; J83-B-576C
(ucs-set-char #x6042 ?$(Cba(B) ; KS0-C-6261
(ucs-set-char #x6042 ?$(H*L(B) ; C02-H-2A4C
(ucs-set-char #x6042 ?$@Wv(B) ; J78-@-5776
(ucs-set-char #x6042 ?$Ab~(B) ; GB0-A-627E
(ucs-set-char #x6042 ?$BWv(B) ; J83-B-5776
(ucs-set-char #x6043 ?$(Cc>(B) ; KS0-C-633E
(ucs-set-char #x6043 ?$(GQ2(B) ; C01-G-5132
(ucs-set-char #x6043 ?$@Wt(B) ; J78-@-5774
(ucs-set-char #x6043 ?$AJQ(B) ; GB0-A-4A51
(ucs-set-char #x6043 ?$BWt(B) ; J83-B-5774
(ucs-set-char #x6044 ?$(H*O(B) ; C02-H-2A4F
(ucs-set-char #x6045 ?$(H*E(B) ; C02-H-2A45
(ucs-set-char #x6046 ?$(GQ1(B) ; C01-G-5131
(ucs-set-char #x6046 ?$@Wq(B) ; J78-@-5771
(ucs-set-char #x6046 ?$BWq(B) ; J83-B-5771
(ucs-set-char #x6047 ?$(D=_(B) ; J90-D-3D5F
(ucs-set-char #x6047 ?$(H*G(B) ; C02-H-2A47
(ucs-set-char #x6048 ?$(D=`(B) ; J90-D-3D60
(ucs-set-char #x6048 ?$(J)?(B) ; C04-J-293F
(ucs-set-char #x6049 ?$(D=a(B) ; J90-D-3D61
(ucs-set-char #x6049 ?$(H*H(B) ; C02-H-2A48
(ucs-set-char #x604A ?$(I,`(B) ; C03-I-2C60
(ucs-set-char #x604A ?$@Wp(B) ; J78-@-5770
(ucs-set-char #x604A ?$BWp(B) ; J83-B-5770
(ucs-set-char #x604B ?$(I0y(B) ; C03-I-3079
(ucs-set-char #x604B ?$@Nx(B) ; J78-@-4E78
(ucs-set-char #x604B ?$AA5(B) ; GB0-A-4135
(ucs-set-char #x604B ?$BNx(B) ; J83-B-4E78
(ucs-set-char #x604C ?$(D=b(B) ; J90-D-3D62
(ucs-set-char #x604C ?$(H*J(B) ; C02-H-2A4A
(ucs-set-char #x604D ?$(C|H(B) ; KS0-C-7C48
(ucs-set-char #x604D ?$(GQ-(B) ; C01-G-512D
(ucs-set-char #x604D ?$@Wr(B) ; J78-@-5772
(ucs-set-char #x604D ?$A;P(B) ; GB0-A-3B50
(ucs-set-char #x604D ?$BWr(B) ; J83-B-5772
(ucs-set-char #x604E ?$(I,V(B) ; C03-I-2C56
(ucs-set-char #x604F ?$(I0s(B) ; C03-I-3073
(ucs-set-char #x6050 ?$(CMp(B) ; KS0-C-4D70
(ucs-set-char #x6050 ?$(GUE(B) ; C01-G-5545
(ucs-set-char #x6050 ?$@62(B) ; J78-@-3632
(ucs-set-char #x6050 ?$A?V(B) ; GB0-A-3F56
(ucs-set-char #x6050 ?$B62(B) ; J83-B-3632
(ucs-set-char #x6051 ?$(D=c(B) ; J90-D-3D63
(ucs-set-char #x6051 ?$(I,W(B) ; C03-I-2C57
(ucs-set-char #x6052 ?$(Cyv(B) ; KS0-C-7976
(ucs-set-char #x6052 ?$(I,](B) ; C03-I-2C5D
(ucs-set-char #x6052 ?$@91(B) ; J78-@-3931
(ucs-set-char #x6052 ?$A:c(B) ; GB0-A-3A63
(ucs-set-char #x6052 ?$B91(B) ; J83-B-3931
(ucs-set-char #x6053 ?$(H*F(B) ; C02-H-2A46
(ucs-set-char #x6054 ?$(D=d(B) ; J90-D-3D64
(ucs-set-char #x6054 ?$(H*B(B) ; C02-H-2A42
(ucs-set-char #x6055 ?$(C_p(B) ; KS0-C-5F70
(ucs-set-char #x6055 ?$(GUF(B) ; C01-G-5546
(ucs-set-char #x6055 ?$@=z(B) ; J78-@-3D7A
(ucs-set-char #x6055 ?$AK!(B) ; GB0-A-4B21
(ucs-set-char #x6055 ?$B=z(B) ; J83-B-3D7A
(ucs-set-char #x6056 ?$(D=e(B) ; J90-D-3D65
(ucs-set-char #x6056 ?$(I0~(B) ; C03-I-307E
(ucs-set-char #x6057 ?$(D=f(B) ; J90-D-3D66
(ucs-set-char #x6057 ?$(J)>(B) ; C04-J-293E
(ucs-set-char #x6058 ?$(H*P(B) ; C02-H-2A50
(ucs-set-char #x6059 ?$(Ce?(B) ; KS0-C-653F
(ucs-set-char #x6059 ?$(GUB(B) ; C01-G-5542
(ucs-set-char #x6059 ?$@Wy(B) ; J78-@-5779
(ucs-set-char #x6059 ?$Am&(B) ; GB0-A-6D26
(ucs-set-char #x6059 ?$BWy(B) ; J83-B-5779
(ucs-set-char #x605A ?$(H/!(B) ; C02-H-2F21
(ucs-set-char #x605A ?$@Wk(B) ; J78-@-576B
(ucs-set-char #x605A ?$Am#(B) ; GB0-A-6D23
(ucs-set-char #x605A ?$BWk(B) ; J83-B-576B
(ucs-set-char #x605B ?$(H*I(B) ; C02-H-2A49
(ucs-set-char #x605C ?$(I,T(B) ; C03-I-2C54
(ucs-set-char #x605D ?$(CN?(B) ; KS0-C-4E3F
(ucs-set-char #x605D ?$(D=g(B) ; J90-D-3D67
(ucs-set-char #x605D ?$(H.~(B) ; C02-H-2E7E
(ucs-set-char #x605D ?$Am"(B) ; GB0-A-6D22
(ucs-set-char #x605E ?$(H*D(B) ; C02-H-2A44
(ucs-set-char #x605F ?$(H*M(B) ; C02-H-2A4D
(ucs-set-char #x605F ?$@Wo(B) ; J78-@-576F
(ucs-set-char #x605F ?$BWo(B) ; J83-B-576F
(ucs-set-char #x6060 ?$(I,_(B) ; C03-I-2C5F
(ucs-set-char #x6060 ?$@W_(B) ; J78-@-575F
(ucs-set-char #x6060 ?$BW_(B) ; J83-B-575F
(ucs-set-char #x6061 ?$(D=h(B) ; J90-D-3D68
(ucs-set-char #x6061 ?$(I,a(B) ; C03-I-2C61
(ucs-set-char #x6062 ?$(C|a(B) ; KS0-C-7C61
(ucs-set-char #x6062 ?$(GQ0(B) ; C01-G-5130
(ucs-set-char #x6062 ?$@2z(B) ; J78-@-327A
(ucs-set-char #x6062 ?$A;V(B) ; GB0-A-3B56
(ucs-set-char #x6062 ?$B2z(B) ; J83-B-327A
(ucs-set-char #x6063 ?$(Cm0(B) ; KS0-C-6D30
(ucs-set-char #x6063 ?$(GUC(B) ; C01-G-5543
(ucs-set-char #x6063 ?$@Ws(B) ; J78-@-5773
(ucs-set-char #x6063 ?$Am'(B) ; GB0-A-6D27
(ucs-set-char #x6063 ?$BWs(B) ; J83-B-5773
(ucs-set-char #x6064 ?$(C}Q(B) ; KS0-C-7D51
(ucs-set-char #x6064 ?$(GQ6(B) ; C01-G-5136
(ucs-set-char #x6064 ?$@Wu(B) ; J78-@-5775
(ucs-set-char #x6064 ?$APt(B) ; GB0-A-5074
(ucs-set-char #x6064 ?$BWu(B) ; J83-B-5775
(ucs-set-char #x6065 ?$(Cv;(B) ; KS0-C-763B
(ucs-set-char #x6065 ?$(GUD(B) ; C01-G-5544
(ucs-set-char #x6065 ?$@CQ(B) ; J78-@-4351
(ucs-set-char #x6065 ?$BCQ(B) ; J83-B-4351
(ucs-set-char #x6066 ?$(H*Q(B) ; C02-H-2A51
(ucs-set-char #x6067 ?$(D=i(B) ; J90-D-3D69
(ucs-set-char #x6067 ?$(H/"(B) ; C02-H-2F22
(ucs-set-char #x6067 ?$Am$(B) ; GB0-A-6D24
(ucs-set-char #x6068 ?$(CyO(B) ; KS0-C-794F
(ucs-set-char #x6068 ?$(GQ/(B) ; C01-G-512F
(ucs-set-char #x6068 ?$@:((B) ; J78-@-3A28
(ucs-set-char #x6068 ?$A:^(B) ; GB0-A-3A5E
(ucs-set-char #x6068 ?$B:((B) ; J83-B-3A28
(ucs-set-char #x6069 ?$(CkZ(B) ; KS0-C-6B5A
(ucs-set-char #x6069 ?$(GUH(B) ; C01-G-5548
(ucs-set-char #x6069 ?$@28(B) ; J78-@-3238
(ucs-set-char #x6069 ?$A6w(B) ; GB0-A-3677
(ucs-set-char #x6069 ?$B28(B) ; J83-B-3238
(ucs-set-char #x606A ?$(CJA(B) ; KS0-C-4A41
(ucs-set-char #x606A ?$(GQ5(B) ; C01-G-5135
(ucs-set-char #x606A ?$@Wm(B) ; J78-@-576D
(ucs-set-char #x606A ?$Ac!(B) ; GB0-A-6321
(ucs-set-char #x606A ?$BWm(B) ; J83-B-576D
(ucs-set-char #x606B ?$(GQ4(B) ; C01-G-5134
(ucs-set-char #x606B ?$@Wx(B) ; J78-@-5778
(ucs-set-char #x606B ?$A62(B) ; GB0-A-3632
(ucs-set-char #x606B ?$BWx(B) ; J83-B-5778
(ucs-set-char #x606C ?$(CR8(B) ; KS0-C-5238
(ucs-set-char #x606C ?$(GQ3(B) ; C01-G-5133
(ucs-set-char #x606C ?$@Ww(B) ; J78-@-5777
(ucs-set-char #x606C ?$ALq(B) ; GB0-A-4C71
(ucs-set-char #x606C ?$BWw(B) ; J83-B-5777
(ucs-set-char #x606D ?$(CMq(B) ; KS0-C-4D71
(ucs-set-char #x606D ?$(GUG(B) ; C01-G-5547
(ucs-set-char #x606D ?$@63(B) ; J78-@-3633
(ucs-set-char #x606D ?$A9'(B) ; GB0-A-3927
(ucs-set-char #x606D ?$B63(B) ; J83-B-3633
(ucs-set-char #x606E ?$(H*R(B) ; C02-H-2A52
(ucs-set-char #x606F ?$(CcS(B) ; KS0-C-6353
(ucs-set-char #x606F ?$(GUI(B) ; C01-G-5549
(ucs-set-char #x606F ?$@B)(B) ; J78-@-4229
(ucs-set-char #x606F ?$AO"(B) ; GB0-A-4F22
(ucs-set-char #x606F ?$BB)(B) ; J83-B-4229
(ucs-set-char #x6070 ?$(C}f(B) ; KS0-C-7D66
(ucs-set-char #x6070 ?$(GQ.(B) ; C01-G-512E
(ucs-set-char #x6070 ?$@3f(B) ; J78-@-3366
(ucs-set-char #x6070 ?$AG!(B) ; GB0-A-4721
(ucs-set-char #x6070 ?$B3f(B) ; J83-B-3366
(ucs-set-char #x6071 ?$(D=j(B) ; J90-D-3D6A
(ucs-set-char #x6071 ?$(J)K(B) ; C04-J-294B
(ucs-set-char #x6072 ?$(H*C(B) ; C02-H-2A43
(ucs-set-char #x6073 ?$(I0z(B) ; C03-I-307A
(ucs-set-char #x6073 ?$A?R(B) ; GB0-A-3F52
(ucs-set-char #x6074 ?$(I0x(B) ; C03-I-3078
(ucs-set-char #x6075 ?$(I0{(B) ; C03-I-307B
(ucs-set-char #x6075 ?$@7C(B) ; J78-@-3743
(ucs-set-char #x6075 ?$B7C(B) ; J83-B-3743
(ucs-set-char #x6076 ?$A6q(B) ; GB0-A-3671
(ucs-set-char #x6077 ?$@Wn(B) ; J78-@-576E
(ucs-set-char #x6077 ?$BWn(B) ; J83-B-576E
(ucs-set-char #x6078 ?$Abz(B) ; GB0-A-627A
(ucs-set-char #x6079 ?$Ab{(B) ; GB0-A-627B
(ucs-set-char #x607A ?$Ab}(B) ; GB0-A-627D
(ucs-set-char #x607B ?$Ab|(B) ; GB0-A-627C
(ucs-set-char #x607C ?$(I,\(B) ; C03-I-2C5C
(ucs-set-char #x607C ?$ADU(B) ; GB0-A-4455
(ucs-set-char #x607D ?$Ac"(B) ; GB0-A-6322
(ucs-set-char #x607E ?$(D=k(B) ; J90-D-3D6B
(ucs-set-char #x607E ?$(I0v(B) ; C03-I-3076
(ucs-set-char #x607F ?$(D=l(B) ; J90-D-3D6C
(ucs-set-char #x607F ?$(GZ<(B) ; C01-G-5A3C
(ucs-set-char #x607F ?$ASA(B) ; GB0-A-5341
(ucs-set-char #x6080 ?$(H/&(B) ; C02-H-2F26
(ucs-set-char #x6081 ?$(H/((B) ; C02-H-2F28
(ucs-set-char #x6081 ?$@Wz(B) ; J78-@-577A
(ucs-set-char #x6081 ?$BWz(B) ; J83-B-577A
(ucs-set-char #x6082 ?$(D=m(B) ; J90-D-3D6D
(ucs-set-char #x6082 ?$(J-%(B) ; C04-J-2D25
(ucs-set-char #x6083 ?$(H/*(B) ; C02-H-2F2A
(ucs-set-char #x6083 ?$@W}(B) ; J78-@-577D
(ucs-set-char #x6083 ?$Ac'(B) ; GB0-A-6327
(ucs-set-char #x6083 ?$BW}(B) ; J83-B-577D
(ucs-set-char #x6084 ?$(GUJ(B) ; C01-G-554A
(ucs-set-char #x6084 ?$@X!(B) ; J78-@-5821
(ucs-set-char #x6084 ?$AGD(B) ; GB0-A-4744
(ucs-set-char #x6084 ?$BX!(B) ; J83-B-5821
(ucs-set-char #x6085 ?$(Cfm(B) ; KS0-C-666D
(ucs-set-char #x6085 ?$(GUP(B) ; C01-G-5550
(ucs-set-char #x6086 ?$(D=n(B) ; J90-D-3D6E
(ucs-set-char #x6086 ?$(H57(B) ; C02-H-3537
(ucs-set-char #x6087 ?$(H/.(B) ; C02-H-2F2E
(ucs-set-char #x6088 ?$(D=o(B) ; J90-D-3D6F
(ucs-set-char #x6088 ?$(H/%(B) ; C02-H-2F25
(ucs-set-char #x6089 ?$(Ccz(B) ; KS0-C-637A
(ucs-set-char #x6089 ?$(GZ>(B) ; C01-G-5A3E
(ucs-set-char #x6089 ?$@<=(B) ; J78-@-3C3D
(ucs-set-char #x6089 ?$AO$(B) ; GB0-A-4F24
(ucs-set-char #x6089 ?$B<=(B) ; J83-B-3C3D
(ucs-set-char #x608A ?$(D=p(B) ; J90-D-3D70
(ucs-set-char #x608A ?$(H55(B) ; C02-H-3535
(ucs-set-char #x608B ?$(I1"(B) ; C03-I-3122
(ucs-set-char #x608B ?$@X'(B) ; J78-@-5827
(ucs-set-char #x608B ?$BX'(B) ; J83-B-5827
(ucs-set-char #x608C ?$(Cp*(B) ; KS0-C-702A
(ucs-set-char #x608C ?$(GUO(B) ; C01-G-554F
(ucs-set-char #x608C ?$@Dp(B) ; J78-@-4470
(ucs-set-char #x608C ?$Ac)(B) ; GB0-A-6329
(ucs-set-char #x608C ?$BDp(B) ; J83-B-4470
(ucs-set-char #x608D ?$(CyP(B) ; KS0-C-7950
(ucs-set-char #x608D ?$(GUM(B) ; C01-G-554D
(ucs-set-char #x608D ?$@W{(B) ; J78-@-577B
(ucs-set-char #x608D ?$A:7(B) ; GB0-A-3A37
(ucs-set-char #x608D ?$BW{(B) ; J83-B-577B
(ucs-set-char #x608E ?$(D=q(B) ; J90-D-3D71
(ucs-set-char #x608E ?$(H/0(B) ; C02-H-2F30
(ucs-set-char #x608F ?$(J--(B) ; C04-J-2D2D
(ucs-set-char #x6090 ?$(H56(B) ; C02-H-3536
(ucs-set-char #x6091 ?$(D=r(B) ; J90-D-3D72
(ucs-set-char #x6091 ?$(J-,(B) ; C04-J-2D2C
(ucs-set-char #x6092 ?$(H/'(B) ; C02-H-2F27
(ucs-set-char #x6092 ?$@X%(B) ; J78-@-5825
(ucs-set-char #x6092 ?$Ac((B) ; GB0-A-6328
(ucs-set-char #x6092 ?$BX%(B) ; J83-B-5825
(ucs-set-char #x6093 ?$(D=s(B) ; J90-D-3D73
(ucs-set-char #x6093 ?$(I1%(B) ; C03-I-3125
(ucs-set-char #x6094 ?$(C|b(B) ; KS0-C-7C62
(ucs-set-char #x6094 ?$(GUN(B) ; C01-G-554E
(ucs-set-char #x6094 ?$(J)J(B) ; C04-J-294A
(ucs-set-char #x6094 ?$@2y(B) ; J78-@-3279
(ucs-set-char #x6094 ?$A;Z(B) ; GB0-A-3B5A
(ucs-set-char #x6094 ?$B2y(B) ; J83-B-3279
(ucs-set-char #x6095 ?$(D=t(B) ; J90-D-3D74
(ucs-set-char #x6095 ?$(H/+(B) ; C02-H-2F2B
(ucs-set-char #x6096 ?$(Cx'(B) ; KS0-C-7827
(ucs-set-char #x6096 ?$(GUQ(B) ; C01-G-5551
(ucs-set-char #x6096 ?$@X#(B) ; J78-@-5823
(ucs-set-char #x6096 ?$Ac#(B) ; GB0-A-6323
(ucs-set-char #x6096 ?$BX#(B) ; J83-B-5823
(ucs-set-char #x6097 ?$(H/-(B) ; C02-H-2F2D
(ucs-set-char #x6097 ?$@X$(B) ; J78-@-5824
(ucs-set-char #x6097 ?$BX$(B) ; J83-B-5824
(ucs-set-char #x6098 ?$(D=u(B) ; J90-D-3D75
(ucs-set-char #x6098 ?$(I5h(B) ; C03-I-3568
(ucs-set-char #x6099 ?$(I0t(B) ; C03-I-3074
(ucs-set-char #x609A ?$(Cae(B) ; KS0-C-6165
(ucs-set-char #x609A ?$(GUL(B) ; C01-G-554C
(ucs-set-char #x609A ?$@W~(B) ; J78-@-577E
(ucs-set-char #x609A ?$Ac$(B) ; GB0-A-6324
(ucs-set-char #x609A ?$BW~(B) ; J83-B-577E
(ucs-set-char #x609B ?$(Cny(B) ; KS0-C-6E79
(ucs-set-char #x609B ?$(H/,(B) ; C02-H-2F2C
(ucs-set-char #x609B ?$@X"(B) ; J78-@-5822
(ucs-set-char #x609B ?$Ac*(B) ; GB0-A-632A
(ucs-set-char #x609B ?$BX"(B) ; J83-B-5822
(ucs-set-char #x609C ?$(H//(B) ; C02-H-2F2F
(ucs-set-char #x609D ?$(D=v(B) ; J90-D-3D76
(ucs-set-char #x609D ?$(H/)(B) ; C02-H-2F29
(ucs-set-char #x609D ?$Ac&(B) ; GB0-A-6326
(ucs-set-char #x609E ?$(D=w(B) ; J90-D-3D77
(ucs-set-char #x609E ?$(I1'(B) ; C03-I-3127
(ucs-set-char #x609F ?$(Cgv(B) ; KS0-C-6776
(ucs-set-char #x609F ?$(GUK(B) ; C01-G-554B
(ucs-set-char #x609F ?$@8g(B) ; J78-@-3867
(ucs-set-char #x609F ?$ANr(B) ; GB0-A-4E72
(ucs-set-char #x609F ?$B8g(B) ; J83-B-3867
(ucs-set-char #x60A0 ?$(Cjm(B) ; KS0-C-6A6D
(ucs-set-char #x60A0 ?$(GZ?(B) ; C01-G-5A3F
(ucs-set-char #x60A0 ?$@M*(B) ; J78-@-4D2A
(ucs-set-char #x60A0 ?$ASF(B) ; GB0-A-5346
(ucs-set-char #x60A0 ?$BM*(B) ; J83-B-4D2A
(ucs-set-char #x60A1 ?$(I5q(B) ; C03-I-3571
(ucs-set-char #x60A2 ?$(D=x(B) ; J90-D-3D78
(ucs-set-char #x60A2 ?$(H/$(B) ; C02-H-2F24
(ucs-set-char #x60A3 ?$(C|4(B) ; KS0-C-7C34
(ucs-set-char #x60A3 ?$(GZ=(B) ; C01-G-5A3D
(ucs-set-char #x60A3 ?$@45(B) ; J78-@-3435
(ucs-set-char #x60A3 ?$A;<(B) ; GB0-A-3B3C
(ucs-set-char #x60A3 ?$B45(B) ; J83-B-3435
(ucs-set-char #x60A4 ?$(CuB(B) ; KS0-C-7542
(ucs-set-char #x60A4 ?$(D=y(B) ; J90-D-3D79
(ucs-set-char #x60A4 ?$(I5r(B) ; C03-I-3572
(ucs-set-char #x60A5 ?$(D=z(B) ; J90-D-3D7A
(ucs-set-char #x60A5 ?$(J1k(B) ; C04-J-316B
(ucs-set-char #x60A6 ?$(I1#(B) ; C03-I-3123
(ucs-set-char #x60A6 ?$@1Y(B) ; J78-@-3159
(ucs-set-char #x60A6 ?$ATC(B) ; GB0-A-5443
(ucs-set-char #x60A6 ?$B1Y(B) ; J83-B-3159
(ucs-set-char #x60A7 ?$(CW\(B) ; KS0-C-575C
(ucs-set-char #x60A7 ?$(I1((B) ; C03-I-3128
(ucs-set-char #x60A7 ?$@X&(B) ; J78-@-5826
(ucs-set-char #x60A7 ?$BX&(B) ; J83-B-5826
(ucs-set-char #x60A8 ?$(D={(B) ; J90-D-3D7B
(ucs-set-char #x60A8 ?$(GZ@(B) ; C01-G-5A40
(ucs-set-char #x60A8 ?$ADz(B) ; GB0-A-447A
(ucs-set-char #x60A9 ?$(I1!(B) ; C03-I-3121
(ucs-set-char #x60A9 ?$@G:(B) ; J78-@-473A
(ucs-set-char #x60A9 ?$BG:(B) ; J83-B-473A
(ucs-set-char #x60AA ?$(I5o(B) ; C03-I-356F
(ucs-set-char #x60AA ?$@0-(B) ; J78-@-302D
(ucs-set-char #x60AA ?$B0-(B) ; J83-B-302D
(ucs-set-char #x60AB ?$Am((B) ; GB0-A-6D28
(ucs-set-char #x60AC ?$AP|(B) ; GB0-A-507C
(ucs-set-char #x60AD ?$Ac%(B) ; GB0-A-6325
(ucs-set-char #x60AE ?$(I1&(B) ; C03-I-3126
(ucs-set-char #x60AF ?$ACu(B) ; GB0-A-4375
(ucs-set-char #x60B0 ?$(Cpu(B) ; KS0-C-7075
(ucs-set-char #x60B0 ?$(D=|(B) ; J90-D-3D7C
(ucs-set-char #x60B0 ?$(H59(B) ; C02-H-3539
(ucs-set-char #x60B1 ?$(D=}(B) ; J90-D-3D7D
(ucs-set-char #x60B1 ?$(H5B(B) ; C02-H-3542
(ucs-set-char #x60B1 ?$Ac-(B) ; GB0-A-632D
(ucs-set-char #x60B2 ?$(C]h(B) ; KS0-C-5D68
(ucs-set-char #x60B2 ?$(G_+(B) ; C01-G-5F2B
(ucs-set-char #x60B2 ?$@Ha(B) ; J78-@-4861
(ucs-set-char #x60B2 ?$A1/(B) ; GB0-A-312F
(ucs-set-char #x60B2 ?$BHa(B) ; J83-B-4861
(ucs-set-char #x60B3 ?$(CSm(B) ; KS0-C-536D
(ucs-set-char #x60B3 ?$(I;T(B) ; C03-I-3B54
(ucs-set-char #x60B3 ?$@W\(B) ; J78-@-575C
(ucs-set-char #x60B3 ?$BW\(B) ; J83-B-575C
(ucs-set-char #x60B4 ?$(Cu|(B) ; KS0-C-757C
(ucs-set-char #x60B4 ?$(GZB(B) ; C01-G-5A42
(ucs-set-char #x60B4 ?$@X,(B) ; J78-@-582C
(ucs-set-char #x60B4 ?$Ac2(B) ; GB0-A-6332
(ucs-set-char #x60B4 ?$BX,(B) ; J83-B-582C
(ucs-set-char #x60B5 ?$(GZG(B) ; C01-G-5A47
(ucs-set-char #x60B5 ?$@X0(B) ; J78-@-5830
(ucs-set-char #x60B5 ?$BX0(B) ; J83-B-5830
(ucs-set-char #x60B6 ?$(CZ?(B) ; KS0-C-5A3F
(ucs-set-char #x60B6 ?$(G_,(B) ; C01-G-5F2C
(ucs-set-char #x60B6 ?$@Le(B) ; J78-@-4C65
(ucs-set-char #x60B6 ?$BLe(B) ; J83-B-4C65
(ucs-set-char #x60B7 ?$(D=~(B) ; J90-D-3D7E
(ucs-set-char #x60B7 ?$(H5D(B) ; C02-H-3544
(ucs-set-char #x60B8 ?$(CL{(B) ; KS0-C-4C7B
(ucs-set-char #x60B8 ?$(GZN(B) ; C01-G-5A4E
(ucs-set-char #x60B8 ?$@X)(B) ; J78-@-5829
(ucs-set-char #x60B8 ?$A<B(B) ; GB0-A-3C42
(ucs-set-char #x60B8 ?$BX)(B) ; J83-B-5829
(ucs-set-char #x60B9 ?$(H;](B) ; C02-H-3B5D
(ucs-set-char #x60BA ?$(H5:(B) ; C02-H-353A
(ucs-set-char #x60BB ?$(D>!(B) ; J90-D-3E21
(ucs-set-char #x60BB ?$(GZF(B) ; C01-G-5A46
(ucs-set-char #x60BB ?$Ac,(B) ; GB0-A-632C
(ucs-set-char #x60BC ?$(CSz(B) ; KS0-C-537A
(ucs-set-char #x60BC ?$(GZI(B) ; C01-G-5A49
(ucs-set-char #x60BC ?$@Ei(B) ; J78-@-4569
(ucs-set-char #x60BC ?$A5?(B) ; GB0-A-353F
(ucs-set-char #x60BC ?$BEi(B) ; J83-B-4569
(ucs-set-char #x60BD ?$(Ct$(B) ; KS0-C-7424
(ucs-set-char #x60BD ?$(GZD(B) ; C01-G-5A44
(ucs-set-char #x60BD ?$@X.(B) ; J78-@-582E
(ucs-set-char #x60BD ?$BX.(B) ; J83-B-582E
(ucs-set-char #x60BE ?$(D>"(B) ; J90-D-3E22
(ucs-set-char #x60BE ?$(H58(B) ; C02-H-3538
(ucs-set-char #x60BF ?$(H5F(B) ; C02-H-3546
(ucs-set-char #x60C0 ?$(H5I(B) ; C02-H-3549
(ucs-set-char #x60C1 ?$(H;l(B) ; C02-H-3B6C
(ucs-set-char #x60C2 ?$(D>#(B) ; J90-D-3E23
(ucs-set-char #x60C2 ?$(J1h(B) ; C04-J-3168
(ucs-set-char #x60C3 ?$(H5G(B) ; C02-H-3547
(ucs-set-char #x60C4 ?$(D>$(B) ; J90-D-3E24
(ucs-set-char #x60C4 ?$(H;a(B) ; C02-H-3B61
(ucs-set-char #x60C5 ?$(CoW(B) ; KS0-C-6F57
(ucs-set-char #x60C5 ?$(GZE(B) ; C01-G-5A45
(ucs-set-char #x60C5 ?$@>p(B) ; J78-@-3E70
(ucs-set-char #x60C5 ?$AGi(B) ; GB0-A-4769
(ucs-set-char #x60C5 ?$B>p(B) ; J83-B-3E70
(ucs-set-char #x60C6 ?$(GZL(B) ; C01-G-5A4C
(ucs-set-char #x60C6 ?$@X/(B) ; J78-@-582F
(ucs-set-char #x60C6 ?$Ac0(B) ; GB0-A-6330
(ucs-set-char #x60C6 ?$BX/(B) ; J83-B-582F
(ucs-set-char #x60C7 ?$(CTC(B) ; KS0-C-5443
(ucs-set-char #x60C7 ?$(GZP(B) ; C01-G-5A50
(ucs-set-char #x60C7 ?$@FW(B) ; J78-@-4657
(ucs-set-char #x60C7 ?$BFW(B) ; J83-B-4657
(ucs-set-char #x60C8 ?$(D>%(B) ; J90-D-3E25
(ucs-set-char #x60C8 ?$(H5A(B) ; C02-H-3541
(ucs-set-char #x60C9 ?$(D>&(B) ; J90-D-3E26
(ucs-set-char #x60C9 ?$(H;\(B) ; C02-H-3B5C
(ucs-set-char #x60CA ?$(D>'(B) ; J90-D-3E27
(ucs-set-char #x60CA ?$(H5E(B) ; C02-H-3545
(ucs-set-char #x60CA ?$A>*(B) ; GB0-A-3E2A
(ucs-set-char #x60CB ?$(D>((B) ; J90-D-3E28
(ucs-set-char #x60CB ?$(GZA(B) ; C01-G-5A41
(ucs-set-char #x60CB ?$AMo(B) ; GB0-A-4D6F
(ucs-set-char #x60CC ?$(H;^(B) ; C02-H-3B5E
(ucs-set-char #x60CD ?$(H5H(B) ; C02-H-3548
(ucs-set-char #x60CE ?$(D>)(B) ; J90-D-3E29
(ucs-set-char #x60CE ?$(H;`(B) ; C02-H-3B60
(ucs-set-char #x60CF ?$(D>*(B) ; J90-D-3E2A
(ucs-set-char #x60CF ?$(H5=(B) ; C02-H-353D
(ucs-set-char #x60D0 ?$(I5j(B) ; C03-I-356A
(ucs-set-char #x60D1 ?$(C{c(B) ; KS0-C-7B63
(ucs-set-char #x60D1 ?$(G_)(B) ; C01-G-5F29
(ucs-set-char #x60D1 ?$@OG(B) ; J78-@-4F47
(ucs-set-char #x60D1 ?$A;s(B) ; GB0-A-3B73
(ucs-set-char #x60D1 ?$BOG(B) ; J83-B-4F47
(ucs-set-char #x60D2 ?$(I;V(B) ; C03-I-3B56
(ucs-set-char #x60D3 ?$(H5;(B) ; C02-H-353B
(ucs-set-char #x60D3 ?$@X+(B) ; J78-@-582B
(ucs-set-char #x60D3 ?$BX+(B) ; J83-B-582B
(ucs-set-char #x60D4 ?$(D>+(B) ; J90-D-3E2B
(ucs-set-char #x60D4 ?$(H5<(B) ; C02-H-353C
(ucs-set-char #x60D5 ?$(D>,(B) ; J90-D-3E2C
(ucs-set-char #x60D5 ?$(GZK(B) ; C01-G-5A4B
(ucs-set-char #x60D5 ?$ALh(B) ; GB0-A-4C68
(ucs-set-char #x60D6 ?$(I;U(B) ; C03-I-3B55
(ucs-set-char #x60D7 ?$(I5n(B) ; C03-I-356E
(ucs-set-char #x60D8 ?$(GZJ(B) ; C01-G-5A4A
(ucs-set-char #x60D8 ?$@X1(B) ; J78-@-5831
(ucs-set-char #x60D8 ?$Ac/(B) ; GB0-A-632F
(ucs-set-char #x60D8 ?$BX1(B) ; J83-B-5831
(ucs-set-char #x60D9 ?$(D>-(B) ; J90-D-3E2D
(ucs-set-char #x60D9 ?$(H5?(B) ; C02-H-353F
(ucs-set-char #x60DA ?$(C{m(B) ; KS0-C-7B6D
(ucs-set-char #x60DA ?$(GZO(B) ; C01-G-5A4F
(ucs-set-char #x60DA ?$@9{(B) ; J78-@-397B
(ucs-set-char #x60DA ?$Ac1(B) ; GB0-A-6331
(ucs-set-char #x60DA ?$B9{(B) ; J83-B-397B
(ucs-set-char #x60DB ?$(D>.(B) ; J90-D-3E2E
(ucs-set-char #x60DB ?$(H5C(B) ; C02-H-3543
(ucs-set-char #x60DC ?$(C`-(B) ; KS0-C-602D
(ucs-set-char #x60DC ?$(GZH(B) ; C01-G-5A48
(ucs-set-char #x60DC ?$@@K(B) ; J78-@-404B
(ucs-set-char #x60DC ?$AO'(B) ; GB0-A-4F27
(ucs-set-char #x60DC ?$B@K(B) ; J83-B-404B
(ucs-set-char #x60DD ?$(D>/(B) ; J90-D-3E2F
(ucs-set-char #x60DD ?$(H5@(B) ; C02-H-3540
(ucs-set-char #x60DD ?$Ac.(B) ; GB0-A-632E
(ucs-set-char #x60DE ?$(D>0(B) ; J90-D-3E30
(ucs-set-char #x60DE ?$(I5y(B) ; C03-I-3579
(ucs-set-char #x60DF ?$(Cjn(B) ; KS0-C-6A6E
(ucs-set-char #x60DF ?$(GZM(B) ; C01-G-5A4D
(ucs-set-char #x60DF ?$@0T(B) ; J78-@-3054
(ucs-set-char #x60DF ?$AN)(B) ; GB0-A-4E29
(ucs-set-char #x60DF ?$B0T(B) ; J83-B-3054
(ucs-set-char #x60E0 ?$(C{3(B) ; KS0-C-7B33
(ucs-set-char #x60E0 ?$(G_-(B) ; C01-G-5F2D
(ucs-set-char #x60E0 ?$@X*(B) ; J78-@-582A
(ucs-set-char #x60E0 ?$A;](B) ; GB0-A-3B5D
(ucs-set-char #x60E0 ?$BX*(B) ; J83-B-582A
(ucs-set-char #x60E1 ?$(CdB(B) ; KS0-C-6442
(ucs-set-char #x60E1 ?$(G_*(B) ; C01-G-5F2A
(ucs-set-char #x60E1 ?$@X((B) ; J78-@-5828
(ucs-set-char #x60E1 ?$BX((B) ; J83-B-5828
(ucs-set-char #x60E2 ?$(D>1(B) ; J90-D-3E31
(ucs-set-char #x60E2 ?$(H;_(B) ; C02-H-3B5F
(ucs-set-char #x60E3 ?$(I;X(B) ; C03-I-3B58
(ucs-set-char #x60E3 ?$@AZ(B) ; J78-@-415A
(ucs-set-char #x60E3 ?$BAZ(B) ; J83-B-415A
(ucs-set-char #x60E4 ?$(H5>(B) ; C02-H-353E
(ucs-set-char #x60E5 ?$(D>2(B) ; J90-D-3E32
(ucs-set-char #x60E5 ?$(I;Y(B) ; C03-I-3B59
(ucs-set-char #x60E6 ?$(GZC(B) ; C01-G-5A43
(ucs-set-char #x60E6 ?$A5k(B) ; GB0-A-356B
(ucs-set-char #x60E7 ?$(I5v(B) ; C03-I-3576
(ucs-set-char #x60E7 ?$@W|(B) ; J78-@-577C
(ucs-set-char #x60E7 ?$A>e(B) ; GB0-A-3E65
(ucs-set-char #x60E7 ?$BW|(B) ; J83-B-577C
(ucs-set-char #x60E8 ?$@;4(B) ; J78-@-3B34
(ucs-set-char #x60E8 ?$A2R(B) ; GB0-A-3252
(ucs-set-char #x60E8 ?$B;4(B) ; J83-B-3B34
(ucs-set-char #x60E9 ?$(I;Z(B) ; C03-I-3B5A
(ucs-set-char #x60E9 ?$A3M(B) ; GB0-A-334D
(ucs-set-char #x60EA ?$(I;M(B) ; C03-I-3B4D
(ucs-set-char #x60EB ?$A19(B) ; GB0-A-3139
(ucs-set-char #x60EC ?$Ac+(B) ; GB0-A-632B
(ucs-set-char #x60ED ?$A2Q(B) ; GB0-A-3251
(ucs-set-char #x60EE ?$(I5t(B) ; C03-I-3574
(ucs-set-char #x60EE ?$A5,(B) ; GB0-A-352C
(ucs-set-char #x60EF ?$A9_(B) ; GB0-A-395F
(ucs-set-char #x60F0 ?$(Cvg(B) ; KS0-C-7667
(ucs-set-char #x60F0 ?$(G_2(B) ; C01-G-5F32
(ucs-set-char #x60F0 ?$@BF(B) ; J78-@-4246
(ucs-set-char #x60F0 ?$A6h(B) ; GB0-A-3668
(ucs-set-char #x60F0 ?$BBF(B) ; J83-B-4246
(ucs-set-char #x60F1 ?$(CR](B) ; KS0-C-525D
(ucs-set-char #x60F1 ?$(G_6(B) ; C01-G-5F36
(ucs-set-char #x60F1 ?$@X=(B) ; J78-@-583D
(ucs-set-char #x60F1 ?$BX=(B) ; J83-B-583D
(ucs-set-char #x60F2 ?$(D>3(B) ; J90-D-3E33
(ucs-set-char #x60F2 ?$(H;c(B) ; C02-H-3B63
(ucs-set-char #x60F3 ?$(C_L(B) ; KS0-C-5F4C
(ucs-set-char #x60F3 ?$(Gcw(B) ; C01-G-6377
(ucs-set-char #x60F3 ?$@A[(B) ; J78-@-415B
(ucs-set-char #x60F3 ?$AOk(B) ; GB0-A-4F6B
(ucs-set-char #x60F3 ?$BA[(B) ; J83-B-415B
(ucs-set-char #x60F4 ?$(G_4(B) ; C01-G-5F34
(ucs-set-char #x60F4 ?$@X8(B) ; J78-@-5838
(ucs-set-char #x60F4 ?$Ac7(B) ; GB0-A-6337
(ucs-set-char #x60F4 ?$BX8(B) ; J83-B-5838
(ucs-set-char #x60F5 ?$(D>4(B) ; J90-D-3E34
(ucs-set-char #x60F5 ?$(H;g(B) ; C02-H-3B67
(ucs-set-char #x60F6 ?$(C|I(B) ; KS0-C-7C49
(ucs-set-char #x60F6 ?$(G_8(B) ; C01-G-5F38
(ucs-set-char #x60F6 ?$@X5(B) ; J78-@-5835
(ucs-set-char #x60F6 ?$A;L(B) ; GB0-A-3B4C
(ucs-set-char #x60F6 ?$BX5(B) ; J83-B-5835
(ucs-set-char #x60F7 ?$(HBk(B) ; C02-H-426B
(ucs-set-char #x60F7 ?$@X6(B) ; J78-@-5836
(ucs-set-char #x60F7 ?$BX6(B) ; J83-B-5836
(ucs-set-char #x60F8 ?$(D>5(B) ; J90-D-3E35
(ucs-set-char #x60F8 ?$(H;i(B) ; C02-H-3B69
(ucs-set-char #x60F9 ?$(Ce)(B) ; KS0-C-6529
(ucs-set-char #x60F9 ?$(Gcy(B) ; C01-G-6379
(ucs-set-char #x60F9 ?$@<f(B) ; J78-@-3C66
(ucs-set-char #x60F9 ?$AHG(B) ; GB0-A-4847
(ucs-set-char #x60F9 ?$B<f(B) ; J83-B-3C66
(ucs-set-char #x60FA ?$(C`v(B) ; KS0-C-6076
(ucs-set-char #x60FA ?$(G_0(B) ; C01-G-5F30
(ucs-set-char #x60FA ?$@X9(B) ; J78-@-5839
(ucs-set-char #x60FA ?$APJ(B) ; GB0-A-504A
(ucs-set-char #x60FA ?$BX9(B) ; J83-B-5839
(ucs-set-char #x60FB ?$(Cv3(B) ; KS0-C-7633
(ucs-set-char #x60FB ?$(G_3(B) ; C01-G-5F33
(ucs-set-char #x60FB ?$@X<(B) ; J78-@-583C
(ucs-set-char #x60FB ?$BX<(B) ; J83-B-583C
(ucs-set-char #x60FC ?$(D>6(B) ; J90-D-3E36
(ucs-set-char #x60FC ?$(H;j(B) ; C02-H-3B6A
(ucs-set-char #x60FD ?$(D>7(B) ; J90-D-3E37
(ucs-set-char #x60FD ?$(I;^(B) ; C03-I-3B5E
(ucs-set-char #x60FE ?$(H;k(B) ; C02-H-3B6B
(ucs-set-char #x60FF ?$(H;q(B) ; C02-H-3B71
(ucs-set-char #x6100 ?$(G_:(B) ; C01-G-5F3A
(ucs-set-char #x6100 ?$@X7(B) ; J78-@-5837
(ucs-set-char #x6100 ?$Ac8(B) ; GB0-A-6338
(ucs-set-char #x6100 ?$BX7(B) ; J83-B-5837
(ucs-set-char #x6101 ?$(Ca~(B) ; KS0-C-617E
(ucs-set-char #x6101 ?$(Gcz(B) ; C01-G-637A
(ucs-set-char #x6101 ?$@=%(B) ; J78-@-3D25
(ucs-set-char #x6101 ?$A3n(B) ; GB0-A-336E
(ucs-set-char #x6101 ?$B=%(B) ; J83-B-3D25
(ucs-set-char #x6102 ?$(D>8(B) ; J90-D-3E38
(ucs-set-char #x6102 ?$(J==(B) ; C04-J-3D3D
(ucs-set-char #x6103 ?$(H;m(B) ; C02-H-3B6D
(ucs-set-char #x6103 ?$@X:(B) ; J78-@-583A
(ucs-set-char #x6103 ?$BX:(B) ; J83-B-583A
(ucs-set-char #x6104 ?$(H;r(B) ; C02-H-3B72
(ucs-set-char #x6105 ?$(H;f(B) ; C02-H-3B66
(ucs-set-char #x6106 ?$(CKp(B) ; KS0-C-4B70
(ucs-set-char #x6106 ?$(Gd&(B) ; C01-G-6426
(ucs-set-char #x6106 ?$@X4(B) ; J78-@-5834
(ucs-set-char #x6106 ?$Am)(B) ; GB0-A-6D29
(ucs-set-char #x6106 ?$BX4(B) ; J83-B-5834
(ucs-set-char #x6107 ?$(D>9(B) ; J90-D-3E39
(ucs-set-char #x6107 ?$(I;O(B) ; C03-I-3B4F
(ucs-set-char #x6108 ?$(Cjo(B) ; KS0-C-6A6F
(ucs-set-char #x6108 ?$(Gc{(B) ; C01-G-637B
(ucs-set-char #x6108 ?$@L|(B) ; J78-@-4C7C
(ucs-set-char #x6108 ?$ASz(B) ; GB0-A-537A
(ucs-set-char #x6108 ?$BL|(B) ; J83-B-4C7C
(ucs-set-char #x6109 ?$(Cjp(B) ; KS0-C-6A70
(ucs-set-char #x6109 ?$(G_9(B) ; C01-G-5F39
(ucs-set-char #x6109 ?$@L{(B) ; J78-@-4C7B
(ucs-set-char #x6109 ?$ASd(B) ; GB0-A-5364
(ucs-set-char #x6109 ?$BL{(B) ; J83-B-4C7B
(ucs-set-char #x610A ?$(D>:(B) ; J90-D-3E3A
(ucs-set-char #x610A ?$(H;d(B) ; C02-H-3B64
(ucs-set-char #x610B ?$(H;s(B) ; C02-H-3B73
(ucs-set-char #x610C ?$(D>;(B) ; J90-D-3E3B
(ucs-set-char #x610C ?$(I;Q(B) ; C03-I-3B51
(ucs-set-char #x610D ?$(CZ@(B) ; KS0-C-5A40
(ucs-set-char #x610D ?$(Gd%(B) ; C01-G-6425
(ucs-set-char #x610D ?$@X>(B) ; J78-@-583E
(ucs-set-char #x610D ?$Am*(B) ; GB0-A-6D2A
(ucs-set-char #x610D ?$BX>(B) ; J83-B-583E
(ucs-set-char #x610E ?$(Cx4(B) ; KS0-C-7834
(ucs-set-char #x610E ?$(G_7(B) ; C01-G-5F37
(ucs-set-char #x610E ?$@X?(B) ; J78-@-583F
(ucs-set-char #x610E ?$Ac9(B) ; GB0-A-6339
(ucs-set-char #x610E ?$BX?(B) ; J83-B-583F
(ucs-set-char #x610F ?$(Ckr(B) ; KS0-C-6B72
(ucs-set-char #x610F ?$(Gct(B) ; C01-G-6374
(ucs-set-char #x610F ?$@0U(B) ; J78-@-3055
(ucs-set-char #x610F ?$ARb(B) ; GB0-A-5262
(ucs-set-char #x610F ?$B0U(B) ; J83-B-3055
(ucs-set-char #x6110 ?$(D><(B) ; J90-D-3E3C
(ucs-set-char #x6110 ?$(H;p(B) ; C02-H-3B70
(ucs-set-char #x6111 ?$(D>=(B) ; J90-D-3E3D
(ucs-set-char #x6111 ?$(I;](B) ; C03-I-3B5D
(ucs-set-char #x6112 ?$(D>>(B) ; J90-D-3E3E
(ucs-set-char #x6112 ?$(G_;(B) ; C01-G-5F3B
(ucs-set-char #x6113 ?$(D>?(B) ; J90-D-3E3F
(ucs-set-char #x6113 ?$(H;h(B) ; C02-H-3B68
(ucs-set-char #x6114 ?$(D>@(B) ; J90-D-3E40
(ucs-set-char #x6114 ?$(H;b(B) ; C02-H-3B62
(ucs-set-char #x6115 ?$(CdC(B) ; KS0-C-6443
(ucs-set-char #x6115 ?$(G_1(B) ; C01-G-5F31
(ucs-set-char #x6115 ?$@X3(B) ; J78-@-5833
(ucs-set-char #x6115 ?$Ac5(B) ; GB0-A-6335
(ucs-set-char #x6115 ?$BX3(B) ; J83-B-5833
(ucs-set-char #x6116 ?$(D>A(B) ; J90-D-3E41
(ucs-set-char #x6116 ?$(H;e(B) ; C02-H-3B65
(ucs-set-char #x6117 ?$(D>B(B) ; J90-D-3E42
(ucs-set-char #x6117 ?$(K?0(B) ; C05-K-3F30
(ucs-set-char #x6118 ?$(H;n(B) ; C02-H-3B6E
(ucs-set-char #x6119 ?$(D>C(B) ; J90-D-3E43
(ucs-set-char #x6119 ?$(IA+(B) ; C03-I-412B
(ucs-set-char #x611A ?$(CiW(B) ; KS0-C-6957
(ucs-set-char #x611A ?$(Gcs(B) ; C01-G-6373
(ucs-set-char #x611A ?$@6r(B) ; J78-@-3672
(ucs-set-char #x611A ?$AS^(B) ; GB0-A-535E
(ucs-set-char #x611A ?$B6r(B) ; J83-B-3672
(ucs-set-char #x611B ?$(Cdq(B) ; KS0-C-6471
(ucs-set-char #x611B ?$(Gcx(B) ; C01-G-6378
(ucs-set-char #x611B ?$@0&(B) ; J78-@-3026
(ucs-set-char #x611B ?$B0&(B) ; J83-B-3026
(ucs-set-char #x611C ?$(D>D(B) ; J90-D-3E44
(ucs-set-char #x611C ?$(G_.(B) ; C01-G-5F2E
(ucs-set-char #x611D ?$(H;o(B) ; C02-H-3B6F
(ucs-set-char #x611E ?$(D>E(B) ; J90-D-3E45
(ucs-set-char #x611E ?$(I;a(B) ; C03-I-3B61
(ucs-set-char #x611F ?$(CJo(B) ; KS0-C-4A6F
(ucs-set-char #x611F ?$(Gcv(B) ; C01-G-6376
(ucs-set-char #x611F ?$@46(B) ; J78-@-3436
(ucs-set-char #x611F ?$A8P(B) ; GB0-A-3850
(ucs-set-char #x611F ?$B46(B) ; J83-B-3436
(ucs-set-char #x6120 ?$(I;b(B) ; C03-I-3B62
(ucs-set-char #x6120 ?$Ac3(B) ; GB0-A-6333
(ucs-set-char #x6121 ?$(I;c(B) ; C03-I-3B63
(ucs-set-char #x6121 ?$@X;(B) ; J78-@-583B
(ucs-set-char #x6121 ?$BX;(B) ; J83-B-583B
(ucs-set-char #x6122 ?$(D>F(B) ; J90-D-3E46
(ucs-set-char #x6122 ?$(I;P(B) ; C03-I-3B50
(ucs-set-char #x6123 ?$(G_/(B) ; C01-G-5F2F
(ucs-set-char #x6123 ?$Ac6(B) ; GB0-A-6336
(ucs-set-char #x6124 ?$A7_(B) ; GB0-A-375F
(ucs-set-char #x6126 ?$Ac4(B) ; GB0-A-6334
(ucs-set-char #x6127 ?$(CNW(B) ; KS0-C-4E57
(ucs-set-char #x6127 ?$(Gd$(B) ; C01-G-6424
(ucs-set-char #x6127 ?$@XC(B) ; J78-@-5843
(ucs-set-char #x6127 ?$A@"(B) ; GB0-A-4022
(ucs-set-char #x6127 ?$BXC(B) ; J83-B-5843
(ucs-set-char #x6128 ?$(HJ*(B) ; C02-H-4A2A
(ucs-set-char #x6128 ?$@XB(B) ; J78-@-5842
(ucs-set-char #x6128 ?$BXB(B) ; J83-B-5842
(ucs-set-char #x6129 ?$(HBv(B) ; C02-H-4276
(ucs-set-char #x612A ?$(D>G(B) ; J90-D-3E47
(ucs-set-char #x612A ?$(IA)(B) ; C03-I-4129
(ucs-set-char #x612B ?$(D>H(B) ; J90-D-3E48
(ucs-set-char #x612B ?$(HBn(B) ; C02-H-426E
(ucs-set-char #x612B ?$Ac:(B) ; GB0-A-633A
(ucs-set-char #x612C ?$(HJ)(B) ; C02-H-4A29
(ucs-set-char #x612C ?$@XG(B) ; J78-@-5847
(ucs-set-char #x612C ?$BXG(B) ; J83-B-5847
(ucs-set-char #x612D ?$(J=9(B) ; C04-J-3D39
(ucs-set-char #x612E ?$(HBr(B) ; C02-H-4272
(ucs-set-char #x612F ?$(HBt(B) ; C02-H-4274
(ucs-set-char #x6130 ?$(C|J(B) ; KS0-C-7C4A
(ucs-set-char #x6130 ?$(D>I(B) ; J90-D-3E49
(ucs-set-char #x6130 ?$(IA'(B) ; C03-I-4127
(ucs-set-char #x6131 ?$(D>J(B) ; J90-D-3E4A
(ucs-set-char #x6131 ?$(IA,(B) ; C03-I-412C
(ucs-set-char #x6132 ?$(HBq(B) ; C02-H-4271
(ucs-set-char #x6133 ?$(IFo(B) ; C03-I-466F
(ucs-set-char #x6134 ?$(Csa(B) ; KS0-C-7361
(ucs-set-char #x6134 ?$(Gd#(B) ; C01-G-6423
(ucs-set-char #x6134 ?$@XH(B) ; J78-@-5848
(ucs-set-char #x6134 ?$BXH(B) ; J83-B-5848
(ucs-set-char #x6135 ?$(D>K(B) ; J90-D-3E4B
(ucs-set-char #x6135 ?$(J=8(B) ; C04-J-3D38
(ucs-set-char #x6136 ?$(D>L(B) ; J90-D-3E4C
(ucs-set-char #x6136 ?$(HBp(B) ; C02-H-4270
(ucs-set-char #x6137 ?$(CKD(B) ; KS0-C-4B44
(ucs-set-char #x6137 ?$(D>M(B) ; J90-D-3E4D
(ucs-set-char #x6137 ?$(Gd'(B) ; C01-G-6427
(ucs-set-char #x6138 ?$(IFn(B) ; C03-I-466E
(ucs-set-char #x6139 ?$(D>N(B) ; J90-D-3E4E
(ucs-set-char #x6139 ?$(LRd(B) ; C06-L-5264
(ucs-set-char #x613A ?$(IA((B) ; C03-I-4128
(ucs-set-char #x613B ?$(HJ9(B) ; C02-H-4A39
(ucs-set-char #x613C ?$(Cce(B) ; KS0-C-6365
(ucs-set-char #x613C ?$(IFl(B) ; C03-I-466C
(ucs-set-char #x613C ?$@XF(B) ; J78-@-5846
(ucs-set-char #x613C ?$BXF(B) ; J83-B-5846
(ucs-set-char #x613D ?$(IA.(B) ; C03-I-412E
(ucs-set-char #x613D ?$@XI(B) ; J78-@-5849
(ucs-set-char #x613D ?$BXI(B) ; J83-B-5849
(ucs-set-char #x613E ?$(CKE(B) ; KS0-C-4B45
(ucs-set-char #x613E ?$(Gd"(B) ; C01-G-6422
(ucs-set-char #x613E ?$@XA(B) ; J78-@-5841
(ucs-set-char #x613E ?$BXA(B) ; J83-B-5841
(ucs-set-char #x613F ?$(Cj4(B) ; KS0-C-6A34
(ucs-set-char #x613F ?$(Ghg(B) ; C01-G-6867
(ucs-set-char #x613F ?$@XE(B) ; J78-@-5845
(ucs-set-char #x613F ?$AT8(B) ; GB0-A-5438
(ucs-set-char #x613F ?$BXE(B) ; J83-B-5845
(ucs-set-char #x6140 ?$(HBw(B) ; C02-H-4277
(ucs-set-char #x6141 ?$(D>O(B) ; J90-D-3E4F
(ucs-set-char #x6141 ?$(HJ+(B) ; C02-H-4A2B
(ucs-set-char #x6142 ?$(Ci=(B) ; KS0-C-693D
(ucs-set-char #x6142 ?$(IFm(B) ; C03-I-466D
(ucs-set-char #x6142 ?$@XJ(B) ; J78-@-584A
(ucs-set-char #x6142 ?$BXJ(B) ; J83-B-584A
(ucs-set-char #x6143 ?$(IA*(B) ; C03-I-412A
(ucs-set-char #x6144 ?$(CWI(B) ; KS0-C-5749
(ucs-set-char #x6144 ?$(Gc~(B) ; C01-G-637E
(ucs-set-char #x6144 ?$@XK(B) ; J78-@-584B
(ucs-set-char #x6144 ?$BXK(B) ; J83-B-584B
(ucs-set-char #x6145 ?$(D>P(B) ; J90-D-3E50
(ucs-set-char #x6145 ?$(HBo(B) ; C02-H-426F
(ucs-set-char #x6146 ?$(D>Q(B) ; J90-D-3E51
(ucs-set-char #x6146 ?$(HBs(B) ; C02-H-4273
(ucs-set-char #x6147 ?$(Ck[(B) ; KS0-C-6B5B
(ucs-set-char #x6147 ?$(Ghf(B) ; C01-G-6866
(ucs-set-char #x6147 ?$@X@(B) ; J78-@-5840
(ucs-set-char #x6147 ?$BX@(B) ; J83-B-5840
(ucs-set-char #x6148 ?$(Cm1(B) ; KS0-C-6D31
(ucs-set-char #x6148 ?$(Gcu(B) ; C01-G-6375
(ucs-set-char #x6148 ?$@;|(B) ; J78-@-3B7C
(ucs-set-char #x6148 ?$A4H(B) ; GB0-A-3448
(ucs-set-char #x6148 ?$B;|(B) ; J83-B-3B7C
(ucs-set-char #x6149 ?$(D>R(B) ; J90-D-3E52
(ucs-set-char #x6149 ?$(HBl(B) ; C02-H-426C
(ucs-set-char #x614A ?$(CLC(B) ; KS0-C-4C43
(ucs-set-char #x614A ?$(HBm(B) ; C02-H-426D
(ucs-set-char #x614A ?$@XD(B) ; J78-@-5844
(ucs-set-char #x614A ?$Ac;(B) ; GB0-A-633B
(ucs-set-char #x614A ?$BXD(B) ; J83-B-5844
(ucs-set-char #x614B ?$(Cw>(B) ; KS0-C-773E
(ucs-set-char #x614B ?$(Ghh(B) ; C01-G-6868
(ucs-set-char #x614B ?$@BV(B) ; J78-@-4256
(ucs-set-char #x614B ?$BBV(B) ; J83-B-4256
(ucs-set-char #x614C ?$(C|K(B) ; KS0-C-7C4B
(ucs-set-char #x614C ?$(Gc}(B) ; C01-G-637D
(ucs-set-char #x614C ?$@92(B) ; J78-@-3932
(ucs-set-char #x614C ?$A;E(B) ; GB0-A-3B45
(ucs-set-char #x614C ?$B92(B) ; J83-B-3932
(ucs-set-char #x614D ?$(Gd!(B) ; C01-G-6421
(ucs-set-char #x614D ?$@X2(B) ; J78-@-5832
(ucs-set-char #x614D ?$BX2(B) ; J83-B-5832
(ucs-set-char #x614E ?$(Gc|(B) ; C01-G-637C
(ucs-set-char #x614E ?$(LRf(B) ; C06-L-5266
(ucs-set-char #x614E ?$@?5(B) ; J78-@-3F35
(ucs-set-char #x614E ?$AIw(B) ; GB0-A-4977
(ucs-set-char #x614E ?$B?5(B) ; J83-B-3F35
(ucs-set-char #x614F ?$(HBu(B) ; C02-H-4275
(ucs-set-char #x6151 ?$AIe(B) ; GB0-A-4965
(ucs-set-char #x6152 ?$(HJ/(B) ; C02-H-4A2F
(ucs-set-char #x6153 ?$(Cxt(B) ; KS0-C-7874
(ucs-set-char #x6153 ?$(HJ0(B) ; C02-H-4A30
(ucs-set-char #x6153 ?$@XX(B) ; J78-@-5858
(ucs-set-char #x6153 ?$BXX(B) ; J83-B-5858
(ucs-set-char #x6154 ?$(HJ5(B) ; C02-H-4A35
(ucs-set-char #x6155 ?$(CY7(B) ; KS0-C-5937
(ucs-set-char #x6155 ?$(Glg(B) ; C01-G-6C67
(ucs-set-char #x6155 ?$@Ji(B) ; J78-@-4A69
(ucs-set-char #x6155 ?$AD=(B) ; GB0-A-443D
(ucs-set-char #x6155 ?$BJi(B) ; J83-B-4A69
(ucs-set-char #x6156 ?$(HJ<(B) ; C02-H-4A3C
(ucs-set-char #x6157 ?$(IKs(B) ; C03-I-4B73
(ucs-set-char #x6158 ?$(CsS(B) ; KS0-C-7353
(ucs-set-char #x6158 ?$(Ghn(B) ; C01-G-686E
(ucs-set-char #x6158 ?$@XN(B) ; J78-@-584E
(ucs-set-char #x6158 ?$BXN(B) ; J83-B-584E
(ucs-set-char #x6159 ?$(CsT(B) ; KS0-C-7354
(ucs-set-char #x6159 ?$(IK~(B) ; C03-I-4B7E
(ucs-set-char #x6159 ?$@XO(B) ; J78-@-584F
(ucs-set-char #x6159 ?$BXO(B) ; J83-B-584F
(ucs-set-char #x615A ?$(Ghm(B) ; C01-G-686D
(ucs-set-char #x615A ?$@XP(B) ; J78-@-5850
(ucs-set-char #x615A ?$BXP(B) ; J83-B-5850
(ucs-set-char #x615B ?$(HJ7(B) ; C02-H-4A37
(ucs-set-char #x615C ?$(IKt(B) ; C03-I-4B74
(ucs-set-char #x615D ?$(Cwd(B) ; KS0-C-7764
(ucs-set-char #x615D ?$(Glf(B) ; C01-G-6C66
(ucs-set-char #x615D ?$@XW(B) ; J78-@-5857
(ucs-set-char #x615D ?$Am+(B) ; GB0-A-6D2B
(ucs-set-char #x615D ?$BXW(B) ; J83-B-5857
(ucs-set-char #x615E ?$(D>S(B) ; J90-D-3E53
(ucs-set-char #x615E ?$(HJ,(B) ; C02-H-4A2C
(ucs-set-char #x615F ?$(CwQ(B) ; KS0-C-7751
(ucs-set-char #x615F ?$(Ghl(B) ; C01-G-686C
(ucs-set-char #x615F ?$@XV(B) ; J78-@-5856
(ucs-set-char #x615F ?$BXV(B) ; J83-B-5856
(ucs-set-char #x6160 ?$(D>T(B) ; J90-D-3E54
(ucs-set-char #x6160 ?$(IFq(B) ; C03-I-4671
(ucs-set-char #x6161 ?$(HJ;(B) ; C02-H-4A3B
(ucs-set-char #x6162 ?$(CX7(B) ; KS0-C-5837
(ucs-set-char #x6162 ?$(Ghj(B) ; C01-G-686A
(ucs-set-char #x6162 ?$@K}(B) ; J78-@-4B7D
(ucs-set-char #x6162 ?$AB}(B) ; GB0-A-427D
(ucs-set-char #x6162 ?$BK}(B) ; J83-B-4B7D
(ucs-set-char #x6163 ?$(CN1(B) ; KS0-C-4E31
(ucs-set-char #x6163 ?$(Ghk(B) ; C01-G-686B
(ucs-set-char #x6163 ?$@47(B) ; J78-@-3437
(ucs-set-char #x6163 ?$B47(B) ; J83-B-3437
(ucs-set-char #x6164 ?$(CJB(B) ; KS0-C-4A42
(ucs-set-char #x6164 ?$(IK|(B) ; C03-I-4B7C
(ucs-set-char #x6165 ?$(HJ8(B) ; C02-H-4A38
(ucs-set-char #x6165 ?$@XT(B) ; J78-@-5854
(ucs-set-char #x6165 ?$BXT(B) ; J83-B-5854
(ucs-set-char #x6166 ?$(HPQ(B) ; C02-H-5051
(ucs-set-char #x6167 ?$(C{4(B) ; KS0-C-7B34
(ucs-set-char #x6167 ?$(Gld(B) ; C01-G-6C64
(ucs-set-char #x6167 ?$@7E(B) ; J78-@-3745
(ucs-set-char #x6167 ?$A;[(B) ; GB0-A-3B5B
(ucs-set-char #x6167 ?$B7E(B) ; J83-B-3745
(ucs-set-char #x6168 ?$(CKF(B) ; KS0-C-4B46
(ucs-set-char #x6168 ?$(G_5(B) ; C01-G-5F35
(ucs-set-char #x6168 ?$@34(B) ; J78-@-3334
(ucs-set-char #x6168 ?$A?.(B) ; GB0-A-3F2E
(ucs-set-char #x6168 ?$B34(B) ; J83-B-3334
(ucs-set-char #x6169 ?$(IFr(B) ; C03-I-4672
(ucs-set-char #x616A ?$(HJ:(B) ; C02-H-4A3A
(ucs-set-char #x616B ?$(Cpv(B) ; KS0-C-7076
(ucs-set-char #x616B ?$(Glk(B) ; C01-G-6C6B
(ucs-set-char #x616B ?$@XQ(B) ; J78-@-5851
(ucs-set-char #x616B ?$BXQ(B) ; J83-B-5851
(ucs-set-char #x616C ?$(D>U(B) ; J90-D-3E55
(ucs-set-char #x616C ?$(HJ2(B) ; C02-H-4A32
(ucs-set-char #x616D ?$(JIo(B) ; C04-J-496F
(ucs-set-char #x616E ?$(CUg(B) ; KS0-C-5567
(ucs-set-char #x616E ?$(Gle(B) ; C01-G-6C65
(ucs-set-char #x616E ?$@N8(B) ; J78-@-4E38
(ucs-set-char #x616E ?$BN8(B) ; J83-B-4E38
(ucs-set-char #x616F ?$(IFj(B) ; C03-I-466A
(ucs-set-char #x616F ?$@XS(B) ; J78-@-5853
(ucs-set-char #x616F ?$BXS(B) ; J83-B-5853
(ucs-set-char #x6170 ?$(CjP(B) ; KS0-C-6A50
(ucs-set-char #x6170 ?$(Glj(B) ; C01-G-6C6A
(ucs-set-char #x6170 ?$@0V(B) ; J78-@-3056
(ucs-set-char #x6170 ?$AN?(B) ; GB0-A-4E3F
(ucs-set-char #x6170 ?$B0V(B) ; J83-B-3056
(ucs-set-char #x6171 ?$(HJ-(B) ; C02-H-4A2D
(ucs-set-char #x6171 ?$@XU(B) ; J78-@-5855
(ucs-set-char #x6171 ?$BXU(B) ; J83-B-5855
(ucs-set-char #x6172 ?$(D>V(B) ; J90-D-3E56
(ucs-set-char #x6172 ?$(HJ1(B) ; C02-H-4A31
(ucs-set-char #x6173 ?$(HJ.(B) ; C02-H-4A2E
(ucs-set-char #x6173 ?$@XL(B) ; J78-@-584C
(ucs-set-char #x6173 ?$BXL(B) ; J83-B-584C
(ucs-set-char #x6174 ?$(HJ4(B) ; C02-H-4A34
(ucs-set-char #x6174 ?$@XR(B) ; J78-@-5852
(ucs-set-char #x6174 ?$BXR(B) ; J83-B-5852
(ucs-set-char #x6175 ?$(Gho(B) ; C01-G-686F
(ucs-set-char #x6175 ?$@XY(B) ; J78-@-5859
(ucs-set-char #x6175 ?$Ac<(B) ; GB0-A-633C
(ucs-set-char #x6175 ?$BXY(B) ; J83-B-5859
(ucs-set-char #x6176 ?$(CLT(B) ; KS0-C-4C54
(ucs-set-char #x6176 ?$(Glc(B) ; C01-G-6C63
(ucs-set-char #x6176 ?$@7D(B) ; J78-@-3744
(ucs-set-char #x6176 ?$B7D(B) ; J83-B-3744
(ucs-set-char #x6177 ?$(CK/(B) ; KS0-C-4B2F
(ucs-set-char #x6177 ?$(Ghi(B) ; C01-G-6869
(ucs-set-char #x6177 ?$@XM(B) ; J78-@-584D
(ucs-set-char #x6177 ?$A?6(B) ; GB0-A-3F36
(ucs-set-char #x6177 ?$BXM(B) ; J83-B-584D
(ucs-set-char #x6178 ?$(D>W(B) ; J90-D-3E57
(ucs-set-char #x6178 ?$(IL!(B) ; C03-I-4C21
(ucs-set-char #x6179 ?$(HPC(B) ; C02-H-5043
(ucs-set-char #x617A ?$(HJ6(B) ; C02-H-4A36
(ucs-set-char #x617B ?$(D>X(B) ; J90-D-3E58
(ucs-set-char #x617B ?$(IFh(B) ; C03-I-4668
(ucs-set-char #x617C ?$(D>Y(B) ; J90-D-3E59
(ucs-set-char #x617C ?$(Gli(B) ; C01-G-6C69
(ucs-set-char #x617D ?$(Ct*(B) ; KS0-C-742A
(ucs-set-char #x617D ?$(IFs(B) ; C03-I-4673
(ucs-set-char #x617E ?$(Ci/(B) ; KS0-C-692F
(ucs-set-char #x617E ?$(Gll(B) ; C01-G-6C6C
(ucs-set-char #x617E ?$@M](B) ; J78-@-4D5D
(ucs-set-char #x617E ?$BM](B) ; J83-B-4D5D
(ucs-set-char #x617F ?$(D>Z(B) ; J90-D-3E5A
(ucs-set-char #x617F ?$(M"q(B) ; C07-M-2271
(ucs-set-char #x6180 ?$(D>[(B) ; J90-D-3E5B
(ucs-set-char #x6180 ?$(HJ3(B) ; C02-H-4A33
(ucs-set-char #x6181 ?$(CuC(B) ; KS0-C-7543
(ucs-set-char #x6181 ?$(D>\(B) ; J90-D-3E5C
(ucs-set-char #x6181 ?$(IFk(B) ; C03-I-466B
(ucs-set-char #x6182 ?$(CiX(B) ; KS0-C-6958
(ucs-set-char #x6182 ?$(Glh(B) ; C01-G-6C68
(ucs-set-char #x6182 ?$@M+(B) ; J78-@-4D2B
(ucs-set-char #x6182 ?$BM+(B) ; J83-B-4D2B
(ucs-set-char #x6183 ?$(D>](B) ; J90-D-3E5D
(ucs-set-char #x6183 ?$(HPB(B) ; C02-H-5042
(ucs-set-char #x6184 ?$(D>^(B) ; J90-D-3E5E
(ucs-set-char #x6184 ?$(KM*(B) ; C05-K-4D2A
(ucs-set-char #x6185 ?$(IL#(B) ; C03-I-4C23
(ucs-set-char #x6186 ?$(IFt(B) ; C03-I-4674
(ucs-set-char #x6187 ?$(IL$(B) ; C03-I-4C24
(ucs-set-char #x6187 ?$@X\(B) ; J78-@-585C
(ucs-set-char #x6187 ?$BX\(B) ; J83-B-585C
(ucs-set-char #x6188 ?$(IKw(B) ; C03-I-4B77
(ucs-set-char #x6189 ?$(HPG(B) ; C02-H-5047
(ucs-set-char #x618A ?$(C]i(B) ; KS0-C-5D69
(ucs-set-char #x618A ?$(GpW(B) ; C01-G-7057
(ucs-set-char #x618A ?$@X`(B) ; J78-@-5860
(ucs-set-char #x618A ?$BX`(B) ; J83-B-5860
(ucs-set-char #x618B ?$(D>_(B) ; J90-D-3E5F
(ucs-set-char #x618B ?$(HPA(B) ; C02-H-5041
(ucs-set-char #x618B ?$A1o(B) ; GB0-A-316F
(ucs-set-char #x618C ?$(HW.(B) ; C02-H-572E
(ucs-set-char #x618D ?$(D>`(B) ; J90-D-3E60
(ucs-set-char #x618D ?$(HPP(B) ; C02-H-5050
(ucs-set-char #x618E ?$(Cqs(B) ; KS0-C-7173
(ucs-set-char #x618E ?$(Glp(B) ; C01-G-6C70
(ucs-set-char #x618E ?$(JCQ(B) ; C04-J-4351
(ucs-set-char #x618E ?$@A~(B) ; J78-@-417E
(ucs-set-char #x618E ?$ATw(B) ; GB0-A-5477
(ucs-set-char #x618E ?$BA~(B) ; J83-B-417E
(ucs-set-char #x618F ?$(IKz(B) ; C03-I-4B7A
(ucs-set-char #x6190 ?$(CU{(B) ; KS0-C-557B
(ucs-set-char #x6190 ?$(Gln(B) ; C01-G-6C6E
(ucs-set-char #x6190 ?$@Ny(B) ; J78-@-4E79
(ucs-set-char #x6190 ?$BNy(B) ; J83-B-4E79
(ucs-set-char #x6191 ?$(C^;(B) ; KS0-C-5E3B
(ucs-set-char #x6191 ?$(GpU(B) ; C01-G-7055
(ucs-set-char #x6191 ?$@Xa(B) ; J78-@-5861
(ucs-set-char #x6191 ?$BXa(B) ; J83-B-5861
(ucs-set-char #x6192 ?$(D>a(B) ; J90-D-3E61
(ucs-set-char #x6192 ?$(HPM(B) ; C02-H-504D
(ucs-set-char #x6193 ?$(D>b(B) ; J90-D-3E62
(ucs-set-char #x6193 ?$(HPI(B) ; C02-H-5049
(ucs-set-char #x6194 ?$(Ct{(B) ; KS0-C-747B
(ucs-set-char #x6194 ?$(Glt(B) ; C01-G-6C74
(ucs-set-char #x6194 ?$@X^(B) ; J78-@-585E
(ucs-set-char #x6194 ?$Ac>(B) ; GB0-A-633E
(ucs-set-char #x6194 ?$BX^(B) ; J83-B-585E
(ucs-set-char #x6195 ?$(IKv(B) ; C03-I-4B76
(ucs-set-char #x6196 ?$(HW%(B) ; C02-H-5725
(ucs-set-char #x6196 ?$@X[(B) ; J78-@-585B
(ucs-set-char #x6196 ?$BX[(B) ; J83-B-585B
(ucs-set-char #x6197 ?$(D>c(B) ; J90-D-3E63
(ucs-set-char #x6197 ?$(IPh(B) ; C03-I-5068
(ucs-set-char #x6198 ?$(C}s(B) ; KS0-C-7D73
(ucs-set-char #x6198 ?$(D>d(B) ; J90-D-3E64
(ucs-set-char #x6198 ?$(IL((B) ; C03-I-4C28
(ucs-set-char #x6199 ?$(C}r(B) ; KS0-C-7D72
(ucs-set-char #x6199 ?$(IPg(B) ; C03-I-5067
(ucs-set-char #x6199 ?$@XZ(B) ; J78-@-585A
(ucs-set-char #x6199 ?$BXZ(B) ; J83-B-585A
(ucs-set-char #x619A ?$(Cw&(B) ; KS0-C-7726
(ucs-set-char #x619A ?$(Glr(B) ; C01-G-6C72
(ucs-set-char #x619A ?$@X_(B) ; J78-@-585F
(ucs-set-char #x619A ?$BX_(B) ; J83-B-585F
(ucs-set-char #x619B ?$(HPH(B) ; C02-H-5048
(ucs-set-char #x619C ?$(D>e(B) ; J90-D-3E65
(ucs-set-char #x619C ?$(IL)(B) ; C03-I-4C29
(ucs-set-char #x619D ?$(D>f(B) ; J90-D-3E66
(ucs-set-char #x619D ?$(HW#(B) ; C02-H-5723
(ucs-set-char #x619D ?$Am-(B) ; GB0-A-6D2D
(ucs-set-char #x619E ?$(IL%(B) ; C03-I-4C25
(ucs-set-char #x619F ?$(D>g(B) ; J90-D-3E67
(ucs-set-char #x619F ?$(HPL(B) ; C02-H-504C
(ucs-set-char #x61A0 ?$(D>h(B) ; J90-D-3E68
(ucs-set-char #x61A0 ?$(JP;(B) ; C04-J-503B
(ucs-set-char #x61A1 ?$(HPO(B) ; C02-H-504F
(ucs-set-char #x61A2 ?$(HPF(B) ; C02-H-5046
(ucs-set-char #x61A3 ?$(IKy(B) ; C03-I-4B79
(ucs-set-char #x61A4 ?$(C]I(B) ; KS0-C-5D49
(ucs-set-char #x61A4 ?$(Gls(B) ; C01-G-6C73
(ucs-set-char #x61A4 ?$@J0(B) ; J78-@-4A30
(ucs-set-char #x61A4 ?$BJ0(B) ; J83-B-4A30
(ucs-set-char #x61A5 ?$(D>i(B) ; J90-D-3E69
(ucs-set-char #x61A5 ?$(JP7(B) ; C04-J-5037
(ucs-set-char #x61A6 ?$(IKu(B) ; C03-I-4B75
(ucs-set-char #x61A7 ?$(CTS(B) ; KS0-C-5453
(ucs-set-char #x61A7 ?$(Glm(B) ; C01-G-6C6D
(ucs-set-char #x61A7 ?$@F4(B) ; J78-@-4634
(ucs-set-char #x61A7 ?$Ac?(B) ; GB0-A-633F
(ucs-set-char #x61A7 ?$BF4(B) ; J83-B-4634
(ucs-set-char #x61A8 ?$(D>j(B) ; J90-D-3E6A
(ucs-set-char #x61A8 ?$(HW$(B) ; C02-H-5724
(ucs-set-char #x61A8 ?$A:)(B) ; GB0-A-3A29
(ucs-set-char #x61A9 ?$(CL((B) ; KS0-C-4C28
(ucs-set-char #x61A9 ?$(GpV(B) ; C01-G-7056
(ucs-set-char #x61A9 ?$@7F(B) ; J78-@-3746
(ucs-set-char #x61A9 ?$Am,(B) ; GB0-A-6D2C
(ucs-set-char #x61A9 ?$B7F(B) ; J83-B-3746
(ucs-set-char #x61AA ?$(D>k(B) ; J90-D-3E6B
(ucs-set-char #x61AA ?$(HPN(B) ; C02-H-504E
(ucs-set-char #x61AB ?$(CZA(B) ; KS0-C-5A41
(ucs-set-char #x61AB ?$(Glo(B) ; C01-G-6C6F
(ucs-set-char #x61AB ?$@Xb(B) ; J78-@-5862
(ucs-set-char #x61AB ?$BXb(B) ; J83-B-5862
(ucs-set-char #x61AC ?$(CLU(B) ; KS0-C-4C55
(ucs-set-char #x61AC ?$(Glq(B) ; C01-G-6C71
(ucs-set-char #x61AC ?$@X](B) ; J78-@-585D
(ucs-set-char #x61AC ?$Ac=(B) ; GB0-A-633D
(ucs-set-char #x61AC ?$BX](B) ; J83-B-585D
(ucs-set-char #x61AD ?$(D>l(B) ; J90-D-3E6C
(ucs-set-char #x61AD ?$(HPK(B) ; C02-H-504B
(ucs-set-char #x61AE ?$(CYd(B) ; KS0-C-5964
(ucs-set-char #x61AE ?$(Glu(B) ; C01-G-6C75
(ucs-set-char #x61AE ?$@Xc(B) ; J78-@-5863
(ucs-set-char #x61AE ?$BXc(B) ; J83-B-5863
(ucs-set-char #x61AF ?$(HPJ(B) ; C02-H-504A
(ucs-set-char #x61B0 ?$(HPE(B) ; C02-H-5045
(ucs-set-char #x61B1 ?$(HPD(B) ; C02-H-5044
(ucs-set-char #x61B2 ?$(CzJ(B) ; KS0-C-7A4A
(ucs-set-char #x61B2 ?$(GpT(B) ; C01-G-7054
(ucs-set-char #x61B2 ?$@7{(B) ; J78-@-377B
(ucs-set-char #x61B2 ?$B7{(B) ; J83-B-377B
(ucs-set-char #x61B3 ?$(HPR(B) ; C02-H-5052
(ucs-set-char #x61B4 ?$(HW'(B) ; C02-H-5727
(ucs-set-char #x61B5 ?$(H\k(B) ; C02-H-5C6B
(ucs-set-char #x61B6 ?$(Cec(B) ; KS0-C-6563
(ucs-set-char #x61B6 ?$(GpY(B) ; C01-G-7059
(ucs-set-char #x61B6 ?$@21(B) ; J78-@-3231
(ucs-set-char #x61B6 ?$B21(B) ; J83-B-3231
(ucs-set-char #x61B7 ?$(IPa(B) ; C03-I-5061
(ucs-set-char #x61B7 ?$Ac@(B) ; GB0-A-6340
(ucs-set-char #x61B8 ?$(D>m(B) ; J90-D-3E6D
(ucs-set-char #x61B8 ?$(HW-(B) ; C02-H-572D
(ucs-set-char #x61B9 ?$(D>n(B) ; J90-D-3E6E
(ucs-set-char #x61B9 ?$(IPc(B) ; C03-I-5063
(ucs-set-char #x61BA ?$(CS<(B) ; KS0-C-533C
(ucs-set-char #x61BA ?$(HW+(B) ; C02-H-572B
(ucs-set-char #x61BA ?$@Xk(B) ; J78-@-586B
(ucs-set-char #x61BA ?$BXk(B) ; J83-B-586B
(ucs-set-char #x61BB ?$(IPj(B) ; C03-I-506A
(ucs-set-char #x61BC ?$(D>o(B) ; J90-D-3E6F
(ucs-set-char #x61BC ?$(H\l(B) ; C02-H-5C6C
(ucs-set-char #x61BD ?$(IPd(B) ; C03-I-5064
(ucs-set-char #x61BE ?$(CJp(B) ; KS0-C-4A70
(ucs-set-char #x61BE ?$(GpZ(B) ; C01-G-705A
(ucs-set-char #x61BE ?$@48(B) ; J78-@-3438
(ucs-set-char #x61BE ?$A:6(B) ; GB0-A-3A36
(ucs-set-char #x61BE ?$B48(B) ; J83-B-3438
(ucs-set-char #x61BF ?$(HW,(B) ; C02-H-572C
(ucs-set-char #x61C0 ?$(D>p(B) ; J90-D-3E70
(ucs-set-char #x61C0 ?$(IPf(B) ; C03-I-5066
(ucs-set-char #x61C1 ?$(D>q(B) ; J90-D-3E71
(ucs-set-char #x61C1 ?$(HW)(B) ; C02-H-5729
(ucs-set-char #x61C2 ?$(D>r(B) ; J90-D-3E72
(ucs-set-char #x61C2 ?$(Gs](B) ; C01-G-735D
(ucs-set-char #x61C2 ?$A6.(B) ; GB0-A-362E
(ucs-set-char #x61C3 ?$(CPD(B) ; KS0-C-5044
(ucs-set-char #x61C3 ?$(H\j(B) ; C02-H-5C6A
(ucs-set-char #x61C3 ?$@Xi(B) ; J78-@-5869
(ucs-set-char #x61C3 ?$BXi(B) ; J83-B-5869
(ucs-set-char #x61C4 ?$(IPl(B) ; C03-I-506C
(ucs-set-char #x61C5 ?$(HW&(B) ; C02-H-5726
(ucs-set-char #x61C6 ?$(HW((B) ; C02-H-5728
(ucs-set-char #x61C6 ?$@Xj(B) ; J78-@-586A
(ucs-set-char #x61C6 ?$BXj(B) ; J83-B-586A
(ucs-set-char #x61C7 ?$(CJP(B) ; KS0-C-4A50
(ucs-set-char #x61C7 ?$(Gs^(B) ; C01-G-735E
(ucs-set-char #x61C7 ?$@:)(B) ; J78-@-3A29
(ucs-set-char #x61C7 ?$B:)(B) ; J83-B-3A29
(ucs-set-char #x61C8 ?$(Cz+(B) ; KS0-C-7A2B
(ucs-set-char #x61C8 ?$(Gp\(B) ; C01-G-705C
(ucs-set-char #x61C8 ?$@Xh(B) ; J78-@-5868
(ucs-set-char #x61C8 ?$AP8(B) ; GB0-A-5038
(ucs-set-char #x61C8 ?$BXh(B) ; J83-B-5868
(ucs-set-char #x61C9 ?$(Ckk(B) ; KS0-C-6B6B
(ucs-set-char #x61C9 ?$(Gs\(B) ; C01-G-735C
(ucs-set-char #x61C9 ?$@Xf(B) ; J78-@-5866
(ucs-set-char #x61C9 ?$BXf(B) ; J83-B-5866
(ucs-set-char #x61CA ?$(Cgx(B) ; KS0-C-6778
(ucs-set-char #x61CA ?$(Gp[(B) ; C01-G-705B
(ucs-set-char #x61CA ?$@Xe(B) ; J78-@-5865
(ucs-set-char #x61CA ?$A0C(B) ; GB0-A-3043
(ucs-set-char #x61CA ?$BXe(B) ; J83-B-5865
(ucs-set-char #x61CB ?$(CYe(B) ; KS0-C-5965
(ucs-set-char #x61CB ?$(Gs`(B) ; C01-G-7360
(ucs-set-char #x61CB ?$@Xl(B) ; J78-@-586C
(ucs-set-char #x61CB ?$Am.(B) ; GB0-A-6D2E
(ucs-set-char #x61CB ?$BXl(B) ; J83-B-586C
(ucs-set-char #x61CC ?$(HW*(B) ; C02-H-572A
(ucs-set-char #x61CC ?$@Xd(B) ; J78-@-5864
(ucs-set-char #x61CC ?$BXd(B) ; J83-B-5864
(ucs-set-char #x61CD ?$(GpX(B) ; C01-G-7058
(ucs-set-char #x61CD ?$@Xn(B) ; J78-@-586E
(ucs-set-char #x61CD ?$BXn(B) ; J83-B-586E
(ucs-set-char #x61CE ?$(D>s(B) ; J90-D-3E73
(ucs-set-char #x61CE ?$(IPb(B) ; C03-I-5062
(ucs-set-char #x61CF ?$(D>t(B) ; J90-D-3E74
(ucs-set-char #x61CF ?$(IPe(B) ; C03-I-5065
(ucs-set-char #x61D0 ?$(IPk(B) ; C03-I-506B
(ucs-set-char #x61D0 ?$@2{(B) ; J78-@-327B
(ucs-set-char #x61D0 ?$B2{(B) ; J83-B-327B
(ucs-set-char #x61D1 ?$Am/(B) ; GB0-A-6D2F
(ucs-set-char #x61D2 ?$A@A(B) ; GB0-A-4041
(ucs-set-char #x61D4 ?$AcA(B) ; GB0-A-6341
(ucs-set-char #x61D5 ?$(D>u(B) ; J90-D-3E75
(ucs-set-char #x61D5 ?$(J[+(B) ; C04-J-5B2B
(ucs-set-char #x61D6 ?$(Ha[(B) ; C02-H-615B
(ucs-set-char #x61D7 ?$(JV3(B) ; C04-J-5633
(ucs-set-char #x61D8 ?$(HaS(B) ; C02-H-6153
(ucs-set-char #x61D9 ?$(ITa(B) ; C03-I-5461
(ucs-set-char #x61DA ?$(IT_(B) ; C03-I-545F
(ucs-set-char #x61DB ?$(IT\(B) ; C03-I-545C
(ucs-set-char #x61DC ?$(D>v(B) ; J90-D-3E76
(ucs-set-char #x61DC ?$(IT^(B) ; C03-I-545E
(ucs-set-char #x61DD ?$(D>w(B) ; J90-D-3E77
(ucs-set-char #x61DD ?$(IT](B) ; C03-I-545D
(ucs-set-char #x61DE ?$(D>x(B) ; J90-D-3E78
(ucs-set-char #x61DE ?$(H\r(B) ; C02-H-5C72
(ucs-set-char #x61DF ?$(D>y(B) ; J90-D-3E79
(ucs-set-char #x61DF ?$(HaT(B) ; C02-H-6154
(ucs-set-char #x61E0 ?$(H\n(B) ; C02-H-5C6E
(ucs-set-char #x61E1 ?$(D>z(B) ; J90-D-3E7A
(ucs-set-char #x61E1 ?$(JV2(B) ; C04-J-5632
(ucs-set-char #x61E2 ?$(D>{(B) ; J90-D-3E7B
(ucs-set-char #x61E2 ?$(IT[(B) ; C03-I-545B
(ucs-set-char #x61E3 ?$(GvB(B) ; C01-G-7642
(ucs-set-char #x61E3 ?$@Xp(B) ; J78-@-5870
(ucs-set-char #x61E3 ?$BXp(B) ; J83-B-5870
(ucs-set-char #x61E4 ?$(H\p(B) ; C02-H-5C70
(ucs-set-char #x61E5 ?$(D>~(B) ; J90-D-3E7E
(ucs-set-char #x61E5 ?$(H\o(B) ; C02-H-5C6F
(ucs-set-char #x61E6 ?$(CQW(B) ; KS0-C-5157
(ucs-set-char #x61E6 ?$(Gs_(B) ; C01-G-735F
(ucs-set-char #x61E6 ?$@Xo(B) ; J78-@-586F
(ucs-set-char #x61E6 ?$AE3(B) ; GB0-A-4533
(ucs-set-char #x61E6 ?$BXo(B) ; J83-B-586F
(ucs-set-char #x61E7 ?$(D>|(B) ; J90-D-3E7C
(ucs-set-char #x61E7 ?$(H\m(B) ; C02-H-5C6D
(ucs-set-char #x61E8 ?$(H\q(B) ; C02-H-5C71
(ucs-set-char #x61E9 ?$(D>}(B) ; J90-D-3E7D
(ucs-set-char #x61E9 ?$(Ha\(B) ; C02-H-615C
(ucs-set-char #x61EA ?$(HaX(B) ; C02-H-6158
(ucs-set-char #x61EB ?$(HaZ(B) ; C02-H-615A
(ucs-set-char #x61EC ?$(D?!(B) ; J90-D-3F21
(ucs-set-char #x61EC ?$(J_`(B) ; C04-J-5F60
(ucs-set-char #x61ED ?$(D?"(B) ; J90-D-3F22
(ucs-set-char #x61ED ?$(HaU(B) ; C02-H-6155
(ucs-set-char #x61EE ?$(HaV(B) ; C02-H-6156
(ucs-set-char #x61EF ?$(D?#(B) ; J90-D-3F23
(ucs-set-char #x61EF ?$(J_a(B) ; C04-J-5F61
(ucs-set-char #x61F0 ?$(HaY(B) ; C02-H-6159
(ucs-set-char #x61F1 ?$(HaW(B) ; C02-H-6157
(ucs-set-char #x61F2 ?$(Cs$(B) ; KS0-C-7324
(ucs-set-char #x61F2 ?$(Gx4(B) ; C01-G-7834
(ucs-set-char #x61F2 ?$@D((B) ; J78-@-4428
(ucs-set-char #x61F2 ?$BD((B) ; J83-B-4428
(ucs-set-char #x61F3 ?$(IWe(B) ; C03-I-5765
(ucs-set-char #x61F4 ?$@Xs(B) ; J78-@-5873
(ucs-set-char #x61F4 ?$BXs(B) ; J83-B-5873
(ucs-set-char #x61F5 ?$(Gx7(B) ; C01-G-7837
(ucs-set-char #x61F5 ?$AcB(B) ; GB0-A-6342
(ucs-set-char #x61F6 ?$(CT{(B) ; KS0-C-547B
(ucs-set-char #x61F6 ?$(Gx6(B) ; C01-G-7836
(ucs-set-char #x61F6 ?$@Xq(B) ; J78-@-5871
(ucs-set-char #x61F6 ?$BXq(B) ; J83-B-5871
(ucs-set-char #x61F7 ?$(C|c(B) ; KS0-C-7C63
(ucs-set-char #x61F7 ?$(Gx5(B) ; C01-G-7835
(ucs-set-char #x61F7 ?$@Xg(B) ; J78-@-5867
(ucs-set-char #x61F7 ?$BXg(B) ; J83-B-5867
(ucs-set-char #x61F8 ?$(CzX(B) ; KS0-C-7A58
(ucs-set-char #x61F8 ?$(Gyl(B) ; C01-G-796C
(ucs-set-char #x61F8 ?$@7|(B) ; J78-@-377C
(ucs-set-char #x61F8 ?$B7|(B) ; J83-B-377C
(ucs-set-char #x61F9 ?$(Hhv(B) ; C02-H-6876
(ucs-set-char #x61FA ?$(CsU(B) ; KS0-C-7355
(ucs-set-char #x61FA ?$(Gym(B) ; C01-G-796D
(ucs-set-char #x61FA ?$@Xr(B) ; J78-@-5872
(ucs-set-char #x61FA ?$BXr(B) ; J83-B-5872
(ucs-set-char #x61FB ?$(HeL(B) ; C02-H-654C
(ucs-set-char #x61FC ?$(CO+(B) ; KS0-C-4F2B
(ucs-set-char #x61FC ?$(Gzj(B) ; C01-G-7A6A
(ucs-set-char #x61FC ?$@Xv(B) ; J78-@-5876
(ucs-set-char #x61FC ?$BXv(B) ; J83-B-5876
(ucs-set-char #x61FD ?$(HkZ(B) ; C02-H-6B5A
(ucs-set-char #x61FD ?$@Xu(B) ; J78-@-5875
(ucs-set-char #x61FD ?$BXu(B) ; J83-B-5875
(ucs-set-char #x61FE ?$(Gzk(B) ; C01-G-7A6B
(ucs-set-char #x61FE ?$@Xw(B) ; J78-@-5877
(ucs-set-char #x61FE ?$BXw(B) ; J83-B-5877
(ucs-set-char #x61FF ?$(Cks(B) ; KS0-C-6B73
(ucs-set-char #x61FF ?$(G{`(B) ; C01-G-7B60
(ucs-set-char #x61FF ?$@Xt(B) ; J78-@-5874
(ucs-set-char #x61FF ?$A\2(B) ; GB0-A-5C32
(ucs-set-char #x61FF ?$BXt(B) ; J83-B-5874
(ucs-set-char #x6200 ?$(CU|(B) ; KS0-C-557C
(ucs-set-char #x6200 ?$(G|6(B) ; C01-G-7C36
(ucs-set-char #x6200 ?$@Xx(B) ; J78-@-5878
(ucs-set-char #x6200 ?$BXx(B) ; J83-B-5878
(ucs-set-char #x6201 ?$(D?$(B) ; J90-D-3F24
(ucs-set-char #x6201 ?$(Ho((B) ; C02-H-6F28
(ucs-set-char #x6202 ?$(I_F(B) ; C03-I-5F46
(ucs-set-char #x6203 ?$(D?%(B) ; J90-D-3F25
(ucs-set-char #x6203 ?$(Ho)(B) ; C02-H-6F29
(ucs-set-char #x6204 ?$(D?&(B) ; J90-D-3F26
(ucs-set-char #x6204 ?$(Ho*(B) ; C02-H-6F2A
(ucs-set-char #x6205 ?$(Ia>(B) ; C03-I-613E
(ucs-set-char #x6206 ?$Am0(B) ; GB0-A-6D30
(ucs-set-char #x6207 ?$(CST(B) ; KS0-C-5354
(ucs-set-char #x6207 ?$(D?'(B) ; J90-D-3F27
(ucs-set-char #x6207 ?$(Hr*(B) ; C02-H-722A
(ucs-set-char #x6208 ?$(CM|(B) ; KS0-C-4D7C
(ucs-set-char #x6208 ?$(GEA(B) ; C01-G-4541
(ucs-set-char #x6208 ?$@Xy(B) ; J78-@-5879
(ucs-set-char #x6208 ?$A8j(B) ; GB0-A-386A
(ucs-set-char #x6208 ?$BXy(B) ; J83-B-5879
(ucs-set-char #x6209 ?$(H!](B) ; C02-H-215D
(ucs-set-char #x6209 ?$@Xz(B) ; J78-@-587A
(ucs-set-char #x6209 ?$BXz(B) ; J83-B-587A
(ucs-set-char #x620A ?$(CYf(B) ; KS0-C-5966
(ucs-set-char #x620A ?$(GFS(B) ; C01-G-4653
(ucs-set-char #x620A ?$@Jj(B) ; J78-@-4A6A
(ucs-set-char #x620A ?$ANl(B) ; GB0-A-4E6C
(ucs-set-char #x620A ?$BJj(B) ; J83-B-4A6A
(ucs-set-char #x620B ?$Aj'(B) ; GB0-A-6A27
(ucs-set-char #x620C ?$(Cby(B) ; KS0-C-6279
(ucs-set-char #x620C ?$(GH'(B) ; C01-G-4827
(ucs-set-char #x620C ?$@X|(B) ; J78-@-587C
(ucs-set-char #x620C ?$APg(B) ; GB0-A-5067
(ucs-set-char #x620C ?$BX|(B) ; J83-B-587C
(ucs-set-char #x620D ?$(Cb!(B) ; KS0-C-6221
(ucs-set-char #x620D ?$(GH((B) ; C01-G-4828
(ucs-set-char #x620D ?$@X{(B) ; J78-@-587B
(ucs-set-char #x620D ?$AJy(B) ; GB0-A-4A79
(ucs-set-char #x620D ?$BX{(B) ; J83-B-587B
(ucs-set-char #x620E ?$(CkT(B) ; KS0-C-6B54
(ucs-set-char #x620E ?$(GH&(B) ; C01-G-4826
(ucs-set-char #x620E ?$@=?(B) ; J78-@-3D3F
(ucs-set-char #x620E ?$AHV(B) ; GB0-A-4856
(ucs-set-char #x620E ?$B=?(B) ; J83-B-3D3F
(ucs-set-char #x620F ?$(I#k(B) ; C03-I-236B
(ucs-set-char #x620F ?$AO7(B) ; GB0-A-4F37
(ucs-set-char #x6210 ?$(C`w(B) ; KS0-C-6077
(ucs-set-char #x6210 ?$(GH)(B) ; C01-G-4829
(ucs-set-char #x6210 ?$@@.(B) ; J78-@-402E
(ucs-set-char #x6210 ?$A3I(B) ; GB0-A-3349
(ucs-set-char #x6210 ?$B@.(B) ; J83-B-402E
(ucs-set-char #x6211 ?$(Cd2(B) ; KS0-C-6432
(ucs-set-char #x6211 ?$(GJ<(B) ; C01-G-4A3C
(ucs-set-char #x6211 ?$@2f(B) ; J78-@-3266
(ucs-set-char #x6211 ?$ANR(B) ; GB0-A-4E52
(ucs-set-char #x6211 ?$B2f(B) ; J83-B-3266
(ucs-set-char #x6212 ?$(CL|(B) ; KS0-C-4C7C
(ucs-set-char #x6212 ?$(GJ;(B) ; C01-G-4A3B
(ucs-set-char #x6212 ?$@2|(B) ; J78-@-327C
(ucs-set-char #x6212 ?$A=d(B) ; GB0-A-3D64
(ucs-set-char #x6212 ?$B2|(B) ; J83-B-327C
(ucs-set-char #x6213 ?$(D?((B) ; J90-D-3F28
(ucs-set-char #x6213 ?$(I&%(B) ; C03-I-2625
(ucs-set-char #x6214 ?$(H&p(B) ; C02-H-2670
(ucs-set-char #x6214 ?$@X}(B) ; J78-@-587D
(ucs-set-char #x6214 ?$BX}(B) ; J83-B-587D
(ucs-set-char #x6215 ?$(D?)(B) ; J90-D-3F29
(ucs-set-char #x6215 ?$(GMQ(B) ; C01-G-4D51
(ucs-set-char #x6215 ?$Ac^(B) ; GB0-A-635E
(ucs-set-char #x6216 ?$(C{d(B) ; KS0-C-7B64
(ucs-set-char #x6216 ?$(GMP(B) ; C01-G-4D50
(ucs-set-char #x6216 ?$@0?(B) ; J78-@-303F
(ucs-set-char #x6216 ?$A;r(B) ; GB0-A-3B72
(ucs-set-char #x6216 ?$B0?(B) ; J83-B-303F
(ucs-set-char #x6217 ?$Aj((B) ; GB0-A-6A28
(ucs-set-char #x6218 ?$(I,c(B) ; C03-I-2C63
(ucs-set-char #x6218 ?$AU=(B) ; GB0-A-553D
(ucs-set-char #x6219 ?$(H/1(B) ; C02-H-2F31
(ucs-set-char #x621A ?$(Ct+(B) ; KS0-C-742B
(ucs-set-char #x621A ?$(GZQ(B) ; C01-G-5A51
(ucs-set-char #x621A ?$@@L(B) ; J78-@-404C
(ucs-set-char #x621A ?$AF](B) ; GB0-A-465D
(ucs-set-char #x621A ?$B@L(B) ; J83-B-404C
(ucs-set-char #x621B ?$(GZR(B) ; C01-G-5A52
(ucs-set-char #x621B ?$@X~(B) ; J78-@-587E
(ucs-set-char #x621B ?$Aj)(B) ; GB0-A-6A29
(ucs-set-char #x621B ?$BX~(B) ; J83-B-587E
(ucs-set-char #x621C ?$(D?*(B) ; J90-D-3F2A
(ucs-set-char #x621C ?$(J1n(B) ; C04-J-316E
(ucs-set-char #x621D ?$(J1p(B) ; C04-J-3170
(ucs-set-char #x621D ?$@lC(B) ; J78-@-6C43
(ucs-set-char #x621D ?$BlC(B) ; J83-B-6C43
(ucs-set-char #x621E ?$(I;d(B) ; C03-I-3B64
(ucs-set-char #x621E ?$@Y!(B) ; J78-@-5921
(ucs-set-char #x621E ?$BY!(B) ; J83-B-5921
(ucs-set-char #x621F ?$(CP=(B) ; KS0-C-503D
(ucs-set-char #x621F ?$(G_<(B) ; C01-G-5F3C
(ucs-set-char #x621F ?$@7a(B) ; J78-@-3761
(ucs-set-char #x621F ?$Aj*(B) ; GB0-A-6A2A
(ucs-set-char #x621F ?$B7a(B) ; J83-B-3761
(ucs-set-char #x6220 ?$(D?+(B) ; J90-D-3F2B
(ucs-set-char #x6220 ?$(HBx(B) ; C02-H-4278
(ucs-set-char #x6221 ?$(CJq(B) ; KS0-C-4A71
(ucs-set-char #x6221 ?$(Gd((B) ; C01-G-6428
(ucs-set-char #x6221 ?$@Y"(B) ; J78-@-5922
(ucs-set-char #x6221 ?$Aj,(B) ; GB0-A-6A2C
(ucs-set-char #x6221 ?$BY"(B) ; J83-B-5922
(ucs-set-char #x6222 ?$(D?,(B) ; J90-D-3F2C
(ucs-set-char #x6222 ?$(Gd)(B) ; C01-G-6429
(ucs-set-char #x6222 ?$Aj+(B) ; GB0-A-6A2B
(ucs-set-char #x6223 ?$(D?-(B) ; J90-D-3F2D
(ucs-set-char #x6223 ?$(HBz(B) ; C02-H-427A
(ucs-set-char #x6224 ?$(HB|(B) ; C02-H-427C
(ucs-set-char #x6224 ?$Aj.(B) ; GB0-A-6A2E
(ucs-set-char #x6225 ?$(HB{(B) ; C02-H-427B
(ucs-set-char #x6225 ?$Aj-(B) ; GB0-A-6A2D
(ucs-set-char #x6226 ?$(J=C(B) ; C04-J-3D43
(ucs-set-char #x6226 ?$@@o(B) ; J78-@-406F
(ucs-set-char #x6226 ?$B@o(B) ; J83-B-406F
(ucs-set-char #x6227 ?$(D?.(B) ; J90-D-3F2E
(ucs-set-char #x6227 ?$(HJ>(B) ; C02-H-4A3E
(ucs-set-char #x6228 ?$(IFv(B) ; C03-I-4676
(ucs-set-char #x6229 ?$(D?/(B) ; J90-D-3F2F
(ucs-set-char #x6229 ?$(HJ=(B) ; C02-H-4A3D
(ucs-set-char #x622A ?$(Co8(B) ; KS0-C-6F38
(ucs-set-char #x622A ?$(Ghp(B) ; C01-G-6870
(ucs-set-char #x622A ?$@Y#(B) ; J78-@-5923
(ucs-set-char #x622A ?$A=X(B) ; GB0-A-3D58
(ucs-set-char #x622A ?$BY#(B) ; J83-B-5923
(ucs-set-char #x622B ?$(D?0(B) ; J90-D-3F30
(ucs-set-char #x622B ?$(HJ?(B) ; C02-H-4A3F
(ucs-set-char #x622C ?$(IFu(B) ; C03-I-4675
(ucs-set-char #x622C ?$Aj/(B) ; GB0-A-6A2F
(ucs-set-char #x622D ?$(HPS(B) ; C02-H-5053
(ucs-set-char #x622E ?$(CW@(B) ; KS0-C-5740
(ucs-set-char #x622E ?$(Glv(B) ; C01-G-6C76
(ucs-set-char #x622E ?$@Y$(B) ; J78-@-5924
(ucs-set-char #x622E ?$AB>(B) ; GB0-A-423E
(ucs-set-char #x622E ?$BY$(B) ; J83-B-5924
(ucs-set-char #x622F ?$(IL,(B) ; C03-I-4C2C
(ucs-set-char #x622F ?$@5:(B) ; J78-@-353A
(ucs-set-char #x622F ?$B5:(B) ; J83-B-353A
(ucs-set-char #x6230 ?$(Cnz(B) ; KS0-C-6E7A
(ucs-set-char #x6230 ?$(Gp](B) ; C01-G-705D
(ucs-set-char #x6230 ?$@Y%(B) ; J78-@-5925
(ucs-set-char #x6230 ?$BY%(B) ; J83-B-5925
(ucs-set-char #x6231 ?$(C}t(B) ; KS0-C-7D74
(ucs-set-char #x6231 ?$(IPm(B) ; C03-I-506D
(ucs-set-char #x6232 ?$(Gsa(B) ; C01-G-7361
(ucs-set-char #x6232 ?$@Y&(B) ; J78-@-5926
(ucs-set-char #x6232 ?$BY&(B) ; J83-B-5926
(ucs-set-char #x6233 ?$(GvC(B) ; C01-G-7643
(ucs-set-char #x6233 ?$@Y'(B) ; J78-@-5927
(ucs-set-char #x6233 ?$A4A(B) ; GB0-A-3441
(ucs-set-char #x6233 ?$BY'(B) ; J83-B-5927
(ucs-set-char #x6234 ?$(CSc(B) ; KS0-C-5363
(ucs-set-char #x6234 ?$(Gsb(B) ; C01-G-7362
(ucs-set-char #x6234 ?$@BW(B) ; J78-@-4257
(ucs-set-char #x6234 ?$A4w(B) ; GB0-A-3477
(ucs-set-char #x6234 ?$BBW(B) ; J83-B-4257
(ucs-set-char #x6235 ?$(I_H(B) ; C03-I-5F48
(ucs-set-char #x6236 ?$(C{B(B) ; KS0-C-7B42
(ucs-set-char #x6236 ?$(GEB(B) ; C01-G-4542
(ucs-set-char #x6237 ?$(I!e(B) ; C03-I-2165
(ucs-set-char #x6237 ?$A;'(B) ; GB0-A-3B27
(ucs-set-char #x6238 ?$(I!f(B) ; C03-I-2166
(ucs-set-char #x6238 ?$@8M(B) ; J78-@-384D
(ucs-set-char #x6238 ?$B8M(B) ; J83-B-384D
(ucs-set-char #x6239 ?$(D?1(B) ; J90-D-3F31
(ucs-set-char #x6239 ?$(I"N(B) ; C03-I-224E
(ucs-set-char #x623A ?$(H$((B) ; C02-H-2428
(ucs-set-char #x623B ?$(I&((B) ; C03-I-2628
(ucs-set-char #x623B ?$@La(B) ; J78-@-4C61
(ucs-set-char #x623B ?$BLa(B) ; J83-B-4C61
(ucs-set-char #x623C ?$(I&)(B) ; C03-I-2629
(ucs-set-char #x623D ?$(D?2(B) ; J90-D-3F32
(ucs-set-char #x623D ?$(H&q(B) ; C02-H-2671
(ucs-set-char #x623D ?$Alf(B) ; GB0-A-6C66
(ucs-set-char #x623E ?$(CUh(B) ; KS0-C-5568
(ucs-set-char #x623E ?$(GMS(B) ; C01-G-4D53
(ucs-set-char #x623E ?$Ale(B) ; GB0-A-6C65
(ucs-set-char #x623F ?$(C[.(B) ; KS0-C-5B2E
(ucs-set-char #x623F ?$(GMR(B) ; C01-G-4D52
(ucs-set-char #x623F ?$@K<(B) ; J78-@-4B3C
(ucs-set-char #x623F ?$A7?(B) ; GB0-A-373F
(ucs-set-char #x623F ?$BK<(B) ; J83-B-4B3C
(ucs-set-char #x6240 ?$(Ca6(B) ; KS0-C-6136
(ucs-set-char #x6240 ?$(GMT(B) ; C01-G-4D54
(ucs-set-char #x6240 ?$@=j(B) ; J78-@-3D6A
(ucs-set-char #x6240 ?$AKy(B) ; GB0-A-4B79
(ucs-set-char #x6240 ?$B=j(B) ; J83-B-3D6A
(ucs-set-char #x6241 ?$(Cx7(B) ; KS0-C-7837
(ucs-set-char #x6241 ?$(GQ7(B) ; C01-G-5137
(ucs-set-char #x6241 ?$@Y((B) ; J78-@-5928
(ucs-set-char #x6241 ?$A1b(B) ; GB0-A-3162
(ucs-set-char #x6241 ?$BY((B) ; J83-B-5928
(ucs-set-char #x6242 ?$(D?3(B) ; J90-D-3F33
(ucs-set-char #x6242 ?$(H*S(B) ; C02-H-2A53
(ucs-set-char #x6243 ?$(D?4(B) ; J90-D-3F34
(ucs-set-char #x6243 ?$(H*T(B) ; C02-H-2A54
(ucs-set-char #x6243 ?$Alg(B) ; GB0-A-6C67
(ucs-set-char #x6244 ?$(D?5(B) ; J90-D-3F35
(ucs-set-char #x6245 ?$(I1)(B) ; C03-I-3129
(ucs-set-char #x6246 ?$(D?6(B) ; J90-D-3F36
(ucs-set-char #x6246 ?$(H/2(B) ; C02-H-2F32
(ucs-set-char #x6247 ?$(C`?(B) ; KS0-C-603F
(ucs-set-char #x6247 ?$(GUR(B) ; C01-G-5552
(ucs-set-char #x6247 ?$@@p(B) ; J78-@-4070
(ucs-set-char #x6247 ?$AIH(B) ; GB0-A-4948
(ucs-set-char #x6247 ?$B@p(B) ; J83-B-4070
(ucs-set-char #x6248 ?$(C{C(B) ; KS0-C-7B43
(ucs-set-char #x6248 ?$(GZS(B) ; C01-G-5A53
(ucs-set-char #x6248 ?$@n=(B) ; J78-@-6E3D
(ucs-set-char #x6248 ?$Alh(B) ; GB0-A-6C68
(ucs-set-char #x6248 ?$Bn=(B) ; J83-B-6E3D
(ucs-set-char #x6249 ?$(C]j(B) ; KS0-C-5D6A
(ucs-set-char #x6249 ?$(G_=(B) ; C01-G-5F3D
(ucs-set-char #x6249 ?$@Hb(B) ; J78-@-4862
(ucs-set-char #x6249 ?$Ali(B) ; GB0-A-6C69
(ucs-set-char #x6249 ?$BHb(B) ; J83-B-4862
(ucs-set-char #x624A ?$(H;t(B) ; C02-H-3B74
(ucs-set-char #x624B ?$(Cb"(B) ; KS0-C-6222
(ucs-set-char #x624B ?$(GEC(B) ; C01-G-4543
(ucs-set-char #x624B ?$@<j(B) ; J78-@-3C6A
(ucs-set-char #x624B ?$AJV(B) ; GB0-A-4A56
(ucs-set-char #x624B ?$B<j(B) ; J83-B-3C6A
(ucs-set-char #x624C ?$(D?7(B) ; J90-D-3F37
(ucs-set-char #x624C ?$(J!7(B) ; C04-J-2137
(ucs-set-char #x624C ?$A^P(B) ; GB0-A-5E50
(ucs-set-char #x624D ?$(Cn&(B) ; KS0-C-6E26
(ucs-set-char #x624D ?$(GD_(B) ; C01-G-445F
(ucs-set-char #x624D ?$@:M(B) ; J78-@-3A4D
(ucs-set-char #x624D ?$A2E(B) ; GB0-A-3245
(ucs-set-char #x624D ?$B:M(B) ; J83-B-3A4D
(ucs-set-char #x624E ?$(GED(B) ; C01-G-4544
(ucs-set-char #x624E ?$@Y)(B) ; J78-@-5929
(ucs-set-char #x624E ?$ATz(B) ; GB0-A-547A
(ucs-set-char #x624E ?$BY)(B) ; J83-B-5929
(ucs-set-char #x624F ?$(I"P(B) ; C03-I-2250
(ucs-set-char #x6250 ?$(D?8(B) ; J90-D-3F38
(ucs-set-char #x6250 ?$(H!^(B) ; C02-H-215E
(ucs-set-char #x6251 ?$(D?9(B) ; J90-D-3F39
(ucs-set-char #x6251 ?$(GFW(B) ; C01-G-4657
(ucs-set-char #x6251 ?$AFK(B) ; GB0-A-464B
(ucs-set-char #x6252 ?$(D?:(B) ; J90-D-3F3A
(ucs-set-char #x6252 ?$(GFV(B) ; C01-G-4656
(ucs-set-char #x6252 ?$A0G(B) ; GB0-A-3047
(ucs-set-char #x6253 ?$(Cvh(B) ; KS0-C-7668
(ucs-set-char #x6253 ?$(GFT(B) ; C01-G-4654
(ucs-set-char #x6253 ?$@BG(B) ; J78-@-4247
(ucs-set-char #x6253 ?$A4r(B) ; GB0-A-3472
(ucs-set-char #x6253 ?$BBG(B) ; J83-B-4247
(ucs-set-char #x6254 ?$(D?;(B) ; J90-D-3F3B
(ucs-set-char #x6254 ?$(GFU(B) ; C01-G-4655
(ucs-set-char #x6254 ?$AHS(B) ; GB0-A-4853
(ucs-set-char #x6255 ?$@J'(B) ; J78-@-4A27
(ucs-set-char #x6255 ?$BJ'(B) ; J83-B-4A27
(ucs-set-char #x6256 ?$(D?<(B) ; J90-D-3F3C
(ucs-set-char #x6257 ?$(I#o(B) ; C03-I-236F
(ucs-set-char #x6258 ?$(Cvu(B) ; KS0-C-7675
(ucs-set-char #x6258 ?$(GH,(B) ; C01-G-482C
(ucs-set-char #x6258 ?$@Bq(B) ; J78-@-4271
(ucs-set-char #x6258 ?$AMP(B) ; GB0-A-4D50
(ucs-set-char #x6258 ?$BBq(B) ; J83-B-4271
(ucs-set-char #x6259 ?$(H"I(B) ; C02-H-2249
(ucs-set-char #x625A ?$(D?=(B) ; J90-D-3F3D
(ucs-set-char #x625A ?$(H"K(B) ; C02-H-224B
(ucs-set-char #x625B ?$(GH+(B) ; C01-G-482B
(ucs-set-char #x625B ?$@Y,(B) ; J78-@-592C
(ucs-set-char #x625B ?$A?8(B) ; GB0-A-3F38
(ucs-set-char #x625B ?$BY,(B) ; J83-B-592C
(ucs-set-char #x625C ?$(D?>(B) ; J90-D-3F3E
(ucs-set-char #x625C ?$(H"C(B) ; C02-H-2243
(ucs-set-char #x625D ?$(I#l(B) ; C03-I-236C
(ucs-set-char #x625E ?$(H"D(B) ; C02-H-2244
(ucs-set-char #x625E ?$@Y*(B) ; J78-@-592A
(ucs-set-char #x625E ?$BY*(B) ; J83-B-592A
(ucs-set-char #x625F ?$(I#m(B) ; C03-I-236D
(ucs-set-char #x6260 ?$(H"J(B) ; C02-H-224A
(ucs-set-char #x6260 ?$@Y-(B) ; J78-@-592D
(ucs-set-char #x6260 ?$BY-(B) ; J83-B-592D
(ucs-set-char #x6261 ?$(H"F(B) ; C02-H-2246
(ucs-set-char #x6262 ?$(H"H(B) ; C02-H-2248
(ucs-set-char #x6263 ?$(GH*(B) ; C01-G-482A
(ucs-set-char #x6263 ?$@Y+(B) ; J78-@-592B
(ucs-set-char #x6263 ?$A?[(B) ; GB0-A-3F5B
(ucs-set-char #x6263 ?$BY+(B) ; J83-B-592B
(ucs-set-char #x6264 ?$(D??(B) ; J90-D-3F3F
(ucs-set-char #x6264 ?$(H"E(B) ; C02-H-2245
(ucs-set-char #x6265 ?$(H"L(B) ; C02-H-224C
(ucs-set-char #x6266 ?$(H"G(B) ; C02-H-2247
(ucs-set-char #x6266 ?$AG$(B) ; GB0-A-4724
(ucs-set-char #x6267 ?$(I#n(B) ; C03-I-236E
(ucs-set-char #x6267 ?$AV4(B) ; GB0-A-5634
(ucs-set-char #x6268 ?$@Y.(B) ; J78-@-592E
(ucs-set-char #x6268 ?$BY.(B) ; J83-B-592E
(ucs-set-char #x6269 ?$A@)(B) ; GB0-A-4029
(ucs-set-char #x626A ?$A^Q(B) ; GB0-A-5E51
(ucs-set-char #x626B ?$AI((B) ; GB0-A-4928
(ucs-set-char #x626C ?$AQo(B) ; GB0-A-516F
(ucs-set-char #x626D ?$(D?@(B) ; J90-D-3F40
(ucs-set-char #x626D ?$(GJC(B) ; C01-G-4A43
(ucs-set-char #x626D ?$AE$(B) ; GB0-A-4524
(ucs-set-char #x626E ?$(C]J(B) ; KS0-C-5D4A
(ucs-set-char #x626E ?$(GJL(B) ; C01-G-4A4C
(ucs-set-char #x626E ?$@J1(B) ; J78-@-4A31
(ucs-set-char #x626E ?$A0g(B) ; GB0-A-3067
(ucs-set-char #x626E ?$BJ1(B) ; J83-B-4A31
(ucs-set-char #x626F ?$(D?A(B) ; J90-D-3F41
(ucs-set-char #x626F ?$(GJJ(B) ; C01-G-4A4A
(ucs-set-char #x626F ?$A36(B) ; GB0-A-3336
(ucs-set-char #x6270 ?$(H$2(B) ; C02-H-2432
(ucs-set-char #x6270 ?$AHE(B) ; GB0-A-4845
(ucs-set-char #x6271 ?$(CPb(B) ; KS0-C-5062
(ucs-set-char #x6271 ?$(H$/(B) ; C02-H-242F
(ucs-set-char #x6271 ?$@07(B) ; J78-@-3037
(ucs-set-char #x6271 ?$B07(B) ; J83-B-3037
(ucs-set-char #x6272 ?$(H$7(B) ; C02-H-2437
(ucs-set-char #x6273 ?$(D?B(B) ; J90-D-3F42
(ucs-set-char #x6273 ?$(GJH(B) ; C01-G-4A48
(ucs-set-char #x6273 ?$A0b(B) ; GB0-A-3062
(ucs-set-char #x6274 ?$(H$8(B) ; C02-H-2438
(ucs-set-char #x6275 ?$(I&9(B) ; C03-I-2639
(ucs-set-char #x6276 ?$(C]&(B) ; KS0-C-5D26
(ucs-set-char #x6276 ?$(GJA(B) ; C01-G-4A41
(ucs-set-char #x6276 ?$@I^(B) ; J78-@-495E
(ucs-set-char #x6276 ?$A7v(B) ; GB0-A-3776
(ucs-set-char #x6276 ?$BI^(B) ; J83-B-495E
(ucs-set-char #x6277 ?$(H$5(B) ; C02-H-2435
(ucs-set-char #x6278 ?$(I&.(B) ; C03-I-262E
(ucs-set-char #x6279 ?$(C]k(B) ; KS0-C-5D6B
(ucs-set-char #x6279 ?$(GJG(B) ; C01-G-4A47
(ucs-set-char #x6279 ?$@Hc(B) ; J78-@-4863
(ucs-set-char #x6279 ?$AEz(B) ; GB0-A-457A
(ucs-set-char #x6279 ?$BHc(B) ; J83-B-4863
(ucs-set-char #x627A ?$(D?C(B) ; J90-D-3F43
(ucs-set-char #x627A ?$(H$1(B) ; C02-H-2431
(ucs-set-char #x627B ?$(H$0(B) ; C02-H-2430
(ucs-set-char #x627C ?$(Cdy(B) ; KS0-C-6479
(ucs-set-char #x627C ?$(GJE(B) ; C01-G-4A45
(ucs-set-char #x627C ?$@Y/(B) ; J78-@-592F
(ucs-set-char #x627C ?$A6s(B) ; GB0-A-3673
(ucs-set-char #x627C ?$BY/(B) ; J83-B-592F
(ucs-set-char #x627D ?$(D?D(B) ; J90-D-3F44
(ucs-set-char #x627D ?$(H$6(B) ; C02-H-2436
(ucs-set-char #x627E ?$(GJF(B) ; C01-G-4A46
(ucs-set-char #x627E ?$@Y2(B) ; J78-@-5932
(ucs-set-char #x627E ?$AUR(B) ; GB0-A-5552
(ucs-set-char #x627E ?$BY2(B) ; J83-B-5932
(ucs-set-char #x627F ?$(Cc/(B) ; KS0-C-632F
(ucs-set-char #x627F ?$(GMU(B) ; C01-G-4D55
(ucs-set-char #x627F ?$@>5(B) ; J78-@-3E35
(ucs-set-char #x627F ?$A3P(B) ; GB0-A-3350
(ucs-set-char #x627F ?$B>5(B) ; J83-B-3E35
(ucs-set-char #x6280 ?$(CP|(B) ; KS0-C-507C
(ucs-set-char #x6280 ?$(GJ@(B) ; C01-G-4A40
(ucs-set-char #x6280 ?$@5;(B) ; J78-@-353B
(ucs-set-char #x6280 ?$A<<(B) ; GB0-A-3C3C
(ucs-set-char #x6280 ?$B5;(B) ; J83-B-353B
(ucs-set-char #x6281 ?$(H$3(B) ; C02-H-2433
(ucs-set-char #x6282 ?$(I&*(B) ; C03-I-262A
(ucs-set-char #x6282 ?$@Y0(B) ; J78-@-5930
(ucs-set-char #x6282 ?$BY0(B) ; J83-B-5930
(ucs-set-char #x6283 ?$(H$)(B) ; C02-H-2429
(ucs-set-char #x6283 ?$@Y7(B) ; J78-@-5937
(ucs-set-char #x6283 ?$BY7(B) ; J83-B-5937
(ucs-set-char #x6284 ?$(Ct|(B) ; KS0-C-747C
(ucs-set-char #x6284 ?$(GJ=(B) ; C01-G-4A3D
(ucs-set-char #x6284 ?$@>6(B) ; J78-@-3E36
(ucs-set-char #x6284 ?$A3-(B) ; GB0-A-332D
(ucs-set-char #x6284 ?$B>6(B) ; J83-B-3E36
(ucs-set-char #x6285 ?$(I&7(B) ; C03-I-2637
(ucs-set-char #x6286 ?$(GJP(B) ; C01-G-4A50
(ucs-set-char #x6287 ?$(H$.(B) ; C02-H-242E
(ucs-set-char #x6288 ?$(H$4(B) ; C02-H-2434
(ucs-set-char #x6289 ?$(CL<(B) ; KS0-C-4C3C
(ucs-set-char #x6289 ?$(GJB(B) ; C01-G-4A42
(ucs-set-char #x6289 ?$@Y1(B) ; J78-@-5931
(ucs-set-char #x6289 ?$A>q(B) ; GB0-A-3E71
(ucs-set-char #x6289 ?$BY1(B) ; J83-B-5931
(ucs-set-char #x628A ?$(Cwj(B) ; KS0-C-776A
(ucs-set-char #x628A ?$(GJD(B) ; C01-G-4A44
(ucs-set-char #x628A ?$@GD(B) ; J78-@-4744
(ucs-set-char #x628A ?$A0Q(B) ; GB0-A-3051
(ucs-set-char #x628A ?$BGD(B) ; J83-B-4744
(ucs-set-char #x628B ?$(I&/(B) ; C03-I-262F
(ucs-set-char #x628C ?$(H$*(B) ; C02-H-242A
(ucs-set-char #x628D ?$(D?E(B) ; J90-D-3F45
(ucs-set-char #x628D ?$(I&6(B) ; C03-I-2636
(ucs-set-char #x628E ?$(D?F(B) ; J90-D-3F46
(ucs-set-char #x628E ?$(H$+(B) ; C02-H-242B
(ucs-set-char #x628F ?$(D?G(B) ; J90-D-3F47
(ucs-set-char #x628F ?$(H$,(B) ; C02-H-242C
(ucs-set-char #x6290 ?$(D?H(B) ; J90-D-3F48
(ucs-set-char #x6290 ?$(J$9(B) ; C04-J-2439
(ucs-set-char #x6291 ?$(Ced(B) ; KS0-C-6564
(ucs-set-char #x6291 ?$(GJO(B) ; C01-G-4A4F
(ucs-set-char #x6291 ?$@M^(B) ; J78-@-4D5E
(ucs-set-char #x6291 ?$ARV(B) ; GB0-A-5256
(ucs-set-char #x6291 ?$BM^(B) ; J83-B-4D5E
(ucs-set-char #x6292 ?$(C_q(B) ; KS0-C-5F71
(ucs-set-char #x6292 ?$(GJI(B) ; C01-G-4A49
(ucs-set-char #x6292 ?$@Y3(B) ; J78-@-5933
(ucs-set-char #x6292 ?$AJc(B) ; GB0-A-4A63
(ucs-set-char #x6292 ?$BY3(B) ; J83-B-5933
(ucs-set-char #x6293 ?$(GJN(B) ; C01-G-4A4E
(ucs-set-char #x6293 ?$@Y4(B) ; J78-@-5934
(ucs-set-char #x6293 ?$AW%(B) ; GB0-A-5725
(ucs-set-char #x6293 ?$BY4(B) ; J83-B-5934
(ucs-set-char #x6294 ?$(H$-(B) ; C02-H-242D
(ucs-set-char #x6294 ?$@Y8(B) ; J78-@-5938
(ucs-set-char #x6294 ?$BY8(B) ; J83-B-5938
(ucs-set-char #x6295 ?$(Cwa(B) ; KS0-C-7761
(ucs-set-char #x6295 ?$(GJM(B) ; C01-G-4A4D
(ucs-set-char #x6295 ?$@Ej(B) ; J78-@-456A
(ucs-set-char #x6295 ?$AM6(B) ; GB0-A-4D36
(ucs-set-char #x6295 ?$BEj(B) ; J83-B-456A
(ucs-set-char #x6296 ?$(GJ?(B) ; C01-G-4A3F
(ucs-set-char #x6296 ?$@Y5(B) ; J78-@-5935
(ucs-set-char #x6296 ?$A66(B) ; GB0-A-3636
(ucs-set-char #x6296 ?$BY5(B) ; J83-B-5935
(ucs-set-char #x6297 ?$(Cyw(B) ; KS0-C-7977
(ucs-set-char #x6297 ?$(GJ>(B) ; C01-G-4A3E
(ucs-set-char #x6297 ?$@93(B) ; J78-@-3933
(ucs-set-char #x6297 ?$A?9(B) ; GB0-A-3F39
(ucs-set-char #x6297 ?$B93(B) ; J83-B-3933
(ucs-set-char #x6298 ?$(Co9(B) ; KS0-C-6F39
(ucs-set-char #x6298 ?$(GJK(B) ; C01-G-4A4B
(ucs-set-char #x6298 ?$@@^(B) ; J78-@-405E
(ucs-set-char #x6298 ?$AU[(B) ; GB0-A-555B
(ucs-set-char #x6298 ?$B@^(B) ; J83-B-405E
(ucs-set-char #x6299 ?$(I&5(B) ; C03-I-2635
(ucs-set-char #x629A ?$(J$<(B) ; C04-J-243C
(ucs-set-char #x629A ?$A8'(B) ; GB0-A-3827
(ucs-set-char #x629B ?$(CxX(B) ; KS0-C-7858
(ucs-set-char #x629B ?$(I&3(B) ; C03-I-2633
(ucs-set-char #x629B ?$@YF(B) ; J78-@-5946
(ucs-set-char #x629B ?$AEW(B) ; GB0-A-4557
(ucs-set-char #x629B ?$BYF(B) ; J83-B-5946
(ucs-set-char #x629C ?$(I&4(B) ; C03-I-2634
(ucs-set-char #x629C ?$@H4(B) ; J78-@-4834
(ucs-set-char #x629C ?$BH4(B) ; J83-B-4834
(ucs-set-char #x629D ?$(I&8(B) ; C03-I-2638
(ucs-set-char #x629E ?$(I&1(B) ; C03-I-2631
(ucs-set-char #x629E ?$@Br(B) ; J78-@-4272
(ucs-set-char #x629E ?$BBr(B) ; J83-B-4272
(ucs-set-char #x629F ?$A^R(B) ; GB0-A-5E52
(ucs-set-char #x62A0 ?$A?Y(B) ; GB0-A-3F59
(ucs-set-char #x62A1 ?$ABU(B) ; GB0-A-4255
(ucs-set-char #x62A2 ?$AG@(B) ; GB0-A-4740
(ucs-set-char #x62A4 ?$A;$(B) ; GB0-A-3B24
(ucs-set-char #x62A5 ?$(I&2(B) ; C03-I-2632
(ucs-set-char #x62A5 ?$A1((B) ; GB0-A-3128
(ucs-set-char #x62A6 ?$(D?I(B) ; J90-D-3F49
(ucs-set-char #x62A6 ?$(I)1(B) ; C03-I-2931
(ucs-set-char #x62A7 ?$(I)*(B) ; C03-I-292A
(ucs-set-char #x62A8 ?$(D?J(B) ; J90-D-3F4A
(ucs-set-char #x62A8 ?$(GMc(B) ; C01-G-4D63
(ucs-set-char #x62A8 ?$AEj(B) ; GB0-A-456A
(ucs-set-char #x62A9 ?$(H&}(B) ; C02-H-267D
(ucs-set-char #x62AA ?$(H&v(B) ; C02-H-2676
(ucs-set-char #x62AB ?$(Cy)(B) ; KS0-C-7929
(ucs-set-char #x62AB ?$(GM^(B) ; C01-G-4D5E
(ucs-set-char #x62AB ?$@Hd(B) ; J78-@-4864
(ucs-set-char #x62AB ?$AE{(B) ; GB0-A-457B
(ucs-set-char #x62AB ?$BHd(B) ; J83-B-4864
(ucs-set-char #x62AC ?$(GMq(B) ; C01-G-4D71
(ucs-set-char #x62AC ?$@Z-(B) ; J78-@-5A2D
(ucs-set-char #x62AC ?$AL'(B) ; GB0-A-4C27
(ucs-set-char #x62AC ?$BZ-(B) ; J83-B-5A2D
(ucs-set-char #x62AD ?$(H&r(B) ; C02-H-2672
(ucs-set-char #x62AE ?$(H&y(B) ; C02-H-2679
(ucs-set-char #x62AF ?$(H&{(B) ; C02-H-267B
(ucs-set-char #x62B0 ?$(H&~(B) ; C02-H-267E
(ucs-set-char #x62B1 ?$(CxY(B) ; KS0-C-7859
(ucs-set-char #x62B1 ?$(GMl(B) ; C01-G-4D6C
(ucs-set-char #x62B1 ?$(L+c(B) ; C06-L-2B63
(ucs-set-char #x62B1 ?$@Jz(B) ; J78-@-4A7A
(ucs-set-char #x62B1 ?$A1'(B) ; GB0-A-3127
(ucs-set-char #x62B1 ?$BJz(B) ; J83-B-4A7A
(ucs-set-char #x62B2 ?$(I)&(B) ; C03-I-2926
(ucs-set-char #x62B3 ?$(D?K(B) ; J90-D-3F4B
(ucs-set-char #x62B3 ?$(H&z(B) ; C02-H-267A
(ucs-set-char #x62B4 ?$(H&s(B) ; C02-H-2673
(ucs-set-char #x62B5 ?$(Cn=(B) ; KS0-C-6E3D
(ucs-set-char #x62B5 ?$(GMj(B) ; C01-G-4D6A
(ucs-set-char #x62B5 ?$@Dq(B) ; J78-@-4471
(ucs-set-char #x62B5 ?$A5V(B) ; GB0-A-3556
(ucs-set-char #x62B5 ?$BDq(B) ; J83-B-4471
(ucs-set-char #x62B6 ?$(D?L(B) ; J90-D-3F4C
(ucs-set-char #x62B6 ?$(H&w(B) ; C02-H-2677
(ucs-set-char #x62B7 ?$(D?M(B) ; J90-D-3F4D
(ucs-set-char #x62B7 ?$(I)((B) ; C03-I-2928
(ucs-set-char #x62B8 ?$(H'!(B) ; C02-H-2721
(ucs-set-char #x62B9 ?$(CXF(B) ; KS0-C-5846
(ucs-set-char #x62B9 ?$(GM[(B) ; C01-G-4D5B
(ucs-set-char #x62B9 ?$@Ku(B) ; J78-@-4B75
(ucs-set-char #x62B9 ?$AD((B) ; GB0-A-4428
(ucs-set-char #x62B9 ?$BKu(B) ; J83-B-4B75
(ucs-set-char #x62BA ?$(D?N(B) ; J90-D-3F4E
(ucs-set-char #x62BA ?$(I)%(B) ; C03-I-2925
(ucs-set-char #x62BB ?$(H&|(B) ; C02-H-267C
(ucs-set-char #x62BB ?$@Y;(B) ; J78-@-593B
(ucs-set-char #x62BB ?$A^S(B) ; GB0-A-5E53
(ucs-set-char #x62BB ?$BY;(B) ; J83-B-593B
(ucs-set-char #x62BC ?$(Cdc(B) ; KS0-C-6463
(ucs-set-char #x62BC ?$(GMe(B) ; C01-G-4D65
(ucs-set-char #x62BC ?$@2!(B) ; J78-@-3221
(ucs-set-char #x62BC ?$AQ:(B) ; GB0-A-513A
(ucs-set-char #x62BC ?$B2!(B) ; J83-B-3221
(ucs-set-char #x62BD ?$(CuN(B) ; KS0-C-754E
(ucs-set-char #x62BD ?$(GMd(B) ; C01-G-4D64
(ucs-set-char #x62BD ?$@Cj(B) ; J78-@-436A
(ucs-set-char #x62BD ?$A3i(B) ; GB0-A-3369
(ucs-set-char #x62BD ?$BCj(B) ; J83-B-436A
(ucs-set-char #x62BE ?$(D?O(B) ; J90-D-3F4F
(ucs-set-char #x62BE ?$(H&u(B) ; C02-H-2675
(ucs-set-char #x62BF ?$(D?P(B) ; J90-D-3F50
(ucs-set-char #x62BF ?$(GMY(B) ; C01-G-4D59
(ucs-set-char #x62BF ?$ACr(B) ; GB0-A-4372
(ucs-set-char #x62C0 ?$(I)4(B) ; C03-I-2934
(ucs-set-char #x62C1 ?$(I)2(B) ; C03-I-2932
(ucs-set-char #x62C2 ?$(C]Y(B) ; KS0-C-5D59
(ucs-set-char #x62C2 ?$(GMZ(B) ; C01-G-4D5A
(ucs-set-char #x62C2 ?$@YD(B) ; J78-@-5944
(ucs-set-char #x62C2 ?$A7w(B) ; GB0-A-3777
(ucs-set-char #x62C2 ?$BYD(B) ; J83-B-5944
(ucs-set-char #x62C4 ?$(D?Q(B) ; J90-D-3F51
(ucs-set-char #x62C4 ?$(GMX(B) ; C01-G-4D58
(ucs-set-char #x62C4 ?$AVt(B) ; GB0-A-5674
(ucs-set-char #x62C5 ?$(I)3(B) ; C03-I-2933
(ucs-set-char #x62C5 ?$@C4(B) ; J78-@-4334
(ucs-set-char #x62C5 ?$A5#(B) ; GB0-A-3523
(ucs-set-char #x62C5 ?$BC4(B) ; J83-B-4334
(ucs-set-char #x62C6 ?$(GMp(B) ; C01-G-4D70
(ucs-set-char #x62C6 ?$@Y>(B) ; J78-@-593E
(ucs-set-char #x62C6 ?$A2p(B) ; GB0-A-3270
(ucs-set-char #x62C6 ?$BY>(B) ; J83-B-593E
(ucs-set-char #x62C7 ?$(CYg(B) ; KS0-C-5967
(ucs-set-char #x62C7 ?$(GMh(B) ; C01-G-4D68
(ucs-set-char #x62C7 ?$@YE(B) ; J78-@-5945
(ucs-set-char #x62C7 ?$AD4(B) ; GB0-A-4434
(ucs-set-char #x62C7 ?$BYE(B) ; J83-B-5945
(ucs-set-char #x62C8 ?$(CR9(B) ; KS0-C-5239
(ucs-set-char #x62C8 ?$(GMb(B) ; C01-G-4D62
(ucs-set-char #x62C8 ?$@Y@(B) ; J78-@-5940
(ucs-set-char #x62C8 ?$ADi(B) ; GB0-A-4469
(ucs-set-char #x62C8 ?$BY@(B) ; J83-B-5940
(ucs-set-char #x62C9 ?$(CUC(B) ; KS0-C-5543
(ucs-set-char #x62C9 ?$(GMV(B) ; C01-G-4D56
(ucs-set-char #x62C9 ?$@YG(B) ; J78-@-5947
(ucs-set-char #x62C9 ?$A@-(B) ; GB0-A-402D
(ucs-set-char #x62C9 ?$BYG(B) ; J83-B-5947
(ucs-set-char #x62CA ?$(H&x(B) ; C02-H-2678
(ucs-set-char #x62CA ?$@YC(B) ; J78-@-5943
(ucs-set-char #x62CA ?$A^T(B) ; GB0-A-5E54
(ucs-set-char #x62CA ?$BYC(B) ; J83-B-5943
(ucs-set-char #x62CB ?$(GMa(B) ; C01-G-4D61
(ucs-set-char #x62CC ?$(CZe(B) ; KS0-C-5A65
(ucs-set-char #x62CC ?$(GMW(B) ; C01-G-4D57
(ucs-set-char #x62CC ?$@YB(B) ; J78-@-5942
(ucs-set-char #x62CC ?$A0h(B) ; GB0-A-3068
(ucs-set-char #x62CC ?$BYB(B) ; J83-B-5942
(ucs-set-char #x62CD ?$(CZP(B) ; KS0-C-5A50
(ucs-set-char #x62CD ?$(GMi(B) ; C01-G-4D69
(ucs-set-char #x62CD ?$@Go(B) ; J78-@-476F
(ucs-set-char #x62CD ?$AED(B) ; GB0-A-4544
(ucs-set-char #x62CD ?$BGo(B) ; J83-B-476F
(ucs-set-char #x62CE ?$(D?R(B) ; J90-D-3F52
(ucs-set-char #x62CE ?$(GMr(B) ; C01-G-4D72
(ucs-set-char #x62CE ?$AA`(B) ; GB0-A-4160
(ucs-set-char #x62CF ?$(CQY(B) ; KS0-C-5159
(ucs-set-char #x62CF ?$(H*U(B) ; C02-H-2A55
(ucs-set-char #x62CF ?$@Y<(B) ; J78-@-593C
(ucs-set-char #x62CF ?$BY<(B) ; J83-B-593C
(ucs-set-char #x62D0 ?$(CNX(B) ; KS0-C-4E58
(ucs-set-char #x62D0 ?$(GMf(B) ; C01-G-4D66
(ucs-set-char #x62D0 ?$@2}(B) ; J78-@-327D
(ucs-set-char #x62D0 ?$A9U(B) ; GB0-A-3955
(ucs-set-char #x62D0 ?$B2}(B) ; J83-B-327D
(ucs-set-char #x62D1 ?$(H&t(B) ; C02-H-2674
(ucs-set-char #x62D1 ?$@Y:(B) ; J78-@-593A
(ucs-set-char #x62D1 ?$BY:(B) ; J83-B-593A
(ucs-set-char #x62D2 ?$(CK^(B) ; KS0-C-4B5E
(ucs-set-char #x62D2 ?$(GM\(B) ; C01-G-4D5C
(ucs-set-char #x62D2 ?$@5q(B) ; J78-@-3571
(ucs-set-char #x62D2 ?$A>\(B) ; GB0-A-3E5C
(ucs-set-char #x62D2 ?$B5q(B) ; J83-B-3571
(ucs-set-char #x62D3 ?$(Ct,(B) ; KS0-C-742C
(ucs-set-char #x62D3 ?$(GM_(B) ; C01-G-4D5F
(ucs-set-char #x62D3 ?$@Bs(B) ; J78-@-4273
(ucs-set-char #x62D3 ?$AMX(B) ; GB0-A-4D58
(ucs-set-char #x62D3 ?$BBs(B) ; J83-B-4273
(ucs-set-char #x62D4 ?$(CZ{(B) ; KS0-C-5A7B
(ucs-set-char #x62D4 ?$(GM`(B) ; C01-G-4D60
(ucs-set-char #x62D4 ?$@Y6(B) ; J78-@-5936
(ucs-set-char #x62D4 ?$A0N(B) ; GB0-A-304E
(ucs-set-char #x62D4 ?$BY6(B) ; J83-B-5936
(ucs-set-char #x62D5 ?$(D?S(B) ; J90-D-3F53
(ucs-set-char #x62D5 ?$(I).(B) ; C03-I-292E
(ucs-set-char #x62D6 ?$(Cvi(B) ; KS0-C-7669
(ucs-set-char #x62D6 ?$(D?T(B) ; J90-D-3F54
(ucs-set-char #x62D6 ?$(GMn(B) ; C01-G-4D6E
(ucs-set-char #x62D6 ?$AMO(B) ; GB0-A-4D4F
(ucs-set-char #x62D7 ?$(Chs(B) ; KS0-C-6873
(ucs-set-char #x62D7 ?$(GMo(B) ; C01-G-4D6F
(ucs-set-char #x62D7 ?$@Y9(B) ; J78-@-5939
(ucs-set-char #x62D7 ?$A^V(B) ; GB0-A-5E56
(ucs-set-char #x62D7 ?$BY9(B) ; J83-B-5939
(ucs-set-char #x62D8 ?$(CO,(B) ; KS0-C-4F2C
(ucs-set-char #x62D8 ?$(GMm(B) ; C01-G-4D6D
(ucs-set-char #x62D8 ?$@94(B) ; J78-@-3934
(ucs-set-char #x62D8 ?$A>P(B) ; GB0-A-3E50
(ucs-set-char #x62D8 ?$B94(B) ; J83-B-3934
(ucs-set-char #x62D9 ?$(Cpp(B) ; KS0-C-7070
(ucs-set-char #x62D9 ?$(GMg(B) ; C01-G-4D67
(ucs-set-char #x62D9 ?$@@[(B) ; J78-@-405B
(ucs-set-char #x62D9 ?$AW>(B) ; GB0-A-573E
(ucs-set-char #x62D9 ?$B@[(B) ; J83-B-405B
(ucs-set-char #x62DA ?$(D?U(B) ; J90-D-3F55
(ucs-set-char #x62DA ?$(GMk(B) ; C01-G-4D6B
(ucs-set-char #x62DA ?$A^U(B) ; GB0-A-5E55
(ucs-set-char #x62DB ?$(Ct}(B) ; KS0-C-747D
(ucs-set-char #x62DB ?$(GM](B) ; C01-G-4D5D
(ucs-set-char #x62DB ?$@>7(B) ; J78-@-3E37
(ucs-set-char #x62DB ?$AUP(B) ; GB0-A-5550
(ucs-set-char #x62DB ?$B>7(B) ; J83-B-3E37
(ucs-set-char #x62DC ?$(C[H(B) ; KS0-C-5B48
(ucs-set-char #x62DC ?$(GQ8(B) ; C01-G-5138
(ucs-set-char #x62DC ?$@YA(B) ; J78-@-5941
(ucs-set-char #x62DC ?$A0](B) ; GB0-A-305D
(ucs-set-char #x62DC ?$BYA(B) ; J83-B-5941
(ucs-set-char #x62DD ?$(I)0(B) ; C03-I-2930
(ucs-set-char #x62DD ?$@GR(B) ; J78-@-4752
(ucs-set-char #x62DD ?$BGR(B) ; J83-B-4752
(ucs-set-char #x62DE ?$(I)7(B) ; C03-I-2937
(ucs-set-char #x62DF ?$(I)5(B) ; C03-I-2935
(ucs-set-char #x62DF ?$ADb(B) ; GB0-A-4462
(ucs-set-char #x62E0 ?$(I)6(B) ; C03-I-2936
(ucs-set-char #x62E0 ?$@5r(B) ; J78-@-3572
(ucs-set-char #x62E0 ?$B5r(B) ; J83-B-3572
(ucs-set-char #x62E1 ?$(I)/(B) ; C03-I-292F
(ucs-set-char #x62E1 ?$@3H(B) ; J78-@-3348
(ucs-set-char #x62E1 ?$B3H(B) ; J83-B-3348
(ucs-set-char #x62E2 ?$AB#(B) ; GB0-A-4223
(ucs-set-char #x62E3 ?$A<p(B) ; GB0-A-3C70
(ucs-set-char #x62E4 ?$(I))(B) ; C03-I-2929
(ucs-set-char #x62E5 ?$AS5(B) ; GB0-A-5335
(ucs-set-char #x62E6 ?$A@9(B) ; GB0-A-4039
(ucs-set-char #x62E7 ?$AE!(B) ; GB0-A-4521
(ucs-set-char #x62E8 ?$(L+`(B) ; C06-L-2B60
(ucs-set-char #x62E8 ?$A2&(B) ; GB0-A-3226
(ucs-set-char #x62E9 ?$ATq(B) ; GB0-A-5471
(ucs-set-char #x62EA ?$(D?V(B) ; J90-D-3F56
(ucs-set-char #x62EA ?$(I,m(B) ; C03-I-2C6D
(ucs-set-char #x62EB ?$(H*[(B) ; C02-H-2A5B
(ucs-set-char #x62EC ?$(CN@(B) ; KS0-C-4E40
(ucs-set-char #x62EC ?$(GQD(B) ; C01-G-5144
(ucs-set-char #x62EC ?$@3g(B) ; J78-@-3367
(ucs-set-char #x62EC ?$A@((B) ; GB0-A-4028
(ucs-set-char #x62EC ?$B3g(B) ; J83-B-3367
(ucs-set-char #x62ED ?$(CcT(B) ; KS0-C-6354
(ucs-set-char #x62ED ?$(GQ<(B) ; C01-G-513C
(ucs-set-char #x62ED ?$@?!(B) ; J78-@-3F21
(ucs-set-char #x62ED ?$AJC(B) ; GB0-A-4A43
(ucs-set-char #x62ED ?$B?!(B) ; J83-B-3F21
(ucs-set-char #x62EE ?$(CQO(B) ; KS0-C-514F
(ucs-set-char #x62EE ?$(GQ>(B) ; C01-G-513E
(ucs-set-char #x62EE ?$@YI(B) ; J78-@-5949
(ucs-set-char #x62EE ?$A^W(B) ; GB0-A-5E57
(ucs-set-char #x62EE ?$BYI(B) ; J83-B-5949
(ucs-set-char #x62EF ?$(Cqu(B) ; KS0-C-7175
(ucs-set-char #x62EF ?$(GQC(B) ; C01-G-5143
(ucs-set-char #x62EF ?$@YN(B) ; J78-@-594E
(ucs-set-char #x62EF ?$AU|(B) ; GB0-A-557C
(ucs-set-char #x62EF ?$BYN(B) ; J83-B-594E
(ucs-set-char #x62F0 ?$(H*g(B) ; C02-H-2A67
(ucs-set-char #x62F1 ?$(CMr(B) ; KS0-C-4D72
(ucs-set-char #x62F1 ?$(GQA(B) ; C01-G-5141
(ucs-set-char #x62F1 ?$@YJ(B) ; J78-@-594A
(ucs-set-char #x62F1 ?$A90(B) ; GB0-A-3930
(ucs-set-char #x62F1 ?$BYJ(B) ; J83-B-594A
(ucs-set-char #x62F2 ?$(D?W(B) ; J90-D-3F57
(ucs-set-char #x62F2 ?$(H/3(B) ; C02-H-2F33
(ucs-set-char #x62F3 ?$(COk(B) ; KS0-C-4F6B
(ucs-set-char #x62F3 ?$(GUS(B) ; C01-G-5553
(ucs-set-char #x62F3 ?$@7}(B) ; J78-@-377D
(ucs-set-char #x62F3 ?$AH-(B) ; GB0-A-482D
(ucs-set-char #x62F3 ?$B7}(B) ; J83-B-377D
(ucs-set-char #x62F4 ?$(D?X(B) ; J90-D-3F58
(ucs-set-char #x62F4 ?$(GQF(B) ; C01-G-5146
(ucs-set-char #x62F4 ?$AK)(B) ; GB0-A-4B29
(ucs-set-char #x62F5 ?$(H*X(B) ; C02-H-2A58
(ucs-set-char #x62F5 ?$@YO(B) ; J78-@-594F
(ucs-set-char #x62F5 ?$BYO(B) ; J83-B-594F
(ucs-set-char #x62F6 ?$(H*`(B) ; C02-H-2A60
(ucs-set-char #x62F6 ?$@;"(B) ; J78-@-3B22
(ucs-set-char #x62F6 ?$A^Y(B) ; GB0-A-5E59
(ucs-set-char #x62F6 ?$B;"(B) ; J83-B-3B22
(ucs-set-char #x62F7 ?$(CM8(B) ; KS0-C-4D38
(ucs-set-char #x62F7 ?$(GQB(B) ; C01-G-5142
(ucs-set-char #x62F7 ?$@9i(B) ; J78-@-3969
(ucs-set-char #x62F7 ?$A?=(B) ; GB0-A-3F3D
(ucs-set-char #x62F7 ?$B9i(B) ; J83-B-3969
(ucs-set-char #x62F8 ?$(H*_(B) ; C02-H-2A5F
(ucs-set-char #x62F9 ?$(H*\(B) ; C02-H-2A5C
(ucs-set-char #x62FA ?$(H*d(B) ; C02-H-2A64
(ucs-set-char #x62FB ?$(H*f(B) ; C02-H-2A66
(ucs-set-char #x62FC ?$(D?Y(B) ; J90-D-3F59
(ucs-set-char #x62FC ?$(GQ;(B) ; C01-G-513B
(ucs-set-char #x62FC ?$(I6((B) ; C03-I-3628
(ucs-set-char #x62FC ?$AF4(B) ; GB0-A-4634
(ucs-set-char #x62FD ?$(D?Z(B) ; J90-D-3F5A
(ucs-set-char #x62FD ?$(GQ?(B) ; C01-G-513F
(ucs-set-char #x62FD ?$AW'(B) ; GB0-A-5727
(ucs-set-char #x62FE ?$(Cc&(B) ; KS0-C-6326
(ucs-set-char #x62FE ?$(GQE(B) ; C01-G-5145
(ucs-set-char #x62FE ?$@=&(B) ; J78-@-3D26
(ucs-set-char #x62FE ?$AJ0(B) ; GB0-A-4A30
(ucs-set-char #x62FE ?$B=&(B) ; J83-B-3D26
(ucs-set-char #x62FF ?$(CQZ(B) ; KS0-C-515A
(ucs-set-char #x62FF ?$(GUU(B) ; C01-G-5555
(ucs-set-char #x62FF ?$@Y=(B) ; J78-@-593D
(ucs-set-char #x62FF ?$ADC(B) ; GB0-A-4443
(ucs-set-char #x62FF ?$BY=(B) ; J83-B-593D
(ucs-set-char #x6300 ?$(H*a(B) ; C02-H-2A61
(ucs-set-char #x6301 ?$(Cr%(B) ; KS0-C-7225
(ucs-set-char #x6301 ?$(GQ=(B) ; C01-G-513D
(ucs-set-char #x6301 ?$@;}(B) ; J78-@-3B7D
(ucs-set-char #x6301 ?$A3V(B) ; GB0-A-3356
(ucs-set-char #x6301 ?$B;}(B) ; J83-B-3B7D
(ucs-set-char #x6302 ?$(GQH(B) ; C01-G-5148
(ucs-set-char #x6302 ?$@YL(B) ; J78-@-594C
(ucs-set-char #x6302 ?$A9R(B) ; GB0-A-3952
(ucs-set-char #x6302 ?$BYL(B) ; J83-B-594C
(ucs-set-char #x6303 ?$(D?[(B) ; J90-D-3F5B
(ucs-set-char #x6303 ?$(H*Z(B) ; C02-H-2A5A
(ucs-set-char #x6304 ?$(D?\(B) ; J90-D-3F5C
(ucs-set-char #x6304 ?$(I,o(B) ; C03-I-2C6F
(ucs-set-char #x6305 ?$(I,p(B) ; C03-I-2C70
(ucs-set-char #x6306 ?$(K)E(B) ; C05-K-2945
(ucs-set-char #x6307 ?$(Cr&(B) ; KS0-C-7226
(ucs-set-char #x6307 ?$(GQ@(B) ; C01-G-5140
(ucs-set-char #x6307 ?$@;X(B) ; J78-@-3B58
(ucs-set-char #x6307 ?$AV8(B) ; GB0-A-5638
(ucs-set-char #x6307 ?$B;X(B) ; J83-B-3B58
(ucs-set-char #x6308 ?$(GUT(B) ; C01-G-5554
(ucs-set-char #x6308 ?$@YM(B) ; J78-@-594D
(ucs-set-char #x6308 ?$Aj|(B) ; GB0-A-6A7C
(ucs-set-char #x6308 ?$BYM(B) ; J83-B-594D
(ucs-set-char #x6309 ?$(CdN(B) ; KS0-C-644E
(ucs-set-char #x6309 ?$(GQ:(B) ; C01-G-513A
(ucs-set-char #x6309 ?$@0D(B) ; J78-@-3044
(ucs-set-char #x6309 ?$A04(B) ; GB0-A-3034
(ucs-set-char #x6309 ?$B0D(B) ; J83-B-3044
(ucs-set-char #x630A ?$(D?](B) ; J90-D-3F5D
(ucs-set-char #x630A ?$(J)Y(B) ; C04-J-2959
(ucs-set-char #x630B ?$(D?^(B) ; J90-D-3F5E
(ucs-set-char #x630B ?$(H*W(B) ; C02-H-2A57
(ucs-set-char #x630C ?$(H*^(B) ; C02-H-2A5E
(ucs-set-char #x630C ?$@YH(B) ; J78-@-5948
(ucs-set-char #x630C ?$BYH(B) ; J83-B-5948
(ucs-set-char #x630D ?$(D?_(B) ; J90-D-3F5F
(ucs-set-char #x630D ?$(H*V(B) ; C02-H-2A56
(ucs-set-char #x630E ?$(H*Y(B) ; C02-H-2A59
(ucs-set-char #x630E ?$A?f(B) ; GB0-A-3F66
(ucs-set-char #x630F ?$(H*](B) ; C02-H-2A5D
(ucs-set-char #x6310 ?$(D?`(B) ; J90-D-3F60
(ucs-set-char #x6310 ?$(H/4(B) ; C02-H-2F34
(ucs-set-char #x6311 ?$(CS{(B) ; KS0-C-537B
(ucs-set-char #x6311 ?$(GQG(B) ; C01-G-5147
(ucs-set-char #x6311 ?$@D)(B) ; J78-@-4429
(ucs-set-char #x6311 ?$ALt(B) ; GB0-A-4C74
(ucs-set-char #x6311 ?$BD)(B) ; J83-B-4429
(ucs-set-char #x6312 ?$(J)Q(B) ; C04-J-2951
(ucs-set-char #x6313 ?$(D?a(B) ; J90-D-3F61
(ucs-set-char #x6313 ?$(H*b(B) ; C02-H-2A62
(ucs-set-char #x6314 ?$(H*c(B) ; C02-H-2A63
(ucs-set-char #x6315 ?$(H*e(B) ; C02-H-2A65
(ucs-set-char #x6316 ?$(D?b(B) ; J90-D-3F62
(ucs-set-char #x6316 ?$(GQ9(B) ; C01-G-5139
(ucs-set-char #x6316 ?$AMZ(B) ; GB0-A-4D5A
(ucs-set-char #x6317 ?$(I,l(B) ; C03-I-2C6C
(ucs-set-char #x6318 ?$(D?c(B) ; J90-D-3F63
(ucs-set-char #x6319 ?$(I12(B) ; C03-I-3132
(ucs-set-char #x6319 ?$@5s(B) ; J78-@-3573
(ucs-set-char #x6319 ?$B5s(B) ; J83-B-3573
(ucs-set-char #x631A ?$AV?(B) ; GB0-A-563F
(ucs-set-char #x631B ?$(I13(B) ; C03-I-3133
(ucs-set-char #x631B ?$ABN(B) ; GB0-A-424E
(ucs-set-char #x631D ?$ANN(B) ; GB0-A-4E4E
(ucs-set-char #x631E ?$AL"(B) ; GB0-A-4C22
(ucs-set-char #x631F ?$(I,k(B) ; C03-I-2C6B
(ucs-set-char #x631F ?$@64(B) ; J78-@-3634
(ucs-set-char #x631F ?$AP.(B) ; GB0-A-502E
(ucs-set-char #x631F ?$B64(B) ; J83-B-3634
(ucs-set-char #x6320 ?$ADS(B) ; GB0-A-4453
(ucs-set-char #x6321 ?$(I,n(B) ; C03-I-2C6E
(ucs-set-char #x6321 ?$A52(B) ; GB0-A-3532
(ucs-set-char #x6322 ?$A^X(B) ; GB0-A-5E58
(ucs-set-char #x6323 ?$(J)[(B) ; C04-J-295B
(ucs-set-char #x6323 ?$AUu(B) ; GB0-A-5575
(ucs-set-char #x6324 ?$A<7(B) ; GB0-A-3C37
(ucs-set-char #x6325 ?$A;S(B) ; GB0-A-3B53
(ucs-set-char #x6327 ?$@YK(B) ; J78-@-594B
(ucs-set-char #x6327 ?$BYK(B) ; J83-B-594B
(ucs-set-char #x6328 ?$(GUc(B) ; C01-G-5563
(ucs-set-char #x6328 ?$@0'(B) ; J78-@-3027
(ucs-set-char #x6328 ?$A0$(B) ; GB0-A-3024
(ucs-set-char #x6328 ?$B0'(B) ; J83-B-3027
(ucs-set-char #x6329 ?$(D?d(B) ; J90-D-3F64
(ucs-set-char #x6329 ?$(H/@(B) ; C02-H-2F40
(ucs-set-char #x632A ?$(D?e(B) ; J90-D-3F65
(ucs-set-char #x632A ?$(GUa(B) ; C01-G-5561
(ucs-set-char #x632A ?$AE2(B) ; GB0-A-4532
(ucs-set-char #x632B ?$(Cq)(B) ; KS0-C-7129
(ucs-set-char #x632B ?$(GUb(B) ; C01-G-5562
(ucs-set-char #x632B ?$@:C(B) ; J78-@-3A43
(ucs-set-char #x632B ?$A4l(B) ; GB0-A-346C
(ucs-set-char #x632B ?$B:C(B) ; J83-B-3A43
(ucs-set-char #x632C ?$(H/6(B) ; C02-H-2F36
(ucs-set-char #x632D ?$(D?f(B) ; J90-D-3F66
(ucs-set-char #x632D ?$(H/F(B) ; C02-H-2F46
(ucs-set-char #x632E ?$(I1,(B) ; C03-I-312C
(ucs-set-char #x632F ?$(CrI(B) ; KS0-C-7249
(ucs-set-char #x632F ?$(GUX(B) ; C01-G-5558
(ucs-set-char #x632F ?$@?6(B) ; J78-@-3F36
(ucs-set-char #x632F ?$AUq(B) ; GB0-A-5571
(ucs-set-char #x632F ?$B?6(B) ; J83-B-3F36
(ucs-set-char #x6330 ?$(I1/(B) ; C03-I-312F
(ucs-set-char #x6331 ?$(I15(B) ; C03-I-3135
(ucs-set-char #x6332 ?$(H5J(B) ; C02-H-354A
(ucs-set-char #x6332 ?$Aj}(B) ; GB0-A-6A7D
(ucs-set-char #x6333 ?$(H/H(B) ; C02-H-2F48
(ucs-set-char #x6334 ?$(H/B(B) ; C02-H-2F42
(ucs-set-char #x6335 ?$(D?g(B) ; J90-D-3F67
(ucs-set-char #x6335 ?$(I18(B) ; C03-I-3138
(ucs-set-char #x6336 ?$(D?h(B) ; J90-D-3F68
(ucs-set-char #x6336 ?$(H/9(B) ; C02-H-2F39
(ucs-set-char #x6337 ?$(I17(B) ; C03-I-3137
(ucs-set-char #x6338 ?$(H/K(B) ; C02-H-2F4B
(ucs-set-char #x6339 ?$(D?i(B) ; J90-D-3F69
(ucs-set-char #x6339 ?$(H/<(B) ; C02-H-2F3C
(ucs-set-char #x6339 ?$A^Z(B) ; GB0-A-5E5A
(ucs-set-char #x633A ?$(CoX(B) ; KS0-C-6F58
(ucs-set-char #x633A ?$(GU^(B) ; C01-G-555E
(ucs-set-char #x633A ?$@Dr(B) ; J78-@-4472
(ucs-set-char #x633A ?$AM&(B) ; GB0-A-4D26
(ucs-set-char #x633A ?$BDr(B) ; J83-B-4472
(ucs-set-char #x633B ?$(CfI(B) ; KS0-C-6649
(ucs-set-char #x633B ?$(H5a(B) ; C02-H-3561
(ucs-set-char #x633C ?$(D?j(B) ; J90-D-3F6A
(ucs-set-char #x633C ?$(H/?(B) ; C02-H-2F3F
(ucs-set-char #x633D ?$(CX8(B) ; KS0-C-5838
(ucs-set-char #x633D ?$(GU`(B) ; C01-G-5560
(ucs-set-char #x633D ?$@HT(B) ; J78-@-4854
(ucs-set-char #x633D ?$AMl(B) ; GB0-A-4D6C
(ucs-set-char #x633D ?$BHT(B) ; J83-B-4854
(ucs-set-char #x633E ?$(Czs(B) ; KS0-C-7A73
(ucs-set-char #x633E ?$(GUW(B) ; C01-G-5557
(ucs-set-char #x633E ?$@YQ(B) ; J78-@-5951
(ucs-set-char #x633E ?$BYQ(B) ; J83-B-5951
(ucs-set-char #x633F ?$(I1<(B) ; C03-I-313C
(ucs-set-char #x633F ?$@A^(B) ; J78-@-415E
(ucs-set-char #x633F ?$BA^(B) ; J83-B-415E
(ucs-set-char #x6340 ?$(H/M(B) ; C02-H-2F4D
(ucs-set-char #x6341 ?$(D?k(B) ; J90-D-3F6B
(ucs-set-char #x6341 ?$(H/A(B) ; C02-H-2F41
(ucs-set-char #x6342 ?$(D?l(B) ; J90-D-3F6C
(ucs-set-char #x6342 ?$(GUZ(B) ; C01-G-555A
(ucs-set-char #x6342 ?$ANf(B) ; GB0-A-4E66
(ucs-set-char #x6343 ?$(D?m(B) ; J90-D-3F6D
(ucs-set-char #x6343 ?$(H/:(B) ; C02-H-2F3A
(ucs-set-char #x6343 ?$A^\(B) ; GB0-A-5E5C
(ucs-set-char #x6344 ?$(D?n(B) ; J90-D-3F6E
(ucs-set-char #x6344 ?$(H/7(B) ; C02-H-2F37
(ucs-set-char #x6345 ?$(H/8(B) ; C02-H-2F38
(ucs-set-char #x6345 ?$AM1(B) ; GB0-A-4D31
(ucs-set-char #x6346 ?$(D?o(B) ; J90-D-3F6F
(ucs-set-char #x6346 ?$(GU[(B) ; C01-G-555B
(ucs-set-char #x6346 ?$A@&(B) ; GB0-A-4026
(ucs-set-char #x6347 ?$(H/G(B) ; C02-H-2F47
(ucs-set-char #x6348 ?$(H/N(B) ; C02-H-2F4E
(ucs-set-char #x6349 ?$(Cs5(B) ; KS0-C-7335
(ucs-set-char #x6349 ?$(GU](B) ; C01-G-555D
(ucs-set-char #x6349 ?$@B*(B) ; J78-@-422A
(ucs-set-char #x6349 ?$AW=(B) ; GB0-A-573D
(ucs-set-char #x6349 ?$BB*(B) ; J83-B-422A
(ucs-set-char #x634A ?$(D?p(B) ; J90-D-3F70
(ucs-set-char #x634A ?$(H/>(B) ; C02-H-2F3E
(ucs-set-char #x634B ?$(D?q(B) ; J90-D-3F71
(ucs-set-char #x634B ?$(H/=(B) ; C02-H-2F3D
(ucs-set-char #x634B ?$A^[(B) ; GB0-A-5E5B
(ucs-set-char #x634C ?$(Cx$(B) ; KS0-C-7824
(ucs-set-char #x634C ?$(GUe(B) ; C01-G-5565
(ucs-set-char #x634C ?$@;+(B) ; J78-@-3B2B
(ucs-set-char #x634C ?$A0F(B) ; GB0-A-3046
(ucs-set-char #x634C ?$B;+(B) ; J83-B-3B2B
(ucs-set-char #x634D ?$(GUd(B) ; C01-G-5564
(ucs-set-char #x634D ?$@YR(B) ; J78-@-5952
(ucs-set-char #x634D ?$A:4(B) ; GB0-A-3A34
(ucs-set-char #x634D ?$BYR(B) ; J83-B-5952
(ucs-set-char #x634E ?$(D?r(B) ; J90-D-3F72
(ucs-set-char #x634E ?$(GUV(B) ; C01-G-5556
(ucs-set-char #x634E ?$AIS(B) ; GB0-A-4953
(ucs-set-char #x634F ?$(CQs(B) ; KS0-C-5173
(ucs-set-char #x634F ?$(GU\(B) ; C01-G-555C
(ucs-set-char #x634F ?$@YT(B) ; J78-@-5954
(ucs-set-char #x634F ?$ADs(B) ; GB0-A-4473
(ucs-set-char #x634F ?$BYT(B) ; J83-B-5954
(ucs-set-char #x6350 ?$(CfH(B) ; KS0-C-6648
(ucs-set-char #x6350 ?$(GU_(B) ; C01-G-555F
(ucs-set-char #x6350 ?$@YP(B) ; J78-@-5950
(ucs-set-char #x6350 ?$A>h(B) ; GB0-A-3E68
(ucs-set-char #x6350 ?$BYP(B) ; J83-B-5950
(ucs-set-char #x6351 ?$(H/J(B) ; C02-H-2F4A
(ucs-set-char #x6352 ?$(D?s(B) ; J90-D-3F73
(ucs-set-char #x6352 ?$(I1.(B) ; C03-I-312E
(ucs-set-char #x6353 ?$(D?t(B) ; J90-D-3F74
(ucs-set-char #x6353 ?$(I19(B) ; C03-I-3139
(ucs-set-char #x6354 ?$(D?u(B) ; J90-D-3F75
(ucs-set-char #x6354 ?$(H/D(B) ; C02-H-2F44
(ucs-set-char #x6355 ?$(CxZ(B) ; KS0-C-785A
(ucs-set-char #x6355 ?$(GUY(B) ; C01-G-5559
(ucs-set-char #x6355 ?$@Ja(B) ; J78-@-4A61
(ucs-set-char #x6355 ?$A26(B) ; GB0-A-3236
(ucs-set-char #x6355 ?$BJa(B) ; J83-B-4A61
(ucs-set-char #x6356 ?$(H/5(B) ; C02-H-2F35
(ucs-set-char #x6357 ?$(H/L(B) ; C02-H-2F4C
(ucs-set-char #x6357 ?$@D=(B) ; J78-@-443D
(ucs-set-char #x6357 ?$BD=(B) ; J83-B-443D
(ucs-set-char #x6358 ?$(D?v(B) ; J90-D-3F76
(ucs-set-char #x6358 ?$(H/C(B) ; C02-H-2F43
(ucs-set-char #x6359 ?$(H/E(B) ; C02-H-2F45
(ucs-set-char #x635A ?$(H/I(B) ; C02-H-2F49
(ucs-set-char #x635B ?$(D?w(B) ; J90-D-3F77
(ucs-set-char #x635B ?$(I10(B) ; C03-I-3130
(ucs-set-char #x635C ?$(I1;(B) ; C03-I-313B
(ucs-set-char #x635C ?$@A\(B) ; J78-@-415C
(ucs-set-char #x635C ?$BA\(B) ; J83-B-415C
(ucs-set-char #x635D ?$(I16(B) ; C03-I-3136
(ucs-set-char #x635E ?$A@L(B) ; GB0-A-404C
(ucs-set-char #x635F ?$AKp(B) ; GB0-A-4B70
(ucs-set-char #x6361 ?$A<q(B) ; GB0-A-3C71
(ucs-set-char #x6362 ?$A;;(B) ; GB0-A-3B3B
(ucs-set-char #x6363 ?$A57(B) ; GB0-A-3537
(ucs-set-char #x6365 ?$(D?x(B) ; J90-D-3F78
(ucs-set-char #x6365 ?$(H5K(B) ; C02-H-354B
(ucs-set-char #x6366 ?$(D?y(B) ; J90-D-3F79
(ucs-set-char #x6366 ?$(I61(B) ; C03-I-3631
(ucs-set-char #x6367 ?$(C\i(B) ; KS0-C-5C69
(ucs-set-char #x6367 ?$(GZ[(B) ; C01-G-5A5B
(ucs-set-char #x6367 ?$@J{(B) ; J78-@-4A7B
(ucs-set-char #x6367 ?$AEu(B) ; GB0-A-4575
(ucs-set-char #x6367 ?$BJ{(B) ; J83-B-4A7B
(ucs-set-char #x6368 ?$(C^W(B) ; KS0-C-5E57
(ucs-set-char #x6368 ?$(GZo(B) ; C01-G-5A6F
(ucs-set-char #x6368 ?$(L@6(B) ; C06-L-4036
(ucs-set-char #x6368 ?$@<N(B) ; J78-@-3C4E
(ucs-set-char #x6368 ?$B<N(B) ; J83-B-3C4E
(ucs-set-char #x6369 ?$(GZn(B) ; C01-G-5A6E
(ucs-set-char #x6369 ?$@Y`(B) ; J78-@-5960
(ucs-set-char #x6369 ?$A^f(B) ; GB0-A-5E66
(ucs-set-char #x6369 ?$BY`(B) ; J83-B-5960
(ucs-set-char #x636A ?$(I6'(B) ; C03-I-3627
(ucs-set-char #x636B ?$(GZc(B) ; C01-G-5A63
(ucs-set-char #x636B ?$@Y_(B) ; J78-@-595F
(ucs-set-char #x636B ?$BY_(B) ; J83-B-595F
(ucs-set-char #x636C ?$(D?z(B) ; J90-D-3F7A
(ucs-set-char #x636C ?$(I6)(B) ; C03-I-3629
(ucs-set-char #x636D ?$(D?{(B) ; J90-D-3F7B
(ucs-set-char #x636D ?$(H5](B) ; C02-H-355D
(ucs-set-char #x636D ?$A^c(B) ; GB0-A-5E63
(ucs-set-char #x636E ?$(CK_(B) ; KS0-C-4B5F
(ucs-set-char #x636E ?$(H5Y(B) ; C02-H-3559
(ucs-set-char #x636E ?$@?x(B) ; J78-@-3F78
(ucs-set-char #x636E ?$A>](B) ; GB0-A-3E5D
(ucs-set-char #x636E ?$B?x(B) ; J83-B-3F78
(ucs-set-char #x636F ?$(H5V(B) ; C02-H-3556
(ucs-set-char #x6370 ?$(H5h(B) ; C02-H-3568
(ucs-set-char #x6371 ?$(D?|(B) ; J90-D-3F7C
(ucs-set-char #x6371 ?$(GZ^(B) ; C01-G-5A5E
(ucs-set-char #x6371 ?$A^_(B) ; GB0-A-5E5F
(ucs-set-char #x6372 ?$(COl(B) ; KS0-C-4F6C
(ucs-set-char #x6372 ?$(GZV(B) ; C01-G-5A56
(ucs-set-char #x6372 ?$@7~(B) ; J78-@-377E
(ucs-set-char #x6372 ?$B7~(B) ; J83-B-377E
(ucs-set-char #x6373 ?$(I6&(B) ; C03-I-3626
(ucs-set-char #x6374 ?$(D?}(B) ; J90-D-3F7D
(ucs-set-char #x6374 ?$(I62(B) ; C03-I-3632
(ucs-set-char #x6375 ?$(D?~(B) ; J90-D-3F7E
(ucs-set-char #x6375 ?$(H5[(B) ; C02-H-355B
(ucs-set-char #x6376 ?$(G_M(B) ; C01-G-5F4D
(ucs-set-char #x6376 ?$@YY(B) ; J78-@-5959
(ucs-set-char #x6376 ?$A47(B) ; GB0-A-3437
(ucs-set-char #x6376 ?$BYY(B) ; J83-B-5959
(ucs-set-char #x6377 ?$(Ct_(B) ; KS0-C-745F
(ucs-set-char #x6377 ?$(GZZ(B) ; C01-G-5A5A
(ucs-set-char #x6377 ?$@>9(B) ; J78-@-3E39
(ucs-set-char #x6377 ?$A=](B) ; GB0-A-3D5D
(ucs-set-char #x6377 ?$B>9(B) ; J83-B-3E39
(ucs-set-char #x6378 ?$(D@!(B) ; J90-D-4021
(ucs-set-char #x6378 ?$(H5c(B) ; C02-H-3563
(ucs-set-char #x6379 ?$(I6"(B) ; C03-I-3622
(ucs-set-char #x637A ?$(CQt(B) ; KS0-C-5174
(ucs-set-char #x637A ?$(GZp(B) ; C01-G-5A70
(ucs-set-char #x637A ?$@Fh(B) ; J78-@-4668
(ucs-set-char #x637A ?$A^`(B) ; GB0-A-5E60
(ucs-set-char #x637A ?$BFh(B) ; J83-B-4668
(ucs-set-char #x637B ?$(CR:(B) ; KS0-C-523A
(ucs-set-char #x637B ?$(GZm(B) ; C01-G-5A6D
(ucs-set-char #x637B ?$@G1(B) ; J78-@-4731
(ucs-set-char #x637B ?$ADm(B) ; GB0-A-446D
(ucs-set-char #x637B ?$BG1(B) ; J83-B-4731
(ucs-set-char #x637C ?$(D@"(B) ; J90-D-4022
(ucs-set-char #x637C ?$(H5_(B) ; C02-H-355F
(ucs-set-char #x637D ?$(D@#(B) ; J90-D-4023
(ucs-set-char #x637D ?$(H5N(B) ; C02-H-354E
(ucs-set-char #x637E ?$(I5|(B) ; C03-I-357C
(ucs-set-char #x637F ?$(C_r(B) ; KS0-C-5F72
(ucs-set-char #x637F ?$(D@$(B) ; J90-D-4024
(ucs-set-char #x637F ?$(I6+(B) ; C03-I-362B
(ucs-set-char #x6380 ?$(GZl(B) ; C01-G-5A6C
(ucs-set-char #x6380 ?$@YW(B) ; J78-@-5957
(ucs-set-char #x6380 ?$AOF(B) ; GB0-A-4F46
(ucs-set-char #x6380 ?$BYW(B) ; J83-B-5957
(ucs-set-char #x6381 ?$(H5e(B) ; C02-H-3565
(ucs-set-char #x6382 ?$(D@%(B) ; J90-D-4025
(ucs-set-char #x6382 ?$(H5M(B) ; C02-H-354D
(ucs-set-char #x6382 ?$A5`(B) ; GB0-A-3560
(ucs-set-char #x6383 ?$(Ca7(B) ; KS0-C-6137
(ucs-set-char #x6383 ?$(GZa(B) ; C01-G-5A61
(ucs-set-char #x6383 ?$(L@+(B) ; C06-L-402B
(ucs-set-char #x6383 ?$@A](B) ; J78-@-415D
(ucs-set-char #x6383 ?$BA](B) ; J83-B-415D
(ucs-set-char #x6384 ?$(D@&(B) ; J90-D-4026
(ucs-set-char #x6384 ?$(GZe(B) ; C01-G-5A65
(ucs-set-char #x6385 ?$(H5d(B) ; C02-H-3564
(ucs-set-char #x6386 ?$(I6#(B) ; C03-I-3623
(ucs-set-char #x6387 ?$(D@'(B) ; J90-D-4027
(ucs-set-char #x6387 ?$(H5W(B) ; C02-H-3557
(ucs-set-char #x6387 ?$A6^(B) ; GB0-A-365E
(ucs-set-char #x6388 ?$(Cb#(B) ; KS0-C-6223
(ucs-set-char #x6388 ?$(GZf(B) ; C01-G-5A66
(ucs-set-char #x6388 ?$@<x(B) ; J78-@-3C78
(ucs-set-char #x6388 ?$AJZ(B) ; GB0-A-4A5A
(ucs-set-char #x6388 ?$B<x(B) ; J83-B-3C78
(ucs-set-char #x6389 ?$(CS|(B) ; KS0-C-537C
(ucs-set-char #x6389 ?$(GZ`(B) ; C01-G-5A60
(ucs-set-char #x6389 ?$@Y\(B) ; J78-@-595C
(ucs-set-char #x6389 ?$A5t(B) ; GB0-A-3574
(ucs-set-char #x6389 ?$BY\(B) ; J83-B-595C
(ucs-set-char #x638A ?$(D@((B) ; J90-D-4028
(ucs-set-char #x638A ?$(H5L(B) ; C02-H-354C
(ucs-set-char #x638A ?$A^e(B) ; GB0-A-5E65
(ucs-set-char #x638B ?$(I5}(B) ; C03-I-357D
(ucs-set-char #x638C ?$(Cmf(B) ; KS0-C-6D66
(ucs-set-char #x638C ?$(G_?(B) ; C01-G-5F3F
(ucs-set-char #x638C ?$@>8(B) ; J78-@-3E38
(ucs-set-char #x638C ?$AUF(B) ; GB0-A-5546
(ucs-set-char #x638C ?$B>8(B) ; J83-B-3E38
(ucs-set-char #x638D ?$(H5g(B) ; C02-H-3567
(ucs-set-char #x638E ?$(H5U(B) ; C02-H-3555
(ucs-set-char #x638E ?$@YV(B) ; J78-@-5956
(ucs-set-char #x638E ?$A^a(B) ; GB0-A-5E61
(ucs-set-char #x638E ?$BYV(B) ; J83-B-5956
(ucs-set-char #x638F ?$(GZk(B) ; C01-G-5A6B
(ucs-set-char #x638F ?$@Y[(B) ; J78-@-595B
(ucs-set-char #x638F ?$ALM(B) ; GB0-A-4C4D
(ucs-set-char #x638F ?$BY[(B) ; J83-B-595B
(ucs-set-char #x6390 ?$(D@)(B) ; J90-D-4029
(ucs-set-char #x6390 ?$(H5X(B) ; C02-H-3558
(ucs-set-char #x6390 ?$AF~(B) ; GB0-A-467E
(ucs-set-char #x6391 ?$(H5f(B) ; C02-H-3566
(ucs-set-char #x6392 ?$(C[I(B) ; KS0-C-5B49
(ucs-set-char #x6392 ?$(GZj(B) ; C01-G-5A6A
(ucs-set-char #x6392 ?$@GS(B) ; J78-@-4753
(ucs-set-char #x6392 ?$AEE(B) ; GB0-A-4545
(ucs-set-char #x6392 ?$BGS(B) ; J83-B-4753
(ucs-set-char #x6393 ?$(I6$(B) ; C03-I-3624
(ucs-set-char #x6394 ?$(D@*(B) ; J90-D-402A
(ucs-set-char #x6394 ?$(H;u(B) ; C02-H-3B75
(ucs-set-char #x6395 ?$(D@+(B) ; J90-D-402B
(ucs-set-char #x6395 ?$(J1w(B) ; C04-J-3177
(ucs-set-char #x6396 ?$(Cdz(B) ; KS0-C-647A
(ucs-set-char #x6396 ?$(GZW(B) ; C01-G-5A57
(ucs-set-char #x6396 ?$@YU(B) ; J78-@-5955
(ucs-set-char #x6396 ?$AR4(B) ; GB0-A-5234
(ucs-set-char #x6396 ?$BYU(B) ; J83-B-5955
(ucs-set-char #x6397 ?$(H5S(B) ; C02-H-3553
(ucs-set-char #x6398 ?$(CO^(B) ; KS0-C-4F5E
(ucs-set-char #x6398 ?$(GZ\(B) ; C01-G-5A5C
(ucs-set-char #x6398 ?$@7!(B) ; J78-@-3721
(ucs-set-char #x6398 ?$A>r(B) ; GB0-A-3E72
(ucs-set-char #x6398 ?$B7!(B) ; J83-B-3721
(ucs-set-char #x6399 ?$(D@,(B) ; J90-D-402C
(ucs-set-char #x6399 ?$(GZg(B) ; C01-G-5A67
(ucs-set-char #x639A ?$(D@-(B) ; J90-D-402D
(ucs-set-char #x639A ?$(J1x(B) ; C04-J-3178
(ucs-set-char #x639B ?$(CNP(B) ; KS0-C-4E50
(ucs-set-char #x639B ?$(GZb(B) ; C01-G-5A62
(ucs-set-char #x639B ?$@3](B) ; J78-@-335D
(ucs-set-char #x639B ?$B3](B) ; J83-B-335D
(ucs-set-char #x639C ?$(H5\(B) ; C02-H-355C
(ucs-set-char #x639D ?$(H5R(B) ; C02-H-3552
(ucs-set-char #x639E ?$(D@.(B) ; J90-D-402E
(ucs-set-char #x639E ?$(H5P(B) ; C02-H-3550
(ucs-set-char #x639F ?$(H5b(B) ; C02-H-3562
(ucs-set-char #x639F ?$@Y](B) ; J78-@-595D
(ucs-set-char #x639F ?$BY](B) ; J83-B-595D
(ucs-set-char #x63A0 ?$(CUS(B) ; KS0-C-5553
(ucs-set-char #x63A0 ?$(GZT(B) ; C01-G-5A54
(ucs-set-char #x63A0 ?$@N+(B) ; J78-@-4E2B
(ucs-set-char #x63A0 ?$ABS(B) ; GB0-A-4253
(ucs-set-char #x63A0 ?$BN+(B) ; J83-B-4E2B
(ucs-set-char #x63A1 ?$(Csu(B) ; KS0-C-7375
(ucs-set-char #x63A1 ?$(GZh(B) ; C01-G-5A68
(ucs-set-char #x63A1 ?$@:N(B) ; J78-@-3A4E
(ucs-set-char #x63A1 ?$B:N(B) ; J83-B-3A4E
(ucs-set-char #x63A2 ?$(Cw.(B) ; KS0-C-772E
(ucs-set-char #x63A2 ?$(GZX(B) ; C01-G-5A58
(ucs-set-char #x63A2 ?$@C5(B) ; J78-@-4335
(ucs-set-char #x63A2 ?$AL=(B) ; GB0-A-4C3D
(ucs-set-char #x63A2 ?$BC5(B) ; J83-B-4335
(ucs-set-char #x63A3 ?$(G_>(B) ; C01-G-5F3E
(ucs-set-char #x63A3 ?$@YZ(B) ; J78-@-595A
(ucs-set-char #x63A3 ?$A38(B) ; GB0-A-3338
(ucs-set-char #x63A3 ?$BYZ(B) ; J83-B-595A
(ucs-set-char #x63A4 ?$(D@/(B) ; J90-D-402F
(ucs-set-char #x63A4 ?$(H5`(B) ; C02-H-3560
(ucs-set-char #x63A5 ?$(CoH(B) ; KS0-C-6F48
(ucs-set-char #x63A5 ?$(GZY(B) ; C01-G-5A59
(ucs-set-char #x63A5 ?$@@\(B) ; J78-@-405C
(ucs-set-char #x63A5 ?$A=S(B) ; GB0-A-3D53
(ucs-set-char #x63A5 ?$B@\(B) ; J83-B-405C
(ucs-set-char #x63A6 ?$(D@0(B) ; J90-D-4030
(ucs-set-char #x63A6 ?$(J2#(B) ; C04-J-3223
(ucs-set-char #x63A7 ?$(CMs(B) ; KS0-C-4D73
(ucs-set-char #x63A7 ?$(GZU(B) ; C01-G-5A55
(ucs-set-char #x63A7 ?$@95(B) ; J78-@-3935
(ucs-set-char #x63A7 ?$A?X(B) ; GB0-A-3F58
(ucs-set-char #x63A7 ?$B95(B) ; J83-B-3935
(ucs-set-char #x63A8 ?$(CuO(B) ; KS0-C-754F
(ucs-set-char #x63A8 ?$(GZd(B) ; C01-G-5A64
(ucs-set-char #x63A8 ?$@?d(B) ; J78-@-3F64
(ucs-set-char #x63A8 ?$AMF(B) ; GB0-A-4D46
(ucs-set-char #x63A8 ?$B?d(B) ; J83-B-3F64
(ucs-set-char #x63A9 ?$(Ces(B) ; KS0-C-6573
(ucs-set-char #x63A9 ?$(GZ_(B) ; C01-G-5A5F
(ucs-set-char #x63A9 ?$@1f(B) ; J78-@-3166
(ucs-set-char #x63A9 ?$AQZ(B) ; GB0-A-515A
(ucs-set-char #x63A9 ?$B1f(B) ; J83-B-3166
(ucs-set-char #x63AA ?$(CpB(B) ; KS0-C-7042
(ucs-set-char #x63AA ?$(GZ](B) ; C01-G-5A5D
(ucs-set-char #x63AA ?$@A<(B) ; J78-@-413C
(ucs-set-char #x63AA ?$A4k(B) ; GB0-A-346B
(ucs-set-char #x63AA ?$BA<(B) ; J83-B-413C
(ucs-set-char #x63AB ?$(H5T(B) ; C02-H-3554
(ucs-set-char #x63AB ?$@YX(B) ; J78-@-5958
(ucs-set-char #x63AB ?$BYX(B) ; J83-B-5958
(ucs-set-char #x63AC ?$(GZi(B) ; C01-G-5A69
(ucs-set-char #x63AC ?$@5E(B) ; J78-@-3545
(ucs-set-char #x63AC ?$A^d(B) ; GB0-A-5E64
(ucs-set-char #x63AC ?$B5E(B) ; J83-B-3545
(ucs-set-char #x63AD ?$(D@1(B) ; J90-D-4031
(ucs-set-char #x63AD ?$(H5Q(B) ; C02-H-3551
(ucs-set-char #x63AD ?$A^](B) ; GB0-A-5E5D
(ucs-set-char #x63AE ?$(D@2(B) ; J90-D-4032
(ucs-set-char #x63AE ?$(H5^(B) ; C02-H-355E
(ucs-set-char #x63AE ?$A^g(B) ; GB0-A-5E67
(ucs-set-char #x63AF ?$(D@3(B) ; J90-D-4033
(ucs-set-char #x63AF ?$(H5Z(B) ; C02-H-355A
(ucs-set-char #x63B0 ?$(H;w(B) ; C02-H-3B77
(ucs-set-char #x63B0 ?$Aj~(B) ; GB0-A-6A7E
(ucs-set-char #x63B1 ?$(H;v(B) ; C02-H-3B76
(ucs-set-char #x63B2 ?$(I6-(B) ; C03-I-362D
(ucs-set-char #x63B2 ?$@7G(B) ; J78-@-3747
(ucs-set-char #x63B2 ?$B7G(B) ; J83-B-3747
(ucs-set-char #x63B3 ?$AB0(B) ; GB0-A-4230
(ucs-set-char #x63B4 ?$A^b(B) ; GB0-A-5E62
(ucs-set-char #x63B4 ?$BDO(B) ; J83-B-444F
(ucs-set-char #x63B5 ?$@Y^(B) ; J78-@-595E
(ucs-set-char #x63B5 ?$BY^(B) ; J83-B-595E
(ucs-set-char #x63B7 ?$AV@(B) ; GB0-A-5640
(ucs-set-char #x63B8 ?$A5'(B) ; GB0-A-3527
(ucs-set-char #x63BA ?$(I6.(B) ; C03-I-362E
(ucs-set-char #x63BA ?$A2t(B) ; GB0-A-3274
(ucs-set-char #x63BB ?$BA_(B) ; J83-B-415F
(ucs-set-char #x63BC ?$A^h(B) ; GB0-A-5E68
(ucs-set-char #x63BD ?$(D@4(B) ; J90-D-4034
(ucs-set-char #x63BD ?$(H5O(B) ; C02-H-354F
(ucs-set-char #x63BE ?$(H<)(B) ; C02-H-3C29
(ucs-set-char #x63BE ?$@Ya(B) ; J78-@-5961
(ucs-set-char #x63BE ?$A^r(B) ; GB0-A-5E72
(ucs-set-char #x63BE ?$BYa(B) ; J83-B-5961
(ucs-set-char #x63BF ?$(I;q(B) ; C03-I-3B71
(ucs-set-char #x63C0 ?$(CJQ(B) ; KS0-C-4A51
(ucs-set-char #x63C0 ?$(G_A(B) ; C01-G-5F41
(ucs-set-char #x63C0 ?$@Yc(B) ; J78-@-5963
(ucs-set-char #x63C0 ?$BYc(B) ; J83-B-5963
(ucs-set-char #x63C1 ?$(D@5(B) ; J90-D-4035
(ucs-set-char #x63C1 ?$(I;p(B) ; C03-I-3B70
(ucs-set-char #x63C2 ?$(H</(B) ; C02-H-3C2F
(ucs-set-char #x63C3 ?$(H;|(B) ; C02-H-3B7C
(ucs-set-char #x63C3 ?$@B7(B) ; J78-@-4237
(ucs-set-char #x63C3 ?$BB7(B) ; J83-B-4237
(ucs-set-char #x63C4 ?$(Cjq(B) ; KS0-C-6A71
(ucs-set-char #x63C4 ?$(H<,(B) ; C02-H-3C2C
(ucs-set-char #x63C4 ?$@Yi(B) ; J78-@-5969
(ucs-set-char #x63C4 ?$A^m(B) ; GB0-A-5E6D
(ucs-set-char #x63C4 ?$BYi(B) ; J83-B-5969
(ucs-set-char #x63C5 ?$(D@6(B) ; J90-D-4036
(ucs-set-char #x63C5 ?$(HB}(B) ; C02-H-427D
(ucs-set-char #x63C6 ?$(CP&(B) ; KS0-C-5026
(ucs-set-char #x63C6 ?$(G_D(B) ; C01-G-5F44
(ucs-set-char #x63C6 ?$@Yd(B) ; J78-@-5964
(ucs-set-char #x63C6 ?$A^q(B) ; GB0-A-5E71
(ucs-set-char #x63C6 ?$BYd(B) ; J83-B-5964
(ucs-set-char #x63C7 ?$(H<0(B) ; C02-H-3C30
(ucs-set-char #x63C8 ?$(D@7(B) ; J90-D-4037
(ucs-set-char #x63C8 ?$(H<3(B) ; C02-H-3C33
(ucs-set-char #x63C9 ?$(G_C(B) ; C01-G-5F43
(ucs-set-char #x63C9 ?$@Yf(B) ; J78-@-5966
(ucs-set-char #x63C9 ?$AH`(B) ; GB0-A-4860
(ucs-set-char #x63C9 ?$BYf(B) ; J83-B-5966
(ucs-set-char #x63CA ?$(H<!(B) ; C02-H-3C21
(ucs-set-char #x63CB ?$(H<2(B) ; C02-H-3C32
(ucs-set-char #x63CC ?$(H<1(B) ; C02-H-3C31
(ucs-set-char #x63CD ?$(G_E(B) ; C01-G-5F45
(ucs-set-char #x63CD ?$AWa(B) ; GB0-A-5761
(ucs-set-char #x63CE ?$(D@8(B) ; J90-D-4038
(ucs-set-char #x63CE ?$(H;x(B) ; C02-H-3B78
(ucs-set-char #x63CE ?$A^o(B) ; GB0-A-5E6F
(ucs-set-char #x63CF ?$(CYZ(B) ; KS0-C-595A
(ucs-set-char #x63CF ?$(G_@(B) ; C01-G-5F40
(ucs-set-char #x63CF ?$@IA(B) ; J78-@-4941
(ucs-set-char #x63CF ?$ACh(B) ; GB0-A-4368
(ucs-set-char #x63CF ?$BIA(B) ; J83-B-4941
(ucs-set-char #x63D0 ?$(Cp+(B) ; KS0-C-702B
(ucs-set-char #x63D0 ?$(G_H(B) ; C01-G-5F48
(ucs-set-char #x63D0 ?$@Ds(B) ; J78-@-4473
(ucs-set-char #x63D0 ?$ALa(B) ; GB0-A-4C61
(ucs-set-char #x63D0 ?$BDs(B) ; J83-B-4473
(ucs-set-char #x63D1 ?$(D@9(B) ; J90-D-4039
(ucs-set-char #x63D1 ?$(I;s(B) ; C03-I-3B73
(ucs-set-char #x63D2 ?$(G_F(B) ; C01-G-5F46
(ucs-set-char #x63D2 ?$@Yg(B) ; J78-@-5967
(ucs-set-char #x63D2 ?$A2e(B) ; GB0-A-3265
(ucs-set-char #x63D2 ?$BYg(B) ; J83-B-5967
(ucs-set-char #x63D3 ?$(D@:(B) ; J90-D-403A
(ucs-set-char #x63D3 ?$(H<.(B) ; C02-H-3C2E
(ucs-set-char #x63D4 ?$(D@;(B) ; J90-D-403B
(ucs-set-char #x63D4 ?$(J7q(B) ; C04-J-3771
(ucs-set-char #x63D5 ?$(D@<(B) ; J90-D-403C
(ucs-set-char #x63D5 ?$(H<$(B) ; C02-H-3C24
(ucs-set-char #x63D6 ?$(Ckg(B) ; KS0-C-6B67
(ucs-set-char #x63D6 ?$(G_J(B) ; C01-G-5F4A
(ucs-set-char #x63D6 ?$@M,(B) ; J78-@-4D2C
(ucs-set-char #x63D6 ?$AR>(B) ; GB0-A-523E
(ucs-set-char #x63D6 ?$BM,(B) ; J83-B-4D2C
(ucs-set-char #x63D7 ?$(H<5(B) ; C02-H-3C35
(ucs-set-char #x63D8 ?$(H<-(B) ; C02-H-3C2D
(ucs-set-char #x63D9 ?$(H<6(B) ; C02-H-3C36
(ucs-set-char #x63DA ?$(Ce@(B) ; KS0-C-6540
(ucs-set-char #x63DA ?$(G_R(B) ; C01-G-5F52
(ucs-set-char #x63DA ?$@MH(B) ; J78-@-4D48
(ucs-set-char #x63DA ?$BMH(B) ; J83-B-4D48
(ucs-set-char #x63DB ?$(C|5(B) ; KS0-C-7C35
(ucs-set-char #x63DB ?$(G_P(B) ; C01-G-5F50
(ucs-set-char #x63DB ?$@49(B) ; J78-@-3439
(ucs-set-char #x63DB ?$B49(B) ; J83-B-3439
(ucs-set-char #x63DC ?$(D@=(B) ; J90-D-403D
(ucs-set-char #x63DC ?$(H<+(B) ; C02-H-3C2B
(ucs-set-char #x63DD ?$(H<*(B) ; C02-H-3C2A
(ucs-set-char #x63DE ?$(I;g(B) ; C03-I-3B67
(ucs-set-char #x63DE ?$A^n(B) ; GB0-A-5E6E
(ucs-set-char #x63DF ?$(H<((B) ; C02-H-3C28
(ucs-set-char #x63E0 ?$(D@>(B) ; J90-D-403E
(ucs-set-char #x63E0 ?$(H<"(B) ; C02-H-3C22
(ucs-set-char #x63E0 ?$A^k(B) ; GB0-A-5E6B
(ucs-set-char #x63E1 ?$(CdD(B) ; KS0-C-6444
(ucs-set-char #x63E1 ?$(G_I(B) ; C01-G-5F49
(ucs-set-char #x63E1 ?$@0.(B) ; J78-@-302E
(ucs-set-char #x63E1 ?$ANU(B) ; GB0-A-4E55
(ucs-set-char #x63E1 ?$B0.(B) ; J83-B-302E
(ucs-set-char #x63E2 ?$(I;f(B) ; C03-I-3B66
(ucs-set-char #x63E3 ?$(G_G(B) ; C01-G-5F47
(ucs-set-char #x63E3 ?$@Ye(B) ; J78-@-5965
(ucs-set-char #x63E3 ?$A4'(B) ; GB0-A-3427
(ucs-set-char #x63E3 ?$BYe(B) ; J83-B-5965
(ucs-set-char #x63E4 ?$(H/;(B) ; C02-H-2F3B
(ucs-set-char #x63E5 ?$(D@?(B) ; J90-D-403F
(ucs-set-char #x63E5 ?$(H;y(B) ; C02-H-3B79
(ucs-set-char #x63E6 ?$(I;h(B) ; C03-I-3B68
(ucs-set-char #x63E7 ?$(HC=(B) ; C02-H-433D
(ucs-set-char #x63E8 ?$(H;z(B) ; C02-H-3B7A
(ucs-set-char #x63E9 ?$(G_B(B) ; C01-G-5F42
(ucs-set-char #x63E9 ?$@Yb(B) ; J78-@-5962
(ucs-set-char #x63E9 ?$A?+(B) ; GB0-A-3F2B
(ucs-set-char #x63E9 ?$BYb(B) ; J83-B-5962
(ucs-set-char #x63EA ?$(D@@(B) ; J90-D-4040
(ucs-set-char #x63EA ?$(G_O(B) ; C01-G-5F4F
(ucs-set-char #x63EA ?$A>>(B) ; GB0-A-3E3E
(ucs-set-char #x63EB ?$(HC!(B) ; C02-H-4321
(ucs-set-char #x63EC ?$(D@A(B) ; J90-D-4041
(ucs-set-char #x63EC ?$(J7`(B) ; C04-J-3760
(ucs-set-char #x63ED ?$(CL)(B) ; KS0-C-4C29
(ucs-set-char #x63ED ?$(G_K(B) ; C01-G-5F4B
(ucs-set-char #x63ED ?$A=R(B) ; GB0-A-3D52
(ucs-set-char #x63EE ?$(C}F(B) ; KS0-C-7D46
(ucs-set-char #x63EE ?$(G_L(B) ; C01-G-5F4C
(ucs-set-char #x63EE ?$@4x(B) ; J78-@-3478
(ucs-set-char #x63EE ?$B4x(B) ; J83-B-3478
(ucs-set-char #x63EF ?$(H;{(B) ; C02-H-3B7B
(ucs-set-char #x63F0 ?$(H<4(B) ; C02-H-3C34
(ucs-set-char #x63F1 ?$(HB~(B) ; C02-H-427E
(ucs-set-char #x63F2 ?$(D@B(B) ; J90-D-4042
(ucs-set-char #x63F2 ?$(H<%(B) ; C02-H-3C25
(ucs-set-char #x63F2 ?$A^i(B) ; GB0-A-5E69
(ucs-set-char #x63F3 ?$(D@C(B) ; J90-D-4043
(ucs-set-char #x63F3 ?$(H;~(B) ; C02-H-3B7E
(ucs-set-char #x63F4 ?$(Cj5(B) ; KS0-C-6A35
(ucs-set-char #x63F4 ?$(G_N(B) ; C01-G-5F4E
(ucs-set-char #x63F4 ?$@1g(B) ; J78-@-3167
(ucs-set-char #x63F4 ?$AT.(B) ; GB0-A-542E
(ucs-set-char #x63F4 ?$B1g(B) ; J83-B-3167
(ucs-set-char #x63F5 ?$(D@D(B) ; J90-D-4044
(ucs-set-char #x63F5 ?$(H<&(B) ; C02-H-3C26
(ucs-set-char #x63F6 ?$(Ce*(B) ; KS0-C-652A
(ucs-set-char #x63F6 ?$(H<#(B) ; C02-H-3C23
(ucs-set-char #x63F6 ?$@Yh(B) ; J78-@-5968
(ucs-set-char #x63F6 ?$A^^(B) ; GB0-A-5E5E
(ucs-set-char #x63F6 ?$BYh(B) ; J83-B-5968
(ucs-set-char #x63F7 ?$(C_:(B) ; KS0-C-5F3A
(ucs-set-char #x63F7 ?$(I;r(B) ; C03-I-3B72
(ucs-set-char #x63F8 ?$(D@E(B) ; J90-D-4045
(ucs-set-char #x63F8 ?$(I;m(B) ; C03-I-3B6D
(ucs-set-char #x63F8 ?$A^j(B) ; GB0-A-5E6A
(ucs-set-char #x63F9 ?$(D@F(B) ; J90-D-4046
(ucs-set-char #x63F9 ?$(G_S(B) ; C01-G-5F53
(ucs-set-char #x63FA ?$(J7o(B) ; C04-J-376F
(ucs-set-char #x63FA ?$@MI(B) ; J78-@-4D49
(ucs-set-char #x63FA ?$BMI(B) ; J83-B-4D49
(ucs-set-char #x63FD ?$A@?(B) ; GB0-A-403F
(ucs-set-char #x63FE ?$(I;o(B) ; C03-I-3B6F
(ucs-set-char #x63FF ?$A^l(B) ; GB0-A-5E6C
(ucs-set-char #x6400 ?$A2s(B) ; GB0-A-3273
(ucs-set-char #x6401 ?$A8i(B) ; GB0-A-3869
(ucs-set-char #x6402 ?$AB'(B) ; GB0-A-4227
(ucs-set-char #x6405 ?$A=A(B) ; GB0-A-3D41
(ucs-set-char #x6406 ?$(Gd8(B) ; C01-G-6438
(ucs-set-char #x6406 ?$@Yl(B) ; J78-@-596C
(ucs-set-char #x6406 ?$BYl(B) ; J83-B-596C
(ucs-set-char #x6407 ?$(IAI(B) ; C03-I-4149
(ucs-set-char #x6408 ?$(IA2(B) ; C03-I-4132
(ucs-set-char #x6409 ?$(D@G(B) ; J90-D-4047
(ucs-set-char #x6409 ?$(HC$(B) ; C02-H-4324
(ucs-set-char #x640A ?$(D@H(B) ; J90-D-4048
(ucs-set-char #x640A ?$(HC7(B) ; C02-H-4337
(ucs-set-char #x640B ?$(HC<(B) ; C02-H-433C
(ucs-set-char #x640B ?$A^u(B) ; GB0-A-5E75
(ucs-set-char #x640C ?$(HC0(B) ; C02-H-4330
(ucs-set-char #x640C ?$A^x(B) ; GB0-A-5E78
(ucs-set-char #x640D ?$(Ca_(B) ; KS0-C-615F
(ucs-set-char #x640D ?$(Gd4(B) ; C01-G-6434
(ucs-set-char #x640D ?$@B;(B) ; J78-@-423B
(ucs-set-char #x640D ?$BB;(B) ; J83-B-423B
(ucs-set-char #x640E ?$(HCA(B) ; C02-H-4341
(ucs-set-char #x640F ?$(CZQ(B) ; KS0-C-5A51
(ucs-set-char #x640F ?$(Gd1(B) ; C01-G-6431
(ucs-set-char #x640F ?$@Ys(B) ; J78-@-5973
(ucs-set-char #x640F ?$A2+(B) ; GB0-A-322B
(ucs-set-char #x640F ?$BYs(B) ; J83-B-5973
(ucs-set-char #x6410 ?$(D@I(B) ; J90-D-4049
(ucs-set-char #x6410 ?$(HC"(B) ; C02-H-4322
(ucs-set-char #x6410 ?$A4$(B) ; GB0-A-3424
(ucs-set-char #x6411 ?$(IA:(B) ; C03-I-413A
(ucs-set-char #x6412 ?$(D@J(B) ; J90-D-404A
(ucs-set-char #x6412 ?$(HC#(B) ; C02-H-4323
(ucs-set-char #x6413 ?$(Gd*(B) ; C01-G-642A
(ucs-set-char #x6413 ?$@Ym(B) ; J78-@-596D
(ucs-set-char #x6413 ?$A4j(B) ; GB0-A-346A
(ucs-set-char #x6413 ?$BYm(B) ; J83-B-596D
(ucs-set-char #x6414 ?$(Ca8(B) ; KS0-C-6138
(ucs-set-char #x6414 ?$(D@K(B) ; J90-D-404B
(ucs-set-char #x6414 ?$(Gd3(B) ; C01-G-6433
(ucs-set-char #x6414 ?$@A_(B) ; J78-@-415F
(ucs-set-char #x6414 ?$AI&(B) ; GB0-A-4926
(ucs-set-char #x6415 ?$(HC*(B) ; C02-H-432A
(ucs-set-char #x6416 ?$(Cht(B) ; KS0-C-6874
(ucs-set-char #x6416 ?$(Gd6(B) ; C01-G-6436
(ucs-set-char #x6416 ?$@Yj(B) ; J78-@-596A
(ucs-set-char #x6416 ?$BYj(B) ; J83-B-596A
(ucs-set-char #x6417 ?$(CS}(B) ; KS0-C-537D
(ucs-set-char #x6417 ?$(Gd7(B) ; C01-G-6437
(ucs-set-char #x6417 ?$@Yq(B) ; J78-@-5971
(ucs-set-char #x6417 ?$BYq(B) ; J83-B-5971
(ucs-set-char #x6418 ?$(D@L(B) ; J90-D-404C
(ucs-set-char #x6418 ?$(HC+(B) ; C02-H-432B
(ucs-set-char #x6419 ?$(IA8(B) ; C03-I-4138
(ucs-set-char #x641A ?$(HC8(B) ; C02-H-4338
(ucs-set-char #x641B ?$(HC>(B) ; C02-H-433E
(ucs-set-char #x641B ?$A^v(B) ; GB0-A-5E76
(ucs-set-char #x641C ?$(Cb$(B) ; KS0-C-6224
(ucs-set-char #x641C ?$(Gd2(B) ; C01-G-6432
(ucs-set-char #x641C ?$@YS(B) ; J78-@-5953
(ucs-set-char #x641C ?$AKQ(B) ; GB0-A-4B51
(ucs-set-char #x641C ?$BYS(B) ; J83-B-5953
(ucs-set-char #x641D ?$(IA>(B) ; C03-I-413E
(ucs-set-char #x641E ?$(D@M(B) ; J90-D-404D
(ucs-set-char #x641E ?$(Gd,(B) ; C01-G-642C
(ucs-set-char #x641E ?$A8c(B) ; GB0-A-3863
(ucs-set-char #x641F ?$(HC)(B) ; C02-H-4329
(ucs-set-char #x6420 ?$(D@N(B) ; J90-D-404E
(ucs-set-char #x6420 ?$(HC%(B) ; C02-H-4325
(ucs-set-char #x6420 ?$A^w(B) ; GB0-A-5E77
(ucs-set-char #x6421 ?$(HC@(B) ; C02-H-4340
(ucs-set-char #x6421 ?$A^z(B) ; GB0-A-5E7A
(ucs-set-char #x6422 ?$(CrJ(B) ; KS0-C-724A
(ucs-set-char #x6422 ?$(D@O(B) ; J90-D-404F
(ucs-set-char #x6422 ?$(HC.(B) ; C02-H-432E
(ucs-set-char #x6423 ?$(HC/(B) ; C02-H-432F
(ucs-set-char #x6424 ?$(D@P(B) ; J90-D-4050
(ucs-set-char #x6424 ?$(HC&(B) ; C02-H-4326
(ucs-set-char #x6425 ?$(D@Q(B) ; J90-D-4051
(ucs-set-char #x6425 ?$(HC:(B) ; C02-H-433A
(ucs-set-char #x6426 ?$(HC1(B) ; C02-H-4331
(ucs-set-char #x6426 ?$@Yn(B) ; J78-@-596E
(ucs-set-char #x6426 ?$A^y(B) ; GB0-A-5E79
(ucs-set-char #x6426 ?$BYn(B) ; J83-B-596E
(ucs-set-char #x6427 ?$(HC;(B) ; C02-H-433B
(ucs-set-char #x6428 ?$(HC3(B) ; C02-H-4333
(ucs-set-char #x6428 ?$@Yr(B) ; J78-@-5972
(ucs-set-char #x6428 ?$BYr(B) ; J83-B-5972
(ucs-set-char #x6429 ?$(D@R(B) ; J90-D-4052
(ucs-set-char #x6429 ?$(IA=(B) ; C03-I-413D
(ucs-set-char #x642A ?$(D@S(B) ; J90-D-4053
(ucs-set-char #x642A ?$(Gd-(B) ; C01-G-642D
(ucs-set-char #x642A ?$ALB(B) ; GB0-A-4C42
(ucs-set-char #x642B ?$(HJ@(B) ; C02-H-4A40
(ucs-set-char #x642C ?$(CZf(B) ; KS0-C-5A66
(ucs-set-char #x642C ?$(Gd0(B) ; C01-G-6430
(ucs-set-char #x642C ?$@HB(B) ; J78-@-4842
(ucs-set-char #x642C ?$A0a(B) ; GB0-A-3061
(ucs-set-char #x642C ?$BHB(B) ; J83-B-4842
(ucs-set-char #x642D ?$(Cw3(B) ; KS0-C-7733
(ucs-set-char #x642D ?$(Gd.(B) ; C01-G-642E
(ucs-set-char #x642D ?$@Ek(B) ; J78-@-456B
(ucs-set-char #x642D ?$A4n(B) ; GB0-A-346E
(ucs-set-char #x642D ?$BEk(B) ; J83-B-456B
(ucs-set-char #x642E ?$(HC?(B) ; C02-H-433F
(ucs-set-char #x642F ?$(D@T(B) ; J90-D-4054
(ucs-set-char #x642F ?$(HC6(B) ; C02-H-4336
(ucs-set-char #x6430 ?$(D@U(B) ; J90-D-4055
(ucs-set-char #x6430 ?$(HC2(B) ; C02-H-4332
(ucs-set-char #x6431 ?$(IA6(B) ; C03-I-4136
(ucs-set-char #x6432 ?$(IA3(B) ; C03-I-4133
(ucs-set-char #x6433 ?$(HC'(B) ; C02-H-4327
(ucs-set-char #x6434 ?$(Ghz(B) ; C01-G-687A
(ucs-set-char #x6434 ?$@Yk(B) ; J78-@-596B
(ucs-set-char #x6434 ?$Ae:(B) ; GB0-A-653A
(ucs-set-char #x6434 ?$BYk(B) ; J83-B-596B
(ucs-set-char #x6435 ?$(D@V(B) ; J90-D-4056
(ucs-set-char #x6435 ?$(HC5(B) ; C02-H-4335
(ucs-set-char #x6436 ?$(Gd5(B) ; C01-G-6435
(ucs-set-char #x6436 ?$@Yo(B) ; J78-@-596F
(ucs-set-char #x6436 ?$BYo(B) ; J83-B-596F
(ucs-set-char #x6437 ?$(HC-(B) ; C02-H-432D
(ucs-set-char #x6438 ?$(IA4(B) ; C03-I-4134
(ucs-set-char #x6439 ?$(HC,(B) ; C02-H-432C
(ucs-set-char #x643A ?$(C}M(B) ; KS0-C-7D4D
(ucs-set-char #x643A ?$(IAH(B) ; C03-I-4148
(ucs-set-char #x643A ?$@7H(B) ; J78-@-3748
(ucs-set-char #x643A ?$AP/(B) ; GB0-A-502F
(ucs-set-char #x643A ?$B7H(B) ; J83-B-3748
(ucs-set-char #x643B ?$(IG%(B) ; C03-I-4725
(ucs-set-char #x643C ?$(IAB(B) ; C03-I-4142
(ucs-set-char #x643D ?$(D@W(B) ; J90-D-4057
(ucs-set-char #x643D ?$(Gd/(B) ; C01-G-642F
(ucs-set-char #x643D ?$A2k(B) ; GB0-A-326B
(ucs-set-char #x643E ?$(Cs6(B) ; KS0-C-7336
(ucs-set-char #x643E ?$(Gd+(B) ; C01-G-642B
(ucs-set-char #x643E ?$@:q(B) ; J78-@-3A71
(ucs-set-char #x643E ?$B:q(B) ; J83-B-3A71
(ucs-set-char #x643F ?$(D@X(B) ; J90-D-4058
(ucs-set-char #x643F ?$(HJU(B) ; C02-H-4A55
(ucs-set-char #x643F ?$Ak!(B) ; GB0-A-6B21
(ucs-set-char #x6440 ?$(HC9(B) ; C02-H-4339
(ucs-set-char #x6441 ?$(HC4(B) ; C02-H-4334
(ucs-set-char #x6441 ?$A^t(B) ; GB0-A-5E74
(ucs-set-char #x6442 ?$@@](B) ; J78-@-405D
(ucs-set-char #x6442 ?$B@](B) ; J83-B-405D
(ucs-set-char #x6443 ?$(HC((B) ; C02-H-4328
(ucs-set-char #x6444 ?$AIc(B) ; GB0-A-4963
(ucs-set-char #x6445 ?$A^s(B) ; GB0-A-5E73
(ucs-set-char #x6446 ?$(IAD(B) ; C03-I-4144
(ucs-set-char #x6446 ?$A0Z(B) ; GB0-A-305A
(ucs-set-char #x6447 ?$(IAE(B) ; C03-I-4145
(ucs-set-char #x6447 ?$AR!(B) ; GB0-A-5221
(ucs-set-char #x6448 ?$A1w(B) ; GB0-A-3177
(ucs-set-char #x644A ?$AL/(B) ; GB0-A-4C2F
(ucs-set-char #x644B ?$(D@Y(B) ; J90-D-4059
(ucs-set-char #x644B ?$(HJP(B) ; C02-H-4A50
(ucs-set-char #x644C ?$(IFx(B) ; C03-I-4678
(ucs-set-char #x644D ?$(HJA(B) ; C02-H-4A41
(ucs-set-char #x644E ?$(HJL(B) ; C02-H-4A4C
(ucs-set-char #x644E ?$@Yw(B) ; J78-@-5977
(ucs-set-char #x644E ?$BYw(B) ; J83-B-5977
(ucs-set-char #x644F ?$(D@Z(B) ; J90-D-405A
(ucs-set-char #x644F ?$(IG((B) ; C03-I-4728
(ucs-set-char #x6450 ?$(HJS(B) ; C02-H-4A53
(ucs-set-char #x6451 ?$(D@[(B) ; J90-D-405B
(ucs-set-char #x6451 ?$(Ghx(B) ; C01-G-6878
(ucs-set-char #x6451 ?$@DO(B) ; J78-@-444F
(ucs-set-char #x6452 ?$(D@\(B) ; J90-D-405C
(ucs-set-char #x6452 ?$(G_Q(B) ; C01-G-5F51
(ucs-set-char #x6452 ?$A^p(B) ; GB0-A-5E70
(ucs-set-char #x6453 ?$(D@](B) ; J90-D-405D
(ucs-set-char #x6453 ?$(HJQ(B) ; C02-H-4A51
(ucs-set-char #x6454 ?$(D@^(B) ; J90-D-405E
(ucs-set-char #x6454 ?$(Ghs(B) ; C01-G-6873
(ucs-set-char #x6454 ?$AK$(B) ; GB0-A-4B24
(ucs-set-char #x6455 ?$(IF~(B) ; C03-I-467E
(ucs-set-char #x6456 ?$(IG$(B) ; C03-I-4724
(ucs-set-char #x6457 ?$(IFz(B) ; C03-I-467A
(ucs-set-char #x6458 ?$(CnW(B) ; KS0-C-6E57
(ucs-set-char #x6458 ?$(Ghr(B) ; C01-G-6872
(ucs-set-char #x6458 ?$@E&(B) ; J78-@-4526
(ucs-set-char #x6458 ?$AU*(B) ; GB0-A-552A
(ucs-set-char #x6458 ?$BE&(B) ; J83-B-4526
(ucs-set-char #x6459 ?$(HJX(B) ; C02-H-4A58
(ucs-set-char #x645A ?$(D@_(B) ; J90-D-405F
(ucs-set-char #x645A ?$(JC](B) ; C04-J-435D
(ucs-set-char #x645B ?$(D@`(B) ; J90-D-4060
(ucs-set-char #x645B ?$(HJB(B) ; C02-H-4A42
(ucs-set-char #x645C ?$(D@a(B) ; J90-D-4061
(ucs-set-char #x645C ?$(HJO(B) ; C02-H-4A4F
(ucs-set-char #x645D ?$(D@b(B) ; J90-D-4062
(ucs-set-char #x645D ?$(HJC(B) ; C02-H-4A43
(ucs-set-char #x645E ?$(HJN(B) ; C02-H-4A4E
(ucs-set-char #x645E ?$A^{(B) ; GB0-A-5E7B
(ucs-set-char #x645F ?$(D@c(B) ; J90-D-4063
(ucs-set-char #x645F ?$(Ghv(B) ; C01-G-6876
(ucs-set-char #x6460 ?$(CuD(B) ; KS0-C-7544
(ucs-set-char #x6460 ?$(D@d(B) ; J90-D-4064
(ucs-set-char #x6460 ?$(HJR(B) ; C02-H-4A52
(ucs-set-char #x6461 ?$(D@e(B) ; J90-D-4065
(ucs-set-char #x6461 ?$(H<'(B) ; C02-H-3C27
(ucs-set-char #x6462 ?$(IG!(B) ; C03-I-4721
(ucs-set-char #x6463 ?$(D@f(B) ; J90-D-4066
(ucs-set-char #x6463 ?$(JC^(B) ; C04-J-435E
(ucs-set-char #x6464 ?$(IG*(B) ; C03-I-472A
(ucs-set-char #x6465 ?$(HJY(B) ; C02-H-4A59
(ucs-set-char #x6466 ?$(HJJ(B) ; C02-H-4A4A
(ucs-set-char #x6467 ?$(Ghy(B) ; C01-G-6879
(ucs-set-char #x6467 ?$@Yt(B) ; J78-@-5974
(ucs-set-char #x6467 ?$A4](B) ; GB0-A-345D
(ucs-set-char #x6467 ?$BYt(B) ; J83-B-5974
(ucs-set-char #x6468 ?$(HPa(B) ; C02-H-5061
(ucs-set-char #x6469 ?$(CX$(B) ; KS0-C-5824
(ucs-set-char #x6469 ?$(Glw(B) ; C01-G-6C77
(ucs-set-char #x6469 ?$(M#-(B) ; C07-M-232D
(ucs-set-char #x6469 ?$@K`(B) ; J78-@-4B60
(ucs-set-char #x6469 ?$AD&(B) ; GB0-A-4426
(ucs-set-char #x6469 ?$BK`(B) ; J83-B-4B60
(ucs-set-char #x646A ?$(IG#(B) ; C03-I-4723
(ucs-set-char #x646B ?$(HJW(B) ; C02-H-4A57
(ucs-set-char #x646C ?$(HJV(B) ; C02-H-4A56
(ucs-set-char #x646D ?$(D@g(B) ; J90-D-4067
(ucs-set-char #x646D ?$(Gh{(B) ; C01-G-687B
(ucs-set-char #x646D ?$A^}(B) ; GB0-A-5E7D
(ucs-set-char #x646E ?$(HPT(B) ; C02-H-5054
(ucs-set-char #x646F ?$(Cr'(B) ; KS0-C-7227
(ucs-set-char #x646F ?$(Glx(B) ; C01-G-6C78
(ucs-set-char #x646F ?$@Yu(B) ; J78-@-5975
(ucs-set-char #x646F ?$BYu(B) ; J83-B-5975
(ucs-set-char #x6470 ?$(HPU(B) ; C02-H-5055
(ucs-set-char #x6471 ?$(IG"(B) ; C03-I-4722
(ucs-set-char #x6472 ?$(HJF(B) ; C02-H-4A46
(ucs-set-char #x6473 ?$(D@h(B) ; J90-D-4068
(ucs-set-char #x6473 ?$(HJG(B) ; C02-H-4A47
(ucs-set-char #x6474 ?$(D@i(B) ; J90-D-4069
(ucs-set-char #x6474 ?$(HJD(B) ; C02-H-4A44
(ucs-set-char #x6475 ?$(HJI(B) ; C02-H-4A49
(ucs-set-char #x6476 ?$(HJE(B) ; C02-H-4A45
(ucs-set-char #x6476 ?$@Yv(B) ; J78-@-5976
(ucs-set-char #x6476 ?$BYv(B) ; J83-B-5976
(ucs-set-char #x6477 ?$(HJZ(B) ; C02-H-4A5A
(ucs-set-char #x6478 ?$(CY8(B) ; KS0-C-5938
(ucs-set-char #x6478 ?$(Ghu(B) ; C01-G-6875
(ucs-set-char #x6478 ?$@LN(B) ; J78-@-4C4E
(ucs-set-char #x6478 ?$AC~(B) ; GB0-A-437E
(ucs-set-char #x6478 ?$BLN(B) ; J83-B-4C4E
(ucs-set-char #x6479 ?$(CY9(B) ; KS0-C-5939
(ucs-set-char #x6479 ?$(Gly(B) ; C01-G-6C79
(ucs-set-char #x6479 ?$AD!(B) ; GB0-A-4421
(ucs-set-char #x647A ?$(CoI(B) ; KS0-C-6F49
(ucs-set-char #x647A ?$(Ghw(B) ; C01-G-6877
(ucs-set-char #x647A ?$@@"(B) ; J78-@-4022
(ucs-set-char #x647A ?$A_!(B) ; GB0-A-5F21
(ucs-set-char #x647A ?$B@"(B) ; J83-B-4022
(ucs-set-char #x647B ?$(D@j(B) ; J90-D-406A
(ucs-set-char #x647B ?$(Gh|(B) ; C01-G-687C
(ucs-set-char #x647C ?$(IF{(B) ; C03-I-467B
(ucs-set-char #x647D ?$(D@k(B) ; J90-D-406B
(ucs-set-char #x647D ?$(HJH(B) ; C02-H-4A48
(ucs-set-char #x647E ?$(IG)(B) ; C03-I-4729
(ucs-set-char #x647F ?$(HJT(B) ; C02-H-4A54
(ucs-set-char #x6480 ?$(IL-(B) ; C03-I-4C2D
(ucs-set-char #x6481 ?$(IG&(B) ; C03-I-4726
(ucs-set-char #x6482 ?$(HJM(B) ; C02-H-4A4D
(ucs-set-char #x6482 ?$AAL(B) ; GB0-A-414C
(ucs-set-char #x6483 ?$(IL5(B) ; C03-I-4C35
(ucs-set-char #x6483 ?$@7b(B) ; J78-@-3762
(ucs-set-char #x6483 ?$B7b(B) ; J83-B-3762
(ucs-set-char #x6484 ?$A^|(B) ; GB0-A-5E7C
(ucs-set-char #x6485 ?$(D@l(B) ; J90-D-406C
(ucs-set-char #x6485 ?$(HPX(B) ; C02-H-5058
(ucs-set-char #x6485 ?$A>o(B) ; GB0-A-3E6F
(ucs-set-char #x6486 ?$(IL8(B) ; C03-I-4C38
(ucs-set-char #x6487 ?$(D@m(B) ; J90-D-406D
(ucs-set-char #x6487 ?$(Ghq(B) ; C01-G-6871
(ucs-set-char #x6487 ?$AF2(B) ; GB0-A-4632
(ucs-set-char #x6488 ?$(CVN(B) ; KS0-C-564E
(ucs-set-char #x6488 ?$(Gl|(B) ; C01-G-6C7C
(ucs-set-char #x6488 ?$@Y}(B) ; J78-@-597D
(ucs-set-char #x6488 ?$BY}(B) ; J83-B-597D
(ucs-set-char #x6489 ?$(HW5(B) ; C02-H-5735
(ucs-set-char #x648A ?$(HP](B) ; C02-H-505D
(ucs-set-char #x648B ?$(HP\(B) ; C02-H-505C
(ucs-set-char #x648C ?$(HP^(B) ; C02-H-505E
(ucs-set-char #x648D ?$(IL0(B) ; C03-I-4C30
(ucs-set-char #x648E ?$(IL/(B) ; C03-I-4C2F
(ucs-set-char #x648F ?$(D@n(B) ; J90-D-406E
(ucs-set-char #x648F ?$(HP[(B) ; C02-H-505B
(ucs-set-char #x6490 ?$(D@o(B) ; J90-D-406F
(ucs-set-char #x6490 ?$(Gl}(B) ; C01-G-6C7D
(ucs-set-char #x6491 ?$(CwK(B) ; KS0-C-774B
(ucs-set-char #x6491 ?$(D@p(B) ; J90-D-4070
(ucs-set-char #x6491 ?$(IL;(B) ; C03-I-4C3B
(ucs-set-char #x6491 ?$A3E(B) ; GB0-A-3345
(ucs-set-char #x6492 ?$(C_.(B) ; KS0-C-5F2E
(ucs-set-char #x6492 ?$(Gm%(B) ; C01-G-6D25
(ucs-set-char #x6492 ?$@;5(B) ; J78-@-3B35
(ucs-set-char #x6492 ?$AHv(B) ; GB0-A-4876
(ucs-set-char #x6492 ?$B;5(B) ; J83-B-3B35
(ucs-set-char #x6493 ?$(Chu(B) ; KS0-C-6875
(ucs-set-char #x6493 ?$(Gm"(B) ; C01-G-6D22
(ucs-set-char #x6493 ?$@Yz(B) ; J78-@-597A
(ucs-set-char #x6493 ?$BYz(B) ; J83-B-597A
(ucs-set-char #x6494 ?$(IL1(B) ; C03-I-4C31
(ucs-set-char #x6495 ?$(Gm#(B) ; C01-G-6D23
(ucs-set-char #x6495 ?$@Yy(B) ; J78-@-5979
(ucs-set-char #x6495 ?$AK:(B) ; GB0-A-4B3A
(ucs-set-char #x6495 ?$BYy(B) ; J83-B-5979
(ucs-set-char #x6496 ?$(HPV(B) ; C02-H-5056
(ucs-set-char #x6496 ?$A^~(B) ; GB0-A-5E7E
(ucs-set-char #x6497 ?$(HPY(B) ; C02-H-5059
(ucs-set-char #x6498 ?$(D@q(B) ; J90-D-4071
(ucs-set-char #x6498 ?$(HPc(B) ; C02-H-5063
(ucs-set-char #x6499 ?$(D@r(B) ; J90-D-4072
(ucs-set-char #x6499 ?$(Gm+(B) ; C01-G-6D2B
(ucs-set-char #x6499 ?$A_$(B) ; GB0-A-5F24
(ucs-set-char #x649A ?$(CR5(B) ; KS0-C-5235
(ucs-set-char #x649A ?$(Gm)(B) ; C01-G-6D29
(ucs-set-char #x649A ?$@G2(B) ; J78-@-4732
(ucs-set-char #x649A ?$BG2(B) ; J83-B-4732
(ucs-set-char #x649B ?$(D@s(B) ; J90-D-4073
(ucs-set-char #x649B ?$(IL.(B) ; C03-I-4C2E
(ucs-set-char #x649C ?$(HPZ(B) ; C02-H-505A
(ucs-set-char #x649D ?$(D@t(B) ; J90-D-4074
(ucs-set-char #x649D ?$(H;}(B) ; C02-H-3B7D
(ucs-set-char #x649D ?$(JJ'(B) ; C04-J-4A27
(ucs-set-char #x649E ?$(CSU(B) ; KS0-C-5355
(ucs-set-char #x649E ?$(Glz(B) ; C01-G-6C7A
(ucs-set-char #x649E ?$@F5(B) ; J78-@-4635
(ucs-set-char #x649E ?$AW2(B) ; GB0-A-5732
(ucs-set-char #x649E ?$BF5(B) ; J83-B-4635
(ucs-set-char #x649F ?$(D@u(B) ; J90-D-4075
(ucs-set-char #x649F ?$(HP`(B) ; C02-H-5060
(ucs-set-char #x64A0 ?$(HPW(B) ; C02-H-5057
(ucs-set-char #x64A1 ?$(D@v(B) ; J90-D-4076
(ucs-set-char #x64A1 ?$(IL>(B) ; C03-I-4C3E
(ucs-set-char #x64A2 ?$(Gm,(B) ; C01-G-6D2C
(ucs-set-char #x64A3 ?$(D@w(B) ; J90-D-4077
(ucs-set-char #x64A3 ?$(HP_(B) ; C02-H-505F
(ucs-set-char #x64A4 ?$(CtL(B) ; KS0-C-744C
(ucs-set-char #x64A4 ?$(Ght(B) ; C01-G-6874
(ucs-set-char #x64A4 ?$@E1(B) ; J78-@-4531
(ucs-set-char #x64A4 ?$A37(B) ; GB0-A-3337
(ucs-set-char #x64A4 ?$BE1(B) ; J83-B-4531
(ucs-set-char #x64A5 ?$(CZ|(B) ; KS0-C-5A7C
(ucs-set-char #x64A5 ?$(Gm!(B) ; C01-G-6D21
(ucs-set-char #x64A5 ?$@Y{(B) ; J78-@-597B
(ucs-set-char #x64A5 ?$BY{(B) ; J83-B-597B
(ucs-set-char #x64A6 ?$(D@x(B) ; J90-D-4078
(ucs-set-char #x64A6 ?$(HJK(B) ; C02-H-4A4B
(ucs-set-char #x64A7 ?$(IL?(B) ; C03-I-4C3F
(ucs-set-char #x64A8 ?$(D@y(B) ; J90-D-4079
(ucs-set-char #x64A8 ?$(IL4(B) ; C03-I-4C34
(ucs-set-char #x64A9 ?$(Gm$(B) ; C01-G-6D24
(ucs-set-char #x64A9 ?$@Y|(B) ; J78-@-597C
(ucs-set-char #x64A9 ?$AAC(B) ; GB0-A-4143
(ucs-set-char #x64A9 ?$BY|(B) ; J83-B-597C
(ucs-set-char #x64AA ?$(IL=(B) ; C03-I-4C3D
(ucs-set-char #x64AB ?$(CYh(B) ; KS0-C-5968
(ucs-set-char #x64AB ?$(Gm((B) ; C01-G-6D28
(ucs-set-char #x64AB ?$@Io(B) ; J78-@-496F
(ucs-set-char #x64AB ?$BIo(B) ; J83-B-496F
(ucs-set-char #x64AC ?$(D@z(B) ; J90-D-407A
(ucs-set-char #x64AC ?$(Gm*(B) ; C01-G-6D2A
(ucs-set-char #x64AC ?$AGK(B) ; GB0-A-474B
(ucs-set-char #x64AD ?$(Cwk(B) ; KS0-C-776B
(ucs-set-char #x64AD ?$(Gm'(B) ; C01-G-6D27
(ucs-set-char #x64AD ?$@GE(B) ; J78-@-4745
(ucs-set-char #x64AD ?$A2%(B) ; GB0-A-3225
(ucs-set-char #x64AD ?$BGE(B) ; J83-B-4745
(ucs-set-char #x64AE ?$(CuI(B) ; KS0-C-7549
(ucs-set-char #x64AE ?$(Gm&(B) ; C01-G-6D26
(ucs-set-char #x64AE ?$@;#(B) ; J78-@-3B23
(ucs-set-char #x64AE ?$A4i(B) ; GB0-A-3469
(ucs-set-char #x64AE ?$B;#(B) ; J83-B-3B23
(ucs-set-char #x64AF ?$(IL:(B) ; C03-I-4C3A
(ucs-set-char #x64B0 ?$(Cs<(B) ; KS0-C-733C
(ucs-set-char #x64B0 ?$(Gl~(B) ; C01-G-6C7E
(ucs-set-char #x64B0 ?$@@q(B) ; J78-@-4071
(ucs-set-char #x64B0 ?$AW+(B) ; GB0-A-572B
(ucs-set-char #x64B0 ?$B@q(B) ; J83-B-4071
(ucs-set-char #x64B1 ?$(HPb(B) ; C02-H-5062
(ucs-set-char #x64B2 ?$(CZR(B) ; KS0-C-5A52
(ucs-set-char #x64B2 ?$(Gl{(B) ; C01-G-6C7B
(ucs-set-char #x64B2 ?$@KP(B) ; J78-@-4B50
(ucs-set-char #x64B2 ?$BKP(B) ; J83-B-4B50
(ucs-set-char #x64B3 ?$(D@{(B) ; J90-D-407B
(ucs-set-char #x64B3 ?$(Gm-(B) ; C01-G-6D2D
(ucs-set-char #x64B4 ?$(IL9(B) ; C03-I-4C39
(ucs-set-char #x64B5 ?$ADl(B) ; GB0-A-446C
(ucs-set-char #x64B7 ?$A_"(B) ; GB0-A-5F22
(ucs-set-char #x64B8 ?$A_#(B) ; GB0-A-5F23
(ucs-set-char #x64B9 ?$(IL7(B) ; C03-I-4C37
(ucs-set-char #x64B9 ?$@Yx(B) ; J78-@-5978
(ucs-set-char #x64B9 ?$B3I(B) ; J83-B-3349
(ucs-set-char #x64BA ?$A_%(B) ; GB0-A-5F25
(ucs-set-char #x64BB ?$(CS5(B) ; KS0-C-5335
(ucs-set-char #x64BB ?$(Gpa(B) ; C01-G-7061
(ucs-set-char #x64BB ?$@Z%(B) ; J78-@-5A25
(ucs-set-char #x64BB ?$BZ%(B) ; J83-B-5A25
(ucs-set-char #x64BC ?$(Gpb(B) ; C01-G-7062
(ucs-set-char #x64BC ?$@Y~(B) ; J78-@-597E
(ucs-set-char #x64BC ?$A:3(B) ; GB0-A-3A33
(ucs-set-char #x64BC ?$BY~(B) ; J83-B-597E
(ucs-set-char #x64BD ?$(D@|(B) ; J90-D-407C
(ucs-set-char #x64BD ?$(HW4(B) ; C02-H-5734
(ucs-set-char #x64BE ?$(D@}(B) ; J90-D-407D
(ucs-set-char #x64BE ?$(Gpk(B) ; C01-G-706B
(ucs-set-char #x64BF ?$(D@~(B) ; J90-D-407E
(ucs-set-char #x64BF ?$(Gph(B) ; C01-G-7068
(ucs-set-char #x64C0 ?$(IPp(B) ; C03-I-5070
(ucs-set-char #x64C0 ?$A_&(B) ; GB0-A-5F26
(ucs-set-char #x64C1 ?$(Ch6(B) ; KS0-C-6836
(ucs-set-char #x64C1 ?$(Gp_(B) ; C01-G-705F
(ucs-set-char #x64C1 ?$@MJ(B) ; J78-@-4D4A
(ucs-set-char #x64C1 ?$BMJ(B) ; J83-B-4D4A
(ucs-set-char #x64C2 ?$(Gpf(B) ; C01-G-7066
(ucs-set-char #x64C2 ?$@Z'(B) ; J78-@-5A27
(ucs-set-char #x64C2 ?$A@^(B) ; GB0-A-405E
(ucs-set-char #x64C2 ?$BZ'(B) ; J83-B-5A27
(ucs-set-char #x64C3 ?$(HW6(B) ; C02-H-5736
(ucs-set-char #x64C4 ?$(CVO(B) ; KS0-C-564F
(ucs-set-char #x64C4 ?$(DA!(B) ; J90-D-4121
(ucs-set-char #x64C4 ?$(Gpd(B) ; C01-G-7064
(ucs-set-char #x64C5 ?$(Ct:(B) ; KS0-C-743A
(ucs-set-char #x64C5 ?$(Gp^(B) ; C01-G-705E
(ucs-set-char #x64C5 ?$@Z#(B) ; J78-@-5A23
(ucs-set-char #x64C5 ?$AIC(B) ; GB0-A-4943
(ucs-set-char #x64C5 ?$BZ#(B) ; J83-B-5A23
(ucs-set-char #x64C6 ?$(IL2(B) ; C03-I-4C32
(ucs-set-char #x64C7 ?$(CwI(B) ; KS0-C-7749
(ucs-set-char #x64C7 ?$(Gpe(B) ; C01-G-7065
(ucs-set-char #x64C7 ?$@Z$(B) ; J78-@-5A24
(ucs-set-char #x64C7 ?$BZ$(B) ; J83-B-5A24
(ucs-set-char #x64C8 ?$(IPw(B) ; C03-I-5077
(ucs-set-char #x64C9 ?$(DA"(B) ; J90-D-4122
(ucs-set-char #x64C9 ?$(HW3(B) ; C02-H-5733
(ucs-set-char #x64CA ?$(CL*(B) ; KS0-C-4C2A
(ucs-set-char #x64CA ?$(DA#(B) ; J90-D-4123
(ucs-set-char #x64CA ?$(Gsd(B) ; C01-G-7364
(ucs-set-char #x64CB ?$(DA$(B) ; J90-D-4124
(ucs-set-char #x64CB ?$(Gp`(B) ; C01-G-7060
(ucs-set-char #x64CC ?$(DA%(B) ; J90-D-4125
(ucs-set-char #x64CC ?$(KT^(B) ; C05-K-545E
(ucs-set-char #x64CD ?$(CpC(B) ; KS0-C-7043
(ucs-set-char #x64CD ?$(Gpg(B) ; C01-G-7067
(ucs-set-char #x64CD ?$@A`(B) ; J78-@-4160
(ucs-set-char #x64CD ?$A2Y(B) ; GB0-A-3259
(ucs-set-char #x64CD ?$BA`(B) ; J83-B-4160
(ucs-set-char #x64CE ?$(CLV(B) ; KS0-C-4C56
(ucs-set-char #x64CE ?$(DA&(B) ; J90-D-4126
(ucs-set-char #x64CE ?$(Gsc(B) ; C01-G-7363
(ucs-set-char #x64CE ?$AGf(B) ; GB0-A-4766
(ucs-set-char #x64CF ?$(HW2(B) ; C02-H-5732
(ucs-set-char #x64D0 ?$(DA'(B) ; J90-D-4127
(ucs-set-char #x64D0 ?$(HW1(B) ; C02-H-5731
(ucs-set-char #x64D0 ?$A_'(B) ; GB0-A-5F27
(ucs-set-char #x64D1 ?$(DA((B) ; J90-D-4128
(ucs-set-char #x64D1 ?$(IPv(B) ; C03-I-5076
(ucs-set-char #x64D2 ?$(CPS(B) ; KS0-C-5053
(ucs-set-char #x64D2 ?$(Gpi(B) ; C01-G-7069
(ucs-set-char #x64D2 ?$@Z"(B) ; J78-@-5A22
(ucs-set-char #x64D2 ?$AG\(B) ; GB0-A-475C
(ucs-set-char #x64D2 ?$BZ"(B) ; J83-B-5A22
(ucs-set-char #x64D3 ?$(IPo(B) ; C03-I-506F
(ucs-set-char #x64D4 ?$(CS=(B) ; KS0-C-533D
(ucs-set-char #x64D4 ?$(Gpj(B) ; C01-G-706A
(ucs-set-char #x64D4 ?$@Y?(B) ; J78-@-593F
(ucs-set-char #x64D4 ?$BY?(B) ; J83-B-593F
(ucs-set-char #x64D5 ?$(DA)(B) ; J90-D-4129
(ucs-set-char #x64D5 ?$(IPy(B) ; C03-I-5079
(ucs-set-char #x64D6 ?$(HW0(B) ; C02-H-5730
(ucs-set-char #x64D7 ?$(DA*(B) ; J90-D-412A
(ucs-set-char #x64D7 ?$(HW/(B) ; C02-H-572F
(ucs-set-char #x64D7 ?$A_((B) ; GB0-A-5F28
(ucs-set-char #x64D8 ?$(C[{(B) ; KS0-C-5B7B
(ucs-set-char #x64D8 ?$(Gse(B) ; C01-G-7365
(ucs-set-char #x64D8 ?$@Z&(B) ; J78-@-5A26
(ucs-set-char #x64D8 ?$Ak"(B) ; GB0-A-6B22
(ucs-set-char #x64D8 ?$BZ&(B) ; J83-B-5A26
(ucs-set-char #x64D9 ?$(HW9(B) ; C02-H-5739
(ucs-set-char #x64DA ?$(CK`(B) ; KS0-C-4B60
(ucs-set-char #x64DA ?$(Gpc(B) ; C01-G-7063
(ucs-set-char #x64DA ?$@Z!(B) ; J78-@-5A21
(ucs-set-char #x64DA ?$BZ!(B) ; J83-B-5A21
(ucs-set-char #x64DB ?$(HW7(B) ; C02-H-5737
(ucs-set-char #x64DC ?$(IPu(B) ; C03-I-5075
(ucs-set-char #x64DE ?$AKS(B) ; GB0-A-4B53
(ucs-set-char #x64DF ?$(ITd(B) ; C03-I-5464
(ucs-set-char #x64E0 ?$(Gsf(B) ; C01-G-7366
(ucs-set-char #x64E0 ?$@Z+(B) ; J78-@-5A2B
(ucs-set-char #x64E0 ?$BZ+(B) ; J83-B-5A2B
(ucs-set-char #x64E1 ?$(CSd(B) ; KS0-C-5364
(ucs-set-char #x64E1 ?$(ITg(B) ; C03-I-5467
(ucs-set-char #x64E1 ?$@Z,(B) ; J78-@-5A2C
(ucs-set-char #x64E1 ?$BZ,(B) ; J83-B-5A2C
(ucs-set-char #x64E2 ?$(Cvw(B) ; KS0-C-7677
(ucs-set-char #x64E2 ?$(Gsk(B) ; C01-G-736B
(ucs-set-char #x64E2 ?$@E'(B) ; J78-@-4527
(ucs-set-char #x64E2 ?$A_*(B) ; GB0-A-5F2A
(ucs-set-char #x64E2 ?$BE'(B) ; J83-B-4527
(ucs-set-char #x64E3 ?$(H\u(B) ; C02-H-5C75
(ucs-set-char #x64E3 ?$@Z.(B) ; J78-@-5A2E
(ucs-set-char #x64E3 ?$BZ.(B) ; J83-B-5A2E
(ucs-set-char #x64E4 ?$(DA+(B) ; J90-D-412B
(ucs-set-char #x64E4 ?$(H\w(B) ; C02-H-5C77
(ucs-set-char #x64E4 ?$A_)(B) ; GB0-A-5F29
(ucs-set-char #x64E5 ?$(CU:(B) ; KS0-C-553A
(ucs-set-char #x64E5 ?$(DA,(B) ; J90-D-412C
(ucs-set-char #x64E5 ?$(IWk(B) ; C03-I-576B
(ucs-set-char #x64E6 ?$(CsM(B) ; KS0-C-734D
(ucs-set-char #x64E6 ?$(Gsh(B) ; C01-G-7368
(ucs-set-char #x64E6 ?$@;$(B) ; J78-@-3B24
(ucs-set-char #x64E6 ?$A2A(B) ; GB0-A-3241
(ucs-set-char #x64E6 ?$B;$(B) ; J83-B-3B24
(ucs-set-char #x64E7 ?$(CKa(B) ; KS0-C-4B61
(ucs-set-char #x64E7 ?$(IWm(B) ; C03-I-576D
(ucs-set-char #x64E7 ?$@Z)(B) ; J78-@-5A29
(ucs-set-char #x64E7 ?$BZ)(B) ; J83-B-5A29
(ucs-set-char #x64E8 ?$(H\x(B) ; C02-H-5C78
(ucs-set-char #x64E9 ?$(DA-(B) ; J90-D-412D
(ucs-set-char #x64E9 ?$(H\t(B) ; C02-H-5C74
(ucs-set-char #x64EA ?$(DA.(B) ; J90-D-412E
(ucs-set-char #x64EA ?$(IWl(B) ; C03-I-576C
(ucs-set-char #x64EB ?$(H\v(B) ; C02-H-5C76
(ucs-set-char #x64EC ?$(Ckt(B) ; KS0-C-6B74
(ucs-set-char #x64EC ?$(Gsi(B) ; C01-G-7369
(ucs-set-char #x64EC ?$@5<(B) ; J78-@-353C
(ucs-set-char #x64EC ?$B5<(B) ; J83-B-353C
(ucs-set-char #x64ED ?$(DA/(B) ; J90-D-412F
(ucs-set-char #x64ED ?$(Gsl(B) ; C01-G-736C
(ucs-set-char #x64EE ?$(ITi(B) ; C03-I-5469
(ucs-set-char #x64EF ?$(H\s(B) ; C02-H-5C73
(ucs-set-char #x64EF ?$@Z/(B) ; J78-@-5A2F
(ucs-set-char #x64EF ?$BZ/(B) ; J83-B-5A2F
(ucs-set-char #x64F0 ?$(DA0(B) ; J90-D-4130
(ucs-set-char #x64F0 ?$(Gsg(B) ; C01-G-7367
(ucs-set-char #x64F1 ?$(Gsj(B) ; C01-G-736A
(ucs-set-char #x64F1 ?$@Z((B) ; J78-@-5A28
(ucs-set-char #x64F1 ?$BZ((B) ; J83-B-5A28
(ucs-set-char #x64F2 ?$(Ct-(B) ; KS0-C-742D
(ucs-set-char #x64F2 ?$(GvE(B) ; C01-G-7645
(ucs-set-char #x64F2 ?$@Z3(B) ; J78-@-5A33
(ucs-set-char #x64F2 ?$BZ3(B) ; J83-B-5A33
(ucs-set-char #x64F3 ?$(HW8(B) ; C02-H-5738
(ucs-set-char #x64F4 ?$(C|*(B) ; KS0-C-7C2A
(ucs-set-char #x64F4 ?$(GvD(B) ; C01-G-7644
(ucs-set-char #x64F4 ?$@Z2(B) ; J78-@-5A32
(ucs-set-char #x64F4 ?$BZ2(B) ; J83-B-5A32
(ucs-set-char #x64F5 ?$(DA1(B) ; J90-D-4131
(ucs-set-char #x64F5 ?$(M?b(B) ; C07-M-3F62
(ucs-set-char #x64F6 ?$(IWj(B) ; C03-I-576A
(ucs-set-char #x64F6 ?$@Z1(B) ; J78-@-5A31
(ucs-set-char #x64F6 ?$BZ1(B) ; J83-B-5A31
(ucs-set-char #x64F7 ?$(DA2(B) ; J90-D-4132
(ucs-set-char #x64F7 ?$(GvJ(B) ; C01-G-764A
(ucs-set-char #x64F8 ?$(Ha`(B) ; C02-H-6160
(ucs-set-char #x64F9 ?$(IWp(B) ; C03-I-5770
(ucs-set-char #x64FA ?$(Cwl(B) ; KS0-C-776C
(ucs-set-char #x64FA ?$(GvH(B) ; C01-G-7648
(ucs-set-char #x64FA ?$@Z4(B) ; J78-@-5A34
(ucs-set-char #x64FA ?$BZ4(B) ; J83-B-5A34
(ucs-set-char #x64FB ?$(DA3(B) ; J90-D-4133
(ucs-set-char #x64FB ?$(GvI(B) ; C01-G-7649
(ucs-set-char #x64FC ?$(Hac(B) ; C02-H-6163
(ucs-set-char #x64FD ?$(Ha_(B) ; C02-H-615F
(ucs-set-char #x64FD ?$@Z6(B) ; J78-@-5A36
(ucs-set-char #x64FD ?$BZ6(B) ; J83-B-5A36
(ucs-set-char #x64FE ?$(Chv(B) ; KS0-C-6876
(ucs-set-char #x64FE ?$(GvF(B) ; C01-G-7646
(ucs-set-char #x64FE ?$@>q(B) ; J78-@-3E71
(ucs-set-char #x64FE ?$B>q(B) ; J83-B-3E71
(ucs-set-char #x64FF ?$(DA4(B) ; J90-D-4134
(ucs-set-char #x64FF ?$(Ha](B) ; C02-H-615D
(ucs-set-char #x6500 ?$(CZg(B) ; KS0-C-5A67
(ucs-set-char #x6500 ?$(Gx8(B) ; C01-G-7838
(ucs-set-char #x6500 ?$@Z5(B) ; J78-@-5A35
(ucs-set-char #x6500 ?$AEJ(B) ; GB0-A-454A
(ucs-set-char #x6500 ?$BZ5(B) ; J83-B-5A35
(ucs-set-char #x6501 ?$(DA5(B) ; J90-D-4135
(ucs-set-char #x6501 ?$(Haa(B) ; C02-H-6161
(ucs-set-char #x6502 ?$(J[6(B) ; C04-J-5B36
(ucs-set-char #x6503 ?$(Hab(B) ; C02-H-6162
(ucs-set-char #x6504 ?$(CwL(B) ; KS0-C-774C
(ucs-set-char #x6504 ?$(DA6(B) ; J90-D-4136
(ucs-set-char #x6504 ?$(Ha^(B) ; C02-H-615E
(ucs-set-char #x6505 ?$(IWn(B) ; C03-I-576E
(ucs-set-char #x6505 ?$BZ9(B) ; J83-B-5A39
(ucs-set-char #x6506 ?$(GvG(B) ; C01-G-7647
(ucs-set-char #x6507 ?$(HeM(B) ; C02-H-654D
(ucs-set-char #x6508 ?$(DA7(B) ; J90-D-4137
(ucs-set-char #x6508 ?$(IZ;(B) ; C03-I-5A3B
(ucs-set-char #x6509 ?$(DA8(B) ; J90-D-4138
(ucs-set-char #x6509 ?$(HeP(B) ; C02-H-6550
(ucs-set-char #x6509 ?$A_+(B) ; GB0-A-5F2B
(ucs-set-char #x650A ?$(DA9(B) ; J90-D-4139
(ucs-set-char #x650A ?$(IZ<(B) ; C03-I-5A3C
(ucs-set-char #x650B ?$(IZ:(B) ; C03-I-5A3A
(ucs-set-char #x650C ?$(HeQ(B) ; C02-H-6551
(ucs-set-char #x650D ?$(HeO(B) ; C02-H-654F
(ucs-set-char #x650E ?$(HeR(B) ; C02-H-6552
(ucs-set-char #x650F ?$(DA:(B) ; J90-D-413A
(ucs-set-char #x650F ?$(Gx9(B) ; C01-G-7839
(ucs-set-char #x6510 ?$(HeN(B) ; C02-H-654E
(ucs-set-char #x6511 ?$(I^1(B) ; C03-I-5E31
(ucs-set-char #x6512 ?$AT\(B) ; GB0-A-545C
(ucs-set-char #x6513 ?$(DA;(B) ; J90-D-413B
(ucs-set-char #x6513 ?$(Hhz(B) ; C02-H-687A
(ucs-set-char #x6514 ?$(DA<(B) ; J90-D-413C
(ucs-set-char #x6514 ?$(Gyo(B) ; C01-G-796F
(ucs-set-char #x6515 ?$(Hhy(B) ; C02-H-6879
(ucs-set-char #x6516 ?$(DA=(B) ; J90-D-413D
(ucs-set-char #x6516 ?$(Hhx(B) ; C02-H-6878
(ucs-set-char #x6517 ?$(Hhw(B) ; C02-H-6877
(ucs-set-char #x6518 ?$(CeA(B) ; KS0-C-6541
(ucs-set-char #x6518 ?$(Gyn(B) ; C01-G-796E
(ucs-set-char #x6518 ?$@Z7(B) ; J78-@-5A37
(ucs-set-char #x6518 ?$AHA(B) ; GB0-A-4841
(ucs-set-char #x6518 ?$BZ7(B) ; J83-B-5A37
(ucs-set-char #x6519 ?$(DA>(B) ; J90-D-413E
(ucs-set-char #x6519 ?$(Gyp(B) ; C01-G-7970
(ucs-set-char #x651B ?$(DA?(B) ; J90-D-413F
(ucs-set-char #x651B ?$(Hk[(B) ; C02-H-6B5B
(ucs-set-char #x651C ?$(Gzm(B) ; C01-G-7A6D
(ucs-set-char #x651C ?$@Z8(B) ; J78-@-5A38
(ucs-set-char #x651C ?$BZ8(B) ; J83-B-5A38
(ucs-set-char #x651D ?$(C`n(B) ; KS0-C-606E
(ucs-set-char #x651D ?$(Gzl(B) ; C01-G-7A6C
(ucs-set-char #x651D ?$@Yp(B) ; J78-@-5970
(ucs-set-char #x651D ?$BYp(B) ; J83-B-5970
(ucs-set-char #x651E ?$(DA@(B) ; J90-D-4140
(ucs-set-char #x651E ?$(I_J(B) ; C03-I-5F4A
(ucs-set-char #x651F ?$(DAA(B) ; J90-D-4141
(ucs-set-char #x651F ?$(I_K(B) ; C03-I-5F4B
(ucs-set-char #x6520 ?$(HmO(B) ; C02-H-6D4F
(ucs-set-char #x6521 ?$(HmN(B) ; C02-H-6D4E
(ucs-set-char #x6522 ?$(DAB(B) ; J90-D-4142
(ucs-set-char #x6522 ?$(HmQ(B) ; C02-H-6D51
(ucs-set-char #x6522 ?$@Z9(B) ; J78-@-5A39
(ucs-set-char #x6523 ?$(CU}(B) ; KS0-C-557D
(ucs-set-char #x6523 ?$(G|7(B) ; C01-G-7C37
(ucs-set-char #x6523 ?$@Z;(B) ; J78-@-5A3B
(ucs-set-char #x6523 ?$BZ;(B) ; J83-B-5A3B
(ucs-set-char #x6524 ?$(G{a(B) ; C01-G-7B61
(ucs-set-char #x6524 ?$@Z:(B) ; J78-@-5A3A
(ucs-set-char #x6524 ?$BZ:(B) ; J83-B-5A3A
(ucs-set-char #x6525 ?$(Ho,(B) ; C02-H-6F2C
(ucs-set-char #x6525 ?$A_,(B) ; GB0-A-5F2C
(ucs-set-char #x6526 ?$(DAC(B) ; J90-D-4143
(ucs-set-char #x6526 ?$(HmP(B) ; C02-H-6D50
(ucs-set-char #x6527 ?$(I_I(B) ; C03-I-5F49
(ucs-set-char #x6528 ?$(I`2(B) ; C03-I-6032
(ucs-set-char #x6529 ?$(DAD(B) ; J90-D-4144
(ucs-set-char #x6529 ?$(Ho+(B) ; C02-H-6F2B
(ucs-set-char #x652A ?$(CNf(B) ; KS0-C-4E66
(ucs-set-char #x652A ?$(G|9(B) ; C01-G-7C39
(ucs-set-char #x652A ?$@3I(B) ; J78-@-3349
(ucs-set-char #x652A ?$BYx(B) ; J83-B-5978
(ucs-set-char #x652B ?$(C|+(B) ; KS0-C-7C2B
(ucs-set-char #x652B ?$(G|8(B) ; C01-G-7C38
(ucs-set-char #x652B ?$@Z<(B) ; J78-@-5A3C
(ucs-set-char #x652B ?$A>p(B) ; GB0-A-3E70
(ucs-set-char #x652B ?$BZ<(B) ; J83-B-5A3C
(ucs-set-char #x652C ?$(CU;(B) ; KS0-C-553B
(ucs-set-char #x652C ?$(G|_(B) ; C01-G-7C5F
(ucs-set-char #x652C ?$@Z0(B) ; J78-@-5A30
(ucs-set-char #x652C ?$BZ0(B) ; J83-B-5A30
(ucs-set-char #x652D ?$(Hp7(B) ; C02-H-7037
(ucs-set-char #x652E ?$(DAE(B) ; J90-D-4145
(ucs-set-char #x652E ?$(Hp}(B) ; C02-H-707D
(ucs-set-char #x652E ?$A_-(B) ; GB0-A-5F2D
(ucs-set-char #x652F ?$(Cr((B) ; KS0-C-7228
(ucs-set-char #x652F ?$(GEE(B) ; C01-G-4545
(ucs-set-char #x652F ?$@;Y(B) ; J78-@-3B59
(ucs-set-char #x652F ?$AV'(B) ; GB0-A-5627
(ucs-set-char #x652F ?$B;Y(B) ; J83-B-3B59
(ucs-set-char #x6530 ?$(L#l(B) ; C06-L-236C
(ucs-set-char #x6531 ?$(DAF(B) ; J90-D-4146
(ucs-set-char #x6531 ?$(I,r(B) ; C03-I-2C72
(ucs-set-char #x6532 ?$(H<7(B) ; C02-H-3C37
(ucs-set-char #x6533 ?$(HW:(B) ; C02-H-573A
(ucs-set-char #x6534 ?$(I!g(B) ; C03-I-2167
(ucs-set-char #x6534 ?$@Z=(B) ; J78-@-5A3D
(ucs-set-char #x6534 ?$Aj7(B) ; GB0-A-6A37
(ucs-set-char #x6534 ?$BZ=(B) ; J83-B-5A3D
(ucs-set-char #x6535 ?$(I!h(B) ; C03-I-2168
(ucs-set-char #x6535 ?$@Z>(B) ; J78-@-5A3E
(ucs-set-char #x6535 ?$Ak6(B) ; GB0-A-6B36
(ucs-set-char #x6535 ?$BZ>(B) ; J83-B-5A3E
(ucs-set-char #x6536 ?$(Cb%(B) ; KS0-C-6225
(ucs-set-char #x6536 ?$(GH-(B) ; C01-G-482D
(ucs-set-char #x6536 ?$@Z@(B) ; J78-@-5A40
(ucs-set-char #x6536 ?$AJU(B) ; GB0-A-4A55
(ucs-set-char #x6536 ?$BZ@(B) ; J83-B-5A40
(ucs-set-char #x6537 ?$(CM9(B) ; KS0-C-4D39
(ucs-set-char #x6537 ?$(H"M(B) ; C02-H-224D
(ucs-set-char #x6537 ?$@Z?(B) ; J78-@-5A3F
(ucs-set-char #x6537 ?$BZ?(B) ; J83-B-5A3F
(ucs-set-char #x6538 ?$(Cjr(B) ; KS0-C-6A72
(ucs-set-char #x6538 ?$(GJS(B) ; C01-G-4A53
(ucs-set-char #x6538 ?$@ZA(B) ; J78-@-5A41
(ucs-set-char #x6538 ?$AX|(B) ; GB0-A-587C
(ucs-set-char #x6538 ?$BZA(B) ; J83-B-5A41
(ucs-set-char #x6539 ?$(CKG(B) ; KS0-C-4B47
(ucs-set-char #x6539 ?$(GJQ(B) ; C01-G-4A51
(ucs-set-char #x6539 ?$@2~(B) ; J78-@-327E
(ucs-set-char #x6539 ?$A8D(B) ; GB0-A-3844
(ucs-set-char #x6539 ?$B2~(B) ; J83-B-327E
(ucs-set-char #x653A ?$(DAG(B) ; J90-D-4147
(ucs-set-char #x653A ?$(J$?(B) ; C04-J-243F
(ucs-set-char #x653B ?$(CMt(B) ; KS0-C-4D74
(ucs-set-char #x653B ?$(GJR(B) ; C01-G-4A52
(ucs-set-char #x653B ?$@96(B) ; J78-@-3936
(ucs-set-char #x653B ?$A9%(B) ; GB0-A-3925
(ucs-set-char #x653B ?$B96(B) ; J83-B-3936
(ucs-set-char #x653C ?$(DAH(B) ; J90-D-4148
(ucs-set-char #x653C ?$(J$>(B) ; C04-J-243E
(ucs-set-char #x653D ?$(DAI(B) ; J90-D-4149
(ucs-set-char #x653D ?$(H'"(B) ; C02-H-2722
(ucs-set-char #x653E ?$(C[/(B) ; KS0-C-5B2F
(ucs-set-char #x653E ?$(GMs(B) ; C01-G-4D73
(ucs-set-char #x653E ?$@J|(B) ; J78-@-4A7C
(ucs-set-char #x653E ?$A7E(B) ; GB0-A-3745
(ucs-set-char #x653E ?$BJ|(B) ; J83-B-4A7C
(ucs-set-char #x653F ?$(CoY(B) ; KS0-C-6F59
(ucs-set-char #x653F ?$(GQI(B) ; C01-G-5149
(ucs-set-char #x653F ?$@@/(B) ; J78-@-402F
(ucs-set-char #x653F ?$AU~(B) ; GB0-A-557E
(ucs-set-char #x653F ?$B@/(B) ; J83-B-402F
(ucs-set-char #x6540 ?$(I,t(B) ; C03-I-2C74
(ucs-set-char #x6541 ?$(H*h(B) ; C02-H-2A68
(ucs-set-char #x6542 ?$(I,v(B) ; C03-I-2C76
(ucs-set-char #x6543 ?$(DAJ(B) ; J90-D-414A
(ucs-set-char #x6543 ?$(H*i(B) ; C02-H-2A69
(ucs-set-char #x6544 ?$(I,s(B) ; C03-I-2C73
(ucs-set-char #x6545 ?$(CM:(B) ; KS0-C-4D3A
(ucs-set-char #x6545 ?$(GQJ(B) ; C01-G-514A
(ucs-set-char #x6545 ?$@8N(B) ; J78-@-384E
(ucs-set-char #x6545 ?$A9J(B) ; GB0-A-394A
(ucs-set-char #x6545 ?$B8N(B) ; J83-B-384E
(ucs-set-char #x6546 ?$(H/P(B) ; C02-H-2F50
(ucs-set-char #x6547 ?$(DAK(B) ; J90-D-414B
(ucs-set-char #x6547 ?$(J-C(B) ; C04-J-2D43
(ucs-set-char #x6548 ?$(C|y(B) ; KS0-C-7C79
(ucs-set-char #x6548 ?$(GUf(B) ; C01-G-5566
(ucs-set-char #x6548 ?$@ZC(B) ; J78-@-5A43
(ucs-set-char #x6548 ?$AP'(B) ; GB0-A-5027
(ucs-set-char #x6548 ?$BZC(B) ; J83-B-5A43
(ucs-set-char #x6549 ?$(DAL(B) ; J90-D-414C
(ucs-set-char #x6549 ?$(GUg(B) ; C01-G-5567
(ucs-set-char #x6549 ?$AtM(B) ; GB0-A-744D
(ucs-set-char #x654A ?$(H/O(B) ; C02-H-2F4F
(ucs-set-char #x654B ?$(I1=(B) ; C03-I-313D
(ucs-set-char #x654C ?$(J-D(B) ; C04-J-2D44
(ucs-set-char #x654C ?$A5P(B) ; GB0-A-3550
(ucs-set-char #x654D ?$(C_s(B) ; KS0-C-5F73
(ucs-set-char #x654D ?$(I67(B) ; C03-I-3637
(ucs-set-char #x654D ?$@ZF(B) ; J78-@-5A46
(ucs-set-char #x654D ?$BZF(B) ; J83-B-5A46
(ucs-set-char #x654E ?$(CNg(B) ; KS0-C-4E67
(ucs-set-char #x654E ?$(I66(B) ; C03-I-3636
(ucs-set-char #x654F ?$(CZB(B) ; KS0-C-5A42
(ucs-set-char #x654F ?$(GZw(B) ; C01-G-5A77
(ucs-set-char #x654F ?$(J-F(B) ; C04-J-2D46
(ucs-set-char #x654F ?$@IR(B) ; J78-@-4952
(ucs-set-char #x654F ?$ACt(B) ; GB0-A-4374
(ucs-set-char #x654F ?$BIR(B) ; J83-B-4952
(ucs-set-char #x6550 ?$(DAM(B) ; J90-D-414D
(ucs-set-char #x6550 ?$(J2+(B) ; C04-J-322B
(ucs-set-char #x6551 ?$(CO-(B) ; KS0-C-4F2D
(ucs-set-char #x6551 ?$(GZs(B) ; C01-G-5A73
(ucs-set-char #x6551 ?$@5_(B) ; J78-@-355F
(ucs-set-char #x6551 ?$A>H(B) ; GB0-A-3E48
(ucs-set-char #x6551 ?$B5_(B) ; J83-B-355F
(ucs-set-char #x6552 ?$(DAN(B) ; J90-D-414E
(ucs-set-char #x6552 ?$(J2/(B) ; C04-J-322F
(ucs-set-char #x6553 ?$(H5i(B) ; C02-H-3569
(ucs-set-char #x6554 ?$(DAO(B) ; J90-D-414F
(ucs-set-char #x6554 ?$(GZz(B) ; C01-G-5A7A
(ucs-set-char #x6555 ?$(GZy(B) ; C01-G-5A79
(ucs-set-char #x6555 ?$@ZE(B) ; J78-@-5A45
(ucs-set-char #x6555 ?$Ak7(B) ; GB0-A-6B37
(ucs-set-char #x6555 ?$BZE(B) ; J83-B-5A45
(ucs-set-char #x6556 ?$(Cgy(B) ; KS0-C-6779
(ucs-set-char #x6556 ?$(GZr(B) ; C01-G-5A72
(ucs-set-char #x6556 ?$@ZD(B) ; J78-@-5A44
(ucs-set-char #x6556 ?$A0=(B) ; GB0-A-303D
(ucs-set-char #x6556 ?$BZD(B) ; J83-B-5A44
(ucs-set-char #x6557 ?$(Cx((B) ; KS0-C-7828
(ucs-set-char #x6557 ?$(GZu(B) ; C01-G-5A75
(ucs-set-char #x6557 ?$@GT(B) ; J78-@-4754
(ucs-set-char #x6557 ?$BGT(B) ; J83-B-4754
(ucs-set-char #x6558 ?$(GZx(B) ; C01-G-5A78
(ucs-set-char #x6558 ?$@ZG(B) ; J78-@-5A47
(ucs-set-char #x6558 ?$BZG(B) ; J83-B-5A47
(ucs-set-char #x6559 ?$(GZt(B) ; C01-G-5A74
(ucs-set-char #x6559 ?$@65(B) ; J78-@-3635
(ucs-set-char #x6559 ?$A=L(B) ; GB0-A-3D4C
(ucs-set-char #x6559 ?$B65(B) ; J83-B-3635
(ucs-set-char #x655A ?$(I64(B) ; C03-I-3634
(ucs-set-char #x655B ?$AA2(B) ; GB0-A-4132
(ucs-set-char #x655C ?$(H<;(B) ; C02-H-3C3B
(ucs-set-char #x655D ?$(GZq(B) ; C01-G-5A71
(ucs-set-char #x655D ?$@ZI(B) ; J78-@-5A49
(ucs-set-char #x655D ?$A1V(B) ; GB0-A-3156
(ucs-set-char #x655D ?$BZI(B) ; J83-B-5A49
(ucs-set-char #x655E ?$(Csb(B) ; KS0-C-7362
(ucs-set-char #x655E ?$(G_T(B) ; C01-G-5F54
(ucs-set-char #x655E ?$@ZH(B) ; J78-@-5A48
(ucs-set-char #x655E ?$A3((B) ; GB0-A-3328
(ucs-set-char #x655E ?$BZH(B) ; J83-B-5A48
(ucs-set-char #x655F ?$(DAP(B) ; J90-D-4150
(ucs-set-char #x655F ?$(I;t(B) ; C03-I-3B74
(ucs-set-char #x6560 ?$(DAQ(B) ; J90-D-4151
(ucs-set-char #x6560 ?$(I;u(B) ; C03-I-3B75
(ucs-set-char #x6561 ?$(I;v(B) ; C03-I-3B76
(ucs-set-char #x6562 ?$(CJr(B) ; KS0-C-4A72
(ucs-set-char #x6562 ?$(G_V(B) ; C01-G-5F56
(ucs-set-char #x6562 ?$@4:(B) ; J78-@-343A
(ucs-set-char #x6562 ?$A8R(B) ; GB0-A-3852
(ucs-set-char #x6562 ?$B4:(B) ; J83-B-343A
(ucs-set-char #x6563 ?$(C_$(B) ; KS0-C-5F24
(ucs-set-char #x6563 ?$(G_W(B) ; C01-G-5F57
(ucs-set-char #x6563 ?$@;6(B) ; J78-@-3B36
(ucs-set-char #x6563 ?$AI"(B) ; GB0-A-4922
(ucs-set-char #x6563 ?$B;6(B) ; J83-B-3B36
(ucs-set-char #x6564 ?$(H<:(B) ; C02-H-3C3A
(ucs-set-char #x6565 ?$(H<=(B) ; C02-H-3C3D
(ucs-set-char #x6566 ?$(CTD(B) ; KS0-C-5444
(ucs-set-char #x6566 ?$(G_U(B) ; C01-G-5F55
(ucs-set-char #x6566 ?$@FX(B) ; J78-@-4658
(ucs-set-char #x6566 ?$A6X(B) ; GB0-A-3658
(ucs-set-char #x6566 ?$BFX(B) ; J83-B-4658
(ucs-set-char #x6567 ?$(DAR(B) ; J90-D-4152
(ucs-set-char #x6567 ?$(H<8(B) ; C02-H-3C38
(ucs-set-char #x6568 ?$(H<<(B) ; C02-H-3C3C
(ucs-set-char #x656A ?$(H<9(B) ; C02-H-3C39
(ucs-set-char #x656B ?$(DAS(B) ; J90-D-4153
(ucs-set-char #x656B ?$(IAK(B) ; C03-I-414B
(ucs-set-char #x656B ?$Ak8(B) ; GB0-A-6B38
(ucs-set-char #x656C ?$(CLW(B) ; KS0-C-4C57
(ucs-set-char #x656C ?$(Gd9(B) ; C01-G-6439
(ucs-set-char #x656C ?$@7I(B) ; J78-@-3749
(ucs-set-char #x656C ?$A>4(B) ; GB0-A-3E34
(ucs-set-char #x656C ?$B7I(B) ; J83-B-3749
(ucs-set-char #x656D ?$(CeB(B) ; KS0-C-6542
(ucs-set-char #x656D ?$(IAN(B) ; C03-I-414E
(ucs-set-char #x656E ?$(J=](B) ; C04-J-3D5D
(ucs-set-char #x656F ?$(HCB(B) ; C02-H-4342
(ucs-set-char #x6570 ?$(IAM(B) ; C03-I-414D
(ucs-set-char #x6570 ?$@?t(B) ; J78-@-3F74
(ucs-set-char #x6570 ?$AJ}(B) ; GB0-A-4A7D
(ucs-set-char #x6570 ?$B?t(B) ; J83-B-3F74
(ucs-set-char #x6571 ?$(IG0(B) ; C03-I-4730
(ucs-set-char #x6572 ?$(CM;(B) ; KS0-C-4D3B
(ucs-set-char #x6572 ?$(Gh}(B) ; C01-G-687D
(ucs-set-char #x6572 ?$@ZJ(B) ; J78-@-5A4A
(ucs-set-char #x6572 ?$AGC(B) ; GB0-A-4743
(ucs-set-char #x6572 ?$BZJ(B) ; J83-B-5A4A
(ucs-set-char #x6573 ?$(HJ[(B) ; C02-H-4A5B
(ucs-set-char #x6574 ?$(CoZ(B) ; KS0-C-6F5A
(ucs-set-char #x6574 ?$(Gpl(B) ; C01-G-706C
(ucs-set-char #x6574 ?$@@0(B) ; J78-@-4030
(ucs-set-char #x6574 ?$AU{(B) ; GB0-A-557B
(ucs-set-char #x6574 ?$B@0(B) ; J83-B-4030
(ucs-set-char #x6575 ?$(CnX(B) ; KS0-C-6E58
(ucs-set-char #x6575 ?$(Gm.(B) ; C01-G-6D2E
(ucs-set-char #x6575 ?$@E((B) ; J78-@-4528
(ucs-set-char #x6575 ?$BE((B) ; J83-B-4528
(ucs-set-char #x6576 ?$(HPd(B) ; C02-H-5064
(ucs-set-char #x6577 ?$(C]'(B) ; KS0-C-5D27
(ucs-set-char #x6577 ?$(Gm/(B) ; C01-G-6D2F
(ucs-set-char #x6577 ?$(L]K(B) ; C06-L-5D4B
(ucs-set-char #x6577 ?$@I_(B) ; J78-@-495F
(ucs-set-char #x6577 ?$A7s(B) ; GB0-A-3773
(ucs-set-char #x6577 ?$BI_(B) ; J83-B-495F
(ucs-set-char #x6578 ?$(Cb&(B) ; KS0-C-6226
(ucs-set-char #x6578 ?$(Gm0(B) ; C01-G-6D30
(ucs-set-char #x6578 ?$@ZK(B) ; J78-@-5A4B
(ucs-set-char #x6578 ?$BZK(B) ; J83-B-5A4B
(ucs-set-char #x6579 ?$(HPf(B) ; C02-H-5066
(ucs-set-char #x657A ?$(DAT(B) ; J90-D-4154
(ucs-set-char #x657A ?$(HPe(B) ; C02-H-5065
(ucs-set-char #x657B ?$(HPg(B) ; C02-H-5067
(ucs-set-char #x657C ?$(HW<(B) ; C02-H-573C
(ucs-set-char #x657D ?$(DAU(B) ; J90-D-4155
(ucs-set-char #x657E ?$(C`@(B) ; KS0-C-6040
(ucs-set-char #x657E ?$(JPI(B) ; C04-J-5049
(ucs-set-char #x657F ?$(HW;(B) ; C02-H-573B
(ucs-set-char #x6580 ?$(H\z(B) ; C02-H-5C7A
(ucs-set-char #x6581 ?$(DAV(B) ; J90-D-4156
(ucs-set-char #x6581 ?$(H\y(B) ; C02-H-5C79
(ucs-set-char #x6582 ?$(CV0(B) ; KS0-C-5630
(ucs-set-char #x6582 ?$(Gsm(B) ; C01-G-736D
(ucs-set-char #x6582 ?$@ZL(B) ; J78-@-5A4C
(ucs-set-char #x6582 ?$BZL(B) ; J83-B-5A4C
(ucs-set-char #x6583 ?$(CxJ(B) ; KS0-C-784A
(ucs-set-char #x6583 ?$(Gsn(B) ; C01-G-736E
(ucs-set-char #x6583 ?$@ZM(B) ; J78-@-5A4D
(ucs-set-char #x6583 ?$BZM(B) ; J83-B-5A4D
(ucs-set-char #x6584 ?$(HeS(B) ; C02-H-6553
(ucs-set-char #x6585 ?$(C|z(B) ; KS0-C-7C7A
(ucs-set-char #x6585 ?$(DAW(B) ; J90-D-4157
(ucs-set-char #x6585 ?$(I\A(B) ; C03-I-5C41
(ucs-set-char #x6587 ?$(CY~(B) ; KS0-C-597E
(ucs-set-char #x6587 ?$(GEF(B) ; C01-G-4546
(ucs-set-char #x6587 ?$@J8(B) ; J78-@-4A38
(ucs-set-char #x6587 ?$AND(B) ; GB0-A-4E44
(ucs-set-char #x6587 ?$BJ8(B) ; J83-B-4A38
(ucs-set-char #x6588 ?$(I%X(B) ; C03-I-2558
(ucs-set-char #x6588 ?$@U](B) ; J78-@-555D
(ucs-set-char #x6588 ?$BU](B) ; J83-B-555D
(ucs-set-char #x6589 ?$(I)9(B) ; C03-I-2939
(ucs-set-char #x6589 ?$@@F(B) ; J78-@-4046
(ucs-set-char #x6589 ?$B@F(B) ; J83-B-4046
(ucs-set-char #x658A ?$(DAX(B) ; J90-D-4158
(ucs-set-char #x658A ?$(J-G(B) ; C04-J-2D47
(ucs-set-char #x658B ?$(I1@(B) ; C03-I-3140
(ucs-set-char #x658B ?$AU+(B) ; GB0-A-552B
(ucs-set-char #x658C ?$(C^0(B) ; KS0-C-5E30
(ucs-set-char #x658C ?$(H<>(B) ; C02-H-3C3E
(ucs-set-char #x658C ?$@IL(B) ; J78-@-494C
(ucs-set-char #x658C ?$A1s(B) ; GB0-A-3173
(ucs-set-char #x658C ?$BIL(B) ; J83-B-494C
(ucs-set-char #x658D ?$(I68(B) ; C03-I-3638
(ucs-set-char #x658E ?$(I69(B) ; C03-I-3639
(ucs-set-char #x658E ?$@:X(B) ; J78-@-3A58
(ucs-set-char #x658E ?$B:X(B) ; J83-B-3A58
(ucs-set-char #x6590 ?$(C]l(B) ; KS0-C-5D6C
(ucs-set-char #x6590 ?$(G_Y(B) ; C01-G-5F59
(ucs-set-char #x6590 ?$@He(B) ; J78-@-4865
(ucs-set-char #x6590 ?$Al3(B) ; GB0-A-6C33
(ucs-set-char #x6590 ?$BHe(B) ; J83-B-4865
(ucs-set-char #x6591 ?$(CZh(B) ; KS0-C-5A68
(ucs-set-char #x6591 ?$(G_X(B) ; C01-G-5F58
(ucs-set-char #x6591 ?$@HC(B) ; J78-@-4843
(ucs-set-char #x6591 ?$A0_(B) ; GB0-A-305F
(ucs-set-char #x6591 ?$BHC(B) ; J83-B-4843
(ucs-set-char #x6592 ?$(DAY(B) ; J90-D-4159
(ucs-set-char #x6592 ?$(HCC(B) ; C02-H-4343
(ucs-set-char #x6593 ?$Al5(B) ; GB0-A-6C35
(ucs-set-char #x6594 ?$(Had(B) ; C02-H-6164
(ucs-set-char #x6595 ?$(DAZ(B) ; J90-D-415A
(ucs-set-char #x6595 ?$(Gzn(B) ; C01-G-7A6E
(ucs-set-char #x6596 ?$(Ho-(B) ; C02-H-6F2D
(ucs-set-char #x6597 ?$(CT`(B) ; KS0-C-5460
(ucs-set-char #x6597 ?$(GEG(B) ; C01-G-4547
(ucs-set-char #x6597 ?$@EM(B) ; J78-@-454D
(ucs-set-char #x6597 ?$A67(B) ; GB0-A-3637
(ucs-set-char #x6597 ?$BEM(B) ; J83-B-454D
(ucs-set-char #x6598 ?$(DA[(B) ; J90-D-415B
(ucs-set-char #x6598 ?$(J$A(B) ; C04-J-2441
(ucs-set-char #x6599 ?$(CVy(B) ; KS0-C-5679
(ucs-set-char #x6599 ?$(GUh(B) ; C01-G-5568
(ucs-set-char #x6599 ?$@NA(B) ; J78-@-4E41
(ucs-set-char #x6599 ?$AAO(B) ; GB0-A-414F
(ucs-set-char #x6599 ?$BNA(B) ; J83-B-4E41
(ucs-set-char #x659A ?$(I1B(B) ; C03-I-3142
(ucs-set-char #x659B ?$(CMW(B) ; KS0-C-4D57
(ucs-set-char #x659B ?$(GZ|(B) ; C01-G-5A7C
(ucs-set-char #x659B ?$@ZO(B) ; J78-@-5A4F
(ucs-set-char #x659B ?$Auz(B) ; GB0-A-757A
(ucs-set-char #x659B ?$BZO(B) ; J83-B-5A4F
(ucs-set-char #x659C ?$(C^X(B) ; KS0-C-5E58
(ucs-set-char #x659C ?$(GZ{(B) ; C01-G-5A7B
(ucs-set-char #x659C ?$@<P(B) ; J78-@-3C50
(ucs-set-char #x659C ?$AP1(B) ; GB0-A-5031
(ucs-set-char #x659C ?$B<P(B) ; J83-B-3C50
(ucs-set-char #x659D ?$(DA\(B) ; J90-D-415C
(ucs-set-char #x659D ?$(H<?(B) ; C02-H-3C3F
(ucs-set-char #x659E ?$(H<@(B) ; C02-H-3C40
(ucs-set-char #x659F ?$(Crx(B) ; KS0-C-7278
(ucs-set-char #x659F ?$(Gd:(B) ; C01-G-643A
(ucs-set-char #x659F ?$@ZP(B) ; J78-@-5A50
(ucs-set-char #x659F ?$AUe(B) ; GB0-A-5565
(ucs-set-char #x659F ?$BZP(B) ; J83-B-5A50
(ucs-set-char #x65A0 ?$(DA](B) ; J90-D-415D
(ucs-set-char #x65A0 ?$(HJ\(B) ; C02-H-4A5C
(ucs-set-char #x65A1 ?$(CdV(B) ; KS0-C-6456
(ucs-set-char #x65A1 ?$(Gh~(B) ; C01-G-687E
(ucs-set-char #x65A1 ?$@06(B) ; J78-@-3036
(ucs-set-char #x65A1 ?$ANS(B) ; GB0-A-4E53
(ucs-set-char #x65A1 ?$B06(B) ; J83-B-3036
(ucs-set-char #x65A2 ?$(HW=(B) ; C02-H-573D
(ucs-set-char #x65A3 ?$(DA^(B) ; J90-D-415E
(ucs-set-char #x65A3 ?$(JV?(B) ; C04-J-563F
(ucs-set-char #x65A4 ?$(CPE(B) ; KS0-C-5045
(ucs-set-char #x65A4 ?$(GEH(B) ; C01-G-4548
(ucs-set-char #x65A4 ?$@6T(B) ; J78-@-3654
(ucs-set-char #x65A4 ?$A=o(B) ; GB0-A-3D6F
(ucs-set-char #x65A4 ?$B6T(B) ; J83-B-3654
(ucs-set-char #x65A5 ?$(Ct.(B) ; KS0-C-742E
(ucs-set-char #x65A5 ?$(GFX(B) ; C01-G-4658
(ucs-set-char #x65A5 ?$@@M(B) ; J78-@-404D
(ucs-set-char #x65A5 ?$A3b(B) ; GB0-A-3362
(ucs-set-char #x65A5 ?$B@M(B) ; J83-B-404D
(ucs-set-char #x65A6 ?$(DA_(B) ; J90-D-415F
(ucs-set-char #x65A6 ?$(I);(B) ; C03-I-293B
(ucs-set-char #x65A7 ?$(C]((B) ; KS0-C-5D28
(ucs-set-char #x65A7 ?$(GMt(B) ; C01-G-4D74
(ucs-set-char #x65A7 ?$@I`(B) ; J78-@-4960
(ucs-set-char #x65A7 ?$A8+(B) ; GB0-A-382B
(ucs-set-char #x65A7 ?$BI`(B) ; J83-B-4960
(ucs-set-char #x65A8 ?$(H'#(B) ; C02-H-2723
(ucs-set-char #x65A9 ?$AU6(B) ; GB0-A-5536
(ucs-set-char #x65AA ?$(H*j(B) ; C02-H-2A6A
(ucs-set-char #x65AB ?$(CmE(B) ; KS0-C-6D45
(ucs-set-char #x65AB ?$(GQK(B) ; C01-G-514B
(ucs-set-char #x65AB ?$@ZQ(B) ; J78-@-5A51
(ucs-set-char #x65AB ?$Am=(B) ; GB0-A-6D3D
(ucs-set-char #x65AB ?$BZQ(B) ; J83-B-5A51
(ucs-set-char #x65AC ?$(CsV(B) ; KS0-C-7356
(ucs-set-char #x65AC ?$(GZ}(B) ; C01-G-5A7D
(ucs-set-char #x65AC ?$@;B(B) ; J78-@-3B42
(ucs-set-char #x65AC ?$B;B(B) ; J83-B-3B42
(ucs-set-char #x65AD ?$(I6:(B) ; C03-I-363A
(ucs-set-char #x65AD ?$@CG(B) ; J78-@-4347
(ucs-set-char #x65AD ?$A6O(B) ; GB0-A-364F
(ucs-set-char #x65AD ?$BCG(B) ; J83-B-4347
(ucs-set-char #x65AE ?$(DA`(B) ; J90-D-4160
(ucs-set-char #x65AE ?$(H<A(B) ; C02-H-3C41
(ucs-set-char #x65AF ?$(C^Y(B) ; KS0-C-5E59
(ucs-set-char #x65AF ?$(G_Z(B) ; C01-G-5F5A
(ucs-set-char #x65AF ?$@;[(B) ; J78-@-3B5B
(ucs-set-char #x65AF ?$AK9(B) ; GB0-A-4B39
(ucs-set-char #x65AF ?$B;[(B) ; J83-B-3B5B
(ucs-set-char #x65B0 ?$(Ccf(B) ; KS0-C-6366
(ucs-set-char #x65B0 ?$(Gd;(B) ; C01-G-643B
(ucs-set-char #x65B0 ?$@?7(B) ; J78-@-3F37
(ucs-set-char #x65B0 ?$APB(B) ; GB0-A-5042
(ucs-set-char #x65B0 ?$B?7(B) ; J83-B-3F37
(ucs-set-char #x65B2 ?$(DAa(B) ; J90-D-4161
(ucs-set-char #x65B2 ?$(HPh(B) ; C02-H-5068
(ucs-set-char #x65B3 ?$(DAb(B) ; J90-D-4162
(ucs-set-char #x65B3 ?$(HPi(B) ; C02-H-5069
(ucs-set-char #x65B4 ?$(DAc(B) ; J90-D-4163
(ucs-set-char #x65B4 ?$(JPN(B) ; C04-J-504E
(ucs-set-char #x65B5 ?$(ITk(B) ; C03-I-546B
(ucs-set-char #x65B6 ?$(H\{(B) ; C02-H-5C7B
(ucs-set-char #x65B7 ?$(CS((B) ; KS0-C-5328
(ucs-set-char #x65B7 ?$(GvK(B) ; C01-G-764B
(ucs-set-char #x65B7 ?$@ZR(B) ; J78-@-5A52
(ucs-set-char #x65B7 ?$BZR(B) ; J83-B-5A52
(ucs-set-char #x65B8 ?$(Hp~(B) ; C02-H-707E
(ucs-set-char #x65B9 ?$(C[0(B) ; KS0-C-5B30
(ucs-set-char #x65B9 ?$(GEI(B) ; C01-G-4549
(ucs-set-char #x65B9 ?$@J}(B) ; J78-@-4A7D
(ucs-set-char #x65B9 ?$A7=(B) ; GB0-A-373D
(ucs-set-char #x65B9 ?$BJ}(B) ; J83-B-4A7D
(ucs-set-char #x65BA ?$(I)<(B) ; C03-I-293C
(ucs-set-char #x65BB ?$(H'$(B) ; C02-H-2724
(ucs-set-char #x65BC ?$(CeZ(B) ; KS0-C-655A
(ucs-set-char #x65BC ?$(GMu(B) ; C01-G-4D75
(ucs-set-char #x65BC ?$@1w(B) ; J78-@-3177
(ucs-set-char #x65BC ?$Al6(B) ; GB0-A-6C36
(ucs-set-char #x65BC ?$B1w(B) ; J83-B-3177
(ucs-set-char #x65BD ?$(Cc?(B) ; KS0-C-633F
(ucs-set-char #x65BD ?$(GQL(B) ; C01-G-514C
(ucs-set-char #x65BD ?$@;\(B) ; J78-@-3B5C
(ucs-set-char #x65BD ?$AJ)(B) ; GB0-A-4A29
(ucs-set-char #x65BD ?$B;\(B) ; J83-B-3B5C
(ucs-set-char #x65BE ?$(I,w(B) ; C03-I-2C77
(ucs-set-char #x65BF ?$(DAd(B) ; J90-D-4164
(ucs-set-char #x65BF ?$(H*k(B) ; C02-H-2A6B
(ucs-set-char #x65C1 ?$(C[1(B) ; KS0-C-5B31
(ucs-set-char #x65C1 ?$(GUi(B) ; C01-G-5569
(ucs-set-char #x65C1 ?$@ZU(B) ; J78-@-5A55
(ucs-set-char #x65C1 ?$AET(B) ; GB0-A-4554
(ucs-set-char #x65C1 ?$BZU(B) ; J83-B-5A55
(ucs-set-char #x65C2 ?$(DAe(B) ; J90-D-4165
(ucs-set-char #x65C2 ?$(H/T(B) ; C02-H-2F54
(ucs-set-char #x65C3 ?$(H/R(B) ; C02-H-2F52
(ucs-set-char #x65C3 ?$@ZS(B) ; J78-@-5A53
(ucs-set-char #x65C3 ?$Al9(B) ; GB0-A-6C39
(ucs-set-char #x65C3 ?$BZS(B) ; J83-B-5A53
(ucs-set-char #x65C4 ?$(H/S(B) ; C02-H-2F53
(ucs-set-char #x65C4 ?$@ZV(B) ; J78-@-5A56
(ucs-set-char #x65C4 ?$Al8(B) ; GB0-A-6C38
(ucs-set-char #x65C4 ?$BZV(B) ; J83-B-5A56
(ucs-set-char #x65C5 ?$(CUi(B) ; KS0-C-5569
(ucs-set-char #x65C5 ?$(GUj(B) ; C01-G-556A
(ucs-set-char #x65C5 ?$@N9(B) ; J78-@-4E39
(ucs-set-char #x65C5 ?$ABC(B) ; GB0-A-4243
(ucs-set-char #x65C5 ?$BN9(B) ; J83-B-4E39
(ucs-set-char #x65C6 ?$(H/Q(B) ; C02-H-2F51
(ucs-set-char #x65C6 ?$@ZT(B) ; J78-@-5A54
(ucs-set-char #x65C6 ?$Al7(B) ; GB0-A-6C37
(ucs-set-char #x65C6 ?$BZT(B) ; J83-B-5A54
(ucs-set-char #x65C7 ?$(I6<(B) ; C03-I-363C
(ucs-set-char #x65C8 ?$(DAf(B) ; J90-D-4166
(ucs-set-char #x65C8 ?$(J24(B) ; C04-J-3234
(ucs-set-char #x65C9 ?$(DAg(B) ; J90-D-4167
(ucs-set-char #x65C9 ?$(I6?(B) ; C03-I-363F
(ucs-set-char #x65CA ?$(I6=(B) ; C03-I-363D
(ucs-set-char #x65CB ?$(C`A(B) ; KS0-C-6041
(ucs-set-char #x65CB ?$(G[!(B) ; C01-G-5B21
(ucs-set-char #x65CB ?$@@{(B) ; J78-@-407B
(ucs-set-char #x65CB ?$AP}(B) ; GB0-A-507D
(ucs-set-char #x65CB ?$B@{(B) ; J83-B-407B
(ucs-set-char #x65CC ?$(Co[(B) ; KS0-C-6F5B
(ucs-set-char #x65CC ?$(G["(B) ; C01-G-5B22
(ucs-set-char #x65CC ?$@ZW(B) ; J78-@-5A57
(ucs-set-char #x65CC ?$Al:(B) ; GB0-A-6C3A
(ucs-set-char #x65CC ?$BZW(B) ; J83-B-5A57
(ucs-set-char #x65CD ?$(H5j(B) ; C02-H-356A
(ucs-set-char #x65CE ?$(DAh(B) ; J90-D-4168
(ucs-set-char #x65CE ?$(G[#(B) ; C01-G-5B23
(ucs-set-char #x65CE ?$Al;(B) ; GB0-A-6C3B
(ucs-set-char #x65CF ?$(Cpi(B) ; KS0-C-7069
(ucs-set-char #x65CF ?$(GZ~(B) ; C01-G-5A7E
(ucs-set-char #x65CF ?$@B2(B) ; J78-@-4232
(ucs-set-char #x65CF ?$AWe(B) ; GB0-A-5765
(ucs-set-char #x65CF ?$BB2(B) ; J83-B-4232
(ucs-set-char #x65D0 ?$(DAi(B) ; J90-D-4169
(ucs-set-char #x65D0 ?$(H<B(B) ; C02-H-3C42
(ucs-set-char #x65D1 ?$(I;y(B) ; C03-I-3B79
(ucs-set-char #x65D2 ?$(CW2(B) ; KS0-C-5732
(ucs-set-char #x65D2 ?$(H<C(B) ; C02-H-3C43
(ucs-set-char #x65D2 ?$@ZX(B) ; J78-@-5A58
(ucs-set-char #x65D2 ?$Al<(B) ; GB0-A-6C3C
(ucs-set-char #x65D2 ?$BZX(B) ; J83-B-5A58
(ucs-set-char #x65D3 ?$(HCD(B) ; C02-H-4344
(ucs-set-char #x65D4 ?$(DAj(B) ; J90-D-416A
(ucs-set-char #x65D4 ?$(J=d(B) ; C04-J-3D64
(ucs-set-char #x65D6 ?$(DAk(B) ; J90-D-416B
(ucs-set-char #x65D6 ?$(Gi"(B) ; C01-G-6922
(ucs-set-char #x65D6 ?$Al=(B) ; GB0-A-6C3D
(ucs-set-char #x65D7 ?$(CP}(B) ; KS0-C-507D
(ucs-set-char #x65D7 ?$(Gi!(B) ; C01-G-6921
(ucs-set-char #x65D7 ?$@4z(B) ; J78-@-347A
(ucs-set-char #x65D7 ?$AFl(B) ; GB0-A-466C
(ucs-set-char #x65D7 ?$B4z(B) ; J83-B-347A
(ucs-set-char #x65D8 ?$(DAl(B) ; J90-D-416C
(ucs-set-char #x65D8 ?$(JPO(B) ; C04-J-504F
(ucs-set-char #x65D9 ?$@ZZ(B) ; J78-@-5A5A
(ucs-set-char #x65D9 ?$BZZ(B) ; J83-B-5A5A
(ucs-set-char #x65DA ?$(H\|(B) ; C02-H-5C7C
(ucs-set-char #x65DB ?$(Hae(B) ; C02-H-6165
(ucs-set-char #x65DB ?$@ZY(B) ; J78-@-5A59
(ucs-set-char #x65DB ?$BZY(B) ; J83-B-5A59
(ucs-set-char #x65DC ?$(IZ?(B) ; C03-I-5A3F
(ucs-set-char #x65DD ?$(HeU(B) ; C02-H-6555
(ucs-set-char #x65DE ?$(HeT(B) ; C02-H-6554
(ucs-set-char #x65DF ?$(DAm(B) ; J90-D-416D
(ucs-set-char #x65DF ?$(Hh{(B) ; C02-H-687B
(ucs-set-char #x65E0 ?$(CYi(B) ; KS0-C-5969
(ucs-set-char #x65E0 ?$(I!i(B) ; C03-I-2169
(ucs-set-char #x65E0 ?$@Z[(B) ; J78-@-5A5B
(ucs-set-char #x65E0 ?$AN^(B) ; GB0-A-4E5E
(ucs-set-char #x65E0 ?$BZ[(B) ; J83-B-5A5B
(ucs-set-char #x65E1 ?$(H!>(B) ; C02-H-213E
(ucs-set-char #x65E1 ?$@Z\(B) ; J78-@-5A5C
(ucs-set-char #x65E1 ?$BZ\(B) ; J83-B-5A5C
(ucs-set-char #x65E2 ?$(GQM(B) ; C01-G-514D
(ucs-set-char #x65E2 ?$@4{(B) ; J78-@-347B
(ucs-set-char #x65E2 ?$A<H(B) ; GB0-A-3C48
(ucs-set-char #x65E2 ?$B4{(B) ; J83-B-347B
(ucs-set-char #x65E3 ?$(CP~(B) ; KS0-C-507E
(ucs-set-char #x65E3 ?$(I6@(B) ; C03-I-3640
(ucs-set-char #x65E3 ?$(I6A(B) ; C03-I-3641
(ucs-set-char #x65E4 ?$(IAP(B) ; C03-I-4150
(ucs-set-char #x65E5 ?$(Clm(B) ; KS0-C-6C6D
(ucs-set-char #x65E5 ?$(GEJ(B) ; C01-G-454A
(ucs-set-char #x65E5 ?$@F|(B) ; J78-@-467C
(ucs-set-char #x65E5 ?$AHU(B) ; GB0-A-4855
(ucs-set-char #x65E5 ?$BF|(B) ; J83-B-467C
(ucs-set-char #x65E6 ?$(CS)(B) ; KS0-C-5329
(ucs-set-char #x65E6 ?$(GFY(B) ; C01-G-4659
(ucs-set-char #x65E6 ?$@C6(B) ; J78-@-4336
(ucs-set-char #x65E6 ?$A5)(B) ; GB0-A-3529
(ucs-set-char #x65E6 ?$BC6(B) ; J83-B-4336
(ucs-set-char #x65E7 ?$(I"Q(B) ; C03-I-2251
(ucs-set-char #x65E7 ?$@5l(B) ; J78-@-356C
(ucs-set-char #x65E7 ?$A>I(B) ; GB0-A-3E49
(ucs-set-char #x65E7 ?$B5l(B) ; J83-B-356C
(ucs-set-char #x65E8 ?$(Cr)(B) ; KS0-C-7229
(ucs-set-char #x65E8 ?$(GH/(B) ; C01-G-482F
(ucs-set-char #x65E8 ?$@;](B) ; J78-@-3B5D
(ucs-set-char #x65E8 ?$AV<(B) ; GB0-A-563C
(ucs-set-char #x65E8 ?$B;](B) ; J83-B-3B5D
(ucs-set-char #x65E9 ?$(CpD(B) ; KS0-C-7044
(ucs-set-char #x65E9 ?$(GH.(B) ; C01-G-482E
(ucs-set-char #x65E9 ?$@Aa(B) ; J78-@-4161
(ucs-set-char #x65E9 ?$ATg(B) ; GB0-A-5467
(ucs-set-char #x65E9 ?$BAa(B) ; J83-B-4161
(ucs-set-char #x65EA ?$(I#s(B) ; C03-I-2373
(ucs-set-char #x65EB ?$(I#r(B) ; C03-I-2372
(ucs-set-char #x65EC ?$(Cbb(B) ; KS0-C-6262
(ucs-set-char #x65EC ?$(GH0(B) ; C01-G-4830
(ucs-set-char #x65EC ?$@=\(B) ; J78-@-3D5C
(ucs-set-char #x65EC ?$AQ.(B) ; GB0-A-512E
(ucs-set-char #x65EC ?$B=\(B) ; J83-B-3D5C
(ucs-set-char #x65ED ?$(Cio(B) ; KS0-C-696F
(ucs-set-char #x65ED ?$(GH1(B) ; C01-G-4831
(ucs-set-char #x65ED ?$@00(B) ; J78-@-3030
(ucs-set-char #x65ED ?$APq(B) ; GB0-A-5071
(ucs-set-char #x65ED ?$B00(B) ; J83-B-3030
(ucs-set-char #x65EE ?$(H"O(B) ; C02-H-224F
(ucs-set-char #x65EE ?$Aj8(B) ; GB0-A-6A38
(ucs-set-char #x65EF ?$(H"N(B) ; C02-H-224E
(ucs-set-char #x65EF ?$Aj9(B) ; GB0-A-6A39
(ucs-set-char #x65F0 ?$(DAn(B) ; J90-D-416E
(ucs-set-char #x65F0 ?$(H$9(B) ; C02-H-2439
(ucs-set-char #x65F0 ?$Aj:(B) ; GB0-A-6A3A
(ucs-set-char #x65F1 ?$(CyQ(B) ; KS0-C-7951
(ucs-set-char #x65F1 ?$(GJT(B) ; C01-G-4A54
(ucs-set-char #x65F1 ?$@Z](B) ; J78-@-5A5D
(ucs-set-char #x65F1 ?$A:5(B) ; GB0-A-3A35
(ucs-set-char #x65F1 ?$BZ](B) ; J83-B-5A5D
(ucs-set-char #x65F2 ?$(DAo(B) ; J90-D-416F
(ucs-set-char #x65F2 ?$(H$<(B) ; C02-H-243C
(ucs-set-char #x65F3 ?$(H$;(B) ; C02-H-243B
(ucs-set-char #x65F4 ?$(CiY(B) ; KS0-C-6959
(ucs-set-char #x65F4 ?$(DAp(B) ; J90-D-4170
(ucs-set-char #x65F4 ?$(H$:(B) ; C02-H-243A
(ucs-set-char #x65F5 ?$(DAq(B) ; J90-D-4171
(ucs-set-char #x65F5 ?$(H$=(B) ; C02-H-243D
(ucs-set-char #x65F6 ?$(I&=(B) ; C03-I-263D
(ucs-set-char #x65F6 ?$AJ1(B) ; GB0-A-4A31
(ucs-set-char #x65F7 ?$A?u(B) ; GB0-A-3F75
(ucs-set-char #x65F9 ?$(DAr(B) ; J90-D-4172
(ucs-set-char #x65F9 ?$(J&b(B) ; C04-J-2662
(ucs-set-char #x65FA ?$(ChZ(B) ; KS0-C-685A
(ucs-set-char #x65FA ?$(GMv(B) ; C01-G-4D76
(ucs-set-char #x65FA ?$@2"(B) ; J78-@-3222
(ucs-set-char #x65FA ?$AMz(B) ; GB0-A-4D7A
(ucs-set-char #x65FA ?$B2"(B) ; J83-B-3222
(ucs-set-char #x65FB ?$(CZC(B) ; KS0-C-5A43
(ucs-set-char #x65FB ?$(H'*(B) ; C02-H-272A
(ucs-set-char #x65FB ?$@Za(B) ; J78-@-5A61
(ucs-set-char #x65FB ?$BZa(B) ; J83-B-5A61
(ucs-set-char #x65FC ?$(CZD(B) ; KS0-C-5A44
(ucs-set-char #x65FC ?$(H'&(B) ; C02-H-2726
(ucs-set-char #x65FD ?$(CTE(B) ; KS0-C-5445
(ucs-set-char #x65FD ?$(H'/(B) ; C02-H-272F
(ucs-set-char #x65FE ?$(DAs(B) ; J90-D-4173
(ucs-set-char #x65FE ?$(I)C(B) ; C03-I-2943
(ucs-set-char #x65FF ?$(Cgz(B) ; KS0-C-677A
(ucs-set-char #x65FF ?$(DAt(B) ; J90-D-4174
(ucs-set-char #x65FF ?$(I)>(B) ; C03-I-293E
(ucs-set-char #x6600 ?$(DAu(B) ; J90-D-4175
(ucs-set-char #x6600 ?$(GM}(B) ; C01-G-4D7D
(ucs-set-char #x6600 ?$Aj@(B) ; GB0-A-6A40
(ucs-set-char #x6601 ?$(I)B(B) ; C03-I-2942
(ucs-set-char #x6602 ?$(GM{(B) ; C01-G-4D7B
(ucs-set-char #x6602 ?$A0:(B) ; GB0-A-303A
(ucs-set-char #x6602 ?$B97(B) ; J83-B-3937
(ucs-set-char #x6603 ?$(H'+(B) ; C02-H-272B
(ucs-set-char #x6603 ?$@Z`(B) ; J78-@-5A60
(ucs-set-char #x6603 ?$Aj>(B) ; GB0-A-6A3E
(ucs-set-char #x6603 ?$BZ`(B) ; J83-B-5A60
(ucs-set-char #x6604 ?$(DAv(B) ; J90-D-4176
(ucs-set-char #x6604 ?$(H''(B) ; C02-H-2727
(ucs-set-char #x6605 ?$(H'.(B) ; C02-H-272E
(ucs-set-char #x6606 ?$(CM`(B) ; KS0-C-4D60
(ucs-set-char #x6606 ?$(GMz(B) ; C01-G-4D7A
(ucs-set-char #x6606 ?$@:+(B) ; J78-@-3A2B
(ucs-set-char #x6606 ?$A@%(B) ; GB0-A-4025
(ucs-set-char #x6606 ?$B:+(B) ; J83-B-3A2B
(ucs-set-char #x6607 ?$(Cc0(B) ; KS0-C-6330
(ucs-set-char #x6607 ?$(GN#(B) ; C01-G-4E23
(ucs-set-char #x6607 ?$@>:(B) ; J78-@-3E3A
(ucs-set-char #x6607 ?$B>:(B) ; J83-B-3E3A
(ucs-set-char #x6608 ?$(DAw(B) ; J90-D-4177
(ucs-set-char #x6608 ?$(H')(B) ; C02-H-2729
(ucs-set-char #x6609 ?$(C[2(B) ; KS0-C-5B32
(ucs-set-char #x6609 ?$(DAx(B) ; J90-D-4178
(ucs-set-char #x6609 ?$(H'%(B) ; C02-H-2725
(ucs-set-char #x660A ?$(C{D(B) ; KS0-C-7B44
(ucs-set-char #x660A ?$(GN"(B) ; C01-G-4E22
(ucs-set-char #x660A ?$@Z_(B) ; J78-@-5A5F
(ucs-set-char #x660A ?$Aj;(B) ; GB0-A-6A3B
(ucs-set-char #x660A ?$BZ_(B) ; J83-B-5A5F
(ucs-set-char #x660B ?$(H',(B) ; C02-H-272C
(ucs-set-char #x660C ?$(Csc(B) ; KS0-C-7363
(ucs-set-char #x660C ?$(GMy(B) ; C01-G-4D79
(ucs-set-char #x660C ?$@>;(B) ; J78-@-3E3B
(ucs-set-char #x660C ?$A2}(B) ; GB0-A-327D
(ucs-set-char #x660C ?$B>;(B) ; J83-B-3E3B
(ucs-set-char #x660D ?$(DAy(B) ; J90-D-4179
(ucs-set-char #x660D ?$(H'-(B) ; C02-H-272D
(ucs-set-char #x660E ?$(CY%(B) ; KS0-C-5925
(ucs-set-char #x660E ?$(GM|(B) ; C01-G-4D7C
(ucs-set-char #x660E ?$@L@(B) ; J78-@-4C40
(ucs-set-char #x660E ?$ACw(B) ; GB0-A-4377
(ucs-set-char #x660E ?$BL@(B) ; J83-B-4C40
(ucs-set-char #x660F ?$(C{g(B) ; KS0-C-7B67
(ucs-set-char #x660F ?$(GM~(B) ; C01-G-4D7E
(ucs-set-char #x660F ?$@:*(B) ; J78-@-3A2A
(ucs-set-char #x660F ?$A;h(B) ; GB0-A-3B68
(ucs-set-char #x660F ?$B:*(B) ; J83-B-3A2A
(ucs-set-char #x6610 ?$(C]K(B) ; KS0-C-5D4B
(ucs-set-char #x6610 ?$(H'1(B) ; C02-H-2731
(ucs-set-char #x6611 ?$(CPT(B) ; KS0-C-5054
(ucs-set-char #x6611 ?$(DAz(B) ; J90-D-417A
(ucs-set-char #x6611 ?$(H'0(B) ; C02-H-2730
(ucs-set-char #x6612 ?$(DA{(B) ; J90-D-417B
(ucs-set-char #x6612 ?$(H'((B) ; C02-H-2728
(ucs-set-char #x6613 ?$(Cf6(B) ; KS0-C-6636
(ucs-set-char #x6613 ?$(GMx(B) ; C01-G-4D78
(ucs-set-char #x6613 ?$@0W(B) ; J78-@-3057
(ucs-set-char #x6613 ?$ARW(B) ; GB0-A-5257
(ucs-set-char #x6613 ?$B0W(B) ; J83-B-3057
(ucs-set-char #x6614 ?$(C`.(B) ; KS0-C-602E
(ucs-set-char #x6614 ?$(GMw(B) ; C01-G-4D77
(ucs-set-char #x6614 ?$@@N(B) ; J78-@-404E
(ucs-set-char #x6614 ?$ANt(B) ; GB0-A-4E74
(ucs-set-char #x6614 ?$B@N(B) ; J83-B-404E
(ucs-set-char #x6615 ?$(C}Z(B) ; KS0-C-7D5A
(ucs-set-char #x6615 ?$(DA|(B) ; J90-D-417C
(ucs-set-char #x6615 ?$(GN!(B) ; C01-G-4E21
(ucs-set-char #x6615 ?$Aj?(B) ; GB0-A-6A3F
(ucs-set-char #x6616 ?$(DA}(B) ; J90-D-417D
(ucs-set-char #x6616 ?$(J&a(B) ; C04-J-2661
(ucs-set-char #x6617 ?$(I)@(B) ; C03-I-2940
(ucs-set-char #x6618 ?$(I)A(B) ; C03-I-2941
(ucs-set-char #x6619 ?$Aj<(B) ; GB0-A-6A3C
(ucs-set-char #x661A ?$(I,~(B) ; C03-I-2C7E
(ucs-set-char #x661B ?$(I,z(B) ; C03-I-2C7A
(ucs-set-char #x661C ?$(H*p(B) ; C02-H-2A70
(ucs-set-char #x661C ?$@Zf(B) ; J78-@-5A66
(ucs-set-char #x661C ?$BZf(B) ; J83-B-5A66
(ucs-set-char #x661D ?$(DA~(B) ; J90-D-417E
(ucs-set-char #x661D ?$(H*v(B) ; C02-H-2A76
(ucs-set-char #x661D ?$AjC(B) ; GB0-A-6A43
(ucs-set-char #x661E ?$(C\5(B) ; KS0-C-5C35
(ucs-set-char #x661E ?$(DB!(B) ; J90-D-4221
(ucs-set-char #x661E ?$(I-#(B) ; C03-I-2D23
(ucs-set-char #x661F ?$(C`x(B) ; KS0-C-6078
(ucs-set-char #x661F ?$(GQS(B) ; C01-G-5153
(ucs-set-char #x661F ?$@@1(B) ; J78-@-4031
(ucs-set-char #x661F ?$APG(B) ; GB0-A-5047
(ucs-set-char #x661F ?$B@1(B) ; J83-B-4031
(ucs-set-char #x6620 ?$(Cg1(B) ; KS0-C-6731
(ucs-set-char #x6620 ?$(GQP(B) ; C01-G-5150
(ucs-set-char #x6620 ?$@1G(B) ; J78-@-3147
(ucs-set-char #x6620 ?$AS3(B) ; GB0-A-5333
(ucs-set-char #x6620 ?$B1G(B) ; J83-B-3147
(ucs-set-char #x6621 ?$(DB"(B) ; J90-D-4222
(ucs-set-char #x6621 ?$(H*m(B) ; C02-H-2A6D
(ucs-set-char #x6622 ?$(DB#(B) ; J90-D-4223
(ucs-set-char #x6622 ?$(H*r(B) ; C02-H-2A72
(ucs-set-char #x6623 ?$(DB$(B) ; J90-D-4224
(ucs-set-char #x6623 ?$(I,|(B) ; C03-I-2C7C
(ucs-set-char #x6624 ?$(DB%(B) ; J90-D-4225
(ucs-set-char #x6624 ?$(GQV(B) ; C01-G-5156
(ucs-set-char #x6625 ?$(Cup(B) ; KS0-C-7570
(ucs-set-char #x6625 ?$(GQN(B) ; C01-G-514E
(ucs-set-char #x6625 ?$@=U(B) ; J78-@-3D55
(ucs-set-char #x6625 ?$A4:(B) ; GB0-A-343A
(ucs-set-char #x6625 ?$B=U(B) ; J83-B-3D55
(ucs-set-char #x6626 ?$(DB&(B) ; J90-D-4226
(ucs-set-char #x6626 ?$(H*q(B) ; C02-H-2A71
(ucs-set-char #x6627 ?$(CX\(B) ; KS0-C-585C
(ucs-set-char #x6627 ?$(GQQ(B) ; C01-G-5151
(ucs-set-char #x6627 ?$@Kf(B) ; J78-@-4B66
(ucs-set-char #x6627 ?$ACA(B) ; GB0-A-4341
(ucs-set-char #x6627 ?$BKf(B) ; J83-B-4B66
(ucs-set-char #x6628 ?$(CmF(B) ; KS0-C-6D46
(ucs-set-char #x6628 ?$(GQT(B) ; C01-G-5154
(ucs-set-char #x6628 ?$@:r(B) ; J78-@-3A72
(ucs-set-char #x6628 ?$AWr(B) ; GB0-A-5772
(ucs-set-char #x6628 ?$B:r(B) ; J83-B-3A72
(ucs-set-char #x6629 ?$(DB'(B) ; J90-D-4227
(ucs-set-char #x6629 ?$(I,y(B) ; C03-I-2C79
(ucs-set-char #x662A ?$(DB((B) ; J90-D-4228
(ucs-set-char #x662A ?$(J)g(B) ; C04-J-2967
(ucs-set-char #x662B ?$(DB)(B) ; J90-D-4229
(ucs-set-char #x662B ?$(H*t(B) ; C02-H-2A74
(ucs-set-char #x662C ?$(DB*(B) ; J90-D-422A
(ucs-set-char #x662C ?$(I,}(B) ; C03-I-2C7D
(ucs-set-char #x662D ?$(Ca9(B) ; KS0-C-6139
(ucs-set-char #x662D ?$(GQO(B) ; C01-G-514F
(ucs-set-char #x662D ?$@><(B) ; J78-@-3E3C
(ucs-set-char #x662D ?$AUQ(B) ; GB0-A-5551
(ucs-set-char #x662D ?$B><(B) ; J83-B-3E3C
(ucs-set-char #x662E ?$(DB+(B) ; J90-D-422B
(ucs-set-char #x662E ?$(H*y(B) ; C02-H-2A79
(ucs-set-char #x662F ?$(Cc@(B) ; KS0-C-6340
(ucs-set-char #x662F ?$(GQR(B) ; C01-G-5152
(ucs-set-char #x662F ?$@@'(B) ; J78-@-4027
(ucs-set-char #x662F ?$AJG(B) ; GB0-A-4A47
(ucs-set-char #x662F ?$B@'(B) ; J83-B-4027
(ucs-set-char #x6630 ?$(Cy@(B) ; KS0-C-7940
(ucs-set-char #x6630 ?$(DB,(B) ; J90-D-422C
(ucs-set-char #x6630 ?$(I-!(B) ; C03-I-2D21
(ucs-set-char #x6631 ?$(Cip(B) ; KS0-C-6970
(ucs-set-char #x6631 ?$(DB-(B) ; J90-D-422D
(ucs-set-char #x6631 ?$(GQU(B) ; C01-G-5155
(ucs-set-char #x6631 ?$AjE(B) ; GB0-A-6A45
(ucs-set-char #x6632 ?$(H*n(B) ; C02-H-2A6E
(ucs-set-char #x6633 ?$(DB.(B) ; J90-D-422E
(ucs-set-char #x6633 ?$(H*s(B) ; C02-H-2A73
(ucs-set-char #x6634 ?$(CY[(B) ; KS0-C-595B
(ucs-set-char #x6634 ?$(H*w(B) ; C02-H-2A77
(ucs-set-char #x6634 ?$@Ze(B) ; J78-@-5A65
(ucs-set-char #x6634 ?$AjD(B) ; GB0-A-6A44
(ucs-set-char #x6634 ?$BZe(B) ; J83-B-5A65
(ucs-set-char #x6635 ?$(H*o(B) ; C02-H-2A6F
(ucs-set-char #x6635 ?$@Zc(B) ; J78-@-5A63
(ucs-set-char #x6635 ?$AjG(B) ; GB0-A-6A47
(ucs-set-char #x6635 ?$BZc(B) ; J83-B-5A63
(ucs-set-char #x6636 ?$(Csd(B) ; KS0-C-7364
(ucs-set-char #x6636 ?$(H*l(B) ; C02-H-2A6C
(ucs-set-char #x6636 ?$@Zd(B) ; J78-@-5A64
(ucs-set-char #x6636 ?$AjF(B) ; GB0-A-6A46
(ucs-set-char #x6636 ?$BZd(B) ; J83-B-5A64
(ucs-set-char #x6637 ?$(DB0(B) ; J90-D-4230
(ucs-set-char #x6637 ?$(I-$(B) ; C03-I-2D24
(ucs-set-char #x6638 ?$(I-%(B) ; C03-I-2D25
(ucs-set-char #x6639 ?$(DB/(B) ; J90-D-422F
(ucs-set-char #x6639 ?$(H*x(B) ; C02-H-2A78
(ucs-set-char #x663A ?$(C\6(B) ; KS0-C-5C36
(ucs-set-char #x663A ?$(H*u(B) ; C02-H-2A75
(ucs-set-char #x663B ?$(Cdi(B) ; KS0-C-6469
(ucs-set-char #x663B ?$(I-"(B) ; C03-I-2D22
(ucs-set-char #x663B ?$@97(B) ; J78-@-3937
(ucs-set-char #x663C ?$(I,7(B) ; C03-I-2C37
(ucs-set-char #x663C ?$@Ck(B) ; J78-@-436B
(ucs-set-char #x663C ?$AVg(B) ; GB0-A-5667
(ucs-set-char #x663C ?$BCk(B) ; J83-B-436B
(ucs-set-char #x663E ?$AOT(B) ; GB0-A-4F54
(ucs-set-char #x663F ?$@[&(B) ; J78-@-5B26
(ucs-set-char #x663F ?$B[&(B) ; J83-B-5B26
(ucs-set-char #x6640 ?$(DB1(B) ; J90-D-4231
(ucs-set-char #x6640 ?$(I1F(B) ; C03-I-3146
(ucs-set-char #x6641 ?$(CpE(B) ; KS0-C-7045
(ucs-set-char #x6641 ?$(GUr(B) ; C01-G-5572
(ucs-set-char #x6641 ?$@Zj(B) ; J78-@-5A6A
(ucs-set-char #x6641 ?$AjK(B) ; GB0-A-6A4B
(ucs-set-char #x6641 ?$BZj(B) ; J83-B-5A6A
(ucs-set-char #x6642 ?$(CcA(B) ; KS0-C-6341
(ucs-set-char #x6642 ?$(GUk(B) ; C01-G-556B
(ucs-set-char #x6642 ?$@;~(B) ; J78-@-3B7E
(ucs-set-char #x6642 ?$B;~(B) ; J83-B-3B7E
(ucs-set-char #x6643 ?$(C|L(B) ; KS0-C-7C4C
(ucs-set-char #x6643 ?$(GUn(B) ; C01-G-556E
(ucs-set-char #x6643 ?$@98(B) ; J78-@-3938
(ucs-set-char #x6643 ?$A;N(B) ; GB0-A-3B4E
(ucs-set-char #x6643 ?$B98(B) ; J83-B-3938
(ucs-set-char #x6644 ?$(C|M(B) ; KS0-C-7C4D
(ucs-set-char #x6644 ?$(I1L(B) ; C03-I-314C
(ucs-set-char #x6644 ?$@Zh(B) ; J78-@-5A68
(ucs-set-char #x6644 ?$BZh(B) ; J83-B-5A68
(ucs-set-char #x6645 ?$(DB2(B) ; J90-D-4232
(ucs-set-char #x6645 ?$(GUq(B) ; C01-G-5571
(ucs-set-char #x6646 ?$(DB3(B) ; J90-D-4233
(ucs-set-char #x6646 ?$(I1D(B) ; C03-I-3144
(ucs-set-char #x6647 ?$(H/W(B) ; C02-H-2F57
(ucs-set-char #x6648 ?$(I1I(B) ; C03-I-3149
(ucs-set-char #x6649 ?$(CrK(B) ; KS0-C-724B
(ucs-set-char #x6649 ?$(GUl(B) ; C01-G-556C
(ucs-set-char #x6649 ?$@Zi(B) ; J78-@-5A69
(ucs-set-char #x6649 ?$BZi(B) ; J83-B-5A69
(ucs-set-char #x664A ?$(DB4(B) ; J90-D-4234
(ucs-set-char #x664A ?$(H/U(B) ; C02-H-2F55
(ucs-set-char #x664B ?$(CrL(B) ; KS0-C-724C
(ucs-set-char #x664B ?$(I1H(B) ; C03-I-3148
(ucs-set-char #x664B ?$@?8(B) ; J78-@-3F38
(ucs-set-char #x664B ?$A=z(B) ; GB0-A-3D7A
(ucs-set-char #x664B ?$B?8(B) ; J83-B-3F38
(ucs-set-char #x664C ?$(DB5(B) ; J90-D-4235
(ucs-set-char #x664C ?$(GUp(B) ; C01-G-5570
(ucs-set-char #x664C ?$AIN(B) ; GB0-A-494E
(ucs-set-char #x664D ?$(I1M(B) ; C03-I-314D
(ucs-set-char #x664E ?$(DB7(B) ; J90-D-4237
(ucs-set-char #x664E ?$(I1E(B) ; C03-I-3145
(ucs-set-char #x664F ?$(CdO(B) ; KS0-C-644F
(ucs-set-char #x664F ?$(GUm(B) ; C01-G-556D
(ucs-set-char #x664F ?$@Zg(B) ; J78-@-5A67
(ucs-set-char #x664F ?$AjL(B) ; GB0-A-6A4C
(ucs-set-char #x664F ?$BZg(B) ; J83-B-5A67
(ucs-set-char #x6650 ?$(I1C(B) ; C03-I-3143
(ucs-set-char #x6651 ?$(DB6(B) ; J90-D-4236
(ucs-set-char #x6651 ?$(H/X(B) ; C02-H-2F58
(ucs-set-char #x6652 ?$(GUo(B) ; C01-G-556F
(ucs-set-char #x6652 ?$@;/(B) ; J78-@-3B2F
(ucs-set-char #x6652 ?$AI9(B) ; GB0-A-4939
(ucs-set-char #x6652 ?$B;/(B) ; J83-B-3B2F
(ucs-set-char #x6653 ?$AO~(B) ; GB0-A-4F7E
(ucs-set-char #x6654 ?$AjJ(B) ; GB0-A-6A4A
(ucs-set-char #x6655 ?$ATN(B) ; GB0-A-544E
(ucs-set-char #x6656 ?$AjM(B) ; GB0-A-6A4D
(ucs-set-char #x6657 ?$(DB8(B) ; J90-D-4238
(ucs-set-char #x6657 ?$(I6B(B) ; C03-I-3642
(ucs-set-char #x6657 ?$AjO(B) ; GB0-A-6A4F
(ucs-set-char #x6658 ?$(DB9(B) ; J90-D-4239
(ucs-set-char #x6658 ?$(J29(B) ; C04-J-3239
(ucs-set-char #x6659 ?$(Cq[(B) ; KS0-C-715B
(ucs-set-char #x6659 ?$(DB:(B) ; J90-D-423A
(ucs-set-char #x6659 ?$(H5n(B) ; C02-H-356E
(ucs-set-char #x665A ?$(G[%(B) ; C01-G-5B25
(ucs-set-char #x665A ?$AMm(B) ; GB0-A-4D6D
(ucs-set-char #x665B ?$(CzY(B) ; KS0-C-7A59
(ucs-set-char #x665B ?$(DB;(B) ; J90-D-423B
(ucs-set-char #x665B ?$(H5m(B) ; C02-H-356D
(ucs-set-char #x665C ?$(DB<(B) ; J90-D-423C
(ucs-set-char #x665C ?$(H5o(B) ; C02-H-356F
(ucs-set-char #x665D ?$(Cq8(B) ; KS0-C-7138
(ucs-set-char #x665D ?$(G[$(B) ; C01-G-5B24
(ucs-set-char #x665D ?$@Zl(B) ; J78-@-5A6C
(ucs-set-char #x665D ?$BZl(B) ; J83-B-5A6C
(ucs-set-char #x665E ?$(C}u(B) ; KS0-C-7D75
(ucs-set-char #x665E ?$(G[)(B) ; C01-G-5B29
(ucs-set-char #x665E ?$@Zk(B) ; J78-@-5A6B
(ucs-set-char #x665E ?$BZk(B) ; J83-B-5A6B
(ucs-set-char #x665F ?$(C`y(B) ; KS0-C-6079
(ucs-set-char #x665F ?$(H/V(B) ; C02-H-2F56
(ucs-set-char #x665F ?$@Zp(B) ; J78-@-5A70
(ucs-set-char #x665F ?$AjI(B) ; GB0-A-6A49
(ucs-set-char #x665F ?$BZp(B) ; J83-B-5A70
(ucs-set-char #x6660 ?$(DB=(B) ; J90-D-423D
(ucs-set-char #x6660 ?$(I1K(B) ; C03-I-314B
(ucs-set-char #x6661 ?$(DB>(B) ; J90-D-423E
(ucs-set-char #x6661 ?$(H5l(B) ; C02-H-356C
(ucs-set-char #x6661 ?$AjN(B) ; GB0-A-6A4E
(ucs-set-char #x6662 ?$(H5p(B) ; C02-H-3570
(ucs-set-char #x6662 ?$@Zq(B) ; J78-@-5A71
(ucs-set-char #x6662 ?$BZq(B) ; J83-B-5A71
(ucs-set-char #x6663 ?$(I6D(B) ; C03-I-3644
(ucs-set-char #x6664 ?$(Cg{(B) ; KS0-C-677B
(ucs-set-char #x6664 ?$(G[&(B) ; C01-G-5B26
(ucs-set-char #x6664 ?$@Zm(B) ; J78-@-5A6D
(ucs-set-char #x6664 ?$ANn(B) ; GB0-A-4E6E
(ucs-set-char #x6664 ?$BZm(B) ; J83-B-5A6D
(ucs-set-char #x6665 ?$(C|7(B) ; KS0-C-7C37
(ucs-set-char #x6665 ?$(H5k(B) ; C02-H-356B
(ucs-set-char #x6666 ?$(C|d(B) ; KS0-C-7C64
(ucs-set-char #x6666 ?$(G[((B) ; C01-G-5B28
(ucs-set-char #x6666 ?$@3"(B) ; J78-@-3322
(ucs-set-char #x6666 ?$A;^(B) ; GB0-A-3B5E
(ucs-set-char #x6666 ?$B3"(B) ; J83-B-3322
(ucs-set-char #x6667 ?$(C{E(B) ; KS0-C-7B45
(ucs-set-char #x6667 ?$(I6E(B) ; C03-I-3645
(ucs-set-char #x6667 ?$@Zn(B) ; J78-@-5A6E
(ucs-set-char #x6667 ?$BZn(B) ; J83-B-5A6E
(ucs-set-char #x6668 ?$(Ccg(B) ; KS0-C-6367
(ucs-set-char #x6668 ?$(G['(B) ; C01-G-5B27
(ucs-set-char #x6668 ?$@Zo(B) ; J78-@-5A6F
(ucs-set-char #x6668 ?$A3?(B) ; GB0-A-333F
(ucs-set-char #x6668 ?$BZo(B) ; J83-B-5A6F
(ucs-set-char #x6669 ?$(CX9(B) ; KS0-C-5839
(ucs-set-char #x6669 ?$(I<&(B) ; C03-I-3C26
(ucs-set-char #x6669 ?$@HU(B) ; J78-@-4855
(ucs-set-char #x6669 ?$BHU(B) ; J83-B-4855
(ucs-set-char #x666A ?$(DB@(B) ; J90-D-4240
(ucs-set-char #x666A ?$(H<J(B) ; C02-H-3C4A
(ucs-set-char #x666B ?$(Cvx(B) ; KS0-C-7678
(ucs-set-char #x666B ?$(DBA(B) ; J90-D-4241
(ucs-set-char #x666B ?$(I;}(B) ; C03-I-3B7D
(ucs-set-char #x666C ?$(DBB(B) ; J90-D-4242
(ucs-set-char #x666C ?$(H<E(B) ; C02-H-3C45
(ucs-set-char #x666D ?$(I<%(B) ; C03-I-3C25
(ucs-set-char #x666E ?$(C\E(B) ; KS0-C-5C45
(ucs-set-char #x666E ?$(G_[(B) ; C01-G-5F5B
(ucs-set-char #x666E ?$@Ia(B) ; J78-@-4961
(ucs-set-char #x666E ?$AFU(B) ; GB0-A-4655
(ucs-set-char #x666E ?$BIa(B) ; J83-B-4961
(ucs-set-char #x666F ?$(CLX(B) ; KS0-C-4C58
(ucs-set-char #x666F ?$(G__(B) ; C01-G-5F5F
(ucs-set-char #x666F ?$@7J(B) ; J78-@-374A
(ucs-set-char #x666F ?$A>0(B) ; GB0-A-3E30
(ucs-set-char #x666F ?$B7J(B) ; J83-B-374A
(ucs-set-char #x6670 ?$(G_\(B) ; C01-G-5F5C
(ucs-set-char #x6670 ?$@Zr(B) ; J78-@-5A72
(ucs-set-char #x6670 ?$ANz(B) ; GB0-A-4E7A
(ucs-set-char #x6670 ?$BZr(B) ; J83-B-5A72
(ucs-set-char #x6671 ?$(H<H(B) ; C02-H-3C48
(ucs-set-char #x6672 ?$(H<K(B) ; C02-H-3C4B
(ucs-set-char #x6673 ?$(C`/(B) ; KS0-C-602F
(ucs-set-char #x6673 ?$(DBD(B) ; J90-D-4244
(ucs-set-char #x6673 ?$(I<#(B) ; C03-I-3C23
(ucs-set-char #x6674 ?$(Ctg(B) ; KS0-C-7467
(ucs-set-char #x6674 ?$(G_](B) ; C01-G-5F5D
(ucs-set-char #x6674 ?$@@2(B) ; J78-@-4032
(ucs-set-char #x6674 ?$AGg(B) ; GB0-A-4767
(ucs-set-char #x6674 ?$B@2(B) ; J83-B-4032
(ucs-set-char #x6675 ?$(DBE(B) ; J90-D-4245
(ucs-set-char #x6675 ?$(J8$(B) ; C04-J-3824
(ucs-set-char #x6676 ?$(Co\(B) ; KS0-C-6F5C
(ucs-set-char #x6676 ?$(G_^(B) ; C01-G-5F5E
(ucs-set-char #x6676 ?$@>=(B) ; J78-@-3E3D
(ucs-set-char #x6676 ?$A>'(B) ; GB0-A-3E27
(ucs-set-char #x6676 ?$B>=(B) ; J83-B-3E3D
(ucs-set-char #x6677 ?$(CO|(B) ; KS0-C-4F7C
(ucs-set-char #x6677 ?$(DBG(B) ; J90-D-4247
(ucs-set-char #x6677 ?$(G_c(B) ; C01-G-5F63
(ucs-set-char #x6677 ?$AjP(B) ; GB0-A-6A50
(ucs-set-char #x6678 ?$(Co](B) ; KS0-C-6F5D
(ucs-set-char #x6678 ?$(DBH(B) ; J90-D-4248
(ucs-set-char #x6678 ?$(HCM(B) ; C02-H-434D
(ucs-set-char #x6679 ?$(DBI(B) ; J90-D-4249
(ucs-set-char #x6679 ?$(H<I(B) ; C02-H-3C49
(ucs-set-char #x667A ?$(Cr*(B) ; KS0-C-722A
(ucs-set-char #x667A ?$(G_a(B) ; C01-G-5F61
(ucs-set-char #x667A ?$@CR(B) ; J78-@-4352
(ucs-set-char #x667A ?$AVG(B) ; GB0-A-5647
(ucs-set-char #x667A ?$BCR(B) ; J83-B-4352
(ucs-set-char #x667B ?$(DBJ(B) ; J90-D-424A
(ucs-set-char #x667B ?$(H<F(B) ; C02-H-3C46
(ucs-set-char #x667C ?$(DBL(B) ; J90-D-424C
(ucs-set-char #x667C ?$(H<D(B) ; C02-H-3C44
(ucs-set-char #x667D ?$(I;|(B) ; C03-I-3B7C
(ucs-set-char #x667E ?$(DBC(B) ; J90-D-4243
(ucs-set-char #x667E ?$(G_b(B) ; C01-G-5F62
(ucs-set-char #x667E ?$AA@(B) ; GB0-A-4140
(ucs-set-char #x667F ?$(DBF(B) ; J90-D-4246
(ucs-set-char #x667F ?$(I;~(B) ; C03-I-3B7E
(ucs-set-char #x6680 ?$(DBK(B) ; J90-D-424B
(ucs-set-char #x6680 ?$(H<G(B) ; C02-H-3C47
(ucs-set-char #x6681 ?$(I<$(B) ; C03-I-3C24
(ucs-set-char #x6681 ?$@6G(B) ; J78-@-3647
(ucs-set-char #x6681 ?$B6G(B) ; J83-B-3647
(ucs-set-char #x6682 ?$AT](B) ; GB0-A-545D
(ucs-set-char #x6683 ?$@Zs(B) ; J78-@-5A73
(ucs-set-char #x6683 ?$BZs(B) ; J83-B-5A73
(ucs-set-char #x6684 ?$(C}>(B) ; KS0-C-7D3E
(ucs-set-char #x6684 ?$(GdA(B) ; C01-G-6441
(ucs-set-char #x6684 ?$@Zw(B) ; J78-@-5A77
(ucs-set-char #x6684 ?$AjQ(B) ; GB0-A-6A51
(ucs-set-char #x6684 ?$BZw(B) ; J83-B-5A77
(ucs-set-char #x6685 ?$(J=i(B) ; C04-J-3D69
(ucs-set-char #x6686 ?$(HCE(B) ; C02-H-4345
(ucs-set-char #x6687 ?$(CJ,(B) ; KS0-C-4A2C
(ucs-set-char #x6687 ?$(Gd>(B) ; C01-G-643E
(ucs-set-char #x6687 ?$@2K(B) ; J78-@-324B
(ucs-set-char #x6687 ?$AO>(B) ; GB0-A-4F3E
(ucs-set-char #x6687 ?$B2K(B) ; J83-B-324B
(ucs-set-char #x6688 ?$(C};(B) ; KS0-C-7D3B
(ucs-set-char #x6688 ?$(Gd?(B) ; C01-G-643F
(ucs-set-char #x6688 ?$@Zt(B) ; J78-@-5A74
(ucs-set-char #x6688 ?$BZt(B) ; J83-B-5A74
(ucs-set-char #x6689 ?$(C}G(B) ; KS0-C-7D47
(ucs-set-char #x6689 ?$(Gd=(B) ; C01-G-643D
(ucs-set-char #x6689 ?$@Zv(B) ; J78-@-5A76
(ucs-set-char #x6689 ?$BZv(B) ; J83-B-5A76
(ucs-set-char #x668A ?$(HCJ(B) ; C02-H-434A
(ucs-set-char #x668B ?$(DBM(B) ; J90-D-424D
(ucs-set-char #x668B ?$(HCI(B) ; C02-H-4349
(ucs-set-char #x668C ?$(DBN(B) ; J90-D-424E
(ucs-set-char #x668C ?$(HCF(B) ; C02-H-4346
(ucs-set-char #x668C ?$AjR(B) ; GB0-A-6A52
(ucs-set-char #x668D ?$(DBO(B) ; J90-D-424F
(ucs-set-char #x668D ?$(GdC(B) ; C01-G-6443
(ucs-set-char #x668E ?$(Cg2(B) ; KS0-C-6732
(ucs-set-char #x668E ?$(IA[(B) ; C03-I-415B
(ucs-set-char #x668E ?$@Zu(B) ; J78-@-5A75
(ucs-set-char #x668E ?$BZu(B) ; J83-B-5A75
(ucs-set-char #x668F ?$(IAV(B) ; C03-I-4156
(ucs-set-char #x6690 ?$(CjQ(B) ; KS0-C-6A51
(ucs-set-char #x6690 ?$(DBP(B) ; J90-D-4250
(ucs-set-char #x6690 ?$(HCH(B) ; C02-H-4348
(ucs-set-char #x6691 ?$(C_t(B) ; KS0-C-5F74
(ucs-set-char #x6691 ?$(G_`(B) ; C01-G-5F60
(ucs-set-char #x6691 ?$(LS<(B) ; C06-L-533C
(ucs-set-char #x6691 ?$@=k(B) ; J78-@-3D6B
(ucs-set-char #x6691 ?$AJn(B) ; GB0-A-4A6E
(ucs-set-char #x6691 ?$B=k(B) ; J83-B-3D6B
(ucs-set-char #x6692 ?$(DBQ(B) ; J90-D-4251
(ucs-set-char #x6692 ?$(IAY(B) ; C03-I-4159
(ucs-set-char #x6693 ?$(IAQ(B) ; C03-I-4151
(ucs-set-char #x6694 ?$(HCL(B) ; C02-H-434C
(ucs-set-char #x6695 ?$(HCG(B) ; C02-H-4347
(ucs-set-char #x6696 ?$(CQl(B) ; KS0-C-516C
(ucs-set-char #x6696 ?$(Gd@(B) ; C01-G-6440
(ucs-set-char #x6696 ?$@CH(B) ; J78-@-4348
(ucs-set-char #x6696 ?$AE/(B) ; GB0-A-452F
(ucs-set-char #x6696 ?$BCH(B) ; J83-B-4348
(ucs-set-char #x6697 ?$(Cd^(B) ; KS0-C-645E
(ucs-set-char #x6697 ?$(Gd<(B) ; C01-G-643C
(ucs-set-char #x6697 ?$@0E(B) ; J78-@-3045
(ucs-set-char #x6697 ?$A05(B) ; GB0-A-3035
(ucs-set-char #x6697 ?$B0E(B) ; J83-B-3045
(ucs-set-char #x6698 ?$(CeC(B) ; KS0-C-6543
(ucs-set-char #x6698 ?$(GdB(B) ; C01-G-6442
(ucs-set-char #x6698 ?$@Zx(B) ; J78-@-5A78
(ucs-set-char #x6698 ?$BZx(B) ; J83-B-5A78
(ucs-set-char #x6699 ?$(DBR(B) ; J90-D-4252
(ucs-set-char #x6699 ?$(HCK(B) ; C02-H-434B
(ucs-set-char #x669A ?$(DBS(B) ; J90-D-4253
(ucs-set-char #x669A ?$(IG4(B) ; C03-I-4734
(ucs-set-char #x669B ?$(DBT(B) ; J90-D-4254
(ucs-set-char #x669B ?$(JCk(B) ; C04-J-436B
(ucs-set-char #x669C ?$(DBU(B) ; J90-D-4255
(ucs-set-char #x669C ?$(IG5(B) ; C03-I-4735
(ucs-set-char #x669D ?$(CY&(B) ; KS0-C-5926
(ucs-set-char #x669D ?$(Gi%(B) ; C01-G-6925
(ucs-set-char #x669D ?$@Zy(B) ; J78-@-5A79
(ucs-set-char #x669D ?$AjT(B) ; GB0-A-6A54
(ucs-set-char #x669D ?$BZy(B) ; J83-B-5A79
(ucs-set-char #x669E ?$(JCo(B) ; C04-J-436F
(ucs-set-char #x669F ?$(DBV(B) ; J90-D-4256
(ucs-set-char #x669F ?$(HJ_(B) ; C02-H-4A5F
(ucs-set-char #x66A0 ?$(CM<(B) ; KS0-C-4D3C
(ucs-set-char #x66A0 ?$(DBW(B) ; J90-D-4257
(ucs-set-char #x66A0 ?$(HJ^(B) ; C02-H-4A5E
(ucs-set-char #x66A1 ?$(HJ](B) ; C02-H-4A5D
(ucs-set-char #x66A2 ?$(Cse(B) ; KS0-C-7365
(ucs-set-char #x66A2 ?$(Gi#(B) ; C01-G-6923
(ucs-set-char #x66A2 ?$@D*(B) ; J78-@-442A
(ucs-set-char #x66A2 ?$BD*(B) ; J83-B-442A
(ucs-set-char #x66A3 ?$(JCm(B) ; C04-J-436D
(ucs-set-char #x66A4 ?$(DBX(B) ; J90-D-4258
(ucs-set-char #x66A4 ?$(IG9(B) ; C03-I-4739
(ucs-set-char #x66A5 ?$(IG3(B) ; C03-I-4733
(ucs-set-char #x66A6 ?$(IG7(B) ; C03-I-4737
(ucs-set-char #x66A6 ?$@Nq(B) ; J78-@-4E71
(ucs-set-char #x66A6 ?$BNq(B) ; J83-B-4E71
(ucs-set-char #x66A7 ?$AjS(B) ; GB0-A-6A53
(ucs-set-char #x66A8 ?$(Gi$(B) ; C01-G-6924
(ucs-set-char #x66A8 ?$At_(B) ; GB0-A-745F
(ucs-set-char #x66A9 ?$(HPl(B) ; C02-H-506C
(ucs-set-char #x66AA ?$(HPo(B) ; C02-H-506F
(ucs-set-char #x66AB ?$(CmU(B) ; KS0-C-6D55
(ucs-set-char #x66AB ?$(Gm2(B) ; C01-G-6D32
(ucs-set-char #x66AB ?$@;C(B) ; J78-@-3B43
(ucs-set-char #x66AB ?$B;C(B) ; J83-B-3B43
(ucs-set-char #x66AC ?$(ILD(B) ; C03-I-4C44
(ucs-set-char #x66AD ?$(DBY(B) ; J90-D-4259
(ucs-set-char #x66AD ?$(ILF(B) ; C03-I-4C46
(ucs-set-char #x66AE ?$(CY:(B) ; KS0-C-593A
(ucs-set-char #x66AE ?$(Gm1(B) ; C01-G-6D31
(ucs-set-char #x66AE ?$@Jk(B) ; J78-@-4A6B
(ucs-set-char #x66AE ?$AD:(B) ; GB0-A-443A
(ucs-set-char #x66AE ?$BJk(B) ; J83-B-4A6B
(ucs-set-char #x66AF ?$(HPp(B) ; C02-H-5070
(ucs-set-char #x66B0 ?$(HPk(B) ; C02-H-506B
(ucs-set-char #x66B1 ?$(DBZ(B) ; J90-D-425A
(ucs-set-char #x66B1 ?$(Gm4(B) ; C01-G-6D34
(ucs-set-char #x66B2 ?$(Cmg(B) ; KS0-C-6D67
(ucs-set-char #x66B2 ?$(DB[(B) ; J90-D-425B
(ucs-set-char #x66B2 ?$(HPm(B) ; C02-H-506D
(ucs-set-char #x66B3 ?$(C{5(B) ; KS0-C-7B35
(ucs-set-char #x66B3 ?$(ILA(B) ; C03-I-4C41
(ucs-set-char #x66B4 ?$(Cxl(B) ; KS0-C-786C
(ucs-set-char #x66B4 ?$(Gm3(B) ; C01-G-6D33
(ucs-set-char #x66B4 ?$@K=(B) ; J78-@-4B3D
(ucs-set-char #x66B4 ?$A1)(B) ; GB0-A-3129
(ucs-set-char #x66B4 ?$BK=(B) ; J83-B-4B3D
(ucs-set-char #x66B5 ?$(DB\(B) ; J90-D-425C
(ucs-set-char #x66B5 ?$(HPj(B) ; C02-H-506A
(ucs-set-char #x66B6 ?$(IL@(B) ; C03-I-4C40
(ucs-set-char #x66B7 ?$(HPn(B) ; C02-H-506E
(ucs-set-char #x66B8 ?$(Gpr(B) ; C01-G-7072
(ucs-set-char #x66B8 ?$@["(B) ; J78-@-5B22
(ucs-set-char #x66B8 ?$B["(B) ; J83-B-5B22
(ucs-set-char #x66B9 ?$(C`g(B) ; KS0-C-6067
(ucs-set-char #x66B9 ?$(Gpo(B) ; C01-G-706F
(ucs-set-char #x66B9 ?$@Z{(B) ; J78-@-5A7B
(ucs-set-char #x66B9 ?$Ae_(B) ; GB0-A-655F
(ucs-set-char #x66B9 ?$BZ{(B) ; J83-B-5A7B
(ucs-set-char #x66BA ?$(HWF(B) ; C02-H-5746
(ucs-set-char #x66BB ?$(CLY(B) ; KS0-C-4C59
(ucs-set-char #x66BB ?$(DB](B) ; J90-D-425D
(ucs-set-char #x66BB ?$(HWE(B) ; C02-H-5745
(ucs-set-char #x66BC ?$(ILC(B) ; C03-I-4C43
(ucs-set-char #x66BC ?$@Z~(B) ; J78-@-5A7E
(ucs-set-char #x66BC ?$BZ~(B) ; J83-B-5A7E
(ucs-set-char #x66BD ?$(HWD(B) ; C02-H-5744
(ucs-set-char #x66BE ?$(CTF(B) ; KS0-C-5446
(ucs-set-char #x66BE ?$(HW?(B) ; C02-H-573F
(ucs-set-char #x66BE ?$@Z}(B) ; J78-@-5A7D
(ucs-set-char #x66BE ?$AjU(B) ; GB0-A-6A55
(ucs-set-char #x66BE ?$BZ}(B) ; J83-B-5A7D
(ucs-set-char #x66BF ?$(DB^(B) ; J90-D-425E
(ucs-set-char #x66BF ?$(IP}(B) ; C03-I-507D
(ucs-set-char #x66C0 ?$(DB_(B) ; J90-D-425F
(ucs-set-char #x66C0 ?$(HW@(B) ; C02-H-5740
(ucs-set-char #x66C1 ?$(IQ#(B) ; C03-I-5123
(ucs-set-char #x66C1 ?$@Zz(B) ; J78-@-5A7A
(ucs-set-char #x66C1 ?$BZz(B) ; J83-B-5A7A
(ucs-set-char #x66C2 ?$(DB`(B) ; J90-D-4260
(ucs-set-char #x66C2 ?$(JPP(B) ; C04-J-5050
(ucs-set-char #x66C3 ?$(DBa(B) ; J90-D-4261
(ucs-set-char #x66C3 ?$(IPz(B) ; C03-I-507A
(ucs-set-char #x66C4 ?$(Cg%(B) ; KS0-C-6725
(ucs-set-char #x66C4 ?$(Gpp(B) ; C01-G-7070
(ucs-set-char #x66C4 ?$@[!(B) ; J78-@-5B21
(ucs-set-char #x66C4 ?$B[!(B) ; J83-B-5B21
(ucs-set-char #x66C5 ?$(IP~(B) ; C03-I-507E
(ucs-set-char #x66C6 ?$(CUu(B) ; KS0-C-5575
(ucs-set-char #x66C6 ?$(Gpm(B) ; C01-G-706D
(ucs-set-char #x66C7 ?$(CS>(B) ; KS0-C-533E
(ucs-set-char #x66C7 ?$(Gpq(B) ; C01-G-7071
(ucs-set-char #x66C7 ?$@F^(B) ; J78-@-465E
(ucs-set-char #x66C7 ?$BF^(B) ; J83-B-465E
(ucs-set-char #x66C8 ?$(DBb(B) ; J90-D-4262
(ucs-set-char #x66C8 ?$(HW>(B) ; C02-H-573E
(ucs-set-char #x66C9 ?$(C|{(B) ; KS0-C-7C7B
(ucs-set-char #x66C9 ?$(Gpn(B) ; C01-G-706E
(ucs-set-char #x66C9 ?$@Z|(B) ; J78-@-5A7C
(ucs-set-char #x66C9 ?$BZ|(B) ; J83-B-5A7C
(ucs-set-char #x66CA ?$(HWA(B) ; C02-H-5741
(ucs-set-char #x66CB ?$(HWB(B) ; C02-H-5742
(ucs-set-char #x66CC ?$(DBc(B) ; J90-D-4263
(ucs-set-char #x66CC ?$(HWG(B) ; C02-H-5747
(ucs-set-char #x66CD ?$(IQ"(B) ; C03-I-5122
(ucs-set-char #x66CE ?$(DBd(B) ; J90-D-4264
(ucs-set-char #x66CE ?$(ITq(B) ; C03-I-5471
(ucs-set-char #x66CF ?$(DBe(B) ; J90-D-4265
(ucs-set-char #x66CF ?$(HWC(B) ; C02-H-5743
(ucs-set-char #x66D0 ?$(ITo(B) ; C03-I-546F
(ucs-set-char #x66D1 ?$(ITp(B) ; C03-I-5470
(ucs-set-char #x66D2 ?$(H\}(B) ; C02-H-5C7D
(ucs-set-char #x66D3 ?$(JVA(B) ; C04-J-5641
(ucs-set-char #x66D4 ?$(DBf(B) ; J90-D-4266
(ucs-set-char #x66D4 ?$(ITl(B) ; C03-I-546C
(ucs-set-char #x66D5 ?$(ITm(B) ; C03-I-546D
(ucs-set-char #x66D6 ?$(Cdr(B) ; KS0-C-6472
(ucs-set-char #x66D6 ?$(Gsp(B) ; C01-G-7370
(ucs-set-char #x66D6 ?$@[#(B) ; J78-@-5B23
(ucs-set-char #x66D6 ?$B[#(B) ; J83-B-5B23
(ucs-set-char #x66D7 ?$(ITr(B) ; C03-I-5472
(ucs-set-char #x66D8 ?$(Hah(B) ; C02-H-6168
(ucs-set-char #x66D9 ?$(C_u(B) ; KS0-C-5F75
(ucs-set-char #x66D9 ?$(Gso(B) ; C01-G-736F
(ucs-set-char #x66D9 ?$@=l(B) ; J78-@-3D6C
(ucs-set-char #x66D9 ?$AJo(B) ; GB0-A-4A6F
(ucs-set-char #x66D9 ?$B=l(B) ; J83-B-3D6C
(ucs-set-char #x66DA ?$(Haf(B) ; C02-H-6166
(ucs-set-char #x66DA ?$@[$(B) ; J78-@-5B24
(ucs-set-char #x66DA ?$B[$(B) ; J83-B-5B24
(ucs-set-char #x66DB ?$(DBg(B) ; J90-D-4267
(ucs-set-char #x66DB ?$(Hag(B) ; C02-H-6167
(ucs-set-char #x66DB ?$AjV(B) ; GB0-A-6A56
(ucs-set-char #x66DC ?$(Chx(B) ; KS0-C-6878
(ucs-set-char #x66DC ?$(GvL(B) ; C01-G-764C
(ucs-set-char #x66DC ?$@MK(B) ; J78-@-4D4B
(ucs-set-char #x66DC ?$AjW(B) ; GB0-A-6A57
(ucs-set-char #x66DC ?$BMK(B) ; J83-B-4D4B
(ucs-set-char #x66DD ?$(Cxm(B) ; KS0-C-786D
(ucs-set-char #x66DD ?$(Gx;(B) ; C01-G-783B
(ucs-set-char #x66DD ?$@Gx(B) ; J78-@-4778
(ucs-set-char #x66DD ?$AFX(B) ; GB0-A-4658
(ucs-set-char #x66DD ?$BGx(B) ; J83-B-4778
(ucs-set-char #x66DE ?$(HeV(B) ; C02-H-6556
(ucs-set-char #x66DF ?$(DBh(B) ; J90-D-4268
(ucs-set-char #x66DF ?$(IZC(B) ; C03-I-5A43
(ucs-set-char #x66E0 ?$(CNG(B) ; KS0-C-4E47
(ucs-set-char #x66E0 ?$(Gx:(B) ; C01-G-783A
(ucs-set-char #x66E0 ?$@[%(B) ; J78-@-5B25
(ucs-set-char #x66E0 ?$B[%(B) ; J83-B-5B25
(ucs-set-char #x66E1 ?$(IZB(B) ; C03-I-5A42
(ucs-set-char #x66E3 ?$(Hh}(B) ; C02-H-687D
(ucs-set-char #x66E4 ?$(Hh~(B) ; C02-H-687E
(ucs-set-char #x66E5 ?$(I\B(B) ; C03-I-5C42
(ucs-set-char #x66E6 ?$(C}v(B) ; KS0-C-7D76
(ucs-set-char #x66E6 ?$(Gyq(B) ; C01-G-7971
(ucs-set-char #x66E6 ?$@['(B) ; J78-@-5B27
(ucs-set-char #x66E6 ?$AjX(B) ; GB0-A-6A58
(ucs-set-char #x66E6 ?$B['(B) ; J83-B-5B27
(ucs-set-char #x66E7 ?$(I\C(B) ; C03-I-5C43
(ucs-set-char #x66E8 ?$(DBi(B) ; J90-D-4269
(ucs-set-char #x66E8 ?$(Hh|(B) ; C02-H-687C
(ucs-set-char #x66E9 ?$(Gzo(B) ; C01-G-7A6F
(ucs-set-char #x66E9 ?$@[((B) ; J78-@-5B28
(ucs-set-char #x66E9 ?$AjY(B) ; GB0-A-6A59
(ucs-set-char #x66E9 ?$B[((B) ; J83-B-5B28
(ucs-set-char #x66EA ?$(JjL(B) ; C04-J-6A4C
(ucs-set-char #x66EB ?$(DBj(B) ; J90-D-426A
(ucs-set-char #x66EB ?$(Ho.(B) ; C02-H-6F2E
(ucs-set-char #x66EC ?$(DBk(B) ; J90-D-426B
(ucs-set-char #x66EC ?$(G|:(B) ; C01-G-7C3A
(ucs-set-char #x66ED ?$(Hp8(B) ; C02-H-7038
(ucs-set-char #x66EE ?$(DBl(B) ; J90-D-426C
(ucs-set-char #x66EE ?$(Hp9(B) ; C02-H-7039
(ucs-set-char #x66EF ?$(Ia?(B) ; C03-I-613F
(ucs-set-char #x66F0 ?$(ChX(B) ; KS0-C-6858
(ucs-set-char #x66F0 ?$(GEK(B) ; C01-G-454B
(ucs-set-char #x66F0 ?$@[)(B) ; J78-@-5B29
(ucs-set-char #x66F0 ?$AT;(B) ; GB0-A-543B
(ucs-set-char #x66F0 ?$B[)(B) ; J83-B-5B29
(ucs-set-char #x66F1 ?$(J!|(B) ; C04-J-217C
(ucs-set-char #x66F2 ?$(CMX(B) ; KS0-C-4D58
(ucs-set-char #x66F2 ?$(GH2(B) ; C01-G-4832
(ucs-set-char #x66F2 ?$@6J(B) ; J78-@-364A
(ucs-set-char #x66F2 ?$AGz(B) ; GB0-A-477A
(ucs-set-char #x66F2 ?$B6J(B) ; J83-B-364A
(ucs-set-char #x66F3 ?$(CgV(B) ; KS0-C-6756
(ucs-set-char #x66F3 ?$(GH3(B) ; C01-G-4833
(ucs-set-char #x66F3 ?$@1H(B) ; J78-@-3148
(ucs-set-char #x66F3 ?$AR7(B) ; GB0-A-5237
(ucs-set-char #x66F3 ?$B1H(B) ; J83-B-3148
(ucs-set-char #x66F4 ?$(CLZ(B) ; KS0-C-4C5A
(ucs-set-char #x66F4 ?$(GJU(B) ; C01-G-4A55
(ucs-set-char #x66F4 ?$@99(B) ; J78-@-3939
(ucs-set-char #x66F4 ?$A8|(B) ; GB0-A-387C
(ucs-set-char #x66F4 ?$B99(B) ; J83-B-3939
(ucs-set-char #x66F5 ?$(I&A(B) ; C03-I-2641
(ucs-set-char #x66F5 ?$@[*(B) ; J78-@-5B2A
(ucs-set-char #x66F5 ?$B[*(B) ; J83-B-5B2A
(ucs-set-char #x66F6 ?$(H'2(B) ; C02-H-2732
(ucs-set-char #x66F7 ?$(CJc(B) ; KS0-C-4A63
(ucs-set-char #x66F7 ?$(GQW(B) ; C01-G-5157
(ucs-set-char #x66F7 ?$@[+(B) ; J78-@-5B2B
(ucs-set-char #x66F7 ?$AjB(B) ; GB0-A-6A42
(ucs-set-char #x66F7 ?$B[+(B) ; J83-B-5B2B
(ucs-set-char #x66F8 ?$(C_v(B) ; KS0-C-5F76
(ucs-set-char #x66F8 ?$(GUs(B) ; C01-G-5573
(ucs-set-char #x66F8 ?$(L86(B) ; C06-L-3836
(ucs-set-char #x66F8 ?$@=q(B) ; J78-@-3D71
(ucs-set-char #x66F8 ?$B=q(B) ; J83-B-3D71
(ucs-set-char #x66F9 ?$(CpG(B) ; KS0-C-7047
(ucs-set-char #x66F9 ?$(G[*(B) ; C01-G-5B2A
(ucs-set-char #x66F9 ?$@Ab(B) ; J78-@-4162
(ucs-set-char #x66F9 ?$A2\(B) ; GB0-A-325C
(ucs-set-char #x66F9 ?$BAb(B) ; J83-B-4162
(ucs-set-char #x66FA ?$(CpF(B) ; KS0-C-7046
(ucs-set-char #x66FA ?$(DBm(B) ; J90-D-426D
(ucs-set-char #x66FB ?$(DB?(B) ; J90-D-423F
(ucs-set-char #x66FC ?$(CX:(B) ; KS0-C-583A
(ucs-set-char #x66FC ?$(GY7(B) ; C01-G-5937
(ucs-set-char #x66FC ?$@RX(B) ; J78-@-5258
(ucs-set-char #x66FC ?$AB|(B) ; GB0-A-427C
(ucs-set-char #x66FC ?$BRX(B) ; J83-B-5258
(ucs-set-char #x66FD ?$@A>(B) ; J78-@-413E
(ucs-set-char #x66FD ?$BA>(B) ; J83-B-413E
(ucs-set-char #x66FE ?$(Cqt(B) ; KS0-C-7174
(ucs-set-char #x66FE ?$(G_d(B) ; C01-G-5F64
(ucs-set-char #x66FE ?$@A=(B) ; J78-@-413D
(ucs-set-char #x66FE ?$ATx(B) ; GB0-A-5478
(ucs-set-char #x66FE ?$BA=(B) ; J83-B-413D
(ucs-set-char #x66FF ?$(Ctp(B) ; KS0-C-7470
(ucs-set-char #x66FF ?$(G_e(B) ; C01-G-5F65
(ucs-set-char #x66FF ?$@BX(B) ; J78-@-4258
(ucs-set-char #x66FF ?$ALf(B) ; GB0-A-4C66
(ucs-set-char #x66FF ?$BBX(B) ; J83-B-4258
(ucs-set-char #x6700 ?$(CuL(B) ; KS0-C-754C
(ucs-set-char #x6700 ?$(G^2(B) ; C01-G-5E32
(ucs-set-char #x6700 ?$(LIx(B) ; C06-L-4978
(ucs-set-char #x6700 ?$@:G(B) ; J78-@-3A47
(ucs-set-char #x6700 ?$AWn(B) ; GB0-A-576E
(ucs-set-char #x6700 ?$B:G(B) ; J83-B-3A47
(ucs-set-char #x6701 ?$(H<L(B) ; C02-H-3C4C
(ucs-set-char #x6703 ?$(C|e(B) ; KS0-C-7C65
(ucs-set-char #x6703 ?$(GdD(B) ; C01-G-6444
(ucs-set-char #x6703 ?$@Pr(B) ; J78-@-5072
(ucs-set-char #x6703 ?$BPr(B) ; J83-B-5072
(ucs-set-char #x6704 ?$(HJa(B) ; C02-H-4A61
(ucs-set-char #x6705 ?$(DBn(B) ; J90-D-426E
(ucs-set-char #x6705 ?$(HJ`(B) ; C02-H-4A60
(ucs-set-char #x6706 ?$(IQ$(B) ; C03-I-5124
(ucs-set-char #x6707 ?$(DBo(B) ; J90-D-426F
(ucs-set-char #x6707 ?$(MSG(B) ; C07-M-5347
(ucs-set-char #x6708 ?$(CjE(B) ; KS0-C-6A45
(ucs-set-char #x6708 ?$(GEL(B) ; C01-G-454C
(ucs-set-char #x6708 ?$@7n(B) ; J78-@-376E
(ucs-set-char #x6708 ?$ATB(B) ; GB0-A-5442
(ucs-set-char #x6708 ?$B7n(B) ; J83-B-376E
(ucs-set-char #x6709 ?$(Cjs(B) ; KS0-C-6A73
(ucs-set-char #x6709 ?$(GH4(B) ; C01-G-4834
(ucs-set-char #x6709 ?$@M-(B) ; J78-@-4D2D
(ucs-set-char #x6709 ?$ASP(B) ; GB0-A-5350
(ucs-set-char #x6709 ?$BM-(B) ; J83-B-4D2D
(ucs-set-char #x670A ?$(H'3(B) ; C02-H-2733
(ucs-set-char #x670A ?$AkC(B) ; GB0-A-6B43
(ucs-set-char #x670B ?$(C][(B) ; KS0-C-5D5B
(ucs-set-char #x670B ?$(GN%(B) ; C01-G-4E25
(ucs-set-char #x670B ?$@J~(B) ; J78-@-4A7E
(ucs-set-char #x670B ?$AEs(B) ; GB0-A-4573
(ucs-set-char #x670B ?$BJ~(B) ; J83-B-4A7E
(ucs-set-char #x670C ?$(I)E(B) ; C03-I-2945
(ucs-set-char #x670D ?$(C\W(B) ; KS0-C-5C57
(ucs-set-char #x670D ?$(GN$(B) ; C01-G-4E24
(ucs-set-char #x670D ?$@I~(B) ; J78-@-497E
(ucs-set-char #x670D ?$A7~(B) ; GB0-A-377E
(ucs-set-char #x670D ?$BI~(B) ; J83-B-497E
(ucs-set-char #x670E ?$(DBp(B) ; J90-D-4270
(ucs-set-char #x670E ?$(I-'(B) ; C03-I-2D27
(ucs-set-char #x670F ?$(H*z(B) ; C02-H-2A7A
(ucs-set-char #x670F ?$@[,(B) ; J78-@-5B2C
(ucs-set-char #x670F ?$B[,(B) ; J83-B-5B2C
(ucs-set-char #x6710 ?$(H*{(B) ; C02-H-2A7B
(ucs-set-char #x6710 ?$AkT(B) ; GB0-A-6B54
(ucs-set-char #x6712 ?$(H/Y(B) ; C02-H-2F59
(ucs-set-char #x6713 ?$(DBq(B) ; J90-D-4271
(ucs-set-char #x6713 ?$(H/Z(B) ; C02-H-2F5A
(ucs-set-char #x6714 ?$(C^}(B) ; KS0-C-5E7D
(ucs-set-char #x6714 ?$(GUt(B) ; C01-G-5574
(ucs-set-char #x6714 ?$@:s(B) ; J78-@-3A73
(ucs-set-char #x6714 ?$AK7(B) ; GB0-A-4B37
(ucs-set-char #x6714 ?$B:s(B) ; J83-B-3A73
(ucs-set-char #x6715 ?$(Cry(B) ; KS0-C-7279
(ucs-set-char #x6715 ?$(GUu(B) ; C01-G-5575
(ucs-set-char #x6715 ?$@D?(B) ; J78-@-443F
(ucs-set-char #x6715 ?$Ak^(B) ; GB0-A-6B5E
(ucs-set-char #x6715 ?$BD?(B) ; J83-B-443F
(ucs-set-char #x6716 ?$(I6H(B) ; C03-I-3648
(ucs-set-char #x6716 ?$@[-(B) ; J78-@-5B2D
(ucs-set-char #x6716 ?$B[-(B) ; J83-B-5B2D
(ucs-set-char #x6717 ?$(CUG(B) ; KS0-C-5547
(ucs-set-char #x6717 ?$(GUv(B) ; C01-G-5576
(ucs-set-char #x6717 ?$(J2>(B) ; C04-J-323E
(ucs-set-char #x6717 ?$@O/(B) ; J78-@-4F2F
(ucs-set-char #x6717 ?$A@J(B) ; GB0-A-404A
(ucs-set-char #x6717 ?$BO/(B) ; J83-B-4F2F
(ucs-set-char #x6718 ?$(H5q(B) ; C02-H-3571
(ucs-set-char #x6719 ?$(DBr(B) ; J90-D-4272
(ucs-set-char #x6719 ?$(I6G(B) ; C03-I-3647
(ucs-set-char #x671A ?$(I6F(B) ; C03-I-3646
(ucs-set-char #x671B ?$(CXP(B) ; KS0-C-5850
(ucs-set-char #x671B ?$(G[,(B) ; C01-G-5B2C
(ucs-set-char #x671B ?$(L@X(B) ; C06-L-4058
(ucs-set-char #x671B ?$@K>(B) ; J78-@-4B3E
(ucs-set-char #x671B ?$AM{(B) ; GB0-A-4D7B
(ucs-set-char #x671B ?$BK>(B) ; J83-B-4B3E
(ucs-set-char #x671C ?$(DBs(B) ; J90-D-4273
(ucs-set-char #x671C ?$(J8)(B) ; C04-J-3829
(ucs-set-char #x671D ?$(CpH(B) ; KS0-C-7048
(ucs-set-char #x671D ?$(G_g(B) ; C01-G-5F67
(ucs-set-char #x671D ?$@D+(B) ; J78-@-442B
(ucs-set-char #x671D ?$A3/(B) ; GB0-A-332F
(ucs-set-char #x671D ?$BD+(B) ; J83-B-442B
(ucs-set-char #x671E ?$(CQ!(B) ; KS0-C-5121
(ucs-set-char #x671E ?$(I<)(B) ; C03-I-3C29
(ucs-set-char #x671E ?$@[.(B) ; J78-@-5B2E
(ucs-set-char #x671E ?$B[.(B) ; J83-B-5B2E
(ucs-set-char #x671F ?$(CQ"(B) ; KS0-C-5122
(ucs-set-char #x671F ?$(G_f(B) ; C01-G-5F66
(ucs-set-char #x671F ?$@4|(B) ; J78-@-347C
(ucs-set-char #x671F ?$AFZ(B) ; GB0-A-465A
(ucs-set-char #x671F ?$B4|(B) ; J83-B-347C
(ucs-set-char #x6720 ?$(DBt(B) ; J90-D-4274
(ucs-set-char #x6720 ?$(HCN(B) ; C02-H-434E
(ucs-set-char #x6721 ?$(HFA(B) ; C02-H-4641
(ucs-set-char #x6722 ?$(DBu(B) ; J90-D-4275
(ucs-set-char #x6722 ?$(HJb(B) ; C02-H-4A62
(ucs-set-char #x6723 ?$(HWH(B) ; C02-H-5748
(ucs-set-char #x6724 ?$(IQ&(B) ; C03-I-5126
(ucs-set-char #x6726 ?$(CYT(B) ; KS0-C-5954
(ucs-set-char #x6726 ?$(GvM(B) ; C01-G-764D
(ucs-set-char #x6726 ?$@[/(B) ; J78-@-5B2F
(ucs-set-char #x6726 ?$Ak|(B) ; GB0-A-6B7C
(ucs-set-char #x6726 ?$B[/(B) ; J83-B-5B2F
(ucs-set-char #x6727 ?$(CVh(B) ; KS0-C-5668
(ucs-set-char #x6727 ?$(Gyr(B) ; C01-G-7972
(ucs-set-char #x6727 ?$@[0(B) ; J78-@-5B30
(ucs-set-char #x6727 ?$B[0(B) ; J83-B-5B30
(ucs-set-char #x6728 ?$(CYJ(B) ; KS0-C-594A
(ucs-set-char #x6728 ?$(GEM(B) ; C01-G-454D
(ucs-set-char #x6728 ?$@LZ(B) ; J78-@-4C5A
(ucs-set-char #x6728 ?$AD>(B) ; GB0-A-443E
(ucs-set-char #x6728 ?$BLZ(B) ; J83-B-4C5A
(ucs-set-char #x6729 ?$(K!H(B) ; C05-K-2148
(ucs-set-char #x672A ?$(CZ1(B) ; KS0-C-5A31
(ucs-set-char #x672A ?$(GF\(B) ; C01-G-465C
(ucs-set-char #x672A ?$@L$(B) ; J78-@-4C24
(ucs-set-char #x672A ?$AN4(B) ; GB0-A-4E34
(ucs-set-char #x672A ?$BL$(B) ; J83-B-4C24
(ucs-set-char #x672B ?$(CXG(B) ; KS0-C-5847
(ucs-set-char #x672B ?$(GF](B) ; C01-G-465D
(ucs-set-char #x672B ?$@Kv(B) ; J78-@-4B76
(ucs-set-char #x672B ?$AD)(B) ; GB0-A-4429
(ucs-set-char #x672B ?$BKv(B) ; J83-B-4B76
(ucs-set-char #x672C ?$(C\b(B) ; KS0-C-5C62
(ucs-set-char #x672C ?$(GF[(B) ; C01-G-465B
(ucs-set-char #x672C ?$@K\(B) ; J78-@-4B5C
(ucs-set-char #x672C ?$A1>(B) ; GB0-A-313E
(ucs-set-char #x672C ?$BK\(B) ; J83-B-4B5C
(ucs-set-char #x672D ?$(CsN(B) ; KS0-C-734E
(ucs-set-char #x672D ?$(GF^(B) ; C01-G-465E
(ucs-set-char #x672D ?$@;%(B) ; J78-@-3B25
(ucs-set-char #x672D ?$AT}(B) ; GB0-A-547D
(ucs-set-char #x672D ?$B;%(B) ; J83-B-3B25
(ucs-set-char #x672E ?$(Cut(B) ; KS0-C-7574
(ucs-set-char #x672E ?$(GFZ(B) ; C01-G-465A
(ucs-set-char #x672E ?$@[2(B) ; J78-@-5B32
(ucs-set-char #x672E ?$B[2(B) ; J83-B-5B32
(ucs-set-char #x672F ?$(I"R(B) ; C03-I-2252
(ucs-set-char #x672F ?$AJu(B) ; GB0-A-4A75
(ucs-set-char #x6731 ?$(Cq9(B) ; KS0-C-7139
(ucs-set-char #x6731 ?$(GH7(B) ; C01-G-4837
(ucs-set-char #x6731 ?$@<k(B) ; J78-@-3C6B
(ucs-set-char #x6731 ?$AVl(B) ; GB0-A-566C
(ucs-set-char #x6731 ?$B<k(B) ; J83-B-3C6B
(ucs-set-char #x6732 ?$(I#w(B) ; C03-I-2377
(ucs-set-char #x6733 ?$(DBv(B) ; J90-D-4276
(ucs-set-char #x6733 ?$(H"W(B) ; C02-H-2257
(ucs-set-char #x6734 ?$(CZS(B) ; KS0-C-5A53
(ucs-set-char #x6734 ?$(GH6(B) ; C01-G-4836
(ucs-set-char #x6734 ?$@KQ(B) ; J78-@-4B51
(ucs-set-char #x6734 ?$AFS(B) ; GB0-A-4653
(ucs-set-char #x6734 ?$BKQ(B) ; J83-B-4B51
(ucs-set-char #x6735 ?$(GH8(B) ; C01-G-4838
(ucs-set-char #x6735 ?$A6d(B) ; GB0-A-3664
(ucs-set-char #x6736 ?$(Cvj(B) ; KS0-C-766A
(ucs-set-char #x6736 ?$(I#x(B) ; C03-I-2378
(ucs-set-char #x6736 ?$@[4(B) ; J78-@-5B34
(ucs-set-char #x6736 ?$B[4(B) ; J83-B-5B34
(ucs-set-char #x6737 ?$(I#u(B) ; C03-I-2375
(ucs-set-char #x6737 ?$@[7(B) ; J78-@-5B37
(ucs-set-char #x6737 ?$B[7(B) ; J83-B-5B37
(ucs-set-char #x6738 ?$(H"R(B) ; C02-H-2252
(ucs-set-char #x6738 ?$@[6(B) ; J78-@-5B36
(ucs-set-char #x6738 ?$B[6(B) ; J83-B-5B36
(ucs-set-char #x6739 ?$(H"Q(B) ; C02-H-2251
(ucs-set-char #x673A ?$(COu(B) ; KS0-C-4F75
(ucs-set-char #x673A ?$(H"T(B) ; C02-H-2254
(ucs-set-char #x673A ?$@4y(B) ; J78-@-3479
(ucs-set-char #x673A ?$A;z(B) ; GB0-A-3B7A
(ucs-set-char #x673A ?$B4y(B) ; J83-B-3479
(ucs-set-char #x673B ?$(H"S(B) ; C02-H-2253
(ucs-set-char #x673C ?$(H"V(B) ; C02-H-2256
(ucs-set-char #x673D ?$(C}.(B) ; KS0-C-7D2E
(ucs-set-char #x673D ?$(GH5(B) ; C01-G-4835
(ucs-set-char #x673D ?$@5`(B) ; J78-@-3560
(ucs-set-char #x673D ?$AP`(B) ; GB0-A-5060
(ucs-set-char #x673D ?$B5`(B) ; J83-B-3560
(ucs-set-char #x673E ?$(DBw(B) ; J90-D-4277
(ucs-set-char #x673E ?$(H"P(B) ; C02-H-2250
(ucs-set-char #x673F ?$(H"U(B) ; C02-H-2255
(ucs-set-char #x673F ?$@[3(B) ; J78-@-5B33
(ucs-set-char #x673F ?$B[3(B) ; J83-B-5B33
(ucs-set-char #x6740 ?$(J$I(B) ; C04-J-2449
(ucs-set-char #x6740 ?$AI1(B) ; GB0-A-4931
(ucs-set-char #x6741 ?$@[5(B) ; J78-@-5B35
(ucs-set-char #x6741 ?$B[5(B) ; J83-B-5B35
(ucs-set-char #x6742 ?$ATS(B) ; GB0-A-5453
(ucs-set-char #x6743 ?$AH((B) ; GB0-A-4828
(ucs-set-char #x6744 ?$(I&H(B) ; C03-I-2648
(ucs-set-char #x6745 ?$(DBx(B) ; J90-D-4278
(ucs-set-char #x6745 ?$(H$>(B) ; C02-H-243E
(ucs-set-char #x6746 ?$(CJR(B) ; KS0-C-4A52
(ucs-set-char #x6746 ?$(GJ_(B) ; C01-G-4A5F
(ucs-set-char #x6746 ?$@[8(B) ; J78-@-5B38
(ucs-set-char #x6746 ?$A8K(B) ; GB0-A-384B
(ucs-set-char #x6746 ?$B[8(B) ; J83-B-5B38
(ucs-set-char #x6747 ?$(DBy(B) ; J90-D-4279
(ucs-set-char #x6747 ?$(H$?(B) ; C02-H-243F
(ucs-set-char #x6748 ?$(DBz(B) ; J90-D-427A
(ucs-set-char #x6748 ?$(H$C(B) ; C02-H-2443
(ucs-set-char #x6748 ?$Ah>(B) ; GB0-A-683E
(ucs-set-char #x6749 ?$(C_4(B) ; KS0-C-5F34
(ucs-set-char #x6749 ?$(GJ^(B) ; C01-G-4A5E
(ucs-set-char #x6749 ?$@?y(B) ; J78-@-3F79
(ucs-set-char #x6749 ?$AI<(B) ; GB0-A-493C
(ucs-set-char #x6749 ?$B?y(B) ; J83-B-3F79
(ucs-set-char #x674A ?$(I&I(B) ; C03-I-2649
(ucs-set-char #x674B ?$(H$G(B) ; C02-H-2447
(ucs-set-char #x674C ?$(DB{(B) ; J90-D-427B
(ucs-set-char #x674C ?$(H$B(B) ; C02-H-2442
(ucs-set-char #x674C ?$Ah;(B) ; GB0-A-683B
(ucs-set-char #x674D ?$(H$E(B) ; C02-H-2445
(ucs-set-char #x674E ?$(CW](B) ; KS0-C-575D
(ucs-set-char #x674E ?$(GJW(B) ; C01-G-4A57
(ucs-set-char #x674E ?$@M{(B) ; J78-@-4D7B
(ucs-set-char #x674E ?$A@n(B) ; GB0-A-406E
(ucs-set-char #x674E ?$BM{(B) ; J83-B-4D7B
(ucs-set-char #x674F ?$(Cz:(B) ; KS0-C-7A3A
(ucs-set-char #x674F ?$(GJX(B) ; C01-G-4A58
(ucs-set-char #x674F ?$@0I(B) ; J78-@-3049
(ucs-set-char #x674F ?$APS(B) ; GB0-A-5053
(ucs-set-char #x674F ?$B0I(B) ; J83-B-3049
(ucs-set-char #x6750 ?$(Cn'(B) ; KS0-C-6E27
(ucs-set-char #x6750 ?$(GJY(B) ; C01-G-4A59
(ucs-set-char #x6750 ?$@:`(B) ; J78-@-3A60
(ucs-set-char #x6750 ?$A2D(B) ; GB0-A-3244
(ucs-set-char #x6750 ?$B:`(B) ; J83-B-3A60
(ucs-set-char #x6751 ?$(Cu=(B) ; KS0-C-753D
(ucs-set-char #x6751 ?$(GJZ(B) ; C01-G-4A5A
(ucs-set-char #x6751 ?$@B<(B) ; J78-@-423C
(ucs-set-char #x6751 ?$A4e(B) ; GB0-A-3465
(ucs-set-char #x6751 ?$BB<(B) ; J83-B-423C
(ucs-set-char #x6752 ?$(I&E(B) ; C03-I-2645
(ucs-set-char #x6753 ?$(Cxu(B) ; KS0-C-7875
(ucs-set-char #x6753 ?$(GJa(B) ; C01-G-4A61
(ucs-set-char #x6753 ?$(L(.(B) ; C06-L-282E
(ucs-set-char #x6753 ?$@<](B) ; J78-@-3C5D
(ucs-set-char #x6753 ?$Ah<(B) ; GB0-A-683C
(ucs-set-char #x6753 ?$B<](B) ; J83-B-3C5D
(ucs-set-char #x6754 ?$(DB|(B) ; J90-D-427C
(ucs-set-char #x6754 ?$(I&D(B) ; C03-I-2644
(ucs-set-char #x6755 ?$(DB}(B) ; J90-D-427D
(ucs-set-char #x6755 ?$(H$A(B) ; C02-H-2441
(ucs-set-char #x6756 ?$(Cmh(B) ; KS0-C-6D68
(ucs-set-char #x6756 ?$(GJ\(B) ; C01-G-4A5C
(ucs-set-char #x6756 ?$@>s(B) ; J78-@-3E73
(ucs-set-char #x6756 ?$AUH(B) ; GB0-A-5548
(ucs-set-char #x6756 ?$B>s(B) ; J83-B-3E73
(ucs-set-char #x6757 ?$(GJb(B) ; C01-G-4A62
(ucs-set-char #x6758 ?$(I&G(B) ; C03-I-2647
(ucs-set-char #x6759 ?$(H$@(B) ; C02-H-2440
(ucs-set-char #x6759 ?$@[;(B) ; J78-@-5B3B
(ucs-set-char #x6759 ?$B[;(B) ; J83-B-5B3B
(ucs-set-char #x675A ?$(H$F(B) ; C02-H-2446
(ucs-set-char #x675B ?$(I&B(B) ; C03-I-2642
(ucs-set-char #x675C ?$(CTa(B) ; KS0-C-5461
(ucs-set-char #x675C ?$(GJ[(B) ; C01-G-4A5B
(ucs-set-char #x675C ?$@EN(B) ; J78-@-454E
(ucs-set-char #x675C ?$A6E(B) ; GB0-A-3645
(ucs-set-char #x675C ?$BEN(B) ; J83-B-454E
(ucs-set-char #x675D ?$(DB~(B) ; J90-D-427E
(ucs-set-char #x675D ?$(H$D(B) ; C02-H-2444
(ucs-set-char #x675E ?$(CQ#(B) ; KS0-C-5123
(ucs-set-char #x675E ?$(GJ](B) ; C01-G-4A5D
(ucs-set-char #x675E ?$@[9(B) ; J78-@-5B39
(ucs-set-char #x675E ?$Ah=(B) ; GB0-A-683D
(ucs-set-char #x675E ?$B[9(B) ; J83-B-5B39
(ucs-set-char #x675F ?$(CaV(B) ; KS0-C-6156
(ucs-set-char #x675F ?$(GJV(B) ; C01-G-4A56
(ucs-set-char #x675F ?$@B+(B) ; J78-@-422B
(ucs-set-char #x675F ?$AJx(B) ; GB0-A-4A78
(ucs-set-char #x675F ?$BB+(B) ; J83-B-422B
(ucs-set-char #x6760 ?$(GJ`(B) ; C01-G-4A60
(ucs-set-char #x6760 ?$@[:(B) ; J78-@-5B3A
(ucs-set-char #x6760 ?$A8\(B) ; GB0-A-385C
(ucs-set-char #x6760 ?$B[:(B) ; J83-B-5B3A
(ucs-set-char #x6761 ?$(I&J(B) ; C03-I-264A
(ucs-set-char #x6761 ?$@>r(B) ; J78-@-3E72
(ucs-set-char #x6761 ?$ALu(B) ; GB0-A-4C75
(ucs-set-char #x6761 ?$B>r(B) ; J83-B-3E72
(ucs-set-char #x6762 ?$@L](B) ; J78-@-4C5D
(ucs-set-char #x6762 ?$BL](B) ; J83-B-4C5D
(ucs-set-char #x6763 ?$@[<(B) ; J78-@-5B3C
(ucs-set-char #x6763 ?$B[<(B) ; J83-B-5B3C
(ucs-set-char #x6764 ?$@[=(B) ; J78-@-5B3D
(ucs-set-char #x6764 ?$B[=(B) ; J83-B-5B3D
(ucs-set-char #x6765 ?$(J$F(B) ; C04-J-2446
(ucs-set-char #x6765 ?$@Mh(B) ; J78-@-4D68
(ucs-set-char #x6765 ?$A@4(B) ; GB0-A-4034
(ucs-set-char #x6765 ?$BMh(B) ; J83-B-4D68
(ucs-set-char #x6766 ?$(DC!(B) ; J90-D-4321
(ucs-set-char #x6768 ?$AQn(B) ; GB0-A-516E
(ucs-set-char #x6769 ?$Ah?(B) ; GB0-A-683F
(ucs-set-char #x676A ?$(GN:(B) ; C01-G-4E3A
(ucs-set-char #x676A ?$@[B(B) ; J78-@-5B42
(ucs-set-char #x676A ?$AhB(B) ; GB0-A-6842
(ucs-set-char #x676A ?$B[B(B) ; J83-B-5B42
(ucs-set-char #x676B ?$(I)G(B) ; C03-I-2947
(ucs-set-char #x676C ?$(DC"(B) ; J90-D-4322
(ucs-set-char #x676C ?$(H'5(B) ; C02-H-2735
(ucs-set-char #x676D ?$(Cyx(B) ; KS0-C-7978
(ucs-set-char #x676D ?$(GN&(B) ; C01-G-4E26
(ucs-set-char #x676D ?$@9:(B) ; J78-@-393A
(ucs-set-char #x676D ?$A:<(B) ; GB0-A-3A3C
(ucs-set-char #x676D ?$B9:(B) ; J83-B-393A
(ucs-set-char #x676E ?$(DC#(B) ; J90-D-4323
(ucs-set-char #x676E ?$(J&i(B) ; C04-J-2669
(ucs-set-char #x676F ?$(C[J(B) ; KS0-C-5B4A
(ucs-set-char #x676F ?$(GN0(B) ; C01-G-4E30
(ucs-set-char #x676F ?$@GU(B) ; J78-@-4755
(ucs-set-char #x676F ?$A1-(B) ; GB0-A-312D
(ucs-set-char #x676F ?$BGU(B) ; J83-B-4755
(ucs-set-char #x6770 ?$(CKy(B) ; KS0-C-4B79
(ucs-set-char #x6770 ?$(GN1(B) ; C01-G-4E31
(ucs-set-char #x6770 ?$@[?(B) ; J78-@-5B3F
(ucs-set-char #x6770 ?$A=\(B) ; GB0-A-3D5C
(ucs-set-char #x6770 ?$B[?(B) ; J83-B-5B3F
(ucs-set-char #x6771 ?$(CTT(B) ; KS0-C-5454
(ucs-set-char #x6771 ?$(GN)(B) ; C01-G-4E29
(ucs-set-char #x6771 ?$@El(B) ; J78-@-456C
(ucs-set-char #x6771 ?$BEl(B) ; J83-B-456C
(ucs-set-char #x6772 ?$(GN;(B) ; C01-G-4E3B
(ucs-set-char #x6772 ?$@Z^(B) ; J78-@-5A5E
(ucs-set-char #x6772 ?$Aj=(B) ; GB0-A-6A3D
(ucs-set-char #x6772 ?$BZ^(B) ; J83-B-5A5E
(ucs-set-char #x6773 ?$(CY\(B) ; KS0-C-595C
(ucs-set-char #x6773 ?$(GN+(B) ; C01-G-4E2B
(ucs-set-char #x6773 ?$@Zb(B) ; J78-@-5A62
(ucs-set-char #x6773 ?$AhC(B) ; GB0-A-6843
(ucs-set-char #x6773 ?$BZb(B) ; J83-B-5A62
(ucs-set-char #x6774 ?$(DC$(B) ; J90-D-4324
(ucs-set-char #x6774 ?$(H'=(B) ; C02-H-273D
(ucs-set-char #x6775 ?$(Cn>(B) ; KS0-C-6E3E
(ucs-set-char #x6775 ?$(GN6(B) ; C01-G-4E36
(ucs-set-char #x6775 ?$@5O(B) ; J78-@-354F
(ucs-set-char #x6775 ?$AhF(B) ; GB0-A-6846
(ucs-set-char #x6775 ?$B5O(B) ; J83-B-354F
(ucs-set-char #x6776 ?$(DC%(B) ; J90-D-4325
(ucs-set-char #x6776 ?$(H'8(B) ; C02-H-2738
(ucs-set-char #x6777 ?$(Cwm(B) ; KS0-C-776D
(ucs-set-char #x6777 ?$(GN,(B) ; C01-G-4E2C
(ucs-set-char #x6777 ?$@GG(B) ; J78-@-4747
(ucs-set-char #x6777 ?$AhK(B) ; GB0-A-684B
(ucs-set-char #x6777 ?$BGG(B) ; J83-B-4747
(ucs-set-char #x6778 ?$(H'G(B) ; C02-H-2747
(ucs-set-char #x6779 ?$(H'H(B) ; C02-H-2748
(ucs-set-char #x677A ?$(H'@(B) ; C02-H-2740
(ucs-set-char #x677B ?$(CRn(B) ; KS0-C-526E
(ucs-set-char #x677B ?$(DC&(B) ; J90-D-4326
(ucs-set-char #x677B ?$(H'9(B) ; C02-H-2739
(ucs-set-char #x677C ?$(GN9(B) ; C01-G-4E39
(ucs-set-char #x677C ?$@[A(B) ; J78-@-5B41
(ucs-set-char #x677C ?$AhL(B) ; GB0-A-684C
(ucs-set-char #x677C ?$B[A(B) ; J83-B-5B41
(ucs-set-char #x677D ?$(H'E(B) ; C02-H-2745
(ucs-set-char #x677E ?$(Caf(B) ; KS0-C-6166
(ucs-set-char #x677E ?$(GN4(B) ; C01-G-4E34
(ucs-set-char #x677E ?$@>>(B) ; J78-@-3E3E
(ucs-set-char #x677E ?$AKI(B) ; GB0-A-4B49
(ucs-set-char #x677E ?$B>>(B) ; J83-B-3E3E
(ucs-set-char #x677F ?$(Cwy(B) ; KS0-C-7779
(ucs-set-char #x677F ?$(GN2(B) ; C01-G-4E32
(ucs-set-char #x677F ?$@HD(B) ; J78-@-4844
(ucs-set-char #x677F ?$A0e(B) ; GB0-A-3065
(ucs-set-char #x677F ?$BHD(B) ; J83-B-4844
(ucs-set-char #x6780 ?$(I)R(B) ; C03-I-2952
(ucs-set-char #x6781 ?$(DC'(B) ; J90-D-4327
(ucs-set-char #x6781 ?$(H'F(B) ; C02-H-2746
(ucs-set-char #x6781 ?$A<+(B) ; GB0-A-3C2B
(ucs-set-char #x6782 ?$(I)I(B) ; C03-I-2949
(ucs-set-char #x6783 ?$(H'D(B) ; C02-H-2744
(ucs-set-char #x6784 ?$(DC((B) ; J90-D-4328
(ucs-set-char #x6784 ?$(H'<(B) ; C02-H-273C
(ucs-set-char #x6784 ?$A99(B) ; GB0-A-3939
(ucs-set-char #x6785 ?$(H'4(B) ; C02-H-2734
(ucs-set-char #x6785 ?$@[G(B) ; J78-@-5B47
(ucs-set-char #x6785 ?$B[G(B) ; J83-B-5B47
(ucs-set-char #x6786 ?$(H';(B) ; C02-H-273B
(ucs-set-char #x6787 ?$(C]m(B) ; KS0-C-5D6D
(ucs-set-char #x6787 ?$(GN-(B) ; C01-G-4E2D
(ucs-set-char #x6787 ?$@Hz(B) ; J78-@-487A
(ucs-set-char #x6787 ?$AhA(B) ; GB0-A-6841
(ucs-set-char #x6787 ?$BHz(B) ; J83-B-487A
(ucs-set-char #x6788 ?$(J&e(B) ; C04-J-2665
(ucs-set-char #x6789 ?$(Ch[(B) ; KS0-C-685B
(ucs-set-char #x6789 ?$(GN3(B) ; C01-G-4E33
(ucs-set-char #x6789 ?$@[>(B) ; J78-@-5B3E
(ucs-set-char #x6789 ?$AMw(B) ; GB0-A-4D77
(ucs-set-char #x6789 ?$B[>(B) ; J83-B-5B3E
(ucs-set-char #x678A ?$(I)J(B) ; C03-I-294A
(ucs-set-char #x678B ?$(C[3(B) ; KS0-C-5B33
(ucs-set-char #x678B ?$(GN'(B) ; C01-G-4E27
(ucs-set-char #x678B ?$@[D(B) ; J78-@-5B44
(ucs-set-char #x678B ?$AhJ(B) ; GB0-A-684A
(ucs-set-char #x678B ?$B[D(B) ; J83-B-5B44
(ucs-set-char #x678C ?$(H'?(B) ; C02-H-273F
(ucs-set-char #x678C ?$@[C(B) ; J78-@-5B43
(ucs-set-char #x678C ?$B[C(B) ; J83-B-5B43
(ucs-set-char #x678D ?$(H'>(B) ; C02-H-273E
(ucs-set-char #x678E ?$(DC)(B) ; J90-D-4329
(ucs-set-char #x678E ?$(H'6(B) ; C02-H-2736
(ucs-set-char #x678F ?$(CQw(B) ; KS0-C-5177
(ucs-set-char #x678F ?$(DC*(B) ; J90-D-432A
(ucs-set-char #x678F ?$(I)O(B) ; C03-I-294F
(ucs-set-char #x6790 ?$(C`0(B) ; KS0-C-6030
(ucs-set-char #x6790 ?$(GN5(B) ; C01-G-4E35
(ucs-set-char #x6790 ?$@@O(B) ; J78-@-404F
(ucs-set-char #x6790 ?$ANv(B) ; GB0-A-4E76
(ucs-set-char #x6790 ?$B@O(B) ; J83-B-404F
(ucs-set-char #x6791 ?$(DC+(B) ; J90-D-432B
(ucs-set-char #x6791 ?$(H'B(B) ; C02-H-2742
(ucs-set-char #x6792 ?$(H'7(B) ; C02-H-2737
(ucs-set-char #x6793 ?$(CTb(B) ; KS0-C-5462
(ucs-set-char #x6793 ?$(DC,(B) ; J90-D-432C
(ucs-set-char #x6793 ?$(GN8(B) ; C01-G-4E38
(ucs-set-char #x6794 ?$(H'I(B) ; C02-H-2749
(ucs-set-char #x6795 ?$(CvW(B) ; KS0-C-7657
(ucs-set-char #x6795 ?$(GN((B) ; C01-G-4E28
(ucs-set-char #x6795 ?$@Km(B) ; J78-@-4B6D
(ucs-set-char #x6795 ?$AUm(B) ; GB0-A-556D
(ucs-set-char #x6795 ?$BKm(B) ; J83-B-4B6D
(ucs-set-char #x6796 ?$(DC-(B) ; J90-D-432D
(ucs-set-char #x6796 ?$(I)H(B) ; C03-I-2948
(ucs-set-char #x6797 ?$(CWy(B) ; KS0-C-5779
(ucs-set-char #x6797 ?$(GN/(B) ; C01-G-4E2F
(ucs-set-char #x6797 ?$@NS(B) ; J78-@-4E53
(ucs-set-char #x6797 ?$AAV(B) ; GB0-A-4156
(ucs-set-char #x6797 ?$BNS(B) ; J83-B-4E53
(ucs-set-char #x6798 ?$(DC.(B) ; J90-D-432E
(ucs-set-char #x6798 ?$(H':(B) ; C02-H-273A
(ucs-set-char #x6798 ?$AhD(B) ; GB0-A-6844
(ucs-set-char #x6799 ?$(DC/(B) ; J90-D-432F
(ucs-set-char #x6799 ?$(H'C(B) ; C02-H-2743
(ucs-set-char #x679A ?$(CX](B) ; KS0-C-585D
(ucs-set-char #x679A ?$(GN7(B) ; C01-G-4E37
(ucs-set-char #x679A ?$@Kg(B) ; J78-@-4B67
(ucs-set-char #x679A ?$AC6(B) ; GB0-A-4336
(ucs-set-char #x679A ?$BKg(B) ; J83-B-4B67
(ucs-set-char #x679B ?$(DC0(B) ; J90-D-4330
(ucs-set-char #x679B ?$(J&g(B) ; C04-J-2667
(ucs-set-char #x679C ?$(CM}(B) ; KS0-C-4D7D
(ucs-set-char #x679C ?$(GN*(B) ; C01-G-4E2A
(ucs-set-char #x679C ?$@2L(B) ; J78-@-324C
(ucs-set-char #x679C ?$A9{(B) ; GB0-A-397B
(ucs-set-char #x679C ?$B2L(B) ; J83-B-324C
(ucs-set-char #x679D ?$(Cr+(B) ; KS0-C-722B
(ucs-set-char #x679D ?$(GN.(B) ; C01-G-4E2E
(ucs-set-char #x679D ?$@;^(B) ; J78-@-3B5E
(ucs-set-char #x679D ?$AV&(B) ; GB0-A-5626
(ucs-set-char #x679D ?$B;^(B) ; J83-B-3B5E
(ucs-set-char #x679E ?$(J&j(B) ; C04-J-266A
(ucs-set-char #x679E ?$AhH(B) ; GB0-A-6848
(ucs-set-char #x679F ?$(H'A(B) ; C02-H-2741
(ucs-set-char #x67A0 ?$@OH(B) ; J78-@-4F48
(ucs-set-char #x67A0 ?$BOH(B) ; J83-B-4F48
(ucs-set-char #x67A1 ?$@[F(B) ; J78-@-5B46
(ucs-set-char #x67A1 ?$B[F(B) ; J83-B-5B46
(ucs-set-char #x67A2 ?$(I)N(B) ; C03-I-294E
(ucs-set-char #x67A2 ?$@?u(B) ; J78-@-3F75
(ucs-set-char #x67A2 ?$AJ`(B) ; GB0-A-4A60
(ucs-set-char #x67A2 ?$B?u(B) ; J83-B-3F75
(ucs-set-char #x67A3 ?$(I)L(B) ; C03-I-294C
(ucs-set-char #x67A3 ?$ATf(B) ; GB0-A-5466
(ucs-set-char #x67A5 ?$Ah@(B) ; GB0-A-6840
(ucs-set-char #x67A6 ?$@[E(B) ; J78-@-5B45
(ucs-set-char #x67A6 ?$B[E(B) ; J83-B-5B45
(ucs-set-char #x67A7 ?$AhE(B) ; GB0-A-6845
(ucs-set-char #x67A8 ?$AhG(B) ; GB0-A-6847
(ucs-set-char #x67A9 ?$@[@(B) ; J78-@-5B40
(ucs-set-char #x67A9 ?$B[@(B) ; J83-B-5B40
(ucs-set-char #x67AA ?$AG9(B) ; GB0-A-4739
(ucs-set-char #x67AB ?$A7c(B) ; GB0-A-3763
(ucs-set-char #x67AD ?$AhI(B) ; GB0-A-6849
(ucs-set-char #x67AE ?$(H+=(B) ; C02-H-2B3D
(ucs-set-char #x67AF ?$(CM=(B) ; KS0-C-4D3D
(ucs-set-char #x67AF ?$(GQ_(B) ; C01-G-515F
(ucs-set-char #x67AF ?$@8O(B) ; J78-@-384F
(ucs-set-char #x67AF ?$A?](B) ; GB0-A-3F5D
(ucs-set-char #x67AF ?$B8O(B) ; J83-B-384F
(ucs-set-char #x67B0 ?$(CxB(B) ; KS0-C-7842
(ucs-set-char #x67B0 ?$(DC1(B) ; J90-D-4331
(ucs-set-char #x67B0 ?$(GQl(B) ; C01-G-516C
(ucs-set-char #x67B0 ?$AhR(B) ; GB0-A-6852
(ucs-set-char #x67B1 ?$(DC2(B) ; J90-D-4332
(ucs-set-char #x67B1 ?$(I-6(B) ; C03-I-2D36
(ucs-set-char #x67B2 ?$(DC3(B) ; J90-D-4333
(ucs-set-char #x67B2 ?$(H+8(B) ; C02-H-2B38
(ucs-set-char #x67B3 ?$(Cr,(B) ; KS0-C-722C
(ucs-set-char #x67B3 ?$(H+.(B) ; C02-H-2B2E
(ucs-set-char #x67B3 ?$@[L(B) ; J78-@-5B4C
(ucs-set-char #x67B3 ?$AhW(B) ; GB0-A-6857
(ucs-set-char #x67B3 ?$B[L(B) ; J83-B-5B4C
(ucs-set-char #x67B4 ?$(GQe(B) ; C01-G-5165
(ucs-set-char #x67B4 ?$@[J(B) ; J78-@-5B4A
(ucs-set-char #x67B4 ?$B[J(B) ; J83-B-5B4A
(ucs-set-char #x67B5 ?$(DC4(B) ; J90-D-4334
(ucs-set-char #x67B5 ?$(H+,(B) ; C02-H-2B2C
(ucs-set-char #x67B5 ?$AhU(B) ; GB0-A-6855
(ucs-set-char #x67B6 ?$(CJ-(B) ; KS0-C-4A2D
(ucs-set-char #x67B6 ?$(GQ^(B) ; C01-G-515E
(ucs-set-char #x67B6 ?$@2M(B) ; J78-@-324D
(ucs-set-char #x67B6 ?$A<\(B) ; GB0-A-3C5C
(ucs-set-char #x67B6 ?$B2M(B) ; J83-B-324D
(ucs-set-char #x67B7 ?$(CJ.(B) ; KS0-C-4A2E
(ucs-set-char #x67B7 ?$(H+'(B) ; C02-H-2B27
(ucs-set-char #x67B7 ?$@[H(B) ; J78-@-5B48
(ucs-set-char #x67B7 ?$A<O(B) ; GB0-A-3C4F
(ucs-set-char #x67B7 ?$B[H(B) ; J83-B-5B48
(ucs-set-char #x67B8 ?$(CO.(B) ; KS0-C-4F2E
(ucs-set-char #x67B8 ?$(GQh(B) ; C01-G-5168
(ucs-set-char #x67B8 ?$@[N(B) ; J78-@-5B4E
(ucs-set-char #x67B8 ?$Ah[(B) ; GB0-A-685B
(ucs-set-char #x67B8 ?$B[N(B) ; J83-B-5B4E
(ucs-set-char #x67B9 ?$(H+4(B) ; C02-H-2B34
(ucs-set-char #x67B9 ?$@[T(B) ; J78-@-5B54
(ucs-set-char #x67B9 ?$B[T(B) ; J83-B-5B54
(ucs-set-char #x67BA ?$(H+!(B) ; C02-H-2B21
(ucs-set-char #x67BB ?$(DC5(B) ; J90-D-4335
(ucs-set-char #x67BB ?$(H+#(B) ; C02-H-2B23
(ucs-set-char #x67BC ?$(DC6(B) ; J90-D-4336
(ucs-set-char #x67BC ?$(I-.(B) ; C03-I-2D2E
(ucs-set-char #x67BD ?$(DC7(B) ; J90-D-4337
(ucs-set-char #x67BD ?$(J-Y(B) ; C04-J-2D59
(ucs-set-char #x67BE ?$(CcB(B) ; KS0-C-6342
(ucs-set-char #x67BE ?$(J)n(B) ; C04-J-296E
(ucs-set-char #x67BF ?$(I-0(B) ; C03-I-2D30
(ucs-set-char #x67C0 ?$(DC9(B) ; J90-D-4339
(ucs-set-char #x67C0 ?$(H+&(B) ; C02-H-2B26
(ucs-set-char #x67C1 ?$(H*|(B) ; C02-H-2A7C
(ucs-set-char #x67C1 ?$@BH(B) ; J78-@-4248
(ucs-set-char #x67C1 ?$Ah^(B) ; GB0-A-685E
(ucs-set-char #x67C1 ?$BBH(B) ; J83-B-4248
(ucs-set-char #x67C2 ?$(DC:(B) ; J90-D-433A
(ucs-set-char #x67C2 ?$(H+3(B) ; C02-H-2B33
(ucs-set-char #x67C3 ?$(DC;(B) ; J90-D-433B
(ucs-set-char #x67C3 ?$(H+C(B) ; C02-H-2B43
(ucs-set-char #x67C3 ?$AhZ(B) ; GB0-A-685A
(ucs-set-char #x67C4 ?$(C\7(B) ; KS0-C-5C37
(ucs-set-char #x67C4 ?$(GQc(B) ; C01-G-5163
(ucs-set-char #x67C4 ?$@JA(B) ; J78-@-4A41
(ucs-set-char #x67C4 ?$A1z(B) ; GB0-A-317A
(ucs-set-char #x67C4 ?$BJA(B) ; J83-B-4A41
(ucs-set-char #x67C5 ?$(DC<(B) ; J90-D-433C
(ucs-set-char #x67C5 ?$(H+((B) ; C02-H-2B28
(ucs-set-char #x67C6 ?$(H+:(B) ; C02-H-2B3A
(ucs-set-char #x67C6 ?$@[V(B) ; J78-@-5B56
(ucs-set-char #x67C6 ?$B[V(B) ; J83-B-5B56
(ucs-set-char #x67C7 ?$(I--(B) ; C03-I-2D2D
(ucs-set-char #x67C8 ?$(DC=(B) ; J90-D-433D
(ucs-set-char #x67C8 ?$(H*~(B) ; C02-H-2A7E
(ucs-set-char #x67C9 ?$(DC>(B) ; J90-D-433E
(ucs-set-char #x67C9 ?$(H+A(B) ; C02-H-2B41
(ucs-set-char #x67CA ?$(H+B(B) ; C02-H-2B42
(ucs-set-char #x67CA ?$@I"(B) ; J78-@-4922
(ucs-set-char #x67CA ?$BI"(B) ; J83-B-4922
(ucs-set-char #x67CB ?$(H+E(B) ; C02-H-2B45
(ucs-set-char #x67CC ?$(H+<(B) ; C02-H-2B3C
(ucs-set-char #x67CD ?$(H+-(B) ; C02-H-2B2D
(ucs-set-char #x67CE ?$(H+5(B) ; C02-H-2B35
(ucs-set-char #x67CE ?$@[U(B) ; J78-@-5B55
(ucs-set-char #x67CE ?$B[U(B) ; J83-B-5B55
(ucs-set-char #x67CF ?$(C[Z(B) ; KS0-C-5B5A
(ucs-set-char #x67CF ?$(GQi(B) ; C01-G-5169
(ucs-set-char #x67CF ?$@Gp(B) ; J78-@-4770
(ucs-set-char #x67CF ?$A0X(B) ; GB0-A-3058
(ucs-set-char #x67CF ?$BGp(B) ; J83-B-4770
(ucs-set-char #x67D0 ?$(CY;(B) ; KS0-C-593B
(ucs-set-char #x67D0 ?$(GQ\(B) ; C01-G-515C
(ucs-set-char #x67D0 ?$@K?(B) ; J78-@-4B3F
(ucs-set-char #x67D0 ?$AD3(B) ; GB0-A-4433
(ucs-set-char #x67D0 ?$BK?(B) ; J83-B-4B3F
(ucs-set-char #x67D1 ?$(CJs(B) ; KS0-C-4A73
(ucs-set-char #x67D1 ?$(GQd(B) ; C01-G-5164
(ucs-set-char #x67D1 ?$@4;(B) ; J78-@-343B
(ucs-set-char #x67D1 ?$A8L(B) ; GB0-A-384C
(ucs-set-char #x67D1 ?$B4;(B) ; J83-B-343B
(ucs-set-char #x67D2 ?$(CvS(B) ; KS0-C-7653
(ucs-set-char #x67D2 ?$(DC?(B) ; J90-D-433F
(ucs-set-char #x67D2 ?$(GQp(B) ; C01-G-5170
(ucs-set-char #x67D2 ?$AFb(B) ; GB0-A-4662
(ucs-set-char #x67D3 ?$(Cfx(B) ; KS0-C-6678
(ucs-set-char #x67D3 ?$(GQY(B) ; C01-G-5159
(ucs-set-char #x67D3 ?$@@w(B) ; J78-@-4077
(ucs-set-char #x67D3 ?$AH>(B) ; GB0-A-483E
(ucs-set-char #x67D3 ?$B@w(B) ; J83-B-4077
(ucs-set-char #x67D4 ?$(Cju(B) ; KS0-C-6A75
(ucs-set-char #x67D4 ?$(GQ[(B) ; C01-G-515B
(ucs-set-char #x67D4 ?$@=@(B) ; J78-@-3D40
(ucs-set-char #x67D4 ?$AHa(B) ; GB0-A-4861
(ucs-set-char #x67D4 ?$B=@(B) ; J83-B-3D40
(ucs-set-char #x67D5 ?$(I-1(B) ; C03-I-2D31
(ucs-set-char #x67D6 ?$(I-+(B) ; C03-I-2D2B
(ucs-set-char #x67D7 ?$(DC@(B) ; J90-D-4340
(ucs-set-char #x67D7 ?$(I-:(B) ; C03-I-2D3A
(ucs-set-char #x67D8 ?$(H+%(B) ; C02-H-2B25
(ucs-set-char #x67D8 ?$@DS(B) ; J78-@-4453
(ucs-set-char #x67D8 ?$AhO(B) ; GB0-A-684F
(ucs-set-char #x67D8 ?$BDS(B) ; J83-B-4453
(ucs-set-char #x67D9 ?$(DCA(B) ; J90-D-4341
(ucs-set-char #x67D9 ?$(GQm(B) ; C01-G-516D
(ucs-set-char #x67D9 ?$AhT(B) ; GB0-A-6854
(ucs-set-char #x67DA ?$(Cjv(B) ; KS0-C-6A76
(ucs-set-char #x67DA ?$(GQf(B) ; C01-G-5166
(ucs-set-char #x67DA ?$@M.(B) ; J78-@-4D2E
(ucs-set-char #x67DA ?$AhV(B) ; GB0-A-6856
(ucs-set-char #x67DA ?$BM.(B) ; J83-B-4D2E
(ucs-set-char #x67DB ?$(H+?(B) ; C02-H-2B3F
(ucs-set-char #x67DC ?$(DCB(B) ; J90-D-4342
(ucs-set-char #x67DC ?$(H+"(B) ; C02-H-2B22
(ucs-set-char #x67DC ?$A9q(B) ; GB0-A-3971
(ucs-set-char #x67DD ?$(Cvy(B) ; KS0-C-7679
(ucs-set-char #x67DD ?$(GQo(B) ; C01-G-516F
(ucs-set-char #x67DD ?$@[Q(B) ; J78-@-5B51
(ucs-set-char #x67DD ?$AhX(B) ; GB0-A-6858
(ucs-set-char #x67DD ?$B[Q(B) ; J83-B-5B51
(ucs-set-char #x67DE ?$(GQj(B) ; C01-G-516A
(ucs-set-char #x67DE ?$@[P(B) ; J78-@-5B50
(ucs-set-char #x67DE ?$AWu(B) ; GB0-A-5775
(ucs-set-char #x67DE ?$B[P(B) ; J83-B-5B50
(ucs-set-char #x67DF ?$(H++(B) ; C02-H-2B2B
(ucs-set-char #x67E0 ?$(J)m(B) ; C04-J-296D
(ucs-set-char #x67E0 ?$AD{(B) ; GB0-A-447B
(ucs-set-char #x67E1 ?$(DCC(B) ; J90-D-4343
(ucs-set-char #x67E1 ?$(J-N(B) ; C04-J-2D4E
(ucs-set-char #x67E2 ?$(GQn(B) ; C01-G-516E
(ucs-set-char #x67E2 ?$@[R(B) ; J78-@-5B52
(ucs-set-char #x67E2 ?$Ah\(B) ; GB0-A-685C
(ucs-set-char #x67E2 ?$B[R(B) ; J83-B-5B52
(ucs-set-char #x67E3 ?$(H+2(B) ; C02-H-2B32
(ucs-set-char #x67E4 ?$(H+*(B) ; C02-H-2B2A
(ucs-set-char #x67E4 ?$@[O(B) ; J78-@-5B4F
(ucs-set-char #x67E4 ?$B[O(B) ; J83-B-5B4F
(ucs-set-char #x67E5 ?$(GQg(B) ; C01-G-5167
(ucs-set-char #x67E5 ?$A2i(B) ; GB0-A-3269
(ucs-set-char #x67E6 ?$(DCD(B) ; J90-D-4344
(ucs-set-char #x67E6 ?$(H+>(B) ; C02-H-2B3E
(ucs-set-char #x67E7 ?$(H+6(B) ; C02-H-2B36
(ucs-set-char #x67E7 ?$@[W(B) ; J78-@-5B57
(ucs-set-char #x67E7 ?$B[W(B) ; J83-B-5B57
(ucs-set-char #x67E8 ?$(I-*(B) ; C03-I-2D2A
(ucs-set-char #x67E9 ?$(CO/(B) ; KS0-C-4F2F
(ucs-set-char #x67E9 ?$(GQa(B) ; C01-G-5161
(ucs-set-char #x67E9 ?$@[M(B) ; J78-@-5B4D
(ucs-set-char #x67E9 ?$AhQ(B) ; GB0-A-6851
(ucs-set-char #x67E9 ?$B[M(B) ; J83-B-5B4D
(ucs-set-char #x67EA ?$(H+D(B) ; C02-H-2B44
(ucs-set-char #x67EB ?$(H+)(B) ; C02-H-2B29
(ucs-set-char #x67EC ?$(CJS(B) ; KS0-C-4A53
(ucs-set-char #x67EC ?$(GQ](B) ; C01-G-515D
(ucs-set-char #x67EC ?$@[K(B) ; J78-@-5B4B
(ucs-set-char #x67EC ?$A<m(B) ; GB0-A-3C6D
(ucs-set-char #x67EC ?$B[K(B) ; J83-B-5B4B
(ucs-set-char #x67ED ?$(H+;(B) ; C02-H-2B3B
(ucs-set-char #x67EE ?$(H+1(B) ; C02-H-2B31
(ucs-set-char #x67EE ?$@[S(B) ; J78-@-5B53
(ucs-set-char #x67EE ?$B[S(B) ; J83-B-5B53
(ucs-set-char #x67EF ?$(CJ/(B) ; KS0-C-4A2F
(ucs-set-char #x67EF ?$(GQb(B) ; C01-G-5162
(ucs-set-char #x67EF ?$@[I(B) ; J78-@-5B49
(ucs-set-char #x67EF ?$A?B(B) ; GB0-A-3F42
(ucs-set-char #x67EF ?$B[I(B) ; J83-B-5B49
(ucs-set-char #x67F0 ?$(CR0(B) ; KS0-C-5230
(ucs-set-char #x67F0 ?$(DCE(B) ; J90-D-4345
(ucs-set-char #x67F0 ?$(H+7(B) ; C02-H-2B37
(ucs-set-char #x67F0 ?$AhM(B) ; GB0-A-684D
(ucs-set-char #x67F1 ?$(Cq:(B) ; KS0-C-713A
(ucs-set-char #x67F1 ?$(GQZ(B) ; C01-G-515A
(ucs-set-char #x67F1 ?$@Cl(B) ; J78-@-436C
(ucs-set-char #x67F1 ?$AVy(B) ; GB0-A-5679
(ucs-set-char #x67F1 ?$BCl(B) ; J83-B-436C
(ucs-set-char #x67F2 ?$(DCF(B) ; J90-D-4346
(ucs-set-char #x67F2 ?$(H*}(B) ; C02-H-2A7D
(ucs-set-char #x67F3 ?$(CW3(B) ; KS0-C-5733
(ucs-set-char #x67F3 ?$(GQk(B) ; C01-G-516B
(ucs-set-char #x67F3 ?$@Lx(B) ; J78-@-4C78
(ucs-set-char #x67F3 ?$AAx(B) ; GB0-A-4178
(ucs-set-char #x67F3 ?$BLx(B) ; J83-B-4C78
(ucs-set-char #x67F4 ?$(CcC(B) ; KS0-C-6343
(ucs-set-char #x67F4 ?$(GV'(B) ; C01-G-5627
(ucs-set-char #x67F4 ?$@<F(B) ; J78-@-3C46
(ucs-set-char #x67F4 ?$A2q(B) ; GB0-A-3271
(ucs-set-char #x67F4 ?$B<F(B) ; J83-B-3C46
(ucs-set-char #x67F5 ?$(Cs}(B) ; KS0-C-737D
(ucs-set-char #x67F5 ?$(GQ`(B) ; C01-G-5160
(ucs-set-char #x67F5 ?$B:t(B) ; J83-B-3A74
(ucs-set-char #x67F6 ?$(C^Z(B) ; KS0-C-5E5A
(ucs-set-char #x67F6 ?$(DCG(B) ; J90-D-4347
(ucs-set-char #x67F6 ?$(H+0(B) ; C02-H-2B30
(ucs-set-char #x67F7 ?$(DCH(B) ; J90-D-4348
(ucs-set-char #x67F7 ?$(H+/(B) ; C02-H-2B2F
(ucs-set-char #x67F8 ?$(H+$(B) ; C02-H-2B24
(ucs-set-char #x67F9 ?$(DC8(B) ; J90-D-4338
(ucs-set-char #x67F9 ?$(I)Q(B) ; C03-I-2951
(ucs-set-char #x67FA ?$(H+@(B) ; C02-H-2B40
(ucs-set-char #x67FA ?$(I-5(B) ; C03-I-2D35
(ucs-set-char #x67FB ?$(C^[(B) ; KS0-C-5E5B
(ucs-set-char #x67FB ?$(I-4(B) ; C03-I-2D34
(ucs-set-char #x67FB ?$@::(B) ; J78-@-3A3A
(ucs-set-char #x67FB ?$B::(B) ; J83-B-3A3A
(ucs-set-char #x67FC ?$(H+9(B) ; C02-H-2B39
(ucs-set-char #x67FD ?$Ah_(B) ; GB0-A-685F
(ucs-set-char #x67FE ?$(Co^(B) ; KS0-C-6F5E
(ucs-set-char #x67FE ?$(I-2(B) ; C03-I-2D32
(ucs-set-char #x67FE ?$@Ko(B) ; J78-@-4B6F
(ucs-set-char #x67FE ?$BKo(B) ; J83-B-4B6F
(ucs-set-char #x67FF ?$(GQX(B) ; C01-G-5158
(ucs-set-char #x67FF ?$@3A(B) ; J78-@-3341
(ucs-set-char #x67FF ?$AJA(B) ; GB0-A-4A41
(ucs-set-char #x67FF ?$B3A(B) ; J83-B-3341
(ucs-set-char #x6800 ?$(I-9(B) ; C03-I-2D39
(ucs-set-char #x6800 ?$AhY(B) ; GB0-A-6859
(ucs-set-char #x6801 ?$(I-7(B) ; C03-I-2D37
(ucs-set-char #x6802 ?$@DN(B) ; J78-@-444E
(ucs-set-char #x6802 ?$BDN(B) ; J83-B-444E
(ucs-set-char #x6803 ?$@FJ(B) ; J78-@-464A
(ucs-set-char #x6803 ?$BFJ(B) ; J83-B-464A
(ucs-set-char #x6804 ?$(L1r(B) ; C06-L-3172
(ucs-set-char #x6804 ?$@1I(B) ; J78-@-3149
(ucs-set-char #x6804 ?$B1I(B) ; J83-B-3149
(ucs-set-char #x6805 ?$(I-8(B) ; C03-I-2D38
(ucs-set-char #x6805 ?$@:t(B) ; J78-@-3A74
(ucs-set-char #x6805 ?$AU$(B) ; GB0-A-5524
(ucs-set-char #x6807 ?$A1j(B) ; GB0-A-316A
(ucs-set-char #x6808 ?$AU;(B) ; GB0-A-553B
(ucs-set-char #x6809 ?$AhN(B) ; GB0-A-684E
(ucs-set-char #x680A ?$AhP(B) ; GB0-A-6850
(ucs-set-char #x680B ?$A60(B) ; GB0-A-3630
(ucs-set-char #x680C ?$AhS(B) ; GB0-A-6853
(ucs-set-char #x680E ?$Ah](B) ; GB0-A-685D
(ucs-set-char #x680F ?$A@8(B) ; GB0-A-4038
(ucs-set-char #x6811 ?$AJw(B) ; GB0-A-4A77
(ucs-set-char #x6812 ?$(Cbc(B) ; KS0-C-6263
(ucs-set-char #x6812 ?$(H/n(B) ; C02-H-2F6E
(ucs-set-char #x6813 ?$(Cn{(B) ; KS0-C-6E7B
(ucs-set-char #x6813 ?$(GV.(B) ; C01-G-562E
(ucs-set-char #x6813 ?$@@r(B) ; J78-@-4072
(ucs-set-char #x6813 ?$AK((B) ; GB0-A-4B28
(ucs-set-char #x6813 ?$B@r(B) ; J83-B-4072
(ucs-set-char #x6814 ?$(DCJ(B) ; J90-D-434A
(ucs-set-char #x6814 ?$(H/o(B) ; C02-H-2F6F
(ucs-set-char #x6815 ?$(I1](B) ; C03-I-315D
(ucs-set-char #x6816 ?$(C_w(B) ; KS0-C-5F77
(ucs-set-char #x6816 ?$(H/c(B) ; C02-H-2F63
(ucs-set-char #x6816 ?$@@4(B) ; J78-@-4034
(ucs-set-char #x6816 ?$AF\(B) ; GB0-A-465C
(ucs-set-char #x6816 ?$B@4(B) ; J83-B-4034
(ucs-set-char #x6817 ?$(CWJ(B) ; KS0-C-574A
(ucs-set-char #x6817 ?$(GV#(B) ; C01-G-5623
(ucs-set-char #x6817 ?$@7*(B) ; J78-@-372A
(ucs-set-char #x6817 ?$A@u(B) ; GB0-A-4075
(ucs-set-char #x6817 ?$B7*(B) ; J83-B-372A
(ucs-set-char #x6818 ?$(GV/(B) ; C01-G-562F
(ucs-set-char #x6819 ?$(DCK(B) ; J90-D-434B
(ucs-set-char #x6819 ?$(I1W(B) ; C03-I-3157
(ucs-set-char #x681A ?$(H/\(B) ; C02-H-2F5C
(ucs-set-char #x681B ?$(I1S(B) ; C03-I-3153
(ucs-set-char #x681C ?$(H/e(B) ; C02-H-2F65
(ucs-set-char #x681D ?$(DCL(B) ; J90-D-434C
(ucs-set-char #x681D ?$(H/m(B) ; C02-H-2F6D
(ucs-set-char #x681D ?$Ahi(B) ; GB0-A-6869
(ucs-set-char #x681E ?$(I1[(B) ; C03-I-315B
(ucs-set-char #x681E ?$@[Y(B) ; J78-@-5B59
(ucs-set-char #x681E ?$B[Y(B) ; J83-B-5B59
(ucs-set-char #x681F ?$(DCM(B) ; J90-D-434D
(ucs-set-char #x681F ?$(H/[(B) ; C02-H-2F5B
(ucs-set-char #x681F ?$(I<:(B) ; C03-I-3C3A
(ucs-set-char #x6820 ?$(H/v(B) ; C02-H-2F76
(ucs-set-char #x6821 ?$(CNh(B) ; KS0-C-4E68
(ucs-set-char #x6821 ?$(GUw(B) ; C01-G-5577
(ucs-set-char #x6821 ?$@9;(B) ; J78-@-393B
(ucs-set-char #x6821 ?$AP#(B) ; GB0-A-5023
(ucs-set-char #x6821 ?$B9;(B) ; J83-B-393B
(ucs-set-char #x6822 ?$(C[[(B) ; KS0-C-5B5B
(ucs-set-char #x6822 ?$(I1^(B) ; C03-I-315E
(ucs-set-char #x6822 ?$@3|(B) ; J78-@-337C
(ucs-set-char #x6822 ?$B3|(B) ; J83-B-337C
(ucs-set-char #x6823 ?$(I1d(B) ; C03-I-3164
(ucs-set-char #x6824 ?$(I1P(B) ; C03-I-3150
(ucs-set-char #x6825 ?$(H/u(B) ; C02-H-2F75
(ucs-set-char #x6826 ?$(H/p(B) ; C02-H-2F70
(ucs-set-char #x6827 ?$(DCO(B) ; J90-D-434F
(ucs-set-char #x6827 ?$(I1_(B) ; C03-I-315F
(ucs-set-char #x6828 ?$(DCN(B) ; J90-D-434E
(ucs-set-char #x6828 ?$(H/q(B) ; C02-H-2F71
(ucs-set-char #x6829 ?$(GV!(B) ; C01-G-5621
(ucs-set-char #x6829 ?$@[[(B) ; J78-@-5B5B
(ucs-set-char #x6829 ?$Ahr(B) ; GB0-A-6872
(ucs-set-char #x6829 ?$B[[(B) ; J83-B-5B5B
(ucs-set-char #x682A ?$(Cq;(B) ; KS0-C-713B
(ucs-set-char #x682A ?$(GV,(B) ; C01-G-562C
(ucs-set-char #x682A ?$@3t(B) ; J78-@-3374
(ucs-set-char #x682A ?$AVj(B) ; GB0-A-566A
(ucs-set-char #x682A ?$B3t(B) ; J83-B-3374
(ucs-set-char #x682B ?$(H/g(B) ; C02-H-2F67
(ucs-set-char #x682B ?$@[a(B) ; J78-@-5B61
(ucs-set-char #x682B ?$B[a(B) ; J83-B-5B61
(ucs-set-char #x682C ?$(DCP(B) ; J90-D-4350
(ucs-set-char #x682C ?$(I1V(B) ; C03-I-3156
(ucs-set-char #x682D ?$(DCQ(B) ; J90-D-4351
(ucs-set-char #x682D ?$(H/h(B) ; C02-H-2F68
(ucs-set-char #x682E ?$(H/r(B) ; C02-H-2F72
(ucs-set-char #x682F ?$(Ciq(B) ; KS0-C-6971
(ucs-set-char #x682F ?$(DCR(B) ; J90-D-4352
(ucs-set-char #x682F ?$(H/i(B) ; C02-H-2F69
(ucs-set-char #x6830 ?$(DCS(B) ; J90-D-4353
(ucs-set-char #x6830 ?$(I1c(B) ; C03-I-3163
(ucs-set-char #x6831 ?$(DCT(B) ; J90-D-4354
(ucs-set-char #x6831 ?$(H/d(B) ; C02-H-2F64
(ucs-set-char #x6832 ?$(H/^(B) ; C02-H-2F5E
(ucs-set-char #x6832 ?$@[^(B) ; J78-@-5B5E
(ucs-set-char #x6832 ?$Ah`(B) ; GB0-A-6860
(ucs-set-char #x6832 ?$B[^(B) ; J83-B-5B5E
(ucs-set-char #x6833 ?$(DCU(B) ; J90-D-4355
(ucs-set-char #x6833 ?$(H/_(B) ; C02-H-2F5F
(ucs-set-char #x6833 ?$Aha(B) ; GB0-A-6861
(ucs-set-char #x6834 ?$(H/l(B) ; C02-H-2F6C
(ucs-set-char #x6834 ?$@@s(B) ; J78-@-4073
(ucs-set-char #x6834 ?$B@s(B) ; J83-B-4073
(ucs-set-char #x6835 ?$(H/f(B) ; C02-H-2F66
(ucs-set-char #x6836 ?$(I1T(B) ; C03-I-3154
(ucs-set-char #x6837 ?$(I1O(B) ; C03-I-314F
(ucs-set-char #x6837 ?$AQy(B) ; GB0-A-5179
(ucs-set-char #x6838 ?$(Cz7(B) ; KS0-C-7A37
(ucs-set-char #x6838 ?$(GUx(B) ; C01-G-5578
(ucs-set-char #x6838 ?$@3K(B) ; J78-@-334B
(ucs-set-char #x6838 ?$A:K(B) ; GB0-A-3A4B
(ucs-set-char #x6838 ?$B3K(B) ; J83-B-334B
(ucs-set-char #x6839 ?$(CPF(B) ; KS0-C-5046
(ucs-set-char #x6839 ?$(GU|(B) ; C01-G-557C
(ucs-set-char #x6839 ?$@:,(B) ; J78-@-3A2C
(ucs-set-char #x6839 ?$A8y(B) ; GB0-A-3879
(ucs-set-char #x6839 ?$B:,(B) ; J83-B-3A2C
(ucs-set-char #x683A ?$(H/t(B) ; C02-H-2F74
(ucs-set-char #x683B ?$(DCV(B) ; J90-D-4356
(ucs-set-char #x683B ?$(H/`(B) ; C02-H-2F60
(ucs-set-char #x683C ?$(CL+(B) ; KS0-C-4C2B
(ucs-set-char #x683C ?$(GV*(B) ; C01-G-562A
(ucs-set-char #x683C ?$@3J(B) ; J78-@-334A
(ucs-set-char #x683C ?$A8q(B) ; GB0-A-3871
(ucs-set-char #x683C ?$B3J(B) ; J83-B-334A
(ucs-set-char #x683D ?$(Cn((B) ; KS0-C-6E28
(ucs-set-char #x683D ?$(GV&(B) ; C01-G-5626
(ucs-set-char #x683D ?$@:O(B) ; J78-@-3A4F
(ucs-set-char #x683D ?$ATT(B) ; GB0-A-5454
(ucs-set-char #x683D ?$B:O(B) ; J83-B-3A4F
(ucs-set-char #x683E ?$(I1Z(B) ; C03-I-315A
(ucs-set-char #x683E ?$Aho(B) ; GB0-A-686F
(ucs-set-char #x683F ?$(DCW(B) ; J90-D-4357
(ucs-set-char #x683F ?$(J-U(B) ; C04-J-2D55
(ucs-set-char #x6840 ?$(CKz(B) ; KS0-C-4B7A
(ucs-set-char #x6840 ?$(GV)(B) ; C01-G-5629
(ucs-set-char #x6840 ?$@[\(B) ; J78-@-5B5C
(ucs-set-char #x6840 ?$Ahn(B) ; GB0-A-686E
(ucs-set-char #x6840 ?$B[\(B) ; J83-B-5B5C
(ucs-set-char #x6841 ?$(Cyy(B) ; KS0-C-7979
(ucs-set-char #x6841 ?$(GV0(B) ; C01-G-5630
(ucs-set-char #x6841 ?$@7e(B) ; J78-@-3765
(ucs-set-char #x6841 ?$Ahl(B) ; GB0-A-686C
(ucs-set-char #x6841 ?$B7e(B) ; J83-B-3765
(ucs-set-char #x6842 ?$(CL}(B) ; KS0-C-4C7D
(ucs-set-char #x6842 ?$(GU}(B) ; C01-G-557D
(ucs-set-char #x6842 ?$@7K(B) ; J78-@-374B
(ucs-set-char #x6842 ?$A9p(B) ; GB0-A-3970
(ucs-set-char #x6842 ?$B7K(B) ; J83-B-374B
(ucs-set-char #x6843 ?$(CS~(B) ; KS0-C-537E
(ucs-set-char #x6843 ?$(GV+(B) ; C01-G-562B
(ucs-set-char #x6843 ?$@Em(B) ; J78-@-456D
(ucs-set-char #x6843 ?$ALR(B) ; GB0-A-4C52
(ucs-set-char #x6843 ?$BEm(B) ; J83-B-456D
(ucs-set-char #x6844 ?$(DCX(B) ; J90-D-4358
(ucs-set-char #x6844 ?$(H/k(B) ; C02-H-2F6B
(ucs-set-char #x6844 ?$Ahf(B) ; GB0-A-6866
(ucs-set-char #x6845 ?$(DCY(B) ; J90-D-4359
(ucs-set-char #x6845 ?$(GV-(B) ; C01-G-562D
(ucs-set-char #x6845 ?$AN&(B) ; GB0-A-4E26
(ucs-set-char #x6846 ?$(GUz(B) ; C01-G-557A
(ucs-set-char #x6846 ?$@[Z(B) ; J78-@-5B5A
(ucs-set-char #x6846 ?$A?r(B) ; GB0-A-3F72
(ucs-set-char #x6846 ?$B[Z(B) ; J83-B-5B5A
(ucs-set-char #x6847 ?$(I1Y(B) ; C03-I-3159
(ucs-set-char #x6848 ?$(CdP(B) ; KS0-C-6450
(ucs-set-char #x6848 ?$(GUy(B) ; C01-G-5579
(ucs-set-char #x6848 ?$@0F(B) ; J78-@-3046
(ucs-set-char #x6848 ?$A08(B) ; GB0-A-3038
(ucs-set-char #x6848 ?$B0F(B) ; J83-B-3046
(ucs-set-char #x6849 ?$(H/](B) ; C02-H-2F5D
(ucs-set-char #x6849 ?$Ahq(B) ; GB0-A-6871
(ucs-set-char #x684A ?$(DCZ(B) ; J90-D-435A
(ucs-set-char #x684A ?$(J-O(B) ; C04-J-2D4F
(ucs-set-char #x684A ?$Ahp(B) ; GB0-A-6870
(ucs-set-char #x684B ?$(H/a(B) ; C02-H-2F61
(ucs-set-char #x684C ?$(DC[(B) ; J90-D-435B
(ucs-set-char #x684C ?$(GV$(B) ; C01-G-5624
(ucs-set-char #x684C ?$AW@(B) ; GB0-A-5740
(ucs-set-char #x684D ?$(H/s(B) ; C02-H-2F73
(ucs-set-char #x684D ?$@[](B) ; J78-@-5B5D
(ucs-set-char #x684D ?$B[](B) ; J83-B-5B5D
(ucs-set-char #x684E ?$(Crn(B) ; KS0-C-726E
(ucs-set-char #x684E ?$(H/j(B) ; C02-H-2F6A
(ucs-set-char #x684E ?$@[_(B) ; J78-@-5B5F
(ucs-set-char #x684E ?$Ahd(B) ; GB0-A-6864
(ucs-set-char #x684E ?$B[_(B) ; J83-B-5B5F
(ucs-set-char #x684F ?$(H/b(B) ; C02-H-2F62
(ucs-set-char #x6850 ?$(CTU(B) ; KS0-C-5455
(ucs-set-char #x6850 ?$(GV((B) ; C01-G-5628
(ucs-set-char #x6850 ?$@6M(B) ; J78-@-364D
(ucs-set-char #x6850 ?$AM)(B) ; GB0-A-4D29
(ucs-set-char #x6850 ?$B6M(B) ; J83-B-364D
(ucs-set-char #x6851 ?$(C_M(B) ; KS0-C-5F4D
(ucs-set-char #x6851 ?$(GV%(B) ; C01-G-5625
(ucs-set-char #x6851 ?$@7,(B) ; J78-@-372C
(ucs-set-char #x6851 ?$AI#(B) ; GB0-A-4923
(ucs-set-char #x6851 ?$B7,(B) ; J83-B-372C
(ucs-set-char #x6852 ?$(DCI(B) ; J90-D-4349
(ucs-set-char #x6852 ?$(I-/(B) ; C03-I-2D2F
(ucs-set-char #x6853 ?$(C|8(B) ; KS0-C-7C38
(ucs-set-char #x6853 ?$(GU{(B) ; C01-G-557B
(ucs-set-char #x6853 ?$@4<(B) ; J78-@-343C
(ucs-set-char #x6853 ?$A;8(B) ; GB0-A-3B38
(ucs-set-char #x6853 ?$B4<(B) ; J83-B-343C
(ucs-set-char #x6854 ?$(CQP(B) ; KS0-C-5150
(ucs-set-char #x6854 ?$(GU~(B) ; C01-G-557E
(ucs-set-char #x6854 ?$@5K(B) ; J78-@-354B
(ucs-set-char #x6854 ?$A=[(B) ; GB0-A-3D5B
(ucs-set-char #x6854 ?$B5K(B) ; J83-B-354B
(ucs-set-char #x6855 ?$(DC\(B) ; J90-D-435C
(ucs-set-char #x6855 ?$(I1b(B) ; C03-I-3162
(ucs-set-char #x6855 ?$Ahj(B) ; GB0-A-686A
(ucs-set-char #x6856 ?$(I1X(B) ; C03-I-3158
(ucs-set-char #x6857 ?$(DC](B) ; J90-D-435D
(ucs-set-char #x6857 ?$(J-S(B) ; C04-J-2D53
(ucs-set-char #x6858 ?$(DC^(B) ; J90-D-435E
(ucs-set-char #x6858 ?$(I1a(B) ; C03-I-3161
(ucs-set-char #x6859 ?$(I1`(B) ; C03-I-3160
(ucs-set-char #x6859 ?$@[b(B) ; J78-@-5B62
(ucs-set-char #x6859 ?$B[b(B) ; J83-B-5B62
(ucs-set-char #x685B ?$(DC_(B) ; J90-D-435F
(ucs-set-char #x685C ?$@:y(B) ; J78-@-3A79
(ucs-set-char #x685C ?$B:y(B) ; J83-B-3A79
(ucs-set-char #x685D ?$@Kq(B) ; J78-@-4B71
(ucs-set-char #x685D ?$BKq(B) ; J83-B-4B71
(ucs-set-char #x685F ?$@;7(B) ; J78-@-3B37
(ucs-set-char #x685F ?$B;7(B) ; J83-B-3B37
(ucs-set-char #x6860 ?$Ahb(B) ; GB0-A-6862
(ucs-set-char #x6861 ?$Ahc(B) ; GB0-A-6863
(ucs-set-char #x6862 ?$Ahe(B) ; GB0-A-6865
(ucs-set-char #x6863 ?$@[c(B) ; J78-@-5B63
(ucs-set-char #x6863 ?$A55(B) ; GB0-A-3535
(ucs-set-char #x6863 ?$B[c(B) ; J83-B-5B63
(ucs-set-char #x6864 ?$Ahg(B) ; GB0-A-6867
(ucs-set-char #x6865 ?$AGE(B) ; GB0-A-4745
(ucs-set-char #x6866 ?$Ahk(B) ; GB0-A-686B
(ucs-set-char #x6867 ?$@[X(B) ; J78-@-5B58
(ucs-set-char #x6867 ?$Ahm(B) ; GB0-A-686D
(ucs-set-char #x6867 ?$BI0(B) ; J83-B-4930
(ucs-set-char #x6868 ?$A=0(B) ; GB0-A-3D30
(ucs-set-char #x6869 ?$AW.(B) ; GB0-A-572E
(ucs-set-char #x686B ?$(DC`(B) ; J90-D-4360
(ucs-set-char #x686B ?$(H6((B) ; C02-H-3628
(ucs-set-char #x686B ?$Ahx(B) ; GB0-A-6878
(ucs-set-char #x686C ?$(I6U(B) ; C03-I-3655
(ucs-set-char #x686D ?$(CrM(B) ; KS0-C-724D
(ucs-set-char #x686D ?$(H5v(B) ; C02-H-3576
(ucs-set-char #x686E ?$(DCa(B) ; J90-D-4361
(ucs-set-char #x686E ?$(H5w(B) ; C02-H-3577
(ucs-set-char #x686F ?$(DCb(B) ; J90-D-4362
(ucs-set-char #x686F ?$(H5{(B) ; C02-H-357B
(ucs-set-char #x6870 ?$(DCc(B) ; J90-D-4363
(ucs-set-char #x6870 ?$(I6`(B) ; C03-I-3660
(ucs-set-char #x6871 ?$(DCd(B) ; J90-D-4364
(ucs-set-char #x6871 ?$(H6,(B) ; C02-H-362C
(ucs-set-char #x6872 ?$(DCe(B) ; J90-D-4365
(ucs-set-char #x6872 ?$(H6)(B) ; C02-H-3629
(ucs-set-char #x6873 ?$(I6N(B) ; C03-I-364E
(ucs-set-char #x6874 ?$(H6"(B) ; C02-H-3622
(ucs-set-char #x6874 ?$@[o(B) ; J78-@-5B6F
(ucs-set-char #x6874 ?$Ahu(B) ; GB0-A-6875
(ucs-set-char #x6874 ?$B[o(B) ; J83-B-5B6F
(ucs-set-char #x6875 ?$(DCf(B) ; J90-D-4366
(ucs-set-char #x6875 ?$(H6!(B) ; C02-H-3621
(ucs-set-char #x6876 ?$(CwR(B) ; KS0-C-7752
(ucs-set-char #x6876 ?$(G[3(B) ; C01-G-5B33
(ucs-set-char #x6876 ?$@23(B) ; J78-@-3233
(ucs-set-char #x6876 ?$AM0(B) ; GB0-A-4D30
(ucs-set-char #x6876 ?$B23(B) ; J83-B-3233
(ucs-set-char #x6877 ?$(H6%(B) ; C02-H-3625
(ucs-set-char #x6877 ?$@[d(B) ; J78-@-5B64
(ucs-set-char #x6877 ?$Ahv(B) ; GB0-A-6876
(ucs-set-char #x6877 ?$B[d(B) ; J83-B-5B64
(ucs-set-char #x6878 ?$(H64(B) ; C02-H-3634
(ucs-set-char #x6879 ?$(DCg(B) ; J90-D-4367
(ucs-set-char #x6879 ?$(H5r(B) ; C02-H-3572
(ucs-set-char #x687A ?$(DCh(B) ; J90-D-4368
(ucs-set-char #x687A ?$(I6[(B) ; C03-I-365B
(ucs-set-char #x687B ?$(DCi(B) ; J90-D-4369
(ucs-set-char #x687B ?$(H65(B) ; C02-H-3635
(ucs-set-char #x687C ?$(DCj(B) ; J90-D-436A
(ucs-set-char #x687C ?$(H6'(B) ; C02-H-3627
(ucs-set-char #x687D ?$(H69(B) ; C02-H-3639
(ucs-set-char #x687E ?$(H6-(B) ; C02-H-362D
(ucs-set-char #x687E ?$@[u(B) ; J78-@-5B75
(ucs-set-char #x687E ?$B[u(B) ; J83-B-5B75
(ucs-set-char #x687F ?$(CJT(B) ; KS0-C-4A54
(ucs-set-char #x687F ?$(G[2(B) ; C01-G-5B32
(ucs-set-char #x687F ?$@[e(B) ; J78-@-5B65
(ucs-set-char #x687F ?$B[e(B) ; J83-B-5B65
(ucs-set-char #x6880 ?$(H6+(B) ; C02-H-362B
(ucs-set-char #x6881 ?$(CUY(B) ; KS0-C-5559
(ucs-set-char #x6881 ?$(G[-(B) ; C01-G-5B2D
(ucs-set-char #x6881 ?$@NB(B) ; J78-@-4E42
(ucs-set-char #x6881 ?$AA:(B) ; GB0-A-413A
(ucs-set-char #x6881 ?$BNB(B) ; J83-B-4E42
(ucs-set-char #x6882 ?$(DCk(B) ; J90-D-436B
(ucs-set-char #x6882 ?$(G[B(B) ; C01-G-5B42
(ucs-set-char #x6883 ?$(G[8(B) ; C01-G-5B38
(ucs-set-char #x6883 ?$@[l(B) ; J78-@-5B6C
(ucs-set-char #x6883 ?$Ahh(B) ; GB0-A-6868
(ucs-set-char #x6883 ?$B[l(B) ; J83-B-5B6C
(ucs-set-char #x6884 ?$(DCl(B) ; J90-D-436C
(ucs-set-char #x6884 ?$(I6W(B) ; C03-I-3657
(ucs-set-char #x6885 ?$(CX^(B) ; KS0-C-585E
(ucs-set-char #x6885 ?$(G[<(B) ; C01-G-5B3C
(ucs-set-char #x6885 ?$(J-\(B) ; C04-J-2D5C
(ucs-set-char #x6885 ?$@G_(B) ; J78-@-475F
(ucs-set-char #x6885 ?$AC7(B) ; GB0-A-4337
(ucs-set-char #x6885 ?$BG_(B) ; J83-B-475F
(ucs-set-char #x6886 ?$(DCm(B) ; J90-D-436D
(ucs-set-char #x6886 ?$(G[;(B) ; C01-G-5B3B
(ucs-set-char #x6886 ?$A0p(B) ; GB0-A-3070
(ucs-set-char #x6887 ?$(H5s(B) ; C02-H-3573
(ucs-set-char #x6888 ?$(DCn(B) ; J90-D-436E
(ucs-set-char #x6888 ?$(J2?(B) ; C04-J-323F
(ucs-set-char #x6889 ?$(H62(B) ; C02-H-3632
(ucs-set-char #x688A ?$(H68(B) ; C02-H-3638
(ucs-set-char #x688B ?$(H60(B) ; C02-H-3630
(ucs-set-char #x688C ?$(H67(B) ; C02-H-3637
(ucs-set-char #x688D ?$B[t(B) ; J83-B-5B74
(ucs-set-char #x688E ?$(I6Q(B) ; C03-I-3651
(ucs-set-char #x688E ?$(K2~(B) ; C05-K-327E
(ucs-set-char #x688E ?$@[t(B) ; J78-@-5B74
(ucs-set-char #x688F ?$(CMY(B) ; KS0-C-4D59
(ucs-set-char #x688F ?$(H6$(B) ; C02-H-3624
(ucs-set-char #x688F ?$@[g(B) ; J78-@-5B67
(ucs-set-char #x688F ?$Aht(B) ; GB0-A-6874
(ucs-set-char #x688F ?$B[g(B) ; J83-B-5B67
(ucs-set-char #x6890 ?$(H5t(B) ; C02-H-3574
(ucs-set-char #x6891 ?$(H66(B) ; C02-H-3636
(ucs-set-char #x6892 ?$(H6&(B) ; C02-H-3626
(ucs-set-char #x6893 ?$(Cn)(B) ; KS0-C-6E29
(ucs-set-char #x6893 ?$(G[0(B) ; C01-G-5B30
(ucs-set-char #x6893 ?$@04(B) ; J78-@-3034
(ucs-set-char #x6893 ?$Ahw(B) ; GB0-A-6877
(ucs-set-char #x6893 ?$B04(B) ; J83-B-3034
(ucs-set-char #x6894 ?$(Cv<(B) ; KS0-C-763C
(ucs-set-char #x6894 ?$(G[=(B) ; C01-G-5B3D
(ucs-set-char #x6894 ?$@[i(B) ; J78-@-5B69
(ucs-set-char #x6894 ?$B[i(B) ; J83-B-5B69
(ucs-set-char #x6895 ?$(I6Z(B) ; C03-I-365A
(ucs-set-char #x6896 ?$(DCo(B) ; J90-D-436F
(ucs-set-char #x6896 ?$(H6/(B) ; C02-H-362F
(ucs-set-char #x6897 ?$(CL[(B) ; KS0-C-4C5B
(ucs-set-char #x6897 ?$(G[6(B) ; C01-G-5B36
(ucs-set-char #x6897 ?$@9<(B) ; J78-@-393C
(ucs-set-char #x6897 ?$A9#(B) ; GB0-A-3923
(ucs-set-char #x6897 ?$B9<(B) ; J83-B-393C
(ucs-set-char #x6898 ?$(DCp(B) ; J90-D-4370
(ucs-set-char #x6898 ?$(I6M(B) ; C03-I-364D
(ucs-set-char #x6899 ?$(I6\(B) ; C03-I-365C
(ucs-set-char #x689A ?$(DCq(B) ; J90-D-4371
(ucs-set-char #x689A ?$(I6P(B) ; C03-I-3650
(ucs-set-char #x689B ?$(H6.(B) ; C02-H-362E
(ucs-set-char #x689B ?$@[k(B) ; J78-@-5B6B
(ucs-set-char #x689B ?$B[k(B) ; J83-B-5B6B
(ucs-set-char #x689C ?$(DCr(B) ; J90-D-4372
(ucs-set-char #x689C ?$(H5u(B) ; C02-H-3575
(ucs-set-char #x689D ?$(CpI(B) ; KS0-C-7049
(ucs-set-char #x689D ?$(G[>(B) ; C01-G-5B3E
(ucs-set-char #x689D ?$@[j(B) ; J78-@-5B6A
(ucs-set-char #x689D ?$B[j(B) ; J83-B-5B6A
(ucs-set-char #x689E ?$(I6K(B) ; C03-I-364B
(ucs-set-char #x689F ?$(C||(B) ; KS0-C-7C7C
(ucs-set-char #x689F ?$(G[@(B) ; C01-G-5B40
(ucs-set-char #x689F ?$@[f(B) ; J78-@-5B66
(ucs-set-char #x689F ?$B[f(B) ; J83-B-5B66
(ucs-set-char #x68A0 ?$(H61(B) ; C02-H-3631
(ucs-set-char #x68A0 ?$@[q(B) ; J78-@-5B71
(ucs-set-char #x68A0 ?$B[q(B) ; J83-B-5B71
(ucs-set-char #x68A1 ?$(ChI(B) ; KS0-C-6849
(ucs-set-char #x68A1 ?$(DCs(B) ; J90-D-4373
(ucs-set-char #x68A1 ?$(G[A(B) ; C01-G-5B41
(ucs-set-char #x68A2 ?$(Ct~(B) ; KS0-C-747E
(ucs-set-char #x68A2 ?$(G[/(B) ; C01-G-5B2F
(ucs-set-char #x68A2 ?$@>?(B) ; J78-@-3E3F
(ucs-set-char #x68A2 ?$AIR(B) ; GB0-A-4952
(ucs-set-char #x68A2 ?$B>?(B) ; J83-B-3E3F
(ucs-set-char #x68A3 ?$(DCt(B) ; J90-D-4374
(ucs-set-char #x68A3 ?$(H5|(B) ; C02-H-357C
(ucs-set-char #x68A4 ?$(H63(B) ; C02-H-3633
(ucs-set-char #x68A5 ?$(DCu(B) ; J90-D-4375
(ucs-set-char #x68A5 ?$(I6T(B) ; C03-I-3654
(ucs-set-char #x68A6 ?$(I4x(B) ; C03-I-3478
(ucs-set-char #x68A6 ?$@Tm(B) ; J78-@-546D
(ucs-set-char #x68A6 ?$ACN(B) ; GB0-A-434E
(ucs-set-char #x68A6 ?$BTm(B) ; J83-B-546D
(ucs-set-char #x68A7 ?$(Cg|(B) ; KS0-C-677C
(ucs-set-char #x68A7 ?$(G[5(B) ; C01-G-5B35
(ucs-set-char #x68A7 ?$@8h(B) ; J78-@-3868
(ucs-set-char #x68A7 ?$AN`(B) ; GB0-A-4E60
(ucs-set-char #x68A7 ?$B8h(B) ; J83-B-3868
(ucs-set-char #x68A8 ?$(CW^(B) ; KS0-C-575E
(ucs-set-char #x68A8 ?$(G[?(B) ; C01-G-5B3F
(ucs-set-char #x68A8 ?$@M|(B) ; J78-@-4D7C
(ucs-set-char #x68A8 ?$A@f(B) ; GB0-A-4066
(ucs-set-char #x68A8 ?$BM|(B) ; J83-B-4D7C
(ucs-set-char #x68A9 ?$(DCv(B) ; J90-D-4376
(ucs-set-char #x68A9 ?$(H5~(B) ; C02-H-357E
(ucs-set-char #x68AA ?$(DCw(B) ; J90-D-4377
(ucs-set-char #x68AA ?$(H6*(B) ; C02-H-362A
(ucs-set-char #x68AB ?$(H5y(B) ; C02-H-3579
(ucs-set-char #x68AC ?$(H5}(B) ; C02-H-357D
(ucs-set-char #x68AD ?$(C^\(B) ; KS0-C-5E5C
(ucs-set-char #x68AD ?$(G[:(B) ; C01-G-5B3A
(ucs-set-char #x68AD ?$@[h(B) ; J78-@-5B68
(ucs-set-char #x68AD ?$AKs(B) ; GB0-A-4B73
(ucs-set-char #x68AD ?$B[h(B) ; J83-B-5B68
(ucs-set-char #x68AE ?$(DCx(B) ; J90-D-4378
(ucs-set-char #x68AE ?$(H5x(B) ; C02-H-3578
(ucs-set-char #x68AF ?$(Cp,(B) ; KS0-C-702C
(ucs-set-char #x68AF ?$(G[.(B) ; C01-G-5B2E
(ucs-set-char #x68AF ?$@Dt(B) ; J78-@-4474
(ucs-set-char #x68AF ?$AL](B) ; GB0-A-4C5D
(ucs-set-char #x68AF ?$BDt(B) ; J83-B-4474
(ucs-set-char #x68B0 ?$(CL~(B) ; KS0-C-4C7E
(ucs-set-char #x68B0 ?$(G[7(B) ; C01-G-5B37
(ucs-set-char #x68B0 ?$@3#(B) ; J78-@-3323
(ucs-set-char #x68B0 ?$AP5(B) ; GB0-A-5035
(ucs-set-char #x68B0 ?$B3#(B) ; J83-B-3323
(ucs-set-char #x68B1 ?$(CMa(B) ; KS0-C-4D61
(ucs-set-char #x68B1 ?$(G[4(B) ; C01-G-5B34
(ucs-set-char #x68B1 ?$@:-(B) ; J78-@-3A2D
(ucs-set-char #x68B1 ?$B:-(B) ; J83-B-3A2D
(ucs-set-char #x68B2 ?$(DCy(B) ; J90-D-4379
(ucs-set-char #x68B2 ?$(H6#(B) ; C02-H-3623
(ucs-set-char #x68B3 ?$(Ca:(B) ; KS0-C-613A
(ucs-set-char #x68B3 ?$(GV"(B) ; C01-G-5622
(ucs-set-char #x68B3 ?$@[`(B) ; J78-@-5B60
(ucs-set-char #x68B3 ?$AJa(B) ; GB0-A-4A61
(ucs-set-char #x68B3 ?$B[`(B) ; J83-B-5B60
(ucs-set-char #x68B4 ?$(H<c(B) ; C02-H-3C63
(ucs-set-char #x68B5 ?$(C[o(B) ; KS0-C-5B6F
(ucs-set-char #x68B5 ?$(G[1(B) ; C01-G-5B31
(ucs-set-char #x68B5 ?$@[p(B) ; J78-@-5B70
(ucs-set-char #x68B5 ?$Ahs(B) ; GB0-A-6873
(ucs-set-char #x68B5 ?$B[p(B) ; J83-B-5B70
(ucs-set-char #x68B6 ?$(CZ2(B) ; KS0-C-5A32
(ucs-set-char #x68B6 ?$(I6L(B) ; C03-I-364C
(ucs-set-char #x68B6 ?$@3a(B) ; J78-@-3361
(ucs-set-char #x68B6 ?$B3a(B) ; J83-B-3361
(ucs-set-char #x68B7 ?$(I6R(B) ; C03-I-3652
(ucs-set-char #x68B8 ?$(I6^(B) ; C03-I-365E
(ucs-set-char #x68B9 ?$(I6_(B) ; C03-I-365F
(ucs-set-char #x68B9 ?$@[n(B) ; J78-@-5B6E
(ucs-set-char #x68B9 ?$B[n(B) ; J83-B-5B6E
(ucs-set-char #x68BA ?$@[r(B) ; J78-@-5B72
(ucs-set-char #x68BA ?$B[r(B) ; J83-B-5B72
(ucs-set-char #x68BB ?$(DCz(B) ; J90-D-437A
(ucs-set-char #x68BC ?$@[m(B) ; J78-@-5B6D
(ucs-set-char #x68BC ?$BEn(B) ; J83-B-456E
(ucs-set-char #x68C0 ?$A<l(B) ; GB0-A-3C6C
(ucs-set-char #x68C1 ?$(I6V(B) ; C03-I-3656
(ucs-set-char #x68C2 ?$Ahy(B) ; GB0-A-6879
(ucs-set-char #x68C3 ?$(I<E(B) ; C03-I-3C45
(ucs-set-char #x68C4 ?$(CQ%(B) ; KS0-C-5125
(ucs-set-char #x68C4 ?$(G[9(B) ; C01-G-5B39
(ucs-set-char #x68C4 ?$@4~(B) ; J78-@-347E
(ucs-set-char #x68C4 ?$B4~(B) ; J83-B-347E
(ucs-set-char #x68C5 ?$(C\8(B) ; KS0-C-5C38
(ucs-set-char #x68C5 ?$(DC{(B) ; J90-D-437B
(ucs-set-char #x68C5 ?$(I<A(B) ; C03-I-3C41
(ucs-set-char #x68C6 ?$(H<f(B) ; C02-H-3C66
(ucs-set-char #x68C6 ?$@\2(B) ; J78-@-5C32
(ucs-set-char #x68C6 ?$B\2(B) ; J83-B-5C32
(ucs-set-char #x68C7 ?$(H<|(B) ; C02-H-3C7C
(ucs-set-char #x68C8 ?$(DC|(B) ; J90-D-437C
(ucs-set-char #x68C8 ?$(H<q(B) ; C02-H-3C71
(ucs-set-char #x68C9 ?$(CXv(B) ; KS0-C-5876
(ucs-set-char #x68C9 ?$(G_{(B) ; C01-G-5F7B
(ucs-set-char #x68C9 ?$@LI(B) ; J78-@-4C49
(ucs-set-char #x68C9 ?$AC^(B) ; GB0-A-435E
(ucs-set-char #x68C9 ?$BLI(B) ; J83-B-4C49
(ucs-set-char #x68CA ?$(I<8(B) ; C03-I-3C38
(ucs-set-char #x68CA ?$@[w(B) ; J78-@-5B77
(ucs-set-char #x68CA ?$B[w(B) ; J83-B-5B77
(ucs-set-char #x68CB ?$(CQ$(B) ; KS0-C-5124
(ucs-set-char #x68CB ?$(G_v(B) ; C01-G-5F76
(ucs-set-char #x68CB ?$@4}(B) ; J78-@-347D
(ucs-set-char #x68CB ?$AFe(B) ; GB0-A-4665
(ucs-set-char #x68CB ?$B4}(B) ; J83-B-347D
(ucs-set-char #x68CC ?$(DC}(B) ; J90-D-437D
(ucs-set-char #x68CC ?$(H<`(B) ; C02-H-3C60
(ucs-set-char #x68CD ?$(CMb(B) ; KS0-C-4D62
(ucs-set-char #x68CD ?$(G_w(B) ; C01-G-5F77
(ucs-set-char #x68CD ?$@[~(B) ; J78-@-5B7E
(ucs-set-char #x68CD ?$A9w(B) ; GB0-A-3977
(ucs-set-char #x68CD ?$B[~(B) ; J83-B-5B7E
(ucs-set-char #x68CE ?$(H<p(B) ; C02-H-3C70
(ucs-set-char #x68CF ?$(DC~(B) ; J90-D-437E
(ucs-set-char #x68CF ?$(I<>(B) ; C03-I-3C3E
(ucs-set-char #x68D0 ?$(DD!(B) ; J90-D-4421
(ucs-set-char #x68D0 ?$(H<i(B) ; C02-H-3C69
(ucs-set-char #x68D1 ?$(DD"(B) ; J90-D-4422
(ucs-set-char #x68D1 ?$(H<v(B) ; C02-H-3C76
(ucs-set-char #x68D2 ?$(C\j(B) ; KS0-C-5C6A
(ucs-set-char #x68D2 ?$(G_s(B) ; C01-G-5F73
(ucs-set-char #x68D2 ?$@K@(B) ; J78-@-4B40
(ucs-set-char #x68D2 ?$A0t(B) ; GB0-A-3074
(ucs-set-char #x68D2 ?$BK@(B) ; J83-B-4B40
(ucs-set-char #x68D3 ?$(DD#(B) ; J90-D-4423
(ucs-set-char #x68D3 ?$(H<N(B) ; C02-H-3C4E
(ucs-set-char #x68D4 ?$(H<x(B) ; C02-H-3C78
(ucs-set-char #x68D4 ?$@\!(B) ; J78-@-5C21
(ucs-set-char #x68D4 ?$B\!(B) ; J83-B-5C21
(ucs-set-char #x68D5 ?$(Cpw(B) ; KS0-C-7077
(ucs-set-char #x68D5 ?$(G_i(B) ; C01-G-5F69
(ucs-set-char #x68D5 ?$@\#(B) ; J78-@-5C23
(ucs-set-char #x68D5 ?$AWX(B) ; GB0-A-5758
(ucs-set-char #x68D5 ?$B\#(B) ; J83-B-5C23
(ucs-set-char #x68D6 ?$(DD$(B) ; J90-D-4424
(ucs-set-char #x68D6 ?$(H<V(B) ; C02-H-3C56
(ucs-set-char #x68D7 ?$(CpJ(B) ; KS0-C-704A
(ucs-set-char #x68D7 ?$(G_l(B) ; C01-G-5F6C
(ucs-set-char #x68D7 ?$@\'(B) ; J78-@-5C27
(ucs-set-char #x68D7 ?$B\'(B) ; J83-B-5C27
(ucs-set-char #x68D8 ?$(CP>(B) ; KS0-C-503E
(ucs-set-char #x68D8 ?$(G_k(B) ; C01-G-5F6B
(ucs-set-char #x68D8 ?$@[y(B) ; J78-@-5B79
(ucs-set-char #x68D8 ?$A<,(B) ; GB0-A-3C2C
(ucs-set-char #x68D8 ?$B[y(B) ; J83-B-5B79
(ucs-set-char #x68D9 ?$(DD%(B) ; J90-D-4425
(ucs-set-char #x68D9 ?$(J82(B) ; C04-J-3832
(ucs-set-char #x68DA ?$(C]\(B) ; KS0-C-5D5C
(ucs-set-char #x68DA ?$(G_|(B) ; C01-G-5F7C
(ucs-set-char #x68DA ?$@C*(B) ; J78-@-432A
(ucs-set-char #x68DA ?$AEo(B) ; GB0-A-456F
(ucs-set-char #x68DA ?$BC*(B) ; J83-B-432A
(ucs-set-char #x68DB ?$(I6S(B) ; C03-I-3653
(ucs-set-char #x68DC ?$(DD&(B) ; J90-D-4426
(ucs-set-char #x68DC ?$(H<P(B) ; C02-H-3C50
(ucs-set-char #x68DD ?$(DD'(B) ; J90-D-4427
(ucs-set-char #x68DD ?$(H<r(B) ; C02-H-3C72
(ucs-set-char #x68DE ?$(H<s(B) ; C02-H-3C73
(ucs-set-char #x68DF ?$(CTV(B) ; KS0-C-5456
(ucs-set-char #x68DF ?$(G_n(B) ; C01-G-5F6E
(ucs-set-char #x68DF ?$@Eo(B) ; J78-@-456F
(ucs-set-char #x68DF ?$BEo(B) ; J83-B-456F
(ucs-set-char #x68E0 ?$(CSV(B) ; KS0-C-5356
(ucs-set-char #x68E0 ?$(G_j(B) ; C01-G-5F6A
(ucs-set-char #x68E0 ?$@\+(B) ; J78-@-5C2B
(ucs-set-char #x68E0 ?$ALD(B) ; GB0-A-4C44
(ucs-set-char #x68E0 ?$B\+(B) ; J83-B-5C2B
(ucs-set-char #x68E1 ?$(H<^(B) ; C02-H-3C5E
(ucs-set-char #x68E1 ?$@[|(B) ; J78-@-5B7C
(ucs-set-char #x68E1 ?$B[|(B) ; J83-B-5B7C
(ucs-set-char #x68E2 ?$(I<=(B) ; C03-I-3C3D
(ucs-set-char #x68E3 ?$(G_u(B) ; C01-G-5F75
(ucs-set-char #x68E3 ?$@\((B) ; J78-@-5C28
(ucs-set-char #x68E3 ?$Ai&(B) ; GB0-A-6926
(ucs-set-char #x68E3 ?$B\((B) ; J83-B-5C28
(ucs-set-char #x68E4 ?$(H<Y(B) ; C02-H-3C59
(ucs-set-char #x68E5 ?$(DD((B) ; J90-D-4428
(ucs-set-char #x68E5 ?$(I<2(B) ; C03-I-3C32
(ucs-set-char #x68E6 ?$(H<t(B) ; C02-H-3C74
(ucs-set-char #x68E7 ?$(CmP(B) ; KS0-C-6D50
(ucs-set-char #x68E7 ?$(G_q(B) ; C01-G-5F71
(ucs-set-char #x68E7 ?$@\"(B) ; J78-@-5C22
(ucs-set-char #x68E7 ?$B\"(B) ; J83-B-5C22
(ucs-set-char #x68E8 ?$(CM!(B) ; KS0-C-4D21
(ucs-set-char #x68E8 ?$(DD)(B) ; J90-D-4429
(ucs-set-char #x68E8 ?$(H<l(B) ; C02-H-3C6C
(ucs-set-char #x68E9 ?$(H<y(B) ; C02-H-3C79
(ucs-set-char #x68EA ?$(DD*(B) ; J90-D-442A
(ucs-set-char #x68EA ?$(H<S(B) ; C02-H-3C53
(ucs-set-char #x68EB ?$(DD+(B) ; J90-D-442B
(ucs-set-char #x68EB ?$(H<X(B) ; C02-H-3C58
(ucs-set-char #x68EC ?$(DD,(B) ; J90-D-442C
(ucs-set-char #x68EC ?$(H<R(B) ; C02-H-3C52
(ucs-set-char #x68ED ?$(DD-(B) ; J90-D-442D
(ucs-set-char #x68ED ?$(I<*(B) ; C03-I-3C2A
(ucs-set-char #x68EE ?$(C_5(B) ; KS0-C-5F35
(ucs-set-char #x68EE ?$(G_p(B) ; C01-G-5F70
(ucs-set-char #x68EE ?$@?9(B) ; J78-@-3F39
(ucs-set-char #x68EE ?$AI-(B) ; GB0-A-492D
(ucs-set-char #x68EE ?$B?9(B) ; J83-B-3F39
(ucs-set-char #x68EF ?$(H<e(B) ; C02-H-3C65
(ucs-set-char #x68EF ?$@\,(B) ; J78-@-5C2C
(ucs-set-char #x68EF ?$B\,(B) ; J83-B-5C2C
(ucs-set-char #x68F0 ?$(DD.(B) ; J90-D-442E
(ucs-set-char #x68F0 ?$(HCd(B) ; C02-H-4364
(ucs-set-char #x68F0 ?$Ai"(B) ; GB0-A-6922
(ucs-set-char #x68F1 ?$(DD/(B) ; J90-D-442F
(ucs-set-char #x68F1 ?$(H<T(B) ; C02-H-3C54
(ucs-set-char #x68F1 ?$A@b(B) ; GB0-A-4062
(ucs-set-char #x68F2 ?$(C_x(B) ; KS0-C-5F78
(ucs-set-char #x68F2 ?$(G_t(B) ; C01-G-5F74
(ucs-set-char #x68F2 ?$@@3(B) ; J78-@-4033
(ucs-set-char #x68F2 ?$B@3(B) ; J83-B-4033
(ucs-set-char #x68F3 ?$(H<](B) ; C02-H-3C5D
(ucs-set-char #x68F4 ?$(H<u(B) ; C02-H-3C75
(ucs-set-char #x68F5 ?$(DD0(B) ; J90-D-4430
(ucs-set-char #x68F5 ?$(G_o(B) ; C01-G-5F6F
(ucs-set-char #x68F5 ?$A?C(B) ; GB0-A-3F43
(ucs-set-char #x68F6 ?$(DD1(B) ; J90-D-4431
(ucs-set-char #x68F6 ?$(H<Z(B) ; C02-H-3C5A
(ucs-set-char #x68F7 ?$(H<W(B) ; C02-H-3C57
(ucs-set-char #x68F8 ?$(H<h(B) ; C02-H-3C68
(ucs-set-char #x68F9 ?$(CT!(B) ; KS0-C-5421
(ucs-set-char #x68F9 ?$(G_r(B) ; C01-G-5F72
(ucs-set-char #x68F9 ?$@\*(B) ; J78-@-5C2A
(ucs-set-char #x68F9 ?$Ah~(B) ; GB0-A-687E
(ucs-set-char #x68F9 ?$B\*(B) ; J83-B-5C2A
(ucs-set-char #x68FA ?$(CN2(B) ; KS0-C-4E32
(ucs-set-char #x68FA ?$(G_h(B) ; C01-G-5F68
(ucs-set-char #x68FA ?$@4=(B) ; J78-@-343D
(ucs-set-char #x68FA ?$A9W(B) ; GB0-A-3957
(ucs-set-char #x68FA ?$B4=(B) ; J83-B-343D
(ucs-set-char #x68FB ?$(DD2(B) ; J90-D-4432
(ucs-set-char #x68FB ?$(G_~(B) ; C01-G-5F7E
(ucs-set-char #x68FC ?$(DD3(B) ; J90-D-4433
(ucs-set-char #x68FC ?$(H<k(B) ; C02-H-3C6B
(ucs-set-char #x68FC ?$Ah{(B) ; GB0-A-687B
(ucs-set-char #x68FD ?$(DD4(B) ; J90-D-4434
(ucs-set-char #x68FD ?$(H<j(B) ; C02-H-3C6A
(ucs-set-char #x68FE ?$(I<1(B) ; C03-I-3C31
(ucs-set-char #x68FF ?$(I<B(B) ; C03-I-3C42
(ucs-set-char #x6900 ?$(ChJ(B) ; KS0-C-684A
(ucs-set-char #x6900 ?$(I<9(B) ; C03-I-3C39
(ucs-set-char #x6900 ?$@OP(B) ; J78-@-4F50
(ucs-set-char #x6900 ?$BOP(B) ; J83-B-4F50
(ucs-set-char #x6901 ?$(I<;(B) ; C03-I-3C3B
(ucs-set-char #x6901 ?$@[v(B) ; J78-@-5B76
(ucs-set-char #x6901 ?$Ai$(B) ; GB0-A-6924
(ucs-set-char #x6901 ?$B[v(B) ; J83-B-5B76
(ucs-set-char #x6902 ?$(I<4(B) ; C03-I-3C34
(ucs-set-char #x6903 ?$(I</(B) ; C03-I-3C2F
(ucs-set-char #x6904 ?$(H<O(B) ; C02-H-3C4F
(ucs-set-char #x6904 ?$@\&(B) ; J78-@-5C26
(ucs-set-char #x6904 ?$B\&(B) ; J83-B-5C26
(ucs-set-char #x6905 ?$(Cku(B) ; KS0-C-6B75
(ucs-set-char #x6905 ?$(G_m(B) ; C01-G-5F6D
(ucs-set-char #x6905 ?$@0X(B) ; J78-@-3058
(ucs-set-char #x6905 ?$ARN(B) ; GB0-A-524E
(ucs-set-char #x6905 ?$B0X(B) ; J83-B-3058
(ucs-set-char #x6906 ?$(DD5(B) ; J90-D-4435
(ucs-set-char #x6906 ?$(H<w(B) ; C02-H-3C77
(ucs-set-char #x6907 ?$(H<_(B) ; C02-H-3C5F
(ucs-set-char #x6908 ?$(H<a(B) ; C02-H-3C61
(ucs-set-char #x6908 ?$@[x(B) ; J78-@-5B78
(ucs-set-char #x6908 ?$B[x(B) ; J83-B-5B78
(ucs-set-char #x6909 ?$(DD6(B) ; J90-D-4436
(ucs-set-char #x6909 ?$(I<7(B) ; C03-I-3C37
(ucs-set-char #x690A ?$(DD7(B) ; J90-D-4437
(ucs-set-char #x690A ?$(H<n(B) ; C02-H-3C6E
(ucs-set-char #x690B ?$(H<m(B) ; C02-H-3C6D
(ucs-set-char #x690B ?$@L:(B) ; J78-@-4C3A
(ucs-set-char #x690B ?$Ai#(B) ; GB0-A-6923
(ucs-set-char #x690B ?$BL:(B) ; J83-B-4C3A
(ucs-set-char #x690C ?$(H<M(B) ; C02-H-3C4D
(ucs-set-char #x690C ?$@[}(B) ; J78-@-5B7D
(ucs-set-char #x690C ?$B[}(B) ; J83-B-5B7D
(ucs-set-char #x690D ?$(CcU(B) ; KS0-C-6355
(ucs-set-char #x690D ?$(G_x(B) ; C01-G-5F78
(ucs-set-char #x690D ?$@?"(B) ; J78-@-3F22
(ucs-set-char #x690D ?$AV2(B) ; GB0-A-5632
(ucs-set-char #x690D ?$B?"(B) ; J83-B-3F22
(ucs-set-char #x690E ?$(CuP(B) ; KS0-C-7550
(ucs-set-char #x690E ?$(G_z(B) ; C01-G-5F7A
(ucs-set-char #x690E ?$@DG(B) ; J78-@-4447
(ucs-set-char #x690E ?$AW5(B) ; GB0-A-5735
(ucs-set-char #x690E ?$BDG(B) ; J83-B-4447
(ucs-set-char #x690F ?$(H<U(B) ; C02-H-3C55
(ucs-set-char #x690F ?$@[s(B) ; J78-@-5B73
(ucs-set-char #x690F ?$B[s(B) ; J83-B-5B73
(ucs-set-char #x6910 ?$(DD8(B) ; J90-D-4438
(ucs-set-char #x6910 ?$(H<\(B) ; C02-H-3C5C
(ucs-set-char #x6910 ?$Ai'(B) ; GB0-A-6927
(ucs-set-char #x6911 ?$(DD9(B) ; J90-D-4439
(ucs-set-char #x6911 ?$(H<d(B) ; C02-H-3C64
(ucs-set-char #x6912 ?$(Cu!(B) ; KS0-C-7521
(ucs-set-char #x6912 ?$(G_y(B) ; C01-G-5F79
(ucs-set-char #x6912 ?$@\%(B) ; J78-@-5C25
(ucs-set-char #x6912 ?$A=7(B) ; GB0-A-3D37
(ucs-set-char #x6912 ?$B\%(B) ; J83-B-5C25
(ucs-set-char #x6913 ?$(DD:(B) ; J90-D-443A
(ucs-set-char #x6913 ?$(H<[(B) ; C02-H-3C5B
(ucs-set-char #x6914 ?$(H<g(B) ; C02-H-3C67
(ucs-set-char #x6915 ?$(H<z(B) ; C02-H-3C7A
(ucs-set-char #x6916 ?$(DD;(B) ; J90-D-443B
(ucs-set-char #x6917 ?$(DD<(B) ; J90-D-443C
(ucs-set-char #x6917 ?$(H<o(B) ; C02-H-3C6F
(ucs-set-char #x6918 ?$(I<<(B) ; C03-I-3C3C
(ucs-set-char #x6919 ?$@?z(B) ; J78-@-3F7A
(ucs-set-char #x6919 ?$B?z(B) ; J83-B-3F7A
(ucs-set-char #x691A ?$@\/(B) ; J78-@-5C2F
(ucs-set-char #x691A ?$B\/(B) ; J83-B-5C2F
(ucs-set-char #x691B ?$@3q(B) ; J78-@-3371
(ucs-set-char #x691B ?$B3q(B) ; J83-B-3371
(ucs-set-char #x691C ?$(I<D(B) ; C03-I-3C44
(ucs-set-char #x691C ?$@8!(B) ; J78-@-3821
(ucs-set-char #x691C ?$B8!(B) ; J83-B-3821
(ucs-set-char #x691E ?$(I<3(B) ; C03-I-3C33
(ucs-set-char #x691F ?$Ah|(B) ; GB0-A-687C
(ucs-set-char #x6920 ?$Ah}(B) ; GB0-A-687D
(ucs-set-char #x6921 ?$@\1(B) ; J78-@-5C31
(ucs-set-char #x6921 ?$B\1(B) ; J83-B-5C31
(ucs-set-char #x6922 ?$@[z(B) ; J78-@-5B7A
(ucs-set-char #x6922 ?$B[z(B) ; J83-B-5B7A
(ucs-set-char #x6923 ?$@\0(B) ; J78-@-5C30
(ucs-set-char #x6923 ?$B\0(B) ; J83-B-5C30
(ucs-set-char #x6924 ?$Ai!(B) ; GB0-A-6921
(ucs-set-char #x6925 ?$(H<{(B) ; C02-H-3C7B
(ucs-set-char #x6925 ?$@\)(B) ; J78-@-5C29
(ucs-set-char #x6925 ?$B\)(B) ; J83-B-5C29
(ucs-set-char #x6926 ?$@[{(B) ; J78-@-5B7B
(ucs-set-char #x6926 ?$B[{(B) ; J83-B-5B7B
(ucs-set-char #x6927 ?$(CY'(B) ; KS0-C-5927
(ucs-set-char #x6928 ?$@\-(B) ; J78-@-5C2D
(ucs-set-char #x6928 ?$B\-(B) ; J83-B-5C2D
(ucs-set-char #x692A ?$(H<Q(B) ; C02-H-3C51
(ucs-set-char #x692A ?$@\.(B) ; J78-@-5C2E
(ucs-set-char #x692A ?$B\.(B) ; J83-B-5C2E
(ucs-set-char #x692D ?$AMV(B) ; GB0-A-4D56
(ucs-set-char #x692E ?$(I<@(B) ; C03-I-3C40
(ucs-set-char #x692F ?$(HCx(B) ; C02-H-4378
(ucs-set-char #x6930 ?$(Ce+(B) ; KS0-C-652B
(ucs-set-char #x6930 ?$(GdL(B) ; C01-G-644C
(ucs-set-char #x6930 ?$@\?(B) ; J78-@-5C3F
(ucs-set-char #x6930 ?$AR,(B) ; GB0-A-522C
(ucs-set-char #x6930 ?$B\?(B) ; J83-B-5C3F
(ucs-set-char #x6931 ?$(DD=(B) ; J90-D-443D
(ucs-set-char #x6931 ?$(IAe(B) ; C03-I-4165
(ucs-set-char #x6932 ?$(HCv(B) ; C02-H-4376
(ucs-set-char #x6933 ?$(DD>(B) ; J90-D-443E
(ucs-set-char #x6933 ?$(HCa(B) ; C02-H-4361
(ucs-set-char #x6934 ?$(HCf(B) ; C02-H-4366
(ucs-set-char #x6934 ?$@FN(B) ; J78-@-464E
(ucs-set-char #x6934 ?$Ai2(B) ; GB0-A-6932
(ucs-set-char #x6934 ?$BFN(B) ; J83-B-464E
(ucs-set-char #x6935 ?$(DD?(B) ; J90-D-443F
(ucs-set-char #x6935 ?$(HC_(B) ; C02-H-435F
(ucs-set-char #x6936 ?$(IAw(B) ; C03-I-4177
(ucs-set-char #x6936 ?$@\$(B) ; J78-@-5C24
(ucs-set-char #x6936 ?$B\$(B) ; J83-B-5C24
(ucs-set-char #x6937 ?$(HCr(B) ; C02-H-4372
(ucs-set-char #x6938 ?$(DD@(B) ; J90-D-4440
(ucs-set-char #x6938 ?$(HCQ(B) ; C02-H-4351
(ucs-set-char #x6939 ?$(HCX(B) ; C02-H-4358
(ucs-set-char #x6939 ?$@\;(B) ; J78-@-5C3B
(ucs-set-char #x6939 ?$Ai)(B) ; GB0-A-6929
(ucs-set-char #x6939 ?$B\;(B) ; J83-B-5C3B
(ucs-set-char #x693A ?$(J=q(B) ; C04-J-3D71
(ucs-set-char #x693B ?$(DDA(B) ; J90-D-4441
(ucs-set-char #x693B ?$(HCp(B) ; C02-H-4370
(ucs-set-char #x693C ?$(HCz(B) ; C02-H-437A
(ucs-set-char #x693D ?$(CfK(B) ; KS0-C-664B
(ucs-set-char #x693D ?$(HCb(B) ; C02-H-4362
(ucs-set-char #x693D ?$@\=(B) ; J78-@-5C3D
(ucs-set-char #x693D ?$A4*(B) ; GB0-A-342A
(ucs-set-char #x693D ?$B\=(B) ; J83-B-5C3D
(ucs-set-char #x693E ?$(IAh(B) ; C03-I-4168
(ucs-set-char #x693F ?$(Cuq(B) ; KS0-C-7571
(ucs-set-char #x693F ?$(HCU(B) ; C02-H-4355
(ucs-set-char #x693F ?$@DX(B) ; J78-@-4458
(ucs-set-char #x693F ?$A4;(B) ; GB0-A-343B
(ucs-set-char #x693F ?$BDX(B) ; J83-B-4458
(ucs-set-char #x6940 ?$(HCh(B) ; C02-H-4368
(ucs-set-char #x6941 ?$(HCm(B) ; C02-H-436D
(ucs-set-char #x6942 ?$(DDB(B) ; J90-D-4442
(ucs-set-char #x6942 ?$(HCY(B) ; C02-H-4359
(ucs-set-char #x6942 ?$(IAn(B) ; C03-I-416E
(ucs-set-char #x6942 ?$Ai+(B) ; GB0-A-692B
(ucs-set-char #x6943 ?$(IAk(B) ; C03-I-416B
(ucs-set-char #x6944 ?$(HCj(B) ; C02-H-436A
(ucs-set-char #x6945 ?$(DDC(B) ; J90-D-4443
(ucs-set-char #x6945 ?$(HCV(B) ; C02-H-4356
(ucs-set-char #x6946 ?$(IA](B) ; C03-I-415D
(ucs-set-char #x6947 ?$(IAu(B) ; C03-I-4175
(ucs-set-char #x6948 ?$(HC](B) ; C02-H-435D
(ucs-set-char #x6949 ?$(DDD(B) ; J90-D-4444
(ucs-set-char #x6949 ?$(HC^(B) ; C02-H-435E
(ucs-set-char #x694A ?$(CeE(B) ; KS0-C-6545
(ucs-set-char #x694A ?$(GdN(B) ; C01-G-644E
(ucs-set-char #x694A ?$@ML(B) ; J78-@-4D4C
(ucs-set-char #x694A ?$BML(B) ; J83-B-4D4C
(ucs-set-char #x694B ?$(HCq(B) ; C02-H-4371
(ucs-set-char #x694C ?$(HCo(B) ; C02-H-436F
(ucs-set-char #x694D ?$(IAs(B) ; C03-I-4173
(ucs-set-char #x694E ?$(DDE(B) ; J90-D-4445
(ucs-set-char #x694E ?$(HCR(B) ; C02-H-4352
(ucs-set-char #x694F ?$(HCt(B) ; C02-H-4374
(ucs-set-char #x6950 ?$(IAt(B) ; C03-I-4174
(ucs-set-char #x6951 ?$(HCu(B) ; C02-H-4375
(ucs-set-char #x6952 ?$(HCw(B) ; C02-H-4377
(ucs-set-char #x6953 ?$(Cy#(B) ; KS0-C-7923
(ucs-set-char #x6953 ?$(GdR(B) ; C01-G-6452
(ucs-set-char #x6953 ?$@Iv(B) ; J78-@-4976
(ucs-set-char #x6953 ?$BIv(B) ; J83-B-4976
(ucs-set-char #x6954 ?$(C`[(B) ; KS0-C-605B
(ucs-set-char #x6954 ?$(GdJ(B) ; C01-G-644A
(ucs-set-char #x6954 ?$@\8(B) ; J78-@-5C38
(ucs-set-char #x6954 ?$AP((B) ; GB0-A-5028
(ucs-set-char #x6954 ?$B\8(B) ; J83-B-5C38
(ucs-set-char #x6955 ?$(Cvk(B) ; KS0-C-766B
(ucs-set-char #x6955 ?$(IAo(B) ; C03-I-416F
(ucs-set-char #x6955 ?$@BJ(B) ; J78-@-424A
(ucs-set-char #x6955 ?$BBJ(B) ; J83-B-424A
(ucs-set-char #x6956 ?$(H5z(B) ; C02-H-357A
(ucs-set-char #x6957 ?$(CKq(B) ; KS0-C-4B71
(ucs-set-char #x6957 ?$(DDF(B) ; J90-D-4446
(ucs-set-char #x6957 ?$(HCZ(B) ; C02-H-435A
(ucs-set-char #x6957 ?$Ai%(B) ; GB0-A-6925
(ucs-set-char #x6958 ?$(HCl(B) ; C02-H-436C
(ucs-set-char #x6959 ?$(CYj(B) ; KS0-C-596A
(ucs-set-char #x6959 ?$(HC[(B) ; C02-H-435B
(ucs-set-char #x6959 ?$@\>(B) ; J78-@-5C3E
(ucs-set-char #x6959 ?$B\>(B) ; J83-B-5C3E
(ucs-set-char #x695A ?$(Cu"(B) ; KS0-C-7522
(ucs-set-char #x695A ?$(GdG(B) ; C01-G-6447
(ucs-set-char #x695A ?$@A?(B) ; J78-@-413F
(ucs-set-char #x695A ?$A3~(B) ; GB0-A-337E
(ucs-set-char #x695A ?$BA?(B) ; J83-B-413F
(ucs-set-char #x695B ?$(DDG(B) ; J90-D-4447
(ucs-set-char #x695B ?$(GdW(B) ; C01-G-6457
(ucs-set-char #x695C ?$(HCs(B) ; C02-H-4373
(ucs-set-char #x695C ?$@\5(B) ; J78-@-5C35
(ucs-set-char #x695C ?$B\5(B) ; J83-B-5C35
(ucs-set-char #x695D ?$(GdU(B) ; C01-G-6455
(ucs-set-char #x695D ?$@\B(B) ; J78-@-5C42
(ucs-set-char #x695D ?$Ai,(B) ; GB0-A-692C
(ucs-set-char #x695D ?$B\B(B) ; J83-B-5C42
(ucs-set-char #x695E ?$(CWQ(B) ; KS0-C-5751
(ucs-set-char #x695E ?$(GdQ(B) ; C01-G-6451
(ucs-set-char #x695E ?$@\A(B) ; J78-@-5C41
(ucs-set-char #x695E ?$A@c(B) ; GB0-A-4063
(ucs-set-char #x695E ?$B\A(B) ; J83-B-5C41
(ucs-set-char #x695F ?$(HCP(B) ; C02-H-4350
(ucs-set-char #x6960 ?$(CQx(B) ; KS0-C-5178
(ucs-set-char #x6960 ?$(GdI(B) ; C01-G-6449
(ucs-set-char #x6960 ?$@Fo(B) ; J78-@-466F
(ucs-set-char #x6960 ?$Ai*(B) ; GB0-A-692A
(ucs-set-char #x6960 ?$BFo(B) ; J83-B-466F
(ucs-set-char #x6961 ?$(Cjx(B) ; KS0-C-6A78
(ucs-set-char #x6961 ?$(IAy(B) ; C03-I-4179
(ucs-set-char #x6961 ?$@\@(B) ; J78-@-5C40
(ucs-set-char #x6961 ?$B\@(B) ; J83-B-5C40
(ucs-set-char #x6962 ?$(Cjy(B) ; KS0-C-6A79
(ucs-set-char #x6962 ?$(HCS(B) ; C02-H-4353
(ucs-set-char #x6962 ?$@Fj(B) ; J78-@-466A
(ucs-set-char #x6962 ?$BFj(B) ; J83-B-466A
(ucs-set-char #x6963 ?$(CZ3(B) ; KS0-C-5A33
(ucs-set-char #x6963 ?$(DDH(B) ; J90-D-4448
(ucs-set-char #x6963 ?$(GdV(B) ; C01-G-6456
(ucs-set-char #x6963 ?$Ai9(B) ; GB0-A-6939
(ucs-set-char #x6964 ?$(DDI(B) ; J90-D-4449
(ucs-set-char #x6964 ?$(IAx(B) ; C03-I-4178
(ucs-set-char #x6965 ?$(DDJ(B) ; J90-D-444A
(ucs-set-char #x6965 ?$(HCc(B) ; C02-H-4363
(ucs-set-char #x6966 ?$(DDK(B) ; J90-D-444B
(ucs-set-char #x6966 ?$(HCO(B) ; C02-H-434F
(ucs-set-char #x6966 ?$Ai8(B) ; GB0-A-6938
(ucs-set-char #x6967 ?$(IAv(B) ; C03-I-4176
(ucs-set-char #x6968 ?$(Co_(B) ; KS0-C-6F5F
(ucs-set-char #x6968 ?$(DDL(B) ; J90-D-444C
(ucs-set-char #x6968 ?$(GdO(B) ; C01-G-644F
(ucs-set-char #x6969 ?$(DDM(B) ; J90-D-444D
(ucs-set-char #x6969 ?$(HCg(B) ; C02-H-4367
(ucs-set-char #x696A ?$(HCW(B) ; C02-H-4357
(ucs-set-char #x696A ?$@\D(B) ; J78-@-5C44
(ucs-set-char #x696A ?$B\D(B) ; J83-B-5C44
(ucs-set-char #x696B ?$(Cqo(B) ; KS0-C-716F
(ucs-set-char #x696B ?$(GdP(B) ; C01-G-6450
(ucs-set-char #x696B ?$@\7(B) ; J78-@-5C37
(ucs-set-char #x696B ?$Ai.(B) ; GB0-A-692E
(ucs-set-char #x696B ?$B\7(B) ; J83-B-5C37
(ucs-set-char #x696C ?$(DDN(B) ; J90-D-444E
(ucs-set-char #x696C ?$(HC`(B) ; C02-H-4360
(ucs-set-char #x696D ?$(Cev(B) ; KS0-C-6576
(ucs-set-char #x696D ?$(GdF(B) ; C01-G-6446
(ucs-set-char #x696D ?$@6H(B) ; J78-@-3648
(ucs-set-char #x696D ?$B6H(B) ; J83-B-3648
(ucs-set-char #x696E ?$(Cn?(B) ; KS0-C-6E3F
(ucs-set-char #x696E ?$(G_}(B) ; C01-G-5F7D
(ucs-set-char #x696E ?$@\:(B) ; J78-@-5C3A
(ucs-set-char #x696E ?$Ahz(B) ; GB0-A-687A
(ucs-set-char #x696E ?$B\:(B) ; J83-B-5C3A
(ucs-set-char #x696F ?$(Cbd(B) ; KS0-C-6264
(ucs-set-char #x696F ?$(HCi(B) ; C02-H-4369
(ucs-set-char #x696F ?$@=](B) ; J78-@-3D5D
(ucs-set-char #x696F ?$B=](B) ; J83-B-3D5D
(ucs-set-char #x6970 ?$(DDO(B) ; J90-D-444F
(ucs-set-char #x6970 ?$(H<b(B) ; C02-H-3C62
(ucs-set-char #x6971 ?$(DDP(B) ; J90-D-4450
(ucs-set-char #x6971 ?$(HCT(B) ; C02-H-4354
(ucs-set-char #x6971 ?$Ai((B) ; GB0-A-6928
(ucs-set-char #x6972 ?$(DDQ(B) ; J90-D-4451
(ucs-set-char #x6972 ?$(J=l(B) ; C04-J-3D6C
(ucs-set-char #x6973 ?$(IAm(B) ; C03-I-416D
(ucs-set-char #x6973 ?$@G`(B) ; J78-@-4760
(ucs-set-char #x6973 ?$BG`(B) ; J83-B-4760
(ucs-set-char #x6974 ?$(HCn(B) ; C02-H-436E
(ucs-set-char #x6974 ?$@\<(B) ; J78-@-5C3C
(ucs-set-char #x6974 ?$B\<(B) ; J83-B-5C3C
(ucs-set-char #x6975 ?$(CP?(B) ; KS0-C-503F
(ucs-set-char #x6975 ?$(GdK(B) ; C01-G-644B
(ucs-set-char #x6975 ?$@6K(B) ; J78-@-364B
(ucs-set-char #x6975 ?$B6K(B) ; J83-B-364B
(ucs-set-char #x6976 ?$(HCk(B) ; C02-H-436B
(ucs-set-char #x6977 ?$(Cz,(B) ; KS0-C-7A2C
(ucs-set-char #x6977 ?$(GdH(B) ; C01-G-6448
(ucs-set-char #x6977 ?$@\4(B) ; J78-@-5C34
(ucs-set-char #x6977 ?$A?,(B) ; GB0-A-3F2C
(ucs-set-char #x6977 ?$B\4(B) ; J83-B-5C34
(ucs-set-char #x6978 ?$(CuQ(B) ; KS0-C-7551
(ucs-set-char #x6978 ?$(HCe(B) ; C02-H-4365
(ucs-set-char #x6978 ?$@\6(B) ; J78-@-5C36
(ucs-set-char #x6978 ?$Ai1(B) ; GB0-A-6931
(ucs-set-char #x6978 ?$B\6(B) ; J83-B-5C36
(ucs-set-char #x6979 ?$(Cg3(B) ; KS0-C-6733
(ucs-set-char #x6979 ?$(GdS(B) ; C01-G-6453
(ucs-set-char #x6979 ?$@\3(B) ; J78-@-5C33
(ucs-set-char #x6979 ?$Ai:(B) ; GB0-A-693A
(ucs-set-char #x6979 ?$B\3(B) ; J83-B-5C33
(ucs-set-char #x697A ?$(DDR(B) ; J90-D-4452
(ucs-set-char #x697A ?$(HC\(B) ; C02-H-435C
(ucs-set-char #x697B ?$(DDS(B) ; J90-D-4453
(ucs-set-char #x697B ?$(HCy(B) ; C02-H-4379
(ucs-set-char #x697C ?$(IAj(B) ; C03-I-416A
(ucs-set-char #x697C ?$@O0(B) ; J78-@-4F30
(ucs-set-char #x697C ?$AB%(B) ; GB0-A-4225
(ucs-set-char #x697C ?$BO0(B) ; J83-B-4F30
(ucs-set-char #x697D ?$(IA{(B) ; C03-I-417B
(ucs-set-char #x697D ?$@3Z(B) ; J78-@-335A
(ucs-set-char #x697D ?$B3Z(B) ; J83-B-335A
(ucs-set-char #x697E ?$@\9(B) ; J78-@-5C39
(ucs-set-char #x697E ?$B\9(B) ; J83-B-5C39
(ucs-set-char #x697F ?$(DDT(B) ; J90-D-4454
(ucs-set-char #x6980 ?$(DDU(B) ; J90-D-4455
(ucs-set-char #x6980 ?$Ai/(B) ; GB0-A-692F
(ucs-set-char #x6981 ?$@\C(B) ; J78-@-5C43
(ucs-set-char #x6981 ?$B\C(B) ; J83-B-5C43
(ucs-set-char #x6982 ?$(GdM(B) ; C01-G-644D
(ucs-set-char #x6982 ?$@35(B) ; J78-@-3335
(ucs-set-char #x6982 ?$A8E(B) ; GB0-A-3845
(ucs-set-char #x6982 ?$B35(B) ; J83-B-3335
(ucs-set-char #x6983 ?$(HE,(B) ; C02-H-452C
(ucs-set-char #x6984 ?$Ai-(B) ; GB0-A-692D
(ucs-set-char #x6985 ?$(IAr(B) ; C03-I-4172
(ucs-set-char #x6986 ?$(GdT(B) ; C01-G-6454
(ucs-set-char #x6986 ?$AS\(B) ; GB0-A-535C
(ucs-set-char #x6987 ?$Ai4(B) ; GB0-A-6934
(ucs-set-char #x6988 ?$Ai5(B) ; GB0-A-6935
(ucs-set-char #x6989 ?$Ai7(B) ; GB0-A-6937
(ucs-set-char #x698A ?$@:g(B) ; J78-@-3A67
(ucs-set-char #x698A ?$B:g(B) ; J83-B-3A67
(ucs-set-char #x698D ?$(DDV(B) ; J90-D-4456
(ucs-set-char #x698D ?$(HJp(B) ; C02-H-4A70
(ucs-set-char #x698D ?$AiG(B) ; GB0-A-6947
(ucs-set-char #x698E ?$(HJn(B) ; C02-H-4A6E
(ucs-set-char #x698E ?$@1](B) ; J78-@-315D
(ucs-set-char #x698E ?$B1](B) ; J83-B-315D
(ucs-set-char #x698F ?$(IG:(B) ; C03-I-473A
(ucs-set-char #x6990 ?$(HK&(B) ; C02-H-4B26
(ucs-set-char #x6991 ?$(HJl(B) ; C02-H-4A6C
(ucs-set-char #x6991 ?$@\T(B) ; J78-@-5C54
(ucs-set-char #x6991 ?$B\T(B) ; J83-B-5C54
(ucs-set-char #x6992 ?$(DDW(B) ; J90-D-4457
(ucs-set-char #x6992 ?$(IG=(B) ; C03-I-473D
(ucs-set-char #x6993 ?$(HJ~(B) ; C02-H-4A7E
(ucs-set-char #x6994 ?$(GdE(B) ; C01-G-6445
(ucs-set-char #x6994 ?$@O1(B) ; J78-@-4F31
(ucs-set-char #x6994 ?$A@F(B) ; GB0-A-4046
(ucs-set-char #x6994 ?$BO1(B) ; J83-B-4F31
(ucs-set-char #x6995 ?$(Ci>(B) ; KS0-C-693E
(ucs-set-char #x6995 ?$(Gi((B) ; C01-G-6928
(ucs-set-char #x6995 ?$@\W(B) ; J78-@-5C57
(ucs-set-char #x6995 ?$AiE(B) ; GB0-A-6945
(ucs-set-char #x6995 ?$B\W(B) ; J83-B-5C57
(ucs-set-char #x6996 ?$(DDX(B) ; J90-D-4458
(ucs-set-char #x6996 ?$(HJh(B) ; C02-H-4A68
(ucs-set-char #x6997 ?$(HK%(B) ; C02-H-4B25
(ucs-set-char #x6998 ?$(DDY(B) ; J90-D-4459
(ucs-set-char #x6998 ?$(IGQ(B) ; C03-I-4751
(ucs-set-char #x6998 ?$Ai0(B) ; GB0-A-6930
(ucs-set-char #x6999 ?$(HJm(B) ; C02-H-4A6D
(ucs-set-char #x699A ?$(HJ{(B) ; C02-H-4A7B
(ucs-set-char #x699B ?$(CrN(B) ; KS0-C-724E
(ucs-set-char #x699B ?$(Gi-(B) ; C01-G-692D
(ucs-set-char #x699B ?$@?:(B) ; J78-@-3F3A
(ucs-set-char #x699B ?$Ai;(B) ; GB0-A-693B
(ucs-set-char #x699B ?$B?:(B) ; J83-B-3F3A
(ucs-set-char #x699C ?$(C[4(B) ; KS0-C-5B34
(ucs-set-char #x699C ?$(Gi&(B) ; C01-G-6926
(ucs-set-char #x699C ?$@\V(B) ; J78-@-5C56
(ucs-set-char #x699C ?$A0q(B) ; GB0-A-3071
(ucs-set-char #x699C ?$B\V(B) ; J83-B-5C56
(ucs-set-char #x699D ?$(IGN(B) ; C03-I-474E
(ucs-set-char #x699E ?$(HK#(B) ; C02-H-4B23
(ucs-set-char #x699F ?$(IGF(B) ; C03-I-4746
(ucs-set-char #x69A0 ?$(HJf(B) ; C02-H-4A66
(ucs-set-char #x69A0 ?$@\U(B) ; J78-@-5C55
(ucs-set-char #x69A0 ?$B\U(B) ; J83-B-5C55
(ucs-set-char #x69A1 ?$(DDZ(B) ; J90-D-445A
(ucs-set-char #x69A1 ?$(HK"(B) ; C02-H-4B22
(ucs-set-char #x69A2 ?$(IGG(B) ; C03-I-4747
(ucs-set-char #x69A3 ?$(Gi8(B) ; C01-G-6938
(ucs-set-char #x69A3 ?$(L]h(B) ; C06-L-5D68
(ucs-set-char #x69A4 ?$(HJw(B) ; C02-H-4A77
(ucs-set-char #x69A5 ?$(C|N(B) ; KS0-C-7C4E
(ucs-set-char #x69A5 ?$(DD[(B) ; J90-D-445B
(ucs-set-char #x69A5 ?$(HK)(B) ; C02-H-4B29
(ucs-set-char #x69A6 ?$(DD\(B) ; J90-D-445C
(ucs-set-char #x69A6 ?$(Gi6(B) ; C01-G-6936
(ucs-set-char #x69A7 ?$(C]n(B) ; KS0-C-5D6E
(ucs-set-char #x69A7 ?$(HJo(B) ; C02-H-4A6F
(ucs-set-char #x69A7 ?$@\R(B) ; J78-@-5C52
(ucs-set-char #x69A7 ?$Ai<(B) ; GB0-A-693C
(ucs-set-char #x69A7 ?$B\R(B) ; J83-B-5C52
(ucs-set-char #x69A8 ?$(DD](B) ; J90-D-445D
(ucs-set-char #x69A8 ?$(Gi'(B) ; C01-G-6927
(ucs-set-char #x69A8 ?$AU%(B) ; GB0-A-5525
(ucs-set-char #x69A9 ?$(HJq(B) ; C02-H-4A71
(ucs-set-char #x69AA ?$(HK!(B) ; C02-H-4B21
(ucs-set-char #x69AB ?$(DD^(B) ; J90-D-445E
(ucs-set-char #x69AB ?$(Gi0(B) ; C01-G-6930
(ucs-set-char #x69AB ?$Ai>(B) ; GB0-A-693E
(ucs-set-char #x69AC ?$(HJj(B) ; C02-H-4A6A
(ucs-set-char #x69AD ?$(DD_(B) ; J90-D-445F
(ucs-set-char #x69AD ?$(Gi4(B) ; C01-G-6934
(ucs-set-char #x69AD ?$Ai?(B) ; GB0-A-693F
(ucs-set-char #x69AE ?$(Cg4(B) ; KS0-C-6734
(ucs-set-char #x69AE ?$(Gi*(B) ; C01-G-692A
(ucs-set-char #x69AE ?$@\F(B) ; J78-@-5C46
(ucs-set-char #x69AE ?$B\F(B) ; J83-B-5C46
(ucs-set-char #x69AF ?$(DD`(B) ; J90-D-4460
(ucs-set-char #x69AF ?$(HJs(B) ; C02-H-4A73
(ucs-set-char #x69B0 ?$(HJi(B) ; C02-H-4A69
(ucs-set-char #x69B1 ?$(HJc(B) ; C02-H-4A63
(ucs-set-char #x69B1 ?$@\c(B) ; J78-@-5C63
(ucs-set-char #x69B1 ?$AiA(B) ; GB0-A-6941
(ucs-set-char #x69B1 ?$B\c(B) ; J83-B-5C63
(ucs-set-char #x69B2 ?$(IG>(B) ; C03-I-473E
(ucs-set-char #x69B2 ?$@\E(B) ; J78-@-5C45
(ucs-set-char #x69B2 ?$B\E(B) ; J83-B-5C45
(ucs-set-char #x69B3 ?$(HJ}(B) ; C02-H-4A7D
(ucs-set-char #x69B4 ?$(CW4(B) ; KS0-C-5734
(ucs-set-char #x69B4 ?$(Gi1(B) ; C01-G-6931
(ucs-set-char #x69B4 ?$@\X(B) ; J78-@-5C58
(ucs-set-char #x69B4 ?$AAq(B) ; GB0-A-4171
(ucs-set-char #x69B4 ?$B\X(B) ; J83-B-5C58
(ucs-set-char #x69B5 ?$(HK((B) ; C02-H-4B28
(ucs-set-char #x69B6 ?$(HJd(B) ; C02-H-4A64
(ucs-set-char #x69B7 ?$(DDa(B) ; J90-D-4461
(ucs-set-char #x69B7 ?$(Gi.(B) ; C01-G-692E
(ucs-set-char #x69B7 ?$AH6(B) ; GB0-A-4836
(ucs-set-char #x69B8 ?$(DDb(B) ; J90-D-4462
(ucs-set-char #x69B8 ?$(JCw(B) ; C04-J-4377
(ucs-set-char #x69B9 ?$(HJy(B) ; C02-H-4A79
(ucs-set-char #x69BA ?$(DDc(B) ; J90-D-4463
(ucs-set-char #x69BA ?$(JCy(B) ; C04-J-4379
(ucs-set-char #x69BB ?$(Cw4(B) ; KS0-C-7734
(ucs-set-char #x69BB ?$(Gi/(B) ; C01-G-692F
(ucs-set-char #x69BB ?$@\P(B) ; J78-@-5C50
(ucs-set-char #x69BB ?$Ai=(B) ; GB0-A-693D
(ucs-set-char #x69BB ?$B\P(B) ; J83-B-5C50
(ucs-set-char #x69BC ?$(DDd(B) ; J90-D-4464
(ucs-set-char #x69BC ?$(HJk(B) ; C02-H-4A6B
(ucs-set-char #x69BD ?$(HJv(B) ; C02-H-4A76
(ucs-set-char #x69BE ?$(HJr(B) ; C02-H-4A72
(ucs-set-char #x69BE ?$@\K(B) ; J78-@-5C4B
(ucs-set-char #x69BE ?$B\K(B) ; J83-B-5C4B
(ucs-set-char #x69BF ?$(HJt(B) ; C02-H-4A74
(ucs-set-char #x69BF ?$@\H(B) ; J78-@-5C48
(ucs-set-char #x69BF ?$B\H(B) ; J83-B-5C48
(ucs-set-char #x69C0 ?$(IGC(B) ; C03-I-4743
(ucs-set-char #x69C1 ?$(CM>(B) ; KS0-C-4D3E
(ucs-set-char #x69C1 ?$(Gi)(B) ; C01-G-6929
(ucs-set-char #x69C1 ?$@\I(B) ; J78-@-5C49
(ucs-set-char #x69C1 ?$AiB(B) ; GB0-A-6942
(ucs-set-char #x69C1 ?$B\I(B) ; J83-B-5C49
(ucs-set-char #x69C2 ?$(HK'(B) ; C02-H-4B27
(ucs-set-char #x69C3 ?$(CZi(B) ; KS0-C-5A69
(ucs-set-char #x69C3 ?$(Gi7(B) ; C01-G-6937
(ucs-set-char #x69C3 ?$@\Q(B) ; J78-@-5C51
(ucs-set-char #x69C3 ?$B\Q(B) ; J83-B-5C51
(ucs-set-char #x69C4 ?$(HJu(B) ; C02-H-4A75
(ucs-set-char #x69C5 ?$(DDe(B) ; J90-D-4465
(ucs-set-char #x69C5 ?$(IG;(B) ; C03-I-473B
(ucs-set-char #x69C6 ?$(HK*(B) ; C02-H-4B2A
(ucs-set-char #x69C7 ?$(JD'(B) ; C04-J-4427
(ucs-set-char #x69C7 ?$@Kj(B) ; J78-@-4B6A
(ucs-set-char #x69C7 ?$Bt"(B) ; J83-B-7422
(ucs-set-char #x69C8 ?$(DDf(B) ; J90-D-4466
(ucs-set-char #x69C8 ?$(IG<(B) ; C03-I-473C
(ucs-set-char #x69C9 ?$(HJe(B) ; C02-H-4A65
(ucs-set-char #x69CA ?$(HJz(B) ; C02-H-4A7A
(ucs-set-char #x69CA ?$@\N(B) ; J78-@-5C4E
(ucs-set-char #x69CA ?$AiC(B) ; GB0-A-6943
(ucs-set-char #x69CA ?$B\N(B) ; J83-B-5C4E
(ucs-set-char #x69CB ?$(CO0(B) ; KS0-C-4F30
(ucs-set-char #x69CB ?$(Gi,(B) ; C01-G-692C
(ucs-set-char #x69CB ?$@9=(B) ; J78-@-393D
(ucs-set-char #x69CB ?$B9=(B) ; J83-B-393D
(ucs-set-char #x69CC ?$(CwY(B) ; KS0-C-7759
(ucs-set-char #x69CC ?$(Gi5(B) ; C01-G-6935
(ucs-set-char #x69CC ?$@DH(B) ; J78-@-4448
(ucs-set-char #x69CC ?$Ai3(B) ; GB0-A-6933
(ucs-set-char #x69CC ?$BDH(B) ; J83-B-4448
(ucs-set-char #x69CD ?$(Csf(B) ; KS0-C-7366
(ucs-set-char #x69CD ?$(Gi3(B) ; C01-G-6933
(ucs-set-char #x69CD ?$@Ad(B) ; J78-@-4164
(ucs-set-char #x69CD ?$BAd(B) ; J83-B-4164
(ucs-set-char #x69CE ?$(HJg(B) ; C02-H-4A67
(ucs-set-char #x69CE ?$@\L(B) ; J78-@-5C4C
(ucs-set-char #x69CE ?$Ai6(B) ; GB0-A-6936
(ucs-set-char #x69CE ?$B\L(B) ; J83-B-5C4C
(ucs-set-char #x69CF ?$(HJ|(B) ; C02-H-4A7C
(ucs-set-char #x69D0 ?$(CNY(B) ; KS0-C-4E59
(ucs-set-char #x69D0 ?$(Gi2(B) ; C01-G-6932
(ucs-set-char #x69D0 ?$@\G(B) ; J78-@-5C47
(ucs-set-char #x69D0 ?$A;1(B) ; GB0-A-3B31
(ucs-set-char #x69D0 ?$B\G(B) ; J83-B-5C47
(ucs-set-char #x69D1 ?$(DDg(B) ; J90-D-4467
(ucs-set-char #x69D1 ?$(IGE(B) ; C03-I-4745
(ucs-set-char #x69D2 ?$(IGH(B) ; C03-I-4748
(ucs-set-char #x69D3 ?$(Gi+(B) ; C01-G-692B
(ucs-set-char #x69D3 ?$@\J(B) ; J78-@-5C4A
(ucs-set-char #x69D3 ?$B\J(B) ; J83-B-5C4A
(ucs-set-char #x69D4 ?$(HJx(B) ; C02-H-4A78
(ucs-set-char #x69D4 ?$Ai@(B) ; GB0-A-6940
(ucs-set-char #x69D5 ?$(IGM(B) ; C03-I-474D
(ucs-set-char #x69D6 ?$(DDh(B) ; J90-D-4468
(ucs-set-char #x69D6 ?$(IGD(B) ; C03-I-4744
(ucs-set-char #x69D7 ?$(DDi(B) ; J90-D-4469
(ucs-set-char #x69D7 ?$(JD((B) ; C04-J-4428
(ucs-set-char #x69D8 ?$(ILT(B) ; C03-I-4C54
(ucs-set-char #x69D8 ?$@MM(B) ; J78-@-4D4D
(ucs-set-char #x69D8 ?$BMM(B) ; J83-B-4D4D
(ucs-set-char #x69D9 ?$(HK$(B) ; C02-H-4B24
(ucs-set-char #x69D9 ?$BKj(B) ; J83-B-4B6A
(ucs-set-char #x69DB ?$A<w(B) ; GB0-A-3C77
(ucs-set-char #x69DD ?$@\O(B) ; J78-@-5C4F
(ucs-set-char #x69DD ?$B\O(B) ; J83-B-5C4F
(ucs-set-char #x69DE ?$@\Y(B) ; J78-@-5C59
(ucs-set-char #x69DE ?$B\Y(B) ; J83-B-5C59
(ucs-set-char #x69DF ?$AiD(B) ; GB0-A-6944
(ucs-set-char #x69E0 ?$AiF(B) ; GB0-A-6946
(ucs-set-char #x69E1 ?$(IGL(B) ; C03-I-474C
(ucs-set-char #x69E2 ?$(DDj(B) ; J90-D-446A
(ucs-set-char #x69E2 ?$(HP|(B) ; C02-H-507C
(ucs-set-char #x69E3 ?$(IGB(B) ; C03-I-4742
(ucs-set-char #x69E4 ?$(HPx(B) ; C02-H-5078
(ucs-set-char #x69E5 ?$(DDk(B) ; J90-D-446B
(ucs-set-char #x69E5 ?$(HPt(B) ; C02-H-5074
(ucs-set-char #x69E6 ?$(HQ*(B) ; C02-H-512A
(ucs-set-char #x69E7 ?$(HQ'(B) ; C02-H-5127
(ucs-set-char #x69E7 ?$@\a(B) ; J78-@-5C61
(ucs-set-char #x69E7 ?$B\a(B) ; J83-B-5C61
(ucs-set-char #x69E8 ?$(CN*(B) ; KS0-C-4E2A
(ucs-set-char #x69E8 ?$(Gm7(B) ; C01-G-6D37
(ucs-set-char #x69E8 ?$@\Z(B) ; J78-@-5C5A
(ucs-set-char #x69E8 ?$B\Z(B) ; J83-B-5C5A
(ucs-set-char #x69E9 ?$(ILd(B) ; C03-I-4C64
(ucs-set-char #x69EA ?$(CKH(B) ; KS0-C-4B48
(ucs-set-char #x69EA ?$(IL`(B) ; C03-I-4C60
(ucs-set-char #x69EB ?$(HQ.(B) ; C02-H-512E
(ucs-set-char #x69EB ?$@\g(B) ; J78-@-5C67
(ucs-set-char #x69EB ?$B\g(B) ; J83-B-5C67
(ucs-set-char #x69EC ?$(HP{(B) ; C02-H-507B
(ucs-set-char #x69ED ?$(GmB(B) ; C01-G-6D42
(ucs-set-char #x69ED ?$@\e(B) ; J78-@-5C65
(ucs-set-char #x69ED ?$AiJ(B) ; GB0-A-694A
(ucs-set-char #x69ED ?$B\e(B) ; J83-B-5C65
(ucs-set-char #x69EE ?$(DDl(B) ; J90-D-446C
(ucs-set-char #x69EE ?$(HQ$(B) ; C02-H-5124
(ucs-set-char #x69EF ?$(DDm(B) ; J90-D-446D
(ucs-set-char #x69EF ?$(ILO(B) ; C03-I-4C4F
(ucs-set-char #x69F0 ?$(ILQ(B) ; C03-I-4C51
(ucs-set-char #x69F1 ?$(DDn(B) ; J90-D-446E
(ucs-set-char #x69F1 ?$(HPw(B) ; C02-H-5077
(ucs-set-char #x69F2 ?$(HQ#(B) ; C02-H-5123
(ucs-set-char #x69F2 ?$@\`(B) ; J78-@-5C60
(ucs-set-char #x69F2 ?$AiN(B) ; GB0-A-694E
(ucs-set-char #x69F2 ?$B\`(B) ; J83-B-5C60
(ucs-set-char #x69F3 ?$(DDo(B) ; J90-D-446F
(ucs-set-char #x69F3 ?$(Gm?(B) ; C01-G-6D3F
(ucs-set-char #x69F4 ?$(HQ7(B) ; C02-H-5137
(ucs-set-char #x69F5 ?$(DDp(B) ; J90-D-4470
(ucs-set-char #x69F5 ?$(JJ=(B) ; C04-J-4A3D
(ucs-set-char #x69F6 ?$(HQ4(B) ; C02-H-5134
(ucs-set-char #x69F7 ?$(HQ&(B) ; C02-H-5126
(ucs-set-char #x69F8 ?$(HPu(B) ; C02-H-5075
(ucs-set-char #x69F9 ?$(IL_(B) ; C03-I-4C5F
(ucs-set-char #x69F9 ?$@\_(B) ; J78-@-5C5F
(ucs-set-char #x69F9 ?$B\_(B) ; J83-B-5C5F
(ucs-set-char #x69FA ?$(ILW(B) ; C03-I-4C57
(ucs-set-char #x69FB ?$(CP'(B) ; KS0-C-5027
(ucs-set-char #x69FB ?$(HQ+(B) ; C02-H-512B
(ucs-set-char #x69FB ?$@DP(B) ; J78-@-4450
(ucs-set-char #x69FB ?$BDP(B) ; J83-B-4450
(ucs-set-char #x69FC ?$(HQ-(B) ; C02-H-512D
(ucs-set-char #x69FD ?$(CpK(B) ; KS0-C-704B
(ucs-set-char #x69FD ?$(Gm;(B) ; C01-G-6D3B
(ucs-set-char #x69FD ?$@Ae(B) ; J78-@-4165
(ucs-set-char #x69FD ?$A2[(B) ; GB0-A-325B
(ucs-set-char #x69FD ?$BAe(B) ; J83-B-4165
(ucs-set-char #x69FE ?$(DDq(B) ; J90-D-4471
(ucs-set-char #x69FE ?$(HQ!(B) ; C02-H-5121
(ucs-set-char #x69FF ?$(CPG(B) ; KS0-C-5047
(ucs-set-char #x69FF ?$(HPz(B) ; C02-H-507A
(ucs-set-char #x69FF ?$@\](B) ; J78-@-5C5D
(ucs-set-char #x69FF ?$AiH(B) ; GB0-A-6948
(ucs-set-char #x69FF ?$B\](B) ; J83-B-5C5D
(ucs-set-char #x6A00 ?$(DDr(B) ; J90-D-4472
(ucs-set-char #x6A00 ?$(HPq(B) ; C02-H-5071
(ucs-set-char #x6A01 ?$(DDs(B) ; J90-D-4473
(ucs-set-char #x6A01 ?$(Gm8(B) ; C01-G-6D38
(ucs-set-char #x6A02 ?$(CdE(B) ; KS0-C-6445
(ucs-set-char #x6A02 ?$(Gm@(B) ; C01-G-6D40
(ucs-set-char #x6A02 ?$@\[(B) ; J78-@-5C5B
(ucs-set-char #x6A02 ?$B\[(B) ; J83-B-5C5B
(ucs-set-char #x6A03 ?$(DDt(B) ; J90-D-4474
(ucs-set-char #x6A03 ?$(JJH(B) ; C04-J-4A48
(ucs-set-char #x6A04 ?$(HQ0(B) ; C02-H-5130
(ucs-set-char #x6A05 ?$(GmA(B) ; C01-G-6D41
(ucs-set-char #x6A05 ?$@\b(B) ; J78-@-5C62
(ucs-set-char #x6A05 ?$B\b(B) ; J83-B-5C62
(ucs-set-char #x6A06 ?$(HPr(B) ; C02-H-5072
(ucs-set-char #x6A07 ?$(HQ6(B) ; C02-H-5136
(ucs-set-char #x6A08 ?$(HQ)(B) ; C02-H-5129
(ucs-set-char #x6A09 ?$(HQ/(B) ; C02-H-512F
(ucs-set-char #x6A0A ?$(C[`(B) ; KS0-C-5B60
(ucs-set-char #x6A0A ?$(Gm>(B) ; C01-G-6D3E
(ucs-set-char #x6A0A ?$@\h(B) ; J78-@-5C68
(ucs-set-char #x6A0A ?$A7.(B) ; GB0-A-372E
(ucs-set-char #x6A0A ?$B\h(B) ; J83-B-5C68
(ucs-set-char #x6A0B ?$(ILM(B) ; C03-I-4C4D
(ucs-set-char #x6A0B ?$@Hu(B) ; J78-@-4875
(ucs-set-char #x6A0B ?$BHu(B) ; J83-B-4875
(ucs-set-char #x6A0C ?$(ILP(B) ; C03-I-4C50
(ucs-set-char #x6A0C ?$@\n(B) ; J78-@-5C6E
(ucs-set-char #x6A0C ?$B\n(B) ; J83-B-5C6E
(ucs-set-char #x6A0D ?$(HQ,(B) ; C02-H-512C
(ucs-set-char #x6A0E ?$(ILG(B) ; C03-I-4C47
(ucs-set-char #x6A0F ?$(DDu(B) ; J90-D-4475
(ucs-set-char #x6A0F ?$(HQ3(B) ; C02-H-5133
(ucs-set-char #x6A10 ?$(IL[(B) ; C03-I-4C5B
(ucs-set-char #x6A11 ?$(CUZ(B) ; KS0-C-555A
(ucs-set-char #x6A11 ?$(DDv(B) ; J90-D-4476
(ucs-set-char #x6A11 ?$(GmC(B) ; C01-G-6D43
(ucs-set-char #x6A12 ?$(ILV(B) ; C03-I-4C56
(ucs-set-char #x6A12 ?$@\i(B) ; J78-@-5C69
(ucs-set-char #x6A12 ?$B\i(B) ; J83-B-5C69
(ucs-set-char #x6A13 ?$(CW'(B) ; KS0-C-5727
(ucs-set-char #x6A13 ?$(Gm=(B) ; C01-G-6D3D
(ucs-set-char #x6A13 ?$@\l(B) ; J78-@-5C6C
(ucs-set-char #x6A13 ?$B\l(B) ; J83-B-5C6C
(ucs-set-char #x6A14 ?$(HQ%(B) ; C02-H-5125
(ucs-set-char #x6A14 ?$@\f(B) ; J78-@-5C66
(ucs-set-char #x6A14 ?$B\f(B) ; J83-B-5C66
(ucs-set-char #x6A15 ?$(DDw(B) ; J90-D-4477
(ucs-set-char #x6A15 ?$(HPv(B) ; C02-H-5076
(ucs-set-char #x6A16 ?$(HQ8(B) ; C02-H-5138
(ucs-set-char #x6A17 ?$(Cn@(B) ; KS0-C-6E40
(ucs-set-char #x6A17 ?$(HPs(B) ; C02-H-5073
(ucs-set-char #x6A17 ?$@Ct(B) ; J78-@-4374
(ucs-set-char #x6A17 ?$AiK(B) ; GB0-A-694B
(ucs-set-char #x6A17 ?$BCt(B) ; J83-B-4374
(ucs-set-char #x6A18 ?$(HQ1(B) ; C02-H-5131
(ucs-set-char #x6A18 ?$AiL(B) ; GB0-A-694C
(ucs-set-char #x6A19 ?$(Cxv(B) ; KS0-C-7876
(ucs-set-char #x6A19 ?$(Gm:(B) ; C01-G-6D3A
(ucs-set-char #x6A19 ?$@I8(B) ; J78-@-4938
(ucs-set-char #x6A19 ?$BI8(B) ; J83-B-4938
(ucs-set-char #x6A1A ?$(DDx(B) ; J90-D-4478
(ucs-set-char #x6A1A ?$(ILJ(B) ; C03-I-4C4A
(ucs-set-char #x6A1B ?$(HP}(B) ; C02-H-507D
(ucs-set-char #x6A1B ?$@\\(B) ; J78-@-5C5C
(ucs-set-char #x6A1B ?$B\\(B) ; J83-B-5C5C
(ucs-set-char #x6A1C ?$(ILI(B) ; C03-I-4C49
(ucs-set-char #x6A1D ?$(DDy(B) ; J90-D-4479
(ucs-set-char #x6A1D ?$(HP~(B) ; C02-H-507E
(ucs-set-char #x6A1E ?$(CuR(B) ; KS0-C-7552
(ucs-set-char #x6A1E ?$(Gm9(B) ; C01-G-6D39
(ucs-set-char #x6A1E ?$@\d(B) ; J78-@-5C64
(ucs-set-char #x6A1E ?$B\d(B) ; J83-B-5C64
(ucs-set-char #x6A1F ?$(Cmi(B) ; KS0-C-6D69
(ucs-set-char #x6A1F ?$(Gm6(B) ; C01-G-6D36
(ucs-set-char #x6A1F ?$@>@(B) ; J78-@-3E40
(ucs-set-char #x6A1F ?$AUA(B) ; GB0-A-5541
(ucs-set-char #x6A1F ?$B>@(B) ; J83-B-3E40
(ucs-set-char #x6A20 ?$(DDz(B) ; J90-D-447A
(ucs-set-char #x6A20 ?$(HPy(B) ; C02-H-5079
(ucs-set-char #x6A21 ?$(CY<(B) ; KS0-C-593C
(ucs-set-char #x6A21 ?$(Gm<(B) ; C01-G-6D3C
(ucs-set-char #x6A21 ?$@LO(B) ; J78-@-4C4F
(ucs-set-char #x6A21 ?$AD#(B) ; GB0-A-4423
(ucs-set-char #x6A21 ?$BLO(B) ; J83-B-4C4F
(ucs-set-char #x6A22 ?$(ILR(B) ; C03-I-4C52
(ucs-set-char #x6A22 ?$@\x(B) ; J78-@-5C78
(ucs-set-char #x6A22 ?$B\x(B) ; J83-B-5C78
(ucs-set-char #x6A23 ?$(CeF(B) ; KS0-C-6546
(ucs-set-char #x6A23 ?$(Gm5(B) ; C01-G-6D35
(ucs-set-char #x6A23 ?$@\k(B) ; J78-@-5C6B
(ucs-set-char #x6A23 ?$B\k(B) ; J83-B-5C6B
(ucs-set-char #x6A24 ?$(DD{(B) ; J90-D-447B
(ucs-set-char #x6A24 ?$(ILb(B) ; C03-I-4C62
(ucs-set-char #x6A25 ?$(HQ2(B) ; C02-H-5132
(ucs-set-char #x6A26 ?$(HQ5(B) ; C02-H-5135
(ucs-set-char #x6A27 ?$(HQ"(B) ; C02-H-5122
(ucs-set-char #x6A28 ?$(DD|(B) ; J90-D-447C
(ucs-set-char #x6A28 ?$(HWU(B) ; C02-H-5755
(ucs-set-char #x6A28 ?$AiX(B) ; GB0-A-6958
(ucs-set-char #x6A29 ?$(IL^(B) ; C03-I-4C5E
(ucs-set-char #x6A29 ?$@8"(B) ; J78-@-3822
(ucs-set-char #x6A29 ?$B8"(B) ; J83-B-3822
(ucs-set-char #x6A2A ?$(ILY(B) ; C03-I-4C59
(ucs-set-char #x6A2A ?$@2#(B) ; J78-@-3223
(ucs-set-char #x6A2A ?$A:a(B) ; GB0-A-3A61
(ucs-set-char #x6A2A ?$B2#(B) ; J83-B-3223
(ucs-set-char #x6A2B ?$@3_(B) ; J78-@-335F
(ucs-set-char #x6A2B ?$B3_(B) ; J83-B-335F
(ucs-set-char #x6A2C ?$(ILa(B) ; C03-I-4C61
(ucs-set-char #x6A2E ?$@\S(B) ; J78-@-5C53
(ucs-set-char #x6A2E ?$B\S(B) ; J83-B-5C53
(ucs-set-char #x6A2F ?$AiI(B) ; GB0-A-6949
(ucs-set-char #x6A30 ?$(DD}(B) ; J90-D-447D
(ucs-set-char #x6A31 ?$AS#(B) ; GB0-A-5323
(ucs-set-char #x6A32 ?$(DD~(B) ; J90-D-447E
(ucs-set-char #x6A32 ?$(HWM(B) ; C02-H-574D
(ucs-set-char #x6A33 ?$(IQ,(B) ; C03-I-512C
(ucs-set-char #x6A34 ?$(DE!(B) ; J90-D-4521
(ucs-set-char #x6A34 ?$(HWI(B) ; C02-H-5749
(ucs-set-char #x6A35 ?$(Cu#(B) ; KS0-C-7523
(ucs-set-char #x6A35 ?$(Gq!(B) ; C01-G-7121
(ucs-set-char #x6A35 ?$@>A(B) ; J78-@-3E41
(ucs-set-char #x6A35 ?$AiT(B) ; GB0-A-6954
(ucs-set-char #x6A35 ?$B>A(B) ; J83-B-3E41
(ucs-set-char #x6A36 ?$(IQ<(B) ; C03-I-513C
(ucs-set-char #x6A36 ?$@\p(B) ; J78-@-5C70
(ucs-set-char #x6A36 ?$B\p(B) ; J83-B-5C70
(ucs-set-char #x6A37 ?$(DE"(B) ; J90-D-4522
(ucs-set-char #x6A37 ?$(IQ8(B) ; C03-I-5138
(ucs-set-char #x6A38 ?$(CZT(B) ; KS0-C-5A54
(ucs-set-char #x6A38 ?$(Gpt(B) ; C01-G-7074
(ucs-set-char #x6A38 ?$@\w(B) ; J78-@-5C77
(ucs-set-char #x6A38 ?$B\w(B) ; J83-B-5C77
(ucs-set-char #x6A39 ?$(Cb'(B) ; KS0-C-6227
(ucs-set-char #x6A39 ?$(Gpy(B) ; C01-G-7079
(ucs-set-char #x6A39 ?$@<y(B) ; J78-@-3C79
(ucs-set-char #x6A39 ?$B<y(B) ; J83-B-3C79
(ucs-set-char #x6A3A ?$(C{|(B) ; KS0-C-7B7C
(ucs-set-char #x6A3A ?$(Gpu(B) ; C01-G-7075
(ucs-set-char #x6A3A ?$@3r(B) ; J78-@-3372
(ucs-set-char #x6A3A ?$B3r(B) ; J83-B-3372
(ucs-set-char #x6A3B ?$(DE#(B) ; J90-D-4523
(ucs-set-char #x6A3B ?$(HWW(B) ; C02-H-5757
(ucs-set-char #x6A3C ?$(HWb(B) ; C02-H-5762
(ucs-set-char #x6A3D ?$(Cq\(B) ; KS0-C-715C
(ucs-set-char #x6A3D ?$(Gps(B) ; C01-G-7073
(ucs-set-char #x6A3D ?$@C.(B) ; J78-@-432E
(ucs-set-char #x6A3D ?$AiW(B) ; GB0-A-6957
(ucs-set-char #x6A3D ?$BC.(B) ; J83-B-432E
(ucs-set-char #x6A3E ?$(DE$(B) ; J90-D-4524
(ucs-set-char #x6A3E ?$(HWO(B) ; C02-H-574F
(ucs-set-char #x6A3E ?$AiP(B) ; GB0-A-6950
(ucs-set-char #x6A3F ?$(DE%(B) ; J90-D-4525
(ucs-set-char #x6A3F ?$(HWX(B) ; C02-H-5758
(ucs-set-char #x6A40 ?$(HQ((B) ; C02-H-5128
(ucs-set-char #x6A41 ?$(HWY(B) ; C02-H-5759
(ucs-set-char #x6A42 ?$(IQ((B) ; C03-I-5128
(ucs-set-char #x6A43 ?$(IQ+(B) ; C03-I-512B
(ucs-set-char #x6A44 ?$(CJt(B) ; KS0-C-4A74
(ucs-set-char #x6A44 ?$(Gpz(B) ; C01-G-707A
(ucs-set-char #x6A44 ?$@\m(B) ; J78-@-5C6D
(ucs-set-char #x6A44 ?$AiO(B) ; GB0-A-694F
(ucs-set-char #x6A44 ?$B\m(B) ; J83-B-5C6D
(ucs-set-char #x6A45 ?$(DE&(B) ; J90-D-4526
(ucs-set-char #x6A45 ?$(IQ@(B) ; C03-I-5140
(ucs-set-char #x6A46 ?$(DE'(B) ; J90-D-4527
(ucs-set-char #x6A46 ?$(HWh(B) ; C02-H-5768
(ucs-set-char #x6A47 ?$(Gp~(B) ; C01-G-707E
(ucs-set-char #x6A47 ?$@\r(B) ; J78-@-5C72
(ucs-set-char #x6A47 ?$AGA(B) ; GB0-A-4741
(ucs-set-char #x6A47 ?$B\r(B) ; J83-B-5C72
(ucs-set-char #x6A48 ?$(Chz(B) ; KS0-C-687A
(ucs-set-char #x6A48 ?$(Gq#(B) ; C01-G-7123
(ucs-set-char #x6A48 ?$@\v(B) ; J78-@-5C76
(ucs-set-char #x6A48 ?$B\v(B) ; J83-B-5C76
(ucs-set-char #x6A49 ?$(DE((B) ; J90-D-4528
(ucs-set-char #x6A49 ?$(HWK(B) ; C02-H-574B
(ucs-set-char #x6A4A ?$(DE)(B) ; J90-D-4529
(ucs-set-char #x6A4A ?$(IQ;(B) ; C03-I-513B
(ucs-set-char #x6A4B ?$(CNi(B) ; KS0-C-4E69
(ucs-set-char #x6A4B ?$(Gp}(B) ; C01-G-707D
(ucs-set-char #x6A4B ?$@66(B) ; J78-@-3636
(ucs-set-char #x6A4B ?$B66(B) ; J83-B-3636
(ucs-set-char #x6A4C ?$(IQ1(B) ; C03-I-5131
(ucs-set-char #x6A4D ?$(HWf(B) ; C02-H-5766
(ucs-set-char #x6A4E ?$(DE*(B) ; J90-D-452A
(ucs-set-char #x6A4E ?$(HWg(B) ; C02-H-5767
(ucs-set-char #x6A4F ?$(HW](B) ; C02-H-575D
(ucs-set-char #x6A50 ?$(DE+(B) ; J90-D-452B
(ucs-set-char #x6A50 ?$(HW\(B) ; C02-H-575C
(ucs-set-char #x6A50 ?$AiR(B) ; GB0-A-6952
(ucs-set-char #x6A51 ?$(DE,(B) ; J90-D-452C
(ucs-set-char #x6A51 ?$(HWT(B) ; C02-H-5754
(ucs-set-char #x6A52 ?$(Cix(B) ; KS0-C-6978
(ucs-set-char #x6A52 ?$(DE-(B) ; J90-D-452D
(ucs-set-char #x6A52 ?$(IQ)(B) ; C03-I-5129
(ucs-set-char #x6A53 ?$(Cbe(B) ; KS0-C-6265
(ucs-set-char #x6A53 ?$(IQ>(B) ; C03-I-513E
(ucs-set-char #x6A54 ?$(HW^(B) ; C02-H-575E
(ucs-set-char #x6A55 ?$(DE.(B) ; J90-D-452E
(ucs-set-char #x6A55 ?$(HWe(B) ; C02-H-5765
(ucs-set-char #x6A56 ?$(DE/(B) ; J90-D-452F
(ucs-set-char #x6A56 ?$(HWd(B) ; C02-H-5764
(ucs-set-char #x6A57 ?$(IQ/(B) ; C03-I-512F
(ucs-set-char #x6A58 ?$(CP9(B) ; KS0-C-5039
(ucs-set-char #x6A58 ?$(Gpx(B) ; C01-G-7078
(ucs-set-char #x6A58 ?$@5L(B) ; J78-@-354C
(ucs-set-char #x6A58 ?$AiY(B) ; GB0-A-6959
(ucs-set-char #x6A58 ?$B5L(B) ; J83-B-354C
(ucs-set-char #x6A59 ?$(CTr(B) ; KS0-C-5472
(ucs-set-char #x6A59 ?$(Gpv(B) ; C01-G-7076
(ucs-set-char #x6A59 ?$@\t(B) ; J78-@-5C74
(ucs-set-char #x6A59 ?$A3H(B) ; GB0-A-3348
(ucs-set-char #x6A59 ?$B\t(B) ; J83-B-5C74
(ucs-set-char #x6A5A ?$(HWV(B) ; C02-H-5756
(ucs-set-char #x6A5B ?$(DE0(B) ; J90-D-4530
(ucs-set-char #x6A5B ?$(HWS(B) ; C02-H-5753
(ucs-set-char #x6A5B ?$AiS(B) ; GB0-A-6953
(ucs-set-char #x6A5C ?$(IQD(B) ; C03-I-5144
(ucs-set-char #x6A5D ?$(HWP(B) ; C02-H-5750
(ucs-set-char #x6A5E ?$(HWc(B) ; C02-H-5763
(ucs-set-char #x6A5F ?$(CQ&(B) ; KS0-C-5126
(ucs-set-char #x6A5F ?$(Gq"(B) ; C01-G-7122
(ucs-set-char #x6A5F ?$@5!(B) ; J78-@-3521
(ucs-set-char #x6A5F ?$B5!(B) ; J83-B-3521
(ucs-set-char #x6A60 ?$(HWa(B) ; C02-H-5761
(ucs-set-char #x6A61 ?$(C_N(B) ; KS0-C-5F4E
(ucs-set-char #x6A61 ?$(Gp|(B) ; C01-G-707C
(ucs-set-char #x6A61 ?$@FK(B) ; J78-@-464B
(ucs-set-char #x6A61 ?$AOp(B) ; GB0-A-4F70
(ucs-set-char #x6A61 ?$BFK(B) ; J83-B-464B
(ucs-set-char #x6A62 ?$(Gp{(B) ; C01-G-707B
(ucs-set-char #x6A62 ?$@\s(B) ; J78-@-5C73
(ucs-set-char #x6A62 ?$B\s(B) ; J83-B-5C73
(ucs-set-char #x6A63 ?$(IQ'(B) ; C03-I-5127
(ucs-set-char #x6A64 ?$(DE1(B) ; J90-D-4531
(ucs-set-char #x6A64 ?$(HW[(B) ; C02-H-575B
(ucs-set-char #x6A65 ?$(JJK(B) ; C04-J-4A4B
(ucs-set-char #x6A65 ?$AiM(B) ; GB0-A-694D
(ucs-set-char #x6A66 ?$(HWJ(B) ; C02-H-574A
(ucs-set-char #x6A66 ?$@\u(B) ; J78-@-5C75
(ucs-set-char #x6A66 ?$B\u(B) ; J83-B-5C75
(ucs-set-char #x6A67 ?$(DE2(B) ; J90-D-4532
(ucs-set-char #x6A67 ?$(HWL(B) ; C02-H-574C
(ucs-set-char #x6A68 ?$(HWN(B) ; C02-H-574E
(ucs-set-char #x6A69 ?$(HW`(B) ; C02-H-5760
(ucs-set-char #x6A6A ?$(DE3(B) ; J90-D-4533
(ucs-set-char #x6A6A ?$(HWZ(B) ; C02-H-575A
(ucs-set-char #x6A6B ?$(C|t(B) ; KS0-C-7C74
(ucs-set-char #x6A6B ?$(Gpw(B) ; C01-G-7077
(ucs-set-char #x6A6C ?$(IQ.(B) ; C03-I-512E
(ucs-set-char #x6A6D ?$(HWQ(B) ; C02-H-5751
(ucs-set-char #x6A6E ?$(IQ2(B) ; C03-I-5132
(ucs-set-char #x6A6F ?$(HW_(B) ; C02-H-575F
(ucs-set-char #x6A70 ?$(IQA(B) ; C03-I-5141
(ucs-set-char #x6A71 ?$(DE4(B) ; J90-D-4534
(ucs-set-char #x6A71 ?$(IQ:(B) ; C03-I-513A
(ucs-set-char #x6A71 ?$A3w(B) ; GB0-A-3377
(ucs-set-char #x6A72 ?$@\o(B) ; J78-@-5C6F
(ucs-set-char #x6A72 ?$B\o(B) ; J83-B-5C6F
(ucs-set-char #x6A73 ?$(DE5(B) ; J90-D-4535
(ucs-set-char #x6A76 ?$(HWR(B) ; C02-H-5752
(ucs-set-char #x6A78 ?$@\q(B) ; J78-@-5C71
(ucs-set-char #x6A78 ?$B\q(B) ; J83-B-5C71
(ucs-set-char #x6A79 ?$AiV(B) ; GB0-A-6956
(ucs-set-char #x6A7C ?$AiZ(B) ; GB0-A-695A
(ucs-set-char #x6A7D ?$(ITu(B) ; C03-I-5475
(ucs-set-char #x6A7E ?$(DE6(B) ; J90-D-4536
(ucs-set-char #x6A7E ?$(Gsx(B) ; C01-G-7378
(ucs-set-char #x6A7F ?$(H]1(B) ; C02-H-5D31
(ucs-set-char #x6A7F ?$@3`(B) ; J78-@-3360
(ucs-set-char #x6A7F ?$B3`(B) ; J83-B-3360
(ucs-set-char #x6A80 ?$(CS*(B) ; KS0-C-532A
(ucs-set-char #x6A80 ?$(Gsq(B) ; C01-G-7371
(ucs-set-char #x6A80 ?$@CI(B) ; J78-@-4349
(ucs-set-char #x6A80 ?$AL4(B) ; GB0-A-4C34
(ucs-set-char #x6A80 ?$BCI(B) ; J83-B-4349
(ucs-set-char #x6A81 ?$(DE7(B) ; J90-D-4537
(ucs-set-char #x6A81 ?$(H]"(B) ; C02-H-5D22
(ucs-set-char #x6A82 ?$(IT{(B) ; C03-I-547B
(ucs-set-char #x6A83 ?$(DE8(B) ; J90-D-4538
(ucs-set-char #x6A83 ?$(H]-(B) ; C02-H-5D2D
(ucs-set-char #x6A84 ?$(CL,(B) ; KS0-C-4C2C
(ucs-set-char #x6A84 ?$(Gss(B) ; C01-G-7373
(ucs-set-char #x6A84 ?$@\|(B) ; J78-@-5C7C
(ucs-set-char #x6A84 ?$AO-(B) ; GB0-A-4F2D
(ucs-set-char #x6A84 ?$B\|(B) ; J83-B-5C7C
(ucs-set-char #x6A85 ?$(H]4(B) ; C02-H-5D34
(ucs-set-char #x6A86 ?$(DE9(B) ; J90-D-4539
(ucs-set-char #x6A86 ?$(IU!(B) ; C03-I-5521
(ucs-set-char #x6A87 ?$(DE:(B) ; J90-D-453A
(ucs-set-char #x6A87 ?$(H])(B) ; C02-H-5D29
(ucs-set-char #x6A88 ?$(IT|(B) ; C03-I-547C
(ucs-set-char #x6A89 ?$(Co`(B) ; KS0-C-6F60
(ucs-set-char #x6A89 ?$(DE;(B) ; J90-D-453B
(ucs-set-char #x6A89 ?$(H]$(B) ; C02-H-5D24
(ucs-set-char #x6A8A ?$(ITv(B) ; C03-I-5476
(ucs-set-char #x6A8B ?$(DE<(B) ; J90-D-453C
(ucs-set-char #x6A8B ?$(JVE(B) ; C04-J-5645
(ucs-set-char #x6A8C ?$(H]5(B) ; C02-H-5D35
(ucs-set-char #x6A8D ?$(Cee(B) ; KS0-C-6565
(ucs-set-char #x6A8D ?$(H\~(B) ; C02-H-5C7E
(ucs-set-char #x6A8D ?$@\z(B) ; J78-@-5C7A
(ucs-set-char #x6A8D ?$B\z(B) ; J83-B-5C7A
(ucs-set-char #x6A8E ?$(CPU(B) ; KS0-C-5055
(ucs-set-char #x6A8E ?$(H]+(B) ; C02-H-5D2B
(ucs-set-char #x6A8E ?$@8i(B) ; J78-@-3869
(ucs-set-char #x6A8E ?$AiU(B) ; GB0-A-6955
(ucs-set-char #x6A8E ?$B8i(B) ; J83-B-3869
(ucs-set-char #x6A8F ?$(IU'(B) ; C03-I-5527
(ucs-set-char #x6A90 ?$(Gsz(B) ; C01-G-737A
(ucs-set-char #x6A90 ?$@\y(B) ; J78-@-5C79
(ucs-set-char #x6A90 ?$Ai\(B) ; GB0-A-695C
(ucs-set-char #x6A90 ?$B\y(B) ; J83-B-5C79
(ucs-set-char #x6A91 ?$(DE=(B) ; J90-D-453D
(ucs-set-char #x6A91 ?$(H]0(B) ; C02-H-5D30
(ucs-set-char #x6A91 ?$Ai[(B) ; GB0-A-695B
(ucs-set-char #x6A92 ?$(H]6(B) ; C02-H-5D36
(ucs-set-char #x6A93 ?$(H]*(B) ; C02-H-5D2A
(ucs-set-char #x6A94 ?$(Gsr(B) ; C01-G-7372
(ucs-set-char #x6A95 ?$(H],(B) ; C02-H-5D2C
(ucs-set-char #x6A96 ?$(H]!(B) ; C02-H-5D21
(ucs-set-char #x6A97 ?$(C[|(B) ; KS0-C-5B7C
(ucs-set-char #x6A97 ?$(Gsy(B) ; C01-G-7379
(ucs-set-char #x6A97 ?$@]!(B) ; J78-@-5D21
(ucs-set-char #x6A97 ?$Ai^(B) ; GB0-A-695E
(ucs-set-char #x6A97 ?$B]!(B) ; J83-B-5D21
(ucs-set-char #x6A98 ?$(IU#(B) ; C03-I-5523
(ucs-set-char #x6A99 ?$(ITz(B) ; C03-I-547A
(ucs-set-char #x6A9A ?$(H]3(B) ; C02-H-5D33
(ucs-set-char #x6A9B ?$(DE>(B) ; J90-D-453E
(ucs-set-char #x6A9B ?$(H]&(B) ; C02-H-5D26
(ucs-set-char #x6A9C ?$(C|f(B) ; KS0-C-7C66
(ucs-set-char #x6A9C ?$(Gsu(B) ; C01-G-7375
(ucs-set-char #x6A9C ?$@I0(B) ; J78-@-4930
(ucs-set-char #x6A9C ?$B[X(B) ; J83-B-5B58
(ucs-set-char #x6A9D ?$(DE?(B) ; J90-D-453F
(ucs-set-char #x6A9D ?$(IU$(B) ; C03-I-5524
(ucs-set-char #x6A9E ?$(DE@(B) ; J90-D-4540
(ucs-set-char #x6A9E ?$(H]((B) ; C02-H-5D28
(ucs-set-char #x6A9F ?$(DEA(B) ; J90-D-4541
(ucs-set-char #x6A9F ?$(H]%(B) ; C02-H-5D25
(ucs-set-char #x6AA0 ?$(Gs{(B) ; C01-G-737B
(ucs-set-char #x6AA0 ?$@\{(B) ; J78-@-5C7B
(ucs-set-char #x6AA0 ?$AiQ(B) ; GB0-A-6951
(ucs-set-char #x6AA0 ?$B\{(B) ; J83-B-5C7B
(ucs-set-char #x6AA1 ?$(H]'(B) ; C02-H-5D27
(ucs-set-char #x6AA2 ?$(CK~(B) ; KS0-C-4B7E
(ucs-set-char #x6AA2 ?$(Gst(B) ; C01-G-7374
(ucs-set-char #x6AA2 ?$@\}(B) ; J78-@-5C7D
(ucs-set-char #x6AA2 ?$B\}(B) ; J83-B-5C7D
(ucs-set-char #x6AA3 ?$(Cmj(B) ; KS0-C-6D6A
(ucs-set-char #x6AA3 ?$(Gsw(B) ; C01-G-7377
(ucs-set-char #x6AA3 ?$@\~(B) ; J78-@-5C7E
(ucs-set-char #x6AA3 ?$B\~(B) ; J83-B-5C7E
(ucs-set-char #x6AA4 ?$(H]/(B) ; C02-H-5D2F
(ucs-set-char #x6AA5 ?$(DEB(B) ; J90-D-4542
(ucs-set-char #x6AA5 ?$(H]#(B) ; C02-H-5D23
(ucs-set-char #x6AA6 ?$(H]2(B) ; C02-H-5D32
(ucs-set-char #x6AA7 ?$(ITx(B) ; C03-I-5478
(ucs-set-char #x6AA8 ?$(H].(B) ; C02-H-5D2E
(ucs-set-char #x6AA9 ?$Ai](B) ; GB0-A-695D
(ucs-set-char #x6AAA ?$(IU)(B) ; C03-I-5529
(ucs-set-char #x6AAA ?$@],(B) ; J78-@-5D2C
(ucs-set-char #x6AAA ?$B],(B) ; J83-B-5D2C
(ucs-set-char #x6AAB ?$(DEC(B) ; J90-D-4543
(ucs-set-char #x6AAB ?$(IWt(B) ; C03-I-5774
(ucs-set-char #x6AAB ?$Ai_(B) ; GB0-A-695F
(ucs-set-char #x6AAC ?$(GvO(B) ; C01-G-764F
(ucs-set-char #x6AAC ?$@]((B) ; J78-@-5D28
(ucs-set-char #x6AAC ?$ACJ(B) ; GB0-A-434A
(ucs-set-char #x6AAC ?$B]((B) ; J83-B-5D28
(ucs-set-char #x6AAD ?$(Has(B) ; C02-H-6173
(ucs-set-char #x6AAE ?$(GvT(B) ; C01-G-7654
(ucs-set-char #x6AAE ?$@En(B) ; J78-@-456E
(ucs-set-char #x6AAE ?$B[m(B) ; J83-B-5B6D
(ucs-set-char #x6AAF ?$(DED(B) ; J90-D-4544
(ucs-set-char #x6AAF ?$(GvU(B) ; C01-G-7655
(ucs-set-char #x6AB0 ?$(DEE(B) ; J90-D-4545
(ucs-set-char #x6AB0 ?$(IWw(B) ; C03-I-5777
(ucs-set-char #x6AB1 ?$(DEF(B) ; J90-D-4546
(ucs-set-char #x6AB1 ?$(IX!(B) ; C03-I-5821
(ucs-set-char #x6AB2 ?$(IWv(B) ; C03-I-5776
(ucs-set-char #x6AB3 ?$(C^1(B) ; KS0-C-5E31
(ucs-set-char #x6AB3 ?$(GvN(B) ; C01-G-764E
(ucs-set-char #x6AB3 ?$@]'(B) ; J78-@-5D27
(ucs-set-char #x6AB3 ?$B]'(B) ; J83-B-5D27
(ucs-set-char #x6AB4 ?$(DEG(B) ; J90-D-4547
(ucs-set-char #x6AB4 ?$(Har(B) ; C02-H-6172
(ucs-set-char #x6AB5 ?$(IWx(B) ; C03-I-5778
(ucs-set-char #x6AB6 ?$(Hao(B) ; C02-H-616F
(ucs-set-char #x6AB7 ?$(Hap(B) ; C02-H-6170
(ucs-set-char #x6AB8 ?$(GvR(B) ; C01-G-7652
(ucs-set-char #x6AB8 ?$@]&(B) ; J78-@-5D26
(ucs-set-char #x6AB8 ?$B]&(B) ; J83-B-5D26
(ucs-set-char #x6AB9 ?$(Haj(B) ; C02-H-616A
(ucs-set-char #x6ABA ?$(Han(B) ; C02-H-616E
(ucs-set-char #x6ABB ?$(Cyc(B) ; KS0-C-7963
(ucs-set-char #x6ABB ?$(GvQ(B) ; C01-G-7651
(ucs-set-char #x6ABB ?$@]#(B) ; J78-@-5D23
(ucs-set-char #x6ABB ?$B]#(B) ; J83-B-5D23
(ucs-set-char #x6ABC ?$(IW~(B) ; C03-I-577E
(ucs-set-char #x6ABD ?$(DEH(B) ; J90-D-4548
(ucs-set-char #x6ABD ?$(Hak(B) ; C02-H-616B
(ucs-set-char #x6ABE ?$(DEI(B) ; J90-D-4549
(ucs-set-char #x6ABE ?$(IWy(B) ; C03-I-5779
(ucs-set-char #x6ABF ?$(DEJ(B) ; J90-D-454A
(ucs-set-char #x6ABF ?$(IX#(B) ; C03-I-5823
(ucs-set-char #x6AC0 ?$(IW}(B) ; C03-I-577D
(ucs-set-char #x6AC1 ?$(IWz(B) ; C03-I-577A
(ucs-set-char #x6AC1 ?$@\j(B) ; J78-@-5C6A
(ucs-set-char #x6AC1 ?$B\j(B) ; J83-B-5C6A
(ucs-set-char #x6AC2 ?$(CT"(B) ; KS0-C-5422
(ucs-set-char #x6AC2 ?$(GvS(B) ; C01-G-7653
(ucs-set-char #x6AC2 ?$@]%(B) ; J78-@-5D25
(ucs-set-char #x6AC2 ?$B]%(B) ; J83-B-5D25
(ucs-set-char #x6AC3 ?$(COv(B) ; KS0-C-4F76
(ucs-set-char #x6AC3 ?$(GvP(B) ; C01-G-7650
(ucs-set-char #x6AC3 ?$@]$(B) ; J78-@-5D24
(ucs-set-char #x6AC3 ?$B]$(B) ; J83-B-5D24
(ucs-set-char #x6AC4 ?$(IX"(B) ; C03-I-5822
(ucs-set-char #x6AC5 ?$(Hai(B) ; C02-H-6169
(ucs-set-char #x6AC6 ?$(DEK(B) ; J90-D-454B
(ucs-set-char #x6AC6 ?$(Ham(B) ; C02-H-616D
(ucs-set-char #x6AC7 ?$(Haq(B) ; C02-H-6171
(ucs-set-char #x6AC8 ?$(DEM(B) ; J90-D-454D
(ucs-set-char #x6AC8 ?$(IW{(B) ; C03-I-577B
(ucs-set-char #x6AC9 ?$(DEL(B) ; J90-D-454C
(ucs-set-char #x6ACB ?$(He\(B) ; C02-H-655C
(ucs-set-char #x6ACC ?$(DEN(B) ; J90-D-454E
(ucs-set-char #x6ACC ?$(HeY(B) ; C02-H-6559
(ucs-set-char #x6ACD ?$(Heb(B) ; C02-H-6562
(ucs-set-char #x6ACE ?$(IZD(B) ; C03-I-5A44
(ucs-set-char #x6ACF ?$(Hea(B) ; C02-H-6561
(ucs-set-char #x6AD0 ?$(DEO(B) ; J90-D-454F
(ucs-set-char #x6AD0 ?$(He_(B) ; C02-H-655F
(ucs-set-char #x6AD1 ?$(HeZ(B) ; C02-H-655A
(ucs-set-char #x6AD1 ?$@]*(B) ; J78-@-5D2A
(ucs-set-char #x6AD1 ?$B]*(B) ; J83-B-5D2A
(ucs-set-char #x6AD2 ?$(IZO(B) ; C03-I-5A4F
(ucs-set-char #x6AD3 ?$(CVP(B) ; KS0-C-5650
(ucs-set-char #x6AD3 ?$(Gx?(B) ; C01-G-783F
(ucs-set-char #x6AD3 ?$@O&(B) ; J78-@-4F26
(ucs-set-char #x6AD3 ?$BO&(B) ; J83-B-4F26
(ucs-set-char #x6AD4 ?$(DEP(B) ; J90-D-4550
(ucs-set-char #x6AD4 ?$(IZE(B) ; C03-I-5A45
(ucs-set-char #x6AD5 ?$(DEQ(B) ; J90-D-4551
(ucs-set-char #x6AD5 ?$(IZN(B) ; C03-I-5A4E
(ucs-set-char #x6AD6 ?$(DER(B) ; J90-D-4552
(ucs-set-char #x6AD6 ?$(J_q(B) ; C04-J-5F71
(ucs-set-char #x6AD7 ?$(IZG(B) ; C03-I-5A47
(ucs-set-char #x6AD8 ?$(IZM(B) ; C03-I-5A4D
(ucs-set-char #x6AD9 ?$(He[(B) ; C02-H-655B
(ucs-set-char #x6ADA ?$(CUj(B) ; KS0-C-556A
(ucs-set-char #x6ADA ?$(Gx>(B) ; C01-G-783E
(ucs-set-char #x6ADA ?$@]-(B) ; J78-@-5D2D
(ucs-set-char #x6ADA ?$B]-(B) ; J83-B-5D2D
(ucs-set-char #x6ADB ?$(Cqn(B) ; KS0-C-716E
(ucs-set-char #x6ADB ?$(Gsv(B) ; C01-G-7376
(ucs-set-char #x6ADB ?$@6{(B) ; J78-@-367B
(ucs-set-char #x6ADB ?$B6{(B) ; J83-B-367B
(ucs-set-char #x6ADC ?$(DES(B) ; J90-D-4553
(ucs-set-char #x6ADC ?$(He^(B) ; C02-H-655E
(ucs-set-char #x6ADD ?$(DET(B) ; J90-D-4554
(ucs-set-char #x6ADD ?$(Gx=(B) ; C01-G-783D
(ucs-set-char #x6ADE ?$(Hec(B) ; C02-H-6563
(ucs-set-char #x6ADE ?$@])(B) ; J78-@-5D29
(ucs-set-char #x6ADE ?$B])(B) ; J83-B-5D29
(ucs-set-char #x6ADF ?$(He](B) ; C02-H-655D
(ucs-set-char #x6ADF ?$@]+(B) ; J78-@-5D2B
(ucs-set-char #x6ADF ?$B]+(B) ; J83-B-5D2B
(ucs-set-char #x6AE0 ?$(HeX(B) ; C02-H-6558
(ucs-set-char #x6AE1 ?$(Hal(B) ; C02-H-616C
(ucs-set-char #x6AE2 ?$(IZH(B) ; C03-I-5A48
(ucs-set-char #x6AE3 ?$(IZF(B) ; C03-I-5A46
(ucs-set-char #x6AE4 ?$(DEU(B) ; J90-D-4555
(ucs-set-char #x6AE5 ?$(Gx<(B) ; C01-G-783C
(ucs-set-char #x6AE7 ?$(DEV(B) ; J90-D-4556
(ucs-set-char #x6AE7 ?$(HeW(B) ; C02-H-6557
(ucs-set-char #x6AE8 ?$(Hi$(B) ; C02-H-6924
(ucs-set-char #x6AE8 ?$@H'(B) ; J78-@-4827
(ucs-set-char #x6AE8 ?$BH'(B) ; J83-B-4827
(ucs-set-char #x6AE9 ?$(I\I(B) ; C03-I-5C49
(ucs-set-char #x6AEA ?$(Hi#(B) ; C02-H-6923
(ucs-set-char #x6AEA ?$@].(B) ; J78-@-5D2E
(ucs-set-char #x6AEA ?$B].(B) ; J83-B-5D2E
(ucs-set-char #x6AEB ?$(He`(B) ; C02-H-6560
(ucs-set-char #x6AEC ?$(DEW(B) ; J90-D-4557
(ucs-set-char #x6AEC ?$(Gys(B) ; C01-G-7973
(ucs-set-char #x6AED ?$(IWu(B) ; C03-I-5775
(ucs-set-char #x6AEE ?$(Hi'(B) ; C02-H-6927
(ucs-set-char #x6AEF ?$(Hi((B) ; C02-H-6928
(ucs-set-char #x6AF0 ?$(DEX(B) ; J90-D-4558
(ucs-set-char #x6AF0 ?$(Hi"(B) ; C02-H-6922
(ucs-set-char #x6AF1 ?$(DEY(B) ; J90-D-4559
(ucs-set-char #x6AF1 ?$(Hi&(B) ; C02-H-6926
(ucs-set-char #x6AF2 ?$(DEZ(B) ; J90-D-455A
(ucs-set-char #x6AF2 ?$(JcP(B) ; C04-J-6350
(ucs-set-char #x6AF3 ?$(Hi!(B) ; C02-H-6921
(ucs-set-char #x6AF4 ?$(I\G(B) ; C03-I-5C47
(ucs-set-char #x6AF6 ?$(CzK(B) ; KS0-C-7A4B
(ucs-set-char #x6AF6 ?$(JcN(B) ; C04-J-634E
(ucs-set-char #x6AF8 ?$(Hk_(B) ; C02-H-6B5F
(ucs-set-char #x6AF9 ?$(Hi%(B) ; C02-H-6925
(ucs-set-char #x6AFA ?$(Gzr(B) ; C01-G-7A72
(ucs-set-char #x6AFA ?$@]2(B) ; J78-@-5D32
(ucs-set-char #x6AFA ?$B]2(B) ; J83-B-5D32
(ucs-set-char #x6AFB ?$(Ce!(B) ; KS0-C-6521
(ucs-set-char #x6AFB ?$(Gzp(B) ; C01-G-7A70
(ucs-set-char #x6AFB ?$@]/(B) ; J78-@-5D2F
(ucs-set-char #x6AFB ?$B]/(B) ; J83-B-5D2F
(ucs-set-char #x6AFC ?$(DE[(B) ; J90-D-455B
(ucs-set-char #x6AFC ?$(Hk](B) ; C02-H-6B5D
(ucs-set-char #x6AFD ?$(DE\(B) ; J90-D-455C
(ucs-set-char #x6AFD ?$(I^5(B) ; C03-I-5E35
(ucs-set-char #x6AFE ?$(I^4(B) ; C03-I-5E34
(ucs-set-char #x6AFF ?$(I^3(B) ; C03-I-5E33
(ucs-set-char #x6B00 ?$(Hk`(B) ; C02-H-6B60
(ucs-set-char #x6B01 ?$(I^7(B) ; C03-I-5E37
(ucs-set-char #x6B02 ?$(DE](B) ; J90-D-455D
(ucs-set-char #x6B02 ?$(Hk\(B) ; C02-H-6B5C
(ucs-set-char #x6B03 ?$(DE^(B) ; J90-D-455E
(ucs-set-char #x6B03 ?$(Hk^(B) ; C02-H-6B5E
(ucs-set-char #x6B04 ?$(CU1(B) ; KS0-C-5531
(ucs-set-char #x6B04 ?$(Gzq(B) ; C01-G-7A71
(ucs-set-char #x6B04 ?$@Ms(B) ; J78-@-4D73
(ucs-set-char #x6B04 ?$BMs(B) ; J83-B-4D73
(ucs-set-char #x6B05 ?$@]0(B) ; J78-@-5D30
(ucs-set-char #x6B05 ?$B]0(B) ; J83-B-5D30
(ucs-set-char #x6B06 ?$(DE_(B) ; J90-D-455F
(ucs-set-char #x6B06 ?$(I_O(B) ; C03-I-5F4F
(ucs-set-char #x6B07 ?$(DE`(B) ; J90-D-4560
(ucs-set-char #x6B07 ?$(I_N(B) ; C03-I-5F4E
(ucs-set-char #x6B08 ?$(HmS(B) ; C02-H-6D53
(ucs-set-char #x6B09 ?$(DEa(B) ; J90-D-4561
(ucs-set-char #x6B09 ?$(HmT(B) ; C02-H-6D54
(ucs-set-char #x6B0A ?$(COm(B) ; KS0-C-4F6D
(ucs-set-char #x6B0A ?$(G{b(B) ; C01-G-7B62
(ucs-set-char #x6B0A ?$@\^(B) ; J78-@-5C5E
(ucs-set-char #x6B0A ?$B\^(B) ; J83-B-5C5E
(ucs-set-char #x6B0B ?$(HmR(B) ; C02-H-6D52
(ucs-set-char #x6B0C ?$(Cmk(B) ; KS0-C-6D6B
(ucs-set-char #x6B0F ?$(DEb(B) ; J90-D-4562
(ucs-set-char #x6B0F ?$(Ho1(B) ; C02-H-6F31
(ucs-set-char #x6B10 ?$(DEc(B) ; J90-D-4563
(ucs-set-char #x6B10 ?$(G|;(B) ; C01-G-7C3B
(ucs-set-char #x6B11 ?$(DEd(B) ; J90-D-4564
(ucs-set-char #x6B11 ?$(Ho/(B) ; C02-H-6F2F
(ucs-set-char #x6B12 ?$(CU2(B) ; KS0-C-5532
(ucs-set-char #x6B12 ?$(Ho0(B) ; C02-H-6F30
(ucs-set-char #x6B12 ?$@]3(B) ; J78-@-5D33
(ucs-set-char #x6B12 ?$B]3(B) ; J83-B-5D33
(ucs-set-char #x6B13 ?$(Hp:(B) ; C02-H-703A
(ucs-set-char #x6B14 ?$(I`t(B) ; C03-I-6074
(ucs-set-char #x6B16 ?$(CU<(B) ; KS0-C-553C
(ucs-set-char #x6B16 ?$(G}#(B) ; C01-G-7D23
(ucs-set-char #x6B16 ?$@]4(B) ; J78-@-5D34
(ucs-set-char #x6B16 ?$B]4(B) ; J83-B-5D34
(ucs-set-char #x6B17 ?$(DEe(B) ; J90-D-4565
(ucs-set-char #x6B17 ?$(Hq#(B) ; C02-H-7123
(ucs-set-char #x6B18 ?$(Hq!(B) ; C02-H-7121
(ucs-set-char #x6B19 ?$(Hq"(B) ; C02-H-7122
(ucs-set-char #x6B1A ?$(Hq$(B) ; C02-H-7124
(ucs-set-char #x6B1B ?$(DEf(B) ; J90-D-4566
(ucs-set-char #x6B1B ?$(Ia@(B) ; C03-I-6140
(ucs-set-char #x6B1C ?$(Iae(B) ; C03-I-6165
(ucs-set-char #x6B1D ?$(IaA(B) ; C03-I-6141
(ucs-set-char #x6B1D ?$@15(B) ; J78-@-3135
(ucs-set-char #x6B1D ?$B15(B) ; J83-B-3135
(ucs-set-char #x6B1E ?$(DEg(B) ; J90-D-4567
(ucs-set-char #x6B1E ?$(Hr+(B) ; C02-H-722B
(ucs-set-char #x6B1F ?$@]6(B) ; J78-@-5D36
(ucs-set-char #x6B1F ?$B]6(B) ; J83-B-5D36
(ucs-set-char #x6B20 ?$(C}b(B) ; KS0-C-7D62
(ucs-set-char #x6B20 ?$(GEN(B) ; C01-G-454E
(ucs-set-char #x6B20 ?$@7g(B) ; J78-@-3767
(ucs-set-char #x6B20 ?$AG7(B) ; GB0-A-4737
(ucs-set-char #x6B20 ?$B7g(B) ; J83-B-3767
(ucs-set-char #x6B21 ?$(Cs-(B) ; KS0-C-732D
(ucs-set-char #x6B21 ?$(GH9(B) ; C01-G-4839
(ucs-set-char #x6B21 ?$(L%#(B) ; C06-L-2523
(ucs-set-char #x6B21 ?$@<!(B) ; J78-@-3C21
(ucs-set-char #x6B21 ?$A4N(B) ; GB0-A-344E
(ucs-set-char #x6B21 ?$B<!(B) ; J83-B-3C21
(ucs-set-char #x6B22 ?$(I#y(B) ; C03-I-2379
(ucs-set-char #x6B22 ?$A;6(B) ; GB0-A-3B36
(ucs-set-char #x6B23 ?$(C}[(B) ; KS0-C-7D5B
(ucs-set-char #x6B23 ?$(GN<(B) ; C01-G-4E3C
(ucs-set-char #x6B23 ?$@6U(B) ; J78-@-3655
(ucs-set-char #x6B23 ?$AP@(B) ; GB0-A-5040
(ucs-set-char #x6B23 ?$B6U(B) ; J83-B-3655
(ucs-set-char #x6B24 ?$(DEh(B) ; J90-D-4568
(ucs-set-char #x6B24 ?$(J&q(B) ; C04-J-2671
(ucs-set-char #x6B24 ?$Al#(B) ; GB0-A-6C23
(ucs-set-char #x6B25 ?$(H'J(B) ; C02-H-274A
(ucs-set-char #x6B26 ?$(I)S(B) ; C03-I-2953
(ucs-set-char #x6B27 ?$(I)T(B) ; C03-I-2954
(ucs-set-char #x6B27 ?$@2$(B) ; J78-@-3224
(ucs-set-char #x6B27 ?$AE7(B) ; GB0-A-4537
(ucs-set-char #x6B27 ?$B2$(B) ; J83-B-3224
(ucs-set-char #x6B28 ?$(DEi(B) ; J90-D-4569
(ucs-set-char #x6B28 ?$(H+F(B) ; C02-H-2B46
(ucs-set-char #x6B29 ?$(J)r(B) ; C04-J-2972
(ucs-set-char #x6B2A ?$(I-<(B) ; C03-I-2D3C
(ucs-set-char #x6B2B ?$(DEj(B) ; J90-D-456A
(ucs-set-char #x6B2B ?$(I1f(B) ; C03-I-3166
(ucs-set-char #x6B2C ?$(DEk(B) ; J90-D-456B
(ucs-set-char #x6B2C ?$(H/w(B) ; C02-H-2F77
(ucs-set-char #x6B2D ?$(H/y(B) ; C02-H-2F79
(ucs-set-char #x6B2E ?$(I1e(B) ; C03-I-3165
(ucs-set-char #x6B2F ?$(DEl(B) ; J90-D-456C
(ucs-set-char #x6B2F ?$(H/x(B) ; C02-H-2F78
(ucs-set-char #x6B30 ?$(I1g(B) ; C03-I-3167
(ucs-set-char #x6B31 ?$(H/z(B) ; C02-H-2F7A
(ucs-set-char #x6B32 ?$(Ci0(B) ; KS0-C-6930
(ucs-set-char #x6B32 ?$(G[C(B) ; C01-G-5B43
(ucs-set-char #x6B32 ?$@M_(B) ; J78-@-4D5F
(ucs-set-char #x6B32 ?$AS{(B) ; GB0-A-537B
(ucs-set-char #x6B32 ?$BM_(B) ; J83-B-4D5F
(ucs-set-char #x6B33 ?$(H6;(B) ; C02-H-363B
(ucs-set-char #x6B34 ?$(H/{(B) ; C02-H-2F7B
(ucs-set-char #x6B35 ?$(DEm(B) ; J90-D-456D
(ucs-set-char #x6B35 ?$(I6b(B) ; C03-I-3662
(ucs-set-char #x6B36 ?$(DEn(B) ; J90-D-456E
(ucs-set-char #x6B36 ?$(H6:(B) ; C02-H-363A
(ucs-set-char #x6B37 ?$(H6<(B) ; C02-H-363C
(ucs-set-char #x6B37 ?$@]8(B) ; J78-@-5D38
(ucs-set-char #x6B37 ?$Al$(B) ; GB0-A-6C24
(ucs-set-char #x6B37 ?$B]8(B) ; J83-B-5D38
(ucs-set-char #x6B38 ?$(H6=(B) ; C02-H-363D
(ucs-set-char #x6B38 ?$@]7(B) ; J78-@-5D37
(ucs-set-char #x6B38 ?$B]7(B) ; J83-B-5D37
(ucs-set-char #x6B39 ?$(H<}(B) ; C02-H-3C7D
(ucs-set-char #x6B39 ?$@]:(B) ; J78-@-5D3A
(ucs-set-char #x6B39 ?$Al%(B) ; GB0-A-6C25
(ucs-set-char #x6B39 ?$B]:(B) ; J83-B-5D3A
(ucs-set-char #x6B3A ?$(CQ'(B) ; KS0-C-5127
(ucs-set-char #x6B3A ?$(G`"(B) ; C01-G-6022
(ucs-set-char #x6B3A ?$@5=(B) ; J78-@-353D
(ucs-set-char #x6B3A ?$AF[(B) ; GB0-A-465B
(ucs-set-char #x6B3A ?$B5=(B) ; J83-B-353D
(ucs-set-char #x6B3B ?$(DEo(B) ; J90-D-456F
(ucs-set-char #x6B3B ?$(H<~(B) ; C02-H-3C7E
(ucs-set-char #x6B3C ?$(H="(B) ; C02-H-3D22
(ucs-set-char #x6B3D ?$(C}c(B) ; KS0-C-7D63
(ucs-set-char #x6B3D ?$(G`#(B) ; C01-G-6023
(ucs-set-char #x6B3D ?$@6V(B) ; J78-@-3656
(ucs-set-char #x6B3D ?$B6V(B) ; J83-B-3656
(ucs-set-char #x6B3E ?$(CN3(B) ; KS0-C-4E33
(ucs-set-char #x6B3E ?$(G`!(B) ; C01-G-6021
(ucs-set-char #x6B3E ?$@4>(B) ; J78-@-343E
(ucs-set-char #x6B3E ?$A?n(B) ; GB0-A-3F6E
(ucs-set-char #x6B3E ?$B4>(B) ; J83-B-343E
(ucs-set-char #x6B3F ?$(DEp(B) ; J90-D-4570
(ucs-set-char #x6B3F ?$(H=!(B) ; C02-H-3D21
(ucs-set-char #x6B40 ?$(IA}(B) ; C03-I-417D
(ucs-set-char #x6B41 ?$(HD"(B) ; C02-H-4422
(ucs-set-char #x6B42 ?$(HC~(B) ; C02-H-437E
(ucs-set-char #x6B43 ?$(HC}(B) ; C02-H-437D
(ucs-set-char #x6B43 ?$@]=(B) ; J78-@-5D3D
(ucs-set-char #x6B43 ?$Al&(B) ; GB0-A-6C26
(ucs-set-char #x6B43 ?$B]=(B) ; J83-B-5D3D
(ucs-set-char #x6B44 ?$(IA|(B) ; C03-I-417C
(ucs-set-char #x6B45 ?$(HC|(B) ; C02-H-437C
(ucs-set-char #x6B46 ?$(C}d(B) ; KS0-C-7D64
(ucs-set-char #x6B46 ?$(DEq(B) ; J90-D-4571
(ucs-set-char #x6B46 ?$(HC{(B) ; C02-H-437B
(ucs-set-char #x6B46 ?$Al'(B) ; GB0-A-6C27
(ucs-set-char #x6B47 ?$(CzN(B) ; KS0-C-7A4E
(ucs-set-char #x6B47 ?$(GdX(B) ; C01-G-6458
(ucs-set-char #x6B47 ?$@]<(B) ; J78-@-5D3C
(ucs-set-char #x6B47 ?$AP*(B) ; GB0-A-502A
(ucs-set-char #x6B47 ?$B]<(B) ; J83-B-5D3C
(ucs-set-char #x6B48 ?$(HD!(B) ; C02-H-4421
(ucs-set-char #x6B49 ?$(Gi9(B) ; C01-G-6939
(ucs-set-char #x6B49 ?$@]>(B) ; J78-@-5D3E
(ucs-set-char #x6B49 ?$AG8(B) ; GB0-A-4738
(ucs-set-char #x6B49 ?$B]>(B) ; J83-B-5D3E
(ucs-set-char #x6B4A ?$(DEr(B) ; J90-D-4572
(ucs-set-char #x6B4A ?$(HK+(B) ; C02-H-4B2B
(ucs-set-char #x6B4B ?$(HK-(B) ; C02-H-4B2D
(ucs-set-char #x6B4C ?$(CJ0(B) ; KS0-C-4A30
(ucs-set-char #x6B4C ?$(Gi:(B) ; C01-G-693A
(ucs-set-char #x6B4C ?$@2N(B) ; J78-@-324E
(ucs-set-char #x6B4C ?$A8h(B) ; GB0-A-3868
(ucs-set-char #x6B4C ?$B2N(B) ; J83-B-324E
(ucs-set-char #x6B4D ?$(DEs(B) ; J90-D-4573
(ucs-set-char #x6B4D ?$(HK,(B) ; C02-H-4B2C
(ucs-set-char #x6B4E ?$(Cw'(B) ; KS0-C-7727
(ucs-set-char #x6B4E ?$(GmE(B) ; C01-G-6D45
(ucs-set-char #x6B4E ?$@C7(B) ; J78-@-4337
(ucs-set-char #x6B4E ?$BC7(B) ; J83-B-4337
(ucs-set-char #x6B4F ?$(ILf(B) ; C03-I-4C66
(ucs-set-char #x6B50 ?$(CO1(B) ; KS0-C-4F31
(ucs-set-char #x6B50 ?$(GmD(B) ; C01-G-6D44
(ucs-set-char #x6B50 ?$@]?(B) ; J78-@-5D3F
(ucs-set-char #x6B50 ?$B]?(B) ; J83-B-5D3F
(ucs-set-char #x6B51 ?$(HQ9(B) ; C02-H-5139
(ucs-set-char #x6B52 ?$(DEt(B) ; J90-D-4574
(ucs-set-char #x6B52 ?$(ILe(B) ; C03-I-4C65
(ucs-set-char #x6B53 ?$(ILg(B) ; C03-I-4C67
(ucs-set-char #x6B53 ?$@4?(B) ; J78-@-343F
(ucs-set-char #x6B53 ?$B4?(B) ; J83-B-343F
(ucs-set-char #x6B54 ?$(HWj(B) ; C02-H-576A
(ucs-set-char #x6B54 ?$@]A(B) ; J78-@-5D41
(ucs-set-char #x6B54 ?$B]A(B) ; J83-B-5D41
(ucs-set-char #x6B55 ?$(HWi(B) ; C02-H-5769
(ucs-set-char #x6B56 ?$(DEu(B) ; J90-D-4575
(ucs-set-char #x6B56 ?$(HWk(B) ; C02-H-576B
(ucs-set-char #x6B57 ?$(IQF(B) ; C03-I-5146
(ucs-set-char #x6B58 ?$(DEv(B) ; J90-D-4576
(ucs-set-char #x6B58 ?$(IQE(B) ; C03-I-5145
(ucs-set-char #x6B59 ?$(Gq$(B) ; C01-G-7124
(ucs-set-char #x6B59 ?$@]@(B) ; J78-@-5D40
(ucs-set-char #x6B59 ?$Al((B) ; GB0-A-6C28
(ucs-set-char #x6B59 ?$B]@(B) ; J83-B-5D40
(ucs-set-char #x6B5B ?$(H]7(B) ; C02-H-5D37
(ucs-set-char #x6B5B ?$@]B(B) ; J78-@-5D42
(ucs-set-char #x6B5B ?$B]B(B) ; J83-B-5D42
(ucs-set-char #x6B5C ?$(Gs|(B) ; C01-G-737C
(ucs-set-char #x6B5D ?$(DEw(B) ; J90-D-4577
(ucs-set-char #x6B5D ?$(IU+(B) ; C03-I-552B
(ucs-set-char #x6B5E ?$(Hat(B) ; C02-H-6174
(ucs-set-char #x6B5F ?$(Cf"(B) ; KS0-C-6622
(ucs-set-char #x6B5F ?$(GvV(B) ; C01-G-7656
(ucs-set-char #x6B5F ?$@]C(B) ; J78-@-5D43
(ucs-set-char #x6B5F ?$B]C(B) ; J83-B-5D43
(ucs-set-char #x6B60 ?$(DEx(B) ; J90-D-4578
(ucs-set-char #x6B60 ?$(Hed(B) ; C02-H-6564
(ucs-set-char #x6B61 ?$(C|6(B) ; KS0-C-7C36
(ucs-set-char #x6B61 ?$(G{c(B) ; C01-G-7B63
(ucs-set-char #x6B61 ?$@]D(B) ; J78-@-5D44
(ucs-set-char #x6B61 ?$B]D(B) ; J83-B-5D44
(ucs-set-char #x6B62 ?$(Cr-(B) ; KS0-C-722D
(ucs-set-char #x6B62 ?$(GEO(B) ; C01-G-454F
(ucs-set-char #x6B62 ?$@;_(B) ; J78-@-3B5F
(ucs-set-char #x6B62 ?$AV9(B) ; GB0-A-5639
(ucs-set-char #x6B62 ?$B;_(B) ; J83-B-3B5F
(ucs-set-char #x6B63 ?$(Coa(B) ; KS0-C-6F61
(ucs-set-char #x6B63 ?$(GF_(B) ; C01-G-465F
(ucs-set-char #x6B63 ?$@@5(B) ; J78-@-4035
(ucs-set-char #x6B63 ?$AU}(B) ; GB0-A-557D
(ucs-set-char #x6B63 ?$B@5(B) ; J83-B-4035
(ucs-set-char #x6B64 ?$(Cs.(B) ; KS0-C-732E
(ucs-set-char #x6B64 ?$(GH:(B) ; C01-G-483A
(ucs-set-char #x6B64 ?$@:!(B) ; J78-@-3A21
(ucs-set-char #x6B64 ?$A4K(B) ; GB0-A-344B
(ucs-set-char #x6B64 ?$B:!(B) ; J83-B-3A21
(ucs-set-char #x6B65 ?$(C\F(B) ; KS0-C-5C46
(ucs-set-char #x6B65 ?$(GJc(B) ; C01-G-4A63
(ucs-set-char #x6B65 ?$A2=(B) ; GB0-A-323D
(ucs-set-char #x6B66 ?$(CYk(B) ; KS0-C-596B
(ucs-set-char #x6B66 ?$(GN=(B) ; C01-G-4E3D
(ucs-set-char #x6B66 ?$@Ip(B) ; J78-@-4970
(ucs-set-char #x6B66 ?$ANd(B) ; GB0-A-4E64
(ucs-set-char #x6B66 ?$BIp(B) ; J83-B-4970
(ucs-set-char #x6B67 ?$(DEy(B) ; J90-D-4579
(ucs-set-char #x6B67 ?$(GN>(B) ; C01-G-4E3E
(ucs-set-char #x6B67 ?$AFg(B) ; GB0-A-4667
(ucs-set-char #x6B68 ?$(I)U(B) ; C03-I-2955
(ucs-set-char #x6B69 ?$(I)V(B) ; C03-I-2956
(ucs-set-char #x6B69 ?$@Jb(B) ; J78-@-4A62
(ucs-set-char #x6B69 ?$BJb(B) ; J83-B-4A62
(ucs-set-char #x6B6A ?$(Ch`(B) ; KS0-C-6860
(ucs-set-char #x6B6A ?$(GQq(B) ; C01-G-5171
(ucs-set-char #x6B6A ?$@OD(B) ; J78-@-4F44
(ucs-set-char #x6B6A ?$AMa(B) ; GB0-A-4D61
(ucs-set-char #x6B6A ?$BOD(B) ; J83-B-4F44
(ucs-set-char #x6B6B ?$(DEz(B) ; J90-D-457A
(ucs-set-char #x6B6B ?$(I-=(B) ; C03-I-2D3D
(ucs-set-char #x6B6C ?$(I1h(B) ; C03-I-3168
(ucs-set-char #x6B6D ?$(H/|(B) ; C02-H-2F7C
(ucs-set-char #x6B6E ?$(DE{(B) ; J90-D-457B
(ucs-set-char #x6B6E ?$(I<I(B) ; C03-I-3C49
(ucs-set-char #x6B6F ?$(I<G(B) ; C03-I-3C47
(ucs-set-char #x6B6F ?$@;u(B) ; J78-@-3B75
(ucs-set-char #x6B6F ?$B;u(B) ; J83-B-3B75
(ucs-set-char #x6B70 ?$(DE|(B) ; J90-D-457C
(ucs-set-char #x6B70 ?$(JD-(B) ; C04-J-442D
(ucs-set-char #x6B71 ?$(IA~(B) ; C03-I-417E
(ucs-set-char #x6B72 ?$(Ca((B) ; KS0-C-6128
(ucs-set-char #x6B72 ?$(GdY(B) ; C01-G-6459
(ucs-set-char #x6B73 ?$(IB!(B) ; C03-I-4221
(ucs-set-char #x6B73 ?$@:P(B) ; J78-@-3A50
(ucs-set-char #x6B73 ?$B:P(B) ; J83-B-3A50
(ucs-set-char #x6B74 ?$(IGS(B) ; C03-I-4753
(ucs-set-char #x6B74 ?$@Nr(B) ; J78-@-4E72
(ucs-set-char #x6B74 ?$BNr(B) ; J83-B-4E72
(ucs-set-char #x6B75 ?$(DE}(B) ; J90-D-457D
(ucs-set-char #x6B75 ?$(JJN(B) ; C04-J-4A4E
(ucs-set-char #x6B76 ?$(HRY(B) ; C02-H-5259
(ucs-set-char #x6B77 ?$(CUv(B) ; KS0-C-5576
(ucs-set-char #x6B77 ?$(Gq%(B) ; C01-G-7125
(ucs-set-char #x6B78 ?$(CO}(B) ; KS0-C-4F7D
(ucs-set-char #x6B78 ?$(GvW(B) ; C01-G-7657
(ucs-set-char #x6B78 ?$@]E(B) ; J78-@-5D45
(ucs-set-char #x6B78 ?$B]E(B) ; J83-B-5D45
(ucs-set-char #x6B79 ?$(GEP(B) ; C01-G-4550
(ucs-set-char #x6B79 ?$@]F(B) ; J78-@-5D46
(ucs-set-char #x6B79 ?$A4u(B) ; GB0-A-3475
(ucs-set-char #x6B79 ?$B]F(B) ; J83-B-5D46
(ucs-set-char #x6B7A ?$(I"S(B) ; C03-I-2253
(ucs-set-char #x6B7B ?$(C^](B) ; KS0-C-5E5D
(ucs-set-char #x6B7B ?$(GH;(B) ; C01-G-483B
(ucs-set-char #x6B7B ?$@;`(B) ; J78-@-3B60
(ucs-set-char #x6B7B ?$AK@(B) ; GB0-A-4B40
(ucs-set-char #x6B7B ?$B;`(B) ; J83-B-3B60
(ucs-set-char #x6B7C ?$A<_(B) ; GB0-A-3C5F
(ucs-set-char #x6B7D ?$(DE~(B) ; J90-D-457E
(ucs-set-char #x6B7D ?$(J&v(B) ; C04-J-2676
(ucs-set-char #x6B7E ?$(DF!(B) ; J90-D-4621
(ucs-set-char #x6B7E ?$(H'L(B) ; C02-H-274C
(ucs-set-char #x6B7F ?$(CYQ(B) ; KS0-C-5951
(ucs-set-char #x6B7F ?$(GN?(B) ; C01-G-4E3F
(ucs-set-char #x6B7F ?$@]G(B) ; J78-@-5D47
(ucs-set-char #x6B7F ?$B]G(B) ; J83-B-5D47
(ucs-set-char #x6B80 ?$(H'K(B) ; C02-H-274B
(ucs-set-char #x6B80 ?$@]H(B) ; J78-@-5D48
(ucs-set-char #x6B80 ?$B]H(B) ; J83-B-5D48
(ucs-set-char #x6B81 ?$(I)X(B) ; C03-I-2958
(ucs-set-char #x6B81 ?$Aib(B) ; GB0-A-6962
(ucs-set-char #x6B82 ?$(DF"(B) ; J90-D-4622
(ucs-set-char #x6B82 ?$(H+G(B) ; C02-H-2B47
(ucs-set-char #x6B82 ?$Aic(B) ; GB0-A-6963
(ucs-set-char #x6B83 ?$(Cdj(B) ; KS0-C-646A
(ucs-set-char #x6B83 ?$(GQr(B) ; C01-G-5172
(ucs-set-char #x6B83 ?$@]J(B) ; J78-@-5D4A
(ucs-set-char #x6B83 ?$AQj(B) ; GB0-A-516A
(ucs-set-char #x6B83 ?$B]J(B) ; J83-B-5D4A
(ucs-set-char #x6B84 ?$(CrO(B) ; KS0-C-724F
(ucs-set-char #x6B84 ?$(H+H(B) ; C02-H-2B48
(ucs-set-char #x6B84 ?$@]I(B) ; J78-@-5D49
(ucs-set-char #x6B84 ?$Aie(B) ; GB0-A-6965
(ucs-set-char #x6B84 ?$B]I(B) ; J83-B-5D49
(ucs-set-char #x6B85 ?$(DF#(B) ; J90-D-4623
(ucs-set-char #x6B85 ?$(K)i(B) ; C05-K-2969
(ucs-set-char #x6B86 ?$(Cw?(B) ; KS0-C-773F
(ucs-set-char #x6B86 ?$(GQs(B) ; C01-G-5173
(ucs-set-char #x6B86 ?$@KX(B) ; J78-@-4B58
(ucs-set-char #x6B86 ?$A4y(B) ; GB0-A-3479
(ucs-set-char #x6B86 ?$BKX(B) ; J83-B-4B58
(ucs-set-char #x6B87 ?$Aid(B) ; GB0-A-6964
(ucs-set-char #x6B88 ?$(H/~(B) ; C02-H-2F7E
(ucs-set-char #x6B89 ?$(Cbf(B) ; KS0-C-6266
(ucs-set-char #x6B89 ?$(GV2(B) ; C01-G-5632
(ucs-set-char #x6B89 ?$@=^(B) ; J78-@-3D5E
(ucs-set-char #x6B89 ?$AQ3(B) ; GB0-A-5133
(ucs-set-char #x6B89 ?$B=^(B) ; J83-B-3D5E
(ucs-set-char #x6B8A ?$(Cb((B) ; KS0-C-6228
(ucs-set-char #x6B8A ?$(GV1(B) ; C01-G-5631
(ucs-set-char #x6B8A ?$@<l(B) ; J78-@-3C6C
(ucs-set-char #x6B8A ?$AJb(B) ; GB0-A-4A62
(ucs-set-char #x6B8A ?$B<l(B) ; J83-B-3C6C
(ucs-set-char #x6B8B ?$(I1j(B) ; C03-I-316A
(ucs-set-char #x6B8B ?$@;D(B) ; J78-@-3B44
(ucs-set-char #x6B8B ?$A2P(B) ; GB0-A-3250
(ucs-set-char #x6B8B ?$B;D(B) ; J83-B-3B44
(ucs-set-char #x6B8C ?$(H6B(B) ; C02-H-3642
(ucs-set-char #x6B8D ?$(H6@(B) ; C02-H-3640
(ucs-set-char #x6B8D ?$@]K(B) ; J78-@-5D4B
(ucs-set-char #x6B8D ?$Aih(B) ; GB0-A-6968
(ucs-set-char #x6B8D ?$B]K(B) ; J83-B-5D4B
(ucs-set-char #x6B8E ?$(H6A(B) ; C02-H-3641
(ucs-set-char #x6B8F ?$(H6?(B) ; C02-H-363F
(ucs-set-char #x6B90 ?$(I6d(B) ; C03-I-3664
(ucs-set-char #x6B91 ?$(H6>(B) ; C02-H-363E
(ucs-set-char #x6B92 ?$Aif(B) ; GB0-A-6966
(ucs-set-char #x6B93 ?$Aig(B) ; GB0-A-6967
(ucs-set-char #x6B94 ?$(H=#(B) ; C02-H-3D23
(ucs-set-char #x6B95 ?$(H=&(B) ; C02-H-3D26
(ucs-set-char #x6B95 ?$@]M(B) ; J78-@-5D4D
(ucs-set-char #x6B95 ?$B]M(B) ; J83-B-5D4D
(ucs-set-char #x6B96 ?$(CcV(B) ; KS0-C-6356
(ucs-set-char #x6B96 ?$(G`%(B) ; C01-G-6025
(ucs-set-char #x6B96 ?$@?#(B) ; J78-@-3F23
(ucs-set-char #x6B96 ?$AV3(B) ; GB0-A-5633
(ucs-set-char #x6B96 ?$B?#(B) ; J83-B-3F23
(ucs-set-char #x6B97 ?$(DF$(B) ; J90-D-4624
(ucs-set-char #x6B97 ?$(H=$(B) ; C02-H-3D24
(ucs-set-char #x6B98 ?$(CmQ(B) ; KS0-C-6D51
(ucs-set-char #x6B98 ?$(G`$(B) ; C01-G-6024
(ucs-set-char #x6B98 ?$@]L(B) ; J78-@-5D4C
(ucs-set-char #x6B98 ?$B]L(B) ; J83-B-5D4C
(ucs-set-char #x6B99 ?$(H=%(B) ; C02-H-3D25
(ucs-set-char #x6B9A ?$Aii(B) ; GB0-A-6969
(ucs-set-char #x6B9B ?$(DF%(B) ; J90-D-4625
(ucs-set-char #x6B9B ?$(HD#(B) ; C02-H-4423
(ucs-set-char #x6B9B ?$Aij(B) ; GB0-A-696A
(ucs-set-char #x6B9C ?$(IB"(B) ; C03-I-4222
(ucs-set-char #x6B9D ?$(JD1(B) ; C04-J-4431
(ucs-set-char #x6B9E ?$(Ciy(B) ; KS0-C-6979
(ucs-set-char #x6B9E ?$(HK.(B) ; C02-H-4B2E
(ucs-set-char #x6B9E ?$@]N(B) ; J78-@-5D4E
(ucs-set-char #x6B9E ?$B]N(B) ; J83-B-5D4E
(ucs-set-char #x6B9F ?$(DF&(B) ; J90-D-4626
(ucs-set-char #x6B9F ?$(HK/(B) ; C02-H-4B2F
(ucs-set-char #x6BA0 ?$(DF'(B) ; J90-D-4627
(ucs-set-char #x6BA0 ?$(HK0(B) ; C02-H-4B30
(ucs-set-char #x6BA1 ?$(IGT(B) ; C03-I-4754
(ucs-set-char #x6BA1 ?$Aik(B) ; GB0-A-696B
(ucs-set-char #x6BA2 ?$(DF((B) ; J90-D-4628
(ucs-set-char #x6BA2 ?$(HQ<(B) ; C02-H-513C
(ucs-set-char #x6BA3 ?$(DF)(B) ; J90-D-4629
(ucs-set-char #x6BA3 ?$(HQ;(B) ; C02-H-513B
(ucs-set-char #x6BA4 ?$(GmF(B) ; C01-G-6D46
(ucs-set-char #x6BA4 ?$@]O(B) ; J78-@-5D4F
(ucs-set-char #x6BA4 ?$B]O(B) ; J83-B-5D4F
(ucs-set-char #x6BA5 ?$(HQ:(B) ; C02-H-513A
(ucs-set-char #x6BA6 ?$(HQ=(B) ; C02-H-513D
(ucs-set-char #x6BA7 ?$(HWl(B) ; C02-H-576C
(ucs-set-char #x6BA8 ?$(DF*(B) ; J90-D-462A
(ucs-set-char #x6BA8 ?$(JPm(B) ; C04-J-506D
(ucs-set-char #x6BA9 ?$(DF+(B) ; J90-D-462B
(ucs-set-char #x6BA9 ?$(K[r(B) ; C05-K-5B72
(ucs-set-char #x6BAA ?$(HWm(B) ; C02-H-576D
(ucs-set-char #x6BAA ?$@]P(B) ; J78-@-5D50
(ucs-set-char #x6BAA ?$Ail(B) ; GB0-A-696C
(ucs-set-char #x6BAA ?$B]P(B) ; J83-B-5D50
(ucs-set-char #x6BAB ?$(HWn(B) ; C02-H-576E
(ucs-set-char #x6BAB ?$@]Q(B) ; J78-@-5D51
(ucs-set-char #x6BAB ?$B]Q(B) ; J83-B-5D51
(ucs-set-char #x6BAC ?$(DF,(B) ; J90-D-462C
(ucs-set-char #x6BAC ?$(JVR(B) ; C04-J-5652
(ucs-set-char #x6BAD ?$(DF-(B) ; J90-D-462D
(ucs-set-char #x6BAD ?$(H]8(B) ; C02-H-5D38
(ucs-set-char #x6BAE ?$(CV1(B) ; KS0-C-5631
(ucs-set-char #x6BAE ?$(DF.(B) ; J90-D-462E
(ucs-set-char #x6BAE ?$(Gs}(B) ; C01-G-737D
(ucs-set-char #x6BAF ?$(C^2(B) ; KS0-C-5E32
(ucs-set-char #x6BAF ?$(GvX(B) ; C01-G-7658
(ucs-set-char #x6BAF ?$@]R(B) ; J78-@-5D52
(ucs-set-char #x6BAF ?$B]R(B) ; J83-B-5D52
(ucs-set-char #x6BB0 ?$(DF/(B) ; J90-D-462F
(ucs-set-char #x6BB0 ?$(Hee(B) ; C02-H-6565
(ucs-set-char #x6BB1 ?$@]T(B) ; J78-@-5D54
(ucs-set-char #x6BB1 ?$B]T(B) ; J83-B-5D54
(ucs-set-char #x6BB2 ?$(C`h(B) ; KS0-C-6068
(ucs-set-char #x6BB2 ?$(Gzs(B) ; C01-G-7A73
(ucs-set-char #x6BB2 ?$@]S(B) ; J78-@-5D53
(ucs-set-char #x6BB2 ?$B]S(B) ; J83-B-5D53
(ucs-set-char #x6BB3 ?$(H!?(B) ; C02-H-213F
(ucs-set-char #x6BB3 ?$@]U(B) ; J78-@-5D55
(ucs-set-char #x6BB3 ?$Al/(B) ; GB0-A-6C2F
(ucs-set-char #x6BB3 ?$B]U(B) ; J83-B-5D55
(ucs-set-char #x6BB4 ?$(I)Y(B) ; C03-I-2959
(ucs-set-char #x6BB4 ?$@2%(B) ; J78-@-3225
(ucs-set-char #x6BB4 ?$AE9(B) ; GB0-A-4539
(ucs-set-char #x6BB4 ?$B2%(B) ; J83-B-3225
(ucs-set-char #x6BB5 ?$(CS+(B) ; KS0-C-532B
(ucs-set-char #x6BB5 ?$(GQt(B) ; C01-G-5174
(ucs-set-char #x6BB5 ?$@CJ(B) ; J78-@-434A
(ucs-set-char #x6BB5 ?$A6N(B) ; GB0-A-364E
(ucs-set-char #x6BB5 ?$BCJ(B) ; J83-B-434A
(ucs-set-char #x6BB6 ?$(H+I(B) ; C02-H-2B49
(ucs-set-char #x6BB7 ?$(Ck\(B) ; KS0-C-6B5C
(ucs-set-char #x6BB7 ?$(GV3(B) ; C01-G-5633
(ucs-set-char #x6BB7 ?$@]V(B) ; J78-@-5D56
(ucs-set-char #x6BB7 ?$ARs(B) ; GB0-A-5273
(ucs-set-char #x6BB7 ?$B]V(B) ; J83-B-5D56
(ucs-set-char #x6BB8 ?$(DF0(B) ; J90-D-4630
(ucs-set-char #x6BB8 ?$(J2N(B) ; C04-J-324E
(ucs-set-char #x6BB9 ?$(DF1(B) ; J90-D-4631
(ucs-set-char #x6BB9 ?$(J2P(B) ; C04-J-3250
(ucs-set-char #x6BBA ?$(C_/(B) ; KS0-C-5F2F
(ucs-set-char #x6BBA ?$(G[D(B) ; C01-G-5B44
(ucs-set-char #x6BBA ?$(J-e(B) ; C04-J-2D65
(ucs-set-char #x6BBA ?$@;&(B) ; J78-@-3B26
(ucs-set-char #x6BBA ?$B;&(B) ; J83-B-3B26
(ucs-set-char #x6BBB ?$(I6e(B) ; C03-I-3665
(ucs-set-char #x6BBB ?$@3L(B) ; J78-@-334C
(ucs-set-char #x6BBB ?$B3L(B) ; J83-B-334C
(ucs-set-char #x6BBC ?$(CJC(B) ; KS0-C-4A43
(ucs-set-char #x6BBC ?$(G`&(B) ; C01-G-6026
(ucs-set-char #x6BBC ?$@]W(B) ; J78-@-5D57
(ucs-set-char #x6BBC ?$B]W(B) ; J83-B-5D57
(ucs-set-char #x6BBD ?$(DF2(B) ; J90-D-4632
(ucs-set-char #x6BBD ?$(H='(B) ; C02-H-3D27
(ucs-set-char #x6BBE ?$(DF3(B) ; J90-D-4633
(ucs-set-char #x6BBE ?$(I<K(B) ; C03-I-3C4B
(ucs-set-char #x6BBF ?$(Cn|(B) ; KS0-C-6E7C
(ucs-set-char #x6BBF ?$(Gd[(B) ; C01-G-645B
(ucs-set-char #x6BBF ?$@EB(B) ; J78-@-4542
(ucs-set-char #x6BBF ?$A5n(B) ; GB0-A-356E
(ucs-set-char #x6BBF ?$BEB(B) ; J83-B-4542
(ucs-set-char #x6BC0 ?$(GdZ(B) ; C01-G-645A
(ucs-set-char #x6BC0 ?$@TL(B) ; J78-@-544C
(ucs-set-char #x6BC0 ?$BTL(B) ; J83-B-544C
(ucs-set-char #x6BC1 ?$(C}C(B) ; KS0-C-7D43
(ucs-set-char #x6BC1 ?$(IB&(B) ; C03-I-4226
(ucs-set-char #x6BC1 ?$A;Y(B) ; GB0-A-3B59
(ucs-set-char #x6BC2 ?$Al1(B) ; GB0-A-6C31
(ucs-set-char #x6BC3 ?$(DF4(B) ; J90-D-4634
(ucs-set-char #x6BC3 ?$(HK1(B) ; C02-H-4B31
(ucs-set-char #x6BC4 ?$(DF5(B) ; J90-D-4635
(ucs-set-char #x6BC4 ?$(HK2(B) ; C02-H-4B32
(ucs-set-char #x6BC5 ?$(Ckv(B) ; KS0-C-6B76
(ucs-set-char #x6BC5 ?$(GmG(B) ; C01-G-6D47
(ucs-set-char #x6BC5 ?$@5#(B) ; J78-@-3523
(ucs-set-char #x6BC5 ?$ARc(B) ; GB0-A-5263
(ucs-set-char #x6BC5 ?$B5#(B) ; J83-B-3523
(ucs-set-char #x6BC6 ?$(CO2(B) ; KS0-C-4F32
(ucs-set-char #x6BC6 ?$(GmH(B) ; C01-G-6D48
(ucs-set-char #x6BC6 ?$@]X(B) ; J78-@-5D58
(ucs-set-char #x6BC6 ?$B]X(B) ; J83-B-5D58
(ucs-set-char #x6BC7 ?$(HWp(B) ; C02-H-5770
(ucs-set-char #x6BC8 ?$(HWo(B) ; C02-H-576F
(ucs-set-char #x6BC9 ?$(DF6(B) ; J90-D-4636
(ucs-set-char #x6BC9 ?$(Hau(B) ; C02-H-6175
(ucs-set-char #x6BCA ?$(Ho2(B) ; C02-H-6F32
(ucs-set-char #x6BCB ?$(CYl(B) ; KS0-C-596C
(ucs-set-char #x6BCB ?$(GEQ(B) ; C01-G-4551
(ucs-set-char #x6BCB ?$@]Y(B) ; J78-@-5D59
(ucs-set-char #x6BCB ?$ANc(B) ; GB0-A-4E63
(ucs-set-char #x6BCB ?$B]Y(B) ; J83-B-5D59
(ucs-set-char #x6BCC ?$(DF7(B) ; J90-D-4637
(ucs-set-char #x6BCC ?$(H!@(B) ; C02-H-2140
(ucs-set-char #x6BCD ?$(CY=(B) ; KS0-C-593D
(ucs-set-char #x6BCD ?$(GF`(B) ; C01-G-4660
(ucs-set-char #x6BCD ?$@Jl(B) ; J78-@-4A6C
(ucs-set-char #x6BCD ?$AD8(B) ; GB0-A-4438
(ucs-set-char #x6BCD ?$BJl(B) ; J83-B-4A6C
(ucs-set-char #x6BCE ?$(I#z(B) ; C03-I-237A
(ucs-set-char #x6BCE ?$@Kh(B) ; J78-@-4B68
(ucs-set-char #x6BCE ?$BKh(B) ; J83-B-4B68
(ucs-set-char #x6BCF ?$(CX_(B) ; KS0-C-585F
(ucs-set-char #x6BCF ?$(GJd(B) ; C01-G-4A64
(ucs-set-char #x6BCF ?$AC?(B) ; GB0-A-433F
(ucs-set-char #x6BD0 ?$(H$H(B) ; C02-H-2448
(ucs-set-char #x6BD1 ?$(I)Z(B) ; C03-I-295A
(ucs-set-char #x6BD2 ?$(CT8(B) ; KS0-C-5438
(ucs-set-char #x6BD2 ?$(GQu(B) ; C01-G-5175
(ucs-set-char #x6BD2 ?$@FG(B) ; J78-@-4647
(ucs-set-char #x6BD2 ?$A6>(B) ; GB0-A-363E
(ucs-set-char #x6BD2 ?$BFG(B) ; J83-B-4647
(ucs-set-char #x6BD3 ?$(Ck>(B) ; KS0-C-6B3E
(ucs-set-char #x6BD3 ?$(Gd\(B) ; C01-G-645C
(ucs-set-char #x6BD3 ?$@]Z(B) ; J78-@-5D5A
(ucs-set-char #x6BD3 ?$AX9(B) ; GB0-A-5839
(ucs-set-char #x6BD3 ?$B]Z(B) ; J83-B-5D5A
(ucs-set-char #x6BD4 ?$(C]o(B) ; KS0-C-5D6F
(ucs-set-char #x6BD4 ?$(GER(B) ; C01-G-4552
(ucs-set-char #x6BD4 ?$@Hf(B) ; J78-@-4866
(ucs-set-char #x6BD4 ?$A1H(B) ; GB0-A-3148
(ucs-set-char #x6BD4 ?$BHf(B) ; J83-B-4866
(ucs-set-char #x6BD5 ?$A1O(B) ; GB0-A-314F
(ucs-set-char #x6BD6 ?$(C]p(B) ; KS0-C-5D70
(ucs-set-char #x6BD6 ?$(DF8(B) ; J90-D-4638
(ucs-set-char #x6BD6 ?$(H+J(B) ; C02-H-2B4A
(ucs-set-char #x6BD6 ?$A1Q(B) ; GB0-A-3151
(ucs-set-char #x6BD7 ?$(C]q(B) ; KS0-C-5D71
(ucs-set-char #x6BD7 ?$(GQv(B) ; C01-G-5176
(ucs-set-char #x6BD7 ?$AE~(B) ; GB0-A-457E
(ucs-set-char #x6BD8 ?$(C]r(B) ; KS0-C-5D72
(ucs-set-char #x6BD8 ?$(H+K(B) ; C02-H-2B4B
(ucs-set-char #x6BD8 ?$@H{(B) ; J78-@-487B
(ucs-set-char #x6BD8 ?$BH{(B) ; J83-B-487B
(ucs-set-char #x6BD9 ?$A1P(B) ; GB0-A-3150
(ucs-set-char #x6BDA ?$(DF9(B) ; J90-D-4639
(ucs-set-char #x6BDA ?$(Gs~(B) ; C01-G-737E
(ucs-set-char #x6BDB ?$(CY>(B) ; KS0-C-593E
(ucs-set-char #x6BDB ?$(GES(B) ; C01-G-4553
(ucs-set-char #x6BDB ?$@LS(B) ; J78-@-4C53
(ucs-set-char #x6BDB ?$AC+(B) ; GB0-A-432B
(ucs-set-char #x6BDB ?$BLS(B) ; J83-B-4C53
(ucs-set-char #x6BDE ?$(H'M(B) ; C02-H-274D
(ucs-set-char #x6BDF ?$@][(B) ; J78-@-5D5B
(ucs-set-char #x6BDF ?$B][(B) ; J83-B-5D5B
(ucs-set-char #x6BE0 ?$(H+L(B) ; C02-H-2B4C
(ucs-set-char #x6BE1 ?$(DF:(B) ; J90-D-463A
(ucs-set-char #x6BE1 ?$(I-B(B) ; C03-I-2D42
(ucs-set-char #x6BE1 ?$AU1(B) ; GB0-A-5531
(ucs-set-char #x6BE2 ?$(H0%(B) ; C02-H-3025
(ucs-set-char #x6BE3 ?$(DF;(B) ; J90-D-463B
(ucs-set-char #x6BE3 ?$(H0$(B) ; C02-H-3024
(ucs-set-char #x6BE4 ?$(H0"(B) ; C02-H-3022
(ucs-set-char #x6BE5 ?$(I1n(B) ; C03-I-316E
(ucs-set-char #x6BE6 ?$(DF<(B) ; J90-D-463C
(ucs-set-char #x6BE6 ?$(H0!(B) ; C02-H-3021
(ucs-set-char #x6BE7 ?$(DF=(B) ; J90-D-463D
(ucs-set-char #x6BE7 ?$(H0&(B) ; C02-H-3026
(ucs-set-char #x6BE8 ?$(H0#(B) ; C02-H-3023
(ucs-set-char #x6BE9 ?$(I1l(B) ; C03-I-316C
(ucs-set-char #x6BEA ?$(I1m(B) ; C03-I-316D
(ucs-set-char #x6BEA ?$Ak$(B) ; GB0-A-6B24
(ucs-set-char #x6BEB ?$(C{F(B) ; KS0-C-7B46
(ucs-set-char #x6BEB ?$(G[E(B) ; C01-G-5B45
(ucs-set-char #x6BEB ?$@]](B) ; J78-@-5D5D
(ucs-set-char #x6BEB ?$A:A(B) ; GB0-A-3A41
(ucs-set-char #x6BEB ?$B]](B) ; J83-B-5D5D
(ucs-set-char #x6BEC ?$(CO3(B) ; KS0-C-4F33
(ucs-set-char #x6BEC ?$(G[F(B) ; C01-G-5B46
(ucs-set-char #x6BEC ?$@]\(B) ; J78-@-5D5C
(ucs-set-char #x6BEC ?$B]\(B) ; J83-B-5D5C
(ucs-set-char #x6BED ?$(I6f(B) ; C03-I-3666
(ucs-set-char #x6BEE ?$(DF>(B) ; J90-D-463E
(ucs-set-char #x6BEF ?$(G`'(B) ; C01-G-6027
(ucs-set-char #x6BEF ?$@]_(B) ; J78-@-5D5F
(ucs-set-char #x6BEF ?$AL:(B) ; GB0-A-4C3A
(ucs-set-char #x6BEF ?$B]_(B) ; J83-B-5D5F
(ucs-set-char #x6BF0 ?$(H=((B) ; C02-H-3D28
(ucs-set-char #x6BF1 ?$(DF?(B) ; J90-D-463F
(ucs-set-char #x6BF1 ?$(J8N(B) ; C04-J-384E
(ucs-set-char #x6BF2 ?$(H=)(B) ; C02-H-3D29
(ucs-set-char #x6BF3 ?$(H=*(B) ; C02-H-3D2A
(ucs-set-char #x6BF3 ?$@]^(B) ; J78-@-5D5E
(ucs-set-char #x6BF3 ?$Ak%(B) ; GB0-A-6B25
(ucs-set-char #x6BF3 ?$B]^(B) ; J83-B-5D5E
(ucs-set-char #x6BF4 ?$(I<M(B) ; C03-I-3C4D
(ucs-set-char #x6BF5 ?$Ak'(B) ; GB0-A-6B27
(ucs-set-char #x6BF7 ?$(DF@(B) ; J90-D-4640
(ucs-set-char #x6BF7 ?$(HD'(B) ; C02-H-4427
(ucs-set-char #x6BF8 ?$(HD((B) ; C02-H-4428
(ucs-set-char #x6BF9 ?$(DFA(B) ; J90-D-4641
(ucs-set-char #x6BF9 ?$(HD&(B) ; C02-H-4426
(ucs-set-char #x6BF9 ?$Ak((B) ; GB0-A-6B28
(ucs-set-char #x6BFA ?$(IB((B) ; C03-I-4228
(ucs-set-char #x6BFB ?$(HD$(B) ; C02-H-4424
(ucs-set-char #x6BFC ?$(HD%(B) ; C02-H-4425
(ucs-set-char #x6BFD ?$(Gd](B) ; C01-G-645D
(ucs-set-char #x6BFD ?$Ak&(B) ; GB0-A-6B26
(ucs-set-char #x6BFE ?$(HK3(B) ; C02-H-4B33
(ucs-set-char #x6BFF ?$(DFB(B) ; J90-D-4642
(ucs-set-char #x6BFF ?$(HQ@(B) ; C02-H-5140
(ucs-set-char #x6C00 ?$(HQ?(B) ; C02-H-513F
(ucs-set-char #x6C01 ?$(HQ>(B) ; C02-H-513E
(ucs-set-char #x6C02 ?$(DFC(B) ; J90-D-4643
(ucs-set-char #x6C02 ?$(HQA(B) ; C02-H-5141
(ucs-set-char #x6C03 ?$(HWr(B) ; C02-H-5772
(ucs-set-char #x6C04 ?$(DFD(B) ; J90-D-4644
(ucs-set-char #x6C04 ?$(HWq(B) ; C02-H-5771
(ucs-set-char #x6C05 ?$(DFE(B) ; J90-D-4645
(ucs-set-char #x6C05 ?$(Gq&(B) ; C01-G-7126
(ucs-set-char #x6C05 ?$Ak)(B) ; GB0-A-6B29
(ucs-set-char #x6C06 ?$(HWs(B) ; C02-H-5773
(ucs-set-char #x6C06 ?$Ak+(B) ; GB0-A-6B2B
(ucs-set-char #x6C07 ?$Ak*(B) ; GB0-A-6B2A
(ucs-set-char #x6C08 ?$(Cn}(B) ; KS0-C-6E7D
(ucs-set-char #x6C08 ?$(Gt!(B) ; C01-G-7421
(ucs-set-char #x6C08 ?$@]a(B) ; J78-@-5D61
(ucs-set-char #x6C08 ?$B]a(B) ; J83-B-5D61
(ucs-set-char #x6C09 ?$(DFF(B) ; J90-D-4646
(ucs-set-char #x6C09 ?$(H]9(B) ; C02-H-5D39
(ucs-set-char #x6C0A ?$(IU-(B) ; C03-I-552D
(ucs-set-char #x6C0B ?$(Hav(B) ; C02-H-6176
(ucs-set-char #x6C0C ?$(Hef(B) ; C02-H-6566
(ucs-set-char #x6C0D ?$(DFG(B) ; J90-D-4647
(ucs-set-char #x6C0D ?$(HmU(B) ; C02-H-6D55
(ucs-set-char #x6C0D ?$Ak,(B) ; GB0-A-6B2C
(ucs-set-char #x6C0E ?$(DFH(B) ; J90-D-4648
(ucs-set-char #x6C0E ?$(JmW(B) ; C04-J-6D57
(ucs-set-char #x6C0F ?$(Cd+(B) ; KS0-C-642B
(ucs-set-char #x6C0F ?$(GET(B) ; C01-G-4554
(ucs-set-char #x6C0F ?$@;a(B) ; J78-@-3B61
(ucs-set-char #x6C0F ?$AJO(B) ; GB0-A-4A4F
(ucs-set-char #x6C0F ?$B;a(B) ; J83-B-3B61
(ucs-set-char #x6C10 ?$(DFI(B) ; J90-D-4649
(ucs-set-char #x6C10 ?$(GFb(B) ; C01-G-4662
(ucs-set-char #x6C10 ?$AX5(B) ; GB0-A-5835
(ucs-set-char #x6C11 ?$(CZE(B) ; KS0-C-5A45
(ucs-set-char #x6C11 ?$(GFa(B) ; C01-G-4661
(ucs-set-char #x6C11 ?$@L1(B) ; J78-@-4C31
(ucs-set-char #x6C11 ?$ACq(B) ; GB0-A-4371
(ucs-set-char #x6C11 ?$BL1(B) ; J83-B-4C31
(ucs-set-char #x6C12 ?$(DFJ(B) ; J90-D-464A
(ucs-set-char #x6C12 ?$(J#!(B) ; C04-J-2321
(ucs-set-char #x6C13 ?$(CXl(B) ; KS0-C-586C
(ucs-set-char #x6C13 ?$(GN@(B) ; C01-G-4E40
(ucs-set-char #x6C13 ?$@]b(B) ; J78-@-5D62
(ucs-set-char #x6C13 ?$AC%(B) ; GB0-A-4325
(ucs-set-char #x6C13 ?$B]b(B) ; J83-B-5D62
(ucs-set-char #x6C14 ?$(H!A(B) ; C02-H-2141
(ucs-set-char #x6C14 ?$@]c(B) ; J78-@-5D63
(ucs-set-char #x6C14 ?$AFx(B) ; GB0-A-4678
(ucs-set-char #x6C14 ?$B]c(B) ; J83-B-5D63
(ucs-set-char #x6C15 ?$(H!_(B) ; C02-H-215F
(ucs-set-char #x6C15 ?$Ak-(B) ; GB0-A-6B2D
(ucs-set-char #x6C16 ?$(GH<(B) ; C01-G-483C
(ucs-set-char #x6C16 ?$ADJ(B) ; GB0-A-444A
(ucs-set-char #x6C17 ?$@5$(B) ; J78-@-3524
(ucs-set-char #x6C17 ?$B5$(B) ; J83-B-3524
(ucs-set-char #x6C18 ?$(H"X(B) ; C02-H-2258
(ucs-set-char #x6C18 ?$Ak.(B) ; GB0-A-6B2E
(ucs-set-char #x6C19 ?$(DFK(B) ; J90-D-464B
(ucs-set-char #x6C19 ?$(H$I(B) ; C02-H-2449
(ucs-set-char #x6C19 ?$Ak/(B) ; GB0-A-6B2F
(ucs-set-char #x6C1A ?$(H$J(B) ; C02-H-244A
(ucs-set-char #x6C1A ?$Ak0(B) ; GB0-A-6B30
(ucs-set-char #x6C1B ?$(GNA(B) ; C01-G-4E41
(ucs-set-char #x6C1B ?$@]d(B) ; J78-@-5D64
(ucs-set-char #x6C1B ?$A7U(B) ; GB0-A-3755
(ucs-set-char #x6C1B ?$B]d(B) ; J83-B-5D64
(ucs-set-char #x6C1C ?$(I)](B) ; C03-I-295D
(ucs-set-char #x6C1D ?$(H'N(B) ; C02-H-274E
(ucs-set-char #x6C1F ?$(DFL(B) ; J90-D-464C
(ucs-set-char #x6C1F ?$(GQw(B) ; C01-G-5177
(ucs-set-char #x6C1F ?$A7z(B) ; GB0-A-377A
(ucs-set-char #x6C20 ?$(H+M(B) ; C02-H-2B4D
(ucs-set-char #x6C21 ?$(H+N(B) ; C02-H-2B4E
(ucs-set-char #x6C21 ?$Ak1(B) ; GB0-A-6B31
(ucs-set-char #x6C22 ?$AGb(B) ; GB0-A-4762
(ucs-set-char #x6C23 ?$(CQ((B) ; KS0-C-5128
(ucs-set-char #x6C23 ?$(GV4(B) ; C01-G-5634
(ucs-set-char #x6C23 ?$@]f(B) ; J78-@-5D66
(ucs-set-char #x6C23 ?$B]f(B) ; J83-B-5D66
(ucs-set-char #x6C24 ?$(GV8(B) ; C01-G-5638
(ucs-set-char #x6C24 ?$@]e(B) ; J78-@-5D65
(ucs-set-char #x6C24 ?$Ak3(B) ; GB0-A-6B33
(ucs-set-char #x6C24 ?$B]e(B) ; J83-B-5D65
(ucs-set-char #x6C25 ?$(H0'(B) ; C02-H-3027
(ucs-set-char #x6C26 ?$(DFM(B) ; J90-D-464D
(ucs-set-char #x6C26 ?$(GV7(B) ; C01-G-5637
(ucs-set-char #x6C26 ?$A:$(B) ; GB0-A-3A24
(ucs-set-char #x6C27 ?$(DFN(B) ; J90-D-464E
(ucs-set-char #x6C27 ?$(GV5(B) ; C01-G-5635
(ucs-set-char #x6C27 ?$AQu(B) ; GB0-A-5175
(ucs-set-char #x6C28 ?$(DFO(B) ; J90-D-464F
(ucs-set-char #x6C28 ?$(GV6(B) ; C01-G-5636
(ucs-set-char #x6C28 ?$A01(B) ; GB0-A-3031
(ucs-set-char #x6C29 ?$Ak2(B) ; GB0-A-6B32
(ucs-set-char #x6C2A ?$(H6C(B) ; C02-H-3643
(ucs-set-char #x6C2A ?$Ak4(B) ; GB0-A-6B34
(ucs-set-char #x6C2B ?$(G[G(B) ; C01-G-5B47
(ucs-set-char #x6C2C ?$(DFP(B) ; J90-D-4650
(ucs-set-char #x6C2C ?$(G`*(B) ; C01-G-602A
(ucs-set-char #x6C2D ?$(I<N(B) ; C03-I-3C4E
(ucs-set-char #x6C2E ?$(DFQ(B) ; J90-D-4651
(ucs-set-char #x6C2E ?$(G`((B) ; C01-G-6028
(ucs-set-char #x6C2E ?$A5*(B) ; GB0-A-352A
(ucs-set-char #x6C2F ?$(G`)(B) ; C01-G-6029
(ucs-set-char #x6C2F ?$ABH(B) ; GB0-A-4248
(ucs-set-char #x6C30 ?$(H=+(B) ; C02-H-3D2B
(ucs-set-char #x6C30 ?$AGh(B) ; GB0-A-4768
(ucs-set-char #x6C31 ?$(IB)(B) ; C03-I-4229
(ucs-set-char #x6C32 ?$(IB*(B) ; C03-I-422A
(ucs-set-char #x6C32 ?$Ak5(B) ; GB0-A-6B35
(ucs-set-char #x6C33 ?$(DFR(B) ; J90-D-4652
(ucs-set-char #x6C33 ?$(Gi;(B) ; C01-G-693B
(ucs-set-char #x6C34 ?$(Cb)(B) ; KS0-C-6229
(ucs-set-char #x6C34 ?$(GEU(B) ; C01-G-4555
(ucs-set-char #x6C34 ?$@?e(B) ; J78-@-3F65
(ucs-set-char #x6C34 ?$AK.(B) ; GB0-A-4B2E
(ucs-set-char #x6C34 ?$B?e(B) ; J83-B-3F65
(ucs-set-char #x6C35 ?$(DFS(B) ; J90-D-4653
(ucs-set-char #x6C35 ?$Ac_(B) ; GB0-A-635F
(ucs-set-char #x6C36 ?$(DFT(B) ; J90-D-4654
(ucs-set-char #x6C36 ?$(H!`(B) ; C02-H-2160
(ucs-set-char #x6C37 ?$(C^<(B) ; KS0-C-5E3C
(ucs-set-char #x6C37 ?$(I"W(B) ; C03-I-2257
(ucs-set-char #x6C37 ?$@I9(B) ; J78-@-4939
(ucs-set-char #x6C37 ?$BI9(B) ; J83-B-4939
(ucs-set-char #x6C38 ?$(Cg5(B) ; KS0-C-6735
(ucs-set-char #x6C38 ?$(GFc(B) ; C01-G-4663
(ucs-set-char #x6C38 ?$@1J(B) ; J78-@-314A
(ucs-set-char #x6C38 ?$AS@(B) ; GB0-A-5340
(ucs-set-char #x6C38 ?$B1J(B) ; J83-B-314A
(ucs-set-char #x6C39 ?$(I"T(B) ; C03-I-2254
(ucs-set-char #x6C3A ?$(DFU(B) ; J90-D-4655
(ucs-set-char #x6C3B ?$(DFV(B) ; J90-D-4656
(ucs-set-char #x6C3B ?$(H!c(B) ; C02-H-2163
(ucs-set-char #x6C3C ?$(I$!(B) ; C03-I-2421
(ucs-set-char #x6C3D ?$AY[(B) ; GB0-A-595B
(ucs-set-char #x6C3E ?$(C[p(B) ; KS0-C-5B70
(ucs-set-char #x6C3E ?$(GFf(B) ; C01-G-4666
(ucs-set-char #x6C3E ?$@HE(B) ; J78-@-4845
(ucs-set-char #x6C3E ?$BHE(B) ; J83-B-4845
(ucs-set-char #x6C3F ?$(DFW(B) ; J90-D-4657
(ucs-set-char #x6C3F ?$(H!b(B) ; C02-H-2162
(ucs-set-char #x6C40 ?$(Cob(B) ; KS0-C-6F62
(ucs-set-char #x6C40 ?$(GFe(B) ; C01-G-4665
(ucs-set-char #x6C40 ?$@Du(B) ; J78-@-4475
(ucs-set-char #x6C40 ?$AM!(B) ; GB0-A-4D21
(ucs-set-char #x6C40 ?$BDu(B) ; J83-B-4475
(ucs-set-char #x6C41 ?$(Cqp(B) ; KS0-C-7170
(ucs-set-char #x6C41 ?$(GFd(B) ; C01-G-4664
(ucs-set-char #x6C41 ?$@=A(B) ; J78-@-3D41
(ucs-set-char #x6C41 ?$AV-(B) ; GB0-A-562D
(ucs-set-char #x6C41 ?$B=A(B) ; J83-B-3D41
(ucs-set-char #x6C42 ?$(CO4(B) ; KS0-C-4F34
(ucs-set-char #x6C42 ?$(GJe(B) ; C01-G-4A65
(ucs-set-char #x6C42 ?$@5a(B) ; J78-@-3561
(ucs-set-char #x6C42 ?$AGs(B) ; GB0-A-4773
(ucs-set-char #x6C42 ?$B5a(B) ; J83-B-3561
(ucs-set-char #x6C43 ?$(H!a(B) ; C02-H-2161
(ucs-set-char #x6C44 ?$(I"X(B) ; C03-I-2258
(ucs-set-char #x6C45 ?$(I"Y(B) ; C03-I-2259
(ucs-set-char #x6C46 ?$(H"Y(B) ; C02-H-2259
(ucs-set-char #x6C46 ?$AY`(B) ; GB0-A-5960
(ucs-set-char #x6C47 ?$A;c(B) ; GB0-A-3B63
(ucs-set-char #x6C49 ?$A::(B) ; GB0-A-3A3A
(ucs-set-char #x6C4A ?$(DFX(B) ; J90-D-4658
(ucs-set-char #x6C4A ?$(H"](B) ; C02-H-225D
(ucs-set-char #x6C4A ?$Acb(B) ; GB0-A-6362
(ucs-set-char #x6C4B ?$(DFY(B) ; J90-D-4659
(ucs-set-char #x6C4B ?$(H"_(B) ; C02-H-225F
(ucs-set-char #x6C4C ?$(H"`(B) ; C02-H-2260
(ucs-set-char #x6C4D ?$(DFZ(B) ; J90-D-465A
(ucs-set-char #x6C4D ?$(GHF(B) ; C01-G-4846
(ucs-set-char #x6C4E ?$(C[q(B) ; KS0-C-5B71
(ucs-set-char #x6C4E ?$(GHG(B) ; C01-G-4847
(ucs-set-char #x6C4E ?$@HF(B) ; J78-@-4846
(ucs-set-char #x6C4E ?$BHF(B) ; J83-B-4846
(ucs-set-char #x6C4F ?$(DF[(B) ; J90-D-465B
(ucs-set-char #x6C4F ?$(H"\(B) ; C02-H-225C
(ucs-set-char #x6C50 ?$(C`1(B) ; KS0-C-6031
(ucs-set-char #x6C50 ?$(GHB(B) ; C01-G-4842
(ucs-set-char #x6C50 ?$@<.(B) ; J78-@-3C2E
(ucs-set-char #x6C50 ?$AO+(B) ; GB0-A-4F2B
(ucs-set-char #x6C50 ?$B<.(B) ; J83-B-3C2E
(ucs-set-char #x6C51 ?$(I#}(B) ; C03-I-237D
(ucs-set-char #x6C52 ?$(DF\(B) ; J90-D-465C
(ucs-set-char #x6C52 ?$(H"Z(B) ; C02-H-225A
(ucs-set-char #x6C53 ?$(I$%(B) ; C03-I-2425
(ucs-set-char #x6C54 ?$(DF](B) ; J90-D-465D
(ucs-set-char #x6C54 ?$(H"^(B) ; C02-H-225E
(ucs-set-char #x6C54 ?$Ac`(B) ; GB0-A-6360
(ucs-set-char #x6C55 ?$(C_%(B) ; KS0-C-5F25
(ucs-set-char #x6C55 ?$(GHC(B) ; C01-G-4843
(ucs-set-char #x6C55 ?$@]h(B) ; J78-@-5D68
(ucs-set-char #x6C55 ?$AIG(B) ; GB0-A-4947
(ucs-set-char #x6C55 ?$B]h(B) ; J83-B-5D68
(ucs-set-char #x6C56 ?$(I&U(B) ; C03-I-2655
(ucs-set-char #x6C57 ?$(CyR(B) ; KS0-C-7952
(ucs-set-char #x6C57 ?$(GH>(B) ; C01-G-483E
(ucs-set-char #x6C57 ?$@4@(B) ; J78-@-3440
(ucs-set-char #x6C57 ?$A:9(B) ; GB0-A-3A39
(ucs-set-char #x6C57 ?$B4@(B) ; J83-B-3440
(ucs-set-char #x6C58 ?$(I#|(B) ; C03-I-237C
(ucs-set-char #x6C59 ?$(DF^(B) ; J90-D-465E
(ucs-set-char #x6C59 ?$(GH?(B) ; C01-G-483F
(ucs-set-char #x6C5A ?$(Cg}(B) ; KS0-C-677D
(ucs-set-char #x6C5A ?$(I$#(B) ; C03-I-2423
(ucs-set-char #x6C5A ?$@1x(B) ; J78-@-3178
(ucs-set-char #x6C5A ?$B1x(B) ; J83-B-3178
(ucs-set-char #x6C5B ?$(DF_(B) ; J90-D-465F
(ucs-set-char #x6C5B ?$(GHE(B) ; C01-G-4845
(ucs-set-char #x6C5B ?$AQ4(B) ; GB0-A-5134
(ucs-set-char #x6C5C ?$(DF`(B) ; J90-D-4660
(ucs-set-char #x6C5C ?$(H"[(B) ; C02-H-225B
(ucs-set-char #x6C5C ?$Aca(B) ; GB0-A-6361
(ucs-set-char #x6C5D ?$(Cf#(B) ; KS0-C-6623
(ucs-set-char #x6C5D ?$(GH=(B) ; C01-G-483D
(ucs-set-char #x6C5D ?$@Fr(B) ; J78-@-4672
(ucs-set-char #x6C5D ?$AHj(B) ; GB0-A-486A
(ucs-set-char #x6C5D ?$BFr(B) ; J83-B-4672
(ucs-set-char #x6C5E ?$(C{q(B) ; KS0-C-7B71
(ucs-set-char #x6C5E ?$(GJf(B) ; C01-G-4A66
(ucs-set-char #x6C5E ?$@]g(B) ; J78-@-5D67
(ucs-set-char #x6C5E ?$A9/(B) ; GB0-A-392F
(ucs-set-char #x6C5E ?$B]g(B) ; J83-B-5D67
(ucs-set-char #x6C5F ?$(CK0(B) ; KS0-C-4B30
(ucs-set-char #x6C5F ?$(GH@(B) ; C01-G-4840
(ucs-set-char #x6C5F ?$@9>(B) ; J78-@-393E
(ucs-set-char #x6C5F ?$A=-(B) ; GB0-A-3D2D
(ucs-set-char #x6C5F ?$B9>(B) ; J83-B-393E
(ucs-set-char #x6C60 ?$(Cr.(B) ; KS0-C-722E
(ucs-set-char #x6C60 ?$(GHA(B) ; C01-G-4841
(ucs-set-char #x6C60 ?$@CS(B) ; J78-@-4353
(ucs-set-char #x6C60 ?$A3X(B) ; GB0-A-3358
(ucs-set-char #x6C60 ?$BCS(B) ; J83-B-4353
(ucs-set-char #x6C61 ?$(GHD(B) ; C01-G-4844
(ucs-set-char #x6C61 ?$AN[(B) ; GB0-A-4E5B
(ucs-set-char #x6C62 ?$@]i(B) ; J78-@-5D69
(ucs-set-char #x6C62 ?$B]i(B) ; J83-B-5D69
(ucs-set-char #x6C64 ?$AL@(B) ; GB0-A-4C40
(ucs-set-char #x6C65 ?$(H$[(B) ; C02-H-245B
(ucs-set-char #x6C66 ?$(H$Y(B) ; C02-H-2459
(ucs-set-char #x6C67 ?$(DG6(B) ; J90-D-4736
(ucs-set-char #x6C67 ?$(H$L(B) ; C02-H-244C
(ucs-set-char #x6C67 ?$(I-R(B) ; C03-I-2D52
(ucs-set-char #x6C68 ?$(CMg(B) ; KS0-C-4D67
(ucs-set-char #x6C68 ?$(GJr(B) ; C01-G-4A72
(ucs-set-char #x6C68 ?$@]q(B) ; J78-@-5D71
(ucs-set-char #x6C68 ?$Ach(B) ; GB0-A-6368
(ucs-set-char #x6C68 ?$B]q(B) ; J83-B-5D71
(ucs-set-char #x6C69 ?$(H$S(B) ; C02-H-2453
(ucs-set-char #x6C69 ?$Aci(B) ; GB0-A-6369
(ucs-set-char #x6C6A ?$(Ch\(B) ; KS0-C-685C
(ucs-set-char #x6C6A ?$(GJm(B) ; C01-G-4A6D
(ucs-set-char #x6C6A ?$@]j(B) ; J78-@-5D6A
(ucs-set-char #x6C6A ?$AMt(B) ; GB0-A-4D74
(ucs-set-char #x6C6A ?$B]j(B) ; J83-B-5D6A
(ucs-set-char #x6C6B ?$(DFa(B) ; J90-D-4661
(ucs-set-char #x6C6B ?$(H$M(B) ; C02-H-244D
(ucs-set-char #x6C6C ?$(I)d(B) ; C03-I-2964
(ucs-set-char #x6C6D ?$(CgW(B) ; KS0-C-6757
(ucs-set-char #x6C6D ?$(DFb(B) ; J90-D-4662
(ucs-set-char #x6C6D ?$(H$U(B) ; C02-H-2455
(ucs-set-char #x6C6E ?$(I&P(B) ; C03-I-2650
(ucs-set-char #x6C6F ?$(DFc(B) ; J90-D-4663
(ucs-set-char #x6C6F ?$(H$R(B) ; C02-H-2452
(ucs-set-char #x6C70 ?$(Cw@(B) ; KS0-C-7740
(ucs-set-char #x6C70 ?$(GJp(B) ; C01-G-4A70
(ucs-set-char #x6C70 ?$@BA(B) ; J78-@-4241
(ucs-set-char #x6C70 ?$AL-(B) ; GB0-A-4C2D
(ucs-set-char #x6C70 ?$BBA(B) ; J83-B-4241
(ucs-set-char #x6C71 ?$(H$Q(B) ; C02-H-2451
(ucs-set-char #x6C72 ?$(CPc(B) ; KS0-C-5063
(ucs-set-char #x6C72 ?$(GJw(B) ; C01-G-4A77
(ucs-set-char #x6C72 ?$@5b(B) ; J78-@-3562
(ucs-set-char #x6C72 ?$A<3(B) ; GB0-A-3C33
(ucs-set-char #x6C72 ?$B5b(B) ; J83-B-3562
(ucs-set-char #x6C73 ?$(H$Z(B) ; C02-H-245A
(ucs-set-char #x6C73 ?$@]r(B) ; J78-@-5D72
(ucs-set-char #x6C73 ?$B]r(B) ; J83-B-5D72
(ucs-set-char #x6C74 ?$(DFd(B) ; J90-D-4664
(ucs-set-char #x6C74 ?$(GJy(B) ; C01-G-4A79
(ucs-set-char #x6C74 ?$Acj(B) ; GB0-A-636A
(ucs-set-char #x6C75 ?$(I&S(B) ; C03-I-2653
(ucs-set-char #x6C76 ?$(CZ!(B) ; KS0-C-5A21
(ucs-set-char #x6C76 ?$(DFe(B) ; J90-D-4665
(ucs-set-char #x6C76 ?$(GJ{(B) ; C01-G-4A7B
(ucs-set-char #x6C76 ?$Ack(B) ; GB0-A-636B
(ucs-set-char #x6C77 ?$(I#~(B) ; C03-I-237E
(ucs-set-char #x6C78 ?$(DFf(B) ; J90-D-4666
(ucs-set-char #x6C78 ?$(H$K(B) ; C02-H-244B
(ucs-set-char #x6C79 ?$(DFg(B) ; J90-D-4667
(ucs-set-char #x6C79 ?$(I&W(B) ; C03-I-2657
(ucs-set-char #x6C79 ?$APZ(B) ; GB0-A-505A
(ucs-set-char #x6C7A ?$(CL=(B) ; KS0-C-4C3D
(ucs-set-char #x6C7A ?$(GJn(B) ; C01-G-4A6E
(ucs-set-char #x6C7A ?$@7h(B) ; J78-@-3768
(ucs-set-char #x6C7A ?$B7h(B) ; J83-B-3768
(ucs-set-char #x6C7B ?$(DFh(B) ; J90-D-4668
(ucs-set-char #x6C7B ?$(H$\(B) ; C02-H-245C
(ucs-set-char #x6C7C ?$(I&Q(B) ; C03-I-2651
(ucs-set-char #x6C7D ?$(CQ)(B) ; KS0-C-5129
(ucs-set-char #x6C7D ?$(GJu(B) ; C01-G-4A75
(ucs-set-char #x6C7D ?$@5%(B) ; J78-@-3525
(ucs-set-char #x6C7D ?$AF{(B) ; GB0-A-467B
(ucs-set-char #x6C7D ?$B5%(B) ; J83-B-3525
(ucs-set-char #x6C7E ?$(C]L(B) ; KS0-C-5D4C
(ucs-set-char #x6C7E ?$(GJx(B) ; C01-G-4A78
(ucs-set-char #x6C7E ?$@]p(B) ; J78-@-5D70
(ucs-set-char #x6C7E ?$A7Z(B) ; GB0-A-375A
(ucs-set-char #x6C7E ?$B]p(B) ; J83-B-5D70
(ucs-set-char #x6C7F ?$(I&L(B) ; C03-I-264C
(ucs-set-char #x6C80 ?$(H'e(B) ; C02-H-2765
(ucs-set-char #x6C81 ?$(Cc~(B) ; KS0-C-637E
(ucs-set-char #x6C81 ?$(GJh(B) ; C01-G-4A68
(ucs-set-char #x6C81 ?$@]n(B) ; J78-@-5D6E
(ucs-set-char #x6C81 ?$AG_(B) ; GB0-A-475F
(ucs-set-char #x6C81 ?$B]n(B) ; J83-B-5D6E
(ucs-set-char #x6C82 ?$(CQ*(B) ; KS0-C-512A
(ucs-set-char #x6C82 ?$(GK!(B) ; C01-G-4B21
(ucs-set-char #x6C82 ?$@]k(B) ; J78-@-5D6B
(ucs-set-char #x6C82 ?$ARJ(B) ; GB0-A-524A
(ucs-set-char #x6C82 ?$B]k(B) ; J83-B-5D6B
(ucs-set-char #x6C83 ?$(Ch*(B) ; KS0-C-682A
(ucs-set-char #x6C83 ?$(GJv(B) ; C01-G-4A76
(ucs-set-char #x6C83 ?$@M`(B) ; J78-@-4D60
(ucs-set-char #x6C83 ?$ANV(B) ; GB0-A-4E56
(ucs-set-char #x6C83 ?$BM`(B) ; J83-B-4D60
(ucs-set-char #x6C84 ?$(H$N(B) ; C02-H-244E
(ucs-set-char #x6C85 ?$(Cj6(B) ; KS0-C-6A36
(ucs-set-char #x6C85 ?$(DFi(B) ; J90-D-4669
(ucs-set-char #x6C85 ?$(GJk(B) ; C01-G-4A6B
(ucs-set-char #x6C85 ?$Acd(B) ; GB0-A-6364
(ucs-set-char #x6C86 ?$(Cyz(B) ; KS0-C-797A
(ucs-set-char #x6C86 ?$(DFj(B) ; J90-D-466A
(ucs-set-char #x6C86 ?$(GJz(B) ; C01-G-4A7A
(ucs-set-char #x6C86 ?$Acl(B) ; GB0-A-636C
(ucs-set-char #x6C87 ?$(CfL(B) ; KS0-C-664C
(ucs-set-char #x6C87 ?$(DFk(B) ; J90-D-466B
(ucs-set-char #x6C87 ?$(H$V(B) ; C02-H-2456
(ucs-set-char #x6C88 ?$(CvX(B) ; KS0-C-7658
(ucs-set-char #x6C88 ?$(GJi(B) ; C01-G-4A69
(ucs-set-char #x6C88 ?$@D@(B) ; J78-@-4440
(ucs-set-char #x6C88 ?$AIr(B) ; GB0-A-4972
(ucs-set-char #x6C88 ?$BD@(B) ; J83-B-4440
(ucs-set-char #x6C89 ?$(DFl(B) ; J90-D-466C
(ucs-set-char #x6C89 ?$(GJj(B) ; C01-G-4A6A
(ucs-set-char #x6C89 ?$A3A(B) ; GB0-A-3341
(ucs-set-char #x6C8A ?$(H'c(B) ; C02-H-2763
(ucs-set-char #x6C8B ?$(H$O(B) ; C02-H-244F
(ucs-set-char #x6C8C ?$(CTG(B) ; KS0-C-5447
(ucs-set-char #x6C8C ?$(GJq(B) ; C01-G-4A71
(ucs-set-char #x6C8C ?$@FY(B) ; J78-@-4659
(ucs-set-char #x6C8C ?$Acg(B) ; GB0-A-6367
(ucs-set-char #x6C8C ?$BFY(B) ; J83-B-4659
(ucs-set-char #x6C8D ?$(GJ|(B) ; C01-G-4A7C
(ucs-set-char #x6C8D ?$@]l(B) ; J78-@-5D6C
(ucs-set-char #x6C8D ?$B]l(B) ; J83-B-5D6C
(ucs-set-char #x6C8E ?$(H$](B) ; C02-H-245D
(ucs-set-char #x6C8F ?$(H$P(B) ; C02-H-2450
(ucs-set-char #x6C8F ?$AFc(B) ; GB0-A-4663
(ucs-set-char #x6C90 ?$(CYK(B) ; KS0-C-594B
(ucs-set-char #x6C90 ?$(GJo(B) ; C01-G-4A6F
(ucs-set-char #x6C90 ?$@]t(B) ; J78-@-5D74
(ucs-set-char #x6C90 ?$Ace(B) ; GB0-A-6365
(ucs-set-char #x6C90 ?$B]t(B) ; J83-B-5D74
(ucs-set-char #x6C91 ?$(I&M(B) ; C03-I-264D
(ucs-set-char #x6C92 ?$(CYR(B) ; KS0-C-5952
(ucs-set-char #x6C92 ?$(GJt(B) ; C01-G-4A74
(ucs-set-char #x6C92 ?$@]s(B) ; J78-@-5D73
(ucs-set-char #x6C92 ?$B]s(B) ; J83-B-5D73
(ucs-set-char #x6C93 ?$(CSK(B) ; KS0-C-534B
(ucs-set-char #x6C93 ?$(H'O(B) ; C02-H-274F
(ucs-set-char #x6C93 ?$@7#(B) ; J78-@-3723
(ucs-set-char #x6C93 ?$Am3(B) ; GB0-A-6D33
(ucs-set-char #x6C93 ?$B7#(B) ; J83-B-3723
(ucs-set-char #x6C94 ?$(CXw(B) ; KS0-C-5877
(ucs-set-char #x6C94 ?$(DFm(B) ; J90-D-466D
(ucs-set-char #x6C94 ?$(GJ}(B) ; C01-G-4A7D
(ucs-set-char #x6C94 ?$Acf(B) ; GB0-A-6366
(ucs-set-char #x6C95 ?$(CZ)(B) ; KS0-C-5A29
(ucs-set-char #x6C95 ?$(DFn(B) ; J90-D-466E
(ucs-set-char #x6C95 ?$(H$W(B) ; C02-H-2457
(ucs-set-char #x6C96 ?$(Cux(B) ; KS0-C-7578
(ucs-set-char #x6C96 ?$(GJs(B) ; C01-G-4A73
(ucs-set-char #x6C96 ?$@2-(B) ; J78-@-322D
(ucs-set-char #x6C96 ?$B2-(B) ; J83-B-322D
(ucs-set-char #x6C97 ?$(DFo(B) ; J90-D-466F
(ucs-set-char #x6C97 ?$(I)c(B) ; C03-I-2963
(ucs-set-char #x6C98 ?$(DFp(B) ; J90-D-4670
(ucs-set-char #x6C98 ?$(GJ~(B) ; C01-G-4A7E
(ucs-set-char #x6C99 ?$(C^^(B) ; KS0-C-5E5E
(ucs-set-char #x6C99 ?$(GJg(B) ; C01-G-4A67
(ucs-set-char #x6C99 ?$@:;(B) ; J78-@-3A3B
(ucs-set-char #x6C99 ?$AI3(B) ; GB0-A-4933
(ucs-set-char #x6C99 ?$B:;(B) ; J83-B-3A3B
(ucs-set-char #x6C9A ?$(Cr/(B) ; KS0-C-722F
(ucs-set-char #x6C9A ?$(H$T(B) ; C02-H-2454
(ucs-set-char #x6C9A ?$@]m(B) ; J78-@-5D6D
(ucs-set-char #x6C9A ?$B]m(B) ; J83-B-5D6D
(ucs-set-char #x6C9B ?$(Cx)(B) ; KS0-C-7829
(ucs-set-char #x6C9B ?$(GJl(B) ; C01-G-4A6C
(ucs-set-char #x6C9B ?$@]o(B) ; J78-@-5D6F
(ucs-set-char #x6C9B ?$AEf(B) ; GB0-A-4566
(ucs-set-char #x6C9B ?$B]o(B) ; J83-B-5D6F
(ucs-set-char #x6C9C ?$(DFq(B) ; J90-D-4671
(ucs-set-char #x6C9C ?$(H$X(B) ; C02-H-2458
(ucs-set-char #x6C9D ?$(H'd(B) ; C02-H-2764
(ucs-set-char #x6C9E ?$(I&N(B) ; C03-I-264E
(ucs-set-char #x6C9F ?$(DFr(B) ; J90-D-4672
(ucs-set-char #x6C9F ?$(I&R(B) ; C03-I-2652
(ucs-set-char #x6C9F ?$A95(B) ; GB0-A-3935
(ucs-set-char #x6CA0 ?$(I&\(B) ; C03-I-265C
(ucs-set-char #x6CA1 ?$(I&Y(B) ; C03-I-2659
(ucs-set-char #x6CA1 ?$@KW(B) ; J78-@-4B57
(ucs-set-char #x6CA1 ?$AC;(B) ; GB0-A-433B
(ucs-set-char #x6CA1 ?$BKW(B) ; J83-B-4B57
(ucs-set-char #x6CA2 ?$(I&V(B) ; C03-I-2656
(ucs-set-char #x6CA2 ?$@Bt(B) ; J78-@-4274
(ucs-set-char #x6CA2 ?$BBt(B) ; J83-B-4274
(ucs-set-char #x6CA3 ?$Acc(B) ; GB0-A-6363
(ucs-set-char #x6CA4 ?$AE=(B) ; GB0-A-453D
(ucs-set-char #x6CA5 ?$AA$(B) ; GB0-A-4124
(ucs-set-char #x6CA6 ?$ABY(B) ; GB0-A-4259
(ucs-set-char #x6CA7 ?$A2W(B) ; GB0-A-3257
(ucs-set-char #x6CA9 ?$Acm(B) ; GB0-A-636D
(ucs-set-char #x6CAA ?$(I&[(B) ; C03-I-265B
(ucs-set-char #x6CAA ?$A;&(B) ; GB0-A-3B26
(ucs-set-char #x6CAB ?$(CXH(B) ; KS0-C-5848
(ucs-set-char #x6CAB ?$(GNM(B) ; C01-G-4E4D
(ucs-set-char #x6CAB ?$@Kw(B) ; J78-@-4B77
(ucs-set-char #x6CAB ?$AD-(B) ; GB0-A-442D
(ucs-set-char #x6CAB ?$BKw(B) ; J83-B-4B77
(ucs-set-char #x6CAC ?$(GN](B) ; C01-G-4E5D
(ucs-set-char #x6CAD ?$(H'V(B) ; C02-H-2756
(ucs-set-char #x6CAD ?$Acp(B) ; GB0-A-6370
(ucs-set-char #x6CAE ?$(CnA(B) ; KS0-C-6E41
(ucs-set-char #x6CAE ?$(GNT(B) ; C01-G-4E54
(ucs-set-char #x6CAE ?$@]|(B) ; J78-@-5D7C
(ucs-set-char #x6CAE ?$A>Z(B) ; GB0-A-3E5A
(ucs-set-char #x6CAE ?$B]|(B) ; J83-B-5D7C
(ucs-set-char #x6CAF ?$(I-N(B) ; C03-I-2D4E
(ucs-set-char #x6CB0 ?$(DFs(B) ; J90-D-4673
(ucs-set-char #x6CB0 ?$(H'k(B) ; C02-H-276B
(ucs-set-char #x6CB1 ?$(GNE(B) ; C01-G-4E45
(ucs-set-char #x6CB1 ?$@]}(B) ; J78-@-5D7D
(ucs-set-char #x6CB1 ?$Ac{(B) ; GB0-A-637B
(ucs-set-char #x6CB1 ?$B]}(B) ; J83-B-5D7D
(ucs-set-char #x6CB2 ?$(DFt(B) ; J90-D-4674
(ucs-set-char #x6CB2 ?$(I)k(B) ; C03-I-296B
(ucs-set-char #x6CB2 ?$Acu(B) ; GB0-A-6375
(ucs-set-char #x6CB3 ?$(CyA(B) ; KS0-C-7941
(ucs-set-char #x6CB3 ?$(GNH(B) ; C01-G-4E48
(ucs-set-char #x6CB3 ?$@2O(B) ; J78-@-324F
(ucs-set-char #x6CB3 ?$A:S(B) ; GB0-A-3A53
(ucs-set-char #x6CB3 ?$B2O(B) ; J83-B-324F
(ucs-set-char #x6CB4 ?$(DFu(B) ; J90-D-4675
(ucs-set-char #x6CB4 ?$(H'b(B) ; C02-H-2762
(ucs-set-char #x6CB5 ?$(J'&(B) ; C04-J-2726
(ucs-set-char #x6CB6 ?$(H'T(B) ; C02-H-2754
(ucs-set-char #x6CB7 ?$(H'X(B) ; C02-H-2758
(ucs-set-char #x6CB8 ?$(C]s(B) ; KS0-C-5D73
(ucs-set-char #x6CB8 ?$(GNP(B) ; C01-G-4E50
(ucs-set-char #x6CB8 ?$@J((B) ; J78-@-4A28
(ucs-set-char #x6CB8 ?$A7P(B) ; GB0-A-3750
(ucs-set-char #x6CB8 ?$BJ((B) ; J83-B-4A28
(ucs-set-char #x6CB9 ?$(Cjz(B) ; KS0-C-6A7A
(ucs-set-char #x6CB9 ?$(GNR(B) ; C01-G-4E52
(ucs-set-char #x6CB9 ?$@L}(B) ; J78-@-4C7D
(ucs-set-char #x6CB9 ?$ASM(B) ; GB0-A-534D
(ucs-set-char #x6CB9 ?$BL}(B) ; J83-B-4C7D
(ucs-set-char #x6CBA ?$(H'[(B) ; C02-H-275B
(ucs-set-char #x6CBA ?$@^!(B) ; J78-@-5E21
(ucs-set-char #x6CBA ?$B^!(B) ; J83-B-5E21
(ucs-set-char #x6CBB ?$(Cv=(B) ; KS0-C-763D
(ucs-set-char #x6CBB ?$(GNY(B) ; C01-G-4E59
(ucs-set-char #x6CBB ?$@<#(B) ; J78-@-3C23
(ucs-set-char #x6CBB ?$AVN(B) ; GB0-A-564E
(ucs-set-char #x6CBB ?$B<#(B) ; J83-B-3C23
(ucs-set-char #x6CBC ?$(Ca;(B) ; KS0-C-613B
(ucs-set-char #x6CBC ?$(GNK(B) ; C01-G-4E4B
(ucs-set-char #x6CBC ?$@>B(B) ; J78-@-3E42
(ucs-set-char #x6CBC ?$AUS(B) ; GB0-A-5553
(ucs-set-char #x6CBC ?$B>B(B) ; J83-B-3E42
(ucs-set-char #x6CBD ?$(CM?(B) ; KS0-C-4D3F
(ucs-set-char #x6CBD ?$(GNI(B) ; C01-G-4E49
(ucs-set-char #x6CBD ?$@]x(B) ; J78-@-5D78
(ucs-set-char #x6CBD ?$A9A(B) ; GB0-A-3941
(ucs-set-char #x6CBD ?$B]x(B) ; J83-B-5D78
(ucs-set-char #x6CBE ?$(CtT(B) ; KS0-C-7454
(ucs-set-char #x6CBE ?$(GNJ(B) ; C01-G-4E4A
(ucs-set-char #x6CBE ?$@]~(B) ; J78-@-5D7E
(ucs-set-char #x6CBE ?$AU4(B) ; GB0-A-5534
(ucs-set-char #x6CBE ?$B]~(B) ; J83-B-5D7E
(ucs-set-char #x6CBF ?$(CfM(B) ; KS0-C-664D
(ucs-set-char #x6CBF ?$(GNX(B) ; C01-G-4E58
(ucs-set-char #x6CBF ?$(L,[(B) ; C06-L-2C5B
(ucs-set-char #x6CBF ?$@1h(B) ; J78-@-3168
(ucs-set-char #x6CBF ?$AQX(B) ; GB0-A-5158
(ucs-set-char #x6CBF ?$B1h(B) ; J83-B-3168
(ucs-set-char #x6CC0 ?$(H'g(B) ; C02-H-2767
(ucs-set-char #x6CC1 ?$(C|O(B) ; KS0-C-7C4F
(ucs-set-char #x6CC1 ?$(GNS(B) ; C01-G-4E53
(ucs-set-char #x6CC1 ?$@67(B) ; J78-@-3637
(ucs-set-char #x6CC1 ?$B67(B) ; J83-B-3637
(ucs-set-char #x6CC2 ?$(C{"(B) ; KS0-C-7B22
(ucs-set-char #x6CC2 ?$(DFv(B) ; J90-D-4676
(ucs-set-char #x6CC2 ?$(H'Z(B) ; C02-H-275A
(ucs-set-char #x6CC3 ?$(H'\(B) ; C02-H-275C
(ucs-set-char #x6CC4 ?$(C`\(B) ; KS0-C-605C
(ucs-set-char #x6CC4 ?$(GNQ(B) ; C01-G-4E51
(ucs-set-char #x6CC4 ?$@]u(B) ; J78-@-5D75
(ucs-set-char #x6CC4 ?$AP9(B) ; GB0-A-5039
(ucs-set-char #x6CC4 ?$B]u(B) ; J83-B-5D75
(ucs-set-char #x6CC5 ?$(GNV(B) ; C01-G-4E56
(ucs-set-char #x6CC5 ?$@]z(B) ; J78-@-5D7A
(ucs-set-char #x6CC5 ?$AGv(B) ; GB0-A-4776
(ucs-set-char #x6CC5 ?$B]z(B) ; J83-B-5D7A
(ucs-set-char #x6CC6 ?$(DFw(B) ; J90-D-4677
(ucs-set-char #x6CC6 ?$(H'](B) ; C02-H-275D
(ucs-set-char #x6CC7 ?$(H'j(B) ; C02-H-276A
(ucs-set-char #x6CC8 ?$(I)m(B) ; C03-I-296D
(ucs-set-char #x6CC9 ?$(Ct;(B) ; KS0-C-743B
(ucs-set-char #x6CC9 ?$(GQx(B) ; C01-G-5178
(ucs-set-char #x6CC9 ?$@@t(B) ; J78-@-4074
(ucs-set-char #x6CC9 ?$AH*(B) ; GB0-A-482A
(ucs-set-char #x6CC9 ?$B@t(B) ; J83-B-4074
(ucs-set-char #x6CCA ?$(CZU(B) ; KS0-C-5A55
(ucs-set-char #x6CCA ?$(GN\(B) ; C01-G-4E5C
(ucs-set-char #x6CCA ?$@Gq(B) ; J78-@-4771
(ucs-set-char #x6CCA ?$A24(B) ; GB0-A-3234
(ucs-set-char #x6CCA ?$BGq(B) ; J83-B-4771
(ucs-set-char #x6CCB ?$(J&}(B) ; C04-J-267D
(ucs-set-char #x6CCC ?$(Cy2(B) ; KS0-C-7932
(ucs-set-char #x6CCC ?$(GNF(B) ; C01-G-4E46
(ucs-set-char #x6CCC ?$@Hg(B) ; J78-@-4867
(ucs-set-char #x6CCC ?$ACZ(B) ; GB0-A-435A
(ucs-set-char #x6CCC ?$BHg(B) ; J83-B-4867
(ucs-set-char #x6CCD ?$(DFx(B) ; J90-D-4678
(ucs-set-char #x6CCD ?$(H'i(B) ; C02-H-2769
(ucs-set-char #x6CCE ?$(I)l(B) ; C03-I-296C
(ucs-set-char #x6CCF ?$(DFy(B) ; J90-D-4679
(ucs-set-char #x6CCF ?$(H'm(B) ; C02-H-276D
(ucs-set-char #x6CD0 ?$(DFz(B) ; J90-D-467A
(ucs-set-char #x6CD0 ?$(H'Y(B) ; C02-H-2759
(ucs-set-char #x6CD0 ?$Acn(B) ; GB0-A-636E
(ucs-set-char #x6CD1 ?$(DF{(B) ; J90-D-467B
(ucs-set-char #x6CD1 ?$(H'o(B) ; C02-H-276F
(ucs-set-char #x6CD2 ?$(DF|(B) ; J90-D-467C
(ucs-set-char #x6CD2 ?$(H'`(B) ; C02-H-2760
(ucs-set-char #x6CD3 ?$(C{r(B) ; KS0-C-7B72
(ucs-set-char #x6CD3 ?$(GNO(B) ; C01-G-4E4F
(ucs-set-char #x6CD3 ?$@]w(B) ; J78-@-5D77
(ucs-set-char #x6CD3 ?$Ac|(B) ; GB0-A-637C
(ucs-set-char #x6CD3 ?$B]w(B) ; J83-B-5D77
(ucs-set-char #x6CD4 ?$(DF}(B) ; J90-D-467D
(ucs-set-char #x6CD4 ?$(H'U(B) ; C02-H-2755
(ucs-set-char #x6CD4 ?$Aco(B) ; GB0-A-636F
(ucs-set-char #x6CD5 ?$(C[v(B) ; KS0-C-5B76
(ucs-set-char #x6CD5 ?$(GNN(B) ; C01-G-4E4E
(ucs-set-char #x6CD5 ?$@K!(B) ; J78-@-4B21
(ucs-set-char #x6CD5 ?$A7((B) ; GB0-A-3728
(ucs-set-char #x6CD5 ?$BK!(B) ; J83-B-4B21
(ucs-set-char #x6CD6 ?$(DF~(B) ; J90-D-467E
(ucs-set-char #x6CD6 ?$(GN`(B) ; C01-G-4E60
(ucs-set-char #x6CD6 ?$Acw(B) ; GB0-A-6377
(ucs-set-char #x6CD7 ?$(C^_(B) ; KS0-C-5E5F
(ucs-set-char #x6CD7 ?$(GNU(B) ; C01-G-4E55
(ucs-set-char #x6CD7 ?$@]y(B) ; J78-@-5D79
(ucs-set-char #x6CD7 ?$Act(B) ; GB0-A-6374
(ucs-set-char #x6CD7 ?$B]y(B) ; J83-B-5D79
(ucs-set-char #x6CD8 ?$(I)j(B) ; C03-I-296A
(ucs-set-char #x6CD9 ?$(H'S(B) ; C02-H-2753
(ucs-set-char #x6CD9 ?$@^$(B) ; J78-@-5E24
(ucs-set-char #x6CD9 ?$B^$(B) ; J83-B-5E24
(ucs-set-char #x6CDA ?$(DG!(B) ; J90-D-4721
(ucs-set-char #x6CDA ?$(H+W(B) ; C02-H-2B57
(ucs-set-char #x6CDB ?$(C[r(B) ; KS0-C-5B72
(ucs-set-char #x6CDB ?$(GN[(B) ; C01-G-4E5B
(ucs-set-char #x6CDB ?$@^"(B) ; J78-@-5E22
(ucs-set-char #x6CDB ?$A7:(B) ; GB0-A-373A
(ucs-set-char #x6CDB ?$B^"(B) ; J83-B-5E22
(ucs-set-char #x6CDC ?$(DG"(B) ; J90-D-4722
(ucs-set-char #x6CDC ?$(GN_(B) ; C01-G-4E5F
(ucs-set-char #x6CDD ?$(H'a(B) ; C02-H-2761
(ucs-set-char #x6CDD ?$@]{(B) ; J78-@-5D7B
(ucs-set-char #x6CDD ?$B]{(B) ; J83-B-5D7B
(ucs-set-char #x6CDE ?$(H'f(B) ; C02-H-2766
(ucs-set-char #x6CDE ?$AE"(B) ; GB0-A-4522
(ucs-set-char #x6CDF ?$(I)e(B) ; C03-I-2965
(ucs-set-char #x6CE0 ?$(DG#(B) ; J90-D-4723
(ucs-set-char #x6CE0 ?$(GNa(B) ; C01-G-4E61
(ucs-set-char #x6CE0 ?$Acv(B) ; GB0-A-6376
(ucs-set-char #x6CE1 ?$(Cx\(B) ; KS0-C-785C
(ucs-set-char #x6CE1 ?$(GNZ(B) ; C01-G-4E5A
(ucs-set-char #x6CE1 ?$@K"(B) ; J78-@-4B22
(ucs-set-char #x6CE1 ?$AE](B) ; GB0-A-455D
(ucs-set-char #x6CE1 ?$BK"(B) ; J83-B-4B22
(ucs-set-char #x6CE2 ?$(Cwn(B) ; KS0-C-776E
(ucs-set-char #x6CE2 ?$(GNL(B) ; C01-G-4E4C
(ucs-set-char #x6CE2 ?$@GH(B) ; J78-@-4748
(ucs-set-char #x6CE2 ?$A2((B) ; GB0-A-3228
(ucs-set-char #x6CE2 ?$BGH(B) ; J83-B-4748
(ucs-set-char #x6CE3 ?$(Ckh(B) ; KS0-C-6B68
(ucs-set-char #x6CE3 ?$(GNB(B) ; C01-G-4E42
(ucs-set-char #x6CE3 ?$@5c(B) ; J78-@-3563
(ucs-set-char #x6CE3 ?$AF|(B) ; GB0-A-467C
(ucs-set-char #x6CE3 ?$B5c(B) ; J83-B-3563
(ucs-set-char #x6CE4 ?$(I)i(B) ; C03-I-2969
(ucs-set-char #x6CE5 ?$(CRz(B) ; KS0-C-527A
(ucs-set-char #x6CE5 ?$(GNG(B) ; C01-G-4E47
(ucs-set-char #x6CE5 ?$@E%(B) ; J78-@-4525
(ucs-set-char #x6CE5 ?$AD`(B) ; GB0-A-4460
(ucs-set-char #x6CE5 ?$BE%(B) ; J83-B-4525
(ucs-set-char #x6CE6 ?$(J&{(B) ; C04-J-267B
(ucs-set-char #x6CE7 ?$(DG$(B) ; J90-D-4724
(ucs-set-char #x6CE7 ?$(H'W(B) ; C02-H-2757
(ucs-set-char #x6CE8 ?$(Cq<(B) ; KS0-C-713C
(ucs-set-char #x6CE8 ?$(GNC(B) ; C01-G-4E43
(ucs-set-char #x6CE8 ?$@Cm(B) ; J78-@-436D
(ucs-set-char #x6CE8 ?$AW"(B) ; GB0-A-5722
(ucs-set-char #x6CE8 ?$BCm(B) ; J83-B-436D
(ucs-set-char #x6CE9 ?$(DG%(B) ; J90-D-4725
(ucs-set-char #x6CE9 ?$(H'n(B) ; C02-H-276E
(ucs-set-char #x6CEA ?$(I)g(B) ; C03-I-2967
(ucs-set-char #x6CEA ?$@^%(B) ; J78-@-5E25
(ucs-set-char #x6CEA ?$A@a(B) ; GB0-A-4061
(ucs-set-char #x6CEA ?$B^%(B) ; J83-B-5E25
(ucs-set-char #x6CEB ?$(CzZ(B) ; KS0-C-7A5A
(ucs-set-char #x6CEB ?$(DG&(B) ; J90-D-4726
(ucs-set-char #x6CEB ?$(H'Q(B) ; C02-H-2751
(ucs-set-char #x6CEB ?$Acy(B) ; GB0-A-6379
(ucs-set-char #x6CEC ?$(DG'(B) ; J90-D-4727
(ucs-set-char #x6CEC ?$(H'P(B) ; C02-H-2750
(ucs-set-char #x6CED ?$(H'^(B) ; C02-H-275E
(ucs-set-char #x6CEE ?$(CZj(B) ; KS0-C-5A6A
(ucs-set-char #x6CEE ?$(DG((B) ; J90-D-4728
(ucs-set-char #x6CEE ?$(H'R(B) ; C02-H-2752
(ucs-set-char #x6CEE ?$Acz(B) ; GB0-A-637A
(ucs-set-char #x6CEF ?$(CZF(B) ; KS0-C-5A46
(ucs-set-char #x6CEF ?$(GN^(B) ; C01-G-4E5E
(ucs-set-char #x6CEF ?$@^#(B) ; J78-@-5E23
(ucs-set-char #x6CEF ?$Ac}(B) ; GB0-A-637D
(ucs-set-char #x6CEF ?$B^#(B) ; J83-B-5E23
(ucs-set-char #x6CF0 ?$(CwA(B) ; KS0-C-7741
(ucs-set-char #x6CF0 ?$(GV9(B) ; C01-G-5639
(ucs-set-char #x6CF0 ?$@BY(B) ; J78-@-4259
(ucs-set-char #x6CF0 ?$AL)(B) ; GB0-A-4C29
(ucs-set-char #x6CF0 ?$BBY(B) ; J83-B-4259
(ucs-set-char #x6CF1 ?$(GNW(B) ; C01-G-4E57
(ucs-set-char #x6CF1 ?$@]v(B) ; J78-@-5D76
(ucs-set-char #x6CF1 ?$Acs(B) ; GB0-A-6373
(ucs-set-char #x6CF1 ?$B]v(B) ; J83-B-5D76
(ucs-set-char #x6CF2 ?$(DG)(B) ; J90-D-4729
(ucs-set-char #x6CF2 ?$(H'_(B) ; C02-H-275F
(ucs-set-char #x6CF3 ?$(Cg6(B) ; KS0-C-6736
(ucs-set-char #x6CF3 ?$(GND(B) ; C01-G-4E44
(ucs-set-char #x6CF3 ?$@1K(B) ; J78-@-314B
(ucs-set-char #x6CF3 ?$AS>(B) ; GB0-A-533E
(ucs-set-char #x6CF3 ?$B1K(B) ; J83-B-314B
(ucs-set-char #x6CF4 ?$(DG*(B) ; J90-D-472A
(ucs-set-char #x6CF4 ?$(I-O(B) ; C03-I-2D4F
(ucs-set-char #x6CF5 ?$(GR)(B) ; C01-G-5229
(ucs-set-char #x6CF5 ?$A1C(B) ; GB0-A-3143
(ucs-set-char #x6CF6 ?$Am4(B) ; GB0-A-6D34
(ucs-set-char #x6CF7 ?$Acq(B) ; GB0-A-6371
(ucs-set-char #x6CF8 ?$Acr(B) ; GB0-A-6372
(ucs-set-char #x6CF9 ?$(H'l(B) ; C02-H-276C
(ucs-set-char #x6CFA ?$Acx(B) ; GB0-A-6378
(ucs-set-char #x6CFB ?$AP:(B) ; GB0-A-503A
(ucs-set-char #x6CFC ?$AFC(B) ; GB0-A-4643
(ucs-set-char #x6CFD ?$ATs(B) ; GB0-A-5473
(ucs-set-char #x6CFE ?$Ac~(B) ; GB0-A-637E
(ucs-set-char #x6CFF ?$(I-F(B) ; C03-I-2D46
(ucs-set-char #x6D00 ?$(H+^(B) ; C02-H-2B5E
(ucs-set-char #x6D01 ?$(H+a(B) ; C02-H-2B61
(ucs-set-char #x6D01 ?$A=`(B) ; GB0-A-3D60
(ucs-set-char #x6D02 ?$(I-P(B) ; C03-I-2D50
(ucs-set-char #x6D03 ?$(H+d(B) ; C02-H-2B64
(ucs-set-char #x6D04 ?$(DG+(B) ; J90-D-472B
(ucs-set-char #x6D04 ?$(H+Y(B) ; C02-H-2B59
(ucs-set-char #x6D04 ?$Ad'(B) ; GB0-A-6427
(ucs-set-char #x6D05 ?$(I-H(B) ; C03-I-2D48
(ucs-set-char #x6D06 ?$(I-J(B) ; C03-I-2D4A
(ucs-set-char #x6D07 ?$(DG,(B) ; J90-D-472C
(ucs-set-char #x6D07 ?$(H+g(B) ; C02-H-2B67
(ucs-set-char #x6D07 ?$Ad&(B) ; GB0-A-6426
(ucs-set-char #x6D08 ?$(H+j(B) ; C02-H-2B6A
(ucs-set-char #x6D09 ?$(H+l(B) ; C02-H-2B6C
(ucs-set-char #x6D0A ?$(DG-(B) ; J90-D-472D
(ucs-set-char #x6D0A ?$(H+V(B) ; C02-H-2B56
(ucs-set-char #x6D0B ?$(CeG(B) ; KS0-C-6547
(ucs-set-char #x6D0B ?$(GQy(B) ; C01-G-5179
(ucs-set-char #x6D0B ?$@MN(B) ; J78-@-4D4E
(ucs-set-char #x6D0B ?$AQs(B) ; GB0-A-5173
(ucs-set-char #x6D0B ?$BMN(B) ; J83-B-4D4E
(ucs-set-char #x6D0C ?$(CV,(B) ; KS0-C-562C
(ucs-set-char #x6D0C ?$(GQ~(B) ; C01-G-517E
(ucs-set-char #x6D0C ?$@^0(B) ; J78-@-5E30
(ucs-set-char #x6D0C ?$Ad#(B) ; GB0-A-6423
(ucs-set-char #x6D0C ?$B^0(B) ; J83-B-5E30
(ucs-set-char #x6D0D ?$(H0,(B) ; C02-H-302C
(ucs-set-char #x6D0E ?$(DG.(B) ; J90-D-472E
(ucs-set-char #x6D0E ?$(GR0(B) ; C01-G-5230
(ucs-set-char #x6D0E ?$Ad)(B) ; GB0-A-6429
(ucs-set-char #x6D0F ?$(DG/(B) ; J90-D-472F
(ucs-set-char #x6D0F ?$(H+e(B) ; C02-H-2B65
(ucs-set-char #x6D10 ?$(H+m(B) ; C02-H-2B6D
(ucs-set-char #x6D11 ?$(C\G(B) ; KS0-C-5C47
(ucs-set-char #x6D11 ?$(DG0(B) ; J90-D-4730
(ucs-set-char #x6D11 ?$(H+](B) ; C02-H-2B5D
(ucs-set-char #x6D12 ?$(H+U(B) ; C02-H-2B55
(ucs-set-char #x6D12 ?$@^/(B) ; J78-@-5E2F
(ucs-set-char #x6D12 ?$AHw(B) ; GB0-A-4877
(ucs-set-char #x6D12 ?$B^/(B) ; J83-B-5E2F
(ucs-set-char #x6D13 ?$(DG1(B) ; J90-D-4731
(ucs-set-char #x6D13 ?$(I-I(B) ; C03-I-2D49
(ucs-set-char #x6D14 ?$(I-G(B) ; C03-I-2D47
(ucs-set-char #x6D15 ?$(I-M(B) ; C03-I-2D4D
(ucs-set-char #x6D16 ?$(H0G(B) ; C02-H-3047
(ucs-set-char #x6D17 ?$(Ca)(B) ; KS0-C-6129
(ucs-set-char #x6D17 ?$(GR#(B) ; C01-G-5223
(ucs-set-char #x6D17 ?$@@v(B) ; J78-@-4076
(ucs-set-char #x6D17 ?$AO4(B) ; GB0-A-4F34
(ucs-set-char #x6D17 ?$B@v(B) ; J83-B-4076
(ucs-set-char #x6D18 ?$(H+b(B) ; C02-H-2B62
(ucs-set-char #x6D19 ?$(Cb*(B) ; KS0-C-622A
(ucs-set-char #x6D19 ?$(H+Z(B) ; C02-H-2B5A
(ucs-set-char #x6D19 ?$@^,(B) ; J78-@-5E2C
(ucs-set-char #x6D19 ?$Ad((B) ; GB0-A-6428
(ucs-set-char #x6D19 ?$B^,(B) ; J83-B-5E2C
(ucs-set-char #x6D1A ?$(DG2(B) ; J90-D-4732
(ucs-set-char #x6D1A ?$(H+\(B) ; C02-H-2B5C
(ucs-set-char #x6D1A ?$Ad.(B) ; GB0-A-642E
(ucs-set-char #x6D1B ?$(CU&(B) ; KS0-C-5526
(ucs-set-char #x6D1B ?$(GR((B) ; C01-G-5228
(ucs-set-char #x6D1B ?$@Ml(B) ; J78-@-4D6C
(ucs-set-char #x6D1B ?$ABe(B) ; GB0-A-4265
(ucs-set-char #x6D1B ?$BMl(B) ; J83-B-4D6C
(ucs-set-char #x6D1C ?$(I1z(B) ; C03-I-317A
(ucs-set-char #x6D1D ?$(H+_(B) ; C02-H-2B5F
(ucs-set-char #x6D1E ?$(CTW(B) ; KS0-C-5457
(ucs-set-char #x6D1E ?$(GR"(B) ; C01-G-5222
(ucs-set-char #x6D1E ?$@F6(B) ; J78-@-4636
(ucs-set-char #x6D1E ?$A64(B) ; GB0-A-3634
(ucs-set-char #x6D1E ?$BF6(B) ; J83-B-4636
(ucs-set-char #x6D1F ?$(H+R(B) ; C02-H-2B52
(ucs-set-char #x6D1F ?$@^&(B) ; J78-@-5E26
(ucs-set-char #x6D1F ?$B^&(B) ; J83-B-5E26
(ucs-set-char #x6D20 ?$(H+h(B) ; C02-H-2B68
(ucs-set-char #x6D21 ?$(I-K(B) ; C03-I-2D4B
(ucs-set-char #x6D22 ?$(H+k(B) ; C02-H-2B6B
(ucs-set-char #x6D23 ?$(I-E(B) ; C03-I-2D45
(ucs-set-char #x6D24 ?$(I-W(B) ; C03-I-2D57
(ucs-set-char #x6D25 ?$(CrP(B) ; KS0-C-7250
(ucs-set-char #x6D25 ?$(GQ}(B) ; C01-G-517D
(ucs-set-char #x6D25 ?$@DE(B) ; J78-@-4445
(ucs-set-char #x6D25 ?$A=r(B) ; GB0-A-3D72
(ucs-set-char #x6D25 ?$BDE(B) ; J83-B-4445
(ucs-set-char #x6D26 ?$(DG3(B) ; J90-D-4733
(ucs-set-char #x6D26 ?$(I-S(B) ; C03-I-2D53
(ucs-set-char #x6D27 ?$(Cj{(B) ; KS0-C-6A7B
(ucs-set-char #x6D27 ?$(DG4(B) ; J90-D-4734
(ucs-set-char #x6D27 ?$(GR+(B) ; C01-G-522B
(ucs-set-char #x6D27 ?$Ad"(B) ; GB0-A-6422
(ucs-set-char #x6D28 ?$(DG5(B) ; J90-D-4735
(ucs-set-char #x6D28 ?$(H+O(B) ; C02-H-2B4F
(ucs-set-char #x6D29 ?$(C`](B) ; KS0-C-605D
(ucs-set-char #x6D29 ?$(GR-(B) ; C01-G-522D
(ucs-set-char #x6D29 ?$@1L(B) ; J78-@-314C
(ucs-set-char #x6D29 ?$B1L(B) ; J83-B-314C
(ucs-set-char #x6D2A ?$(C{s(B) ; KS0-C-7B73
(ucs-set-char #x6D2A ?$(GQ{(B) ; C01-G-517B
(ucs-set-char #x6D2A ?$@9?(B) ; J78-@-393F
(ucs-set-char #x6D2A ?$A:i(B) ; GB0-A-3A69
(ucs-set-char #x6D2A ?$B9?(B) ; J83-B-393F
(ucs-set-char #x6D2B ?$(GR1(B) ; C01-G-5231
(ucs-set-char #x6D2B ?$@^)(B) ; J78-@-5E29
(ucs-set-char #x6D2B ?$Ad*(B) ; GB0-A-642A
(ucs-set-char #x6D2B ?$B^)(B) ; J83-B-5E29
(ucs-set-char #x6D2C ?$(H+i(B) ; C02-H-2B69
(ucs-set-char #x6D2D ?$(H+Q(B) ; C02-H-2B51
(ucs-set-char #x6D2E ?$(DG7(B) ; J90-D-4737
(ucs-set-char #x6D2E ?$(GR.(B) ; C01-G-522E
(ucs-set-char #x6D2E ?$Ad,(B) ; GB0-A-642C
(ucs-set-char #x6D2F ?$(DG8(B) ; J90-D-4738
(ucs-set-char #x6D2F ?$(H0A(B) ; C02-H-3041
(ucs-set-char #x6D30 ?$(H'h(B) ; C02-H-2768
(ucs-set-char #x6D31 ?$(DG9(B) ; J90-D-4739
(ucs-set-char #x6D31 ?$(GR!(B) ; C01-G-5221
(ucs-set-char #x6D31 ?$A6}(B) ; GB0-A-367D
(ucs-set-char #x6D32 ?$(Cq=(B) ; KS0-C-713D
(ucs-set-char #x6D32 ?$(GQz(B) ; C01-G-517A
(ucs-set-char #x6D32 ?$@='(B) ; J78-@-3D27
(ucs-set-char #x6D32 ?$AV^(B) ; GB0-A-565E
(ucs-set-char #x6D32 ?$B='(B) ; J83-B-3D27
(ucs-set-char #x6D33 ?$(H+X(B) ; C02-H-2B58
(ucs-set-char #x6D33 ?$@^.(B) ; J78-@-5E2E
(ucs-set-char #x6D33 ?$Ad2(B) ; GB0-A-6432
(ucs-set-char #x6D33 ?$B^.(B) ; J83-B-5E2E
(ucs-set-char #x6D34 ?$(H+P(B) ; C02-H-2B50
(ucs-set-char #x6D34 ?$(I6u(B) ; C03-I-3675
(ucs-set-char #x6D35 ?$(Cbg(B) ; KS0-C-6267
(ucs-set-char #x6D35 ?$(GR/(B) ; C01-G-522F
(ucs-set-char #x6D35 ?$@^-(B) ; J78-@-5E2D
(ucs-set-char #x6D35 ?$Ad-(B) ; GB0-A-642D
(ucs-set-char #x6D35 ?$B^-(B) ; J83-B-5E2D
(ucs-set-char #x6D36 ?$(C}W(B) ; KS0-C-7D57
(ucs-set-char #x6D36 ?$(GR'(B) ; C01-G-5227
(ucs-set-char #x6D36 ?$@^((B) ; J78-@-5E28
(ucs-set-char #x6D36 ?$B^((B) ; J83-B-5E28
(ucs-set-char #x6D37 ?$(H+c(B) ; C02-H-2B63
(ucs-set-char #x6D38 ?$(CNH(B) ; KS0-C-4E48
(ucs-set-char #x6D38 ?$(GR,(B) ; C01-G-522C
(ucs-set-char #x6D38 ?$@^+(B) ; J78-@-5E2B
(ucs-set-char #x6D38 ?$B^+(B) ; J83-B-5E2B
(ucs-set-char #x6D39 ?$(Cj7(B) ; KS0-C-6A37
(ucs-set-char #x6D39 ?$(DG:(B) ; J90-D-473A
(ucs-set-char #x6D39 ?$(GR*(B) ; C01-G-522A
(ucs-set-char #x6D39 ?$Ad!(B) ; GB0-A-6421
(ucs-set-char #x6D3A ?$(H+[(B) ; C02-H-2B5B
(ucs-set-char #x6D3B ?$(C|@(B) ; KS0-C-7C40
(ucs-set-char #x6D3B ?$(GR$(B) ; C01-G-5224
(ucs-set-char #x6D3B ?$@3h(B) ; J78-@-3368
(ucs-set-char #x6D3B ?$A;n(B) ; GB0-A-3B6E
(ucs-set-char #x6D3B ?$B3h(B) ; J83-B-3368
(ucs-set-char #x6D3C ?$(DG;(B) ; J90-D-473B
(ucs-set-char #x6D3C ?$(H+S(B) ; C02-H-2B53
(ucs-set-char #x6D3C ?$AM](B) ; GB0-A-4D5D
(ucs-set-char #x6D3D ?$(C}g(B) ; KS0-C-7D67
(ucs-set-char #x6D3D ?$(GR%(B) ; C01-G-5225
(ucs-set-char #x6D3D ?$@^*(B) ; J78-@-5E2A
(ucs-set-char #x6D3D ?$AG"(B) ; GB0-A-4722
(ucs-set-char #x6D3D ?$B^*(B) ; J83-B-5E2A
(ucs-set-char #x6D3E ?$(Cwo(B) ; KS0-C-776F
(ucs-set-char #x6D3E ?$(GR&(B) ; C01-G-5226
(ucs-set-char #x6D3E ?$(L2B(B) ; C06-L-3242
(ucs-set-char #x6D3E ?$@GI(B) ; J78-@-4749
(ucs-set-char #x6D3E ?$AEI(B) ; GB0-A-4549
(ucs-set-char #x6D3E ?$BGI(B) ; J83-B-4749
(ucs-set-char #x6D3F ?$(DG<(B) ; J90-D-473C
(ucs-set-char #x6D3F ?$(H+T(B) ; C02-H-2B54
(ucs-set-char #x6D40 ?$(H+f(B) ; C02-H-2B66
(ucs-set-char #x6D41 ?$(CW5(B) ; KS0-C-5735
(ucs-set-char #x6D41 ?$(GQ|(B) ; C01-G-517C
(ucs-set-char #x6D41 ?$(J-p(B) ; C04-J-2D70
(ucs-set-char #x6D41 ?$@N.(B) ; J78-@-4E2E
(ucs-set-char #x6D41 ?$AAw(B) ; GB0-A-4177
(ucs-set-char #x6D41 ?$BN.(B) ; J83-B-4E2E
(ucs-set-char #x6D42 ?$(H+`(B) ; C02-H-2B60
(ucs-set-char #x6D43 ?$(J*!(B) ; C04-J-2A21
(ucs-set-char #x6D43 ?$Ad$(B) ; GB0-A-6424
(ucs-set-char #x6D44 ?$(I-U(B) ; C03-I-2D55
(ucs-set-char #x6D44 ?$@>t(B) ; J78-@-3E74
(ucs-set-char #x6D44 ?$B>t(B) ; J83-B-3E74
(ucs-set-char #x6D45 ?$(I-Q(B) ; C03-I-2D51
(ucs-set-char #x6D45 ?$@@u(B) ; J78-@-4075
(ucs-set-char #x6D45 ?$AG3(B) ; GB0-A-4733
(ucs-set-char #x6D45 ?$B@u(B) ; J83-B-4075
(ucs-set-char #x6D46 ?$A=,(B) ; GB0-A-3D2C
(ucs-set-char #x6D47 ?$A==(B) ; GB0-A-3D3D
(ucs-set-char #x6D48 ?$Ad%(B) ; GB0-A-6425
(ucs-set-char #x6D4A ?$AWG(B) ; GB0-A-5747
(ucs-set-char #x6D4B ?$A2b(B) ; GB0-A-3262
(ucs-set-char #x6D4D ?$Ad+(B) ; GB0-A-642B
(ucs-set-char #x6D4E ?$A<C(B) ; GB0-A-3C43
(ucs-set-char #x6D4F ?$Ad/(B) ; GB0-A-642F
(ucs-set-char #x6D51 ?$A;k(B) ; GB0-A-3B6B
(ucs-set-char #x6D52 ?$Ad0(B) ; GB0-A-6430
(ucs-set-char #x6D53 ?$AE((B) ; GB0-A-4528
(ucs-set-char #x6D54 ?$Ad1(B) ; GB0-A-6431
(ucs-set-char #x6D56 ?$(I1w(B) ; C03-I-3177
(ucs-set-char #x6D57 ?$(DG=(B) ; J90-D-473D
(ucs-set-char #x6D57 ?$(I1s(B) ; C03-I-3173
(ucs-set-char #x6D58 ?$(H0/(B) ; C02-H-302F
(ucs-set-char #x6D59 ?$(Co:(B) ; KS0-C-6F3A
(ucs-set-char #x6D59 ?$(GVA(B) ; C01-G-5641
(ucs-set-char #x6D59 ?$@^6(B) ; J78-@-5E36
(ucs-set-char #x6D59 ?$AUc(B) ; GB0-A-5563
(ucs-set-char #x6D59 ?$B^6(B) ; J83-B-5E36
(ucs-set-char #x6D5A ?$(Cq](B) ; KS0-C-715D
(ucs-set-char #x6D5A ?$(GVF(B) ; C01-G-5646
(ucs-set-char #x6D5A ?$@^4(B) ; J78-@-5E34
(ucs-set-char #x6D5A ?$A?#(B) ; GB0-A-3F23
(ucs-set-char #x6D5A ?$B^4(B) ; J83-B-5E34
(ucs-set-char #x6D5B ?$(I1y(B) ; C03-I-3179
(ucs-set-char #x6D5C ?$(C^3(B) ; KS0-C-5E33
(ucs-set-char #x6D5C ?$(I2&(B) ; C03-I-3226
(ucs-set-char #x6D5C ?$@IM(B) ; J78-@-494D
(ucs-set-char #x6D5C ?$Ad:(B) ; GB0-A-643A
(ucs-set-char #x6D5C ?$BIM(B) ; J83-B-494D
(ucs-set-char #x6D5D ?$(I1v(B) ; C03-I-3176
(ucs-set-char #x6D5E ?$(DG>(B) ; J90-D-473E
(ucs-set-char #x6D5E ?$(H08(B) ; C02-H-3038
(ucs-set-char #x6D5E ?$Ad7(B) ; GB0-A-6437
(ucs-set-char #x6D5F ?$(DG?(B) ; J90-D-473F
(ucs-set-char #x6D5F ?$(H0>(B) ; C02-H-303E
(ucs-set-char #x6D60 ?$(H0:(B) ; C02-H-303A
(ucs-set-char #x6D60 ?$Ad;(B) ; GB0-A-643B
(ucs-set-char #x6D61 ?$(DG@(B) ; J90-D-4740
(ucs-set-char #x6D61 ?$(H0-(B) ; C02-H-302D
(ucs-set-char #x6D62 ?$(H00(B) ; C02-H-3030
(ucs-set-char #x6D63 ?$(ChK(B) ; KS0-C-684B
(ucs-set-char #x6D63 ?$(H0)(B) ; C02-H-3029
(ucs-set-char #x6D63 ?$@^1(B) ; J78-@-5E31
(ucs-set-char #x6D63 ?$Ad=(B) ; GB0-A-643D
(ucs-set-char #x6D63 ?$B^1(B) ; J83-B-5E31
(ucs-set-char #x6D64 ?$(H0*(B) ; C02-H-302A
(ucs-set-char #x6D64 ?$@^3(B) ; J78-@-5E33
(ucs-set-char #x6D64 ?$B^3(B) ; J83-B-5E33
(ucs-set-char #x6D65 ?$(DGA(B) ; J90-D-4741
(ucs-set-char #x6D65 ?$(GVM(B) ; C01-G-564D
(ucs-set-char #x6D66 ?$(Cx](B) ; KS0-C-785D
(ucs-set-char #x6D66 ?$(GV>(B) ; C01-G-563E
(ucs-set-char #x6D66 ?$@1:(B) ; J78-@-313A
(ucs-set-char #x6D66 ?$AFV(B) ; GB0-A-4656
(ucs-set-char #x6D66 ?$B1:(B) ; J83-B-313A
(ucs-set-char #x6D67 ?$(DGB(B) ; J90-D-4742
(ucs-set-char #x6D67 ?$(H09(B) ; C02-H-3039
(ucs-set-char #x6D68 ?$(H0B(B) ; C02-H-3042
(ucs-set-char #x6D69 ?$(C{G(B) ; KS0-C-7B47
(ucs-set-char #x6D69 ?$(GVH(B) ; C01-G-5648
(ucs-set-char #x6D69 ?$(L9-(B) ; C06-L-392D
(ucs-set-char #x6D69 ?$@9@(B) ; J78-@-3940
(ucs-set-char #x6D69 ?$A:F(B) ; GB0-A-3A46
(ucs-set-char #x6D69 ?$B9@(B) ; J83-B-3940
(ucs-set-char #x6D6A ?$(CUH(B) ; KS0-C-5548
(ucs-set-char #x6D6A ?$(GV:(B) ; C01-G-563A
(ucs-set-char #x6D6A ?$@O2(B) ; J78-@-4F32
(ucs-set-char #x6D6A ?$A@K(B) ; GB0-A-404B
(ucs-set-char #x6D6A ?$BO2(B) ; J83-B-4F32
(ucs-set-char #x6D6B ?$(I1o(B) ; C03-I-316F
(ucs-set-char #x6D6C ?$(CW_(B) ; KS0-C-575F
(ucs-set-char #x6D6C ?$(GVC(B) ; C01-G-5643
(ucs-set-char #x6D6C ?$@3=(B) ; J78-@-333D
(ucs-set-char #x6D6C ?$B3=(B) ; J83-B-333D
(ucs-set-char #x6D6D ?$(H01(B) ; C02-H-3031
(ucs-set-char #x6D6E ?$(C])(B) ; KS0-C-5D29
(ucs-set-char #x6D6E ?$(GVE(B) ; C01-G-5645
(ucs-set-char #x6D6E ?$@Ib(B) ; J78-@-4962
(ucs-set-char #x6D6E ?$A8!(B) ; GB0-A-3821
(ucs-set-char #x6D6E ?$BIb(B) ; J83-B-4962
(ucs-set-char #x6D6F ?$(DGC(B) ; J90-D-4743
(ucs-set-char #x6D6F ?$(H02(B) ; C02-H-3032
(ucs-set-char #x6D6F ?$Ad4(B) ; GB0-A-6434
(ucs-set-char #x6D70 ?$(DGD(B) ; J90-D-4744
(ucs-set-char #x6D70 ?$(H0<(B) ; C02-H-303C
(ucs-set-char #x6D71 ?$(I2"(B) ; C03-I-3222
(ucs-set-char #x6D72 ?$(I2%(B) ; C03-I-3225
(ucs-set-char #x6D73 ?$(I1r(B) ; C03-I-3172
(ucs-set-char #x6D74 ?$(Ci1(B) ; KS0-C-6931
(ucs-set-char #x6D74 ?$(GVG(B) ; C01-G-5647
(ucs-set-char #x6D74 ?$@Ma(B) ; J78-@-4D61
(ucs-set-char #x6D74 ?$AT!(B) ; GB0-A-5421
(ucs-set-char #x6D74 ?$BMa(B) ; J83-B-4D61
(ucs-set-char #x6D75 ?$(H0K(B) ; C02-H-304B
(ucs-set-char #x6D76 ?$(H0+(B) ; C02-H-302B
(ucs-set-char #x6D77 ?$(Cz-(B) ; KS0-C-7A2D
(ucs-set-char #x6D77 ?$(GV@(B) ; C01-G-5640
(ucs-set-char #x6D77 ?$(J*%(B) ; C04-J-2A25
(ucs-set-char #x6D77 ?$@3$(B) ; J78-@-3324
(ucs-set-char #x6D77 ?$A:#(B) ; GB0-A-3A23
(ucs-set-char #x6D77 ?$B3$(B) ; J83-B-3324
(ucs-set-char #x6D78 ?$(CvY(B) ; KS0-C-7659
(ucs-set-char #x6D78 ?$(GV?(B) ; C01-G-563F
(ucs-set-char #x6D78 ?$(L8t(B) ; C06-L-3874
(ucs-set-char #x6D78 ?$@?;(B) ; J78-@-3F3B
(ucs-set-char #x6D78 ?$A=~(B) ; GB0-A-3D7E
(ucs-set-char #x6D78 ?$B?;(B) ; J83-B-3F3B
(ucs-set-char #x6D79 ?$(Czt(B) ; KS0-C-7A74
(ucs-set-char #x6D79 ?$(GVK(B) ; C01-G-564B
(ucs-set-char #x6D79 ?$@^5(B) ; J78-@-5E35
(ucs-set-char #x6D79 ?$B^5(B) ; J83-B-5E35
(ucs-set-char #x6D7A ?$(H0((B) ; C02-H-3028
(ucs-set-char #x6D7B ?$(H0I(B) ; C02-H-3049
(ucs-set-char #x6D7C ?$(DGE(B) ; J90-D-4745
(ucs-set-char #x6D7C ?$(H0=(B) ; C02-H-303D
(ucs-set-char #x6D7C ?$Ad<(B) ; GB0-A-643C
(ucs-set-char #x6D7D ?$(H0J(B) ; C02-H-304A
(ucs-set-char #x6D7E ?$(H0D(B) ; C02-H-3044
(ucs-set-char #x6D7F ?$(Cx*(B) ; KS0-C-782A
(ucs-set-char #x6D7F ?$(H06(B) ; C02-H-3036
(ucs-set-char #x6D80 ?$(H0E(B) ; C02-H-3045
(ucs-set-char #x6D81 ?$(I2!(B) ; C03-I-3221
(ucs-set-char #x6D82 ?$(DGF(B) ; J90-D-4746
(ucs-set-char #x6D82 ?$(H0?(B) ; C02-H-303F
(ucs-set-char #x6D82 ?$AM?(B) ; GB0-A-4D3F
(ucs-set-char #x6D83 ?$(H0H(B) ; C02-H-3048
(ucs-set-char #x6D84 ?$(H0F(B) ; C02-H-3046
(ucs-set-char #x6D85 ?$(Cfn(B) ; KS0-C-666E
(ucs-set-char #x6D85 ?$(GVL(B) ; C01-G-564C
(ucs-set-char #x6D85 ?$@^:(B) ; J78-@-5E3A
(ucs-set-char #x6D85 ?$ADy(B) ; GB0-A-4479
(ucs-set-char #x6D85 ?$B^:(B) ; J83-B-5E3A
(ucs-set-char #x6D86 ?$(H07(B) ; C02-H-3037
(ucs-set-char #x6D87 ?$(CL\(B) ; KS0-C-4C5C
(ucs-set-char #x6D87 ?$(DGG(B) ; J90-D-4747
(ucs-set-char #x6D87 ?$(GV=(B) ; C01-G-563D
(ucs-set-char #x6D88 ?$(Ca<(B) ; KS0-C-613C
(ucs-set-char #x6D88 ?$(GV<(B) ; C01-G-563C
(ucs-set-char #x6D88 ?$@>C(B) ; J78-@-3E43
(ucs-set-char #x6D88 ?$AO{(B) ; GB0-A-4F7B
(ucs-set-char #x6D88 ?$B>C(B) ; J83-B-3E43
(ucs-set-char #x6D89 ?$(C`o(B) ; KS0-C-606F
(ucs-set-char #x6D89 ?$(GVD(B) ; C01-G-5644
(ucs-set-char #x6D89 ?$AIf(B) ; GB0-A-4966
(ucs-set-char #x6D8A ?$(GVJ(B) ; C01-G-564A
(ucs-set-char #x6D8B ?$(H0C(B) ; C02-H-3043
(ucs-set-char #x6D8C ?$(Ci?(B) ; KS0-C-693F
(ucs-set-char #x6D8C ?$(GVI(B) ; C01-G-5649
(ucs-set-char #x6D8C ?$@M0(B) ; J78-@-4D30
(ucs-set-char #x6D8C ?$AS?(B) ; GB0-A-533F
(ucs-set-char #x6D8C ?$BM0(B) ; J83-B-4D30
(ucs-set-char #x6D8D ?$(C|}(B) ; KS0-C-7C7D
(ucs-set-char #x6D8D ?$(H04(B) ; C02-H-3034
(ucs-set-char #x6D8E ?$(CfN(B) ; KS0-C-664E
(ucs-set-char #x6D8E ?$(G[H(B) ; C01-G-5B48
(ucs-set-char #x6D8E ?$@^7(B) ; J78-@-5E37
(ucs-set-char #x6D8E ?$AOQ(B) ; GB0-A-4F51
(ucs-set-char #x6D8E ?$B^7(B) ; J83-B-5E37
(ucs-set-char #x6D8F ?$(I1x(B) ; C03-I-3178
(ucs-set-char #x6D90 ?$(H0L(B) ; C02-H-304C
(ucs-set-char #x6D91 ?$(CaW(B) ; KS0-C-6157
(ucs-set-char #x6D91 ?$(DGH(B) ; J90-D-4748
(ucs-set-char #x6D91 ?$(H03(B) ; C02-H-3033
(ucs-set-char #x6D91 ?$Ad3(B) ; GB0-A-6433
(ucs-set-char #x6D92 ?$(DGI(B) ; J90-D-4749
(ucs-set-char #x6D92 ?$(H0.(B) ; C02-H-302E
(ucs-set-char #x6D93 ?$(CfO(B) ; KS0-C-664F
(ucs-set-char #x6D93 ?$(GVB(B) ; C01-G-5642
(ucs-set-char #x6D93 ?$@^2(B) ; J78-@-5E32
(ucs-set-char #x6D93 ?$Ad8(B) ; GB0-A-6438
(ucs-set-char #x6D93 ?$B^2(B) ; J83-B-5E32
(ucs-set-char #x6D94 ?$(DGJ(B) ; J90-D-474A
(ucs-set-char #x6D94 ?$(GVN(B) ; C01-G-564E
(ucs-set-char #x6D94 ?$Ad9(B) ; GB0-A-6439
(ucs-set-char #x6D95 ?$(Ctq(B) ; KS0-C-7471
(ucs-set-char #x6D95 ?$(GV;(B) ; C01-G-563B
(ucs-set-char #x6D95 ?$@^8(B) ; J78-@-5E38
(ucs-set-char #x6D95 ?$ALi(B) ; GB0-A-4C69
(ucs-set-char #x6D95 ?$B^8(B) ; J83-B-5E38
(ucs-set-char #x6D96 ?$(DGK(B) ; J90-D-474B
(ucs-set-char #x6D96 ?$(I2'(B) ; C03-I-3227
(ucs-set-char #x6D97 ?$(DGL(B) ; J90-D-474C
(ucs-set-char #x6D97 ?$(H0;(B) ; C02-H-303B
(ucs-set-char #x6D98 ?$(DGM(B) ; J90-D-474D
(ucs-set-char #x6D98 ?$(H0@(B) ; C02-H-3040
(ucs-set-char #x6D99 ?$(I1}(B) ; C03-I-317D
(ucs-set-char #x6D99 ?$@N^(B) ; J78-@-4E5E
(ucs-set-char #x6D99 ?$BN^(B) ; J83-B-4E5E
(ucs-set-char #x6D9A ?$(I1{(B) ; C03-I-317B
(ucs-set-char #x6D9B ?$(I1|(B) ; C03-I-317C
(ucs-set-char #x6D9B ?$@^9(B) ; J78-@-5E39
(ucs-set-char #x6D9B ?$ALN(B) ; GB0-A-4C4E
(ucs-set-char #x6D9B ?$BEs(B) ; J83-B-4573
(ucs-set-char #x6D9C ?$BFB(B) ; J83-B-4642
(ucs-set-char #x6D9D ?$A@T(B) ; GB0-A-4054
(ucs-set-char #x6D9E ?$Ad5(B) ; GB0-A-6435
(ucs-set-char #x6D9F ?$AA0(B) ; GB0-A-4130
(ucs-set-char #x6DA0 ?$Ad6(B) ; GB0-A-6436
(ucs-set-char #x6DA1 ?$ANP(B) ; GB0-A-4E50
(ucs-set-char #x6DA3 ?$A;A(B) ; GB0-A-3B41
(ucs-set-char #x6DA4 ?$A5S(B) ; GB0-A-3553
(ucs-set-char #x6DA6 ?$AHs(B) ; GB0-A-4873
(ucs-set-char #x6DA7 ?$A='(B) ; GB0-A-3D27
(ucs-set-char #x6DA8 ?$AUG(B) ; GB0-A-5547
(ucs-set-char #x6DA9 ?$AI,(B) ; GB0-A-492C
(ucs-set-char #x6DAA ?$(DGN(B) ; J90-D-474E
(ucs-set-char #x6DAA ?$(G[j(B) ; C01-G-5B6A
(ucs-set-char #x6DAA ?$A8"(B) ; GB0-A-3822
(ucs-set-char #x6DAB ?$(H6E(B) ; C02-H-3645
(ucs-set-char #x6DAB ?$AdJ(B) ; GB0-A-644A
(ucs-set-char #x6DAC ?$(DGO(B) ; J90-D-474F
(ucs-set-char #x6DAC ?$(H6I(B) ; C02-H-3649
(ucs-set-char #x6DAD ?$(I6o(B) ; C03-I-366F
(ucs-set-char #x6DAE ?$(G[W(B) ; C01-G-5B57
(ucs-set-char #x6DAE ?$AdL(B) ; GB0-A-644C
(ucs-set-char #x6DAF ?$(Cds(B) ; KS0-C-6473
(ucs-set-char #x6DAF ?$(G[U(B) ; C01-G-5B55
(ucs-set-char #x6DAF ?$@36(B) ; J78-@-3336
(ucs-set-char #x6DAF ?$AQD(B) ; GB0-A-5144
(ucs-set-char #x6DAF ?$B36(B) ; J83-B-3336
(ucs-set-char #x6DB0 ?$(I6z(B) ; C03-I-367A
(ucs-set-char #x6DB1 ?$(I7!(B) ; C03-I-3721
(ucs-set-char #x6DB2 ?$(Cd{(B) ; KS0-C-647B
(ucs-set-char #x6DB2 ?$(G[L(B) ; C01-G-5B4C
(ucs-set-char #x6DB2 ?$@1U(B) ; J78-@-3155
(ucs-set-char #x6DB2 ?$AR:(B) ; GB0-A-523A
(ucs-set-char #x6DB2 ?$B1U(B) ; J83-B-3155
(ucs-set-char #x6DB3 ?$(H6G(B) ; C02-H-3647
(ucs-set-char #x6DB4 ?$(DGP(B) ; J90-D-4750
(ucs-set-char #x6DB4 ?$(H6F(B) ; C02-H-3646
(ucs-set-char #x6DB5 ?$(Cyd(B) ; KS0-C-7964
(ucs-set-char #x6DB5 ?$(G[`(B) ; C01-G-5B60
(ucs-set-char #x6DB5 ?$@^>(B) ; J78-@-5E3E
(ucs-set-char #x6DB5 ?$A:-(B) ; GB0-A-3A2D
(ucs-set-char #x6DB5 ?$B^>(B) ; J83-B-5E3E
(ucs-set-char #x6DB6 ?$(I<P(B) ; C03-I-3C50
(ucs-set-char #x6DB7 ?$(DGQ(B) ; J90-D-4751
(ucs-set-char #x6DB7 ?$(H6L(B) ; C02-H-364C
(ucs-set-char #x6DB8 ?$(G[Z(B) ; C01-G-5B5A
(ucs-set-char #x6DB8 ?$@^A(B) ; J78-@-5E41
(ucs-set-char #x6DB8 ?$A:T(B) ; GB0-A-3A54
(ucs-set-char #x6DB8 ?$B^A(B) ; J83-B-5E41
(ucs-set-char #x6DB9 ?$(DGR(B) ; J90-D-4752
(ucs-set-char #x6DB9 ?$(I6r(B) ; C03-I-3672
(ucs-set-char #x6DBA ?$(H6^(B) ; C02-H-365E
(ucs-set-char #x6DBB ?$(H6j(B) ; C02-H-366A
(ucs-set-char #x6DBC ?$(G[I(B) ; C01-G-5B49
(ucs-set-char #x6DBC ?$@NC(B) ; J78-@-4E43
(ucs-set-char #x6DBC ?$BNC(B) ; J83-B-4E43
(ucs-set-char #x6DBD ?$(DGS(B) ; J90-D-4753
(ucs-set-char #x6DBD ?$(H6[(B) ; C02-H-365B
(ucs-set-char #x6DBE ?$(H6T(B) ; C02-H-3654
(ucs-set-char #x6DBF ?$(DGT(B) ; J90-D-4754
(ucs-set-char #x6DBF ?$(G[l(B) ; C01-G-5B6C
(ucs-set-char #x6DBF ?$AdC(B) ; GB0-A-6443
(ucs-set-char #x6DC0 ?$(Coc(B) ; KS0-C-6F63
(ucs-set-char #x6DC0 ?$(H6D(B) ; C02-H-3644
(ucs-set-char #x6DC0 ?$@Md(B) ; J78-@-4D64
(ucs-set-char #x6DC0 ?$A5m(B) ; GB0-A-356D
(ucs-set-char #x6DC0 ?$BMd(B) ; J83-B-4D64
(ucs-set-char #x6DC1 ?$(I6j(B) ; C03-I-366A
(ucs-set-char #x6DC2 ?$(H6`(B) ; C02-H-3660
(ucs-set-char #x6DC3 ?$(COn(B) ; KS0-C-4F6E
(ucs-set-char #x6DC3 ?$(I6k(B) ; C03-I-366B
(ucs-set-char #x6DC4 ?$(Cv>(B) ; KS0-C-763E
(ucs-set-char #x6DC4 ?$(DGU(B) ; J90-D-4755
(ucs-set-char #x6DC4 ?$(G[i(B) ; C01-G-5B69
(ucs-set-char #x6DC4 ?$AWM(B) ; GB0-A-574D
(ucs-set-char #x6DC5 ?$(C`2(B) ; KS0-C-6032
(ucs-set-char #x6DC5 ?$(G[](B) ; C01-G-5B5D
(ucs-set-char #x6DC5 ?$@^H(B) ; J78-@-5E48
(ucs-set-char #x6DC5 ?$Ad@(B) ; GB0-A-6440
(ucs-set-char #x6DC5 ?$B^H(B) ; J83-B-5E48
(ucs-set-char #x6DC6 ?$(C|~(B) ; KS0-C-7C7E
(ucs-set-char #x6DC6 ?$(G[h(B) ; C01-G-5B68
(ucs-set-char #x6DC6 ?$@^B(B) ; J78-@-5E42
(ucs-set-char #x6DC6 ?$AO}(B) ; GB0-A-4F7D
(ucs-set-char #x6DC6 ?$B^B(B) ; J83-B-5E42
(ucs-set-char #x6DC7 ?$(CQ+(B) ; KS0-C-512B
(ucs-set-char #x6DC7 ?$(G[S(B) ; C01-G-5B53
(ucs-set-char #x6DC7 ?$@^?(B) ; J78-@-5E3F
(ucs-set-char #x6DC7 ?$Ad?(B) ; GB0-A-643F
(ucs-set-char #x6DC7 ?$B^?(B) ; J83-B-5E3F
(ucs-set-char #x6DC8 ?$(DGV(B) ; J90-D-4756
(ucs-set-char #x6DC8 ?$(H6P(B) ; C02-H-3650
(ucs-set-char #x6DC9 ?$(H6b(B) ; C02-H-3662
(ucs-set-char #x6DCA ?$(DGW(B) ; J90-D-4757
(ucs-set-char #x6DCA ?$(H6Z(B) ; C02-H-365A
(ucs-set-char #x6DCB ?$(CWz(B) ; KS0-C-577A
(ucs-set-char #x6DCB ?$(G[T(B) ; C01-G-5B54
(ucs-set-char #x6DCB ?$@NT(B) ; J78-@-4E54
(ucs-set-char #x6DCB ?$AA\(B) ; GB0-A-415C
(ucs-set-char #x6DCB ?$BNT(B) ; J83-B-4E54
(ucs-set-char #x6DCC ?$(G[N(B) ; C01-G-5B4E
(ucs-set-char #x6DCC ?$@^E(B) ; J78-@-5E45
(ucs-set-char #x6DCC ?$ALJ(B) ; GB0-A-4C4A
(ucs-set-char #x6DCC ?$B^E(B) ; J83-B-5E45
(ucs-set-char #x6DCD ?$(H6h(B) ; C02-H-3668
(ucs-set-char #x6DCE ?$(DGX(B) ; J90-D-4758
(ucs-set-char #x6DCE ?$(I6l(B) ; C03-I-366C
(ucs-set-char #x6DCF ?$(C{H(B) ; KS0-C-7B48
(ucs-set-char #x6DCF ?$(DGY(B) ; J90-D-4759
(ucs-set-char #x6DCF ?$(H6a(B) ; C02-H-3661
(ucs-set-char #x6DD0 ?$(H6c(B) ; C02-H-3663
(ucs-set-char #x6DD1 ?$(CbW(B) ; KS0-C-6257
(ucs-set-char #x6DD1 ?$(G[V(B) ; C01-G-5B56
(ucs-set-char #x6DD1 ?$@=J(B) ; J78-@-3D4A
(ucs-set-char #x6DD1 ?$AJg(B) ; GB0-A-4A67
(ucs-set-char #x6DD1 ?$B=J(B) ; J83-B-3D4A
(ucs-set-char #x6DD2 ?$(G[^(B) ; C01-G-5B5E
(ucs-set-char #x6DD2 ?$@^G(B) ; J78-@-5E47
(ucs-set-char #x6DD2 ?$B^G(B) ; J83-B-5E47
(ucs-set-char #x6DD3 ?$(H6e(B) ; C02-H-3665
(ucs-set-char #x6DD4 ?$(H6N(B) ; C02-H-364E
(ucs-set-char #x6DD5 ?$(H6_(B) ; C02-H-365F
(ucs-set-char #x6DD5 ?$@^L(B) ; J78-@-5E4C
(ucs-set-char #x6DD5 ?$B^L(B) ; J83-B-5E4C
(ucs-set-char #x6DD6 ?$(DGZ(B) ; J90-D-475A
(ucs-set-char #x6DD6 ?$(H6S(B) ; C02-H-3653
(ucs-set-char #x6DD6 ?$ADW(B) ; GB0-A-4457
(ucs-set-char #x6DD7 ?$(H6g(B) ; C02-H-3667
(ucs-set-char #x6DD8 ?$(CT#(B) ; KS0-C-5423
(ucs-set-char #x6DD8 ?$(G[c(B) ; C01-G-5B63
(ucs-set-char #x6DD8 ?$@Eq(B) ; J78-@-4571
(ucs-set-char #x6DD8 ?$ALT(B) ; GB0-A-4C54
(ucs-set-char #x6DD8 ?$BEq(B) ; J83-B-4571
(ucs-set-char #x6DD9 ?$(Cpx(B) ; KS0-C-7078
(ucs-set-char #x6DD9 ?$(G[K(B) ; C01-G-5B4B
(ucs-set-char #x6DD9 ?$@^J(B) ; J78-@-5E4A
(ucs-set-char #x6DD9 ?$AdH(B) ; GB0-A-6448
(ucs-set-char #x6DD9 ?$B^J(B) ; J83-B-5E4A
(ucs-set-char #x6DDA ?$(CW((B) ; KS0-C-5728
(ucs-set-char #x6DDA ?$(G[a(B) ; C01-G-5B61
(ucs-set-char #x6DDB ?$(DG[(B) ; J90-D-475B
(ucs-set-char #x6DDB ?$(H6X(B) ; C02-H-3658
(ucs-set-char #x6DDC ?$(H6V(B) ; C02-H-3656
(ucs-set-char #x6DDD ?$(DG\(B) ; J90-D-475C
(ucs-set-char #x6DDD ?$(H6W(B) ; C02-H-3657
(ucs-set-char #x6DDD ?$AdG(B) ; GB0-A-6447
(ucs-set-char #x6DDE ?$(Cag(B) ; KS0-C-6167
(ucs-set-char #x6DDE ?$(G[X(B) ; C01-G-5B58
(ucs-set-char #x6DDE ?$@^D(B) ; J78-@-5E44
(ucs-set-char #x6DDE ?$AdA(B) ; GB0-A-6441
(ucs-set-char #x6DDE ?$B^D(B) ; J83-B-5E44
(ucs-set-char #x6DDF ?$(DG](B) ; J90-D-475D
(ucs-set-char #x6DDF ?$(H6R(B) ; C02-H-3652
(ucs-set-char #x6DE0 ?$(DG^(B) ; J90-D-475E
(ucs-set-char #x6DE0 ?$(H6Q(B) ; C02-H-3651
(ucs-set-char #x6DE0 ?$AdD(B) ; GB0-A-6444
(ucs-set-char #x6DE1 ?$(CS?(B) ; KS0-C-533F
(ucs-set-char #x6DE1 ?$(G[M(B) ; C01-G-5B4D
(ucs-set-char #x6DE1 ?$@C8(B) ; J78-@-4338
(ucs-set-char #x6DE1 ?$A5-(B) ; GB0-A-352D
(ucs-set-char #x6DE1 ?$BC8(B) ; J83-B-4338
(ucs-set-char #x6DE2 ?$(DG_(B) ; J90-D-475F
(ucs-set-char #x6DE2 ?$(H6K(B) ; C02-H-364B
(ucs-set-char #x6DE3 ?$(H6i(B) ; C02-H-3669
(ucs-set-char #x6DE4 ?$(G[O(B) ; C01-G-5B4F
(ucs-set-char #x6DE4 ?$@^K(B) ; J78-@-5E4B
(ucs-set-char #x6DE4 ?$ASY(B) ; GB0-A-5359
(ucs-set-char #x6DE4 ?$B^K(B) ; J83-B-5E4B
(ucs-set-char #x6DE5 ?$(DG`(B) ; J90-D-4760
(ucs-set-char #x6DE5 ?$(H6U(B) ; C02-H-3655
(ucs-set-char #x6DE6 ?$(G[m(B) ; C01-G-5B6D
(ucs-set-char #x6DE6 ?$@^@(B) ; J78-@-5E40
(ucs-set-char #x6DE6 ?$AdF(B) ; GB0-A-6446
(ucs-set-char #x6DE6 ?$B^@(B) ; J83-B-5E40
(ucs-set-char #x6DE7 ?$(I6t(B) ; C03-I-3674
(ucs-set-char #x6DE8 ?$(Cod(B) ; KS0-C-6F64
(ucs-set-char #x6DE8 ?$(G[g(B) ; C01-G-5B67
(ucs-set-char #x6DE8 ?$@^F(B) ; J78-@-5E46
(ucs-set-char #x6DE8 ?$B^F(B) ; J83-B-5E46
(ucs-set-char #x6DE9 ?$(DGa(B) ; J90-D-4761
(ucs-set-char #x6DE9 ?$(H6J(B) ; C02-H-364A
(ucs-set-char #x6DEA ?$(CWE(B) ; KS0-C-5745
(ucs-set-char #x6DEA ?$(G[d(B) ; C01-G-5B64
(ucs-set-char #x6DEA ?$@^M(B) ; J78-@-5E4D
(ucs-set-char #x6DEA ?$B^M(B) ; J83-B-5E4D
(ucs-set-char #x6DEB ?$(Ckb(B) ; KS0-C-6B62
(ucs-set-char #x6DEB ?$(G[b(B) ; C01-G-5B62
(ucs-set-char #x6DEB ?$@0|(B) ; J78-@-307C
(ucs-set-char #x6DEB ?$ARy(B) ; GB0-A-5279
(ucs-set-char #x6DEB ?$B0|(B) ; J83-B-307C
(ucs-set-char #x6DEC ?$(G[k(B) ; C01-G-5B6B
(ucs-set-char #x6DEC ?$@^C(B) ; J78-@-5E43
(ucs-set-char #x6DEC ?$A4c(B) ; GB0-A-3463
(ucs-set-char #x6DEC ?$B^C(B) ; J83-B-5E43
(ucs-set-char #x6DED ?$(H6\(B) ; C02-H-365C
(ucs-set-char #x6DEE ?$(C|g(B) ; KS0-C-7C67
(ucs-set-char #x6DEE ?$(G[f(B) ; C01-G-5B66
(ucs-set-char #x6DEE ?$@^N(B) ; J78-@-5E4E
(ucs-set-char #x6DEE ?$A;4(B) ; GB0-A-3B34
(ucs-set-char #x6DEE ?$B^N(B) ; J83-B-5E4E
(ucs-set-char #x6DEF ?$(DGb(B) ; J90-D-4762
(ucs-set-char #x6DEF ?$(H05(B) ; C02-H-3035
(ucs-set-char #x6DF0 ?$(DGc(B) ; J90-D-4763
(ucs-set-char #x6DF0 ?$(H6](B) ; C02-H-365D
(ucs-set-char #x6DF1 ?$(Cd"(B) ; KS0-C-6422
(ucs-set-char #x6DF1 ?$(G[e(B) ; C01-G-5B65
(ucs-set-char #x6DF1 ?$@?<(B) ; J78-@-3F3C
(ucs-set-char #x6DF1 ?$AIn(B) ; GB0-A-496E
(ucs-set-char #x6DF1 ?$B?<(B) ; J83-B-3F3C
(ucs-set-char #x6DF2 ?$(H6d(B) ; C02-H-3664
(ucs-set-char #x6DF3 ?$(Cbh(B) ; KS0-C-6268
(ucs-set-char #x6DF3 ?$(G[J(B) ; C01-G-5B4A
(ucs-set-char #x6DF3 ?$@=_(B) ; J78-@-3D5F
(ucs-set-char #x6DF3 ?$A4>(B) ; GB0-A-343E
(ucs-set-char #x6DF3 ?$B=_(B) ; J83-B-3D5F
(ucs-set-char #x6DF4 ?$(DGd(B) ; J90-D-4764
(ucs-set-char #x6DF4 ?$(H6Y(B) ; C02-H-3659
(ucs-set-char #x6DF5 ?$(CfP(B) ; KS0-C-6650
(ucs-set-char #x6DF5 ?$(G[\(B) ; C01-G-5B5C
(ucs-set-char #x6DF5 ?$@J%(B) ; J78-@-4A25
(ucs-set-char #x6DF5 ?$BJ%(B) ; J83-B-4A25
(ucs-set-char #x6DF6 ?$(DGe(B) ; J90-D-4765
(ucs-set-char #x6DF6 ?$(H6M(B) ; C02-H-364D
(ucs-set-char #x6DF7 ?$(C{h(B) ; KS0-C-7B68
(ucs-set-char #x6DF7 ?$(G[[(B) ; C01-G-5B5B
(ucs-set-char #x6DF7 ?$@:.(B) ; J78-@-3A2E
(ucs-set-char #x6DF7 ?$A;l(B) ; GB0-A-3B6C
(ucs-set-char #x6DF7 ?$B:.(B) ; J83-B-3A2E
(ucs-set-char #x6DF8 ?$(Cth(B) ; KS0-C-7468
(ucs-set-char #x6DF8 ?$(I6|(B) ; C03-I-367C
(ucs-set-char #x6DF9 ?$(Cet(B) ; KS0-C-6574
(ucs-set-char #x6DF9 ?$(G[Y(B) ; C01-G-5B59
(ucs-set-char #x6DF9 ?$@^;(B) ; J78-@-5E3B
(ucs-set-char #x6DF9 ?$AQM(B) ; GB0-A-514D
(ucs-set-char #x6DF9 ?$B^;(B) ; J83-B-5E3B
(ucs-set-char #x6DFA ?$(Ct<(B) ; KS0-C-743C
(ucs-set-char #x6DFA ?$(G[Q(B) ; C01-G-5B51
(ucs-set-char #x6DFA ?$@^I(B) ; J78-@-5E49
(ucs-set-char #x6DFA ?$B^I(B) ; J83-B-5E49
(ucs-set-char #x6DFB ?$(CtU(B) ; KS0-C-7455
(ucs-set-char #x6DFB ?$(G[P(B) ; C01-G-5B50
(ucs-set-char #x6DFB ?$@E:(B) ; J78-@-453A
(ucs-set-char #x6DFB ?$ALm(B) ; GB0-A-4C6D
(ucs-set-char #x6DFB ?$BE:(B) ; J83-B-453A
(ucs-set-char #x6DFC ?$(DGf(B) ; J90-D-4766
(ucs-set-char #x6DFC ?$(H=,(B) ; C02-H-3D2C
(ucs-set-char #x6DFC ?$Am5(B) ; GB0-A-6D35
(ucs-set-char #x6DFD ?$(H6f(B) ; C02-H-3666
(ucs-set-char #x6DFE ?$(I<](B) ; C03-I-3C5D
(ucs-set-char #x6DFF ?$(I7((B) ; C03-I-3728
(ucs-set-char #x6E00 ?$(DGg(B) ; J90-D-4767
(ucs-set-char #x6E00 ?$(H6O(B) ; C02-H-364F
(ucs-set-char #x6E01 ?$(I7&(B) ; C03-I-3726
(ucs-set-char #x6E02 ?$(I7#(B) ; C03-I-3723
(ucs-set-char #x6E03 ?$(H=A(B) ; C02-H-3D41
(ucs-set-char #x6E04 ?$(DGh(B) ; J90-D-4768
(ucs-set-char #x6E04 ?$(I6p(B) ; C03-I-3670
(ucs-set-char #x6E05 ?$(G[R(B) ; C01-G-5B52
(ucs-set-char #x6E05 ?$@@6(B) ; J78-@-4036
(ucs-set-char #x6E05 ?$AGe(B) ; GB0-A-4765
(ucs-set-char #x6E05 ?$B@6(B) ; J83-B-4036
(ucs-set-char #x6E06 ?$(I6w(B) ; C03-I-3677
(ucs-set-char #x6E07 ?$(I7$(B) ; C03-I-3724
(ucs-set-char #x6E07 ?$@3i(B) ; J78-@-3369
(ucs-set-char #x6E07 ?$B3i(B) ; J83-B-3369
(ucs-set-char #x6E08 ?$(I6v(B) ; C03-I-3676
(ucs-set-char #x6E08 ?$@:Q(B) ; J78-@-3A51
(ucs-set-char #x6E08 ?$B:Q(B) ; J83-B-3A51
(ucs-set-char #x6E09 ?$(I7%(B) ; C03-I-3725
(ucs-set-char #x6E09 ?$@>D(B) ; J78-@-3E44
(ucs-set-char #x6E09 ?$B>D(B) ; J83-B-3E44
(ucs-set-char #x6E0A ?$(I6y(B) ; C03-I-3679
(ucs-set-char #x6E0A ?$@^=(B) ; J78-@-5E3D
(ucs-set-char #x6E0A ?$AT((B) ; GB0-A-5428
(ucs-set-char #x6E0A ?$B^=(B) ; J83-B-5E3D
(ucs-set-char #x6E0B ?$(J2m(B) ; C04-J-326D
(ucs-set-char #x6E0B ?$@=B(B) ; J78-@-3D42
(ucs-set-char #x6E0B ?$B=B(B) ; J83-B-3D42
(ucs-set-char #x6E0C ?$(I6}(B) ; C03-I-367D
(ucs-set-char #x6E0C ?$AdK(B) ; GB0-A-644B
(ucs-set-char #x6E0D ?$AWU(B) ; GB0-A-5755
(ucs-set-char #x6E0E ?$AdB(B) ; GB0-A-6442
(ucs-set-char #x6E10 ?$A=%(B) ; GB0-A-3D25
(ucs-set-char #x6E11 ?$AdE(B) ; GB0-A-6445
(ucs-set-char #x6E12 ?$(I7)(B) ; C03-I-3729
(ucs-set-char #x6E13 ?$@7L(B) ; J78-@-374C
(ucs-set-char #x6E13 ?$B7L(B) ; J83-B-374C
(ucs-set-char #x6E14 ?$ASf(B) ; GB0-A-5366
(ucs-set-char #x6E15 ?$@^<(B) ; J78-@-5E3C
(ucs-set-char #x6E15 ?$B^<(B) ; J83-B-5E3C
(ucs-set-char #x6E16 ?$AdI(B) ; GB0-A-6449
(ucs-set-char #x6E17 ?$(C_6(B) ; KS0-C-5F36
(ucs-set-char #x6E17 ?$(I7'(B) ; C03-I-3727
(ucs-set-char #x6E17 ?$AIx(B) ; GB0-A-4978
(ucs-set-char #x6E18 ?$(I<T(B) ; C03-I-3C54
(ucs-set-char #x6E19 ?$(C|9(B) ; KS0-C-7C39
(ucs-set-char #x6E19 ?$(G`G(B) ; C01-G-6047
(ucs-set-char #x6E19 ?$@^R(B) ; J78-@-5E52
(ucs-set-char #x6E19 ?$B^R(B) ; J83-B-5E52
(ucs-set-char #x6E1A ?$(CnB(B) ; KS0-C-6E42
(ucs-set-char #x6E1A ?$(G[_(B) ; C01-G-5B5F
(ucs-set-char #x6E1A ?$@=m(B) ; J78-@-3D6D
(ucs-set-char #x6E1A ?$Ad>(B) ; GB0-A-643E
(ucs-set-char #x6E1A ?$B=m(B) ; J83-B-3D6D
(ucs-set-char #x6E1B ?$(CJu(B) ; KS0-C-4A75
(ucs-set-char #x6E1B ?$(G`5(B) ; C01-G-6035
(ucs-set-char #x6E1B ?$@8:(B) ; J78-@-383A
(ucs-set-char #x6E1B ?$B8:(B) ; J83-B-383A
(ucs-set-char #x6E1C ?$(H=;(B) ; C02-H-3D3B
(ucs-set-char #x6E1D ?$(G`C(B) ; C01-G-6043
(ucs-set-char #x6E1D ?$@^a(B) ; J78-@-5E61
(ucs-set-char #x6E1D ?$ASe(B) ; GB0-A-5365
(ucs-set-char #x6E1D ?$B^a(B) ; J83-B-5E61
(ucs-set-char #x6E1E ?$(DGi(B) ; J90-D-4769
(ucs-set-char #x6E1E ?$(I<R(B) ; C03-I-3C52
(ucs-set-char #x6E1F ?$(Coe(B) ; KS0-C-6F65
(ucs-set-char #x6E1F ?$(H=/(B) ; C02-H-3D2F
(ucs-set-char #x6E1F ?$@^[(B) ; J78-@-5E5B
(ucs-set-char #x6E1F ?$B^[(B) ; J83-B-5E5B
(ucs-set-char #x6E20 ?$(CKb(B) ; KS0-C-4B62
(ucs-set-char #x6E20 ?$(G`2(B) ; C01-G-6032
(ucs-set-char #x6E20 ?$@5t(B) ; J78-@-3574
(ucs-set-char #x6E20 ?$AG~(B) ; GB0-A-477E
(ucs-set-char #x6E20 ?$B5t(B) ; J83-B-3574
(ucs-set-char #x6E21 ?$(CT$(B) ; KS0-C-5424
(ucs-set-char #x6E21 ?$(G`.(B) ; C01-G-602E
(ucs-set-char #x6E21 ?$@EO(B) ; J78-@-454F
(ucs-set-char #x6E21 ?$A6I(B) ; GB0-A-3649
(ucs-set-char #x6E21 ?$BEO(B) ; J83-B-454F
(ucs-set-char #x6E22 ?$(DGj(B) ; J90-D-476A
(ucs-set-char #x6E22 ?$(H=M(B) ; C02-H-3D4D
(ucs-set-char #x6E23 ?$(C^`(B) ; KS0-C-5E60
(ucs-set-char #x6E23 ?$(G`4(B) ; C01-G-6034
(ucs-set-char #x6E23 ?$@^V(B) ; J78-@-5E56
(ucs-set-char #x6E23 ?$AT|(B) ; GB0-A-547C
(ucs-set-char #x6E23 ?$B^V(B) ; J83-B-5E56
(ucs-set-char #x6E24 ?$(CZ}(B) ; KS0-C-5A7D
(ucs-set-char #x6E24 ?$(G`8(B) ; C01-G-6038
(ucs-set-char #x6E24 ?$@^_(B) ; J78-@-5E5F
(ucs-set-char #x6E24 ?$A23(B) ; GB0-A-3233
(ucs-set-char #x6E24 ?$B^_(B) ; J83-B-5E5F
(ucs-set-char #x6E25 ?$(CdF(B) ; KS0-C-6446
(ucs-set-char #x6E25 ?$(G`3(B) ; C01-G-6033
(ucs-set-char #x6E25 ?$@0/(B) ; J78-@-302F
(ucs-set-char #x6E25 ?$AdW(B) ; GB0-A-6457
(ucs-set-char #x6E25 ?$B0/(B) ; J83-B-302F
(ucs-set-char #x6E26 ?$(Ch>(B) ; KS0-C-683E
(ucs-set-char #x6E26 ?$(G`<(B) ; C01-G-603C
(ucs-set-char #x6E26 ?$@12(B) ; J78-@-3132
(ucs-set-char #x6E26 ?$B12(B) ; J83-B-3132
(ucs-set-char #x6E27 ?$(DGk(B) ; J90-D-476B
(ucs-set-char #x6E27 ?$(H=Q(B) ; C02-H-3D51
(ucs-set-char #x6E28 ?$(H=H(B) ; C02-H-3D48
(ucs-set-char #x6E29 ?$(I<k(B) ; C03-I-3C6B
(ucs-set-char #x6E29 ?$@29(B) ; J78-@-3239
(ucs-set-char #x6E29 ?$ANB(B) ; GB0-A-4E42
(ucs-set-char #x6E29 ?$B29(B) ; J83-B-3239
(ucs-set-char #x6E2A ?$(I<m(B) ; C03-I-3C6D
(ucs-set-char #x6E2B ?$(C`^(B) ; KS0-C-605E
(ucs-set-char #x6E2B ?$(H=6(B) ; C02-H-3D36
(ucs-set-char #x6E2B ?$@^X(B) ; J78-@-5E58
(ucs-set-char #x6E2B ?$AdM(B) ; GB0-A-644D
(ucs-set-char #x6E2B ?$B^X(B) ; J83-B-5E58
(ucs-set-char #x6E2C ?$(Cv4(B) ; KS0-C-7634
(ucs-set-char #x6E2C ?$(G`A(B) ; C01-G-6041
(ucs-set-char #x6E2C ?$@B,(B) ; J78-@-422C
(ucs-set-char #x6E2C ?$BB,(B) ; J83-B-422C
(ucs-set-char #x6E2D ?$(CjR(B) ; KS0-C-6A52
(ucs-set-char #x6E2D ?$(G`;(B) ; C01-G-603B
(ucs-set-char #x6E2D ?$@^O(B) ; J78-@-5E4F
(ucs-set-char #x6E2D ?$AN<(B) ; GB0-A-4E3C
(ucs-set-char #x6E2D ?$B^O(B) ; J83-B-5E4F
(ucs-set-char #x6E2E ?$(H=B(B) ; C02-H-3D42
(ucs-set-char #x6E2E ?$@^Q(B) ; J78-@-5E51
(ucs-set-char #x6E2E ?$B^Q(B) ; J83-B-5E51
(ucs-set-char #x6E2F ?$(Cy{(B) ; KS0-C-797B
(ucs-set-char #x6E2F ?$(G`+(B) ; C01-G-602B
(ucs-set-char #x6E2F ?$(LJe(B) ; C06-L-4A65
(ucs-set-char #x6E2F ?$@9A(B) ; J78-@-3941
(ucs-set-char #x6E2F ?$A8[(B) ; GB0-A-385B
(ucs-set-char #x6E2F ?$B9A(B) ; J83-B-3941
(ucs-set-char #x6E30 ?$(H=N(B) ; C02-H-3D4E
(ucs-set-char #x6E31 ?$(H=G(B) ; C02-H-3D47
(ucs-set-char #x6E32 ?$(C`B(B) ; KS0-C-6042
(ucs-set-char #x6E32 ?$(DGl(B) ; J90-D-476C
(ucs-set-char #x6E32 ?$(G`/(B) ; C01-G-602F
(ucs-set-char #x6E32 ?$AdV(B) ; GB0-A-6456
(ucs-set-char #x6E33 ?$(H=<(B) ; C02-H-3D3C
(ucs-set-char #x6E34 ?$(CJd(B) ; KS0-C-4A64
(ucs-set-char #x6E34 ?$(G`>(B) ; C01-G-603E
(ucs-set-char #x6E34 ?$A?J(B) ; GB0-A-3F4A
(ucs-set-char #x6E35 ?$(H=Y(B) ; C02-H-3D59
(ucs-set-char #x6E36 ?$(Cg7(B) ; KS0-C-6737
(ucs-set-char #x6E36 ?$(DGm(B) ; J90-D-476D
(ucs-set-char #x6E36 ?$(H=Z(B) ; C02-H-3D5A
(ucs-set-char #x6E37 ?$(J8[(B) ; C04-J-385B
(ucs-set-char #x6E38 ?$(Cj}(B) ; KS0-C-6A7D
(ucs-set-char #x6E38 ?$(G`,(B) ; C01-G-602C
(ucs-set-char #x6E38 ?$@^b(B) ; J78-@-5E62
(ucs-set-char #x6E38 ?$ASN(B) ; GB0-A-534E
(ucs-set-char #x6E38 ?$B^b(B) ; J83-B-5E62
(ucs-set-char #x6E39 ?$(DGn(B) ; J90-D-476E
(ucs-set-char #x6E39 ?$(H=L(B) ; C02-H-3D4C
(ucs-set-char #x6E3A ?$(CY](B) ; KS0-C-595D
(ucs-set-char #x6E3A ?$(G`@(B) ; C01-G-6040
(ucs-set-char #x6E3A ?$@^](B) ; J78-@-5E5D
(ucs-set-char #x6E3A ?$ACl(B) ; GB0-A-436C
(ucs-set-char #x6E3A ?$B^](B) ; J83-B-5E5D
(ucs-set-char #x6E3B ?$(DGo(B) ; J90-D-476F
(ucs-set-char #x6E3B ?$(H=@(B) ; C02-H-3D40
(ucs-set-char #x6E3C ?$(CZ4(B) ; KS0-C-5A34
(ucs-set-char #x6E3C ?$(DGp(B) ; J90-D-4770
(ucs-set-char #x6E3C ?$(H=2(B) ; C02-H-3D32
(ucs-set-char #x6E3D ?$(Cn*(B) ; KS0-C-6E2A
(ucs-set-char #x6E3D ?$(H=3(B) ; C02-H-3D33
(ucs-set-char #x6E3E ?$(C{i(B) ; KS0-C-7B69
(ucs-set-char #x6E3E ?$(G`D(B) ; C01-G-6044
(ucs-set-char #x6E3E ?$@^U(B) ; J78-@-5E55
(ucs-set-char #x6E3E ?$B^U(B) ; J83-B-5E55
(ucs-set-char #x6E3F ?$(H=7(B) ; C02-H-3D37
(ucs-set-char #x6E40 ?$(H=>(B) ; C02-H-3D3E
(ucs-set-char #x6E41 ?$(H=8(B) ; C02-H-3D38
(ucs-set-char #x6E42 ?$(I<Z(B) ; C03-I-3C5A
(ucs-set-char #x6E43 ?$(C[K(B) ; KS0-C-5B4B
(ucs-set-char #x6E43 ?$(G`B(B) ; C01-G-6042
(ucs-set-char #x6E43 ?$@^\(B) ; J78-@-5E5C
(ucs-set-char #x6E43 ?$AEH(B) ; GB0-A-4548
(ucs-set-char #x6E43 ?$B^\(B) ; J83-B-5E5C
(ucs-set-char #x6E44 ?$(CZ5(B) ; KS0-C-5A35
(ucs-set-char #x6E44 ?$(DGq(B) ; J90-D-4771
(ucs-set-char #x6E44 ?$(G`J(B) ; C01-G-604A
(ucs-set-char #x6E44 ?$AdX(B) ; GB0-A-6458
(ucs-set-char #x6E45 ?$(DGr(B) ; J90-D-4772
(ucs-set-char #x6E45 ?$(H=4(B) ; C02-H-3D34
(ucs-set-char #x6E46 ?$(H=-(B) ; C02-H-3D2D
(ucs-set-char #x6E47 ?$(H=.(B) ; C02-H-3D2E
(ucs-set-char #x6E48 ?$(DGs(B) ; J90-D-4773
(ucs-set-char #x6E48 ?$(I<V(B) ; C03-I-3C56
(ucs-set-char #x6E49 ?$(DGt(B) ; J90-D-4774
(ucs-set-char #x6E49 ?$(H=0(B) ; C02-H-3D30
(ucs-set-char #x6E4A ?$(Cq>(B) ; KS0-C-713E
(ucs-set-char #x6E4A ?$(G`1(B) ; C01-G-6031
(ucs-set-char #x6E4A ?$@L+(B) ; J78-@-4C2B
(ucs-set-char #x6E4A ?$BL+(B) ; J83-B-4C2B
(ucs-set-char #x6E4B ?$(DGu(B) ; J90-D-4775
(ucs-set-char #x6E4B ?$(H==(B) ; C02-H-3D3D
(ucs-set-char #x6E4C ?$(I<n(B) ; C03-I-3C6E
(ucs-set-char #x6E4D ?$(CS,(B) ; KS0-C-532C
(ucs-set-char #x6E4D ?$(G`?(B) ; C01-G-603F
(ucs-set-char #x6E4D ?$@^Z(B) ; J78-@-5E5A
(ucs-set-char #x6E4D ?$AMD(B) ; GB0-A-4D44
(ucs-set-char #x6E4D ?$B^Z(B) ; J83-B-5E5A
(ucs-set-char #x6E4E ?$(G`H(B) ; C01-G-6048
(ucs-set-char #x6E4E ?$@^^(B) ; J78-@-5E5E
(ucs-set-char #x6E4E ?$AdO(B) ; GB0-A-644F
(ucs-set-char #x6E4E ?$B^^(B) ; J83-B-5E5E
(ucs-set-char #x6E4F ?$(DGv(B) ; J90-D-4776
(ucs-set-char #x6E4F ?$(I<X(B) ; C03-I-3C58
(ucs-set-char #x6E50 ?$(I<i(B) ; C03-I-3C69
(ucs-set-char #x6E51 ?$(DGw(B) ; J90-D-4777
(ucs-set-char #x6E51 ?$(H=?(B) ; C02-H-3D3F
(ucs-set-char #x6E52 ?$(DGx(B) ; J90-D-4778
(ucs-set-char #x6E52 ?$(H=W(B) ; C02-H-3D57
(ucs-set-char #x6E53 ?$(DGy(B) ; J90-D-4779
(ucs-set-char #x6E53 ?$(H=O(B) ; C02-H-3D4F
(ucs-set-char #x6E53 ?$AdT(B) ; GB0-A-6454
(ucs-set-char #x6E54 ?$(DGz(B) ; J90-D-477A
(ucs-set-char #x6E54 ?$(G`-(B) ; C01-G-602D
(ucs-set-char #x6E54 ?$AdU(B) ; GB0-A-6455
(ucs-set-char #x6E55 ?$(H=U(B) ; C02-H-3D55
(ucs-set-char #x6E56 ?$(C{I(B) ; KS0-C-7B49
(ucs-set-char #x6E56 ?$(G`9(B) ; C01-G-6039
(ucs-set-char #x6E56 ?$@8P(B) ; J78-@-3850
(ucs-set-char #x6E56 ?$A:~(B) ; GB0-A-3A7E
(ucs-set-char #x6E56 ?$B8P(B) ; J83-B-3850
(ucs-set-char #x6E57 ?$(DG{(B) ; J90-D-477B
(ucs-set-char #x6E57 ?$(I<f(B) ; C03-I-3C66
(ucs-set-char #x6E58 ?$(C_O(B) ; KS0-C-5F4F
(ucs-set-char #x6E58 ?$(G`7(B) ; C01-G-6037
(ucs-set-char #x6E58 ?$@>E(B) ; J78-@-3E45
(ucs-set-char #x6E58 ?$AOf(B) ; GB0-A-4F66
(ucs-set-char #x6E58 ?$B>E(B) ; J83-B-3E45
(ucs-set-char #x6E59 ?$(I<d(B) ; C03-I-3C64
(ucs-set-char #x6E5A ?$(H=[(B) ; C02-H-3D5B
(ucs-set-char #x6E5B ?$(CS@(B) ; KS0-C-5340
(ucs-set-char #x6E5B ?$(G`6(B) ; C01-G-6036
(ucs-set-char #x6E5B ?$@C9(B) ; J78-@-4339
(ucs-set-char #x6E5B ?$AU?(B) ; GB0-A-553F
(ucs-set-char #x6E5B ?$BC9(B) ; J83-B-4339
(ucs-set-char #x6E5C ?$(CcW(B) ; KS0-C-6357
(ucs-set-char #x6E5C ?$(DG|(B) ; J90-D-477C
(ucs-set-char #x6E5C ?$(H=E(B) ; C02-H-3D45
(ucs-set-char #x6E5D ?$(DG}(B) ; J90-D-477D
(ucs-set-char #x6E5D ?$(H=9(B) ; C02-H-3D39
(ucs-set-char #x6E5E ?$(Cof(B) ; KS0-C-6F66
(ucs-set-char #x6E5E ?$(DG~(B) ; J90-D-477E
(ucs-set-char #x6E5E ?$(H=C(B) ; C02-H-3D43
(ucs-set-char #x6E5F ?$(C|P(B) ; KS0-C-7C50
(ucs-set-char #x6E5F ?$(G`M(B) ; C01-G-604D
(ucs-set-char #x6E5F ?$@^T(B) ; J78-@-5E54
(ucs-set-char #x6E5F ?$AdR(B) ; GB0-A-6452
(ucs-set-char #x6E5F ?$B^T(B) ; J83-B-5E54
(ucs-set-char #x6E60 ?$(H=I(B) ; C02-H-3D49
(ucs-set-char #x6E61 ?$(H=F(B) ; C02-H-3D46
(ucs-set-char #x6E62 ?$(DH!(B) ; J90-D-4821
(ucs-set-char #x6E62 ?$(H=5(B) ; C02-H-3D35
(ucs-set-char #x6E63 ?$(DH"(B) ; J90-D-4822
(ucs-set-char #x6E63 ?$(G`I(B) ; C01-G-6049
(ucs-set-char #x6E64 ?$(H=S(B) ; C02-H-3D53
(ucs-set-char #x6E65 ?$(H=P(B) ; C02-H-3D50
(ucs-set-char #x6E66 ?$(H=X(B) ; C02-H-3D58
(ucs-set-char #x6E67 ?$(Ci@(B) ; KS0-C-6940
(ucs-set-char #x6E67 ?$(G`0(B) ; C01-G-6030
(ucs-set-char #x6E67 ?$@M/(B) ; J78-@-4D2F
(ucs-set-char #x6E67 ?$BM/(B) ; J83-B-4D2F
(ucs-set-char #x6E68 ?$(DH#(B) ; J90-D-4823
(ucs-set-char #x6E68 ?$(H=D(B) ; C02-H-3D44
(ucs-set-char #x6E69 ?$(G`L(B) ; C01-G-604C
(ucs-set-char #x6E6A ?$(I<[(B) ; C03-I-3C5B
(ucs-set-char #x6E6B ?$(CuS(B) ; KS0-C-7553
(ucs-set-char #x6E6B ?$(H=K(B) ; C02-H-3D4B
(ucs-set-char #x6E6B ?$@^W(B) ; J78-@-5E57
(ucs-set-char #x6E6B ?$AdP(B) ; GB0-A-6450
(ucs-set-char #x6E6B ?$B^W(B) ; J83-B-5E57
(ucs-set-char #x6E6C ?$(IB:(B) ; C03-I-423A
(ucs-set-char #x6E6D ?$(I<`(B) ; C03-I-3C60
(ucs-set-char #x6E6E ?$(Cl\(B) ; KS0-C-6C5C
(ucs-set-char #x6E6E ?$(G`:(B) ; C01-G-603A
(ucs-set-char #x6E6E ?$@^P(B) ; J78-@-5E50
(ucs-set-char #x6E6E ?$AdN(B) ; GB0-A-644E
(ucs-set-char #x6E6E ?$B^P(B) ; J83-B-5E50
(ucs-set-char #x6E6F ?$(Cw7(B) ; KS0-C-7737
(ucs-set-char #x6E6F ?$(G`=(B) ; C01-G-603D
(ucs-set-char #x6E6F ?$@Er(B) ; J78-@-4572
(ucs-set-char #x6E6F ?$BEr(B) ; J83-B-4572
(ucs-set-char #x6E70 ?$(I<\(B) ; C03-I-3C5C
(ucs-set-char #x6E71 ?$(H=J(B) ; C02-H-3D4A
(ucs-set-char #x6E72 ?$(Cj8(B) ; KS0-C-6A38
(ucs-set-char #x6E72 ?$(G`K(B) ; C01-G-604B
(ucs-set-char #x6E72 ?$@^S(B) ; J78-@-5E53
(ucs-set-char #x6E72 ?$B^S(B) ; J83-B-5E53
(ucs-set-char #x6E73 ?$(CQy(B) ; KS0-C-5179
(ucs-set-char #x6E73 ?$(DH$(B) ; J90-D-4824
(ucs-set-char #x6E73 ?$(H=:(B) ; C02-H-3D3A
(ucs-set-char #x6E74 ?$(H6H(B) ; C02-H-3648
(ucs-set-char #x6E75 ?$(I<Q(B) ; C03-I-3C51
(ucs-set-char #x6E76 ?$(I<l(B) ; C03-I-3C6C
(ucs-set-char #x6E76 ?$@^Y(B) ; J78-@-5E59
(ucs-set-char #x6E76 ?$B^Y(B) ; J83-B-5E59
(ucs-set-char #x6E77 ?$(H=T(B) ; C02-H-3D54
(ucs-set-char #x6E78 ?$(H=R(B) ; C02-H-3D52
(ucs-set-char #x6E79 ?$(H=V(B) ; C02-H-3D56
(ucs-set-char #x6E7A ?$(C\H(B) ; KS0-C-5C48
(ucs-set-char #x6E7B ?$(DH%(B) ; J90-D-4825
(ucs-set-char #x6E7B ?$(I<b(B) ; C03-I-3C62
(ucs-set-char #x6E7C ?$(J8\(B) ; C04-J-385C
(ucs-set-char #x6E7D ?$(DH&(B) ; J90-D-4826
(ucs-set-char #x6E7D ?$(J8^(B) ; C04-J-385E
(ucs-set-char #x6E7E ?$(I<c(B) ; C03-I-3C63
(ucs-set-char #x6E7E ?$@OQ(B) ; J78-@-4F51
(ucs-set-char #x6E7E ?$AMe(B) ; GB0-A-4D65
(ucs-set-char #x6E7E ?$BOQ(B) ; J83-B-4F51
(ucs-set-char #x6E7F ?$(LTD(B) ; C06-L-5444
(ucs-set-char #x6E7F ?$@<>(B) ; J78-@-3C3E
(ucs-set-char #x6E7F ?$AJ*(B) ; GB0-A-4A2A
(ucs-set-char #x6E7F ?$B<>(B) ; J83-B-3C3E
(ucs-set-char #x6E80 ?$(I<h(B) ; C03-I-3C68
(ucs-set-char #x6E80 ?$@K~(B) ; J78-@-4B7E
(ucs-set-char #x6E80 ?$BK~(B) ; J83-B-4B7E
(ucs-set-char #x6E82 ?$@^c(B) ; J78-@-5E63
(ucs-set-char #x6E82 ?$B^c(B) ; J83-B-5E63
(ucs-set-char #x6E83 ?$A@#(B) ; GB0-A-4023
(ucs-set-char #x6E85 ?$A=&(B) ; GB0-A-3D26
(ucs-set-char #x6E86 ?$(J8_(B) ; C04-J-385F
(ucs-set-char #x6E86 ?$AdS(B) ; GB0-A-6453
(ucs-set-char #x6E88 ?$(H=1(B) ; C02-H-3D31
(ucs-set-char #x6E89 ?$(G`F(B) ; C01-G-6046
(ucs-set-char #x6E89 ?$A8H(B) ; GB0-A-3848
(ucs-set-char #x6E8C ?$BH.(B) ; J83-B-482E
(ucs-set-char #x6E8D ?$(DH'(B) ; J90-D-4827
(ucs-set-char #x6E8D ?$(HDG(B) ; C02-H-4447
(ucs-set-char #x6E8E ?$(HDF(B) ; C02-H-4446
(ucs-set-char #x6E8F ?$(HD,(B) ; C02-H-442C
(ucs-set-char #x6E8F ?$@^o(B) ; J78-@-5E6F
(ucs-set-char #x6E8F ?$Adg(B) ; GB0-A-6467
(ucs-set-char #x6E8F ?$B^o(B) ; J83-B-5E6F
(ucs-set-char #x6E90 ?$(Cj9(B) ; KS0-C-6A39
(ucs-set-char #x6E90 ?$(Gdc(B) ; C01-G-6463
(ucs-set-char #x6E90 ?$@8;(B) ; J78-@-383B
(ucs-set-char #x6E90 ?$AT4(B) ; GB0-A-5434
(ucs-set-char #x6E90 ?$B8;(B) ; J83-B-383B
(ucs-set-char #x6E91 ?$(IB0(B) ; C03-I-4230
(ucs-set-char #x6E92 ?$(HDE(B) ; C02-H-4445
(ucs-set-char #x6E93 ?$(DH((B) ; J90-D-4828
(ucs-set-char #x6E93 ?$(HD/(B) ; C02-H-442F
(ucs-set-char #x6E94 ?$(HD0(B) ; C02-H-4430
(ucs-set-char #x6E95 ?$(J>?(B) ; C04-J-3E3F
(ucs-set-char #x6E96 ?$(Cq^(B) ; KS0-C-715E
(ucs-set-char #x6E96 ?$(Gdm(B) ; C01-G-646D
(ucs-set-char #x6E96 ?$@=`(B) ; J78-@-3D60
(ucs-set-char #x6E96 ?$B=`(B) ; J83-B-3D60
(ucs-set-char #x6E97 ?$(HDN(B) ; C02-H-444E
(ucs-set-char #x6E98 ?$(Gdh(B) ; C01-G-6468
(ucs-set-char #x6E98 ?$@^e(B) ; J78-@-5E65
(ucs-set-char #x6E98 ?$Ad[(B) ; GB0-A-645B
(ucs-set-char #x6E98 ?$B^e(B) ; J83-B-5E65
(ucs-set-char #x6E99 ?$(DH)(B) ; J90-D-4829
(ucs-set-char #x6E99 ?$(HDD(B) ; C02-H-4444
(ucs-set-char #x6E9A ?$(IB3(B) ; C03-I-4233
(ucs-set-char #x6E9B ?$(HD)(B) ; C02-H-4429
(ucs-set-char #x6E9C ?$(CW6(B) ; KS0-C-5736
(ucs-set-char #x6E9C ?$(Gdn(B) ; C01-G-646E
(ucs-set-char #x6E9C ?$@N/(B) ; J78-@-4E2F
(ucs-set-char #x6E9C ?$AAo(B) ; GB0-A-416F
(ucs-set-char #x6E9C ?$BN/(B) ; J83-B-4E2F
(ucs-set-char #x6E9D ?$(CO5(B) ; KS0-C-4F35
(ucs-set-char #x6E9D ?$(Gdd(B) ; C01-G-6464
(ucs-set-char #x6E9D ?$@9B(B) ; J78-@-3942
(ucs-set-char #x6E9D ?$B9B(B) ; J83-B-3942
(ucs-set-char #x6E9E ?$(HD8(B) ; C02-H-4438
(ucs-set-char #x6E9F ?$(CY((B) ; KS0-C-5928
(ucs-set-char #x6E9F ?$(HD.(B) ; C02-H-442E
(ucs-set-char #x6E9F ?$@^r(B) ; J78-@-5E72
(ucs-set-char #x6E9F ?$Adi(B) ; GB0-A-6469
(ucs-set-char #x6E9F ?$B^r(B) ; J83-B-5E72
(ucs-set-char #x6EA0 ?$(DH*(B) ; J90-D-482A
(ucs-set-char #x6EA0 ?$(HD1(B) ; C02-H-4431
(ucs-set-char #x6EA1 ?$(HDI(B) ; C02-H-4449
(ucs-set-char #x6EA2 ?$(Cln(B) ; KS0-C-6C6E
(ucs-set-char #x6EA2 ?$(Gd^(B) ; C01-G-645E
(ucs-set-char #x6EA2 ?$@0n(B) ; J78-@-306E
(ucs-set-char #x6EA2 ?$ARg(B) ; GB0-A-5267
(ucs-set-char #x6EA2 ?$B0n(B) ; J83-B-306E
(ucs-set-char #x6EA3 ?$(HDP(B) ; C02-H-4450
(ucs-set-char #x6EA4 ?$(HDH(B) ; C02-H-4448
(ucs-set-char #x6EA5 ?$(C]*(B) ; KS0-C-5D2A
(ucs-set-char #x6EA5 ?$(Gdg(B) ; C01-G-6467
(ucs-set-char #x6EA5 ?$@^p(B) ; J78-@-5E70
(ucs-set-char #x6EA5 ?$Ad_(B) ; GB0-A-645F
(ucs-set-char #x6EA5 ?$B^p(B) ; J83-B-5E70
(ucs-set-char #x6EA6 ?$(HD=(B) ; C02-H-443D
(ucs-set-char #x6EA7 ?$(DH+(B) ; J90-D-482B
(ucs-set-char #x6EA7 ?$(Gdr(B) ; C01-G-6472
(ucs-set-char #x6EA7 ?$Ad`(B) ; GB0-A-6460
(ucs-set-char #x6EA8 ?$(IB.(B) ; C03-I-422E
(ucs-set-char #x6EA9 ?$(IB6(B) ; C03-I-4236
(ucs-set-char #x6EAA ?$(CM"(B) ; KS0-C-4D22
(ucs-set-char #x6EAA ?$(Gdq(B) ; C01-G-6471
(ucs-set-char #x6EAA ?$@^d(B) ; J78-@-5E64
(ucs-set-char #x6EAA ?$AO*(B) ; GB0-A-4F2A
(ucs-set-char #x6EAA ?$B^d(B) ; J83-B-5E64
(ucs-set-char #x6EAB ?$(Ch.(B) ; KS0-C-682E
(ucs-set-char #x6EAB ?$(Gdk(B) ; C01-G-646B
(ucs-set-char #x6EAC ?$(IB@(B) ; C03-I-4240
(ucs-set-char #x6EAD ?$(DH,(B) ; J90-D-482C
(ucs-set-char #x6EAD ?$(J>6(B) ; C04-J-3E36
(ucs-set-char #x6EAE ?$(DH-(B) ; J90-D-482D
(ucs-set-char #x6EAE ?$(HDO(B) ; C02-H-444F
(ucs-set-char #x6EAF ?$(Ca=(B) ; KS0-C-613D
(ucs-set-char #x6EAF ?$(Gd_(B) ; C01-G-645F
(ucs-set-char #x6EAF ?$@^j(B) ; J78-@-5E6A
(ucs-set-char #x6EAF ?$AK](B) ; GB0-A-4B5D
(ucs-set-char #x6EAF ?$B^j(B) ; J83-B-5E6A
(ucs-set-char #x6EB0 ?$(HD;(B) ; C02-H-443B
(ucs-set-char #x6EB1 ?$(CrQ(B) ; KS0-C-7251
(ucs-set-char #x6EB1 ?$(DH.(B) ; J90-D-482E
(ucs-set-char #x6EB1 ?$(HD2(B) ; C02-H-4432
(ucs-set-char #x6EB1 ?$AdZ(B) ; GB0-A-645A
(ucs-set-char #x6EB2 ?$(HD?(B) ; C02-H-443F
(ucs-set-char #x6EB2 ?$@^l(B) ; J78-@-5E6C
(ucs-set-char #x6EB2 ?$AdQ(B) ; GB0-A-6451
(ucs-set-char #x6EB2 ?$B^l(B) ; J83-B-5E6C
(ucs-set-char #x6EB3 ?$(DH/(B) ; J90-D-482F
(ucs-set-char #x6EB3 ?$(HDK(B) ; C02-H-444B
(ucs-set-char #x6EB4 ?$(Gds(B) ; C01-G-6473
(ucs-set-char #x6EB4 ?$Ade(B) ; GB0-A-6465
(ucs-set-char #x6EB5 ?$(IB9(B) ; C03-I-4239
(ucs-set-char #x6EB6 ?$(CiA(B) ; KS0-C-6941
(ucs-set-char #x6EB6 ?$(Gda(B) ; C01-G-6461
(ucs-set-char #x6EB6 ?$@MO(B) ; J78-@-4D4F
(ucs-set-char #x6EB6 ?$AH\(B) ; GB0-A-485C
(ucs-set-char #x6EB6 ?$BMO(B) ; J83-B-4D4F
(ucs-set-char #x6EB7 ?$(HD:(B) ; C02-H-443A
(ucs-set-char #x6EB7 ?$@^g(B) ; J78-@-5E67
(ucs-set-char #x6EB7 ?$Adc(B) ; GB0-A-6463
(ucs-set-char #x6EB7 ?$B^g(B) ; J83-B-5E67
(ucs-set-char #x6EB8 ?$(IB-(B) ; C03-I-422D
(ucs-set-char #x6EB9 ?$(HD3(B) ; C02-H-4433
(ucs-set-char #x6EBA ?$(CR|(B) ; KS0-C-527C
(ucs-set-char #x6EBA ?$(Gdj(B) ; C01-G-646A
(ucs-set-char #x6EBA ?$@E.(B) ; J78-@-452E
(ucs-set-char #x6EBA ?$ADg(B) ; GB0-A-4467
(ucs-set-char #x6EBA ?$BE.(B) ; J83-B-452E
(ucs-set-char #x6EBB ?$(DH0(B) ; J90-D-4830
(ucs-set-char #x6EBB ?$(IB1(B) ; C03-I-4231
(ucs-set-char #x6EBB ?$Adb(B) ; GB0-A-6462
(ucs-set-char #x6EBC ?$(Gdi(B) ; C01-G-6469
(ucs-set-char #x6EBD ?$(HD6(B) ; C02-H-4436
(ucs-set-char #x6EBD ?$@^i(B) ; J78-@-5E69
(ucs-set-char #x6EBD ?$Ada(B) ; GB0-A-6461
(ucs-set-char #x6EBD ?$B^i(B) ; J83-B-5E69
(ucs-set-char #x6EBE ?$(HD@(B) ; C02-H-4440
(ucs-set-char #x6EBF ?$(DH1(B) ; J90-D-4831
(ucs-set-char #x6EBF ?$(HDJ(B) ; C02-H-444A
(ucs-set-char #x6EC0 ?$(DH2(B) ; J90-D-4832
(ucs-set-char #x6EC0 ?$(HD-(B) ; C02-H-442D
(ucs-set-char #x6EC1 ?$(DH3(B) ; J90-D-4833
(ucs-set-char #x6EC1 ?$(HD7(B) ; C02-H-4437
(ucs-set-char #x6EC1 ?$A3|(B) ; GB0-A-337C
(ucs-set-char #x6EC2 ?$(C[5(B) ; KS0-C-5B35
(ucs-set-char #x6EC2 ?$(Gdb(B) ; C01-G-6462
(ucs-set-char #x6EC2 ?$@^q(B) ; J78-@-5E71
(ucs-set-char #x6EC2 ?$Adh(B) ; GB0-A-6468
(ucs-set-char #x6EC2 ?$B^q(B) ; J83-B-5E71
(ucs-set-char #x6EC3 ?$(DH4(B) ; J90-D-4834
(ucs-set-char #x6EC3 ?$(HDA(B) ; C02-H-4441
(ucs-set-char #x6EC4 ?$(Csg(B) ; KS0-C-7367
(ucs-set-char #x6EC4 ?$(Gdo(B) ; C01-G-646F
(ucs-set-char #x6EC4 ?$@^k(B) ; J78-@-5E6B
(ucs-set-char #x6EC4 ?$B^k(B) ; J83-B-5E6B
(ucs-set-char #x6EC5 ?$(CX~(B) ; KS0-C-587E
(ucs-set-char #x6EC5 ?$(Gdf(B) ; C01-G-6466
(ucs-set-char #x6EC5 ?$@LG(B) ; J78-@-4C47
(ucs-set-char #x6EC5 ?$BLG(B) ; J83-B-4C47
(ucs-set-char #x6EC6 ?$(HD4(B) ; C02-H-4434
(ucs-set-char #x6EC7 ?$(DH5(B) ; J90-D-4835
(ucs-set-char #x6EC7 ?$(Gde(B) ; C01-G-6465
(ucs-set-char #x6EC7 ?$A5a(B) ; GB0-A-3561
(ucs-set-char #x6EC8 ?$(DH6(B) ; J90-D-4836
(ucs-set-char #x6EC8 ?$(HD+(B) ; C02-H-442B
(ucs-set-char #x6EC9 ?$(C|Q(B) ; KS0-C-7C51
(ucs-set-char #x6EC9 ?$(HD9(B) ; C02-H-4439
(ucs-set-char #x6EC9 ?$@^f(B) ; J78-@-5E66
(ucs-set-char #x6EC9 ?$B^f(B) ; J83-B-5E66
(ucs-set-char #x6ECA ?$(DH7(B) ; J90-D-4837
(ucs-set-char #x6ECA ?$(HDM(B) ; C02-H-444D
(ucs-set-char #x6ECB ?$(Cm2(B) ; KS0-C-6D32
(ucs-set-char #x6ECB ?$(G`E(B) ; C01-G-6045
(ucs-set-char #x6ECB ?$@<"(B) ; J78-@-3C22
(ucs-set-char #x6ECB ?$AWL(B) ; GB0-A-574C
(ucs-set-char #x6ECB ?$B<"(B) ; J83-B-3C22
(ucs-set-char #x6ECC ?$(Ct/(B) ; KS0-C-742F
(ucs-set-char #x6ECC ?$(GiW(B) ; C01-G-6957
(ucs-set-char #x6ECC ?$@^~(B) ; J78-@-5E7E
(ucs-set-char #x6ECC ?$B^~(B) ; J83-B-5E7E
(ucs-set-char #x6ECD ?$(DH8(B) ; J90-D-4838
(ucs-set-char #x6ECD ?$(HD<(B) ; C02-H-443C
(ucs-set-char #x6ECE ?$(C{#(B) ; KS0-C-7B23
(ucs-set-char #x6ECE ?$(DH9(B) ; J90-D-4839
(ucs-set-char #x6ECE ?$(HK4(B) ; C02-H-4B34
(ucs-set-char #x6ECF ?$(DH:(B) ; J90-D-483A
(ucs-set-char #x6ECF ?$(HD>(B) ; C02-H-443E
(ucs-set-char #x6ECF ?$Adf(B) ; GB0-A-6466
(ucs-set-char #x6ED0 ?$(HDL(B) ; C02-H-444C
(ucs-set-char #x6ED1 ?$(C|A(B) ; KS0-C-7C41
(ucs-set-char #x6ED1 ?$(Gdl(B) ; C01-G-646C
(ucs-set-char #x6ED1 ?$@3j(B) ; J78-@-336A
(ucs-set-char #x6ED1 ?$A;,(B) ; GB0-A-3B2C
(ucs-set-char #x6ED1 ?$B3j(B) ; J83-B-336A
(ucs-set-char #x6ED2 ?$(HD5(B) ; C02-H-4435
(ucs-set-char #x6ED3 ?$(Cn+(B) ; KS0-C-6E2B
(ucs-set-char #x6ED3 ?$(Gd`(B) ; C01-G-6460
(ucs-set-char #x6ED3 ?$@^h(B) ; J78-@-5E68
(ucs-set-char #x6ED3 ?$AWR(B) ; GB0-A-5752
(ucs-set-char #x6ED3 ?$B^h(B) ; J83-B-5E68
(ucs-set-char #x6ED4 ?$(CT%(B) ; KS0-C-5425
(ucs-set-char #x6ED4 ?$(Gdp(B) ; C01-G-6470
(ucs-set-char #x6ED4 ?$@^m(B) ; J78-@-5E6D
(ucs-set-char #x6ED4 ?$ALO(B) ; GB0-A-4C4F
(ucs-set-char #x6ED4 ?$B^m(B) ; J83-B-5E6D
(ucs-set-char #x6ED5 ?$(GmZ(B) ; C01-G-6D5A
(ucs-set-char #x6ED5 ?$@^n(B) ; J78-@-5E6E
(ucs-set-char #x6ED5 ?$Akx(B) ; GB0-A-6B78
(ucs-set-char #x6ED5 ?$B^n(B) ; J83-B-5E6E
(ucs-set-char #x6ED6 ?$(HD*(B) ; C02-H-442A
(ucs-set-char #x6ED7 ?$(LTN(B) ; C06-L-544E
(ucs-set-char #x6ED7 ?$Add(B) ; GB0-A-6464
(ucs-set-char #x6ED8 ?$(HDC(B) ; C02-H-4443
(ucs-set-char #x6ED9 ?$(IBD(B) ; C03-I-4244
(ucs-set-char #x6EDA ?$(IB>(B) ; C03-I-423E
(ucs-set-char #x6EDA ?$A9v(B) ; GB0-A-3976
(ucs-set-char #x6EDB ?$(IBG(B) ; C03-I-4247
(ucs-set-char #x6EDC ?$(HDB(B) ; C02-H-4442
(ucs-set-char #x6EDD ?$(IB=(B) ; C03-I-423D
(ucs-set-char #x6EDD ?$@Bl(B) ; J78-@-426C
(ucs-set-char #x6EDD ?$BBl(B) ; J83-B-426C
(ucs-set-char #x6EDE ?$@BZ(B) ; J78-@-425A
(ucs-set-char #x6EDE ?$AVM(B) ; GB0-A-564D
(ucs-set-char #x6EDE ?$BBZ(B) ; J83-B-425A
(ucs-set-char #x6EDF ?$AdY(B) ; GB0-A-6459
(ucs-set-char #x6EE0 ?$Ad\(B) ; GB0-A-645C
(ucs-set-char #x6EE1 ?$ABz(B) ; GB0-A-427A
(ucs-set-char #x6EE2 ?$Ad^(B) ; GB0-A-645E
(ucs-set-char #x6EE3 ?$(IBE(B) ; C03-I-4245
(ucs-set-char #x6EE4 ?$ABK(B) ; GB0-A-424B
(ucs-set-char #x6EE5 ?$A@D(B) ; GB0-A-4044
(ucs-set-char #x6EE6 ?$(IB?(B) ; C03-I-423F
(ucs-set-char #x6EE6 ?$ABP(B) ; GB0-A-4250
(ucs-set-char #x6EE8 ?$(IB;(B) ; C03-I-423B
(ucs-set-char #x6EE8 ?$A1u(B) ; GB0-A-3175
(ucs-set-char #x6EE9 ?$(IBF(B) ; C03-I-4246
(ucs-set-char #x6EE9 ?$AL2(B) ; GB0-A-4C32
(ucs-set-char #x6EEB ?$(DH;(B) ; J90-D-483B
(ucs-set-char #x6EEB ?$(HKP(B) ; C02-H-4B50
(ucs-set-char #x6EEC ?$(GiT(B) ; C01-G-6954
(ucs-set-char #x6EEC ?$@^v(B) ; J78-@-5E76
(ucs-set-char #x6EEC ?$B^v(B) ; J83-B-5E76
(ucs-set-char #x6EED ?$(DH<(B) ; J90-D-483C
(ucs-set-char #x6EED ?$(HKE(B) ; C02-H-4B45
(ucs-set-char #x6EEE ?$(DH=(B) ; J90-D-483D
(ucs-set-char #x6EEE ?$(HKJ(B) ; C02-H-4B4A
(ucs-set-char #x6EEF ?$(Ctr(B) ; KS0-C-7472
(ucs-set-char #x6EEF ?$(GiI(B) ; C01-G-6949
(ucs-set-char #x6EEF ?$@^|(B) ; J78-@-5E7C
(ucs-set-char #x6EEF ?$B^|(B) ; J83-B-5E7C
(ucs-set-char #x6EF0 ?$(IGV(B) ; C03-I-4756
(ucs-set-char #x6EF1 ?$(HK6(B) ; C02-H-4B36
(ucs-set-char #x6EF2 ?$(GiV(B) ; C01-G-6956
(ucs-set-char #x6EF2 ?$@^z(B) ; J78-@-5E7A
(ucs-set-char #x6EF2 ?$B^z(B) ; J83-B-5E7A
(ucs-set-char #x6EF3 ?$(IGW(B) ; C03-I-4757
(ucs-set-char #x6EF4 ?$(CnY(B) ; KS0-C-6E59
(ucs-set-char #x6EF4 ?$(Gi@(B) ; C01-G-6940
(ucs-set-char #x6EF4 ?$@E)(B) ; J78-@-4529
(ucs-set-char #x6EF4 ?$A5N(B) ; GB0-A-354E
(ucs-set-char #x6EF4 ?$BE)(B) ; J83-B-4529
(ucs-set-char #x6EF5 ?$(HK5(B) ; C02-H-4B35
(ucs-set-char #x6EF6 ?$(HKV(B) ; C02-H-4B56
(ucs-set-char #x6EF7 ?$(GiX(B) ; C01-G-6958
(ucs-set-char #x6EF7 ?$@_#(B) ; J78-@-5F23
(ucs-set-char #x6EF7 ?$B_#(B) ; J83-B-5F23
(ucs-set-char #x6EF8 ?$(C{J(B) ; KS0-C-7B4A
(ucs-set-char #x6EF8 ?$(HK9(B) ; C02-H-4B39
(ucs-set-char #x6EF8 ?$@^w(B) ; J78-@-5E77
(ucs-set-char #x6EF8 ?$B^w(B) ; J83-B-5E77
(ucs-set-char #x6EF9 ?$(DH>(B) ; J90-D-483E
(ucs-set-char #x6EF9 ?$(HKI(B) ; C02-H-4B49
(ucs-set-char #x6EF9 ?$Ado(B) ; GB0-A-646F
(ucs-set-char #x6EFA ?$(IGe(B) ; C03-I-4765
(ucs-set-char #x6EFB ?$(DH?(B) ; J90-D-483F
(ucs-set-char #x6EFB ?$(HK;(B) ; C02-H-4B3B
(ucs-set-char #x6EFC ?$(HKY(B) ; C02-H-4B59
(ucs-set-char #x6EFD ?$(DH@(B) ; J90-D-4840
(ucs-set-char #x6EFD ?$(HKU(B) ; C02-H-4B55
(ucs-set-char #x6EFE ?$(CMc(B) ; KS0-C-4D63
(ucs-set-char #x6EFE ?$(Gi>(B) ; C01-G-693E
(ucs-set-char #x6EFE ?$@^x(B) ; J78-@-5E78
(ucs-set-char #x6EFE ?$B^x(B) ; J83-B-5E78
(ucs-set-char #x6EFF ?$(CX;(B) ; KS0-C-583B
(ucs-set-char #x6EFF ?$(GiH(B) ; C01-G-6948
(ucs-set-char #x6EFF ?$@^`(B) ; J78-@-5E60
(ucs-set-char #x6EFF ?$B^`(B) ; J83-B-5E60
(ucs-set-char #x6F00 ?$(HQ[(B) ; C02-H-515B
(ucs-set-char #x6F01 ?$(Ce[(B) ; KS0-C-655B
(ucs-set-char #x6F01 ?$(GiU(B) ; C01-G-6955
(ucs-set-char #x6F01 ?$@5y(B) ; J78-@-3579
(ucs-set-char #x6F01 ?$B5y(B) ; J83-B-3579
(ucs-set-char #x6F02 ?$(Cxw(B) ; KS0-C-7877
(ucs-set-char #x6F02 ?$(GiF(B) ; C01-G-6946
(ucs-set-char #x6F02 ?$@I:(B) ; J78-@-493A
(ucs-set-char #x6F02 ?$AF/(B) ; GB0-A-462F
(ucs-set-char #x6F02 ?$BI:(B) ; J83-B-493A
(ucs-set-char #x6F03 ?$(HK7(B) ; C02-H-4B37
(ucs-set-char #x6F04 ?$(DHA(B) ; J90-D-4841
(ucs-set-char #x6F04 ?$(IGc(B) ; C03-I-4763
(ucs-set-char #x6F05 ?$(HKT(B) ; C02-H-4B54
(ucs-set-char #x6F06 ?$(CvT(B) ; KS0-C-7654
(ucs-set-char #x6F06 ?$(GiJ(B) ; C01-G-694A
(ucs-set-char #x6F06 ?$@<?(B) ; J78-@-3C3F
(ucs-set-char #x6F06 ?$AFa(B) ; GB0-A-4661
(ucs-set-char #x6F06 ?$B<?(B) ; J83-B-3C3F
(ucs-set-char #x6F07 ?$(HKQ(B) ; C02-H-4B51
(ucs-set-char #x6F08 ?$(DHB(B) ; J90-D-4842
(ucs-set-char #x6F08 ?$(HK^(B) ; C02-H-4B5E
(ucs-set-char #x6F09 ?$(HK=(B) ; C02-H-4B3D
(ucs-set-char #x6F09 ?$@9w(B) ; J78-@-3977
(ucs-set-char #x6F09 ?$Adu(B) ; GB0-A-6475
(ucs-set-char #x6F09 ?$B9w(B) ; J83-B-3977
(ucs-set-char #x6F0A ?$(DHC(B) ; J90-D-4843
(ucs-set-char #x6F0A ?$(HKF(B) ; C02-H-4B46
(ucs-set-char #x6F0B ?$(ILx(B) ; C03-I-4C78
(ucs-set-char #x6F0C ?$(DHD(B) ; J90-D-4844
(ucs-set-char #x6F0C ?$(IG[(B) ; C03-I-475B
(ucs-set-char #x6F0D ?$(DHE(B) ; J90-D-4845
(ucs-set-char #x6F0D ?$(HK\(B) ; C02-H-4B5C
(ucs-set-char #x6F0E ?$(HKR(B) ; C02-H-4B52
(ucs-set-char #x6F0F ?$(CW)(B) ; KS0-C-5729
(ucs-set-char #x6F0F ?$(GiE(B) ; C01-G-6945
(ucs-set-char #x6F0F ?$@O3(B) ; J78-@-4F33
(ucs-set-char #x6F0F ?$AB)(B) ; GB0-A-4229
(ucs-set-char #x6F0F ?$BO3(B) ; J83-B-4F33
(ucs-set-char #x6F10 ?$(ILj(B) ; C03-I-4C6A
(ucs-set-char #x6F11 ?$(CKI(B) ; KS0-C-4B49
(ucs-set-char #x6F11 ?$(IGd(B) ; C03-I-4764
(ucs-set-char #x6F11 ?$@^t(B) ; J78-@-5E74
(ucs-set-char #x6F11 ?$B^t(B) ; J83-B-5E74
(ucs-set-char #x6F12 ?$(HKD(B) ; C02-H-4B44
(ucs-set-char #x6F13 ?$(Gi?(B) ; C01-G-693F
(ucs-set-char #x6F13 ?$@_"(B) ; J78-@-5F22
(ucs-set-char #x6F13 ?$A@l(B) ; GB0-A-406C
(ucs-set-char #x6F13 ?$B_"(B) ; J83-B-5F22
(ucs-set-char #x6F14 ?$(CfQ(B) ; KS0-C-6651
(ucs-set-char #x6F14 ?$(Gi=(B) ; C01-G-693D
(ucs-set-char #x6F14 ?$@1i(B) ; J78-@-3169
(ucs-set-char #x6F14 ?$AQ](B) ; GB0-A-515D
(ucs-set-char #x6F14 ?$B1i(B) ; J83-B-3169
(ucs-set-char #x6F15 ?$(CpL(B) ; KS0-C-704C
(ucs-set-char #x6F15 ?$(GiO(B) ; C01-G-694F
(ucs-set-char #x6F15 ?$@Af(B) ; J78-@-4166
(ucs-set-char #x6F15 ?$Adn(B) ; GB0-A-646E
(ucs-set-char #x6F15 ?$BAf(B) ; J83-B-4166
(ucs-set-char #x6F16 ?$(DHF(B) ; J90-D-4846
(ucs-set-char #x6F16 ?$(JDC(B) ; C04-J-4443
(ucs-set-char #x6F17 ?$(IG_(B) ; C03-I-475F
(ucs-set-char #x6F18 ?$(DHG(B) ; J90-D-4847
(ucs-set-char #x6F18 ?$(HKB(B) ; C02-H-4B42
(ucs-set-char #x6F19 ?$(HK?(B) ; C02-H-4B3F
(ucs-set-char #x6F1A ?$(DHH(B) ; J90-D-4848
(ucs-set-char #x6F1A ?$(HK@(B) ; C02-H-4B40
(ucs-set-char #x6F1B ?$(DHI(B) ; J90-D-4849
(ucs-set-char #x6F1B ?$(IGZ(B) ; C03-I-475A
(ucs-set-char #x6F1C ?$(HKX(B) ; C02-H-4B58
(ucs-set-char #x6F1D ?$(IG\(B) ; C03-I-475C
(ucs-set-char #x6F1E ?$(HK](B) ; C02-H-4B5D
(ucs-set-char #x6F1F ?$(HK[(B) ; C02-H-4B5B
(ucs-set-char #x6F20 ?$(CX.(B) ; KS0-C-582E
(ucs-set-char #x6F20 ?$(GiC(B) ; C01-G-6943
(ucs-set-char #x6F20 ?$@Gy(B) ; J78-@-4779
(ucs-set-char #x6F20 ?$AD.(B) ; GB0-A-442E
(ucs-set-char #x6F20 ?$BGy(B) ; J83-B-4779
(ucs-set-char #x6F21 ?$(HK_(B) ; C02-H-4B5F
(ucs-set-char #x6F22 ?$(CyS(B) ; KS0-C-7953
(ucs-set-char #x6F22 ?$(GiG(B) ; C01-G-6947
(ucs-set-char #x6F22 ?$@4A(B) ; J78-@-3441
(ucs-set-char #x6F22 ?$B4A(B) ; J83-B-3441
(ucs-set-char #x6F23 ?$(CU~(B) ; KS0-C-557E
(ucs-set-char #x6F23 ?$(GiN(B) ; C01-G-694E
(ucs-set-char #x6F23 ?$@Nz(B) ; J78-@-4E7A
(ucs-set-char #x6F23 ?$BNz(B) ; J83-B-4E7A
(ucs-set-char #x6F24 ?$(JDD(B) ; C04-J-4444
(ucs-set-char #x6F24 ?$Adm(B) ; GB0-A-646D
(ucs-set-char #x6F25 ?$(HK8(B) ; C02-H-4B38
(ucs-set-char #x6F26 ?$(DHJ(B) ; J90-D-484A
(ucs-set-char #x6F26 ?$(HQC(B) ; C02-H-5143
(ucs-set-char #x6F27 ?$(HKA(B) ; C02-H-4B41
(ucs-set-char #x6F28 ?$(IG^(B) ; C03-I-475E
(ucs-set-char #x6F29 ?$(DHK(B) ; J90-D-484B
(ucs-set-char #x6F29 ?$(GiA(B) ; C01-G-6941
(ucs-set-char #x6F29 ?$Adv(B) ; GB0-A-6476
(ucs-set-char #x6F2A ?$(DHL(B) ; J90-D-484C
(ucs-set-char #x6F2A ?$(GiS(B) ; C01-G-6953
(ucs-set-char #x6F2A ?$Adt(B) ; GB0-A-6474
(ucs-set-char #x6F2B ?$(CX<(B) ; KS0-C-583C
(ucs-set-char #x6F2B ?$(GiP(B) ; C01-G-6950
(ucs-set-char #x6F2B ?$@L!(B) ; J78-@-4C21
(ucs-set-char #x6F2B ?$AB~(B) ; GB0-A-427E
(ucs-set-char #x6F2B ?$BL!(B) ; J83-B-4C21
(ucs-set-char #x6F2C ?$(Cr0(B) ; KS0-C-7230
(ucs-set-char #x6F2C ?$(GiD(B) ; C01-G-6944
(ucs-set-char #x6F2C ?$@DR(B) ; J78-@-4452
(ucs-set-char #x6F2C ?$BDR(B) ; J83-B-4452
(ucs-set-char #x6F2D ?$(DHS(B) ; J90-D-4853
(ucs-set-char #x6F2D ?$(HKK(B) ; C02-H-4B4B
(ucs-set-char #x6F2D ?$Ad](B) ; GB0-A-645D
(ucs-set-char #x6F2E ?$(HK<(B) ; C02-H-4B3C
(ucs-set-char #x6F2F ?$(DHM(B) ; J90-D-484D
(ucs-set-char #x6F2F ?$(GiQ(B) ; C01-G-6951
(ucs-set-char #x6F2F ?$Adp(B) ; GB0-A-6470
(ucs-set-char #x6F30 ?$(DHN(B) ; J90-D-484E
(ucs-set-char #x6F30 ?$(HKM(B) ; C02-H-4B4D
(ucs-set-char #x6F31 ?$(Cb+(B) ; KS0-C-622B
(ucs-set-char #x6F31 ?$(GiK(B) ; C01-G-694B
(ucs-set-char #x6F31 ?$@^{(B) ; J78-@-5E7B
(ucs-set-char #x6F31 ?$AJ~(B) ; GB0-A-4A7E
(ucs-set-char #x6F31 ?$B^{(B) ; J83-B-5E7B
(ucs-set-char #x6F32 ?$(Csh(B) ; KS0-C-7368
(ucs-set-char #x6F32 ?$(GiM(B) ; C01-G-694D
(ucs-set-char #x6F32 ?$@^}(B) ; J78-@-5E7D
(ucs-set-char #x6F32 ?$B^}(B) ; J83-B-5E7D
(ucs-set-char #x6F33 ?$(DHO(B) ; J90-D-484F
(ucs-set-char #x6F33 ?$(Gi<(B) ; C01-G-693C
(ucs-set-char #x6F33 ?$AUD(B) ; GB0-A-5544
(ucs-set-char #x6F34 ?$(IG](B) ; C03-I-475D
(ucs-set-char #x6F35 ?$(HKO(B) ; C02-H-4B4F
(ucs-set-char #x6F36 ?$(DHP(B) ; J90-D-4850
(ucs-set-char #x6F36 ?$(HKG(B) ; C02-H-4B47
(ucs-set-char #x6F36 ?$Adq(B) ; GB0-A-6471
(ucs-set-char #x6F37 ?$(HK:(B) ; C02-H-4B3A
(ucs-set-char #x6F38 ?$(CoB(B) ; KS0-C-6F42
(ucs-set-char #x6F38 ?$(GiL(B) ; C01-G-694C
(ucs-set-char #x6F38 ?$@A2(B) ; J78-@-4132
(ucs-set-char #x6F38 ?$BA2(B) ; J83-B-4132
(ucs-set-char #x6F39 ?$(HKW(B) ; C02-H-4B57
(ucs-set-char #x6F3A ?$(HKZ(B) ; C02-H-4B5A
(ucs-set-char #x6F3B ?$(DHQ(B) ; J90-D-4851
(ucs-set-char #x6F3B ?$(HKC(B) ; C02-H-4B43
(ucs-set-char #x6F3C ?$(DHR(B) ; J90-D-4852
(ucs-set-char #x6F3C ?$(HKN(B) ; C02-H-4B4E
(ucs-set-char #x6F3D ?$(ILt(B) ; C03-I-4C74
(ucs-set-char #x6F3E ?$(GiB(B) ; C01-G-6942
(ucs-set-char #x6F3E ?$@_!(B) ; J78-@-5F21
(ucs-set-char #x6F3E ?$AQz(B) ; GB0-A-517A
(ucs-set-char #x6F3E ?$B_!(B) ; J83-B-5F21
(ucs-set-char #x6F3F ?$(Cml(B) ; KS0-C-6D6C
(ucs-set-char #x6F3F ?$(GmI(B) ; C01-G-6D49
(ucs-set-char #x6F3F ?$@^y(B) ; J78-@-5E79
(ucs-set-char #x6F3F ?$B^y(B) ; J83-B-5E79
(ucs-set-char #x6F40 ?$(HKL(B) ; C02-H-4B4C
(ucs-set-char #x6F41 ?$(Cg8(B) ; KS0-C-6738
(ucs-set-char #x6F41 ?$(HQB(B) ; C02-H-5142
(ucs-set-char #x6F41 ?$@^s(B) ; J78-@-5E73
(ucs-set-char #x6F41 ?$B^s(B) ; J83-B-5E73
(ucs-set-char #x6F42 ?$(IGb(B) ; C03-I-4762
(ucs-set-char #x6F43 ?$(HKS(B) ; C02-H-4B53
(ucs-set-char #x6F44 ?$(IGa(B) ; C03-I-4761
(ucs-set-char #x6F45 ?$(JDR(B) ; C04-J-4452
(ucs-set-char #x6F45 ?$@^u(B) ; J78-@-5E75
(ucs-set-char #x6F45 ?$B4C(B) ; J83-B-3443
(ucs-set-char #x6F46 ?$Adk(B) ; GB0-A-646B
(ucs-set-char #x6F47 ?$Adl(B) ; GB0-A-646C
(ucs-set-char #x6F4A ?$(IGf(B) ; C03-I-4766
(ucs-set-char #x6F4B ?$Adr(B) ; GB0-A-6472
(ucs-set-char #x6F4D ?$AN+(B) ; GB0-A-4E2B
(ucs-set-char #x6F4E ?$(HK>(B) ; C02-H-4B3E
(ucs-set-char #x6F4F ?$(DHT(B) ; J90-D-4854
(ucs-set-char #x6F4F ?$(HQL(B) ; C02-H-514C
(ucs-set-char #x6F50 ?$(HQV(B) ; C02-H-5156
(ucs-set-char #x6F51 ?$(CZ~(B) ; KS0-C-5A7E
(ucs-set-char #x6F51 ?$(DHU(B) ; J90-D-4855
(ucs-set-char #x6F51 ?$(GmL(B) ; C01-G-6D4C
(ucs-set-char #x6F51 ?$@H.(B) ; J78-@-482E
(ucs-set-char #x6F52 ?$(DHV(B) ; J90-D-4856
(ucs-set-char #x6F52 ?$(HQU(B) ; C02-H-5155
(ucs-set-char #x6F53 ?$(DHW(B) ; J90-D-4857
(ucs-set-char #x6F53 ?$(HQa(B) ; C02-H-5161
(ucs-set-char #x6F54 ?$(CL>(B) ; KS0-C-4C3E
(ucs-set-char #x6F54 ?$(GmN(B) ; C01-G-6D4E
(ucs-set-char #x6F54 ?$@7i(B) ; J78-@-3769
(ucs-set-char #x6F54 ?$B7i(B) ; J83-B-3769
(ucs-set-char #x6F55 ?$(HQS(B) ; C02-H-5153
(ucs-set-char #x6F56 ?$(JJX(B) ; C04-J-4A58
(ucs-set-char #x6F57 ?$(Cr|(B) ; KS0-C-727C
(ucs-set-char #x6F57 ?$(DHX(B) ; J90-D-4858
(ucs-set-char #x6F57 ?$(HQW(B) ; C02-H-5157
(ucs-set-char #x6F58 ?$(CZk(B) ; KS0-C-5A6B
(ucs-set-char #x6F58 ?$(GmY(B) ; C01-G-6D59
(ucs-set-char #x6F58 ?$@_/(B) ; J78-@-5F2F
(ucs-set-char #x6F58 ?$AEK(B) ; GB0-A-454B
(ucs-set-char #x6F58 ?$B_/(B) ; J83-B-5F2F
(ucs-set-char #x6F59 ?$(DHY(B) ; J90-D-4859
(ucs-set-char #x6F59 ?$(IL}(B) ; C03-I-4C7D
(ucs-set-char #x6F5A ?$(CbX(B) ; KS0-C-6258
(ucs-set-char #x6F5A ?$(DHZ(B) ; J90-D-485A
(ucs-set-char #x6F5A ?$(HQN(B) ; C02-H-514E
(ucs-set-char #x6F5B ?$(CmV(B) ; KS0-C-6D56
(ucs-set-char #x6F5B ?$(GmQ(B) ; C01-G-6D51
(ucs-set-char #x6F5B ?$@_*(B) ; J78-@-5F2A
(ucs-set-char #x6F5B ?$B_*(B) ; J83-B-5F2A
(ucs-set-char #x6F5C ?$(ILs(B) ; C03-I-4C73
(ucs-set-char #x6F5C ?$@@x(B) ; J78-@-4078
(ucs-set-char #x6F5C ?$AG1(B) ; GB0-A-4731
(ucs-set-char #x6F5C ?$B@x(B) ; J83-B-4078
(ucs-set-char #x6F5D ?$(DH[(B) ; J90-D-485B
(ucs-set-char #x6F5D ?$(HQZ(B) ; C02-H-515A
(ucs-set-char #x6F5E ?$(CVQ(B) ; KS0-C-5651
(ucs-set-char #x6F5E ?$(DH\(B) ; J90-D-485C
(ucs-set-char #x6F5E ?$(HW{(B) ; C02-H-577B
(ucs-set-char #x6F5E ?$AB:(B) ; GB0-A-423A
(ucs-set-char #x6F5F ?$(C`3(B) ; KS0-C-6033
(ucs-set-char #x6F5F ?$(Gm](B) ; C01-G-6D5D
(ucs-set-char #x6F5F ?$@3c(B) ; J78-@-3363
(ucs-set-char #x6F5F ?$B3c(B) ; J83-B-3363
(ucs-set-char #x6F60 ?$(Gm\(B) ; C01-G-6D5C
(ucs-set-char #x6F61 ?$(DH](B) ; J90-D-485D
(ucs-set-char #x6F61 ?$(HQ\(B) ; C02-H-515C
(ucs-set-char #x6F62 ?$(C|R(B) ; KS0-C-7C52
(ucs-set-char #x6F62 ?$(DH^(B) ; J90-D-485E
(ucs-set-char #x6F62 ?$(HQK(B) ; C02-H-514B
(ucs-set-char #x6F62 ?$Adj(B) ; GB0-A-646A
(ucs-set-char #x6F63 ?$(HQf(B) ; C02-H-5166
(ucs-set-char #x6F64 ?$(CkH(B) ; KS0-C-6B48
(ucs-set-char #x6F64 ?$(GmW(B) ; C01-G-6D57
(ucs-set-char #x6F64 ?$@=a(B) ; J78-@-3D61
(ucs-set-char #x6F64 ?$B=a(B) ; J83-B-3D61
(ucs-set-char #x6F65 ?$(ILk(B) ; C03-I-4C6B
(ucs-set-char #x6F66 ?$(GmM(B) ; C01-G-6D4D
(ucs-set-char #x6F66 ?$@_3(B) ; J78-@-5F33
(ucs-set-char #x6F66 ?$AAJ(B) ; GB0-A-414A
(ucs-set-char #x6F66 ?$B_3(B) ; J83-B-5F33
(ucs-set-char #x6F67 ?$(HQ_(B) ; C02-H-515F
(ucs-set-char #x6F68 ?$(DH_(B) ; J90-D-485F
(ucs-set-char #x6F68 ?$(JJi(B) ; C04-J-4A69
(ucs-set-char #x6F69 ?$(HQc(B) ; C02-H-5163
(ucs-set-char #x6F6A ?$(HQh(B) ; C02-H-5168
(ucs-set-char #x6F6B ?$(HQ](B) ; C02-H-515D
(ucs-set-char #x6F6C ?$(DH`(B) ; J90-D-4860
(ucs-set-char #x6F6C ?$(HQQ(B) ; C02-H-5151
(ucs-set-char #x6F6D ?$(CSA(B) ; KS0-C-5341
(ucs-set-char #x6F6D ?$(GmP(B) ; C01-G-6D50
(ucs-set-char #x6F6D ?$@_,(B) ; J78-@-5F2C
(ucs-set-char #x6F6D ?$AL6(B) ; GB0-A-4C36
(ucs-set-char #x6F6D ?$B_,(B) ; J83-B-5F2C
(ucs-set-char #x6F6E ?$(CpM(B) ; KS0-C-704D
(ucs-set-char #x6F6E ?$(GmS(B) ; C01-G-6D53
(ucs-set-char #x6F6E ?$(M$O(B) ; C07-M-244F
(ucs-set-char #x6F6E ?$@D,(B) ; J78-@-442C
(ucs-set-char #x6F6E ?$A31(B) ; GB0-A-3331
(ucs-set-char #x6F6E ?$BD,(B) ; J83-B-442C
(ucs-set-char #x6F6F ?$(Gm[(B) ; C01-G-6D5B
(ucs-set-char #x6F6F ?$@_)(B) ; J78-@-5F29
(ucs-set-char #x6F6F ?$B_)(B) ; J83-B-5F29
(ucs-set-char #x6F70 ?$(COw(B) ; KS0-C-4F77
(ucs-set-char #x6F70 ?$(GmV(B) ; C01-G-6D56
(ucs-set-char #x6F70 ?$@DY(B) ; J78-@-4459
(ucs-set-char #x6F70 ?$BDY(B) ; J83-B-4459
(ucs-set-char #x6F71 ?$(ILu(B) ; C03-I-4C75
(ucs-set-char #x6F72 ?$(HQT(B) ; C02-H-5154
(ucs-set-char #x6F72 ?$Ad{(B) ; GB0-A-647B
(ucs-set-char #x6F73 ?$(HKH(B) ; C02-H-4B48
(ucs-set-char #x6F74 ?$(IL~(B) ; C03-I-4C7E
(ucs-set-char #x6F74 ?$@_L(B) ; J78-@-5F4C
(ucs-set-char #x6F74 ?$Ads(B) ; GB0-A-6473
(ucs-set-char #x6F74 ?$B_L(B) ; J83-B-5F4C
(ucs-set-char #x6F75 ?$(ILl(B) ; C03-I-4C6C
(ucs-set-char #x6F76 ?$(HQP(B) ; C02-H-5150
(ucs-set-char #x6F77 ?$(HQg(B) ; C02-H-5167
(ucs-set-char #x6F78 ?$(GmR(B) ; C01-G-6D52
(ucs-set-char #x6F78 ?$@_&(B) ; J78-@-5F26
(ucs-set-char #x6F78 ?$Adz(B) ; GB0-A-647A
(ucs-set-char #x6F78 ?$B_&(B) ; J83-B-5F26
(ucs-set-char #x6F79 ?$(ILy(B) ; C03-I-4C79
(ucs-set-char #x6F7A ?$(CmR(B) ; KS0-C-6D52
(ucs-set-char #x6F7A ?$(GmU(B) ; C01-G-6D55
(ucs-set-char #x6F7A ?$@_%(B) ; J78-@-5F25
(ucs-set-char #x6F7A ?$Ad}(B) ; GB0-A-647D
(ucs-set-char #x6F7A ?$B_%(B) ; J83-B-5F25
(ucs-set-char #x6F7B ?$(HQi(B) ; C02-H-5169
(ucs-set-char #x6F7C ?$(CTX(B) ; KS0-C-5458
(ucs-set-char #x6F7C ?$(GmJ(B) ; C01-G-6D4A
(ucs-set-char #x6F7C ?$@_.(B) ; J78-@-5F2E
(ucs-set-char #x6F7C ?$Ad|(B) ; GB0-A-647C
(ucs-set-char #x6F7C ?$B_.(B) ; J83-B-5F2E
(ucs-set-char #x6F7D ?$(C\I(B) ; KS0-C-5C49
(ucs-set-char #x6F7D ?$(DHa(B) ; J90-D-4861
(ucs-set-char #x6F7D ?$(HQ^(B) ; C02-H-515E
(ucs-set-char #x6F7E ?$(CWq(B) ; KS0-C-5771
(ucs-set-char #x6F7E ?$(DHb(B) ; J90-D-4862
(ucs-set-char #x6F7E ?$(HQD(B) ; C02-H-5144
(ucs-set-char #x6F7F ?$(HQd(B) ; C02-H-5164
(ucs-set-char #x6F80 ?$(Gt*(B) ; C01-G-742A
(ucs-set-char #x6F80 ?$@_((B) ; J78-@-5F28
(ucs-set-char #x6F80 ?$B_((B) ; J83-B-5F28
(ucs-set-char #x6F81 ?$(C_;(B) ; KS0-C-5F3B
(ucs-set-char #x6F81 ?$(ILz(B) ; C03-I-4C7A
(ucs-set-char #x6F81 ?$@_'(B) ; J78-@-5F27
(ucs-set-char #x6F81 ?$B_'(B) ; J83-B-5F27
(ucs-set-char #x6F82 ?$(HQR(B) ; C02-H-5152
(ucs-set-char #x6F82 ?$@_-(B) ; J78-@-5F2D
(ucs-set-char #x6F82 ?$B_-(B) ; J83-B-5F2D
(ucs-set-char #x6F83 ?$(DHc(B) ; J90-D-4863
(ucs-set-char #x6F83 ?$(JPu(B) ; C04-J-5075
(ucs-set-char #x6F84 ?$(Cs%(B) ; KS0-C-7325
(ucs-set-char #x6F84 ?$(GmK(B) ; C01-G-6D4B
(ucs-set-char #x6F84 ?$@@!(B) ; J78-@-4021
(ucs-set-char #x6F84 ?$A3N(B) ; GB0-A-334E
(ucs-set-char #x6F84 ?$B@!(B) ; J83-B-4021
(ucs-set-char #x6F85 ?$(HQM(B) ; C02-H-514D
(ucs-set-char #x6F86 ?$(GmO(B) ; C01-G-6D4F
(ucs-set-char #x6F86 ?$@_$(B) ; J78-@-5F24
(ucs-set-char #x6F86 ?$B_$(B) ; J83-B-5F24
(ucs-set-char #x6F87 ?$(DHd(B) ; J90-D-4864
(ucs-set-char #x6F87 ?$(HQE(B) ; C02-H-5145
(ucs-set-char #x6F88 ?$(CtM(B) ; KS0-C-744D
(ucs-set-char #x6F88 ?$(DHe(B) ; J90-D-4865
(ucs-set-char #x6F88 ?$(GiR(B) ; C01-G-6952
(ucs-set-char #x6F88 ?$A3:(B) ; GB0-A-333A
(ucs-set-char #x6F89 ?$(HQI(B) ; C02-H-5149
(ucs-set-char #x6F89 ?$Adw(B) ; GB0-A-6477
(ucs-set-char #x6F8A ?$(JJW(B) ; C04-J-4A57
(ucs-set-char #x6F8B ?$(DHf(B) ; J90-D-4866
(ucs-set-char #x6F8B ?$(HQb(B) ; C02-H-5162
(ucs-set-char #x6F8C ?$(DHg(B) ; J90-D-4867
(ucs-set-char #x6F8C ?$(HQJ(B) ; C02-H-514A
(ucs-set-char #x6F8C ?$Ady(B) ; GB0-A-6479
(ucs-set-char #x6F8D ?$(Cq?(B) ; KS0-C-713F
(ucs-set-char #x6F8D ?$(DHh(B) ; J90-D-4868
(ucs-set-char #x6F8D ?$(HQH(B) ; C02-H-5148
(ucs-set-char #x6F8D ?$Adx(B) ; GB0-A-6478
(ucs-set-char #x6F8E ?$(Cx1(B) ; KS0-C-7831
(ucs-set-char #x6F8E ?$(GmT(B) ; C01-G-6D54
(ucs-set-char #x6F8E ?$@_0(B) ; J78-@-5F30
(ucs-set-char #x6F8E ?$AEl(B) ; GB0-A-456C
(ucs-set-char #x6F8E ?$B_0(B) ; J83-B-5F30
(ucs-set-char #x6F8F ?$(IL{(B) ; C03-I-4C7B
(ucs-set-char #x6F90 ?$(Ciz(B) ; KS0-C-697A
(ucs-set-char #x6F90 ?$(DHi(B) ; J90-D-4869
(ucs-set-char #x6F90 ?$(HQ`(B) ; C02-H-5160
(ucs-set-char #x6F91 ?$(ILw(B) ; C03-I-4C77
(ucs-set-char #x6F91 ?$@_1(B) ; J78-@-5F31
(ucs-set-char #x6F91 ?$B_1(B) ; J83-B-5F31
(ucs-set-char #x6F92 ?$(DHj(B) ; J90-D-486A
(ucs-set-char #x6F92 ?$(HQG(B) ; C02-H-5147
(ucs-set-char #x6F93 ?$(DHk(B) ; J90-D-486B
(ucs-set-char #x6F93 ?$(HQY(B) ; C02-H-5159
(ucs-set-char #x6F94 ?$(C{K(B) ; KS0-C-7B4B
(ucs-set-char #x6F94 ?$(DHl(B) ; J90-D-486C
(ucs-set-char #x6F94 ?$(HQX(B) ; C02-H-5158
(ucs-set-char #x6F95 ?$(HQe(B) ; C02-H-5165
(ucs-set-char #x6F96 ?$(DHm(B) ; J90-D-486D
(ucs-set-char #x6F96 ?$(HQO(B) ; C02-H-514F
(ucs-set-char #x6F97 ?$(CJU(B) ; KS0-C-4A55
(ucs-set-char #x6F97 ?$(GmX(B) ; C01-G-6D58
(ucs-set-char #x6F97 ?$@4B(B) ; J78-@-3442
(ucs-set-char #x6F97 ?$B4B(B) ; J83-B-3442
(ucs-set-char #x6F98 ?$(JJd(B) ; C04-J-4A64
(ucs-set-char #x6F9A ?$(DHn(B) ; J90-D-486E
(ucs-set-char #x6F9C ?$A@=(B) ; GB0-A-403D
(ucs-set-char #x6F9E ?$(HW~(B) ; C02-H-577E
(ucs-set-char #x6F9F ?$(DHo(B) ; J90-D-486F
(ucs-set-char #x6F9F ?$(IQV(B) ; C03-I-5156
(ucs-set-char #x6FA0 ?$(DHp(B) ; J90-D-4870
(ucs-set-char #x6FA0 ?$(Gq3(B) ; C01-G-7133
(ucs-set-char #x6FA1 ?$(Gq)(B) ; C01-G-7129
(ucs-set-char #x6FA1 ?$@_6(B) ; J78-@-5F36
(ucs-set-char #x6FA1 ?$ATh(B) ; GB0-A-5468
(ucs-set-char #x6FA1 ?$B_6(B) ; J83-B-5F36
(ucs-set-char #x6FA2 ?$(HX,(B) ; C02-H-582C
(ucs-set-char #x6FA3 ?$(CyT(B) ; KS0-C-7954
(ucs-set-char #x6FA3 ?$(HWv(B) ; C02-H-5776
(ucs-set-char #x6FA3 ?$@_5(B) ; J78-@-5F35
(ucs-set-char #x6FA3 ?$B_5(B) ; J83-B-5F35
(ucs-set-char #x6FA4 ?$(CwJ(B) ; KS0-C-774A
(ucs-set-char #x6FA4 ?$(Gq+(B) ; C01-G-712B
(ucs-set-char #x6FA4 ?$@_7(B) ; J78-@-5F37
(ucs-set-char #x6FA4 ?$B_7(B) ; J83-B-5F37
(ucs-set-char #x6FA5 ?$(DHq(B) ; J90-D-4871
(ucs-set-char #x6FA5 ?$(HX$(B) ; C02-H-5824
(ucs-set-char #x6FA6 ?$(DHr(B) ; J90-D-4872
(ucs-set-char #x6FA6 ?$(Gq2(B) ; C01-G-7132
(ucs-set-char #x6FA7 ?$(CVH(B) ; KS0-C-5648
(ucs-set-char #x6FA7 ?$(DHs(B) ; J90-D-4873
(ucs-set-char #x6FA7 ?$(Gq-(B) ; C01-G-712D
(ucs-set-char #x6FA7 ?$Ae"(B) ; GB0-A-6522
(ucs-set-char #x6FA8 ?$(DHt(B) ; J90-D-4874
(ucs-set-char #x6FA8 ?$(HX"(B) ; C02-H-5822
(ucs-set-char #x6FA9 ?$(H];(B) ; C02-H-5D3B
(ucs-set-char #x6FAA ?$(HX((B) ; C02-H-5828
(ucs-set-char #x6FAA ?$@_:(B) ; J78-@-5F3A
(ucs-set-char #x6FAA ?$B_:(B) ; J83-B-5F3A
(ucs-set-char #x6FAB ?$(HX.(B) ; C02-H-582E
(ucs-set-char #x6FAC ?$(HX'(B) ; C02-H-5827
(ucs-set-char #x6FAD ?$(HWt(B) ; C02-H-5774
(ucs-set-char #x6FAE ?$(C|h(B) ; KS0-C-7C68
(ucs-set-char #x6FAE ?$(DHu(B) ; J90-D-4875
(ucs-set-char #x6FAE ?$(HX%(B) ; C02-H-5825
(ucs-set-char #x6FAF ?$(Cs=(B) ; KS0-C-733D
(ucs-set-char #x6FAF ?$(DHv(B) ; J90-D-4876
(ucs-set-char #x6FAF ?$(HX0(B) ; C02-H-5830
(ucs-set-char #x6FB0 ?$(DHw(B) ; J90-D-4877
(ucs-set-char #x6FB0 ?$(HX2(B) ; C02-H-5832
(ucs-set-char #x6FB1 ?$(Cn~(B) ; KS0-C-6E7E
(ucs-set-char #x6FB1 ?$(Gq((B) ; C01-G-7128
(ucs-set-char #x6FB1 ?$@EC(B) ; J78-@-4543
(ucs-set-char #x6FB1 ?$BEC(B) ; J83-B-4543
(ucs-set-char #x6FB2 ?$(HX1(B) ; C02-H-5831
(ucs-set-char #x6FB3 ?$(Cg~(B) ; KS0-C-677E
(ucs-set-char #x6FB3 ?$(Gq.(B) ; C01-G-712E
(ucs-set-char #x6FB3 ?$@_4(B) ; J78-@-5F34
(ucs-set-char #x6FB3 ?$A0D(B) ; GB0-A-3044
(ucs-set-char #x6FB3 ?$B_4(B) ; J83-B-5F34
(ucs-set-char #x6FB4 ?$(Gq4(B) ; C01-G-7134
(ucs-set-char #x6FB5 ?$(DHx(B) ; J90-D-4878
(ucs-set-char #x6FB5 ?$(IQT(B) ; C03-I-5154
(ucs-set-char #x6FB6 ?$(DHy(B) ; J90-D-4879
(ucs-set-char #x6FB6 ?$(Gq1(B) ; C01-G-7131
(ucs-set-char #x6FB6 ?$Ae$(B) ; GB0-A-6524
(ucs-set-char #x6FB7 ?$(IQX(B) ; C03-I-5158
(ucs-set-char #x6FB8 ?$(HX+(B) ; C02-H-582B
(ucs-set-char #x6FB9 ?$(CSB(B) ; KS0-C-5342
(ucs-set-char #x6FB9 ?$(Gq0(B) ; C01-G-7130
(ucs-set-char #x6FB9 ?$@_8(B) ; J78-@-5F38
(ucs-set-char #x6FB9 ?$Ae#(B) ; GB0-A-6523
(ucs-set-char #x6FB9 ?$B_8(B) ; J83-B-5F38
(ucs-set-char #x6FBA ?$(HX&(B) ; C02-H-5826
(ucs-set-char #x6FBB ?$(IQM(B) ; C03-I-514D
(ucs-set-char #x6FBC ?$(DHz(B) ; J90-D-487A
(ucs-set-char #x6FBC ?$(HWx(B) ; C02-H-5778
(ucs-set-char #x6FBD ?$(HW}(B) ; C02-H-577D
(ucs-set-char #x6FBE ?$(CS6(B) ; KS0-C-5336
(ucs-set-char #x6FBE ?$(IQP(B) ; C03-I-5150
(ucs-set-char #x6FBF ?$(HX*(B) ; C02-H-582A
(ucs-set-char #x6FC0 ?$(CL-(B) ; KS0-C-4C2D
(ucs-set-char #x6FC0 ?$(Gq/(B) ; C01-G-712F
(ucs-set-char #x6FC0 ?$@7c(B) ; J78-@-3763
(ucs-set-char #x6FC0 ?$A<$(B) ; GB0-A-3C24
(ucs-set-char #x6FC0 ?$B7c(B) ; J83-B-3763
(ucs-set-char #x6FC1 ?$(Cvz(B) ; KS0-C-767A
(ucs-set-char #x6FC1 ?$(Gq,(B) ; C01-G-712C
(ucs-set-char #x6FC1 ?$@By(B) ; J78-@-4279
(ucs-set-char #x6FC1 ?$BBy(B) ; J83-B-4279
(ucs-set-char #x6FC2 ?$(CV2(B) ; KS0-C-5632
(ucs-set-char #x6FC2 ?$(Gq'(B) ; C01-G-7127
(ucs-set-char #x6FC2 ?$@_2(B) ; J78-@-5F32
(ucs-set-char #x6FC2 ?$Ae%(B) ; GB0-A-6525
(ucs-set-char #x6FC2 ?$B_2(B) ; J83-B-5F32
(ucs-set-char #x6FC3 ?$(CRX(B) ; KS0-C-5258
(ucs-set-char #x6FC3 ?$(Gq*(B) ; C01-G-712A
(ucs-set-char #x6FC3 ?$@G;(B) ; J78-@-473B
(ucs-set-char #x6FC3 ?$BG;(B) ; J83-B-473B
(ucs-set-char #x6FC4 ?$(HW|(B) ; C02-H-577C
(ucs-set-char #x6FC5 ?$(DH{(B) ; J90-D-487B
(ucs-set-char #x6FC5 ?$(JQ"(B) ; C04-J-5122
(ucs-set-char #x6FC6 ?$(HQF(B) ; C02-H-5146
(ucs-set-char #x6FC6 ?$@_9(B) ; J78-@-5F39
(ucs-set-char #x6FC6 ?$B_9(B) ; J83-B-5F39
(ucs-set-char #x6FC7 ?$(DH|(B) ; J90-D-487C
(ucs-set-char #x6FC7 ?$(HWw(B) ; C02-H-5777
(ucs-set-char #x6FC8 ?$(DH}(B) ; J90-D-487D
(ucs-set-char #x6FC8 ?$(HWz(B) ; C02-H-577A
(ucs-set-char #x6FC9 ?$(HX-(B) ; C02-H-582D
(ucs-set-char #x6FC9 ?$Ae!(B) ; GB0-A-6521
(ucs-set-char #x6FCA ?$(CgX(B) ; KS0-C-6758
(ucs-set-char #x6FCA ?$(DH~(B) ; J90-D-487E
(ucs-set-char #x6FCA ?$(HX!(B) ; C02-H-5821
(ucs-set-char #x6FCB ?$(HWu(B) ; C02-H-5775
(ucs-set-char #x6FCC ?$(H]:(B) ; C02-H-5D3A
(ucs-set-char #x6FCD ?$(HX/(B) ; C02-H-582F
(ucs-set-char #x6FCE ?$(HWy(B) ; C02-H-5779
(ucs-set-char #x6FCF ?$(HX)(B) ; C02-H-5829
(ucs-set-char #x6FD0 ?$(ILq(B) ; C03-I-4C71
(ucs-set-char #x6FD1 ?$Ad~(B) ; GB0-A-647E
(ucs-set-char #x6FD2 ?$A1t(B) ; GB0-A-3174
(ucs-set-char #x6FD3 ?$(IQU(B) ; C03-I-5155
(ucs-set-char #x6FD4 ?$(H]=(B) ; C02-H-5D3D
(ucs-set-char #x6FD4 ?$@_>(B) ; J78-@-5F3E
(ucs-set-char #x6FD4 ?$B_>(B) ; J83-B-5F3E
(ucs-set-char #x6FD5 ?$(Cc%(B) ; KS0-C-6325
(ucs-set-char #x6FD5 ?$(Gt.(B) ; C01-G-742E
(ucs-set-char #x6FD5 ?$@_<(B) ; J78-@-5F3C
(ucs-set-char #x6FD5 ?$B_<(B) ; J83-B-5F3C
(ucs-set-char #x6FD6 ?$(IU0(B) ; C03-I-5530
(ucs-set-char #x6FD7 ?$(IU/(B) ; C03-I-552F
(ucs-set-char #x6FD8 ?$(Gt"(B) ; C01-G-7422
(ucs-set-char #x6FD8 ?$@_?(B) ; J78-@-5F3F
(ucs-set-char #x6FD8 ?$B_?(B) ; J83-B-5F3F
(ucs-set-char #x6FD9 ?$(IU5(B) ; C03-I-5535
(ucs-set-char #x6FDA ?$(Cg9(B) ; KS0-C-6739
(ucs-set-char #x6FDA ?$(DI!(B) ; J90-D-4921
(ucs-set-char #x6FDA ?$(IU6(B) ; C03-I-5536
(ucs-set-char #x6FDB ?$(Gt&(B) ; C01-G-7426
(ucs-set-char #x6FDB ?$@_B(B) ; J78-@-5F42
(ucs-set-char #x6FDB ?$B_B(B) ; J83-B-5F42
(ucs-set-char #x6FDC ?$(H]?(B) ; C02-H-5D3F
(ucs-set-char #x6FDD ?$(H]E(B) ; C02-H-5D45
(ucs-set-char #x6FDE ?$(DI"(B) ; J90-D-4922
(ucs-set-char #x6FDE ?$(H]C(B) ; C02-H-5D43
(ucs-set-char #x6FDE ?$Ae((B) ; GB0-A-6528
(ucs-set-char #x6FDF ?$(Cp-(B) ; KS0-C-702D
(ucs-set-char #x6FDF ?$(Gt$(B) ; C01-G-7424
(ucs-set-char #x6FDF ?$@_;(B) ; J78-@-5F3B
(ucs-set-char #x6FDF ?$B_;(B) ; J83-B-5F3B
(ucs-set-char #x6FE0 ?$(C{L(B) ; KS0-C-7B4C
(ucs-set-char #x6FE0 ?$(Gt%(B) ; C01-G-7425
(ucs-set-char #x6FE0 ?$@9j(B) ; J78-@-396A
(ucs-set-char #x6FE0 ?$Ae)(B) ; GB0-A-6529
(ucs-set-char #x6FE0 ?$B9j(B) ; J83-B-396A
(ucs-set-char #x6FE1 ?$(Ck!(B) ; KS0-C-6B21
(ucs-set-char #x6FE1 ?$(Gt,(B) ; C01-G-742C
(ucs-set-char #x6FE1 ?$@G((B) ; J78-@-4728
(ucs-set-char #x6FE1 ?$Ae&(B) ; GB0-A-6526
(ucs-set-char #x6FE1 ?$BG((B) ; J83-B-4728
(ucs-set-char #x6FE2 ?$(H]F(B) ; C02-H-5D46
(ucs-set-char #x6FE3 ?$(H]>(B) ; C02-H-5D3E
(ucs-set-char #x6FE4 ?$(CT&(B) ; KS0-C-5426
(ucs-set-char #x6FE4 ?$(Gt'(B) ; C01-G-7427
(ucs-set-char #x6FE4 ?$@Es(B) ; J78-@-4573
(ucs-set-char #x6FE4 ?$B^9(B) ; J83-B-5E39
(ucs-set-char #x6FE5 ?$(IU1(B) ; C03-I-5531
(ucs-set-char #x6FE6 ?$(H]B(B) ; C02-H-5D42
(ucs-set-char #x6FE7 ?$(H]A(B) ; C02-H-5D41
(ucs-set-char #x6FE8 ?$(DI#(B) ; J90-D-4923
(ucs-set-char #x6FE8 ?$(H]G(B) ; C02-H-5D47
(ucs-set-char #x6FE9 ?$(C{M(B) ; KS0-C-7B4D
(ucs-set-char #x6FE9 ?$(DI$(B) ; J90-D-4924
(ucs-set-char #x6FE9 ?$(Gt-(B) ; C01-G-742D
(ucs-set-char #x6FEA ?$(IU7(B) ; C03-I-5537
(ucs-set-char #x6FEB ?$(CU=(B) ; KS0-C-553D
(ucs-set-char #x6FEB ?$(Gt((B) ; C01-G-7428
(ucs-set-char #x6FEB ?$@Mt(B) ; J78-@-4D74
(ucs-set-char #x6FEB ?$BMt(B) ; J83-B-4D74
(ucs-set-char #x6FEC ?$(Cq_(B) ; KS0-C-715F
(ucs-set-char #x6FEC ?$(Gt+(B) ; C01-G-742B
(ucs-set-char #x6FEC ?$@_=(B) ; J78-@-5F3D
(ucs-set-char #x6FEC ?$B_=(B) ; J83-B-5F3D
(ucs-set-char #x6FED ?$(H]@(B) ; C02-H-5D40
(ucs-set-char #x6FEE ?$(Gt/(B) ; C01-G-742F
(ucs-set-char #x6FEE ?$@_A(B) ; J78-@-5F41
(ucs-set-char #x6FEE ?$Ae'(B) ; GB0-A-6527
(ucs-set-char #x6FEE ?$B_A(B) ; J83-B-5F41
(ucs-set-char #x6FEF ?$(Cv{(B) ; KS0-C-767B
(ucs-set-char #x6FEF ?$(Gt)(B) ; C01-G-7429
(ucs-set-char #x6FEF ?$@Bu(B) ; J78-@-4275
(ucs-set-char #x6FEF ?$Ae*(B) ; GB0-A-652A
(ucs-set-char #x6FEF ?$BBu(B) ; J83-B-4275
(ucs-set-char #x6FF0 ?$(DI%(B) ; J90-D-4925
(ucs-set-char #x6FF0 ?$(Gt0(B) ; C01-G-7430
(ucs-set-char #x6FF1 ?$(C^4(B) ; KS0-C-5E34
(ucs-set-char #x6FF1 ?$(Gt#(B) ; C01-G-7423
(ucs-set-char #x6FF1 ?$@_@(B) ; J78-@-5F40
(ucs-set-char #x6FF1 ?$B_@(B) ; J83-B-5F40
(ucs-set-char #x6FF2 ?$(H]D(B) ; C02-H-5D44
(ucs-set-char #x6FF3 ?$(IZU(B) ; C03-I-5A55
(ucs-set-char #x6FF3 ?$@_+(B) ; J78-@-5F2B
(ucs-set-char #x6FF3 ?$B_+(B) ; J83-B-5F2B
(ucs-set-char #x6FF4 ?$(H]<(B) ; C02-H-5D3C
(ucs-set-char #x6FF5 ?$(DI&(B) ; J90-D-4926
(ucs-set-char #x6FF5 ?$(IQY(B) ; C03-I-5159
(ucs-set-char #x6FF6 ?$(IU9(B) ; C03-I-5539
(ucs-set-char #x6FF6 ?$@oi(B) ; J78-@-6F69
(ucs-set-char #x6FF6 ?$Boi(B) ; J83-B-6F69
(ucs-set-char #x6FF7 ?$(Hb%(B) ; C02-H-6225
(ucs-set-char #x6FF9 ?$(DI'(B) ; J90-D-4927
(ucs-set-char #x6FFA ?$(Gv](B) ; C01-G-765D
(ucs-set-char #x6FFA ?$@_E(B) ; J78-@-5F45
(ucs-set-char #x6FFA ?$B_E(B) ; J83-B-5F45
(ucs-set-char #x6FFB ?$(Hb"(B) ; C02-H-6222
(ucs-set-char #x6FFC ?$(DI((B) ; J90-D-4928
(ucs-set-char #x6FFC ?$(Hb$(B) ; C02-H-6224
(ucs-set-char #x6FFD ?$(DI)(B) ; J90-D-4929
(ucs-set-char #x6FFD ?$(IX((B) ; C03-I-5828
(ucs-set-char #x6FFE ?$(CUk(B) ; KS0-C-556B
(ucs-set-char #x6FFE ?$(Gv[(B) ; C01-G-765B
(ucs-set-char #x6FFE ?$@_I(B) ; J78-@-5F49
(ucs-set-char #x6FFE ?$B_I(B) ; J83-B-5F49
(ucs-set-char #x6FFF ?$(Ha~(B) ; C02-H-617E
(ucs-set-char #x7000 ?$(DI*(B) ; J90-D-492A
(ucs-set-char #x7000 ?$(Hb!(B) ; C02-H-6221
(ucs-set-char #x7001 ?$(CeH(B) ; KS0-C-6548
(ucs-set-char #x7001 ?$(Haz(B) ; C02-H-617A
(ucs-set-char #x7001 ?$@_G(B) ; J78-@-5F47
(ucs-set-char #x7001 ?$B_G(B) ; J83-B-5F47
(ucs-set-char #x7002 ?$(IX*(B) ; C03-I-582A
(ucs-set-char #x7003 ?$(IX'(B) ; C03-I-5827
(ucs-set-char #x7004 ?$(HX#(B) ; C02-H-5823
(ucs-set-char #x7005 ?$(C{$(B) ; KS0-C-7B24
(ucs-set-char #x7005 ?$(DI+(B) ; J90-D-492B
(ucs-set-char #x7005 ?$(Ha{(B) ; C02-H-617B
(ucs-set-char #x7006 ?$(CT9(B) ; KS0-C-5439
(ucs-set-char #x7006 ?$(DI,(B) ; J90-D-492C
(ucs-set-char #x7006 ?$(Gv\(B) ; C01-G-765C
(ucs-set-char #x7006 ?$@FB(B) ; J78-@-4642
(ucs-set-char #x7007 ?$(DI-(B) ; J90-D-492D
(ucs-set-char #x7007 ?$(Haw(B) ; C02-H-6177
(ucs-set-char #x7008 ?$(IX&(B) ; C03-I-5826
(ucs-set-char #x7009 ?$(C^a(B) ; KS0-C-5E61
(ucs-set-char #x7009 ?$(GvY(B) ; C01-G-7659
(ucs-set-char #x7009 ?$@_C(B) ; J78-@-5F43
(ucs-set-char #x7009 ?$B_C(B) ; J83-B-5F43
(ucs-set-char #x700A ?$(Hb&(B) ; C02-H-6226
(ucs-set-char #x700B ?$(Cd#(B) ; KS0-C-6423
(ucs-set-char #x700B ?$(GvZ(B) ; C01-G-765A
(ucs-set-char #x700B ?$@_D(B) ; J78-@-5F44
(ucs-set-char #x700B ?$B_D(B) ; J83-B-5F44
(ucs-set-char #x700C ?$(Hax(B) ; C02-H-6178
(ucs-set-char #x700D ?$(DI.(B) ; J90-D-492E
(ucs-set-char #x700D ?$(Hay(B) ; C02-H-6179
(ucs-set-char #x700E ?$(Ha}(B) ; C02-H-617D
(ucs-set-char #x700F ?$(CW7(B) ; KS0-C-5737
(ucs-set-char #x700F ?$(Gv_(B) ; C01-G-765F
(ucs-set-char #x700F ?$@_H(B) ; J78-@-5F48
(ucs-set-char #x700F ?$B_H(B) ; J83-B-5F48
(ucs-set-char #x7010 ?$(IX)(B) ; C03-I-5829
(ucs-set-char #x7011 ?$(Cxn(B) ; KS0-C-786E
(ucs-set-char #x7011 ?$(Gv^(B) ; C01-G-765E
(ucs-set-char #x7011 ?$@_F(B) ; J78-@-5F46
(ucs-set-char #x7011 ?$AFY(B) ; GB0-A-4659
(ucs-set-char #x7011 ?$B_F(B) ; J83-B-5F46
(ucs-set-char #x7012 ?$(J[^(B) ; C04-J-5B5E
(ucs-set-char #x7013 ?$(IX+(B) ; C03-I-582B
(ucs-set-char #x7014 ?$(Ha|(B) ; C02-H-617C
(ucs-set-char #x7015 ?$(C^5(B) ; KS0-C-5E35
(ucs-set-char #x7015 ?$(GxE(B) ; C01-G-7845
(ucs-set-char #x7015 ?$@IN(B) ; J78-@-494E
(ucs-set-char #x7015 ?$BIN(B) ; J83-B-494E
(ucs-set-char #x7016 ?$(Hej(B) ; C02-H-656A
(ucs-set-char #x7017 ?$(DI/(B) ; J90-D-492F
(ucs-set-char #x7017 ?$(Hep(B) ; C02-H-6570
(ucs-set-char #x7018 ?$(CVR(B) ; KS0-C-5652
(ucs-set-char #x7018 ?$(GxF(B) ; C01-G-7846
(ucs-set-char #x7018 ?$@_N(B) ; J78-@-5F4E
(ucs-set-char #x7018 ?$B_N(B) ; J83-B-5F4E
(ucs-set-char #x7019 ?$(Heg(B) ; C02-H-6567
(ucs-set-char #x701A ?$(CyU(B) ; KS0-C-7955
(ucs-set-char #x701A ?$(GxC(B) ; C01-G-7843
(ucs-set-char #x701A ?$@_K(B) ; J78-@-5F4B
(ucs-set-char #x701A ?$Ae+(B) ; GB0-A-652B
(ucs-set-char #x701A ?$B_K(B) ; J83-B-5F4B
(ucs-set-char #x701B ?$(Cg:(B) ; KS0-C-673A
(ucs-set-char #x701B ?$(Gx@(B) ; C01-G-7840
(ucs-set-char #x701B ?$@_J(B) ; J78-@-5F4A
(ucs-set-char #x701B ?$Ae-(B) ; GB0-A-652D
(ucs-set-char #x701B ?$B_J(B) ; J83-B-5F4A
(ucs-set-char #x701C ?$(CkU(B) ; KS0-C-6B55
(ucs-set-char #x701C ?$(Her(B) ; C02-H-6572
(ucs-set-char #x701D ?$(CUw(B) ; KS0-C-5577
(ucs-set-char #x701D ?$(GxD(B) ; C01-G-7844
(ucs-set-char #x701D ?$@_M(B) ; J78-@-5F4D
(ucs-set-char #x701D ?$B_M(B) ; J83-B-5F4D
(ucs-set-char #x701E ?$(Cog(B) ; KS0-C-6F67
(ucs-set-char #x701E ?$(IZR(B) ; C03-I-5A52
(ucs-set-char #x701E ?$(JV](B) ; C04-J-565D
(ucs-set-char #x701E ?$@FT(B) ; J78-@-4654
(ucs-set-char #x701E ?$BFT(B) ; J83-B-4654
(ucs-set-char #x701F ?$(Ca>(B) ; KS0-C-613E
(ucs-set-char #x701F ?$(GxA(B) ; C01-G-7841
(ucs-set-char #x701F ?$@_O(B) ; J78-@-5F4F
(ucs-set-char #x701F ?$B_O(B) ; J83-B-5F4F
(ucs-set-char #x7020 ?$(DI0(B) ; J90-D-4930
(ucs-set-char #x7020 ?$(Hei(B) ; C02-H-6569
(ucs-set-char #x7021 ?$(Hel(B) ; C02-H-656C
(ucs-set-char #x7022 ?$(Hem(B) ; C02-H-656D
(ucs-set-char #x7023 ?$(Cz.(B) ; KS0-C-7A2E
(ucs-set-char #x7023 ?$(DI1(B) ; J90-D-4931
(ucs-set-char #x7023 ?$(Hen(B) ; C02-H-656E
(ucs-set-char #x7023 ?$Ae,(B) ; GB0-A-652C
(ucs-set-char #x7024 ?$(Heq(B) ; C02-H-6571
(ucs-set-char #x7025 ?$(IZT(B) ; C03-I-5A54
(ucs-set-char #x7026 ?$(Hb#(B) ; C02-H-6223
(ucs-set-char #x7026 ?$@Cu(B) ; J78-@-4375
(ucs-set-char #x7026 ?$BCu(B) ; J83-B-4375
(ucs-set-char #x7027 ?$(CVi(B) ; KS0-C-5669
(ucs-set-char #x7027 ?$(Heh(B) ; C02-H-6568
(ucs-set-char #x7027 ?$@Bm(B) ; J78-@-426D
(ucs-set-char #x7027 ?$BBm(B) ; J83-B-426D
(ucs-set-char #x7028 ?$(CVn(B) ; KS0-C-566E
(ucs-set-char #x7028 ?$(GxB(B) ; C01-G-7842
(ucs-set-char #x7029 ?$(Heo(B) ; C02-H-656F
(ucs-set-char #x702A ?$(Hi4(B) ; C02-H-6934
(ucs-set-char #x702B ?$(Hek(B) ; C02-H-656B
(ucs-set-char #x702C ?$(IZS(B) ; C03-I-5A53
(ucs-set-char #x702C ?$@@%(B) ; J78-@-4025
(ucs-set-char #x702C ?$B@%(B) ; J83-B-4025
(ucs-set-char #x702F ?$(Cg;(B) ; KS0-C-673B
(ucs-set-char #x702F ?$(DI2(B) ; J90-D-4932
(ucs-set-char #x702F ?$(Hi+(B) ; C02-H-692B
(ucs-set-char #x7030 ?$(Gyu(B) ; C01-G-7975
(ucs-set-char #x7030 ?$@_P(B) ; J78-@-5F50
(ucs-set-char #x7030 ?$B_P(B) ; J83-B-5F50
(ucs-set-char #x7031 ?$(Hi.(B) ; C02-H-692E
(ucs-set-char #x7032 ?$(Gyv(B) ; C01-G-7976
(ucs-set-char #x7032 ?$@_R(B) ; J78-@-5F52
(ucs-set-char #x7032 ?$B_R(B) ; J83-B-5F52
(ucs-set-char #x7033 ?$(Hi7(B) ; C02-H-6937
(ucs-set-char #x7034 ?$(DI3(B) ; J90-D-4933
(ucs-set-char #x7034 ?$(Hi-(B) ; C02-H-692D
(ucs-set-char #x7035 ?$(Hi*(B) ; C02-H-692A
(ucs-set-char #x7035 ?$Ae/(B) ; GB0-A-652F
(ucs-set-char #x7036 ?$(I\Q(B) ; C03-I-5C51
(ucs-set-char #x7037 ?$(ClK(B) ; KS0-C-6C4B
(ucs-set-char #x7037 ?$(DI4(B) ; J90-D-4934
(ucs-set-char #x7037 ?$(Hi,(B) ; C02-H-692C
(ucs-set-char #x7038 ?$(Hi0(B) ; C02-H-6930
(ucs-set-char #x7039 ?$(DI5(B) ; J90-D-4935
(ucs-set-char #x7039 ?$(Hi3(B) ; C02-H-6933
(ucs-set-char #x7039 ?$Ae.(B) ; GB0-A-652E
(ucs-set-char #x703A ?$(Hi2(B) ; C02-H-6932
(ucs-set-char #x703B ?$(Hi6(B) ; C02-H-6936
(ucs-set-char #x703C ?$(DI6(B) ; J90-D-4936
(ucs-set-char #x703C ?$(Hi)(B) ; C02-H-6929
(ucs-set-char #x703D ?$(I\O(B) ; C03-I-5C4F
(ucs-set-char #x703E ?$(CU3(B) ; KS0-C-5533
(ucs-set-char #x703E ?$(Gyt(B) ; C01-G-7974
(ucs-set-char #x703E ?$@_Q(B) ; J78-@-5F51
(ucs-set-char #x703E ?$B_Q(B) ; J83-B-5F51
(ucs-set-char #x703F ?$(Hi1(B) ; C02-H-6931
(ucs-set-char #x7040 ?$(Hi5(B) ; C02-H-6935
(ucs-set-char #x7041 ?$(Hi8(B) ; C02-H-6938
(ucs-set-char #x7042 ?$(Hi/(B) ; C02-H-692F
(ucs-set-char #x7043 ?$(DI7(B) ; J90-D-4937
(ucs-set-char #x7043 ?$(Hka(B) ; C02-H-6B61
(ucs-set-char #x7044 ?$(DI8(B) ; J90-D-4938
(ucs-set-char #x7044 ?$(Hkb(B) ; C02-H-6B62
(ucs-set-char #x7045 ?$(Hkf(B) ; C02-H-6B66
(ucs-set-char #x7046 ?$(Hkg(B) ; C02-H-6B67
(ucs-set-char #x7047 ?$(I^<(B) ; C03-I-5E3C
(ucs-set-char #x7048 ?$(DI9(B) ; J90-D-4939
(ucs-set-char #x7048 ?$(Hkd(B) ; C02-H-6B64
(ucs-set-char #x7049 ?$(DI:(B) ; J90-D-493A
(ucs-set-char #x7049 ?$(Hke(B) ; C02-H-6B65
(ucs-set-char #x704A ?$(DI;(B) ; J90-D-493B
(ucs-set-char #x704A ?$(Hkc(B) ; C02-H-6B63
(ucs-set-char #x704B ?$(DI<(B) ; J90-D-493C
(ucs-set-char #x704B ?$(I^:(B) ; C03-I-5E3A
(ucs-set-char #x704C ?$(CN4(B) ; KS0-C-4E34
(ucs-set-char #x704C ?$(Gzt(B) ; C01-G-7A74
(ucs-set-char #x704C ?$@4C(B) ; J78-@-3443
(ucs-set-char #x704C ?$A9`(B) ; GB0-A-3960
(ucs-set-char #x704C ?$B^u(B) ; J83-B-5E75
(ucs-set-char #x704D ?$(I^;(B) ; C03-I-5E3B
(ucs-set-char #x704E ?$(DIA(B) ; J90-D-4941
(ucs-set-char #x704F ?$Ae0(B) ; GB0-A-6530
(ucs-set-char #x7050 ?$(C{%(B) ; KS0-C-7B25
(ucs-set-char #x7051 ?$(Can(B) ; KS0-C-616E
(ucs-set-char #x7051 ?$(G{d(B) ; C01-G-7B64
(ucs-set-char #x7051 ?$@_S(B) ; J78-@-5F53
(ucs-set-char #x7051 ?$B_S(B) ; J83-B-5F53
(ucs-set-char #x7052 ?$(HmY(B) ; C02-H-6D59
(ucs-set-char #x7053 ?$(I`6(B) ; C03-I-6036
(ucs-set-char #x7054 ?$(DI=(B) ; J90-D-493D
(ucs-set-char #x7054 ?$(I_R(B) ; C03-I-5F52
(ucs-set-char #x7055 ?$(DI>(B) ; J90-D-493E
(ucs-set-char #x7055 ?$(HmV(B) ; C02-H-6D56
(ucs-set-char #x7056 ?$(HmW(B) ; C02-H-6D57
(ucs-set-char #x7057 ?$(HmX(B) ; C02-H-6D58
(ucs-set-char #x7058 ?$(Cw((B) ; KS0-C-7728
(ucs-set-char #x7058 ?$(G{e(B) ; C01-G-7B65
(ucs-set-char #x7058 ?$@Fg(B) ; J78-@-4667
(ucs-set-char #x7058 ?$BFg(B) ; J83-B-4667
(ucs-set-char #x7059 ?$(I`7(B) ; C03-I-6037
(ucs-set-char #x705A ?$(Ho4(B) ; C02-H-6F34
(ucs-set-char #x705B ?$(Ho3(B) ; C02-H-6F33
(ucs-set-char #x705D ?$(C{N(B) ; KS0-C-7B4E
(ucs-set-char #x705D ?$(DI?(B) ; J90-D-493F
(ucs-set-char #x705D ?$(Hp=(B) ; C02-H-703D
(ucs-set-char #x705E ?$(DI@(B) ; J90-D-4940
(ucs-set-char #x705E ?$(G|`(B) ; C01-G-7C60
(ucs-set-char #x705E ?$Ae1(B) ; GB0-A-6531
(ucs-set-char #x705F ?$(Hp;(B) ; C02-H-703B
(ucs-set-char #x7060 ?$(Hp>(B) ; C02-H-703E
(ucs-set-char #x7061 ?$(Hp<(B) ; C02-H-703C
(ucs-set-char #x7062 ?$(Hq%(B) ; C02-H-7125
(ucs-set-char #x7063 ?$(CX=(B) ; KS0-C-583D
(ucs-set-char #x7063 ?$(G}$(B) ; C01-G-7D24
(ucs-set-char #x7063 ?$@_T(B) ; J78-@-5F54
(ucs-set-char #x7063 ?$B_T(B) ; J83-B-5F54
(ucs-set-char #x7064 ?$(DIB(B) ; J90-D-4942
(ucs-set-char #x7064 ?$(G}2(B) ; C01-G-7D32
(ucs-set-char #x7065 ?$(DIC(B) ; J90-D-4943
(ucs-set-char #x7065 ?$(Hqq(B) ; C02-H-7171
(ucs-set-char #x7066 ?$(Hq[(B) ; C02-H-715B
(ucs-set-char #x7067 ?$(Iay(B) ; C03-I-6179
(ucs-set-char #x7068 ?$(Hqp(B) ; C02-H-7170
(ucs-set-char #x7069 ?$(Hr>(B) ; C02-H-723E
(ucs-set-char #x706A ?$(Hr?(B) ; C02-H-723F
(u