;;; ucs-ll-sym.el --- UCS table of Letterlike Symbols

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Letterlike Symbols

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; DEGREE CELSIUS
(ucs-set-char #x2103 ?$(G"j(B) ; C01-G-226A
(ucs-set-char #x2103 ?$(C!I(B) ; KS0-C-2149
(ucs-set-char #x2103 ?$(A!f(B) ; GB0-A-2166
(ucs-set-char #x2103 ?$(@!n(B) ; J78-@-216E
(ucs-set-char #x2103 ?$(B!n(B) ; J83-B-216E

;; CARE OF
(ucs-set-char #x2105 ?$(G""(B) ; C01-G-2222

;; DEGREE FAHRENHEIT
(ucs-set-char #x2109 ?$(C"5(B) ; KS0-C-2235
(ucs-set-char #x2109 ?$(G"k(B) ; C01-G-226B

;; SCRIPT SMALL L
(ucs-set-char #x2113 ?$(C'$(B) ; KS0-C-2724

;; NUMERO SIGN
(ucs-set-char #x2116 ?-L) ; ISO-8859-5-F0-A
(ucs-set-char #x2116 ?$(C"`(B) ; KS0-C-2260
(ucs-set-char #x2116 ?$(D"q(B) ; J90-D-2271
(ucs-set-char #x2116 ?$(A!m(B) ; GB0-A-216D

;; TELEPHONE SIGN
(ucs-set-char #x2121 ?$(C"e(B) ; KS0-C-2265

;; TRADE MARK SIGN
(ucs-set-char #x2122 ?$(C"b(B) ; KS0-C-2262
(ucs-set-char #x2122 ?$(D"o(B) ; J90-D-226F

;; OHM SIGN
(ucs-set-char #x2126 ?$(C'Y(B) ; KS0-C-2759

;; ANGSTROM SIGN
(ucs-set-char #x212B ?$(C!J(B) ; KS0-C-214A
(ucs-set-char #x212B ?$(B"r(B) ; J83-B-2272

;;; ucs-ll-sym.el ends here
