/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* IO control */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/commands/RCS/io.c,v $ */

static char rcsid[] = "$Revision: 2.1 $ $Date: 91/07/03 10:17:25 $ $State: Beta $ $Author: carroll $";

/* ------------------------------------------------------------------------- */
#include "header.h"

#if POLL
#include <stropts.h>
#include <poll.h>
#endif

#include "struct.h"

/* ------------------------------------------------------------------------ */
#if POLL
static struct pollfd *p_fd;
#endif

extern struct Client *client;
extern int accept_fd;
extern int n_clients;

extern int errno;

extern FILE *trace;
/* ------------------------------------------------------------------------ */
void
InitializeIO()
{
#if POLL
  p_fd = (struct pollfd *) malloc(n_clients * sizeof(struct pollfd));
#endif
}
/* ------------------------------------------------------------------------ */
#if POLL
#define IS_WRITEABLE(i)	(p_fd[client[i].poll_index].revents&(POLLOUT|POLLHUP))
#define IS_READABLE(i)	(p_fd[client[i].poll_index].revents&(POLLIN|POLLPRI))

#define ADD_CLIENT(i)	{\
			  client[i].poll_index = nfds; \
			  p_fd[nfds].fd = client[i].fd; \
			  p_fd[nfds].events = POLLIN | POLLPRI |\
			    (!MBisChunkEmpty(&(client[i].output)) ? \
			     POLLOUT : 0); \
			  nfds += 1; \
			}

#define ACCEPT_WAITING	((POLLIN|POLLPRI) & p_fd[accept_poll_index].revents)

#else					/* not POLL, use SELECT */

#define IS_WRITEABLE(i)	FD_ISSET(client[i].fd, &write_fds)
#define IS_READABLE(i)	FD_ISSET(client[i].fd, &read_fds)

#define ADD_CLIENT(i)	{\
			  FD_SET(client[i].fd, &read_fds); \
			  if (!MBisChunkEmpty(&(client[i].output))) \
			    FD_SET(client[i].fd, &write_fds); \
		        }

#define ACCEPT_WAITING	FD_ISSET(accept_fd, &read_fds)
#endif
/* ------------------------------------------------------------------------ */
void
DoIO()
{
  int i,n = 0;
  int next_client = -1;

#if POLL
  unsigned long nfds = 0;
  unsigned long accept_poll_index = -1;
#else /* not POLL, use SELECT */
  fd_set read_fds;
  fd_set write_fds;
#endif

#if !POLL
  FD_ZERO(&read_fds);
  FD_ZERO(&write_fds);
#endif

  /* the accept fd is a special case */

#if POLL
  p_fd[nfds].fd = accept_fd;
  p_fd[nfds].events = POLLIN|POLLPRI;
  accept_poll_index = nfds;
  nfds += 1;
#else
  FD_SET(accept_fd, &read_fds);
#endif

  for ( i = 0 ; i < n_clients ; ++i )
    {
      if (CLIENT_DEAD != client[i].state) ADD_CLIENT(i)
      else if (-1 == next_client) next_client = i;
    }

#if POLL
  if (nfds) n = poll(p_fd, nfds, -1);
#else
  n = select(n_clients, &read_fds, &write_fds, NULL, NULL);
#endif

  if (n > 0)
    {
      for ( i = 0 ; i < n_clients ; ++i )
	{
	  if (CLIENT_DEAD != client[i].state)
	    {
	      if (IS_READABLE(i))
		{
		  extern int errno;
		  int count = MBChunkRead(client[i].fd,&client[i].input);

		  if (0 == count || (count < 0 && errno != EAGAIN))
		    {
		      DumpClient(client + i);
		      continue;		/* blow off other checks */
		    }
		  else
		    HandleClient(client+i);
		}
	      if (IS_WRITEABLE(i))
		{
		  extern int errno;
		  int count = MBChunkWrite(client[i].fd,&client[i].output);

		  /* Sigh. If the chunk is empty, then the write will return
		   * 0, so we can't use count == 0 as a check
		   */
		  if (count < 0 && errno != EAGAIN)
		    DumpClient(client + 1);
		}
	    }
	}

      /* done all the normal IO, now if there is POLLIN on the accept_fd,
       * then someone's trying to connect. Make them a client.
       */
      if (ACCEPT_WAITING)
	{
	  struct sockaddr_in saddr;
	  int saddr_size = sizeof(struct sockaddr_in);
	  int fd;

	  saddr.sin_family = AF_INET;
	  fd = accept(accept_fd, (struct sockaddr *)&saddr, &saddr_size);

	  if (fd >= 0)			/* we connected! yow! */
	    {
	      if (MBLogLevel > 1) printf("Accepted socket %d\n",fd);
	      if (NULL != trace)
		{
		  fprintf(trace, "Accepted socket %d\n",fd);
		  fflush(trace);
		}
	      if (next_client >= 0)	/* somewhere to put it */
		{
		  if (MBLogLevel > 1) printf("Added client %d\n",next_client);
		  if (NULL != trace)
		    {
		      fprintf(trace, "Added client %d\n",next_client);
		      fflush(trace);
		    }
		  client[next_client].state = CLIENT_ALIVE;
		  client[next_client].fd = fd;
		  memcpy((char *)&client[next_client].saddr,
			 (char *)&saddr, sizeof(struct sockaddr_in));
		}
	      else
		{
		  close(fd);		/* no room, piss off! */
		}
	    }
	  else				/* some sort of error */
	    {
	      perror("Accept:");
	      switch (errno)
		{
		case EAGAIN :
		  break;
		default:
#ifdef SO_ERROR
		  setsockopt(accept_fd,SOL_SOCKET,SO_ERROR,0,0);
#endif
		  break;
		}
	    }
	}
    }
}
/* ------------------------------------------------------------------------ */
