(defvar *mbus-stream* nil)
(defvar *mbus-unix-process* nil)
(defvar *mbus-input* nil)
(defvar *mbus-timeout* 5.0)
(defvar *mbus-interface-program* "/delta/stable/bin/connect")
(defvar *mbus-port* (or (sys:getenv "MBUS_PORT") 2390))
(defvar *mbus-host*
  (or
    (sys:getenv "MBUS_HOST") 
    (multiple-value-bind (a b c)
      (run-shell-command "hostname" :wait nil :input :stream :output :stream)
      (format nil "~S" (read a))
    )
    "spruce"
))

(defun run ()
  (multiple-value-bind (io error proc)
    (excl:run-shell-command 
      (format nil "exec ~S ~S ~S"
	*mbus-interface-program* *mbus-host* *mbus-port*
      )
      :input :stream :output :stream :wait nil
    )
    (let
      ((*mbus-stream* io))
      (format *mbus-stream* "(accept \".*\" \"server.cb\")")
      (loop
	(setq sexp (read *mbus-stream*))
	(format t "~S~%" sexp)
))))
