/* Synched up with: Not in FSF. */

/* The following three symbols give information on
 the size of various data types.  */

#define DEC_ALPHA		/* Digital Alpha AXP */

#define SHORTBITS 16		/* Number of bits in a short */

#define INTBITS 32L		/* Number of bits in an int */

#define LONGBITS 64L		/* Number of bits in a long */

/* Define NO_ARG_ARRAY if you cannot take the address of the first of a
 * group of arguments and treat it as an array of the arguments.  */

#define NO_ARG_ARRAY

/* Define WORD_MACHINE if addresses and such have
 * to be corrected before they can be used as byte counts.  */

/* #define WORD_MACHINE */

/* Define how to take a char and sign-extend into an int.
   On machines where char is signed, this is a no-op.  */

#define SIGN_EXTEND_CHAR(c) ((signed char)(c))

/* Now define a symbol for the cpu type, if your compiler
   does not define it automatically:
   Ones defined so far include vax, m68000, ns16000, pyramid,
   orion, tahoe, APOLLO and many others */

/* Use type int rather than a union, to represent Lisp_Object */
/* This is desirable for most machines.  */

/* #define NO_UNION_TYPE */

/* Define EXPLICIT_SIGN_EXTEND if XINT must explicitly sign-extend
   the 24-bit bit field into an int.  In other words, if bit fields
   are always unsigned.

   If you use NO_UNION_TYPE, this flag does not matter.  */

#define EXPLICIT_SIGN_EXTEND

/* Data type of load average, as read out of kmem.  */
/* Load average requires special crocks.  Version 19 has them.
   For now, don't define this.  */

#define LOAD_AVE_TYPE long 

/* Convert that into an integer that is 100 for a load average of 1.0  */

#define LOAD_AVE_CVT(x) (int) (((double) (x)) * 100.0 / 256.0) 

/* Define CANNOT_DUMP on machines where unexec does not work.
   Then the function dump-emacs will not be defined
   and temacs will do (load "loadup") automatically unless told otherwise.  */

/* #define CANNOT_DUMP */

/* Define VIRT_ADDR_VARIES if the virtual addresses of
   pure and impure space as loaded can vary, and even their
   relative order cannot be relied on.

   Otherwise Emacs assumes that text space precedes data space,
   numerically.  */

/* #define VIRT_ADDR_VARIES */

/* Define C_ALLOCA if this machine does not support a true alloca
   and the one written in C should be used instead.
   Define HAVE_ALLOCA to say that the system provides a properly
   working alloca function and it should be used.
   Define neither one if an assembler-language alloca
   in the file alloca.s should be used.  */

#define HAVE_ALLOCA
/* #define SYSTEM_MALLOC */
/* Define NO_REMAP if memory segmentation makes it not work well
   to change the boundary between the text section and data section
   when Emacs is dumped.  If you define this, the preloaded Lisp
   code will not be sharable; but that's better than failing completely.  */

/* #define NO_REMAP */

/* This machine requires completely different unexec code
   which lives in a separate file.  Specify the file name.  */

#define UNEXEC unexalpha.o

/* Supposedly the following will overcome a kernel bug.  */

#define TEXT_START    0x120000000     /* user text starts at  9*2^29 */
#define DATA_START    0x140000000     /* user data starts at 10*2^29 */
#define START_FILES pre-crt0.o /usr/lib/cmplrs/cc/crt0.o
#define LINKER ld
#define LIBS_DEBUG -ldnet_stub
/*
 * Cast pointers to this value on Alpha machines.
 */
#define PNTR_COMPARISON_TYPE unsigned long

#ifndef PURESIZE
#define PURESIZE 	765000
#endif

/* The Dec CC compiler (but apparently not GCC, which uses different
   macros due to its own compiler bug) breaks spectacularly
   when MACROIZE_ERROR_CHECKING is turned on. */
#define BROKEN_MACROIZE_ERROR_CHECKING
