/* Define scrollbar instance.
   Copyright (C) 1994, 1995 Board of Trustees, University of Illinois

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Synched up with: Not in FSF. */

#ifndef _XEMACS_SCROLLBAR_H_
#define _XEMACS_SCROLLBAR_H_

#ifdef HAVE_X_WINDOWS

#include "device.h"
#include "xintrinsic.h"
#include "lwlib.h"

struct scrollbar_instance
{
  /* Used by the frame caches. */
  struct scrollbar_instance *next;

  /* Pointer back to the mirror structure attached to. */
  struct window_mirror *mirror;

  /* Pointer to the scrollbar widget this structure describes. */
  Widget scrollbar_widget;

  /* Unique scrollbar identifier and name. */
  unsigned int scrollbar_id;
  char *scrollbar_name;

  /* This flag indicates if the scrollbar is currently in use. */
  char scrollbar_is_active;

  /* This flag indicates if a data parameter has changed. */
  char scrollbar_instance_changed;

  /* Is set if we have already set the backing_store attribute correctly */
  char backing_store_initialized;

  /* Positioning and sizing information for scrollbar and slider. */
  scrollbar_values data;

#if defined (LWLIB_SCROLLBARS_MOTIF) || defined (LWLIB_SCROLLBARS_LUCID)
  /* Recorded starting position for Motif-like scrollbar drags. */
  int vdrag_orig_value;
  Bufpos vdrag_orig_window_start;
#endif
};

extern void init_frame_scrollbars (struct frame *f);
extern void init_device_scrollbars (struct device *d);
extern void init_global_scrollbars (struct device *d);
extern void x_release_window_scrollbars (struct window_mirror *mir);
extern void free_frame_scrollbars (struct frame *f);
extern void x_update_window_scrollbars (struct window *w,
					struct window_mirror *mirror,
					int active, int horiz_only);
extern void x_update_frame_scrollbars (struct frame *f);
extern void x_set_scrollbar_pointer (struct frame *f, Lisp_Object cursor);
extern int x_window_is_scrollbar (struct frame *f, Window win);

extern Lisp_Object Vscrollbar_width, Vscrollbar_height;

#endif /* HAVE_X_WINDOWS */
#endif /* _XEMACS_SCROLLBAR_H_ */
