/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.JDEException;
import jde.debugger.spec.AccessWatchpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.LineBreakpointSpec;
import jde.debugger.spec.MethodBreakpointSpec;
import jde.debugger.spec.ModificationWatchpointSpec;
import jde.debugger.spec.PatternReferenceTypeSpec;
import jde.debugger.spec.SourceNameReferenceTypeSpec;
import jde.debugger.spec.WatchpointSpec;

public class EventRequestSpecList {
    private Map eventRequestSpecs = Collections.synchronizedMap(new HashMap());
    private final Application app;

    public EventRequestSpecList(Application app) {
        this.app = app;
    }

    public void resolve(ReferenceType refType) {
        Map map = this.eventRequestSpecs;
        synchronized (map) {
            Iterator iter = this.eventRequestSpecs.values().iterator();
            while (iter.hasNext()) {
                ((EventRequestSpec)iter.next()).attemptResolve(refType);
            }
        }
    }

    public void install(EventRequestSpec ers) {
        Map map = this.eventRequestSpecs;
        synchronized (map) {
            this.eventRequestSpecs.put(ers.getID(), ers);
        }
        if (this.app.getVM() != null) {
            ers.attemptImmediateResolve(this.app.getVM());
        }
    }

    public void delete(EventRequestSpec ers) {
        EventRequest request = ers.getEventRequest();
        Map map = this.eventRequestSpecs;
        synchronized (map) {
            this.eventRequestSpecs.remove(ers.getID());
        }
        if (request != null) {
            request.virtualMachine().eventRequestManager().deleteEventRequest(request);
        }
    }

    public void removeSpec(Long specID) throws JDEException {
        Map map = this.eventRequestSpecs;
        synchronized (map) {
            if (!this.eventRequestSpecs.containsKey(specID)) {
                throw new JDEException("'" + specID + "' doesn't exist");
            }
            this.delete((EventRequestSpec)this.eventRequestSpecs.get(specID));
        }
    }

    public EventRequestSpec createExceptionIntercept(String classPattern, boolean notifyCaught, boolean notifyUncaught) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        ExceptionSpec ers = new ExceptionSpec(this.app, refSpec, notifyCaught, notifyUncaught);
        return ers;
    }

    public WatchpointSpec createAccessWatchpoint(String classPattern, String m) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        AccessWatchpointSpec ers = new AccessWatchpointSpec(this.app, refSpec, m);
        return ers;
    }

    public WatchpointSpec createModificationWatchpoint(String classPattern, String m) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        ModificationWatchpointSpec ers = new ModificationWatchpointSpec(this.app, refSpec, m);
        return ers;
    }

    public EventRequestSpec createClassLineBreakpoint(String classPattern, int line) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        LineBreakpointSpec ers = new LineBreakpointSpec(this.app, refSpec, line);
        return ers;
    }

    public EventRequestSpec createSourceLineBreakpoint(String sourceName, int line) {
        SourceNameReferenceTypeSpec refSpec = new SourceNameReferenceTypeSpec(sourceName, line);
        LineBreakpointSpec ers = new LineBreakpointSpec(this.app, refSpec, line);
        return ers;
    }

    public EventRequestSpec createMethodBreakpoint(String classPattern, String methodId, List methodArgs) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        MethodBreakpointSpec e = new MethodBreakpointSpec(this.app, refSpec, methodId, methodArgs);
        return e;
    }
}

